/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

public final class StringBuffer {
    int count;
    char[] value;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public StringBuffer append(char c) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public native StringBuffer append(int var1);

    public StringBuffer append(long l) {
        return this.append(Long.toString(l));
    }

    public StringBuffer append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBuffer append(double d) {
        return this.append(Double.toString(d));
    }

    public StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.length();
        this.ensureCapacity_unsynchronized(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    private void ensureCapacity_unsynchronized(int n) {
        if (n > this.value.length) {
            n = Math.max(n, this.value.length * 2 + 2);
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.count = 0;
        this.value = new char[n];
    }

    public StringBuffer(String string) {
        if (string == null) {
            string = "null";
        }
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public native String toString();
}

