/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Connection
extends JarURLConnection {
    private static SimpleDateFormat dateFormat;
    private JarFile jar_file;
    private JarEntry jar_entry;
    private URL jar_url;

    protected Connection(URL uRL) throws MalformedURLException {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.jar_url = this.getJarFileURL();
        this.jar_file = JarFileCache.get(this.jar_url, this.useCaches);
        String string = this.getEntryName();
        if (string != null && !string.equals("")) {
            this.jar_entry = (JarEntry)this.jar_file.getEntry(string);
            if (this.jar_entry == null) {
                throw new FileNotFoundException("No entry for " + string + " exists.");
            }
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        return this.jar_file.getInputStream(this.jar_entry);
    }

    public synchronized JarFile getJarFile() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarFile if doInput is false");
        }
        return this.jar_file;
    }

    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (string.equals("content-type")) {
                return URLConnection.guessContentTypeFromName(this.getJarEntry().getName());
            }
            if (string.equals("content-length")) {
                return Long.toString(this.getJarEntry().getSize());
            }
            if (string.equals("last-modified")) {
                Class clazz = Connection.class$("gnu.java.net.protocol.jar.Connection");
                synchronized (clazz) {
                    try {
                        if (dateFormat == null) {
                            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", new Locale("En", "Us", "Unix"));
                        }
                        String string2 = dateFormat.format(new Date(this.getJarEntry().getTime()));
                        Object var4_5 = null;
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string3 = null;
        return string3;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getContentLength() {
        if (!this.connected) {
            return -1;
        }
        return (int)this.jar_entry.getSize();
    }

    public long getLastModified() {
        if (!this.connected) {
            return -1;
        }
        try {
            return this.getJarEntry().getTime();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static class JarFileCache {
        private static Hashtable cache = new Hashtable();
        private static final int READBUFSIZE = 4096;

        public static synchronized JarFile get(URL uRL, boolean bl) throws IOException {
            JarFile jarFile;
            if (bl && (jarFile = (JarFile)cache.get(uRL)) != null) {
                return jarFile;
            }
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile();
                string = gnu.java.net.protocol.file.Connection.unquote(string);
                File file = new File(string);
                jarFile = new JarFile(file, true, 1);
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
                byte[] byArray = new byte[4096];
                File file = File.createTempFile("cache", "jar");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                jarFile = new JarFile(file, true, 5);
            }
            if (bl) {
                cache.put(uRL, jarFile);
            }
            return jarFile;
        }
    }
}

