/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.Util;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class RecordOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG_RECORD_LAYER = true;
    private static final Logger logger = SystemLogger.SYSTEM;
    private final ContentType type;
    private final SecurityParameters params;
    private final boolean emitEmpty;
    private static final byte[] ZERO = new byte[0];

    RecordOutputStream(OutputStream outputStream, ContentType contentType, SecurityParameters securityParameters) {
        super(outputStream);
        this.type = contentType;
        this.params = securityParameters;
        String string = Util.getSecurityProperty("jessie.emit.empty.records");
        if (string == null) {
            string = "false";
        }
        this.emitEmpty = Boolean.valueOf(string) != false && contentType == ContentType.APPLICATION_DATA;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void write(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 < 0) {
            throw new ArrayIndexOutOfBoundsException("size=" + var1_1.length + " off=" + var2_2 + " len=" + var3_3);
        }
        if (var3_3 < 0) {
            throw new ArrayIndexOutOfBoundsException("size=" + var1_1.length + " off=" + var2_2 + " len=" + var3_3);
        }
        if (var2_2 + var3_3 > var1_1.length) {
            throw new ArrayIndexOutOfBoundsException("size=" + var1_1.length + " off=" + var2_2 + " len=" + var3_3);
        }
        var4_4 = 0;
        var5_5 = 0;
        while (true) lbl-1000:
        // 2 sources

        {
            if (this.emitEmpty) {
                var6_6 /* !! */  = this.params.encrypt(RecordOutputStream.ZERO, 0, 0, this.type);
                RecordOutputStream.logger.log((Level)Component.SSL_RECORD_LAYER, ">> WRITING RECORD <<{4}struct {{4}  type = {0};{4}  version = {1};{4}  length = {2};{4}{3}{4}} TLSCiphertext;", new Object[]{this.type, this.params.getVersion(), new Integer(var6_6 /* !! */ .length), Util.hexDump(var6_6 /* !! */ , "  "), SystemProperties.getProperty("line.separator")});
                this.out.write(this.type.getValue());
                this.params.getVersion().write(this.out);
                this.out.write(var6_6 /* !! */ .length >>> 8 & 255);
                this.out.write(var6_6 /* !! */ .length & 255);
                this.out.write(var6_6 /* !! */ );
                this.out.flush();
            }
            var5_5 = Math.min(var3_3 - var4_4, this.params.getFragmentLength());
            RecordOutputStream.logger.log((Level)Component.SSL_RECORD_LAYER, "writing chunk size={0}", new Integer(var5_5));
            var6_6 /* !! */  = (byte[])this.out;
            // MONITORENTER : var6_6 /* !! */ 
            var7_7 = this.params.encrypt(var1_1, var2_2 + var4_4, var5_5, this.type);
            RecordOutputStream.logger.log((Level)Component.SSL_RECORD_LAYER, ">> WRITING RECORD <<{4}struct {{4}  type = {0};{4}  version = {1};{4}  length = {2};{4}{3}{4}} TLSCiphertext;", new Object[]{this.type, this.params.getVersion(), new Integer(var7_7.length), Util.hexDump(var7_7, "  "), SystemProperties.getProperty("line.separator")});
            this.out.write(this.type.getValue());
            this.params.getVersion().write(this.out);
            this.out.write(var7_7.length >>> 8 & 255);
            this.out.write(var7_7.length & 255);
            this.out.write(var7_7);
            this.out.flush();
            break;
        }
        catch (Throwable var8_8) {
            var7_7 = null;
            // MONITOREXIT : var6_6 /* !! */ 
            throw var8_8;
        }
        {
            var7_7 = null;
            // MONITOREXIT : var6_6 /* !! */ 
            if ((var4_4 += var5_5) >= var3_3) return;
            ** while (true)
        }
    }
}

