/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Package {
    private final String name;
    private final String implTitle;
    private final String implVendor;
    private final String implVersion;
    private final String specTitle;
    private final String specVendor;
    private final String specVersion;
    private final URL sealed;

    Package(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        if (string == null) {
            throw new IllegalArgumentException("null Package name");
        }
        this.name = string;
        this.implTitle = string5;
        this.implVendor = string6;
        this.implVersion = string7;
        this.specTitle = string2;
        this.specVendor = string3;
        this.specVersion = string4;
        this.sealed = uRL;
    }

    public String getName() {
        return this.name;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public boolean isSealed() {
        return this.sealed != null;
    }

    public boolean isSealed(URL uRL) {
        return uRL.equals(this.sealed);
    }

    public boolean isCompatibleWith(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.specVersion, ".");
        try {
            while (stringTokenizer.hasMoreElements()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n2 < n) {
                    return false;
                }
                if (n2 <= n) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return true;
    }

    public static Package getPackage(String string) {
        ClassLoader classLoader = VMSecurityManager.currentClassLoader(Package.class$("java.lang.Package"));
        if (classLoader != null) {
            return classLoader.getPackage(string);
        }
        return VMClassLoader.getPackage(string);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Package[] getPackages() {
        Class clazz = VMSecurityManager.getClassContext(Package.class$("java.lang.Package"))[1];
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader.getPackages();
        }
        return VMClassLoader.getPackages();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name + (this.specTitle == null ? "" : ", " + this.specTitle) + (this.specVersion == null ? "" : ", version " + this.specVersion);
    }
}

