;;;                 COPYRIGHT NOTICE
;;;  
;;;  Copyright (C) 2007-2010 Mario Rodriguez Riotorto
;;;  
;;;  This program is free software; you can redistribute
;;;  it and/or modify it under the terms of the
;;;  GNU General Public License as published by
;;;  the Free Software Foundation; either version 2 
;;;  of the License, or (at your option) any later version. 
;;;  
;;;  This program is distributed in the hope that it
;;;  will be useful, but WITHOUT ANY WARRANTY;
;;;  without even the implied warranty of MERCHANTABILITY
;;;  or FITNESS FOR A PARTICULAR PURPOSE. See the 
;;;  GNU General Public License for more details at
;;;  http://www.gnu.org/copyleft/gpl.html

;;; This package contains boundaries coordinates and the definition
;;; of graphic object geomap for two and three dimensions.

;;; Loading this package, Maxima-level global variable $boundaries_array
;;; will contain coordinates (longitude, latitude) of boundary segments:
;;; coast lines and country borders. These coordinates were taken from 
;;; the public domain 'World Boundary Databank'
;;; http://www-cger.nies.go.jp/grid-e/gridtxt/grid19.html

;;; For questions, suggestions, bugs and the like, feel free
;;; to contact me at
;;; mario @@@ edu DOT xunta DOT es

(setf $boundaries_array
'#(#(-121.3553 64.812187 -121.1681 64.813873 -121.0692 64.904137 
  -120.6781 64.981087 -120.3947 65.097473 -120.0433 65.195534 
  -119.8853 65.336639 -119.4747 65.32164 -119.5442 65.431374 
  -120.0614 65.601929 -120.0933 65.631088 -119.9228 65.631088 
  -119.6556 65.693588 -119.5981 65.719971 -119.7645 65.741638 
  -119.6795 65.794418 -118.9147 65.789703 -118.6572 65.698303 
  -118.7103 65.668587 -118.6397 65.638313 -118.5628 65.649696 
  -118.557 65.673859 -118.4092 65.689423 -118.0981 65.671371 
  -117.9933 65.733582 -117.8664 65.73497 -117.9969 65.764687 
  -117.9878 65.791092 -117.8942 65.817467 -118.0461 65.799973 
  -118.13 65.800262 -118.2214 65.844971 -118.2647 65.85997 
  -118.1669 65.943039 -118.1103 65.975807 -118.1298 66.018593 
  -117.9367 66.058296 -117.7756 66.026093 -117.7708 66.056091 
  -117.835 66.0522 -118.0258 66.096649 -117.9814 66.133034 
  -117.8994 66.158043 -117.7447 66.148033 -117.692 66.190262 
  -117.8242 66.170532 -117.8017 66.213028 -117.7278 66.214142 
  -117.6378 66.25386 -117.6245 66.285812 -117.7147 66.295807 
  -117.7117 66.311371 -117.625 66.365807 -117.6239 66.387192 
  -117.4639 66.44136 -117.4736 66.464706 -117.8522 66.409416 
  -117.9044 66.415253 -117.8581 66.446373 -117.8584 66.485809 
  -117.5886 66.62886 -117.725 66.608032 -117.7222 66.64386 
  -118.0086 66.601089 -118.2183 66.506638 -118.275 66.431091 
  -118.1275 66.487762 -118.147 66.454697 -118.4483 66.356918 
  -118.9817 66.316093 -119.3342 66.337479 -119.522 66.323303 
  -119.537 66.303307 -119.797 66.311371 -119.8056 66.330811 
  -119.73 66.343307 -119.6275 66.332748 -119.605 66.351089 
  -119.6689 66.366928 -119.8956 66.323303 -119.9958 66.351357 
  -119.9722 66.377197 -120.4517 66.378311 -120.5067 66.414703 
  -120.4425 66.463867 -120.3392 66.453873 -120.3278 66.469971 
  -120.3745 66.488037 -120.05 66.628593 -120.1203 66.664978 
  -119.5822 66.729713 -119.5525 66.749153 -119.565 66.766922 
  -119.4631 66.752762 -119.4356 66.781082 -118.9706 66.86525 
  -118.9689 66.887756 -119.2267 66.909149 -119.2058 66.942749 
  -119.2856 66.929977 -119.5247 66.952477 -119.4358 66.994141 
  -119.752 66.97525 -119.8131 67.000809 -119.7364 67.020538 
  -119.7658 67.042213 -119.9486 67.030807 -120.2417 66.964706 
  -120.5097 66.948303 -120.6631 66.898857 -121.1664 66.865807 
  -121.2242 66.832748 -121.4839 66.759407 -121.4456 66.726639 
  -121.7503 66.69165 -121.9995 66.612473 -122.3195 66.58609 
  -122.3686 66.612762 -122.4833 66.573029 -122.5014 66.607758 
  -122.5317 66.580261 -122.5108 66.561653 -122.9245 66.539703 
  -122.9617 66.477203 -123.0883 66.46109 -123.1586 66.476929 
  -123.1539 66.516373 -123.1542 66.529984 -123.2567 66.468582 
  -123.4636 66.440536 -124.0078 66.309418 -124.3075 66.362762 
  -124.4697 66.246643 -124.6314 66.274696 -124.8781 66.25914 
  -124.9644 66.308594 -125.0786 66.256638 -125.1219 66.170807 
  -125.1142 66.124687 -124.8603 65.926933 -124.7844 65.910812 
  -124.8045 65.997482 -124.74 66.046654 -124.6694 66.050537 
  -124.7111 66.026367 -124.6475 65.99025 -124.575 65.992203 
  -124.5517 66.014137 -124.5914 66.059982 -124.5578 66.099426 
  -124.6211 66.125259 -124.6069 66.141373 -124.545 66.156372 
  -124.1667 66.170807 -124.0853 66.116364 -123.9914 66.103027 
  -123.3525 66.170807 -123.2489 66.164703 -123.2331 66.130814 
  -123.1183 66.039978 -123.085 66.055817 -123.1056 66.113037 
  -123.0442 66.099983 -122.9389 66.183868 -123.0406 66.22998 
  -123.0206 66.25415 -122.4892 66.259697 -121.8575 66.241638 
  -121.6895 66.189697 -121.562 66.096916 -121.2872 66.101357 
  -121.2211 66.064697 -121.3058 65.973587 -121.4683 65.930252 
  -121.8417 65.924698 -122.1047 65.987473 -122.5992 65.963028 
  -122.5417 65.939972 -122.5053 65.899139 -122.1792 65.844971 
  -122.1369 65.799698 -122.1533 65.771362 -122.8978 65.480797 
  -122.7583 65.415253 -122.7503 65.36998 -122.7586 65.320824 
  -122.885 65.257202 -123.452 65.20137 -123.492 65.163307 
  -123.1272 65.074142 -122.3858 65.016083 -122.0395 64.938873 
  -121.5839 65.079971 -121.6658 65.127762 -121.6069 65.144417 
  -121.59 65.17804 -121.6192 65.259979 -121.5292 65.311371 
  -121.5133 65.348862 -121.5458 65.352203 -121.5278 65.389977 
  -120.9684 65.561081 -120.6886 65.61026 -120.3836 65.575256 
  -120.4047 65.533043 -120.3342 65.502472 -120.3631 65.415527 
  -120.5581 65.266647 -120.9831 65.114967 -121.0147 65.075256 
  -120.9539 65.041367 -121.0945 64.978592 -121.2806 64.977478 
  -121.3922 64.990807 -121.5047 64.936081 -121.507 64.883034 
  -121.3553 64.812187) #(-109.2328 62.85165 -109.0803 62.82832 
  -109.0109 62.80727 -109.0583 62.76305 -109.0984 62.737259 
  -108.9311 62.79332 -108.9003 62.772209 -109.007 62.733601 
  -108.9936 62.69249 -109.3145 62.575821 -109.3014 62.610538 
  -109.1639 62.653881 -109.2803 62.646381 -109.2128 62.69693 
  -109.7872 62.801929 -110.6786 62.823879 -110.7422 62.794159 
  -110.5992 62.7911 -110.5939 62.766651 -110.9461 62.742771 
  -111.2817 62.658871 -111.4636 62.594711 -111.665 62.386379 
  -111.65 62.36721 -111.562 62.454708 -111.3664 62.553051 
  -111.0192 62.64082 -110.54 62.655819 -110.4883 62.66832 
  -110.525 62.691101 -110.452 62.723598 -110.4325 62.7561 
  -110.4931 62.764431 -110.4597 62.797211 -110.0845 62.778881 
  -109.782 62.734711 -109.7714 62.72221 -110.3797 62.74527 
  -110.4061 62.716381 -110.4208 62.681931 -109.7169 62.669991 
  -109.6986 62.648041 -109.9306 62.57555 -110.2547 62.567211 
  -110.7853 62.533039 -110.7353 62.52055 -110.3181 62.537491 
  -110.6733 62.451382 -110.6558 62.42971 -110.2703 62.516102 
  -110.1816 62.50779 -109.8997 62.561649 -109.8503 62.555271 
  -109.9906 62.50499 -110.3353 62.448318 -110.4772 62.379711 
  -110.2514 62.39193 -110.2317 62.37693 -110.6272 62.34499 
  -110.6492 62.36665 -110.6689 62.40276 -111.0214 62.394428 
  -111.1361 62.336102 -111.1039 62.324429 -111.2731 62.290821 
  -111.3256 62.250542 -111.2486 62.27055 -111.237 62.259159 
  -111.5908 62.12888 -111.5806 62.11499 -111.5344 62.125542 
  -111.5075 62.118038 -111.6736 62.064991 -111.7192 62.030819 
  -111.465 62.073879 -111.49 62.037209 -112.0425 61.763882 
  -112.1567 61.670269 -112.71 61.436649 -112.8722 61.44138 
  -112.87 61.410549 -112.9433 61.383598 -113.0158 61.398041 
  -112.9825 61.435822 -113.1083 61.486931 -113.3333 61.451931 
  -113.6778 61.30249 -113.715 61.254711 -113.6714 61.194439 
  -113.7433 61.160549 -113.6314 61.148319 -113.6181 61.11277 
  -113.6536 61.061939 -113.742 61.008598 -113.9875 60.966648 
  -114.2208 61.012489 -114.6395 60.903599 -114.7934 60.925819 
  -115.0212 60.888149) #(-115.0212 60.888149 -115.9556 60.84082 
  -116.4228 60.949429 -116.4886 61.01054 -116.5525 61.028599 
  -117.0764 61.045551 -117.4514 61.19054 -117.4975 61.2561 
  -117.1258 61.153881 -116.7028 61.219711 -116.8011 61.306099 
  -116.757 61.324429 -116.1931 61.267769 -115.9611 61.172489 
  -115.935 61.190819 -116.0186 61.234989 -115.8795 61.263882 
  -115.8489 61.303051 -116.0253 61.374149 -115.9911 61.401932 
  -115.8572 61.398319 -115.7072 61.447491 -115.7556 61.466648 
  -115.7197 61.566662 -115.6583 61.605549 -115.6669 61.646931 
  -115.5483 61.676929 -115.575 61.72443 -115.5181 61.75555 
  -115.3064 61.776371 -115.2028 61.750542 -115.2006 61.731659 
  -114.9222 61.75526 -114.6189 61.860821 -114.6847 61.883881 
  -114.6383 61.918049 -114.6433 61.935551 -114.7558 61.926929 
  -114.7595 61.974152 -115.045 62.09499 -115.0269 62.144711 
  -115.1311 62.212769 -115.3158 62.21888 -115.3303 62.242771 
  -115.2319 62.315269 -115.3053 62.336929 -115.3089 62.419159 
  -115.2678 62.458321 -115.3003 62.489159 -115.6992 62.478321 
  -115.7722 62.533039 -115.695 62.553322 -116.0075 62.68388 
  -116.0514 62.71804 -115.9942 62.778599 -115.9314 62.77776 
  -115.6875 62.684429 -115.7731 62.655819 -115.5161 62.638321 
  -114.7395 62.396931 -114.5836 62.351101 -114.312 62.416931 
  -114.242 62.398041 -114.2469 62.353039 -113.892 62.20776 
  -113.8042 62.134991 -113.7878 62.11721 -113.5342 62.04916 
  -113.5983 62.029991 -113.5194 62.004162 -113.4128 62.03471 
  -113.3186 61.989712 -113.1895 62.0061 -112.4175 62.073601 
  -112.1656 62.194988 -111.7133 62.38026 -111.4414 62.694988 
  -111.0733 62.848049 -110.6733 62.924992 -110.105 62.934429 
  -109.2328 62.85165) #(-140.9991 69.644562 -141.0009 66.832474 
  -141.0014 63.56638 -140.9969 60.30759) 
#(-140.9969 60.30759 -140.52139 60.22221 -140.45081 60.309711 
  -139.9794 60.187759 -139.6767 60.340542 -139.0681 60.352211 
  -139.0658 60.316929 -139.1889 60.088871 -139.04781 59.997478 
  -138.69031 59.906929 -138.65469 59.814701 -138.5844 59.756649 
  -137.9994 59.45158 -137.9888 59.446079 -137.59081 59.23859 
  -137.47971 58.998039 -137.5072 58.937759 -137.4958 58.91193 
  -137.42751 58.911369 -136.8089 59.16526 -136.58389 59.163311 
  -136.4808 59.261929 -136.46359 59.4697 -136.3 59.471088 
  -136.2339 59.525822 -136.2392 59.561371 -136.3439 59.602772 
  -135.4736 59.801929 -135.0145 59.56749 -135.0211 59.471088 
  -135.09171 59.426929 -134.9892 59.38998 -135.0161 59.347759 
  -134.94749 59.27887 -134.688 59.24332 -134.56641 59.130539 
  -134.4614 59.126652 -134.3775 59.04388 -134.39529 58.98304 
  -134.3114 58.964432 -134.3322 58.92971 -134.2455 58.85693 
  -133.8269 58.726089 -133.6833 58.595539 -133.36639 58.42416) 
#(-133.36639 58.42416 -133.4472 58.377201 -133.13699 58.135818 
  -133.0844 58.02943 -132.6489 57.619148 -132.2267 57.2047 
  -132.3369 57.088322 -132.0275 57.036381 -132.1031 56.86665 
  -131.8614 56.799709 -131.8161 56.59499 -131.53951 56.596649 
  -131.12579 56.42416 -130.7744 56.3661 -130.6272 56.258598 
  -130.4619 56.23526 -130.4142 56.128868 -130.2292 56.09026 
  -130.08859 56.118038 -130.01421 56.023869 -130.0162 55.912411) 
#(-7.2047219 54.309711 -7.146111 54.2486 -7.2544451 54.197201 
  -7.2586122 54.1572 -7.521111 54.12804 -7.6566672 54.184429 
  -7.8208342 54.19915 -7.8677778 54.224152 -7.878056 54.28915 
  -8.0902767 54.391369 -8.1647224 54.46804 -7.706111 54.60638 
  -7.746944 54.61554 -7.914166 54.671101 -7.9202781 54.703602 
  -7.5374999 54.741371 -7.5527768 54.79166 -7.4827781 54.82999 
  -7.460556 54.898041 -7.4083338 54.950539 -7.4099998 54.989979 
  -7.253056 55.070541) #(-6.2701449 54.09687 -6.3044438 54.10638 
  -6.375 54.06638 -6.5675001 54.050819 -6.6702781 54.070541 
  -6.6311111 54.166088 -6.686388 54.19915 -6.750278 54.189152 
  -6.8277779 54.241928 -6.873055 54.342209 -6.980278 54.403591 
  -7.0586109 54.409981 -7.2047219 54.309711) 
#(5.0444531 52.926361 5.375555 53.070541) 
#(5.268362 52.68644 5.3041658 52.706928 5.2783332 52.75082 
  5.1599998 52.744431 5.1297221 52.767208 5.1161108 52.85638 
  5.0444531 52.926361) #(5.4580231 52.532452 5.1355548 52.38026 
  5.1561108 52.337212 5.2786102 52.325821 5.415834 52.279572 
  5.5341659 52.283329 5.5536108 52.35693 5.7983322 52.430538 
  5.8630552 52.523602 5.8361111 52.563599 5.6502771 52.606659 
  5.540833 52.571659 5.4580231 52.532452) 
#(5.375555 53.070541 5.4122219 53.020821 5.374166 52.872211 
  5.4336109 52.850269 5.6077781 52.848881 5.7194438 52.834148 
  5.5972209 52.753601 5.5994439 52.6586 5.664721 52.608318 
  5.855 52.608318 5.8780551 52.50943 5.813055 52.427212 
  5.625278 52.354431 5.5336099 52.267208 5.4655552 52.258041 
  4.9702768 52.36721 5.080555 52.419708 5.0777769 52.471661 
  5.0283332 52.623878 5.0499992 52.64193 5.1677771 52.62888 
  5.268362 52.68644) #(-98.430733 53.04472 -98.796112 53.082489 
  -98.829453 53.032768 -99.043327 53.04916 -99.061401 53.10165 
  -99.200562 53.17165 -99.216133 53.32999 -99.148064 53.399712 
  -99.061684 53.51804 -99.049728 53.60693 -98.970291 53.69305 
  -99.008057 53.772491 -98.951683 53.819149 -98.968338 53.844711 
  -98.928886 53.871929 -98.811401 53.8936 -98.711403 53.871929 
  -98.690842 53.836102 -98.400848 53.86137 -98.199173 53.819439 
  -97.969177 53.686649 -97.878891 53.708321 -97.883057 53.738602 
  -98.258621 53.894161 -98.315567 53.983879 -98.310287 54.014992 
  -98.230827 54.087769 -98.212509 54.169159 -98.042236 54.364712 
  -98.011124 54.41444 -97.916672 54.362209 -97.969727 54.33054 
  -97.958618 54.30444 -97.819458 54.319149 -97.796402 54.300819 
  -97.868896 54.248051 -98.14473 54.182209 -98.164459 54.14526 
  -98.150284 54.047489 -98.22084 54.025269 -98.223618 54.001099 
  -98.095291 53.920269 -98.041672 53.933601 -98.027237 53.985538 
  -97.731667 54.08638 -97.729736 54.037769 -97.794167 53.988319 
  -97.950844 53.982491 -97.978058 53.960541 -97.956947 53.85471 
  -97.81723 53.71526 -97.829727 53.61137 -97.699173 53.51054 
  -97.672791 53.408329 -97.592216 53.36694 -97.583893 53.290272 
  -97.420013 53.16832 -97.440567 53.13026 -97.33168 53.001381 
  -97.435287 52.947769 -97.378067 52.90276 -97.398064 52.859989 
  -97.201401 52.686649 -97.138062 52.539989 -97.03334 52.415821 
  -97.037231 52.31554 -97.008347 52.24971 -97.088058 52.23999 
  -97.025009 52.150829 -96.857788 52.005821 -96.822243 51.946381 
  -96.871948 51.87888 -96.859734 51.861931 -96.775848 51.858051 
  -96.702507 51.812771 -96.694733 51.77055) 
#(3.370646 51.375549 3.363889 51.313599 3.4391661 51.244431 
  3.5241661 51.250542 3.5247221 51.288319 3.7930551 51.261929 
  3.8063879 51.21693 3.957222 51.216091 4.2149992 51.330269 
  4.2300119 51.35722) #(4.236443 51.368771 4.2394428 51.374149 
  4.413054 51.35804 4.437777 51.375259 4.396667 51.416931 
  4.4116659 51.456928 4.5494428 51.482761 4.541944 51.426651 
  4.6716652 51.427479 4.769166 51.502769 4.8258319 51.49221 
  4.8447218 51.461369 4.8163872 51.425541 4.7827768 51.4147 
  4.9402761 51.401371 5.041388 51.486649 5.104444 51.434978 
  5.0772219 51.39526 5.143888 51.3186 5.2374992 51.308319 
  5.2388878 51.262211 5.457777 51.28054 5.8554649 51.14782) 
#(5.8554649 51.14782 5.8027759 51.093319 5.7758322 51.021099 
  5.7227759 50.96526 5.7591658 50.94915 5.683742 50.882191) 
#(5.683742 50.882191 5.6986089 50.757771 6.0084071 50.756069) 
#(-96.694733 51.77055 -96.783623 51.75499 -96.54306 51.538879 
  -96.577507 51.498322 -96.53334 51.456928 -96.365837 51.32777 
  -96.260834 51.203602 -96.331123 51.196381 -96.360001 51.164711 
  -96.313606 51.111099 -96.400558 51.110271 -96.425003 51.084148 
  -96.352509 50.800819 -96.381668 50.71027 -96.305847 50.61721 
  -96.440567 50.636379 -96.531113 50.731098 -96.603897 50.653599 
  -96.561401 50.4561 -96.628067 50.408871 -96.778061 50.37888 
  -96.926392 50.434429 -96.976959 50.891941 -96.907501 50.98444 
  -96.941116 51.049992 -96.83223 51.11499 -96.840286 51.148041 
  -96.746674 51.238319 -96.675003 51.252769 -96.611679 51.344151 
  -96.69751 51.346931 -96.748901 51.354431 -96.890007 51.206661 
  -96.98584 51.183319 -96.980827 51.258881 -96.904167 51.31776 
  -96.92334 51.347488 -96.759171 51.51276 -96.722778 51.60638 
  -96.797234 51.60471 -96.771118 51.665539 -96.823624 51.689709 
  -96.842506 51.73082 -97.089737 51.662209 -97.136124 51.496929 
  -97.254463 51.42971 -97.283623 51.4561 -97.301117 51.629711 
  -97.220291 51.799709 -97.34584 52.04443 -97.422234 52.040272 
  -97.511124 51.99221 -97.542793 51.913879 -97.585854 51.91832 
  -97.606117 52.000271 -97.501678 52.079151 -97.486954 52.1311 
  -97.672501 52.10471 -97.678337 52.151371 -97.771118 52.12249 
  -97.775009 52.092209 -97.714737 52.081661 -97.810562 51.91444 
  -97.755836 51.868881 -97.789459 51.860271 -98.029716 51.94804 
  -98.156403 52.241379 -98.410278 52.360821 -98.465012 52.420818 
  -98.466667 52.501381 -98.719177 52.64555 -98.898354 52.850552 
  -98.906952 52.910259 -98.856117 52.940819 -98.600853 52.984711 
  -98.430733 53.04472) #(5.7830381 49.527271 5.8399992 49.552212 
  5.8991661 49.662762 5.8205552 49.749149 5.746666 49.795269 
  5.7533331 49.849152 5.731111 49.89415 5.808332 49.961102 
  5.8197212 50.009708 5.98 50.172211 6.1069431 50.167759 
  6.1318331 50.12553) #(-95.069092 49.360859 -95.152786 49.376652) 
#(-95.152786 49.376652 -95.153519 49.180672) 
#(-95.153519 49.180672 -95.154167 48.999432) 
#(-95.154167 48.999432 -95.277077 48.999439) 
#(-95.277077 48.999439 -97.202499 48.99971 -100.4689 48.999989 
  -103.7353 48.999432 -107.0014 48.999989 -110.2683 48.99971 
  -113.5344 48.999432 -116.8008 48.999432 -120.0678 48.99971 
  -122.7573 48.998661) #(-94.704964 48.86272 -94.700562 48.899712 
  -94.83168 49.31609 -95.069092 49.360859) 
#(-94.704964 48.86272 -94.704773 48.861542) 
#(-88.051117 48.701649 -87.76889 48.78471 -87.767227 48.8386 
  -87.967506 48.865551 -88.097778 48.811939 -88.089172 48.743038 
  -88.051117 48.701649) #(-93.357597 48.609699 
  -93.361656 48.608601) #(-94.704773 48.861542 -94.690277 48.7747 
  -94.492767 48.69553 -94.278877 48.70248 -94.251106 48.671101 
  -93.885559 48.63026 -93.793327 48.517761 -93.650558 48.516102 
  -93.454453 48.559711 -93.456673 48.59499 -93.361656 48.608601) 
#(-92.438919 48.35223 -92.498611 48.446651 -92.690552 48.444981 
  -92.702499 48.482479 -92.62027 48.498039 -92.626099 48.5322 
  -93.245003 48.640541 -93.357597 48.609699) 
#(-90.838058 48.208599 -90.881943 48.237209 
  -91.037216 48.189701) #(-90.838058 48.208599 -90.77861 48.107491 
  -90.740829 48.09082 -90.389999 48.09724) 
#(-91.440689 48.046471 -91.037216 48.189701) 
#(-91.440689 48.046471 -91.696663 48.10054 -91.734444 48.19054 
  -91.95639 48.235821 -92.051941 48.35387 -92.261124 48.345261 
  -92.300552 48.304989 -92.290283 48.246651 -92.363892 48.233601 
  -92.438919 48.35223) #(-86.328049 48.62656 -86.402786 48.727772 
  -86.631958 48.74221 -86.621674 48.788052 -86.711403 48.80999 
  -86.865837 48.75193 -86.978897 48.80999 -87.141678 48.771099 
  -87.363892 48.805271 -87.968338 48.9561 -88.035568 49.022209 
  -88.271118 48.977211 -88.234177 48.922489 -88.258904 48.887211 
  -88.236954 48.855549 -88.107788 48.798321 -88.103622 48.711651 
  -88.204727 48.606659 -88.290283 48.606659 -88.312233 48.650269 
  -88.335564 48.647209 -88.304459 48.589989 -88.400009 48.540272 
  -88.430557 48.573601 -88.45668 48.539989 -88.482788 48.470539 
  -88.559723 48.430271 -88.58667 48.494709 -88.338623 48.69305 
  -88.318336 48.77721 -88.390007 48.846371 -88.486389 48.850819 
  -88.549454 48.637211 -88.624451 48.62471 -88.631958 48.549709 
  -88.693069 48.507771 -88.698624 48.46138 -88.759453 48.361931 
  -88.936684 48.319988 -88.753891 48.577209 -88.791672 48.57888 
  -89.144447 48.48138 -89.244453 48.38221 -89.198898 48.324429 
  -89.234734 48.30777 -89.263901 48.20388 -89.418327 48.070271 
  -89.579117 48.009029) #(-89.579117 48.009029 
  -89.58931 48.004108) #(-89.583328 48.003319 -89.58931 48.004108) 
#(-89.58931 48.004108 -89.674438 48.015541 -89.904167 47.989151 
  -89.993057 48.022758 -90.065277 48.108318 -90.156387 48.122478 
  -90.389999 48.09724) #(-89.123901 47.834431 -88.973068 47.899429 
  -88.987228 47.91415 -88.671677 48.014992 -88.471123 48.16193 
  -88.835281 48.06332 -89.208344 47.914711 -89.2164 47.853321 
  -89.123901 47.834431) #(-68.888443 47.18803 -69.047501 47.269711 
  -69.055557 47.438591 -69.232483 47.47089) 
#(-67.792862 47.070679 -68.118622 47.289711 -68.323334 47.365822 
  -68.368057 47.351101 -68.405006 47.293598 -68.504463 47.30415 
  -68.888443 47.18803) #(9.54041 47.266975 9.4841614 47.192211 
  9.5116653 47.096088 9.4758301 47.058041) 
#(9.4758301 47.058041 9.6018343 47.049644) 
#(-88.408073 46.997211 -88.224731 47.207489 -87.974731 47.335819 
  -87.948624 47.362492 -88.001106 47.374981 -88.015007 47.392769 
  -87.778633 47.396648 -87.722778 47.426659 -87.801117 47.478039 
  -88.032791 47.488041 -88.401123 47.386929 -88.613892 47.21471 
  -88.608063 47.14027 -88.45195 47.1036 -88.450012 47.15638 
  -88.401947 47.186649 -88.426392 47.097488 -88.48056 47.074429 
  -88.476387 47.042759 -88.408073 46.997211) 
#(-84.775284 46.653042 -84.863617 46.905258 -85.628883 47.225262 
  -86.531677 47.593319 -87.444717 47.955818 -88.368057 48.312199 
  -88.688599 48.257488 -89.356659 47.97971 -89.583328 48.003319) 
#(-89.58931 48.004108 -89.805557 47.899712 -90.486389 47.721931 
  -91.065567 47.45332 -91.294449 47.266102 -91.570282 47.096371 
  -92.101387 46.790821 -92.104172 46.759159 -92.018066 46.701099 
  -91.789459 46.7061 -91.297234 46.837212 -91.113342 46.86166 
  -91.029716 46.922489 -90.8414 46.959148 -90.759171 46.896389 
  -90.950562 46.60194 -90.908623 46.594711 -90.738892 46.664989 
  -90.45668 46.568321 -90.412781 46.584431) 
#(-90.412781 46.584431 -90.279167 46.62138 -89.787781 46.831661 
  -89.422501 46.85194 -89.240837 46.919991 -89.131668 47.004162 
  -89.061401 46.99638 -88.936401 47.035259 -88.886398 47.110821 
  -88.65834 47.234711 -88.625557 47.22221 -88.636124 47.143318 
  -88.453339 47.009159 -88.440567 46.967209 -88.47084 46.891102 
  -88.453613 46.77776 -88.388634 46.875271 -88.162231 46.970829 
  -88.138901 46.963329 -88.258621 46.886379 -88.281403 46.830269 
  -88.198059 46.908329 -88.055008 46.92971 -87.678337 46.848049 
  -87.573624 46.733051 -87.384171 46.596371 -87.391953 46.538879 
  -87.349731 46.511662 -87.198624 46.5061 -87.069733 46.53693 
  -86.965286 46.536381 -86.927231 46.483879 -86.835564 46.451382 
  -86.769447 46.495819 -86.676392 46.455818 -86.146118 46.68499) 
#(-69.232483 47.47089 -69.435272 47.271648 -70.009193 46.69804 
  -70.051147 46.439171) #(-83.600067 46.283619 
  -84.056122 46.329151 -84.12001 46.386379 -84.075287 46.503601 
  -84.136124 46.544991 -84.517227 46.482208 -84.589737 46.542488 
  -84.587784 46.571098 -84.426392 46.711651 -84.474457 46.758041 
  -84.544167 46.696098 -84.569458 46.737209 -84.539726 46.82943 
  -84.366959 46.849152 -84.361954 46.89555 -84.472778 46.939709 
  -84.611954 46.903881 -84.666946 46.96027 -84.727783 46.95805 
  -84.785278 47.001381 -84.695557 47.190269 -84.585854 47.278599 
  -84.583618 47.30415 -84.720001 47.436378 -84.916397 47.51527 
  -85.028633 47.61694 -84.967506 47.68082 -84.991119 47.71693 
  -84.939178 47.740822 -84.912514 47.802761 -84.931953 47.855259 
  -84.837784 47.917488 -84.848618 47.95277 -84.89418 47.959431 
  -85.665848 47.92944 -85.827507 47.970829 -85.956123 48.06332 
  -86.224731 48.4286 -86.263062 48.584431 -86.328049 48.62656) 
#(-70.051147 46.439171 -70.139183 46.37582 -70.287216 46.197762 
  -70.234444 46.150822 -70.254028 46.12291) 
#(-83.941299 46.082329 -83.893623 46.09721 -83.891953 46.15527 
  -83.806122 46.144428 -83.785278 46.22971 -83.920563 46.29332 
  -84.11084 46.307491 -84.087784 46.231098 -83.941299 46.082329) 
#(-83.618057 45.93166 -83.51918 45.935551 -83.476669 46.003601 
  -83.540009 46.019161 -83.553886 46.059711 -83.625557 46.1036 
  -83.72139 46.098049 -83.678337 46.071381 -83.692497 46.040539 
  -83.871674 46.014992 -83.888062 45.983051 -83.830002 45.960541 
  -83.766678 45.95499 -83.618057 45.93166) 
#(-83.597748 45.826969 -83.448036 46.011929 -83.61055 46.119148 
  -83.712219 46.123871 -83.958893 46.071659 -84.099442 46.232761 
  -84.160278 46.424992 -84.118332 46.51804 -84.141953 46.535259 
  -84.435127 46.486389 -84.480003 46.46027 -84.565277 46.466381 
  -84.775284 46.653042) #(-86.146118 46.68499 -85.493347 46.684711 
  -85.248901 46.764149 -84.948624 46.77721 -85.01445 46.71582 
  -85.047501 46.510818 -85.007233 46.488041 -84.621948 46.485821 
  -84.580566 46.421379 -84.514717 46.431381 -84.287231 46.462212 
  -84.178337 46.250271 -84.243057 46.2286 -84.246948 46.197491 
  -84.029167 46.14249 -84.055008 46.108879 -84.017227 46.06221 
  -83.892227 46.00526 -83.9039 45.969711 -84.452217 46.013882 
  -84.476959 45.984989 -84.5625 46.040272 -84.670288 46.048599 
  -84.733337 45.962769 -84.705292 45.862492 -84.759171 45.853039 
  -85.009171 46.018318 -85.184448 46.069439 -85.535278 46.100269 
  -85.688339 45.972488 -86.107788 45.970829 -86.297234 45.93166 
  -86.323624 45.89888 -86.353897 45.809158) 
#(-67.790939 45.760529 -67.757233 45.833321 -67.779739 46.34248 
  -67.792862 47.070679) #(-67.4832 45.601662 -67.5392 45.608501 
  -67.796967 45.696091 -67.804443 45.731369 -67.790939 45.760529) 
#(-67.424042 45.59444 -67.4832 45.601662) 
#(-81.863617 45.52055 -81.801392 45.542488 -81.601959 45.751659 
  -81.588348 45.80582 -81.708069 45.803322 -81.657501 45.883881 
  -81.704727 45.892208 -81.811401 45.744431 -81.829727 45.88805 
  -81.910568 45.896648 -81.890007 45.954708 -81.942497 45.983318 
  -82.013062 45.979431 -82.107788 45.928879 -82.118057 45.89193 
  -82.167793 45.837769 -82.224731 45.948601 -82.279167 45.926929 
  -82.306953 45.99165 -82.58168 45.906651 -82.589737 45.88055 
  -82.509171 45.848598 -82.520279 45.801102 -82.547501 45.787491 
  -82.561401 45.827492 -82.757507 45.844151 -82.842216 45.920269 
  -82.805283 45.98888 -82.843903 45.99332 -82.991959 45.929989 
  -83.173073 45.967491 -83.201401 45.95332 -83.232788 45.894161 
  -83.213348 45.873878 -82.713058 45.783329 -82.097778 45.589161 
  -82.015007 45.565819 -81.789169 45.69582 -81.750839 45.677761 
  -81.904449 45.575821 -81.930557 45.598049 -81.990837 45.555538 
  -81.863617 45.52055) #(-67.20076 45.19215 -67.281387 45.19693 
  -67.319168 45.148602 -67.359451 45.160542 -67.465012 45.281101 
  -67.450302 45.31749 -67.482788 45.500271 -67.410828 45.52998 
  -67.424042 45.59444) #(-70.254028 46.12291 -70.309723 45.980808 
  -70.248627 45.96471 -70.246109 45.940819 -70.411392 45.804428 
  -70.388901 45.752769 -70.416946 45.718319 -70.466667 45.711929 
  -70.696663 45.565262 -70.718887 45.485821 -70.634171 45.428322 
  -70.639999 45.40498 -70.668877 45.39193 -70.769173 45.436649 
  -70.824173 45.416088 -70.825562 45.316662 -70.886124 45.238041 
  -70.955017 45.35387 -71.010567 45.355259 -71.170273 45.25388 
  -71.303047 45.30304 -71.440567 45.23859 -71.398643 45.199421 
  -71.496658 45.068878 -71.495003 45.020901) 
#(-71.495003 45.020901 -71.708344 45.02026 -72.698334 45.019428 
  -73.090408 45.01363) #(-73.090408 45.01363 -73.206161 45.011921) 
#(-73.206161 45.011921 -73.335251 45.010021) 
#(-73.335251 45.010021 -73.355453 45.009708) 
#(-73.355453 45.009708 -73.694717 45.004711 
  -74.678047 45.007061) #(-87.305847 44.808601 -87.212509 44.89027 
  -87.198059 44.9561 -87.172501 44.99749 -87.080292 45.06971 
  -87.051682 45.24221 -86.995293 45.222759 -86.987503 45.275539 
  -87.077789 45.297489 -87.341949 45.025829 -87.410278 44.90554 
  -87.369476 44.838531 -87.305847 44.808601) 
#(-79.660004 44.751659 -79.708618 44.775829 -79.719177 44.805271 
  -79.678337 44.841648 -79.688904 44.882488 -79.736954 44.865551 
  -79.707779 44.83276 -79.743896 44.800541 -79.787231 44.821381 
  -79.79834 44.896931 -80.079727 45.098598 -80.011124 45.126659 
  -79.988892 45.15332 -80.026672 45.194439 -80.109734 45.191101 
  -80.12973 45.24332 -80.077217 45.275829 -80.035278 45.332211 
  -80.077507 45.398041 -80.128067 45.411652 -80.192497 45.375542 
  -80.180847 45.33971 -80.307243 45.377491 -80.311111 45.430538 
  -80.334167 45.379429 -80.353897 45.386379 -80.39473 45.477211 
  -80.378616 45.570541 -80.412514 45.585541 -80.501404 45.569439 
  -80.671677 45.807491 -80.674179 45.847488 -80.772232 45.928322 
  -81.185287 45.94138 -81.162231 45.970829 -81.1689 46.017769 
  -81.505836 45.977211 -81.497787 46.02026 -81.670288 45.946381 
  -81.579727 46.011379 -81.701401 46.014149 -81.540848 46.064991 
  -81.637222 46.122211 -81.747787 46.063599 -81.722778 46.106098 
  -82.174454 46.12582 -82.307243 46.146381 -82.368896 46.17971 
  -82.551392 46.174709 -82.688904 46.17527 -82.63028 46.21777 
  -82.837509 46.181381 -83.379997 46.231659 -83.600067 46.283619) 
#(-74.678047 45.007061 -74.850281 45.016651 -75.125267 44.920269 
  -75.485001 44.724701 -75.781738 44.47575) 
#(-75.781738 44.47575 -75.812233 44.502491) 
#(-75.781738 44.47575 -75.87999 44.393318 -76.053329 44.346649 
  -76.434723 44.10471) #(-79.062607 43.272301 
  -79.058327 43.273041) #(-76.434723 44.10471 -76.793327 43.646099 
  -77.73999 43.638889 -78.702499 43.638039 -79.184723 43.465542 
  -79.062607 43.272301) #(-79.062607 43.272301 
  -79.061661 43.270821) #(-79.058327 43.273041 -78.541946 43.37888 
  -78.05751 43.382771 -77.555008 43.247761 -77.344727 43.293049 
  -77.029716 43.276371 -76.773621 43.32999 -76.678619 43.389149 
  -76.539459 43.46777 -76.2789 43.522209 -76.187233 43.58276 
  -76.214172 43.653881 -76.208618 43.73637 -76.301964 43.860538 
  -76.246948 43.888882 -76.058327 43.989159 -76.065567 44.0061 
  -76.160278 43.970539 -76.214737 43.98888 -76.12529 44.052761 
  -76.174728 44.072491 -76.305557 44.026932 -76.306671 44.06554 
  -76.358063 44.085541 -76.343903 44.136379 -75.805008 44.413879 
  -75.765007 44.461102 -75.781738 44.47575) 
#(-75.812233 44.502491 -76.34639 44.282768 -76.465286 44.254711 
  -76.816879 44.152229 -77.045288 44.060261 -77.070007 44.092209 
  -76.886673 44.17749 -76.920837 44.196381 -76.962509 44.169991 
  -77.051964 44.138321 -77.027237 44.192211 -77.019447 44.21138 
  -77.166397 44.171101 -77.235291 44.189709 -77.454727 44.138882 
  -77.586403 44.088871 -77.575562 44.07888 -77.483902 44.12138 
  -77.305557 44.150551 -77.296951 44.11388 -77.251106 44.144711 
  -77.066391 44.172489 -77.128067 44.0336 -76.980827 44.053879 
  -76.861389 44.11694 -76.853622 44.099152 -77.01001 43.999989 
  -77.041122 43.95443 -77.031403 43.93055 -76.886124 43.955818 
  -76.852783 43.939159 -77.148903 43.85416 -77.232788 43.87999 
  -77.170288 43.954151 -77.289169 43.913879 -77.321953 43.9561 
  -77.485573 43.942211 -77.581123 44.002769 -77.546951 44.022209 
  -77.728897 44.03249 -78.281677 43.953041 -78.965561 43.86277 
  -79.30751 43.680538 -79.472778 43.643879 -79.712784 43.382488 
  -79.775009 43.3036 -79.743622 43.260818 -79.671951 43.235828 
  -79.45668 43.204151 -79.062607 43.272301) 
#(-79.065567 43.09972 -79.061661 43.270821) 
#(-79.065567 43.09972 -79.053383 43.084141) 
#(-82.417969 43.019299 -82.13028 43.585258 -82.209442 43.930271 
  -82.37471 44.642761 -82.543327 45.35582 -82.735001 45.443039 
  -83.597748 45.826969) #(-84.991302 45.775059 
  -84.739182 45.797211 -84.458618 45.66082 -84.329727 45.673599 
  -84.200562 45.62888 -84.108612 45.50832 -84.019447 45.503319 
  -83.826134 45.433041 -83.710007 45.419708 -83.668327 45.380821 
  -83.490013 45.356098 -83.385834 45.276371 -83.408623 45.23777 
  -83.267227 45.037491 -83.314453 45.037491 -83.375839 45.07888 
  -83.434448 45.063042 -83.461121 44.999989 -83.36557 44.899712 
  -83.300293 44.80249 -83.333618 44.335541 -83.498901 44.28138 
  -83.541946 44.249989 -83.58139 44.095268 -83.668617 44.048321 
  -83.696671 43.998051 -83.839737 44.002209 -83.896118 43.940819 
  -83.946671 43.729988 -83.891953 43.669708 -83.69278 43.599152 
  -83.64917 43.613041 -83.529167 43.72694 -83.486679 43.70443 
  -83.452507 43.75499 -83.253616 43.984989 -83.150284 43.993599 
  -83.01918 44.051929 -82.918617 44.065269 -82.781403 44.013882 
  -82.696671 43.926659 -82.629997 43.785549 -82.525558 43.271648 
  -82.417969 43.019299) #(-82.415863 43.014381 -82.26918 43.051102 
  -81.748901 43.341381 -81.715843 43.403049 -81.705002 43.55415 
  -81.739182 44.095539 -81.661667 44.15221 -81.580841 44.346661 
  -81.545837 44.352772 -81.265839 44.623322 -81.276123 44.7761 
  -81.368347 44.921379 -81.349731 44.973049 -81.405838 44.992771 
  -81.462227 45.048321 -81.591667 45.15221 -81.576134 45.19276 
  -81.702217 45.201099 -81.689453 45.267208 -81.618347 45.249989 
  -81.291122 45.251659 -81.276123 45.22971 -81.328339 45.167759 
  -81.248901 44.998051 -81.191391 45.00943 -81.198334 44.971931 
  -81.110291 44.96027 -81.123611 44.915272 -81.025009 44.967209 
  -80.948624 44.95776 -81.026947 44.83305 -81.1064 44.795818 
  -81.123611 44.75082 -80.982788 44.810261 -80.892792 44.7911 
  -80.882782 44.75555 -80.944733 44.61137 -80.934448 44.593319 
  -80.826401 44.69054 -80.729446 44.725552 -80.637222 44.720268 
  -80.578339 44.609711 -80.104446 44.46777 -80.071953 44.476101 
  -79.995293 44.563599 -79.991119 44.69804 -80.117233 44.762211 
  -80.103897 44.819988 -80.004997 44.860538 -79.93779 44.863602 
  -79.876106 44.803879 -79.877792 44.768318 -79.660004 44.751659) 
#(-82.417969 43.019299 -82.415863 43.014381) 
#(-82.420624 43.014069 -82.417969 43.019299) 
#(-86.22998 42.999851 -86.329727 43.225269 -86.353058 43.250271 
  -86.544167 43.61916 -86.535004 43.678322 -86.433327 43.78471 
  -86.438339 43.84082 -86.523354 44.04916 -86.518623 44.081928 
  -86.398354 44.170818 -86.267502 44.365261 -86.228897 44.583321 
  -86.251953 44.64278 -86.257507 44.709431 -86.085564 44.758598 
  -86.075287 44.913052 -85.934174 44.980549 -85.855827 44.94804 
  -85.813904 44.964989 -85.640007 45.183319 -85.599731 45.194149 
  -85.6539 44.833321 -85.621399 44.785259 -85.605011 44.790272 
  -85.523064 44.993881 -85.49501 44.997211 -85.478622 44.969711 
  -85.547501 44.829151 -85.559174 44.76054 -85.520569 44.78027 
  -85.395569 44.993599 -85.386124 45.267769 -85.325562 45.316101 
  -85.140007 45.383598 -85.044724 45.374149 -84.920288 45.401932 
  -84.91806 45.420551 -85.026123 45.438042 -85.095291 45.498878 
  -85.11084 45.56805 -85.090286 45.61832 -84.940567 45.735821 
  -84.991302 45.775059) #(-86.353897 45.809158 
  -86.523903 45.757771 -86.636948 45.609989 -86.714172 45.684711 
  -86.5439 45.836651 -86.566391 45.894428 -86.779716 45.864712 
  -86.856949 45.72443 -86.983612 45.696381 -87.004463 45.82888 
  -86.959167 45.899429 -86.978897 45.919991 -87.004997 45.89526 
  -87.070847 45.739429 -87.17807 45.656101 -87.303337 45.482491 
  -87.605011 45.157768 -87.646118 44.988319 -87.843903 44.934158 
  -88.018623 44.644161 -88.0289 44.555271 -87.938057 44.53915 
  -87.751953 44.662769 -87.718903 44.733879 -87.630569 44.829708 
  -87.443893 44.889149 -87.325844 44.794991 -87.333893 44.763882 
  -87.443893 44.599991 -87.549454 44.31443 -87.496674 44.216099 
  -87.51889 44.165821 -87.652237 44.081928 -87.729736 43.892769 
  -87.697243 43.749989 -87.797501 43.5611 -87.910004 43.233879 
  -87.877228 43.173599 -87.902237 43.01749 -87.868233 42.99622) 
#(-79.053383 43.084141 -79.031387 43.056091 -79.005051 43.02216 
  -78.97995 42.97406 -78.917068 42.916161) 
#(-82.645943 42.555359 -82.586403 42.55859 -82.521393 42.61887 
  -82.474716 42.751659 -82.48111 42.82943 -82.41333 42.96471 
  -82.420624 43.014069) #(-82.650726 42.555099 
  -82.645943 42.555359) #(-79.053383 43.084141 
  -79.078613 43.081661 -78.932793 42.899429 -79.006958 42.876659 
  -79.179733 42.878601 -79.354736 42.867489 -80.025558 42.807491 
  -80.263901 42.758881 -80.340286 42.668598 -80.386124 42.678051 
  -80.449448 42.623322 -80.440567 42.599152 -80.173073 42.569988 
  -80.26918 42.555538 -80.898354 42.661652 -81.156403 42.672211 
  -81.451401 42.607491 -81.654716 42.478039) 
#(1.7109669 42.473499 1.5333329 42.4361 1.448333 42.450821 
  1.446388 42.572208 1.4352469 42.597149) 
#(-79.730827 42.27776 -79.276672 42.522209 -79.09584 42.640541 
  -78.87529 42.78138 -78.861679 42.841381 -78.936684 42.983318 
  -78.886124 43.039162 -78.90834 43.068878 -79.022232 43.087212 
  -79.053383 43.084141) #(-82.645943 42.555359 
  -82.648903 42.547779 -82.595573 42.509991 -82.4189 42.498322 
  -82.402237 42.387489 -82.440002 42.341381 -82.493057 42.312771 
  -82.956123 42.341099 -83.081947 42.289711 -83.101959 42.238319) 
#(-83.175056 42.120789 -83.101669 42.292759 -82.886124 42.404709 
  -82.876953 42.525829 -82.838058 42.569988 -82.781403 42.577209 
  -82.813606 42.621101 -82.811401 42.646648 -82.712509 42.694439 
  -82.630836 42.678879 -82.620827 42.619431 -82.645943 42.555359) 
#(-81.654716 42.478039 -81.813904 42.368881 -81.842506 42.27943 
  -81.892502 42.253319 -81.857788 42.32082 -82.078056 42.251099 
  -82.388062 42.1236 -82.485001 42.022209 -82.505836 41.913319 
  -82.551682 41.988319 -82.628067 42.035259 -82.698334 42.035259 
  -82.828339 41.984989 -82.921951 41.98666 -83.123901 42.06971 
  -83.101959 42.238319) #(-78.917068 42.916161 -78.94249 42.852489 
  -79.009453 42.811649 -80.097229 42.396381 -80.267227 42.368591 
  -81.249161 42.224979 -81.34639 42.180538 -82.425278 41.675541 
  -82.696663 41.683868 -83.071953 41.859711 -83.16861 42.046101 
  -83.13797 42.112339 -83.113243 42.251308 -83.098267 42.281239 
  -83.087769 42.29221 -83.073334 42.301201 -83.048393 42.311169 
  -82.92305 42.36499 -82.650726 42.555099) 
#(-87.868233 42.99622 -87.764717 42.78027 -87.811401 42.636929 
  -87.799179 42.473598 -87.829727 42.346378 -87.809448 42.217491 
  -87.670288 42.066929 -87.656677 41.97971 -87.564728 41.76804 
  -87.388634 41.634708 -87.189728 41.629429 -86.966949 41.701931 
  -86.646667 41.881939 -86.344177 42.30027 -86.236954 42.593319 
  -86.22998 42.999851) #(-83.175056 42.120789 -83.199448 42.03138 
  -83.256958 41.934429 -83.303337 41.937481 -83.448624 41.764431 
  -83.459457 41.71944 -83.414169 41.707489 -83.320557 41.710541 
  -82.978348 41.53582 -82.889717 41.529991 -82.833618 41.588871 
  -82.789169 41.542488 -82.734177 41.549709 -82.702507 41.512211 
  -83.058899 41.458599 -82.977783 41.435551 -82.804459 41.47887 
  -82.482788 41.39027 -82.305557 41.438042 -81.712784 41.501099 
  -81.386948 41.70443 -80.853897 41.889149 -80.293327 42.05138 
  -80.122787 42.156651 -80.069458 42.165272 -79.730827 42.27776) 
#(-112.3611 40.688881 -112.3231 40.695271 -112.1789 40.776932 
  -112.1608 40.84721 -112.2614 41.04887 -112.2331 41.076931 
  -112.1714 41.050819 -112.125 40.971931 -112.0536 40.90971 
  -112.055 40.938042 -112.1953 41.127491 -112.3467 41.241379 
  -112.4245 41.2136 -112.4803 41.228039 -112.5234 41.35915 
  -112.6286 41.42915 -112.7628 41.535549 -112.7858 41.631649 
  -112.7661 41.659988 -112.795 41.68082 -112.8984 41.65332 
  -112.9542 41.535259 -112.9295 41.392208 -112.8239 41.248878 
  -112.7561 41.044708 -112.6833 40.9711 -112.6167 41.08749 
  -112.5864 41.088039 -112.5667 41.062771 -112.4845 40.935261 
  -112.3611 40.688881) #(-7.2922521 38.57066 -7.2655559 38.708321 
  -7.1558328 38.790272 -6.9538889 39.026932 -6.9611111 39.056648 
  -7.040556 39.122761 -7.1158328 39.10416 -7.1541672 39.122761 
  -7.1399999 39.173321 -7.2430549 39.213039 -7.2350001 39.276371 
  -7.313611 39.3447 -7.293612 39.467758 -7.4424992 39.55109 
  -7.5333328 39.66888 -7.4077778 39.648319 -7.0172219 39.674992 
  -6.8638892 40.015541 -7.0144448 40.146648 -7.0061111 40.230808 
  -6.960834 40.240261 -6.7874999 40.341648 -6.8483329 40.44331 
  -6.791111 40.51804 -6.8391671 40.574989 -6.7977781 40.657761 
  -6.8294449 40.75526 -6.7997222 40.856091 -6.8916669 40.974701 
  -6.9244442 41.031368 -6.8086109 41.040539 -6.6813889 41.215542 
  -6.5983329 41.244148 -6.433888 41.322491 -6.3186111 41.387211 
  -6.3294449 41.41526 -6.2177782 41.52943 -6.1944442 41.59304 
  -6.3558331 41.677761 -6.4977779 41.65749 -6.539444 41.679428 
  -6.562778 41.745258 -6.5086122 41.873871 -6.5686111 41.887211 
  -6.5450001 41.937199 -6.5816669 41.96748 -6.628056 41.94109 
  -6.809444 41.990261 -6.8377781 41.947201 -7.1522231 41.98859 
  -7.2005558 41.883598 -7.4272218 41.812481 -7.456944 41.864429 
  -7.5244451 41.840542 -7.6119442 41.83498 -7.5916672 41.879711 
  -7.706111 41.90443 -7.8800001 41.852772 -7.8861108 41.923321 
  -7.9122219 41.889709 -7.9819441 41.866379 -8.1408348 41.809151 
  -8.2188892 41.913601 -8.082777 42.025261 -8.0900002 42.068878 
  -8.185833 42.064701 -8.2013893 42.15221 -8.6211109 42.0536 
  -8.8123951 41.90453) #(-7.3070712 38.425598 -7.3297219 38.447201 
  -7.3011112 38.52499 -7.2922521 38.57066) 
#(128.3654 38.622532 128.3036 38.58387 128.3105 38.501659 
  128.2733 38.423599 128.13409 38.32832 127.8227 38.29916 
  127.7764 38.333321 127.1975 38.311932 126.9905 38.21804 
  126.7666 37.968319 126.6866 37.94804 126.6886 37.82732) 
#(-7.4181652 37.17337 -7.5141668 37.573318 -7.2975001 37.848042 
  -7.2547231 37.987492 -7.146111 38.00526 -7.0069451 38.028042 
  -6.9441662 38.162762 -6.9480548 38.218319 -7.0877781 38.174431 
  -7.1441669 38.27026 -7.3070712 38.425598) 
#(42.373852 37.059639 42.366089 37.11018) 
#(36.30859 34.682758 36.305538 34.668049 36.153591 34.638599 
  35.970718 34.649509) #(42.373852 37.059639 41.835258 36.598869 
  41.403042 36.525539 41.290272 36.355549 41.25499 36.054989 
  41.37804 35.838589 41.383869 35.625259 41.27776 35.495541 
  41.211369 35.194698 41.229149 34.788319 41.00388 34.41943) 
#(36.382511 33.833309 36.283329 33.917759 36.420818 34.051651 
  36.624981 34.203869 36.58971 34.238041 36.60054 34.309429 
  36.559151 34.323601 36.55109 34.42609 36.424431 34.501659 
  36.338871 34.519711 36.42915 34.60693 36.37804 34.638599 
  36.344429 34.689152 36.30859 34.682758) 
#(77.831413 35.480751 77.869957 35.44915 77.920242 35.43803 
  78.05191 35.505821 78.088028 35.476929 78.06636 35.43137 
  78.023857 35.274429 78.087189 35.160809 78.299133 34.65498 
  78.368301 34.59304 78.631638 34.55304 78.974693 34.36499 
  79.011917 34.283871 79.00386 34.22942 78.967743 34.189152 
  78.74913 34.092209 78.731918 34.04332 78.785522 33.893879 
  78.795593 33.728989) #(78.795593 33.728989 78.798141 33.68718) 
#(78.798141 33.68718 78.806633 33.548611 78.837479 33.478039 
  78.937408 33.408649) #(41.00388 34.41943 40.277481 34.07777 
  38.794552 33.377232) #(35.619282 33.248661 35.810539 33.360821 
  35.824429 33.40221 36.059151 33.57943 36.052761 33.598042 
  35.934978 33.646099 35.971088 33.718868 36.111099 33.834709 
  36.382511 33.833309) #(35.619282 33.248661 35.566662 33.290272 
  35.504711 33.094151 35.349152 33.063042 35.316929 33.107208 
  35.097061 33.09211) #(35.614819 32.89716 35.622478 32.987759 
  35.590542 33.017761 35.639431 33.049709 35.669708 33.251659 
  35.619282 33.248661) #(35.6394 32.81448 35.614819 32.89716) 
#(35.631649 32.749989 35.6394 32.81448) 
#(35.599171 32.715031 35.631649 32.749989) 
#(35.93998 32.699162 35.793598 32.744148 35.63345 32.686508) 
#(35.63345 32.686508 35.599171 32.715031) 
#(35.563599 32.65192 35.63345 32.686508) 
#(-114.7186 32.718319 -115.1622 32.686649 -117.1236 32.536789) 
#(-114.8094 32.50388 -114.7186 32.718319) 
#(35.552929 32.393791 35.56332 32.44109 35.55415 32.521381 
  35.563599 32.65192) #(38.794552 33.377232 38.722759 33.340542 
  38.449711 33.197479 38.177761 33.053871 37.906368 32.909431 
  37.636101 32.763882 37.367489 32.618038 37.098591 32.470268 
  36.837761 32.313599 36.674709 32.343601 36.400261 32.381939 
  36.324989 32.451099 36.080269 32.538879 35.93998 32.699162) 
#(38.794552 33.377232 38.797489 33.371651 38.899712 33.144711 
  39.001381 32.917759 39.102211 32.69165 39.20277 32.464432 
  39.303082 32.237339) #(-2.211518 35.09972 -2.2052779 35.05138 
  -1.7472219 34.747211 -1.853333 34.60054 -1.686389 34.48526 
  -1.793334 34.378319 -1.6536109 34.08498 -1.726667 33.69553 
  -1.6419441 33.650822 -1.600278 33.556931 -1.666667 33.38332 
  -1.665555 33.256649 -1.478889 33.058041 -1.487222 32.979149 
  -1.542778 32.939419 -1.383055 32.72443 -1.010556 32.50832 
  -1.078056 32.441368 -1.196389 32.404701 -1.25 32.326931 
  -1.253889 32.21471) #(35.000851 31.98558 34.985821 32.132481 
  35.07999 32.470539 35.222759 32.551929 35.412201 32.50082 
  35.432209 32.4161 35.552929 32.393791) 
#(35.108921 31.83342 34.971088 31.824711 34.963322 31.858891 
  35.03054 31.883881 35.000851 31.98558) 
#(-106.5203 31.78055 -108.2086 31.783331) 
#(35.53233 31.75005 35.54887 31.82777 35.541931 31.94166 
  35.52248 31.998329 35.540821 32.085541 35.552929 32.393791) 
#(35.478649 31.497829 35.53233 31.75005) 
#(35.478649 31.497829 35.39592 31.491739) 
#(35.39592 31.491739 35.394711 31.491659 35.320271 31.439159 
  35.138599 31.36194 34.904148 31.363609 34.88443 31.404711 
  34.953602 31.594721 35.02026 31.658051 35.226372 31.74777 
  35.219978 31.808331 35.108921 31.83342) 
#(-111.0458 31.33305 -112.87 31.91416 -114.8094 32.50388) 
#(-108.2086 31.783331 -108.2083 31.33305) 
#(-108.2083 31.33305 -111.0458 31.33305) 
#(35.431881 31.323191 35.46582 31.38055 35.478649 31.497829) 
#(35.417191 31.234671 35.399429 31.26833 35.431881 31.323191) 
#(34.490261 31.596661 34.55859 31.533051 34.364151 31.360821 
  34.370541 31.29472 34.267078 31.216261) 
#(34.267078 31.216261 34.21748 31.322491) 
#(32.306629 31.19339 32.316101 31.259159) 
#(35.441792 31.089331 35.4622 31.149441 35.417191 31.234671) 
#(35.392208 30.943331 35.441792 31.089331) 
#(32.319149 30.811939 32.314159 30.96999 32.306629 31.19339) 
#(42.977482 30.72777 42.42387 30.963329 41.22221 31.4711 
  40.002491 32.0611 39.303082 32.237339) 
#(47.422771 30.641661 47.62999 30.678049 47.626381 30.702499 
  47.412209 30.730551 47.516651 30.787769 47.51582 30.81222 
  47.39526 30.81555 47.332211 30.740549 47.197769 30.751659 
  47.187481 30.80805 47.03054 30.801109 46.885269 30.91444 
  46.676929 30.8825 46.727211 30.85388 46.851101 30.78055 
  46.794991 30.73527 46.860538 30.708611 46.914711 30.737221 
  46.866379 30.76083 47.00526 30.74305 47.097759 30.731661 
  47.391651 30.699989 47.422771 30.641661) 
#(32.29874 30.56299 32.30032 30.58827 32.347488 30.71277 
  32.319149 30.811939) #(35.157269 30.415661 35.20026 30.56777 
  35.28471 30.718599 35.337761 30.88694 35.392208 30.943331) 
#(32.357189 30.412901 32.29874 30.56299) 
#(11.52714 33.165779 11.49166 33.034988 11.47055 32.627762 
  11.58333 32.490822 11.5675 32.442211 11.51667 32.40942 
  10.8825 32.139149 10.78722 32.008881 10.62472 31.970551 
  10.61361 31.85638 10.46667 31.72027 10.38 31.730551 
  10.30639 31.713051 10.13944 31.509991 10.12333 31.422489 
  10.29055 30.90666 10.21527 30.736099 9.8822174 30.34749 
  9.5320244 30.236059) #(8.6302299 36.942989 8.6163864 36.894989 
  8.6572208 36.867489 8.6499977 36.835258 8.4238873 36.790539 
  8.4211102 36.764431 8.4716635 36.75304 8.475275 36.717201 
  8.4430542 36.654701 8.2313862 36.567211 8.183609 36.524151 
  8.1908321 36.49165 8.3736076 36.444698 8.2627773 35.901089 
  8.2736092 35.758598 8.3402729 35.677479 8.3622189 35.521931 
  8.3094435 35.427212 8.3083324 35.339149 8.3449974 35.287209 
  8.4272213 35.26749 8.4508305 35.233871 8.4011097 35.192211 
  8.2613888 34.910259 8.2886105 34.752769 8.2266636 34.69553 
  8.2474976 34.641102 7.8397222 34.412479 7.767499 34.23637 
  7.6569428 34.21249 7.5272222 34.101929 7.4916658 33.899712 
  7.5224991 33.788601 7.724165 33.439419 7.7319431 33.248322 
  7.7649989 33.208599 8.0227757 33.112759 8.0902748 33.114429 
  8.3061066 32.834148 8.3511086 32.531101 9.0591621 32.091091 
  9.1955528 31.56916 9.5320244 30.236059) 
#(32.56258 30.190121 32.56749 30.236111 32.469151 30.279989 
  32.385639 30.41921 32.357189 30.412901) 
#(80.858582 30.174709 80.904137 30.21693 80.936363 30.181379 
  81.027397 30.2047) #(32.58007 29.95192 32.56258 30.190121) 
#(-1.253889 32.21471 -1.292778 32.159149 -1.198611 32.166931 
  -1.177778 32.11499 -1.213055 32.08971 -1.5 32.10804 
  -2.220278 32.14999 -2.865278 32.084709 -2.938333 32.02887 
  -2.9725001 31.85083 -3.518889 31.67277 -3.7147219 31.716379 
  -3.8186109 31.695551 -3.835278 31.65027 -3.835556 31.46693 
  -3.7247219 31.394711 -3.804167 31.339161 -3.7963891 31.221661 
  -3.825556 31.18277 -3.815556 31.152491 -3.7244439 31.188601 
  -3.5980549 31.086109 -3.602222 30.991381 -3.646667 30.9611 
  -4.0272231 30.90666 -4.1738892 30.766109 -4.4302778 30.637211 
  -4.5919452 30.626381 -4.9424992 30.49221 -5.145 30.186661 
  -5.396111 29.974159 -5.5938892 29.89694) 
#(34.961922 29.5511 34.965542 29.56249 34.9734 29.58552 
  35.166931 30.151661 35.140541 30.23971 35.181931 30.36694 
  35.157269 30.415661) #(34.901539 29.49379 34.865822 29.58416 
  34.862209 29.67388 34.833321 29.777769 34.78915 29.890829 
  34.754711 30.0 34.7136 30.11277 34.667759 30.22583 
  34.622478 30.338329 34.543598 30.429991 34.520538 30.5411 
  34.501099 30.653049 34.450539 30.765829 34.39415 30.87888 
  34.352211 30.991659 34.309711 31.104441 34.267078 31.216261) 
#(43.999882 29.46003 43.59082 29.607771 43.612759 30.10277 
  43.658321 30.37944 43.062481 30.414721 42.977482 30.72777) 
#(-101.0342 29.453039 -101.142 29.49194 -101.235 29.6161 
  -101.3019 29.57638 -101.3061 29.631109) 
#(43.999882 29.46003 44.71489 29.205379) 
#(39.303082 32.237339 39.275822 32.216648 39.00499 32.00555 
  38.860821 31.970551 38.594429 31.90527 38.32832 31.839439 
  38.062481 31.77305 37.79887 31.707211 37.533871 31.640551 
  37.269428 31.57333 37.00526 31.50555 37.098042 31.41333 
  37.326382 31.1861 37.551929 30.96027 37.776932 30.73221 
  38.001381 30.504169 37.93082 30.468599 37.667488 30.33638 
  37.61998 30.240271 37.51054 30.018049 37.262211 29.95916 
  37.002769 29.91221 36.743599 29.864719 36.698589 29.79805 
  36.54916 29.57527 36.328041 29.37722 36.069981 29.188881 
  35.98888 29.201929 35.732479 29.242491 35.475811 29.28249 
  35.218868 29.321939 34.96096 29.362431) 
#(80.149696 29.11249 80.25914 29.149441 80.23996 29.21471 
  80.28775 29.205549 80.306923 29.310551 80.275803 29.322491 
  80.241348 29.439989 80.409973 29.60638 80.37413 29.74416 
  80.420242 29.78916 80.479973 29.796659 80.875519 30.143049 
  80.858582 30.174709) #(46.541611 29.10416 46.55526 29.11249 
  46.883598 29.502769 47.128868 29.97471 47.169979 30.01527 
  47.35693 30.082211 47.731369 30.083879 47.950439 30.01302) 
#(44.71489 29.205379 45.464989 29.47443 45.774151 29.368601 
  46.541611 29.10416) #(-101.3061 29.631109 -101.3558 29.660549 
  -101.405 29.77277 -101.5314 29.76416 -101.5417 29.81472 
  -101.5756 29.773331 -101.8336 29.79583 -102.3147 29.883329 
  -102.385 29.769711 -102.6703 29.742769 -102.7611 29.59277 
  -102.8195 29.39666 -102.8861 29.340549 -102.8625 29.224159 
  -102.9044 29.216101 -103.0353 29.0986 -103.0775 29.091101 
  -103.1105 29.00333 -103.1542 28.98138 -103.4011 29.036381 
  -103.5433 29.14916 -103.6358 29.158331 -103.7611 29.22472 
  -103.9992 29.31361 -104.4425 29.588051 -104.6803 29.945551 
  -104.6822 30.18749 -104.8114 30.34972 -104.8672 30.50222 
  -105.125 30.74972 -105.2667 30.799721 -105.4975 30.954161 
  -105.8714 31.291941 -106.2144 31.475269 -106.3358 31.68944 
  -106.5203 31.78055) #(44.71489 29.205379 44.741928 29.19055 
  45.508881 28.774719 45.764992 28.856939 46.541611 29.10416) 
#(-8.6692944 28.70929 -8.495554 28.79055 -8.3577766 28.919161 
  -8.0466671 29.093611 -7.622777 29.391939 -7.434166 29.397221 
  -7.1997209 29.594721 -6.5755558 29.57111 -6.5111108 29.6336 
  -6.4744439 29.83305 -6.4002781 29.80444 -6.1913881 29.809719 
  -5.5938892 29.89694) #(46.541611 29.10416 46.69804 29.08638 
  47.460819 28.99888 47.53915 28.8561 47.57526 28.699989 
  47.684151 28.561939 48.419731 28.544359) 
#(-8.6692944 28.70929 -8.6692944 27.66885) 
#(-8.6692944 27.66885 -9.9338894 27.66666 -13.17693 27.665079) 
#(83.923683 27.452971 83.832748 27.42749 83.878304 27.36861 
  83.858307 27.352221 83.607742 27.46916 83.386368 27.472771 
  83.389969 27.39666 83.330544 27.33749 83.275803 27.34333 
  83.176361 27.448879 82.76442 27.50527 82.70108 27.711109 
  82.424133 27.67944 82.170807 27.85722 81.999687 27.922211 
  81.880249 27.85722 81.476067 28.08333 81.470253 28.1236 
  81.388313 28.17444 81.319977 28.129999 81.188858 28.36916 
  80.910522 28.45722 80.831093 28.50527 80.569977 28.684719 
  80.505539 28.658331 80.508591 28.56694 80.440247 28.62888 
  80.357742 28.62944 80.313019 28.69721 80.055801 28.836109 
  80.06218 28.93638 80.12468 28.984159 80.149696 29.11249) 
#(-8.6692944 27.66885 -8.6692944 27.280199) 
#(88.142357 27.86809 88.195801 27.841379 88.045807 27.48527 
  88.06665 27.436939 88.013031 27.21221) 
#(88.750549 27.14727 88.806351 27.25305 88.901367 27.282221 
  88.917877 27.321039) #(-99.458618 27.04694 -99.440826 27.253611 
  -99.483887 27.28278 -99.503067 27.56583 -99.544159 27.610821 
  -99.70723 27.661659 -99.745003 27.72138 -99.835564 27.77527 
  -99.881943 27.90638 -99.99472 27.999439 -100.0131 28.068609 
  -100.1967 28.208891 -100.3317 28.40555 -100.3275 28.509159 
  -100.44 28.61694 -100.4958 28.740271 -100.5656 28.83971 
  -100.6683 29.113331 -100.7661 29.17444 -100.7753 29.233049 
  -101.0181 29.388599 -101.0342 29.453039) 
#(91.659554 27.76511 91.6008 27.66666 91.598022 27.62499 
  91.631348 27.536381 91.765533 27.45694 91.775253 27.4161 
  92.007751 27.471939 92.11441 27.28583 92.015259 27.168051 
  92.015533 27.08083 92.083313 27.02277 92.112183 26.920271 
  92.069977 26.86194 91.997192 26.85194 91.915253 26.893881 
  91.916924 26.85416 91.8358 26.863331 91.712479 26.799999 
  91.542191 26.80444 91.492188 26.87472 91.418854 26.873329 
  91.371353 26.800831 91.307457 26.778049 90.682457 26.77417 
  90.392197 26.903601 90.344131 26.894159 90.143044 26.75333 
  89.98996 26.73583 89.841919 26.70138 89.618301 26.72694 
  89.636093 26.771111 89.360786 26.859989 89.22081 26.81472 
  89.110237 26.829161 88.921631 26.98777 88.873016 26.95499 
  88.867737 27.080549 88.843307 27.108601 88.750549 27.14727) 
#(-99.172501 26.56361 -99.271118 26.861389 -99.349167 26.88166 
  -99.380829 27.00388 -99.458618 27.04694) 
#(86.948517 26.53265 86.7258 26.421379 86.325813 26.614161 
  86.206627 26.58555 86.029419 26.66305 85.85553 26.570271 
  85.80719 26.602489 85.728577 26.67305 85.726067 26.801661 
  85.623291 26.86694 85.334412 26.735821 85.211639 26.766939 
  85.18663 26.794991 85.194412 26.854441 85.167191 26.870831 
  85.036362 26.85055 84.933296 26.967489 84.750259 27.0075 
  84.644127 27.05666 84.681084 27.140829 84.679138 27.23527 
  84.594971 27.34194 84.297737 27.38833 84.192459 27.476379 
  84.098862 27.516109 84.040253 27.44471 83.923683 27.452971) 
#(88.013031 27.21221 87.996918 27.102489 88.149139 26.920271 
  88.192734 26.73138 88.089417 26.43111 88.003311 26.36721 
  87.921913 26.448601 87.593033 26.37944 87.476913 26.435551 
  87.390533 26.414709 87.328033 26.347771 87.133591 26.41333 
  87.053848 26.587219 86.994423 26.528879 86.948517 26.53265) 
#(-8.6692944 27.280199 -8.667223 26.000271) 
#(-8.667223 26.000271 -8.7672234 25.99971 -12.00083 26.0) 
#(95.020714 25.92828 95.134979 26.00194 95.17746 26.070829 
  95.08165 26.22805 95.068314 26.3486 95.148323 26.620001 
  95.253593 26.67944 95.271088 26.64472 95.449692 26.715549 
  95.519417 26.82305 95.610786 26.821381 95.65802 26.895281 
  95.717743 26.89138 95.773857 26.97221 95.919128 27.035549 
  96.035797 27.19249 96.194122 27.27083 96.524139 27.294161 
  96.60997 27.36694 96.763603 27.355829 96.88414 27.254721 
  96.861359 27.21027 96.888313 27.178049 96.991913 27.13472 
  97.144417 27.092489 97.158859 27.138611 96.957199 27.384159 
  96.895523 27.564989 97.249397 27.90749 97.299133 27.91666 
  97.3172 27.87833 97.367737 27.89666 97.394127 28.01861 
  97.316071 28.089161 97.349548 28.22267) 
#(89.853439 25.894751 89.863297 25.94138 89.861649 25.943859 
  89.853638 25.955959 89.673576 26.228331 89.629959 26.22333 
  89.589142 26.153601 89.636368 26.070829 89.553017 25.96221 
  89.512756 26.003599 89.432739 25.998329 89.149406 26.141939 
  89.074692 26.384991 88.953857 26.44611 88.91803 26.367769 
  88.99469 26.33555 89.055237 26.242491 89.00798 26.230169) 
#(-97.136841 25.96471 -97.351936 25.912491 -97.343887 25.85861 
  -97.367493 25.839439 -97.479721 25.88583 -97.61972 26.007771 
  -97.713333 26.0275 -97.788597 26.06444 -98.066673 26.03833 
  -98.083328 26.069719 -98.147507 26.05916 -98.300278 26.10638 
  -98.523903 26.239441 -98.93222 26.392771 -99.005569 26.38666 
  -99.106659 26.422489 -99.089722 26.49527 -99.172501 26.56361) 
#(89.826553 25.767401 89.853439 25.894751) 
#(56.2719 25.634899 56.21471 25.615271 56.1436 25.6761 
  56.185539 26.014721 56.158871 26.083599 56.081211 26.066441) 
#(-4.8063889 25.000271 -5.148056 25.21277 -6.897223 26.26749 
  -8.6692944 27.280199) #(-4.8063889 25.000271 
  -6.5774999 24.999161) #(92.496613 24.889931 92.402191 25.033331 
  92.093582 25.17749 92.003036 25.181931 91.4758 25.139429 
  91.257751 25.207769 90.82164 25.149719 90.776077 25.1761 
  90.412483 25.14888 90.327759 25.18499 89.837753 25.296101 
  89.814407 25.37388 89.863297 25.64749 89.820251 25.73749 
  89.826553 25.767401) #(89.00798 26.230169 88.92775 26.27944 
  88.883591 26.27833 88.849411 26.231661 88.763603 26.299999 
  88.699402 26.26944 88.671631 26.28944 88.741348 26.323601 
  88.694122 26.391939 88.429138 26.555 88.419418 26.59638 
  88.401077 26.625271 88.334702 26.48666 88.353577 26.45166 
  88.378021 26.489429 88.49469 26.450001 88.522476 26.355829 
  88.457474 26.36916 88.373863 26.303049 88.179688 26.14333 
  88.183296 26.03389 88.131073 25.989161 88.10524 25.86916 
  88.15831 25.77833 88.257477 25.815001 88.287483 25.794161 
  88.521088 25.53194 88.70108 25.46805 88.772476 25.51639 
  88.84108 25.454161 88.82164 25.401661 88.882462 25.32638 
  89.005814 25.305269 89.006363 25.278049 88.944687 25.196939 
  88.558853 25.18305 88.450813 25.187771 88.438019 25.02305 
  88.332199 24.867491 88.215263 24.948879 88.135246 24.91832 
  88.1633 24.881941 88.043297 24.68416 88.074783 24.64052) 
#(51.21603 24.61903 51.10862 24.55559) 
#(50.827641 24.75386 50.969429 24.57777 51.10862 24.55559) 
#(91.946617 24.34944 91.997742 24.326111 91.974693 24.37888 
  92.098022 24.37888 92.135246 24.41416 92.248581 24.742491 
  92.248016 24.896379 92.281647 24.907221 92.38942 24.857771 
  92.496613 24.889931) #(-97.713623 24.26638 -97.611389 24.723881 
  -97.538071 25.0686 -97.472504 25.200001 -97.422791 25.346939 
  -97.394997 25.413879 -97.436684 25.425831 -97.472778 25.44916 
  -97.537231 25.44194 -97.535278 25.30694 -97.631958 25.31222 
  -97.625839 25.36694 -97.6875 25.36277 -97.713058 25.260559 
  -97.753067 25.25555 -97.694458 25.23333 -97.713058 25.019991 
  -97.759171 24.96472 -97.662231 24.95055 -97.625557 24.90472 
  -97.730827 24.849991 -97.688606 24.7411 -97.712784 24.688881 
  -97.691963 24.66861 -97.670013 24.695551 -97.718338 24.477209 
  -97.743057 24.479719 -97.826683 24.56111 -97.837784 24.440269 
  -97.811111 24.415831 -97.761948 24.42667 -97.708344 24.44388 
  -97.726959 24.27916 -97.713623 24.26638) 
#(88.074783 24.64052 88.125519 24.50861 88.554688 24.309441 
  88.691071 24.31666 88.737473 24.25083 88.743851 24.18749 
  88.708313 24.171379 88.707748 24.108049) 
#(93.397751 23.783051 93.384407 23.921379 93.328033 23.981661 
  93.336639 24.073601 93.364143 24.09111 93.405807 24.076389 
  93.477188 23.967489 93.529137 23.964161 93.635803 24.016939 
  94.036636 23.91777 94.128304 23.843611 94.15358 23.85972 
  94.279968 24.228609 94.359131 24.37166 94.389137 24.48 
  94.508591 24.61138 94.538567 24.708891 94.597748 24.725269 
  94.735519 25.030279 94.728577 25.136379 94.588867 25.189989 
  94.577469 25.24527 94.634979 25.409719 94.878571 25.591101 
  95.039139 25.75111 95.020714 25.92828) 
#(11.98645 23.52232 11.55889 24.30249 10.71527 24.567209 
  10.42222 24.47805 10.25222 24.605829 10.21833 24.75111 
  10.05444 24.838051 10.02666 25.33749 9.3983307 26.15332 
  9.3930531 26.18277 9.4299955 26.233049 9.4994392 26.357491 
  9.6386089 26.41555 9.8763847 26.528879 9.9305515 26.859711 
  9.8483315 26.9086 9.7349949 27.323879 9.8391628 27.508051 
  9.8138847 27.57638 9.8811073 27.621111 9.9541655 27.868601 
  9.7902737 28.27055 9.8733311 28.859159 9.7647209 29.433331 
  9.5666637 29.80694 9.3038864 30.12249 9.5320244 30.236059) 
#(-12.00083 26.0 -12.00056 23.454439) 
#(-12.00056 23.454439 -12.59639 23.27643) 
#(-6.3566632 23.146021 -6.371388 23.289709 -6.5774999 24.999161) 
#(92.174408 23.73628 92.030533 23.645269 92.004967 23.678329 
  91.945801 23.722771 91.967468 23.51277 91.952469 23.47999 
  91.844971 23.410271 91.767197 23.25666 91.795242 23.19499 
  91.809967 23.07444 91.613586 22.94305 91.546631 23.00305 
  91.500259 23.14749 91.426071 23.26194 91.392754 23.26333 
  91.377457 23.20694 91.40358 23.07444 91.339973 23.10499 
  91.282204 23.373329 91.159126 23.653049 91.273857 23.97444 
  91.361076 23.99527 91.376068 24.03388 91.370796 24.097771 
  91.404694 24.11055 91.482193 24.090549 91.631638 24.11305 
  91.657204 24.224159 91.714691 24.14888 91.755249 24.158331 
  91.757751 24.239161 91.789139 24.22805 91.846359 24.181379 
  91.899979 24.15694 91.932457 24.275551 91.91774 24.32666 
  91.946617 24.34944) #(93.098587 22.78944 93.144127 22.9011 
  93.124969 23.014441 93.147202 23.053881 93.206627 23.05722 
  93.238861 23.00889 93.293579 23.008881 93.35025 23.07333 
  93.404419 23.47555 93.397751 23.783051) 
#(88.707748 24.108049 88.727188 24.0536 88.733032 23.915831 
  88.614143 23.87249 88.598022 23.84721 88.568039 23.641109 
  88.789963 23.46027 88.711357 23.308611 88.733856 23.24333 
  88.847198 23.242769 88.986633 23.195829 88.868851 23.082769 
  88.864693 22.960831 88.973297 22.83333 88.942497 22.63409) 
#(15.00063 23.00037 14.235 22.614161 13.59555 23.139429 
  13.41722 23.21471 11.98645 23.52232) 
#(56.37582 24.964439 56.02462 25.039221 56.02462 24.2061 
  55.694012 23.79615 55.694012 22.288589) 
#(114.22119 22.548855 114.3139 22.49749 114.1602 22.44944 
  114.2016 22.38166 114.3139 22.47555 114.39 22.42972 
  114.373 22.365 114.2772 22.387489 114.2536 22.35305 
  114.3 22.2775 114.2364 22.29361 114.1344 22.32999 
  113.91 22.362499 113.8966 22.40694 114.03134 22.510466) 
#(93.098587 22.78944 93.119957 22.52722 93.182739 22.427771 
  93.191071 22.248329 93.142471 22.236931 93.163452 22.19154) 
#(113.5606 22.210602 113.5525 22.18305 113.52873 22.181513) 
#(113.54643 22.152607 113.54906 22.157171 113.55266 22.157171 
  113.55445 22.154406 113.55266 22.15164 113.54906 22.15081 
  113.54643 22.152607) #(113.55266 22.1255 113.55266 22.120106 
  113.55348 22.116371 113.55791 22.115541 113.56234 22.11734 
  113.5651 22.121904 113.56331 22.129095 113.55971 22.131861 
  113.55445 22.130894 113.55266 22.128128 113.55266 22.1255) 
#(89.059837 22.098761 89.064438 22.117109 89.096359 22.148609 
  89.007202 22.276381 88.997742 22.465549 88.95108 22.55583 
  88.942497 22.63409) #(50.826099 24.747511 50.84734 24.25238 
  51.495319 23.604389 52.090408 22.52001 55.502258 22.057159 
  55.694012 22.288589) #(25.00355 22.001301 25.00111 22.475821 
  24.999439 23.82972 24.99777 25.18 24.999439 26.53944 
  25.00222 27.89888 24.99777 29.24888 24.876101 29.51194 
  24.88694 29.663879 24.817209 29.77416 24.831381 29.88666 
  24.706381 30.156099 24.72694 30.233879 24.9286 30.511101 
  25.0186 30.793051 24.868879 31.16194 24.87471 31.383881 
  24.948601 31.428881 25.069719 31.581659 25.13423 31.63933) 
#(33.183491 22.001301 32.8311 22.00083 32.144428 22.00333 
  31.45388 21.998329 31.515829 22.170549 31.48555 22.216379 
  31.441099 22.23221 31.38916 22.206659 31.277491 21.999161 
  31.080271 21.9986 30.384991 22.000271 29.69083 21.998051 
  29.0002 22.001301) #(35.624592 23.128 35.226929 22.77083 
  34.969151 22.8486 34.713871 22.288879 34.17165 22.196659 
  34.10059 21.99802) #(34.10059 21.99802 33.850819 21.999439 
  33.183491 22.001301) #(29.0002 22.001301 28.815269 22.0 
  28.178329 22.002489 27.551941 21.99777 26.91444 21.99666 
  26.2761 21.998329 25.6311 21.999161 25.00355 22.001301) 
#(36.89061 22.00102 36.552479 21.9986 35.882198 21.99777 
  35.208599 22.000271 34.539711 21.995541 34.10059 21.99802) 
#(92.601303 21.98217 92.562469 22.13805 92.604424 22.151661 
  92.514687 22.721939 92.468582 22.761669 92.459702 22.853319 
  92.394417 22.91777 92.348587 23.22361 92.383591 23.284719 
  92.311897 23.526381 92.288857 23.69611 92.252197 23.72249 
  92.227188 23.65971 92.206917 23.65444 92.174408 23.73628) 
#(92.601303 21.98217 92.68219 22.03138 92.697456 22.15222 
  92.718582 22.15971 92.812737 22.09638 92.901077 21.9536 
  92.950256 22.02916 92.984703 21.991381 93.006088 22.00388 
  93.040527 22.15888 93.058006 22.21027 93.163452 22.19154) 
#(-0.002362632 21.826361 -1.429444 22.80694 -3.1002779 23.91416 
  -4.8063889 25.000271) #(34.10059 21.99802 34.018318 21.768049 
  33.57193 21.72332 33.183491 22.001301) 
#(101.1524 21.564671 101.1518 21.57086) 
#(-12.59639 23.27643 -12.99861 23.024719 -13.10555 22.893049 
  -13.15028 22.7575 -13.07917 22.51055 -13.0 21.338051) 
#(1.169242 21.099899 -0.002362632 21.826361) 
#(92.263199 21.05447 92.193298 21.179159 92.201637 21.342489 
  92.376907 21.474159 92.416077 21.434719 92.420517 21.382219 
  92.467468 21.359989 92.553574 21.3736 92.585251 21.26333 
  92.607468 21.250549 92.669418 21.29694 92.636917 21.3911 
  92.601303 21.98217) #(11.98645 23.52232 11.84444 23.44194 
  10.36083 22.5886 8.8944445 21.72221 7.4544892 20.852131) 
#(-13.0 21.338051 -13.39555 21.340269 -15.17028 21.336941 
  -16.953051 21.338329 -17.05435 20.917931 -17.05435 20.770069) 
#(100.0923 20.349291 100.0966 20.35833 100.1861 20.65332 
  100.3761 20.828051 100.5158 20.803881 100.5705 20.81777 
  100.648 20.8736 100.6336 20.89138 100.538 20.86694 
  100.5133 20.88777 100.5455 21.02527 100.6091 21.04277 
  100.7322 21.314159 100.8347 21.30249 101.0052 21.400829 
  101.1616 21.53055 101.1524 21.564671) 
#(100.0923 20.349291 99.959137 20.455271 99.79747 20.331381 
  99.666367 20.311939 99.456093 20.388611) 
#(100.5811 20.157619 100.5205 20.144991 100.4528 20.193331 
  100.3761 20.34416 100.3086 20.3936 100.25 20.37916 
  100.1597 20.234989 100.0972 20.2561 100.0923 20.349291) 
#(104.0404 19.694441 104.1391 19.65999 104.1641 19.68832 
  104.3086 19.686939 104.3206 19.661501) 
#(104.3206 19.661501 104.4136 19.693331 104.523 19.60471 
  104.645 19.615549 104.6616 19.66888 104.8364 19.79138 
  104.8461 19.853319 104.7788 19.874161 104.8525 19.945271 
  104.96 19.986931 104.9808 20.0186 104.935 20.185551 
  104.6805 20.21888 104.6788 20.28055 104.7139 20.29027 
  104.7069 20.345551 104.6025 20.41971 104.5105 20.408051 
  104.3886 20.43861 104.3813 20.46055 104.4708 20.53722 
  104.5511 20.51638 104.6436 20.660271 104.5853 20.67388 
  104.348 20.83444 104.1091 20.977209 104.0769 20.958321 
  103.8036 20.845831 103.7894 20.7486 103.7294 20.724159 
  103.7383 20.669991 103.6872 20.658331 103.4486 20.82777 
  103.4169 20.794161 103.1664 20.85083 103.0308 21.059999 
  102.9669 21.078609 102.9166 21.23444 102.823 21.26083 
  102.9005 21.302771 102.9438 21.45471 102.875 21.43277 
  102.9619 21.544161 102.9889 21.68277 102.965 21.74888 
  102.9394 21.72471 102.8614 21.718321 102.8583 21.826941 
  102.8289 21.847771 102.8072 21.828051 102.8175 21.733601 
  102.7469 21.66638 102.6711 21.662491 102.6405 21.86305 
  102.5055 21.96221 102.4194 22.12055 102.2675 22.21777 
  102.1405 22.395889) #(23.999559 19.497761 24.00083 20.00194 
  24.37277 19.995819 25.00083 19.999161 25.00222 20.644159 
  25.00355 22.001301) #(23.999559 19.497761 21.394711 20.852209 
  18.363609 22.34444 16.00083 23.45055 15.00063 23.00037) 
#(104.0698 19.40983 104.1225 19.497219 104.0366 19.611099 
  104.0404 19.694441) #(103.8791 19.29343 103.9877 19.39916 
  104.0698 19.40983) #(93.868301 19.26123 93.935066 19.17086) 
#(7.4544892 20.852131 5.812499 19.4461 4.245091 19.146191) 
#(-71.678329 19.098881 -71.62944 19.219709 -71.696381 19.241659 
  -71.766953 19.33194 -71.739723 19.345551 -71.692207 19.498329 
  -71.75148 19.700171) #(55.694012 22.288589 56.011391 22.288589 
  56.011391 21.23065 51.999149 18.99888) 
#(1.169242 21.099899 1.161389 20.761101 1.178888 20.732771 
  1.326667 20.73333 1.375 20.65749 1.483333 20.63916 
  1.6630549 20.53611 1.665555 20.442209 1.8102781 20.301109 
  1.881111 20.30138 1.908888 20.23138 2.102499 20.220831 
  2.178055 20.27944 2.2180541 20.27916 2.323611 20.19944 
  2.4216659 20.053049 2.8463881 19.97471 3.2349999 19.81555 
  3.218333 19.532221 3.248055 19.512211 3.272222 19.3736 
  3.1536109 19.223049 3.121388 19.136101 3.331944 18.976379 
  4.245091 19.146191) #(-71.853882 18.96888 -71.678329 19.098881) 
#(-71.991524 18.608589 -71.97084 18.624161 -71.887512 18.61138 
  -71.726387 18.716101 -71.710007 18.798889 -71.779167 18.957769 
  -71.853882 18.96888) #(-71.94635 18.542459 -71.991524 18.608589) 
#(99.456093 20.388611 99.555801 20.199711 99.533859 20.147221 
  99.319138 20.06666 99.170242 20.12805 99.066933 20.086109 
  99.026367 19.82555 98.908859 19.748051 98.836906 19.81638 
  98.671631 19.7486 98.555801 19.67499 98.509697 19.71249 
  98.253593 19.67305 98.080811 19.808611 98.045517 19.79833 
  98.034973 19.643881 97.983582 19.62388 97.792191 19.395821 
  97.837479 19.29361 97.7883 19.276939 97.842194 19.204439 
  97.833862 19.096939 97.678299 18.928049 97.748863 18.85944 
  97.774689 18.56999 97.6633 18.566111 97.534126 18.48971 
  97.442459 18.497219 97.361908 18.583879) 
#(-88.281982 18.48521 -88.405273 18.48971 -88.492218 18.46777 
  -88.617691 18.21624) #(-71.771477 18.05423 -71.748894 18.095551 
  -71.769173 18.202209 -71.694717 18.32222 -71.910278 18.44194 
  -71.88501 18.477209 -71.94635 18.542459) 
#(-88.773392 17.98844 -88.710564 18.060551 -88.681107 18.185551 
  -88.617691 18.21624) #(-88.773392 17.98844 -88.848618 17.877489 
  -89.035828 18.00555 -89.143402 17.9559) 
#(97.698853 17.82888 97.750259 17.977489 97.616638 18.242769 
  97.647751 18.273609 97.623016 18.3125 97.563583 18.32777 
  97.524689 18.264999 97.48497 18.294161 97.444122 18.396099 
  97.34581 18.544161 97.361908 18.583879) 
#(-89.143402 17.9559 -89.142441 17.81868) 
#(103.0901 18.137409 103.0672 18.02499 103.0186 17.978609 
  102.9386 18.003599 102.6716 17.86194 102.6666 17.8025 
  102.5891 17.844999 102.6127 17.9186 102.5903 17.957769 
  102.2933 18.052219 102.1764 18.195551 102.1055 18.21027 
  101.8903 18.030001 101.8316 18.05389 101.7725 18.05444 
  101.7269 17.909161 101.6208 17.881941 101.5591 17.814791) 
#(101.5591 17.814791 101.558 17.784719 101.3905 17.69249 
  101.23 17.527531) #(101.23 17.527531 101.1522 17.4611 
  101.0991 17.498051 100.9189 17.56889 100.9102 17.59638 
  100.9625 17.66721 100.9805 17.764999 101.0303 17.836109 
  101.1908 18.05777 101.1516 18.257771 101.1805 18.333599 
  101.0916 18.37694 101.0622 18.454439 101.14 18.527491 
  101.2689 18.686939 101.2286 18.72916 101.2544 18.78499 
  101.3519 19.051661 101.2872 19.1075 101.2028 19.390829 
  101.2852 19.521379 101.2694 19.579161 101.2191 19.595551 
  101.19 19.568609 101.0322 19.61944 100.8947 19.619711 
  100.7753 19.48444 100.6366 19.55055 100.575 19.49361 
  100.4844 19.54472 100.4061 19.764441 100.4833 19.858049 
  100.5811 20.157619) #(15.52404 17.333941 15.59249 18.604441 
  15.75389 19.932489 15.99666 20.35305 15.56861 20.77972 
  15.55833 20.884439 15.58444 20.929991 15.62722 20.955271 
  15.28444 21.445271 15.2025 21.495819 15.19472 21.99888 
  15.00063 23.00037) #(38.621319 18.0089 38.458599 17.871111 
  38.368038 17.662769 38.273602 17.60305 38.271099 17.54777 
  38.24165 17.527491 38.169708 17.558331 38.122761 17.483601 
  38.096649 17.48777 38.092209 17.547211 38.045818 17.54805 
  37.91721 17.447491 37.869709 17.44499 37.8311 17.483049 
  37.7911 17.468599 37.735821 17.376659 37.506649 17.315269) 
#(-89.142441 17.81868 -89.22084 17.81916 -89.573334 17.820271 
  -89.925827 17.820829 -90.277786 17.82111 -90.63028 17.820551 
  -90.982773 17.82 -90.983322 17.59194 -90.984161 17.256109 
  -91.09111 17.25666 -91.436943 17.2575) 
#(37.506649 17.315269 37.516651 17.18721 37.42416 17.03722) 
#(15.52404 17.333941 15.48861 16.90027) 
#(106.5563 16.899981 106.5611 16.996941 106.4711 16.982491 
  106.3614 17.13555 106.3355 17.234159 106.2875 17.29389 
  106.2536 17.245819 106.2116 17.26166 106.0436 17.402769 
  105.8586 17.62055 105.785 17.659439 105.7364 17.717489 
  105.615 17.87138 105.6247 17.947769 105.4997 18.179991 
  105.4336 18.207769 105.383 18.160271 105.185 18.318331 
  105.1916 18.37833 105.1319 18.40999 105.1033 18.46693 
  105.1494 18.59972 105.1897 18.602489 105.1938 18.64249 
  105.1344 18.706381 104.9575 18.73888 104.6722 18.836941 
  104.5208 18.979429 104.4536 18.9811 104.2239 19.13249 
  103.9647 19.253611 103.8791 19.29343) 
#(53.078251 16.64386 52.71027 17.080271 52.74638 17.336941 
  52.61166 17.532221 51.904148 18.54528 51.999149 18.99888) 
#(106.5868 16.62709 106.5563 16.899981) 
#(106.5868 16.62709 106.633 16.60499 106.6744 16.4786 
  106.7347 16.43055 106.7842 16.45356) 
#(42.790272 16.37722 43.066662 16.54944 43.102489 16.67944 
  43.206089 16.672211 43.185261 16.75222 43.230541 16.776661 
  43.228031 16.809719 43.153591 16.8486 43.173038 17.2111 
  43.273869 17.263611 43.2561 17.30722 43.180538 17.3325 
  43.270821 17.42555 43.44915 17.5275 43.526371 17.51667 
  43.703602 17.394991 43.79221 17.3461 43.90971 17.358879 
  43.90971 17.31333 43.956928 17.30805 44.023869 17.37499 
  44.114712 17.34305 44.173321 17.41194 44.340542 17.413879 
  44.498871 17.395821) #(-91.436943 17.2575 -91.277222 17.178329 
  -91.204727 17.0611 -91.039436 16.894991 -90.983322 16.903049 
  -90.950844 16.896379 -90.94194 16.86166 -90.801392 16.80361 
  -90.678879 16.675819 -90.645844 16.549721 -90.597504 16.48027 
  -90.39389 16.41082 -90.403877 16.352209 -90.445831 16.22888 
  -90.446663 16.075001) #(-88.910957 15.89272 -88.980827 15.89805 
  -89.217773 15.88972) #(-89.217773 15.88972 -89.202217 16.138611 
  -89.180557 16.474991 -89.15834 16.81139 -89.144173 17.147499 
  -89.142776 17.48333 -89.142441 17.81868) 
#(23.999559 19.497761 23.999439 18.966379 23.99971 15.69944) 
#(-88.313889 15.67138 -88.213058 15.72305) 
#(-6.3566632 23.146021 -6.166666 21.528049 -5.9744439 19.866381 
  -5.7872219 18.186939 -5.601666 16.507771 -5.335278 16.328051 
  -5.495616 15.49846) #(-5.495616 15.49846 -5.9055562 15.50333 
  -7.626111 15.50361 -9.3336105 15.49972 -9.3194447 15.63416 
  -9.3380547 15.70472 -9.4424992 15.59694 -9.4113903 15.44389 
  -9.6966667 15.43 -9.8177776 15.37388 -10.11806 15.37277 
  -10.16445 15.40361 -10.71901 15.43814) 
#(4.245091 19.146191 4.245554 18.660549 4.2525001 16.994431 
  4.2141662 16.993601 4.2008319 16.393881 4.0744429 16.303329 
  3.9808331 16.070271 4.0008321 15.98972 3.924444 15.90416 
  3.8902769 15.71805 3.844166 15.67277 3.7224989 15.65 
  3.5377769 15.49249 3.5248179 15.35935) 
#(105.588 15.33552 105.483 15.34166 105.483 15.37694 
  105.6 15.43305 105.6344 15.59472 105.6325 15.67861 
  105.5964 15.72805 105.4269 15.77583 105.3497 15.93805 
  105.4069 15.99222 105.4119 16.0186 105.183 16.05888 
  105.0466 16.128599 105.0216 16.23638 104.9397 16.322491 
  104.7461 16.531111 104.7689 16.697491 104.753 16.887779 
  104.8094 17.19388 104.7894 17.414721 104.6664 17.54249 
  104.4444 17.673321 104.2608 17.881941 104.15 18.060829 
  103.9958 18.307501 103.95 18.330549 103.8686 18.279989 
  103.6758 18.35194 103.3972 18.43499 103.2816 18.407221 
  103.2366 18.346661 103.2825 18.29888 103.1705 18.24777 
  103.1408 18.16527 103.0901 18.137409) 
#(37.42416 17.03722 37.145538 17.01638 37.098869 17.05249 
  36.991371 17.06444 37.01804 17.003599 36.986931 16.94305 
  37.022758 16.85055 36.910542 16.63555 36.901371 16.495831 
  36.95499 16.43082 36.971371 16.26416 36.915821 16.214991 
  36.542759 15.23472 36.443859 15.15067) 
#(-12.77853 15.14678 -12.78833 15.20861 -12.84972 15.20805 
  -12.89361 15.26166 -12.84389 15.27028 -12.84583 15.30805 
  -12.9325 15.36805 -12.96472 15.50611 -13.06028 15.47916 
  -13.10028 15.50889 -13.0925 15.58333 -13.24278 15.63861 
  -13.39555 16.055269 -13.46056 16.09499 -13.49528 16.149719 
  -13.67722 16.098881 -13.71111 16.18499 -13.85166 16.11832 
  -13.87528 16.19805 -13.97361 16.237209 -13.96694 16.278049 
  -14.225 16.54777 -14.33556 16.576941 -14.33722 16.63249 
  -14.37778 16.63999 -14.86028 16.638321 -14.98111 16.69305 
  -15.04861 16.63027 -15.09778 16.67111 -15.11694 16.648331 
  -15.0875 16.614441 -15.10806 16.586109 -15.23917 16.55888 
  -15.46889 16.57972 -15.55 16.512489 -15.98583 16.48999 
  -16.146111 16.551941 -16.299999 16.503599 -16.38805 16.21999 
  -16.468889 16.18055 -16.49222 16.052219 -16.50695 16.09416 
  -16.527269 16.077959) #(-10.89882 15.10682 -10.82722 15.27555 
  -10.7625 15.31277 -10.71901 15.43814) 
#(-10.89882 15.10682 -10.9225 15.13833 -11.1725 15.37472 
  -11.42083 15.63583 -11.51222 15.64666 -11.64222 15.52416 
  -11.71083 15.54778) #(51.999149 18.99888 47.461941 17.57415 
  45.59082 15.10555) #(45.59082 15.10555 44.498871 17.395821) 
#(-90.446663 16.075001 -90.679443 16.07555 -91.029167 16.07555 
  -91.37944 16.075821 -91.729172 16.074989 -91.805557 15.94722 
  -92.009171 15.60472 -92.211403 15.26222 -92.065826 15.07777) 
#(-89.150833 15.07361 -89.008904 15.12527 -88.668327 15.35 
  -88.327789 15.63528 -88.313889 15.67138) 
#(3.5248179 15.35935 3.0324991 15.43305 3.021944 15.37638 
  1.3125 15.28666 0.97472191 14.97861 0.74249983 14.96749 
  0.69499987 14.94222 0.51222217 15.00083 0.39666659 14.96055 
  0.22639389 15.00076) #(0.2345342 14.91561 0.22639389 15.00076) 
#(-12.77853 15.14678 -12.47889 15.00889 -12.43083 14.88778 
  -12.24575 14.77217) #(-12.05762 14.72555 -11.97444 14.77111 
  -11.80417 14.90805 -11.80278 15.04861 -11.845 15.05916 
  -11.71083 15.54778) #(-12.24575 14.77217 -12.23083 14.76194 
  -12.13695 14.77777 -12.05762 14.72555) 
#(107.5459 14.70496 107.5136 14.80361 107.5458 14.83694 
  107.5847 14.89944 107.478 14.97361 107.4797 15.03778 
  107.58 15.04416 107.6952 15.27083 107.62 15.34277 
  107.4591 15.51111 107.2616 15.65027 107.2536 15.72639 
  107.1877 15.75944 107.175 15.795 107.2066 15.86139 
  107.3983 15.91389 107.4666 16.00889 107.4605 16.082491 
  107.3341 16.05694 107.1544 16.197769 107.1489 16.26083 
  107.0911 16.301941 106.9891 16.29777 106.9072 16.39249 
  106.8983 16.449989 106.8852 16.53249 106.848 16.53722 
  106.7842 16.45356) #(-92.065826 15.07777 -92.150833 14.97027 
  -92.186111 14.84361 -92.166397 14.77277 -92.18721 14.58833 
  -92.245941 14.54808) #(106.5417 14.59898 106.4333 14.52333 
  106.4383 14.4875 106.3324 14.44532) 
#(-89.354874 14.42769 -89.299438 14.515 -89.154449 14.5825 
  -89.144447 14.64861 -89.224716 14.86805 -89.154167 14.98138 
  -89.181381 15.00333 -89.150833 15.07361) 
#(-12.24575 14.77217 -12.14778 14.63944 -12.17861 14.6075 
  -12.2025 14.40083) #(105.2104 14.35256 105.4419 14.43222 
  105.5378 14.57777 105.5214 14.79 105.6191 14.99166 
  105.4689 15.125 105.4936 15.20527 105.5964 15.27472 
  105.588 15.33552) #(-89.037216 14.33472 -89.126099 14.32555 
  -89.354874 14.42769) #(107.5459 14.70496 107.5294 14.69361 
  107.4541 14.55777 107.4225 14.54555 107.3266 14.60694 
  107.2961 14.59861 107.278 14.55972 107.1089 14.40111 
  107.0502 14.44305 106.9975 14.36388 106.8383 14.3125 
  106.7336 14.4425 106.6277 14.46694 106.5417 14.59898) 
#(-89.553452 14.28625 -89.590286 14.32194 -89.573334 14.41333 
  -89.542221 14.42027 -89.526947 14.38638 -89.396118 14.45166 
  -89.354874 14.42769) #(-89.553452 14.28625 -89.575012 14.27722 
  -89.492706 14.24125) #(-88.83139 14.11416 -88.908623 14.20722 
  -88.954727 14.18833 -89.037216 14.33472) 
#(105.7324 14.11149 105.5983 14.15166 105.5172 14.14083 
  105.3641 14.10944 105.21 14.28444 105.2104 14.35256) 
#(-89.854599 14.05946 -89.737778 14.04361 -89.743057 14.08389 
  -89.646118 14.19972 -89.492706 14.24125) 
#(-88.661438 14.01413 -88.72139 14.0975 -88.767227 14.13778 
  -88.809433 14.09305 -88.83139 14.11416) 
#(105.8492 14.00722 105.7324 14.11149) 
#(105.857 14.00024 105.8492 14.00722) 
#(15.48861 16.90027 14.36889 15.73388 13.85916 15.03778 
  13.76722 14.84805 13.79416 14.73277 13.66083 14.64583 
  13.68416 14.5725 13.66528 14.54194 13.47555 14.46833 
  13.46222 14.42805 13.56238 13.99192) 
#(107.4743 13.93001 107.4455 14.005 107.3852 14.00278 
  107.368 14.03389 107.3839 14.26083 107.4161 14.42944 
  107.4783 14.43083 107.5355 14.55694 107.5459 14.70496) 
#(106.3324 14.44532 106.2511 14.49333 106.2469 14.44639 
  106.2097 14.37555 106.0283 14.36027 105.9939 14.34333 
  106.0416 14.22472 106.1019 14.18666 106.1744 14.05028 
  106.0919 13.92 105.9391 13.92694 105.857 14.00024) 
#(-87.900284 13.89805 -88.006958 13.86944 -88.040833 13.93055) 
#(-88.353058 13.86833 -88.196663 13.98777 -88.059998 13.96389 
  -88.040833 13.93055) #(-88.353058 13.86833 -88.489166 13.86555 
  -88.50473 13.98138 -88.661438 14.01413) 
#(-87.900284 13.89805 -87.878601 13.90194 -87.750473 13.86406) 
#(-83.130867 14.99329 -83.176941 14.98972 -83.390839 15.02472 
  -83.417503 14.99111 -83.506958 15.01278 -83.531113 14.94972 
  -83.718887 14.86833 -83.843887 14.785 -83.921387 14.79944 
  -83.932503 14.7525 -84.118057 14.78416 -84.103333 14.72888 
  -84.196663 14.71638 -84.237213 14.76333 -84.267776 14.74472 
  -84.275284 14.665 -84.325562 14.67361 -84.449158 14.62778 
  -84.68222 14.68555 -84.818619 14.82778 -85.025833 14.70055 
  -85.032784 14.57361 -85.08667 14.54333 -85.11528 14.56667 
  -85.175827 14.445 -85.155838 14.34027 -85.179169 14.31528 
  -85.315002 14.28111 -85.388062 14.20555 -85.468338 14.10805 
  -85.52417 14.05528 -85.732773 13.95778 -85.736656 13.82861) 
#(-85.736656 13.82861 -85.800827 13.83916 -85.853882 13.91416 
  -85.909157 13.90694 -86.022507 14.00305 -86.015839 14.06583 
  -86.088333 14.04444) #(107.4624 13.79621 107.4743 13.93001) 
#(-90.095093 13.74547 -90.105827 13.83583 -90.037514 13.90027 
  -89.854599 14.05946) #(13.56238 13.99192 13.62524 13.71821) 
#(13.62524 13.71821 13.34778 13.72) 
#(-86.088333 14.04444 -86.175827 13.97083 -86.313049 13.77083 
  -86.354172 13.75805 -86.530563 13.7925 -86.761124 13.75278 
  -86.763474 13.71084) #(-12.08259 13.70828 -11.95278 13.80833 
  -11.9425 13.90444 -12.015 14.0125 -11.98083 14.16722 
  -12.03111 14.27888 -12.09833 14.30444 -12.09889 14.36666 
  -12.2025 14.40083) #(13.34778 13.72 13.32361 13.67944) 
#(0.2345342 14.91561 -0.24611109 15.07805 -0.38611111 15.00555 
  -0.44388881 15.08305 -0.72500002 15.08305 -1.073889 14.7775 
  -1.318889 14.72888 -1.678333 14.50055 -1.9808331 14.475 
  -2.0069449 14.18805 -2.1077781 14.15139 -2.4727769 14.28889 
  -2.833333 14.04139 -2.884445 13.87749 -2.9041669 13.72166 
  -2.8786111 13.65611 -2.962224 13.62583) 
#(-2.962224 13.62583 -3.0494449 13.6125 -3.0708339 13.66083 
  -3.1901929 13.6789) #(13.76189 13.52478 13.62524 13.71821) 
#(-87.714447 13.47055 -87.783333 13.52639 -87.695267 13.81805 
  -87.750473 13.86406) #(-13.86906 13.50849 -13.91417 13.56667 
  -13.98778 13.5825 -14.33778 13.45388 -14.43528 13.50972 
  -14.51195 13.63444 -14.59917 13.67027 -14.64917 13.66222 
  -14.71889 13.61194 -14.79195 13.65333 -14.81639 13.74111 
  -14.86389 13.78416 -15.07055 13.82638 -15.25167 13.74472 
  -15.315 13.79528 -15.36472 13.78139 -15.45861 13.70444 
  -15.48889 13.58944 -16.569269 13.59005) 
#(-87.814499 13.40747 -87.714447 13.47055) 
#(97.698853 17.82888 97.793854 17.68416 97.911636 17.58139 
  98.028847 17.464161 98.108017 17.38221 98.346077 17.045549 
  98.423576 17.053329 98.511093 16.941099 98.517197 16.863609 
  98.546631 16.80777 98.491348 16.77389 98.479424 16.729719 
  98.617188 16.51861 98.689682 16.28499 98.715813 16.276381 
  98.864967 16.47666 98.928299 16.37916 98.860237 16.17083 
  98.814972 16.103609 98.774406 16.123329 98.571373 16.046101 
  98.617462 15.97 98.565247 15.72278 98.593582 15.41694 
  98.558853 15.33 98.503593 15.38722 98.42247 15.35999 
  98.413589 15.26 98.310242 15.30305 98.200256 15.21555 
  98.264137 14.80694 98.447739 14.60583 98.571373 14.38194 
  98.669693 14.29972 98.759697 14.2175 98.93718 14.10222 
  99.180527 13.7125 99.213654 13.33534) 
#(13.90318 13.32478 13.76189 13.52478) 
#(-3.1901929 13.6789 -3.248889 13.71999 -3.271111 13.70166 
  -3.2325001 13.28805 -3.441118 13.27585) 
#(-86.763474 13.71084 -86.732773 13.5225 -86.732773 13.37666 
  -86.696663 13.35666 -86.696381 13.29472 -86.743057 13.26083 
  -86.827789 13.29667 -86.909729 13.24111) 
#(14.07499 13.08159 13.90318 13.32478) 
#(13.32361 13.67944 13.25139 13.58888 12.96861 13.51278 
  12.8625 13.45028 12.67055 13.27806 12.62916 13.30055 
  12.47805 13.05666 12.37361 13.07333 12.245 13.11027 
  12.14693 13.10119) #(-16.77482 13.03709 -16.70055 13.16139 
  -15.80944 13.16 -15.80889 13.34889 -15.5675 13.36111 
  -15.50528 13.39833 -15.36 13.36722 -15.25945 13.38556 
  -15.21278 13.42972 -15.19695 13.535 -15.11139 13.59583 
  -14.95444 13.4725 -14.85056 13.45388 -14.72806 13.36889 
  -14.64778 13.34444 -14.57361 13.36305 -14.37833 13.245 
  -14.2975 13.24111 -13.84972 13.33361 -13.79861 13.40027 
  -13.80833 13.45305 -13.86906 13.50849) 
#(-87.063606 13.00028 -86.952499 13.04167 -86.909729 13.24111) 
#(8.4330273 13.06478 8.1222172 13.30361 7.8149981 13.35278 
  7.3797202 13.09972 7.2188869 13.12555 7.0905552 12.99527 
  6.933332 12.99722 6.8063879 13.10805 6.6791658 13.34389 
  6.4230552 13.60527 6.2849989 13.68389 6.2380528 13.68333 
  6.1608319 13.64305 5.547473 13.89313) 
#(-87.063606 13.00028 -87.30014 12.98741) 
#(92.876999 12.90509 92.792862 12.90233) 
#(14.07499 13.08159 14.44305 13.08472 14.52611 12.96999 
  14.50805 12.8775 14.52012 12.86465) 
#(14.52012 12.86465 14.55458 12.82794) 
#(21.828251 12.80389 21.97249 13.0875 22.07999 13.15333 
  22.22888 13.27639 22.295271 13.37778 22.217211 13.58472 
  22.153601 13.63444 22.138599 13.72805 22.08444 13.77916 
  22.233879 13.96583 22.47694 14.10083 22.55249 14.12083 
  22.56694 14.16416 22.555269 14.23194 22.456659 14.25222 
  22.440269 14.28222 22.44194 14.48944 22.38138 14.52305 
  22.384159 14.55416 22.4161 14.60027 22.70249 14.69139 
  22.66888 14.85416 22.75333 14.97694 22.86832 15.09444 
  22.935829 15.11611 22.984711 15.23111 22.99527 15.38583 
  22.919439 15.50972 22.937771 15.5625 23.11832 15.71055 
  23.38138 15.68527 23.47916 15.72611 23.68527 15.75611 
  23.99971 15.69944) #(12.14693 13.10119 11.86722 13.24972 
  11.44638 13.37639 11.03833 13.36027 10.84111 13.38611 
  10.14833 13.25972 9.9299955 13.13305 9.6352749 12.80277 
  8.9849968 12.84666 8.6636086 12.94333 8.5544415 13.06667 
  8.4974957 13.08583 8.4330273 13.06478) 
#(36.443859 15.15067 36.544708 14.26083 36.446369 13.95694 
  36.486931 13.83944 36.39748 13.56778 36.2486 13.36805 
  36.155258 13.02444 36.141602 12.70686) 
#(14.18351 12.46948 14.07499 13.08159) 
#(-12.08259 13.70828 -12.05445 13.66055 -11.86806 13.4575 
  -11.88528 13.375 -11.79833 13.31278 -11.75694 13.37305 
  -11.71972 13.41278 -11.59778 13.36472 -11.52778 13.13778 
  -11.43472 13.07611 -11.42 12.95944 -11.37806 12.98805 
  -11.36806 12.92889 -11.41222 12.91611 -11.38333 12.72666 
  -11.42861 12.71389 -11.4225 12.62361 -11.45194 12.55055 
  -11.35833 12.46749) #(104.5319 12.45583 104.5247 12.48833 
  104.5814 12.49278 104.4983 12.52555 104.44 12.54528 
  104.4778 12.68444 104.4472 12.73611 104.3941 12.76056 
  104.2841 12.73278 104.2203 12.75472 104.1578 12.91722 
  104.0216 13.16722 103.7355 13.26243 103.6872 13.22389 
  103.7064 13.15055 103.8036 12.915 103.8416 12.90722 
  103.8422 12.8675 104.0236 12.78222 104.0941 12.81778 
  104.1125 12.75416 104.2028 12.58139 104.3275 12.53417 
  104.4447 12.51527 104.5319 12.45583) 
#(14.18805 12.44389 14.18351 12.46948) 
#(-11.37333 12.40464 -11.35833 12.46749) 
#(-16.677811 12.33458 -16.46389 12.36111 -16.20916 12.46083 
  -15.68556 12.43 -15.40722 12.55694 -15.21833 12.68472 
  -13.92833 12.67666 -13.71255 12.66603) 
#(-13.71255 12.66603 -13.06139 12.63972 -13.04167 12.59 
  -13.06889 12.525 -13.03778 12.47305 -12.95528 12.47639 
  -12.93167 12.54111 -12.89167 12.54305 -12.84139 12.48 
  -12.63333 12.4375 -12.57278 12.35916 -12.49694 12.39667 
  -12.43639 12.38277 -12.34528 12.30139 -12.09889 12.41028 
  -11.96889 12.39139 -11.90833 12.42889 -11.84167 12.38639 
  -11.48639 12.43666 -11.37333 12.40464) 
#(-13.71255 12.66603 -13.71472 12.56889 -13.64417 12.47138 
  -13.66361 12.35166 -13.69424 12.29309) 
#(-9.3113079 12.50425 -9.3622208 12.4875 -9.3988895 12.44611 
  -9.2933331 12.35555 -9.3454437 12.2498) 
#(-8.9799395 12.22371 -8.9466667 12.35305 -9.0577774 12.43666 
  -9.3113079 12.50425) #(-13.97062 12.15323 -13.95667 12.20972 
  -13.87861 12.24555 -13.71472 12.2575 -13.69424 12.29309) 
#(14.18805 12.44389 14.17389 12.38416 14.49083 12.33583 
  14.55277 12.23222 14.65722 12.18722 14.67416 12.15083) 
#(14.55458 12.82794 14.55194 12.76361 14.715 12.71028 
  14.70722 12.65388 14.74555 12.67333 14.87555 12.44111 
  14.90166 12.14277 15.04507 12.08408) 
#(-3.441118 13.27585 -3.4233339 13.1975 -3.4413891 13.16805 
  -3.541111 13.17889 -3.791667 13.36166 -3.938611 13.37805 
  -3.966666 13.39889 -3.9024999 13.45777 -3.9641671 13.50416 
  -4.0252781 13.42611 -4.1294441 13.30639 -4.2433329 13.23444 
  -4.2188892 13.18139 -4.3125 13.16639 -4.335278 13.10999 
  -4.2055559 12.94027 -4.2072229 12.76639 -4.2691669 12.71639 
  -4.4688892 12.72583 -4.4741669 12.65778 -4.3658328 12.53333 
  -4.438055 12.43444 -4.3875008 12.31111 -4.4072232 12.29722 
  -4.456944 12.33389 -4.5694451 12.20111 -4.539444 12.13972 
  -4.6643782 12.062) #(-9.3454437 12.2498 -9.4666653 12.24861 
  -9.6674995 12.12778 -9.6725006 12.06777 -9.7611122 12.02805 
  -9.9869442 12.12083 -10.27306 12.20944 -10.32917 12.22416) 
#(-8.9799395 12.22371 -8.8994446 12.17805 -8.9041672 12.04444 
  -8.7965717 12.00806) #(-10.32917 12.22416 -10.33333 12.18527 
  -10.51111 12.11611 -10.65241 11.89351) 
#(-10.65241 11.89351 -10.89222 12.20111 -11.04528 12.20722 
  -11.15417 12.04055 -11.25389 11.99611 -11.46278 12.14028 
  -11.495 12.20611 -11.43 12.28722 -11.44111 12.36333 
  -11.37333 12.40464) #(2.843498 12.39332 2.771111 12.37749 
  2.686388 12.29028 2.645278 12.30472 2.3780551 12.24027 
  2.383611 12.16639 2.445277 12.02416 2.4705551 11.97777 
  2.3902769 11.93333 2.4099989 11.90444 2.4015629 11.88988) 
#(2.4015629 11.88988 2.0583329 12.35722 2.0777769 12.38611 
  2.2650001 12.425 2.2008319 12.63083 2.0961101 12.72555 
  1.988889 12.73111 1.871666 12.60888 1.578333 12.63 
  1.117222 13.01111 0.9891665 13.04722 0.99166638 13.37166 
  1.011667 13.37277 1.126667 13.32861 1.2175 13.36361 
  1.072222 13.44638 0.99027753 13.57027 0.77444428 13.64417 
  0.77277768 13.68833 0.62499988 13.68472 0.38499999 14.04917 
  0.4052777 14.25416 0.18944439 14.46472 0.1666667 14.52305 
  0.2413889 14.75222 0.1933333 14.83583 0.23722219 14.8875 
  0.2345342 14.91561) #(106.4713 11.86946 106.4202 11.97361 
  106.4766 11.97083 106.7303 11.97583 106.7819 12.06583 
  106.9789 12.08444 107.1669 12.27778 107.3189 12.32944 
  107.4408 12.25361 107.5489 12.35639 107.583 12.5 
  107.5677 12.80222 107.5097 12.8825 107.4958 13.00555 
  107.6364 13.38166 107.6289 13.54278 107.4624 13.79621) 
#(-5.4022231 11.83 -5.3480558 11.82527 -5.1938891 11.90528 
  -4.936388 12.00944 -4.7847219 12.00083 -4.6986098 12.06277 
  -4.6643782 12.062) #(3.558888 11.75694 3.468888 11.85583 
  3.312222 11.89 3.2538891 12.01722 3.195554 12.06388 
  2.843498 12.39332) #(5.547473 13.89313 5.3649988 13.8475 
  5.286109 13.75222 4.9236102 13.73638 4.8855548 13.78139 
  4.4699988 13.68694 4.247777 13.48138 4.142499 13.47694 
  4.1049991 12.99638 3.9527769 12.74888 3.6577771 12.52888 
  3.6716659 11.97555 3.6169441 11.91972 3.688333 11.74972 
  3.605495 11.69169) #(3.558888 11.75694 3.605495 11.69169) 
#(2.4015629 11.88988 2.3380549 11.76472 2.313859 11.67916) 
#(106.4585 11.66456 106.4236 11.7675 106.4713 11.86946) 
#(105.2104 14.35256 105.1372 14.23972 105.0694 14.21833 
  105.033 14.24777 105.0019 14.38333 104.8805 14.4225 
  104.7822 14.43055 104.715 14.43777 104.5716 14.36472 
  104.4433 14.37222 104.1875 14.38667 103.9736 14.36444 
  103.7008 14.39055 103.6958 14.44 103.6591 14.44778 
  103.5078 14.39666 103.2286 14.33278 102.958 14.20305 
  102.9197 14.10472 102.79 13.93444 102.7222 13.76361 
  102.5633 13.68139 102.5605 13.6525 102.6227 13.60694 
  102.5272 13.56778 102.3602 13.57166 102.3514 13.26722 
  102.4958 13.01194 102.525 12.76694 102.5122 12.665 
  102.5925 12.62666 102.7886 12.42472 102.7369 12.30361 
  102.7819 11.99972 102.9164 11.74277 102.9142 11.63342) 
#(37.38026 11.62666 37.586929 12.01805 37.544708 12.23778 
  37.475819 12.30583 37.31554 12.28583 37.26582 12.20277 
  37.172211 12.21389 37.14999 12.27361 37.1161 12.265 
  37.011662 12.16 36.993599 11.88361 37.156101 11.80416 
  37.21526 11.83 37.28249 11.80667 37.338871 11.69722 
  37.28471 11.66583 37.324989 11.63222 37.38026 11.62666) 
#(105.8182 11.59644 105.8214 11.62083 105.9666 11.64639 
  106.0391 11.77639 106.19 11.74916 106.4585 11.66456) 
#(1.902678 11.42858 2.019166 11.42527 2.313859 11.67916) 
#(105.8858 11.39974 105.8991 11.44805 105.8182 11.59644) 
#(-8.3596497 11.37156 -8.5141678 11.43027 -8.5341663 11.49389 
  -8.6077785 11.47583 -8.7030544 11.65889 -8.8316669 11.66166 
  -8.7965717 12.00806) #(43.12331 12.70889 42.881371 12.6275 
  42.841091 12.55528 42.81609 12.43611 42.698589 12.36389 
  42.53582 12.50416 42.456089 12.52917 42.33942 12.39694 
  41.948589 11.81667 41.82943 11.74194 41.759708 11.50528 
  41.80883 11.26637) #(36.141602 12.70686 36.069149 12.72444 
  35.699421 12.66583 35.43803 12.25056 35.432491 12.20055 
  35.386101 12.17 35.33971 12.02472 35.096931 11.82694 
  35.05859 11.74 35.08749 11.53583 34.963871 11.25694 
  34.980541 11.22222) #(41.80883 11.26637 41.812481 11.24861 
  41.79797 11.09725) #(-84.882782 11.0275 -84.765289 11.09555 
  -84.778343 11.16333 -84.871117 11.35194 -85.017792 11.53806 
  -85.172501 11.72389 -85.361389 11.87611 -85.435287 11.86639 
  -85.556953 12.02 -85.769882 12.11221 -85.875557 12.08861 
  -85.933617 11.97444 -85.881958 11.80361 -85.914459 11.71055 
  -85.872223 11.65917 -85.825287 11.55528 -85.716667 11.33555 
  -85.517227 11.20305 -85.363892 11.15361 -85.123062 11.08222 
  -84.882782 11.0275) #(43.248619 11.47285 42.943279 11.00391) 
#(0.96777761 10.99583 0.97888857 11.08027 1.102777 11.04027 
  1.063889 11.13972 1.156389 11.16278 1.132777 11.24944 
  1.1538889 11.27722 1.272778 11.25916 1.308611 11.29139 
  1.3975 11.43972 1.5 11.46416 1.609166 11.38833 
  1.766111 11.42666 1.902678 11.42858) 
#(0.91743511 10.99576 0.96777761 10.99583) 
#(41.79797 11.09725 41.787209 10.98499 41.825821 10.97083 
  42.264431 10.99249 42.63443 11.09805 42.75193 11.07666 
  42.772758 11.01639 42.814152 10.98777 42.943279 11.00391) 
#(-13.97062 12.15323 -13.89028 12.14361 -13.70667 12.00139 
  -13.70917 11.71527 -13.79167 11.68555 -13.79944 11.71472 
  -13.86111 11.74416 -13.87806 11.66916 -14.00222 11.64083 
  -14.27667 11.67889 -14.51528 11.51222 -14.69139 11.50667 
  -14.78417 11.38527 -14.85528 11.19777 -15.01974 10.96388) 
#(-8.3596497 11.37156 -8.4102783 11.33527 -8.3547211 11.32277 
  -8.3761101 11.28194 -8.4747219 11.29111 -8.5150013 11.22639 
  -8.6827774 10.99194 -8.6713886 10.955 -8.6027765 10.96416) 
#(-84.35556 10.99333 -84.444443 10.95944 -84.674438 11.07805 
  -84.902786 10.94083 -84.940552 10.95527 -85.284157 11.09139 
  -85.614441 11.21361 -85.650284 11.15166 -85.711349 11.08428) 
#(-0.1509551 11.13927 0.50694442 11.0025 0.5041666 10.93694 
  0.67166662 10.99666 0.91743511 10.99576) 
#(22.881161 10.92391 22.975269 11.21583 22.93082 11.41583 
  22.7911 11.40166 22.625549 11.53444 22.552771 11.66555 
  22.625549 12.08361 22.47666 12.03416 22.49777 12.18694 
  22.383881 12.46527 22.46693 12.62166 22.22332 12.74722 
  22.125271 12.65 21.970831 12.63972 21.900551 12.67666 
  21.828251 12.80389) #(22.76749 10.955 22.881161 10.92391) 
#(-2.8310571 11.00341 -2.230278 11.00027 -0.67972219 10.9975 
  -0.66500008 10.95472 -0.61000001 10.91722 -0.56777787 10.99222 
  -0.48888889 10.99833 -0.4230555 11.09694 -0.38194439 11.10861 
  -0.35277781 11.06889 -0.27527779 11.13 -0.28527781 11.16666 
  -0.1509551 11.13927) #(-83.64534 10.92426 -83.661667 10.87944 
  -83.677223 10.78889 -83.924438 10.70972 -83.982224 10.75611 
  -84.197769 10.78583 -84.224716 10.87805 -84.321671 10.92666 
  -84.35556 10.99333) #(-5.4022231 11.83 -5.3372221 11.80027 
  -5.2636118 11.74944 -5.289444 11.61666 -5.2147231 11.5775 
  -5.1986098 11.41889 -5.251667 11.395 -5.250834 11.24472 
  -5.2972221 11.20694 -5.2975001 11.14416 -5.3302779 11.11472 
  -5.4886112 11.07638 -5.4863882 11.03028 -5.4116669 10.835 
  -5.456389 10.74694 -5.462501 10.64555) 
#(-6.6450858 10.66679 -6.585278 10.60722 -6.4183331 10.55055 
  -6.3819442 10.59055 -6.4202781 10.62888 -6.4099998 10.69305 
  -6.2432022 10.73495) #(-5.5206599 10.43099 -5.462501 10.64555) 
#(104.4484 10.4225 104.5986 10.53416 104.8214 10.52 
  104.8905 10.54 105.0997 10.72639 105.0664 10.78139 
  105.0436 10.90139 105.1091 10.95555 105.3555 10.84666 
  105.4297 10.96611 105.4672 10.955 105.7583 11.02139 
  105.7916 11.00722 105.8702 10.85166 105.933 10.83361 
  105.9575 10.9 106.2033 10.77055 106.1458 10.91555 
  106.1552 10.97583 106.2144 10.97555 106.1591 11.09389 
  106.0747 11.10666 105.8697 11.29694 105.8858 11.39974) 
#(99.213654 13.33534 99.208588 13.20667 99.120796 13.17583 
  99.114143 13.05083 99.193573 12.96944 99.203583 12.83305 
  99.438858 12.57111 99.414413 12.45444 99.485786 12.25972 
  99.476639 12.13028 99.573303 12.13667 99.589417 11.8725 
  99.660797 11.82055 99.557457 11.62778 99.48996 11.62916 
  99.46553 11.60472 99.402763 11.38889 99.358307 11.35 
  99.077469 10.94861 99.020248 10.96333 99.003311 10.82861 
  98.85553 10.76722 98.781921 10.66666 98.823868 10.51667 
  98.742554 10.34643) #(-6.6450858 10.66679 -6.6766658 10.59833 
  -6.6380558 10.40944 -6.689455 10.3395) 
#(-0.1509551 11.13927 -0.1338889 11.11139 -0.02111111 11.10361 
  0.03444444 11.075 0.032499999 10.98972 -0.071388893 10.73777 
  -0.068333343 10.63389 0.045833331 10.58611 0.1963888 10.39778 
  0.28638881 10.41389 0.3208333 10.33055 0.39333329 10.30833 
  0.38324001 10.27363) #(-6.2432022 10.73495 -6.188889 10.63027 
  -6.2466669 10.51639 -6.210279 10.50972 -6.1683331 10.35861 
  -6.2269449 10.31416 -6.2232499 10.25848) 
#(-6.2232499 10.25848 -6.1930552 10.23388 -6.0625 10.19111 
  -5.9833331 10.20861 -5.956111 10.28444 -5.8894439 10.27583 
  -5.878056 10.37555 -5.6502781 10.45111 -5.5206599 10.43099) 
#(-7.9776812 10.16547 -7.940556 10.24333 -7.9850001 10.33777 
  -8.0938892 10.35638 -8.122221 10.43722 -8.2155552 10.42166 
  -8.2822227 10.54944 -8.2897224 11.00777 -8.3511105 11.05722 
  -8.4888878 11.05889 -8.5441666 10.97527 -8.6027765 10.96416) 
#(-7.9776812 10.16547 -7.8852782 10.17666 -7.6997209 10.40639 
  -7.5347219 10.41972 -7.500278 10.46139 -7.4566669 10.45083 
  -7.4308329 10.33777 -7.3600001 10.35083 -7.3458338 10.25027 
  -7.269722 10.25444 -7.0105562 10.14194 -6.9499998 10.17194 
  -6.9461112 10.21472 -6.982223 10.25361 -6.9438891 10.35305 
  -6.7761121 10.37749 -6.689455 10.3395) 
#(-8.1333332 10.01055 -8.0091667 10.09944 -7.9776812 10.16547) 
#(15.04507 12.08408 15.05361 12.03305 15.05166 11.945 
  15.11111 11.78139 15.06277 11.68167 15.14 11.525 
  15.10555 11.48972 15.0175 11.18611 15.07861 10.88944 
  15.05666 10.80555 15.08722 10.74722 15.13972 10.51916 
  15.38778 10.22861 15.67887 9.9924259) 
#(-4.310833 9.5983295 -4.376945 9.5824966 -4.4263892 9.6574974 
  -4.5091672 9.6544418 -4.5086122 9.7113857 -4.5327778 9.7466621 
  -4.5713892 9.6869411 -4.602222 9.721384 -4.685555 9.6752739 
  -4.7422218 9.7502747 -4.7752781 9.7366619 -4.7802782 9.7908306 
  -4.8600001 9.8749962 -4.9283328 9.8680515 -4.9744439 9.9052753 
  -4.9499998 9.9486055 -4.98 10.05361 -5.1300001 10.30472 
  -5.1750002 10.28944 -5.208055 10.3225 -5.3225002 10.29916 
  -5.4113889 10.30111 -5.5206599 10.43099) 
#(-82.87532 9.5563335 -82.833214 9.4981861) 
#(-8.1333332 10.01055 -8.1605568 9.9441624 -8.1047211 9.867218 
  -8.1158333 9.803051 -8.1381817 9.4978828) 
#(-82.565193 9.5697861 -82.615547 9.4897165 -82.727493 9.5588856 
  -82.843338 9.6083298 -82.87532 9.5563335) 
#(-2.6868529 9.482336 -2.794445 9.7358284 -2.738611 9.826107 
  -2.7963891 10.05777 -2.7547231 10.265 -2.843611 10.32638 
  -2.768611 10.41666 -2.8577781 10.45722 -2.9324999 10.63 
  -2.8802781 10.80416 -2.8310571 11.00341) 
#(0.2290142 9.4322796 0.221111 9.4727726 0.27500001 9.4805508 
  0.29722211 9.5097198 0.2230555 9.5286083 0.2330555 9.5722179 
  0.34861109 9.5644417 0.37638879 9.5905514 0.3491666 9.6116619 
  0.28527769 9.5911064 0.25305551 9.6536083 0.2752777 9.6799955 
  0.33583331 9.6497192 0.3494443 9.6922188 0.32249999 9.7291622 
  0.36805549 10.0275 0.3994444 10.06111 0.34972209 10.11527 
  0.38324001 10.27363) #(-4.310833 9.5983295 -4.2872219 9.6902733 
  -4.121666 9.8299961 -4.040833 9.7994404 -3.7650001 9.930275 
  -3.2969451 9.9008293 -3.302778 9.8580513 -3.259167 9.8480511 
  -3.1911111 9.9238853 -3.1794441 9.8399963 -3.1175001 9.8291626 
  -3.065556 9.7249966 -2.989723 9.7277737 -2.948611 9.6511078 
  -2.791111 9.4133301 -2.7449999 9.3963852 -2.6868529 9.482336) 
#(12.84893 9.3600788 13.05278 9.5083313 13.15639 9.515831 
  13.22111 9.555275 13.25139 9.6769409 13.22833 9.9097195 
  13.26555 9.9849949 13.24389 10.03166 13.26639 10.08611 
  13.39805 10.11111 13.47055 10.19166 13.45861 10.23888 
  13.57833 10.6825 13.6375 10.75583 13.88666 11.17055 
  14.00916 11.28333 14.15805 11.23361 14.19583 11.25083 
  14.61777 11.50555 14.64639 11.57583 14.64111 11.64694 
  14.55833 11.71527 14.64944 11.915 14.61916 12.03555 
  14.67416 12.15083) #(-12.90091 9.2704659 -12.84417 9.2822189 
  -12.78806 9.327219 -12.70472 9.3991642 -12.58361 9.6622181 
  -12.51945 9.7108288 -12.50333 9.8622169) 
#(-71.324799 11.85264 -71.40361 11.81278 -71.977219 11.665 
  -72.265007 11.1525 -72.341377 11.165 -72.493057 11.12111 
  -72.584442 10.93722 -72.847229 10.52305 -72.978882 9.988884 
  -72.962509 9.8369408 -73.09584 9.5816631 -73.383904 9.1897202 
  -73.371933 9.1669407 -73.318413 9.1737165) 
#(-82.833214 9.4981861 -82.934723 9.4716635 -82.934158 9.3983307 
  -82.929466 9.0620708) #(-12.50333 9.8622169 -12.23556 9.9388847 
  -12.13194 9.8749962 -11.89333 9.931385 -11.895 9.9961071 
  -11.21472 9.9974957 -10.93639 9.6583309 -10.82861 9.4333305 
  -10.74833 9.3877754 -10.65667 9.2949963 -10.72694 9.1811085 
  -10.73389 9.0799961 -10.57125 9.057003) 
#(3.605495 11.69169 3.474999 11.42972 3.6941659 11.135 
  3.739166 11.11666 3.7538891 10.79444 3.8466661 10.70305 
  3.855 10.585 3.789444 10.40277 3.6888881 10.44972 
  3.6372221 10.41166 3.581944 10.27527 3.684444 10.15111 
  3.6094439 9.9480515 3.5252769 9.844162 3.3466661 9.8091621 
  3.331111 9.7558308 3.363333 9.6819401 3.3172221 9.6361084 
  3.2633331 9.6358299 3.1416659 9.4411068 3.1702781 9.2744408 
  3.0949991 9.0905514 2.9875 9.0611076 2.7883329 9.054163) 
#(-13.29843 9.0384521 -13.1875 9.0869408 -13.09583 9.0458298 
  -13.0075 9.1036072 -12.96083 9.2344398 -12.93056 9.2888851 
  -12.90091 9.2704659) #(42.943279 11.00391 42.665531 10.62138 
  42.7122 10.53194 42.786098 10.45555 42.816929 10.31388 
  43.091648 9.9183292 43.216091 9.8813839 43.278042 9.641386 
  43.341091 9.6080513 43.43082 9.4261074 43.58305 9.3361073 
  43.627201 9.3544407 44.01054 9.0072193) 
#(18.884081 8.8350372 18.92944 8.9205513 19.10944 9.0136089 
  19.38888 8.9972172 19.86499 9.0469418 20.06749 9.1352749 
  20.32888 9.1044407 20.455549 9.157774 20.50194 9.2805519 
  20.66777 9.2983303 20.659161 9.3427734 20.706659 9.3641624 
  20.95332 9.5899963 20.996941 9.6852741 21.26944 9.9811077 
  21.34222 9.9586067 21.408331 10.00694 21.477209 10.15111 
  21.67388 10.24277 21.71888 10.3325 21.700821 10.52694 
  21.723881 10.64194 22.00388 10.73472 22.014999 10.80777 
  22.063881 10.83416 22.184441 10.81889 22.201929 10.87027 
  22.466101 11.00139 22.76749 10.955) 
#(-2.584651 8.7815266 -2.655833 9.013052 -2.773056 9.055275 
  -2.6624999 9.2691631 -2.7161109 9.3116627 -2.668056 9.3827724 
  -2.6868529 9.482336) #(14.03305 8.7011089 14.06389 8.7583313 
  13.99571 8.8418655 13.97 8.8294411 14.06056 8.8838863 
  13.96389 8.889719 13.90166 8.9627743 13.75694 8.9841633 
  13.70472 9.0602741 13.66889 8.9055519 13.72694 8.9469414 
  13.73972 8.8983307 13.79222 8.9255524 13.79555 8.8308296 
  13.74611 8.8094435 13.80861 8.7738857 13.86361 8.8761082 
  13.88055 8.7697201 13.98611 8.7941647 13.96361 8.7386074 
  13.99611 8.7047195 14.01639 8.763052 14.03305 8.7011089) 
#(18.884081 8.8350372 19.12582 8.6727734 19.06221 8.5769405) 
#(-10.26652 8.4887009 -10.24889 8.4877739 -10.16222 8.5322189 
  -10.05667 8.5047188 -10.06361 8.4347191 -10.04528 8.4213848 
  -9.9522228 8.4822178 -9.8377781 8.4919395 -9.7737083 8.5696774) 
#(-7.647985 8.3797588 -7.6747222 8.6208286 -7.794723 8.7569408 
  -7.9144449 8.7672195 -7.956389 8.8011074 -7.936666 8.9330521 
  -7.895 9.0216637 -7.7369442 9.072773 -7.7422218 9.0997181 
  -7.9083338 9.1827736 -7.9208341 9.2177734 -7.8597221 9.3752728 
  -7.8619442 9.4238853 -7.9705548 9.3874969 -8.0513897 9.3974972 
  -8.1381817 9.4978828) #(-7.647985 8.3797588 -7.74861 8.3763847 
  -7.7649999 8.4222183 -7.8247218 8.4861069 -7.8305559 8.4358292 
  -7.8800001 8.4283295 -7.935277 8.4977741 -8.1983337 8.4966621 
  -8.2422943 8.4426594) #(34.980541 11.22222 35.00555 11.17444 
  34.933319 10.95666 34.975262 10.86444 34.773319 10.68694 
  34.76638 10.75305 34.594429 10.88778 34.439701 10.78444 
  34.286098 10.55416 34.348869 10.245 34.336369 10.18222 
  34.231369 10.03028 34.085819 9.553051 34.134991 8.9552746 
  34.111931 8.5652733 33.974701 8.4388847 33.82304 8.4141636 
  33.774971 8.3658886) #(33.20443 8.4338856 33.63998 8.4641628 
  33.701649 8.3805504 33.774971 8.3658886) 
#(-10.70127 8.2757549 -10.65222 8.3380508 -10.54944 8.3102741 
  -10.48583 8.3549957 -10.38611 8.4949951 -10.26652 8.4887009) 
#(-10.70127 8.2757549 -10.65028 8.4349957 -10.58972 8.5716629 
  -10.50028 8.6249962 -10.46722 8.6841621 -10.53028 8.7513866 
  -10.59528 8.8894405 -10.57125 9.057003) 
#(-59.989052 8.5335979 -59.801392 8.2749977 -59.831951 8.2288837 
  -59.94445 8.2102737) #(24.85508 8.1697407 24.80444 8.1927757 
  24.53499 8.2080517 24.45999 8.2713852 24.35083 8.2491627 
  24.177219 8.3161068 24.14027 8.3758278 24.165819 8.4777737 
  24.269159 8.5830517 24.25333 8.6911068 24.23082 8.6972179 
  23.517771 8.7141647 23.50416 8.8013859 23.581659 8.9061069 
  23.58305 8.9886074 23.565269 9.0052757 23.52861 8.9574966 
  23.48527 8.9688854 23.448601 9.0249977 23.492769 9.1741638 
  23.65221 9.2799969 23.626101 9.5461082 23.69471 9.6716633 
  23.669161 9.8669395 23.303881 10.45916 23.009439 10.69861 
  22.881161 10.92391) #(-82.896667 8.0267086 -82.930832 8.2547188 
  -82.96666 8.2747211 -83.031677 8.3369408 -82.830566 8.4738846 
  -82.82695 8.5758305 -82.915283 8.7452736 -82.88501 8.7847214 
  -82.748611 8.8872185 -82.719162 8.9402733 -82.855827 9.0458298 
  -82.929466 9.0620708) #(47.011929 8.0011101 47.989429 8.0030518) 
#(44.01054 9.0072193 45.343319 8.5641632 47.011929 8.0011101) 
#(17.708469 7.9849792 17.8836 7.9583321 18.046101 8.0166655 
  18.588881 8.0402737 18.62499 8.0672188 18.63666 8.1458302 
  18.686661 8.2141628 18.809441 8.2608299 19.06221 8.5769405) 
#(2.6821289 7.893651 2.725832 8.0830517 2.7558329 8.5880508 
  2.7883329 9.054163) #(-59.94445 8.2102737 -60.023331 8.0413857 
  -60.178051 7.9813871 -60.340939 7.8460422) 
#(-10.26652 8.4887009 -10.29445 8.3658295 -10.29722 8.1983299 
  -10.35555 8.1463852 -10.49806 8.136385 -10.60333 8.0305519 
  -10.60044 7.7731638) #(15.67887 9.9924259 15.42222 9.9269409 
  15.23277 9.9877739 15.03139 9.9463844 14.92027 9.9716635 
  14.77639 9.9211082 14.45833 9.9988842 14.19055 9.9816628 
  14.10861 9.8113861 14.01 9.7299957 13.96027 9.6344414 
  14.4175 9.1341629 14.82472 8.8111076 14.85277 8.8177738 
  15.19277 8.4972172 15.25805 8.3516617 15.44666 7.8774981 
  15.50361 7.7741652 15.58 7.7583318) 
#(-9.7737083 8.5696774 -9.7066669 8.4327736 -9.6941662 8.4877739 
  -9.6625004 8.4891624 -9.6274986 8.4555511 -9.6561108 8.389719 
  -9.5819445 8.4138851 -9.4844437 8.346384 -9.5172234 8.2427731 
  -9.4913883 8.1752739 -9.4627781 8.1338863 -9.4283333 8.0583305 
  -9.4102783 8.032774 -9.4361115 7.931942 -9.3552017 7.7435918) 
#(16.56444 7.8733311 16.403601 7.7799988 16.40447 7.6788449) 
#(-8.6705465 7.6966629 -8.5572224 7.6916652 -8.5561104 7.618608 
  -8.468956 7.5598731) #(17.708469 7.9849792 17.39138 7.8777752 
  17.165819 7.728054 16.946659 7.6452761 16.817419 7.5459709) 
#(16.56444 7.8733311 16.56333 7.8149981 16.62916 7.7566652 
  16.62999 7.6769428 16.817419 7.5459709) 
#(-8.468956 7.5598731 -8.399168 7.618608 -8.2122211 7.5449982 
  -8.1866655 7.5913868 -8.0499992 8.0319405 -7.9483328 8.0186081 
  -7.9691672 8.0663853 -7.9886112 8.1916637 -8.0727768 8.1638851 
  -8.251112 8.2522202 -8.2211113 8.3563843 -8.2422943 8.4426594) 
#(15.58 7.7583318 15.58416 7.6866651 15.4991 7.5264311) 
#(15.4991 7.5264311 15.51861 7.518332 15.68916 7.5238881 
  15.78277 7.4577761 16.251381 7.6372199 16.40447 7.6788449) 
#(-9.484417 7.363657 -9.4225006 7.4249978 -9.3900013 7.3886099 
  -9.3050575 7.4163718) #(-9.484417 7.363657 -9.4133339 7.4894419 
  -9.3552017 7.7435918) #(-77.88913 7.2277222 -77.811111 7.4799991 
  -77.745003 7.4874978 -77.720551 7.5480542 -77.758621 7.6255531 
  -77.754997 7.7099981 -77.735283 7.724165 -77.662216 7.6777749 
  -77.606377 7.5494418 -77.573898 7.5252762 -77.438599 7.6227751 
  -77.325012 7.7208319 -77.371933 7.7861099 -77.291946 7.9077759 
  -77.146667 7.9458308 -77.221657 8.1022186 -77.363892 8.2869415 
  -77.373894 8.3963852 -77.420273 8.4705505 -77.478607 8.4797173 
  -77.366127 8.6761703) #(-9.1109104 7.1939411 -8.9286118 7.288054 
  -8.9041672 7.2536101 -8.8394432 7.3002758 -8.7080545 7.518332 
  -8.7230549 7.5722208 -8.6705465 7.6966629) 
#(-9.3050575 7.4163718 -9.2041664 7.3813872 -9.1980553 7.3124981 
  -9.0977783 7.2324982 -9.1109104 7.1939411) 
#(-73.318413 9.1737165 -73.001404 9.302496 -72.98111 9.2608299 
  -72.973618 9.1424961 -72.926941 9.0983295 -72.845284 9.140274 
  -72.772232 9.1130505 -72.664436 8.6411076 -72.384171 8.3630505 
  -72.335564 8.1463852 -72.333618 8.0494404 -72.402496 8.0419407 
  -72.420273 7.9899979 -72.471657 7.4919419 -72.39917 7.4061089 
  -72.183319 7.3827748 -72.145554 7.1986079 -72.065552 7.0616651) 
#(1.548611 6.995275 1.6425 6.995553 1.644444 7.265554 
  1.634722 8.3577728 1.613055 8.3747177 1.660833 8.4969406 
  1.624722 8.5480518 1.627777 8.8811073 1.5963891 9.1169395 
  1.473611 9.2563858 1.3375 9.5424957 1.368333 9.5966635 
  1.355 9.9952736 0.77666658 10.37666 0.78527772 10.52444 
  0.91743511 10.99576) #(-70.119164 6.975831 -70.307503 6.9397202 
  -70.513062 7.0152769 -70.569458 7.0902772 -70.824173 7.0849981 
  -70.963058 7.0027761 -71.132217 6.995275 -71.553047 7.0447211 
  -71.880829 6.9852748 -72.065552 7.0616651) 
#(-60.340939 7.8460422 -60.535278 7.8022199 -60.632771 7.60111 
  -60.693611 7.5661092 -60.71973 7.5288868 -60.691109 7.455832 
  -60.64584 7.4366651 -60.588051 7.3163862 -60.634449 7.2580538 
  -60.617771 7.1944418 -60.535561 7.1238871 -60.495281 7.181109 
  -60.35778 7.1755528 -60.278339 7.1124992 -60.33139 7.0241652 
  -60.368061 6.9302759) #(-11.4987 6.913198 -11.33778 7.0927758 
  -11.35583 7.1469431 -11.2775 7.224442 -11.09889 7.3872199 
  -10.90417 7.5091648 -10.68472 7.744442 -10.60044 7.7731638) 
#(0.2290142 9.4322796 0.28777769 9.4213848 0.3644444 9.4897165 
  0.4627777 9.4883289 0.5488888 9.4149971 0.55194438 9.3611069 
  0.44805539 9.0199966 0.51444417 8.9119415 0.48249999 8.7916641 
  0.38999999 8.7874966 0.38305539 8.7622185 0.47249991 8.5927734 
  0.63388878 8.491663 0.67416662 8.4055519 0.72694433 8.284996 
  0.58888882 8.1974964 0.6269443 7.769165 0.5872221 7.6941638 
  0.58194429 7.620831 0.52111101 7.5858321 0.51055551 7.4605541 
  0.57027769 7.3852758 0.64666659 7.3999991 0.66583318 7.3036089 
  0.60805541 7.0144429 0.51388878 6.9708319 0.56388873 6.9174981 
  0.52916658 6.8258309) #(10.59611 7.1341648 10.62 7.0536089 
  10.85416 6.9469419 10.88277 6.827776 10.94333 6.7780542 
  11.01916 6.7786088) #(-60.368061 6.9302759 -60.408329 6.9474978 
  -60.713058 6.7580538 -60.909439 6.809164 -60.896111 6.7597208 
  -61.13805 6.701942) #(33.20443 8.4338856 33.1647 8.3913879 
  33.184711 8.1288834 33.104988 8.0930519 32.989429 7.9255528 
  33.013599 7.8469429 33.059711 7.7899981 33.169979 7.7963872 
  33.33749 7.7124991 33.441368 7.745831 33.498322 7.7222199 
  33.65554 7.683053 34.026932 7.3866649 34.02943 7.2391639 
  34.185539 7.164721 34.20665 7.0491648 34.476089 6.911387 
  34.507488 6.8002758 34.687481 6.6949978 34.759991 6.6097212) 
#(0.68370593 6.587327 0.57111102 6.8133321 0.52916658 6.8258309) 
#(-8.6066666 6.5077758 -8.5061111 6.5941648 -8.3583336 6.7541661 
  -8.2880554 7.180831 -8.3613892 7.2394419 -8.4183331 7.5011101 
  -8.468956 7.5598731) #(-8.6066666 6.5077758 -8.4752769 6.4358311 
  -8.4547215 6.4899979 -8.3819427 6.4424968) 
#(11.01916 6.7786088 11.08222 6.6977758 11.07333 6.5911088 
  11.11694 6.4441638 11.15472 6.433331 11.38889 6.4602771 
  11.445 6.5969429 11.51472 6.6041651 11.5625 6.6674981 
  11.58777 6.785275 11.55472 6.8211098 11.5875 6.89222 
  11.79139 7.0508308 11.88666 7.078054 11.89416 7.123054 
  11.74972 7.2705541 11.86 7.4022212 12.04361 7.577776 
  12.04361 7.7397199 12.22277 7.97472 12.24722 8.3938866 
  12.27527 8.4283295 12.35333 8.430275 12.42166 8.5186081 
  12.38639 8.6130505 12.49249 8.6288834 12.56889 8.6005516 
  12.6875 8.6608295 12.72833 8.7594414 12.79416 8.765831 
  12.82416 8.847496 12.84138 9.0855522 12.90889 9.2352734 
  12.91361 9.3436069 12.84893 9.3600788) 
#(2.6821289 7.893651 2.7422221 7.808609 2.7333331 7.6397209 
  2.7627771 7.5474982 2.8072219 7.4172201 2.7574999 7.4194422 
  2.7786109 7.1344428 2.747777 7.099165 2.7983329 7.0399981 
  2.7252769 6.954443 2.798888 6.6886091 2.7416661 6.621943 
  2.7186961 6.3644552) #(1.799956 6.2809291 1.771389 6.392498 
  1.575278 6.6797199 1.623055 6.7577758 1.548611 6.995275) 
#(1.6341749 6.2106791 1.799956 6.2809291) 
#(-70.119164 6.975831 -69.429718 6.118608) 
#(0.68370593 6.587327 0.73361099 6.4908309 0.90472209 6.329443 
  1.000278 6.327776 1.1 6.1605539 1.201111 6.1599979 
  1.20385 6.099102) #(-67.454788 6.19311 -67.573624 6.266109 
  -67.835564 6.308332 -68.001106 6.206665 -68.152222 6.223331 
  -68.313606 6.1669431 -68.454178 6.1905541 -68.644173 6.1341648 
  -68.971123 6.1986079 -69.094162 6.1991639 -69.194992 6.099998 
  -69.256958 6.0838871 -69.33139 6.1530528 -69.429718 6.118608) 
#(-61.13805 6.701942 -61.20472 6.5744429 -61.15361 6.4922199 
  -61.156658 6.328887 -61.113892 6.2822208 -61.11306 6.1872201 
  -61.219158 6.1288862 -61.27914 6.0667601) 
#(14.41444 6.0441651 14.48805 6.1297202 14.74027 6.2624989 
  14.805 6.3466649 14.95861 6.7336092 15.05916 6.7786088 
  15.23972 7.246109 15.46027 7.3958321 15.42916 7.4288859 
  15.4991 7.5264311) #(14.56333 5.910831 14.485 5.9199982 
  14.41444 6.0441651) #(9.0063858 5.9099979 9.0033302 5.9447198 
  9.2949963 6.2077761 9.3633308 6.3258309 9.4349957 6.327776 
  9.4686069 6.4044428 9.5766621 6.4469419 9.6122189 6.5216651 
  9.7113876 6.5227761 9.7955513 6.8016639 9.8747177 6.7758312 
  10.16722 7.019165 10.205 6.9005542 10.25639 6.8758311 
  10.51333 6.8780541 10.59611 7.1341648) 
#(8.8606663 5.8198209 8.8799973 5.8547201 9.0063858 5.9099979) 
#(102.0944 6.2361751 102.0916 6.1105542 101.9461 5.9647212 
  101.9438 5.8619428 101.8241 5.7394419 101.685 5.7708321 
  101.6589 5.8605552 101.57 5.9166651 101.2819 5.8044419 
  101.2489 5.6991639 101.1397 5.6319418 101.0841 5.7141662 
  101.0244 5.7327762 100.9936 5.806108 101.1202 5.9905539 
  101.0791 6.1608319 101.1216 6.1872201 101.1155 6.248888 
  100.9897 6.2774978 100.9458 6.2386088 100.8522 6.2427769 
  100.8541 6.3255548 100.7486 6.5036101 100.655 6.4483309 
  100.3711 6.5474982 100.2989 6.7016659 100.2086 6.7105551 
  100.19 6.6874981 100.1714 6.476665 100.1286 6.4177909) 
#(-2.584651 8.7815266 -2.4880559 8.1977749 -2.6113889 8.1377754 
  -2.5888889 8.0408306 -2.684166 8.0124969 -2.741112 7.9388871 
  -2.7747221 7.9466648 -2.7852781 7.8536091 -2.823889 7.8236089 
  -3.0241671 7.0730538 -3.0899999 7.0619421 -3.2241659 6.8136091 
  -3.186388 6.7163868 -3.249166 6.6113868 -3.169445 6.2772212 
  -3.0066669 5.8577762 -3.0138891 5.707499 -2.948611 5.7130542 
  -2.960556 5.6272202) #(-2.7640259 5.590343 -2.7766671 5.6133318 
  -2.906389 5.6163859 -2.960556 5.6272202) 
#(-2.7640259 5.590343 -2.7181389 5.3463111) 
#(14.53166 5.2936101 14.60111 5.4205532 14.58916 5.6041651 
  14.62444 5.6977758 14.62166 5.8391652 14.59277 5.930553 
  14.56333 5.910831) #(-61.27914 6.0667601 -61.389999 5.9399981 
  -60.732929 5.205276) #(8.824007 5.1880012 8.8280535 5.2341642 
  8.9202766 5.6074982 8.8336086 5.7136102 8.8888845 5.786109 
  8.8606663 5.8198209) #(-60.732929 5.205276 -60.66695 5.2166648 
  -60.440552 5.1763868 -60.20055 5.2736092 -60.11142 5.2259059) 
#(14.68759 5.1142812 14.53166 5.2936101) 
#(-2.928575 5.0991802 -2.7347219 5.1127758 -2.773334 5.349998 
  -2.7181389 5.3463111) #(27.45586 5.0171428 27.45805 5.0836101 
  27.295549 5.2358308 27.23777 5.4388871 27.28194 5.5488868 
  27.142771 5.7719431 26.829439 5.9049978 26.808611 5.9799991 
  26.612209 6.0144429 26.51416 6.1097202 26.43749 6.077776 
  26.450821 6.1161089 26.523609 6.1736088 26.523609 6.2211089 
  26.30138 6.392498 26.306101 6.4494419 26.384991 6.5891652 
  26.39666 6.6552758 26.09444 6.850276 26.04833 6.9983311 
  25.374161 7.3394418 25.3311 7.4252758 25.20694 7.497498 
  25.189989 7.5927758 25.296101 7.6499991 25.286381 7.7833319 
  25.22555 7.8727751 25.14888 7.893054 25.053881 7.9211092 
  24.96999 8.0233307 24.85508 8.1697407) 
#(47.989429 8.0030518 46.418591 6.473331 44.950821 4.9024978) 
#(8.5904846 4.8105149 8.6361103 4.8269429 8.6219406 4.894721 
  8.824007 5.1880012) #(34.759991 6.6097212 34.870541 6.2374978 
  34.981369 6.0611091 34.97554 5.949719 35.10582 5.6927762 
  35.10387 5.6324978 35.289989 5.5077758 35.271099 5.435554 
  35.319439 5.3605542 35.361099 5.352221 35.458038 5.432498 
  35.533329 5.4252758 35.604988 5.373054 35.689701 5.389998 
  35.836929 5.3130531 35.795269 5.2374978 35.830818 5.1538868 
  35.773869 5.0752759 35.774429 4.7986088 35.940319 4.6220808) 
#(35.940319 4.6220808 35.716648 4.618053 35.699009 4.6179352) 
#(35.699009 4.6179352 35.610249 4.617341) 
#(35.610249 4.617341 35.509071 4.6166649) 
#(35.509071 4.6166649 35.051929 4.6136088 34.387489 4.6099982 
  34.376591 4.599154) #(35.509071 4.6166649 35.420818 4.7711101 
  35.476929 4.9027758 35.463871 4.9224982 35.310261 4.9074979 
  35.344429 5.0124989 35.303871 5.0202761 35.196651 4.955832 
  35.15221 4.9888868 34.973309 4.894999 34.498322 4.7377758 
  34.376591 4.599154) #(22.72666 4.6227751 22.79277 4.723609 
  22.855829 4.706943 22.890829 4.8191652 22.97916 4.828609 
  23.022499 4.743053 23.186661 4.724442 23.272221 4.6247201 
  23.42638 4.5919428 23.449989 4.6588869 23.70916 4.7758312 
  24.105551 4.9199982 24.151939 4.8999991 24.401939 5.035275 
  24.35499 5.059998 24.394159 5.1155539 24.43166 5.0652752 
  24.4536 5.1063871 24.525551 5.0772209 24.67277 4.9180541 
  24.977209 4.9877758 25.075821 4.9472198 25.11277 4.998054 
  25.22777 5.0069432 25.323601 5.057498 25.310551 5.1911092 
  25.36194 5.3147202 25.52083 5.3474979 25.79583 5.2363858 
  25.87582 5.2174978 25.90527 5.165832 25.97332 5.2316651 
  26.031111 5.1911092 26.088329 5.2405539 26.163601 5.2299991 
  26.500549 5.0447211 26.646379 5.08111 26.87249 5.0313869 
  26.945271 5.1461101 27.09638 5.202776 27.419439 5.0747199 
  27.45586 5.0171428) #(35.940319 4.6220808 35.95126 4.5209751) 
#(35.95126 4.5209751 36.045818 4.4466648 36.197239 4.4466648) 
#(-7.5255609 4.3514509 -7.563334 4.3872199 -7.5466671 4.4241648 
  -7.5883331 4.9058309 -7.539444 4.9405541 -7.5549989 5.0833321 
  -7.4952769 5.10111 -7.4644451 5.2747202 -7.4127779 5.285275 
  -7.3677778 5.3355541 -7.4063892 5.3644428 -7.436388 5.4372201 
  -7.3683329 5.5722208 -7.415556 5.6572208 -7.4247222 5.8449979 
  -7.458055 5.8608308 -7.6419449 5.9197202 -7.685833 5.9044442 
  -7.7625008 5.9505539 -7.773056 6.035831 -7.8452778 6.0827761 
  -7.8225002 6.202776 -7.9022231 6.2783322 -8.0733337 6.2933311 
  -8.2080545 6.2986088 -8.289444 6.3480539 -8.3669434 6.3544431 
  -8.4083347 6.4249978 -8.3819427 6.4424968) 
#(115.1459 4.9033551 115.2441 4.724998 115.2664 4.5294428 
  115.3602 4.329165 115.3364 4.3113871 115.0986 4.3863869 
  115.0266 4.6566648 115.0296 4.8183198) 
#(34.376591 4.599154 33.997601 4.2217598) 
#(44.950821 4.9024978 43.98193 4.9630542 43.6236 4.869164 
  43.163872 4.6708322 42.971371 4.5086098 42.91415 4.3561091 
  42.831661 4.2952762 42.514149 4.2336092 42.19582 4.2088871 
  42.075821 4.1752772) #(19.284109 5.027812 19.398331 5.119998 
  19.56638 5.1502762 19.838329 5.0883312 19.865829 5.0416651 
  20.281111 4.7922201 20.37027 4.725831 20.456381 4.519165 
  20.576099 4.414721 20.614719 4.4080529 20.8386 4.4491639 
  20.98444 4.4266639 21.172211 4.3038859 21.28277 4.3341651 
  21.35527 4.2799988 21.551941 4.245831 21.6586 4.2991648 
  21.925819 4.2341642 22.25972 4.1341648 22.39138 4.1286092 
  22.46805 4.1552758 22.61305 4.369164 22.587219 4.411665 
  22.601379 4.477221 22.69416 4.493053 22.72666 4.6227751) 
#(15.12289 4.1144042 15.10277 4.1719432 15.04389 4.3622198 
  14.89222 4.476665 14.73277 4.623054 14.70305 4.8586092 
  14.68759 5.1142812) #(-67.454788 6.19311 -67.491943 6.118608 
  -67.414436 5.9872198 -67.622223 5.787498 -67.651672 5.6699982 
  -67.613327 5.539165 -67.731667 5.430553 -67.849731 5.307775 
  -67.828888 5.1122198 -67.79306 5.0499978 -67.875267 4.5252762 
  -67.813049 4.4652758 -67.805557 4.2274981 -67.729172 4.0874991) 
#(15.19083 4.0469432 15.12289 4.1144042) 
#(115.0135 4.8909941 114.9794 4.831665 114.8489 4.8008308 
  114.7778 4.7208319 114.8408 4.437499 114.8766 4.432775 
  114.8689 4.3586092 114.8036 4.2730541 114.848 4.2722211 
  114.7964 4.1305528 114.67 4.0297198 114.61 4.0277758 
  114.4447 4.2658319 114.3752 4.2569432 114.3236 4.2802758 
  114.3278 4.3447208 114.2358 4.5319419 114.091 4.5899029) 
#(42.075821 4.1752772 41.955818 4.0852761 41.930538 4.0097222 
  41.913639 3.998662) #(41.913639 3.998662 41.836929 3.947777 
  41.77137 3.98611 41.319149 3.944443 41.12915 3.9627769 
  40.783428 4.2876191) #(-59.858341 3.5638881 -59.760559 3.6283319 
  -59.51889 3.9524989 -59.598621 4.016387 -59.63583 4.1463871 
  -59.70528 4.1672201 -59.732769 4.2274981 -59.71278 4.309443 
  -59.676121 4.3888869 -59.754719 4.4302759 -60.147789 4.517498 
  -60.152222 4.5733318 -60.025829 4.707221 -59.97472 5.0930538 
  -60.051941 5.1344428 -60.11142 5.2259059) 
#(-64.641586 4.221951 -64.58223 4.121664 -64.248894 4.1480541 
  -64.116943 4.098609 -64.043327 3.895277 -63.988609 3.883054 
  -63.8475 3.9597211 -63.608341 3.94361 -63.50111 3.8574989 
  -63.456669 3.8666661 -63.423328 3.96611 -63.3825 3.9708321 
  -63.31472 3.946666 -62.987228 3.600832 -62.875 3.560277 
  -62.77528 3.6069441 -62.735561 3.6711099 -62.727489 3.731111 
  -62.75861 3.8347211 -62.753891 3.98611 -62.73111 4.038054 
  -62.54195 4.0416651 -62.531391 4.1263871 -62.40028 4.181942 
  -62.246391 4.122498 -62.110001 4.100831 -62.051109 4.1511102 
  -61.892502 4.1508312 -61.745548 4.2494421 -61.553329 4.2491651 
  -61.512501 4.2980542 -61.505001 4.3952761 -61.456669 4.4211092 
  -61.34222 4.4174981 -61.281391 4.457221 -61.31139 4.5202761 
  -61.266399 4.519721 -60.985001 4.5205541 -60.930828 4.5847211 
  -60.884998 4.7116652 -60.816109 4.7297201 -60.64167 4.8555541 
  -60.579731 4.9811101 -60.662769 5.1874981 -60.732929 5.205276) 
#(33.997601 4.2217598 33.51693 3.7522221 33.183868 3.7661099 
  33.016651 3.8886099 32.716648 3.7552769 32.40443 3.7436099 
  32.195259 3.611944 32.19331 3.5113881 32.093601 3.5324991 
  32.063869 3.590277 31.95027 3.5947211 31.93055 3.6919429 
  31.79472 3.823333 31.701929 3.7130549 31.66194 3.705554 
  31.540831 3.65361 31.28805 3.7947221 31.176661 3.7952771 
  30.95471 3.6711099 30.868521 3.4921401) 
#(30.868521 3.4921401 30.85527 3.572499 30.76305 3.6827769 
  30.614719 3.6069441 30.55888 3.613888 30.58194 3.697221 
  30.544439 3.870554 30.205271 3.9624989 30.14027 4.1088872 
  30.065269 4.1280541 30.026661 4.205276 29.945271 4.2438869 
  29.956659 4.3022199 29.899719 4.3466649 29.83666 4.3463869 
  29.793329 4.3849978 29.81472 4.560276 29.674709 4.6272202 
  29.47999 4.6769428 29.321659 4.3866649 29.25444 4.3874989 
  29.25222 4.35111 29.20499 4.3436098 29.062771 4.4611092 
  28.882771 4.4797201 28.7686 4.5563869 28.650829 4.4236088 
  28.505831 4.373054 28.44249 4.287776 28.36916 4.2827759 
  28.335831 4.35111 28.200821 4.3474979 28.16638 4.3877759 
  28.064159 4.431109 28.03277 4.560554 27.92971 4.5511088 
  27.78611 4.6069422 27.782221 4.7602768 27.70388 4.7936101 
  27.70277 4.8336101 27.64888 4.9019418 27.578051 4.894999 
  27.45586 5.0171428) #(18.625999 3.4788561 18.59499 3.769166 
  18.64888 4.0024991 18.591379 4.2311101 18.537769 4.2991648 
  18.541941 4.3355541 18.582211 4.370553 18.71471 4.370275 
  18.776661 4.4233308 18.816099 4.5263872 19.088881 4.9180541 
  19.284109 5.027812) #(36.197239 4.4466648 36.64748 4.4466648 
  36.973309 4.396666 37.998039 3.72861 38.12109 3.611666 
  38.44804 3.599443 38.52887 3.653888 38.913601 3.5138879 
  39.055538 3.527221 39.19693 3.478611 39.498039 3.455277 
  39.50499 3.4180551 39.560261 3.406666 39.782761 3.6783321 
  39.86665 3.8694429 40.388599 4.098887 40.783428 4.2876191) 
#(-57.248138 5.4858098 -57.33556 5.3133321 -57.286671 5.2294431 
  -57.26112 5.2205529 -57.252499 5.269165 -57.21278 5.2322221 
  -57.190552 5.164165 -57.228882 5.1408319 -57.266109 5.1777749 
  -57.29723 5.1602759 -57.289169 5.016665 -57.375832 5.0061092 
  -57.688332 5.0102768 -57.853619 4.912776 -57.926392 4.7986088 
  -57.838612 4.6547198 -57.8825 4.559164 -57.95417 4.287776 
  -58.071671 4.1522212 -58.040562 3.9947209 -57.929169 3.8866661 
  -57.835831 3.664999 -57.735001 3.6102769 -57.636951 3.4611101 
  -57.66695 3.395555 -57.642231 3.3558331) 
#(-54.168968 5.346324 -54.290562 5.248054 -54.45583 5.0044432 
  -54.47472 4.7366648 -54.434441 4.7086101 -54.402222 4.1813869 
  -54.331669 4.14222 -54.360279 4.0349979 -54.284451 3.926388 
  -54.12389 3.7855549 -54.067219 3.664443 -54.009171 3.6363881 
  -53.98444 3.599443 -54.003059 3.4427769 -54.09444 3.2949989) 
#(-67.729172 4.0874991 -67.690567 3.9586101 -67.59584 3.737777 
  -67.488907 3.7227759 -67.374443 3.478888 -67.303879 3.4519429 
  -67.290833 3.3974991 -67.384171 3.259166) 
#(15.93889 3.1061101 15.86944 3.1055551 15.26027 3.673888 
  15.07694 3.9205551 15.04389 4.0291648 15.19083 4.0469432) 
#(18.53933 3.07568 18.61166 3.131943 18.64222 3.2105551 
  18.625999 3.4788561) #(117.5881 4.171236 117.4433 4.1927762 
  117.2333 4.3591642 116.8305 4.330832 116.7427 4.373054 
  116.6944 4.331943 116.6419 4.3347211 116.5703 4.3861089 
  116.5216 4.3661089 116.5258 4.3174982 116.4514 4.2952762 
  116.3497 4.370831 116.1669 4.3758311 116.0541 4.2772212 
  115.8864 4.368053 115.8566 4.3430538 115.8519 4.2794442 
  115.758 4.2363858 115.5644 3.906388 115.6164 3.854166 
  115.5714 3.612777 115.6266 3.426666 115.5708 3.4177771 
  115.4873 3.027843) #(40.986309 2.8325901 41.336929 3.1674991 
  41.913639 3.9904649 41.913639 3.998662) 
#(-67.846336 2.79245 -67.843353 2.8683319 -67.446663 3.2419429 
  -67.384171 3.259166) #(18.402769 2.7313881 18.53933 3.07568) 
#(16.11516 2.705832 16.078051 2.70611 16.071659 2.7966659 
  16.11277 2.823333 16.11055 2.864166 15.93889 3.1061101) 
#(18.34202 2.612628 18.402769 2.7313881) 
#(115.4873 3.027843 115.3208 2.986388 115.2708 3.0450001 
  115.1555 2.925555 115.135 2.882499 115.1294 2.771944 
  115.0816 2.6163881 115.0983 2.5974989 115.1472 2.6086099) 
#(-54.09444 3.2949989 -54.19194 3.1788881 -54.17028 3.008333 
  -54.18639 2.90361 -54.180561 2.840832 -54.42667 2.4272211 
  -54.483238 2.4285491) #(18.21999 2.4272211 18.34202 2.612628) 
#(-54.483238 2.4285491 -54.52417 2.3361101 -54.573891 2.354722 
  -54.61536 2.3197789) #(11.36837 2.303591 11.62472 2.313055 
  12.16222 2.280277 12.33687 2.317276) 
#(12.33687 2.317276 12.57568 2.274327) 
#(16.206409 2.221102 16.501659 2.849443 16.482771 3.156666 
  16.588881 3.4819429 16.69916 3.5452771 16.86194 3.5244441 
  16.876659 3.5658319 16.98777 3.5352769 17.077221 3.5766661 
  17.3561 3.6152771 17.413879 3.6797211 17.493601 3.7108331 
  17.579439 3.6483331 17.759991 3.6305549 17.86499 3.5361099 
  17.938881 3.5774989 17.98888 3.539166 18.04944 3.5663879 
  18.143881 3.550832 18.18388 3.4827771 18.233879 3.499166 
  18.272499 3.583055 18.39805 3.5774989 18.48138 3.641943 
  18.533331 3.5988879 18.54888 3.5533321 18.625999 3.4788561) 
#(16.206409 2.221102 16.16444 2.300277 16.09194 2.656388 
  16.11516 2.705832) #(-51.68639 4.031846 -51.84972 3.84361 
  -52.103329 3.444999 -52.344158 3.154166 -52.33556 3.0644441 
  -52.445831 2.863333 -52.567501 2.5155549 -52.916389 2.195832 
  -53.11861 2.2224989 -53.265011 2.1924989) 
#(31.277451 2.1782031 31.20249 2.229166 31.196939 2.3058319 
  31.049721 2.3038881 31.070271 2.3349991 30.987209 2.4083321 
  30.946381 2.4088881 30.89805 2.3352771 30.862209 2.353611 
  30.82666 2.4422209 30.72916 2.447777 30.78694 2.674721 
  30.85638 2.790833 30.877769 2.897222 30.824989 2.988055 
  30.763611 3.0672221 30.935551 3.424721 30.909161 3.5258319 
  30.868521 3.4921401) #(31.27972 2.176666 31.277451 2.1782031) 
#(11.34038 2.168611 11.36837 2.303591) 
#(10.02291 2.167367 10.67361 2.1677771 11.34038 2.168611) 
#(9.8085461 2.346065 9.8508282 2.2424991 10.02291 2.167367) 
#(13.29422 2.1640739 13.255 2.2663879 13.13194 2.280277 
  13.08555 2.246388 13.0 2.25611 12.755 2.2327771 
  12.57568 2.274327) #(13.29422 2.1640739 13.73 2.1602769 
  14.37833 2.1613879 14.52389 2.1605539 14.56783 2.203994) 
#(115.1472 2.6086099 115.2372 2.5224991 115.2136 2.4913881 
  115.148 2.4808321 115.0872 2.4188881 114.9497 2.3605549 
  114.9477 2.291111 114.8047 2.248888 114.7764 2.146666) 
#(-53.265011 2.1924989 -53.218891 2.258055 -53.339722 2.352777 
  -53.471661 2.2566659 -53.64806 2.288332 -53.74501 2.373888 
  -53.796669 2.354166 -53.817501 2.309443 -53.93222 2.271944 
  -53.932499 2.224721 -53.99889 2.194443 -54.105 2.113055 
  -54.144169 2.120554 -54.180561 2.1724989 -54.249168 2.146666 
  -54.47694 2.218333 -54.546951 2.3183329 -54.61536 2.3197789) 
#(114.7764 2.146666 114.8102 2.0341661 114.8683 2.0438881) 
#(-57.642231 3.3558331 -57.29945 3.370832 -57.293331 3.2638879 
  -57.21056 3.0352769 -57.202221 2.820833 -57.127781 2.791666 
  -57.093609 2.715832 -57.02306 2.6247211 -56.691891 2.0269749) 
#(-56.691891 2.0269749 -56.557781 2.021944 -56.470909 1.944464) 
#(-54.61536 2.3197789 -54.678341 2.32111 -54.696659 2.3369441 
  -54.689159 2.4538879 -54.759998 2.4711101 -54.80666 2.435555 
  -54.867771 2.4402771 -54.9725 2.5547211 -54.956108 2.581388 
  -54.953892 2.6161101 -55.11195 2.527221 -55.15028 2.572499 
  -55.2589 2.497221 -55.282219 2.521666 -55.33083 2.5113881 
  -55.380001 2.428055 -55.728882 2.4011099 -55.94722 2.5319431 
  -55.982769 2.5224991 -55.98473 2.4799991 -56.03722 2.349999 
  -56.098049 2.343888 -56.131939 2.2527771 -55.901661 2.0452771 
  -55.901661 1.897222 -55.956669 1.849444 -56.470909 1.944464) 
#(-59.631111 1.846388 -59.751949 1.8652771 -59.73473 2.287221 
  -59.849731 2.330555 -59.965279 2.6266661 -59.97694 2.9113879 
  -59.85973 3.2869439 -59.821388 3.4680541 -59.858341 3.5638881) 
#(114.8683 2.0438881 114.853 1.897222 114.6939 1.829247) 
#(-69.377777 1.728635 -69.459167 1.760278 -69.738892 1.731666 
  -69.843201 1.715337) #(16.07222 1.654166 16.162491 1.726666 
  16.124161 1.873888 16.060551 1.973333 16.089991 2.166388 
  16.206409 2.221102) #(16.07222 1.654166 16.017771 1.761111 
  15.93277 1.780555 15.87194 1.825 15.48638 1.976388 
  15.33722 1.920555 15.27277 1.992222 15.15139 2.039721 
  15.14139 2.008333 15.07222 1.98 14.98 2.0319431 
  14.95388 2.0036111 14.88778 2.0038879 14.91083 2.0533321 
  14.86139 2.112499 14.80527 2.060833 14.56783 2.203994) 
#(18.038601 1.445555 18.078329 1.655277 18.09333 2.2294431 
  18.21999 2.4272211) #(-59.631111 1.846388 -59.678051 1.771389 
  -59.64278 1.731111 -59.531391 1.718888 -59.232769 1.379166 
  -59.000542 1.3311779) #(-78.595932 1.269294 -78.634171 1.264444) 
#(-78.634171 1.264444 -78.809868 1.4379258) 
#(30.475651 1.232531 30.693331 1.498888 31.036659 1.765555 
  31.302771 2.121388 31.27972 2.176666) 
#(30.475651 1.232531 30.472389 1.231599) 
#(31.277451 2.1782031 31.039989 1.979722 30.6786 1.675277 
  30.38777 1.300555 30.423611 1.241666 30.467489 1.259444 
  30.472389 1.231599) #(-66.873383 1.225538 -66.991676 1.695833 
  -67.133904 1.987777 -67.111938 2.099443 -67.172501 2.1480551 
  -67.216949 2.2752769 -67.174179 2.3369441 -67.19249 2.392499 
  -67.281387 2.4388881 -67.493896 2.666388 -67.56778 2.683332 
  -67.607224 2.7955551 -67.756958 2.8388879 -67.846336 2.79245) 
#(13.18587 1.2231261 13.30555 1.234166 13.37833 1.296388 
  13.52194 1.271944 13.60139 1.331944 13.77889 1.371944 
  13.79833 1.433888 13.90361 1.438888 14.07388 1.375277 
  14.15944 1.395277 14.23517 1.363793) 
#(13.18587 1.2231261 13.15222 1.253889 13.22555 1.299722 
  13.24638 1.395555 13.1375 1.568611 13.14194 1.703055 
  13.17389 1.776111 13.16111 1.904444 13.28833 2.0669439 
  13.29422 2.1640739) #(-78.560272 1.198611 -78.595932 1.269294) 
#(-56.470909 1.944464 -56.554722 1.9033329 -56.62833 1.9397219 
  -56.670841 1.9136111 -56.97916 1.916388 -57.053051 1.952777 
  -57.067501 2.010833 -57.100559 2.0238881 -57.23695 1.947222 
  -57.303051 1.981388 -57.353062 1.955555 -57.507511 1.736388 
  -57.564449 1.698055 -57.75362 1.7205549 -57.825279 1.682222 
  -57.980831 1.656944 -57.97472 1.601388 -58.013889 1.5122221 
  -58.252781 1.565833 -58.311939 1.603333 -58.3475 1.549444 
  -58.503899 1.450555 -58.471111 1.320555 -58.51556 1.267777 
  -58.695271 1.286944 -58.726391 1.228611 -58.80722 1.185555 
  -58.865841 1.201944 -58.928341 1.3027771 -59.000542 1.3311779) 
#(-66.873383 1.225538 -67.075562 1.1724989 -67.084183 1.1938879 
  -67.07251 1.625277 -67.191963 1.849444 -67.335297 2.11111 
  -67.424438 2.143888 -67.517227 2.099999 -67.783333 1.806944 
  -67.95195 1.742499 -68.015289 1.7738889 -68.089722 1.933611 
  -68.194992 2.0144441 -68.275833 1.832222 -68.153343 1.724166 
  -69.377777 1.728635) #(34.527439 1.113417 34.57748 1.092499 
  34.60582 1.158888 34.81971 1.231388 34.829708 1.288888 
  34.79221 1.393611 34.999989 1.671944 34.999432 1.8766659 
  35.026089 1.919722 34.979149 1.994722 34.994991 2.09111 
  34.944698 2.2130549 34.882198 2.413054 34.94054 2.4505551 
  34.93581 2.5069439 34.839149 2.603888 34.74971 2.8558331 
  34.662201 2.86111 34.59082 2.9394431 34.559151 3.11111 
  34.454151 3.1819429 34.40498 3.406666 34.45554 3.5241661 
  34.463322 3.6713879 34.354988 3.73861 34.299431 3.706666 
  34.263599 3.7863879 34.17609 3.7755549 34.163311 3.8272209 
  34.210541 3.840555 34.214149 3.8874991 34.09943 3.8799989 
  34.129711 3.954443 34.054699 4.185554 33.997601 4.2217598) 
#(-69.843201 1.715337 -69.842216 1.062222) 
#(30.472389 1.231599 30.479719 1.1900001 30.530041 1.008083 
  30.685551 1.137777 30.953051 1.521111 31.20166 1.619166 
  31.41416 1.916389 31.359159 2.260833 31.45805 2.331388 
  31.45166 2.3461101 31.371111 2.3166659 31.29722 2.1947219 
  31.277451 2.1782031) #(9.8045006 1.0025541 10.01472 1.0019439 
  10.68444 1.0025001 11.35389 1.0019439 11.34889 1.503055 
  11.34038 2.168611) #(-77.916367 0.88166428 -78.351936 1.067222 
  -78.473328 1.197777 -78.560272 1.198611) 
#(114.6939 1.829247 114.7108 1.770555 114.6661 1.630277 
  114.5875 1.45 114.5436 1.432222 114.3894 1.508333 
  114.1941 1.424166 114.1344 1.467777 113.9255 1.4438879 
  113.7822 1.299444 113.6425 1.229444 113.5514 1.316388 
  113.4333 1.286388 113.0989 1.438333 112.9805 1.4227771 
  113.0441 1.496666 113.0427 1.554166 112.4844 1.5700001 
  112.3097 1.499444 112.1847 1.425277 112.1272 1.144444 
  111.9416 1.124722 111.8566 1.0169441 111.7977 0.99388862 
  111.6503 1.035 111.5339 0.96083307 111.5025 1.025277 
  111.3947 1.0116661 111.2364 1.086388 110.9041 1.014444 
  110.8444 0.96444422 110.5875 0.85333312 110.5197 0.86638862 
  110.43 0.94111079 110.3491 0.99027753 110.2333 1.114444 
  110.068 1.223333 109.9372 1.405555 109.8503 1.414444 
  109.6677 1.617777 109.67 1.784444 109.5855 1.800833 
  109.5547 1.853611 109.6501 2.064256) 
#(30.472389 1.231599 30.3486 1.19611 30.332211 1.151388 
  30.278049 1.168888 30.231661 1.125 30.216101 0.99249971 
  29.961889 0.83035761) #(-77.655937 0.81524563 
  -77.714722 0.84583312 -77.809402 0.80548918) 
#(-77.809402 0.80548918 -77.889999 0.82972193 
  -77.916367 0.88166428) #(-66.873383 1.225538 
  -66.317497 0.75222212 -66.12944 0.73277748 
  -65.971123 0.80388868 -65.862228 0.91333318 
  -65.703613 0.98444408 -65.559448 0.97111082 
  -65.511124 0.90472198 -65.509171 0.84388858 
  -65.583618 0.72583312 -65.563606 0.6716665 
  -65.519173 0.64972198 -65.433609 0.69916642 
  -65.389999 0.8308332 -65.301666 0.9266665 -65.196663 0.92416638 
  -65.171951 0.95472193 -65.140556 1.112499 -65.098618 1.145277 
  -65.017227 1.133888 -64.815552 1.282222 -64.751106 1.243611 
  -64.697487 1.262777 -64.523331 1.4375 -64.37027 1.511389 
  -64.349991 1.484166 -64.386398 1.409722 -64.366943 1.364444 
  -64.34169 1.366944 -64.255287 1.4805551 -64.070282 1.650277 
  -64.043877 1.909166 -63.970829 1.967222 -63.763889 1.9802769 
  -63.651112 2.0647211 -63.393059 2.1513879 -63.35778 2.269721 
  -63.365841 2.4213879 -63.48695 2.425555 -64.036942 2.4705541 
  -64.047501 2.5133331 -63.993061 2.633054 -64.01001 2.8022211 
  -64.218613 3.123333 -64.235817 3.433054 -64.18251 3.5461099 
  -64.203613 3.6099989 -64.497498 3.8338881 -64.685272 4.0705538 
  -64.801102 4.201942 -64.79805 4.2772212 -64.769173 4.289165 
  -64.693047 4.267221 -64.641586 4.221951) 
#(-69.209351 0.61827731 -69.137512 0.62999982 
  -69.125816 0.65111089 -69.182503 0.7319442 
  -69.142227 0.87055528 -69.202789 0.90666652 
  -69.193329 0.95194417 -69.275558 1.041111 -69.426102 1.027222 
  -69.446663 1.062222 -69.710297 1.060277 -69.72084 1.089722 
  -69.842216 1.062222) #(34.159981 0.60305518 34.260818 0.6411109 
  34.2911 0.68638861 34.410809 0.82194418 34.527439 1.113417) 
#(17.9487 0.35261491 17.96693 0.4477776 17.87888 0.95333308 
  18.038601 1.445555) #(34.00423 0.2369886 34.107769 0.35694429 
  34.159981 0.60305518) #(33.99947 0.2304191 34.00423 0.2369886) 
#(33.99947 0.2304191 33.980549 0.27027771 33.809429 0.15611111 
  33.79665 0.2338888 33.775829 0.1880555 33.705818 0.19750001 
  33.74749 0.3216666 33.620819 0.32055539 33.61832 0.2241666 
  33.546379 0.1766666 33.5261 0.2211111 33.483879 0.1852777 
  33.42387 0.2599999 33.412769 0.2930555 33.49416 0.2663888 
  33.511101 0.29944441 33.331379 0.36027771 33.36665 0.3947221 
  33.385818 0.48749989 33.303051 0.42749989 33.278599 0.48166659 
  33.190819 0.403611 33.24165 0.38777769 33.26276 0.36499989 
  33.15332 0.30916661 33.157211 0.2502777 33.11832 0.24888889 
  33.071098 0.25388879 33.098049 0.20111109 32.97887 0.088888869 
  32.894989 0.076944433 32.896931 0.14194439 32.875271 0.19194441 
  32.855259 0.1430555 32.810261 0.1572222 32.790272 0.1025 
  32.66193 0.090277761 32.65554 0.12972219 32.74165 0.1705555 
  32.722488 0.2052777 32.69054 0.1633333 32.654709 0.1680555 
  32.657768 0.253611 32.64526 0.28972211 32.564709 0.1872222 
  32.598049 0.1394444 32.5261 0.076944433 32.440819 0.029444439 
  32.413052 0.054722209 32.457211 0.092777759 32.45332 0.1177777 
  32.366379 0.080555528 32.377491 0.047222208 32.355549 0.01333333 
  32.253601 0.045277771) #(29.710819 -0.069301412 
  29.71666 0.072222203 29.77722 0.1752777 29.813881 0.158611 
  29.85833 0.36666659 29.96249 0.48722211 29.94416 0.57249981 
  29.961889 0.83035761) #(29.70989 -0.075809941 
  29.710819 -0.069301412) #(-75.285248 -0.1191244 
  -75.434433 -0.06000001 -75.597778 0.055833321 
  -75.628052 0.028888879 -75.775284 0.056388881 
  -76.047783 0.33999991 -76.10611 0.3216666 -76.115829 0.37916651 
  -76.303047 0.41888869 -76.33168 0.373611 -76.40834 0.39694431 
  -76.40889 0.24833331 -76.72139 0.2805554 -76.733063 0.2324999 
  -76.88028 0.2422222 -77.080841 0.35916659 -77.196663 0.3347221 
  -77.379707 0.38472211 -77.427223 0.42444429 
  -77.444443 0.62722188 -77.476387 0.66361088 
  -77.541672 0.65611088 -77.65834 0.74499983 
  -77.655937 0.81524563) #(-75.285248 -0.1191244 
  -75.360001 -0.15333331 -75.628052 -0.1083333) 
#(-75.624687 -0.176809 -75.628052 -0.1083333) 
#(34.186039 -0.1906672 34.131649 -0.1969445 
  34.084431 -0.14388891 34.14138 -0.1177778 
  34.122211 -0.062222231 34.05415 -0.1083333 33.951382 0.089722201 
  34.001381 0.2263888 33.99947 0.2304191) 
#(17.736771 -0.31636539 17.70999 -0.17416669 17.8036 0.1486111 
  17.9487 0.35261491) #(-75.363892 -0.4666667 
  -75.48555 -0.2266667 -75.624687 -0.176809) 
#(29.653 -0.47405931 29.70989 -0.075809941) 
#(29.6527 -0.47612429 29.653 -0.47405931) 
#(-75.218613 -0.9772222 -75.291382 -0.71833348 
  -75.245003 -0.61972219 -75.262787 -0.52305567 
  -75.363892 -0.4666667) #(32.253601 0.045277771 
  32.292759 0.0036111111 32.28249 -0.031388901 
  32.248322 -0.029444439 32.20805 0.03333332 
  32.186939 -0.076666683 32.086102 -0.034722231 
  32.01804 -0.055277791 32.072491 -0.098888889 
  31.953609 -0.1122222 31.92305 -0.1983334 31.97583 -0.1911111 
  32.033329 -0.32555559 31.840549 -0.48444459 31.78916 -0.5866667 
  31.801941 -0.65027791 31.72444 -0.74361122 31.69944 -0.84083349 
  31.769991 -0.87166673 31.76553 -0.99930829) 
#(31.76553 -0.99930829 31.423599 -0.99916661 
  30.751181 -0.99758112) #(31.839861 -0.9993391 
  31.835661 -0.99933738 31.76553 -0.99930829) 
#(33.92033 -1.001492 33.918591 -0.45277789 33.976089 -0.1341667 
  33.9072 0.1030555 33.99947 0.2304191) 
#(33.92033 -1.001492 33.433319 -1.000278 32.766651 -0.99972212 
  32.094429 -0.99944448 31.839861 -0.9993391) 
#(14.41639 -1.033448 14.51861 -0.60916662 14.45666 -0.51861131 
  14.30666 -0.43333331 14.1775 -0.4525001 14.16083 -0.3577778 
  14.12083 -0.2761111 13.88694 -0.2530556 13.85222 -0.1675 
  13.95 0.03333332 13.91333 0.042499989 13.88861 0.22277769 
  13.96972 0.36277771 14.06639 0.42805541 14.07222 0.4849999 
  14.10278 0.54638863 14.27916 0.55361092 14.4725 0.84611082 
  14.36527 1.090277 14.31277 1.111111 14.27389 1.326388 
  14.23517 1.363793) #(34.069351 -1.05581 34.07526 -1.0502779 
  34.04388 -1.001667 34.1311 -1.006945 34.178879 -0.85416669 
  34.07082 -0.79305577 34.065269 -0.55611128 
  34.157768 -0.52833343 34.178322 -0.44777781 
  34.221371 -0.41583341 34.29694 -0.47916669 34.396931 -0.4525001 
  34.41888 -0.52805579 34.46888 -0.50222242 34.5061 -0.45944449 
  34.44138 -0.3872222 34.467491 -0.34111109 34.594151 -0.341389 
  34.752491 -0.33944449 34.762211 -0.2911112 34.80444 -0.31138891 
  34.843319 -0.30694449 34.8461 -0.27750009 34.734711 -0.15555561 
  34.733601 -0.087777793 34.500542 -0.18555561 
  34.447208 -0.1644444 34.34082 -0.2033333 34.390541 -0.2733334 
  34.306381 -0.3919445 34.27776 -0.39250001 34.186039 -0.1906672) 
#(34.069351 -1.05581 34.029709 -1.036945 34.020538 -1.001389 
  33.92033 -1.001492) #(30.751181 -0.99758112 30.64138 -1.072222 
  30.482309 -1.061622) #(30.482309 -1.061622 30.52277 -1.2275 
  30.63166 -1.3730561) #(29.597469 -1.385249 29.578329 -0.89999998 
  29.62833 -0.88888907 29.632771 -0.64611107 29.67194 -0.57222217 
  29.6527 -0.47612429) #(30.482309 -1.061622 30.3561 -1.0650001 
  30.27972 -1.214445 30.184719 -1.275 30.170549 -1.339722 
  29.974991 -1.464444 29.901939 -1.455833 29.883329 -1.3677779 
  29.829161 -1.319167 29.597469 -1.385249) 
#(41.55772 -1.674361 41.55526 -1.592222 41.029709 -0.906389 
  40.98859 0.0 40.986309 2.8325901) 
#(29.23632 -1.687701 29.361099 -1.510278 29.597469 -1.385249) 
#(29.23278 -1.692744 29.23632 -1.687701) 
#(31.839861 -0.9993391 31.858879 -1.094722 31.79388 -1.483611 
  31.74972 -1.475 31.7561 -1.553889 31.74416 -1.636389 
  31.68305 -1.891667 31.638611 -1.936389 31.613819 -2.0440919) 
#(30.63166 -1.3730561 30.739161 -1.436945 30.840269 -1.6705559 
  30.808331 -1.929445 30.876381 -2.0469451) 
#(36.01339 -2.1222329 35.671371 -1.931667 34.987759 -1.5505559 
  34.30526 -1.168056 34.069351 -1.05581) 
#(36.045189 -2.1399519 36.01339 -2.1222329) 
#(36.295269 -2.2792871 36.045189 -2.1399519) 
#(30.35615 -2.3356769 30.352551 -2.335758) 
#(30.352551 -2.335758 30.29598 -2.337023) 
#(30.01251 -2.3386991 30.007351 -2.3396139) 
#(30.007351 -2.3396139 29.9911 -2.3425) 
#(30.876381 -2.0469451 30.829161 -2.357779 30.782021 -2.3807499) 
#(30.782021 -2.3807499 30.57375 -2.3994009) 
#(30.57375 -2.3994009 30.3811 -2.2994449 30.35615 -2.3356769) 
#(30.132429 -2.425163 30.093611 -2.3805561 30.03504 -2.3503301 
  30.01251 -2.3386991) #(30.29598 -2.337023 30.224991 -2.3386121 
  30.153601 -2.4305561 30.132429 -2.425163) 
#(28.87278 -2.4411991 28.863609 -2.4102781 28.88916 -2.367223 
  28.957769 -2.3622229 28.99332 -2.2855561 29.09194 -2.273056 
  29.1236 -2.229167 29.170549 -2.0863891 29.12388 -1.9044451 
  29.1411 -1.8197221 29.23278 -1.692744) 
#(28.883881 -2.478611 28.87278 -2.4411991) 
#(-72.354446 -2.4344449 -72.59584 -2.407778 
  -72.646118 -2.4941671 -72.69249 -2.440556 
  -72.71666 -2.4749999 -72.74472 -2.434444 
  -72.805832 -2.4877779 -72.891953 -2.503056 
  -72.944443 -2.395556 -73.022781 -2.4222231 
  -73.036118 -2.365278 -73.083069 -2.3633339 
  -73.133904 -2.2433331 -73.088333 -2.2244451 
  -73.057503 -2.1408341 -73.093338 -1.918056 
  -73.199158 -1.803056 -73.309433 -1.8722219 
  -73.507507 -1.748333 -73.446381 -1.5963891 
  -73.517227 -1.503889 -73.556381 -1.370834 
  -73.738892 -1.238611 -73.755569 -1.294167 
  -73.844162 -1.260556 -73.850281 -1.1708339 
  -73.938316 -1.168889 -74.020554 -1.035278 
  -74.077789 -1.073611 -74.236938 -1.018889 
  -74.29361 -0.90222239 -74.242493 -0.8900001 
  -74.238892 -0.85916662 -74.309158 -0.81333351 
  -74.376099 -0.56805551 -74.607773 -0.3836112 
  -74.638344 -0.41027781 -74.663887 -0.34666669 
  -74.706673 -0.36777779 -74.730827 -0.26638901 
  -74.786667 -0.20055559 -74.876099 -0.2272222 
  -75.150833 -0.038888901 -75.212219 -0.037500001 
  -75.245003 -0.1197222 -75.285248 -0.1191244) 
#(33.426102 -2.5572231 33.458599 -2.4980559 33.400829 -2.471112 
  33.462212 -2.449167 33.534161 -2.3794451 33.756649 -2.2758341 
  33.836102 -2.209445 33.774151 -2.0886109 33.732208 -2.0916669 
  33.603039 -2.1827779 33.254162 -2.1111109 33.22472 -2.143333 
  33.20332 -2.1094451 33.221661 -2.0411119 33.398319 -2.0411119 
  33.377209 -1.99 33.40638 -1.970834 33.548038 -2.035001 
  33.572491 -1.988333 33.492771 -1.927778 33.43943 -1.8822221 
  33.313042 -1.948334 33.284988 -1.928334 33.321659 -1.849167 
  33.374981 -1.799167 33.442211 -1.8002779 33.461929 -1.848611 
  33.504429 -1.840834 33.5886 -1.768889 33.646099 -1.766111 
  33.569988 -1.708056 33.54916 -1.672223 33.698318 -1.678889 
  33.709709 -1.640278 33.615822 -1.561389 33.687771 -1.525556 
  33.651661 -1.4761111 33.776661 -1.48 33.836929 -1.521945 
  33.957489 -1.518889 33.886379 -1.474167 33.79332 -1.430833 
  33.779709 -1.403056 33.820541 -1.388334 33.803879 -1.325834 
  33.947208 -1.342778 33.981098 -1.3325 33.8936 -1.285833 
  33.873878 -1.238889 34.069351 -1.05581) 
#(30.522461 -2.649637 30.489161 -2.6708341 30.433599 -2.6752779 
  30.43527 -2.6430559 30.57375 -2.3994009) 
#(-70.049728 -2.7275 -70.071671 -2.6611111 
  -70.125549 -2.699445 -70.236938 -2.552222 
  -70.32695 -2.5783341 -70.338333 -2.5555561 
  -70.299988 -2.531667 -70.307503 -2.4955549 
  -70.420547 -2.511111 -70.527222 -2.426389 
  -70.552223 -2.4324999 -70.540833 -2.4947231 
  -70.587784 -2.481112 -70.599731 -2.4208341 
  -70.758621 -2.2961111 -70.97139 -2.2236111 
  -70.988327 -2.3002779 -71.093887 -2.303056 
  -71.113892 -2.353056 -71.35556 -2.3913889 
  -71.357773 -2.353055 -71.430283 -2.2769451 
  -71.460564 -2.3525 -71.515007 -2.2358339 
  -71.679443 -2.2216671 -71.688599 -2.1497231 
  -71.731377 -2.1675 -71.898621 -2.384445 -72.008621 -2.357223 
  -72.04805 -2.387223 -72.103882 -2.4763889 
  -72.12999 -2.440556 -72.208893 -2.458334 
  -72.208893 -2.5063901 -72.33667 -2.479722 
  -72.354446 -2.4344449) #(29.024151 -2.744447 
  28.88916 -2.6538889 28.853319 -2.5136111 28.883881 -2.478611) 
#(29.9911 -2.3425 29.946939 -2.3211119 29.95471 -2.4749999 
  29.899441 -2.7055559 29.821939 -2.772778 29.571251 -2.8004) 
#(29.571251 -2.8004 29.527491 -2.8266671 29.44388 -2.7958341 
  29.37944 -2.8261111 29.34972 -2.8080561 29.32888 -2.6536119 
  29.140551 -2.5891671 29.05888 -2.604722 29.024151 -2.744447) 
#(30.522461 -2.649637 30.457211 -2.7230561 30.41749 -2.8619449 
  30.485161 -2.946501) #(31.613819 -2.0440919 31.70833 -2.012778 
  31.6511 -2.2577789 31.639721 -2.3713889 31.75638 -2.3305559 
  31.793051 -2.479722 31.713051 -2.5336111 31.760269 -2.626112 
  31.81555 -2.605 31.85972 -2.616667 31.767771 -2.6616671 
  31.79055 -2.8316669 31.81583 -2.8277781 31.84333 -2.7866671 
  31.82638 -2.7366669 31.848881 -2.68139 31.883329 -2.7177789 
  31.903049 -2.6411121 31.98138 -2.772778 32.024151 -2.7480559 
  31.93166 -2.595834 31.98805 -2.593334 31.98666 -2.5569451 
  32.005821 -2.4849999 32.163879 -2.5450001 32.159988 -2.49 
  32.0611 -2.4241669 32.068878 -2.3725009 32.172211 -2.3800011 
  32.218319 -2.251667 32.308041 -2.270556 32.357769 -2.3383341 
  32.321659 -2.356112 32.444988 -2.462779 32.545551 -2.440834 
  32.55444 -2.4652791 32.509708 -2.531667 32.530819 -2.5558331 
  32.665272 -2.4016671 32.67527 -2.520556 32.731659 -2.491111 
  32.738319 -2.5336111 32.764992 -2.498611 32.822208 -2.500834 
  32.819988 -2.7125001 32.860538 -2.719167 32.86277 -2.7775011 
  32.721661 -2.875556 32.796101 -2.916667 32.752491 -2.9341669 
  32.761662 -3.013056 32.816662 -2.9375 32.903881 -2.804167 
  32.999149 -2.8819449 33.02277 -2.857223 32.928879 -2.814723 
  32.959991 -2.790556 32.863602 -2.635278 32.881939 -2.5922229 
  32.87138 -2.482501 32.895821 -2.4455559 32.962769 -2.3897231 
  33.105259 -2.3913889 33.149712 -2.469445 33.426102 -2.5572231) 
#(37.675259 -3.051389 37.63026 -3.0169439 36.295269 -2.2792871) 
#(16.188881 -3.061666 16.19582 -2.8225 16.18388 -2.2458329 
  16.20694 -2.1588891 16.41444 -1.981111 16.583879 -1.766667 
  16.80722 -1.316389 16.96805 -1.1538889 17.30694 -1.015278 
  17.63555 -0.67083329 17.736931 -0.44361109 
  17.736771 -0.31636539) #(29.215321 -3.336621 29.21055 -3.2366669 
  29.240549 -3.1108339 29.21916 -3.021111 29.1486 -2.9961109 
  29.07444 -2.874722 28.98749 -2.8105559 28.98777 -2.77 
  29.024151 -2.744447) #(29.215509 -3.33816 29.215321 -3.336621) 
#(-78.256119 -3.5169439 -78.221123 -3.5086119 
  -78.170273 -3.4313891 -78.215843 -3.373889 
  -77.903343 -3.0269451 -77.342216 -2.8074999 
  -76.661392 -2.572778 -76.144173 -2.1838889 
  -75.590286 -1.553334 -75.402222 -0.92277789 
  -75.343887 -0.97611111 -75.218613 -0.9772222) 
#(30.4494 -3.5480001 30.63166 -3.450556 30.663601 -3.386667 
  30.624161 -3.3713889 30.678329 -3.3166671 30.76749 -3.3 
  30.83499 -3.2569449 30.85388 -3.1575 30.8311 -3.1180561 
  30.840269 -2.9741671 30.742769 -2.989723 30.55722 -2.893889 
  30.485161 -2.946501) #(37.78336 -3.651428 37.733601 -3.5261121 
  37.617199 -3.5075009 37.599991 -3.450278 37.613041 -3.3975 
  37.719978 -3.311945 37.675259 -3.051389) 
#(30.400829 -3.7861111 30.4494 -3.5480001) 
#(-70.620773 -3.8259039 -70.724442 -3.779722 
  -70.049728 -2.7275) #(11.14151 -3.9228981 11.24472 -3.678611 
  11.43917 -3.585 11.47833 -3.521389 11.56055 -3.5172219 
  11.69472 -3.696389 11.88472 -3.699167 11.925 -3.626667 
  11.84222 -3.5794439 11.84138 -3.551389 11.975 -3.322222 
  11.95805 -3.291389 11.69972 -3.166945 11.73194 -3.0377779 
  11.76611 -3.0472231 11.80166 -3.0088899 11.6325 -2.8186109 
  11.56472 -2.8672221 11.54333 -2.856945 11.54611 -2.793889 
  11.61194 -2.7158329 11.6475 -2.6133339 11.57417 -2.333333 
  11.68111 -2.356667 11.73527 -2.436666 11.77166 -2.396389 
  11.96416 -2.333333 12.02166 -2.3913889 12.47805 -2.3272231 
  12.51722 -2.093055 12.44805 -2.0244451 12.45277 -1.8772219 
  12.49527 -1.923889 12.52472 -1.905278 12.52055 -1.8724999 
  12.655 -1.824445 12.84527 -1.9544441 12.90444 -2.146945 
  12.97277 -2.190834 13.01111 -2.2955561 13.01944 -2.3477781 
  13.48694 -2.435277 13.72583 -2.186111 13.72722 -2.1511109 
  13.77055 -2.093055 13.93027 -2.357779 13.86444 -2.4230559 
  13.87888 -2.4763889 14.08777 -2.4949999 14.12833 -2.4544449 
  14.255 -2.342222 14.15833 -2.228611 14.22555 -2.1902781 
  14.26444 -1.9661109 14.42972 -1.891667 14.42139 -1.812778 
  14.46666 -1.6805561 14.38389 -1.610833 14.43389 -1.578611 
  14.50166 -1.390278 14.44416 -1.331944 14.48194 -1.212778 
  14.41639 -1.033448) #(15.51695 -4.0968022 15.56944 -4.0372219 
  15.84333 -3.969167 15.91111 -3.9197221 15.98333 -3.7569449 
  16.22777 -3.322222 16.188881 -3.061666) 
#(15.48707 -4.2009659 15.51695 -4.0968022) 
#(-69.209351 0.61827731 -69.318893 0.65305531 
  -69.464447 0.74027753 -69.511124 0.72638857 
  -69.611389 0.64555538 -69.678329 0.67888868 
  -69.940552 0.58166653 -70.044159 0.59083313 
  -70.046387 0.50444418 -70.058037 -0.1575 
  -69.928329 -0.30944449 -69.62027 -0.5044446 
  -69.573059 -0.63666689 -69.618057 -0.73388898 
  -69.565552 -0.84500003 -69.468338 -0.96611118 
  -69.44223 -1.0241669 -69.380829 -1.174445 
  -69.383904 -1.366667 -69.4375 -1.429167 -69.455276 -1.537778 
  -69.576111 -2.208333 -69.695831 -2.876945 
  -69.816101 -3.5494449 -69.946579 -4.2242279) 
#(-69.946579 -4.2242279 -70.248894 -3.8611121 
  -70.371933 -3.7883339 -70.516113 -3.8611121 
  -70.620773 -3.8259039) #(15.48 -4.2256379 15.48707 -4.2009659) 
#(-78.660553 -4.3022232 -78.531677 -3.9127779 
  -78.402496 -3.753612 -78.337784 -3.4227779 
  -78.284729 -3.408056 -78.260559 -3.4255559 
  -78.256119 -3.5169439) #(15.27287 -4.3067608 15.42861 -4.293612 
  15.47333 -4.2488899 15.48 -4.2256379) 
#(29.215509 -3.33816 29.20388 -3.3372231 29.151661 -3.354445 
  29.141939 -3.3991671 29.153049 -3.6741669 29.097771 -3.77 
  29.125549 -3.825278 29.10055 -3.8691671 29.10388 -4.2297239 
  29.04615 -4.307415) #(-70.035278 -4.336112 
  -69.972229 -4.3030558 -69.946579 -4.2242279) 
#(30.400829 -3.7861111 30.335831 -3.7741671 30.255831 -3.886945 
  30.207769 -4.0261121 30.072769 -4.166667 30.044439 -4.2463889 
  29.90583 -4.3497229 29.812771 -4.3602781 29.788851 -4.4043999) 
#(29.42359 -4.449472 29.38555 -4.1541681 29.232491 -3.885 
  29.246941 -3.594444 29.215509 -3.33816) 
#(29.65313 -4.4536529 29.65666 -4.4102778 29.599991 -4.358057 
  29.53833 -4.211668 29.329439 -3.761111 29.34499 -3.3805561 
  29.310829 -3.345834 29.215509 -3.33816) 
#(29.42359 -4.449472 29.65313 -4.4536529) 
#(29.65313 -4.4536529 29.711941 -4.4547229 29.788851 -4.4043999) 
#(-80.394173 -4.4769459 -80.130722 -4.28127) 
#(-80.340393 -3.3822739 -80.253891 -3.4208341 
  -80.271118 -3.470834 -80.212784 -3.595834 
  -80.220001 -3.688334 -80.156387 -3.887778 
  -80.316391 -4.0130572 -80.423317 -3.978333 
  -80.474716 -4.0072241 -80.480827 -4.1791682 
  -80.447769 -4.2219458 -80.335564 -4.1994438 
  -80.482773 -4.3997231 -80.467773 -4.43889 
  -80.394173 -4.4769459) #(-80.130722 -4.28127 
  -79.980827 -4.3838902 -79.89917 -4.3933339 
  -79.857224 -4.4475002 -79.789436 -4.4830561 
  -79.649986 -4.4327779 -79.495003 -4.5330558 
  -79.503067 -4.5686111) #(39.20562 -4.6731219 
  39.11998 -4.6100011 37.78336 -3.651428) 
#(13.09105 -4.6330719 13.10083 -4.5725012 13.14528 -4.5891681 
  13.19472 -4.6836109 13.37555 -4.7866678 13.41028 -4.8830562) 
#(13.41028 -4.8830562 13.49416 -4.8038888 13.70055 -4.7233338 
  13.73916 -4.4416671 13.82861 -4.4261112 13.88027 -4.4847231 
  13.965 -4.4950008 13.99111 -4.4652781 14.41528 -4.2741671 
  14.39916 -4.3413901 14.4875 -4.4269452 14.47666 -4.4563899 
  14.36472 -4.5577779 14.38333 -4.5994449 14.41904 -4.8876481) 
#(14.41904 -4.8876481 14.49583 -4.8408341 14.655 -4.9100008 
  14.71889 -4.8850002 14.84611 -4.7916679 15.15194 -4.4200001 
  15.27287 -4.3067608) #(-79.503067 -4.5686111 
  -79.480827 -4.713335 -79.356659 -4.8911119 
  -79.049438 -5.003335 -78.891388 -4.8441682 
  -78.918327 -4.7391658 -78.865829 -4.666389 
  -78.668327 -4.5591669 -78.62471 -4.436667 
  -78.670273 -4.379168 -78.660553 -4.3022232) 
#(12.01007 -5.0206151 12.16639 -4.8958349 12.20638 -4.7588892 
  12.29222 -4.793612 12.41278 -4.6025 12.65 -4.5594449 
  12.66444 -4.521667 12.78083 -4.3888888 12.89583 -4.415277 
  12.92222 -4.4852772 13.09105 -4.6330719) 
#(12.46205 -5.0923572 12.70805 -4.918611 12.82555 -4.7355571 
  13.0825 -4.6700001 13.09105 -4.6330719) 
#(12.20966 -5.770905 12.28389 -5.734446 12.52666 -5.7241669 
  12.53889 -5.1208329 12.46205 -5.0923572) 
#(13.17802 -5.8596091 13.34139 -5.8905559 13.40805 -5.853889 
  13.50083 -5.855278 13.98028 -5.835834 14.33555 -5.8925009 
  15.02806 -5.8627791 15.70527 -5.8586121 16.36832 -5.853056 
  16.57972 -5.9008331) #(29.94454 -5.921329 29.948879 -5.8205571 
  29.84388 -5.5713902 29.740271 -5.4538889 29.74222 -5.4124999 
  29.806391 -5.2619448 29.773331 -5.001945 29.590549 -4.9119458 
  29.601101 -4.83389 29.64222 -4.587501 29.65313 -4.4536529) 
#(141.0062 -6.3330889 141.0061 -5.9549999 141.0061 -5.2866678 
  141.0061 -4.6174998 141.0061 -3.947778 141.0061 -3.2777779 
  141.0074 -2.6077781) #(141.0062 -6.8934212 140.9005 -6.8511109 
  140.8499 -6.6169448 140.89799 -6.5966668 140.9485 -6.435833 
  140.95129 -6.3724999 141.0062 -6.3330889) 
#(-70.035278 -4.336112 -70.107773 -4.25389 
  -70.156113 -4.273335 -70.172501 -4.3247228 
  -70.208618 -4.3252792 -70.323898 -4.1372228 
  -70.433319 -4.1316671 -70.511948 -4.1808338 
  -70.545273 -4.1394448 -70.585281 -4.1961122 
  -70.620003 -4.1158342 -70.652222 -4.1186109 
  -70.684433 -4.1741681 -70.765839 -4.146945 
  -70.835007 -4.187778 -70.881668 -4.293334 
  -70.972778 -4.3794451 -70.988892 -4.3413901 
  -71.12944 -4.39889 -71.169724 -4.357779 
  -71.200562 -4.4113898 -71.233322 -4.376112 
  -71.290833 -4.3836122 -71.305557 -4.438334 
  -71.406677 -4.4349999 -71.656387 -4.5091681 
  -71.690552 -4.4738898 -71.826401 -4.5077791 
  -72.243881 -4.7588902 -72.325562 -4.7608352 
  -72.412781 -4.8863902 -72.531952 -4.9530559 
  -72.63501 -5.0591669 -72.741379 -5.0513892 
  -72.91777 -5.1519451 -72.891953 -5.2075009 
  -72.918327 -5.3225002 -72.950562 -5.564167 
  -73.218887 -6.0458341 -73.21611 -6.1552792 
  -73.164169 -6.2077789 -73.123894 -6.4477782 
  -73.19194 -6.5536122 -73.245827 -6.5680571 
  -73.434433 -6.6330552 -73.75473 -6.895 -73.801468 -7.117239) 
#(20.541929 -7.2846832 21.10305 -7.2827778 21.7836 -7.2816682) 
#(20.6311 -6.9144449 20.539989 -7.1422229 20.541929 -7.2846832) 
#(29.04615 -4.307415 29.146111 -4.3422241 29.23777 -4.0530558 
  29.259439 -4.1147232 29.197769 -4.522501 29.15749 -4.5050001 
  29.09305 -4.7822242 29.14583 -5.23 29.303329 -5.4894452 
  29.37472 -5.6405568 29.33666 -5.628057 29.339991 -5.6722231 
  29.324989 -5.8230562 29.18166 -5.919724 29.190269 -6.081389 
  29.320271 -6.1988902 29.40666 -6.4683352 29.453329 -6.5261121 
  29.48638 -6.5147238 29.491659 -6.67028 29.786381 -7.0552778 
  29.956659 -7.1047239 30.096661 -7.2136121 30.214161 -7.4658341 
  30.19722 -7.6136122 30.298941 -7.8882589) 
#(16.57972 -5.9008331 16.6 -6.0125008 16.717489 -6.1772232 
  16.70388 -6.4644461 16.84111 -6.7994442 16.91194 -6.8655558 
  16.927219 -6.9175 16.959999 -6.9852772 16.960819 -7.0388899 
  16.94582 -7.2083349 17.02527 -7.3083339 17.105551 -7.4222231 
  17.181101 -7.4277778 17.14666 -7.4694452 17.214439 -7.588613 
  17.287769 -7.62639 17.284161 -7.6994438 17.41972 -7.8480568 
  17.43721 -7.9247231 17.543329 -8.0213909 17.53722 -8.0772228) 
#(17.53722 -8.0772228 17.63805 -8.0980549 17.740549 -8.0619469 
  17.804991 -8.0863895 17.868601 -8.0458336 17.922211 -8.046669 
  18.007219 -8.108057 18.11805 -8.1069431 18.11194 -8.0780582 
  18.135269 -8.020834 18.525829 -7.9955559 18.531111 -7.9302788 
  18.767771 -7.9305549 18.794991 -7.998889 19.373051 -7.9961119 
  19.359159 -7.8580561 19.377489 -7.5716681 19.47138 -7.5686111 
  19.53583 -7.46 19.499439 -7.3516669 19.504709 -7.143889 
  19.56638 -7.0530558 19.542219 -6.9972229 19.631109 -6.996944 
  20.31138 -6.9947228 20.332491 -6.9144449 20.6311 -6.9144449) 
#(30.769991 -8.190834 30.708599 -8.0002785 30.45583 -7.5802789 
  30.381941 -7.2838898 30.207491 -6.9924998 29.82305 -6.6983328 
  29.55027 -6.295279 29.49666 -6.043889 29.504709 -5.9458342 
  29.631941 -5.7483339 29.62166 -5.669168 29.534439 -5.4480562 
  29.351379 -4.9513888 29.341379 -4.7977781 29.43082 -4.5411119 
  29.42359 -4.449472) #(30.57626 -8.2208061 30.769991 -8.190834) 
#(30.298941 -7.8882589 30.36388 -7.900835 30.58749 -8.1527805 
  30.57626 -8.2208061) #(28.897631 -8.4809036 29.40888 -8.4011116 
  30.089439 -8.296114 30.57626 -8.2208061) 
#(28.90082 -8.4877195 28.897631 -8.4809036) 
#(31.169991 -8.5953827 31.16835 -8.5961361) 
#(31.16835 -8.5961361 31.14027 -8.4177799 31.06027 -8.3522243 
  30.95694 -8.2130566 30.76722 -7.8091679 30.6161 -7.5700021 
  30.60972 -7.355001 30.5261 -7.1813898 30.53611 -7.1194458 
  30.56138 -7.0905571 30.56888 -6.9677782 30.447491 -6.856946 
  30.394159 -6.7474999 30.13888 -6.4569449 30.070271 -6.4572239 
  29.949711 -6.5055571 29.714161 -6.2588902 29.721939 -6.0900002 
  29.7561 -6.021389 29.94454 -5.921329) 
#(31.16835 -8.5961361 31.12582 -8.6155567 31.0411 -8.5902786 
  30.8986 -8.4558334 30.769991 -8.190834) 
#(30.57626 -8.2208061 30.5686 -8.2672253 30.457769 -8.3808355 
  30.446939 -8.4733353 30.489719 -8.5250034 30.57777 -8.5102806 
  30.53055 -8.588335 30.61277 -8.5600014 30.6436 -8.4891701 
  30.68055 -8.4850035 30.683331 -8.5300026 30.79055 -8.5630589 
  31.024719 -8.8013916 31.06361 -8.7938919 31.11833 -8.7377796 
  31.186939 -8.7461147 31.196939 -8.690836 31.16861 -8.5977802 
  31.16835 -8.5961361) #(141.0083 -9.128336 141.0069 -8.8888912 
  141.0069 -8.2247238 141.0061 -7.5594449 141.0062 -6.8934212) 
#(28.521549 -9.378149 28.40221 -9.3116684 28.371111 -9.2733364 
  28.38805 -9.2352791 28.52527 -9.1625023 28.7286 -8.9919453 
  28.96166 -8.6677799 28.95583 -8.6052799 28.90082 -8.4877195) 
#(32.940681 -9.4062672 32.830818 -9.3663902 32.741928 -9.2816696 
  32.53693 -9.2611141 32.470821 -9.1605587 32.04221 -9.0408363 
  31.98444 -9.0730572 31.93749 -9.0291691 31.931379 -8.9800014 
  31.9561 -8.9308357 31.785549 -8.8850021 31.683599 -8.9088917 
  31.57305 -8.8186111 31.551661 -8.689167 31.39805 -8.6294441 
  31.375549 -8.5822239 31.27305 -8.6219463 31.220551 -8.5766659 
  31.169991 -8.5953827) #(33.028591 -9.4116688 
  32.997761 -9.3733349 32.940262 -9.4036121 32.940681 -9.4062672) 
#(28.521549 -9.378149 28.538811 -9.4285812) 
#(32.940681 -9.4062672 32.953869 -9.4894447 32.98502 -9.4810305) 
#(33.928139 -9.6998062 33.755821 -9.582777 33.676929 -9.6105576 
  33.578869 -9.5847235 33.508881 -9.6219463 33.428871 -9.6119461 
  33.393879 -9.5380554 33.301929 -9.4841671 33.192478 -9.5091686 
  33.028591 -9.4116688) #(-65.438316 -9.6827774 
  -65.570007 -9.8363895 -65.613052 -9.8330574 
  -65.706123 -9.7502785 -65.759171 -9.7700024 
  -65.782784 -9.731945 -65.798607 -9.7825031 
  -65.823639 -9.7563915 -66.029167 -9.8069458 
  -66.059174 -9.7883358 -66.559433 -9.8916702 
  -66.779167 -10.00667 -67.158043 -10.31317) 
#(-65.396057 -10.3953 -65.313606 -10.29389 
  -65.288887 -10.19556 -65.333618 -10.02611 
  -65.301392 -9.8372231 -65.381943 -9.6977806 
  -65.438316 -9.6827774) #(-67.158043 -10.31317 
  -67.300293 -10.31667 -67.674263 -10.60999) 
#(-67.674263 -10.60999 -67.703484 -10.6943) 
#(-70.533073 -10.93222 -70.631943 -11.00306 
  -70.62999 -10.51167 -70.628052 -9.8336124 
  -70.557503 -9.7761145 -70.537216 -9.6911135 
  -70.596657 -9.6061115 -70.569458 -9.5697231 
  -70.53389 -9.4538898 -70.584442 -9.4380569 
  -70.708893 -9.5433331 -70.906952 -9.7147236 
  -71.299156 -9.9963894 -71.501404 -10.00361 
  -72.185822 -10.00389 -72.150284 -9.8888912 
  -72.180283 -9.8013916 -72.271118 -9.7466679 
  -72.305557 -9.5300026 -72.428596 -9.483057 
  -72.586121 -9.4536133 -73.205276 -9.4072247 
  -72.975563 -9.1547241 -72.948608 -9.0838909 
  -72.964447 -8.9833336 -73.169998 -8.7102795 
  -73.297501 -8.6511145 -73.351936 -8.4683342 
  -73.533333 -8.3555555 -73.651108 -8.0161133 
  -73.767227 -7.9572229 -73.782227 -7.8711119 
  -73.714172 -7.8724999 -73.692757 -7.8091669 
  -73.710564 -7.77139 -73.833328 -7.7255559 
  -74.009453 -7.5350008 -73.948883 -7.501667 
  -73.972778 -7.3458352 -73.892502 -7.375001 
  -73.711403 -7.3191681 -73.704178 -7.2850008 
  -73.801468 -7.117239) #(-68.752502 -11.00972 
  -68.868332 -11.01611 -69.069733 -10.96639 
  -69.567436 -10.95047) #(-69.567436 -10.95047 
  -69.929169 -10.91445 -70.027496 -10.96806 
  -70.269447 -11.05861 -70.394173 -11.05111 
  -70.533073 -10.93222) #(-67.703484 -10.6943 
  -67.822243 -10.66333 -68.015007 -10.65917 
  -68.101936 -10.70528 -68.289436 -10.98556 
  -68.579178 -11.1046) #(-68.579178 -11.1046 
  -68.76445 -11.13972 -68.784439 -11.11972 
  -68.752502 -11.00972) #(22.244459 -11.25064 22.483601 -11.13 
  22.519711 -11.04195 22.58083 -11.03445 22.7236 -11.09333 
  22.86916 -11.05056 22.94277 -11.095 23.108049 -11.09195 
  23.39749 -10.97028 23.50305 -10.95972 23.85055 -11.02778 
  23.886101 -11.01472 23.982719 -10.86963) 
#(21.7836 -7.2816682 21.81971 -7.3255572 21.8461 -7.4525008 
  21.749439 -7.9450011 21.80916 -8.0622215 21.93721 -8.443058 
  21.86027 -8.854723 21.85471 -9.2294455 21.79055 -9.4055557 
  21.83499 -9.5336132 22.02499 -9.8513908 22.147209 -9.9113922 
  22.31444 -10.38584 22.26416 -10.50056 22.303329 -10.53778 
  22.313049 -10.76722 22.186661 -10.82917 22.16555 -10.87333 
  22.246099 -11.07306 22.244459 -11.25064) 
#(40.435551 -10.48045 40.42054 -10.50584 40.273869 -10.58667 
  40.165531 -10.67139 39.76693 -10.92056 39.628319 -10.94806 
  39.256939 -11.17083 38.89777 -11.17222 38.852772 -11.20722 
  38.672489 -11.27084 38.493309 -11.4171) 
#(33.928139 -9.6998062 33.95026 -9.5463905 33.98859 -9.4977779 
  34.043598 -9.484724 34.133869 -9.5672255 34.447762 -9.8994446 
  34.558041 -10.18028 34.570541 -10.44445 34.67609 -10.7475 
  34.593868 -11.02833 34.668591 -11.16334 34.763599 -11.345 
  34.823318 -11.34028 34.918591 -11.42806 34.963249 -11.56566) 
#(35.41914 -11.57212 34.962009 -11.5729) 
#(34.963249 -11.56566 34.962009 -11.5729) 
#(34.962009 -11.5729 34.958061 -11.57291) 
#(38.493309 -11.4171 38.102211 -11.25334 37.868591 -11.32667 
  37.843319 -11.40528 37.824711 -11.51472 37.791931 -11.56111 
  37.440262 -11.72556 37.34721 -11.68667 37.286098 -11.70417 
  37.10804 -11.66445 37.025822 -11.56723 36.824989 -11.57056 
  36.672211 -11.71611 36.537209 -11.72695 36.185539 -11.70417 
  36.16304 -11.57778 36.086369 -11.54306 35.933319 -11.43084 
  35.816929 -11.42083 35.6436 -11.58945 35.476372 -11.59806 
  35.41914 -11.57212) #(23.982719 -10.86963 24.131941 -10.91472 
  24.143049 -11.03778 24.32305 -11.05195 24.399719 -11.11417 
  24.410271 -11.28028 24.361099 -11.35528 24.30444 -11.37556 
  24.312771 -11.3975 24.39138 -11.40945 24.44833 -11.46361 
  24.53166 -11.45972 24.698601 -11.33861 24.8111 -11.32361 
  25.332211 -11.19333 25.34638 -11.21389 25.288601 -11.37639 
  25.359711 -11.64167 25.502489 -11.71945 25.49305 -11.76222 
  25.51833 -11.77834 25.56027 -11.75334 25.782221 -11.8025 
  25.87471 -11.78945 26.01722 -11.90361 26.4611 -11.91722) 
#(28.538811 -9.4285812 28.587219 -9.5700016 28.696381 -9.798336 
  28.6686 -9.8194466 28.62499 -10.1425 28.570271 -10.2225 
  28.69305 -10.66695 28.61832 -10.72167 28.507219 -10.99445 
  28.484159 -11.16806 28.39555 -11.39584 28.358049 -11.53417 
  28.463329 -11.79667 28.81221 -12.07195 29.03694 -12.38445 
  29.210819 -12.37222 29.48193 -12.46028 29.522221 -12.43695 
  29.525829 -12.39167 29.480551 -12.38556 29.459431 -12.28639 
  29.499161 -12.22945 29.80563 -12.15853) 
#(-63.918331 -12.54473 -63.95834 -12.53278 
  -64.394173 -12.46167 -64.498611 -12.36417 
  -64.469162 -12.2825 -64.485001 -12.23556 -64.51973 -12.24195 
  -64.680557 -12.16861 -64.691383 -12.1 -64.736656 -12.15306 
  -64.811943 -12.0275 -64.987503 -12.01056 -65.017227 -11.97 
  -64.99527 -11.91111 -65.120827 -11.69389 -65.165009 -11.7725 
  -65.208893 -11.71861 -65.1875 -11.65 -65.231377 -11.51 
  -65.315552 -11.48889 -65.351959 -11.38056 
  -65.325562 -11.33195 -65.385033 -11.29333 
  -65.400284 -11.16417 -65.299438 -10.97278 
  -65.328056 -10.85111 -65.409439 -10.79889 
  -65.443878 -10.51472 -65.404167 -10.44584 
  -65.396057 -10.3953) #(21.998529 -13.2535 21.998329 -13.00417 
  22.644159 -13.00528 23.331659 -13.00584 24.02055 -13.00639 
  24.016939 -12.98722 23.88694 -12.80472 23.914989 -12.66972 
  24.052219 -12.38528 24.03499 -12.26417 23.974991 -12.2 
  23.995541 -11.77167 24.02861 -11.45778 24.06221 -11.42195 
  23.982719 -10.86963) #(26.4611 -11.91722 26.723049 -12.01889 
  26.90221 -11.96111 26.986099 -11.87167 27.032221 -11.59611 
  27.108601 -11.58222 27.2136 -11.5825 27.2411 -11.79361 
  27.4786 -11.96667 27.547211 -12.18972 27.674721 -12.30278 
  27.79694 -12.29861 27.85471 -12.25334 27.955549 -12.30167 
  27.9811 -12.37056 28.04472 -12.365 28.151661 -12.43167 
  28.210819 -12.40139 28.3661 -12.45555 28.533331 -12.67139 
  28.493601 -12.74195 28.56999 -12.89084 28.596661 -12.89473 
  28.63249 -12.84084 28.678881 -12.84222 28.82222 -12.98917 
  28.84499 -13.09139 28.924709 -13.16028 28.96166 -13.34778 
  29.015829 -13.39778 29.06583 -13.38695 29.17083 -13.39972 
  29.589439 -13.22194 29.683599 -13.265 29.68277 -13.30611 
  29.62138 -13.37195 29.629709 -13.40945 29.663879 -13.43778 
  29.801941 -13.45195 29.803881 -12.82889 29.80563 -12.15853) 
#(34.862122 -13.49742 34.658039 -13.49639 34.569149 -13.34695 
  34.52998 -12.75889 34.444431 -12.50334 34.373871 -12.16722 
  34.614429 -11.76389 34.626091 -11.57583 34.958061 -11.57291) 
#(34.962009 -11.5729 34.88332 -12.0325 34.698318 -12.18056 
  34.694439 -12.44195 34.823879 -12.70667 34.752209 -12.91917 
  34.813599 -13.07695 34.788319 -13.32056 34.868599 -13.38639 
  34.865791 -13.50039) #(34.865791 -13.50039 34.862122 -13.49742) 
#(32.98502 -9.4810305 32.99332 -9.6216679 33.10471 -9.6627808 
  33.11776 -9.586668 33.229149 -9.6341667 33.23859 -9.7313881 
  33.36137 -9.8244457 33.39027 -9.9036121 33.359428 -9.9330578 
  33.324162 -10.06778 33.559429 -10.22722 33.572762 -10.40028 
  33.684978 -10.51334 33.693039 -10.58111 33.501659 -10.77972 
  33.396931 -10.79861 33.28693 -10.86555 33.250271 -10.8975 
  33.409149 -11.17 33.356651 -11.25611 33.230541 -11.57472 
  33.284431 -11.57056 33.323601 -11.60778 33.32999 -11.80722 
  33.271099 -12.13139 33.335258 -12.25778 33.394428 -12.34167 
  33.54443 -12.32778 33.537769 -12.36889 33.357208 -12.54333 
  33.28027 -12.52722 33.226929 -12.58834 33.13776 -12.58084 
  33.046379 -12.60389 32.96027 -12.76167 32.967758 -12.85056 
  33.035259 -12.91028 32.99276 -13.03695 33.012211 -13.215 
  32.822208 -13.53806 32.69054 -13.565 32.689701 -13.6225 
  32.78582 -13.64056 32.83276 -13.70972 32.77832 -13.74333 
  32.78249 -13.77556 32.899151 -13.82 33.004429 -14.03278 
  33.039989 -14.05278 33.161652 -13.92222 33.221802 -14.0111) 
#(34.865791 -13.50039 34.860538 -13.71361 35.072208 -13.74028 
  35.282211 -14.36306 35.2286 -14.39834 35.07082 -14.19778 
  34.946098 -14.14806 34.938881 -14.05361 34.858051 -14.00139 
  34.833599 -14.03584 34.86694 -14.09389 34.801659 -14.24584 
  34.701382 -14.27417 34.560551 -14.10167 34.5261 -13.95723 
  34.58527 -13.89111 34.627491 -13.69695 34.506939 -13.56223 
  34.46777 -13.58334 34.424431 -13.56278 34.310822 -13.37195 
  34.33638 -12.91584 34.262211 -12.82639 34.278049 -12.7425 
  34.226101 -12.71195 34.17944 -12.5975 34.201931 -12.49445 
  34.149712 -12.37945 34.081661 -12.38 34.027489 -12.19028 
  34.06805 -12.005 34.191101 -11.90445 34.193878 -11.80972 
  34.316662 -11.70723 34.326649 -11.64084 34.225819 -11.24278 
  34.246929 -11.11556 34.188042 -10.56639 34.26305 -10.43445 
  34.10416 -10.21584 33.98444 -10.03972 33.901371 -9.778059 
  33.928139 -9.6998062) #(-69.153717 -14.57234 
  -68.979172 -14.3675 -69.006958 -14.33361 
  -68.984444 -14.23028 -68.853333 -14.19917 -68.867767 -14.11 
  -68.977493 -13.96167 -68.982224 -13.86167 
  -69.085564 -13.67445 -69.080002 -13.64361 
  -69.011673 -13.63417 -68.964172 -13.48333 
  -68.974716 -12.92639 -68.881943 -12.75889 
  -68.804169 -12.73028 -68.731377 -12.66972 
  -68.781113 -12.61778 -68.6875 -12.51945 -68.770844 -12.30861 
  -69.150284 -11.63222 -69.567436 -10.95047) 
#(-60.43256 -14.81804 -60.353889 -14.60222 
  -60.34639 -14.48333 -60.448608 -14.29639 
  -60.480831 -14.15139 -60.384171 -13.98445 
  -60.482769 -13.79972 -60.79501 -13.67861 
  -61.040001 -13.51528 -61.067501 -13.47361 
  -61.160549 -13.52695 -61.338329 -13.48778 
  -61.44944 -13.54639 -61.52972 -13.54834 -61.593891 -13.50723 
  -61.695 -13.52611 -61.841671 -13.53861 -61.874439 -13.45222 
  -62.01722 -13.34861 -62.121941 -13.14834 
  -62.394718 -13.14195 -62.46944 -13.07111 
  -62.583889 -13.05861 -62.693611 -12.96611 
  -62.779171 -13.01084 -62.998051 -12.835 -63.07056 -12.65278 
  -63.136669 -12.63611 -63.24139 -12.70445 
  -63.678341 -12.46917 -63.81361 -12.465 -63.918331 -12.54473) 
#(30.21277 -14.98111 30.845551 -14.76389 31.38221 -14.645 
  31.58527 -14.56167 32.07777 -14.38806 33.221802 -14.0111) 
#(-60.571671 -15.0975 -60.383888 -15.09278 
  -60.43256 -14.81804) #(35.84182 -15.32784 35.800259 -15.17778 
  35.92416 -14.88556 35.8811 -14.885 35.877201 -14.65611 
  35.095261 -13.68611 34.865791 -13.50039) 
#(35.843578 -15.33422 35.84182 -15.32784) 
#(-69.368584 -15.51216 -69.327217 -15.43056 
  -69.275833 -15.40417 -69.285553 -15.35722 
  -69.140556 -15.25473 -69.138062 -15.22528 
  -69.278061 -15.11111 -69.384171 -14.95889 
  -69.361656 -14.79361 -69.239723 -14.72528 
  -69.245003 -14.61639 -69.22084 -14.57028 
  -69.153717 -14.57234) #(30.413879 -15.63361 30.357771 -15.55472 
  30.38805 -15.47889 30.358049 -15.33028 30.26833 -15.25084 
  30.21277 -14.98111) #(35.78693 -16.0625 35.867199 -15.41945 
  35.843578 -15.33422) #(21.998529 -13.2535 21.999439 -14.52111 
  22.00079 -16.170851) #(-68.958794 -16.2155 -68.970284 -16.2075 
  -69.100769 -16.215549) #(-69.100769 -16.215549 
  -69.150558 -16.218611 -69.214722 -16.156389 
  -69.422234 -15.61806 -69.368584 -15.51216) 
#(-60.571671 -15.0975 -60.227219 -15.47861 
  -60.160278 -16.26306) #(-68.879333 -16.270741 
  -68.919159 -16.24305 -68.958794 -16.2155) 
#(-69.368584 -15.51216 -69.385559 -15.49306 
  -69.436401 -15.49806 -69.523651 -15.39415 
  -69.700562 -15.25139 -69.755569 -15.25722 
  -69.718338 -15.30361 -69.835854 -15.2925 
  -69.884171 -15.30778 -69.869743 -15.35 -69.951134 -15.39834 
  -69.922234 -15.46611 -69.774437 -15.67306 
  -69.789726 -15.73306 -69.851387 -15.69528 -69.861954 -15.64 
  -69.945557 -15.57195 -69.975594 -15.71084 
  -70.021957 -15.69723 -70.041412 -15.73361 
  -70.006668 -15.86417 -69.858902 -15.93084 -69.795563 -15.905 
  -69.872513 -15.86861 -69.855827 -15.81028 
  -69.810287 -15.78639 -69.801392 -15.8175 
  -69.730293 -15.92417 -69.696404 -15.89611 
  -69.699173 -15.94723 -69.664169 -15.98167 
  -69.433899 -16.01445 -69.412514 -16.080561 
  -69.510559 -16.19417 -69.478348 -16.21862 
  -69.410278 -16.189449 -69.366386 -16.250839 
  -69.268066 -16.28751 -69.105827 -16.238899 
  -69.100769 -16.215549) #(-58.355549 -16.44055 
  -58.327499 -16.279169 -58.386669 -16.27667 
  -58.440552 -16.330009 -58.757778 -16.31889 
  -59.460831 -16.291389 -60.160278 -16.26306) 
#(30.413879 -15.63361 30.37805 -15.65056 29.831381 -15.61611 
  29.31916 -15.74861 29.13805 -15.86 28.927219 -15.97222 
  28.85833 -16.0625 28.85055 -16.399731 28.761909 -16.534401) 
#(28.761909 -16.534401 28.75976 -16.53767) 
#(-69.028122 -16.540871 -68.990829 -16.41972 
  -68.826111 -16.351391 -68.833633 -16.3025 
  -68.879333 -16.270741) #(-68.958794 -16.2155 
  -69.077789 -16.26667 -69.031403 -16.31778 
  -69.031403 -16.408621 -69.09584 -16.477779 
  -69.08168 -16.510839 -69.028122 -16.540871) 
#(35.137211 -16.55056 35.251659 -16.458611 35.29332 -16.22472 
  35.411652 -16.124451 35.606091 -16.13723 35.78693 -16.0625) 
#(-69.028122 -16.540871 -68.930573 -16.59556 
  -68.856117 -16.59528 -68.860573 -16.47084 
  -68.937233 -16.46612 -68.940567 -16.43251 
  -68.696121 -16.36639 -68.703613 -16.340839 
  -68.583359 -16.32917 -68.580566 -16.24028 
  -68.801392 -16.189171 -68.84584 -16.21973 
  -68.90834 -16.07028 -68.853622 -16.064171 
  -68.76918 -15.97722 -68.797501 -15.94972 
  -69.017807 -15.93056 -69.005836 -15.86917 
  -69.04335 -15.78861 -69.187233 -15.70778 -69.161667 -15.675 
  -69.26503 -15.67778 -69.325287 -15.56084 
  -69.368584 -15.51216) #(32.982201 -16.708611 
  32.768501 -16.717819) #(32.768501 -16.717819 32.70776 -16.68417 
  32.708321 -16.60778 32.655258 -16.58139 32.240261 -16.43889 
  32.062759 -16.449169 31.908051 -16.418329 31.76055 -16.24 
  31.42388 -16.16111 31.300831 -16.02862 31.05805 -16.02306 
  30.984711 -16.05917 30.9286 -16.00223 30.42277 -16.009171 
  30.413879 -15.63361) #(35.2906 -17.135811 35.308041 -17.06139 
  35.271099 -16.950279 35.30415 -16.846121 35.27137 -16.69722 
  35.168591 -16.62112 35.137211 -16.55056) 
#(33.221802 -14.0111 33.47887 -14.41056 33.549431 -14.44223 
  33.650539 -14.58945 33.69276 -14.59861 33.70776 -14.50056 
  33.73637 -14.4875 33.82555 -14.53389 33.932209 -14.47528 
  34.073879 -14.49389 34.30109 -14.40361 34.388882 -14.39722 
  34.5411 -14.61556 34.52248 -14.68861 34.566929 -14.78722 
  34.58971 -15.28278 34.425259 -15.49667 34.44331 -15.5475 
  34.409981 -15.67583 34.324162 -15.74361 34.260269 -15.80778 
  34.263599 -15.91639 34.427761 -16.06362 34.410542 -16.205 
  34.454151 -16.28417 34.57555 -16.323891 34.594429 -16.40472 
  34.761929 -16.53723 34.859711 -16.6775 35.049431 -16.823891 
  35.128319 -16.81695 35.146381 -16.84111 35.139149 -16.95195 
  35.052479 -17.027229 35.091648 -17.129169 35.2906 -17.135811) 
#(33.044922 -17.34626 32.968319 -17.147499 32.84248 -16.93111 
  32.943871 -16.832781 32.982201 -16.708611) 
#(14.20931 -17.38678 14.21805 -17.38695 15.62611 -17.388889 
  17.022499 -17.391939 18.407339 -17.38678) 
#(11.75375 -17.25786 11.97694 -17.16361 12.12305 -17.14834 
  12.24694 -17.226669 12.42833 -17.205561 12.45166 -17.25362 
  12.50861 -17.23889 12.93888 -17.011391 13.37416 -16.968889 
  13.49694 -17.026951 13.54472 -17.136669 13.98083 -17.424999 
  14.18777 -17.416389 14.20931 -17.38678) 
#(-57.94389 -17.4403 -58.209171 -17.354719 
  -58.39806 -17.248341 -58.464451 -16.90028 
  -58.466389 -16.638611 -58.347221 -16.50556 
  -58.355549 -16.44055) #(-57.87389 -17.493441 
  -57.94389 -17.4403) #(-69.499733 -17.50528 
  -69.501106 -17.378889 -69.590851 -17.29528 
  -69.652496 -17.285839 -69.618057 -17.18667 
  -69.385834 -17.05084 -69.411118 -17.020559 
  -69.343613 -16.9825 -69.166397 -16.72056 
  -69.094467 -16.70723 -69.002502 -16.64473 
  -69.037781 -16.60306 -69.037514 -16.57139 
  -69.028122 -16.540871) #(-57.752239 -17.585791 
  -57.87389 -17.493441) #(23.474859 -17.624531 
  24.23567 -17.48188) #(22.00079 -16.170851 22.070829 -16.23917 
  22.13888 -16.4925 22.24888 -16.57 23.20166 -17.479719 
  23.474859 -17.624531) #(25.265751 -17.797661 25.11832 -17.694731 
  25.03277 -17.5825 24.76388 -17.509729 24.23567 -17.48188) 
#(27.146219 -17.84528 27.21027 -17.749729 27.37978 -17.577499 
  27.42638 -17.57473 27.458611 -17.517229 27.551109 -17.502781 
  27.60972 -17.353621 27.651381 -17.32917 27.659439 -17.23362 
  27.92638 -17.091949 27.93388 -17.051121 28.01166 -17.055281 
  28.10055 -17.03112 28.04277 -16.98612 28.09222 -16.891399 
  28.13555 -16.840839 28.314159 -16.82056 28.357491 -16.75639 
  28.391661 -16.760839 28.3736 -16.790279 28.470831 -16.901119 
  28.43833 -16.81584 28.644991 -16.68973 28.69611 -16.686951 
  28.68722 -16.772511 28.74333 -16.81889 28.86277 -16.76195 
  28.84277 -16.689449 28.87805 -16.664169 28.92277 -16.71084 
  28.9986 -16.608061 28.93638 -16.597231 28.95388 -16.55862 
  28.8811 -16.58889 28.84416 -16.57362 28.88138 -16.554171 
  28.76749 -16.53723 28.761909 -16.534401) 
#(28.75976 -16.53767 28.259991 -16.724171 28.138599 -16.82362 
  27.82527 -16.959169 27.63888 -17.22472 27.61916 -17.337231 
  27.145821 -17.804449 27.146219 -17.84528) 
#(27.122431 -17.88076 27.146219 -17.84528) 
#(27.122431 -17.88076 27.03141 -17.95545) 
#(28.761909 -16.534401 28.651381 -16.47834 28.57305 -16.534731 
  28.51083 -16.56501 28.48888 -16.51417 28.396111 -16.60001 
  28.37583 -16.55389 28.27499 -16.54306 28.321659 -16.571671 
  28.32888 -16.599449 28.285271 -16.608891 28.25083 -16.65723 
  28.202499 -16.634729 28.161659 -16.64362 28.20388 -16.692499 
  28.073879 -16.75639 28.085831 -16.816669 28.015829 -16.85862 
  27.9086 -16.77084 27.87944 -16.805 27.845551 -16.820009 
  27.791941 -16.79973 27.770269 -16.853621 27.86833 -16.903061 
  27.69083 -16.946951 27.73999 -16.98473 27.658051 -17.06056 
  27.620831 -17.05167 27.55249 -17.160561 27.418329 -17.28334 
  27.453609 -17.31889 27.34222 -17.413891 27.314159 -17.466669 
  27.37999 -17.455009 27.37944 -17.479731 27.170549 -17.688339 
  27.03141 -17.95545) #(27.03141 -17.95545 27.020769 -17.96418) 
#(20.784861 -18.01173 20.3936 -17.887501 20.09972 -17.895559 
  19.91527 -17.85751 19.75555 -17.897499 19.662491 -17.837231 
  19.459709 -17.86167 18.91666 -17.81501 18.719709 -17.706949 
  18.48333 -17.440281 18.407339 -17.38678) 
#(21.382641 -18.01173 21.423599 -18.00667 22.83777 -17.747219 
  23.474859 -17.624531) #(20.784861 -18.01173 20.971661 -17.9625 
  21.242769 -17.938339 21.382641 -18.01173) 
#(27.020769 -17.96418 26.689159 -18.075279 26.46277 -17.968611 
  26.31472 -17.935841 26.214991 -17.884171 25.971661 -18.00639 
  25.859711 -17.973339 25.85416 -17.908621 25.71999 -17.83639 
  25.59972 -17.841391 25.391939 -17.85084 25.265751 -17.797661) 
#(-57.582581 -18.100439 -57.77528 -17.63695 
  -57.739719 -17.59528 -57.752239 -17.585791) 
#(33.044922 -17.34626 32.96027 -17.52084 33.04332 -17.61389 
  33.018589 -17.723339 32.966091 -17.84223 32.974701 -17.923611 
  32.946091 -17.975 32.975811 -18.101391) 
#(-57.5042 -18.177731 -57.565552 -18.14139 
  -57.582581 -18.100439) #(23.291451 -17.99815 
  21.46249 -18.304449 20.99544 -18.31741) 
#(-70.40332 -18.34799 -70.178329 -18.32889 
  -69.965843 -18.256109 -69.841667 -18.12862 
  -69.769173 -17.946951 -69.848343 -17.716669 
  -69.815002 -17.652229 -69.684158 -17.66362 
  -69.499733 -17.50528) #(33.001438 -18.405029 33.07304 -18.34889 
  32.966648 -18.23584 33.001099 -18.183331 32.975811 -18.101391) 
#(25.265751 -17.797661 24.82333 -17.840561 24.60194 -18.020559 
  24.496099 -18.05945 24.464161 -18.00806 24.381941 -17.946671 
  23.98888 -18.16445 23.82333 -18.32251 23.615549 -18.485279 
  23.570829 -18.46722 23.54888 -18.31723 23.461941 -18.226391 
  23.291451 -17.99815) #(-59.990841 -19.296671 
  -60.613621 -19.459169 -61.742771 -19.645) 
#(-68.684952 -19.70084 -68.480827 -19.44445 
  -68.4375 -19.437229 -68.462219 -19.39889 
  -68.740829 -19.17778 -68.952499 -18.967501 
  -68.93277 -18.88278 -69.000839 -18.743059 
  -69.027237 -18.466391 -69.148064 -18.137779 
  -69.075012 -18.07723 -69.078613 -18.018061 
  -69.139717 -18.0275 -69.265556 -17.96361 
  -69.303329 -17.963341 -69.335564 -17.781389 
  -69.491379 -17.628889 -69.499733 -17.50528) 
#(-58.1217 -19.740311 -57.793892 -19.08112 
  -57.70472 -19.04834 -57.71666 -18.946951 
  -57.77277 -18.909731 -57.551941 -18.23889 
  -57.491112 -18.238609 -57.458611 -18.20472 
  -57.5042 -18.177731) #(-57.847778 -19.978889 
  -58.1217 -19.740311) #(-58.158169 -20.168859 
  -57.847778 -19.978889) #(-58.158169 -20.168859 
  -58.151661 -19.82806 -58.232498 -19.782511 
  -59.10194 -19.348061 -59.990841 -19.296671) 
#(27.71397 -20.509859 27.35722 -20.465 27.287491 -20.49472 
  27.297211 -20.302509 27.21999 -20.091669 27.026661 -20.00028 
  26.969709 -20.009729 26.610821 -19.85445 26.5886 -19.79917 
  26.441099 -19.73111 26.40444 -19.675831 26.325821 -19.654449 
  26.348049 -19.597231 26.19194 -19.544729 25.961941 -19.100281 
  25.97332 -18.94556 25.808331 -18.776951 25.797489 -18.681669 
  25.659439 -18.53112 25.39333 -18.122511 25.30916 -18.06584 
  25.23666 -17.894449 25.265751 -17.797661) 
#(-61.742771 -19.645 -61.913059 -20.080009 
  -62.269451 -20.562229) #(33.001438 -18.405029 
  33.013599 -18.466949 32.888321 -18.53056 32.949711 -18.690281 
  32.92804 -18.767229 32.89999 -18.791109 32.817211 -18.779169 
  32.701099 -18.83695 32.720261 -18.88278 32.69915 -18.94445 
  32.716091 -19.02195 32.845261 -19.03723 32.852211 -19.286671 
  32.78471 -19.36639 32.783039 -19.467779 32.85054 -19.493891 
  32.845539 -19.684999 32.912762 -19.692499 32.953602 -19.648609 
  32.978588 -19.664169 32.975811 -19.73667 33.059429 -19.780279 
  33.03915 -19.81389 33.026649 -20.03112 32.953041 -20.03639 
  32.901089 -20.134729 32.665821 -20.55723 32.550819 -20.555 
  32.502209 -20.59861 32.483601 -20.661671 32.52137 -20.914169 
  32.360271 -21.135839 32.492168 -21.34646) 
#(29.08334 -21.825121 29.08083 -21.820841 28.56805 -21.631109 
  28.49194 -21.66083 28.35722 -21.60306 28.20277 -21.59667 
  28.01277 -21.561951 27.9086 -21.31389 27.739429 -21.145559 
  27.68527 -21.06362 27.71944 -20.811951 27.700821 -20.60667 
  27.72471 -20.567499 27.71397 -20.509859) 
#(29.25815 -22.066521 29.15666 -22.07695 29.073879 -22.037781 
  29.03722 -21.974171 29.037769 -21.89473 29.08334 -21.825121) 
#(-57.9828 -22.08923 -57.922779 -21.895281 
  -57.956669 -21.8475 -57.891949 -21.689449 
  -57.95417 -21.510839 -57.851398 -21.330549 
  -57.906658 -21.28112 -57.838329 -21.20056 
  -57.81945 -20.95611 -57.921108 -20.902229 
  -57.864449 -20.859171 -57.861389 -20.82917 
  -57.943329 -20.79417 -57.85973 -20.734449 
  -57.926392 -20.66695 -57.978882 -20.711109 
  -57.996948 -20.612221 -57.990841 -20.44084 
  -58.08556 -20.37112 -58.10556 -20.265011 
  -58.14278 -20.280279 -58.161942 -20.23667 
  -58.11972 -20.201111 -58.158169 -20.168859) 
#(-66.231667 -21.78751 -66.273621 -21.95723 
  -66.345551 -22.11445) #(-64.670273 -22.17112 
  -64.722778 -22.181391 -64.988602 -22.090839 -65.598892 -22.1 
  -65.768066 -22.10223 -65.926392 -21.933331 
  -66.041382 -21.91667 -66.077499 -21.831949 
  -66.231667 -21.78751) #(29.370529 -22.19138 
  29.25815 -22.066521) #(-57.9828 -22.08923 -57.87944 -22.13056 
  -57.64555 -22.099171 -57.614719 -22.173059 
  -57.516941 -22.184731 -57.320839 -22.20167 
  -57.177219 -22.215839 -57.000858 -22.23308) 
#(-62.269451 -20.562229 -62.259171 -21.05695 
  -62.63866 -22.236629) #(-62.63866 -22.236629 
  -62.78944 -22.12278 -62.80917 -21.996389) 
#(-57.000858 -22.23308 -56.87389 -22.245831 
  -56.875832 -22.285 -56.834171 -22.29834 -56.78083 -22.253059 
  -56.701111 -22.214451 -56.637779 -22.262779 
  -56.48634 -22.08267) #(-56.48634 -22.08267 
  -56.396389 -22.06695 -56.383888 -22.10112 
  -56.200279 -22.275841 -55.921669 -22.30056) 
#(-62.80917 -21.996389 -63.941109 -22.000839 
  -64.115829 -22.342779) #(32.492168 -21.34646 
  32.410259 -21.311119 31.39333 -22.35417 31.29763 -22.41614) 
#(31.29763 -22.41614 31.15583 -22.321671 30.86694 -22.29612 
  30.294991 -22.34334 30.2311 -22.292231 30.133051 -22.30056 
  29.76749 -22.13611 29.450821 -22.16334 29.370529 -22.19138) 
#(14.675 -22.638611 14.52833 -22.68195) 
#(-66.345551 -22.11445 -66.736938 -22.227501 
  -66.775009 -22.42695 -67.022781 -22.523899 
  -67.012512 -22.64278 -67.123047 -22.71806 
  -67.18367 -22.82156) #(-64.325012 -22.873619 
  -64.275284 -22.63389 -64.146118 -22.432779 
  -64.115829 -22.342779) #(-64.325012 -22.873619 
  -64.34584 -22.847231 -64.456673 -22.632231 
  -64.433319 -22.54278 -64.566101 -22.361389 
  -64.539169 -22.27639 -64.561943 -22.24361 
  -64.670273 -22.17112) #(-68.684952 -19.70084 
  -68.696953 -19.740561 -68.541107 -19.84473 
  -68.574448 -20.05751 -68.650558 -20.056669 
  -68.786942 -20.10334 -68.774719 -20.13167 
  -68.710281 -20.14917 -68.726097 -20.23111 
  -68.668327 -20.32778 -68.757507 -20.37611 
  -68.749451 -20.43306 -68.684738 -20.509729 
  -68.488602 -20.60778 -68.46611 -20.64473 
  -68.567497 -20.742229 -68.550827 -20.909451 
  -68.50029 -20.939449 -68.421112 -20.939171 
  -68.188606 -21.296949 -68.188606 -21.60639 
  -68.105827 -21.7425 -68.084442 -21.966949 
  -67.970551 -22.06473 -67.922501 -22.241949 
  -67.935822 -22.29612 -67.886124 -22.438339 
  -67.876389 -22.82806 -67.793327 -22.878059 
  -67.579453 -22.901119 -67.18367 -22.82156) 
#(14.45084 -23.151159 14.73222 -23.233061 14.66805 -22.984171 
  14.675 -22.638611) #(-67.18367 -22.82156 -67.001106 -23.002781 
  -67.151321 -23.39765) #(-60.313061 -24.020281 
  -60.640839 -23.895559 -61.015011 -23.80611 
  -61.124168 -23.59778 -61.22472 -23.555281 
  -61.619999 -23.285839 -61.999168 -22.99472 
  -62.005562 -22.94223 -62.26083 -22.600281 
  -62.237499 -22.56695 -62.25861 -22.51889 
  -62.628052 -22.303329 -62.62389 -22.249161 
  -62.63866 -22.236629) #(-54.243061 -24.052231 
  -54.42889 -23.900841 -54.63805 -23.80751 
  -54.932499 -23.968611 -55.204441 -24.018339 
  -55.396671 -23.971121 -55.418892 -23.939171 
  -55.44194 -23.70084 -55.522499 -23.596951 
  -55.502781 -23.378889 -55.550549 -23.31917 
  -55.527222 -23.219999 -55.630001 -22.98695 
  -55.610001 -22.708611 -55.730831 -22.53945 
  -55.745548 -22.395281 -55.85973 -22.28334 
  -55.921669 -22.30056) #(-59.638248 -24.24752 
  -60.038059 -24.009729 -60.17028 -24.04167 
  -60.313061 -24.020281) #(29.370529 -22.19138 
  29.08749 -22.224171 28.96055 -22.313339 28.96582 -22.386391 
  28.91777 -22.45834 28.634439 -22.563339 28.439711 -22.57362 
  28.18416 -22.684731 28.14916 -22.780001 28.04277 -22.84111 
  28.052219 -22.88139 28.024441 -22.92445 27.938601 -22.955561 
  27.928329 -23.05806 27.81749 -23.109171 27.78611 -23.165279 
  27.736931 -23.23 27.601379 -23.22028 27.572769 -23.28945 
  27.52055 -23.38361 27.395821 -23.390841 27.10277 -23.57667 
  27.067209 -23.66083 27.03249 -23.65472 26.999161 -23.648609 
  26.959431 -23.75362 26.84527 -24.26445 26.554991 -24.436939 
  26.46471 -24.580561 26.40288 -24.63044) 
#(25.86595 -24.738661 26.359989 -24.618891 26.40288 -24.63044) 
#(20.99544 -18.31741 20.993601 -19.299721 20.99332 -20.647221 
  20.99194 -21.99695 19.995819 -22.0014 19.99666 -22.073891 
  19.99888 -23.42667 20.00141 -24.76363) 
#(-54.401901 -24.823589 -54.311939 -24.609171 
  -54.331669 -24.492781 -54.274441 -24.41139 
  -54.253059 -24.33139 -54.31945 -24.237221 
  -54.329441 -24.12167 -54.243061 -24.052231) 
#(25.86595 -24.738661 25.832211 -25.028061) 
#(-54.596111 -25.574869 -54.617222 -25.438061 
  -54.42223 -25.13695 -54.457779 -25.04973 
  -54.401901 -24.823589) #(25.58709 -25.62104 
  25.832211 -25.028061) #(-54.596111 -25.574869 
  -54.426109 -25.684999 -54.380001 -25.577499 
  -54.278339 -25.548889 -54.24194 -25.59667 
  -54.176392 -25.57362 -54.203609 -25.53112 
  -54.095829 -25.49861 -54.11417 -25.56723 
  -54.08083 -25.598339 -54.067501 -25.55056 
  -53.968071 -25.58823) #(31.29763 -22.41614 31.561661 -23.18667 
  31.550831 -23.476669 31.683599 -23.613621 31.769711 -23.85639 
  31.876381 -23.9275 31.88583 -24.17112 32.016102 -24.45945 
  32.018589 -25.035 31.988319 -25.518061 32.019981 -25.65028 
  31.919439 -25.814171 31.967739 -25.958179) 
#(31.967739 -25.958179 32.089981 -26.009451 32.103039 -26.16222 
  32.0611 -26.261391 32.072208 -26.393339 32.12915 -26.50584 
  32.13422 -26.84057) #(32.33305 -26.860279 32.893089 -26.846439) 
#(32.33305 -26.860279 32.13422 -26.84057) 
#(20.692341 -26.89468 20.897209 -26.794729 21.144159 -26.866671 
  21.3486 -26.827499 21.523609 -26.85334 21.69305 -26.85305 
  21.77861 -26.77084 21.759991 -26.69195 21.79138 -26.671671 
  21.89888 -26.668329 22.067209 -26.614731 22.17944 -26.42778 
  22.461941 -26.215 22.71277 -25.999161 22.72249 -25.937229 
  22.769159 -25.823059 22.73027 -25.788891 22.81888 -25.66806 
  22.813049 -25.56389 22.92638 -25.38389 23.10471 -25.30028 
  23.458321 -25.278339 23.49638 -25.333891 23.73444 -25.462219 
  23.84416 -25.574169 24.007219 -25.622511 24.000271 -25.65889 
  24.15027 -25.62167 24.266109 -25.696671 24.39333 -25.762779 
  24.4461 -25.735559 24.50444 -25.76306 24.80777 -25.830839 
  25.03694 -25.728609 25.15221 -25.76222 25.386379 -25.746389 
  25.58709 -25.62104) #(20.692341 -26.89468 20.63694 -26.81278 
  20.61138 -26.449169 20.693331 -26.38612 20.860821 -26.13361 
  20.75666 -25.78195 20.67971 -25.679449 20.687771 -25.57889 
  20.631941 -25.51889 20.673321 -25.45916 20.55555 -25.379999 
  20.38999 -25.036949 20.17499 -24.892229 20.00141 -24.76363) 
#(-53.838902 -27.17169 -53.698608 -26.88945 
  -53.711681 -26.83473 -53.750561 -26.766951 
  -53.72694 -26.675831 -53.71278 -26.360559 
  -53.65028 -26.26306 -53.660278 -26.19973 
  -53.827229 -25.95278 -53.827499 -25.85112 
  -53.894718 -25.629169 -53.95805 -25.64444 
  -53.968071 -25.58823) #(-58.60265 -27.29418 
  -58.65889 -27.181391 -58.63612 -27.13723 
  -58.56361 -27.116949 -58.546108 -27.045839 
  -58.509731 -27.05862 -58.47361 -26.936119 
  -58.31778 -26.87834 -58.34222 -26.81389 -58.246109 -26.76473 
  -58.239719 -26.649731 -58.185268 -26.658621 
  -58.168331 -26.596951 -58.21806 -26.54056 
  -58.207218 -26.494169 -58.211391 -26.425831 
  -58.169449 -26.34223 -58.17223 -26.272779 
  -58.104721 -26.24028 -58.121941 -26.218889 
  -57.853889 -25.996389 -57.900829 -25.952499 
  -57.750011 -25.716669 -57.75111 -25.67 -57.575569 -25.573059 
  -57.557781 -25.433331 -57.640282 -25.378889 
  -57.65028 -25.330009 -57.870548 -25.08778 
  -57.980831 -25.077499 -58.228611 -24.938339 
  -58.338051 -24.997499 -58.460831 -24.852501 
  -58.686661 -24.81612 -58.885559 -24.726391 
  -59.13139 -24.59889 -59.426392 -24.39834 
  -59.615841 -24.28639 -59.638248 -24.24752) 
#(32.13422 -26.84057 32.006939 -26.80862 31.958599 -27.11278 
  31.983601 -27.316669 31.51749 -27.313061 31.161659 -27.203051 
  30.983049 -27.029449 30.899441 -26.77195 30.81888 -26.81056 
  30.8036 -26.702499 30.802219 -26.462219 31.063881 -26.091391 
  31.12833 -25.913891 31.320551 -25.75528 31.421659 -25.72834 
  31.87805 -25.99556 31.967739 -25.958179) 
#(-55.785381 -27.43449 -55.603611 -27.34639 
  -55.581669 -27.30195 -55.598881 -27.16445 
  -55.451939 -27.091391 -55.445831 -27.023899 
  -55.396111 -26.97167 -55.25111 -26.936119 
  -55.18639 -26.96278 -55.12611 -26.945 -55.117771 -26.85778 
  -54.95055 -26.770559 -54.930561 -26.688339 
  -54.883331 -26.656111 -54.803612 -26.659451 
  -54.63361 -26.200279 -54.663059 -25.977221 
  -54.601669 -25.95278 -54.644169 -25.65695 
  -54.583889 -25.636669 -54.596111 -25.574869) 
#(-56.784199 -27.492331 -56.874168 -27.42112 
  -56.932499 -27.423059 -57.059441 -27.48889 
  -57.404449 -27.42417 -57.735561 -27.305281 
  -58.01112 -27.270281 -58.60265 -27.29418) 
#(-56.76926 -27.499741 -56.784199 -27.492331) 
#(-55.785381 -27.43449 -55.88805 -27.333891 
  -56.0425 -27.303619 -56.148609 -27.312229 
  -56.274719 -27.396111 -56.271111 -27.46139 
  -56.361111 -27.584169 -56.392231 -27.586121 
  -56.452782 -27.55084 -56.515011 -27.46417 
  -56.585831 -27.448059 -56.673328 -27.46139 
  -56.726101 -27.50362 -56.76926 -27.499741) 
#(19.99725 -28.426359 19.9986 -27.471951 20.000271 -26.11945 
  20.00141 -24.76363) #(16.483021 -28.580339 16.678049 -28.46056 
  16.72777 -28.496111 16.803329 -28.36445 16.778879 -28.32473 
  16.773609 -28.259451 16.82444 -28.26112 16.80722 -28.21833 
  16.85166 -28.212219 16.83861 -28.16861 16.882771 -28.17695 
  16.88166 -28.139721 16.91749 -28.06389 17.09499 -28.03639 
  17.19416 -28.121389 17.18416 -28.202499 17.221661 -28.24472 
  17.261379 -28.23694 17.348881 -28.23667 17.39916 -28.34778 
  17.38805 -28.42305 17.321939 -28.467779 17.359989 -28.516399 
  17.409439 -28.716391 17.59527 -28.69334 17.604441 -28.75695 
  17.65555 -28.775841 17.708599 -28.751671 18.183599 -28.90889 
  18.63999 -28.846951 18.957769 -28.868059 19.009439 -28.93222 
  19.12944 -28.960831 19.294991 -28.89361 19.239161 -28.798889 
  19.27416 -28.731951 19.466379 -28.69972 19.569441 -28.52639 
  19.99725 -28.426359) #(27.014721 -29.641729 27.349991 -29.481951 
  27.456659 -29.291109 27.73138 -28.941111 27.87999 -28.9125 
  27.929991 -28.85334 27.980551 -28.88306 28.146379 -28.723049 
  28.6511 -28.56945 28.700411 -28.61367) 
#(-67.151321 -23.39765 -67.339996 -24.023899 
  -68.252502 -24.396391 -68.289436 -24.457781 
  -68.392227 -24.50584 -68.443878 -24.62639 
  -68.491096 -24.60667 -68.571671 -24.805281 
  -68.545273 -24.873619 -68.455002 -24.905001 
  -68.354446 -25.129169 -68.397781 -25.14028 
  -68.502502 -25.177231 -68.575562 -25.355 
  -68.595284 -25.50556 -68.484734 -25.778339 
  -68.404167 -26.173889 -68.570557 -26.317499 
  -68.579727 -26.520559 -68.287216 -26.915279 
  -68.320282 -27.044729 -68.525284 -27.088341 
  -68.588333 -27.16972 -68.738892 -27.10334 
  -68.811111 -27.12056 -68.878601 -27.237499 
  -68.865837 -27.288059 -68.939163 -27.417219 
  -69.006958 -27.458891 -69.186111 -27.965839 
  -69.304443 -28.00362 -69.410294 -28.2125 
  -69.476387 -28.191389 -69.529999 -28.312229 
  -69.656952 -28.405279 -69.666412 -28.572781 
  -69.704453 -28.59334 -69.800278 -29.108061 
  -70.027222 -29.28195 -70.035004 -29.355 
  -70.003067 -29.423889 -69.96167 -29.680559 
  -69.917503 -29.713341) #(-57.613529 -30.18268 
  -57.533619 -30.16334 -57.319729 -29.975281 
  -57.29306 -29.81889 -57.250278 -29.787781 
  -57.110561 -29.76667 -57.041389 -29.702221 
  -56.690281 -29.33445 -56.64167 -29.19611 
  -56.571671 -29.124729 -56.418331 -29.056391 
  -56.40472 -28.9625 -56.315552 -28.91222 -56.28944 -28.784731 
  -56.015282 -28.59111 -56.018608 -28.50778 
  -55.89362 -28.464451 -55.90028 -28.380831 
  -55.873611 -28.35639 -55.812222 -28.35639 
  -55.692501 -28.40889 -55.66806 -28.34528 -55.67889 -28.3025 
  -55.773331 -28.246389 -55.756672 -28.219999 
  -55.440552 -28.079451 -55.374168 -27.97361 
  -55.180561 -27.855841 -55.12611 -27.885839 -55.105831 -27.85 
  -55.029171 -27.853889 -55.021671 -27.833891 
  -55.081951 -27.79056 -55.073059 -27.771669 
  -54.993061 -27.788059 -54.91222 -27.737221 
  -54.80611 -27.530279 -54.753059 -27.56056 
  -54.579731 -27.448339 -54.53722 -27.49111 
  -54.448051 -27.465281 -54.45417 -27.411949 
  -54.354172 -27.45389 -54.345829 -27.39945 
  -54.307781 -27.431669 -54.279171 -27.42417 
  -54.230549 -27.34584 -54.167782 -27.25 -54.148609 -27.289169 
  -54.091942 -27.28334 -53.877781 -27.11945 
  -53.838902 -27.17169) #(27.380989 -30.31601 27.395269 -30.12833 
  27.328051 -30.13945 27.014721 -29.641729) 
#(27.380989 -30.31601 27.459709 -30.311951 27.564131 -30.40341) 
#(28.700411 -28.61367 28.976101 -28.88722 29.073879 -28.966669 
  29.33305 -29.092501 29.455549 -29.35334 29.418051 -29.433331 
  29.35722 -29.45056 29.293329 -29.504999 29.31221 -29.576111 
  29.166929 -29.672501 29.12471 -29.83223 29.15749 -29.851669 
  29.1611 -29.92112 28.785271 -30.103609 28.54472 -30.11445 
  28.241659 -30.26306 28.217489 -30.301121 28.2575 -30.32667 
  28.144711 -30.45417 28.15999 -30.498329 28.09194 -30.60334 
  28.097771 -30.65889 27.738041 -30.59778 27.69083 -30.548611 
  27.564131 -30.40341) #(-58.198299 -32.45335 
  -58.101391 -32.32806 -58.099442 -32.259178 
  -58.184441 -32.15501 -58.146389 -31.99028 
  -58.18388 -31.921671 -58.17889 -31.85417 -58.03722 -31.78639 
  -57.97916 -31.610279 -57.98695 -31.552509 
  -58.077499 -31.484171 -58.076111 -31.456671 
  -57.988892 -31.40167 -57.851669 -31.046391 
  -57.91029 -30.93417 -57.81361 -30.91222 
  -57.795841 -30.876949 -57.808891 -30.73473 
  -57.889999 -30.59223 -57.874722 -30.50445 
  -57.757511 -30.428341 -57.62611 -30.285839 
  -57.640282 -30.190001 -57.613529 -30.18268) 
#(-57.613529 -30.18268 -57.566952 -30.205561 
  -57.568062 -30.252781 -57.521671 -30.27528 
  -57.214161 -30.29278 -57.150551 -30.24334 
  -57.14555 -30.184999 -57.071671 -30.109449 
  -56.97583 -30.100559 -56.79528 -30.11278 -56.61945 -30.25223 
  -56.625271 -30.294729 -56.27417 -30.528891 
  -56.163891 -30.645559 -56.001949 -30.796391 
  -55.976662 -30.860279 -56.00695 -30.94445 
  -56.000561 -31.08223 -55.8325 -31.071119 -55.71666 -30.94223 
  -55.642231 -30.94195 -55.629169 -30.84861 
  -55.576672 -30.84861 -55.41555 -30.97139 
  -55.235828 -31.245279 -55.065281 -31.32695 -55.02 -31.270559 
  -54.90834 -31.376671 -54.588051 -31.46278 
  -54.47028 -31.58139 -54.46389 -31.672501 -54.12418 -31.91556 
  -54.067219 -31.875 -53.907501 -31.949169 
  -53.863892 -32.011681 -53.746948 -32.055561 
  -53.718891 -32.14278 -53.62944 -32.366119 
  -53.40028 -32.57056 -53.25528 -32.602791 
  -53.171741 -32.666061) #(-53.171741 -32.666061 
  -53.095001 -32.724171 -53.111671 -32.74696 
  -53.49667 -33.092781 -53.53056 -33.199451 
  -53.50111 -33.408051 -53.52417 -33.580841 
  -53.52412 -33.585152) #(-53.52412 -33.585152 
  -53.52306 -33.6814 -53.37582 -33.74773) 
#(-69.917503 -29.713341 -69.905838 -29.814449 
  -69.967499 -30.088619 -69.841667 -30.12056 
  -69.827499 -30.15889 -69.897781 -30.32251 
  -69.944443 -30.37639 -70.044159 -30.396669 
  -70.130547 -30.354719 -70.165833 -30.37084 
  -70.134171 -30.43972 -70.300278 -30.77639 
  -70.330002 -30.953609 -70.258057 -31.039169 
  -70.313606 -31.03195 -70.349167 -31.07445 
  -70.420273 -31.154169 -70.445541 -31.09306 
  -70.47139 -31.098061 -70.533333 -31.188061 
  -70.587219 -31.566669 -70.468887 -31.808901 
  -70.416397 -31.87834 -70.278343 -31.897221 
  -70.231949 -31.968889 -70.273064 -32.048069 
  -70.33168 -32.039181 -70.37999 -32.05167 
  -70.329178 -32.197231 -70.235001 -32.326401 
  -70.232773 -32.425838 -70.166107 -32.4589 
  -70.146118 -32.506119 -70.171112 -32.607792 
  -70.144173 -32.761681 -69.992767 -32.895561 
  -70.101669 -33.03001 -70.098892 -33.172508 
  -70.023064 -33.27029 -69.976936 -33.298901 
  -69.935547 -33.243622 -69.898621 -33.237511 
  -69.79834 -33.286129 -69.779167 -33.40556 
  -69.87027 -33.564449 -69.848343 -33.724171 
  -69.904167 -33.769169 -69.900284 -33.960831 
  -69.849167 -33.971951 -69.866096 -34.143902 
  -69.813049 -34.229721 -69.828339 -34.250851 
  -70.023903 -34.275009 -70.054993 -34.298351 
  -70.047501 -34.409168 -70.224716 -34.59528 
  -70.23555 -34.66695 -70.313606 -34.74889 
  -70.263634 -34.797791 -70.361938 -35.004452 
  -70.361656 -35.142502 -70.386124 -35.171669 
  -70.541382 -35.2089 -70.569458 -35.254459 
  -70.550278 -35.296669 -70.423317 -35.340839 
  -70.460831 -35.38834 -70.396118 -35.515011 
  -70.420273 -35.64362 -70.337784 -35.808338 
  -70.409729 -35.963619 -70.369453 -36.04668 
  -70.426666 -36.135551) #(-70.426666 -36.135551 
  -70.580002 -36.148621 -70.706673 -36.2775 
  -70.700562 -36.409161 -70.730827 -36.424721 
  -70.893623 -36.402222 -70.941101 -36.48444 
  -71.037781 -36.486111 -71.057503 -36.562778 
  -71.043327 -36.679729 -71.063606 -36.699451 
  -71.107498 -36.67556 -71.138344 -36.69083 
  -71.186943 -36.848888 -71.12999 -36.962231 
  -71.200287 -36.97583 -71.079453 -37.104172 
  -71.196663 -37.313622 -71.109734 -37.453609 
  -71.112213 -37.489449 -71.180283 -37.634731 
  -71.176392 -37.713341 -71.077217 -37.94223 
  -70.97084 -38.41806 -70.825844 -38.55167 
  -70.835281 -38.60001 -70.876663 -38.638901 
  -70.869453 -38.695 -71.059433 -38.75029 
  -71.397781 -38.916111 -71.41861 -38.96056 
  -71.403061 -39.090279 -71.404449 -39.333061 
  -71.473053 -39.393902 -71.45195 -39.438332 
  -71.541107 -39.531391 -71.485817 -39.55751 
  -71.488327 -39.59306 -71.516113 -39.620281 
  -71.685547 -39.56945 -71.710564 -39.637218 
  -71.669449 -39.857231 -71.605827 -39.906391 
  -71.670837 -40.100559 -71.726936 -40.092232 
  -71.806107 -40.09362 -71.807503 -40.168339 
  -71.791382 -40.245838 -71.715561 -40.304169 
  -71.702499 -40.276402 -71.664436 -40.303341 
  -71.719727 -40.42778 -71.791382 -40.415279 
  -71.837784 -40.531681 -71.950562 -40.732769 
  -71.837509 -40.953899 -71.853882 -41.115559) 
#(-71.651314 -43.920731 -71.694992 -43.877781 
  -71.741943 -43.768341 -71.777222 -43.779449 
  -71.809433 -43.736389 -71.690277 -43.672508 
  -71.70723 -43.592232 -71.874161 -43.536671 
  -71.847778 -43.481392 -71.86972 -43.456402 
  -71.921944 -43.45779 -71.922501 -43.378059 
  -71.736938 -43.293072 -71.732773 -43.188061 
  -71.751106 -43.167511 -72.053047 -43.104721 
  -72.106377 -43.055 -72.139717 -42.99139 -72.102493 -42.84861 
  -72.132217 -42.66 -72.113617 -42.528881 
  -72.025833 -42.477501 -72.071671 -42.429729 
  -72.043327 -42.366402 -72.131668 -42.28194 
  -72.017776 -42.13361 -71.970551 -42.125 
  -71.914169 -42.178059 -71.735001 -42.103901 
  -71.91806 -41.626389 -71.839722 -41.56834 
  -71.899437 -41.35862 -71.853882 -41.115559) 
#(-71.648827 -43.923161 -71.651314 -43.920731) 
#(-71.660004 -43.961121 -71.648827 -43.923161) 
#(-71.66835 -43.967369 -71.660004 -43.961121) 
#(-71.751938 -46.341331 -71.761124 -46.224449 
  -71.872498 -46.16555 -71.897781 -46.140289 
  -71.771667 -46.119999 -71.601936 -45.97472 
  -71.637787 -45.892231 -71.759171 -45.84417 
  -71.791946 -45.725559 -71.740829 -45.584171 
  -71.707497 -45.536961 -71.502792 -45.51556 
  -71.467499 -45.477501 -71.506668 -45.411381 
  -71.296951 -45.30584 -71.330002 -45.228329 
  -71.453613 -45.159168 -71.498047 -45.075562 
  -71.591667 -44.97139 -72.071121 -44.897789 
  -72.081123 -44.774731 -72.052223 -44.753891 
  -71.938316 -44.78418 -71.482773 -44.74445 
  -71.339722 -44.803341 -71.271118 -44.79446 
  -71.220284 -44.73333 -71.233322 -44.662781 
  -71.212784 -44.628342 -71.126389 -44.57584 
  -71.110283 -44.528061 -71.203613 -44.42696 
  -71.833618 -44.397781 -71.853882 -44.365292 
  -71.794159 -44.312511 -71.852493 -44.105289 
  -71.66835 -43.967369) #(-71.75174 -46.343731 
  -71.751938 -46.341331) #(-71.672562 -46.530731 
  -71.75174 -46.343731) #(-72.017838 -47.271549 
  -72.027222 -47.243622 -72.017227 -47.19973 
  -71.877777 -47.229729 -71.852493 -47.182781 
  -71.864441 -47.137501 -71.985283 -47.073898 
  -71.995537 -47.048901 -71.904716 -47.000839 
  -71.961121 -46.94389 -71.933319 -46.80611 
  -71.809158 -46.78418 -71.669449 -46.67918 
  -71.672562 -46.530731) #(-72.016273 -47.276211 
  -72.017838 -47.271549) #(-72.042503 -47.299728 
  -72.016273 -47.276211) #(-72.044273 -47.301449 
  -72.042503 -47.299728) #(-72.604027 -48.481411 
  -72.287216 -48.341942 -72.323059 -48.075569 
  -72.529999 -47.94389 -72.535278 -47.909161 
  -72.305557 -47.507229 -72.357773 -47.464451 
  -72.313606 -47.426121 -72.156387 -47.409439 
  -72.044273 -47.301449) #(-72.603409 -48.48428 
  -72.604027 -48.481411) #(-72.672638 -48.87627 
  -72.553047 -48.783619 -72.551941 -48.71806 
  -72.603409 -48.48428) #(-72.698608 -48.896389 
  -72.672638 -48.87627) #(-73.282654 -50.31826 
  -73.351936 -50.23444 -73.52861 -50.144718 
  -73.535828 -50.116661 -73.467216 -50.006672 
  -73.561661 -49.91917 -73.444443 -49.782501 
  -73.536942 -49.678619 -73.510277 -49.613331 
  -73.58168 -49.53194 -73.529716 -49.496399 
  -73.538887 -49.440552 -73.449722 -49.379719 
  -73.464722 -49.31139 -73.134171 -49.303619 
  -73.131943 -49.260841 -73.177223 -49.22139 
  -73.075562 -49.065552 -72.951683 -48.964729 
  -72.803329 -48.94389 -72.698608 -48.896389) 
#(-73.277802 -50.324131 -73.282654 -50.31826) 
#(-73.26712 -50.354118 -73.277802 -50.324131) 
#(-73.265007 -50.360001 -73.26712 -50.354118) 
#(-71.910202 -51.996799 -71.962784 -51.960281 
  -71.940552 -51.886669 -71.971657 -51.845009 
  -72.295273 -51.691109 -72.331123 -51.587219 
  -72.42305 -51.57695 -72.438316 -51.54612 
  -72.339722 -51.47583 -72.247772 -51.232498 
  -72.385559 -51.146111 -72.391953 -51.09639 
  -72.267227 -51.017231 -72.242493 -50.851109 
  -72.341667 -50.7439 -72.294159 -50.649731 
  -72.37027 -50.614449 -72.539993 -50.612228 
  -72.597778 -50.666672 -72.64917 -50.670841 
  -72.732773 -50.621391 -72.781113 -50.625011 
  -73.018066 -50.749451 -73.12999 -50.772221 
  -73.174156 -50.74472 -73.253891 -50.559441 
  -73.265007 -50.360001) #(-69.998611 -51.996391 
  -70.857773 -51.997219 -71.910202 -51.996799) 
#(-68.429153 -52.375439 -68.434433 -52.329182 
  -69.233612 -52.14333 -69.461403 -52.14362 
  -69.998611 -51.996391) #(-68.632919 -54.500229 
  -68.628883 -53.99139 -68.624161 -53.317791 
  -68.618332 -52.64362) #(-68.633301 -54.547409 
  -68.632919 -54.500229) #(-68.636932 -54.788219 
  -68.634171 -54.658611 -68.633301 -54.547409) 
#(3.113055 50.79332 3.0352769 50.773869 2.9012849 50.697048) 
#(2.9012849 50.697048 2.781944 50.75555 2.6294439 50.824711 
  2.6125 50.887211 2.541667 51.091099) 
#(4.1683321 49.981369 4.1500001 49.98637 4.226388 50.0811 
  4.1377769 50.13776 4.2161102 50.26527 4.0908332 50.31443 
  3.7636111 50.351929 3.7252769 50.313599 3.6719439 50.346371 
  3.668889 50.444149 3.602222 50.497211 3.3672221 50.495541 
  3.28 50.538319 3.281388 50.594151 3.1933329 50.741371 
  3.113055 50.79332) #(5.7052078 49.535229 5.7830381 49.527271) 
#(5.7052078 49.535229 5.4730549 49.5061 5.4233322 49.60915 
  5.3072209 49.63081 5.329721 49.659981 5.2761111 49.698589 
  5.2169442 49.69054 5.0977769 49.768589 4.8580542 49.796379 
  4.8811102 49.9147 4.8008318 49.97776 4.851943 50.07943 
  4.8763881 50.15498 4.7575002 50.129429 4.6736102 49.99638 
  4.458333 49.938591 4.1683321 49.981369) 
#(5.7830381 49.527271 5.9633331 49.488319 5.9813881 49.448318 
  6.165277 49.504711 6.3622208 49.45998) 
#(7.588799 47.58456 7.5213881 47.525822 7.4527769 47.469978 
  7.3956099 47.439671) #(7.3956099 47.439671 7.1783319 47.44582 
  7.1980538 47.495258 6.9905548 47.497211 7.0077772 47.45499 
  6.978333 47.444149 6.8811102 47.35693 7.0230551 47.371651 
  7.0616651 47.345539 7.0108328 47.30526) 
#(7.0108328 47.30526 6.9483318 47.291931 6.6944432 47.068321) 
#(6.6944432 47.068321 6.7027769 47.038601 6.5872211 46.987759 
  6.434721 46.926929 6.4527769 46.774429 6.3250222 46.704479) 
#(6.2439308 46.322392 6.246387 46.357769 6.3283329 46.406929 
  6.6336112 46.464149 6.7961102 46.432491 6.808887 46.411091 
  6.8049369 46.405499) #(6.3250222 46.704479 6.1299992 46.593319 
  6.0780549 46.460819 6.1244431 46.40192 6.1144438 46.257771 
  6.060832 46.250542 5.9661102 46.205261 6.0 46.17416 
  5.9658332 46.14027 6.1522222 46.153591 6.3055539 46.252491 
  6.2422209 46.297771 6.2439308 46.322392) 
#(6.8049369 46.405499 6.767499 46.352489 6.8444428 46.27137 
  6.7952771 46.217758 6.788054 46.142208 6.8844442 46.126091 
  6.871387 46.051929 6.9291658 46.065262 7.0387468 45.931721) 
#(7.4406996 43.757824 7.4383001 43.7603 7.4358001 43.7631 
  7.4341998 43.766102 7.4324999 43.769199 7.4294 43.7714 
  7.4246998 43.773102 7.4200001 43.772499 7.4161 43.770599 
  7.4127998 43.768299 7.4096999 43.7658 7.4064002 43.763599 
  7.4031 43.761398 7.4003 43.758598 7.3972001 43.7561 
  7.3938999 43.753899 7.3906002 43.7514 7.3878002 43.7486 
  7.3864002 43.745602 7.3864002 43.741901 7.3882999 43.738899 
  7.3899999 43.735802 7.3908 43.732201 7.3911872 43.728031) 
#(-0.51916671 42.790821 -0.65611112 42.863602 
  -0.74694443 42.965542 -0.8188889 42.946091 -1.3005559 43.071659 
  -1.2883331 43.106091 -1.360278 43.031651 -1.440556 43.048321 
  -1.472778 43.091091 -1.381945 43.196651 -1.4091671 43.273041 
  -1.62 43.256378 -1.655833 43.309429 -1.810488 43.385891) 
#(1.4352469 42.597149 1.383611 42.689701 0.81583309 42.841091 
  0.66777772 42.839149 0.66805542 42.748039 0.67611098 42.689152 
  0.41249999 42.695259 0.29111111 42.675819 0.26194441 42.71748 
  -0.057500001 42.694149 -0.1238889 42.757488 -0.1877778 42.78582 
  -0.3066667 42.849152 -0.3922222 42.796379 -0.50083339 42.822208 
  -0.51916671 42.790821) #(1.7109669 42.473499 1.781667 42.581661 
  1.541111 42.65387 1.4352469 42.597149) 
#(3.1769619 42.437611 3.1508329 42.433319 3.0383329 42.474979 
  2.678333 42.401649 2.6711111 42.338322 2.476666 42.35165 
  2.2541671 42.434711 2.0869441 42.363319 1.976666 42.374699 
  1.953055 42.437199 1.7875 42.490261 1.7109669 42.473499) 
#(9.5031242 54.848251 9.4451694 54.82478) 
#(9.4451694 54.82478 8.9199982 54.908039 8.7194424 54.891102 
  8.6562958 54.9174) #(6.039165 51.71693 5.954999 51.73859 
  5.9688878 51.7911 5.9619441 51.830269 6.1697211 51.84193 
  6.1377769 51.87693 6.1597209 51.90554 6.3802772 51.82999 
  6.5488882 51.885262 6.727777 51.899429 6.830832 51.971371 
  6.8005538 52.00721 6.6880541 52.038879 6.6974978 52.069981 
  6.8605552 52.120258 6.8797212 52.153591 7.0524988 52.235821 
  7.0655551 52.385818 6.9874992 52.461102 6.9461098 52.434429 
  6.705555 52.485821 6.6902761 52.551929 6.7608328 52.567211 
  6.7208328 52.629429 6.7816658 52.654148 7.0358319 52.632759 
  7.0552769 52.65192 7.0697212 52.814991 7.1988878 52.967758 
  7.209444 53.24276) #(6.0084071 50.756069 5.9816661 50.802761 
  6.084722 50.8736 6.0108328 50.9436 6.0283332 50.97665 
  5.9658332 50.978321 5.8694429 51.018879 5.873888 51.050259 
  5.9522219 51.036652 6.1672211 51.162762 6.0794439 51.175819 
  6.0738888 51.220539 6.2222209 51.36166 6.2174988 51.476372 
  6.0930548 51.607208 6.1161098 51.65192 6.0294442 51.6786 
  6.039165 51.71693) #(12.09347 50.3242 12.26 50.261662 
  12.28055 50.1861 12.32972 50.169708 12.36472 50.279148 
  12.48639 50.351379 12.785 50.446369 12.90389 50.423321 
  12.99444 50.423038 13.03361 50.502769 13.19111 50.503601 
  13.23944 50.579708 13.32083 50.5811 13.38 50.641369 
  13.47 50.603321 13.56667 50.711102 13.86194 50.725811 
  13.90778 50.790539 14.04667 50.806931 14.39361 50.894711 
  14.40361 50.932491 14.26083 50.996651 14.47222 51.031368 
  14.59889 50.9772 14.56972 50.916088 14.65083 50.92416 
  14.62527 50.85416 14.80166 50.818878 14.82885 50.866032) 
#(6.1318331 50.12553 6.1733322 50.232479 6.4002771 50.329151 
  6.3663869 50.452209 6.2008319 50.51638 6.26861 50.6236 
  6.1713881 50.623871 6.1083331 50.723309 6.0286102 50.71582 
  6.0084071 50.756069) #(6.5105548 49.706379 6.522222 49.8111 
  6.3266659 49.83971 6.1397219 49.996651 6.1318331 50.12553) 
#(6.5105548 49.706379 6.372499 49.59026 6.3622208 49.45998) 
#(13.40144 49.007488 13.39528 49.050259 13.20361 49.119431 
  13.15111 49.177479 13.02694 49.298321 12.93528 49.34026 
  12.87861 49.328041 12.66166 49.433868 12.525 49.637211 
  12.44194 49.70026 12.40305 49.759991 12.49944 49.83276 
  12.5425 49.920269 12.47444 49.943039 12.49277 49.974979 
  12.42889 49.984428 12.22889 50.096371 12.205 50.17416 
  12.09694 50.24971 12.13583 50.27832 12.09347 50.3242) 
#(8.2273941 48.963711 8.1922207 48.968868 7.9386101 49.04887 
  7.7411098 49.04166 7.539999 49.088871 7.4869428 49.16415 
  7.375277 49.171928 7.3613882 49.14777 7.0883322 49.125259 
  7.038332 49.11832 7.0266662 49.188869 6.8474989 49.21526 
  6.8388882 49.15498 6.78722 49.162479 6.5897222 49.320271 
  6.5947218 49.363041 6.4938879 49.447201 6.3622208 49.45998) 
#(13.40144 49.007488 13.50167 48.944981 13.51611 48.97776 
  13.58444 48.968868 13.66194 48.896381 13.74083 48.881649 
  13.81463 48.78714) #(8.2273941 48.963711 8.1333332 48.88554 
  7.921515 48.690029) #(16.94486 48.616501 16.952801 48.628101 
  16.970301 48.634399 16.9758 48.639999 16.9881 48.6814 
  16.993601 48.687801 17.003599 48.694698 17.0056 48.698101 
  17.003099 48.7089 17.0047 48.716702 17.010599 48.721901 
  17.026699 48.75 17.0347 48.758099 17.0383 48.764999 
  17.0439 48.771099 17.0553 48.776901 17.0686 48.7864 
  17.092199 48.792801 17.1 48.803101 17.108101 48.8269 
  17.113899 48.833099 17.1264 48.837799 17.146099 48.842201 
  17.1628 48.849201 17.1889 48.869202 17.205601 48.869701 
  17.230301 48.8731 17.2528 48.8708 17.3069 48.852501 
  17.343599 48.848099 17.3764 48.827499 17.390301 48.8228 
  17.4039 48.8228 17.4186 48.826698 17.4333 48.833599 
  17.445299 48.843601 17.4592 48.851898 17.4767 48.852501 
  17.493299 48.8461 17.509199 48.832802 17.522499 48.817501 
  17.5294 48.8153 17.549999 48.817799 17.573299 48.8297 
  17.5972 48.8339 17.606701 48.840801 17.633101 48.846401 
  17.645599 48.851898 17.673599 48.851101 17.6861 48.856701 
  17.694201 48.8578 17.7122 48.856098 17.736099 48.871399 
  17.7547 48.875801 17.7631 48.8797 17.7675 48.884201 
  17.775801 48.9006 17.7822 48.9067 17.793301 48.9133 
  17.8011 48.922798 17.8064 48.926399 17.813601 48.927799 
  17.8508 48.928101 17.884199 48.9244 17.890301 48.926899 
  17.8964 48.934399 17.897499 48.947498 17.9 48.952801 
  17.910601 48.9636 17.912201 48.9697 17.9111 48.985001 
  17.928301 49.016899 17.940001 49.0228 17.967501 49.0275 
  17.99 49.0289 18.0175 49.0247 18.0303 49.0256 
  18.0653 49.035801 18.0753 49.041901 18.099701 49.069401 
  18.121901 49.082802 18.130301 49.102798 18.1478 49.115601 
  18.1514 49.124401 18.150801 49.130001 18.145 49.139702 
  18.1453 49.145 18.158899 49.165298 18.166401 49.1964 
  18.1742 49.2103 18.184999 49.2211 18.188101 49.226398 
  18.188101 49.229401 18.184999 49.2342 18.1747 49.241699 
  18.208099 49.284199 18.212799 49.288101 18.2197 49.290001 
  18.252199 49.294399 18.281401 49.301899 18.307199 49.303902 
  18.317801 49.307499 18.3333 49.317799 18.3508 49.323101 
  18.3661 49.3256 18.3794 49.330299 18.3869 49.3358 
  18.4083 49.361099 18.4203 49.371101 18.4203 49.374199 
  18.4172 49.3783 18.406401 49.389198 18.404699 49.394199 
  18.4058 49.3969 18.4144 49.396099 18.428101 49.3908 
  18.436899 49.390598 18.4436 49.392799 18.4692 49.4072 
  18.475599 49.413101 18.4825 49.4231 18.496401 49.4347 
  18.5172 49.444199 18.535299 49.450298 18.546101 49.4575 
  18.5483 49.4636 18.5483 49.481701 18.551399 49.4869 
  18.562201 49.4939 18.5811 49.497799 18.586399 49.497501 
  18.605301 49.491699 18.6231 49.492199 18.630301 49.494202 
  18.6481 49.5033 18.6556 49.5042 18.6817 49.4958 18.705 49.4967 
  18.7306 49.485298 18.744699 49.483101 18.7631 49.491402 
  18.7794 49.505001 18.798599 49.516102 18.8144 49.518902 
  18.8447 49.5158 18.853331 49.51778) 
#(7.921515 48.690029 7.8019428 48.59248 7.8074989 48.513321 
  7.771666 48.49165 7.750833 48.336651 7.6049991 48.156929 
  7.5716658 48.037209 7.6158319 48.002769 7.5133328 47.686932 
  7.588799 47.58456) #(7.6183319 47.5611 7.6744428 47.60638 
  7.588799 47.58456) #(9.5676117 47.543919 9.2616653 47.66304 
  8.8786087 47.655819 8.7999992 47.73526 8.7974987 47.683041 
  8.7249985 47.697762 8.7269421 47.764992 8.559721 47.80637 
  8.4066658 47.703869 8.413332 47.671101 8.621664 47.660259 
  8.6188869 47.639709 8.5083332 47.628319 8.4930305 47.58456) 
#(7.6183319 47.5611 7.6972208 47.54332 7.8194442 47.588322 
  7.9433322 47.5536 8.2055531 47.621651 8.3405533 47.574162 
  8.4930305 47.58456) #(30.858959 69.789658 30.95472 69.681351 
  30.95027 69.603577 30.91 69.548859 30.79694 69.530258 
  30.511391 69.549133 30.18833 69.666924 30.083891 69.656357 
  30.072769 69.631073 30.142771 69.628304 30.17638 69.566071 
  30.02916 69.476639) #(30.02916 69.476639 29.309999 69.315247) 
#(29.309999 69.315247 29.30994 69.299423 29.30974 69.235382 
  29.309719 69.227188) #(28.964769 69.05191 28.78694 69.119133 
  28.78167 69.149696 28.826941 69.238022 29.285549 69.463593 
  29.29472 69.495239 29.098881 69.708023 28.379721 69.827469 
  28.09416 69.938568 28.01524 70.069366) 
#(29.01111 69.034409 28.964769 69.05191) 
#(29.309719 69.227188 29.230551 69.101913 29.0875 69.033859 
  29.01111 69.034409) #(28.01524 70.069366 27.80666 70.079422 
  27.37722 70.002762 27.2925 69.950531 27.03861 69.90831 
  26.80777 69.95192 26.46055 69.931923 26.36972 69.849983 
  25.98888 69.706627 25.942221 69.667473 25.97583 69.630249 
  25.934441 69.56636 25.85305 69.546921 25.830549 69.378304 
  25.75111 69.33609 25.708611 69.206627 25.80916 69.011368 
  25.612221 68.881348 25.38472 68.880524 25.16666 68.785797 
  25.095831 68.629143 24.935551 68.593857) 
#(20.58609 69.063141 20.738331 69.096359 21.067499 69.039139 
  21.11305 69.108017 21.066111 69.126358 21.039721 69.182457 
  21.055 69.228577 21.320829 69.32608 21.68194 69.284698 
  22.34861 68.842468 22.398331 68.71109 23.063881 68.695511 
  23.204161 68.628571 23.703609 68.715263 23.85638 68.832474 
  24.04472 68.823868 24.13139 68.779968 24.690269 68.676361 
  24.797779 68.640808 24.88139 68.558578 24.918329 68.561897 
  24.935551 68.593857) #(29.387131 66.624847 29.350269 66.682457 
  29.159439 66.799133 29.075001 66.879959 29.08778 66.969971 
  29.134159 67.013603 29.406111 67.209137 29.93277 67.51387 
  29.97777 67.572479 29.98638 67.61525 30.02861 67.694687 
  29.69166 67.815247 29.356939 68.082474 28.696659 68.193298 
  28.458611 68.534698 28.759159 68.751923 28.80583 68.821373 
  28.73777 68.875793 28.43222 68.886368 28.45694 68.918297 
  28.964769 69.05191) #(31.587299 62.91383 31.275 63.11776 
  31.250549 63.19165 31.19611 63.23415 30.96249 63.309711 
  30.90416 63.357491 30.481661 63.478588 30.0275 63.71804 
  30.004721 63.752769 30.255831 63.81776 30.59528 64.046921 
  30.614441 64.086639 30.559441 64.156082 30.55805 64.200256 
  30.560829 64.244423 30.35944 64.319702 30.156111 64.354141 
  30.051661 64.405533 30.087219 64.483032 30.002769 64.517754 
  29.980829 64.5858 30.178881 64.631638 30.20916 64.672737 
  30.13139 64.721626 30.13028 64.753036 30.08778 64.791641 
  29.794161 64.797203 29.645 64.913857 29.60638 65.007202 
  29.63722 65.068314 29.874439 65.125793 29.82333 65.148857 
  29.85861 65.175522 29.84305 65.219971 29.60944 65.235237 
  29.598881 65.259697 29.749439 65.347748 29.746111 65.51442 
  29.845551 65.554138 29.85527 65.57608 29.745831 65.621078 
  29.72888 65.642197 30.024441 65.691071 30.12389 65.664978 
  30.134159 65.719131 29.94833 66.049698 29.61833 66.34581 
  29.54833 66.495506 29.387131 66.624847) 
#(30.152981 61.857121 30.54583 62.107491 31.264721 62.51276 
  31.43 62.758881 31.587299 62.91383) 
#(30.039761 61.784969 30.152981 61.857121) 
#(35.879711 60.85693 35.947208 60.919159 35.846111 60.917759 
  35.82999 60.928051 35.960541 60.951382 36.10083 61.0886 
  36.221661 61.07082 36.458328 61.179989 36.390831 61.204151 
  36.341099 61.273319 36.415829 61.290272 36.446659 61.346371 
  36.43388 61.398041 36.372501 61.448879 36.22583 61.475819 
  36.227489 61.524712 36.01638 61.660259 36.040279 61.714161 
  35.984718 61.775269 35.833611 61.831379 35.818329 61.858318 
  35.85527 61.916931 35.85693 61.954708 35.651379 62.05027 
  35.78249 62.198318 35.846378 62.403599 35.835831 62.440269 
  35.764999 62.502769 35.622501 62.56638 35.553051 62.554989 
  35.552769 62.593601 35.508881 62.635269 35.477219 62.62249 
  35.503601 62.569988 35.411659 62.610821 35.408051 62.65971 
  35.30138 62.67944 34.974442 62.764149 35.050549 62.769711 
  34.78249 62.84721 34.69722 62.815269 34.639889 62.86237 
  34.544708 62.913879 34.451389 62.896931 34.54472 62.8386 
  34.573608 62.74416 34.703041 62.659431 34.7486 62.657768 
  35.026379 62.435551 34.874722 62.58527 34.846661 62.629162 
  34.965549 62.653599 35.0975 62.5536 35.306389 62.51693 
  35.301941 62.543049 35.323608 62.576649 35.439159 62.479431 
  35.589439 62.281101 35.583328 62.233318 35.343048 62.120541 
  35.27861 62.170551 35.159439 62.17527 35.107208 62.221661 
  35.011669 62.254162 35.194439 62.096661 35.15749 62.028049 
  35.049438 62.04916 34.871101 62.188881 34.874722 62.252209 
  34.798321 62.365261 34.500549 62.55249 34.567501 62.452209 
  34.762501 62.342491 34.797218 62.273319 34.77 62.245541 
  34.471939 62.458599 34.44194 62.450821 34.715271 62.181381 
  34.708328 62.162491 34.61972 62.244991 34.56139 62.21888 
  34.742771 62.05666 34.72971 62.021381 34.31916 62.174709 
  34.296101 62.199711 34.35833 62.26527 34.06638 62.44305 
  34.07666 62.507771 34.024441 62.529709 33.937222 62.522491 
  33.93111 62.449162 33.984989 62.37027 34.01833 62.369431 
  34.035 62.419991 34.104431 62.395821 34.269428 62.25832 
  34.243038 62.176929 34.541111 62.00555 34.627781 61.865261 
  34.571659 61.777489 34.54583 61.7761 34.484989 61.819149 
  34.358891 61.82999 34.309158 61.89555 34.30389 61.858879 
  34.436939 61.775829 34.724998 61.576649 35.25499 61.475819 
  35.281109 61.44471 35.48888 61.361099 35.555828 61.271931 
  35.69389 61.13055 35.632221 61.056099 35.533051 61.002491 
  35.299721 61.082489 35.182209 61.04388 35.026939 61.133041 
  35.098598 61.17944 35.212219 61.139709 35.24305 61.16832 
  34.82444 61.2286 34.773602 61.129162 34.832771 61.01305 
  34.91777 61.053051 34.891109 61.06776 34.87722 61.095268 
  35.057781 61.062771 35.154999 60.993038 35.346939 61.052761 
  35.391941 61.049709 35.51416 60.989159 35.491661 60.956379 
  35.51722 60.924992 35.604721 60.89249 35.783611 60.906101 
  35.745548 60.872761 35.879711 60.85693) 
#(27.794769 60.547562 28.428049 60.90554 28.63888 60.966091 
  28.712219 61.04166 29.002501 61.177212 29.73444 61.565262 
  29.83972 61.65749 30.039761 61.784969) 
#(31.410549 59.899151 31.514441 59.918049 31.57777 59.970829 
  31.542219 60.081661 31.73139 60.25721 32.164989 60.21138 
  32.19804 60.16943 32.313332 60.1311 32.550549 60.181931 
  32.6161 60.23415 32.6236 60.284431 32.59 60.312771 
  32.581108 60.363041 32.64333 60.348049 32.683331 60.419708 
  32.58527 60.523041 32.627769 60.548599 32.7775 60.499989 
  32.785549 60.456379 32.90694 60.57777 32.953331 60.658329 
  32.802502 60.73193 32.807499 60.851379 32.633331 60.966099 
  32.57333 61.076649 32.398041 61.17527 31.71944 61.388321 
  31.623051 61.476379 31.59 61.474991 31.602501 61.446098 
  31.371941 61.624439 31.33416 61.61665 31.28055 61.606659 
  31.259439 61.657768 31.16361 61.637211 31.158609 61.604431 
  31.06916 61.62582 31.05055 61.70554 30.94552 61.72921 
  30.902769 61.752491 30.81444 61.771099 30.553329 61.590549 
  30.63805 61.548599 30.632771 61.537491 30.46611 61.514431 
  30.465549 61.48138 30.226391 61.519711 30.22694 61.478321 
  30.27639 61.47332 30.346661 61.439159 30.14333 61.359711 
  30.237499 61.332211 30.092779 61.307209 30.06778 61.225269 
  29.894159 61.305271 29.84222 61.252491 29.987499 61.207489 
  30.022221 61.14777 29.86722 61.20332 30.256109 61.02832 
  30.534439 60.814159 30.53389 60.738041 30.495831 60.735538 
  30.515829 60.68721 30.77083 60.510818 30.762779 60.452209 
  30.78083 60.434158 30.821659 60.46027 30.86417 60.41832 
  30.97361 60.20776 31.118891 60.126381 31.08444 60.066929 
  31.16222 60.03194 31.15694 60.008881 31.045561 59.93943 
  31.17944 59.912491 31.335831 59.938881 31.410549 59.899151) 
#(38.436939 58.014431 38.325821 58.098598 38.38554 58.144428 
  38.489712 58.133598 38.563042 58.089432 38.70332 58.11137 
  38.573879 58.244431 38.625271 58.239429 38.778049 58.15276 
  38.769989 58.124439 38.81805 58.094711 38.84943 58.11388 
  38.794991 58.221371 38.816929 58.28471 38.903049 58.356659 
  39.081661 58.332489 38.96526 58.4011 38.968319 58.46999 
  39.07304 58.50193 38.906658 58.492771 38.686661 58.56443 
  38.138199 58.937809 37.795551 59.076099 37.787491 59.09082 
  37.933601 59.109711 38.313881 59.05888 38.476379 59.211929 
  38.33638 59.134159 38.237492 59.158871 38.191929 59.217209 
  38.096931 59.20055 38.160549 59.183601 38.18499 59.138599 
  38.153969 59.082951 37.94693 59.138321 38.033871 59.19693 
  37.9361 59.15527 37.83276 59.12888 37.542759 59.18082 
  37.70277 59.108318 37.675541 59.080818 37.72665 59.010269 
  37.682491 58.98637 37.478039 58.951649 37.485821 58.908039 
  37.43832 58.86665 37.498878 58.824989 37.54443 58.832211 
  37.525539 58.897209 37.54916 58.914711 37.748878 58.940269 
  37.906651 58.881649 37.900829 58.847759 37.94305 58.839432 
  37.98138 58.87888 38.011108 58.870541 37.990261 58.808041 
  38.043049 58.755821 38.038601 58.70499 37.952492 58.74332 
  37.925541 58.743038 38.024151 58.672489 38.102211 58.637489 
  38.126099 58.60165 38.053051 58.608318 38.074989 58.58305 
  38.084148 58.524429 38.001381 58.533871 37.65527 58.646648 
  37.601379 58.63443 37.640549 58.583599 37.683319 58.594711 
  37.69471 58.5686 37.64138 58.531101 37.545551 58.5611 
  37.57193 58.609989 37.448879 58.61694 37.36277 58.67915 
  37.47694 58.739429 37.350819 58.720268 37.11916 58.876381 
  37.174709 58.823601 37.13443 58.792488 37.211102 58.709709 
  37.11694 58.695271 37.126381 58.67944 37.25526 58.69582 
  37.494431 58.573879 37.497211 58.51582 37.699989 58.424431 
  37.90527 58.26804 38.229431 58.24971 38.270821 58.209431 
  38.231098 58.101101 38.261929 58.029148 38.436939 58.014431) 
#(27.371099 57.5364 27.348101 57.5956 27.4058 57.613602 
  27.415001 57.636398 27.3908 57.658901 27.413099 57.690601 
  27.526699 57.722801 27.516399 57.7733 27.5728 57.802799 
  27.545799 57.817799 27.735001 57.835602 27.8211 57.865799 
  27.8053 57.891102 27.683901 57.926399 27.698299 57.996899 
  27.67 58.009701 27.6425 58.027802 27.676701 58.0508 
  27.6733 58.078899 27.554199 58.132801 27.474199 58.213902 
  27.464701 58.297798 27.5392 58.361698 27.5425 58.413898 
  27.4231 58.801399 27.493601 58.881901 27.725 58.987801 
  27.7922 59.063301 27.8442 59.159698 27.8633 59.228901 
  27.8867 59.2542 27.8806 59.2761 27.8969 59.286098 
  28.0972 59.308102 28.0075 59.336102 28.189199 59.352501 
  28.193899 59.375801 28.1703 59.3978 28.006678 59.481701) 
#(28.166498 56.150318 28.3125 56.049999 28.3536 56.0569 
  28.387501 56.0961 28.5208 56.105301 28.646099 56.093601 
  28.7022 56.0322 28.73 55.9631 28.846901 55.942501 
  28.8536 55.9706 29.059401 56.032799 29.412201 55.957802 
  29.464399 55.911098 29.4069 55.895802 29.3592 55.789398 
  29.385799 55.756401 29.4939 55.6889 29.5264 55.691399 
  29.618299 55.751701 29.7192 55.782501 29.823099 55.775299 
  29.8594 55.822498 29.928301 55.8517 30.0147 55.854401 
  30.1406 55.828098 30.226101 55.8661 30.2992 55.836102 
  30.4897 55.799999 30.4942 55.763901 30.606701 55.726101 
  30.6089 55.6814 30.6472 55.6614 30.7269 55.656399 
  30.756701 55.596699 30.8769 55.619202 30.9256 55.6031 
  30.934999 55.531898 30.9186 55.506901 30.9394 55.491699 
  30.906401 55.479198 30.9006 55.459202 30.9394 55.399399 
  30.8578 55.3536 30.813601 55.293301 30.878599 55.2603 
  30.9133 55.203098 31.0047 55.143299 30.9872 55.111698 
  31.029699 55.043301 31.007799 55.026699 30.924999 55.033298 
  30.955799 54.992199 30.9475 54.9692 30.8339 54.944199 
  30.844999 54.8811 30.8011 54.855 30.780001 54.796902 
  31.004999 54.7117 31.0247 54.652199 31.185301 54.6422 
  31.186899 54.609402 31.131701 54.570599 31.0825 54.5056 
  31.1306 54.4786 31.194201 54.480301 31.198437 54.460041 
  31.231899 54.456699 31.263901 54.3867 31.311701 54.3508 
  31.310801 54.2967 31.331699 54.237499 31.544201 54.143299 
  31.6161 54.137199 31.686399 54.1031 31.7617 54.103298 
  31.793301 54.053101 31.8442 54.0644 31.865601 54.002201 
  31.828899 53.886398 31.762136 53.80378 31.8172 53.803902 
  31.8958 53.7775 32.119701 53.82 32.198101 53.785 
  32.329399 53.762199 32.3769 53.718899 32.4617 53.722801 
  32.510601 53.683601 32.4147 53.6464 32.443901 53.571899 
  32.570599 53.521702 32.5975 53.4911 32.670601 53.4972 
  32.657799 53.4692 32.738098 53.465801 32.736401 53.438599 
  32.7239 53.367802 32.7369 53.342499 32.604401 53.333302 
  32.615299 53.3158 32.5858 53.3069 32.462502 53.3083 
  32.4711 53.286098 32.498299 53.278301 32.436699 53.2061 
  32.3531 53.1819 32.298901 53.131901 32.225601 53.133301 
  32.223301 53.105598 32.186401 53.113899 32.118599 53.0872 
  32.012501 53.110001 31.930599 53.0956 31.8869 53.1208 
  31.8011 53.125801 31.7756 53.194199 31.6161 53.2183 
  31.5725 53.1992 31.422501 53.2089 31.3953 53.1814 
  31.3764 53.121101 31.3864 53.099201 31.3272 53.082199 
  31.317801 53.054401 31.266399 53.0219 31.3564 52.9781 
  31.383301 52.9189 31.4153 52.893101 31.4758 52.8633 
  31.5369 52.856098 31.540001 52.821899 31.580799 52.803101 
  31.594999 52.738098 31.5583 52.701401 31.5 52.689999 
  31.583599 52.5947 31.653299 52.553101 31.581699 52.5508 
  31.595301 52.5322 31.564699 52.5158 31.6089 52.491402 
  31.6017 52.406101 31.6231 52.395599 31.6297 52.370602 
  31.5867 52.318901 31.644199 52.2733 31.7169 52.2617 
  31.7022 52.2453 31.703899 52.198601 31.782499 52.165798 
  31.783899 52.108101) #(104.7689 51.46526 105.1558 51.577209 
  105.9367 51.737209 106.195 51.95026 106.1653 52.00555 
  106.2647 52.099152 106.2922 52.149151 106.2544 52.185261 
  106.248 52.264709 106.3464 52.344151 106.5758 52.381649 
  106.7753 52.309711 106.9175 52.464989 107.203 52.574162 
  107.3928 52.646099 107.8019 52.713039 108.1994 52.920269 
  108.3391 53.04221 108.2916 53.10693 108.6508 53.297771 
  108.7597 53.269428 108.9753 53.362492 108.9997 53.40971 
  108.9844 53.50193 108.8919 53.5961 108.8458 53.5961 
  108.5536 53.502769 108.5275 53.50943 108.8064 53.788319 
  108.9255 53.85582 109.0425 53.86137 109.073 53.811378 
  109.0102 53.759991 109.0794 53.736099 108.9839 53.641651 
  109.0091 53.626381 109.15 53.617489 109.2103 53.669708 
  109.1897 53.803051 109.4608 54.011379 109.5611 54.159988 
  109.4697 54.292488 109.5128 54.34082 109.4786 54.397209 
  109.5322 54.634708 109.6389 54.697491 109.6308 54.797771 
  109.6894 54.835541 109.6619 54.869709 109.7772 55.048038 
  109.7464 55.10582 109.8469 55.447491 109.8994 55.461929 
  109.8486 55.503601 109.9619 55.676659 109.8447 55.756939 
  109.6964 55.788319 109.6722 55.7761 109.8164 55.734989 
  109.5658 55.766102 109.5069 55.74577 109.4594 55.699989 
  109.2258 55.574162 109.1691 55.468319 109.2216 55.38554 
  109.1605 55.149429 108.9039 54.949162 108.9539 54.91943 
  108.7903 54.675819 108.5761 54.4911 108.495 54.30138 
  108.3075 54.148319 108.2089 53.940819 107.6433 53.63221 
  107.5416 53.498322 107.5617 53.461102 107.5033 53.416931 
  106.8958 53.136929 106.7478 53.010818 106.8603 53.03693 
  106.9141 52.985538 106.7969 52.926102 106.7661 52.85915 
  106.6278 52.798599 106.5753 52.722759 105.9855 52.493038 
  105.565 52.101101 105.3872 52.021381 105.2441 51.92416 
  105.145 51.898602 104.7425 51.86277 104.6286 51.78054 
  103.7286 51.720539 103.7064 51.688042 103.74 51.662209 
  104.1469 51.53027 104.7689 51.46526) 
#(23.592085 51.528278 23.646099 51.520802 23.608601 51.608101 
  23.6667 51.640598 23.753599 51.6525 23.8967 51.635799 
  23.953899 51.584999 24.0431 51.610298 24.2794 51.737801 
  24.313299 51.822498 24.3967 51.8867 24.8853 51.899399 
  25.179399 51.959702 25.2442 51.9594 25.361099 51.926899 
  25.546976 51.923237 25.695801 51.922798 25.775801 51.939201 
  25.9767 51.912201 26.092199 51.9175 26.180799 51.861401 
  26.436899 51.856899 26.439199 51.820599 26.457199 51.812801 
  26.6497 51.820301 26.9333 51.749699 27.0292 51.769402 
  27.179701 51.762798 27.206699 51.743099 27.200001 51.6703 
  27.298901 51.6544 27.2794 51.597801 27.445601 51.601101 
  27.471701 51.629398 27.512501 51.630299 27.7197 51.592499 
  27.724701 51.5644 27.671101 51.506699 27.746901 51.465599 
  27.817499 51.530602 27.811701 51.5886 27.8514 51.6203 
  27.884701 51.619999 27.9753 51.567799 28.0881 51.564999 
  28.135 51.580299 28.188601 51.643101 28.2586 51.661098 
  28.260799 51.617802 28.3361 51.5769 28.3592 51.530602 
  28.475599 51.5797 28.627199 51.566399 28.660601 51.4519 
  28.683599 51.438599 28.7192 51.452202 28.730301 51.420799 
  28.752501 51.411098 28.764999 51.416901 28.7661 51.484699 
  28.845301 51.554199 28.9289 51.576698 28.9953 51.574699 
  29.028299 51.595798 29.040001 51.624699 29.0833 51.638302 
  29.1861 51.612202 29.205 51.568298 29.243299 51.5378 
  29.250799 51.5047 29.236099 51.4664 29.2819 51.443298 
  29.313101 51.384998 29.353901 51.375 29.4097 51.402802 
  29.483101 51.390301 29.523899 51.453602 29.5944 51.453098 
  29.6217 51.490002 29.669701 51.498901 29.7178 51.4944 
  29.759199 51.441101 29.8514 51.4361 29.8958 51.469398 
  29.933901 51.457199 29.983299 51.486401 30.176399 51.491901 
  30.348101 51.4053 30.3503 51.358299 30.334999 51.345001 
  30.3839 51.307201 30.459999 51.296902 30.4797 51.27 
  30.5494 51.2528 30.571699 51.2733 30.570801 51.301899 
  30.644199 51.332802 30.631901 51.355301 30.6436 51.3708 
  30.619699 51.4161 30.581699 51.430302 30.5886 51.454201 
  30.615601 51.458302 30.5658 51.5158 30.582199 51.536701 
  30.5303 51.551102 30.5222 51.566898 30.542801 51.577202 
  30.5175 51.597801 30.5567 51.625 30.5739 51.697498 
  30.6283 51.711399 30.645599 51.7486 30.6175 51.764198 
  30.6569 51.774399 30.67 51.796398 30.662201 51.823898 
  30.746901 51.895302 30.7964 51.902802 30.8008 51.944401 
  30.8822 51.965599 30.8978 51.997799 30.971701 52.006401 
  30.9669 52.025002 30.9314 52.033298 30.943899 52.049198 
  30.935801 52.0639 30.9631 52.0811 31.161699 52.083302 
  31.251699 52.045601 31.279699 52.054699 31.3011 52.091099 
  31.3619 52.116699 31.783899 52.108101) 
#(100.1889 50.452209 100.2225 50.532768 100.4025 50.528599 
  100.498 50.631939 100.4211 50.633598 100.4305 50.733318 
  100.4958 50.75555 100.4908 50.79887 100.5244 50.85638 
  100.5825 50.873878 100.7105 50.99638 100.6767 51.030819 
  100.7372 51.06638 100.6977 51.122761 100.7322 51.166931 
  100.7975 51.396099 100.7569 51.451649 100.6867 51.466648 
  100.6144 51.584709 100.528 51.61388 100.5202 51.587769 
  100.4352 51.51545 100.3564 51.459148 100.3614 51.43082 
  100.4458 51.448879 100.4633 51.42527 100.443 51.373051 
  100.3869 51.334148 100.2839 51.347759 100.2636 51.31443 
  100.2761 51.240822 100.3355 51.127769 100.2489 50.896099 
  100.2497 50.70776 100.1625 50.562481 100.1622 50.507771 
  100.1889 50.452209) #(104.9603 50.385818 104.3922 50.287491 
  104.2503 50.17638 104.0633 50.141651 103.7955 50.194981 
  103.7291 50.14249 103.6405 50.138599 103.4366 50.209148 
  103.3322 50.196369 103.2819 50.21804 103.2455 50.302761 
  102.613 50.413601 102.5366 50.51305 102.3278 50.56971 
  102.2958 50.648041 102.3558 50.709709 102.3441 50.748322 
  102.2678 50.787209 102.2297 50.84943 102.265 50.893318 
  102.1541 51.244991 102.225 51.30637 102.2233 51.329708 
  102.1844 51.345261 101.5433 51.486931 101.4044 51.451382 
  101.3394 51.46859 100.6702 51.703602 100.2239 51.73304 
  99.919693 51.76054 99.721909 51.89304 99.517197 51.91304 
  99.119957 52.033871 98.934563 52.14201) 
#(127.5885 50.211208 127.3303 50.318878 127.3511 50.417488 
  127.2886 50.45998 127.3655 50.581379 127.2775 50.685539 
  127.2878 50.745258 126.9303 51.059429 126.9019 51.20499 
  126.9769 51.302761 126.9664 51.32082 126.9075 51.321098 
  126.8566 51.294708 126.8997 51.261379 126.8933 51.23859 
  126.8427 51.243599 126.8077 51.279709 126.8205 51.330269 
  126.9155 51.351379 126.9116 51.383041 126.7839 51.438591 
  126.8244 51.501099 126.8022 51.53693 126.7183 51.5536 
  126.6691 51.584431 126.7261 51.65387 126.4689 51.93166 
  126.4464 52.014431 126.5361 52.072208 126.5447 52.136101 
  126.3419 52.184711 126.3097 52.221088 126.4319 52.284431 
  126.3164 52.312199 126.3447 52.37748 126.2669 52.458599 
  126.1969 52.463871 126.1952 52.533039 126.0747 52.59026 
  126.0216 52.561932 125.988 52.581928 125.9766 52.646381 
  126.0661 52.682209 126.0366 52.726089 126.0805 52.744431 
  126.0602 52.784161 125.9544 52.773869 125.8441 52.898869 
  125.6428 52.88332 125.6522 52.917759 125.723 52.946369 
  125.725 52.983318 125.6066 53.054699 125.5061 53.03804 
  125.1647 53.193039 125.0447 53.1936 124.8811 53.15498 
  124.8777 53.087761 124.7119 53.1311 124.6766 53.1786 
  124.4805 53.19165 124.24 53.361099 124.1044 53.34026 
  123.8547 53.481651 123.2533 53.553871 122.9503 53.487492 
  122.1811 53.456379 121.4191 53.315262 120.8575 53.276932 
  120.5505 53.07082 120.3247 52.89304 120.0283 52.767761 
  120.0278 52.627762 120.0725 52.58942 120.1803 52.578869 
  120.4397 52.63665 120.7197 52.535549 120.6291 52.325821 
  120.7061 52.26749 120.7794 52.149151 120.6919 52.042759 
  120.7122 51.982479 120.6522 51.913601 120.5664 51.902481 
  120.2778 51.744148 120.0961 51.660809 119.9744 51.475262 
  119.9852 51.434429 119.8127 51.243038 119.7547 51.206928 
  119.7766 51.160259 119.5744 50.94553 119.5019 50.741928 
  119.2864 50.593601 119.2605 50.473869 119.1466 50.403309 
  119.1352 50.372761 119.3605 50.336651 119.3294 50.106651 
  119.2019 50.00943 119.0969 49.988491) 
#(107.9782 49.947392 107.2472 50.00499 107.0783 50.08498 
  107.0055 50.201099 106.7536 50.32193 106.5469 50.346088 
  106.2628 50.297489 106.0703 50.343601 106.0639 50.377762 
  105.9891 50.410542 105.3083 50.480808 105.1322 50.398319 
  104.9603 50.385818) #(119.0969 49.988491 118.9105 49.984711 
  118.5647 49.917759 118.475 49.83054 118.3847 49.81638 
  118.365 49.778042 117.885 49.54221 117.873 49.507771 
  117.755 49.531368 117.21 49.64193 116.7088 49.82819) 
#(129.52361 49.38998 129.41161 49.43166 129.368 49.413311 
  129.3674 49.3536 129.3383 49.339149 129.1908 49.389431 
  129.1199 49.346371 129.05 49.364151 128.9922 49.441368 
  128.7516 49.46748 128.74409 49.487209 128.8019 49.55859 
  128.763 49.576382 128.49719 49.585258 128.3183 49.537769 
  127.8205 49.59082 127.6866 49.670818 127.6658 49.752209 
  127.5286 49.78915 127.5039 49.83498 127.5305 49.919151 
  127.4852 49.984989 127.4902 50.048599 127.5783 50.145538 
  127.5885 50.211208) #(98.934563 52.14201 98.878304 52.10915 
  98.869423 52.038601 98.726067 51.843319 98.631638 51.782211 
  98.369423 51.730808 98.309692 51.694698 98.227753 51.451382 
  98.056923 51.45248 97.936363 51.307209 97.958588 51.223309 
  97.827759 51.001099 97.868301 50.937481 98.015808 50.85054 
  97.963867 50.77832 98.079147 50.620258 98.30246 50.544151 
  98.32637 50.504162 98.289688 50.29388 98.107193 50.04887 
  97.863861 49.932758 97.777763 49.968868 97.584702 49.920269 
  97.59108 49.84721 97.484131 49.787491 97.30275 49.730808 
  97.169418 49.761662 96.996918 49.89415 96.713303 49.919979 
  96.592468 49.86499 96.564407 49.91666 96.514687 49.930271 
  96.379143 49.8936 96.274689 49.953602 96.065247 50.005821 
  95.952759 49.94582 95.887482 50.021099 95.8172 50.021931 
  95.520813 49.894428 95.42247 49.956089 95.066071 49.961929 
  94.967468 50.056931 94.622742 50.02998 94.383873 50.224701 
  94.292473 50.560261 94.218857 50.57777 93.726913 50.579708 
  93.448853 50.622478 93.321907 50.6036 93.019699 50.613041 
  92.997993 50.63792 92.976967 50.662029 92.97052 50.66943 
  92.99913 50.751381 92.986633 50.785259 92.928848 50.799992 
  92.792191 50.786652 92.764687 50.716091 92.698853 50.683041 
  92.640533 50.68832 92.393311 50.874699 92.32692 50.854988 
  92.316071 50.788319 92.258324 50.723869 92.151917 50.692211 
  91.884697 50.713039 91.723862 50.672211 91.467743 50.526932 
  91.433578 50.466091 91.294128 50.47554 90.979691 50.409981 
  90.698578 50.219429 90.071907 50.090542 90.02803 50.064152 
  90.021088 49.99638 89.977463 49.969978 89.70137 49.934978 
  89.639969 49.899151 89.654419 49.789989 89.714691 49.769981 
  89.718033 49.71748 89.372192 49.579708 89.346359 49.596931 
  89.226639 49.638321 89.197456 49.611099 89.23497 49.540539 
  89.181923 49.506939 88.98941 49.466648 88.928848 49.546379 
  88.887482 49.543598 88.879677 49.523602 88.906631 49.446091 
  88.846916 49.44165 88.650803 49.500542 88.568863 49.475811 
  88.407753 49.483871 88.196617 49.449421 88.131912 49.36832 
  88.156357 49.341648 88.162193 49.272209 87.979424 49.175541 
  87.839973 49.171841) #(116.7088 49.82819 116.6086 49.933868 
  116.2358 50.028042 116.105 50.012211 115.7311 49.88081 
  115.3955 49.901649 115.1575 50.040539 114.8541 50.228321 
  114.6655 50.264709 114.4633 50.24332 114.313 50.284161 
  114.2094 50.259708 113.5861 50.01638 113.1811 49.787491 
  113.0908 49.598591 112.7311 49.497761 112.4833 49.540272 
  112.135 49.437759 111.3522 49.366928 110.9491 49.188869 
  110.7003 49.142208 110.6161 49.1572 110.395 49.25388 
  110.3186 49.19553 109.523 49.239429 109.3686 49.32777 
  108.5477 49.338322 108.455 49.39249 107.9475 49.683319 
  107.9782 49.947392) #(87.345329 49.095699 87.299698 49.210602 
  87.218903 49.246101 87.052498 49.2542 87.0392 49.287201 
  86.926697 49.3531 86.964401 49.391899 86.839699 49.452202 
  86.846901 49.521702 86.746902 49.5639 86.683296 49.551899 
  86.634697 49.570801 86.611099 49.601398 86.666901 49.655602 
  86.695801 49.6744 86.753098 49.673302 86.800301 49.702202 
  86.761398 49.739399 86.783302 49.785801 86.616402 49.797199 
  86.611099 49.761101 86.513603 49.7089 86.480797 49.6511 
  86.426399 49.621399 86.293297 49.589401 86.245796 49.5014 
  86.191101 49.4725 86.132797 49.532799 86.044998 49.520302 
  86.000298 49.4883 85.969398 49.488602 85.953598 49.5214 
  85.9692 49.566399 85.907501 49.5742 85.837196 49.5439 
  85.770798 49.580002 85.690598 49.5644 85.630798 49.627499 
  85.531898 49.5914 85.473099 49.594398 85.4039 49.623299 
  85.2742 49.584999 85.211098 49.647202 85.216698 49.701401 
  85.197502 49.733299 85.091904 49.819698 85.083603 49.881401 
  84.977798 49.9128 84.979202 49.997799 85.058296 50.013599 
  85.014397 50.075802 84.916397 50.104198 84.860603 50.088902 
  84.8106 50.144199 84.736397 50.146099 84.6744 50.196899 
  84.569397 50.193901 84.516403 50.220798 84.4739 50.256699 
  84.3731 50.209702 84.337196 50.247501 84.266899 50.270599 
  84.262802 50.354401 84.196899 50.453098 84.223099 50.514702 
  84.166901 50.557499 84.167503 50.6003 83.970001 50.715599 
  83.972504 50.801701 83.901703 50.8139 83.8358 50.880798 
  83.731102 50.885601 83.662498 50.932499 83.4972 50.9617 
  83.456398 51.002499 83.138603 51.0019 83.087196 50.923599 
  83.010002 50.8894 82.761101 50.910801 82.727501 50.898899 
  82.720299 50.810799 82.498901 50.7211 82.442802 50.758099 
  82.377197 50.7453 82.3564 50.759701 82.3172 50.743599 
  82.279404 50.754398 82.236702 50.720299 82.150299 50.710602 
  82.097801 50.721699 82.011101 50.7714 81.915604 50.7869 
  81.828903 50.768299 81.782799 50.793301 81.761101 50.790001 
  81.7258 50.747501 81.599403 50.736099 81.468102 50.742199 
  81.440804 50.759998 81.489998 50.841099 81.421898 50.927799 
  81.424698 50.9664 81.301399 50.970001 81.183098 50.943901 
  81.076401 50.9478 81.092499 51.018101 81.1689 51.137199 
  81.183601 51.196098 81.128899 51.204201 81.100601 51.180302 
  81.040802 51.1814 80.9403 51.2211 80.944199 51.271099 
  80.932198 51.283901 80.899399 51.290001 80.8722 51.2589 
  80.687798 51.3144 80.637497 51.259399 80.633301 51.214401 
  80.484398 51.2164 80.438599 51.197498 80.430496 51.118599 
  80.480003 51.080601 80.486702 51.0583 80.467796 50.9678 
  80.385597 50.9231 80.283897 50.922501 80.245796 50.893902 
  80.198898 50.887798 80.188301 50.838299 80.171898 50.828602 
  80.136101 50.819401 80.0653 50.860001 80.035004 50.832802 
  80.109398 50.763302 80.077797 50.7575 79.983299 50.826099 
  79.5364 51.450001 79.336899 51.669201 78.916397 52.1842 
  78.542801 52.590599 78.452499 52.708099 78.073097 53.075298 
  78.046402 53.126099 77.921402 53.2589 77.801102 53.345798 
  77.523903 53.506401 76.542801 53.973301 76.4981 54.053299 
  76.392502 54.158901 76.5214 54.170799 76.641701 54.137199 
  76.721397 54.153301 76.802498 54.227501 76.810799 54.260799 
  76.855797 54.293598 76.864998 54.3181 76.855797 54.358898 
  76.785301 54.3736 76.7789 54.394199 76.925003 54.4375 
  76.923599 54.475601 76.811699 54.4478 76.699402 54.444698 
  76.675301 54.43 76.656898 54.367802 76.576401 54.3633 
  76.487801 54.3256 76.238899 54.358898 76.1856 54.295601 
  76.207199 54.259201 75.692726 54.112614 75.573601 54.097198 
  75.501099 54.115299 75.384201 54.0672 75.457199 53.994202 
  75.3694 53.970798 75.033897 53.806702 74.947197 53.8386 
  74.812202 53.844398 74.787201 53.8339 74.758301 53.766899 
  74.675301 53.763901 74.646896 53.688301 74.4664 53.693298 
  74.438904 53.610001 74.483597 53.5844 74.429199 53.4786 
  74.376404 53.471699 74.283897 53.5275 74.293602 53.560799 
  74.266899 53.566101 74.246696 53.6022 74.159401 53.605801 
  74.143097 53.573299 74.088303 53.573898 74.081398 53.632198 
  73.917503 53.654202 73.811096 53.598301 73.775597 53.6175 
  73.676903 53.6194 73.6633 53.5681 73.6008 53.573101 
  73.581703 53.519699 73.437202 53.4361 73.3703 53.4669 
  73.414398 53.527802 73.253899 53.580002 73.281898 53.613899 
  73.238602 53.644402 73.2603 53.6833 73.329697 53.693298 
  73.3564 53.7897 73.461098 53.816101 73.414398 53.8358 
  73.4431 53.875801 73.500801 53.883099 73.653603 53.864201 
  73.7117 53.875 73.763901 54.065601 73.699699 54.055801 
  73.6903 54.086899 73.611702 54.077499 73.6269 54.0392 
  73.541702 54.015301 73.545799 53.9594 73.4944 53.951401 
  73.470596 53.9772 73.410004 53.982201 73.397202 53.948601 
  73.069397 53.988899 73.059402 54.043301 73.000603 54.0536 
  72.993599 54.1161 72.975304 54.1283 72.865799 54.1231 
  72.814697 54.1381 72.613297 54.145302 72.550598 54.1078 
  72.528847 54.050747 72.669403 54.063599 72.731102 53.9617 
  72.57 53.987499 72.478302 53.909199 72.396103 53.927799 
  72.445602 54.0261 72.390602 54.057499 72.3806 54.0942 
  72.486397 54.113602 72.508904 54.142799 72.321701 54.1861 
  72.360298 54.244202 72.344398 54.263599 72.291397 54.274399 
  72.2883 54.300301 72.196899 54.373901 72.1689 54.376701 
  72.051697 54.387798 72.045303 54.363098 72.133904 54.314999 
  72.105003 54.287498 72.084702 54.229198 72.205803 54.200001 
  72.211403 54.1506 72.190598 54.135601 72.1222 54.133099 
  72.032501 54.2356 71.889397 54.258099 71.767799 54.255299 
  71.730598 54.2131 71.749199 54.1544 71.653603 54.110001 
  71.596703 54.136902 71.501099 54.1133 71.483299 54.1936 
  71.405296 54.191101 71.336403 54.215 71.257797 54.126099 
  71.1856 54.103298 71.1147 54.1814 71.064148 54.193054 
  71.079399 54.209999 71.074997 54.270802 70.997803 54.278099 
  70.996902 54.339199 71.086403 54.339199 71.125 54.317501 
  71.2136 54.325802 71.221703 54.410301 71.188599 54.419399 
  71.195801 54.471401 71.167198 54.483601 71.160301 54.5956 
  71.2883 54.634201 71.2789 54.6903 71.227501 54.733898 
  71.105301 54.736099 71.0131 54.797501 71.025002 54.8494 
  70.9683 54.893101 70.999702 54.955601 70.9758 54.9758 
  70.996399 55.0242 70.997803 55.095798 70.803299 55.250801 
  70.8433 55.301899 70.798103 55.318901 70.679199 55.313599 
  70.5783 55.276402 70.470299 55.297199 70.421898 55.261398 
  70.3983 55.209202 70.288101 55.187199 70.238899 55.138901 
  70.055801 55.207802 69.949203 55.204201 69.8461 55.294998 
  69.672798 55.354401 69.491096 55.357498 69.351402 55.394402 
  69.232803 55.3325 69.1856 55.343899 69.168297 55.4006 
  68.952499 55.444698 68.923302 55.424198 68.9394 55.3703 
  69.001099 55.3536 69.002502 55.287498 68.933296 55.286098 
  68.893097 55.3358 68.855003 55.350601 68.724724 55.366116 
  68.700302 55.333302 68.705002 55.286701 68.638901 55.2556 
  68.642502 55.223099 68.625801 55.2019 68.568298 55.211899 
  68.500298 55.190601 68.388901 55.204201 68.357498 55.1875 
  68.313103 55.190601 68.304497 55.205299 68.199699 55.178299 
  68.229698 55.1619 68.210297 55.138901 68.2444 55.104698 
  68.330803 55.080601 68.323601 55.0569 68.259399 55.048901 
  68.25 55.011902 68.212502 54.999699 68.205299 54.966099 
  68.034401 54.950298 67.9244 54.982498 67.832199 54.963299 
  67.766403 54.891899 67.581398 54.854401 67.4758 54.8647 
  67.4011 54.850601 67.3228 54.8675 67.245598 54.806702 
  67.077499 54.796398 67.015297 54.772499 66.808899 54.766701 
  66.722801 54.726898 66.4953 54.723099 66.110466 54.645519) 
#(87.839973 49.171841 87.446617 49.07748 87.345329 49.095699) 
#(16.94486 48.616501 16.8866 48.73032) 
#(16.8866 48.73032 16.77388 48.723869 16.65583 48.787769 
  16.5275 48.81081 16.37055 48.733871 16.060551 48.760269 
  15.95417 48.82832 15.78528 48.87748 15.34055 48.985821 
  15.15972 48.944698 15.15222 49.001381 14.99416 49.01582 
  14.96111 48.766651 14.8125 48.781368 14.70028 48.581379 
  14.45861 48.648319 14.38111 48.57555 14.04167 48.615822 
  14.04527 48.676929 13.81463 48.78714) 
#(13.50528 48.58305 13.44833 48.5686) 
#(13.81463 48.78714 13.79305 48.726089 13.83333 48.698872 
  13.72666 48.517761) #(13.72666 48.517761 13.50528 48.58305) 
#(22.558001 49.079418 22.547489 49.0322 22.465269 48.97554 
  22.326389 48.683868 22.157221 48.576649 22.151449 48.41206) 
#(134.5712 48.363819 134.4913 48.347481 134.4176 48.389408) 
#(134.7408 48.267811 134.601 48.313869 134.5712 48.363819) 
#(13.44833 48.5686 13.43389 48.419979 13.36861 48.351929 
  12.92952 48.209301) #(26.635 48.240871 26.31638 48.186371) 
#(16.976681 48.174179 16.94972 48.278042 16.84083 48.368591 
  16.85611 48.419151 16.896391 48.487209 16.94486 48.616501) 
#(17.0681 48.14415 16.976681 48.174179) 
#(22.151449 48.41206 22.271379 48.404148 22.260269 48.360821 
  22.319441 48.36166 22.31583 48.321098 22.383329 48.244148 
  22.507771 48.245258 22.620461 48.10181) 
#(22.620461 48.10181 22.74416 48.114712 22.84095 48.086769) 
#(19.001249 48.068779 19.476379 48.089149 19.535 48.2122 
  19.66221 48.23193 19.9186 48.129978 20.06555 48.180271 
  20.15027 48.260269 20.291941 48.254711 20.364719 48.30582 
  20.509991 48.537769 20.824711 48.575821 21.125549 48.492489 
  21.44277 48.57526 21.614161 48.498322 21.62805 48.449421 
  21.738041 48.350819 21.86277 48.36554 22.10166 48.377201 
  22.151449 48.41206) #(19.001249 48.068779 18.827499 48.03582) 
#(17.251659 48.02499 17.179899 48.00182) 
#(17.0681 48.14415 17.08083 48.07999 17.179899 48.00182) 
#(117.7638 47.974709 117.808 48.011929 117.9553 48.00721) 
#(87.345329 49.095699 87.259697 49.111099 86.861633 49.104988 
  86.73053 48.97221 86.746078 48.910542 86.821373 48.846649 
  86.774406 48.714432 86.644974 48.616379 86.596077 48.536098 
  86.344131 48.495258 86.230797 48.425259 86.021637 48.436932 
  85.777763 48.40221 85.551826 47.97274) 
#(23.544991 48.00843 23.480551 47.977482 23.17416 48.108601 
  23.12388 48.088322 23.091101 48.01582 23.034161 47.989979 
  22.93416 48.008881 22.93722 47.964989 22.894859 47.9533) 
#(22.84095 48.086769 22.88694 48.036652 22.865271 48.01054 
  22.894859 47.9533) #(23.544991 48.00843 23.64138 47.99276 
  23.874161 47.9286 23.97555 47.960541 24.131109 47.910809 
  24.168591 47.92334) #(12.92952 48.209301 12.75667 48.120541 
  13.00889 47.85416) #(18.849409 47.818439 18.766939 47.877762 
  18.770281 47.956089 18.808331 47.99387 18.827499 48.03582) 
#(117.5124 47.763309 117.7638 47.974709) 
#(18.849409 47.818439 18.8125 47.816662 18.3375 47.740822 
  17.784161 47.746929 17.603331 47.828041 17.251659 48.02499) 
#(26.31638 48.186371 26.272221 48.076099 26.159161 47.984989 
  26.011101 47.97942 25.46833 47.92971 25.23027 47.881371 
  25.12388 47.763882 25.02972 47.72887 24.89749 47.716091 
  24.816389 47.813042 24.6761 47.860271 24.660271 47.906368 
  24.531111 47.95277 24.23805 47.903309 24.168591 47.92334) 
#(17.179899 48.00182 17.1036 47.9772 17.090549 47.88776 
  17.015829 47.868038 17.057501 47.844429 17.083611 47.71027 
  16.7973 47.688) #(16.7973 47.688 16.76194 47.685261 
  16.696449 47.73624) #(131.10249 47.675831 130.9877 47.68832 
  130.9352 47.730259 130.9455 47.800541 130.88519 47.90443 
  130.6774 48.049431 130.6627 48.122211 130.8299 48.301929 
  130.7361 48.423038 130.7636 48.47887 130.7444 48.49387 
  130.62601 48.47665 130.52271 48.613602 130.6705 48.864712 
  130.63271 48.876652 130.2205 48.864151 129.9061 49.036652 
  129.9119 49.081661 129.7319 49.192211 129.7338 49.243038 
  129.7038 49.275822 129.5869 49.270538 129.533 49.304699 
  129.52361 49.38998) #(134.4176 48.389408 134.2294 48.354988 
  133.59351 48.172489 133.5408 48.098869 133.4846 48.0686 
  133.2077 48.113319 132.8844 48.008598 132.80881 47.941929 
  132.7074 47.955818 132.6588 47.935539 132.5827 47.767761 
  132.52879 47.711102 132.2688 47.731369 131.55969 47.661369 
  131.52271 47.723869 131.3938 47.73637 131.10249 47.675831) 
#(116.7088 49.82819 116.6725 49.77499 116.0564 48.863319 
  116.0841 48.815819 115.8111 48.520538 115.8358 48.252491 
  115.54 48.135818 115.5922 47.91943 115.9191 47.691929 
  115.9727 47.691929 116.1155 47.82193 116.2583 47.87859 
  116.4703 47.839149 116.8747 47.888039 117.1111 47.813599 
  117.3278 47.669151 117.3903 47.660542 117.5124 47.763309) 
#(9.727293 47.536259 9.6055527 47.529148 9.5676117 47.543919) 
#(9.5676117 47.543919 9.5582542 47.50407) 
#(117.9553 48.00721 118.5577 47.995258 118.7672 47.772758 
  119.125 47.664989 119.1494 47.533871 119.3464 47.473869 
  119.3086 47.424431) #(13.00889 47.85416 12.93972 47.78471 
  12.9175 47.715542 13.05833 47.706089 13.10028 47.64082 
  13.07417 47.616928 13.05305 47.49638 13.005 47.469429 
  12.80972 47.552212 12.78778 47.58942 12.83083 47.61887 
  12.77389 47.67416 12.505 47.637489 12.44167 47.698589 
  12.24389 47.694698 12.25722 47.743038 12.17722 47.701649 
  12.20639 47.641369 12.19611 47.609428 11.87861 47.606651 
  11.63333 47.595261 11.57444 47.519981 11.42194 47.508881 
  11.40555 47.453869 11.2275 47.400539 11.23666 47.433041 
  11.20305 47.435261 11.10694 47.396381 10.97361 47.400539 
  10.95028 47.46027 10.86583 47.493038 10.90972 47.521931 
  10.84861 47.536381 10.68555 47.55859 10.55444 47.53693 
  10.46527 47.55859 10.48277 47.590542 10.42694 47.576931 
  10.47333 47.435539 10.27444 47.288879 10.16972 47.281101 
  10.21416 47.315262 10.21139 47.386379 10.15444 47.369148 
  10.08722 47.387211 10.10444 47.428871 10.08444 47.46027 
  10.00333 47.483871 9.9633312 47.547771 9.8541641 47.538879 
  9.8136101 47.593601 9.7630539 47.584709 9.727293 47.536259) 
#(9.5582542 47.50407 9.6536102 47.45554 9.664999 47.381371 
  9.6052761 47.359989 9.54041 47.266975) 
#(38.245617 47.090427 38.216099 47.194698 38.313099 47.255798 
  38.319199 47.278301 38.3078 47.299999 38.227798 47.296902 
  38.208099 47.319199 38.285599 47.396099 38.2808 47.5061 
  38.339401 47.601398 38.448898 47.6283 38.605801 47.6381 
  38.691399 47.694199 38.750599 47.683899 38.782501 47.768101 
  38.838299 47.852798 38.897202 47.868301 39.040871 47.866608 
  39.136398 47.8339 39.345299 47.8531 39.411701 47.8297 
  39.599201 47.839401 39.7239 47.818298 39.768101 47.831402 
  39.805801 47.872501 39.796101 47.916698 39.82 47.9697 
  39.7761 48.026402 39.868599 48.040798 39.848301 48.113098 
  39.886398 48.1408 39.9328 48.213299 39.9925 48.235001 
  40.0103 48.259201 39.998901 48.297199 39.9128 48.277802 
  39.8358 48.3153 39.8936 48.337799 39.921398 48.3675 
  39.888302 48.4431 39.838299 48.483898 39.866901 48.500301 
  39.8508 48.557499 39.798901 48.583099 39.669998 48.5881 
  39.656898 48.616699 39.701698 48.676899 39.702202 48.714199 
  39.7272 48.762199 39.757198 48.766399 39.803902 48.817799 
  39.8503 48.822498 39.9758 48.789398 40.0397 48.820301 
  40.076698 48.864201 40.070599 48.8839 40.041901 48.895802 
  39.9706 48.860001 39.923599 48.887501 39.7672 48.9039 
  39.746101 48.944199 39.694401 48.973099 39.7033 49.035301 
  39.9389 49.055 39.940601 49.093899 39.9664 49.123901 
  40.081902 49.183899 40.119202 49.231701 40.166901 49.2486 
  40.160599 49.2836 40.179699 49.3269 40.170799 49.355 
  40.088902 49.424702 40.053101 49.478298 40.07 49.5228 
  40.1478 49.568901 40.134914 49.604839 40.005001 49.614399 
  39.939201 49.571701 39.821701 49.5494 39.761101 49.584702 
  39.639702 49.615601 39.580799 49.730801 39.520599 49.734402 
  39.464199 49.758301 39.365299 49.733101 39.273602 49.7519 
  39.192799 49.8778 39.145 49.876099 39.069199 49.817799 
  38.945301 49.807499 38.889198 49.868099 38.759201 49.887199 
  38.696098 49.927502 38.686699 49.978901 38.642502 49.956902 
  38.595299 49.965801 38.498901 49.9519 38.454201 49.9842 
  38.376099 49.987499 38.3372 50.0592 38.314201 50.073101 
  38.1842 50.065601 38.1964 49.989399 38.185299 49.951099 
  38.1492 49.928101 38.1036 49.938599 38.0242 49.903301 
  38.009701 49.9039 38.013599 49.934399 37.925301 50.0247 
  37.733101 50.087799 37.7047 50.133598 37.605301 50.216702 
  37.6236 50.305302 37.4944 50.351398 37.4631 50.400002 
  37.458599 50.439701 37.3158 50.428101 37.2397 50.3769 
  37.1306 50.348301 37.052799 50.336899 36.973301 50.3489 
  36.790798 50.3036 36.701099 50.266899 36.650002 50.214699 
  36.630001 50.2122 36.555599 50.2272 36.5467 50.2467 
  36.563301 50.276402 36.512798 50.281101 36.4128 50.321701 
  36.3606 50.289398 36.297501 50.284401 36.205299 50.3661 
  36.188301 50.4011 36.160599 50.400299 36.139198 50.425301 
  36.007801 50.439201 35.8503 50.4286 35.794201 50.394199 
  35.739201 50.383301 35.728901 50.353298 35.6875 50.346699 
  35.589199 50.3778 35.5672 50.453098 35.467201 50.480301 
  35.436401 50.5214 35.3936 50.6381 35.488602 50.6758 
  35.458302 50.694199 35.456699 50.7728 35.3978 50.803101 
  35.397499 50.845001 35.3606 50.8722 35.361401 50.926102 
  35.305599 50.944401 35.305801 50.9594 35.297199 50.999699 
  35.358601 51.010799 35.374699 51.038601 35.301899 51.0606 
  35.170799 51.054699 35.121899 51.144699 35.120602 51.201698 
  35.073898 51.221401 35.026901 51.207199 34.958099 51.222198 
  34.917801 51.197201 34.735001 51.172501 34.669998 51.179401 
  34.633598 51.242199 34.537498 51.2342 34.382198 51.263599 
  34.305302 51.230801 34.209702 51.259399 34.279701 51.291901 
  34.3144 51.347198 34.298599 51.3689 34.239201 51.379398 
  34.203602 51.4067 34.239201 51.427799 34.2342 51.5467 
  34.1744 51.588299 34.159698 51.628601 34.104198 51.644699 
  34.099201 51.6661 34.1147 51.680801 34.3908 51.715 
  34.4333 51.7328 34.440601 51.7672 34.383999 51.843307 
  34.334999 51.8578 34.302799 51.887199 34.257801 51.879398 
  34.2481 51.9067 34.169399 51.959999 34.109402 51.959702 
  34.128101 51.9897 34.073101 52.060299 34.075802 52.116901 
  34.097801 52.151901 34.056702 52.201401 33.9683 52.230801 
  33.923599 52.294201 33.863899 52.3167 33.841702 52.3433 
  33.6964 52.361698 33.535301 52.293301 33.512199 52.3111 
  33.527199 52.3475 33.497799 52.366699 33.448898 52.343601 
  33.396702 52.3661 33.336399 52.356899 33.2047 52.3797 
  33.095798 52.310001 33.055599 52.313099 32.923599 52.2472 
  32.860001 52.270302 32.731701 52.261398 32.552502 52.32 
  32.5028 52.314201 32.394199 52.3353 32.358299 52.310001 
  32.386398 52.2547 32.340599 52.221401 32.335602 52.1572 
  32.299198 52.109402 32.224998 52.079399 32.124401 52.0439 
  32.0186 52.057201 31.926399 52.036701 31.9042 52.053902 
  31.8978 52.0961 31.783899 52.108101) 
#(9.54041 47.266975 9.5470381 47.256908 9.5544796 47.255569 
  9.5631638 47.250389 9.5750189 47.249538 9.5726204 47.245594 
  9.5671291 47.237228 9.5601702 47.233093 9.5540218 47.227009 
  9.5633354 47.222412 9.5726013 47.221859 9.5792828 47.214993 
  9.582921 47.20771 9.5827618 47.199009 9.5784254 47.192017 
  9.5748539 47.185555 9.5724745 47.177116 9.575861 47.167278 
  9.5848875 47.168568 9.5940237 47.166775 9.5997219 47.159332 
  9.6067247 47.155319 9.6152954 47.152386 9.6234531 47.152031 
  9.62813 47.143059 9.6304989 47.137081 9.6376333 47.128601 
  9.6348743 47.120762 9.6331272 47.113422 9.6383324 47.105957 
  9.6409492 47.097168 9.6333141 47.090279 9.6292839 47.083153 
  9.6228962 47.078316 9.6173944 47.071007 9.6112404 47.06469 
  9.6054239 47.057774 9.6018343 47.049644) 
#(90.761093 46.99971 90.48996 47.32193 90.465813 47.500271 
  90.407753 47.543049 90.357468 47.643318 90.356918 47.674431 
  90.13414 47.737492 90.083313 47.797489 90.091637 47.865261 
  90.067467 47.889431 89.976639 47.89193 89.938858 47.836369 
  89.781921 47.82832 89.668297 47.91304 89.590813 48.029709 
  89.530533 48.04137 89.2258 47.980541 89.077469 47.995541 
  88.933296 48.115261 88.833862 48.110271 88.60524 48.217758 
  88.574142 48.362759 87.973297 48.576931 87.969421 48.607491 
  88.020813 48.63332 88.088577 48.706379 88.039139 48.747211 
  87.905533 48.773041 87.759407 48.881649 87.781357 48.927479 
  87.873016 48.951931 87.899406 49.002209 87.839973 49.171841) 
#(10.46624 46.885422 10.46357 46.86935) 
#(9.6018343 47.049644 9.8755512 47.02248 9.8736076 46.958599 
  10.06333 46.86499 10.17528 46.858601 10.31083 46.950539 
  10.40083 47.001099 10.48861 46.934978 10.46624 46.885422) 
#(16.696449 47.73624 16.686661 47.74387 16.55583 47.7561 
  16.53249 47.71471 16.45055 47.69804 16.43388 47.664429 
  16.64888 47.629711 16.71249 47.539989 16.64555 47.45277 
  16.45055 47.4072 16.491659 47.27998 16.43861 47.252769 
  16.4561 47.146931 16.52055 47.155258 16.527769 47.13443 
  16.46805 47.095261 16.516939 47.06081 16.45916 47.02943 
  16.346939 47.009991 16.106701 46.851391) 
#(16.026939 46.661369 15.99333 46.737209 15.99361 46.834709 
  16.106701 46.851391) #(16.026939 46.661369 15.64944 46.709709) 
#(13.71896 46.525539 13.41222 46.574429 12.89583 46.612759 
  12.43361 46.695259 12.35583 46.777481 12.28361 46.79137 
  12.295 46.863602 12.14444 46.915821 12.13111 47.01638 
  12.20444 47.03915 12.21111 47.090542 11.75583 46.977482 
  11.61527 47.01305 11.41166 46.972481 11.33916 46.995541 
  11.16444 46.9622 11.01472 46.77248 10.73555 46.798599 
  10.76444 46.834148 10.67278 46.874981 10.56083 46.848591 
  10.46357 46.86935) #(16.106701 46.851391 16.28167 46.872478 
  16.35055 46.841091 16.318331 46.779709 16.426661 46.687759 
  16.391661 46.636379 16.609236 46.475174) 
#(13.71896 46.525539 14.08472 46.48859 14.15944 46.440819 
  14.42833 46.446369 14.57444 46.387489 14.59416 46.437481 
  14.81472 46.51276 14.87055 46.615822 15.10527 46.6572 
  15.50083 46.618038 15.64944 46.709709) 
#(66.110466 54.645519 65.991096 54.6175 65.966904 54.7136 
  65.844398 54.6847 65.790604 54.616699 65.7575 54.601398 
  65.483299 54.6381 65.461098 54.615299 65.485298 54.577499 
  65.475601 54.562801 65.355598 54.569401 65.218597 54.527802 
  65.224701 54.480301 65.201103 54.461399 65.240601 54.348099 
  65.2164 54.318901 65.106102 54.315601 65.014702 54.385601 
  64.957802 54.409199 64.899696 54.404202 64.737801 54.341099 
  64.665298 54.356899 64.602242 54.39415 64.547501 54.365601 
  64.476898 54.3708 64.4114 54.341702 64.303101 54.348598 
  64.201897 54.319199 64.085297 54.318298 64.049202 54.2981 
  63.992802 54.3111 63.98 54.280602 64.019997 54.237801 
  63.901756 54.196404 63.806099 54.244202 63.7369 54.259998 
  63.5625 54.206402 63.484402 54.208599 63.413601 54.1744 
  63.325802 54.182499 63.1478 54.180599 63.132198 54.1689 
  63.148899 54.114201 63.110001 54.0956 63.012501 54.101101 
  62.913898 54.0858 62.8339 54.108601 62.7836 54.082802 
  62.644699 54.076401 62.565601 54.0331 62.608898 53.977501 
  62.5481 53.929199 62.5742 53.8969 62.535801 53.8797 
  62.413601 53.946701 62.401699 53.966702 62.470299 54.002201 
  62.457802 54.040001 62.335602 54.021702 62.0247 54.025002 
  62.025799 53.939701 61.855301 53.951698 61.8456 53.998299 
  61.814701 54.008301 61.773899 53.988098 61.6422 54.0019 
  61.631401 53.9594 61.584202 53.956699 61.5728 54.002499 
  61.486698 54.015598 61.450802 54.064999 61.326099 54.069199 
  61.303299 54.033298 61.215599 54.025799 61.25193 53.951206 
  61.2467 53.928299 61.215 53.912498 61.186401 53.923599 
  61.166698 53.9594 61.043301 53.957802 61.0042 53.9394 
  60.9911 53.9044 61.000599 53.889702 61.118599 53.883301 
  61.150002 53.847198 61.224201 53.834202 61.226898 53.811901 
  61.168598 53.769699 61.134701 53.722198 61.0742 53.7108 
  61.0597 53.643299 61.010601 53.639198 60.9772 53.660599 
  60.9175 53.6614 60.902199 53.656898 60.9011 53.624401 
  61.0942 53.616901 61.148102 53.574699 61.343899 53.548302 
  61.395302 53.5928 61.538898 53.5933 61.577499 53.513302 
  61.500801 53.487202 61.434399 53.443298 61.382801 53.452499 
  61.311901 53.511902 61.241901 53.506901 61.237801 53.455799 
  61.1619 53.3894 61.152802 53.362202 61.195599 53.2994 
  61.278599 53.279202 61.390301 53.273899 61.538101 53.215599 
  61.675598 53.255001 61.781101 53.180801 62.104698 53.125 
  62.144699 53.074402 62.101898 52.978298 61.967201 52.9375 
  61.862499 52.986698 61.685299 52.9828 61.620602 52.952801 
  61.462799 53.029701 61.375801 52.992802 61.3092 52.993301 
  61.2033 53.0219 61.108601 52.9828 60.9967 52.978901 
  61.080601 52.929699 60.878101 52.819401 60.858299 52.781898 
  60.731701 52.749699 60.701099 52.7192 60.694199 52.680801 
  60.732498 52.655602 60.735802 52.637501 60.834702 52.635799 
  60.834702 52.529999 60.970798 52.494999 60.9786 52.413101 
  61.061901 52.342499 60.981701 52.310799 60.909199 52.257198 
  60.782501 52.220299 60.715302 52.156898 60.486698 52.154701 
  60.223099 51.999199 60.023338 52.001396 60.002201 51.958302 
  60.0644 51.8736 60.134399 51.8633 60.148102 51.868599 
  60.143902 51.895599 60.1675 51.900002 60.316101 51.831402 
  60.4967 51.801899 60.498901 51.786098 60.464401 51.766102 
  60.4617 51.737801 60.3736 51.695599 60.3867 51.672501 
  60.519402 51.6558 60.527802 51.627201 60.944401 51.619999 
  60.926701 51.5872 60.934399 51.555302 60.9772 51.497501 
  61.016102 51.481899 61.303101 51.446899 61.355801 51.457802 
  61.4217 51.431702 61.498657 51.42868 61.581699 51.303101 
  61.681927 51.268318 61.585602 51.241402 61.549198 51.215599 
  61.4617 50.8731 61.426701 50.803101 61.381401 50.7836 
  60.7789 50.662498 60.698101 50.661701 60.312199 50.692501 
  60.242802 50.718102 60.1703 50.775299 60.165298 50.845798 
  60.115799 50.8633 60.043598 50.8633 59.984402 50.838299 
  59.938599 50.762501 59.9464 50.689201 59.8703 50.6194 
  59.819698 50.547199 59.650799 50.533901 59.5425 50.478298 
  59.4664 50.532501 59.499699 50.5597 59.575802 50.5564 
  59.586399 50.5844 59.527199 50.596401 59.4925 50.629398 
  59.346901 50.6353 59.288898 50.6203 59.234699 50.668301 
  58.9403 50.683102 58.892799 50.701401 58.808601 50.743301 
  58.783298 50.795799 58.6656 50.805 58.664398 50.872501 
  58.596699 50.8661 58.565601 50.915298 58.624401 50.988602 
  58.601398 51.0467 58.543301 51.072498 58.3908 51.079399 
  58.391102 51.115299 58.337257 51.158356 58.215302 51.115799 
  58.191898 51.062801 58.172199 51.054401 58.109699 51.062199 
  58.075802 51.094398 58.002789 51.085049 57.952202 51.074699 
  57.923302 51.096901 57.860802 51.096901 57.794399 51.119999 
  57.749699 51.072498 57.760601 50.964199 57.741901 50.913601 
  57.715302 50.9039 57.569199 50.925598 57.543098 50.915001 
  57.516102 50.875801 57.481899 50.8647 57.3508 50.907501 
  57.297501 51.006401 57.218899 51.0247 57.186401 51.108601 
  57.099701 51.075802 56.873299 51.0583 56.774399 51.090801 
  56.700298 51.0564 56.729198 50.977798 56.626099 50.985802 
  56.529999 51.074699 56.5033 51.081699 56.439201 51.035 
  56.4533 50.9781 56.3731 50.958099 56.356098 50.901699 
  56.321701 50.888599 56.178101 50.916401 56.1161 50.739201 
  55.9314 50.639702 55.779701 50.5914 55.701401 50.532799 
  55.638302 50.557201 55.5942 50.5975 55.544998 50.605598 
  55.497799 50.661701 55.4436 50.669201 55.369999 50.651901 
  55.2314 50.73 55.075298 50.8283 55.088299 50.8853 
  55.0681 50.900299 54.948101 50.903599 54.828899 50.983299 
  54.705002 51.0322 54.647202 51.0369 54.564701 51.017502 
  54.5453 51.000599 54.5667 50.957199 54.519402 50.9314 
  54.627499 50.907501 54.673901 50.873901 54.6483 50.818901 
  54.676102 50.783901 54.658298 50.721901 54.703098 50.613098 
  54.610298 50.543598 54.520664 50.530659 54.4436 50.563301 
  54.397499 50.631401 54.439201 50.708099 54.438099 50.765301 
  54.503899 50.828098 54.506401 50.856899 54.420601 50.8894 
  54.301399 50.907501 54.266701 50.945599 54.204399 50.9669 
  54.167198 50.998299 54.172501 51.029202 54.133099 51.106098 
  54.041901 51.122799 54.020302 51.160301 53.957199 51.1931 
  53.876701 51.1917 53.806099 51.215599 53.678299 51.227501 
  53.6614 51.2672 53.6133 51.298901 53.619701 51.341099 
  53.595798 51.3606 53.637199 51.372501 53.638599 51.393101 
  53.471401 51.450802 53.4286 51.491699 53.356701 51.506699 
  53.294399 51.486401 53.208099 51.491901 53.155602 51.514702 
  53.1483 51.482498 53.048302 51.491699 52.943901 51.448601 
  52.8881 51.460602 52.8853 51.487499 52.822201 51.485001 
  52.769699 51.5042 52.677799 51.452801 52.647202 51.467201 
  52.583099 51.464401 52.5014 51.5103 52.470299 51.5914 
  52.386902 51.68 52.346901 51.781101 52.313301 51.7789 
  52.296902 51.733101 52.177502 51.728901 52.137199 51.6786 
  52.105801 51.6642 52.020599 51.663601 51.9258 51.687199 
  51.874199 51.673599 51.780602 51.594398 51.803299 51.5 
  51.6819 51.4547 51.650002 51.4697 51.649399 51.528599 
  51.591099 51.544998 51.525002 51.492802 51.437199 51.4692 
  51.303101 51.479698 51.287201 51.515301 51.258099 51.5322 
  51.2589 51.550598 51.391399 51.568901 51.403301 51.614399 
  51.389999 51.638302 51.302502 51.648102 51.258099 51.694199 
  51.181702 51.676701 50.9389 51.6889 50.8633 51.7514 
  50.7728 51.767727 50.758598 51.7197 50.813599 51.648102 
  50.8106 51.591702 50.782799 51.576401 50.6828 51.573101 
  50.717499 51.622501 50.602798 51.639999 50.5947 51.589699 
  50.543598 51.5672 50.548901 51.468601 50.494701 51.4589 
  50.482201 51.4328 50.384701 51.425301 50.397202 51.3997 
  50.354401 51.378101 50.372799 51.332199 50.3633 51.316898 
  50.2575 51.275299 49.968102 51.226101 49.804199 51.110298 
  49.546101 51.108601 49.461899 51.124199 49.421398 51.084702 
  49.4161 51.043301 49.364399 50.979698 49.4408 50.9058 
  49.4422 50.869999 49.4258 50.851398 49.301102 50.810001 
  49.158298 50.792801 49.0308 50.688099 48.830299 50.596699 
  48.739399 50.608299 48.633301 50.6553 48.598598 50.651901 
  48.5956 50.622501 48.697498 50.5919 48.695 50.4856 
  48.7467 50.2728 48.8111 50.194199 48.7911 50.1236 
  48.8797 50.1017 48.916901 50.034199 48.8283 49.955799 
  48.497799 49.849701 48.450802 49.816898 48.407799 49.837502 
  48.376701 49.833302 48.332199 49.878899 48.2458 49.8731 
  48.248901 49.908901 48.1656 49.966099 48.139702 50.008598 
  48.131901 50.066101 48.1106 50.098598 48.034698 50.147202 
  48.016899 50.1875 47.946899 50.245602 47.880001 50.279999 
  47.828899 50.328602 47.781399 50.342201 47.760799 50.375301 
  47.695599 50.3983 47.634399 50.4547 47.599701 50.4608 
  47.520802 50.436401 47.446453 50.374878 47.4161 50.331902 
  47.3167 50.294399 47.3428 50.241901 47.280602 50.182201 
  47.3358 50.135601 47.356701 50.090302 47.302502 50.031898 
  47.188301 49.944199 47.009201 49.900799 46.929401 49.863602 
  46.795799 49.339699 46.868301 49.3228 47.0261 49.236099 
  47.057499 49.202801 47.062801 49.142799 47.040298 49.098598 
  46.954399 49.0131 46.7789 48.936699 46.499199 48.4175 
  47.122799 48.271702 47.1353 48.2486 47.096401 48.209999 
  47.138302 48.169998 47.1222 48.1022 47.199402 48.0872 
  47.215 48.070801 47.137798 48.0186 47.0625 47.996101 
  47.1828 47.874199 47.138599 47.834702 47.141399 47.8139 
  47.390301 47.6861 47.413101 47.831699 47.427502 47.8428 
  47.625595 47.783081 47.691399 47.7658 47.9189 47.782501 
  48.0961 47.7714 48.240799 47.674702 48.298599 47.587799 
  48.443901 47.436901 48.547199 47.417198 48.7211 47.098301 
  49.027199 46.7761 48.941399 46.704201 48.765301 46.6908 
  48.710602 46.759701 48.589401 46.769699 48.513302 46.736099 
  48.478298 46.666901 48.5578 46.631699 48.5811 46.596401 
  48.5606 46.564999 48.740299 46.5583 48.839199 46.481701 
  48.918098 46.489201 49.063599 46.403099 49.196682 46.365856) 
#(16.939159 46.24609 16.876381 46.3186 16.609236 46.475174) 
#(60.490398 46.211819 60.281651 46.167759 60.140541 46.216099 
  60.150539 46.261101 60.4716 46.242779) 
#(60.4716 46.242779 60.628601 46.24165 60.733318 46.295269 
  60.75943 46.233051 60.709431 46.25082 60.75304 46.185261 
  60.65749 46.139709 60.57832 46.144711 60.490398 46.211819) 
#(22.894859 47.9533 22.77083 47.879429 22.774441 47.836369 
  22.612209 47.768589 22.44166 47.7911 22.421379 47.74387 
  22.31888 47.745819 22.010281 47.508598 22.004709 47.374981 
  21.922501 47.354431 21.868879 47.262211 21.651661 47.025539 
  21.69582 47.00082 21.609159 46.894989 21.43832 46.648602 
  21.32666 46.61998 21.26166 46.486931 21.296101 46.447479 
  21.2875 46.414429 21.19721 46.391369 21.18722 46.32999 
  21.05361 46.23888 20.82972 46.27721 20.75333 46.23888 
  20.76305 46.19915 20.721661 46.184429 20.33555 46.158039 
  20.261141 46.11533) #(8.7615681 46.101528 8.7116089 46.101421) 
#(59.514759 46.07806 59.560822 46.119991 59.564991 46.15749 
  59.42638 46.310822 59.550819 46.359711 59.73444 46.338039 
  59.822491 46.27832 59.86277 46.091648 59.893879 46.099991 
  59.98888 46.2061 60.112492 46.22887 60.079708 46.315819 
  59.943878 46.39249 59.871101 46.458321 59.925819 46.489429 
  59.913319 46.519711 59.868881 46.509708 59.789989 46.524712 
  59.939991 46.59388 60.006939 46.5961 60.176651 46.680408) 
#(53.075871 46.033539 53.16415 46.317211 53.103039 46.44249 
  53.07999 46.508598 52.997211 46.482491 53.006939 46.529991 
  53.207211 46.646648 53.194149 46.714989 53.129162 46.722488 
  53.08276 46.851379 52.896931 46.9636 52.646099 46.946098 
  52.54166 46.98444 52.431381 46.989429 52.355259 46.886379 
  52.175819 46.868599 52.234989 46.831661 52.23999 46.80249 
  52.06971 46.823879 52.00193 46.903599 52.004429 46.935261 
  51.944149 46.875542 51.85471 46.891102 51.89082 46.93388 
  51.785259 46.901932 51.683041 46.95443 51.691101 47.04887 
  51.649429 47.053879 51.597759 46.982491 51.526932 47.055271 
  51.198318 47.115261 51.01054 47.0686 50.900539 47.01276 
  50.840549 47.0336 50.75832 46.908329 50.732491 46.914711 
  50.75526 46.969711 50.606659 46.928322 50.6036 46.853039 
  50.55777 46.823601 50.430271 46.9011 50.21804 46.716648 
  50.192211 46.757488 50.11137 46.701931 49.963329 46.625271 
  49.81221 46.53194 49.768879 46.563042 49.752491 46.530819 
  49.617489 46.57555 49.619991 46.519161 49.483089 46.560909 
  49.467209 46.588329 49.501381 46.492771 49.297211 46.57999 
  49.39304 46.474709 49.278599 46.517769 49.365261 46.424992 
  49.360538 46.388882 49.30027 46.430271 49.219711 46.46693 
  49.286381 46.389431 49.168598 46.40638 49.196682 46.365856) 
#(10.46357 46.86935 10.4475 46.76305 10.38528 46.689419 
  10.40528 46.644428 10.47389 46.63332 10.48528 46.590542 
  10.44972 46.53915 10.30166 46.55582 10.23333 46.63998 
  10.10528 46.61137 10.06833 46.554989 10.05 46.47971 
  10.16305 46.41193 10.11 46.326382 10.17722 46.27248 
  10.15944 46.247761 10.06305 46.222759 9.9963856 46.318321 
  9.9499989 46.37915 9.7374954 46.357208 9.7083321 46.298321 
  9.619442 46.293049 9.5124989 46.331928 9.454443 46.50943 
  9.4019432 46.473309 9.3608303 46.508598 9.2722206 46.48415 
  9.2919407 46.32304 9.0833321 46.12109 9.0195293 46.012299 
  9.0062466 45.989651) #(19.038191 45.967602 19.083891 46.019428 
  19.12388 46.023602 19.15527 45.987209 19.24971 45.99332 
  19.570551 46.173599 19.710819 46.174992 19.80722 46.12804 
  20.11832 46.166931 20.261141 46.11533) 
#(7.6773438 45.961239 7.578887 45.983318) 
#(16.939159 46.24609 17.064159 46.20665 17.209721 46.11832 
  17.320551 45.97443 17.35861 45.949989 17.4261 45.9547) 
#(8.9071693 45.935101 8.8972683 45.952751 8.8955536 45.955818 
  8.7852764 45.989979 8.8505516 46.072491 8.8130531 46.10165 
  8.7615681 46.101528) #(8.9077759 45.93277 8.9071693 45.935101) 
#(8.7116089 46.101421 8.6919422 46.101379 8.4444427 46.2486 
  8.4591637 46.338322 8.451664 46.45998 8.4011078 46.456089 
  8.0902748 46.26054 8.1588879 46.176651 7.998055 46.002209 
  7.9024978 45.9911 7.852777 45.919979 7.6773438 45.961239) 
#(8.9172421 45.91716 8.9077759 45.93277) 
#(18.8281 45.896675 19.038191 45.967602) 
#(7.578887 45.983318 7.393332 45.916088 7.099443 45.883598 
  7.0387468 45.931721) #(9.0062466 45.989651 8.996664 45.973309 
  9.0855522 45.899151 9.0316658 45.823879 8.9630527 45.835541 
  8.9172421 45.91716) #(18.278971 45.760349 18.559441 45.801651 
  18.62916 45.876091 18.69916 45.921101 18.803049 45.88665 
  18.8281 45.896675) #(18.278971 45.760349 18.189159 45.784431 
  18.082491 45.766651 17.79944 45.80888 17.57666 45.94054 
  17.4261 45.9547) #(13.71751 45.59766 13.85944 45.58749 
  13.91916 45.637489 13.82194 45.726929 13.59805 45.81081 
  13.57778 45.85416 13.62361 45.922211 13.635 45.98859 
  13.59 45.99332 13.5425 45.96748 13.47944 46.013321 
  13.64583 46.14249 13.66444 46.183041 13.55055 46.21804 
  13.44333 46.230259 13.38305 46.297211 13.48111 46.369431 
  13.69222 46.45026 13.71896 46.525539) 
#(58.571381 45.57066 58.658329 45.8111 58.733318 45.90638 
  58.995541 46.00721 59.10582 45.996101 59.170269 45.964432 
  59.365822 46.03944 59.446659 46.01054 59.427212 45.946098 
  59.399151 45.945541 59.27388 45.820271 59.286652 45.759159 
  59.491379 45.814159 59.531651 45.921379 59.524151 46.03944 
  59.485538 46.019428 59.514759 46.07806) 
#(119.3086 47.424431 119.4791 47.32999 119.6141 47.248039 
  119.7352 47.15554 119.8014 46.99387 119.9255 46.908871 
  119.928 46.71027 119.7794 46.62859 119.6914 46.597759 
  119.64 46.62748 119.363 46.614429 119.0616 46.677761 
  118.9905 46.750271 118.9177 46.720539 118.8869 46.769711 
  118.8441 46.765541 118.7733 46.683868 118.5536 46.690819 
  118.3102 46.736931 117.9161 46.610271 117.8441 46.534431 
  117.7166 46.513882 117.6327 46.55109 117.5989 46.611931 
  117.4211 46.57832 117.3708 46.364429 117.093 46.359428 
  116.8416 46.3936 116.5855 46.295818 116.363 46.088871 
  116.2341 45.88776 116.2805 45.823318 116.2722 45.789429 
  116.15 45.69331 116.0314 45.685539 115.7019 45.458599) 
#(28.212019 45.4482 28.2381 45.5033 28.283899 45.525299 
  28.477501 45.506401 28.5228 45.517799 28.5303 45.543598 
  28.5114 45.569199 28.556101 45.5867 28.5336 45.607201 
  28.528299 45.644699 28.489401 45.665001 28.526899 45.714199 
  28.5825 45.7197 28.583599 45.7631 28.675301 45.775299 
  28.6947 45.794399 28.6889 45.818901 28.7547 45.8386 
  28.7689 45.866901 28.747801 45.929199 28.7558 45.959999 
  28.971901 46.006699 28.9806 46.029701 28.957199 46.105598 
  29.0411 46.193901 28.9494 46.270802 28.965 46.311901 
  28.932199 46.428299 29.0347 46.4953 29.205 46.541401 
  29.2194 46.532799 29.2283 46.484699 29.2264 46.416901 
  29.2008 46.381401 29.224199 46.365299 29.263901 46.398602 
  29.3067 46.402199 29.3008 46.445 29.3239 46.476398 
  29.3475 46.476398 29.393101 46.4161 29.396099 46.438099 
  29.483601 46.492199 29.5075 46.481098 29.499701 46.432201 
  29.576099 46.419998 29.590799 46.383301 29.626699 46.369202 
  29.6728 46.391399 29.6633 46.4286 29.733101 46.4394 
  29.733299 46.4781 29.801701 46.425598 29.830299 46.3881 
  29.8272 46.361698 29.848301 46.348301 29.884701 46.351101 
  29.93 46.383598 30.103901 46.381901 30.134199 46.4156 
  30.073099 46.422798 30.006901 46.456699 30.0186 46.4697 
  29.998899 46.496101 29.9706 46.488098 29.9286 46.505299 
  29.8986 46.529999 29.8958 46.551102 29.968901 46.575298 
  29.948299 46.636902 29.972799 46.734402 29.9464 46.7892 
  29.950001 46.814201 29.908899 46.814201 29.8689 46.861401 
  29.7614 46.866402 29.7153 46.911701 29.5756 46.9431 
  29.5933 47.025299 29.6236 47.046101 29.6136 47.0844 
  29.5697 47.098598 29.5394 47.066898 29.496901 47.118301 
  29.5714 47.1408 29.5567 47.233101 29.599199 47.263302 
  29.584999 47.319698 29.559401 47.3428 29.5058 47.346401 
  29.475 47.292198 29.4056 47.294998 29.3794 47.321899 
  29.380301 47.3578 29.354401 47.380001 29.3228 47.378601 
  29.3078 47.414398 29.262501 47.4319 29.252501 47.455299 
  29.186701 47.439999 29.131399 47.544201 29.1667 47.5867 
  29.205601 47.632198 29.208099 47.718102 29.258101 47.7644 
  29.249201 47.779999 29.195 47.793098 29.194201 47.808899 
  29.2575 47.874699 29.1936 47.895 29.178101 47.9519 
  29.141899 47.986099 29.080601 47.9828 29.0508 47.9394 
  29.003599 47.933102 28.9561 47.950001 28.8783 48.009998 
  28.8517 48.031898 28.853901 48.055599 28.827499 48.078899 
  28.833099 48.1017 28.815599 48.121399 28.6425 48.153599 
  28.551399 48.160599 28.477501 48.118301 28.4608 48.0714 
  28.4217 48.118599 28.438101 48.138302 28.4186 48.169399 
  28.388599 48.163898 28.3456 48.1269 28.312799 48.1394 
  28.3706 48.196098 28.356701 48.2411 28.295 48.238098 
  28.2225 48.205299 28.187201 48.215599 28.1819 48.249699 
  28.1656 48.2575 28.128099 48.231701 28.0944 48.229401 
  28.0819 48.243301 28.096701 48.288601 28.0856 48.307499 
  27.9631 48.325001 27.90411 48.354271 27.870001 48.3983 
  27.7708 48.4478 27.653299 48.4417 27.607201 48.454399 
  27.599701 48.486698 27.5208 48.465 27.4189 48.416698 
  27.3922 48.4389 27.3431 48.442799 27.2703 48.378899 
  27.2339 48.367802 27.0536 48.406898 27.0494 48.365002 
  26.968901 48.358601 26.853901 48.404999 26.8358 48.378899 
  26.791401 48.381699 26.810801 48.321899 26.803301 48.297199 
  26.750601 48.2994 26.7031 48.3447 26.688299 48.311699 
  26.648899 48.2981 26.635 48.240871) 
#(28.212019 45.4482 28.165001 45.5336 28.061939 45.589981 
  28.161381 45.639431 28.107491 45.835819 28.129721 45.867489 
  28.08444 46.011662 28.13555 46.169151 28.25194 46.439419 
  28.209431 46.502491 28.24721 46.608318 28.213881 46.684429 
  28.07111 46.9911 27.992491 47.028591 27.80694 47.163601 
  27.57222 47.37109 27.579439 47.4547 27.469709 47.48859 
  27.466379 47.523869 27.321939 47.641651 27.28944 47.723591 
  27.238331 47.785259 27.16444 47.967758 27.000549 48.15554 
  26.89444 48.2047 26.707769 48.253319 26.635 48.240871) 
#(16.609236 46.475174 16.5772 46.469398 16.3978 46.540798 
  16.300703 46.531738 16.2514 46.498299 16.2689 46.4119 
  16.3039 46.385799 16.2939 46.374401 16.2631 46.388901 
  16.192499 46.384701 16.144699 46.406101 16.0783 46.3797 
  16.0811 46.3311 16.0172 46.2981 15.8217 46.258301 
  15.7811 46.212502 15.6767 46.2267 15.6519 46.216702 
  15.5997 46.142502 15.6294 46.086899 15.7183 46.047199 
  15.7 46.02 15.7236 45.9347 15.6906 45.902802 15.6794 45.8619 
  15.6978 45.8442 15.6567 45.823299 15.6094 45.848598 
  15.5383 45.826401 15.4994 45.8358 15.4822 45.8022 
  15.4447 45.8158 15.3225 45.761398 15.2919 45.731098 
  15.2833 45.694698 15.3028 45.6908 15.3086 45.719398 
  15.3358 45.697498 15.3586 45.714401 15.3681 45.702801 
  15.3472 45.674999 15.3919 45.646702 15.3481 45.6492 
  15.2831 45.608101 15.3039 45.5378 15.3361 45.5103 
  15.3233 45.482201 15.3353 45.456402 15.2722 45.4617 
  15.2242 45.431099 15.1881 45.4394 15.1686 45.425598 
  15.0847 45.486099 15.0211 45.489399 14.9292 45.524399 
  14.9072 45.476398 14.8178 45.465801 14.7972 45.5014 
  14.7031 45.532799 14.6869 45.536701 14.6853 45.5742 
  14.6136 45.619999 14.6014 45.675301 14.565 45.665001 
  14.5544 45.6311 14.5097 45.598099 14.4858 45.529701 
  14.3928 45.486099 14.3206 45.4842 14.2383 45.5056 
  14.1314 45.4744 13.9894 45.522202 13.9783 45.507801 
  13.9972 45.48 13.9867 45.459999 13.9069 45.4533 
  13.8586 45.4781 13.6914 45.444401 13.6153 45.464401 
  13.569667 45.507072) #(35.43082 45.254429 35.451382 45.280819 
  35.319439 45.359989 35.050282 45.61388 34.911381 45.826382 
  34.871658 45.849152 34.8311 45.809711 34.810822 45.819988 
  34.844711 45.90694 34.778049 46.037491 34.743881 46.012489 
  34.670818 46.095268 34.788879 46.088039 34.777489 46.132771 
  34.72916 46.164711 34.653599 46.177212 34.619709 46.157211 
  34.63221 46.074711 34.57777 45.991379 34.535259 45.983879 
  34.401932 46.009991 34.44138 46.09388 34.484989 46.124149 
  34.558319 46.094711 34.574162 46.154991 34.536652 46.187771 
  34.475819 46.139992 34.346661 46.195541 34.293049 46.19249 
  34.320271 46.108879 34.301102 46.098598 34.236938 46.23082 
  34.15638 46.282211 34.146648 46.256378 34.19305 46.170818 
  34.1511 46.145821 34.13332 46.2061 34.078602 46.18388 
  34.129162 46.149151 34.120819 46.11665 33.933319 46.216648 
  33.691101 46.21999 33.739159 46.139709 33.79887 46.126099 
  33.802212 46.173038 33.847488 46.159161 33.84444 46.10387 
  33.963051 46.01638 33.988319 46.03194 33.94471 46.07832 
  33.944149 46.096371 34.006649 46.098598 34.165821 45.993881 
  34.136101 45.94249 34.170551 45.939159 34.197769 45.99527 
  34.127769 46.053322 34.231659 46.00082 34.276939 46.045818 
  34.298599 45.994709 34.35638 46.019161 34.41637 45.946381 
  34.35693 45.884159 34.389709 45.877209 34.431931 45.923038 
  34.473881 45.931381 34.466099 45.898041 34.494709 45.873322 
  34.576099 45.92416 34.546101 45.96693 34.636379 45.93943 
  34.627209 45.909431 34.49416 45.789989 34.732208 45.88221 
  34.670551 45.837212 34.653049 45.7836 34.748322 45.806099 
  34.757221 45.726101 34.83638 45.70026 34.977211 45.6586 
  35.083321 45.529991 35.09193 45.459991 35.011929 45.419159 
  35.114429 45.3311 35.43082 45.254429) 
#(28.7486 45.224979 28.558611 45.24609 28.31666 45.33749 
  28.2761 45.433319 28.212019 45.4482) 
#(29.66177 45.210239 29.67083 45.287491 29.63694 45.350269 
  29.561939 45.39526 29.314159 45.437759 29.00444 45.321098 
  28.784439 45.32082 28.756941 45.265541 28.799721 45.237759 
  28.7486 45.224979) #(7.0387468 45.931721 6.808887 45.831379 
  6.7991662 45.780819 6.8241658 45.714989 6.9908319 45.63998 
  6.9994431 45.518318 7.1813879 45.411652 7.1330538 45.355549 
  7.122776 45.301929 6.8502769 45.136101 6.7608328 45.16832 
  6.620172 45.110661) #(132.01781 45.24567 132.8369 45.055111) 
#(132.8369 45.055111 132.9391 45.02026 133.033 45.061371 
  133.1277 45.152481 133.103 45.299992 133.1899 45.504162 
  133.4716 45.62693 133.4771 45.826382 133.6608 45.934151 
  133.7244 46.064991 133.6869 46.14304 133.80051 46.21526 
  133.8271 46.19331 133.90331 46.261929 133.8644 46.337761 
  133.9294 46.376652 133.91299 46.413872 133.8499 46.439419 
  133.8477 46.48193 134.0191 46.66666 134.0452 46.764709 
  134.0108 46.812199 134.03909 46.859989 134.06219 46.974979 
  134.1355 47.07777 134.21159 47.092758 134.2227 47.127201 
  134.1563 47.266651 134.31441 47.420818 134.4919 47.43137 
  134.6736 47.571659 134.7722 47.734711 134.55721 47.994431 
  134.5838 48.062481 134.6647 48.10387 134.68381 48.22665 
  134.7408 48.267811) #(20.261141 46.11533 20.37805 45.978031 
  20.59166 45.89415 20.721661 45.74054 20.79583 45.76915 
  20.80472 45.744148 20.76722 45.60582 20.823879 45.537209 
  20.783051 45.484711 20.98666 45.345821 21.09499 45.308319 
  21.48527 45.18082 21.51277 45.12331 21.377399 44.994968) 
#(74.143593 44.96693 74.095261 45.026661 74.153587 45.06749 
  74.157471 45.347759 74.098038 45.322769 74.069427 45.346661 
  74.092194 45.459148 74.064148 45.502209 74.093033 45.540821 
  74.266647 45.618038 74.250809 45.68277 74.327759 45.658329 
  74.329422 45.699429 74.226639 45.71888 74.248871 45.770821 
  74.28775 45.747761 74.320251 45.790539 74.227753 45.96804 
  74.251923 45.99749 74.32164 46.023041 74.531372 45.990261 
  74.66748 46.08305 74.730263 46.07832 74.810257 46.128319 
  74.783043 46.191101 74.854424 46.263599 74.860527 46.33276 
  74.910538 46.412769 74.987198 46.378601 75.039703 46.397209 
  75.109703 46.48637 75.144974 46.488602 75.089142 46.43082 
  75.185257 46.41637 75.276917 46.44582 75.270538 46.52277 
  75.355263 46.52277 75.328873 46.49527 75.362762 46.449711 
  75.473862 46.501381 75.399696 46.580818 75.406647 46.621929 
  75.477203 46.672489 75.567467 46.671379 75.579697 46.650269 
  75.535812 46.615261 75.488037 46.649712 75.471359 46.608601 
  75.582748 46.509708 75.539703 46.46693 75.596359 46.474709 
  75.707199 46.529709 75.954422 46.534988 75.94664 46.499439 
  76.079147 46.50721 76.064148 46.54388 76.121643 46.5261 
  76.255539 46.560822 76.800262 46.517208 76.915817 46.444988 
  77.210823 46.46944 77.291092 46.468319 77.428307 46.49971 
  77.726089 46.380821 77.766083 46.424992 77.870247 46.425819 
  78.050812 46.315819 78.175537 46.310551 78.3172 46.36166 
  78.404694 46.284431 78.461357 46.288319 78.474136 46.316662 
  78.418869 46.346931 78.426651 46.382771 78.461906 46.399712 
  78.886642 46.358879 78.964706 46.387489 79.06665 46.48138 
  79.075531 46.595539 79.241089 46.61721 79.25415 46.662491 
  79.22554 46.72916 79.112198 46.810551 79.013313 46.803879 
  79.032471 46.7411 78.967758 46.749439 78.897202 46.801102 
  78.796654 46.790272 78.770248 46.74638 78.923027 46.622761 
  78.789978 46.619709 78.819427 46.653049 78.785812 46.706928 
  78.743317 46.733051 78.588867 46.743038 78.45665 46.599709 
  78.424149 46.66082 78.410248 46.627209 78.383873 46.607769 
  78.378593 46.669991 78.351929 46.661652 78.363037 46.53054 
  78.328033 46.477772 78.252762 46.47887 78.136368 46.60944 
  77.687759 46.661652 77.604141 46.634159 77.140259 46.545269 
  77.127197 46.578041 77.027481 46.644711 76.932747 46.629429 
  76.837753 46.6861 76.826103 46.658611 76.914703 46.582211 
  76.921371 46.560822 76.713593 46.639149 76.718872 46.67915 
  76.572197 46.664989 76.511368 46.612209 76.411636 46.657211 
  76.399406 46.636379 76.354141 46.73888 76.146637 46.800819 
  75.949142 46.763599 75.936081 46.80471 75.920532 46.82943 
  75.656921 46.77499 75.296371 46.720268 75.108871 46.787491 
  75.089981 46.842491 75.066933 46.807491 74.989433 46.768879 
  74.97554 46.793598 74.988586 46.83054 74.879433 46.811649 
  74.856918 46.770821 74.696907 46.776371 74.558594 46.71777 
  74.533577 46.595829 74.201889 46.42944 74.074692 46.41943 
  73.944702 46.289711 74.038589 46.216099 73.851929 46.197769 
  73.829697 46.162209 73.748032 46.224709 73.62886 46.127491 
  73.751923 45.97443 73.67276 45.963039 73.561081 45.801929 
  73.484154 45.841099 73.444977 45.811649 73.42804 45.784988 
  73.560257 45.746658 73.511642 45.720829 73.515808 45.670269 
  73.439697 45.672771 73.429977 45.594711 73.449692 45.568878 
  73.545532 45.55138 73.703308 45.385818 73.823593 45.305271 
  73.821373 45.266651 74.004967 45.212212 74.006927 45.173321 
  73.988312 45.131939 73.989151 45.093319 74.033859 45.0536 
  73.993317 45.01804 74.143593 44.96693) 
#(19.038099 44.8606 19.0047 44.900299 19.013599 44.916698 
  19.036699 44.932499 19.076099 44.909401 19.1453 44.951099 
  19.142799 44.982201 19.105301 44.983898 19.115299 45.036098 
  19.1042 45.096699 19.081699 45.126099 19.1381 45.1292 
  19.160601 45.145802 19.180799 45.173599 19.163601 45.2122 
  19.223101 45.208599 19.2617 45.180302 19.298599 45.203602 
  19.318899 45.199699 19.3286 45.1758 19.4111 45.174999 
  19.423901 45.184399 19.417801 45.2356 19.2603 45.2472 
  19.253901 45.273899 19.195 45.2686 19.128901 45.2906 
  19.1008 45.308102 19.0853 45.347801 19.038601 45.348598 
  18.9825 45.375801 18.9814 45.3964 19.035801 45.410301 
  18.9944 45.451698 18.999701 45.490799 19.083099 45.487801 
  19.100599 45.512199 19.034401 45.542198 19.024401 45.560799 
  18.948299 45.5378 18.901899 45.570301 18.9081 45.616699 
  18.968901 45.667198 18.909201 45.713299 18.9561 45.736099 
  18.958599 45.778099 18.9333 45.782501 18.9244 45.811901 
  18.8592 45.847198 18.8281 45.896675) 
#(21.377399 44.994968 21.55139 44.92804 21.552771 44.89082 
  21.3661 44.864429 21.360979 44.822609) 
#(49.196682 46.365856 49.232769 46.30777 49.305538 46.26305 
  49.287491 46.249149 49.149151 46.289989 49.14082 46.331661 
  49.057209 46.24749 49.113602 46.23082 49.11166 46.14526 
  49.038319 46.195271 48.956928 46.149429 48.944149 46.121101 
  48.934158 46.081928 48.876381 46.14999 48.87999 46.074989 
  48.82555 46.086651 48.816929 46.049431 48.706379 46.132488 
  48.627769 46.08276 48.70277 46.055538 48.727211 45.973881 
  48.75832 45.941929 48.761662 45.85471 48.708321 45.810822 
  48.59277 45.957211 48.55138 45.963329 48.358879 45.8661 
  48.407768 45.832489 48.285259 45.83305 48.256939 45.76804 
  47.847759 45.71278 47.84832 45.628601 47.81971 45.60638 
  47.78915 45.638882 47.730259 45.68388 47.646931 45.73666 
  47.552212 45.769428 47.551102 45.740551 47.625271 45.708881 
  47.60416 45.633598 47.654991 45.620819 47.64138 45.577209 
  47.619991 45.55582 47.5536 45.65443 47.44556 45.698681 
  47.478039 45.72971 47.394989 45.72221 47.546101 45.633041 
  47.570271 45.564159 47.543049 45.525829 47.487209 45.56638 
  47.54332 45.50526 47.486099 45.418598 47.37804 45.411381 
  47.462769 45.380821 47.42165 45.363041 47.371658 45.178322 
  47.291931 45.18082 47.199162 44.968601 47.09721 44.949711 
  47.11665 44.862209 47.071098 44.7836 47.033039 44.82999 
  47.008881 44.908039 46.987209 44.918049 47.00943 44.821098 
  46.88332 44.746658) #(60.176651 46.680408 60.33054 46.735538 
  60.36721 46.664711 60.373322 46.69804 60.44471 46.595539 
  60.501381 46.647209 60.53027 46.604431 60.636379 46.579708 
  60.718319 46.654148 60.591099 46.723598 60.443878 46.744431 
  60.485821 46.800541 60.82888 46.776661 60.90638 46.752209 
  60.91082 46.699711 60.853321 46.668049 60.810261 46.58054 
  60.907211 46.488041 61.08527 46.483879 61.201931 46.511379 
  61.213039 46.646389 61.163052 46.634708 61.16832 46.674431 
  61.30027 46.67749 61.327492 46.763599 61.51276 46.804989 
  61.51276 46.851101 61.56443 46.870819 61.58971 46.83527 
  61.561649 46.773602 61.63776 46.788879 61.702209 46.756378 
  61.726101 46.709991 61.64249 46.686649 61.53194 46.50304 
  61.445541 46.451099 61.397209 46.486931 61.37249 46.312481 
  61.339989 46.29388 61.31638 46.32999 61.237492 46.219151 
  61.26305 46.19804 61.23415 46.154709 61.135818 46.1036 
  61.028599 46.13332 60.896381 46.100819 61.00832 46.052212 
  61.043598 45.9575 61.134159 45.897491 61.087212 45.85416 
  60.996658 45.85915 61.04443 45.794159 60.909431 45.707489 
  60.92416 45.65221 60.969711 45.61694 61.01693 45.687771 
  61.127769 45.720539 61.147491 45.76305 61.306931 45.61665 
  61.233601 45.540821 61.513882 45.300819 61.52776 45.14888 
  61.619991 45.17944 61.643318 45.135818 61.685822 45.184429 
  61.721931 45.218319 61.731098 45.153599 61.76693 45.184429 
  61.82193 45.171101 61.838039 45.149151 61.709148 45.09277 
  61.71249 45.05027 61.74416 45.02721 61.8311 45.10944 
  61.837212 45.024429 61.964989 45.043598 61.94582 44.959431 
  61.850269 44.99165 61.702492 44.849709 61.667488 44.88805 
  61.64027 44.807209 61.450741 44.735439) 
#(94.364807 44.520519 94.318039 44.58749 94.127182 44.70026 
  93.530807 44.9622 93.095253 45.010269 92.359703 45.01276 
  92.092468 45.07943 91.681084 45.0686 91.453583 45.158039 
  91.383034 45.118591 91.23053 45.151089 91.141647 45.212761 
  91.011917 45.223869 90.939407 45.193039 90.881638 45.204151 
  90.794418 45.394711 90.674683 45.494991 90.719421 45.735538 
  91.021088 46.00832 91.029694 46.04166 90.972473 46.177761 
  90.923019 46.31554 91.072197 46.573318 91.034409 46.74221 
  90.943848 46.828869 90.958862 46.883041 90.857193 46.98859 
  90.761093 46.99971) #(22.691931 44.243061 22.53694 44.336369 
  22.45999 44.482201 22.60944 44.552212 22.69944 44.52248 
  22.763611 44.547489 22.753599 44.569149 22.43638 44.714432 
  22.31361 44.66415 22.206659 44.52499 22.146379 44.479149 
  22.08444 44.50304 21.98888 44.636929 21.62277 44.672211 
  21.600269 44.753601 21.56555 44.771648 21.40027 44.780819 
  21.360979 44.822609) #(61.450741 44.735439 61.320271 44.673321 
  61.279148 44.621929 61.17416 44.673599 61.121101 44.637211 
  61.219151 44.623051 61.161098 44.56638 61.11916 44.599709 
  61.074989 44.538319 61.162209 44.47443 61.124439 44.427212 
  61.142769 44.401661 61.232769 44.449162 61.231098 44.383881 
  61.172489 44.391651 61.19138 44.290539 61.150539 44.34388 
  61.13026 44.323601 61.138882 44.245819 61.136711 44.22628) 
#(12.407696 43.913788 12.4083 43.912201 12.41 43.909199 
  12.4122 43.906101 12.4164 43.904701 12.4217 43.9053 
  12.4256 43.906898 12.4303 43.9081 12.4342 43.909698 
  12.4392 43.909401 12.4428 43.907501 12.4453 43.904701 
  12.4475 43.901901 12.4503 43.899399 12.4542 43.897499 
  12.4592 43.896099 12.4647 43.895599 12.4697 43.896099 
  12.4744 43.897202 12.4778 43.899399 12.4811 43.901699 
  12.4844 43.9039 12.4878 43.9058 12.4906 43.9086 
  12.4928 43.911701 12.495 43.9147 12.4961 43.9189 
  12.4964 43.923302 12.4956 43.9272 12.4967 43.931099 
  12.4994 43.933899 12.5033 43.9356 12.5072 43.937199 
  12.5106 43.939201 12.5117 43.943298 12.5108 43.946899 
  12.5097 43.950802 12.5089 43.954399 12.5078 43.958099 
  12.5069 43.961899 12.5067 43.966099 12.5072 43.9706 
  12.5075 43.9753 12.5086 43.979198 12.5103 43.9828 
  12.51 43.9869 12.5056 43.988602 12.4992 43.988899 
  12.4928 43.989201 12.4872 43.988899 12.4819 43.9883 
  12.4767 43.987499 12.4717 43.9869 12.4669 43.985802 
  12.4625 43.984699 12.4581 43.983299 12.4539 43.981701 
  12.4506 43.979698 12.4478 43.976898 12.4456 43.9739 
  12.4439 43.970299 12.4411 43.9678 12.4378 43.965599 
  12.4344 43.963299 12.4306 43.9617 12.4258 43.960602 
  12.4214 43.9594 12.4167 43.958302 12.4128 43.956699 
  12.4089 43.955002 12.4067 43.9519 12.405 43.948299 
  12.4047 43.9436 12.405 43.9394 12.4039 43.9356 
  12.4036 43.930801 12.4039 43.926701 12.4047 43.9231 
  12.4058 43.919399 12.407696 43.913788) 
#(6.620172 45.110661 6.746666 45.02026 6.7433319 44.947762 
  7.0099988 44.848591 7.0688891 44.689152 7.000833 44.69915 
  6.9508319 44.6647 6.960278 44.628868 6.852777 44.540821 
  6.8572221 44.507771 6.934999 44.443039 6.8861098 44.415821 
  6.935832 44.323318 7.2794442 44.156651 7.6727762 44.182758 
  7.7041659 44.072208 7.4922209 43.869431 7.5347648 43.783451) 
#(28.583839 43.747761 28.224991 43.773041 27.99721 43.85915 
  27.95166 43.97887 27.91888 44.00555 27.820271 43.96582 
  27.721661 43.96471 27.656099 44.042488 27.39999 44.021931 
  27.29055 44.088039 27.275551 44.133041) 
#(27.275551 44.133041 26.923321 44.13665 26.4786 44.049431 
  26.11166 43.968319 25.86277 43.76638 25.572929 43.648281) 
#(25.572929 43.648281 25.36305 43.624699 25.22471 43.687481 
  25.080549 43.69109 25.001381 43.723591 24.501659 43.761379 
  24.337219 43.694431 23.890551 43.756378 23.41305 43.85582 
  23.06361 43.802212 22.857491 43.853321 22.84333 43.90498 
  22.90694 43.998871 22.995819 44.014149 23.04277 44.056648 
  23.03722 44.084431 22.882771 44.128868 22.691931 44.243061) 
#(61.136711 44.22628 61.1311 44.175819 61.049709 44.381649 
  61.02721 44.343319 61.088329 44.176659 61.071659 44.15971 
  61.019428 44.167488 61.03027 44.22887 60.97971 44.333599 
  60.951649 44.322208 60.97332 44.297211 60.96693 44.181381 
  60.928879 44.214432 60.898319 44.206379 60.89138 44.05999 
  60.794159 43.993881 60.754429 44.013882 60.725269 44.01276 
  60.745541 43.88443 60.776661 43.87249 60.84721 43.936649 
  60.90332 43.891651 60.870541 43.84499 60.90443 43.805538 
  61.00499 43.837769 60.997761 43.795269 61.033039 43.783329 
  61.002209 43.651371 60.922771 43.67638 60.87888 43.662209 
  60.890541 43.591099 60.798599 43.601101 60.818321 43.657211 
  60.788052 43.657768 60.758598 43.57972 60.622211 43.585541 
  60.524151 43.62888 60.482491 43.61694 60.473598 43.569149 
  60.443321 43.596661 60.240551 43.561649 60.189159 43.591099 
  60.177212 43.572491 60.183319 43.488041 60.14526 43.46804 
  60.07943 43.509159 59.819439 43.426659 59.74971 43.39304 
  59.76693 43.436649 59.71526 43.46027 59.689159 43.624439 
  59.739429 43.627491 59.783329 43.64555 59.52721 43.710819 
  59.481098 43.798321 59.388599 43.74165 59.29221 43.797771 
  59.159431 43.794991 59.144711 43.689709 59.083881 43.713329 
  59.008881 43.83276 58.8536 43.934711 58.727211 43.935551 
  58.942989 43.874062 58.90276 43.879162 58.84026 43.879429 
  58.83749 43.809429 58.896931 43.82082 59.00555 43.783871 
  59.011662 43.723881 58.951382 43.691109 58.962769 43.748322 
  58.705269 43.69471 58.431381 43.631939 58.328041 43.761929 
  58.394428 44.1675 58.2411 44.276932 58.20499 44.53249 
  58.298038 44.59943 58.301102 44.624981 58.22221 44.681931 
  58.180538 44.858601 58.379429 45.264149 58.513882 45.411652 
  58.571381 45.57066) #(115.7019 45.458599 114.938 45.382759 
  114.7361 45.442211 114.5452 45.389431 114.4622 45.211651 
  114.0741 44.93803 113.9169 44.92276 113.638 44.745258 
  113.1261 44.797771 112.6075 44.92638 112.4272 45.08054 
  111.9808 45.091648 111.785 45.000542 111.568 44.67915 
  111.5611 44.57777 111.4269 44.412762 111.4264 44.33276 
  111.585 44.150822 111.8794 43.938869 111.978 43.76305 
  111.9583 43.692211 111.7839 43.672489 111.5858 43.497211 
  111.4355 43.489429 110.9897 43.316929 110.7253 43.078869 
  110.6736 43.003319) #(19.038099 44.8606 18.840799 44.863098 
  18.767799 44.915798 18.7633 44.944698 18.8008 44.949402 
  18.7939 44.996899 18.7311 44.999401 18.7314 45.0219 
  18.669201 45.061699 18.686899 45.077202 18.6756 45.0942 
  18.66 45.087799 18.6553 45.0578 18.6122 45.0625 
  18.638599 45.0947 18.609699 45.084202 18.573099 45.094398 
  18.574699 45.068901 18.535 45.0956 18.5494 45.076099 
  18.527201 45.047199 18.4739 45.064999 18.429701 45.1064 
  18.323099 45.1031 18.251699 45.138599 18.2164 45.1297 
  18.205299 45.084702 18.1194 45.083099 18.069401 45.104401 
  18.07 45.139198 18.0322 45.128899 18.001699 45.152199 
  17.9639 45.112801 17.933901 45.108898 17.9328 45.080002 
  17.8517 45.049198 17.6703 45.1367 17.5961 45.108898 
  17.555799 45.110802 17.5497 45.131699 17.528099 45.111099 
  17.483299 45.110802 17.4944 45.136398 17.4508 45.128101 
  17.4494 45.159199 17.4228 45.141899 17.3722 45.140598 
  17.2672 45.186901 17.240299 45.1483 17.176901 45.1483 
  17.070601 45.188099 17.035601 45.2267 17.008301 45.216099 
  17.010599 45.239201 16.990299 45.226898 16.9722 45.249401 
  16.968599 45.233601 16.932199 45.234402 16.939699 45.265598 
  16.913601 45.273899 16.8239 45.187199 16.594999 45.230598 
  16.525801 45.2244 16.476101 45.1856 16.4594 45.144402 
  16.395 45.118301 16.4 45.090302 16.3536 45.005798 
  16.2925 45.000599 16.2097 45.034401 16.16 45.085602 
  16.1206 45.095001 16.1119 45.128101 16.051901 45.159401 
  16.0231 45.215 15.9517 45.215801 15.9367 45.2286 
  15.8342 45.211899 15.7811 45.1619 15.7844 45.1203 
  15.7647 45.073601 15.7875 44.9953 15.7697 44.919201 
  15.7983 44.855301 15.7364 44.816898 15.7675 44.7761 
  15.8547 44.714401 15.9569 44.700001 16.0425 44.553902 
  16.121401 44.5047 16.159201 44.393902 16.225 44.3358 
  16.183901 44.305801 16.178301 44.214699 16.143101 44.199402 
  16.249399 44.196701 16.3022 44.1572 16.3547 44.081699 
  16.4389 44.031898 16.537201 44.013599 16.701401 43.850601 
  16.722799 43.786098 16.840799 43.7192 16.9764 43.586102 
  17.098301 43.513599 17.2617 43.459702 17.2719 43.444401 
  17.2561 43.414398 17.2981 43.2808 17.3944 43.230301 
  17.4533 43.161098 17.630301 43.0769 17.6842 42.982201 
  17.676701 42.963299 17.579556 42.944008) 
#(100.0347 42.648319 99.498581 42.57082 98.530258 42.628868 
  97.171631 42.797489 96.383034 42.731091 96.356918 42.906929 
  95.881348 43.279148 95.84552 43.441368 95.539963 43.99276 
  95.33609 44.020821 95.35025 44.177761 95.423286 44.27832 
  95.411087 44.296391 95.020523 44.256939 94.724411 44.349152 
  94.599411 44.453041 94.364807 44.520519) 
#(18.45529 42.564522 18.5539 42.621101 18.577499 42.654999 
  18.560301 42.7122 18.5158 42.731098 18.4547 42.828602 
  18.490801 42.861698 18.4839 42.971901 18.535601 43.0172 
  18.65 43.044201 18.659201 43.080299 18.6439 43.139198 
  18.7075 43.214401 18.6978 43.252499 18.855801 43.332802 
  18.8475 43.3489 18.919399 43.356899 18.9603 43.3228 
  18.954201 43.293301 18.9814 43.284199 19.016701 43.239201 
  19.0481 43.232498 19.072201 43.2481 19.091101 43.316399 
  19.020599 43.391899 19.0231 43.4356 18.956699 43.454399 
  18.9494 43.509399 18.9869 43.522202 19.0117 43.556099 
  19.0539 43.535599 19.07 43.508598 19.176701 43.5294 
  19.2292 43.513302 19.2875 43.544201 19.3158 43.5933 
  19.3717 43.616402 19.4086 43.5844 19.511101 43.573299 
  19.491699 43.590801 19.510799 43.679699 19.487499 43.763302 
  19.250601 43.9622 19.2386 44.013599 19.3736 43.965599 
  19.508101 43.958099 19.6192 44.0186 19.619699 44.051899 
  19.5958 44.067799 19.567801 44.051399 19.5583 44.070301 
  19.503901 44.089401 19.4697 44.128101 19.4767 44.151901 
  19.442499 44.1422 19.358299 44.184399 19.318899 44.272499 
  19.239401 44.264702 19.2019 44.2925 19.1653 44.284401 
  19.1042 44.355801 19.110001 44.3992 19.138901 44.413898 
  19.1467 44.438301 19.125299 44.518299 19.1908 44.548302 
  19.1861 44.576401 19.217199 44.59 19.2703 44.68 
  19.313601 44.704399 19.3458 44.769199 19.3353 44.779701 
  19.3608 44.831402 19.355301 44.852798 19.3822 44.862801 
  19.354586 44.893497 19.250299 44.915798 19.208599 44.901402 
  19.176701 44.923302 19.038099 44.8606) 
#(18.45529 42.564522 18.4119 42.6064 18.362499 42.626701 
  18.2686 42.618301 18.1003 42.750801 17.998899 42.761398 
  17.922501 42.8111 17.882799 42.819199 17.845301 42.859699 
  17.842501 42.903599 17.8214 42.9203 17.7864 42.9039 
  17.698099 42.9272 17.655542 42.891289) 
#(18.510256 42.449402 18.4603 42.4869 18.45529 42.564522) 
#(130.6039 42.42062 130.5663 42.53804 130.618 42.57943 
  130.60519 42.619709 130.5322 42.684429 130.4588 42.679989 
  130.4052 42.71804 130.8185 42.876091 130.8952 42.851379 
  131.12331 42.910809 131.1366 42.936932 131.1055 42.97443 
  131.1077 43.04166 131.21831 43.145821 131.19099 43.196651 
  131.2672 43.276089 131.27409 43.363319 131.31129 43.392208 
  131.3011 43.45998 131.1888 43.536652 131.2063 43.623039 
  131.24719 44.027481 131.298 44.051929 131.09489 44.692478 
  130.99831 44.783871 130.9538 44.846088 131.131 44.928871 
  131.22549 44.913872 131.3499 44.974701 131.4666 44.967201 
  131.65469 45.121929 131.63271 45.16888 131.6669 45.212761 
  131.7536 45.213039 131.8447 45.34082 131.89549 45.338871 
  131.9527 45.260818 132.01781 45.24567) 
#(22.691931 44.243061 22.616659 44.17276 22.622499 44.07082 
  22.416929 44.006939 22.35944 43.816929 22.4886 43.62331 
  22.546391 43.470261 22.769711 43.383598 22.84972 43.2822 
  23.006941 43.199989 22.99333 43.14526 22.73333 42.889709 
  22.585831 42.892761 22.44083 42.8186 22.461941 42.79388 
  22.438601 42.574711 22.484989 42.55582 22.55805 42.479149 
  22.51944 42.399151 22.369419 42.322933) 
#(19.39732 42.31707 19.469709 42.39999 19.63583 42.606091 
  19.717489 42.661369 19.755831 42.639709 19.74666 42.543049 
  19.830271 42.4697 20.064159 42.563042 20.072723 42.558441) 
#(130.6039 42.42062 130.6438 42.399712 130.65491 42.313869 
  130.69479 42.288818) #(85.551826 47.97274 85.536362 47.94331 
  85.573868 47.801929 85.609131 47.499432 85.705544 47.36499 
  85.68663 47.211929 85.58136 47.184711 85.515808 47.058041 
  85.219421 47.039711 84.963593 46.864151 84.784973 46.826382 
  84.735237 46.836929 84.781647 46.925819 84.750809 46.95554 
  84.661362 46.994991 84.033043 46.978321 83.564972 47.0611 
  83.162483 47.223591 83.061363 47.220261 83.031357 47.19915 
  83.014687 46.96027 82.873863 46.763599 82.791077 46.546379 
  82.573303 46.173038 82.536911 45.98859 82.324417 45.590542 
  82.319702 45.52943 82.362183 45.495541 82.589142 45.463871 
  82.649406 45.430271 82.658577 45.345539 82.601067 45.174709 
  82.549408 45.12331 82.481644 45.12748 82.325256 45.23304 
  82.270813 45.235821 81.948013 45.15749 81.804138 45.21471 
  81.797737 45.30582 81.732468 45.350819 81.622192 45.329708 
  80.869423 45.1311 80.787193 45.14777 80.076637 45.0247 
  79.864967 44.896099 79.875793 44.86554 80.022202 44.793598 
  80.262192 44.824429 80.484703 44.74609 80.516647 44.707211 
  80.37468 44.65192 80.407204 44.602211 80.348862 44.45026 
  80.376068 44.37582 80.368027 44.112759 80.424683 44.063869 
  80.438858 43.99221 80.739693 43.46582 80.722473 43.404701 
  80.666641 43.348881 80.668579 43.319439 80.764687 43.293049 
  80.779968 43.264431 80.809967 43.130539 80.770523 43.10833 
  80.638313 43.139149 80.376633 43.025261 80.390259 42.99276 
  80.577759 42.908588 80.564972 42.88026 80.258873 42.81609 
  80.15802 42.632488 80.289139 42.231651 80.285477 42.182358) 
#(80.285477 42.182358 80.176697 42.2197 80.113602 42.3036 
  80.056702 42.336899 79.952797 42.4342 79.815598 42.446098 
  79.716904 42.474201 79.571899 42.453098 79.443901 42.472198 
  79.356697 42.6078 79.269997 42.6292 79.215302 42.679199 
  79.196899 42.7267 79.209702 42.779701 79.194702 42.795799 
  79.027802 42.759701 78.9739 42.782799 78.920799 42.775002 
  78.801697 42.8092 78.689201 42.8125 78.6539 42.8428 
  78.512199 42.8853 78.416901 42.885601 78.336899 42.852501 
  78.265297 42.875599 78.093903 42.857498 77.999199 42.867199 
  77.897499 42.900299 77.829399 42.8708 77.811996 42.9025 
  77.729698 42.9147 77.660004 42.915298 77.591103 42.887501 
  77.535599 42.921398 77.459702 42.930302 77.350304 42.896702 
  77.207802 42.917198 77.147499 42.965599 77.062202 42.9706 
  76.976898 42.996399 76.8536 42.981899 76.811996 42.946899 
  76.774399 42.947498 76.724197 42.916698 76.669403 42.9203 
  76.616898 42.900299 76.500603 42.923302 76.441399 42.891899 
  76.410599 42.9161 76.343102 42.9067 76.323303 42.924999 
  76.240303 42.936901 76.187202 42.927799 76.095001 42.941399 
  76.017799 42.923599 75.910797 42.946701 75.802498 42.940601 
  75.7472 42.850601 75.676102 42.8064 75.568604 42.834202 
  75.209999 42.853298 74.8806 42.9828 74.751701 42.993099 
  74.631401 43.066101 74.566101 43.1325 74.451103 43.152199 
  74.391403 43.195301 74.293297 43.216702 74.201103 43.2686 
  74.235802 43.2314 74.235001 43.207199 74.059402 43.188099 
  73.973099 43.2239 73.9133 43.122799 73.831902 43.1292 
  73.5839 43.038601 73.556702 42.956902 73.513901 42.8964 
  73.525803 42.799999 73.4608 42.710602 73.432503 42.621101 
  73.451103 42.533298 73.5336 42.4189 73.507202 42.404701 
  73.406403 42.434399 73.339699 42.4328 73.328598 42.512501 
  73.209198 42.5214 73.1567 42.560001 72.968102 42.538898 
  72.9086 42.548302 72.832802 42.5769 72.791901 42.6381 
  72.757202 42.656101 72.599197 42.6922 72.5047 42.687801 
  72.296898 42.773602 72.1717 42.773602 72.123901 42.757198 
  71.869698 42.8428 71.808899 42.823601 71.725601 42.821701 
  71.597198 42.763599 71.574203 42.765301 71.530296 42.8022 
  71.5028 42.7892 71.424698 42.804199 71.352798 42.743599 
  71.275299 42.759201 71.227501 42.706699 71.166901 42.686901 
  71.167198 42.604198 71.031097 42.573601 71.033897 42.534698 
  71.089699 42.480801 71.0606 42.4608 70.996399 42.486698 
  70.955002 42.427502 70.962502 42.388302 70.873299 42.313099 
  70.906898 42.266899 70.969398 42.2528) 
#(19.39509 42.087891 19.398331 42.108318 19.28249 42.185539 
  19.39732 42.31707) #(19.3811 41.999432 19.39509 42.087891) 
#(40.006512 43.398197 40.084999 43.555 40.177502 43.5825 
  40.261902 43.580002 40.543098 43.508598 40.642502 43.544399 
  40.6922 43.544201 40.749699 43.504398 40.8825 43.470001 
  41.044201 43.375 41.168098 43.387199 41.295601 43.336102 
  41.393299 43.3461 41.4356 43.296101 41.523102 43.269402 
  41.564999 43.232201 41.605301 43.220299 41.730598 43.227798 
  41.822498 43.204201 41.939701 43.217499 42.0578 43.1861 
  42.1203 43.200298 42.181099 43.2356 42.415298 43.239201 
  42.4786 43.222801 42.534401 43.181099 42.625801 43.143101 
  42.701099 43.182499 42.849998 43.179199 42.936401 43.126099 
  43.021099 43.104401 43.010799 43.056702 43.144699 42.963902 
  43.2136 42.931702 43.393299 42.8992 43.5606 42.860802 
  43.670799 42.7911 43.8325 42.748299 43.836102 42.727798 
  43.735298 42.645302 43.778301 42.6031 43.8675 42.599201 
  43.969398 42.558102 44.0536 42.618099 44.137798 42.619701 
  44.220798 42.636902 44.286701 42.712799 44.3769 42.7089 
  44.549702 42.759399 44.689701 42.736401 44.7547 42.6889 
  44.797199 42.615799 44.8083 42.665298 44.855 42.743301 
  44.8867 42.7603 44.941101 42.757801 45.060299 42.692501 
  45.158901 42.705799 45.241901 42.650799 45.3517 42.5294 
  45.552799 42.550301 45.7006 42.516102 45.756901 42.482201 
  45.638599 42.228901 45.647499 42.2047 45.738899 42.173599 
  45.8092 42.123901 45.910301 42.105 45.960602 42.023899 
  46.010799 42.043098 46.0392 42.0233 46.078098 42.034199 
  46.103901 41.994202 46.240002 42.0014 46.32 41.9389 
  46.394199 41.940601 46.452087 41.896572) 
#(20.072723 42.558441 20.1686 42.506939 20.25222 42.324429 
  20.35166 42.324429 20.5261 42.211651 20.620831 41.949711 
  20.589647 41.884552) #(22.369419 42.322933 22.3244 42.361401 
  22.246401 42.339699 22.221901 42.341702 22.195 42.3153 
  22.124701 42.319698 22.0833 42.300598 21.9958 42.3256 
  21.926399 42.306702 21.8503 42.330799 21.804399 42.3008 
  21.788601 42.263302 21.7383 42.237499 21.609776 42.253181 
  21.557199 42.243599 21.51 42.264702 21.459999 42.262501 
  21.4394 42.229698 21.348101 42.195599 21.306101 42.151402 
  21.3286 42.108101 21.313101 42.093601 21.248301 42.099701 
  21.2153 42.150002 21.141899 42.198101 21.1047 42.198898 
  21.0336 42.1511 20.792801 42.0825 20.759199 41.993301 
  20.777201 41.925598 20.733101 41.863899 20.702499 41.856098 
  20.67 41.871899 20.631701 41.855801 20.589647 41.884552) 
#(19.36846 41.849319 19.3811 41.999432) 
#(46.88332 44.746658 46.763599 44.684429 46.71888 44.614429 
  46.67971 44.523041 46.69138 44.480259 46.732208 44.41415 
  47.040539 44.3461 47.088329 44.24416 47.1586 44.20055 
  47.240261 44.2211 47.362492 43.996929 47.461102 43.864441 
  47.439159 43.818321 47.484989 43.82 47.499149 43.763321 
  47.43832 43.733601 47.451382 43.681099 47.36277 43.610271 
  47.4011 43.509708 47.461651 43.52832 47.555271 43.876099 
  47.636379 43.9011 47.698318 43.868881 47.613041 43.774429 
  47.483879 43.4361 47.49638 43.286098 47.572491 43.33054 
  47.588329 43.29694 47.552212 43.26054 47.45388 43.086102 
  47.476379 43.002769 47.70277 42.857491 47.738319 42.633881 
  47.87138 42.582489 47.915539 42.5061 48.2761 42.124149 
  48.324711 42.030819 48.409161 41.909161 48.549709 41.877209 
  48.589043 41.842365) #(52.443321 41.744499 52.430538 41.755821 
  52.49221 41.91415 52.428322 42.00304 52.418049 42.1236 
  52.594711 42.33527 52.68166 42.556381 52.656101 42.624989 
  52.59943 42.683601 52.71582 42.581661 52.746658 42.6511 
  52.73082 42.718319 52.632771 42.769161 52.547211 42.80777 
  52.377491 42.8311 52.272491 42.786098 52.19693 42.87582 
  52.137211 42.884159 51.935551 42.835541 51.878601 42.85915 
  51.769711 43.032211 51.66888 43.104431 51.677761 43.159161 
  51.647491 43.185261 51.294708 43.144428 51.262211 43.163052 
  51.298321 43.261101 51.315819 43.449711 51.24221 43.577209 
  51.146099 43.619709 51.106659 43.670269 50.983601 43.913879 
  50.850552 44.034431 50.86137 44.097488 50.823318 44.208321 
  50.662209 44.267769 50.413879 44.290539 50.23138 44.368881 
  50.22443 44.573318 50.31554 44.6586 50.669991 44.614159 
  50.810551 44.63332 50.91444 44.605259 50.99527 44.53054 
  51.139992 44.479431 51.207489 44.486099 51.250271 44.51804 
  51.377491 44.553329 51.37999 44.51693 51.570271 44.513882 
  51.570541 44.534161 51.427212 44.60915 51.297489 44.59943 
  51.267769 44.654991 50.953041 44.861931 50.973049 44.943878 
  50.96582 44.978039 51.18277 45.05999 51.282768 45.025539 
  51.24749 45.11166 51.414711 45.38443 51.5061 45.332211 
  51.624439 45.351101 51.755821 45.449989 51.858601 45.39304 
  52.369991 45.403599 52.915539 45.311378 53.235271 45.33527 
  52.743599 45.519989 52.747761 45.646931 53.035259 45.926659 
  53.075871 46.033539) #(26.361879 41.70155 26.332769 41.75304 
  26.377489 41.82193 26.544991 41.830818 26.625271 41.983318 
  26.84333 41.97221 27.070271 42.089981 27.20166 42.060539 
  27.243601 42.107208 27.56666 41.907761 27.57972 41.937481 
  27.821659 41.966648 27.834721 42.00193 28.01305 41.982201) 
#(26.361879 41.70155 26.222771 41.744431) 
#(26.495819 41.664429 26.361879 41.70155) 
#(26.593611 41.611099 26.495819 41.664429) 
#(110.6736 43.003319 110.4719 42.846088 110.4405 42.77776 
  110.1344 42.673599 110.1075 42.645538 109.9277 42.641369 
  109.6955 42.558319 109.5447 42.473869 109.4377 42.45332 
  109.3136 42.429989 109.0 42.458321 108.8455 42.39999 
  108.5278 42.442211 107.5711 42.410259 107.4719 42.466091 
  107.2772 42.410542 107.2625 42.359989 107.0028 42.31332 
  106.7819 42.29554 106.1225 42.07748 105.4677 41.831379 
  105.2269 41.749989 105.0122 41.581379) 
#(105.0122 41.581379 104.9305 41.65192 104.5241 41.663872 
  104.5266 41.877201 104.0611 41.80331 103.8494 41.802479 
  103.4164 41.887211 102.7125 42.161369 102.4425 42.151089 
  102.0772 42.233318 101.8147 42.509708 100.8355 42.67804 
  100.315 42.69109 100.255 42.641102 100.0347 42.648319) 
#(22.369419 42.322933 22.363609 42.319981 22.40777 42.27943 
  22.60944 42.103321 22.803329 42.047771 22.947491 41.802479 
  23.01277 41.76527 23.031389 41.720539 22.98555 41.661369 
  22.964991 41.394428 22.935949 41.3433) 
#(58.571381 45.57066 55.9972 45.003101 55.998451 41.325474) 
#(52.443321 41.744499 52.928101 42.096699 53.014999 42.138901 
  53.298901 42.229698 53.462799 42.2714 53.663101 42.2892 
  53.995602 42.348598 54.198601 42.3325 54.365299 42.235298 
  54.761101 42.058899 54.956699 41.912498 54.956699 41.829201 
  54.971699 41.8022 55.1208 41.6581 55.243301 41.484699 
  55.2892 41.439701 55.394699 41.387199 55.456902 41.286701 
  55.537498 41.262199 55.6525 41.2672 55.728901 41.292198 
  55.812199 41.290001 55.9039 41.333599 55.998451 41.325474) 
#(26.222771 41.744431 26.07444 41.711929 26.06749 41.678871 
  26.09972 41.63665 26.19805 41.439419 26.135269 41.35387 
  25.80583 41.33387 25.653049 41.31776 25.38805 41.26305 
  25.239429 41.254429 25.20999 41.29388 24.894711 41.410542 
  24.79888 41.35471 24.725269 41.418049 24.6586 41.421101 
  24.5261 41.572208 24.36388 41.523602 24.30471 41.548599 
  24.245541 41.56776 24.184719 41.516651 24.157221 41.5411 
  24.078609 41.537209 24.074989 41.467201 23.9561 41.446091 
  23.8911 41.45277 23.668051 41.405819 23.281111 41.403309 
  23.175819 41.322762 22.935949 41.3433) 
#(48.589043 41.842365 48.531399 41.7672 48.471401 41.723598 
  48.3997 41.589199 48.2314 41.502499 48.074402 41.4678 
  48.0228 41.3619 47.962502 41.359402 47.953899 41.324402 
  47.908298 41.290798 47.919998 41.226398 47.766899 41.196098 
  47.659698 41.2356 47.571701 41.211102 47.5219 41.2542 
  47.371101 41.2719 47.285599 41.312199 47.2658 41.3311 
  47.2589 41.424702 47.212799 41.488602 47.178101 41.510601 
  47.160599 41.5611 47.1278 41.578098 47.043098 41.5583 
  47.015598 41.627201 46.932499 41.691399 46.925598 41.7178 
  46.872799 41.728901 46.770802 41.7967 46.760799 41.863899 
  46.725601 41.835602 46.591702 41.792198 46.5667 41.8078 
  46.568298 41.8825 46.452087 41.896572) 
#(43.47324 41.106213 43.561699 41.136398 43.7822 41.115799 
  43.862499 41.162201 43.9856 41.163101 44.07 41.1917 
  44.157501 41.188301 44.178299 41.1992 44.192799 41.236401 
  44.301899 41.195 44.365601 41.2197 44.4608 41.186401 
  44.529202 41.214199 44.554199 41.186401 44.577499 41.186401 
  44.634399 41.231701 44.711399 41.212799 44.863602 41.214699 
  44.8778 41.2286 44.821899 41.261902 44.8339 41.2869 
  44.955299 41.2617 45.022499 41.298599) 
#(43.47324 41.106213 43.473042 41.14304 43.375259 41.202209 
  43.23304 41.178322 43.199421 41.25526 43.1236 41.25526 
  43.20776 41.306931 43.160809 41.312759 42.888599 41.508041 
  42.84721 41.473042 42.786381 41.510269 42.831928 41.583321 
  42.726372 41.591091 42.588039 41.576382 42.506649 41.441929 
  42.366928 41.46027 41.95499 41.51638 41.833321 41.428322 
  41.5312 41.523479) #(20.589647 41.884552 20.51416 41.72776 
  20.555269 41.584709 20.46249 41.5536 20.56221 41.40387 
  20.49332 41.32748 20.59749 41.094151 20.644911 41.090149) 
#(46.452087 41.896572 46.420601 41.837799 46.331902 41.759201 
  46.218899 41.757198 46.198101 41.724998 46.201698 41.659401 
  46.237202 41.595001 46.256699 41.589401 46.264999 41.6119 
  46.282799 41.615299 46.2864 41.589199 46.3242 41.593601 
  46.347198 41.570801 46.343601 41.557499 46.299198 41.550301 
  46.3353 41.516899 46.330002 41.485298 46.413601 41.462502 
  46.499199 41.397202 46.5933 41.379398 46.621101 41.365002 
  46.6283 41.34 46.693901 41.312199 46.7108 41.255299 
  46.669998 41.154999 46.622501 41.100601 46.572201 41.108101 
  46.5453 41.095299 46.520802 41.049999 46.483898 41.055599 
  46.4403 41.096401 46.3783 41.104198 46.243301 41.205601 
  46.140301 41.203899 46.031399 41.1703 45.813099 41.226398 
  45.708599 41.290298 45.7197 41.320599 45.770599 41.3433 
  45.5383 41.398602 45.4767 41.4408 45.4011 41.428299 
  45.3367 41.462502 45.2789 41.455601 45.022499 41.298599) 
#(20.644911 41.090149 20.669991 41.088039 20.733879 40.91193 
  20.73975 40.910992) #(22.935949 41.3433 22.80138 41.344151 
  22.765289 41.243839 22.754709 41.214432 22.741171 41.18602 
  22.720551 41.142761 22.653879 41.185261 22.590269 41.11998 
  22.46888 41.121651 22.246941 41.17054 22.1311 41.124981 
  22.06666 41.158321 21.916109 41.095261 21.78027 40.928871 
  21.694441 40.93803 21.672489 40.90192 21.471661 40.910542 
  21.34305 40.871929 21.12001 40.862679) 
#(21.12001 40.862679 20.98325 40.857021) 
#(20.73975 40.910992 20.807501 40.900261 20.858879 40.933319 
  20.983 40.893879 20.98325 40.857021) 
#(26.03331 40.73489 26.12471 40.749989 26.134159 40.781368 
  26.199989 40.828869 26.2036 40.862759 26.327221 40.941929 
  26.320829 41.184711 26.44944 41.285259 26.617769 41.336929 
  26.637211 41.37859 26.593611 41.611099) 
#(43.753529 40.67593 43.735821 40.78249 43.60638 40.988319 
  43.55415 40.998039 43.473591 41.041931 43.47324 41.106213) 
#(125.321 40.648041 125.3293 40.645359) 
#(125.321 40.648041 125.2915 40.639889) 
#(125.3293 40.645359 125.4058 40.620819 125.58 40.784988 
  125.6039 40.755821 125.6844 40.769981 125.6472 40.810539 
  125.698 40.85915 125.9 40.896931 126.0416 40.937759 
  126.0755 40.997478 126.4561 41.357208 126.5272 41.357491 
  126.5008 41.431931 126.5538 41.496929 126.5714 41.620258 
  126.6769 41.66943 126.6969 41.714989 126.7103 41.74054 
  126.7869 41.692211 126.9283 41.796379 127.0452 41.72443 
  127.0452 41.651371 127.1786 41.58749 127.1061 41.545269 
  127.1089 41.532761 127.2108 41.521931 127.2875 41.471088 
  127.4727 41.472759 127.5572 41.42971 127.7094 41.413311 
  127.9369 41.44693 128.0441 41.389431 128.16051 41.386101 
  128.2822 41.53027 128.2972 41.59304 128.1505 41.720821 
  128.06081 41.910542 128.05881 42.003319 128.28239 42.03915 
  128.4225 42.028591 128.4538 42.00388 128.63049 42.02998 
  128.9258 42.024429 128.96271 42.084431 129.1144 42.139431 
  129.2133 42.223042 129.1758 42.234989 129.2094 42.286381 
  129.3566 42.446651 129.54691 42.364429 129.5705 42.405819 
  129.70129 42.43832 129.7291 42.478031 129.74271 42.64082 
  129.7747 42.646931 129.7511 42.7047 129.86189 42.96582 
  130.0419 42.95776 130.0994 42.980541 130.1358 42.9622 
  130.1008 42.91193 130.25909 42.884159 130.2502 42.70998 
  130.4261 42.574429 130.4649 42.54694 130.4816 42.607208 
  130.51469 42.602211 130.5291 42.523041 130.6039 42.42062) 
#(70.969398 42.2528 70.856903 42.1964 70.7528 42.201099 
  70.6689 42.1017 70.624397 42.019699 70.5392 42.038101 
  70.531097 42.068901 70.488297 42.099998 70.373299 42.064201 
  70.333099 42.039398 70.3022 41.9772 70.225601 41.941399 
  70.140297 41.828098 70.086899 41.808899 70.058098 41.7803 
  70.009201 41.7803 69.930801 41.7117 69.845299 41.706402 
  69.642197 41.673302 69.506699 41.582802 69.4431 41.567799 
  69.403603 41.525299 69.419403 41.474998 69.346397 41.4842 
  69.292503 41.458599 69.247803 41.4706 69.1567 41.4258 
  69.150803 41.401699 69.1231 41.408298 69.056396 41.379398 
  69.080597 41.3508 69.063103 41.216099 68.983902 41.1758 
  68.8983 41.1614 68.868301 41.1092 68.774399 41.077202 
  68.724403 40.978901 68.616699 40.936901 68.6119 40.913101 
  68.593597 40.919998 68.593597 40.873901 68.5681 40.861401 
  68.589699 40.730301 68.632202 40.722198 68.651901 40.6717 
  68.623901 40.636398 68.6483 40.626099 68.631699 40.607498 
  68.608101 40.599701 68.537498 40.625599 68.484398 40.591099 
  68.455299 40.597801 68.233299 40.691399 68.074997 40.801102 
  68.015602 40.8139 68.087799 40.862499 68.135002 40.9356 
  68.144402 40.997799 68.122498 41.02 68.1511 41.0308 
  68.143898 41.051399 68.105598 41.065601 68.082497 41.043598 
  68.059196 41.0536 68.028099 41.043598 67.996902 41.119999 
  67.934402 41.194401 67.861099 41.1628 67.754997 41.192501 
  67.455803 41.153301 67.071404 41.1436 66.875801 41.150002 
  66.720001 41.174999 66.558601 41.7328 66.526398 42.003101 
  66.029198 42.003101 66.036697 42.423302 66.070801 42.424198 
  66.123901 42.996899 65.821899 42.877201 65.526901 43.3172 
  65.268303 43.432499 64.931396 43.737801 64.458099 43.5481 
  63.9972 43.570599 63.211399 43.636398 62.023899 43.486099 
  61.136711 44.22628) #(124.9632 40.453739 125.0427 40.46804 
  125.0094 40.509991 125.0316 40.527901 125.2915 40.639889) 
#(70.969398 42.2528 71.027802 42.296398 71.0672 42.302799 
  71.2761 42.204201 71.259697 42.1703 71.216904 42.1394 
  71.146698 42.131901 70.9869 42.044399 70.871101 42.040001 
  70.853302 42.016399 70.8442 41.925301 70.685303 41.904999 
  70.5261 41.7967 70.470001 41.7131 70.181099 41.577499 
  70.191704 41.525002 70.376701 41.496899 70.4217 41.473099 
  70.474197 41.412201 70.540298 41.421902 70.669403 41.476398 
  70.711899 41.470798 70.792801 41.357498 70.784698 41.243301 
  70.847198 41.256401 70.933098 41.199402 71.054703 41.194698 
  71.107498 41.164398 71.151398 41.1642 71.195602 41.116699 
  71.213303 41.136902 71.202499 41.182201 71.243301 41.1964 
  71.2714 41.175598 71.285301 41.119202 71.311096 41.122501 
  71.349998 41.165798 71.418098 41.118599 71.440002 41.137199 
  71.438103 41.3489 71.550301 41.3008 71.6036 41.319199 
  71.660004 41.428902 71.620598 41.5075 71.646103 41.5564 
  71.691399 41.5564 71.7164 41.522499 71.695 41.4319 
  71.725304 41.455601 71.748299 41.4314 71.763901 41.4617 
  71.887199 41.333302 71.893303 41.194401 71.999397 41.2019 
  72.052803 41.158901 72.121902 41.2019 72.183601 41.192501 
  72.216698 41.060001 72.194504 41.004295 72.319199 41.0322 
  72.351402 41.082802 72.404999 41.0336 72.506104 41.015301 
  72.5075 40.975601 72.566704 40.964699 72.631699 40.8853 
  72.725601 40.869202 72.881897 40.876701 72.899399 40.867802 
  72.895302 40.8228 73.027802 40.878899 73.046898 40.8731 
  73.054703 40.8428 73.145599 40.848598 73.1689 40.832199 
  73.170303 40.8172 73.0961 40.7714 72.916702 40.700001 
  72.804497 40.674702 72.768097 40.57 72.690002 40.583302 
  72.672501 40.532799 72.648598 40.516899 72.597198 40.5186 
  72.522499 40.557201 72.473602 40.5578 72.384399 40.615002 
  72.3694 40.598598 72.395798 40.560001 72.381104 40.521099 
  72.453003 40.464401 72.423599 40.388901 72.295601 40.431099 
  72.240601 40.426399 72.237503 40.439701 72.276398 40.445801 
  72.282501 40.462502 72.173599 40.4603 72.110298 40.430801 
  72.098297 40.372501 71.974403 40.318298 71.980301 40.2925 
  72.0494 40.263302 72.041901 40.246899 71.983101 40.2528 
  71.957199 40.238899 71.863297 40.264198 71.797203 40.183899 
  71.710602 40.145802 71.6875 40.1689 71.688103 40.220798 
  71.665604 40.261101 71.634697 40.255299 71.621696 40.206402 
  71.562798 40.2061 71.490303 40.2328 71.464401 40.275299 
  71.421097 40.2728 71.389999 40.301899 71.308899 40.303299 
  71.273598 40.331902 71.217201 40.269199 71.064201 40.2775 
  70.999199 40.270302 70.982162 40.244663) 
#(124.3723 40.094311 124.5922 40.261379 124.8914 40.475811 
  124.9577 40.45277 124.9632 40.453739) 
#(44.778584 39.70665 44.625259 39.814991 44.540272 39.919979 
  44.28027 40.04665 44.01693 40.008598 43.657761 40.108601 
  43.65276 40.134159 43.721088 40.16721 43.594429 40.33749 
  43.618038 40.395538 43.592758 40.440262 43.753529 40.67593) 
#(20.98325 40.857021 20.96681 40.79118 20.961941 40.771648 
  21.030411 40.69936 21.031469 40.69825 21.051941 40.676651 
  21.053049 40.618591 20.936939 40.464432 20.84222 40.474979 
  20.78722 40.394711 20.66527 40.094151 20.55583 40.06638 
  20.513611 40.081379 20.412769 40.05109 20.394159 39.999149 
  20.31472 39.990261 20.36305 39.90749 20.410549 39.811932 
  20.38138 39.787209 20.29138 39.806648 20.30249 39.77832 
  20.260559 39.667759 20.0123 39.690231) 
#(44.81049 39.642731 44.789989 39.698589 44.778584 39.70665) 
#(44.81049 39.642731 44.794651 39.65065) 
#(80.285477 42.182358 80.276367 42.059711 80.204697 42.029148 
  79.977188 42.034161 79.852188 41.999989 79.801361 41.90276 
  79.570534 41.84026 79.296082 41.78582 78.670807 41.53194 
  78.639969 41.48304 78.531082 41.463871 78.365517 41.366379 
  78.373581 41.275539 78.160248 41.085541 77.505814 40.986099 
  77.021637 41.049992 76.867462 41.011101 76.781921 40.940819 
  76.793579 40.862492 76.647476 40.740261 76.63942 40.608601 
  76.442177 40.399151 76.328033 40.35416 76.289963 40.451382 
  76.269699 40.452209 76.18663 40.375542 76.045242 40.388882 
  75.903847 40.30138 75.689682 40.309151 75.661362 40.398319 
  75.696617 40.444981 75.594421 40.63998 75.563293 40.643879 
  75.277473 40.482479 75.058853 40.447762 74.869133 40.52137 
  74.844704 40.503601 74.811081 40.417488 74.872192 40.36832 
  74.877747 40.324711 74.724136 40.336651 74.483032 40.168049 
  74.322197 40.092758 74.198013 40.11388 73.994423 40.046101 
  73.85025 39.825821 73.841637 39.762489 73.956093 39.597759 
  73.848022 39.474979 73.67244 39.458954) 
#(48.359711 39.384708 48.338871 39.425541 47.976372 39.7197) 
#(48.589043 41.842365 48.788319 41.665821 49.136101 41.27776 
  49.154991 41.151661 49.251381 40.987209 49.537769 40.778599 
  49.513321 40.678051 49.577209 40.625271 49.745819 40.574162 
  49.999149 40.58638 50.07193 40.55249 50.236099 40.490261 
  50.363602 40.355549 50.384991 40.221371 50.30888 40.30777 
  50.21138 40.339432 50.085541 40.340549 49.885269 40.363319 
  49.858051 40.343601 49.56221 40.206379 49.425541 40.048321 
  49.482769 39.983601 49.419991 39.92416 49.444439 39.868599 
  49.412769 39.837769 49.421379 39.701099 49.31332 39.614712 
  49.287491 39.48082 49.413601 39.383881 49.39555 39.350269 
  49.40638 39.283329 49.33884 39.327179) 
#(73.67244 39.458954 73.491402 39.470001 73.369698 39.441898 
  73.360298 39.401402 73.343903 39.394699 73.1539 39.353298 
  73.098602 39.3825 73.028297 39.3517 72.948898 39.366402 
  72.858299 39.362499 72.6642 39.401901 72.593102 39.363899 
  72.538597 39.381901 72.497498 39.3517 72.415802 39.358601 
  72.385803 39.3358 72.342201 39.336399 72.306396 39.257198 
  72.248596 39.191898 72.229698 39.2453 72.1092 39.288101 
  72.1017 39.3414 72.076698 39.374699 71.979202 39.351898 
  71.857201 39.286701 71.773102 39.278099 71.7314 39.337502 
  71.774399 39.391102 71.756699 39.4622 71.605003 39.448601 
  71.542503 39.461102 71.514999 39.498901 71.553101 39.5672 
  71.479698 39.6203 71.444397 39.602501 71.406403 39.6064 
  71.316101 39.564701 71.275299 39.516899 71.203003 39.5336 
  71.097198 39.510601 71.032799 39.4119 70.997803 39.4011 
  70.952499 39.410301 70.921898 39.435299 70.889702 39.401901 
  70.848602 39.411098 70.801102 39.388901 70.747803 39.398602 
  70.720596 39.419201 70.724403 39.4767 70.673897 39.5075 
  70.633904 39.580799 70.548897 39.582199 70.491898 39.608299 
  70.417198 39.5919 70.407204 39.577499 70.356102 39.582199 
  70.269203 39.529202 70.234703 39.5261 70.227501 39.624699 
  70.163101 39.553902 70.052498 39.580002 70.002502 39.533901 
  69.9431 39.558601 69.842796 39.537498 69.772797 39.576401 
  69.708099 39.587799 69.589699 39.578899 69.543602 39.546101 
  69.445801 39.5308 69.384399 39.5592 69.362503 39.534401 
  69.340599 39.516899 69.306099 39.539398 69.311401 39.681702 
  69.249199 39.754398 69.264999 39.860298 69.338303 39.996399 
  69.398102 39.9519 69.425003 39.901901 69.5261 39.9319 
  69.500298 39.968601 69.483902 40.036098 69.540802 40.131401 
  69.572197 40.107201 69.605797 40.1119 70.0242 40.2164 
  70.172798 40.141899 70.286102 40.132801 70.348602 40.083099 
  70.542198 40.046101 70.560303 40.026402 70.5522 40.009399 
  70.4925 39.973598 70.467201 39.936401 70.4981 39.906898 
  70.528297 39.950298 70.603104 39.958302 70.6436 39.989399 
  70.661697 40.0369 70.661102 40.1036 70.775597 40.134998 
  70.819702 40.171398 70.833603 40.159698 70.861397 40.179699 
  70.918098 40.1689 70.974403 40.181099 70.996399 40.215302 
  70.982162 40.244663) #(53.881649 39.003609 53.852489 39.036381 
  53.764709 39.02721 53.731098 39.07777 53.717491 39.23999 
  53.657211 39.200821 53.681931 39.079151 53.639992 39.124439 
  53.57193 39.32526 53.445541 39.31443 53.29332 39.346371 
  53.15221 39.34026 53.16888 39.260269 53.181099 39.209991 
  53.084431 39.401932 53.247211 39.631939 53.311939 39.657768 
  53.217491 39.549709 53.227772 39.51527 53.423599 39.535259 
  53.569988 39.463871 53.58054 39.525539 53.634159 39.488319 
  53.73444 39.52388 53.633041 39.56443 53.654709 39.59499 
  53.615551 39.61721 53.546379 39.672771 53.45776 39.668049 
  53.40694 39.670818 53.422211 39.723598 53.575821 39.966099 
  53.396931 40.001659 53.28054 39.938599 53.1586 39.996101 
  52.990551 39.97221 52.920551 40.011929 52.898319 39.994709 
  53.020821 39.77277 52.737492 40.056381 52.767208 40.160549 
  52.690269 40.271931 52.708599 40.34193 52.86832 40.686939 
  52.826099 40.716099 52.87693 40.826382 52.918598 41.081661 
  52.96582 41.05027 52.958321 41.0061 53.06221 40.877769 
  53.061378 40.833881 53.11166 40.767769 53.18832 40.76276 
  53.256649 40.813881 53.248051 40.759708 53.334148 40.773041 
  53.351101 40.824711 53.384159 40.826382 53.379711 40.7761 
  53.473598 40.72887 53.55777 40.77055 53.55666 40.84832 
  53.596661 40.894428 53.657211 40.857208 53.708599 40.634991 
  53.75304 40.6161 53.9361 40.667488 54.031101 40.653881 
  54.095268 40.690819 54.05999 40.713039 54.236931 40.725819 
  54.223598 40.67971 54.397491 40.669159 54.426929 40.719151 
  54.311649 40.71999 54.268318 40.85194 54.31749 40.926659 
  54.474709 40.856659 54.440269 40.814159 54.486931 40.799431 
  54.711102 40.878319 54.759991 40.97332 54.675819 41.06805 
  54.766102 41.038601 54.594151 41.188881 54.064709 41.488602 
  53.98888 41.803322 53.896381 41.899712 53.91666 42.001659 
  53.89249 42.07526 53.803879 42.123878 53.630821 42.14082 
  53.278049 42.070541 53.150829 42.095539 53.07888 42.063599 
  52.7761 41.719711 52.77277 41.65971 52.879162 41.698879 
  52.915539 41.65971 52.823318 41.407211 52.821381 41.34444 
  52.911098 41.108879 52.88332 41.07304 52.84721 41.074429 
  52.786381 41.333599 52.55666 41.515541 52.588329 41.587769 
  52.583321 41.65332 52.443321 41.744499) 
#(48.359711 39.384708 48.150261 39.309151 48.11998 39.263599 
  48.134991 39.208881 48.29388 39.112492 48.323879 39.026371 
  48.276089 38.981651) #(47.976372 39.7197 47.806648 39.677212 
  47.746929 39.62109 47.45443 39.49638 47.355259 39.437481 
  47.099709 39.304428 47.025539 39.189419 46.838322 39.155258 
  46.539925 38.87672) #(45.022499 41.298599 45.060299 41.2453 
  45.052799 41.2033 45.1478 41.201099 45.222801 41.141899 
  45.194698 41.116901 45.081402 41.1161 45.073299 41.101101 
  45.0914 41.062801 45.132801 41.056702 45.138599 41.082802 
  45.156898 41.085602 45.2328 41.021702 45.345001 41.000599 
  45.4389 41.022499 45.437199 40.956902 45.487801 40.946701 
  45.566101 40.8778 45.618099 40.871899 45.6208 40.843899 
  45.5942 40.7878 45.429199 40.729198 45.388302 40.671101 
  45.391102 40.643299 45.420601 40.599998 45.459202 40.5811 
  45.4692 40.538101 45.506901 40.512501 45.540298 40.4533 
  45.6628 40.375801 45.8414 40.303299 45.875801 40.269699 
  45.9133 40.264702 45.958302 40.272202 46.0028 40.220299 
  45.976898 40.116901 45.9244 40.092499 45.905602 40.020599 
  45.6381 40.021702 45.603901 40.007801 45.5928 39.982498 
  45.784199 39.9375 45.816399 39.865601 45.856701 39.823601 
  45.926399 39.788101 46.0061 39.773102 46.067799 39.6894 
  46.153599 39.657799 46.204201 39.598099 46.250301 39.595001 
  46.349998 39.628101 46.413898 39.5839 46.513302 39.583599 
  46.541401 39.5644 46.546398 39.538601 46.509701 39.513302 
  46.516701 39.4758 46.400799 39.450802 46.3806 39.424999 
  46.4039 39.378601 46.518101 39.330299 46.544201 39.2789 
  46.622501 39.224701 46.545601 39.1894 46.452202 39.218601 
  46.4161 39.201401 46.423901 39.163898 46.493599 39.128601 
  46.510799 39.096901 46.523602 39.044201 46.494701 38.959702 
  46.539925 38.87672) #(46.539925 38.87672 46.5336 38.870819 
  46.35471 38.910542 46.177959 38.844219) 
#(46.177959 38.844219 46.107201 38.9361 46.042801 39.0783 
  45.970299 39.166401 45.971901 39.206699 46.0089 39.250801 
  45.9781 39.279999 45.885799 39.319401 45.855598 39.348099 
  45.795601 39.3564 45.7761 39.374699 45.830002 39.449402 
  45.814701 39.494999 45.823101 39.5453 45.783298 39.569199 
  45.732201 39.580601 45.626701 39.560001 45.4575 39.493599 
  45.4086 39.529999 45.326099 39.5383 45.307499 39.5881 
  45.281898 39.608601 45.253899 39.6078 45.204399 39.572201 
  45.171101 39.579201 45.1758 39.672501 45.061901 39.7789 
  44.933102 39.721401 44.858299 39.724998 44.778584 39.70665) 
#(46.177959 38.844219 46.16666 38.839981 45.871929 38.879978 
  45.430538 39.004711 45.337761 39.172489 45.187481 39.21027 
  45.115822 39.312199 44.95026 39.43581 44.888599 39.60582 
  44.81049 39.642731) #(73.67244 39.458954 73.671631 39.458881 
  73.654694 39.43803 73.623863 39.220539 73.851357 38.976089 
  73.844131 38.945259 73.723297 38.912479 73.705254 38.864151 
  73.795212 38.661221) #(48.8605 38.44025 48.832211 38.86499 
  48.90554 38.896648 48.935551 38.9636 48.930271 39.058601 
  48.96138 39.174431 49.002769 39.18943 49.05249 39.172771 
  49.067211 39.107769 49.134708 39.103321 49.14999 39.081661 
  49.123051 39.0261 49.051659 39.001381 49.072208 38.963871 
  49.140541 38.977211 49.201931 39.024712 49.258041 39.319439 
  49.297211 39.343319 49.33884 39.327179) 
#(48.8605 38.44025 48.665531 38.390541 48.610538 38.405819 
  48.429989 38.626091 48.333599 38.601101 48.243599 38.66721 
  48.24387 38.72776 48.103039 38.7836 48.013882 38.85693 
  48.018879 38.909149 48.276089 38.981651) 
#(55.296101 38.001659 54.83305 37.74638 54.80582 37.561649 
  54.69165 37.46748) #(55.998451 41.325474 56.666901 41.288101 
  56.827499 41.2994 57.049999 41.262798 57.092201 41.321899 
  57.188301 41.371101 57.095798 41.401402 57.042801 41.4669 
  57.035801 41.575001 56.976101 41.6647 56.994701 41.749699 
  56.969398 41.8433 56.978298 41.884998 57.119701 41.9417 
  57.2458 42.095299 57.386902 42.162498 57.4739 42.175301 
  57.664398 42.153599 57.752201 42.1842 57.869202 42.190601 
  57.875 42.206402 57.847801 42.237801 57.904701 42.260601 
  57.9636 42.367199 57.923901 42.441898 57.970001 42.450001 
  58.0336 42.505299 58.1017 42.503899 58.146702 42.4622 
  58.225601 42.476101 58.3381 42.441399 58.4114 42.3894 
  58.4119 42.2967 58.510601 42.301102 58.514198 42.3181 
  58.446899 42.3778 58.314999 42.548302 58.1642 42.601101 
  58.143101 42.630798 58.164398 42.651901 58.2939 42.697498 
  58.422501 42.660801 58.562801 42.662498 58.597801 42.784199 
  58.6175 42.797501 58.801899 42.6394 58.951698 42.540798 
  59.047199 42.523899 59.1558 42.5411 59.258598 42.451698 
  59.263901 42.3722 59.284698 42.347801 59.371399 42.3381 
  59.457199 42.292801 59.735802 42.322498 59.843899 42.314999 
  59.9161 42.297798 59.956699 42.243301 60.0644 42.188301 
  59.992199 42.131901 60.0247 42.014999 59.937199 41.994701 
  59.925598 41.980301 59.9342 41.9622 60.122799 41.9217 
  60.177799 41.862202 60.2561 41.8228 60.275002 41.797798 
  60.256901 41.772499 60.122501 41.805 60.069698 41.757801 
  60.080299 41.724201 60.186401 41.594398 60.0994 41.537498 
  60.0769 41.442501 60.091099 41.410301 60.3386 41.308601 
  60.4883 41.219398 60.705002 41.258099 60.811901 41.257801 
  60.955799 41.2486 61.001701 41.208302 61.0331 41.2458 
  61.046902 41.221401 61.0858 41.237202 61.141899 41.231899 
  61.167198 41.198898 61.2733 41.1614 61.355301 41.187199 
  61.385319 41.234257 61.403301 41.292198 61.424702 41.302502 
  61.611401 41.267502 61.893299 41.111698 61.974998 40.999699 
  61.9958 40.849201 62.0425 40.723598 62.097198 40.6539 
  62.1231 40.584202 62.201401 40.486099 62.275002 40.4692 
  62.355301 40.4203 62.353298 40.372501 62.393902 40.3242 
  62.4067 40.229198 62.4408 40.183899 62.418098 40.104698 
  62.441101 40.031101 62.5844 39.909698 62.819401 39.784401 
  63.038601 39.644402 63.526402 39.3936 63.712799 39.2061 
  64.173897 38.955002 64.214699 38.953602 64.340302 38.9911 
  64.4972 38.854198 64.665298 38.741901 64.987198 38.626701 
  65.292198 38.410801 65.597198 38.253899 65.748596 38.226398 
  65.840302 38.273602 65.895302 38.2808 65.989998 38.242802 
  66.071701 38.236099 66.162804 38.173901 66.253601 38.154999 
  66.319397 38.084702 66.423897 38.043598 66.555603 38.0383 
  66.643898 38.003101 66.670303 37.973301 66.666397 37.936699 
  66.5578 37.823898 66.5383 37.7728 66.547798 37.663898 
  66.516899 37.521702 66.571701 37.468601 66.516701 37.404701 
  66.538765 37.360512) #(53.881649 39.003609 53.965549 38.939159 
  53.979431 38.89777 53.854431 38.66637 53.824429 38.521381 
  53.83971 38.436939 53.80582 37.95388 53.896648 37.397491 
  53.90942 37.351521) #(54.69165 37.46748 54.551651 37.446091 
  54.231651 37.327209 53.90942 37.351521) 
#(65.627296 37.333199 65.646927 37.458881 65.70137 37.53693 
  65.766083 37.534161 65.785522 37.568878 66.30275 37.323601 
  66.538765 37.360512) #(73.795212 38.661221 73.847198 38.588039 
  73.974136 38.5336 74.083038 38.547489 74.074417 38.609989 
  74.354691 38.674431 74.553017 38.60054 74.856628 38.470539 
  74.862747 38.384159 74.794418 38.306091 74.820534 38.0686 
  74.913589 38.017761 74.920517 37.938869 74.902763 37.84721 
  74.99025 37.778591 74.902763 37.647209 74.949402 37.563042 
  75.187469 37.406651 75.111076 37.383598 75.096626 37.32193 
  74.898827 37.240299) #(70.982162 40.244663 70.870598 40.242802 
  70.716103 40.203899 70.625801 40.2103 70.589401 40.255299 
  70.558098 40.342499 70.5158 40.360298 70.456703 40.351101 
  70.375 40.376701 70.378304 40.402199 70.346397 40.429699 
  70.3508 40.4617 70.485001 40.506699 70.514999 40.549702 
  70.579697 40.574699 70.795456 40.72551 70.776703 40.7556 
  70.6922 40.772202 70.649399 40.786098 70.645798 40.822498 
  70.667198 40.827499 70.701103 40.7981 70.728897 40.800598 
  70.728104 40.8139 70.544197 40.981098 70.471901 41.037201 
  70.430496 41.050301 70.381699 41.027802 70.374702 40.958302 
  70.316704 40.894199 70.2481 40.855801 70.1222 40.826698 
  70.050301 40.77 69.823097 40.715599 69.732498 40.638599 
  69.680298 40.646702 69.534401 40.7822 69.489197 40.785599 
  69.459198 40.8111 69.400299 40.800301 69.3517 40.768902 
  69.334999 40.738098 69.332199 40.6022 69.251404 40.589699 
  69.210602 40.558899 69.259697 40.5028 69.339203 40.327801 
  69.307503 40.2864 69.239998 40.311699 69.231697 40.2817 
  69.321404 40.211899 69.235298 40.189701 69.097801 40.2244 
  69.032204 40.238602 68.876099 40.218601 68.8358 40.194698 
  68.768303 40.208099 68.64444 40.183277 68.6008 40.178299 
  68.601402 40.1628 68.705803 40.116901 68.863602 40.141701 
  68.987198 40.1492 69.009399 40.101101 68.997498 40.07 
  68.900597 40.077499 68.8386 40.040798 68.808601 40.083099 
  68.785301 40.070599 68.808296 40.043301 68.8153 39.9939 
  68.909203 39.891399 68.853302 39.874199 68.805801 39.971699 
  68.775299 39.9869 68.815598 39.900299 68.8125 39.8783 
  68.774399 39.8619 68.779404 39.838902 68.760803 39.827499 
  68.722198 39.871399 68.673897 39.849998 68.639702 39.855801 
  68.629997 39.656101 68.592499 39.613602 68.536697 39.5872 
  68.540298 39.554699 68.473297 39.537498 68.353302 39.536701 
  68.082497 39.5672 67.827499 39.621399 67.709702 39.625801 
  67.604698 39.566399 67.509697 39.554699 67.513603 39.495602 
  67.442497 39.4856 67.410599 39.299198 67.366699 39.294201 
  67.3675 39.2253 67.381897 39.209702 67.517799 39.167801 
  67.6175 39.171902 67.6539 39.139999 67.694702 39.134701 
  67.687202 39.0494 67.709396 38.9967 67.863297 38.9767 
  67.968903 39.0089 68.036903 38.9842 68.113297 38.997501 
  68.183899 38.900799 68.196404 38.854401 68.154999 38.808601 
  68.083099 38.794399 68.1008 38.739201 68.0578 38.696899 
  68.080597 38.6092 68.071899 38.541401 68.111099 38.498299 
  68.127197 38.4244 68.169403 38.395 68.215599 38.332199 
  68.331398 38.2733 68.384201 38.195599 68.368599 38.112202 
  68.296402 38.018101 68.273903 37.954399 68.150597 37.928101 
  68.073097 37.765301 67.917198 37.617199 67.8564 37.535301 
  67.817497 37.446098 67.843903 37.330601 67.838097 37.261902 
  67.777153 37.185799) #(66.538765 37.360512 66.586906 37.368038 
  66.665253 37.338322 66.744423 37.36137 67.021637 37.377201 
  67.200256 37.246651 67.229424 37.191929 67.266373 37.185261 
  67.424408 37.234989 67.521637 37.27248 67.557457 37.215542 
  67.649406 37.24609 67.774139 37.206089 67.777153 37.185799) 
#(44.794651 39.65065 44.60582 39.78054 44.471088 39.698872 
  44.416088 39.425259 44.307758 39.386929 44.070271 39.411652 
  44.034161 39.379711 44.080818 39.306931 44.216648 39.12915 
  44.15942 39.002209 44.210819 38.891102 44.2911 38.859711 
  44.304989 38.81554 44.260818 38.721649 44.317211 38.613041 
  44.3036 38.430538 44.32526 38.37804 44.440819 38.393318 
  44.47776 38.32304 44.22221 37.906368 44.245541 37.883869 
  44.34499 37.88026 44.419151 37.81776 44.53804 37.78054 
  44.61887 37.716091 44.558041 37.648041 44.592758 37.436932 
  44.801651 37.321659 44.82193 37.271099 44.773319 37.227482 
  44.79443 37.163872) #(44.79443 37.163872 44.786671 37.148151) 
#(42.366089 37.11018 42.345261 37.23859 42.24971 37.27887 
  42.20787 37.322182) #(74.567749 37.02647 74.400528 37.139149 
  74.392197 37.175259 74.537193 37.243038 74.651077 37.234711 
  74.669418 37.266102 74.763313 37.30109 74.816933 37.219151 
  74.898827 37.240299) #(44.786671 37.148151 44.638039 37.187481 
  44.529148 37.120258 44.351101 37.048321 44.317211 36.970539 
  44.25526 36.986649 44.197762 37.111099 44.267761 37.167488 
  44.261662 37.241928 44.231091 37.276371 44.116379 37.31638 
  44.00388 37.314991 43.903591 37.221649 43.623039 37.22998 
  43.345821 37.331928 43.30637 37.309978 43.144428 37.37804 
  42.950539 37.322491 42.786098 37.38443 42.72665 37.355549 
  42.601101 37.186649 42.366089 37.11018) 
#(39.439232 36.698841 39.809978 36.751381 40.048321 36.835541 
  40.400261 36.990261 40.775539 37.11832 41.141102 37.094429 
  41.400539 37.076931 41.84026 37.129978 42.063599 37.196651 
  42.20787 37.322182) #(67.777153 37.185799 67.791641 37.088322 
  67.885529 37.061371 67.910522 37.014431 68.035522 36.924709 
  68.28331 37.019981 68.278313 37.086929 68.301643 37.111099 
  68.413017 37.104431 68.412193 37.148041 68.524979 37.16193 
  68.654694 37.246929 68.825813 37.247761 68.809402 37.322491 
  68.85025 37.324711 68.904968 37.272209 68.924408 37.28471 
  68.891647 37.31749 68.999687 37.307758 69.246628 37.094151 
  69.333038 37.124981 69.45137 37.22998 69.381348 37.344151 
  69.382736 37.455818 69.515808 37.580818 69.91803 37.611931 
  69.958588 37.564991 70.134979 37.529148 70.255539 37.62109 
  70.276917 37.741371 70.165527 37.872211 70.170242 37.94165 
  70.203857 37.92054 70.378304 38.057758 70.491913 38.16721 
  70.584412 38.278591 70.596359 38.334148 70.685516 38.375259 
  70.672203 38.414429 70.880524 38.453041 71.101913 38.40609 
  71.363022 38.248871 71.363861 38.18803 71.284698 38.019981 
  71.264137 37.918049 71.37468 37.905819 71.546356 37.942478 
  71.591919 37.903042 71.588577 37.81609 71.528847 37.764431 
  71.49025 37.284161 71.446907 37.20776 71.43219 37.05859 
  71.568314 36.741371 71.695236 36.672211 71.842743 36.692478 
  72.011368 36.812199 72.346626 36.989979 72.663589 37.026089 
  72.798859 37.22998 73.08136 37.320541 73.150528 37.400822 
  73.314407 37.463322 73.776642 37.434429 73.752762 37.331379 
  73.649406 37.304428 73.619957 37.26276 73.634407 37.239979 
  73.792473 37.22942 74.363861 37.4286 74.400803 37.399429 
  74.699692 37.39193 74.898827 37.240299) 
#(61.1572 36.64999 60.364712 36.645538 60.02943 37.03693 
  59.774429 37.131649 59.620258 37.131931 59.566929 37.208881 
  59.519711 37.196091 59.389709 37.33305 59.37109 37.50388 
  59.322762 37.54137 59.249989 37.513321 59.17165 37.563042 
  58.92609 37.669979 58.778591 37.66193 58.54443 37.703602 
  58.498039 37.64777 58.451649 37.641369 58.223869 37.684711 
  58.19804 37.786381 58.124432 37.799992 57.77832 37.907761 
  57.50526 37.929989 57.34832 37.998871 57.37109 38.09304 
  57.239151 38.273869 57.17609 38.28027 57.050819 38.1936 
  56.857208 38.231369 56.756378 38.284988 56.695259 38.26693 
  56.538879 38.266102 56.38554 38.231369 56.318878 38.173321 
  56.352772 38.132759 56.326649 38.084148 55.982761 38.072491 
  55.798599 38.122478 55.44276 38.086102 55.296101 38.001659) 
#(36.660259 36.833599 36.95554 36.771099 37.043049 36.714432 
  37.024429 36.658039 37.076931 36.621651 37.12748 36.659149 
  37.442478 36.63998 37.50555 36.65971 37.8186 36.760818 
  38.181099 36.905819 38.39082 36.896648 38.726372 36.702209 
  38.860538 36.697762 39.205818 36.665531 39.439232 36.698841) 
#(53.90942 37.351521 54.01582 37.021931 53.988319 36.982208 
  54.031651 36.948318 54.019161 36.8186 53.894711 36.793598 
  53.668598 36.82082 53.63443 36.853321 54.002209 36.904991 
  54.008598 36.948318 53.949162 36.914711 53.244709 36.850269 
  52.615551 36.709148 51.972759 36.57999 51.798599 36.60194 
  51.08749 36.732491 50.740822 36.900829 50.315269 37.153049 
  50.202209 37.383881 50.077492 37.411652 49.47887 37.483601 
  49.274712 37.545818 49.06971 37.67165 49.001099 37.75943 
  48.87138 38.288879 48.8605 38.44025) 
#(36.382511 36.222858 36.440819 36.206379 36.493599 36.230808 
  36.554989 36.223042 36.692211 36.239151 36.690262 36.286381 
  36.618591 36.357491 36.580818 36.400539 36.5536 36.4986 
  36.660259 36.833599) #(36.382511 36.222858 36.37389 36.01321) 
#(35.923241 35.926769 36.005821 35.930538 36.0172 35.878319 
  36.17416 35.821659 36.219151 35.96027 36.37389 36.01321) 
#(61.1572 36.64999 61.189701 36.561371 61.14249 36.392761 
  61.169979 36.302212 61.226089 36.115261 61.125259 35.970821 
  61.244991 35.897209 61.231091 35.667488 61.278721 35.60675) 
#(77.831413 35.480751 77.70108 35.461102 77.521088 35.48415 
  76.919968 35.595539 76.588303 35.760818 76.584702 35.89193 
  76.564133 35.912762 76.525803 35.8736 76.222198 35.81332 
  76.157753 35.828041 76.127457 35.972759 76.09053 36.000542 
  76.007751 36.001659 75.95137 36.031368 75.919968 36.119148 
  76.004433 36.177479 76.004967 36.458599 75.898857 36.62859 
  75.723862 36.74276 75.554138 36.770821 75.472748 36.72554 
  75.431084 36.747761 75.392471 36.917488 75.131348 37.001381 
  74.92775 36.966091 74.895248 36.911652 74.838867 37.011101 
  74.690804 37.062759 74.567749 37.02647) 
#(65.627296 37.333199 65.530807 37.2486 65.072746 37.244431 
  64.798019 37.124981 64.779137 37.095821 64.795242 36.923038 
  64.61525 36.629429 64.627747 36.45998 64.570534 36.35638 
  64.458862 36.247211 64.32164 36.216381 64.282471 36.15192 
  64.169418 36.167488 64.059692 36.088039 64.063858 36.000271 
  63.933868 36.03915 63.595539 35.9622 63.538879 35.90971 
  63.317211 35.852211 63.119431 35.861931 63.10416 35.825821 
  63.23888 35.69553 63.095261 35.626091 63.110538 35.481369 
  62.62331 35.224979 62.459431 35.286381 62.305538 35.145538 
  62.259159 35.297771 62.100819 35.394711 61.97221 35.45998 
  61.802479 35.411091 61.576649 35.450821 61.464989 35.52721 
  61.365822 35.639709 61.278721 35.60675) 
#(77.831413 35.480751 77.755463 35.404812 77.527634 35.312248 
  77.238098 35.217319 77.041122 35.093929) 
#(44.786671 37.148151 44.76804 37.105259 44.90971 37.023869 
  44.906651 36.888321 44.841648 36.81971 44.867199 36.785259 
  45.01693 36.749989 45.066662 36.67387 45.014709 36.535259 
  45.121368 36.41193 45.25082 36.420269 45.369148 36.080269 
  45.33498 36.004429 45.384708 35.98193 45.50555 36.020538 
  45.634991 35.965542 45.74332 35.828041 45.785259 35.814991 
  46.34026 35.82555 46.348869 35.799992 46.3186 35.769711 
  46.13443 35.697201 46.01915 35.675541 46.02026 35.576099 
  45.97998 35.584709 45.99221 35.481091 46.148041 35.301651 
  46.119148 35.244431 46.193039 35.211102 46.155258 35.099152 
  46.03249 35.057758 45.941929 35.095539 45.921371 35.078602 
  45.870258 34.90971) #(61.278721 35.60675 61.27776 35.52026 
  61.239151 35.481091 61.1861 35.29694 61.104431 35.279148 
  61.11388 35.201649 61.065262 34.812759) 
#(45.870258 34.90971 45.77248 34.914429 45.766102 34.845821 
  45.691929 34.819149 45.651089 34.726929 45.708321 34.659149 
  45.71471 34.557209 45.531929 34.60054 45.513321 34.581661 
  45.522758 34.497761 45.435539 34.448589 45.487759 34.335819 
  45.551929 34.344151 45.584709 34.302479 45.56749 34.2197 
  45.405819 33.971088 45.550259 33.888599 45.75193 33.588871 
  45.905491 33.63319) #(77.831413 35.480751 77.940247 35.501659 
  77.972473 35.574162 78.136917 35.54332 78.20192 35.639149 
  78.569977 35.79137 78.700531 35.881931 78.809402 35.925819 
  78.934402 35.89249 79.343307 35.986099 79.432739 35.963322 
  79.457199 35.928871 79.440247 35.878868 79.473862 35.854988 
  79.586906 35.86776 79.665802 35.801651 79.634407 35.759159 
  79.693573 35.650822 79.866913 35.568321 79.919128 35.617489 
  79.964142 35.595821 80.021912 35.437481 80.070534 35.40609 
  80.136093 35.44582 80.201637 35.55888 80.238022 35.557758 
  80.297737 35.503319 80.349411 35.522758 80.387192 35.506378 
  80.386642 35.425259 80.283859 35.32526 80.292191 35.1936 
  80.190804 35.086929 80.201637 34.893879 80.088303 34.736099 
  80.045242 34.658871 79.887482 34.662762 79.843857 34.574429 
  79.761642 34.552761 79.722748 34.519711 79.760529 34.46859 
  79.75415 34.44276 79.683578 34.411652 79.545517 34.432758 
  79.531647 34.410542 79.572197 34.199421 79.511642 34.190262 
  79.522202 34.11388 79.4133 34.01693 79.027191 34.015541 
  78.908859 33.970261 78.907471 33.936649 79.019417 33.754429 
  79.031357 33.626091 78.91803 33.633598 78.910797 33.60804 
  78.937408 33.408649) #(74.332977 32.81525 74.363861 32.869431 
  74.334137 33.000549 74.0383 33.164429 74.011917 33.210541 
  74.024139 33.276371 74.125793 33.343319 74.182457 33.51054 
  74.162483 33.553879 74.014687 33.638882 73.98497 33.687771 
  73.99469 33.75555 74.055801 33.834431 74.169968 33.84832 
  74.257477 33.901089 74.294693 33.964432 74.244423 34.01915 
  73.955811 34.021099 73.907753 34.089981 73.926361 34.132198 
  74.014137 34.175541 74.021088 34.208321 73.968307 34.306091 
  73.854691 34.315819 73.806084 34.353321 73.799133 34.398602 
  73.946083 34.593601 73.957748 34.661369 74.247467 34.754711 
  74.389137 34.781929 74.679413 34.696369 75.200531 34.624149 
  75.399979 34.55304 75.805527 34.50721 75.937469 34.60804 
  76.046631 34.629429 76.160522 34.58527 76.229141 34.609428 
  76.293579 34.70026 76.470253 34.769981 76.738571 34.73859 
  76.801361 34.672211 76.869957 34.658871 76.916924 34.68137 
  76.964142 34.94054 77.023857 34.982479 77.065247 35.039989 
  77.041122 35.093929) #(74.713303 32.838871 74.666924 32.836109 
  74.646362 32.78054 74.598587 32.758881 74.359703 32.775822 
  74.332977 32.81525) #(79.527161 32.74992 79.463593 32.80304 
  79.46109 32.858879 79.418297 32.905819 79.354141 32.983318 
  79.406357 33.161659 79.364693 33.189701 79.103577 33.219711 
  79.079422 33.287209 78.992188 33.3186 78.937408 33.408649) 
#(75.357529 32.305038 75.037483 32.48027 74.744423 32.465 
  74.687469 32.501099 74.65358 32.593319 74.713303 32.838871) 
#(75.327759 32.172489 75.382187 32.275551 75.357529 32.305038) 
#(68.221626 31.81559 68.53775 31.72666 68.57164 31.76527 
  68.447739 31.77277 68.444122 31.79472 68.54747 31.829161 
  68.712479 31.778879 68.731918 31.69944 68.833038 31.60388 
  69.029694 31.64555 69.333862 31.94389 69.287483 32.069149 
  69.283043 32.21777 69.248016 32.443871 69.287483 32.526379 
  69.397751 32.587761 69.456917 32.682209 69.394974 32.773869 
  69.515259 32.873878 69.492462 33.008598 69.561081 33.081928 
  69.791351 33.126942 69.881073 33.089981 70.033577 33.139431 
  70.067749 33.20499 70.144974 33.202492 70.32692 33.33194 
  70.306084 33.396099 70.197739 33.485821 70.196617 33.64082 
  70.132736 33.735538 69.985519 33.75304 69.907471 33.881931 
  69.902763 34.031101 70.491348 33.943039 70.900528 33.973591 
  70.905533 34.013321 70.981079 34.008881 71.135529 34.166088 
  71.153313 34.36137 71.073029 34.39415 70.978027 34.510818 
  70.995796 34.55859 71.094971 34.56805 71.09581 34.676651 
  71.225517 34.744431 71.313858 34.886929 71.496078 34.959431 
  71.543297 35.0947 71.618027 35.131371 71.659126 35.207489 
  71.553574 35.28915 71.549133 35.32832 71.647202 35.436939 
  71.606918 35.48193 71.613861 35.561932 71.508591 35.626652 
  71.545242 35.711102 71.380524 35.946091 71.291077 35.96859 
  71.188019 36.047211 71.248581 36.133041 71.582748 36.335819 
  71.563019 36.372478 71.646637 36.46804 71.753036 36.40749 
  71.817749 36.41666 71.795807 36.491928 72.074692 36.58942 
  72.073303 36.628868 72.191643 36.6572 72.181641 36.71471 
  72.492462 36.771931 73.113022 36.873871 73.779694 36.901089 
  73.963028 36.837761 74.06218 36.821659 74.158859 36.906651 
  74.251923 36.899429 74.336906 36.958881 74.482193 37.011101 
  74.558006 36.96526 74.567749 37.02647) 
#(74.58844 31.59803 74.516083 31.72472 74.538017 31.81666 
  74.620239 31.871941 74.784698 31.94389 74.814133 32.019711 
  74.962753 32.031929 75.037483 32.098881 75.108017 32.070831 
  75.327759 32.172489) #(67.791924 31.341101 67.799698 31.38249 
  67.766922 31.4111 67.646362 31.40999 67.581093 31.5336 
  67.738022 31.53083 67.887482 31.63999 67.98053 31.63583 
  68.166077 31.83305 68.221626 31.81559) 
#(61.76582 31.24527 61.771099 31.318331 61.7136 31.383329 
  61.619431 31.395821 60.843868 31.498329 60.810261 31.8736 
  60.857769 32.234718 60.74165 32.578869 60.581928 33.071659 
  60.591091 33.16304 60.85165 33.418049 60.858318 33.49387 
  60.9286 33.504429 60.901649 33.554428 60.649151 33.574989 
  60.522758 33.653042 60.50526 33.739151 60.55415 33.81332 
  60.52137 33.999149 60.513599 34.150822 60.67165 34.313599 
  60.911091 34.31638 60.89777 34.345821 60.756649 34.483318 
  60.733601 34.54166 60.863602 34.576389 61.065262 34.812759) 
#(67.256363 31.22249 67.288017 31.2136 67.791924 31.341101) 
#(61.803871 30.94582 61.84721 31.04888 61.76582 31.24527) 
#(45.905491 33.63319 45.948589 33.556648 45.874699 33.49165 
  45.996929 33.495541 46.124699 33.308601 46.198589 33.19109 
  46.11137 33.112759 46.055538 33.121651 46.04916 33.09082 
  46.146381 33.069439 46.144989 33.048038 46.097481 33.00555 
  46.103321 32.971088 46.148041 32.953041 46.2836 32.96666 
  46.42387 32.937481 46.638039 32.819988 46.783039 32.708328 
  47.154701 32.45776 47.362492 32.474701 47.440819 32.38332 
  47.413311 32.341091 47.50304 32.253601 47.5172 32.148319 
  47.864429 31.798599 47.697201 31.40777 47.693871 31.00111 
  48.03693 30.994711 48.033329 30.5536 48.069592 30.46073) 
#(81.027397 30.2047 80.601357 30.476379 80.538857 30.464439 
  80.321907 30.56472 80.203583 30.564989 80.227753 30.621941 
  80.187469 30.675819 80.256363 30.72971 80.235519 30.74749 
  80.084137 30.791941 79.909698 30.91666 79.748863 30.98971 
  79.590263 30.94138 79.24025 31.24416 79.217468 31.34083 
  79.086906 31.439159 79.018593 31.411381 78.998581 31.32555 
  78.94191 31.359989 78.89386 31.298889 78.818314 31.286659 
  78.764687 31.31583 78.782753 31.4575 78.724983 31.48082 
  78.726357 31.53167 78.781647 31.555269 78.84108 31.615829 
  78.742462 31.68499 78.693298 31.785271 78.769417 31.958879 
  78.680527 32.035271 78.544693 32.209431 78.474983 32.236099 
  78.483307 32.300541 78.395813 32.54388 78.420517 32.566101 
  78.59552 32.570541 78.743027 32.639431 78.772202 32.622761 
  78.780258 32.47887 78.923859 32.3661 79.099136 32.376369 
  79.147476 32.484711 79.253593 32.515549 79.306923 32.494431 
  79.37413 32.54694 79.516373 32.676941 79.527161 32.74992) 
#(48.545181 29.94454 48.447762 29.99305 48.379429 30.12944 
  48.40276 30.20277 48.274151 30.329161 48.19804 30.31777 
  48.153591 30.421659 48.069592 30.46073) 
#(60.866871 29.862431 61.25304 30.259991 61.812759 30.843611 
  61.803871 30.94582) #(60.866871 29.862431 60.99387 29.826099 
  61.743599 29.615829 62.484428 29.406099 62.78693 29.43388 
  63.5872 29.50388 64.131348 29.394159 64.193024 29.48749 
  64.273857 29.52389 64.695511 29.58638 65.034126 29.5411 
  65.417473 29.640551 66.256638 29.85194 66.361359 29.966101 
  66.238297 30.071381 66.259697 30.114161 66.35025 30.45055 
  66.281921 30.57527 66.404968 30.94611 66.56636 30.97777 
  66.684128 31.086109 66.723022 31.21221 66.891647 31.296101 
  67.036911 31.318609 67.051643 31.297779 67.034698 31.25444 
  67.069702 31.239161 67.256363 31.22249) 
#(61.547581 28.98494 61.511101 29.0886 61.419979 29.16444 
  61.355259 29.38833 60.866871 29.862431) 
#(97.349548 28.22267 97.298309 28.240271 97.233582 28.31777 
  97.105797 28.38139 96.998863 28.33222 96.779137 28.375549 
  96.740799 28.42638 96.59053 28.467211 96.401917 28.351101 
  96.264687 28.41527 96.368301 28.48583 96.345253 28.55694 
  96.434692 28.593889 96.496628 28.692221 96.616364 28.757771 
  96.611633 28.801109 96.533859 28.896379 96.5047 29.06999 
  96.343857 29.032499 96.250259 28.94083 96.172737 28.899719 
  96.14859 28.943331 96.18219 28.99527 96.122742 29.08305 
  96.353027 29.18305 96.395248 29.25527 96.362473 29.29055 
  96.289413 29.241381 96.231079 29.2575 96.166924 29.369711 
  96.063858 29.465549 95.579147 29.244431 95.54303 29.13472 
  95.496078 29.140829 95.479424 29.076099 95.439133 29.04138 
  95.345253 29.04472 95.223587 29.10055 94.947189 29.158609 
  94.800522 29.16749 94.733582 29.28055 94.631866 29.32753) 
#(88.142357 27.86809 87.853851 27.914721 87.797203 27.837219 
  87.72052 27.804991 87.546082 27.845831 87.393593 27.80916 
  87.404137 27.86055 87.192734 27.82305 87.030258 27.965269 
  86.933029 27.95055 86.87413 28.01778 86.764137 28.026661 
  86.758034 28.080271 86.704147 28.111099 86.571907 28.105829 
  86.534973 27.95499 86.444962 27.908051 86.219704 28.016109 
  86.215263 28.11833 86.183578 28.163879 86.092468 28.078051 
  86.131638 27.926109 86.01442 27.882771 85.973022 27.915819 
  85.978027 27.98971 85.918854 28.033331 85.916367 28.096939 
  85.780807 28.2061 85.705811 28.340549 85.619957 28.25111 
  85.5383 28.28944 85.283859 28.272221 85.103302 28.31638 
  85.101913 28.446659 85.181923 28.530001 85.189957 28.603319 
  85.059967 28.6411 84.939682 28.540001 84.823303 28.551941 
  84.231354 28.92944 84.256088 29.042219 84.199692 29.062771 
  84.176361 29.213881 84.02359 29.27916 83.72052 29.22888 
  83.677193 29.16194 83.602463 29.165831 83.346077 29.49666 
  83.284409 29.47443 83.257477 29.58 83.164978 29.633051 
  83.085251 29.58527 82.992188 29.672501 82.85524 29.66888 
  82.557739 29.94277 82.165802 30.07972 82.100517 30.34222 
  81.615517 30.41971 81.541924 30.330549 81.411362 30.380831 
  81.396362 30.283051 81.356628 30.145281 81.290802 30.13055 
  81.30191 30.083599 81.223587 30.010269 81.109703 30.024719 
  81.027397 30.2047) #(94.631866 29.32753 94.596077 29.28499 
  94.285248 29.144159 94.133591 28.96777 94.034409 28.96999 
  94.049133 28.864441 93.738022 28.696939 93.558006 28.683599 
  93.225517 28.62833 93.169418 28.448879 93.118027 28.371941 
  92.823868 28.178049 92.80246 28.20166 92.680252 28.117769 
  92.662193 28.063049 92.729141 28.036381 92.699402 27.955549 
  92.37941 27.80471 92.358307 27.84444 92.335251 27.79805 
  92.306084 27.79833 92.279137 27.863331 92.256638 27.87138 
  92.25386 27.81583 91.97052 27.72805 91.659554 27.76511) 
#(70.083939 27.73613 70.128021 27.82888 70.375793 28.023331 
  70.51442 28.03916 70.598587 27.98999 70.737747 27.73138 
  70.794418 27.709721 70.894417 27.71221 71.239693 27.8486 
  71.626907 27.876101 71.896927 27.961941 71.91803 28.117491 
  71.992188 28.21583 72.206627 28.402491 72.292191 28.679991 
  72.389687 28.78499 72.948303 29.03583 73.269699 29.561661 
  73.397476 29.94277 73.588577 30.020281 73.798859 30.070551 
  73.971909 30.19499 73.934402 30.314159 73.856079 30.364719 
  73.906631 30.398609 74.216637 30.701099 74.568588 31.064159 
  74.628853 31.02527 74.663017 31.05888 74.67247 31.099159 
  74.537483 31.14222 74.530807 31.194441 74.639137 31.481661 
  74.58844 31.59803) #(91.659554 27.76511 91.666924 27.88888 
  91.65831 27.94805 91.338028 28.05249 91.314972 28.096661 
  91.108856 27.971109 91.015808 27.97777 90.896927 28.05055 
  90.382462 28.07972 90.396088 28.23555 90.366074 28.257771 
  89.996353 28.32333 89.83165 28.24888 89.58609 28.139999 
  89.35997 27.87166 89.225517 27.795 89.125793 27.56749 
  88.971077 27.47361 88.917877 27.321039) 
#(88.917877 27.321039 88.78331 27.438049 88.779694 27.48999 
  88.881348 27.842489 88.827187 28.01638 88.611633 28.11305 
  88.534126 28.02916 88.136093 27.94916 88.120506 27.90472 
  88.142357 27.86809) #(63.254169 27.018641 63.278591 27.121941 
  63.34193 27.12249 63.31776 27.169439 63.19804 27.267771 
  62.919708 27.214991 62.764709 27.27194 62.83971 27.47444 
  62.82193 27.760269 62.757771 28.000271 62.781368 28.266939 
  62.59248 28.233601 62.394711 28.421659 62.039711 28.500549 
  61.651371 28.785271 61.547581 28.98494) 
#(63.254169 27.018641 63.28693 26.8811 63.206379 26.84222 
  63.181099 26.633881 63.14027 26.635269) 
#(62.276669 26.354059 62.273319 26.42944 62.371368 26.54249 
  62.613602 26.57999 62.77248 26.649719 63.14027 26.635269) 
#(62.276669 26.354059 62.135818 26.380831 62.1236 26.318331 
  61.85804 26.234711 61.83276 26.17944 61.769428 25.809719 
  61.686371 25.794991 61.646931 25.30611 61.61097 25.193319) 
#(71.087128 24.686331 71.060516 24.72221 70.868584 25.172489 
  70.791351 25.23805 70.674408 25.416941 70.679688 25.511101 
  70.66275 25.701929 70.618301 25.714991 70.379143 25.67555 
  70.272202 25.71277 70.182457 25.834721 70.08609 25.99333 
  70.173859 26.24444 70.189407 26.51083 70.168297 26.556391 
  70.084976 26.594721 69.800797 26.59416 69.508873 26.750271 
  69.48497 26.811661 69.496628 26.875549 69.583313 27.178329 
  69.656631 27.23888 70.037483 27.6 70.083939 27.73613) 
#(71.087128 24.686331 70.999687 24.64444 70.976913 24.59639 
  71.006088 24.45805 71.105797 24.433331 71.098587 24.40889 
  70.941643 24.36916 70.862747 24.31027 70.885803 24.274441 
  70.784973 24.238319 70.644127 24.243601 70.579697 24.28722 
  70.593307 24.422211 70.545517 24.43194 70.381073 24.367769 
  70.120911 24.308531) #(69.696472 24.19438 69.598587 24.281389 
  69.422203 24.28833 69.228638 24.269939) 
#(69.696472 24.19438 70.027763 24.17277 70.071091 24.19721 
  70.120911 24.308531) #(98.59581 24.078051 98.761368 24.121941 
  98.889397 24.160669) #(98.59581 24.078051 98.220253 24.12582 
  98.040527 24.081671 97.649979 23.85166 97.536362 23.95055 
  97.57692 23.982771 97.749397 24.16361 97.727463 24.224991 
  97.759979 24.2575 97.741638 24.29027 97.664688 24.30611 
  97.665527 24.33778 97.716637 24.35277 97.70137 24.38555 
  97.530533 24.44138 97.568588 24.669439 97.55246 24.74305 
  97.624969 24.789709 97.790527 24.83972 97.797203 24.86305 
  97.736633 24.91888 97.723022 25.082491 97.846359 25.26833 
  97.873016 25.25861 97.906357 25.210831 97.941071 25.214161 
  98.069427 25.31444 98.171356 25.624439 98.326637 25.551661 
  98.385803 25.59638 98.391647 25.65666 98.535248 25.84861 
  98.631912 25.801109 98.665802 25.82638 98.715263 25.89666 
  98.655243 25.95388 98.568039 26.123051 98.602753 26.137489 
  98.664413 26.09833 98.709976 26.13472 98.728302 26.200001 
  98.665802 26.26055 98.77858 26.642771 98.739693 26.864161 
  98.760246 27.06999 98.705811 27.10388 98.733856 27.36305 
  98.699982 27.38833 98.704697 27.582491 98.66803 27.61944 
  98.589691 27.602221 98.551071 27.666941 98.428017 27.68638 
  98.426071 27.632771 98.397476 27.546379 98.346916 27.52833 
  98.309402 27.549999 98.166924 27.8836 98.207199 27.90444 
  98.195801 27.93055 98.130798 27.96916 98.157204 28.12027 
  98.130798 28.160549 98.009697 28.218599 98.01886 28.27833 
  97.898857 28.38138 97.796921 28.349159 97.700813 28.521111 
  97.631348 28.484159 97.574982 28.54694 97.548576 28.539989 
  97.464981 28.2925 97.410522 28.29249 97.349548 28.22267) 
#(68.196091 23.77334 68.290527 23.944441 68.330544 23.914709 
  68.361908 23.973881 68.747192 23.96999 68.745239 24.31638 
  68.757751 24.323601 68.824692 24.332781 68.838028 24.270269 
  68.870506 24.24194 68.886642 24.28944 68.92691 24.32555 
  68.994423 24.257771 69.080261 24.29722 69.189407 24.258051 
  69.228638 24.269939) #(114.4619 22.55916 114.3569 22.608049) 
#(114.3569 22.608049 114.22359 22.549334 114.22119 22.548855) 
#(114.22119 22.548855 114.03224 22.511158) 
#(114.03134 22.510466 114.03224 22.511158) 
#(103.9647 22.4988 103.8566 22.5811 103.6528 22.784) 
#(103.6528 22.784 103.563 22.69805 103.585 22.647209 
  103.5494 22.603319 103.3808 22.78194 103.3269 22.793051 
  103.2755 22.669161 103.18 22.624439 103.163 22.53805 
  103.0694 22.492769 103.0708 22.445271 103.0305 22.435551 
  102.9286 22.48193 102.8677 22.597771 102.6836 22.69083 
  102.5602 22.697491 102.5214 22.764999 102.4694 22.771379 
  102.3816 22.67083 102.415 22.632771 102.2644 22.484159 
  102.2508 22.41305 102.1797 22.428329 102.1405 22.395889) 
#(113.5606 22.210602 113.5589 22.211399 113.5569 22.211901 
  113.5553 22.2125 113.5533 22.2131 113.5514 22.2136 
  113.5494 22.214199 113.5472 22.214399 113.5453 22.214399 
  113.5431 22.214199 113.5411 22.2136 113.5394 22.2131 
  113.5378 22.2122 113.5361 22.2117 113.535 22.2106 
  113.5342 22.2089 113.5333 22.2075 113.5325 22.205799 
  113.5319 22.203899 113.5314 22.2019 113.5317 22.200001 
  113.5317 22.1978 113.5317 22.195601 113.5317 22.1933 
  113.5311 22.191099 113.5306 22.1894 113.53 22.187799 
  113.5297 22.185801 113.5294 22.183901 113.5289 22.1819 
  113.52873 22.181513) #(99.46553 22.13583 99.359413 22.09305 
  99.232468 22.114441 99.1633 22.16527 99.244957 22.317209 
  99.296921 22.40666 99.384697 22.509991 99.328033 22.74472 
  99.387192 22.78027 99.445511 22.949711 99.546631 22.91527 
  99.56636 22.938049 99.508324 23.086941 99.356354 23.134991 
  99.189407 23.102489 99.054962 23.13166 99.058853 23.1675 
  98.881348 23.188049 98.937737 23.31805 98.876907 23.333599 
  98.918579 23.364719 98.914688 23.417219 98.879959 23.483601 
  98.821373 23.48472 98.806633 23.554159 98.885803 23.613331 
  98.834412 23.69194 98.684692 23.81222 98.693024 23.934441 
  98.751648 23.9986 98.907204 24.12027 98.889397 24.160669) 
#(99.968231 22.05047 99.847473 22.02277 99.74913 22.07527 
  99.694122 22.041941 99.684402 22.07638 99.612747 22.09194 
  99.46553 22.13583) #(101.1222 21.76972 100.8903 21.685089) 
#(107.7828 21.667139 107.7039 21.62499 107.4858 21.597771 
  107.4872 21.641661 107.4539 21.658051 107.4028 21.617769 
  107.3633 21.60499 107.3014 21.7311 107.2119 21.711941 
  107.013 21.83499 107.0483 21.91444 107.0228 21.938601 
  106.7466 22.01527 106.6922 21.96582 106.6752 21.985821 
  106.6952 22.05722 106.6536 22.328609 106.578 22.3375 
  106.5614 22.364161 106.6072 22.606939 106.6355 22.615549 
  106.6803 22.572769 106.8216 22.80027 106.6794 22.875549 
  106.6425 22.8561 106.6061 22.90221 106.3369 22.853319 
  106.2516 22.871941 106.2272 22.953039 106.1464 22.98333 
  105.8725 22.910271 105.7619 23.02388 105.5703 23.06444 
  105.5544 23.160271 105.5175 23.18721 105.3233 23.37582 
  105.2405 23.26055 105.0644 23.23027 104.823 23.09972 
  104.8611 22.936661 104.7241 22.814989 104.5913 22.821659 
  104.3622 22.686661 104.2619 22.73777 104.2555 22.83194 
  104.1025 22.792219 104.0352 22.691099 104.0169 22.547211 
  103.9647 22.4988) #(101.1518 21.57086 101.1222 21.76972) 
#(107.9861 21.542641 107.9166 21.588881 107.7828 21.667139) 
#(100.8903 21.685089 100.72 21.509991 100.5602 21.45138 
  100.4588 21.486919) #(100.2132 21.43256 100.3889 21.536381 
  100.4588 21.486919) #(100.2132 21.43256 100.1622 21.468321 
  100.1061 21.58333 100.1489 21.63916 100.1361 21.68527 
  99.986359 21.709431 99.968307 21.768881 99.968231 22.05047) 
#(102.1405 22.395889 102.1058 22.43749 101.9947 22.448601 
  101.8947 22.384159 101.8661 22.39027 101.8233 22.46693 
  101.7689 22.50083 101.6894 22.47027 101.6352 22.305269 
  101.57 22.27916 101.6139 22.028879 101.7847 21.824989 
  101.7525 21.72444 101.8289 21.63055 101.7997 21.58416 
  101.7405 21.31361 101.8511 21.245541 101.7847 21.142771 
  101.7175 21.14805 101.6055 21.182211 101.605 21.234989 
  101.2819 21.180269 101.2344 21.25639 101.2653 21.37611 
  101.1936 21.412769 101.2089 21.558611 101.1518 21.57086) 
#(-33.0 83.124741 -33.334179 83.149406 -33.48307 83.142197 
  -33.0 83.116943) #(-33.0 83.622757 -32.233891 83.611923 
  -32.301392 83.589706 -32.277229 83.568047 -30.215 83.596077 
  -29.254999 83.529137 -29.25556 83.498047 -29.1 83.477478 
  -29.021669 83.507217 -28.543329 83.504967 -28.529169 83.482193 
  -28.920561 83.467758 -28.602501 83.416092 -28.15 83.432747 
  -28.43778 83.459427 -28.293329 83.465271 -27.38195 83.463867 
  -26.1 83.369713 -25.67028 83.298859 -25.67223 83.277496 
  -26.039169 83.20665 -27.13611 83.141098 -29.344721 83.175537 
  -30.461109 83.156372 -30.840839 83.111366 -32.022221 83.052467 
  -33.0 83.124741) #(-33.0 83.116943 -32.882778 83.110809 
  -32.498341 83.057747 -32.684448 83.020554 -33.0 83.00769) 
#(-43.99873 83.199768 -42.88863 83.208862 -42.695011 83.274429 
  -41.976959 83.221359 -41.705841 83.171661 -41.897228 83.093307 
  -41.536129 83.127762 -40.47723 82.963318 -39.480839 82.959976 
  -39.00779 82.897476 -39.01918 82.863586 -38.905849 82.815811 
  -38.670292 82.782204 -38.63612 82.746643 -38.551399 82.750809 
  -38.480839 82.828308 -38.696678 82.821907 -38.776951 82.851089 
  -38.783352 82.897202 -38.827229 82.917763 -39.137508 82.971657 
  -39.118351 82.993317 -38.914459 83.011093 -37.575008 83.022476 
  -38.759178 83.046082 -38.612789 83.08136 -37.416679 83.144699 
  -37.547508 83.15831 -37.577789 83.170258 -38.527241 83.197197 
  -38.860008 83.2547 -38.728352 83.281372 -38.82362 83.344971 
  -38.742512 83.392471 -38.840012 83.409416 -38.79945 83.433296 
  -37.796398 83.359154 -37.752239 83.377762 -38.058899 83.431374 
  -37.920292 83.458038 -37.963348 83.480797 -37.910011 83.491364 
  -37.529171 83.496918 -36.485569 83.362198 -36.41724 83.371094 
  -36.692791 83.412483 -36.498901 83.438309 -36.904171 83.490807 
  -36.751122 83.496094 -36.810009 83.514137 -36.67223 83.536926 
  -36.082512 83.554138 -35.23473 83.534698 -34.68251 83.598862 
  -34.480011 83.542763 -34.440571 83.587479 -34.326679 83.593307 
  -34.282791 83.548859 -33.85918 83.453583 -33.745289 83.485809 
  -34.077511 83.550812 -34.070011 83.570251 -33.900009 83.592484 
  -33.01918 83.623032 -33.0 83.622757) 
#(-33.0 83.00769 -35.29668 82.886368 -35.551399 82.76442 
  -35.525291 82.747757 -35.375851 82.746094 -35.430012 82.780258 
  -35.26363 82.820251 -35.30751 82.844711 -35.24279 82.856644 
  -34.717381 82.890953 -33.89806 82.899406 -33.811401 82.859421 
  -33.80751 82.826103 -33.912231 82.802467 -33.881962 82.788857 
  -33.69862 82.824417 -33.684181 82.842758 -33.732231 82.888603 
  -33.728901 82.913063 -33.537231 82.945251 -33.001122 82.971916 
  -32.99987 82.974586) #(-32.99987 82.974586 -31.84306 82.9897 
  -31.719721 82.968033 -31.709169 82.931381 -31.59333 82.937469 
  -31.565281 82.986359 -31.43528 83.008591 -30.00972 83.127472 
  -29.33806 83.132767 -28.33806 83.086113 -26.665279 83.060806 
  -25.18861 83.163307 -24.98473 83.151642 -24.841669 83.108307 
  -24.987221 83.080544 -24.93084 83.047203 -24.77306 83.018044 
  -24.7675 82.988861 -25.13389 82.892197 -25.132231 82.855263 
  -25.664721 82.780807 -23.993059 82.911636 -23.841391 82.892487 
  -24.027229 82.859703 -23.907221 82.816093 -23.88611 82.786926 
  -24.022499 82.757202 -23.76833 82.778313 -23.688061 82.832199 
  -23.26 82.839142 -23.11611 82.790253 -22.66028 82.769699 
  -22.65 82.80304 -22.01708 82.711578) 
#(-45.138901 82.072479 -44.77557 82.078308 -44.73724 82.09581 
  -45.067509 82.216637 -44.865292 82.284416 -44.63834 82.314423 
  -44.4189 82.366089 -44.4389 82.396927 -44.995571 82.510529 
  -46.157791 82.659698 -46.675011 82.676086 -47.55946 82.64415 
  -47.74918 82.624969 -47.226959 82.508324 -47.022511 82.426933 
  -46.88612 82.360809 -45.385841 82.173309 -45.138901 82.072479) 
#(-51.69862 81.970543 -51.23695 81.982483 -51.41695 82.049973 
  -52.515011 82.209137 -52.599461 82.258591 -52.56057 82.269699 
  -52.594181 82.284149 -53.030289 82.329697 -53.168072 82.317467 
  -53.327511 82.266373 -53.345291 82.199142 -53.213902 82.115807 
  -53.06723 82.094147 -51.69862 81.970543) 
#(-22.01708 82.711578 -21.314449 82.608032 -21.39889 82.556091 
  -22.307779 82.421082 -22.21611 82.399406 -22.225281 82.375809 
  -22.481951 82.330811 -23.00861 82.291641 -23.831671 82.285248 
  -24.60556 82.188309 -25.10778 82.152206 -28.01111 82.186081 
  -29.28334 82.136368 -30.63586 82.190323 -30.855829 82.197479 
  -30.45583 82.175827 -30.051109 82.141922 -29.933889 82.101357 
  -32.182499 81.916092 -32.99987 81.821411) 
#(-32.99987 81.821411 -33.04945 81.818863 -33.017231 81.798576 
  -33.098339 81.773857 -33.000011 81.761353) 
#(59.159721 81.728867 59.375549 81.764137 59.331379 81.785538 
  59.437771 81.81665 59.421661 81.827187 59.164989 81.851929 
  58.627491 81.840813 57.938332 81.796654 58.14666 81.770248 
  57.908878 81.730263 59.159721 81.728867) 
#(-33.000011 81.761353 -33.000011 81.714157) 
#(-33.000011 81.714157 -33.05196 81.679138 -33.032791 81.659698 
  -32.99987 81.658798) #(63.506939 81.583862 63.746658 81.623032 
  63.802769 81.653313 63.78249 81.669418 63.639431 81.697746 
  63.255829 81.720543 62.714161 81.69664 62.716942 81.720261 
  62.165131 81.685822 62.726391 81.61026 63.506939 81.583862) 
#(-55.982281 82.263184 -55.28307 82.242477 -55.33807 82.218582 
  -55.113621 82.156647 -55.098068 82.186081 -55.22279 82.211357 
  -55.164181 82.233032 -55.300571 82.281662 -55.53529 82.275818 
  -55.473339 82.294693 -54.450569 82.364151 -54.079731 82.316933 
  -53.559731 82.116089 -53.556122 82.071907 -53.621399 82.018593 
  -53.50029 81.944702 -53.508621 81.89386 -53.780289 81.728592 
  -53.791119 81.653587 -53.796959 81.553864 -53.605839 81.509407 
  -53.480831 81.508034 -53.477509 81.549149 -53.522511 81.604141 
  -53.540852 81.676086 -53.126949 81.780258 -52.930851 81.863037 
  -52.952789 81.963593 -53.028339 82.011917 -52.964451 82.029419 
  -52.762791 82.031921 -52.329731 81.973038 -51.381962 81.901642 
  -50.243351 81.705261 -50.176399 81.636368 -49.865292 81.609703 
  -49.62001 81.643311 -50.01112 81.729713 -50.492512 81.776917 
  -50.59362 81.809692 -50.918072 81.873306 -51.05307 81.926933 
  -50.962509 81.950256 -49.82085 81.870247 -49.57085 81.895538 
  -49.438622 81.933296 -50.55751 82.150528 -50.736679 82.207199 
  -50.79224 82.301651 -51.053341 82.433029 -51.079731 82.477203 
  -51.107792 82.502197 -50.801121 82.508591 -49.610291 82.503311 
  -48.988899 82.442467 -48.68251 82.347473 -47.942509 82.28331 
  -47.563351 82.211906 -47.599461 82.169693 -46.392792 82.097748 
  -45.970291 82.014687 -45.99612 81.978867 -45.74696 81.928864 
  -45.111401 81.778587 -44.640011 81.75415 -44.17445 81.835823 
  -44.588902 81.88887 -44.72168 81.939972 -44.53223 81.938309 
  -44.47279 81.967758 -44.925571 81.9897 -44.930561 82.039703 
  -44.399731 82.100807 -44.62001 82.134979 -44.791119 82.196907 
  -44.66724 82.266647 -44.426682 82.302467 -44.128899 82.311371 
  -42.329731 82.213028 -42.337791 82.226357 -42.827511 82.279984 
  -43.302231 82.280258 -43.863899 82.346649 -43.880291 82.378036 
  -43.745571 82.395828 -43.756962 82.411362 -44.384178 82.483032 
  -44.455009 82.508591 -45.25473 82.667213 -45.735291 82.750526 
  -45.607792 82.782204 -43.202229 82.781647 -42.08556 82.757751 
  -42.16029 82.718307 -42.142231 82.696091 -41.84724 82.655258 
  -41.808899 82.622482 -41.87751 82.544693 -41.718899 82.481087 
  -41.586121 82.48497 -41.5564 82.539978 -41.680851 82.575531 
  -41.636398 82.591637 -41.618061 82.646362 -41.873341 82.717194 
  -41.878071 82.739723 -41.701962 82.745529 -41.327511 82.714706 
  -40.605839 82.570534 -40.203621 82.560272 -40.009178 82.478867 
  -40.089741 82.444138 -40.078621 82.421654 -39.91251 82.36554 
  -39.773899 82.371368 -39.754181 82.404137 -39.884178 82.446091 
  -39.87418 82.469704 -39.766682 82.503593 -40.01223 82.559982 
  -39.980289 82.58165 -39.8689 82.629433 -39.93446 82.68248 
  -40.135571 82.714417 -41.798618 82.833038 -44.672508 82.849983 
  -44.900291 82.873871 -44.962791 82.849983 -45.933899 82.843033 
  -46.42057 82.871643 -46.888069 82.964417 -46.76585 82.96553 
  -46.701962 83.005539 -46.466961 83.054138 -45.938622 83.083862 
  -45.080292 82.96637 -45.102791 82.933029 -44.755009 82.964417 
  -44.4189 82.934143 -43.488071 82.913589 -43.739368 82.923927 
  -45.08363 83.025253 -45.506962 83.112473 -45.4114 83.152206 
  -45.280289 83.125809 -45.116119 83.161087 -44.705841 83.104424 
  -44.70668 83.123032 -44.72723 83.143044 -44.657509 83.166092 
  -43.25153 83.107132 -43.99873 83.199768) 
#(58.228329 81.369141 58.570271 81.406082 58.549431 81.422203 
  58.376942 81.471359 57.846111 81.491928 57.80555 81.536087 
  57.75444 81.561371 56.94416 81.521637 57.00666 81.495796 
  56.846661 81.472748 56.774158 81.460823 56.805271 81.44165 
  57.488049 81.428307 57.600269 81.393593 58.228329 81.369141) 
#(-76.259628 82.46727 -76.194748 82.511093 -75.91864 82.579971 
  -75.914177 82.597473 -76.570572 82.666641 -76.934464 82.794434 
  -77.128357 82.863312 -77.768631 82.92247 -77.950302 82.914139 
  -78.241409 82.858871 -78.128906 82.836639 -78.144203 82.823303 
  -78.406418 82.873581 -78.500847 82.845543 -78.5578 82.860527 
  -78.504471 82.901093 -78.521683 82.921082 -78.719742 82.94664 
  -79.066704 82.875259 -79.144737 82.921921 -79.458633 82.974136 
  -80.398071 82.899696 -80.194473 82.838318 -79.996964 82.803307 
  -79.83696 82.750526 -79.243073 82.695251 -78.576691 82.68692 
  -78.521133 82.676933 -78.894203 82.665253 -79.886139 82.708588 
  -79.983353 82.689148 -79.801132 82.646637 -79.941971 82.649406 
  -80.181412 82.687759 -80.158363 82.727753 -80.500847 82.79747 
  -81.473083 82.824982 -81.585297 82.800812 -81.573639 82.788307 
  -80.897522 82.636368 -80.581703 82.54303 -80.920303 82.535248 
  -81.503082 82.634697 -82.215302 82.668587 -82.371964 82.639687 
  -82.390297 82.611923 -81.922523 82.523033 -82.520859 82.502472 
  -82.728912 82.40831 -82.722794 82.388313 -82.625847 82.359154 
  -81.587799 82.196091 -80.868073 82.154984 -80.975594 82.123581 
  -80.922523 82.103592 -80.657516 82.064697 -79.832237 82.01387 
  -79.921692 81.98497 -79.229187 81.816093 -79.564194 81.825256 
  -80.120033 81.977753 -80.977249 82.040253 -82.382523 82.241089 
  -82.99086 82.29248 -83.02919 82.276657 -83.011414 82.221649 
  -82.584473 82.092758 -82.021133 82.082199 -81.914467 82.05275 
  -81.926407 82.034698 -83.126129 82.072479 -82.978363 82.093872 
  -82.953079 82.11998 -83.023071 82.159416 -83.344467 82.227203 
  -83.38475 82.282204 -83.706703 82.344971 -84.047523 82.371368 
  -84.344467 82.352753 -84.940582 82.431923 -84.631683 82.440262 
  -84.662804 82.468582 -85.09613 82.481644 -85.819748 82.454422 
  -85.905029 82.424973 -85.501419 82.398857 -85.537247 82.345261 
  -85.420303 82.344971 -85.481689 82.313583 -85.367798 82.291092 
  -85.414177 82.276093 -86.871964 82.207748 -86.869461 82.195251 
  -86.752518 82.141083 -86.600594 82.121368 -84.932533 82.019417 
  -84.751694 81.984703 -84.621689 81.899406 -84.656418 81.887756 
  -84.811974 81.927467 -84.816971 81.97081 -84.859192 81.98526 
  -85.038643 81.994141 -85.049187 81.974426 -85.217529 81.995529 
  -85.608078 82.000259 -85.732239 81.983307 -85.386124 81.874969 
  -85.422523 81.857483 -85.960571 82.007477 -86.315308 82.0522 
  -86.892517 82.054138 -87.00975 82.030533 -86.842796 81.987198 
  -87.045029 81.98497 -87.127243 81.963867 -86.835022 81.92775 
  -86.726967 81.891922 -86.804176 81.893044 -87.314468 81.973862 
  -87.173363 82.011093 -87.196136 82.026367 -87.462799 82.080544 
  -88.075577 82.10498 -88.625847 82.062759 -89.054466 81.987473 
  -88.989754 81.921082 -89.075027 81.911636 -89.249741 81.941093 
  -89.398071 81.930817 -89.397797 81.909416 -89.170303 81.895813 
  -89.153923 81.878593 -89.333076 81.827187 -89.318077 81.790817 
  -89.63002 81.856369 -89.735023 81.900818 -89.783363 81.917213 
  -91.051697 81.828873 -91.152527 81.798027 -91.034737 81.76387 
  -91.50975 81.764977 -91.761139 81.681923 -91.902252 81.666924 
  -91.938919 81.655258 -91.444473 81.583588 -91.446693 81.524406 
  -90.964737 81.562469 -91.003357 81.592194 -90.991127 81.616089 
  -90.678909 81.668869 -90.293083 81.641373 -90.355583 81.673576 
  -90.353363 81.690536 -90.271408 81.697479 -90.094193 81.650818 
  -89.601967 81.627762 -89.632523 81.604713 -90.824463 81.459976 
  -90.841423 81.435532 -90.535858 81.376923 -90.398643 81.368591 
  -89.54863 81.477203 -88.306686 81.58136 -87.292664 81.503952) 
#(56.519169 81.163857 57.109989 81.253593 57.78944 81.274696 
  57.891102 81.295532 57.024151 81.376373 56.333889 81.382202 
  56.38776 81.321907 56.57943 81.268311 56.531658 81.254433 
  56.158611 81.287483 55.46611 81.319702 55.537498 81.294418 
  55.43166 81.271637 55.610279 81.271637 55.55637 81.219131 
  55.89193 81.189148 56.23 81.223587 56.38361 81.207474 
  56.390549 81.17276 56.519169 81.163857) 
#(-70.024719 81.102226 -69.638077 81.177467 -70.050858 81.161636 
  -70.206703 81.179703 -68.990021 81.261368 -66.608627 81.512756 
  -66.791412 81.540817 -67.182533 81.564697 -68.091957 81.529137 
  -68.738907 81.528313 -68.849182 81.549149 -68.373627 81.53775 
  -68.449188 81.570824 -69.241409 81.699692 -69.291412 81.718872 
  -69.14003 81.708862 -68.330582 81.568588 -68.156693 81.561081 
  -67.716423 81.594421 -66.172523 81.618027 -66.025017 81.65303 
  -65.871964 81.627197 -65.429176 81.670807 -65.352524 81.691933 
  -65.991409 81.682747 -66.012527 81.696907 -65.631683 81.702477 
  -65.344467 81.743874 -65.332237 81.761093 -64.463074 81.721359 
  -64.180573 81.746368 -64.123917 81.768311 -63.849731 81.801086 
  -62.279171 82.015823 -61.87001 82.106644 -61.388069 82.183296 
  -61.135841 82.247482 -61.076401 82.320824 -61.141121 82.383034 
  -61.285568 82.430252 -61.577511 82.482193 -62.171959 82.525528 
  -62.553341 82.524406 -63.089741 82.46637 -63.07835 82.499687 
  -62.94556 82.563873 -62.964451 82.585533 -63.374729 82.611076 
  -63.235569 82.633324 -63.25473 82.650253 -63.55751 82.673859 
  -63.850288 82.715813 -63.510571 82.732483 -63.384178 82.775818 
  -63.412231 82.811081 -63.623901 82.833588 -64.103363 82.83165 
  -64.478912 82.76442 -64.936974 82.871368 -64.678627 82.884697 
  -64.684738 82.901642 -64.982529 82.901093 -65.307533 82.865547 
  -65.102798 82.848038 -65.353363 82.797203 -65.167526 82.769974 
  -65.197533 82.764137 -65.527252 82.79747 -65.468079 82.833313 
  -65.713364 82.843582 -66.670853 82.74025 -68.642517 82.628601 
  -68.599747 82.652481 -66.841423 82.810806 -66.369461 82.888313 
  -66.301407 82.931923 -67.041412 82.959702 -67.820297 82.958862 
  -68.188629 82.946091 -68.15419 82.991089 -68.404739 83.008324 
  -68.98085 82.982483 -68.975304 83.028313 -69.015579 83.040817 
  -69.233078 83.010246 -69.451141 83.035812 -69.664467 83.070824 
  -69.701973 83.110527 -70.373917 83.113327 -71.238907 83.060547 
  -71.497528 83.007202 -70.857803 82.897202 -70.871689 82.881088 
  -71.370033 82.918869 -71.778641 83.001648 -71.79335 83.020538 
  -71.618362 83.079971 -71.65419 83.097748 -72.685577 83.092758 
  -73.619461 82.941093 -73.633636 82.918587 -73.430573 82.893593 
  -73.35585 82.838593 -72.983917 82.783859 -72.498917 82.718307 
  -72.672523 82.698593 -73.817787 82.852753 -73.99086 82.933868 
  -74.436127 83.027206 -76.028923 83.054428 -76.425583 83.019417 
  -77.252518 83.025253 -77.385567 82.983032 -76.37558 82.789139 
  -75.97641 82.784698 -76.309464 82.752762 -76.300018 82.7397 
  -76.206413 82.708313 -75.434738 82.623871 -75.420303 82.606918 
  -76.23085 82.444702 -76.259628 82.46727) 
#(90.844971 81.058594 89.959427 81.107193 89.893593 81.168587 
  90.067963 81.208801 90.874687 81.23053 91.469704 81.187469 
  91.574692 81.129967 91.250259 81.063026 90.844971 81.058594) 
#(60.914162 80.915253 61.143608 80.929428 61.608059 81.035538 
  61.69416 81.109154 61.239719 81.122192 60.660271 81.092758 
  60.060009 81.002441 60.02499 80.991638 60.10305 80.974701 
  60.914162 80.915253) #(57.73666 80.846077 57.8661 80.854141 
  58.26722 80.924973 57.727211 80.97525 57.64777 81.021362 
  56.67194 81.10553 56.104481 81.103027 56.909431 81.009697 
  56.938332 80.964417 57.20554 80.945534 57.22583 80.923027 
  57.226391 80.899696 57.73666 80.846077) 
#(79.030807 80.813873 78.972748 80.837479 78.986649 80.864433 
  79.217697 80.954712 80.434143 80.934418 80.409698 80.87915 
  80.266083 80.847748 79.769417 80.814697 79.030807 80.813873) 
#(54.84111 80.719704 55.445271 80.757202 55.977219 80.801361 
  55.171101 80.892471 54.961109 80.884697 54.82222 80.830261 
  54.261669 80.856918 54.004711 80.826721 53.976101 80.805527 
  54.103611 80.777481 54.673882 80.775818 54.68639 80.758591 
  54.84111 80.719704) #(57.01778 80.694427 57.193329 80.697479 
  57.704159 80.779694 57.71611 80.798027 57.508331 80.839142 
  56.855831 80.892761 56.674999 80.929703 56.599998 80.978317 
  56.04916 81.039429 55.483601 81.010803 54.690281 81.123581 
  54.609161 81.110527 54.42947 81.024193 54.659161 80.988861 
  54.812771 81.003311 54.98444 80.949692 55.38805 80.961906 
  55.403881 80.921371 55.577221 80.886917 56.681389 80.798576 
  57.01778 80.694427) #(63.21249 80.681641 64.615257 80.758324 
  65.464417 80.922203 65.468323 80.939423 65.303307 80.993591 
  65.452499 81.027763 65.238586 81.133034 64.992767 81.169693 
  64.550262 81.195824 64.245796 81.159698 64.119431 81.086906 
  64.216087 81.055817 64.148041 81.002197 63.973331 80.974701 
  63.244999 80.973587 62.557449 80.844131 62.509159 80.806923 
  63.21249 80.681641) #(56.380829 80.617752 56.935551 80.662483 
  56.948608 80.692749 56.711391 80.749687 56.33749 80.774979 
  55.500309 80.723312 55.70805 80.694427 55.599709 80.659149 
  55.684719 80.648033 56.308331 80.646637 56.380829 80.617752) 
#(-32.99987 81.658798 -32.933331 81.662201 -32.351669 81.743874 
  -31.627501 81.83136 -29.70195 81.941383 -29.707781 81.924423 
  -29.759171 81.870537 -29.618059 81.870529 -29.430559 81.921371 
  -29.487221 81.9422 -29.38361 81.958038 -28.341669 82.008591 
  -25.23889 81.996368 -25.202499 81.983582 -25.29361 81.933029 
  -25.24028 81.899147 -25.246111 81.820824 -25.35722 81.765808 
  -25.904169 81.683037 -27.154169 81.54248 -27.62611 81.491928 
  -27.619169 81.474983 -27.5175 81.454422 -27.252781 81.454422 
  -27.210831 81.423317 -27.24695 81.395538 -26.063339 81.534416 
  -24.922501 81.693863 -24.29389 81.706917 -24.102501 81.76886 
  -24.136391 81.819427 -24.07139 81.913879 -24.120001 81.947746 
  -24.026951 82.006088 -23.61389 82.045807 -22.62389 82.074417 
  -22.250561 82.073608 -22.01722 81.933029 -21.964729 81.756363 
  -22.198891 81.483871 -22.584999 81.317749 -22.97056 81.285538 
  -22.76222 81.261642 -23.007231 81.206093 -22.95472 81.180817 
  -23.92083 80.877197 -23.84417 80.838867 -23.87611 80.812759 
  -23.80361 80.806641 -23.990561 80.724716 -24.43222 80.67804 
  -24.172501 80.691093 -24.062229 80.683029 -24.538891 80.560257 
  -24.53945 80.544983 -24.38195 80.548859 -23.67223 80.71666 
  -23.71945 80.762192 -23.51667 80.802467 -23.50333 80.823303 
  -23.56889 80.856918 -23.55945 80.88942 -23.26528 80.906372 
  -22.745001 80.99942 -22.745001 81.039139 -21.46278 81.343033 
  -21.444731 81.404419 -20.733061 81.586647 -19.91028 81.674698 
  -20.10083 81.617477 -20.19083 81.631378 -20.2575 81.612762 
  -20.216949 81.56192 -20.28417 81.471649 -20.253059 81.419144 
  -19.46361 81.564423 -18.97389 81.541924 -18.87611 81.473862 
  -18.794451 81.482193 -18.763611 81.524139 -18.69611 81.527206 
  -18.39584 81.449142 -17.967779 81.475807 -18.06583 81.502472 
  -18.041389 81.54248 -18.156389 81.565536 -18.17445 81.582748 
  -17.803341 81.550262 -17.60973 81.607758 -17.84584 81.625809 
  -17.92778 81.672203 -17.85195 81.689148 -17.831949 81.715263 
  -17.817499 81.737473 -17.273331 81.70137 -17.54167 81.749977 
  -17.46806 81.797203 -17.52417 81.836357 -17.48278 81.864433 
  -16.91584 81.856087 -16.839729 81.873032 -16.909731 81.905258 
  -16.70056 81.931923 -14.76833 81.918297 -12.89639 81.747208 
  -12.15528 81.603317 -12.38778 81.522476 -13.13417 81.398033 
  -13.23889 81.347473 -13.22 81.322197 -13.54528 81.299973 
  -13.70139 81.257217 -13.65861 81.234421 -14.16083 81.12886 
  -14.6275 81.133881 -15.07139 81.098587 -15.135 81.077477 
  -14.94103 81.000633) #(-87.292664 81.503952 -87.276962 81.485809 
  -87.984467 81.535812 -88.716141 81.513031 -88.932533 81.480797 
  -88.823349 81.453583 -89.940582 81.333313 -89.917252 81.314423 
  -89.655853 81.28804 -88.949738 81.253593 -88.982529 81.241928 
  -90.043327 81.239433 -90.311974 81.186653 -90.347519 81.161636 
  -90.198067 81.069702 -90.011963 81.033043 -89.629471 81.00914 
  -86.517242 81.11998 -85.768631 81.244713 -84.998077 81.306923 
  -84.74614 81.289429 -84.776138 81.266083 -85.887802 81.118874 
  -85.839188 81.075256 -86.75502 81.001083 -88.20697 81.002472 
  -88.905853 80.977753 -89.462517 80.919144 -89.450577 80.903313 
  -89.290863 80.849426 -87.594742 80.628593 -87.271408 80.630249 
  -86.309738 80.940811 -85.606689 81.054977 -85.250313 81.055252 
  -83.150017 81.151367 -82.523071 81.166367 -84.496964 81.041092 
  -84.991409 81.040253 -85.774193 80.948868 -86.660294 80.666092 
  -86.739197 80.597473 -86.551407 80.573593 -86.011963 80.53331 
  -85.694748 80.613586 -85.57196 80.61525 -85.857803 80.543297 
  -84.313629 80.513603 -83.840584 80.545532 -83.77919 80.570824 
  -83.723358 80.64386 -83.836411 80.719704 -83.829742 80.731918 
  -83.493362 80.78775 -83.158363 80.833588 -83.133072 80.818863 
  -83.569473 80.739151 -83.488907 80.699417 -83.143913 80.698593 
  -81.943909 80.833038 -81.763077 80.810806 -82.025299 80.746643 
  -83.078079 80.644974 -83.156418 80.606644 -83.170303 80.564148 
  -83.128891 80.544144 -82.799187 80.539429 -81.065857 80.644699 
  -79.618073 80.819427 -79.165298 80.966637 -79.164749 80.983032 
  -79.343918 80.998306 -79.255287 81.058868 -79.142242 81.069138 
  -79.073639 81.090813 -79.435303 81.169418 -79.486397 81.194977 
  -78.916962 81.098038 -78.690857 81.119423 -78.754471 81.135803 
  -78.72113 81.172203 -78.652527 81.197197 -77.896133 81.335533 
  -76.777802 81.444427 -76.76503 81.428589 -78.472794 81.15831 
  -78.406418 81.144974 -78.426407 81.120796 -78.800018 81.026367 
  -78.930573 80.981918 -78.874474 80.949692 -78.861687 80.911087 
  -78.930023 80.887192 -78.869751 80.852203 -78.190582 80.888313 
  -76.986969 80.890259 -76.49086 80.874969 -76.591141 80.842758 
  -78.198639 80.796921 -79.934464 80.619423 -79.863632 80.603027 
  -78.416687 80.608032 -78.025726 80.581787) 
#(46.08416 80.43692 46.52861 80.471916 46.511669 80.489967 
  46.5275 80.520248 46.68222 80.517471 46.648609 80.556374 
  47.005829 80.551651 47.16666 80.625809 47.423611 80.588867 
  47.44305 80.606644 47.310829 80.645538 47.37722 80.68248 
  47.57111 80.675262 47.477219 80.728592 47.58028 80.747192 
  47.77972 80.762482 47.92194 80.705544 48.52166 80.626648 
  48.75972 80.621094 48.754169 80.657761 48.46278 80.714981 
  48.49638 80.741364 48.638329 80.745247 48.284721 80.825813 
  47.464722 80.854713 47.09166 80.824982 47.194721 80.796082 
  46.999439 80.753311 44.9655 80.627121 45.573051 80.51886 
  46.036381 80.572197 46.083611 80.551086 46.01749 80.494423 
  46.039989 80.445824 46.08416 80.43692) 
#(61.066101 80.403587 61.606941 80.526917 61.704151 80.593033 
  61.939159 80.60025 62.14555 80.632751 62.038059 80.662483 
  62.21888 80.718872 62.285259 80.768044 62.25526 80.789703 
  62.046101 80.878593 61.561939 80.885803 61.040272 80.825813 
  59.96999 80.808868 60.254711 80.834702 60.078892 80.85025 
  59.50666 80.802467 59.572208 80.776917 59.369999 80.734421 
  59.220829 80.642761 59.372211 80.558296 59.31337 80.541367 
  59.659431 80.422203 59.945541 80.438026 60.249149 80.494423 
  61.066101 80.403587) #(53.492771 80.172203 53.6161 80.241364 
  53.724159 80.217484 53.859718 80.249977 53.852489 80.27359 
  53.433331 80.330261 53.317768 80.376648 53.271111 80.409698 
  52.900829 80.406647 52.680271 80.350807 52.714439 80.329147 
  52.703049 80.313583 52.181389 80.271927 52.318909 80.218582 
  53.492771 80.172203) #(58.01749 80.104141 57.929989 80.15831 
  58.01944 80.200256 58.435829 80.168587 58.452499 80.199142 
  58.46249 80.229141 58.09277 80.243591 58.13361 80.275253 
  58.432499 80.318314 58.901371 80.325531 59.276371 80.334137 
  59.198601 80.371094 58.879169 80.424698 57.78249 80.493027 
  56.946388 80.474426 57.273331 80.386642 57.194439 80.357193 
  57.270271 80.260803 57.220829 80.234154 57.29916 80.203308 
  57.271938 80.166092 57.634972 80.110519 58.01749 80.104141) 
#(31.900829 80.079697 33.624439 80.206917 33.624989 80.217758 
  33.317211 80.243027 33.094719 80.22081 31.49361 80.110809 
  31.44944 80.085823 31.900829 80.079697) 
#(56.007221 80.070251 57.024441 80.071091 57.139721 80.10553 
  57.041111 80.15303 57.156101 80.198303 57.094719 80.224136 
  57.127781 80.315262 57.049431 80.352203 56.724991 80.3647 
  56.569721 80.321907 56.18972 80.349701 55.969719 80.323868 
  55.98888 80.28331 55.95472 80.257202 56.04388 80.191093 
  55.802792 80.127113 55.713612 80.101089 56.007221 80.070251) 
#(47.65416 80.067467 48.033039 80.088867 48.060829 80.119141 
  48.203609 80.132751 48.374161 80.087196 48.50222 80.118317 
  48.548882 80.152481 48.51944 80.174973 48.56638 80.199142 
  48.79805 80.149979 49.086109 80.169418 49.10194 80.194427 
  48.97583 80.207474 49.035831 80.239967 48.91888 80.279984 
  48.669998 80.279137 48.63166 80.307213 48.814991 80.346916 
  48.79166 80.36998 48.9025 80.382751 49.46278 80.361649 
  49.67889 80.376373 49.82333 80.414139 49.696388 80.465813 
  49.752769 80.487473 50.949711 80.535248 51.728882 80.680527 
  51.745548 80.718033 51.26722 80.785248 50.31638 80.715263 
  50.294998 80.756638 51.018879 80.833313 51.035549 80.851639 
  50.808609 80.916641 50.133049 80.846649 50.016941 80.8647 
  50.439159 80.909698 50.184441 80.92247 49.005001 80.774979 
  49.109718 80.766083 48.96666 80.737473 49.021111 80.711906 
  49.681381 80.717484 49.613609 80.683868 49.658611 80.640533 
  49.28722 80.639137 49.298611 80.627762 49.40749 80.611649 
  49.38472 80.59137 49.175549 80.5522 49.192211 80.521362 
  48.528332 80.509979 48.567768 80.536926 48.39444 80.56636 
  48.183331 80.526367 48.040279 80.54303 47.445 80.466087 
  47.395828 80.445824 48.122219 80.467484 48.223049 80.417213 
  47.618889 80.400818 47.669441 80.367477 48.153881 80.338867 
  48.127781 80.325256 47.203331 80.306091 47.14278 80.363861 
  47.011108 80.367203 46.637772 80.305527 46.640549 80.279694 
  46.902771 80.227203 46.890831 80.207199 46.971378 80.176361 
  47.384991 80.184418 47.34111 80.210823 47.453609 80.234703 
  47.92416 80.242477 47.963329 80.226929 47.843609 80.207748 
  48.0825 80.194702 47.755001 80.168587 47.637199 80.097473 
  47.619999 80.093582 47.65416 80.067467) 
#(-19.94083 80.056923 -19.08556 80.150818 -19.477221 80.242752 
  -19.724449 80.244713 -19.87056 80.211929 -20.012779 80.092758 
  -19.94083 80.056923) #(-63.787739 80.147163 -64.144203 80.155807 
  -64.203079 80.186371 -64.172523 80.247482 -64.255287 80.240807 
  -64.333359 80.141083 -64.528923 80.091637 -64.966423 80.062759 
  -65.285019 80.103027 -65.549469 80.039978 -66.06752 80.015808 
  -66.44252 80.1147 -66.73085 80.064148 -67.081703 80.066093 
  -67.081131 80.103867 -67.494751 80.195534 -67.445297 80.209427 
  -67.521683 80.267197 -67.46225 80.299149 -67.469467 80.320251 
  -67.434464 80.344971 -66.708633 80.487762 -66.778641 80.520538 
  -66.716141 80.554977 -66.511139 80.563026 -65.986687 80.669983 
  -65.698349 80.711357 -65.075027 80.790253 -64.985023 80.844421 
  -65.021133 80.862473 -64.992798 80.894974 -64.734467 80.91275 
  -64.795029 80.956093 -64.761139 80.988312 -63.92807 81.054428 
  -63.70668 81.13942 -63.574181 81.144974 -63.47224 81.115807 
  -63.371681 81.005539 -62.794731 80.751083 -62.73695 80.777763 
  -63.19862 80.955544 -63.362789 81.127197 -63.355289 81.163589 
  -62.974731 81.223312 -62.240292 81.198593 -61.515011 81.068039 
  -60.892231 81.165527 -61.039459 81.198868 -61.200569 81.296082 
  -61.158352 81.313026 -61.243061 81.330261 -61.308338 81.35997 
  -60.78862 81.473862 -60.79224 81.513603 -61.371681 81.688873 
  -61.452511 81.753036 -61.40279 81.77887 -61.218349 81.818039 
  -60.062511 81.944702 -58.817791 81.851089 -58.663349 81.767197 
  -58.761959 81.733871 -58.70779 81.690536 -58.430561 81.641647 
  -57.623901 81.581093 -57.52306 81.531921 -56.52029 81.331093 
  -56.44973 81.342484 -56.623901 81.399696 -56.999889 81.450882 
  -57.091671 81.472748 -57.528339 81.603317 -58.138069 81.663589 
  -58.360008 81.763313 -58.45863 81.857193 -58.56612 81.888603 
  -59.41029 81.976639 -59.466961 81.996918 -56.586681 82.227753 
  -56.42445 82.22081 -56.325569 82.168297 -56.263069 82.163857 
  -56.13306 82.232193 -55.982281 82.263184) 
#(93.678307 79.994141 93.200813 80.06192 92.061653 80.170258 
  92.205811 80.203033 92.766083 80.162483 92.881638 80.175537 
  92.128311 80.273323 92.136093 80.287483 93.318863 80.272476 
  93.101089 80.314697 91.529137 80.28804 91.639977 80.311081 
  91.464142 80.299149 91.420258 80.314972 91.704147 80.388603 
  92.26387 80.394974 91.943588 80.443588 91.911087 80.462196 
  92.78331 80.518593 92.816933 80.578873 92.778587 80.602478 
  93.325531 80.805817 93.120247 80.772476 92.493874 80.75386 
  92.496643 80.774406 92.668869 80.828308 92.694138 80.882751 
  93.148857 80.92247 93.161636 80.948029 93.068039 80.971649 
  93.151093 81.0047 94.825256 81.127197 95.167213 81.212479 
  95.54747 81.217758 95.034973 81.242752 95.122192 81.270813 
  95.594971 81.289703 96.549423 81.07637 96.541367 81.02359 
  96.728592 81.00386 96.648323 80.97998 96.954147 80.905533 
  97.781372 80.818863 97.744423 80.794418 97.822479 80.784416 
  97.872192 80.757477 97.746643 80.738037 97.9272 80.731087 
  97.963593 80.70137 97.702477 80.661087 97.28775 80.659149 
  97.300537 80.671654 97.152206 80.651642 97.177467 80.62886 
  97.045258 80.580544 97.019417 80.521362 97.211906 80.415527 
  97.185257 80.379433 97.219971 80.342484 97.415253 80.323303 
  97.418587 80.30304 97.197197 80.233871 95.929977 80.212196 
  95.073029 80.136368 94.523857 80.126373 94.391083 80.073303 
  93.678307 79.994141) #(59.364712 79.914429 59.92416 79.99025 
  59.843601 80.038857 59.82526 80.078873 59.670559 80.099983 
  59.353611 80.112198 58.90583 80.057213 58.759159 80.022751 
  58.799709 80.006622 59.364712 79.914429) 
#(-98.797241 79.673576 -98.648621 79.783577 -98.650009 79.818039 
  -98.77919 79.902763 -98.706123 79.965813 -98.785583 80.021637 
  -99.11058 80.130539 -99.732788 80.150528 -100.0656 80.089981 
  -100.1925 80.02803 -100.1278 79.961906 -100.1706 79.921921 
  -100.0703 79.876923 -99.525284 79.883591 -99.295837 79.833313 
  -99.333618 79.80304 -99.301392 79.7547 -98.936401 79.719704 
  -98.866127 79.690811 -98.797241 79.673576) 
#(92.554703 79.659973 92.176361 79.664139 91.950813 79.695251 
  91.97998 79.717194 92.329147 79.714417 92.339142 79.740807 
  92.095261 79.80748 91.499153 79.810532 91.057213 79.853592 
  91.06665 79.87442 91.290817 79.906372 91.276642 79.924973 
  91.01886 79.960533 91.166367 79.982193 91.184982 80.002762 
  91.111923 80.043587 91.086639 80.048576 93.029419 80.009979 
  93.789429 79.906921 93.750259 79.855797 93.358307 79.769699 
  92.554703 79.659973) #(76.642761 79.481918 76.703873 79.50914 
  76.617691 79.543533 76.153313 79.569427 76.04303 79.627472 
  76.054977 79.646927 76.137482 79.657204 76.277763 79.643593 
  76.170532 79.636917 76.261368 79.598862 76.52887 79.637192 
  77.610809 79.51915 77.556641 79.492203 76.642761 79.481918) 
#(-77.926933 79.36734 -77.15863 79.329147 -77.353912 79.42247 
  -77.386139 79.452759 -77.125847 79.462479 -77.076401 79.398323 
  -76.870033 79.349426 -76.123627 79.331093 -75.881973 79.353317 
  -76.169189 79.400253 -76.159187 79.436081 -76.179176 79.459702 
  -77.13446 79.49025 -77.191406 79.511093 -77.142517 79.54747 
  -76.176132 79.488861 -75.931412 79.423576 -75.81752 79.448303 
  -75.786133 79.415253 -75.144203 79.375259 -74.935013 79.385246 
  -74.88446 79.416092 -75.060303 79.490807 -74.964752 79.513031 
  -74.933907 79.491089 -74.544189 79.438026 -73.983353 79.455544 
  -73.950302 79.493874 -73.996964 79.535538 -73.988907 79.551933 
  -73.916412 79.552467 -73.780029 79.503036 -73.616409 79.496918 
  -73.224747 79.524979 -73.126129 79.558296 -73.174469 79.651642 
  -73.295578 79.688583 -73.368073 79.76886 -74.699463 79.792763 
  -74.833359 79.849136 -74.080582 79.888031 -73.06308 79.799423 
  -72.912804 79.702187 -72.217796 79.659973 -71.116676 79.789703 
  -70.910294 79.885803 -71.110023 79.915253 -71.39447 79.884979 
  -71.460571 79.901367 -71.372803 79.939148 -70.719467 79.986359 
  -70.488632 80.057213 -70.507797 80.099701 -70.762802 80.133324 
  -72.169739 80.053307 -72.391968 80.085533 -71.926407 80.099983 
  -71.896973 80.11554 -72.420853 80.21109 -72.294456 80.223312 
  -71.732239 80.111923 -71.463074 80.118027 -70.745033 80.205811 
  -70.178627 80.189148 -69.99086 80.243317 -69.991127 80.26886 
  -70.448639 80.340263 -70.382523 80.41304 -70.813347 80.544983 
  -70.783363 80.563026 -70.499474 80.51387 -70.220306 80.416924 
  -70.305573 80.356087 -70.118362 80.344704 -69.596413 80.361076 
  -69.305573 80.418297 -69.273071 80.463867 -68.89003 80.597473 
  -68.787804 80.632477 -68.668907 80.673859 -67.653923 80.856369 
  -67.531128 80.897476 -67.567787 80.908577 -67.59169 80.933029 
  -67.208633 80.941933 -66.545029 81.070534 -66.438347 81.123596 
  -65.98085 81.223862 -65.441406 81.256363 -64.646133 81.396637 
  -64.436417 81.479424 -64.537804 81.543587 -64.893913 81.53775 
  -66.068359 81.457748 -69.463364 81.183029 -69.660294 81.135246 
  -70.024719 81.102226) #(-94.342133 81.109238 
  -93.908363 81.039429 -94.40863 80.96553 -94.508072 80.979424 
  -94.465302 81.015533 -94.905029 81.05748 -95.241127 81.006088 
  -95.28363 80.949982 -95.460564 80.909698 -95.468918 80.890259 
  -95.150848 80.881088 -95.526688 80.833313 -95.501129 80.806923 
  -95.282806 80.786087 -94.925293 80.814697 -94.857803 80.801361 
  -95.035858 80.768311 -94.140297 80.721916 -94.088364 80.701637 
  -94.650299 80.681374 -94.669724 80.657761 -94.54335 80.599701 
  -94.364754 80.613586 -93.810852 80.541367 -93.866966 80.518311 
  -94.771973 80.561371 -94.995033 80.603027 -96.006958 80.582748 
  -96.020859 80.567467 -95.904167 80.539139 -96.087509 80.48526 
  -95.498917 80.383873 -95.467796 80.358032 -95.460571 80.336906 
  -96.047813 80.389977 -96.281113 80.361923 -96.232529 80.334702 
  -96.592239 80.362762 -96.681953 80.342194 -96.464752 80.313026 
  -96.566406 80.272202 -95.922523 80.194138 -95.646133 80.2397 
  -95.496964 80.219421 -95.692497 80.181091 -95.632797 80.164139 
  -95.263634 80.118317 -94.748627 80.169418 -94.57196 80.224983 
  -94.120033 80.183029 -94.091667 80.17247 -94.510834 80.154419 
  -94.801964 80.085823 -94.414177 79.997757 -94.416962 79.978867 
  -95.672523 80.046654 -96.410294 80.13887 -96.748901 80.134697 
  -96.801392 80.086906 -96.676407 80.041924 -96.675003 80.008324 
  -96.556953 79.948868 -96.262787 79.93692 -96.138077 79.906372 
  -96.381973 79.881638 -96.391678 79.913857 -96.458618 79.914429 
  -96.615303 79.883873 -96.575562 79.849983 -96.392227 79.863037 
  -96.490837 79.83609 -95.901138 79.654419 -95.74086 79.641373 
  -95.153923 79.647476 -94.335571 79.780807 -94.283073 79.757477 
  -94.357788 79.726929 -94.329727 79.688309 -94.429176 79.663857 
  -95.736687 79.537483 -95.710281 79.495796 -95.778641 79.474701 
  -95.671951 79.439423 -95.779457 79.425812 -95.601959 79.384979 
  -95.304176 79.403587 -95.295837 79.379433 -95.164177 79.344704 
  -95.318626 79.332199 -95.194458 79.3022 -94.985863 79.267471 
  -94.506973 79.337196 -94.398071 79.375259 -94.500313 79.3797 
  -94.49501 79.421371 -93.842239 79.389977 -94.135567 79.338867 
  -94.206947 79.272476 -93.969727 79.257477 -93.757523 79.283577 
  -93.648354 79.329971 -93.666138 79.360527 -93.485313 79.354141 
  -93.338058 79.447197 -93.235023 79.435257 -93.236397 79.415253 
  -93.370033 79.351639 -93.347237 79.338867 -93.008636 79.388031 
  -93.061417 79.415817 -93.144203 79.475807 -93.045013 79.476089 
  -92.973358 79.423576 -92.854462 79.407761 -92.581131 79.452187 
  -92.259193 79.446907 -92.228912 79.431374 -92.533623 79.388603 
  -92.561974 79.365807 -91.864754 79.339417 -91.70253 79.361359 
  -91.120033 79.386368 -91.146683 79.356369 -92.603912 79.300812 
  -92.667236 79.26886 -92.676682 79.251373 -92.412247 79.222748 
  -90.359619 79.24855) #(23.640829 79.178589 24.11694 79.196907 
  24.27 79.248871 24.26778 79.266373 24.28167 79.304977 
  24.798611 79.371368 24.9475 79.368874 24.96278 79.335533 
  25.173889 79.328308 25.730829 79.409973 25.97694 79.510803 
  25.942221 79.541367 25.826111 79.596077 25.816111 79.618317 
  26.486389 79.717758 26.531111 79.748306 27.14222 79.853592 
  27.240829 79.898857 27.23889 79.915817 27.10111 79.967484 
  27.23666 80.09581 26.96722 80.127197 26.598049 80.184692 
  25.705 80.168869 25.774719 80.213867 25.54361 80.234421 
  25.26778 80.223312 25.225559 80.247757 25.351669 80.274979 
  24.77972 80.246643 24.89167 80.318314 24.851669 80.341919 
  24.532499 80.253593 24.460831 80.267761 24.5975 80.314423 
  24.347771 80.367752 24.17222 80.359154 24.18222 80.336357 
  24.39666 80.323868 24.37583 80.31192 23.73472 80.294418 
  23.73 80.227203 23.830549 80.188309 23.557501 80.128593 
  23.48917 80.154694 23.476669 80.205811 23.39027 80.1922 
  23.406389 80.170258 23.396111 80.137756 23.08639 80.167213 
  23.156389 80.145813 23.21583 80.113586 23.08 80.124153 
  22.99972 80.156082 23.047501 80.24498 23.308331 80.28331 
  23.3475 80.341919 23.199169 80.351357 23.136391 80.390259 
  23.31778 80.406372 22.828051 80.513313 22.74778 80.503311 
  22.8325 80.430817 22.719721 80.337196 22.71694 80.324982 
  22.61611 80.350807 22.67944 80.42276 22.385 80.423576 
  22.335831 80.370796 22.34972 80.348312 22.549999 80.313026 
  22.572781 80.291641 22.45528 80.264977 22.37611 80.103592 
  22.46611 80.06665 22.452499 80.055252 22.375 80.068314 
  22.352501 80.055527 22.475559 80.011093 22.32111 80.032204 
  22.365 80.007477 22.339161 79.990807 22.205 79.982483 
  22.2225 80.00415 22.12472 80.08136 21.79805 80.146927 
  21.606939 80.113312 21.61916 80.129433 21.89222 80.204971 
  21.879999 80.246094 21.838329 80.271088 21.48333 80.266373 
  21.338329 80.208038 21.321659 80.224426 21.325279 80.256638 
  21.18944 80.232758 20.81361 80.218307 20.748051 80.271088 
  20.81389 80.296082 20.812771 80.31192 20.62278 80.291641 
  20.52305 80.32637 20.547501 80.350807 20.365829 80.419693 
  20.17 80.410812 20.139999 80.376083 20.076389 80.379967 
  20.100559 80.405807 20.06222 80.430527 19.71694 80.498032 
  19.631109 80.493874 19.69083 80.439423 19.51944 80.466087 
  19.46389 80.448593 19.48472 80.389687 19.916941 80.375259 
  19.771111 80.343872 19.85861 80.339706 19.839439 80.306923 
  19.71694 80.243591 19.80722 80.231087 19.83778 80.213867 
  19.614719 80.220543 19.33028 80.325256 19.060829 80.35054 
  18.98 80.336639 19.22389 80.193588 19.480551 80.168297 
  19.58028 80.144699 19.387501 80.107193 19.26333 80.084137 
  19.184441 80.117203 18.70417 80.204422 18.766109 80.181641 
  18.710279 80.156921 18.1675 80.185806 17.820271 80.141083 
  17.797501 80.123581 18.246111 80.095543 18.352221 80.073029 
  18.15472 80.07692 18.239719 80.042213 18.86805 80.034416 
  18.112499 79.903587 18.235279 79.887756 18.319441 79.836357 
  18.70166 79.776917 18.771391 79.717484 18.936939 79.733582 
  19.542219 79.710251 20.391939 79.794144 21.69944 79.833862 
  21.89027 79.816933 21.778049 79.80304 21.73472 79.776367 
  22.24889 79.800812 22.34444 79.783043 22.266939 79.76915 
  20.490829 79.684418 20.49444 79.671371 21.13916 79.577759 
  21.095551 79.558029 20.424999 79.589417 20.150829 79.642761 
  19.66 79.613861 19.63611 79.597748 19.68611 79.548576 
  20.273331 79.454971 20.74333 79.459427 20.85111 79.403313 
  20.795 79.373871 20.968889 79.3647 22.890551 79.412483 
  22.65583 79.35997 22.64694 79.301933 22.695551 79.278313 
  22.92667 79.219147 23.25222 79.19165 23.640829 79.178589) 
#(-18.098061 78.992218 -17.980829 78.99942 -17.98222 79.01915 
  -17.6075 79.087753 -17.55722 79.153053 -17.571671 79.176086 
  -17.72139 79.219421 -18.08556 79.096077 -18.11389 79.06192 
  -18.085831 79.005814 -18.098061 78.992218) 
#(28.095551 78.811653 28.496389 78.888031 29.316111 78.844971 
  29.693609 78.891373 29.65778 78.91304 29.072781 78.898323 
  28.89167 78.949982 28.653891 78.960251 28.415831 78.961906 
  28.424721 78.934418 28.361389 78.916924 28.145281 78.911636 
  27.84639 78.836639 28.095551 78.811653) 
#(97.759697 78.803589 96.843307 78.941933 96.854713 78.970261 
  96.602478 78.986359 96.32692 79.000259 96.272202 79.022202 
  95.970543 78.993591 95.653587 79.00415 95.649696 79.071907 
  95.408577 79.10054 95.283577 79.065536 94.841087 79.059143 
  94.62915 79.137756 94.633034 79.192749 94.426651 79.220543 
  94.320251 79.255249 94.351639 79.314697 94.311081 79.344704 
  94.358871 79.433296 94.346649 79.460251 94.270538 79.478317 
  94.049973 79.46637 94.073303 79.434982 93.949142 79.4272 
  93.698868 79.456093 93.960533 79.478027 93.980797 79.495247 
  93.687187 79.541092 93.878036 79.601357 93.726089 79.594147 
  93.439972 79.501083 93.520248 79.480797 93.224426 79.437759 
  93.140259 79.451637 93.141083 79.474983 93.301933 79.492752 
  93.269974 79.519974 93.020248 79.524979 93.301651 79.549973 
  94.104141 79.768593 94.656647 79.811653 94.661087 79.823593 
  94.22554 79.902481 94.383591 79.931091 94.329697 79.97081 
  94.499153 79.969421 94.943314 80.06665 94.910538 80.096077 
  95.006927 80.10025 95.126083 80.045258 95.343307 80.027206 
  95.393593 80.088593 95.580261 80.111359 96.438026 80.098587 
  96.599701 80.136917 96.728317 80.113861 97.142471 80.168869 
  97.703583 80.155807 98.058296 80.063583 98.0672 80.031647 
  97.767197 79.943588 97.828583 79.926086 97.767761 79.884407 
  97.583862 79.852203 97.656372 79.828033 97.518311 79.804138 
  97.623871 79.776367 97.23497 79.718033 97.20636 79.696907 
  97.549149 79.737473 97.919418 79.852203 97.885246 79.868591 
  98.04303 79.905807 98.384979 79.866364 98.578583 79.978317 
  98.434692 80.008873 98.482193 80.044418 98.570251 80.051933 
  99.36998 80.010529 100.0153 79.824142 100.0633 79.767761 
  99.8172 79.737762 99.882202 79.69136 99.709427 79.556641 
  99.784149 79.511368 99.684692 79.466919 99.689423 79.446907 
  99.732193 79.41748 99.6922 79.389687 99.734154 79.367477 
  99.659149 79.295807 99.455978 79.246986 99.187759 79.305252 
  99.041924 79.296654 99.042213 79.284416 99.859154 79.082748 
  99.864967 79.012482 99.939697 78.973862 99.938873 78.953308 
  99.896637 78.934418 99.394974 78.820534 97.759697 78.803589) 
#(-19.50667 78.727203 -19.266939 78.731644 -19.159731 78.770813 
  -19.401951 78.779419 -19.182501 78.803864 -19.34889 78.816093 
  -19.16222 78.893044 -19.29167 78.896927 -19.19389 78.937759 
  -19.38611 78.931091 -19.746111 78.807213 -19.73667 78.779984 
  -19.50667 78.727203) #(26.708611 78.624969 26.93944 78.646637 
  27.012779 78.698303 26.83416 78.711639 26.613609 78.803864 
  26.44861 78.805252 26.396391 78.770813 26.468889 78.699142 
  26.56389 78.688026 26.708611 78.624969) 
#(-78.025726 80.581787 -80.02475 80.527481 -83.166962 80.32692 
  -83.186974 80.306641 -82.16835 80.013603 -81.557533 79.960823 
  -81.402252 79.93248 -81.665024 79.897751 -81.599747 79.851929 
  -81.568077 79.795807 -81.63002 79.76442 -80.795303 79.648033 
  -79.82724 79.698593 -79.904739 79.646927 -80.618637 79.597198 
  -80.608627 79.576103 -80.630577 79.564148 -81.457237 79.636917 
  -81.60585 79.588593 -81.728638 79.589706 -81.785294 79.614967 
  -81.616409 79.623306 -81.978912 79.718307 -81.970016 79.752762 
  -82.153061 79.858871 -82.532806 79.947197 -83.615837 80.210533 
  -83.989471 80.26442 -86.116127 80.333588 -86.51503 80.299149 
  -86.659737 80.128036 -86.636963 80.092484 -86.442787 79.999687 
  -85.271133 79.923859 -85.36586 79.896362 -86.118637 79.959137 
  -86.39003 79.958038 -86.460571 79.919693 -86.454742 79.847748 
  -86.379997 79.821373 -86.493362 79.800537 -86.486687 79.763603 
  -86.387802 79.747482 -85.493362 79.700531 -85.02919 79.615807 
  -84.94725 79.525818 -84.485023 79.406372 -84.452797 79.328873 
  -84.335571 79.252197 -84.32724 79.188583 -84.086143 79.188026 
  -83.979752 79.221649 -83.94252 79.21109 -84.030029 79.151642 
  -83.68808 79.06665 -83.373901 79.056374 -83.386139 79.039429 
  -83.600594 79.025253 -83.990593 79.051651 -84.050018 79.103317 
  -84.544189 79.141373 -84.789467 79.069427 -84.77919 79.046654 
  -84.726967 79.027763 -84.229187 78.958038 -82.924469 78.934982 
  -82.503082 78.882751 -82.110313 78.913589 -81.999741 78.960251 
  -81.546417 79.062187 -81.486397 79.041641 -81.65419 78.993591 
  -81.753082 78.912201 -81.660858 78.877762 -81.741409 78.839142 
  -83.085861 78.85553 -83.255859 78.829971 -83.210564 78.798859 
  -82.232239 78.736359 -82.23085 78.717758 -82.569473 78.711357 
  -82.559464 78.682213 -82.245453 78.597488) 
#(-111.4625 78.267471 -111.4019 78.28331 -111.4336 78.323029 
  -111.2397 78.323593 -111.3064 78.371094 -111.1167 78.382477 
  -110.7156 78.29248 -109.405 78.306374 -109.3333 78.424973 
  -109.2606 78.455811 -109.4053 78.556923 -110.3944 78.752197 
  -111.4347 78.643311 -111.3786 78.617752 -111.4556 78.592758 
  -112.3117 78.539978 -113.1242 78.420807 -113.3325 78.328873 
  -113.1883 78.269974 -113.0269 78.272751 -112.3811 78.358307 
  -111.9822 78.343872 -111.7953 78.271088 -111.4625 78.267471) 
#(106.1908 78.189972 105.9928 78.214142 106.3789 78.276367 
  106.4361 78.330811 106.5755 78.339142 106.7614 78.303589 
  106.6922 78.255814 106.6389 78.281372 106.4461 78.256927 
  106.4972 78.251923 106.5089 78.24025 106.1908 78.189972) 
#(20.697781 78.186653 20.62694 78.198868 20.666389 78.221359 
  20.77417 78.256088 20.757771 78.293297 20.471939 78.319138 
  20.68222 78.346649 20.663891 78.387192 20.12472 78.472198 
  21.11166 78.56665 21.10305 78.592484 21.20805 78.621094 
  21.458611 78.601929 21.501659 78.565536 22.090549 78.588867 
  22.242769 78.477753 22.23555 78.274979 22.27194 78.263603 
  21.995831 78.242752 20.773331 78.218872 20.697781 78.186653) 
#(-90.359619 79.24855 -91.932251 79.159973 -93.295303 79.166924 
  -93.460564 79.142761 -93.608353 79.051651 -94.263351 78.991928 
  -94.269737 78.962196 -93.996407 78.885803 -93.037804 78.765808 
  -93.163353 78.735527 -93.650284 78.784698 -93.813629 78.765808 
  -93.555557 78.680817 -93.343628 78.673576 -93.46669 78.645813 
  -93.271133 78.584137 -92.96669 78.488586 -92.987244 78.460251 
  -92.920013 78.418869 -92.613892 78.357193 -92.609734 78.330811 
  -92.459473 78.3022 -92.224472 78.325256 -92.18335 78.306374 
  -92.323914 78.287201 -92.186417 78.255539 -92.031418 78.207474 
  -91.857788 78.2397 -91.489754 78.176933 -90.434189 78.136368 
  -90.301407 78.155258 -90.267517 78.186653 -90.374184 78.246368 
  -90.325577 78.271637 -90.715584 78.309143 -90.729446 78.326103 
  -90.186417 78.333313 -90.023361 78.298027 -89.886948 78.215263 
  -89.674179 78.217194 -89.563339 78.149696 -89.461937 78.158577 
  -89.46196 78.175537 -89.785278 78.398033 -89.985023 78.436081 
  -90.100861 78.549698 -90.073349 78.60025 -89.956947 78.605263 
  -89.891418 78.55275 -89.53363 78.399696 -89.196411 78.233871 
  -88.847794 78.151367 -88.784737 78.169983 -88.536133 78.406921 
  -88.552254 78.437469 -88.746399 78.535812 -88.78891 78.612762 
  -88.559464 78.604141 -88.205307 78.452477 -87.985023 78.492203 
  -87.890846 78.578308 -87.90863 78.596916 -88.044167 78.658577 
  -88.130287 78.684692 -88.228912 78.814423 -88.186691 78.898033 
  -88.210571 78.931641 -88.192497 78.980263 -87.753082 79.085533 
  -87.724731 79.075813 -87.813629 78.996918 -87.973083 78.965263 
  -87.946693 78.909149 -88.003357 78.807213 -87.872803 78.694977 
  -87.663094 78.642471 -87.54335 78.664703 -87.451141 78.728867 
  -87.186417 78.82692 -86.93808 78.916924 -86.986969 78.949692 
  -86.983353 79.056641 -86.949188 79.057213 -86.903351 79.009407 
  -86.741409 78.95192 -86.587799 78.983582 -86.565018 79.019417 
  -86.397522 79.079697 -84.931137 79.258324 -84.90419 79.276642 
  -84.951141 79.307213 -85.251129 79.394699 -85.623917 79.599136 
  -85.743637 79.616928 -85.847778 79.596359 -85.901138 79.493591 
  -86.011963 79.440262 -86.12085 79.439972 -86.160583 79.463593 
  -86.028084 79.474701 -86.13446 79.523033 -86.039749 79.545532 
  -86.303093 79.642761 -86.640846 79.653313 -86.813347 79.611923 
  -86.695023 79.567467 -86.790024 79.538857 -86.846413 79.549973 
  -86.819748 79.576103 -86.84169 79.593033 -86.96669 79.601639 
  -87.161133 79.57164 -87.263077 79.511368 -87.345581 79.503036 
  -87.462799 79.534698 -87.441704 79.573868 -87.144203 79.637756 
  -87.055573 79.731918 -87.064728 79.792213 -86.966957 79.885529 
  -87.003082 79.917763 -87.463638 79.83136 -87.47197 79.852478 
  -87.017242 79.94165 -87.019203 79.957199 -87.160294 79.99498 
  -87.18364 80.025253 -87.300018 80.069427 -87.956703 80.069702 
  -88.049187 80.125809 -87.67836 80.156372 -87.564194 80.191093 
  -87.618362 80.272751 -87.607803 80.324142 -87.684189 80.410248 
  -88.384193 80.443588 -88.55336 80.418587 -88.685287 80.371643 
  -88.649193 80.31665 -88.703346 80.293297 -88.573914 80.232483 
  -88.294189 80.20137 -88.256973 80.181641 -88.320297 80.175812 
  -88.191132 80.114967 -88.162247 80.091637 -88.283363 80.118027 
  -88.483353 80.135803 -88.414749 80.10498 -88.56308 80.102753 
  -89.092216 80.200813 -89.251419 80.278313 -89.256973 80.298576 
  -89.105301 80.339417 -89.083633 80.398323 -89.257248 80.396927 
  -89.059464 80.461357 -89.326424 80.531921 -89.58725 80.545532 
  -89.825851 80.518593 -89.754204 80.486359 -89.762802 80.464981 
  -90.046692 80.541641 -90.741409 80.562187 -90.771683 80.577477 
  -90.593918 80.645248 -90.738907 80.711639 -91.121964 80.7547 
  -91.321411 80.882751 -91.781693 81.090263 -91.813919 81.15831 
  -92.181961 81.241089 -93.209183 81.361359 -93.565018 81.376648 
  -93.505577 81.337753 -93.568359 81.30275 -94.068069 81.363312 
  -94.278923 81.341919 -94.391693 81.261093 -94.350594 81.245529 
  -93.928909 81.203873 -93.419456 81.219971 -93.12114 81.182747 
  -93.095863 81.154137 -93.179176 81.135529 -93.123611 81.11525 
  -93.300018 81.079697 -94.342133 81.109238) 
#(107.4389 78.049423 106.4219 78.126923 107.43 78.190262 
  107.6352 78.166092 107.6997 78.122192 107.5833 78.067467 
  107.4389 78.049423) #(99.55304 77.939972 99.451263 77.955383 
  99.369141 77.96109 99.415527 77.988312 99.269974 78.03775 
  99.408043 78.068039 99.533043 78.141922 99.522476 78.168297 
  100.0519 78.346916 99.998306 78.386642 100.0883 78.43692 
  100.2866 78.595543 100.2466 78.624687 100.3933 78.751083 
  100.5944 78.794144 101.1608 78.752197 101.1366 78.768044 
  100.8297 78.798027 100.7936 78.845261 100.7861 78.89859 
  100.8939 78.976639 101.0814 79.029137 101.6244 78.982193 
  100.988 79.067749 101.0664 79.133873 101.2653 79.138603 
  101.1236 79.159416 101.2422 79.224701 101.5533 79.250809 
  101.5272 79.308029 101.5966 79.356087 101.8411 79.358871 
  101.9842 79.254967 102.2628 79.250809 102.1725 79.280533 
  102.1428 79.363586 102.2328 79.414978 102.3989 79.42804 
  103.1403 79.325813 103.0905 79.283577 102.9044 79.264977 
  102.7408 79.156372 102.7947 79.130814 102.3802 78.82164 
  102.5866 78.855263 102.9147 79.052467 103.1705 79.060257 
  103.6247 79.168587 103.6286 79.149139 103.6408 79.129433 
  103.8255 79.156921 104.0178 79.114433 104.0202 79.088593 
  103.9753 79.059982 103.9947 79.048859 104.4239 78.971359 
  104.4864 78.938873 104.5178 78.86998 104.3719 78.849983 
  104.6325 78.837753 104.6594 78.814423 104.5847 78.765533 
  104.7244 78.787483 104.7569 78.815811 104.725 78.838593 
  104.9172 78.854141 105.168 78.809143 105.2552 78.733307 
  105.238 78.715813 105.4158 78.571373 105.3736 78.507751 
  104.7586 78.328033 102.9358 78.236359 102.8769 78.195534 
  102.6611 78.163589 102.6705 78.211906 102.5425 78.221916 
  101.1747 78.183296 100.9111 78.106644 99.910538 77.948868 
  99.736923 77.963867 99.55304 77.939972) 
#(-97.072533 77.804138 -96.710571 77.85553 -96.704727 77.87442 
  -96.285568 77.859421 -95.652252 77.929428 -95.100571 77.953583 
  -94.887238 78.063873 -95.130859 78.194138 -95.345863 78.217758 
  -95.388077 78.236359 -94.837799 78.347198 -94.831703 78.3647 
  -94.878082 78.391373 -95.20668 78.461639 -95.684738 78.521088 
  -95.964752 78.483582 -96.271683 78.538589 -96.164467 78.599983 
  -96.184464 78.628593 -97.160278 78.758873 -97.951401 78.816933 
  -98.364754 78.768044 -98.31778 78.746643 -98.371964 78.719971 
  -98.315567 78.64386 -98.14003 78.599426 -98.031403 78.559418 
  -98.404449 78.508873 -98.347794 78.443039 -98.037231 78.397202 
  -98.039467 78.322479 -98.055008 78.301651 -97.868057 78.279694 
  -97.773064 78.238861 -97.930008 78.236649 -97.926682 78.217758 
  -97.321404 78.207474 -96.87056 78.133324 -96.891953 78.106644 
  -96.887787 78.083038 -96.997803 78.075256 -97.648071 78.090813 
  -97.684448 78.073868 -97.651672 78.051933 -97.746948 78.040817 
  -97.755569 78.025528 -96.992508 77.914139 -97.120033 77.86525 
  -97.072533 77.804138) #(-19.35195 77.801651 -19.243059 77.812187 
  -19.23028 77.839981 -19.314449 77.883034 -19.698891 77.884697 
  -20.0725 77.956917 -20.01861 77.962479 -20.46278 77.966087 
  -20.46611 77.944138 -20.07361 77.869423 -19.35195 77.801651) 
#(-99.906952 77.778587 -99.351959 77.828583 -99.013344 77.888313 
  -99.094727 77.96637 -98.97168 77.997757 -98.946121 78.061653 
  -99.551392 78.286087 -99.741386 78.289978 -99.753616 78.389687 
  -99.859734 78.4422 -99.670288 78.479713 -99.53334 78.583588 
  -99.60112 78.598312 -100.017 78.616638 -100.0628 78.63887 
  -99.91362 78.679703 -99.952507 78.72554 -100.3236 78.77803 
  -100.3514 78.828308 -100.6139 78.798027 -101.1864 78.80275 
  -101.2006 78.820824 -101.0031 78.919983 -101.0056 78.943039 
  -101.2317 78.959427 -101.6489 79.075813 -101.9233 79.085823 
  -102.4181 79.008034 -102.3764 78.946373 -102.5611 78.869713 
  -102.6261 78.900253 -102.5786 78.923576 -102.5836 78.948593 
  -102.7511 78.938873 -102.7681 78.955811 -102.6544 78.994141 
  -102.612 79.092194 -102.892 79.166641 -102.9267 79.21109 
  -102.877 79.233032 -103.7031 79.352753 -105.1611 79.29747 
  -105.44 79.329147 -105.4828 79.306374 -105.4386 79.295258 
  -105.4342 79.273033 -105.5417 79.239967 -105.6286 79.161362 
  -105.5997 79.081093 -105.5625 79.024406 -105.3953 79.011642 
  -104.9197 79.052467 -104.6811 79.016647 -104.6886 78.993591 
  -105.0122 78.844704 -105.0286 78.815262 -104.9883 78.798309 
  -104.8175 78.8022 -104.5642 78.8647 -104.4719 78.950531 
  -104.2339 78.991928 -104.0811 78.979424 -103.8272 78.90387 
  -104.1672 78.81636 -104.2197 78.782204 -104.1706 78.765808 
  -103.9056 78.76886 -103.8706 78.806374 -103.6953 78.793869 
  -103.7889 78.754967 -103.7961 78.735809 -103.4392 78.784973 
  -103.3192 78.74025 -103.3581 78.718582 -103.9892 78.646088 
  -104.0336 78.619713 -103.4019 78.611649 -103.4978 78.564148 
  -103.4489 78.534698 -103.5333 78.496368 -104.3978 78.569977 
  -104.8314 78.569977 -105.0119 78.521637 -105.0506 78.488037 
  -104.8206 78.355797 -104.3636 78.254433 -103.8989 78.245796 
  -103.9061 78.272751 -102.8061 78.377762 -102.6661 78.358582 
  -102.8183 78.300262 -102.7814 78.276093 -102.5906 78.2397 
  -102.1331 78.282761 -101.6967 78.252197 -101.2895 78.18248 
  -101.0356 78.196091 -100.7469 78.071373 -100.8378 78.034973 
  -100.8078 77.992203 -100.6042 77.890808 -100.6078 77.85997 
  -99.906952 77.778587) #(-114.1931 77.698029 -113.9083 77.726357 
  -113.5875 77.808029 -113.6017 77.831093 -114.3506 78.032471 
  -114.2836 78.059143 -114.4139 78.065262 -114.8197 77.973038 
  -115.0908 77.963593 -115.0772 77.938583 -114.5142 77.765259 
  -114.5656 77.757202 -114.1931 77.698029) 
#(-102.0172 77.679703 -100.9406 77.726929 -100.9483 77.753593 
  -101.1914 77.830811 -101.6722 77.893311 -102.4425 77.876648 
  -102.5297 77.834137 -102.5047 77.779984 -102.4139 77.753311 
  -102.4364 77.729713 -102.0172 77.679703) 
#(-18.121111 77.664703 -17.85778 77.67804 -17.73278 77.708588 
  -17.584169 77.837753 -17.674999 77.899696 -17.805559 77.905548 
  -17.93667 77.876083 -17.94861 77.813873 -18.11834 77.755539 
  -18.23667 77.674423 -18.121111 77.664703) 
#(-14.94103 81.000633 -14.65056 80.946907 -14.69667 80.914139 
  -15.90917 80.824142 -15.92028 80.79303 -16.053341 80.725807 
  -17.695 80.746368 -17.91584 80.824692 -18.10611 80.788857 
  -18.01306 80.742477 -18.01778 80.714417 -18.52639 80.630539 
  -18.78722 80.619141 -19.625561 80.670258 -20.156389 80.680527 
  -20.57972 80.584976 -21.247499 80.575531 -21.221109 80.560532 
  -20.81139 80.552467 -20.826111 80.525253 -20.777229 80.498894 
  -20.262501 80.584702 -20.12722 80.64415 -19.93611 80.649979 
  -18.98695 80.587753 -18.831671 80.564972 -18.13056 80.549149 
  -17.43861 80.6297 -16.21278 80.538597 -16.125561 80.497482 
  -16.570841 80.375809 -16.68639 80.373581 -16.60778 80.403587 
  -16.759171 80.404137 -16.75639 80.379967 -16.596951 80.346649 
  -16.603889 80.330811 -16.908609 80.260529 -17.252501 80.228317 
  -18.44861 80.212479 -19.45472 80.280258 -19.81917 80.279419 
  -20.043329 80.235527 -20.12611 80.1772 -20.555281 80.10054 
  -20.36389 80.083313 -20.60306 80.024979 -20.47084 79.983307 
  -20.730829 79.882751 -20.72611 79.856087 -20.430559 79.861649 
  -20.29195 79.798309 -20.35445 79.761093 -20.23473 79.767197 
  -19.878889 79.846649 -20.214729 79.821907 -20.18639 79.870796 
  -20.257231 79.881363 -20.01861 79.988861 -19.28945 80.103317 
  -18.966669 80.083313 -18.321671 80.132477 -17.762501 80.132477 
  -17.567499 80.101089 -17.45417 80.051086 -17.873341 79.866364 
  -18.22278 79.754967 -18.430559 79.738861 -19.228889 79.788857 
  -19.445841 79.738861 -19.63806 79.649696 -19.57667 79.629967 
  -19.585831 79.583328 -19.725 79.526382 -19.799999 79.451103 
  -19.635 79.420258 -19.66806 79.331093 -19.871111 79.185257 
  -19.82111 79.148857 -19.67778 79.22998 -19.69861 79.258873 
  -19.557779 79.33136 -19.04945 79.296654 -19.19083 79.251373 
  -19.182501 79.225273 -19.18445 79.198029 -19.09861 79.221359 
  -19.10556 79.185822 -19.313339 79.17276 -19.285839 79.263313 
  -19.166389 79.279137 -19.315281 79.279984 -19.54528 79.21553 
  -19.56889 79.193863 -19.52528 79.165817 -19.53195 79.148857 
  -19.61945 79.118591 -19.90167 79.136642 -20.091391 79.063583 
  -19.92417 78.974701 -19.906389 78.929138 -19.99917 78.881363 
  -20.15834 78.863312 -20.682779 78.888321 -20.79528 78.835831 
  -21.0075 78.838028 -21.18445 78.80304 -21.025841 78.797203 
  -21.06139 78.755814 -21.071671 78.74054 -21.20278 78.703033 
  -20.92639 78.689972 -21.384171 78.657761 -21.416389 78.642471 
  -20.937229 78.649139 -20.904169 78.629967 -20.93861 78.603592 
  -21.16445 78.539429 -21.135 78.507751 -21.373341 78.305527 
  -21.37611 78.261642 -21.28945 78.240807 -21.279169 78.217758 
  -21.4175 78.14859 -21.54306 78.133591 -21.75695 78.130539 
  -21.4125 78.104424 -21.818609 77.930817 -21.815559 77.916092 
  -21.57917 77.975807 -21.589729 77.959137 -21.78278 77.849701 
  -21.91889 77.840263 -21.897499 77.806641 -22.025 77.704147 
  -22.011391 77.678307 -21.430559 77.676376 -21.722231 77.5522 
  -21.72784 77.525742) #(-66.661301 77.714111 -67.156418 77.668297 
  -67.146133 77.636093 -67.280029 77.563873 -67.646408 77.518044 
  -68.392242 77.503593 -68.366127 77.54776 -68.406967 77.577759 
  -68.699463 77.663857 -68.815582 77.651367 -68.636414 77.574982 
  -68.595863 77.527206 -68.657242 77.504967 -69.206703 77.449417 
  -70.262527 77.555527 -70.248917 77.578873 -69.493637 77.689148 
  -69.493637 77.75415 -69.847794 77.690262 -70.684189 77.677467 
  -70.696411 77.699982 -70.206413 77.820251 -69.993073 77.825256 
  -69.993073 77.841087 -70.376129 77.858307 -70.670303 77.779984 
  -71.237808 77.758873 -71.41835 77.784698 -71.419739 77.808296 
  -71.227524 77.85498 -71.251129 77.881927 -71.628082 77.85997 
  -71.594467 77.89386 -71.628082 77.919144 -71.939468 77.886093 
  -72.35585 78.009407 -72.29335 78.050537 -72.589752 78.058594 
  -72.870033 78.145538 -73.013351 78.150253 -73.043083 78.16748 
  -72.732803 78.189697 -72.815857 78.221359 -72.694473 78.253036 
  -72.656418 78.287483 -72.849747 78.314148 -72.821693 78.351639 
  -72.67836 78.376373 -72.585571 78.419418 -72.674469 78.440536 
  -72.592239 78.465263 -72.624191 78.48497 -72.552254 78.521088 
  -71.519997 78.634697 -70.78891 78.603317 -70.790863 78.656372 
  -70.700577 78.699982 -70.013641 78.779419 -69.843628 78.800262 
  -69.347794 78.798309 -69.137802 78.882751 -68.843918 78.828873 
  -68.79335 78.839417 -69.150017 78.913589 -69.166687 78.928864 
  -69.088364 78.964706 -68.61586 79.030258 -68.041412 79.073029 
  -67.75058 79.037201 -67.666687 79.051086 -67.737518 79.076103 
  -67.691704 79.092758 -67.187813 79.111076 -67.171127 79.154137 
  -67.100021 79.126923 -67.006973 79.113312 -66.97641 79.151093 
  -66.920303 79.140808 -66.918907 79.096359 -66.753082 79.142197 
  -66.339462 79.137192 -66.337799 79.113861 -65.892242 79.139687 
  -65.895576 79.159416 -65.730583 79.200531 -65.710022 79.226929 
  -65.684464 79.249153 -65.528641 79.256363 -65.55336 79.28775 
  -65.136139 79.378593 -65.144203 79.404419 -64.88002 79.492752 
  -64.823639 79.533577 -64.815582 79.589981 -64.876129 79.632477 
  -65.011414 79.653313 -64.907242 79.704147 -65.026962 79.759407 
  -64.95224 79.781372 -65.13002 79.847473 -64.998917 79.863037 
  -65.043083 79.894974 -64.953346 79.964981 -65.05336 79.996094 
  -65.025299 80.020538 -63.787739 80.147163) 
#(-93.570862 77.437759 -93.475304 77.471359 -93.474472 77.556091 
  -93.101959 77.662483 -93.174728 77.704147 -93.656952 77.776642 
  -93.852249 77.737762 -94.752518 77.788589 -95.118637 77.749687 
  -95.406418 77.746094 -95.428093 77.803307 -95.496407 77.805527 
  -96.255569 77.689697 -96.276123 77.640259 -96.329193 77.60498 
  -96.188606 77.544983 -95.889717 77.464417 -95.776962 77.474426 
  -93.570862 77.437759) #(-71.01474 77.36998 -70.069473 77.39386 
  -70.093918 77.412483 -70.726967 77.464706 -71.238907 77.456093 
  -71.283081 77.441933 -71.01474 77.36998) 
#(-112.0311 77.324692 -111.2767 77.424698 -110.9322 77.40831 
  -110.5022 77.460251 -110.1175 77.539978 -110.0814 77.571373 
  -110.1628 77.604713 -110.0406 77.637482 -110.1139 77.692749 
  -110.0803 77.763313 -110.1611 77.784149 -110.6311 77.758034 
  -110.7439 77.77359 -110.9003 77.832748 -110.8958 77.856087 
  -110.8222 77.868874 -110.1961 77.896637 -109.6697 77.971649 
  -109.5811 78.041367 -109.6053 78.071091 -109.7917 78.099136 
  -110.7272 78.097748 -110.8611 78.061653 -111.0933 78.092484 
  -112.4933 77.988312 -113.2308 77.903587 -113.3064 77.837196 
  -113.315 77.783859 -113.2294 77.723587 -113.0964 77.614151 
  -113.2403 77.587196 -113.1981 77.523857 -112.7908 77.441093 
  -112.6011 77.455261 -112.5867 77.431641 -112.4131 77.356087 
  -112.0311 77.324692) #(-71.94252 77.304428 -71.358078 77.358032 
  -71.37558 77.390259 -72.23558 77.454147 -72.573914 77.413857 
  -72.558907 77.399139 -72.467529 77.377472 -72.117798 77.34581 
  -72.115021 77.314697 -71.94252 77.304428) 
#(22.664169 77.254433 22.899719 77.290527 22.95805 77.351639 
  23.20389 77.393311 23.39027 77.373581 23.90111 77.503036 
  24.002781 77.603027 24.263611 77.683868 24.88805 77.739433 
  24.908609 77.755249 24.290279 77.906082 23.89027 77.847473 
  23.636669 77.86525 23.075001 78.001083 23.05139 78.045532 
  23.112221 78.090813 23.36083 78.102753 23.459721 78.155807 
  22.94944 78.248032 21.71167 78.202759 20.903049 78.114967 
  20.86694 78.086639 20.903049 78.067749 21.52194 77.948868 
  21.65778 77.916924 21.537781 77.89386 21.55694 77.855263 
  21.254721 77.726929 21.230829 77.646637 21.200279 77.604424 
  20.83194 77.537201 20.934719 77.496643 20.868891 77.47554 
  20.868891 77.45192 20.951941 77.440811 22.192499 77.503036 
  22.371111 77.564972 22.764999 77.551933 22.747219 77.526093 
  22.41 77.415253 22.49333 77.368317 22.49472 77.327187 
  22.385 77.304428 22.423611 77.257202 22.664169 77.254433) 
#(107.2194 77.230797 107.4541 77.278313 107.2775 77.295258 
  107.415 77.356644 107.7452 77.322746 107.7158 77.265533 
  107.2194 77.230797) #(-90.089188 77.199692 -89.849747 77.249977 
  -89.652802 77.324982 -89.706703 77.358871 -89.696693 77.38942 
  -89.753632 77.473038 -90.083069 77.569977 -90.843918 77.65387 
  -91.12001 77.617752 -91.206947 77.568588 -91.170303 77.449692 
  -91.208908 77.414978 -91.182533 77.386917 -90.657516 77.261093 
  -90.089188 77.199692) #(89.389137 77.168869 89.596649 77.205261 
  89.671921 77.248032 89.541641 77.281921 89.671082 77.273033 
  89.671921 77.290253 89.474701 77.314423 89.263031 77.296371 
  89.154694 77.252762 89.135803 77.204971 89.156952 77.198639 
  89.389137 77.168869) #(-81.784363 77.160721 -81.910568 77.194427 
  -81.904457 77.248581 -82.196671 77.298859 -82.091957 77.31636 
  -81.828346 77.285812 -81.169739 77.322479 -81.204193 77.370529 
  -81.523643 77.378036 -81.748352 77.448029 -81.666962 77.502197 
  -81.67836 77.538307 -81.911407 77.609421 -81.949188 77.655258 
  -81.895287 77.68248 -81.277512 77.424423 -80.682533 77.322479 
  -79.988632 77.27359 -79.712517 77.318314 -79.527252 77.30275 
  -79.083633 77.299973 -78.76474 77.380814 -78.726967 77.367477 
  -78.839737 77.310257 -78.712799 77.312469 -78.23085 77.392197 
  -78.249191 77.411636 -78.252518 77.439148 -78.025299 77.471649 
  -77.944473 77.511368 -77.98085 77.554703 -77.723068 77.599136 
  -77.753082 77.624969 -78.081703 77.673309 -77.98114 77.70137 
  -78.051697 77.729713 -77.963364 77.74942 -77.94725 77.773033 
  -78.006973 77.815811 -78.303093 77.86525 -78.426407 77.906372 
  -78.384453 77.92804 -78.209183 77.954697 -78.238632 77.973862 
  -78.261139 77.995247 -77.785294 77.948868 -76.898071 77.901642 
  -76.574463 77.94165 -76.49086 77.967758 -76.157516 78.012482 
  -75.912247 77.959427 -75.589188 78.089417 -75.621964 78.12442 
  -76.908363 78.195534 -76.855583 78.227478 -76.574188 78.249687 
  -75.613907 78.198029 -75.479187 78.222198 -75.358627 78.301651 
  -75.190308 78.299698 -75.031418 78.33136 -75.111969 78.372757 
  -76.325027 78.515259 -75.443359 78.512192 -74.644737 78.594971 
  -74.819473 78.627472 -74.87001 78.675812 -74.720016 78.707474 
  -74.831703 78.743317 -74.761688 78.77359 -74.807533 78.79776 
  -74.760849 78.823593 -74.933067 78.854141 -75.690582 78.893593 
  -76.440582 78.839417 -76.315582 78.896088 -75.781418 78.934692 
  -75.732529 78.969147 -76.559464 79.029419 -77.71225 78.966087 
  -77.902252 78.91275 -78.168327 78.780807 -78.248077 78.770248 
  -78.297523 78.788857 -78.271133 78.808868 -77.708633 79.013031 
  -78.891693 79.063309 -78.426407 79.083862 -77.495033 79.017761 
  -77.073639 79.070824 -76.146683 79.077759 -76.08197 79.099701 
  -76.160019 79.122192 -76.098068 79.199142 -75.856117 79.150818 
  -75.885567 79.097473 -75.626694 79.066093 -74.691132 79.022202 
  -74.493073 79.032471 -74.436691 79.057747 -74.475021 79.078583 
  -74.735291 79.159973 -74.81752 79.178864 -74.4953 79.207474 
  -74.585564 79.23053 -75.406128 79.237473 -76.237808 79.271088 
  -77.32225 79.267471 -77.92836 79.32637 -78.051407 79.354713 
  -77.926933 79.36734) #(-104.7903 77.108871 -104.4725 77.137482 
  -104.3972 77.183868 -104.3814 77.26442 -104.4725 77.284149 
  -104.4392 77.314423 -105.0164 77.417763 -104.9467 77.479141 
  -104.9592 77.508034 -105.1736 77.612198 -105.6489 77.748581 
  -106.0406 77.74498 -106.0917 77.715263 -105.9308 77.66304 
  -105.8239 77.596359 -105.8381 77.570534 -105.6778 77.507202 
  -105.765 77.463867 -105.6556 77.441933 -105.6897 77.41748 
  -105.5489 77.369423 -105.572 77.323303 -105.3167 77.223312 
  -105.3772 77.218582 -105.3756 77.206917 -104.9936 77.164978 
  -104.7903 77.108871) #(95.741928 76.95665 95.932747 77.003036 
  95.904984 77.023323 95.262756 76.987198 95.244713 77.006088 
  95.439972 77.055252 96.165817 77.126083 96.438309 77.202759 
  96.52066 77.201973 96.538239 77.199463 96.584427 77.137482 
  96.455544 77.0672 95.741928 76.95665) 
#(-113.6286 76.708038 -113.4492 76.777206 -113.4981 76.833313 
  -113.8075 76.88942 -114.1903 76.885246 -114.6064 76.865807 
  -114.8553 76.794418 -114.8731 76.760803 -114.8225 76.753311 
  -113.6286 76.708038) #(148.3972 76.636757 148.7202 76.745247 
  149.4261 76.777763 149.22549 76.732483 149.22189 76.696907 
  149.1689 76.650528 148.3972 76.636757) 
#(16.36278 76.563309 16.308331 76.574142 16.33667 76.65303 
  15.49806 76.879967 15.58722 76.914978 16.14333 76.975807 
  16.237499 76.955811 16.226669 76.926933 16.32666 76.943863 
  16.317221 76.976357 16.495279 76.982758 16.51972 76.998581 
  16.075001 77.026367 16.05694 77.069138 15.99417 77.079971 
  15.84916 77.053589 15.90472 77.013313 15.72833 76.998581 
  15.2325 77.018593 15.05722 77.123032 14.375 77.1922 
  14.345 77.22525 14.15306 77.291367 14.13472 77.318863 
  14.16306 77.34581 14.09111 77.364151 13.96222 77.424149 
  14.05389 77.450813 13.92722 77.491928 13.91416 77.527763 
  14.0575 77.558594 14.35472 77.583862 14.54556 77.565811 
  14.59139 77.522202 14.52694 77.501923 14.53916 77.490807 
  14.7325 77.491089 14.79 77.545807 15.835 77.526367 
  16.223049 77.434982 16.30555 77.471359 16.04805 77.505539 
  15.91389 77.564972 15.65083 77.577187 14.73889 77.65303 
  14.77167 77.665527 15.78 77.747192 16.363331 77.801361 
  16.97139 77.787201 17.11972 77.781647 16.897221 77.817749 
  16.802219 77.858582 16.808611 77.885803 16.88611 77.868027 
  16.98361 77.906082 17.006109 77.931374 16.842779 77.921371 
  16.664721 77.857193 15.81472 77.830261 15.57389 77.883034 
  15.04861 77.78804 13.76111 77.727478 13.72167 77.760529 
  13.815 77.788589 13.80833 77.813309 13.65111 77.848862 
  13.62833 77.957474 13.67639 77.99942 13.6125 78.040527 
  13.61194 78.058296 13.96694 78.090813 14.10972 78.058594 
  14.28333 77.964417 14.35583 77.962753 14.36278 77.980797 
  14.2325 78.066093 14.24972 78.096916 15.03361 78.114433 
  14.995 78.133873 15.05667 78.14859 15.49222 78.238037 
  15.66111 78.217194 15.73694 78.229141 15.60083 78.269699 
  15.60139 78.299149 15.79333 78.336639 16.81889 78.333862 
  17.272499 78.413857 17.21694 78.436371 16.82444 78.386093 
  16.32889 78.452187 16.498329 78.539703 16.82889 78.648033 
  16.83111 78.671921 16.634159 78.666924 16.57111 78.713318 
  16.4925 78.707199 16.35416 78.596359 16.177219 78.541367 
  16.05444 78.492203 15.99333 78.476929 15.46417 78.451637 
  15.35056 78.476929 15.19333 78.588028 15.45278 78.635803 
  15.50139 78.717194 15.42194 78.782761 15.48194 78.811371 
  15.38 78.844704 15.29556 78.819702 15.1975 78.728867 
  15.25639 78.656647 15.01944 78.621094 15.035 78.601089 
  14.94472 78.599983 14.805 78.641647 14.84639 78.681923 
  14.81472 78.730797 14.69861 78.726357 14.44389 78.673859 
  14.5475 78.646362 14.5475 78.573029 14.57361 78.542763 
  14.39944 78.501648 14.4225 78.47081 14.66139 78.443039 
  14.7175 78.406372 14.68833 78.377762 14.27639 78.385246 
  14.24833 78.356369 14.32528 78.306091 14.17583 78.269974 
  14.04055 78.245247 14.07111 78.286362 13.94611 78.267197 
  13.94305 78.224136 13.80778 78.265808 13.74361 78.260803 
  13.85555 78.209427 13.71833 78.196373 13.49278 78.207748 
  13.00667 78.197479 12.91194 78.24054 12.95694 78.266083 
  12.90139 78.321373 12.87111 78.354424 12.7 78.363312 
  12.38917 78.472198 12.3975 78.486649 13.11389 78.517761 
  13.18111 78.544144 12.78555 78.524979 11.92555 78.627197 
  11.84944 78.661087 11.85389 78.694702 11.75417 78.702187 
  11.64694 78.746643 11.79139 78.819977 11.91667 78.81192 
  11.92 78.832474 11.40611 78.925537 11.33555 78.966637 
  11.6025 78.976357 12.0725 78.915817 12.49555 78.903313 
  12.50083 78.918297 12.40389 78.998032 12.06389 78.967484 
  11.98167 78.986076 12.08055 78.99498 12.07805 79.009979 
  11.68167 79.063583 11.85389 79.147202 12.1375 79.216919 
  12.05722 79.23497 12.11583 79.258034 12.08555 79.304428 
  11.83667 79.291924 11.91361 79.236076 11.89722 79.225807 
  11.78861 79.236649 11.68611 79.32164 11.59417 79.301933 
  11.72083 79.19165 11.705 79.161362 11.23639 79.093033 
  11.18305 79.117752 11.14139 79.237762 10.89778 79.332199 
  10.84972 79.370247 10.91805 79.378311 10.85194 79.401093 
  10.90278 79.418869 10.91083 79.456093 10.84028 79.492477 
  10.69778 79.514137 10.67916 79.53804 11.18028 79.559418 
  10.85389 79.599701 10.98611 79.643311 11.36611 79.634979 
  11.45889 79.646088 11.20555 79.709137 11.21861 79.732483 
  11.19889 79.777763 11.54805 79.772202 11.53889 79.810532 
  11.84 79.836639 12.04639 79.709702 12.34167 79.663307 
  12.34528 79.713318 12.19861 79.763313 12.16361 79.809143 
  12.22472 79.83609 12.40472 79.828873 12.54389 79.777481 
  12.51 79.744423 13.09583 79.828888 13.86778 79.868874 
  13.9575 79.829971 13.96556 79.766922 13.88472 79.726357 
  13.62833 79.69664 13.24472 79.700256 13.0175 79.670807 
  12.57778 79.585533 13.33194 79.594147 13.49278 79.568314 
  13.40444 79.523033 13.26528 79.51442 13.2725 79.467194 
  13.4875 79.439423 13.44778 79.483307 13.59444 79.484154 
  13.87361 79.391922 13.90805 79.278587 14.08472 79.26915 
  14.15583 79.338318 13.92861 79.50914 13.89805 79.546082 
  14.11028 79.610527 14.27778 79.610527 14.14861 79.633873 
  14.25667 79.680527 14.55778 79.806091 14.86028 79.76387 
  15.29167 79.60054 15.42639 79.414703 15.79083 79.224136 
  15.65222 79.133034 15.70861 79.097748 15.81333 79.161636 
  15.91722 79.149406 16.132219 79.053864 16.14805 78.986649 
  16.393049 78.904419 16.49555 78.915817 16.492769 78.935257 
  16.17667 79.153313 16.138611 79.239151 15.95944 79.306374 
  15.85417 79.535538 15.91861 79.558296 15.78778 79.635803 
  15.72944 79.653313 15.64111 79.821091 15.73111 79.873581 
  16.139721 79.869141 15.95 79.937469 15.98444 79.973587 
  16.307779 80.062759 16.54055 80.040527 16.721109 79.944427 
  16.696939 79.911636 16.84194 79.869423 16.90694 79.878311 
  16.87055 79.930252 16.977221 79.960251 17.370831 79.924149 
  18.08333 79.730797 18.077221 79.695251 17.602779 79.543297 
  17.765551 79.543587 17.77194 79.51886 17.760281 79.409698 
  17.64167 79.390259 17.68222 79.367203 17.847771 79.393593 
  18.0175 79.468307 18.042219 79.534149 18.193609 79.620796 
  18.356939 79.628311 18.65889 79.559418 18.74861 79.522476 
  18.88583 79.441933 18.85111 79.406082 18.91111 79.389977 
  18.854719 79.372192 18.840549 79.340813 18.87694 79.314148 
  18.79833 79.27887 18.622219 79.264137 18.648331 79.239151 
  18.851391 79.248306 18.950001 79.213028 18.915001 79.175812 
  18.93722 79.160248 19.186661 79.145248 19.348049 79.184692 
  19.834999 79.146927 19.80389 79.115807 19.908051 79.064148 
  19.90667 79.01387 21.54611 78.838318 21.54472 78.760803 
  21.358061 78.696907 21.386391 78.653313 20.67667 78.683296 
  20.558611 78.62442 19.68861 78.612762 19.57777 78.570534 
  19.610279 78.544418 19.66889 78.507477 18.96278 78.449142 
  19.05722 78.389137 19.061939 78.351929 18.95611 78.277763 
  19.060829 78.24498 19.07972 78.217758 18.92 78.173859 
  19.094999 78.102478 19.07111 78.085533 18.784719 78.027206 
  18.5525 78.055252 18.408331 78.014687 18.49667 77.966637 
  18.333891 77.898323 18.44722 77.848312 18.449169 77.762756 
  18.34222 77.670258 18.362499 77.635529 18.287781 77.586357 
  18.30611 77.546082 18.23666 77.490807 17.730829 77.489151 
  17.73139 77.458313 17.625 77.440262 17.417219 77.183029 
  17.44416 77.14415 17.32583 77.043869 17.095831 77.044693 
  17.17639 77.021637 17.318609 76.96553 17.22139 76.917213 
  16.943609 76.815262 16.927219 76.781647 17.18417 76.723038 
  17.19833 76.694702 17.00083 76.626083 16.997219 76.595261 
  16.571939 76.574982 16.55444 76.608307 16.41666 76.617203 
  16.36278 76.563309) #(-101.4042 76.55275 -101.1928 76.571373 
  -100.2975 76.721916 -100.7442 76.753311 -101.6886 76.586357 
  -101.4042 76.55275) #(-89.94725 76.471916 -89.924179 76.508034 
  -89.808907 76.482483 -89.671692 76.50415 -89.794739 76.53331 
  -89.862518 76.597473 -89.837509 76.66304 -89.671967 76.698593 
  -89.688606 76.742752 -89.983078 76.836906 -90.271118 76.827759 
  -90.579453 76.766922 -90.600304 76.73497 -90.563606 76.709976 
  -90.081703 76.48497 -89.94725 76.471916) 
#(112.575 76.441933 112.4247 76.455261 112.3044 76.533043 
  112.08 76.55304 112.0141 76.609451 112.2922 76.617752 
  112.348 76.656647 112.5272 76.616364 112.4872 76.59581 
  112.5272 76.558868 112.6844 76.526917 112.6983 76.50386 
  112.5719 76.498032 112.613 76.457199 112.575 76.441933) 
#(25.030001 76.439148 25.58222 76.70665 25.51527 76.710533 
  25.413891 76.684143 25.065281 76.530533 24.941389 76.443863 
  25.030001 76.439148) #(-82.245453 78.597488 -82.30835 78.568863 
  -82.417252 78.574142 -83.371689 78.776642 -85.099747 78.917763 
  -86.649727 78.795532 -87.109467 78.593033 -87.095581 78.568588 
  -86.878082 78.573029 -86.866409 78.546371 -87.140556 78.550262 
  -87.415024 78.470261 -87.525574 78.410248 -87.493912 78.379967 
  -87.518913 78.23053 -87.475594 78.21637 -87.262222 78.226639 
  -87.089752 78.20192 -87.352249 78.191093 -87.526962 78.149139 
  -87.505859 78.128311 -87.079742 78.102753 -86.719742 78.121918 
  -86.497803 78.21553 -86.39946 78.200256 -86.073639 78.248581 
  -86.05307 78.29747 -85.833359 78.379967 -85.827507 78.344147 
  -85.950302 78.228317 -86.251404 78.156647 -86.291412 78.08136 
  -86.267242 78.06636 -86.148361 78.054703 -85.41835 78.118874 
  -84.96225 78.343582 -84.978638 78.414978 -84.675293 78.588318 
  -84.619751 78.588318 -84.782806 78.505814 -84.848633 78.381927 
  -84.772522 78.342194 -84.834473 78.314972 -84.96669 78.215813 
  -84.479752 78.216919 -84.17836 78.17276 -84.631126 78.199982 
  -84.993073 78.160248 -85.087799 78.103317 -85.07753 78.090813 
  -84.799187 78.055252 -84.533081 78.085533 -84.288094 78.075531 
  -84.761688 78.02359 -85.065582 78.056374 -85.607529 77.957199 
  -85.678909 77.929428 -85.505859 77.899979 -85.474747 77.868591 
  -85.200577 77.901642 -84.401962 77.910248 -84.318909 77.886917 
  -84.523071 77.900253 -84.912247 77.838867 -84.853912 77.87442 
  -84.86586 77.893311 -85.232239 77.881638 -85.400299 77.836357 
  -85.400299 77.813309 -85.297813 77.797203 -85.03447 77.834976 
  -84.94696 77.822746 -85.348907 77.728867 -85.268082 77.70192 
  -85.30835 77.676086 -85.299187 77.660538 -84.922523 77.601639 
  -84.521133 77.689148 -84.480827 77.728592 -84.42836 77.722748 
  -84.450851 77.701637 -84.866409 77.574142 -84.839752 77.53804 
  -83.986969 77.499977 -83.674469 77.530533 -83.200844 77.705544 
  -83.111687 77.789703 -82.728912 77.929703 -82.794189 77.99498 
  -82.76474 78.019699 -82.336143 78.078873 -82.326141 78.065262 
  -82.538071 78.031082 -82.591141 78.011093 -82.513077 77.95636 
  -82.674469 77.836906 -82.807243 77.799423 -82.799187 77.771088 
  -83.426407 77.499687 -83.801407 77.464706 -83.833908 77.448868 
  -84.550308 77.401367 -84.615021 77.383034 -84.481956 77.317749 
  -84.479462 77.294418 -84.720016 77.311653 -84.973358 77.377197 
  -85.400017 77.395813 -85.513077 77.435257 -85.491966 77.454147 
  -85.503906 77.474701 -85.718353 77.464706 -85.976143 77.704147 
  -86.461693 77.83609 -87.295029 77.898033 -88.068077 77.820251 
  -88.103912 77.813583 -88.17836 77.795532 -88.171127 77.761917 
  -88.150299 77.72554 -88.223618 77.662483 -88.162247 77.626923 
  -87.694473 77.537201 -87.642517 77.480263 -87.775299 77.44136 
  -87.780289 77.421082 -87.696136 77.35553 -87.391129 77.330544 
  -87.064194 77.366928 -86.831703 77.352203 -87.232803 77.305527 
  -87.19751 77.275253 -87.033363 77.251648 -87.178627 77.213028 
  -87.1828 77.196907 -86.89003 77.164429 -86.833633 77.148323 
  -86.804466 77.127197 -86.911667 77.138313 -87.336937 77.179138 
  -87.436127 77.144699 -87.349457 77.106087 -87.617798 77.094971 
  -87.651962 77.127762 -88.436401 77.117477 -88.436417 77.092194 
  -88.464752 77.065536 -89.533363 76.853592 -89.501106 76.809692 
  -89.400864 76.733582 -89.45697 76.713318 -89.411972 76.680252 
  -89.431396 76.663589 -89.603912 76.621918 -89.667252 76.564423 
  -89.424469 76.559143 -89.414749 76.491928 -89.119743 76.422203 
  -89.045578 76.447479 -89.01503 76.41275 -88.901962 76.40831 
  -88.781418 76.46637 -88.832779 76.498871 -88.775284 76.524406 
  -88.796417 76.550262 -88.688904 76.59137 -88.640297 76.558594 
  -88.658363 76.475807 -88.677254 76.401917 -88.597794 76.405807 
  -88.611969 76.452187 -88.489471 76.503311 -88.521133 76.566093 
  -88.660583 76.599983 -88.58223 76.626923 -88.646133 76.67775 
  -88.696693 76.72554 -88.541946 76.812759 -88.477798 76.807747 
  -88.479752 76.776917 -88.559464 76.727753 -88.478638 76.656082 
  -88.520859 76.617752 -88.353912 76.508591 -88.438629 76.464142 
  -88.36058 76.431091 -88.434464 76.402206 -88.351387 76.384979 
  -87.900864 76.363037 -87.872803 76.407204 -87.81752 76.390533 
  -87.719742 76.343033 -87.571671 76.345543 -87.498917 76.382202 
  -87.430283 76.417763 -87.553093 76.457199 -87.493073 76.50386 
  -87.57196 76.520813 -87.580017 76.611359 -87.537247 76.617477 
  -87.462799 76.586906 -87.50058 76.535248 -87.391113 76.496643 
  -87.423073 76.456917 -87.177254 76.444702 -87.118362 76.420807 
  -87.15419 76.401093 -87.130859 76.38414 -86.711143 76.348038 
  -86.631973 76.448029 -86.655853 76.467194 -86.508072 76.487762 
  -86.305023 76.52803 -86.628906 76.634407) 
#(-103.7006 76.304138 -103.2592 76.342194 -103.0111 76.423309 
  -103.0081 76.44165 -103.0578 76.457748 -103.3845 76.492203 
  -103.5917 76.531372 -103.5594 76.563873 -103.8264 76.618317 
  -103.8789 76.573593 -104.052 76.568863 -103.9225 76.633591 
  -103.94 76.644699 -104.1342 76.669418 -104.6828 76.597473 
  -104.6589 76.545807 -104.3911 76.46109 -104.392 76.421654 
  -104.4609 76.390259 -104.3667 76.387756 -104.3297 76.358032 
  -104.3758 76.348312 -104.335 76.318588 -103.7006 76.304138) 
#(-86.628906 76.634407 -86.22641 76.542763 -86.222519 76.513313 
  -86.41864 76.469147 -86.415024 76.41275 -86.372238 76.386368 
  -85.386963 76.30304 -84.39418 76.308029 -84.397797 76.330544 
  -84.970581 76.426086 -85.051407 76.514137 -85.028641 76.574982 
  -84.97084 76.581917 -84.849182 76.536362 -84.783913 76.469971 
  -84.518913 76.42775 -84.195572 76.45636 -84.180023 76.491928 
  -84.249741 76.536926 -84.218353 76.564972 -84.20253 76.617203 
  -84.331131 76.647476 -84.284737 76.657761 -84.071136 76.616638 
  -84.03363 76.534698 -83.691132 76.428864 -83.256973 76.407471 
  -83.184464 76.424973 -83.223892 76.445534 -83.184189 76.496643 
  -83.254471 76.579422 -83.499191 76.676651 -83.518623 76.713318 
  -83.400864 76.759979 -83.35585 76.752197 -83.388077 76.671082 
  -83.211403 76.626923 -83.075302 76.532761 -83.09169 76.460823 
  -82.779449 76.383324 -82.260567 76.39859 -82.127518 76.44165 
  -82.158363 76.466087 -82.222504 76.532761 -82.093918 76.557213 
  -82.113907 76.572197 -82.435303 76.628036 -82.562523 76.688873 
  -82.556137 76.723038 -82.74614 76.804138 -82.725021 76.819138 
  -82.580307 76.776367 -82.44252 76.684982 -82.292801 76.635529 
  -82.081413 76.631088 -81.861969 76.669144 -82.056961 76.609154 
  -81.981949 76.584702 -82.059464 76.532471 -82.039726 76.509407 
  -81.71669 76.470261 -81.388924 76.481369 -81.208359 76.553589 
  -80.771667 76.419144 -80.761139 76.39415 -81.088074 76.207199 
  -80.953918 76.191093 -81.07724 76.158043 -81.090302 76.137482 
  -81.05336 76.128036 -79.781418 76.280807 -79.273064 76.304138 
  -79.229752 76.368027 -78.93808 76.449982 -78.790573 76.57164 
  -78.565582 76.563873 -78.607788 76.486649 -78.443359 76.452187 
  -78.138924 76.525818 -78.17836 76.566093 -78.013641 76.630814 
  -77.861969 76.6297 -77.76947 76.65831 -77.789467 76.781647 
  -77.715027 76.821091 -77.890289 76.862762 -77.835297 76.886917 
  -77.906403 76.911636 -77.881126 76.940262 -77.928909 76.96637 
  -78.140846 77.019974 -78.344193 77.007751 -78.56308 76.933029 
  -78.56752 76.887192 -78.720306 76.878593 -78.712517 76.823303 
  -78.963913 76.848038 -78.894203 76.903313 -78.954468 76.935257 
  -79.372238 76.923309 -79.376694 76.957474 -79.003906 77.103592 
  -79.041962 77.161087 -79.25502 77.218582 -79.725861 77.239967 
  -80.013351 77.190536 -80.20697 77.108582 -80.39447 77.072746 
  -80.401962 77.086639 -80.136963 77.186081 -80.155006 77.208038 
  -81.10585 77.283043 -81.784363 77.160721) 
#(96.35054 76.097473 95.263603 76.213028 95.309143 76.25386 
  95.377762 76.285248 95.599136 76.238861 95.785248 76.298309 
  96.06636 76.273857 96.064148 76.236923 96.10553 76.229424 
  96.20665 76.286636 96.339417 76.303864 96.644417 76.262756 
  96.570534 76.184143 96.592194 76.152763 96.536087 76.159149 
  96.523323 76.193588 96.562759 76.231087 96.376373 76.267761 
  96.348038 76.240807 96.408859 76.203033 96.245796 76.203873 
  96.405807 76.165817 96.362473 76.137756 96.343582 76.119713 
  96.35054 76.097473) #(-103.2358 76.046654 -102.5292 76.153587 
  -102.5839 76.183594 -102.5311 76.223312 -102.6522 76.28775 
  -103.8764 76.248581 -104.4542 76.164429 -104.4783 76.135803 
  -104.3911 76.078308 -103.8697 76.04747 -103.2358 76.046654) 
#(83.209427 75.913857 82.268593 75.952759 82.279419 75.969704 
  82.653587 75.993027 83.294693 75.948029 83.286926 75.928864 
  83.209427 75.913857) #(-60.115559 75.997414 -60.515011 76.064972 
  -60.738338 75.993317 -60.904171 76.086906 -60.830841 76.109154 
  -60.86195 76.150528 -61.29945 76.175262 -61.462791 76.164978 
  -61.743622 76.198868 -62.180851 76.222198 -62.172508 76.243591 
  -62.239731 76.286636 -62.6264 76.262756 -62.775291 76.23497 
  -62.730839 76.21109 -62.7789 76.193588 -62.8564 76.244141 
  -62.82085 76.274406 -62.853901 76.29776 -63.059731 76.339417 
  -63.4814 76.370247 -63.504459 76.311081 -63.745289 76.199692 
  -63.72501 76.175812 -64.012512 76.134697 -64.138924 76.157471 
  -64.215302 76.260529 -64.166412 76.315262 -64.31752 76.353027 
  -64.426407 76.344971 -64.36586 76.279137 -64.433067 76.233032 
  -64.68335 76.258591 -64.678627 76.219421 -64.571693 76.169983 
  -64.698067 76.168587 -64.603912 76.126923 -64.694473 76.119713 
  -64.845306 76.17247 -65.021133 76.174423 -64.975021 76.108307 
  -65.238907 76.135246 -65.200302 76.165253 -65.212799 76.182213 
  -65.358917 76.169418 -65.319473 76.148033 -65.363907 76.129433 
  -65.295578 76.071373 -65.366966 76.023033 -65.630577 76.029984 
  -65.888641 76.099701 -65.749741 76.148033 -65.771133 76.204697 
  -65.586411 76.228027 -65.680298 76.264977 -66.177254 76.281921 
  -66.21225 76.223587 -66.407806 76.147202 -66.363907 76.108307 
  -66.397522 76.086906 -66.50946 76.089142 -66.756973 76.17804 
  -66.670303 76.211357 -66.810577 76.216919 -66.819183 76.241364 
  -67.031967 76.262756 -67.281128 76.19136 -67.304749 76.16275 
  -67.040573 76.133034 -67.011139 76.099136 -67.059738 76.074982 
  -66.617798 75.981087 -66.451424 75.913307 -66.503632 75.908859 
  -68.517242 76.09137 -68.569748 76.118874 -68.448639 76.136642 
  -68.474747 76.156647 -68.809189 76.160812 -68.748917 76.186653 
  -68.926971 76.218872 -68.912521 76.242752 -69.325577 76.298576 
  -69.633636 76.380814 -69.569473 76.435806 -69.065582 76.481644 
  -68.711411 76.58609 -68.030579 76.579147 -67.982803 76.599426 
  -67.986397 76.620796 -68.095581 76.651367 -68.021408 76.666924 
  -68.092529 76.704971 -68.785583 76.657204 -70.008072 76.763603 
  -70.079742 76.791924 -70.083359 76.823029 -69.892517 76.875809 
  -69.89975 76.897751 -69.539467 77.000526 -69.672523 77.012482 
  -70.378082 76.794144 -70.519203 76.786636 -70.922523 76.864433 
  -70.98085 76.900528 -70.833633 76.900253 -70.683067 76.937187 
  -71.245033 76.959427 -71.380287 77.019699 -71.366966 77.06192 
  -71.224472 77.074692 -71.194183 77.133324 -70.696693 77.149406 
  -70.924469 77.1772 -70.895859 77.189423 -69.944473 77.239151 
  -68.613907 77.169144 -67.944183 77.199417 -66.396408 77.107758 
  -66.412247 77.126083 -66.440308 77.144974 -66.190018 77.174423 
  -66.193077 77.194977 -66.916702 77.173737 -67.950851 77.221359 
  -68.190857 77.202187 -69.047813 77.25386 -69.087799 77.275528 
  -68.393356 77.372482 -67.620033 77.386368 -66.824188 77.357758 
  -66.525864 77.277481 -66.220581 77.250259 -66.208076 77.269699 
  -66.500847 77.312469 -66.656693 77.415817 -66.521133 77.434418 
  -66.219742 77.421371 -66.101967 77.438309 -66.073349 77.46637 
  -66.231407 77.55275 -66.161682 77.562759 -66.238632 77.592484 
  -66.28363 77.613037 -66.506973 77.626648 -66.724747 77.685532 
  -66.661301 77.714111) #(-18.64584 75.891373 -18.58806 75.902763 
  -18.54917 76.02359 -18.625 76.127197 -18.611111 76.23497 
  -18.692499 76.309982 -18.72278 76.509979 -18.649719 76.613861 
  -18.679449 76.654419 -18.922779 76.748032 -19.031389 76.756363 
  -19.081671 76.722748 -18.992229 76.633614 -19.002501 76.607193 
  -18.78306 76.61026 -18.788891 76.581093 -19.065559 76.591637 
  -19.14222 76.529419 -19.101391 76.466919 -18.89222 76.293297 
  -18.89389 76.22081 -18.63389 75.977478 -18.64584 75.891373) 
#(-120.3781 75.806641 -120.2697 75.821907 -120.1492 75.896362 
  -120.0258 75.839981 -119.77 75.87915 -119.7219 75.905258 
  -119.6069 75.911087 -119.7033 75.942749 -119.6369 75.992203 
  -119.4811 75.97081 -119.4739 76.018593 -119.5039 76.040817 
  -119.6747 76.085251 -119.7931 76.114433 -119.5528 76.117752 
  -119.672 76.140259 -119.692 76.162483 -119.5728 76.16304 
  -119.5728 76.186371 -119.705 76.262192 -119.6583 76.26886 
  -119.6597 76.308868 -119.7139 76.33165 -119.4819 76.35498 
  -119.4561 76.255539 -119.2953 76.186081 -119.3083 76.149979 
  -119.2453 76.111359 -119.0758 76.083313 -118.8864 76.17804 
  -118.9367 76.217194 -118.8767 76.277481 -118.6375 76.28804 
  -118.5661 76.343033 -118.5942 76.383873 -118.6978 76.449417 
  -118.9553 76.483032 -118.9681 76.505249 -118.8742 76.525818 
  -118.5461 76.499977 -118.2995 76.563583 -118.495 76.712196 
  -118.3042 76.717484 -118.3253 76.751923 -118.3195 76.773033 
  -117.9606 76.769974 -117.8881 76.818863 -117.8167 76.821373 
  -117.7386 76.784149 -117.7475 76.766083 -117.9283 76.676651 
  -117.9042 76.630539 -117.9733 76.596359 -117.9539 76.562759 
  -117.9042 76.528313 -118.0275 76.484703 -117.9908 76.462479 
  -118.06 76.409149 -117.575 76.26886 -117.3456 76.256363 
  -117.0956 76.295258 -116.9375 76.358032 -117.0025 76.431923 
  -116.9836 76.454971 -117.0728 76.503036 -116.9947 76.545807 
  -116.0931 76.619141 -115.8947 76.703308 -115.9692 76.756363 
  -116.3556 76.903313 -116.3272 76.935532 -115.8533 76.897202 
  -115.7461 76.925262 -115.755 76.960823 -116.2425 77.044144 
  -116.3906 77.139977 -115.8778 77.215263 -115.3892 77.312187 
  -115.4953 77.359421 -115.8622 77.429428 -116.4169 77.556923 
  -116.7694 77.516373 -116.8042 77.493591 -117.1531 77.451637 
  -116.9947 77.394417 -116.6628 77.391647 -116.6517 77.377762 
  -116.8483 77.315811 -117.1428 77.361359 -117.182 77.340263 
  -117.1056 77.339981 -117.0078 77.294144 -117.062 77.291924 
  -117.5128 77.333313 -118.6511 77.360527 -119.1533 77.325813 
  -119.2958 77.276642 -119.3892 77.184418 -120.4286 76.862762 
  -120.3653 76.83609 -120.4197 76.793297 -121.2147 76.66803 
  -121.2264 76.612762 -121.412 76.553864 -121.422 76.493591 
  -121.55 76.434692 -122.2464 76.409416 -122.6264 76.336357 
  -122.6517 76.257477 -122.8428 76.227203 -122.8586 76.17804 
  -122.9422 76.182213 -123.0056 76.093582 -122.8428 76.131088 
  -122.8422 76.14859 -122.6203 76.174423 -122.5625 76.154694 
  -122.5897 76.134697 -122.4711 76.11026 -122.5439 76.046921 
  -122.58 76.023323 -122.5764 76.007477 -122.7289 75.973038 
  -122.6761 75.951637 -122.4164 75.928589 -122.1267 75.98053 
  -122.1342 76.036362 -121.8481 76.039703 -121.285 75.909973 
  -121.2595 75.964417 -120.9992 75.994423 -121.0111 75.97081 
  -120.9995 75.939697 -120.932 75.959976 -121.0228 76.059143 
  -121.0125 76.139137 -120.9564 76.17775 -120.8572 76.19664 
  -120.6592 76.142471 -120.7431 76.117752 -120.7464 76.093872 
  -120.6486 76.099701 -120.7311 76.057747 -120.7161 76.024406 
  -120.5939 75.978027 -120.4675 76.012192 -120.3845 75.967758 
  -120.4897 75.849983 -120.4669 75.821091 -120.3781 75.806641) 
#(-79.403923 75.804138 -79.420303 75.848038 -79.319458 75.873581 
  -79.021683 75.867477 -79.067787 75.840263 -78.964752 75.842194 
  -78.881683 75.853317 -79.168327 75.931923 -79.176407 75.952759 
  -79.144737 75.97525 -78.845863 76.04747 -78.79808 76.086357 
  -78.893082 76.11554 -79.456703 75.983032 -79.597237 75.902481 
  -79.745033 75.8797 -79.567253 75.84581 -79.593079 75.8172 
  -79.403923 75.804138) #(-103.3014 75.744713 -102.8972 75.745529 
  -102.5092 75.789429 -102.3942 75.880814 -101.9889 75.934418 
  -102.1914 75.9897 -102.8697 75.923309 -103.3114 75.805252 
  -103.2469 75.797203 -103.3539 75.774979 -103.3014 75.744713) 
#(-118.5831 75.49942 -118.2039 75.598862 -118.2636 75.616928 
  -117.9275 75.734421 -117.9564 75.759979 -117.9372 75.785248 
  -117.5731 75.981918 -117.4714 76.088867 -117.6231 76.114433 
  -118.105 76.023857 -118.1683 75.968307 -118.4044 75.960823 
  -118.7169 75.882751 -119.3975 75.618317 -119.3403 75.579422 
  -118.8778 75.553307 -118.9275 75.529419 -118.5831 75.49942) 
#(135.7708 75.370796 135.4483 75.378448 135.4436 75.386368 
  135.59 75.563309 135.5397 75.669983 135.698 75.867752 
  135.7683 75.809418 135.8205 75.744713 135.92191 75.674698 
  136.1777 75.619141 136.1727 75.601089 135.9622 75.508034 
  135.9558 75.478027 136.02721 75.443314 136.0127 75.424973 
  135.7708 75.370796) #(81.974983 75.174423 81.891083 75.213028 
  81.895248 75.274979 81.815811 75.320534 81.718307 75.275253 
  81.636093 75.285812 81.493027 75.358307 81.550537 75.385246 
  81.79303 75.461357 81.726089 75.412201 81.774406 75.374153 
  81.956093 75.405258 81.867477 75.443039 81.947479 75.463318 
  81.907761 75.493317 82.13942 75.517471 82.149887 75.496048 
  82.137482 75.440536 82.222198 75.399979 82.279419 75.325256 
  82.039139 75.340263 82.009407 75.185806 81.974983 75.174423) 
#(-21.72784 77.525742 -21.495001 77.603317 -21.25861 77.643593 
  -21.39806 77.690262 -21.367229 77.807213 -21.043329 77.969971 
  -20.854719 78.014977 -20.5975 77.969971 -20.603889 77.933296 
  -20.040001 77.834427 -19.42639 77.788857 -19.209169 77.751923 
  -18.958611 77.626373 -19.303341 77.580261 -19.466669 77.598312 
  -19.967501 77.712479 -20.25695 77.729141 -20.41028 77.699417 
  -20.59778 77.722214 -20.914169 77.663307 -20.34584 77.599136 
  -20.24556 77.554703 -20.480829 77.568314 -20.653339 77.546654 
  -20.374451 77.53804 -20.42861 77.501923 -21.05361 77.543869 
  -20.174999 77.458588 -20.75111 77.419159 -20.7225 77.403313 
  -19.80584 77.397476 -19.484449 77.342484 -19.39806 77.29747 
  -19.446671 77.267761 -19.42083 77.239967 -19.011391 77.230263 
  -19.077499 77.323303 -18.963341 77.386368 -18.38611 77.338028 
  -18.41806 77.310806 -18.286671 77.305817 -18.23222 77.277481 
  -18.12389 76.943314 -18.219999 76.871094 -18.51889 76.809692 
  -18.46167 76.760803 -18.466391 76.742203 -18.92 76.856918 
  -19.135 76.846359 -19.871389 76.959702 -20.782499 76.984421 
  -21.035839 76.943588 -20.69972 76.954422 -20.58083 76.919144 
  -20.799721 76.868591 -21.116949 76.899139 -21.692499 76.888313 
  -21.708059 76.875259 -21.28056 76.863861 -20.78528 76.836357 
  -21.068609 76.785812 -21.186951 76.804703 -21.618059 76.660248 
  -21.623341 76.642761 -21.74889 76.659149 -21.938339 76.766922 
  -22.103889 76.797203 -22.14139 76.838318 -22.26722 76.858582 
  -22.472231 76.827477 -22.344999 76.770248 -22.31917 76.743591 
  -22.61278 76.743591 -22.72945 76.710533 -22.707781 76.67247 
  -22.46056 76.640533 -22.512501 76.601089 -22.329439 76.511368 
  -22.28528 76.524429 -22.338341 76.58136 -22.16028 76.639687 
  -21.907499 76.618317 -21.809999 76.580544 -22.06695 76.553864 
  -22.031389 76.532204 -21.788059 76.554428 -21.680559 76.519974 
  -22.028891 76.472748 -22.010281 76.459702 -21.70084 76.495529 
  -21.67445 76.478027 -21.74029 76.447739 -21.922159 76.447891 
  -22.216249 76.452698 -22.34528 76.496918 -22.434719 76.492477 
  -22.35722 76.465813 -22.39056 76.449142 -21.57333 76.436653 
  -21.55722 76.379433 -21.70723 76.249977 -21.682501 76.239151 
  -21.49806 76.219971 -21.446951 76.255539 -21.37945 76.289978 
  -21.090561 76.277206 -20.67889 76.161087 -20.420561 76.137756 
  -21.07667 76.288589 -20.906111 76.304977 -20.43445 76.220543 
  -19.929729 76.258591 -19.80584 76.228592 -19.666389 76.126923 
  -19.71806 76.059418 -20.39806 75.978867 -21.78056 75.981644 
  -21.940001 76.041924 -21.980829 75.989151 -21.88139 75.958862 
  -19.93556 75.930527 -19.353609 75.722473 -19.56806 75.729713 
  -19.61195 75.673576 -19.39056 75.554138 -19.33556 75.404984 
  -19.41028 75.236076 -19.610001 75.133034 -19.898331 75.147202 
  -20.004999 75.187187 -20.00695 75.233871 -19.98667 75.294418 
  -20.307501 75.335533 -20.495001 75.296654 -20.70583 75.295807 
  -21.182779 75.40831 -21.275 75.486923 -21.708611 75.595261 
  -22.25111 75.664139 -22.273609 75.64386 -21.764999 75.557213 
  -21.406389 75.454697 -22.114849 75.480743 -22.452971 75.533707 
  -22.477409 75.554062) #(-104.2292 75.018044 -103.7995 75.077477 
  -103.5833 75.164703 -103.6031 75.179977 -103.7497 75.234703 
  -103.7339 75.274139 -103.8142 75.330811 -103.8033 75.36026 
  -104.1553 75.434982 -104.4281 75.420807 -104.7686 75.281921 
  -104.6881 75.259697 -104.9222 75.146088 -104.7061 75.0672 
  -104.2292 75.018044) #(-99.88028 74.978317 -99.426392 74.991364 
  -99.496948 75.026367 -99.325844 75.118317 -99.272507 75.115807 
  -99.392792 75.022476 -99.354446 74.984421 -98.928337 75.012192 
  -98.960564 75.051933 -98.837784 75.058594 -98.861954 75.033043 
  -98.724167 74.989433 -97.946121 75.026642 -97.960007 75.095543 
  -98.08168 75.130539 -98.146667 75.180817 -98.025848 75.210823 
  -98.025009 75.162483 -97.820282 75.111076 -97.582497 75.137482 
  -97.597778 75.164703 -97.800293 75.193863 -97.743622 75.224983 
  -97.9039 75.305252 -97.936951 75.263313 -97.991959 75.284698 
  -97.89418 75.329422 -98.006119 75.319702 -98.048073 75.284698 
  -98.129181 75.301933 -98.080566 75.329971 -98.165283 75.334137 
  -98.107788 75.371918 -98.069458 75.349701 -97.872787 75.370796 
  -97.99501 75.388603 -97.84584 75.411362 -97.783073 75.428307 
  -98.055557 75.452477 -97.943336 75.467194 -98.041687 75.483307 
  -97.86557 75.507477 -97.807533 75.45665 -97.743347 75.471916 
  -97.824448 75.550537 -97.487503 75.496094 -97.487228 75.433029 
  -97.34169 75.39386 -97.281113 75.396927 -97.398071 75.452477 
  -97.424179 75.528587 -97.37001 75.670807 -97.425568 75.6922 
  -97.87056 75.73053 -97.930557 75.746918 -97.664459 75.793297 
  -97.559448 75.870796 -97.644737 75.950531 -97.49501 76.14386 
  -97.523064 76.205811 -97.77919 76.325256 -97.662514 76.419418 
  -97.695847 76.460823 -97.662781 76.481087 -97.76474 76.510529 
  -98.338348 76.562759 -98.395844 76.594421 -98.431122 76.629967 
  -98.404167 76.661362 -98.504997 76.681091 -98.84584 76.67276 
  -98.814178 76.653587 -98.725571 76.610809 -98.815002 76.613586 
  -99.027237 76.601089 -99.050842 76.536087 -98.993057 76.52803 
  -98.875839 76.441933 -98.882782 76.431374 -98.980827 76.471649 
  -99.137512 76.45192 -99.066116 76.39859 -99.184448 76.415817 
  -99.256958 76.470543 -99.14389 76.501648 -99.33168 76.509407 
  -99.498062 76.580544 -100.0995 76.634407 -100.3845 76.628311 
  -100.9628 76.510246 -100.9725 76.48526 -100.6986 76.376083 
  -100.3236 76.38414 -100.1703 76.35553 -100.015 76.316933 
  -100.465 76.274979 -100.5131 76.249153 -100.4389 76.212479 
  -100.0011 76.20192 -99.829727 76.16304 -99.414459 76.15831 
  -99.714447 76.114433 -99.843903 76.139977 -100.2208 76.132202 
  -100.112 76.101357 -100.0775 76.038857 -99.879997 75.972748 
  -99.859734 75.935257 -99.469452 75.974701 -99.457497 75.961357 
  -99.801392 75.90387 -100.1503 75.913857 -100.0714 75.945534 
  -100.335 76.053864 -100.7411 76.094704 -100.632 76.115807 
  -100.6303 76.133324 -100.9283 76.225807 -101.1406 76.24025 
  -101.0681 76.331917 -101.4831 76.437759 -101.8861 76.444977 
  -102.052 76.386368 -101.9575 76.357483 -102.0975 76.341637 
  -102.0636 76.283577 -102.0639 76.255249 -102.16 76.243027 
  -102.052 76.213593 -101.3961 76.243317 -101.7611 76.174149 
  -101.9022 76.107758 -101.9006 76.06665 -101.8192 76.011368 
  -101.6664 75.979424 -101.3922 76.000526 -101.5978 75.919693 
  -101.5272 75.858307 -101.3781 75.851929 -101.3253 75.813309 
  -101.3478 75.774979 -101.0325 75.792763 -101.2811 75.74498 
  -101.4689 75.766373 -101.4561 75.810806 -101.8645 75.902206 
  -102.2903 75.857193 -102.3625 75.818039 -102.3439 75.781921 
  -102.0919 75.785248 -102.237 75.744141 -102.052 75.704147 
  -102.0789 75.688309 -102.4022 75.726929 -102.6892 75.670532 
  -102.6322 75.6147 -102.8606 75.628311 -102.867 75.601089 
  -102.7289 75.572479 -102.7653 75.538307 -102.5997 75.493317 
  -102.352 75.542213 -101.1986 75.591087 -99.817497 75.655258 
  -99.863068 75.614433 -99.686111 75.613861 -99.712784 75.589142 
  -100.2833 75.514977 -99.986679 75.499687 -99.973068 75.488312 
  -100.5845 75.426361 -100.4328 75.375259 -100.5119 75.36525 
  -100.6764 75.376648 -100.7656 75.346359 -100.5003 75.29248 
  -100.2572 75.313309 -100.2794 75.286636 -100.3795 75.27359 
  -100.3542 75.251648 -100.0095 75.242203 -100.0078 75.228027 
  -100.4633 75.223587 -100.5447 75.193039 -100.3981 75.158577 
  -100.3897 75.031082 -100.3283 75.01387 -99.88028 74.978317) 
#(-17.60611 74.933296 -17.34972 75.02803 -17.40028 75.072197 
  -17.327221 75.142197 -17.41445 75.161362 -17.610279 75.13887 
  -17.58334 75.104141 -17.715839 75.078873 -17.87528 75.10025 
  -18.05945 75.178307 -18.01861 75.231087 -18.191111 75.216637 
  -18.188061 75.241089 -17.96917 75.258034 -17.808611 75.306091 
  -17.809719 75.31665 -17.968889 75.400528 -18.105829 75.413857 
  -18.15028 75.324417 -18.362499 75.301361 -18.55278 75.373581 
  -18.950001 75.325531 -18.843889 75.278587 -18.83556 75.14859 
  -18.916389 75.095543 -18.920561 75.027206 -18.86945 74.998032 
  -17.99667 75.029984 -17.600281 74.989151 -17.626949 74.947479 
  -17.60611 74.933296) #(-107.7717 75.095543 -107.6795 75.048576 
  -107.7167 75.010529 -107.4642 74.934418 -107.0061 74.92247 
  -106.8625 74.960823 -106.2353 75.021362 -105.9942 75.062187 
  -106.0795 75.096916 -106.0517 75.117477 -105.8853 75.140259 
  -105.8442 75.183296 -105.9292 75.197746 -105.8753 75.271088 
  -105.6464 75.36525 -105.7142 75.416367 -105.5928 75.467484 
  -105.6458 75.473038 -105.7408 75.49498 -105.4964 75.555252 
  -105.3883 75.656372 -105.4533 75.841637 -105.6064 75.934692 
  -105.8372 75.996918 -106.3167 76.052467 -106.6389 76.05304 
  -106.8933 75.947479 -106.8772 75.870529 -106.87 75.824982 
  -106.6158 75.797203 -106.8306 75.785812 -106.8967 75.720261 
  -106.8881 75.66748 -106.9017 75.649139 -106.9631 75.702759 
  -106.9511 75.747482 -107.105 75.834702 -107.0483 75.890533 
  -107.2342 75.908043 -107.7217 75.880539 -107.8933 75.793297 
  -108.0242 75.783859 -108.015 75.832199 -107.6331 75.981369 
  -107.6597 76.0047 -107.8847 76.06192 -108.4644 76.037201 
  -108.3842 76.086639 -108.4567 76.099136 -108.3314 76.181923 
  -108.1583 76.205544 -108.0931 76.226639 -108.2314 76.249153 
  -108.0775 76.280533 -108.3289 76.396637 -108.6075 76.410538 
  -108.61 76.428589 -108.4819 76.455811 -108.5903 76.481918 
  -108.5306 76.515533 -108.6283 76.517761 -108.5289 76.553864 
  -108.6272 76.575531 -108.7036 76.623032 -108.7042 76.646362 
  -108.5656 76.641647 -108.442 76.696373 -108.4464 76.723587 
  -108.5039 76.756088 -108.6925 76.769974 -108.6556 76.817467 
  -108.7886 76.857193 -108.9189 76.809418 -109.1831 76.819427 
  -109.4547 76.732483 -109.5225 76.685532 -109.8472 76.532471 
  -109.7242 76.531647 -109.767 76.501373 -110.385 76.421082 
  -110.3614 76.372757 -110.3728 76.294418 -110.2017 76.285538 
  -110.0378 76.233871 -109.8878 76.204697 -109.8342 76.236076 
  -109.5217 76.181091 -109.305 76.10054 -109.3803 76.08165 
  -109.2808 76.039429 -109.4214 76.035812 -109.4092 76.007202 
  -110.0247 75.900528 -109.9383 75.856918 -109.6572 75.866364 
  -109.6983 75.839981 -108.9733 75.715263 -108.9267 75.67804 
  -108.8361 75.612762 -109.0267 75.553589 -108.9245 75.523857 
  -108.8994 75.476357 -109.2539 75.514137 -110.1958 75.538589 
  -110.4956 75.569138 -110.8625 75.551086 -111.2714 75.522476 
  -111.4083 75.620796 -111.3553 75.724426 -111.4517 75.742203 
  -111.4392 75.776367 -111.5258 75.793587 -111.58 75.813873 
  -112.2256 75.811081 -112.187 75.844971 -112.0522 75.878036 
  -111.7775 75.894699 -111.7267 75.915817 -111.7639 75.946907 
  -112.4134 76.04248 -112.5261 76.110527 -112.4277 76.166313) 
#(-79.330757 74.8965 -79.509193 74.959427 -79.50502 74.998306 
  -79.795303 75.027481 -80.24086 74.94664 -80.27919 74.959427 
  -80.216423 74.976089 -80.440582 75.03804 -79.960571 75.094704 
  -79.929466 75.140533 -79.62973 75.174973 -79.45253 75.271362 
  -79.587799 75.287483 -79.610023 75.310806 -79.527527 75.322197 
  -79.488083 75.383324 -79.622238 75.402481 -79.675858 75.44136 
  -79.733353 75.471916 -80.320572 75.455811 -80.371964 75.468872 
  -80.150017 75.497482 -79.953918 75.540253 -80.089752 75.545532 
  -80.068359 75.578873 -80.317253 75.630539 -81.271133 75.651367 
  -81.276962 75.668297 -81.111969 75.747192 -81.118073 75.775528 
  -82.14003 75.82692 -82.542793 75.819138 -83.099747 75.732193 
  -83.698639 75.790253 -83.72197 75.810806 -83.767242 75.824142 
  -83.920853 75.803589 -84.022507 75.767197 -84.652252 75.675262 
  -85.013077 75.640259 -85.09169 75.626373 -85.20253 75.598038 
  -85.924179 75.542213 -86.154457 75.500809 -86.110001 75.481918 
  -86.082497 75.421371 -86.376129 75.376373 -86.615593 75.36554 
  -86.36586 75.423309 -86.483353 75.45665 -86.807533 75.479141 
  -87.214188 75.612473 -87.513351 75.559418 -87.509193 75.534149 
  -87.430557 75.501083 -87.500313 75.452187 -87.606407 75.449692 
  -87.49556 75.485809 -87.544456 75.497757 -87.648354 75.56192 
  -87.748917 75.578308 -88.213074 75.470543 -88.305847 75.492203 
  -88.240837 75.50914 -88.203918 75.531082 -88.600861 75.659416 
  -88.754997 75.676651 -88.757523 75.644974 -88.902237 75.604713 
  -88.747803 75.47081 -88.767517 75.434143 -88.964172 75.431923 
  -89.217239 75.584976 -89.403641 75.587196 -89.551132 75.548859 
  -89.568077 75.56192 -89.56752 75.585823 -89.253906 75.631088 
  -89.18335 75.731644 -89.172813 75.780533 -89.439194 75.845261 
  -89.547234 75.842758 -89.656967 75.829147 -89.692497 75.796371 
  -89.776413 75.792763 -89.687813 75.899979 -89.944733 75.971359 
  -89.947533 76.007202 -90.066391 75.999977 -90.116119 75.933594 
  -90.339752 75.968307 -90.530006 75.898323 -90.526123 75.930527 
  -90.44252 75.959702 -90.464752 75.978592 -90.733612 75.959702 
  -90.681122 75.981369 -90.7939 75.994713 -90.903084 75.924698 
  -91.044167 75.901642 -91.091667 75.843307 -91.136139 75.846077 
  -91.118896 75.913857 -90.942253 75.945534 -90.950562 75.962196 
  -91.039459 75.980797 -91.030006 75.996918 -90.233917 76.041092 
  -90.194473 76.062759 -90.575287 76.090263 -90.706413 76.057213 
  -90.862518 76.069977 -90.678627 76.108032 -90.700562 76.119423 
  -91.40863 76.151367 -91.253082 76.198029 -90.122528 76.125259 
  -90.064194 76.136917 -90.438606 76.162201 -90.41835 76.179428 
  -90.198349 76.170532 -89.349731 76.183594 -89.192497 76.236076 
  -89.208633 76.260803 -89.305573 76.299149 -90.73085 76.421921 
  -91.402527 76.457474 -91.564194 76.500809 -91.414726 76.512756 
  -90.826424 76.463028 -90.538094 76.461357 -90.468918 76.479141 
  -90.514717 76.508324 -90.563629 76.559692 -91.009193 76.651642 
  -91.535843 76.688873 -92.011383 76.656647) 
#(86.92247 74.818314 86.335823 74.845543 86.236649 74.888313 
  86.237762 74.917213 86.56636 74.894699 86.593307 74.909973 
  86.503036 74.928864 86.499153 74.97998 86.623032 74.97081 
  86.631363 74.946373 87.027267 74.985863 87.137482 74.936081 
  87.081917 74.899139 86.952759 74.873581 86.870247 74.902763 
  86.704147 74.906082 86.689697 74.886642 86.823593 74.845261 
  86.937187 74.84053 86.92247 74.818314) 
#(149.6958 74.760803 148.68159 74.760803 148.1274 74.813309 
  147.7813 74.907471 147.27251 74.973587 146.89079 75.0672 
  146.53799 75.130539 146.0808 75.214706 146.0722 75.232758 
  146.2411 75.410538 146.2675 75.433868 146.405 75.467758 
  146.3358 75.504967 146.3494 75.546654 146.3891 75.580544 
  146.5054 75.589447 146.7722 75.501083 146.6786 75.479141 
  146.6394 75.419983 147.0183 75.334702 147.308 75.348312 
  147.3322 75.362198 147.2486 75.367752 147.4366 75.392471 
  147.3602 75.417213 147.45441 75.438873 148.43269 75.409973 
  148.5724 75.36998 148.44411 75.295258 148.4525 75.271088 
  148.6008 75.211357 149.3261 75.284416 150.1483 75.218872 
  150.19611 75.193039 150.158 75.152763 150.5569 75.122757 
  150.4666 75.09581 150.5219 75.093582 150.6644 75.129433 
  150.6638 75.15387 150.82719 75.158577 150.953 75.13942 
  150.6416 74.996094 150.688 74.936081 150.60361 74.884407 
  149.9919 74.829697 149.6958 74.760803) 
#(85.661362 74.714981 85.10553 74.743591 85.137482 74.762482 
  85.470467 74.812698 85.642761 74.796654 85.681091 74.74054 
  85.661362 74.714981) #(-20.189171 74.70192 -20.027229 74.716087 
  -19.743059 74.847198 -19.745279 74.876923 -20.003611 74.920532 
  -20.13583 74.91748 -19.96056 74.986076 -19.993059 75.008873 
  -20.230829 75.041656 -20.46139 75.038307 -20.5975 74.991653 
  -20.541109 74.92804 -20.55584 74.892761 -20.68445 74.806374 
  -20.45084 74.73111 -20.189171 74.70192) 
#(56.97411 74.689011 56.58017 74.700287 56.50943 74.748871 
  56.43111 74.738586 56.420269 74.756927 56.48138 74.779419 
  56.475552 74.794144 56.060001 74.776917 55.82972 74.796082 
  55.842499 74.828033 56.6236 74.945824 56.344151 74.934418 
  56.470829 75.015808 56.41888 75.034973 55.987209 74.989151 
  55.859711 74.998581 55.928051 75.053864 55.908878 75.084137 
  55.72694 75.079147 55.80888 75.152481 56.078609 75.214142 
  56.119438 75.186081 56.37582 75.184692 56.47332 75.097748 
  56.447769 75.063309 56.51778 75.069977 56.914162 75.246918 
  56.875271 75.281372 56.751381 75.284149 56.73167 75.301361 
  56.850269 75.35553 57.079441 75.38887 57.55471 75.328583 
  57.733879 75.329147 57.50333 75.492477 57.571381 75.516083 
  58.188881 75.58165 58.153049 75.622757 57.922218 75.628311 
  58.001381 75.674149 58.30249 75.693588 58.733601 75.796921 
  58.78944 75.838867 59.264999 75.885529 60.337212 75.995796 
  60.334431 76.014137 60.040821 76.046921 60.1586 76.075813 
  60.55777 76.127197 60.830818 76.111076 60.478321 76.022476 
  60.490829 76.008324 61.083321 76.074982 61.13776 76.1147 
  61.148041 76.140259 60.945541 76.136917 60.900829 76.152481 
  61.024429 76.21553 60.989429 76.243874 61.06638 76.273857 
  61.446941 76.292213 62.40749 76.255249 62.373051 76.222473 
  62.427212 76.184143 62.636379 76.203873 62.665539 76.232758 
  62.834991 76.260529 62.86721 76.227203 63.02499 76.214981 
  63.71777 76.345543 64.109703 76.311371 64.309143 76.35997 
  64.67247 76.378311 64.670532 76.420807 64.844704 76.479141 
  65.161362 76.468307 65.548576 76.582199 65.992889 76.528519) 
#(139.05051 74.648033 138.11549 74.782471 137.8658 74.857193 
  137.78191 74.981087 137.14079 75.132202 136.9108 75.271927 
  136.8683 75.361359 137.0238 75.388313 137.21989 75.329697 
  137.405 75.352203 137.4247 75.400528 137.39439 75.410812 
  137.25 75.421082 137.1738 75.397476 137.13049 75.423309 
  137.188 75.470543 137.2836 75.468033 137.26801 75.500259 
  137.1908 75.529137 137.1861 75.55304 137.29021 75.595543 
  137.1402 75.649696 136.96629 75.607742 136.9866 75.578583 
  136.9613 75.608032 137.15359 75.655807 137.16299 75.679977 
  137.0719 75.72525 137.18159 75.780258 137.30161 75.787483 
  137.73579 75.743317 137.71471 75.783577 137.43021 75.877197 
  137.4247 75.906921 137.45 75.954697 137.71021 76.008591 
  138.0033 76.019417 138.0961 76.056091 138.1125 76.079971 
  138.07269 76.080811 138.3736 76.155533 138.3847 76.072479 
  138.4502 76.061081 138.50079 76.168297 138.63519 76.204697 
  138.87469 76.217484 139.02299 76.124687 139.1908 76.072197 
  139.81689 75.969971 139.90691 75.925262 139.8336 75.926086 
  139.82159 75.873871 140.1302 75.812469 140.1358 75.788857 
  140.24409 75.824142 140.4386 75.811081 140.5455 75.763603 
  140.5361 75.7397 140.46381 75.709976 140.4449 75.680252 
  140.455 75.639687 140.9111 75.608582 141.06081 75.645248 
  140.8647 75.737198 140.89909 75.77887 140.8766 75.90387 
  140.9222 76.0047 141.0164 76.049698 141.21359 76.056374 
  141.5797 75.999687 141.62 76.018593 141.3313 76.166367 
  141.3566 76.180527 141.705 76.117752 142.5602 75.857758 
  143.1613 75.806641 143.35941 75.829971 143.3855 75.84137 
  143.5844 75.866928 143.9241 75.833313 145.30251 75.566933 
  145.39301 75.511368 145.05769 75.490807 144.70551 75.412201 
  144.6777 75.352753 144.6808 75.324142 144.90359 75.287201 
  144.93111 75.26387 144.7299 75.250259 144.6955 75.160812 
  144.3483 75.044418 143.94971 75.026917 143.7119 75.077759 
  143.36549 75.0672 143.0511 75.118317 142.49271 75.366928 
  142.52721 75.468307 143.0105 75.592194 143.045 75.633873 
  143.0188 75.687469 142.90221 75.718307 142.3033 75.716637 
  142.35941 75.698593 142.4236 75.665817 142.0038 75.656372 
  142.1183 75.644974 142.1933 75.623306 142.00549 75.616928 
  142.13969 75.584702 142.0724 75.525528 142.1825 75.471077 
  142.16969 75.435257 142.16409 75.369713 142.3866 75.272476 
  142.6349 75.093582 143.3927 75.002197 143.58 75.012192 
  143.6714 74.974983 143.69189 74.932747 143.4308 74.887482 
  142.6561 74.884979 142.62379 74.843307 142.71111 74.84137 
  142.5563 74.813583 142.3508 74.823593 141.96831 74.932747 
  141.9789 74.950531 142.0677 74.963318 142.32719 74.91748 
  142.3566 74.933868 142.1938 75.00415 141.8452 74.993874 
  141.7372 74.968033 140.0616 74.824677 139.97411 74.898323 
  139.6469 74.979141 139.46049 74.925537 139.4783 74.86554 
  139.5663 74.856369 139.63409 74.875809 139.37939 74.697746 
  139.20911 74.656082 139.05051 74.648033) 
#(-94.180557 74.631927 -93.563606 74.659416 -93.485001 74.687759 
  -93.463074 74.729424 -93.563629 74.743027 -93.438904 74.757751 
  -93.412804 74.90831 -93.515289 75.038307 -93.488892 75.072479 
  -93.458618 75.128036 -93.578339 75.197746 -93.493347 75.247192 
  -93.499184 75.264687 -93.648064 75.301361 -93.662231 75.31665 
  -93.676964 75.356644 -93.853622 75.392471 -94.031403 75.46553 
  -94.446404 75.605797 -94.827507 75.631088 -95.470291 75.566933 
  -95.824173 75.477753 -95.837227 75.453583 -95.800858 75.431641 
  -95.684723 75.428307 -95.703346 75.402481 -95.974457 75.436081 
  -96.162231 75.395538 -96.151138 75.374969 -95.905563 75.396637 
  -95.778923 75.36998 -95.890297 75.349136 -95.914459 75.358582 
  -95.959167 75.374687 -96.172501 75.285538 -96.063057 75.276642 
  -96.092216 75.255539 -96.45668 75.196907 -96.575302 75.096359 
  -96.614182 74.98497 -96.32225 75.001373 -96.328079 74.974701 
  -96.39418 74.978317 -96.396667 74.919693 -96.337509 74.903587 
  -96.210007 74.915527 -96.142227 75.017761 -96.056396 75.010246 
  -96.124741 74.975807 -96.135559 74.951103 -96.051132 74.972748 
  -96.03334 74.949417 -96.105827 74.938026 -96.122787 74.912201 
  -95.950562 74.857193 -95.542236 74.80748 -95.541397 74.745796 
  -95.450562 74.741638 -95.472794 74.791641 -95.34584 74.795532 
  -95.056396 74.727753 -95.073059 74.702187 -95.005569 74.671371 
  -94.180557 74.631927) #(-92.011383 76.656647 -92.18335 76.6147 
  -93.109177 76.616364 -93.121948 76.574982 -93.580566 76.423027 
  -93.463898 76.399406 -93.54834 76.386093 -93.631958 76.428589 
  -93.63002 76.45192 -93.306953 76.546654 -93.309464 76.573303 
  -93.186401 76.660812 -93.187523 76.745529 -93.467216 76.827477 
  -93.64975 76.908043 -93.964752 76.93248 -94.09639 76.88887 
  -94.44751 76.916641 -94.526672 76.969421 -95.752808 77.068588 
  -96.391113 77.026917 -96.747787 76.982758 -96.660843 76.947197 
  -96.857788 76.924973 -96.865837 76.898033 -96.797501 76.861359 
  -96.316704 76.801361 -96.311951 76.751373 -96.642517 76.748871 
  -96.839737 76.810257 -96.9039 76.784149 -96.8414 76.766373 
  -96.946953 76.738586 -96.857803 76.70192 -96.470573 76.685532 
  -96.403641 76.639687 -95.990013 76.578583 -95.866119 76.55304 
  -95.638901 76.604141 -95.584167 76.598312 -95.7789 76.51886 
  -96.090584 76.510246 -96.061684 76.467194 -95.83168 76.394974 
  -94.859451 76.337196 -94.80864 76.311371 -95.010849 76.331093 
  -95.118362 76.298027 -95.374451 76.29776 -95.386948 76.235809 
  -95.056122 76.219147 -95.001106 76.245796 -94.662247 76.310257 
  -94.644737 76.277481 -94.420288 76.281082 -94.097778 76.259407 
  -93.763344 76.280807 -93.636139 76.326637 -93.653633 76.30275 
  -93.617783 76.291092 -93.523911 76.312759 -93.162247 76.367752 
  -93.065567 76.347748 -93.067253 76.299149 -92.637512 76.115807 
  -92.629181 76.008873 -92.108612 75.858871 -92.104736 75.805252 
  -92.174454 75.744423 -92.036682 75.679428 -92.055298 75.611649 
  -92.013924 75.589142 -92.320023 75.498306 -92.458618 75.368874 
  -92.328903 75.369423 -92.503616 75.218033 -92.384193 75.169983 
  -92.055573 75.150253 -92.112808 75.12886 -92.03891 75.107193 
  -92.030006 75.086357 -92.228897 75.071091 -92.013344 74.90831 
  -92.066391 74.813309 -92.045563 74.789703 -91.807533 74.731918 
  -91.859451 74.721077 -91.833344 74.696091 -91.779449 74.725807 
  -91.651962 74.719971 -91.621964 74.700256 -91.671951 74.689697 
  -91.676407 74.671921 -91.540009 74.646362 -91.360001 74.643311 
  -91.331703 74.67247 -91.361679 74.708588 -91.295563 74.712753 
  -91.277237 74.688026 -91.301407 74.656372 -91.256668 74.628593 
  -91.098083 74.633324 -91.226143 74.733582 -90.81723 74.883591) 
#(-90.81723 74.883591 -90.74086 74.847473 -91.025009 74.702759 
  -90.896118 74.681374 -90.753082 74.731644 -90.756126 74.705544 
  -90.62001 74.61998 -90.478058 74.601089 -90.363358 74.594704 
  -90.088348 74.548859 -89.988907 74.584137 -89.928627 74.530807 
  -89.228622 74.578033 -89.138062 74.606644 -89.095863 74.688026 
  -89.26503 74.756363 -89.047523 74.722473 -89.011124 74.780807 
  -89.060028 74.79747 -89.088623 74.837196 -88.906418 74.773033 
  -88.917526 74.719704 -88.862228 74.658859 -88.805008 74.67775 
  -88.664726 74.844971 -88.618073 74.846359 -88.61586 74.815536 
  -88.545303 74.848038 -88.567253 74.880249 -88.537247 74.906921 
  -88.443893 74.838593 -88.487228 74.791367 -88.29335 74.769417 
  -88.408363 74.74054 -88.491409 74.654694 -88.571404 74.549973 
  -88.517227 74.499687 -87.903923 74.472198 -87.754997 74.513603 
  -87.710854 74.460823 -87.545029 74.464142 -87.416397 74.52887 
  -87.301407 74.544418 -87.371948 74.514687 -87.304169 74.471649 
  -87.111954 74.468033 -87.001968 74.507751 -86.943626 74.461357 
  -86.601967 74.469971 -86.797523 74.543587 -86.799469 74.61525 
  -86.751129 74.613586 -86.753082 74.582474 -86.615837 74.522202 
  -86.374474 74.483307 -86.245033 74.523857 -86.223083 74.562187 
  -86.243073 74.59137 -86.215843 74.610809 -86.1539 74.609154 
  -86.077789 74.545258 -86.105827 74.506927 -86.082497 74.479141 
  -85.581131 74.498306 -85.49585 74.525818 -85.481956 74.554138 
  -85.551971 74.660248 -85.520859 74.688026 -85.468918 74.658859 
  -85.363907 74.501923 -85.25946 74.49054 -85.087799 74.504967 
  -85.037231 74.535248 -85.063919 74.651642 -84.973343 74.696091 
  -84.950844 74.67276 -84.983078 74.570534 -84.89975 74.503311 
  -84.588638 74.503036 -83.855583 74.550812 -83.611954 74.540817 
  -83.454742 74.591087 -83.319168 74.774979 -83.458633 74.808029 
  -83.557251 74.875259 -83.547523 74.897476 -83.475594 74.896637 
  -83.299744 74.835533 -83.116127 74.828583 -83.073639 74.804138 
  -83.128082 74.717484 -83.088913 74.636642 -82.968918 74.570824 
  -82.78363 74.520248 -82.592529 74.510529 -82.482803 74.536362 
  -82.081703 74.477203 -81.759193 74.46109 -81.219177 74.571373 
  -80.231689 74.578033 -80.146667 74.626923 -80.208633 74.694427 
  -80.134171 74.704971 -80.138077 74.724136 -80.246964 74.757477 
  -80.101967 74.789139 -80.108627 74.824417 -80.361397 74.868874 
  -80.413094 74.897751 -80.306412 74.939148 -80.274193 74.881088 
  -80.220863 74.871368 -80.191132 74.894699 -80.210861 74.931091 
  -80.166138 74.932747 -80.142517 74.898033 -80.177803 74.867752 
  -79.880577 74.813026 -79.502243 74.859421 -79.330757 74.8965) 
#(85.356644 74.45192 85.196907 74.485809 85.148033 74.548027 
  85.243591 74.573593 85.368591 74.579697 85.640701 74.541 
  85.62442 74.503036 85.493591 74.498871 85.484154 74.458588 
  85.356644 74.45192) #(85.74498 74.444138 85.662483 74.476639 
  85.804428 74.566933 85.938873 74.573303 86.20665 74.533577 
  86.205544 74.506363 86.112198 74.478592 86.07164 74.508324 
  85.963028 74.505249 85.981087 74.462479 85.74498 74.444138) 
#(65.992889 76.528519 65.757202 76.684982 65.947746 76.748871 
  66.131927 76.751373 66.426933 76.852478 67.596916 77.013031 
  68.515533 76.951103 68.472748 76.925537 68.809418 76.866364 
  68.761093 76.84053 68.764137 76.81665 68.931374 76.782761 
  68.893593 76.757477 68.900528 76.727753 69.030258 76.708038 
  68.856369 76.656647 68.784698 76.587753 68.84053 76.575813 
  68.925537 76.558868 68.429977 76.395538 68.398323 76.364151 
  68.169144 76.31192 68.26442 76.300537 68.313309 76.28331 
  67.929428 76.255539 67.034698 76.084137 65.791092 75.926086 
  63.707489 75.634407 63.65554 75.711639 63.559711 75.708038 
  63.617489 75.686081 63.528599 75.632477 63.282211 75.583313 
  63.029991 75.587753 62.2411 75.432747 62.026661 75.443863 
  61.82304 75.352478 61.696659 75.373306 61.523602 75.226357 
  61.42944 75.223038 61.381378 75.256927 61.3811 75.330544 
  61.273602 75.321373 61.30249 75.285538 61.164989 75.213028 
  60.74638 75.104424 60.810822 75.078033 60.75499 75.029984 
  60.668598 75.020813 60.566101 75.050537 60.59499 75.109154 
  60.49221 75.113586 60.446098 75.014137 60.1036 74.988312 
  60.629429 74.960823 60.684711 74.921082 60.534988 74.859421 
  60.22332 74.858307 60.209991 74.839142 60.348598 74.800537 
  60.364159 74.783043 60.263599 74.745796 59.937481 74.718033 
  59.662491 74.752197 59.869999 74.68248 59.87888 74.626373 
  59.708321 74.585533 59.53471 74.611359 59.148319 74.736649 
  59.094719 74.729713 59.290272 74.638031 59.146111 74.662483 
  59.084991 74.642197 59.22332 74.611076 59.088871 74.482758 
  59.147209 74.438583 58.763599 74.465813 58.71693 74.499687 
  58.182331 74.572563) #(-112.4277 76.166313 -112.7506 76.200531 
  -112.8922 76.25386 -113.0153 76.267197 -113.7567 76.200531 
  -113.9986 76.197746 -113.9833 76.261368 -114.1286 76.310257 
  -114.1061 76.35553 -114.0911 76.38887 -114.1481 76.45137 
  -114.2936 76.480263 -114.8997 76.516922 -115.0214 76.474701 
  -115.4667 76.455811 -115.9094 76.345543 -115.8533 76.318863 
  -115.925 76.286636 -115.882 76.252762 -115.782 76.23526 
  -115.2992 76.23526 -114.8506 76.170258 -115.3275 76.184692 
  -116.3422 76.183029 -116.6414 76.113312 -116.7086 76.043869 
  -116.6694 76.025818 -116.4995 76.026642 -116.5028 75.997192 
  -116.4706 75.968872 -116.6322 75.969147 -116.7314 75.945251 
  -116.7245 75.906372 -116.6767 75.889687 -116.4828 75.873871 
  -114.8242 75.904137 -114.9325 75.856644 -115.5072 75.834976 
  -115.7264 75.853317 -115.8231 75.827187 -116.7628 75.799973 
  -116.9233 75.774696 -117.2336 75.620529 -117.25 75.58609 
  -117.195 75.573593 -116.3475 75.559143 -115.0528 75.703033 
  -114.9997 75.690811 -115.2508 75.641083 -115.2686 75.59581 
  -115.6197 75.578873 -116.0022 75.484703 -116.2947 75.483582 
  -117.2614 75.468872 -117.6669 75.294144 -117.6783 75.244423 
  -117.4192 75.18248 -116.6792 75.117203 -116.5272 75.184692 
  -116.2392 75.20137 -116.267 75.145538 -116.2942 75.099136 
  -116.065 75.127472 -116.0933 75.093033 -116.2267 75.071907 
  -116.2353 75.0522 -115.6906 74.964142 -115.6183 74.979141 
  -115.5375 75.027206 -115.562 75.066933 -115.6467 75.124969 
  -115.6572 75.142761 -115.3869 75.102203 -115.2614 75.151917 
  -115.2561 75.17804 -115.1728 75.107758 -115.2264 75.058296 
  -115.1858 74.98526 -115.0322 74.961639 -114.7839 74.997192 
  -114.3858 75.09581 -114.2981 75.166641 -114.3025 75.182747 
  -114.4681 75.262192 -114.5778 75.262756 -114.6097 75.279984 
  -114.5128 75.314697 -114.2031 75.221359 -114.1375 75.24498 
  -114.0406 75.367752 -114.0939 75.410812 -114.0744 75.440536 
  -114.0242 75.46109 -113.8964 75.374153 -113.3222 75.415817 
  -113.8058 75.326637 -113.9128 75.20137 -113.9125 75.169144 
  -113.9325 75.141373 -113.9731 75.096359 -113.9503 75.060532 
  -113.8942 75.0522 -113.2109 75.081917 -113.1342 75.14415 
  -113.0389 75.093582 -112.8942 75.103317 -112.6981 75.144974 
  -112.7336 75.209137 -112.6658 75.278587 -112.5859 75.239151 
  -112.6347 75.196373 -112.5925 75.181641 -112.4325 75.18692 
  -112.4619 75.218872 -112.3975 75.241089 -112.2947 75.198029 
  -112.4525 75.155807 -112.4097 75.123581 -111.9197 75.133591 
  -111.7608 75.184692 -111.6767 75.146927 -111.3342 75.197479 
  -111.2081 75.26442 -110.9567 75.246094 -110.9206 75.223587 
  -111.3047 75.096359 -111.3281 75.070251 -111.5672 75.060257 
  -111.4842 75.040817 -111.5514 75.011368 -111.7922 74.988037 
  -112.7003 74.981644 -113.2872 74.886368 -113.2197 74.861649 
  -113.2197 74.843582 -113.3206 74.856087 -114.0103 74.790527 
  -114.4197 74.698029 -114.4436 74.664139 -114.3614 74.623581 
  -114.0419 74.528313 -113.4061 74.413307 -112.7531 74.401367 
  -112.0872 74.452187 -111.58 74.524406 -111.1403 74.59053 
  -110.5869 74.718582 -110.6731 74.77887 -109.5081 74.866364 
  -109.3458 74.944702 -109.015 74.984703 -108.9681 75.02359 
  -108.9278 75.051933 -108.7947 75.069138 -108.5306 75.005539 
  -108.5189 74.974426 -108.3917 74.910538 -107.942 74.930817 
  -108.0164 74.948593 -107.7397 75.04303 -107.7717 75.095543) 
#(19.05167 74.344147 19.191111 74.364433 19.299721 74.474983 
  19.264721 74.486076 18.984171 74.511917 18.837219 74.503311 
  18.790279 74.476089 19.05167 74.344147) 
#(112.8149 74.09407 112.1594 74.134697 111.9625 74.210533 
  111.6133 74.24942 111.4836 74.293587 111.4547 74.323029 
  111.4936 74.35025 111.6764 74.373032 111.8778 74.345261 
  111.9842 74.394699 111.9711 74.478592 112.0255 74.536087 
  112.1278 74.548859 113.213 74.486923 113.3941 74.448303 
  113.4333 74.39386 113.2628 74.270538 112.9711 74.193314 
  112.8149 74.09407) #(-21.26861 74.079697 -20.16139 74.16803 
  -20.12528 74.204971 -20.433331 74.27887 -20.43445 74.349426 
  -20.493059 74.380814 -20.655001 74.407761 -20.958611 74.443039 
  -21.38806 74.440536 -21.870279 74.337479 -21.990841 74.227203 
  -21.96833 74.210823 -21.58083 74.156082 -21.26861 74.079697) 
#(83.543869 74.063583 82.829651 74.083542 82.917763 74.123032 
  83.228027 74.148033 83.602753 74.098038 83.543869 74.063583) 
#(140.448 73.901154 140.6647 73.945824 140.9675 73.974426 
  141.0519 74.016647 141.0714 74.095543 141.1172 74.16803 
  140.9855 74.252762 140.8522 74.27359 140.4955 74.278587 
  140.21111 74.237198 140.0883 74.176651 140.0733 74.085823 
  140.1188 74.025253 140.37131 73.917763 140.448 73.901154) 
#(136.1505 73.874153 136.0708 73.896927 136.0405 73.933029 
  135.73109 74.035812 135.6552 74.107193 135.433 74.158577 
  135.35361 74.252762 135.4136 74.24556 135.9091 74.128311 
  136.27161 73.978317 136.2413 73.898857 136.1505 73.874153) 
#(-98.587784 73.832748 -98.287514 73.860809 -97.763641 73.988312 
  -97.638344 74.063873 -97.6539 74.099983 -97.757507 74.119423 
  -99.31723 73.93248 -99.4375 73.896927 -99.381958 73.869141 
  -98.587784 73.832748) #(75.3647 73.39415 75.380539 73.443314 
  75.543869 73.495247 75.51886 73.445824 75.880249 73.457474 
  76.077759 73.558029 76.006088 73.568863 75.580261 73.541924 
  75.323593 73.446907 75.304413 73.409698 75.3647 73.39415) 
#(-55.099941 73.353073 -55.17001 73.411636 -55.444462 73.451103 
  -55.662231 73.578308 -56.02306 73.631927 -56.067509 73.659149 
  -55.849731 73.6772 -55.8489 73.687469 -56.019169 73.6772 
  -56.037788 73.692749 -55.926399 73.715813 -55.950569 73.736649 
  -55.9464 73.762482 -55.65807 73.698868 -55.615009 73.727203 
  -55.837791 73.755249 -55.938622 73.856087 -55.67168 73.835823 
  -55.631962 73.860809 -55.693901 73.887482 -56.099461 73.96109 
  -56.08807 74.004967 -56.360008 74.050812 -56.19862 74.1147 
  -56.31168 74.115807 -56.140011 74.255814 -56.172508 74.279419 
  -56.67445 74.146362 -57.308071 74.097198 -57.283352 74.13942 
  -56.32029 74.284698 -56.327511 74.306923 -56.574181 74.292763 
  -56.531681 74.327477 -56.690289 74.334702 -56.690571 74.349136 
  -56.128071 74.377472 -56.14307 74.39386 -56.212509 74.414139 
  -56.587791 74.402481 -56.78751 74.449417 -56.144451 74.479141 
  -56.261959 74.510529 -56.20668 74.555252 -56.377239 74.541924 
  -56.599731 74.601639 -56.504459 74.613861 -56.47279 74.64415 
  -56.761681 74.651093 -56.777241 74.681641 -57.026402 74.67775 
  -57.048618 74.738861 -57.156681 74.73497 -57.15556 74.765259 
  -57.12196 74.796371 -56.978901 74.759407 -56.803341 74.822746 
  -56.998901 74.867752 -57.049179 74.917763 -57.275291 74.903313 
  -57.927509 75.05304 -58.105839 75.043587 -58.154732 75.060257 
  -58.13084 75.102478 -57.980572 75.135803 -57.918339 75.166092 
  -57.989182 75.192749 -58.223339 75.203033 -58.409451 75.291924 
  -58.430012 75.320251 -58.30307 75.329422 -58.35973 75.363861 
  -58.26112 75.387192 -58.257229 75.402206 -58.434181 75.39386 
  -58.52306 75.338867 -58.697788 75.346359 -58.66251 75.36998 
  -58.22168 75.435257 -58.1814 75.485527 -58.17918 75.525253 
  -58.433071 75.5672 -58.31612 75.64859 -58.60001 75.667763 
  -58.561401 75.691933 -58.44556 75.697746 -58.537231 75.733582 
  -59.075291 75.707748 -59.052509 75.749977 -59.095852 75.771927 
  -59.198898 75.757477 -59.226681 75.775528 -59.231121 75.807747 
  -59.300838 75.811371 -59.140011 75.846077 -59.2164 75.872192 
  -59.51112 75.859703 -59.76001 75.793587 -59.815571 75.816093 
  -59.79557 75.834976 -59.602791 75.914139 -59.790291 75.961906 
  -59.918339 75.919693 -60.113899 75.974136 -60.115559 75.997414) 
#(-22.477409 75.554062 -22.504999 75.550537 -22.3825 75.496368 
  -21.415001 75.423576 -20.58806 75.201637 -20.52972 75.16304 
  -20.67028 75.116089 -21.01222 75.13414 -21.73667 74.976089 
  -21.861389 75.009407 -21.87417 75.050812 -21.967501 75.087753 
  -22.394449 75.165817 -22.154449 75.108871 -21.942499 75.041367 
  -22.019171 75.012192 -21.833611 74.964706 -21.66778 74.953583 
  -21.09306 75.089981 -20.629999 75.057213 -20.718889 74.973312 
  -20.683611 74.888603 -20.76111 74.852753 -20.75111 74.823593 
  -20.603609 74.745247 -20.79723 74.665527 -21.003059 74.658951 
  -20.128059 74.669144 -20.004999 74.624161 -19.714729 74.585251 
  -19.411671 74.685257 -19.29528 74.660248 -19.276951 74.635529 
  -19.37945 74.550812 -18.97806 74.481644 -19.378059 74.260803 
  -19.596951 74.234703 -20.20084 74.276657 -20.208611 74.309143 
  -20.363609 74.443039 -20.503889 74.451637 -21.63834 74.444977 
  -21.817221 74.483032 -21.879721 74.544144 -22.09 74.598038 
  -22.10667 74.584702 -21.942499 74.533043 -21.764999 74.419418 
  -21.80389 74.389137 -22.032499 74.3172 -22.47917 74.30748 
  -22.05806 74.28775 -22.03833 74.256088 -22.067499 74.22554 
  -22.338341 74.157204 -22.206671 74.16275 -22.15834 74.126648 
  -22.450001 74.09137 -22.480829 74.068314 -21.980829 73.998032 
  -22.00695 73.970261 -21.870279 73.904709 -21.814171 73.844421 
  -21.853889 73.763313 -21.815559 73.652206 -21.70306 73.701103 
  -21.76528 73.868591 -21.889721 73.926651 -21.868059 73.953583 
  -21.91778 73.981369 -21.862499 74.036087 -21.66556 74.058296 
  -21.085279 73.941933 -20.28334 73.87999 -20.24917 73.828873 
  -20.53334 73.72081 -20.458611 73.637482 -20.523609 73.565811 
  -20.5075 73.545807 -20.370001 73.527222 -20.40028 73.494713 
  -20.516109 73.450813 -20.851669 73.453308 -21.48889 73.483582 
  -21.61389 73.463028 -21.58556 73.44136 -21.551941 73.395538 
  -22.22695 73.245247 -22.421949 73.254967 -23.395559 73.416367 
  -24.0 73.603867 -24.035 73.666092 -23.98278 73.722198 
  -23.5042 73.683517 -23.03528 73.60054 -22.67445 73.545258 
  -22.23695 73.614166 -22.20056 73.628036 -22.759991 73.573959 
  -23.16361 73.654427 -23.91222 73.751938 -24.027229 73.815262 
  -24.223339 73.78775 -24.45472 73.695824 -24.459169 73.629433 
  -24.377781 73.557213 -24.904449 73.594971 -24.995001 73.638046 
  -24.960831 73.691933 -25.009451 73.718872 -25.43556 73.824692 
  -25.50806 73.90387 -25.688101 73.951553) 
#(58.182331 74.572563 58.636662 74.416924 58.572491 74.384697 
  58.636379 74.357758 58.65443 74.308594 58.722221 74.30304 
  58.725819 74.261642 58.53582 74.236649 58.65527 74.215813 
  58.328041 74.184692 58.310822 74.221359 58.257488 74.207474 
  58.270821 74.170532 58.51749 74.136917 58.299709 74.086357 
  58.20805 74.141647 58.134159 74.133591 58.172489 74.098862 
  58.095268 74.055817 58.197208 74.044693 58.222759 74.008873 
  58.11499 73.983307 57.881939 74.01387 57.533871 74.181923 
  57.413319 74.176933 57.516109 74.122757 57.509991 74.079697 
  57.257488 74.076103 57.548599 74.060257 57.911652 73.915527 
  57.817211 73.887192 57.90749 73.870247 57.944149 73.803307 
  57.90638 73.781647 57.697491 73.712753 57.598881 73.773857 
  57.40276 73.838318 56.711391 73.873306 57.36694 73.811653 
  57.613602 73.662201 57.5686 73.606087 57.229988 73.555817 
  56.9725 73.596916 56.809429 73.670807 56.723049 73.673576 
  56.75499 73.638313 57.237209 73.506088 57.248322 73.480797 
  57.17527 73.441093 57.17416 73.416641 56.887489 73.309418 
  56.764431 73.364151 56.74221 73.342484 56.744431 73.258324 
  56.71888 73.242752 56.09 73.297203 56.034161 73.336639 
  56.031391 73.401367 55.982208 73.428589 55.867771 73.435806 
  55.97916 73.389137 55.976101 73.349983 55.925228 73.312408 
  55.401619 73.385834 54.971661 73.4422 54.781651 73.429977 
  54.220551 73.323029 54.05444 73.362762 54.04361 73.386642 
  54.413879 73.476357 54.293049 73.463867 54.1936 73.498306 
  54.495281 73.595543 55.28471 73.711357 54.82526 73.682747 
  54.86805 73.718872 54.855259 73.727753 54.484989 73.693039 
  54.40554 73.641083 54.200001 73.599426 53.64027 73.743874 
  53.630001 73.768311 53.65749 73.806923 53.774151 73.775818 
  53.90778 73.780533 54.249722 73.910812 54.598598 73.94664 
  54.80444 73.981087 54.58527 74.011642 55.053051 74.175262 
  55.847221 74.099136 55.867222 74.11554 55.803329 74.141083 
  55.077209 74.258324 55.09082 74.26886 55.346939 74.282204 
  55.713051 74.269417 55.740822 74.300812 55.230259 74.368874 
  55.415539 74.441093 56.270828 74.477753 56.258049 74.501083 
  56.1586 74.486076 56.017208 74.497757 56.081669 74.516922 
  56.008331 74.541641 55.85416 74.548309 55.655819 74.516083 
  55.7061 74.551933 55.498051 74.572197 55.569439 74.610527 
  55.520821 74.64415 55.571659 74.659698 55.797779 74.688583 
  55.914719 74.657761 56.303051 74.710251 56.425541 74.699142 
  56.97411 74.689011) #(143.185 73.203308 141.7794 73.294983 
  141.3622 73.363586 140.7027 73.45137 140.3824 73.42804 
  140.00909 73.354424 139.8391 73.345543 139.67661 73.36554 
  139.65269 73.420258 139.72861 73.440262 140.3136 73.452477 
  140.6494 73.568863 140.7097 73.634407 140.95 73.822479 
  141.1646 73.877823 141.3564 73.86026 141.56329 73.898323 
  142.0477 73.917213 142.5766 73.820251 143.4319 73.522476 
  143.5266 73.436081 143.43629 73.40303 143.5439 73.231087 
  143.185 73.203308) #(-24.56056 73.04747 -23.009171 73.094971 
  -22.87528 73.154984 -23.131109 73.181374 -23.59972 73.183594 
  -24.724449 73.291924 -24.98889 73.301666 -24.85 73.322746 
  -23.74111 73.224701 -23.230829 73.219994 -23.26861 73.257751 
  -23.510281 73.303307 -24.418329 73.414703 -25.21611 73.409416 
  -25.29306 73.384697 -25.302219 73.323318 -25.695841 73.203033 
  -25.707781 73.180252 -25.535839 73.136642 -24.56056 73.04747) 
#(120.2286 73.032204 119.6985 73.041168 119.7594 73.074982 
  119.6355 73.121368 119.7516 73.157471 119.8964 73.166367 
  120.1133 73.148323 120.2783 73.098862 120.2139 73.054977 
  120.2286 73.032204) #(70.110527 73.020813 70.002197 73.063873 
  70.106369 73.098312 70.241089 73.03775 70.411636 73.035538 
  70.754967 73.10997 71.676651 73.176933 71.648323 73.237473 
  71.432747 73.348312 71.382477 73.310532 71.210533 73.268044 
  71.019699 73.264977 70.98526 73.281921 71.087753 73.299973 
  71.144699 73.400528 71.104141 73.429703 71.113037 73.446091 
  71.249153 73.433296 71.247482 73.454147 70.930527 73.516083 
  70.485527 73.493027 70.124687 73.439972 69.955261 73.387756 
  70.06665 73.257202 70.031921 73.187759 69.916367 73.126648 
  69.873749 73.050461 70.110527 73.020813) 
#(86.785782 72.991348 86.750526 73.092194 86.373871 73.242203 
  85.914703 73.32637 85.843307 73.37442 85.857193 73.481369 
  86.021927 73.520538 87.176933 73.616928 87.343307 73.699982 
  87.322479 73.704422 87.642761 73.834137 87.64859 73.858871 
  87.638313 73.904419 87.523857 73.906082 87.530533 73.851357 
  87.437759 73.816933 87.267761 73.845543 86.962479 74.01442 
  87.024139 74.045807 87.419693 74.010529 87.393593 74.02887 
  87.320824 74.051651 86.888603 74.0672 86.718033 74.134697 
  86.802467 74.178864 86.760529 74.208038 86.549149 74.251923 
  86.038857 74.261917 85.941933 74.286926 85.961357 74.314148 
  85.911362 74.334702 85.911636 74.356918 86.000809 74.36525 
  86.299423 74.309982 86.29747 74.339706 86.049698 74.41304 
  86.164429 74.421371 86.321091 74.4422 86.587753 74.43248 
  86.607193 74.384697 86.877472 74.391083 86.952477 74.376083 
  86.906372 74.354424 86.723587 74.318588 86.712753 74.297203 
  86.968582 74.338593 87.007477 74.269974 87.053307 74.291924 
  87.025253 74.334976 87.018311 74.366364 87.261093 74.352203 
  87.055817 74.399406 87.079697 74.417213 87.078308 74.440262 
  86.787483 74.422203 86.53804 74.510529 86.780533 74.554428 
  86.31192 74.603317 85.920532 74.610809 85.770248 74.649406 
  86.08136 74.722198 86.124687 74.761917 86.042213 74.818314 
  86.207474 74.810257 86.380249 74.755249 86.221649 74.753311 
  86.342194 74.699142 86.472473 74.722748 86.638313 74.69136 
  86.601639 74.666924 86.629433 74.650528 86.960533 74.603027 
  86.955811 74.624969 86.761917 74.702759 86.897751 74.751373 
  87.060257 74.722473 87.081093 74.775818 87.037483 74.798309 
  87.078033 74.85498 87.365807 74.931091 87.371643 74.955811 
  87.171371 74.984154 87.241638 74.999977 87.428589 74.99942 
  87.481369 74.971077 87.429977 74.95192 87.594971 74.934692 
  87.558594 74.958588 87.758324 75.012192 87.738037 75.035248 
  86.900253 75.083313 86.923576 75.127197 87.035248 75.158043 
  87.290253 75.160538 87.987198 75.099983 88.315262 75.173309 
  88.33165 75.234154 88.502762 75.283859 88.626083 75.26387 
  88.58136 75.293869 88.56665 75.324692 88.885246 75.400528 
  89.081093 75.406372 88.965263 75.431641 89.252762 75.503036 
  89.407204 75.437469 89.719147 75.44664 89.610527 75.486076 
  89.660812 75.498871 90.054138 75.517471 90.050812 75.531082 
  89.939697 75.546371 89.938583 75.568314 90.894974 75.664703 
  90.978317 75.614967 91.163589 75.661087 91.233871 75.626083 
  91.647202 75.647751 91.620247 75.69664 93.854141 75.88414 
  94.161926 75.942749 94.060257 75.92804 93.636093 75.899696 
  93.550537 75.946907 93.440811 75.913589 93.494141 75.893593 
  93.483871 75.879433 93.395538 75.876083 93.31192 75.92804 
  93.303864 75.963028 93.285248 75.976089 92.96109 75.929138 
  93.087479 75.908043 93.069427 75.890808 92.886368 75.893044 
  92.904137 75.917763 92.826637 75.963593 92.925537 75.990807 
  92.91748 76.051651 93.049423 76.065262 93.109154 76.01886 
  93.221359 76.042213 93.224136 76.063873 93.162483 76.074982 
  93.136368 76.094147 93.39386 76.111649 93.436371 76.096916 
  93.351929 76.074982 93.381927 76.048859 93.407204 76.027763 
  93.409973 76.011642 93.943863 76.043869 93.983032 76.058868 
  93.76886 76.094421 94.380249 76.119423 94.493874 76.049149 
  94.731918 76.124687 94.549423 76.152206 94.785248 76.150818 
  94.925262 76.110809 95.411926 76.158043 96.15387 76.099701 
  96.19664 76.077759 95.991638 76.060532 96.075256 76.053307 
  95.980797 76.026367 96.004433 75.99054 95.569977 75.885803 
  95.760529 75.85498 95.823029 75.912201 95.951103 75.949982 
  96.342194 75.959427 96.267471 75.99025 96.511917 76.009979 
  96.665527 75.97081 96.601929 75.943588 96.450531 75.866928 
  96.83136 75.888603 97.043587 75.979713 97.395538 76.044418 
  97.314972 76.020538 97.19136 75.974426 97.248306 75.955261 
  97.212196 75.928589 97.319702 75.947197 97.368027 75.980797 
  97.838593 75.984154 97.806641 76.022202 97.549698 76.052467 
  97.760246 76.093872 97.90303 76.057213 98.217484 76.098038 
  97.915253 76.121368 98.049698 76.158043 98.361359 76.174149 
  98.551086 76.224701 98.817467 76.261917 98.736359 76.210251 
  98.7397 76.196373 99.276917 76.214142 99.278313 76.198593 
  99.089417 76.160538 99.181923 76.125526 99.574692 76.155533 
  99.601639 76.124153 99.467194 76.09581 99.576637 76.077477 
  99.558594 76.060532 99.640808 76.081917 99.761642 76.044418 
  99.765259 76.02359 99.68248 75.967758 99.683868 75.889687 
  99.58136 75.821907 99.254967 75.77359 99.220261 75.748032 
  99.264687 75.712196 99.16748 75.673309 99.096649 75.584137 
  99.159698 75.537201 99.753036 75.453873 99.714417 75.435806 
  99.712479 75.40831 99.785049 75.370529 99.997627 75.272263 
  100.1807 75.17334) #(-96.915283 72.917763 -96.743057 72.933594 
  -96.636688 72.965813 -96.568893 73.062187 -96.650284 73.139977 
  -96.771118 73.113586 -96.730827 73.142761 -96.771973 73.181641 
  -97.059448 73.142197 -97.141113 73.085533 -97.130836 73.039703 
  -97.017792 72.940536 -96.915283 72.917763) 
#(-105.3642 72.863861 -105.2042 72.864151 -105.3239 72.914703 
  -105.1989 72.938873 -104.6492 73.280807 -104.5486 73.414703 
  -104.5756 73.453873 -104.4897 73.526917 -105.1486 73.75415 
  -105.5353 73.762756 -105.7267 73.728592 -106.2056 73.734154 
  -106.6581 73.695251 -107.0183 73.504967 -107.017 73.472748 
  -106.4661 73.401367 -106.1575 73.285812 -106.1817 73.264977 
  -106.0444 73.219421 -106.1014 73.189697 -105.9881 73.169418 
  -105.3642 72.863861) #(74.674423 72.858871 74.708588 72.896637 
  74.635246 72.943863 74.686081 73.061653 74.741928 73.085251 
  74.892761 73.074692 74.4272 73.131927 74.184143 73.101639 
  74.106613 73.032997 74.596359 72.867752 74.674423 72.858871) 
#(129.14079 72.781647 128.31329 72.810532 128.2916 72.871094 
  128.4577 72.899979 129.1411 72.848587 129.2444 72.813873 
  129.14079 72.781647) #(-79.209183 72.74498 -78.273071 72.890533 
  -77.704468 72.897202 -77.206703 72.844971 -76.315582 72.8172 
  -76.093918 72.858032 -76.062241 72.906921 -76.103912 72.936371 
  -76.227226 72.94664 -76.331703 72.969971 -76.260567 72.997192 
  -76.323639 73.026367 -76.241127 73.092194 -76.396683 73.109421 
  -76.633911 73.171921 -76.579742 73.219704 -76.760849 73.318863 
  -77.049187 73.361923 -77.203079 73.505539 -78.166412 73.66803 
  -79.45224 73.630539 -80.435013 73.766083 -80.771667 73.749687 
  -80.863892 73.74498 -80.795578 73.702187 -80.815292 73.639687 
  -80.897781 73.596649 -80.695297 73.477753 -80.820282 73.489151 
  -80.858627 73.469704 -80.861954 73.396362 -80.892517 73.374687 
  -80.797523 73.276917 -80.445297 73.250809 -80.143341 73.216919 
  -80.113907 73.174423 -80.172813 73.162483 -80.176407 73.138313 
  -80.122803 73.114433 -80.181412 73.043869 -79.998917 72.863037 
  -79.54335 72.748581 -79.209183 72.74498) 
#(79.396088 72.699692 79.554977 72.724136 79.581917 72.748871 
  79.513313 72.889137 79.372757 73.026367 79.194702 73.09581 
  79.111649 73.085533 78.676102 72.901337 78.578583 72.845543 
  78.604713 72.80304 78.726639 72.785812 79.396088 72.699692) 
#(-21.90472 72.676651 -21.87389 72.719421 -22.18778 72.81192 
  -22.05584 72.830811 -21.903891 72.911636 -22.020559 72.92247 
  -22.223061 72.971077 -23.273331 73.062759 -24.57667 72.974983 
  -24.584999 72.946373 -24.528891 72.895813 -23.48695 72.869713 
  -22.906111 72.83609 -22.79167 72.79248 -22.617229 72.73082 
  -22.64389 72.715263 -22.046671 72.710533 -22.081949 72.683029 
  -21.90472 72.676651) #(127.3226 72.652863 127.6941 72.700813 
  127.8786 72.761917 128.3019 72.78775 129.33611 72.708038 
  129.3461 72.697197 129.1658 72.653587 128.65109 72.707474 
  128.32719 72.668297 127.3226 72.652863) 
#(100.1807 75.17334 100.1958 75.204971 99.791367 75.374969 
  99.812759 75.443039 99.793869 75.478317 99.209137 75.54747 
  99.170532 75.57692 99.246918 75.6772 99.357193 75.701637 
  99.281921 75.738037 99.326103 75.771088 99.604424 75.777763 
  99.875526 75.904137 99.912201 75.942467 99.878311 75.993874 
  99.820251 76.013313 99.837196 76.037201 99.858307 76.103027 
  99.643311 76.189697 99.585251 76.272751 99.40387 76.275528 
  99.283043 76.341637 99.01886 76.354141 99.018044 76.396637 
  98.813026 76.478317 98.919693 76.519417 99.614433 76.469971 
  100.3227 76.462753 100.843 76.533577 100.9455 76.502472 
  101.7266 76.446907 101.8369 76.400528 102.2336 76.377197 
  102.1914 76.407204 100.8783 76.551361 101.1016 76.610527 
  101.1133 76.679138 101.1927 76.737473 101.2247 76.765533 
  100.9641 76.784973 100.8497 76.878593 100.9466 76.984154 
  101.2311 76.992752 101.2369 77.024696 101.1672 77.060532 
  101.2016 77.094704 102.1272 77.396637 102.2855 77.378036 
  102.5566 77.500259 102.9189 77.551086 102.9286 77.586357 
  103.2583 77.656372 103.2997 77.634697 103.4614 77.623871 
  104.1061 77.731087 104.3333 77.714417 104.2647 77.695534 
  104.2675 77.675812 104.368 77.663857 104.6475 77.700256 
  104.7772 77.689148 104.8086 77.624687 104.9772 77.586357 
  105.8719 77.563583 105.8347 77.536636 105.9005 77.517761 
  105.9239 77.454422 106.2542 77.378311 106.1841 77.344971 
  105.7375 77.361359 105.4375 77.272202 105.5366 77.261642 
  105.4228 77.234421 104.3017 77.125259 104.1294 77.088318 
  105.3991 77.083313 105.9316 77.137192 105.9275 77.116638 
  105.7364 77.057747 105.7683 77.032204 105.5116 77.027763 
  105.4339 77.003311 105.4539 76.974426 105.7122 76.978027 
  106.1941 77.061653 106.3625 77.04303 106.7758 77.000526 
  106.6447 77.02887 106.7833 77.050262 106.9536 77.02803 
  107.265 77.018044 107.2383 76.993591 107.4647 76.930252 
  107.4914 76.90831 107.2605 76.88414 107.3403 76.861649 
  107.1977 76.847473 107.2605 76.837753 107.2116 76.80304 
  107.0644 76.796082 107.0422 76.749977 106.7203 76.711906 
  106.7972 76.66803 106.6786 76.585823 106.5547 76.549423 
  106.5303 76.593033 106.4291 76.601929 106.3655 76.579422 
  106.4011 76.509697 106.8236 76.464417 107.343 76.531647 
  107.5753 76.503593 107.8758 76.535248 108.0 76.635246 
  107.9839 76.653313 107.9036 76.666367 107.9191 76.730263 
  108.2978 76.72998 108.3019 76.699142 109.0703 76.736076 
  109.8008 76.708313 110.5411 76.760246 110.9244 76.729141 
  110.9294 76.758034 111.1341 76.745529 111.0647 76.717758 
  111.1239 76.678589 111.2255 76.707199 111.5525 76.679977 
  111.4772 76.637482 111.4664 76.612473 111.7675 76.603317 
  112.195 76.466919 111.8266 76.339417 112.1122 76.416092 
  112.3089 76.443588 112.7458 76.323593 112.6583 76.314697 
  112.7394 76.284416 112.6452 76.218582 112.5014 76.238586 
  112.6047 76.192467 112.7828 76.192467 112.8553 76.141922 
  112.7933 76.079147 112.6086 76.049973 112.595 76.039703 
  113.0189 76.072197 113.0361 76.093033 112.9894 76.13414 
  113.0197 76.153587 113.1264 76.15387 113.27 76.1297 
  112.9589 76.223862 112.9375 76.257751 113.2169 76.264687 
  113.2944 76.241638 113.2361 76.203873 113.3652 76.203583 
  113.4689 76.130539 113.4355 76.103027 113.4466 76.039978 
  113.5503 76.019417 113.4992 75.983582 113.5403 75.974983 
  113.53 75.949692 113.4394 75.940536 113.5597 75.890808 
  113.4908 75.853317 113.6486 75.875259 113.6197 75.921082 
  113.8025 75.933296 113.8569 75.906647 113.8244 75.888031 
  113.888 75.855797 113.888 75.836639 113.7575 75.712196 
  113.7053 75.597748 113.633 75.577187 113.5539 75.536926 
  113.4217 75.538857 113.5911 75.628311 113.5861 75.659973 
  113.3177 75.68692 113.0391 75.67276 113.138 75.700813 
  113.115 75.717758 112.5805 75.843582 112.3575 75.85025 
  112.3747 75.83136 112.8225 75.733032 112.8541 75.698868 
  112.7464 75.696091 112.8816 75.633324 112.7911 75.569427 
  112.8461 75.54303 113.0119 75.546082 113.0341 75.563873 
  112.9833 75.597198 113.0022 75.610809 113.2503 75.649139 
  113.3005 75.633034 113.2558 75.569138 113.3505 75.527206 
  113.5772 75.505249 113.6316 75.522202 113.6808 75.49498 
  113.7175 75.408577 113.5747 75.40831 113.525 75.385246 
  113.6394 75.383873 113.6705 75.361359 113.6061 75.283859 
  112.8547 74.977753 112.0922 74.861359 112.0805 74.80748 
  111.778 74.661636 111.4055 74.688309 110.9844 74.592484 
  111.0519 74.570251 110.5222 74.473038 110.3469 74.491364 
  110.2805 74.47525 110.3897 74.443588 110.3658 74.414139 
  110.2016 74.365807 109.5577 74.307213 109.7575 74.28331 
  109.9153 74.305817 109.9775 74.289703 109.9441 74.232193 
  109.8453 74.175537 109.4958 74.079147 109.0811 74.036636 
  108.5241 73.802467 108.4339 73.813873 108.4914 73.770248 
  108.0661 73.631088 107.1425 73.6147 107.1022 73.570534 
  107.1586 73.558296 107.1597 73.539139 106.8794 73.44165 
  106.8111 73.344971 106.6714 73.303307 106.2044 73.310257 
  106.0453 73.260246 106.0189 73.148323 105.8491 73.098038 
  105.8269 72.994713 105.5014 72.860527 105.1292 72.786362 
  105.0714 72.764137 105.4566 72.759979 105.6669 72.81192 
  106.0202 72.951637 106.288 72.960251 106.2097 72.97998 
  106.1825 73.051651 106.1933 73.136642 106.3528 73.190262 
  106.7919 73.139977 107.7922 73.17276 108.0694 73.244423 
  108.353 73.219704 108.393 73.245796 108.3594 73.268044 
  108.2077 73.268311 108.2289 73.294418 108.3616 73.299698 
  109.2419 73.39415 109.2586 73.415253 109.21 73.435532 
  109.2125 73.46637 109.4178 73.411926 109.4294 73.444702 
  109.1769 73.515533 109.1922 73.545807 109.245 73.52887 
  109.6005 73.445534 110.1022 73.508324 110.1558 73.544693 
  110.1089 73.556091 110.1186 73.576103 110.4241 73.603867 
  110.4 73.627472 110.4639 73.646362 110.6103 73.64386 
  110.9219 73.700813 110.9 73.764687 110.6483 73.787483 
  110.2411 73.695251 109.798 73.700256 109.733 73.662201 
  109.6333 73.695824 109.5247 73.789703 109.5369 73.822197 
  109.8319 73.875526 109.9033 73.970543 110.0311 74.009697 
  110.2272 74.022751 111.023 73.905807 111.1 73.947197 
  111.0622 73.982193 111.1075 74.019699 111.1972 74.038589 
  111.5183 74.048576 111.5822 74.029984 111.5361 74.004433 
  111.2314 73.993874 111.2014 73.967484 111.3183 73.844147 
  111.6969 73.758034 112.2483 73.706917 112.6064 73.719147 
  112.8447 73.748306 112.9603 73.806641 112.9422 73.843872 
  112.8136 73.966919 112.825 73.997192 112.8878 73.964981 
  113.4033 73.67775 113.418 73.580811 113.2591 73.549423 
  113.1447 73.439972 113.4994 73.334137 113.4847 73.286362 
  113.5202 73.093033 113.4519 73.005814 113.4864 72.958313 
  113.415 72.928589 113.1172 72.86026 113.0897 72.831917 
  113.1864 72.717758 113.3014 72.678307 113.6142 72.624969 
  114.0919 72.594971) #(128.60941 72.527481 128.1006 72.631989 
  128.68829 72.672203 128.9091 72.636093 128.9722 72.590813 
  128.8013 72.554703 128.60941 72.527481) 
#(-119.7363 74.024727 -119.8042 74.046921 -119.8242 74.094704 
  -119.6397 74.199142 -120.9717 74.41803 -121.0022 74.467758 
  -121.1508 74.509979 -121.6519 74.548576 -122.1186 74.491928 
  -122.8664 74.448868 -124.7556 74.342758 -124.775 74.319138 
  -124.6042 74.312469 -124.6931 74.269417 -124.5581 74.266083 
  -124.4267 74.109703 -124.4678 74.094971 -124.2558 73.953583 
  -124.2175 73.872757 -124.1342 73.848312 -123.9078 73.834702 
  -123.7747 73.76442 -123.8442 73.696091 -124.0678 73.654694 
  -124.0786 73.622757 -124.0389 73.586906 -124.1014 73.523857 
  -124.3056 73.478592 -124.4458 73.411087 -124.4094 73.366638 
  -124.6708 73.186653 -124.6447 73.156372 -124.7947 73.134697 
  -124.8625 73.068863 -124.7261 73.006638 -124.4972 72.977203 
  -124.4972 72.919693 -125.1 72.871368 -125.1125 72.85025 
  -125.0261 72.821091 -124.9678 72.705261 -124.96 72.680817 
  -125.0703 72.636093 -125.0781 72.616364 -124.9689 72.60498 
  -124.9528 72.565262 -125.2639 72.494423) 
#(126.5106 72.400414 126.4969 72.402367 126.4277 72.427467 
  126.3022 72.507477 126.3841 72.618874 126.3378 72.722473 
  126.4497 72.791641 126.33 72.890533 126.3619 72.91748 
  126.6653 72.995529 126.78 73.089417 126.7347 73.130249 
  126.7628 73.173576 126.6005 73.257477 126.6541 73.304138 
  126.5611 73.377762 126.6594 73.386093 126.6594 73.416924 
  126.7269 73.444427 126.8275 73.37886 126.8419 73.436081 
  126.9305 73.427467 126.9228 73.495247 126.8722 73.511093 
  126.9136 73.53331 127.2378 73.532471 127.4439 73.479424 
  127.7269 73.479424 127.9842 73.458313 127.8972 73.431374 
  128.07359 73.399696 127.9608 73.345543 128.3652 73.352203 
  128.23579 73.261368 128.6552 73.257751 128.9561 73.183296 
  128.948 73.145813 128.8477 73.149696 128.8652 73.119423 
  128.8158 73.094704 128.7872 73.063583 129.0974 73.130814 
  129.1183 73.094704 129.0527 73.023323 128.93111 72.984154 
  128.33659 72.915527 128.21049 72.86554 128.2444 72.823868 
  128.1741 72.807747 127.3358 72.710823 127.1308 72.639137 
  126.5208 72.526367 126.5819 72.411362 126.5106 72.400414) 
#(126.1255 72.300537 125.6917 72.375809 125.193 72.550262 
  124.9005 72.598312 124.7411 72.674149 124.3828 72.673309 
  124.073 72.768593 122.7069 72.921371 122.4378 72.971336 
  122.4366 72.972397 122.4653 73.012756 122.5216 73.022202 
  122.7016 73.01442 122.9883 72.938873 123.2089 72.92247 
  123.348 72.985809 123.3094 73.020813 123.4158 73.092758 
  123.4611 73.067749 123.4672 73.105797 123.3878 73.122757 
  123.3989 73.170258 123.5158 73.16275 123.6589 73.16803 
  123.6069 73.188309 123.6655 73.20636 123.38 73.296921 
  123.3261 73.343307 123.4136 73.383591 123.2191 73.404694 
  123.3103 73.463318 123.3633 73.443314 123.4111 73.444138 
  123.2744 73.528587 123.2575 73.55748 123.368 73.557747 
  123.3158 73.591919 123.4211 73.578033 123.3769 73.662483 
  123.5311 73.689697 123.5491 73.709702 123.6278 73.696373 
  123.5761 73.673859 123.6408 73.625809 123.6855 73.60025 
  123.9908 73.62915 123.988 73.647751 123.908 73.673576 
  123.9327 73.737762 123.8964 73.75415 123.9347 73.771637 
  124.0411 73.723312 124.0047 73.698303 124.0352 73.681091 
  124.2244 73.719971 124.2247 73.751083 124.3819 73.80275 
  124.9125 73.683594 124.9936 73.621643 125.0611 73.653313 
  125.0461 73.6772 125.133 73.685257 125.2141 73.64415 
  125.1689 73.556641 125.2514 73.535812 125.3433 73.54776 
  125.3708 73.596649 125.648 73.523033 125.5164 73.448868 
  125.5722 73.401917 125.8764 73.461639 125.8172 73.488037 
  125.9061 73.509407 125.9091 73.534416 125.9719 73.527206 
  125.9539 73.457474 125.9089 73.429977 125.9608 73.424423 
  126.0183 73.458862 126.0172 73.507477 126.2878 73.550812 
  126.4022 73.507751 126.3286 73.425812 126.1819 73.459427 
  126.1472 73.434982 126.2308 73.416367 126.2483 73.392471 
  126.1566 73.37442 126.415 73.408577 126.5472 73.345261 
  126.5561 73.23497 126.715 73.084427 126.67 73.050537 
  126.3639 72.938873 126.2939 72.899696 126.2866 72.85553 
  126.3816 72.798859 126.378 72.77359 126.268 72.695534 
  126.3017 72.635246 126.248 72.531647 126.253 72.494423 
  126.3866 72.408577 126.383 72.389687 126.1255 72.300537) 
#(76.973587 72.281647 77.801933 72.300537 78.393044 72.489151 
  78.356369 72.519417 78.184982 72.576103 77.807213 72.619713 
  77.580261 72.624969 77.304428 72.535812 77.234421 72.460251 
  76.888313 72.354713 76.868446 72.343628 76.86116 72.329536 
  76.890533 72.293587 76.973587 72.281647) 
#(-22.277229 72.113861 -22.152229 72.136642 -22.12611 72.170807 
  -22.19417 72.203873 -22.06139 72.269974 -22.31278 72.253036 
  -22.31139 72.301651 -22.59306 72.344971 -22.742781 72.38942 
  -22.75695 72.44136 -22.65028 72.466637 -22.034451 72.386093 
  -21.932501 72.399139 -21.941669 72.478867 -22.02306 72.497482 
  -22.205 72.482758 -22.16445 72.5047 -22.96806 72.721077 
  -23.11195 72.819138 -23.567499 72.831917 -23.73473 72.859703 
  -24.301109 72.866638 -24.48473 72.825813 -24.40167 72.724136 
  -24.40361 72.65303 -24.22583 72.542213 -24.15167 72.543297 
  -24.01111 72.509407 -24.004999 72.482193 -24.06139 72.474426 
  -24.05945 72.439697 -23.946951 72.466637 -23.06139 72.303307 
  -22.99334 72.251648 -22.68306 72.166367 -22.500839 72.204971 
  -22.509171 72.185257 -22.596109 72.160248 -22.563061 72.13887 
  -22.277229 72.113861) #(128.7269 72.074692 128.4758 72.137756 
  128.5127 72.15831 128.53799 72.178307 128.15331 72.242477 
  127.848 72.351357 127.4614 72.441933 126.6759 72.42894 
  126.6503 72.454971 126.6827 72.49942 127.2783 72.608307 
  127.8455 72.636093 128.7294 72.462753 129.1299 72.478027 
  129.2766 72.451637 129.2394 72.413589 129.4861 72.352203 
  129.3214 72.284416 129.5316 72.242477 129.5563 72.218872 
  129.24361 72.132477 129.4861 72.126923 129.3499 72.092758 
  128.7269 72.074692) #(-94.056122 71.982758 -94.031952 72.063026 
  -94.190292 72.01915 -94.228622 72.039978 -94.066963 72.076637 
  -94.014183 72.163857 -93.787231 72.322746 -93.628067 72.341919 
  -93.463348 72.462196 -93.498917 72.521927 -93.606117 72.587196 
  -93.769447 72.624969 -93.823334 72.65303 -93.791122 72.689148 
  -93.794167 72.738861 -94.327507 72.721649 -94.321953 72.759407 
  -94.263062 72.774139 -93.603348 72.774979 -93.334457 72.811371 
  -93.222778 72.780807 -92.293327 72.706093 -92.109734 72.739151 
  -91.845863 72.846649 -91.368057 73.200813 -91.375557 73.210533 
  -91.63446 73.228867 -91.262512 73.26387 -90.921402 73.495247 
  -90.94696 73.514687 -90.989731 73.553307 -90.805283 73.546921 
  -90.583633 73.655807 -90.357529 73.806641 -90.382782 73.85025 
  -90.32724 73.872192 -90.275284 73.838593 -90.215561 73.878036 
  -90.225021 73.908577 -90.896973 73.98497 -91.838364 74.01886 
  -92.113358 73.981369 -92.113892 73.952187 -92.329727 73.942467 
  -92.273621 73.99054 -92.334473 74.031372 -92.638062 74.103027 
  -92.765556 74.085533 -92.748901 74.113312 -92.796677 74.124969 
  -93.431953 74.172203 -93.730827 74.154137 -93.761398 74.12915 
  -93.741127 74.087753 -93.95224 74.13887 -94.325577 74.123306 
  -95.088058 74.021362 -95.245293 74.010246 -95.325012 73.952477 
  -95.311401 73.885246 -95.154167 73.823593 -95.024727 73.855263 
  -94.958344 73.831917 -95.116119 73.806641 -95.089462 73.78331 
  -94.977226 73.733307 -94.649727 73.670807 -94.652237 73.64859 
  -95.041962 73.675812 -95.283623 73.76915 -95.450844 73.771088 
  -95.682251 73.711906 -95.676392 73.664978 -95.723343 73.639977 
  -95.619743 73.622192 -95.545013 73.57164 -95.700562 73.553864 
  -95.632782 73.527763 -95.684174 73.450256 -95.6539 73.412483 
  -95.600853 73.381638 -95.618896 73.348862 -95.585564 73.298027 
  -95.597237 73.219421 -95.573624 73.15303 -95.500313 73.128593 
  -95.647781 73.116638 -95.688606 73.080544 -95.643623 73.04747 
  -95.7164 72.993027 -95.623337 72.92276 -95.675293 72.841087 
  -95.652237 72.788589 -95.550293 72.781082 -95.600281 72.722748 
  -95.458618 72.682213 -95.133621 72.460251 -95.236389 72.428589 
  -95.15889 72.345261 -95.214752 72.200256 -95.15889 72.135803 
  -95.204727 72.102753 -95.083618 72.097748 -95.196671 72.052467 
  -95.196671 71.986076 -94.69278 72.013313 -94.056122 71.982758) 
#(55.223572 71.924347 55.386662 71.94165 55.348881 71.97554 
  55.452492 72.053589 55.34444 72.064697 55.57526 72.182747 
  55.55444 72.213318 55.374439 72.301361 55.485821 72.381638 
  55.450829 72.436653 55.251381 72.435806 55.1325 72.453583 
  55.541931 72.474701 55.548328 72.521362 55.265541 72.584702 
  55.608318 72.536087 55.68111 72.571907 55.620541 72.616364 
  55.726379 72.639977 55.620541 72.700813 55.945541 72.666641 
  55.829708 72.745796 55.42944 72.784149 55.492222 72.810806 
  56.032768 72.773857 56.16415 72.792213 56.249149 72.946373 
  56.23027 72.97554 55.70805 72.948303 55.627781 72.96553 
  56.37999 73.006638 56.461658 73.051933 56.267208 73.071373 
  55.808041 73.059143 56.236938 73.091637 56.587769 73.130814 
  56.559719 73.160538 56.413879 73.229424 54.91444 73.422203 
  54.52721 73.370529 54.404709 73.310532 54.055538 73.266083 
  53.78944 73.3022 53.697781 73.286087 53.570271 73.231369 
  53.42387 73.237473 53.15332 73.155807 53.129711 73.088593 
  53.38166 73.008324 53.139721 73.006363 53.138599 72.959976 
  53.209709 72.935532 53.39193 72.931374 53.38554 72.904137 
  52.986382 72.921082 52.589161 72.85054 52.376381 72.724701 
  52.544159 72.674149 52.786381 72.676933 52.943138 72.672653 
  53.195469 72.656616 53.21944 72.647202 52.923321 72.667213 
  52.734989 72.617752 52.810829 72.611649 52.748878 72.586357 
  52.74221 72.553307 53.0975 72.594704 52.92387 72.553864 
  52.727211 72.5047 52.675282 72.472748 52.82111 72.444702 
  52.660831 72.426651 52.69305 72.366928 52.8036 72.347748 
  52.791382 72.33609 52.57943 72.367477 52.6786 72.334702 
  52.684429 72.308868 52.572208 72.279419 52.575272 72.258591 
  52.409721 72.282204 52.488609 72.239151 52.402771 72.222198 
  52.458611 72.182747 52.479721 72.144699 52.365002 72.157471 
  52.405548 72.122757 52.35194 72.06192 52.186939 72.082748 
  52.194988 72.129433 52.059158 72.068314 51.84193 72.158577 
  51.57444 72.070824 51.44194 71.936371 51.405819 71.805359) 
#(-83.635452 72.983582 -83.670303 72.998306 -85.170578 73.210823 
  -85.188629 73.228867 -85.11586 73.314423 -84.940567 73.363312 
  -84.756683 73.381088 -84.629204 73.298309 -84.339752 73.226089 
  -84.656418 73.390533 -84.625023 73.401367 -84.171692 73.47525 
  -83.724731 73.41304 -83.689468 73.323593 -83.630859 73.297203 
  -83.591141 73.307213 -83.633636 73.428864 -83.679749 73.453873 
  -83.978912 73.496643 -83.979187 73.518044 -83.176682 73.661926 
  -83.045837 73.645813 -82.841141 73.732758 -81.972504 73.730797 
  -81.47641 73.698029 -81.260033 73.563583 -81.180573 73.415253 
  -81.216141 73.303864 -81.19252 73.260529 -80.596413 73.148033 
  -80.549469 73.081917 -80.650864 72.969147 -80.618073 72.911087 
  -80.28363 72.777481 -80.258072 72.724426 -80.464752 72.665253 
  -80.556412 72.607193 -80.523911 72.577477 -80.813919 72.497757 
  -81.031418 72.390808 -81.376419 72.241364 -81.229736 72.258591 
  -80.880569 72.438309 -80.554749 72.512482 -80.509193 72.496643 
  -80.514473 72.3797 -80.680573 72.342194 -80.825577 72.257202 
  -80.839188 72.199692 -80.962799 72.196373 -80.569473 72.088318 
  -80.574188 72.068314 -80.646133 72.063309 -80.771408 72.104141 
  -80.99614 72.06665 -81.061974 72.054138 -81.046967 72.039978 
  -80.847504 72.056641 -80.793083 72.027763 -80.841423 71.939972 
  -80.983627 71.886368 -80.9039 71.885246 -80.756126 71.934143 
  -80.746964 71.982483 -80.556137 72.006927 -80.350594 72.069138 
  -80.352524 72.095543 -80.455307 72.146637 -80.486969 72.189423 
  -80.235313 72.203308 -80.306396 72.255249 -80.261139 72.294983 
  -80.194473 72.28775 -79.991676 72.176651 -79.704193 72.128311 
  -79.691971 72.141647 -79.924179 72.190536 -80.152252 72.310532 
  -80.115593 72.359421 -79.868362 72.43248 -79.861954 72.467484 
  -79.83696 72.498581 -79.734467 72.484421 -79.695557 72.460823 
  -79.76947 72.428864 -79.769203 72.412201 -79.595863 72.334702 
  -79.768913 72.245247 -79.769737 72.225807 -79.712784 72.21109 
  -79.689194 72.243591 -79.535858 72.268593 -79.450577 72.194977 
  -79.467239 72.24942 -79.543617 72.285812 -79.342529 72.400253 
  -79.16864 72.353867 -79.027786 72.277481 -78.965851 72.285812 
  -78.949463 72.266647 -79.036682 72.069427 -79.206703 71.986649 
  -79.190582 71.958313 -78.996689 71.965263 -78.585571 71.865807 
  -78.511139 71.8647 -78.51918 71.880249 -78.800583 71.970543 
  -78.924454 72.020538 -78.873901 72.0672 -78.878906 72.147476 
  -78.854462 72.173027 -78.512527 72.101089 -78.460861 72.073303 
  -78.381973 71.92804 -78.156967 71.811371 -77.906967 71.770538 
  -78.14003 71.830544 -78.321693 71.93692 -78.27919 71.953583 
  -78.14003 71.939423 -77.797523 71.792763 -77.752518 71.749153 
  -77.698349 71.81192 -77.866127 71.835251 -78.053093 71.929138 
  -78.334183 71.991364 -78.392242 72.098587 -78.696693 72.163589 
  -78.869461 72.229713 -78.79335 72.254967 -78.751968 72.28775 
  -78.795303 72.306091 -78.805023 72.333038 -78.604187 72.359421 
  -78.515846 72.330544 -78.52919 72.289703 -78.422241 72.170807 
  -78.384193 72.175537 -78.472794 72.242477 -78.458908 72.299973 
  -78.408363 72.325813 -77.793907 72.242203 -77.64447 72.186653 
  -77.650864 72.094704 -77.58725 72.134697 -77.622238 72.164429 
  -77.56752 72.180817 -76.997223 72.128036) 
#(-107.8062 71.612762 -107.9828 71.633324 -107.9761 71.666367 
  -108.0869 71.719704 -108.1925 71.699692 -108.2428 71.718582 
  -108.1653 71.7547 -108.2808 71.786926 -108.2914 71.881927 
  -108.1897 71.933296 -108.1914 71.960533 -108.2406 71.964417 
  -108.3328 71.925812 -108.2939 71.976357 -108.4122 71.989967 
  -108.4039 72.118317 -108.5364 72.142197 -108.6636 72.362762 
  -108.5881 72.505539 -108.6214 72.549973 -108.7036 72.580261 
  -108.8889 72.597748 -108.8511 72.567467 -109.0433 72.567467 
  -109.0336 72.61554 -108.9575 72.65831 -108.9636 72.679428 
  -109.6586 72.844704 -109.75 72.883873 -109.6181 72.909416 
  -109.735 72.934418 -109.8539 72.91748 -109.9189 72.968033 
  -110.4325 73.01442 -110.7083 73.002472 -110.7539 72.977753 
  -110.7428 72.957199 -110.4936 72.837753 -110.2117 72.818314 
  -110.1714 72.774979 -110.2408 72.752762 -110.2522 72.731644 
  -109.7703 72.722198 -109.8569 72.702759 -109.83 72.684982 
  -109.8328 72.663307 -110.0769 72.720993 -110.2128 72.711639 
  -110.1783 72.680817 -110.2631 72.676086 -110.2417 72.646088 
  -110.0931 72.656372 -109.8125 72.514687 -109.8886 72.484703 
  -110.2422 72.566933 -110.2367 72.548859 -109.8303 72.452187 
  -109.7828 72.429428 -109.9711 72.460251 -110.0506 72.433868 
  -110.1553 72.480263 -110.3842 72.555527 -110.5111 72.511642 
  -110.5142 72.488586 -110.6017 72.498871 -110.4789 72.5522 
  -110.7153 72.573029 -110.8333 72.51915 -110.797 72.472748 
  -111.002 72.471359 -110.9878 72.434418 -111.0842 72.407761 
  -111.0953 72.3797 -111.0653 72.344971 -111.0331 72.281921 
  -111.2775 72.36998 -111.3645 72.342484 -111.3622 72.36554 
  -111.2025 72.460251 -111.3094 72.460823 -111.5883 72.376373 
  -111.5892 72.342758 -111.4245 72.337196 -111.5908 72.299149 
  -111.7503 72.197746 -111.7861 72.222748 -111.7453 72.251923 
  -111.6517 72.319138 -111.6706 72.354141 -111.7944 72.323029 
  -111.8767 72.339417 -111.8597 72.373306 -111.6511 72.408859 
  -111.2628 72.579147 -111.2083 72.680817 -111.265 72.732758 
  -112.5636 72.959137 -113.0628 73.007477 -113.3028 72.948868 
  -113.5989 72.782761 -113.6064 72.758324 -113.41 72.729424 
  -113.4428 72.672203 -113.6997 72.604141 -113.7292 72.61554 
  -113.5842 72.664139 -113.5161 72.70192 -114.1031 72.632202 
  -114.3514 72.55748 -114.4633 72.560257 -114.6045 72.599953) 
#(180.0 71.539047 180.0 90.0 -180.0 90.0 -180.0 71.538849) 
#(-53.113899 71.538589 -52.759178 71.654984 -52.77306 71.661926 
  -53.43779 71.665817 -53.471951 71.65831 -53.442219 71.556923 
  -53.389179 71.543869 -53.113899 71.538589) 
#(179.8602 71.516647 179.9355 71.528214 180.0 71.539047) 
#(137.6608 71.415253 137.51221 71.476357 137.2652 71.487473 
  137.3958 71.447479 137.3127 71.429977 136.9913 71.515533 
  137.02769 71.532204 137.7502 71.594421 137.8902 71.570251 
  137.96249 71.505981 137.7905 71.434143 137.6608 71.415253) 
#(-51.34552 71.482986 -51.711948 71.505249 -52.399448 71.377472 
  -52.707512 71.381363 -52.990841 71.42276 -52.69862 71.521637 
  -52.430561 71.562759 -52.12529 71.57164 -51.7514 71.611649 
  -51.642231 71.704147 -51.664459 71.727753 -51.783352 71.721649 
  -51.863899 71.655258 -52.152241 71.611923 -52.5714 71.630249 
  -52.57806 71.689423 -52.902512 71.679977 -53.26334 71.708313 
  -52.921398 71.81665 -52.856682 71.861076 -52.904171 71.873871 
  -52.908352 71.908859 -52.700569 71.992203 -52.7089 72.015533 
  -52.78112 72.011368 -53.03307 71.905533 -52.983898 71.842484 
  -53.328899 71.770813 -53.373341 71.779694 -53.321949 71.822197 
  -53.31918 71.856918 -53.381401 71.917763 -53.393341 72.033859 
  -53.44223 72.063583 -53.690571 72.118317 -53.72168 72.144417 
  -53.753071 72.242752 -53.849731 72.309692 -53.82362 72.336906 
  -53.560291 72.348312 -53.62196 72.362198 -53.939739 72.336906 
  -53.950569 72.313309 -53.84779 72.258324 -53.845291 72.214706 
  -53.801682 72.131363 -53.581402 72.044418 -53.396679 71.851929 
  -53.412231 71.834137 -53.6339 71.736923 -53.878342 71.746918 
  -53.765011 71.715263 -53.72168 71.679428 -53.730839 71.649406 
  -53.801399 71.628311 -53.933338 71.642471 -54.03307 71.711639 
  -54.100288 71.707474 -54.041401 71.676651 -54.099461 71.633591 
  -53.848068 71.546921 -53.856121 71.508591 -53.915852 71.441933 
  -54.418339 71.363312 -54.878071 71.361923 -54.970009 71.4272 
  -55.12112 71.428307 -55.18362 71.464142 -55.267509 71.483307 
  -55.116959 71.386642 -55.165569 71.377472 -55.384178 71.39859 
  -55.555561 71.478867 -55.677792 71.62915 -55.60751 71.624687 
  -55.583069 71.644417 -55.879459 71.67276 -55.85223 71.713867 
  -55.443901 71.80275 -55.25806 71.768593 -55.3764 71.829971 
  -55.320011 71.881638 -54.822788 71.918587 -54.52029 72.059982 
  -54.430561 72.219971 -54.64806 72.058868 -54.626678 72.018044 
  -54.92001 71.931374 -55.267231 71.923859 -55.589741 71.984703 
  -55.51334 72.041924 -55.28307 72.061653 -55.403629 72.080261 
  -55.40279 72.093872 -54.8839 72.246368 -54.944462 72.362198 
  -54.764729 72.350807 -54.811401 72.364433 -54.97084 72.40387 
  -55.210781 72.373459 -55.285839 72.372482 -55.310841 72.464981 
  -55.341671 72.460533 -55.345852 72.401917 -55.507229 72.389687 
  -55.626122 72.421082 -55.643902 72.447746 -55.470291 72.521927 
  -55.373619 72.504967 -54.982792 72.507202 -55.01862 72.526917 
  -54.986401 72.573593 -54.65807 72.609154 -54.642509 72.62915 
  -54.843899 72.633873 -54.872231 72.672203 -54.589741 72.694138 
  -54.753071 72.743027 -54.53529 72.772202 -54.569462 72.796921 
  -54.825569 72.758873 -54.92168 72.779419 -54.605011 72.828033 
  -54.697788 72.902481 -54.81139 72.932747 -54.780849 72.984154 
  -54.798069 72.998581 -55.017231 72.994713 -55.052792 73.011642 
  -55.010288 73.058029 -55.027241 73.062759 -55.158352 73.012756 
  -55.220009 73.036926 -55.676121 73.055817 -55.709461 73.092758 
  -55.651951 73.121094 -55.479179 73.106087 -55.35973 73.164139 
  -55.360569 73.179428 -55.14529 73.181923 -55.147511 73.212196 
  -55.351959 73.238312 -55.45863 73.259697 -55.33112 73.309982 
  -55.367229 73.327759 -55.254181 73.388313 -55.099941 73.353073) 
#(-98.742477 71.270462 -98.198334 71.414703 -98.041397 71.530807 
  -98.497513 71.733307 -98.450562 71.794144 -98.263062 71.866638 
  -98.25528 71.902481 -98.212227 71.878593 -98.325562 71.798309 
  -98.355827 71.722748 -98.196671 71.643593 -97.896118 71.641922 
  -97.434448 71.617752 -97.084167 71.700256 -96.978348 71.795258 
  -96.861954 71.803864 -96.775284 71.843582 -96.68251 71.840813 
  -96.743057 71.819702 -96.726959 71.793587 -96.565018 71.823868 
  -96.503342 71.90303 -96.523064 71.934418 -96.736679 71.899406 
  -96.761948 71.918587 -96.638344 71.957474 -96.565567 71.946907 
  -96.502502 71.97554 -96.502228 72.038589 -96.672501 72.012756 
  -96.866959 72.041092 -96.508621 72.084976 -96.483063 72.113037 
  -96.53334 72.236923 -96.589737 72.250259 -96.561401 72.275528 
  -96.871948 72.321091 -96.29834 72.415817 -96.302231 72.433868 
  -96.448898 72.601639 -96.585281 72.693863 -96.517502 72.714706 
  -96.56778 72.753311 -96.882507 72.686081 -97.070282 72.608582 
  -97.196671 72.604424 -97.190567 72.640533 -97.046402 72.711639 
  -97.037231 72.746643 -97.236679 72.842484 -97.417793 72.864967 
  -97.266678 72.878593 -97.225014 72.939972 -97.299728 72.969704 
  -97.684448 73.033043 -97.99501 73.037483 -98.283623 72.963318 
  -98.428337 72.856087 -98.450562 72.874969 -98.427513 72.943588 
  -98.510559 73.009407 -97.708618 73.304703 -97.172234 73.352753 
  -97.150284 73.389977 -97.248901 73.429138 -97.173073 73.443588 
  -97.172501 73.460251 -97.248901 73.47554 -97.623611 73.45636 
  -97.667511 73.479424 -97.638062 73.538589 -97.436401 73.525528 
  -97.445282 73.579971 -97.202507 73.557213 -96.968903 73.633324 
  -96.932793 73.6922 -96.962509 73.738586 -97.223618 73.856369 
  -97.621117 73.89386 -97.783073 73.858582 -97.837509 73.867477 
  -97.737228 73.900818 -97.74556 73.909973 -97.887802 73.899406 
  -98.008057 73.838318 -98.856667 73.752762 -99.136124 73.742752 
  -99.163071 73.688026 -99.247787 73.696091 -99.20668 73.725807 
  -99.398064 73.798859 -99.795288 73.872192 -99.816116 73.936081 
  -99.998062 73.943863) #(-99.998062 73.943863 -100.2658 73.899979 
  -100.2997 73.86026 -100.2292 73.831917 -100.0267 73.836906 
  -99.880836 73.900528 -99.843338 73.878311 -99.849731 73.859154 
  -99.955841 73.813873 -100.0269 73.729713 -100.1494 73.799149 
  -100.8864 73.827477 -101.1183 73.723312 -100.8539 73.662201 
  -100.9117 73.622757 -100.5517 73.598862 -100.5439 73.556374 
  -100.5875 73.530533 -100.5986 73.491089 -100.415 73.41803 
  -100.4306 73.406921 -100.5186 73.416924 -100.9094 73.599701 
  -101.2172 73.604141 -101.6167 73.48526 -101.0011 73.28804 
  -100.8233 73.260803 -100.3361 73.324982 -100.4022 73.365807 
  -100.3336 73.388313 -100.0656 73.248032 -99.794724 73.213318 
  -99.819733 73.193314 -100.0533 73.186371 -100.3014 73.281082 
  -100.5231 73.23053 -100.4728 73.193314 -100.6078 73.146362 
  -100.5147 73.114433 -100.4489 73.08136 -100.2956 73.118027 
  -100.17 73.078583 -100.2208 73.04248 -100.1406 73.048027 
  -100.1286 73.010529 -100.0467 72.952187 -100.0775 72.886917 
  -100.3261 72.878036 -100.3225 72.910812 -100.2611 72.921082 
  -100.2631 72.960251 -100.3817 72.949142 -100.4186 72.983871 
  -100.3433 73.01387 -100.317 73.034149 -100.4103 73.034973 
  -100.4989 72.950531 -100.4408 72.91803 -100.3336 72.848038 
  -100.3153 72.802467 -100.4483 72.735527 -100.8281 72.758591 
  -100.8325 72.72554 -100.8414 72.70192 -101.0575 72.686653 
  -101.2964 72.74498 -101.3222 72.778313 -101.42 72.786087 
  -101.455 72.821373 -101.5717 72.890259 -101.6345 72.886917 
  -101.7397 72.97525 -101.8842 73.024696 -101.9072 73.05275 
  -102.1506 73.086357 -102.5178 73.021362 -102.6128 72.896637 
  -102.7495 72.8172 -102.7614 72.779694 -102.6531 72.679138 
  -101.912 72.472198 -101.8842 72.397202 -101.8903 72.362473 
  -101.5111 72.279137 -101.4025 72.244141 -101.3958 72.286926 
  -101.2328 72.333588 -101.0375 72.276367 -101.0556 72.236649 
  -101.0214 72.202187 -100.8856 72.207748 -100.6345 72.185532 
  -100.1158 71.893593 -99.872513 71.858032 -99.821671 71.803307 
  -99.732513 71.776093 -99.558899 71.613037 -99.369453 71.575531 
  -99.319458 71.449982 -99.22084 71.342194 -98.960564 71.379967 
  -98.742477 71.270462) #(-114.6045 72.599953 -114.2797 72.676361 
  -114.3278 72.688873 -114.3575 72.741364 -114.3281 72.754433 
  -113.9858 72.80304 -113.9689 72.824982 -114.055 72.883591 
  -113.9569 73.142471 -114.0561 73.233582 -114.275 73.332199 
  -114.5408 73.373581 -115.9703 73.141083 -117.3911 72.906921 
  -117.8908 72.692749 -118.0408 72.673027 -118.5503 72.483307 
  -118.5886 72.416641 -118.555 72.380814 -118.4467 72.345261 
  -118.177 72.337753 -118.1214 72.308029 -118.1053 72.244713 
  -118.1283 72.222198 -118.5886 72.176086 -118.7175 72.116928 
  -118.7167 72.06665 -118.9458 71.991364 -119.1056 71.876648 
  -119.12 71.713318 -119.0406 71.623032 -118.8683 71.580261 
  -118.8556 71.662483 -118.5664 71.66275 -118.3861 71.619713 
  -118.4283 71.578873 -118.2858 71.585533 -118.1028 71.654694 
  -117.7706 71.67276 -117.7069 71.662483 -117.947 71.633873 
  -117.9572 71.598587 -117.7203 71.574692 -118.0861 71.540253 
  -118.2633 71.494141 -118.3147 71.452187 -118.2836 71.404694 
  -118.1689 71.378036 -117.6814 71.3797 -117.5172 71.379433 
  -117.4833 71.43248 -117.6317 71.45636 -117.5942 71.477478 
  -117.5628 71.499687 -117.3783 71.454147 -117.4167 71.391373 
  -117.3772 71.382751 -117.142 71.414429 -115.6378 71.556923 
  -115.4561 71.527763 -115.5558 71.513603 -115.55 71.504433 
  -115.425 71.488586 -115.0817 71.527206 -115.0667 71.518593 
  -115.4156 71.449692 -115.6208 71.498581 -116.1514 71.435532 
  -116.2111 71.420532 -115.7267 71.381363 -115.7608 71.365807 
  -116.1692 71.348312 -116.2089 71.364151 -116.8247 71.280533 
  -116.8161 71.261917) #(-52.936119 71.147202 -52.642231 71.169144 
  -52.592232 71.23497 -52.361118 71.270813 -52.328621 71.291924 
  -52.418339 71.352753 -52.970852 71.384407 -53.15168 71.345261 
  -53.182789 71.315811 -53.10112 71.196907 -52.936119 71.147202) 
#(-125.2639 72.494423 -125.5344 72.295807 -125.4786 72.286926 
  -125.5422 72.251373 -125.6567 72.251083 -125.6731 72.213318 
  -125.5689 72.174149 -125.6942 72.164703 -125.7928 72.113037 
  -125.7175 72.096359 -125.7247 72.051933 -125.7878 71.982193 
  -125.4164 71.974136 -124.9483 71.96109 -124.9539 71.938026 
  -124.0133 71.685806 -123.6342 71.472473 -123.4803 71.293297 
  -123.3033 71.149696 -123.095 71.079971 -122.7811 71.08609 
  -122.5939 71.17804 -122.1442 71.260803 -122.0433 71.305252 
  -121.7036 71.460823 -121.5819 71.454422 -121.5317 71.429428 
  -121.5375 71.412483 -121.3944 71.380249 -120.7667 71.459702 
  -120.5433 71.516647 -120.4731 71.565536 -120.3775 71.694138 
  -120.4264 71.744423 -120.3792 71.883873 -120.4317 71.908043 
  -120.4392 71.958313 -120.1758 72.094421 -120.1453 72.149979 
  -120.2614 72.2397 -120.2411 72.262482 -120.14 72.267761 
  -120.1761 72.246368 -120.1675 72.230797 -119.787 72.223587 
  -119.3025 72.356644 -119.3325 72.387192 -119.305 72.444702 
  -119.1708 72.542763 -119.1861 72.582474 -119.1589 72.624969 
  -118.8858 72.693588 -117.6425 72.992203 -117.2442 73.054703 
  -116.8383 73.16304 -115.8347 73.339981 -115.315 73.479713 
  -115.325 73.506927 -115.4486 73.588593 -115.7636 73.685257 
  -116.785 74.059692 -117.5125 74.238586 -118.1225 74.275818 
  -118.69 74.217758 -118.8861 74.171921 -118.8672 74.151367 
  -118.807 74.133873 -118.8006 74.09581 -118.9731 74.000259 
  -119.1872 73.987762 -119.1472 74.062187 -119.0808 74.077759 
  -119.0706 74.1147 -119.1311 74.126083 -119.0908 74.156921 
  -119.1211 74.199692 -119.1847 74.216919 -119.5008 74.213867 
  -119.755 74.079147 -119.7363 74.024727) 
#(-53.649448 71.024139 -53.452789 71.049423 -53.3764 71.114967 
  -53.39584 71.15303 -53.584461 71.300812 -53.6464 71.311081 
  -53.973629 71.151367 -53.98418 71.111076 -53.916679 71.083862 
  -53.649448 71.024139) #(180.0 71.539047 180.0 71.383476 
  180.0 71.193481 180.0 71.003487) 
#(-25.688101 73.951553 -25.734449 73.919693 -25.586941 73.864723 
  -25.55139 73.806374 -25.089729 73.690277 -25.11195 73.62886 
  -25.024441 73.591637 -24.69278 73.525818 -24.711941 73.490807 
  -25.315281 73.461639 -25.49778 73.396942 -25.422779 73.392761 
  -25.44556 73.346077 -25.78722 73.249977 -26.1675 73.243874 
  -26.458059 73.339981 -26.57028 73.319702 -26.817499 73.334991 
  -27.01973 73.389977 -27.24667 73.491638 -27.35195 73.488586 
  -27.4575 73.441093 -27.15139 73.359703 -26.422501 73.26886 
  -26.397221 73.23497 -26.72834 73.130249 -27.11195 73.189697 
  -27.681391 73.149406 -27.715561 73.125526 -27.46833 73.132477 
  -27.406389 73.10997 -27.373341 72.983307 -27.49889 72.942749 
  -27.480829 72.924423 -27.331949 72.96553 -27.322781 73.022751 
  -27.288059 73.113312 -27.14806 73.147202 -26.710279 73.10025 
  -26.59528 73.116364 -26.480829 73.187469 -26.407221 73.194427 
  -25.860279 73.183029 -25.72278 73.133881 -25.128059 73.082199 
  -24.985559 73.01915 -25.01334 72.99054 -25.17445 72.923859 
  -25.71278 72.895538 -26.027229 72.787201 -26.26111 72.777763 
  -26.683889 72.869423 -27.38195 72.851929 -27.384451 72.830811 
  -27.344721 72.818863 -26.6975 72.828308 -26.395 72.766083 
  -26.744169 72.719162 -26.740841 72.704422 -26.31945 72.735527 
  -26.365841 72.633614 -26.44083 72.597473 -26.46278 72.572197 
  -26.35556 72.608307 -26.184719 72.721359 -25.531389 72.834702 
  -25.233891 72.799698 -25.205 72.765808 -24.964729 72.731369 
  -24.703609 72.673859 -24.741949 72.646637 -24.72167 72.585251 
  -24.60334 72.549149 -24.615 72.521088 -24.909451 72.460251 
  -25.866949 72.423576 -25.8925 72.406372 -25.31139 72.391647 
  -25.499451 72.214706 -25.466391 72.156921 -25.50639 72.136368 
  -25.485001 72.121643 -25.391109 72.148033 -25.406389 72.20636 
  -25.348061 72.279419 -24.82472 72.434982 -24.52084 72.411926 
  -24.41222 72.35025 -23.803341 72.245796 -23.829439 72.222748 
  -23.742229 72.231918 -23.711109 72.170532 -23.806669 72.134407 
  -23.80139 72.108032 -23.59972 72.148857 -23.103889 72.063026 
  -23.09584 72.043869 -23.16445 72.026367 -23.13472 71.996918 
  -23.028891 72.011368 -22.53334 71.911926 -22.506109 71.881638 
  -22.85556 71.774139 -23.129999 71.663307 -23.125839 71.626083 
  -22.99695 71.636917 -22.43445 71.795258 -22.404169 71.779694 
  -22.438061 71.744423 -22.659731 71.657204 -22.64222 71.607758 
  -22.59778 71.571373 -22.296671 71.689148 -22.297501 71.73053 
  -22.146111 71.746094 -22.146391 71.707474 -21.96417 71.74054 
  -21.90889 71.729424 -22.219721 71.6297 -22.12611 71.619141 
  -22.153339 71.589981 -22.31583 71.589142 -22.50667 71.549713 
  -22.541389 71.477203 -22.490841 71.406082 -22.503059 71.368027 
  -22.46056 71.345261 -22.479719 71.309143 -22.450279 71.248306 
  -22.365841 71.258324 -22.33 71.315536 -22.36084 71.346077 
  -22.293329 71.426941 -22.115841 71.487762 -22.028891 71.483871 
  -21.784451 71.513603 -21.74861 71.484154 -21.871111 71.442467 
  -21.714729 71.437469 -21.815559 71.417763 -21.68306 71.409973 
  -21.850281 71.362473 -21.860001 71.345543 -21.716949 71.354424 
  -21.81278 71.312187 -21.697781 71.33165 -21.61195 71.320824 
  -21.961941 71.26387 -21.894171 71.232193 -21.80806 71.266388 
  -21.72472 71.247192 -21.66861 71.180542 -21.734449 71.140259 
  -21.821671 71.19136 -21.841669 71.179138 -21.745001 71.121918 
  -21.74889 71.105263 -22.330561 71.056091 -22.27639 71.042213 
  -21.871111 71.070534 -21.68111 71.068314 -21.67445 71.041924 
  -21.742229 71.000526) #(-180.0 71.538849 -178.76669 71.582474 
  -178.332 71.520538 -177.715 71.30275 -177.5078 71.290527 
  -177.4395 71.226929 -177.5136 71.160812 -177.74969 71.084427 
  -180.00018 70.999878) #(-180.0 71.538849 -180.00018 70.999878) 
#(-104.4133 70.998871 -104.6486 71.119141 -104.4489 71.218872 
  -104.4389 71.257751 -104.4969 71.322746 -104.4714 71.351089 
  -104.4081 71.364967 -104.2936 71.34137 -104.2786 71.356369 
  -104.4036 71.508591 -104.3592 71.563309 -104.3664 71.588867 
  -104.5936 71.75914 -104.79 71.84137 -105.0375 72.118317 
  -104.9692 72.15303 -104.9575 72.181374 -105.302 72.455261 
  -105.1997 72.460533 -105.2381 72.54776 -105.3183 72.55748 
  -105.3081 72.62886 -105.305 72.660248 -105.4572 72.702759 
  -105.4983 72.780807 -105.3561 72.727203 -105.3261 72.746368 
  -105.5322 72.8797 -105.7608 72.976929 -105.8556 73.056923 
  -106.0639 73.04776 -106.3986 73.149139 -106.5003 73.228592 
  -106.5822 73.215263 -106.6967 73.237473 -106.7508 73.289139 
  -106.8825 73.312187 -107.0303 73.295532 -107.1186 73.235527 
  -107.0203 73.200813 -107.0253 73.180527 -107.1058 73.179428 
  -107.4417 73.281082 -108.0125 73.352478 -108.0825 73.344971 
  -108.0131 73.309143 -108.1536 73.302467 -108.0845 73.247482 
  -107.9461 73.214142 -107.8742 73.183594 -108.1664 73.203873 
  -108.2686 73.171371 -108.3 73.135529 -108.2636 73.091919 
  -108.1561 73.048576 -108.2328 73.033043 -108.1014 72.901093 
  -108.142 72.868317 -108.0511 72.781372 -108.0778 72.743027 
  -108.0058 72.702477 -108.0253 72.666092 -107.9545 72.639137 
  -108.0119 72.61998 -107.8856 72.586639 -107.877 72.524406 
  -107.9806 72.511093 -107.9064 72.473587 -107.7814 72.45636 
  -107.8736 72.414139 -107.8 72.376648 -107.8439 72.354141 
  -107.7545 72.330261 -107.7147 72.295258 -107.7478 72.28331 
  -107.8281 72.306374 -107.865 72.292763 -107.7903 72.249977 
  -107.7789 72.136642 -107.6814 72.136093 -107.61 72.088593 
  -107.6533 72.06636 -107.6139 72.012482 -107.415 71.970543 
  -107.4033 71.924423 -107.2769 71.908043 -107.2708 71.879433 
  -107.4708 71.870796 -107.4044 71.837753 -107.2783 71.814697 
  -107.2789 71.793297 -107.5356 71.779694 -107.6953 71.700531 
  -107.752 71.726639 -107.8231 71.716919 -107.8319 71.676933 
  -107.7261 71.62915 -107.7411 71.613312 -107.8062 71.612762) 
#(136.5211 71.514954 136.5605 71.491364 136.5752 71.474136 
  136.6219 71.518311 136.7177 71.52887 137.27859 71.385529 
  137.25191 71.356644 137.35719 71.366364 137.4902 71.342758 
  137.46609 71.295258 137.7361 71.239433 137.6591 71.209976 
  137.56081 71.224701 137.5363 71.205811 137.70911 71.180817 
  137.8038 71.115807 138.0591 71.127472 138.04829 71.157204 
  137.8194 71.205261 138.07159 71.221916 138.2352 71.274696 
  137.9933 71.296654 138.3577 71.323029 138.0775 71.338593 
  137.95551 71.354424 137.87691 71.363312 137.82719 71.389977 
  137.91409 71.40831 138.02831 71.493874 138.02879 71.555817 
  138.1044 71.578873 138.49471 71.609703 138.4072 71.585251 
  138.39799 71.560257 138.4669 71.533859 138.6013 71.558594 
  138.5544 71.60025 138.72301 71.643593 139.04221 71.569427 
  139.0652 71.520248 139.1561 71.44664 139.1144 71.42775 
  139.21271 71.411087 139.35941 71.424423 139.37331 71.455261 
  139.4566 71.496643 139.7233 71.45192 139.8466 71.490807 
  140.02631 71.465263 140.0219 71.483871 139.79939 71.604424 
  139.6897 71.786636 139.7975 71.85997 139.3347 71.946091 
  139.6541 71.958038 139.71989 72.007477 139.6944 72.038307 
  139.7438 72.099983 139.9055 72.174423 140.0833 72.137756 
  140.2188 72.184982 140.12939 72.221649 139.5688 72.234703 
  139.4269 72.181091 139.4958 72.167763 139.25 72.181374 
  139.25549 72.156647 139.32471 72.143593 139.3255 72.127762 
  139.21159 72.152763 139.08521 72.233307 139.2047 72.345261 
  139.5414 72.494423 140.4391 72.486649 141.1058 72.581917 
  140.9341 72.596916 141.02161 72.676361 141.0013 72.701103 
  140.8864 72.728317 140.58051 72.866638 140.5847 72.884979 
  140.6636 72.893593 141.37109 72.847748 141.5627 72.771088 
  141.91161 72.726357 143.0544 72.689148 145.04691 72.577477 
  146.813 72.353317 146.8322 72.335533 145.89771 72.351639 
  145.35471 72.338867 144.9883 72.433594 144.8855 72.42804 
  144.7347 72.386642 144.5141 72.224136 144.3391 72.286087 
  144.10271 72.275253 144.1908 72.22081 144.53191 72.167213 
  144.94051 72.238586 146.93021 72.309418 146.9227 72.29747 
  146.6833 72.161362 145.96471 71.846916 145.92799 71.86026 
  146.0024 72.000526 146.0114 72.037483 146.1064 72.032761 
  146.34 72.128036 146.1949 72.174973 146.0444 72.152763 
  146.063 72.11525 145.96629 72.065811 145.8383 72.175537 
  145.8983 72.206093 145.6913 72.252762 145.6111 72.237198 
  145.7491 72.207199 145.61749 72.074417 145.6819 72.02359 
  145.765 72.036362 145.8058 72.005814 145.80251 71.925537 
  145.74719 71.909416 145.32829 71.868027 144.9752 71.970261 
  144.95329 71.939972 144.9789 71.908577 145.1219 71.868591 
  145.21629 71.827187 145.14751 71.800262 144.8894 71.776917 
  144.89439 71.721077 144.8891 71.67276 145.3391 71.659973 
  145.57269 71.737762 145.7477 71.72525 146.10159 71.799698 
  147.0072 72.25415 147.2244 72.328308 147.9447 72.328583 
  148.8727 72.25386 149.7202 72.116089 150.0649 71.915527 
  150.0661 71.871918 149.9586 71.826637 149.6402 71.765808 
  149.39751 71.899139 149.338 71.900253 149.3027 71.851929 
  149.1055 71.764977 148.8797 71.798309 149.0386 71.756363 
  148.99159 71.695824 148.8477 71.692749 148.86301 71.669693 
  149.1219 71.694702 149.4819 71.654419 149.90739 71.659416 
  150.1058 71.596077 150.0966 71.583862 150.0024 71.566933 
  150.0119 71.597473 149.96021 71.597198 149.933 71.561081 
  149.9705 71.528313 149.8705 71.496368 149.8658 71.46109 
  150.2599 71.51886 150.6425 71.503036 150.6561 71.446091 
  150.5152 71.34137 150.1627 71.265808 150.02361 71.207474 
  150.40739 71.27803 150.6324 71.380249 150.7339 71.388031 
  150.5952 71.270813 150.70081 71.314697 151.03 71.393044 
  151.5213 71.322479 152.04021 71.065811 152.1411 70.997482 
  152.12019 70.987473 151.9183 70.969147 151.6597 70.987427) 
#(53.041111 70.960533 53.144989 70.985527 53.040279 71.024979 
  53.05444 71.080811 53.218048 71.159698 53.207489 71.251083 
  53.143608 71.267761 53.064442 71.235527 52.775551 71.324142 
  52.891102 71.338318 52.90749 71.306923 53.019718 71.279137 
  52.921101 71.35997 52.753052 71.397751 52.682209 71.390808 
  52.723881 71.343872 52.556931 71.389687 52.271389 71.349426 
  52.208328 71.312187 52.232769 71.281921 52.36916 71.24025 
  52.586102 71.238037 53.013321 71.005814 53.013039 70.986473 
  53.041111 70.960533) #(-87.375664 70.943741 -87.267242 71.006927 
  -87.327507 71.034973 -87.760559 71.143044 -87.852524 71.197197 
  -87.823349 71.223587 -87.844177 71.264137 -87.972237 71.250259 
  -89.402252 71.289429 -89.900009 71.351357 -90.003082 71.458862 
  -89.955856 71.527206 -90.042236 71.595543 -89.795853 71.759697 
  -90.119743 71.926361 -90.049469 71.949982 -89.993622 72.025818 
  -89.607788 72.145248 -89.585007 72.175812 -89.847237 72.176361 
  -89.960571 72.251648 -89.843628 72.423027 -89.890556 72.444977 
  -89.793617 72.462753 -89.74585 72.611359 -89.678337 72.629433 
  -89.573059 72.616928 -89.473618 72.67247 -89.577797 72.705261 
  -89.569473 72.786926 -89.402786 72.755814 -89.24556 72.785248 
  -89.382248 72.801651 -89.411392 72.831093 -89.319168 72.876083 
  -89.299179 72.936653 -89.358353 72.965263 -89.340561 73.000809 
  -89.22641 73.012192 -89.307251 73.04248 -89.180573 73.156372 
  -89.136948 73.184982 -88.888077 73.212753 -89.025284 73.226089 
  -89.035858 73.257477 -88.886688 73.303589 -88.830856 73.290817 
  -88.70253 73.293587 -88.857239 73.33609 -88.40947 73.52359 
  -87.974747 73.654694 -87.406113 73.765259 -86.155853 73.860809 
  -85.069473 73.801933 -84.843079 73.735809 -84.956413 73.665253 
  -85.220863 73.599701 -85.915558 73.366089 -86.404922 72.999443) 
#(25.551941 70.923859 25.74111 70.947746 25.738331 70.974983 
  25.83333 70.958313 26.200279 71.005249 26.218889 71.038589 
  26.1675 71.042763 26.05611 70.996643 25.928329 71.004433 
  25.96583 71.031082 25.887501 71.044983 26.032221 71.078873 
  26.01944 71.118317 25.78194 71.103317 25.80666 71.148323 
  25.784719 71.154694 25.552219 71.140259 25.6875 71.09137 
  25.718611 71.04776 25.55028 71.096916 25.294439 71.042213 
  25.326111 71.006638 25.46278 71.025253 25.560829 71.007202 
  25.41666 70.982193 25.551941 70.923859) 
#(-86.404922 72.999443 -86.658363 72.863586 -86.740593 72.722473 
  -86.686951 72.644699 -86.525299 72.579422 -86.25502 72.443588 
  -86.246117 72.394974 -86.396133 72.309143 -86.438339 72.258034 
  -86.420578 72.012756 -86.110573 71.783043 -85.573624 71.556923 
  -84.930298 71.414429 -84.951141 71.340813 -84.872223 71.333313 
  -84.833908 71.274139 -84.868637 71.26886 -85.148643 71.293297 
  -85.472519 71.231369 -85.420303 71.223587 -85.390007 71.19664 
  -85.515007 71.176086 -85.729172 71.206093 -86.010849 71.143593 
  -86.820023 70.988586 -86.59169 70.972473 -85.478622 71.169144 
  -85.163361 71.136642 -85.042252 71.181641 -84.944473 71.187187 
  -84.84584 71.147751 -84.879997 71.069427 -84.98085 71.101089 
  -84.960564 71.072197 -85.003082 71.044418 -84.949173 71.018311 
  -84.926971 70.988037 -84.975281 70.945251 -84.958633 70.919418 
  -84.799187 70.921654 -84.748077 70.988037 -84.829742 71.073303 
  -84.803619 71.174149 -84.665863 71.22081 -84.793327 71.27803 
  -84.781418 71.332748 -84.762802 71.406647 -84.731956 71.424698 
  -84.557533 71.444138 -84.526138 71.468872 -84.55835 71.545807 
  -84.65834 71.583862 -84.606689 71.649406 -84.650017 71.672203 
  -84.867523 71.66803 -84.876129 71.627762 -85.291397 71.672203 
  -85.573639 71.790817 -85.432793 71.806374 -85.551132 71.886642 
  -86.026947 71.981644 -86.038094 72.015808 -85.763077 72.020813 
  -85.76503 72.04303 -85.522781 72.063583 -85.49501 72.089142 
  -85.540863 72.124153 -85.396683 72.137482 -85.538094 72.23526 
  -85.420578 72.215263 -85.458076 72.244141 -84.920288 72.232758 
  -84.275558 72.023857 -84.194473 71.930817 -84.168907 71.944138 
  -84.171127 72.024139 -84.346687 72.069702 -84.38002 72.108307 
  -84.504753 72.143311 -84.667252 72.199142 -84.926392 72.282204 
  -84.801392 72.354713 -84.872787 72.369423 -84.87085 72.400818 
  -84.786972 72.408859 -84.777237 72.458313 -85.127243 72.351929 
  -85.11586 72.383034 -85.248917 72.392197 -85.535294 72.469704 
  -85.613907 72.550262 -85.486389 72.564972 -85.48114 72.577477 
  -85.623917 72.586906 -85.705307 72.637756 -85.695572 72.709702 
  -85.664177 72.825813 -85.672523 72.907471 -85.499733 72.974136 
  -85.283363 72.964417 -85.069183 73.003036 -85.159737 73.032761 
  -85.17836 73.006638 -85.537247 73.028313 -85.440582 73.125526 
  -85.38002 73.133591 -85.250839 73.061081 -85.126419 73.050812 
  -85.161133 73.07692 -85.223068 73.134697 -85.13002 73.140808 
  -84.829742 73.085533 -84.285858 73.051651 -83.635452 72.983582) 
#(180.0 71.003487 179.9514 70.990196 179.9039 70.97966 
  179.8512 70.958557 179.78259 70.93219 179.7113 70.903587) 
#(-9.0716667 70.806641 -8.9888897 70.811081 -8.6202793 70.959137 
  -8.2430573 70.981087 -7.981945 71.04776 -8.001112 71.103317 
  -7.9341669 71.136093 -7.9322219 71.156921 -7.9972229 71.180817 
  -8.3266678 71.140533 -8.5111122 71.013313 -9.1200008 70.863037 
  -9.0716667 70.806641) #(179.7113 70.903587 179.4922 70.874969 
  179.27271 70.888603 178.78979 70.79921 178.703 70.934692 
  178.61771 71.049973 178.6738 71.104156 179.5641 71.446091 
  179.8638 71.488037 179.8602 71.516647) 
#(-89.333008 70.794647 -89.448639 70.902481 -89.432533 70.915253 
  -89.209473 70.939148 -89.195282 70.968307 -89.559464 71.090263 
  -89.450302 71.089706 -89.134453 71.026917 -88.720581 71.045807 
  -88.369171 71.007477 -88.360291 70.977753 -88.228622 70.946091 
  -87.375664 70.943741) #(114.0919 72.594971 113.6844 72.636642 
  113.3172 72.700813 113.1516 72.826103 113.1675 72.853317 
  113.3694 72.885529 113.5383 72.974426 113.5153 73.024979 
  113.6047 73.113312 113.5405 73.162483 113.528 73.207199 
  113.5586 73.250259 113.7136 73.315536 113.9641 73.326103 
  114.0219 73.346916 113.77 73.353592 113.5936 73.413307 
  113.4658 73.497757 113.5517 73.515533 114.8789 73.607483 
  115.1669 73.681374 116.575 73.66304 117.2422 73.589981 
  118.0211 73.584976 118.8322 73.544693 118.9939 73.489151 
  118.963 73.468582 118.8486 73.450531 118.4789 73.483032 
  118.3669 73.42775 118.3503 73.393593 118.4267 73.362198 
  118.3672 73.339981 118.3608 73.271362 118.4997 73.195824 
  119.5403 73.056091 119.5861 72.996368 119.78248 72.96933 
  120.503 72.877472 120.5639 72.890533 119.79347 72.971947 
  119.7575 73.005814 119.8339 73.016647 121.0316 72.930252 
  121.4933 72.970261 121.9628 72.956917 121.9241 72.919693 
  122.0533 72.891922 123.433 72.722748 123.6805 72.757202 
  123.8597 72.746368 124.343 72.640808 124.7297 72.626373 
  125.1539 72.526642 125.2964 72.441933 126.1375 72.268044 
  126.3725 72.353317 126.5591 72.24498 126.5911 72.190536 
  126.7158 72.156921 126.7775 72.109703 126.8072 72.013603 
  127.133 71.844971 127.0894 71.760803 127.2061 71.591637 
  127.2205 71.392471 127.3039 71.408043 127.3133 71.484421 
  127.2355 71.611649 127.1977 71.77359 127.3261 71.891922 
  127.3111 71.916092 126.9811 72.046921 126.9347 72.138031 
  126.8978 72.286926 126.8147 72.331917 126.723 72.395538 
  127.0291 72.402481 127.6586 72.347473 127.8486 72.251923 
  127.7369 72.246918 127.8952 72.222198 128.43719 72.02359 
  128.4397 71.954971 128.61301 71.890533 128.6508 71.786087 
  128.95551 71.733582 129.17999 71.800262 129.18359 71.83165 
  129.0291 71.992477 129.0619 72.014137 129.2988 71.863586 
  129.3075 71.801651 129.40379 71.777763 129.5313 71.71553 
  128.92909 71.708313 128.8311 71.675537 128.8166 71.643593 
  128.89191 71.592484 129.1624 71.602203 129.25439 71.531921 
  129.235 71.493317 129.42 71.323593 129.6608 71.255539 
  129.75861 71.146927 129.7438 71.121094 129.67909 71.102753 
  129.6433 71.080811 130.0869 71.079697 130.2247 70.986923 
  130.1702 70.962753 130.6169 70.866089 130.7 70.886368 
  130.72301 70.95636 130.793 70.972198 130.8166 70.935806 
  130.8927 70.757202 130.9641 70.741638 131.1819 70.734703 
  131.3499 70.789703 131.57111 70.904419 131.74471 71.082474 
  131.87109 71.159416 131.8224 71.184692 131.8847 71.213593 
  132.1586 71.212479 132.13969 71.231644 131.9586 71.248306 
  131.94659 71.289139 132.11301 71.520538 132.5291 71.885529 
  132.7088 71.940262 132.7552 71.933029 132.75771 71.827759 
  132.71271 71.808868 132.7205 71.765533 132.92081 71.726639 
  133.1644 71.569702 133.6994 71.430527 134.2836 71.365807 
  134.6113 71.398033 134.7475 71.354424 134.6463 71.297203 
  134.66769 71.260529 134.7713 71.367477 134.6964 71.415253 
  134.80881 71.476639 135.21719 71.54776 135.358 71.524406 
  135.42191 71.534416 135.3577 71.557747 135.3658 71.573029 
  135.7711 71.637756 136.5038 71.564697 136.5211 71.514954) 
#(-76.997223 72.128036 -77.016968 72.137192 -77.550018 72.198029 
  -78.499191 72.404694 -78.559464 72.450813 -78.430573 72.586639 
  -77.598633 72.753593 -77.25975 72.751648 -76.753082 72.720543 
  -76.653923 72.670807 -76.681961 72.642471 -76.215302 72.596077 
  -76.150284 72.574142 -76.162521 72.526093 -76.107803 72.473038 
  -76.037247 72.489433 -76.070297 72.545532 -75.988907 72.580811 
  -75.759193 72.579147 -75.19252 72.491928 -74.947533 72.249687 
  -75.253082 72.116364 -75.733353 72.13414 -76.045853 72.076637 
  -76.301682 71.930527 -76.40889 71.854424 -76.374474 71.842484 
  -76.011139 72.049698 -75.796967 72.103592 -75.586143 72.121643 
  -75.233337 72.084137 -75.22113 72.064697 -75.281693 72.038589 
  -75.51503 72.018311 -75.618912 71.978592 -75.69252 71.833313 
  -76.067497 71.70665 -76.085571 71.691933 -75.795303 71.725807 
  -75.655029 71.826103 -75.56752 71.937469 -75.513351 71.995247 
  -75.174454 72.031921 -75.109467 72.101089 -74.996948 72.128593 
  -74.275299 72.078033 -74.122223 71.983582 -74.124474 71.949982 
  -74.212517 71.91275 -74.171127 71.868591 -74.263351 71.815811 
  -74.575302 71.818863 -74.563919 71.790253 -75.085297 71.700813 
  -74.955017 71.678589 -74.956413 71.648323 -75.292801 71.553307 
  -75.406418 71.512192 -75.205307 71.546371 -74.78418 71.682747 
  -74.662521 71.684143 -74.637527 71.641083 -74.733917 71.575531 
  -75.081703 71.515259 -75.146133 71.463593 -75.033363 71.513031 
  -74.838364 71.521927 -74.816132 71.493317 -74.925858 71.454147 
  -74.71669 71.419144 -74.705856 71.380814 -75.087517 71.200256 
  -75.065308 71.180817 -74.864471 71.252472 -74.626129 71.398857 
  -74.638077 71.426651 -74.73558 71.472473 -74.743073 71.511917 
  -74.714462 71.546654 -74.620033 71.558029 -74.523064 71.662201 
  -74.146973 71.738861 -74.097794 71.728867 -74.239471 71.63414 
  -74.252502 71.589981 -74.218918 71.556641 -74.148643 71.537483 
  -74.208633 71.588028 -74.211411 71.618591 -74.01503 71.741089 
  -73.944473 71.766647 -73.71669 71.776367 -73.678337 71.723587 
  -73.990593 71.527481 -73.988907 71.461357 -74.030296 71.433594 
  -74.176407 71.3022 -74.102798 71.30304 -74.09169 71.285538 
  -73.991127 71.329147 -73.854187 71.535812 -73.689194 71.588028 
  -73.588638 71.572197 -73.566971 71.544144 -73.64975 71.44136 
  -73.583618 71.388313 -73.622528 71.356644 -73.517242 71.379967 
  -73.482803 71.434418 -73.380287 71.385246 -73.682251 71.246094 
  -73.74585 71.088593 -73.873917 71.069702 -73.87973 71.04776 
  -73.715851 71.07164 -73.660583 71.103867 -73.673897 71.16304 
  -73.615837 71.230263 -73.434189 71.308594 -73.436417 71.34053 
  -73.349747 71.345261 -73.121964 71.291641 -73.053909 71.261642 
  -73.271973 71.220543 -73.235023 71.173309 -73.266129 71.124153 
  -73.445572 71.040253 -73.377808 70.98053 -73.173889 71.156921 
  -73.172523 71.21637 -73.004753 71.2397 -72.951424 71.316093 
  -72.993073 71.397751 -72.976143 71.409149 -72.765846 71.423859 
  -72.758911 71.437469 -72.838074 71.506363 -72.638641 71.544418 
  -72.578079 71.653587 -71.541412 71.499687 -71.158363 71.289978 
  -71.128632 71.251373 -71.363907 71.13887 -71.489731 71.06192 
  -71.890297 71.109421 -72.085571 71.070251 -72.110023 71.010803 
  -72.297523 70.947197 -72.334167 70.878593 -72.264191 70.866638 
  -72.162247 70.829971 -72.4077 70.689903 -72.624481 70.626343) 
#(51.405819 71.805359 51.401661 71.789978 51.55027 71.607758 
  51.53833 71.558868 51.841381 71.455544 52.277771 71.471916 
  52.140549 71.540527 52.26749 71.578308 52.269711 71.518044 
  52.41721 71.472198 52.36832 71.532761 52.538319 71.632751 
  52.648041 71.533577 52.614159 71.461357 52.817211 71.425262 
  52.80471 71.469421 52.869991 71.445824 52.85387 71.416924 
  52.89555 71.38887 53.047489 71.445534 53.005268 71.486923 
  53.05138 71.499977 53.10693 71.419983 53.140549 71.423309 
  53.153599 71.470543 53.35582 71.5672 53.440552 71.538307 
  53.25388 71.449142 53.36805 71.323593 53.480549 71.291641 
  53.54166 71.309143 53.56332 71.383034 53.68417 71.40303 
  53.88805 71.469704 53.951099 71.45665 53.88583 71.415817 
  53.727219 71.408577 53.457211 71.254967 53.559429 71.20137 
  53.960541 71.176933 54.037209 71.231087 54.098881 71.228592 
  54.066101 71.214981 54.036942 71.183594 54.001389 71.149406 
  54.23082 71.138031 54.21027 71.111359 53.937481 71.098312 
  53.932491 71.128311 54.046101 71.113861 54.02943 71.130539 
  53.808319 71.129967 53.90554 71.076103 53.923328 71.048859 
  53.798328 71.079147 53.599152 71.069977 53.49165 71.09581 
  53.735821 70.955544 53.73999 70.935806 53.671379 70.895813 
  53.689159 70.829697 53.572491 70.886368 53.30249 70.863037 
  53.54166 70.8022 53.529442 70.840813 53.574162 70.828308 
  53.810261 70.799698 54.050541 70.74054 54.287209 70.733307 
  54.289711 70.771088 54.540821 70.681091 54.734989 70.650528 
  54.747211 70.664139 54.47916 70.733871 54.49332 70.782471 
  54.56889 70.773857 54.511101 70.818314 54.709991 70.737473 
  54.753319 70.677467 55.01527 70.606087 55.206661 70.553864 
  55.27277 70.597198 55.230549 70.661087 55.27943 70.684692 
  55.474991 70.654984 55.34861 70.701637 55.352489 70.715263 
  55.437771 70.746094 55.740551 70.651093 55.624981 70.709702 
  55.609989 70.733307 55.761662 70.692467 55.799992 70.630539 
  55.710541 70.642197 56.019989 70.570534 56.040821 70.587479 
  55.907768 70.630814 55.810551 70.691933 56.173038 70.590813 
  56.178051 70.611076 56.09444 70.63942 56.54887 70.586357 
  56.55027 70.570534 56.400829 70.561653 56.401661 70.553864 
  56.564159 70.547203 56.657768 70.588867 56.454441 70.625259 
  56.526932 70.637192 56.447769 70.67276 56.327209 70.676651 
  56.371929 70.643593 56.221111 70.656921 56.299992 70.675812 
  56.199711 70.704697 56.524151 70.750259 56.582771 70.733307 
  56.508041 70.717758 56.509991 70.666924 56.686649 70.626083 
  56.621658 70.652763 56.61166 70.67276 56.729988 70.633873 
  57.331661 70.562759 57.308601 70.577187 56.856659 70.640533 
  56.756649 70.688026 56.768879 70.702759 57.451649 70.60498 
  57.45055 70.628593 57.544708 70.699692 57.482208 70.717194 
  57.435822 70.742203 57.639992 70.726357 57.446381 70.81665 
  57.056099 70.862198 56.275269 71.17247 56.056931 71.29248 
  56.021931 71.375526 55.674992 71.60498 55.52388 71.784973 
  55.510818 71.889137 55.427219 71.912201 55.223572 71.924347) 
#(23.749439 70.522202 23.95277 70.522476 24.105551 70.587196 
  24.12583 70.61525 24.03083 70.686081 23.82333 70.698303 
  23.826389 70.744141 23.698059 70.744713 23.632771 70.690536 
  23.691389 70.662483 23.64583 70.593582 23.749439 70.522202) 
#(22.17528 70.466637 22.26944 70.529137 22.310829 70.529984 
  22.290831 70.499153 22.340549 70.49025 22.50528 70.52887 
  22.572781 70.498306 22.656389 70.563873 22.784161 70.519699 
  23.00972 70.573029 22.99222 70.599426 23.077221 70.578033 
  23.116659 70.603027 23.06028 70.624969 23.252781 70.691093 
  23.454439 70.764687 23.39027 70.781082 23.481939 70.791924 
  23.43166 70.831093 23.314159 70.853867 23.348049 70.789139 
  23.28278 70.771927 23.163059 70.822746 23.070271 70.803864 
  23.17444 70.728317 22.96361 70.658859 22.80555 70.760246 
  22.717779 70.736359 22.76222 70.706093 22.805269 70.640533 
  22.592779 70.644417 22.656111 70.683594 22.52083 70.711906 
  22.48111 70.67247 22.39917 70.711639 22.373051 70.690811 
  22.41222 70.62442 22.24028 70.664429 22.231939 70.632477 
  21.96055 70.657761 21.951389 70.640808 22.022779 70.629433 
  22.33028 70.610809 22.23889 70.577477 22.13833 70.477753 
  22.17528 70.466637) #(-100.2247 70.45665 -100.245 70.48526 
  -100.3697 70.571091 -100.3578 70.590263 -100.267 70.573868 
  -100.1925 70.577187 -100.4611 70.659973 -100.71 70.678589 
  -100.662 70.633034 -100.6814 70.573029 -100.6628 70.554703 
  -100.4728 70.496368 -100.2247 70.45665) 
#(-28.003611 70.426933 -27.156389 70.491928 -26.200001 70.584702 
  -26.02972 70.521088 -25.29945 70.657471 -25.281389 70.680817 
  -25.323059 70.760246 -25.395559 70.771637 -25.48695 70.781372 
  -25.334169 70.816093 -25.416389 70.847748 -25.378059 70.866638 
  -25.40056 70.917213 -25.51722 70.968872 -25.68611 70.974983 
  -25.680559 71.007202 -25.68445 71.063309 -25.68222 71.072746 
  -26.331671 70.928864 -27.12611 70.876099 -27.47472 70.741089 
  -27.98695 70.613586 -28.06889 70.565552 -27.98667 70.524696 
  -28.136669 70.454697 -28.110559 70.436943 -28.003611 70.426933) 
#(-21.742229 71.000526 -21.96945 70.97525 -21.719721 70.985809 
  -21.791389 70.948593 -21.801109 70.928307 -21.633341 70.943588 
  -21.756109 70.861649 -21.702499 70.822746 -21.779169 70.793869 
  -21.902229 70.810806 -21.785561 70.77359 -21.679729 70.797203 
  -21.63028 70.772751 -21.791389 70.732193 -21.593611 70.733582 
  -21.546949 70.706093 -21.76222 70.698868 -21.576111 70.66803 
  -21.75556 70.627472 -21.47472 70.539978 -21.591391 70.462196 
  -21.968889 70.389687 -22.000561 70.407204 -21.942221 70.469421 
  -22.03528 70.498032 -22.37389 70.440811 -22.414721 70.597198 
  -22.474449 70.662483 -22.43861 70.779694 -22.44195 70.846649 
  -22.530279 70.845261 -22.58806 70.78804 -22.646111 70.716087 
  -22.56389 70.57637 -22.586941 70.491928 -22.63028 70.443314 
  -22.74861 70.427467 -23.35528 70.440811 -24.022221 70.652206 
  -24.18222 70.794983 -24.23222 70.930817 -24.198059 71.017761 
  -24.68611 71.283043 -24.615561 71.342758 -24.653891 71.356087 
  -24.772499 71.326103 -25.11389 71.303307 -25.634171 71.538589 
  -26.32889 71.578888 -26.39222 71.636642 -26.435841 71.633591 
  -26.48889 71.564697 -26.65472 71.540817 -26.81361 71.551086 
  -27.18417 71.67775 -27.208611 71.728867 -27.93861 72.004433 
  -28.09222 71.976357 -28.57333 72.128311 -28.6675 72.098038 
  -28.693609 72.07637 -28.468889 72.060257 -28.355 72.012482 
  -28.37361 71.993317 -28.47084 71.981644 -28.47472 71.94165 
  -27.82972 71.894699 -27.817499 71.867752 -27.993059 71.896927 
  -28.033609 71.872482 -27.325279 71.709702 -27.40834 71.635803 
  -28.003059 71.622192 -27.92889 71.596649 -28.147221 71.571907 
  -28.489719 71.578033 -28.477779 71.556091 -28.365841 71.541641 
  -27.593889 71.613037 -27.14056 71.571373 -27.129721 71.555817 
  -27.26306 71.518311 -27.00111 71.529419 -26.674999 71.475807 
  -26.43611 71.506638 -25.75111 71.477753 -25.537781 71.379433 
  -25.43861 71.371094 -25.410839 71.28331 -25.51889 71.212196 
  -25.75333 71.258324 -25.627501 71.20192 -26.478889 70.960251 
  -27.504999 70.938026 -27.776951 71.148323 -27.82556 71.148033 
  -27.92 71.123581 -27.786949 71.019699 -27.70389 71.003593 
  -27.615841 70.946373 -27.66445 70.93692 -27.87611 70.972473 
  -28.206671 70.967484 -28.29361 70.993874 -28.40834 70.965813 
  -28.26111 70.949692 -27.91445 70.867203 -27.98695 70.767761 
  -28.168329 70.629967 -28.31583 70.625809 -28.331671 70.612762 
  -28.244169 70.588318 -28.331671 70.555817 -29.20583 70.462196 
  -29.23436 70.439537) #(23.156389 70.274406 23.64389 70.438309 
  23.65694 70.46637 23.57917 70.520248 23.59194 70.583038 
  23.46833 70.621643 23.387779 70.61026 23.530001 70.53804 
  23.40667 70.555252 23.324169 70.523857 23.262779 70.472473 
  23.253889 70.535812 23.17861 70.544693 23.223049 70.515533 
  23.09639 70.515533 22.8925 70.4422 22.96167 70.416092 
  22.878611 70.39415 23.05389 70.340813 23.115549 70.393593 
  23.136391 70.38414 23.070271 70.308868 23.082781 70.288857 
  23.156389 70.274406) #(22.97611 70.245796 23.009159 70.24942 
  23.000549 70.282761 22.73917 70.38887 22.72361 70.334137 
  22.697781 70.333862 22.693331 70.376648 22.66444 70.391373 
  22.389441 70.349983 22.372499 70.329697 22.468611 70.286636 
  22.97611 70.245796) #(-152.2168 70.812012 -152.4353 70.86998 
  -152.7403 70.881927 -152.67529 70.866928 -152.662 70.838318 
  -152.7139 70.813309 -152.8103 70.886642 -152.8553 70.855263 
  -152.92 70.867477 -152.94501 70.902206 -153.91499 70.889137 
  -154.13 70.789429 -154.2128 70.776642 -154.3511 70.830261 
  -154.6178 70.827477 -154.6481 70.866638 -154.7281 70.878593 
  -154.6544 70.91748 -154.5928 70.997482 -154.6097 71.019417 
  -154.845 71.10054 -155.015 71.113861 -155.01669 71.01915 
  -155.09219 71.016647 -155.0397 71.131363 -155.08749 71.151367 
  -155.12109 71.134979 -155.095 71.084427 -155.1861 71.121368 
  -155.28999 71.079971 -155.1911 71.035538 -155.1806 70.998871 
  -155.2361 70.99025 -155.2831 71.032471 -155.53529 70.935806 
  -155.5336 70.870529 -155.595 70.838028 -155.6628 70.864151 
  -155.6503 70.82164 -155.72 70.839142 -155.9247 70.810532 
  -155.9014 70.767197 -155.98109 70.760529 -155.9828 70.829147 
  -155.9411 70.849426 -155.9558 70.866364 -156.1756 70.92276 
  -156.0195 70.929138 -156.0136 70.945251 -156.09531 70.967194 
  -155.82359 70.981369 -155.54781 71.088318 -155.547 71.117752 
  -155.6317 71.183296 -155.8069 71.204971 -156.1095 71.171921 
  -156.04311 71.209702 -156.13921 71.249687 -156.44701 71.263603 
  -156.60139 71.349983 -156.47279 71.395813 -156.48219 71.406647 
  -156.81641 71.300262 -157.1456 71.11554 -157.39751 71.006363 
  -157.9953 70.835533 -158.235 70.824692 -158.48061 70.844971 
  -158.5136 70.835251 -158.3389 70.817467 -158.5569 70.798027 
  -159.0775 70.813583 -158.9911 70.787201 -159.0172 70.770538 
  -159.24969 70.768044 -159.27969 70.751083 -159.21719 70.687759 
  -159.44501 70.779694 -159.1586 70.81665 -159.16859 70.851639 
  -159.3322 70.859154 -160.0936 70.638031 -160.1178 70.60498 
  -159.9967 70.635246 -159.9189 70.625259 -159.7942 70.529419 
  -159.67641 70.495529 -159.5647 70.524406 -159.2942 70.526642 
  -159.67419 70.466637 -159.8203 70.490807 -159.8867 70.391647 
  -159.8475 70.309143 -159.7711 70.233032 -159.7697 70.1922) 
#(-96.409447 71.119423 -96.461403 71.080544 -96.560837 71.126373 
  -96.539726 71.142197 -96.376678 71.149139 -96.459457 71.197197 
  -96.446671 71.260529 -96.293327 71.300262 -96.241119 71.359421 
  -96.134171 71.409698 -95.980827 71.409698 -95.65889 71.285538 
  -95.533073 71.301086 -95.588623 71.354424 -95.470863 71.363861 
  -95.548897 71.428307 -95.376694 71.509407 -95.799728 71.5047 
  -95.943069 71.553589 -95.893066 71.590813 -95.877502 71.618317 
  -95.724731 71.625809 -95.662231 71.671082 -95.263062 71.723862 
  -95.285843 71.767197 -95.226959 71.826637 -94.700287 71.830811 
  -94.61557 71.868874 -95.213348 71.843033 -95.256958 71.866928 
  -95.217506 71.944977 -94.88028 71.982193 -94.499451 71.988037 
  -94.388634 71.924149 -94.474731 71.889137 -94.460564 71.849426 
  -94.649727 71.815536 -94.610573 71.776367 -94.584457 71.743591 
  -94.392227 71.814423 -94.354736 71.79248 -94.390839 71.774406 
  -94.406952 71.660812 -94.181953 71.791924 -93.910004 71.74498 
  -93.819168 71.774696 -93.71167 71.761368 -93.696671 71.710823 
  -93.818893 71.651917 -93.797501 71.63942 -93.23085 71.473587 
  -93.208893 71.44664 -92.974167 71.340813 -92.854446 71.151367 
  -92.908363 70.903587 -92.855011 70.853027 -92.945007 70.835823 
  -93.021957 70.878036 -93.046127 70.867203 -92.968613 70.820534 
  -92.780838 70.796921 -92.639717 70.709976 -92.689178 70.686371 
  -92.592789 70.685806 -92.297523 70.6297 -92.311401 70.569977 
  -92.276123 70.572479 -92.257248 70.61998 -92.208344 70.61026 
  -92.156677 70.573029 -92.248901 70.57164 -92.187233 70.5047 
  -92.285568 70.487762 -92.041946 70.420532 -91.978912 70.359703 
  -92.085571 70.298309 -91.952507 70.255249 -91.883636 70.319138 
  -91.890289 70.354424 -91.737228 70.358582 -91.693893 70.336357 
  -91.693893 70.197479 -91.636124 70.231644 -91.512413 70.153839) 
#(83.180252 70.08606 83.193588 70.123306 83.160812 70.166092 
  82.971077 70.309418 82.994713 70.332474 83.532204 70.330544 
  83.771088 70.469147 83.739151 70.506638 83.767197 70.556091 
  83.528587 70.813583 83.385803 70.970261 83.404694 70.998581 
  83.334702 71.055527 83.167763 71.074142 83.125526 71.115807 
  83.258873 71.111076 83.150253 71.243874 83.378311 71.370529 
  83.377762 71.462479 83.53775 71.491089 83.630814 71.565262 
  83.622482 71.630814 83.408577 71.74942 83.41748 71.804428 
  83.364433 71.831917 83.039139 71.886093 82.661087 71.87915 
  82.576103 71.968582 82.182213 72.09137 82.306923 72.131363 
  82.300537 72.211357 82.192467 72.283043 81.131638 72.363586 
  80.721359 72.526093 80.709137 72.553589 80.800262 72.599701 
  80.814148 72.628593 80.668869 72.653313 80.628311 72.727203 
  80.76442 72.79776 80.837196 72.916924 80.79747 72.987198 
  80.689148 73.058594 80.44664 73.089142 80.443588 73.101089 
  80.594421 73.118317 80.537201 73.145538 80.271927 73.17804 
  80.507751 73.204697 80.574142 73.226639 80.54248 73.270248 
  80.264687 73.309982 80.278313 73.338867 80.608871 73.442467 
  80.672203 73.505814 80.507751 73.494713 80.509979 73.57164 
  80.574982 73.579697 80.85054 73.561653 81.516922 73.642197 
  83.452759 73.656082 84.784416 73.758873 85.224426 73.697197 
  85.493874 73.724701 85.472473 73.761642 85.589417 73.814697 
  86.786926 73.900818 87.086906 73.859421 87.10054 73.839706 
  87.012482 73.777763 85.839417 73.502762 85.778313 73.459702 
  85.794983 73.358307 85.845543 73.321091 86.251373 73.248581 
  86.282204 73.192467 86.66304 73.121094 86.785782 72.991348) 
#(76.915817 71.069702 76.944138 71.165817 77.05275 71.182747 
  77.788307 71.137482 77.87886 71.095543 77.908859 70.99025 
  77.965813 70.96637 78.454971 70.886093 79.049698 70.939697 
  79.112198 71.008591 79.057747 71.01915 78.988861 70.980263 
  78.844971 71.009697 78.786087 70.989151 78.862762 70.983871 
  78.798576 70.940811 78.43248 70.916641 78.453308 70.966637 
  78.555252 71.04248 78.515533 71.104713 78.457474 71.111359 
  78.345261 71.087753 78.475807 71.051933 78.462196 71.035812 
  78.368874 71.050812 78.23053 71.115807 78.314972 71.209976 
  78.302467 71.247192 78.231087 71.262192 77.931091 71.255539 
  77.906921 71.3172 78.003311 71.347198 77.972473 71.373871 
  77.729141 71.315811 77.753036 71.285248 77.656372 71.284973 
  77.218033 71.361923 76.731369 71.459976 76.248306 71.583588 
  76.271088 71.639977 76.001083 71.914139 76.395248 72.005539 
  76.918297 72.048859 77.130249 71.98497 77.498581 71.844971 
  77.660812 71.822746 77.836906 71.836357 78.182213 71.904694 
  78.229424 71.967194 78.171082 72.015533 77.973587 72.11026 
  77.852203 72.117203 77.488312 72.062469 77.376083 72.086639 
  77.375809 72.111359 77.478592 72.168297 77.449417 72.197479 
  77.483871 72.219421 77.67804 72.190536 77.925262 72.315811 
  78.369423 72.386917 79.500259 72.364151 79.884979 72.23497 
  80.826103 72.086906 80.854141 72.068314 80.818863 72.020248 
  80.734421 72.049698 80.809982 72.074417 80.670258 72.068039 
  80.634979 72.037201 81.264687 71.841919 81.260246 71.798576 
  81.338867 71.76387 81.743317 71.695251 82.852753 71.780258 
  83.261642 71.721077 83.324142 71.6772 83.264977 71.634697 
  83.01387 71.54303 82.986649 71.450256 83.023857 71.432747 
  83.033577 71.407761 82.328308 71.28804 82.256927 71.253593 
  82.335533 71.135246 82.355263 71.079422 82.194702 71.001083 
  82.299423 70.888603 82.407471 70.783577 82.402206 70.758873 
  82.209976 70.679138 82.080811 70.561371 82.156921 70.505249 
  82.201637 70.343033 82.310532 70.223862 82.35054 70.214981 
  82.291924 70.296371 82.156082 70.571091 82.179138 70.580811 
  82.472748 70.607758 82.430527 70.689697 82.563026 70.764687 
  82.486923 70.786926 82.488861 70.818039 82.582199 70.858307 
  82.585823 70.914139 82.756363 70.962479 82.870529 70.913307 
  82.892471 70.950256 82.892197 70.997482 82.934143 70.949982 
  83.1297 70.881088 83.14859 70.837479 83.07692 70.70636 
  83.059982 70.594704 82.993874 70.565262 83.055817 70.497482 
  83.000259 70.410812 82.643311 70.236649 82.649979 70.16803 
  82.944702 70.080811 83.180252 70.08606) 
#(19.901661 70.053307 20.15444 70.114967 19.92972 70.164703 
  19.93944 70.189972 19.86805 70.210533 19.838329 70.16803 
  19.803049 70.173309 19.673611 70.28775 19.58194 70.256363 
  19.68083 70.193039 19.77 70.065262 19.901661 70.053307) 
#(20.593889 70.043587 20.79472 70.059692 20.77083 70.116089 
  20.82583 70.181641 20.82361 70.208862 20.752501 70.234154 
  20.57777 70.231087 20.43 70.184143 20.4011 70.146362 
  20.398331 70.079147 20.467501 70.059143 20.593889 70.098862 
  20.593889 70.043587) #(-116.8161 71.261917 -117.7967 71.166367 
  -117.9806 71.12442 -118.415 70.998032 -118.4086 70.970261 
  -118.1786 70.832474 -117.7095 70.693863 -117.7417 70.661362 
  -117.7247 70.641373 -117.5436 70.595261 -116.9011 70.597198 
  -116.567 70.634407 -116.1625 70.623032 -114.7536 70.616928 
  -114.3928 70.674698 -114.1711 70.664703 -113.9742 70.71553 
  -113.7822 70.697479 -113.2067 70.64415 -112.8822 70.538589 
  -112.7097 70.567467 -112.5281 70.514137 -112.3453 70.519699 
  -112.1153 70.474136 -112.0617 70.405258 -111.9631 70.368874 
  -111.5917 70.35498 -111.4845 70.33165 -111.5836 70.301086 
  -111.4528 70.293869 -111.4681 70.278313 -111.9525 70.262482 
  -112.1503 70.26886 -112.5658 70.231369 -112.5433 70.212196 
  -112.5647 70.198303 -113.1683 70.25914 -113.6839 70.263031 
  -114.255 70.3172 -115.0303 70.279984 -116.5106 70.164139 
  -117.2514 70.072746 -117.432 69.996658) 
#(21.20895 70.207352 21.43833 70.268044 21.44611 70.231087 
  21.499161 70.209976 21.51638 70.303864 21.573891 70.318588 
  21.613609 70.265533 21.73 70.237473 21.870831 70.142197 
  21.882219 70.174149 21.805 70.241089 21.82111 70.26387 
  22.003611 70.320824 22.009159 70.298859 21.99667 70.27803 
  22.08416 70.304703 22.112221 70.291092 22.106939 70.240807 
  22.146391 70.24025 22.153891 70.283043 22.31028 70.280533 
  22.29916 70.252197 22.27722 70.195824 22.23778 70.13414 
  22.55361 70.127197 22.327499 70.165527 22.37722 70.249687 
  22.69944 70.222748 22.977501 70.194138 22.950279 70.171921 
  22.3675 70.059692 23.01667 70.141647 22.991659 70.088318 
  23.030279 70.024406 23.121111 70.040253 23.14805 69.969147 
  23.10111 69.946373 23.32111 69.992203 23.32333 69.943863 
  23.53278 70.021637 23.24861 70.05275 23.18194 70.093307 
  23.365829 70.106644 23.40361 70.139137 23.305269 70.168869 
  23.41972 70.188309 23.283051 70.198593 23.25333 70.218307 
  23.513611 70.236923 23.40694 70.245247 23.612499 70.298576 
  23.465 70.311371 23.51861 70.363586 23.85416 70.495247 
  24.030279 70.507202 24.355829 70.453873 24.303329 70.488861 
  24.11805 70.531921 24.10667 70.546082 24.203609 70.579147 
  24.287781 70.662483 24.36305 70.688583 24.530001 70.654419 
  24.719721 70.617203 24.73778 70.642471 24.699169 70.673859 
  24.24555 70.777206 24.265551 70.83609 24.401939 70.86554 
  24.63472 70.775818 24.64583 70.792763 24.608061 70.856369 
  24.721939 70.867752 24.58333 70.919983 24.59194 70.963028 
  24.7075 70.973587 24.813049 70.944138 24.985279 70.911087 
  24.98805 70.974426 25.06333 70.954147 25.07 70.933868 
  24.92444 70.863312 25.067221 70.852203 25.088329 70.891922 
  25.16111 70.915817 25.25333 70.844704 25.252781 70.786087 
  25.34639 70.809143 25.39278 70.892761 25.343611 70.938583 
  25.347219 70.965813 25.39361 70.967484 25.534439 70.914429 
  25.532499 70.892761 25.445551 70.862473 25.46694 70.83609 
  25.691669 70.888313 25.855551 70.89386 25.90778 70.886642 
  25.91333 70.852478 25.629169 70.757477 25.655279 70.729713 
  25.63028 70.713028 25.143049 70.529984 25.084999 70.496368 
  25.25889 70.520538 25.26972 70.492477 25.05805 70.479424 
  25.28389 70.459427 25.25666 70.387756 25.167219 70.397202 
  25.091391 70.35054 25.20389 70.326637 25.19972 70.294693 
  24.98805 70.228867 24.9625 70.188309 24.94861 70.083313 
  25.034719 70.059692 25.047501 70.079971 25.004999 70.110527 
  25.01639 70.131638 25.092501 70.147202 25.08333 70.104141 
  25.14361 70.07637 25.264999 70.102203 25.2775 70.136093 
  25.513611 70.264137 25.535 70.303589 25.423889 70.322479 
  25.46055 70.354424 26.007771 70.608582 26.0725 70.710533 
  26.545561 70.933029 26.69388 70.952477 26.726391 70.921371 
  26.66972 70.822479 26.74333 70.822746 26.627781 70.70137 
  26.42028 70.665527 26.351391 70.636093 26.54472 70.658577 
  26.65361 70.634407 26.504999 70.363037 26.56111 70.349136 
  26.801941 70.448303 26.79833 70.477203 27.100281 70.467194 
  26.96278 70.531372 27.058331 70.610527 27.26861 70.583038 
  27.09333 70.641922 27.136391 70.664978 27.0975 70.691933 
  27.139721 70.742203 27.34222 70.753036 27.28055 70.768593 
  27.31916 70.824417 27.62639 70.799423 27.47583 70.824417 
  27.53639 70.839706 27.497499 70.864433 27.258329 70.883034 
  27.128889 70.915253 27.156111 70.967484 27.349159 70.943314 
  27.21833 71.013031 27.27305 71.030258 27.475559 71.00386 
  27.54472 70.948593 27.57361 70.968307 27.525 71.034973 
  27.531111 71.081917 27.647499 71.091637 27.65222 71.122482 
  27.73583 71.093307 27.69611 71.059418 27.88611 71.032204 
  28.165279 71.075256 28.23555 71.073303 28.261391 71.045258 
  28.198059 71.016922 28.48694 70.991089 28.550831 70.968307 
  28.443609 70.86026 28.271111 70.813026 28.25222 70.787483 
  28.137779 70.780258 27.99305 70.811653 27.764999 70.779419 
  28.113609 70.737762 28.075001 70.703033 27.875549 70.671921 
  27.663891 70.602478 27.836941 70.61525 28.2125 70.700531 
  28.297779 70.708038 28.288891 70.654694 28.24194 70.618874 
  27.851669 70.478867 27.88139 70.425537 27.970831 70.491364 
  28.18222 70.497757 28.041109 70.447746 28.06555 70.435532 
  28.231939 70.505814 28.33555 70.505539 28.153891 70.369423 
  28.156111 70.244141 28.185829 70.159416 28.14917 70.118874 
  28.01524 70.069366) #(19.08444 69.801086 19.395 69.827759 
  19.43 69.862762 19.681391 69.975807 19.69194 69.994713 
  19.651939 70.020248 19.571659 69.994141 19.561661 70.048027 
  19.48694 70.04776 19.394171 69.988861 19.288891 70.040817 
  19.316389 70.081917 19.06361 70.068314 19.11722 70.024139 
  19.07139 70.012482 19.025551 70.036926 18.82917 70.000259 
  18.853331 69.977203 18.93111 69.962753 18.791389 69.954422 
  18.721109 69.939972 18.73805 69.920807 18.95528 69.870247 
  19.08444 69.801086) #(30.78455 69.791367 30.858959 69.789658) 
#(-78.799744 69.876083 -79.707237 69.85553 -79.902252 69.976357 
  -80.033913 69.944977 -80.040863 69.99498 -80.232803 70.007751 
  -80.326141 69.980263 -80.561417 70.046921 -81.151947 70.083862 
  -81.728638 70.132202 -81.761963 70.117477 -81.670563 70.065262 
  -81.299469 70.02803 -80.940308 69.862762 -80.763077 69.760803 
  -80.807251 69.741364 -80.967796 69.714417 -81.354462 69.880249 
  -81.769737 69.97554 -81.978897 70.064148 -83.04808 70.306923 
  -82.718079 70.201637 -81.710861 69.934143 -81.75946 69.90303 
  -81.960571 69.844147 -82.02002 69.873871 -82.118637 69.810532 
  -82.143631 69.781372 -82.273071 69.805252 -82.20668 69.828583 
  -82.314178 69.857483 -82.463913 69.841087 -82.728912 69.928589 
  -82.741409 69.910248 -83.066971 70.010803 -83.362518 69.975807 
  -84.310577 69.980263 -84.823639 70.028313 -84.87085 70.07164 
  -84.806396 70.086357 -84.811401 70.108582 -84.936684 70.065262 
  -85.369453 70.103592 -85.847519 70.088867 -85.851967 70.038307 
  -85.585571 70.067467 -85.243073 69.99498 -85.245033 69.984421 
  -85.839752 70.003036 -86.301964 70.121643 -86.556122 70.244713 
  -86.552513 70.346916 -86.591667 70.358307 -86.295303 70.472748 
  -86.29335 70.49025 -86.374733 70.525253 -86.340584 70.483871 
  -86.634193 70.389977 -86.647247 70.319427 -86.876129 70.326103 
  -86.896118 70.353027 -86.833069 70.366928 -86.748062 70.388603 
  -86.922234 70.38887 -86.988907 70.435532 -86.923897 70.45665 
  -87.099182 70.450531 -87.168907 70.386642 -86.972778 70.351929 
  -86.969193 70.312759 -86.999474 70.280533 -87.773361 70.33136 
  -87.785568 70.30304 -87.628632 70.29303 -87.623917 70.27803 
  -87.866386 70.238861 -88.234451 70.320824 -88.206703 70.352478 
  -87.901962 70.304428 -87.901962 70.32692 -88.136414 70.388603 
  -88.493896 70.438026 -88.810562 70.495247 -88.956947 70.583862 
  -89.00528 70.656921 -89.333008 70.794647) 
#(59.766102 69.689697 60.4711 69.720543 60.439709 69.756638 
  60.547771 69.805817 60.451649 69.880814 60.477489 69.916092 
  60.412769 69.954971 60.324711 69.951103 60.02055 70.101929 
  59.779148 70.126083 59.764149 70.167763 59.535259 70.205811 
  59.541931 70.252472 59.30888 70.371368 59.044159 70.447479 
  59.033039 70.478867 58.726101 70.416367 58.758881 70.387192 
  58.697491 70.354141 58.595539 70.331093 58.497211 70.33165 
  58.801659 70.235809 58.782768 70.213318 58.471661 70.26915 
  58.4086 70.250259 58.608879 70.137482 58.546101 70.126373 
  58.588039 70.059982 58.936008 69.901894 58.962212 69.880539 
  59.113319 69.854141 59.122761 69.872192 58.969711 69.920807 
  58.958599 69.940536 59.451649 69.875809 59.62582 69.789978 
  59.533871 69.753593 59.554989 69.742752 59.766102 69.689697) 
#(28.01524 70.069366 28.13361 70.082474 28.23222 70.165527 
  28.19722 70.259979 28.246111 70.412201 28.3225 70.436371 
  28.33194 70.474136 28.454439 70.488861 28.46611 70.453873 
  28.509159 70.444138 28.55666 70.504967 28.395 70.54747 
  28.509159 70.675262 28.62611 70.677467 28.522221 70.72081 
  28.67444 70.814972 28.853889 70.880539 29.100559 70.873306 
  29.400551 70.774979 29.296659 70.74054 29.33 70.707474 
  29.452221 70.694427 29.677219 70.743027 29.78166 70.731644 
  29.776661 70.674149 29.73889 70.647476 29.68944 70.613586 
  29.83555 70.635529 29.96722 70.70636 30.10194 70.709137 
  30.20277 70.669983 30.09944 70.640533 30.338329 70.60553 
  30.34166 70.59137 30.152769 70.528587 30.44944 70.556374 
  30.597219 70.53775 30.805269 70.409416 30.94389 70.449692 
  31.064159 70.361649 31.015551 70.333038 31.045561 70.311081 
  31.06333 70.280258 30.52305 70.24054 30.35 70.16803 
  30.38472 70.147476 30.343611 70.121643 30.14361 70.085533 
  30.157499 70.06636 29.78055 70.066933 28.731939 70.177467 
  28.594721 70.163857 28.753889 70.156372 28.612499 70.107758 
  28.743891 70.097748 29.68417 69.966919 29.40527 69.868027 
  29.422779 69.852753 29.53639 69.909416 29.73222 69.909698 
  29.76746 69.833023 29.52389 69.702187 29.522499 69.682213 
  29.49972 69.657204 29.664721 69.731644 30.064159 69.768044 
  29.958879 69.711639 29.941669 69.686653 30.07222 69.739151 
  30.121111 69.699982 30.18889 69.692467 30.114441 69.754967 
  30.20694 69.766083 30.20639 69.785812 30.158051 69.805252 
  30.178049 69.877197 30.308611 69.878593 30.402769 69.822479 
  30.418329 69.700531 30.39666 69.679138 30.41139 69.665527 
  30.452221 69.688583 30.45055 69.773033 30.46833 69.814423 
  30.649719 69.809982 30.72444 69.768044 30.78455 69.791367) 
#(-140.9991 69.644562 -141.2186 69.66803 -141.2603 69.634407 
  -141.38831 69.641083 -141.5659 69.728317 -141.8661 69.792763 
  -142.1114 69.85025 -142.2692 69.848587 -142.4314 69.941933 
  -143.01781 70.085457 -143.30029 70.111359 -143.29469 70.062187 
  -143.3056 70.044983 -143.3486 70.108871 -144.065 70.079147 
  -144.0275 70.032471 -144.065 70.016373 -144.1142 70.064423 
  -144.7075 69.972198 -145.3056 69.998581 -145.42529 70.041092 
  -145.5334 70.093307 -145.6078 70.064972 -145.8394 70.170532 
  -146.2169 70.174973 -147.16611 70.163857 -147.80251 70.22998 
  -147.8161 70.297203 -147.985 70.298309 -148.14751 70.35553 
  -148.505 70.311371 -148.5117 70.362198 -148.60719 70.39859 
  -148.8222 70.411087 -149.0594 70.468033 -149.4153 70.49054 
  -149.57919 70.5047 -149.88811 70.514977 -150.1161 70.437759 
  -150.4175 70.411362 -150.3689 70.486076 -150.5256 70.505249 
  -150.7939 70.493317 -150.9511 70.466637 -151.2092 70.424698 
  -151.19749 70.394974 -151.22031 70.371094 -151.5378 70.440536 
  -151.9483 70.444427 -151.9606 70.470261 -151.78419 70.519974 
  -151.7408 70.559982 -152.6106 70.550262 -152.6089 70.571091 
  -152.1895 70.583313 -152.2695 70.598312 -152.4986 70.649406 
  -152.50751 70.693863 -152.40919 70.720261 -152.4314 70.739433 
  -152.2168 70.812012) #(169.1852 69.569977 168.8325 69.570251 
  168.1516 69.696373 168.05881 69.759697 167.9586 69.773857 
  167.75191 69.827477 167.76221 69.839706 167.95 69.94136 
  168.2702 70.020538 169.4211 69.866089 169.45551 69.821091 
  169.40919 69.762802 169.27499 69.757751 169.2966 69.642471 
  169.1852 69.569977) #(-72.624481 70.626343 -72.542801 70.60997 
  -72.156128 70.77359 -71.326141 70.885529 -71.204742 70.852478 
  -71.173897 70.862198 -71.289467 70.913589 -71.185577 71.019417 
  -70.836143 71.114433 -70.755577 71.11554 -70.605026 71.056374 
  -70.51503 70.940536 -70.519737 70.913857 -70.732803 70.824142 
  -70.74086 70.7547 -70.786133 70.729713 -71.083076 70.661636 
  -71.175308 70.583588 -71.592796 70.606918 -71.588074 70.542763 
  -71.724747 70.490807 -71.759193 70.439972 -71.86586 70.437469 
  -71.960571 70.412483 -71.727249 70.41748 -71.755577 70.329147 
  -71.849747 70.290817 -71.733627 70.313873 -71.674744 70.369713 
  -71.655579 70.472473 -71.525299 70.524696 -71.495567 70.578873 
  -71.253082 70.549698 -71.162247 70.520538 -71.321693 70.306641 
  -71.280029 70.274979 -71.289467 70.246094 -71.51503 70.061081 
  -71.528084 70.020248 -71.331703 70.128593 -71.063606 70.503593 
  -71.05336 70.55304 -70.997238 70.625809 -69.873917 70.883324 
  -69.773911 70.859421 -69.781418 70.84137 -69.926407 70.744713 
  -70.245033 70.638313 -70.423363 70.636917 -70.478912 70.606644 
  -70.400299 70.530258 -70.408081 70.514137 -70.493073 70.485809 
  -70.309723 70.498032 -70.390297 70.584427 -70.382797 70.61525 
  -70.120033 70.618591 -70.027252 70.589706 -69.987808 70.649979 
  -69.847519 70.683296 -69.665848 70.682213 -69.649193 70.731087 
  -69.569473 70.771927 -69.414467 70.788589 -68.329742 70.5672 
  -68.27919 70.531082 -68.296127 70.494141 -68.451424 70.409416 
  -68.451691 70.372482 -68.4953 70.368591 -68.581131 70.404137 
  -68.54808 70.447746 -68.58252 70.464417 -68.661972 70.431091 
  -68.656967 70.338593 -68.784187 70.310257 -69.215027 70.277206 
  -70.166687 70.036636 -70.163094 70.012482 -70.020576 70.058594 
  -69.843918 70.024696 -69.822533 69.981644 -70.148621 69.962196 
  -70.228912 69.911636 -70.444183 69.860527 -70.35585 69.84137 
  -70.184189 69.910248 -69.745567 69.974701 -69.739471 70.001373 
  -69.805023 70.038857 -69.783913 70.089417 -69.653351 70.144974 
  -69.219467 70.188309 -69.059464 70.165253 -69.011688 70.181091 
  -69.129753 70.214706 -68.680573 70.203033 -68.644203 70.147476 
  -68.691132 70.131927 -69.460571 69.813309 -69.597519 69.837753 
  -69.785294 69.827187 -70.001129 69.656082 -69.982803 69.61554 
  -69.811127 69.728867 -69.805573 69.772476 -69.713364 69.80748 
  -69.38475 69.780807 -69.188347 69.887756 -68.870293 69.953033 
  -68.69252 69.931091 -68.569748 70.014977 -68.338364 70.064148 
  -68.193626 70.123581 -68.334747 70.141647 -68.292252 70.186653 
  -68.313629 70.222198 -68.055862 70.322746 -67.795029 70.258873 
  -67.216957 69.937759 -67.11586 69.727203 -67.237244 69.715263 
  -67.791412 69.779419 -68.087799 69.756088 -68.323639 69.62886 
  -68.458359 69.62915 -69.329193 69.532471 -69.688919 69.569427 
  -70.023216 69.53688) #(18.19055 69.529984 18.76222 69.562759 
  18.84639 69.603867 18.789721 69.629433 18.79417 69.671921 
  19.059719 69.759407 19.057779 69.787201 18.995831 69.824982 
  18.69305 69.884407 18.66194 69.861076 18.784439 69.77359 
  18.709721 69.684143 18.646391 69.726357 18.65 69.799423 
  18.546391 69.796921 18.48444 69.744423 18.47694 69.776917 
  18.342501 69.782761 18.351669 69.723312 18.632219 69.689697 
  18.187771 69.70137 18.291941 69.632751 18.399719 69.636093 
  18.32 69.609154 18.26861 69.619141 18.03194 69.627762 
  17.999439 69.583313 18.19055 69.529984) 
#(-51.10973 69.505539 -50.946949 69.563583 -50.96529 69.724426 
  -50.890011 69.767471 -50.840839 69.758034 -50.678341 69.818039 
  -50.670292 69.860527 -51.002239 69.918587 -51.207241 69.916367 
  -51.363071 69.851929 -51.197788 69.833313 -51.078621 69.874969 
  -51.014179 69.874969 -51.342789 69.738312 -51.385571 69.698868 
  -51.334728 69.685257 -51.241402 69.529419 -51.10973 69.505539) 
#(-79.974731 69.502197 -79.93808 69.531921 -80.08197 69.630539 
  -80.021973 69.643593 -79.91835 69.603592 -79.600304 69.612762 
  -79.342529 69.693039 -79.331703 69.713318 -79.44252 69.794983 
  -79.525299 69.806923 -79.896118 69.736649 -80.073349 69.749687 
  -80.153641 69.722198 -80.120567 69.758591 -80.206703 69.798027 
  -80.479172 69.789978 -80.498901 69.759697 -80.405029 69.712753 
  -80.666412 69.748032 -80.805023 69.697746 -80.46225 69.656372 
  -80.309189 69.55748 -80.23558 69.620796 -80.208618 69.618027 
  -80.236389 69.556091 -80.217239 69.52887 -79.974731 69.502197) 
#(-78.817497 69.452759 -78.087799 69.57692 -77.946671 69.646637 
  -77.982788 69.694702 -78.142227 69.742477 -78.26889 69.732193 
  -78.235023 69.668297 -78.315582 69.659698 -78.307251 69.686653 
  -78.39003 69.695534 -78.392242 69.646362 -78.564468 69.639687 
  -78.874191 69.486923 -78.817497 69.452759) 
#(-101.2189 69.371368 -101.0514 69.458588 -100.9992 69.441933 
  -100.9603 69.472473 -101.0533 69.504433 -101.1067 69.540817 
  -101.2431 69.54248 -101.2617 69.58165 -101.3497 69.572479 
  -101.3845 69.532761 -101.1864 69.47525 -101.2289 69.434692 
  -101.3003 69.4422 -101.2189 69.371368) 
#(-96.146667 69.34581 -96.096123 69.468033 -96.136398 69.546082 
  -96.652237 69.560806 -96.260834 69.366928 -96.146667 69.34581) 
#(-95.722778 69.320824 -95.539726 69.325256 -95.402512 69.383324 
  -95.360001 69.50914 -95.488892 69.565536 -95.625839 69.616089 
  -95.920288 69.595261 -96.008347 69.468033 -95.946121 69.413857 
  -95.994171 69.383324 -95.961937 69.346359 -95.862228 69.348038 
  -95.781403 69.463028 -95.823059 69.51442 -95.815842 69.562759 
  -95.694458 69.540253 -95.648354 69.403313 -95.731949 69.373032 
  -95.722778 69.320824) #(-53.717789 69.251083 
  -52.753071 69.358582 -52.066959 69.502197 -51.83363 69.626083 
  -51.840569 69.639687 -52.026951 69.673576 -51.9039 69.736923 
  -51.94334 69.777206 -52.04195 69.808868 -52.34668 69.847198 
  -52.73473 69.933029 -53.037231 70.116364 -53.310009 70.202759 
  -54.302231 70.31636 -54.76112 70.24054 -54.84362 70.175812 
  -54.817791 70.060532 -54.728352 70.019699 -54.252789 69.931374 
  -54.250561 69.911362 -54.70668 69.967194 -54.847511 69.944977 
  -54.868061 69.920807 -54.79612 69.875259 -54.930851 69.86026 
  -54.92223 69.823593 -54.849171 69.79303 -54.634449 69.774979 
  -54.408619 69.687187 -54.42474 69.670807 -54.677231 69.751373 
  -54.967232 69.727203 -54.80946 69.607758 -54.46056 69.558029 
  -53.99445 69.556641 -53.99057 69.596916 -53.940571 69.602203 
  -53.87001 69.561653 -53.978901 69.515808 -53.966961 69.48497 
  -53.730839 69.515533 -53.8564 69.461639 -53.776402 69.451637 
  -53.62862 69.49054 -53.558899 69.565536 -53.495289 69.556091 
  -53.576962 69.474136 -53.386398 69.439697 -53.79557 69.41748 
  -54.23196 69.449417 -54.259449 69.42247 -54.256119 69.385246 
  -53.87973 69.303864 -53.852509 69.263313 -53.717789 69.251083) 
#(-90.329742 69.235809 -90.154167 69.354713 -90.195282 69.416924 
  -90.215561 69.441093 -90.237793 69.416092 -90.241959 69.38942 
  -90.301964 69.434418 -90.4664 69.385803 -90.511414 69.357483 
  -90.409729 69.274139 -90.329742 69.235809) 
#(-76.897522 69.103867 -76.858627 69.148857 -76.949463 69.197479 
  -76.905029 69.226357 -76.676407 69.306091 -76.64473 69.381363 
  -76.723358 69.423576 -76.950851 69.395248 -77.113907 69.44165 
  -77.360023 69.392761 -77.381973 69.247482 -77.285843 69.153587 
  -77.171967 69.117203 -76.958908 69.142471 -76.897522 69.103867) 
#(17.040831 69.011368 17.201389 69.023857 17.186939 69.044693 
  17.17333 69.06665 17.46944 69.200256 17.525829 69.195534 
  17.485279 69.151093 17.90139 69.16803 18.00555 69.196373 
  17.87583 69.2397 17.968611 69.256638 17.92111 69.286636 
  17.9175 69.325531 18.10083 69.358032 18.074169 69.430817 
  18.01972 69.44165 18.002781 69.404984 17.94305 69.426086 
  18.053049 69.490807 17.94833 69.522751 17.845551 69.444702 
  17.8225 69.461357 17.888611 69.54747 17.829439 69.588028 
  17.74778 69.538589 17.69305 69.594971 17.65222 69.588593 
  17.69639 69.512756 17.625549 69.503036 17.53861 69.580811 
  17.46917 69.597748 17.45944 69.564697 17.61083 69.474701 
  17.59 69.455261 17.401939 69.523033 17.30167 69.526093 
  17.379721 69.473587 17.21278 69.500259 17.186939 69.490807 
  17.26111 69.444427 17.48167 69.430252 17.480829 69.419693 
  17.285271 69.410812 17.377769 69.381088 17.38472 69.360809 
  17.025551 69.397751 16.87611 69.356087 17.08555 69.357193 
  17.115829 69.326103 17.046671 69.317467 16.89666 69.299698 
  17.12278 69.246368 16.87583 69.221359 16.89555 69.192467 
  17.173889 69.195824 17.04528 69.12886 16.80139 69.116364 
  16.7675 69.090263 16.811661 69.049698 16.95611 69.067749 
  17.13611 69.069702 17.040831 69.011368) 
#(180.0 68.978706 180.0 71.003487) 
#(173.75011 69.846313 173.7666 69.856087 173.7686 69.876648 
  173.9252 69.844704 174.0336 69.881927 174.4922 69.86026 
  175.1516 69.861359 175.1552 69.848038 175.4319 69.853592 
  175.5527 69.893593 176.1261 69.886368 176.2813 69.805252 
  176.2339 69.775528 176.42 69.762756 176.6852 69.683594 
  178.13161 69.460823 178.28909 69.455544 178.24471 69.473587 
  178.47971 69.46611 178.8886 69.379433 179.06329 69.321373 
  178.88721 69.310806 178.6622 69.380814 178.65829 69.334702 
  178.70689 69.280533 179.2191 69.274406 179.9286 69.001389 
  179.91769 68.99054 179.5475 69.109421 179.58771 69.075256 
  179.7561 68.989151 180.0 68.978706) 
#(20.89138 68.926849 20.93111 68.94635 20.866659 69.004967 
  20.58609 69.063141) #(15.47778 68.877762 15.57306 68.965813 
  15.54194 69.012192 15.62389 68.98053 15.86389 69.026093 
  16.08861 69.157761 16.153891 69.276093 16.11194 69.312759 
  15.97472 69.280807 15.86944 69.228317 15.56028 69.094704 
  15.42278 68.979424 15.42028 68.911087 15.47778 68.877762) 
#(-180.00018 70.999878 -180.0 68.851898) 
#(-79.238907 68.827477 -78.934448 68.888603 -78.640846 69.04776 
  -78.458908 69.221916 -78.356407 69.196091 -78.211411 69.299973 
  -78.291412 69.374969 -78.458633 69.389977 -78.724747 69.331093 
  -78.623917 69.256927 -78.756683 69.257477 -78.878632 69.136642 
  -79.208618 69.082474 -79.309464 68.973587 -79.419189 68.920258 
  -79.400299 68.871918 -79.366127 68.847748 -79.238907 68.827477) 
#(-104.2636 68.941589 -103.4945 68.798576 -103.3533 68.784149 
  -103.36 68.813873 -103.2919 68.829971 -102.9908 68.794418 
  -102.7006 68.845261 -102.7658 68.882751 -102.7303 68.896637 
  -102.62 68.861076 -102.4856 68.871368 -102.38 68.954971 
  -101.8994 68.97525 -101.8064 69.00386 -101.8678 69.04248 
  -101.78 69.103867 -101.752 69.165527 -101.7853 69.196373 
  -101.9631 69.257202 -102.1067 69.179703 -102.2172 69.22525 
  -102.2014 69.279137 -102.0675 69.239151 -102.0458 69.296082 
  -102.1728 69.322479 -102.1606 69.354713 -102.0242 69.352753 
  -101.9311 69.407471 -101.9475 69.431374 -102.0933 69.487762 
  -102.4811 69.474701 -102.5308 69.409416 -102.8411 69.383324 
  -103.1825 69.111076 -103.2178 69.137192 -103.2047 69.200813 
  -103.0231 69.271637 -102.9914 69.424698 -103.0464 69.516922 
  -103.0961 69.515533 -103.0919 69.473862 -103.1361 69.436371 
  -103.2167 69.551086 -103.5072 69.617752 -103.477 69.693588 
  -103.2975 69.696907 -103.1867 69.629433 -102.7981 69.529984 
  -102.5078 69.564148 -102.492 69.696373 -102.5922 69.693863 
  -102.6745 69.750259 -102.6733 69.766373 -102.5764 69.737473 
  -102.3761 69.809418 -102.3497 69.756363 -102.2995 69.794418 
  -102.3322 69.841087 -102.2372 69.850807 -102.2531 69.901093 
  -102.2175 69.916924 -102.1661 69.882202 -102.177 69.849136 
  -102.1389 69.823029 -102.035 69.847473 -101.9303 69.733582 
  -101.8564 69.743027 -101.6645 69.649406 -101.5597 69.764977 
  -101.4453 69.909149 -101.4164 69.886917 -101.4683 69.823029 
  -101.3297 69.669983 -101.0645 69.64859 -100.9386 69.67247 
  -100.8781 69.771637 -100.87 69.814423 -100.9614 69.939148 
  -100.9222 69.965263 -101.0028 70.088867 -100.9733 70.155533 
  -100.9997 70.17276 -101.112 70.197197 -101.2389 70.133034 
  -101.3761 70.17775 -101.4134 70.12442 -101.56 70.113586 
  -101.6508 70.221359 -101.5886 70.271927 -101.7278 70.307213 
  -101.8495 70.256638 -101.9256 70.260529 -102.2814 70.38414 
  -102.86 70.512756 -102.8483 70.593872 -103.0253 70.660248 
  -103.1367 70.674423 -103.1558 70.654984 -103.1083 70.560532 
  -102.915 70.505249 -102.9306 70.49054 -103.1219 70.501923 
  -103.3094 70.595261 -103.4906 70.587479 -103.6247 70.628036 
  -103.657 70.665527 -104.0003 70.757202 -104.1228 70.914703 
  -104.4133 70.998871) #(-180.0 68.851898 -179.77228 68.85685 
  -179.62462 68.854385 -179.45973 68.812553 -179.28993 68.770714 
  -179.0 68.767822) #(48.828892 68.726639 49.495548 68.82164 
  49.90778 68.991928 49.883598 69.007477 49.86055 69.01886 
  50.146111 69.140808 50.224998 69.143044 50.11721 69.03331 
  50.127209 68.99025 50.177212 69.011368 50.331108 69.124687 
  50.305271 69.161926 50.10416 69.281082 49.24416 69.505539 
  48.943321 69.506927 48.634991 69.444138 48.391659 69.335251 
  48.27528 69.230263 48.265541 69.123032 48.244991 69.088463 
  48.211391 68.995529 48.266659 68.976089 48.227779 68.953583 
  48.225552 68.882751 48.283329 68.897476 48.29472 68.858582 
  48.59 68.728592 48.828892 68.726639) 
#(-134.323 68.717453 -134.43111 68.792763 -134.4886 68.870247 
  -134.6667 68.956093 -134.6736 69.017761 -134.5681 69.106644 
  -134.07809 69.345543 -133.8578 69.440811 -133.7484 69.542213 
  -133.7917 69.57692 -133.8056 69.539429 -133.9472 69.506363 
  -133.9778 69.528587 -134.125 69.542213 -134.1795 69.587479 
  -134.21919 69.578873 -134.147 69.635529 -134.2253 69.675812 
  -134.35139 69.668869 -134.31219 69.721077 -134.4931 69.715813 
  -134.4017 69.638313 -134.4778 69.538589 -134.5764 69.54776 
  -134.5939 69.509407 -134.52139 69.47525 -134.5256 69.507751 
  -134.47501 69.515533 -134.4084 69.491364 -134.42081 69.463028 
  -134.49609 69.441933 -134.67751 69.480797 -135.1508 69.476929 
  -135.2872 69.419144 -135.2408 69.308296 -135.1861 69.286087 
  -135.17059 69.257751 -135.57201 69.338593 -135.6106 69.319702 
  -135.5506 69.229141 -135.5853 69.223312 -135.6595 69.31665 
  -135.7328 69.330811 -135.8486 69.296921 -135.8522 69.268044 
  -135.60719 69.145248 -135.9261 69.2547 -135.96719 69.214706 
  -135.9361 69.099701 -135.7209 69.046082 -135.7045 69.014977 
  -135.80251 68.989433 -135.97839 69.040817 -135.9875 69.011917 
  -135.9211 68.954422 -135.9984 68.956917 -135.9953 68.942467 
  -135.825 68.895813 -135.52921 68.928589 -135.45531 68.977753 
  -134.9147 68.966637 -134.8342 68.987473 -134.767 68.953308 
  -134.4678 68.762482 -134.4575 68.719147 -134.323 68.717453) 
#(-100.367 68.710533 -100.1722 68.799423 -100.205 68.846649 
  -100.1311 68.909973 -100.2389 68.924149 -100.3236 68.996094 
  -100.5436 69.036636 -100.6281 68.991364 -100.5736 68.936653 
  -100.6261 68.912483 -100.6231 68.761917 -100.572 68.754433 
  -100.53 68.787483 -100.4542 68.788857 -100.4797 68.748871 
  -100.367 68.710533) #(-122.7486 69.825157 -122.8081 69.793587 
  -122.9592 69.833588 -123.1522 69.768044 -123.0964 69.670532 
  -123.1622 69.618591 -123.1267 69.571091 -123.18 69.492477 
  -123.3011 69.506638 -123.4286 69.476357 -123.4508 69.446907 
  -123.3914 69.406921 -123.68 69.353317 -123.7461 69.378311 
  -123.8895 69.36525 -123.9847 69.404984 -124.0164 69.37915 
  -123.9925 69.345543 -124.2336 69.347748 -124.4722 69.374153 
  -124.5122 69.40831 -124.4145 69.41275 -124.4367 69.451637 
  -124.3953 69.486923 -124.2406 69.550262 -124.2036 69.619713 
  -124.0353 69.678864 -124.0697 69.723587 -124.3286 69.698593 
  -124.5036 69.730797 -124.4425 69.832748 -124.4483 69.862762 
  -124.4639 69.913589 -124.4331 69.948029 -124.5344 69.968582 
  -124.3719 70.029419 -124.3667 70.078033 -124.4461 70.108871 
  -124.3939 70.14859 -124.55 70.157471 -124.7439 70.127197 
  -124.7439 70.112198 -124.4414 70.076103 -124.4361 70.036362 
  -124.5486 70.047203 -124.5336 70.019417 -124.5978 70.015259 
  -124.6453 70.071907 -124.7144 70.069138 -124.9569 70.032204 
  -124.9867 70.041641 -124.9817 70.074417 -125.017 70.078873 
  -125.2022 69.997757 -125.1908 69.931923 -125.1106 69.969971 
  -124.827 70.012482 -124.8222 69.996094 -124.7645 69.97081 
  -124.6686 70.016083 -124.6278 69.98497 -124.6583 69.96553 
  -124.8933 69.940262 -125.0731 69.791641 -125.1572 69.823593 
  -125.1844 69.855797 -125.2764 69.808296 -125.2414 69.760246 
  -124.8975 69.750526 -124.822 69.714981 -124.8664 69.682747 
  -124.9383 69.645813 -124.9753 69.730797 -125.0795 69.742752 
  -125.3781 69.678589 -125.41 69.628036 -125.2178 69.578033 
  -125.2928 69.549149 -125.1856 69.507202 -125.1317 69.484703 
  -125.3242 69.523857 -125.5781 69.471649 -125.6095 69.415253 
  -125.2345 69.462196 -125.0894 69.449692 -125.112 69.415817 
  -125.1653 69.381638 -125.4606 69.401093 -125.3922 69.359421 
  -125.4264 69.312187 -125.8067 69.383873 -125.9889 69.430527 
  -126.7058 69.766083 -126.8111 69.916367 -126.7653 69.93248 
  -126.8933 70.008873 -127.0611 70.18248 -127.2747 70.326103 
  -127.9967 70.59053 -128.08279 70.55275 -128.1606 70.491364 
  -128.1967 70.391922 -128.15781 70.371094 -127.9019 70.393311 
  -127.9725 70.345261 -128.1122 70.359703 -128.0284 70.286362 
  -127.7167 70.259697 -127.515 70.221649 -128.10921 70.182213 
  -128.3683 70.101639 -128.3614 70.058868 -128.30859 70.008034 
  -128.3242 69.948303 -128.9734 69.721649 -128.925 69.680817 
  -128.97749 69.674698 -129.1539 69.700256 -129.1297 69.74942 
  -129.16949 69.824692 -129.1097 69.847748 -128.9344 69.844147 
  -128.9561 69.889687 -128.8983 69.914429 -128.8989 69.962753 
  -128.9653 69.962479 -129.0589 69.873871 -129.14861 69.849983 
  -129.9447 69.756088 -130.3383 69.678307 -130.7478 69.449142 
  -130.64529 69.454697 -130.66811 69.424698 -130.77139 69.398857 
  -130.9472 69.264137 -130.9567 69.161926 -130.92281 69.135246 
  -131.01421 69.136917 -131.0247 69.209702 -130.9117 69.322197 
  -130.897 69.369713 -130.92751 69.393311 -131.0278 69.306641 
  -131.04781 69.33609 -130.9295 69.425262 -130.942 69.517761 
  -130.9903 69.539429 -131.0056 69.412483 -131.11639 69.322479 
  -131.03391 69.429138 -131.0386 69.511917 -131.10451 69.57164 
  -131.0831 69.60054 -131.1236 69.6147 -131.1839 69.602478 
  -131.1947 69.578873 -131.06219 69.510246 -131.10001 69.394417 
  -131.1458 69.374687 -131.1136 69.513313 -131.2225 69.574692 
  -131.14639 69.443314 -131.19341 69.36525 -131.41499 69.301361 
  -131.2072 69.399979 -131.21609 69.448303 -131.2572 69.501648 
  -131.26331 69.469147 -131.2514 69.404419 -131.32201 69.493317 
  -131.3764 69.449982 -131.42081 69.361649 -131.5347 69.333313 
  -131.4225 69.439697 -131.6075 69.473312 -131.67999 69.45192 
  -131.6458 69.421654 -131.8795 69.428307 -131.965 69.397202 
  -131.7144 69.397751 -131.8145 69.312187 -132.19701 69.212196 
  -132.2917 69.203873 -132.29469 69.231369 -132.3398 69.226639 
  -132.38499 69.139137 -132.4675 69.107193 -132.4239 69.150253 
  -132.4084 69.226929 -132.4353 69.230263 -132.4481 69.170532 
  -132.50639 69.12915 -132.8656 69.068314 -132.8681 69.026917 
  -132.8558 68.984421 -132.6758 68.926651 -132.8159 68.931923 
  -132.8159 68.904694 -132.705 68.880814 -132.7758 68.844147 
  -132.64639 68.849426 -132.6389 68.883591 -132.53889 68.877472 
  -132.5067 68.892197 -132.39281 68.85997 -132.4245 68.835251 
  -132.707 68.813873 -132.7225 68.786926 -132.7847 68.818588 
  -132.9619 68.851639 -132.9381 68.795807 -133.26579 68.859421 
  -133.3811 68.835533 -133.2047 68.786636 -133.2209 68.771637 
  -133.01199 68.713028 -132.9183 68.690262 -133.272 68.734421 
  -133.48421 68.811653 -133.4847 68.85025 -133.4258 68.851639 
  -133.46111 68.892761 -133.3994 68.881363 -133.3347 68.866089 
  -133.2261 68.913589 -133.21671 69.001923 -133.1833 69.040817 
  -132.9192 69.074982 -132.92281 68.985809 -132.8822 68.985527 
  -132.8981 69.077187 -132.8297 69.106918 -132.9072 69.12442 
  -132.82919 69.221359 -132.58 69.287483 -132.51559 69.268311 
  -132.505 69.202759 -132.48531 69.16275 -132.4317 69.256363 
  -132.44341 69.293587 -132.39281 69.308594 -132.3159 69.247757 
  -132.3394 69.311081 -132.0817 69.374687 -132.09419 69.41803 
  -132.08 69.480797 -132.0128 69.521362 -131.03999 69.640808 
  -131.0267 69.593033 -130.9192 69.5672 -130.81219 69.648323 
  -130.57829 69.708038 -130.522 69.782471 -130.0883 69.872192 
  -129.4942 70.026642 -129.5536 70.042763 -129.4695 70.049423 
  -129.41 70.094421 -129.40469 70.123032 -129.4323 70.126923 
  -129.4572 70.092484 -129.50391 70.109421 -129.4592 70.147476 
  -129.6295 70.160812 -129.5919 70.188583 -129.6611 70.252472 
  -129.78999 70.219971 -129.86861 70.099136 -130.0909 70.083313 
  -130.105 70.109703 -130.1575 70.056374 -130.1936 70.05748 
  -130.17081 70.105263 -130.3297 70.078873 -130.28529 70.101639 
  -130.4003 70.166367 -130.5242 70.103867 -130.5472 70.127472 
  -130.4722 70.173859 -130.657 70.13414 -130.66451 70.09137 
  -130.7484 70.081917 -130.71359 70.125526 -130.8053 70.104713 
  -131.0195 70.027763 -130.9306 70.021362 -131.0047 70.00386 
  -131.0806 69.884979 -131.1703 69.881927 -131.1519 69.85997 
  -131.185 69.824142 -131.2206 69.843033 -131.20329 69.889137 
  -131.24609 69.931091 -131.41029 69.957199 -131.4325 69.934982 
  -131.41859 69.901917 -131.645 69.864967 -131.76559 69.794693 
  -131.9344 69.761917 -132.147 69.685257 -132.2942 69.708313 
  -132.5406 69.740807 -132.6031 69.687187 -132.6022 69.666924 
  -132.4411 69.702477 -132.44949 69.654419 -132.36391 69.687759 
  -132.3325 69.671082 -132.4175 69.635529 -132.8922 69.655869) 
#(-132.8922 69.655869 -132.9886 69.595261 -132.95219 69.563309 
  -133.00861 69.477753 -133.6703 69.386642 -133.6911 69.359154 
  -133.70081 69.333862 -133.77 69.350807 -133.90559 69.287483 
  -134.1628 69.2547 -134.26469 69.159698 -134.55499 69.087753 
  -134.6292 69.008873 -134.6145 68.983307 -134.2234 68.699692 
  -134.2464 68.687469 -134.35809 68.680527 -134.47391 68.711357 
  -134.67641 68.877197 -134.8456 68.929428 -134.9922 68.8797 
  -135.2417 68.926933 -135.60001 68.890533 -135.60451 68.873032 
  -135.3419 68.83165 -135.5061 68.832474 -135.32249 68.72525 
  -135.187 68.687759 -135.3261 68.669144 -135.4239 68.699142 
  -136.0278 68.873032 -136.5222 68.909149 -136.6525 68.871094 
  -136.88721 68.916641 -137.255 68.948303 -138.2189 69.173309 
  -138.33501 69.239151 -138.3564 69.298309 -138.4097 69.303864 
  -138.4075 69.276917 -138.6006 69.236649 -138.6517 69.295258 
  -138.9395 69.399979 -139.1286 69.508324 -139.68781 69.574417 
  -139.7664 69.599983 -140.4883 69.599426 -140.9991 69.644562) 
#(-110.0132 68.62117 -108.9375 68.741089 -108.5514 68.879433 
  -108.5297 68.901367 -108.5633 68.933594 -108.4922 68.947479 
  -108.1756 68.931091 -107.5539 68.97554 -107.3042 69.032471 
  -107.1381 69.150528 -106.9361 69.21109 -106.925 69.239433 
  -106.9972 69.335251 -106.955 69.357193 -106.7533 69.37915 
  -106.7331 69.44165 -106.555 69.496368 -106.3103 69.40387 
  -106.2736 69.281372 -106.4103 69.217758 -106.4061 69.180527 
  -106.1778 69.14415 -105.8303 69.172203 -105.5539 69.152481 
  -105.4667 69.097473 -105.0358 69.05748 -105.0833 69.106369 
  -104.9117 69.065811 -104.9453 69.025818 -105.2742 68.948868 
  -104.8345 68.869713 -104.5117 68.873032 -104.4453 68.938873 
  -104.2708 68.900528 -104.2636 68.941589) 
#(15.05917 68.572479 15.39583 68.676651 15.40139 68.718872 
  15.36861 68.74025 15.27389 68.758034 15.35639 68.803864 
  15.37528 68.849426 15.23778 68.823868 15.29305 68.912201 
  15.23861 68.90831 15.14444 69.008324 15.08778 69.008034 
  15.01167 68.97081 15.01167 68.94136 15.11917 68.855263 
  15.14861 68.812187 15.03972 68.847473 15.00139 68.796371 
  14.95167 68.860527 14.90528 68.841919 14.95055 68.806091 
  14.90222 68.754433 14.67361 68.758591 14.67667 68.825256 
  14.62167 68.823303 14.60778 68.799973 14.64278 68.784973 
  14.56278 68.748581 14.55139 68.798576 14.52 68.801361 
  14.43861 68.75386 14.53916 68.731918 14.37111 68.683594 
  14.40861 68.635246 14.44861 68.604141 14.62028 68.622757 
  14.67833 68.707474 14.99639 68.698303 15.06611 68.743874 
  14.99667 68.761917 15.15 68.749153 15.15778 68.694977 
  14.96556 68.661362 14.81056 68.616928 15.05917 68.572479) 
#(-101.8314 68.566933 -101.7953 68.62886 -101.825 68.649696 
  -101.7017 68.637756 -101.6825 68.661636 -101.6942 68.768044 
  -102.0231 68.819427 -102.3417 68.678864 -101.8314 68.566933) 
#(151.6597 70.987427 152.5338 70.844147 152.5416 70.788879 
  153.4525 70.877472 153.6761 70.854424 154.23579 70.961357 
  155.42191 71.05275 155.5219 71.044693 155.4938 71.002197 
  155.5361 70.974426 155.5997 71.058594 155.8363 71.090263 
  156.78 71.093033 157.9783 71.040817 159.1516 70.844971 
  159.7002 70.658577 160.03799 70.405533 160.1058 70.276093 
  160.08971 70.238586 160.0083 70.201103 159.9539 70.121918 
  159.6886 70.133034 159.9113 70.093582 159.8569 70.059982 
  159.8638 69.994423 159.72549 69.936371 159.688 69.885529 
  159.7988 69.808594 159.72971 69.739151 159.87109 69.79303 
  160.1599 69.709976 160.175 69.728027 160.31799 69.696907 
  160.3152 69.652763 160.91299 69.641373 161.0058 69.574142 
  160.93221 69.509979 160.9241 69.45192 160.9852 69.361923 
  161.0414 69.160828 160.96381 69.103592 161.27049 69.042213 
  161.41161 68.979713 161.3791 68.924149 161.21719 68.789978 
  161.2202 68.736923 161.0925 68.586639 161.0125 68.550812 
  160.75549 68.561653 160.7666 68.535538 160.96941 68.519974 
  161.1277 68.555252 161.3416 68.699982 161.2905 68.736649 
  161.3277 68.798309 161.5797 68.914978 161.5519 69.036362 
  161.4919 69.069427 161.4808 69.116638 161.39079 69.218307 
  161.463 69.289139 161.4166 69.325531 161.485 69.344421 
  161.4325 69.373871 161.46159 69.390259 162.0161 69.543869 
  162.0211 69.582748 162.3233 69.662201 162.3277 69.699692 
  162.75301 69.648033 163.21719 69.717194 163.5999 69.680527 
  163.8725 69.728867 164.08501 69.761642 164.16521 69.708038 
  164.53239 69.599426 164.8972 69.583313 166.69411 69.513313 
  166.6899 69.492203 166.9413 69.500809 167.645 69.758324 
  167.7869 69.776093 168.07829 69.702187 167.95 69.659698 
  167.948 69.638031 168.1008 69.602753 168.258 69.532471 
  168.23689 69.501648 168.2305 69.291367 168.35519 69.221359 
  169.3589 69.082748 169.39771 69.054703 169.44051 68.863052 
  169.47971 68.819977 169.61659 68.776093 170.36861 68.819702 
  170.6133 68.755814 170.4416 68.835251 170.4514 68.861359 
  170.6599 68.911362 170.65109 68.884407 170.7213 68.818863 
  170.6886 68.939972 170.8938 68.989151 170.9697 69.051086 
  171.05721 69.019974 171.1608 69.040253 171.00771 69.065536 
  171.00191 69.114967 170.8891 69.17775 170.9308 69.239967 
  170.90739 69.306091 170.7422 69.38942 170.6655 69.532761 
  170.5424 69.604713 170.1627 69.594421 170.12109 69.617203 
  170.1561 69.659973 170.298 69.734421 170.46159 69.7397 
  170.5672 69.77803 170.53551 69.817467 170.55251 70.088593 
  170.40221 70.111923 170.4491 70.131927 170.578 70.123032 
  172.3474 69.970543 172.73689 69.979141 173.2325 69.816093 
  173.1855 69.803307 173.19189 69.779694 173.37 69.785248 
  173.4772 69.822479 173.46941 69.844971 173.28 69.909973 
  173.1619 69.900253 173.21249 69.926651 173.4763 69.950813 
  173.75011 69.846313) #(-96.607788 68.457474 -96.291397 68.473038 
  -96.127792 68.563873 -95.843903 68.6147 -95.801682 68.733871 
  -95.593903 68.752762 -95.539169 68.723312 -95.550293 68.69664 
  -95.546951 68.668869 -95.263062 68.80275 -95.210564 68.854713 
  -95.365303 68.899139 -95.654167 68.826637 -95.688606 68.873581 
  -95.840286 68.877197 -95.978058 69.049149 -95.924454 69.089417 
  -95.955566 69.141922 -96.073624 69.231644 -96.156952 69.163307 
  -96.118896 69.025528 -96.195282 69.038307 -96.235001 69.064148 
  -96.211403 69.128036 -96.251404 69.15387 -96.172501 69.265259 
  -96.218613 69.311081 -96.955566 69.523323 -97.113892 69.622192 
  -97.303886 69.698303 -97.391678 69.593307 -97.489464 69.673859 
  -97.339737 69.70137 -97.350853 69.710251 -97.874733 69.882477 
  -98.023621 69.882202 -98.107788 69.814697 -98.211121 69.799423 
  -98.314178 69.722198 -98.368057 69.601089 -98.078339 69.473038 
  -98.003891 69.435806 -98.078613 69.42276 -98.248901 69.48497 
  -98.357788 69.559143 -98.485573 69.583313 -98.56723 69.57637 
  -98.605293 69.535812 -98.587227 69.512192 -98.436401 69.479424 
  -98.448059 69.461639 -98.577507 69.479424 -98.609177 69.449692 
  -98.598068 69.430527 -98.388062 69.329147 -98.393623 69.308029 
  -98.441391 69.298027 -98.641953 69.29747 -98.706947 69.261368 
  -98.711121 69.199142 -98.798073 69.170532 -99.476959 69.130814 
  -99.593613 69.031372 -99.589737 69.011093 -99.188606 68.824142 
  -99.0439 68.864967 -99.118057 68.921082 -99.006958 68.907761 
  -98.981117 68.950531 -98.827507 68.929138 -98.811951 68.910538 
  -98.879997 68.852203 -98.847504 68.825531 -98.618896 68.796371 
  -98.53418 68.750809 -98.451134 68.749977 -98.39473 68.776917 
  -98.420288 68.829147 -98.37001 68.857483 -98.243057 68.81192 
  -98.291946 68.765808 -98.281677 68.746368 -98.105293 68.669693 
  -98.050003 68.694977 -97.875839 68.665527 -97.475014 68.535538 
  -97.130836 68.517471 -97.094452 68.539139 -97.121948 68.56665 
  -97.099457 68.587753 -96.607788 68.457474) 
#(-117.432 69.996658 -117.2389 69.753036 -116.8461 69.643044 
  -116.9186 69.594147 -116.7417 69.543297 -116.75 69.574982 
  -116.5814 69.560532 -116.5614 69.488586 -116.6189 69.474983 
  -116.5386 69.410248 -115.9559 69.292213 -115.1286 69.239433 
  -114.992 69.280258 -114.7978 69.252472 -114.3114 69.284973 
  -113.702 69.210251 -113.6922 69.189423 -113.6725 69.116638 
  -113.545 69.048027 -113.5681 69.018044 -113.6781 68.88887 
  -113.6172 68.845261 -113.677 68.811081 -113.5878 68.773857 
  -113.4211 68.628311 -113.0436 68.50415 -113.0378 68.488312 
  -113.2914 68.489151 -113.3094 68.467194 -113.2514 68.452187 
  -112.9611 68.47525 -111.6006 68.543587 -111.2536 68.51442 
  -111.2111 68.526093 -111.2183 68.55275 -111.3892 68.565811 
  -111.392 68.582474 -110.8775 68.607483 -110.8503 68.591087 
  -110.5611 68.616638 -110.3636 68.574692 -110.22 68.62915 
  -110.0132 68.62117) #(-29.23436 70.439537 -29.12528 70.386642 
  -28.805 70.465263 -28.278061 70.50386 -28.34584 70.439697 
  -28.334169 70.408859 -28.225281 70.368317 -28.099449 70.382477 
  -26.72472 70.478592 -26.4825 70.463867 -26.341669 70.386368 
  -26.353889 70.360283 -26.727779 70.287483 -26.95389 70.323593 
  -27.196671 70.266647 -27.43306 70.172203 -27.876949 70.088318 
  -28.09972 70.141083 -28.264721 70.139687 -28.441111 70.082474 
  -28.57584 70.095543 -28.58778 70.081917 -28.53083 70.043587 
  -28.125839 70.071907 -27.96806 70.006927 -27.535 70.049438 
  -27.51722 69.966919 -27.41584 69.955261 -27.274441 69.993591 
  -27.17028 70.169418 -26.89917 70.248581 -26.79723 70.253036 
  -26.307501 70.197746 -25.936951 70.292763 -25.21278 70.41304 
  -25.22834 70.382202 -25.394449 70.359154 -25.27528 70.353317 
  -25.353889 70.29747 -25.32972 70.273857 -25.23028 70.272476 
  -25.120001 70.336639 -25.000839 70.35997 -24.07 70.179428 
  -23.161671 70.09053 -22.099449 70.147476 -22.104719 70.106918 
  -22.373341 69.971359 -22.56278 69.974136 -22.56834 69.940811 
  -22.64222 69.933868 -22.791389 69.953873 -22.916389 69.939972 
  -22.79278 69.898033 -22.807501 69.879433 -23.065559 69.939972 
  -23.093889 69.916382 -23.040001 69.870796 -23.26667 69.863861 
  -22.91028 69.81192 -22.912781 69.796082 -23.01667 69.755814 
  -23.1875 69.788589 -23.25695 69.835533 -23.37056 69.855263 
  -23.32556 69.836357 -23.245279 69.75914 -23.64222 69.724426 
  -23.904169 69.755249 -23.832781 69.732483 -23.579439 69.623581 
  -23.728889 69.599136 -23.622499 69.584702 -23.660561 69.553589 
  -23.837219 69.50972 -23.99695 69.588318 -24.051941 69.552467 
  -24.331671 69.603027 -24.084169 69.512482 -24.07667 69.472748 
  -24.15834 69.465263 -24.12195 69.431091 -24.10611 69.413307 
  -24.27084 69.441933 -24.33778 69.423859 -24.360001 69.400818 
  -24.455 69.357758 -24.743059 69.426086 -24.752501 69.391373 
  -24.644449 69.363586 -24.615841 69.313026 -24.72084 69.301361 
  -24.760281 69.283577 -24.61389 69.279419 -24.625 69.258034 
  -24.805281 69.238861 -25.10195 69.297203 -25.25778 69.247192 
  -25.271111 69.227753 -25.06945 69.225807 -24.986389 69.197746 
  -25.019449 69.155807 -25.323891 69.12886 -25.26556 69.10054 
  -25.219999 69.045258 -25.282499 69.032784 -25.37389 69.041924 
  -25.34778 69.062187 -25.473061 69.055527 -25.599171 69.104141 
  -25.653339 69.088593 -25.53722 69.029137 -25.645559 68.998306 
  -25.456949 68.9897 -25.466669 68.956917 -25.688061 68.958862 
  -25.715839 68.931923 -25.57972 68.90303 -25.634451 68.866928 
  -25.799721 68.880539 -25.79361 68.84581 -26.28083 68.775818 
  -26.269171 68.72081 -26.609171 68.652763 -26.716669 68.66304 
  -26.71167 68.704697 -27.00778 68.625526 -27.01222 68.588028 
  -27.05806 68.57637 -27.28945 68.604141 -27.33556 68.586639 
  -27.22472 68.551651 -27.22278 68.53804 -27.42417 68.53804 
  -27.73917 68.534973 -27.759171 68.519974 -27.615841 68.494423 
  -27.6075 68.479424 -27.779169 68.468033 -27.92028 68.510803 
  -27.945841 68.568588 -28.036949 68.556374 -28.01222 68.448868 
  -28.102779 68.438873 -28.27667 68.501923 -28.35965 68.495163) 
#(-104.5725 68.394699 -104.4414 68.417213 -104.4278 68.456917 
  -104.4828 68.511642 -104.6825 68.573868 -104.9647 68.580811 
  -105.0817 68.546371 -104.8831 68.449982 -104.5725 68.394699) 
#(-74.994461 68.332748 -74.826141 68.342194 -74.816116 68.369713 
  -74.863907 68.3797 -74.776688 68.410538 -74.9039 68.426651 
  -74.777252 68.459976 -74.780579 68.49025 -74.844467 68.517761 
  -75.002502 68.673309 -75.224731 68.706093 -75.311974 68.689697 
  -75.416412 68.518044 -75.370033 68.4897 -75.029167 68.390533 
  -74.994461 68.332748) #(68.649979 68.312187 68.58136 68.332199 
  68.570251 68.376083 68.904694 68.614433 69.108307 68.872482 
  68.983307 68.874969 68.954422 68.904984 69.220261 68.957199 
  69.013603 68.944427 69.021637 68.964142 68.819977 68.911926 
  68.655258 68.921654 68.449692 68.983582 68.05748 69.269417 
  68.025253 69.35025 68.109421 69.38887 68.102753 69.496918 
  68.084976 69.550537 68.025253 69.532471 68.027763 69.500809 
  67.986649 69.482758 67.786087 69.516647 67.613037 69.591637 
  66.982193 69.699692 66.988586 69.676086 66.981918 69.643593 
  66.857193 69.630814 66.953873 69.535538 66.936371 69.521362 
  66.873581 69.541367 66.784698 69.592484 66.789703 69.694977 
  66.873306 70.001083 66.920807 70.039978 66.983032 70.054703 
  67.0047 70.024139 66.966637 69.988312 67.029137 69.958313 
  67.248581 70.015533 67.324142 70.103592 67.277206 70.093872 
  67.291641 70.158577 67.244141 70.188583 67.238312 70.141083 
  67.088028 70.217194 67.206917 70.396927 67.266647 70.411087 
  67.208862 70.526642 67.339706 70.750259 67.306641 70.79248 
  67.228867 70.825531 67.107193 70.835251 66.688873 70.760529 
  66.646927 70.838867 66.615807 70.887482 66.891647 71.077477 
  66.821373 71.101929 66.739433 71.046921 66.773857 71.017471 
  66.7547 71.0047 66.679138 71.001083 66.616364 71.025818 
  66.641373 71.071907 66.783859 71.142197 66.915527 71.292763 
  67.137756 71.314697 67.794693 71.487198 68.305252 71.709427 
  68.465263 71.812469 68.770248 72.277481 68.846916 72.45636 
  68.914978 72.481087 68.866638 72.528313 68.904419 72.549149 
  68.978592 72.671082 68.98526 72.702477 69.203308 72.780807 
  69.310532 72.879433 69.31192 72.935257 69.369423 72.960533 
  69.530533 72.974701 69.78804 72.964142 69.783577 72.934143 
  69.562187 72.914703 69.548027 72.895538 71.556557 72.907944) 
#(14.985 68.263031 15.55917 68.472198 15.54222 68.507477 
  15.61139 68.473312 15.34083 68.343872 15.335 68.326103 
  15.42611 68.333588 15.59972 68.30748 15.77861 68.434418 
  15.85555 68.431923 15.86444 68.462196 15.86972 68.399406 
  15.88333 68.362198 15.96028 68.380814 16.09944 68.534149 
  16.5075 68.55748 16.57361 68.702187 16.52861 68.721077 
  16.55583 68.773857 16.4925 68.78775 16.553329 68.82164 
  16.24305 68.89859 16.29277 68.837479 16.17889 68.851639 
  16.087219 68.813873 16.09639 68.792763 16.20639 68.754967 
  16.203609 68.72998 16.067221 68.727753 16.037781 68.696373 
  16.08305 68.677467 16.07333 68.633591 15.97639 68.665817 
  15.8125 68.606644 15.80861 68.554428 15.73944 68.526093 
  15.77361 68.626373 15.86389 68.646927 15.98444 68.74498 
  15.93972 68.785538 15.76333 68.732758 15.87583 68.792213 
  15.91166 68.95192 15.88694 68.963593 15.63611 68.94664 
  15.56917 68.878036 15.55361 68.843033 15.63861 68.818039 
  15.45944 68.808296 15.45472 68.756927 15.50916 68.736359 
  15.64555 68.739151 15.71361 68.698593 15.45167 68.72998 
  15.43556 68.703873 15.45833 68.656921 15.63194 68.605797 
  15.43806 68.615807 15.45194 68.552467 15.22278 68.560532 
  15.18167 68.522202 15.33583 68.48526 15.22944 68.449692 
  15.0 68.30304 14.985 68.263031) 
#(-70.023216 69.53688 -69.685028 69.548859 -69.300018 69.506088 
  -68.971413 69.555817 -68.593918 69.585533 -67.946411 69.454697 
  -67.258636 69.467484 -66.92836 69.383034 -66.676407 69.265808 
  -66.646683 69.203583 -66.689743 69.161926 -66.776138 69.12886 
  -67.016693 69.178589 -67.535294 69.159149 -68.210022 69.311371 
  -69.01503 69.35498 -69.241409 69.284149 -69.235023 69.259697 
  -69.11586 69.303307 -68.172523 69.269699 -68.088638 69.228867 
  -68.13002 69.197746 -68.263077 69.211357 -68.505287 69.195824 
  -68.707237 69.138313 -69.011139 69.119713 -69.09169 69.090813 
  -68.926971 69.098312 -68.956131 69.034149 -69.01503 68.976089 
  -68.930573 68.992752 -68.926407 69.025818 -68.61586 69.135803 
  -68.351677 69.171654 -67.725304 69.032204 -67.72113 69.009697 
  -68.029457 68.971359 -68.314194 69.010529 -68.485863 68.983307 
  -68.30336 68.985809 -68.040573 68.935257 -68.089752 68.901367 
  -68.001129 68.885529 -67.986969 68.854424 -68.473083 68.898857 
  -67.820297 68.787201 -68.407791 68.839142 -68.611969 68.835823 
  -68.515297 68.813583 -68.491676 68.791092 -68.967529 68.814697 
  -69.051971 68.846649 -69.361969 68.874153 -69.39447 68.857758 
  -69.245567 68.851357 -69.154167 68.827187 -69.357803 68.829147 
  -69.371407 68.812759 -68.95752 68.790527 -68.96669 68.754433 
  -68.52919 68.746643 -68.137527 68.691933 -68.095863 68.657204 
  -68.094467 68.627762 -68.680573 68.655533 -68.883911 68.608582 
  -68.594193 68.633591 -68.469467 68.606369 -68.559464 68.58165 
  -68.337799 68.593307 -68.18364 68.564972 -67.914467 68.546371 
  -67.90419 68.455811 -67.960571 68.396927 -67.898643 68.421654 
  -67.864471 68.549423 -67.525574 68.548576 -67.493073 68.52359 
  -67.63475 68.486649 -67.603912 68.453583 -67.622528 68.389137 
  -67.603638 68.37886 -67.551407 68.414429 -67.562813 68.487762 
  -67.232803 68.48053 -67.191971 68.426361 -67.100594 68.418297 
  -67.112808 68.478867 -66.961411 68.435806 -66.80336 68.467194 
  -66.66391 68.43248 -67.011139 68.353592 -67.286682 68.395813 
  -67.74585 68.343033 -67.852798 68.307213 -67.561691 68.333313 
  -67.583359 68.286636 -67.551697 68.258324 -67.482529 68.325813 
  -67.244186 68.358307 -67.011688 68.316093 -67.232483 68.281662) 
#(-52.498901 68.19371 -52.446678 68.227478 -52.558071 68.253311 
  -52.538349 68.290817 -52.76001 68.264687 -52.632511 68.231644 
  -52.9314 68.250526 -52.927231 68.269417 -52.781399 68.306641 
  -53.10973 68.282761 -53.20612 68.306641 -53.343899 68.269417 
  -53.388069 68.330261 -53.241959 68.351357 -53.088348 68.306923 
  -52.80946 68.407471 -52.426121 68.464706 -52.473339 68.509697 
  -51.947788 68.582474 -51.949718 68.554138 -51.363899 68.541924 
  -51.347511 68.560257 -51.163349 68.556923 -51.073898 68.601357 
  -51.003899 68.645538 -51.030289 68.668297 -51.060291 68.698593 
  -50.876122 68.613312 -50.853901 68.630539 -50.916401 68.666641 
  -50.98724 68.732483 -50.777241 68.771362 -50.751122 68.810532 
  -51.12418 68.733582 -51.291119 68.751648 -50.963348 68.931923 
  -51.05946 68.910812 -51.075569 68.886917 -51.190289 68.889137 
  -51.11446 68.926933 -51.08112 68.980797 -51.13279 69.040527 
  -51.08168 69.049423 -51.122231 69.098038 -50.76918 69.126083 
  -50.73418 69.100807 -50.904171 69.069427 -50.659451 69.07692 
  -50.52557 69.023033 -50.51862 68.944702 -50.345291 68.901917 
  -50.311119 68.924973 -50.466671 68.972473 -50.492512 69.013031 
  -50.462791 69.024139 -50.33807 68.997192 -50.345291 69.04776 
  -50.259178 69.054977 -50.26001 69.019417 -50.29668 68.98526 
  -50.24696 68.959427 -50.20612 68.964142 -50.188622 69.039429 
  -50.255001 69.076103 -50.43446 69.051361 -50.680561 69.102753 
  -50.67445 69.128036 -50.49445 69.122192 -50.159451 69.158859 
  -50.12973 69.204147 -50.14529 69.224701 -50.27335 69.1922 
  -50.470291 69.201103 -50.461399 69.237473 -50.372791 69.33609 
  -50.43251 69.338318 -50.524181 69.308594 -50.547508 69.258591 
  -50.571949 69.221649 -50.88612 69.173027 -51.119179 69.197479 
  -51.096119 69.218307 -50.868061 69.282761 -50.993061 69.320251 
  -50.96806 69.338028 -50.834461 69.341637 -50.899181 69.393044 
  -50.838902 69.431374 -50.865841 69.457474 -50.694462 69.48497 
  -50.482792 69.446091 -50.516682 69.488037 -50.23196 69.506363 
  -50.228901 69.529137 -50.878071 69.486076 -50.87529 69.51387 
  -50.791401 69.554703 -50.795292 69.583313 -50.846119 69.620796 
  -50.825291 69.633873 -50.747791 69.643311 -50.418072 69.591637 
  -50.42445 69.614433 -50.440842 69.652481 -50.78529 69.669693 
  -50.819462 69.705811 -50.597511 69.78331 -50.191959 69.757477 
  -50.321678 69.835533 -50.313622 69.873306 -50.589741 69.925537 
  -50.565842 69.973312 -50.306122 69.976357 -50.212231 70.015259 
  -50.24279 70.036087 -50.37001 70.041367 -50.69556 69.995796 
  -51.285839 69.962479 -51.04668 70.03331 -50.985008 69.993874 
  -50.861118 70.023323 -50.908901 70.039139 -51.2514 70.067749 
  -51.45557 69.959702 -51.56918 69.974983 -51.545292 70.028313 
  -51.639179 70.007751 -52.265289 70.0522 -52.482792 70.140533 
  -52.876949 70.279984 -53.93446 70.390808 -54.366119 70.589142 
  -54.628071 70.654137 -54.54446 70.731087 -54.293339 70.799698 
  -54.063622 70.829697 -52.722511 70.744713 -51.755291 70.48053 
  -50.676399 70.322746 -50.559181 70.333038 -50.536671 70.360809 
  -50.595852 70.39386 -50.66251 70.385803 -50.675289 70.404137 
  -50.531399 70.489967 -50.778069 70.416367 -51.037231 70.430817 
  -51.096119 70.463028 -50.98362 70.467758 -50.951679 70.476089 
  -51.05751 70.505814 -51.212509 70.501373 -51.345291 70.56665 
  -51.196678 70.623306 -50.877789 70.507477 -50.873901 70.539978 
  -50.89806 70.570824 -50.764179 70.53775 -50.75668 70.554703 
  -50.987789 70.611076 -50.975849 70.628593 -50.867229 70.657204 
  -50.658619 70.6147 -50.618061 70.623871 -50.653339 70.645538 
  -50.871681 70.68248 -51.10112 70.659149 -51.079449 70.727478 
  -51.071678 70.763031 -51.20668 70.688026 -51.430012 70.70636 
  -51.43446 70.751648 -51.27668 70.766647 -51.26862 70.806923 
  -51.221119 70.808296 -50.79974 70.714706 -50.68251 70.707199 
  -50.63335 70.74025 -50.9189 70.818863 -51.428341 70.899979 
  -51.951962 71.026642 -51.821678 71.065811 -51.190289 70.953873 
  -50.950008 70.971077 -50.918339 71.021927 -51.468899 71.053864 
  -51.48307 71.070534 -51.378071 71.090813 -51.389462 71.112198 
  -51.24279 71.128593 -51.256962 71.145538 -51.60918 71.107193 
  -51.817509 71.13414 -52.061401 71.094421 -52.244179 71.117477 
  -52.235569 71.133873 -51.863899 71.251923 -51.580009 71.252762 
  -51.527241 71.274696 -51.529171 71.305252 -51.69223 71.340263 
  -51.64584 71.361359 -51.80695 71.336906 -52.01556 71.25415 
  -52.482792 71.140808 -52.548618 71.159973 -52.54945 71.196091 
  -52.488899 71.222748 -52.3139 71.24054 -52.246681 71.28331 
  -52.28223 71.352478 -51.97279 71.42804 -51.388069 71.439697 
  -51.34552 71.482986) #(56.49263 68.581497 56.574711 68.635246 
  56.649151 68.634407 56.87027 68.563026 57.108051 68.540527 
  57.398041 68.580811 57.6161 68.741364 57.937481 68.750809 
  57.982769 68.784416 57.94249 68.819427 57.971371 68.846916 
  58.227772 68.887482 58.244431 68.869713 58.197491 68.833313 
  58.257771 68.781082 58.374439 68.750259 58.336102 68.730263 
  58.434711 68.742203 58.42915 68.762192 58.284988 68.791092 
  58.253601 68.840263 58.28944 68.900253 58.601101 68.961906 
  59.195541 68.997192 59.229431 68.97998 58.888599 68.933594 
  59.09277 68.911362 59.2761 68.833588 59.427212 68.745247 
  59.394989 68.699417 59.177761 68.697746 59.05777 68.616089 
  59.062481 68.570251 59.12471 68.530807 59.075821 68.47998 
  59.073318 68.421371 59.127209 68.401093 59.681099 68.338028 
  59.8736 68.385529 59.969151 68.467758 59.936378 68.523323 
  59.760269 68.640533 59.78693 68.668587 59.923321 68.72081 
  60.086651 68.686653 60.431099 68.707748 60.594711 68.750809 
  60.80027 68.888603 60.909988 68.914703 60.944149 68.983871 
  60.92194 69.099426 60.799709 69.164429 60.7211 69.170532 
  60.73415 69.106369 60.65971 69.105797 60.58527 69.136917 
  60.579708 69.274139 60.372761 69.415817 60.277489 69.490807 
  60.140541 69.574142 60.164989 69.635803 60.28693 69.670532 
  60.424709 69.666092 60.670818 69.679428 60.632771 69.727753 
  60.7211 69.73053 60.688042 69.759697 60.696098 69.811371 
  60.790539 69.851089 60.93166 69.863037 61.345268 69.812187 
  63.227489 69.688873 64.172203 69.537201 64.959137 69.319977 
  64.996368 69.285812 64.828033 69.284149 64.763031 69.190811 
  64.766922 69.152481 64.805817 69.143044 64.942749 69.204697 
  64.920258 69.235809 65.0672 69.272202 65.880814 69.121643 
  65.875809 69.10054 65.6772 69.118317 67.1297 68.837196 
  67.04248 68.815536 67.039139 68.789703 67.209976 68.699417 
  67.338318 68.690811 67.719147 68.531921 68.159416 68.411362 
  68.260529 68.334702 68.185257 68.236076 68.276642 68.233307 
  68.264977 68.187469 68.313873 68.193588 68.496643 68.271362 
  68.649979 68.312187) #(14.21055 68.166924 14.38361 68.179703 
  14.66972 68.246368 14.62472 68.258591 14.69278 68.281647 
  14.69694 68.31636 14.73861 68.33165 14.72139 68.251923 
  14.78194 68.260246 15.11417 68.411087 15.15861 68.452477 
  14.89583 68.428864 14.87861 68.373032 14.75222 68.351639 
  14.82805 68.400253 14.78528 68.424698 14.70639 68.42247 
  14.69583 68.374969 14.63972 68.425537 14.38389 68.367203 
  14.48361 68.328033 14.48306 68.295807 14.31722 68.315262 
  14.295 68.281082 14.33028 68.260803 14.20194 68.200256 
  14.21055 68.166924) #(30.858959 69.789658 30.90416 69.791092 
  31.40583 69.716087 31.403891 69.684418 31.32999 69.626923 
  31.324169 69.611923 31.45694 69.692749 31.77389 69.681091 
  31.81028 69.693588 31.691389 69.732193 31.713329 69.825813 
  31.756941 69.846649 31.86916 69.841637 32.038601 69.768311 
  32.079159 69.786636 32.090549 69.811371 31.91139 69.931091 
  31.941111 69.967484 32.055828 69.959427 32.516109 69.834427 
  32.523331 69.794144 32.724159 69.794693 33.130829 69.725807 
  33.121109 69.684143 33.045559 69.617477 32.849159 69.582474 
  32.161659 69.656372 32.182781 69.709976 32.15527 69.742752 
  32.10722 69.74498 32.12138 69.709976 32.094158 69.66275 
  31.970551 69.647751 32.068329 69.620796 32.01305 69.562187 
  32.134441 69.599426 32.434719 69.567749 32.39333 69.536087 
  32.4986 69.511368 32.485279 69.49942 32.190281 69.42775 
  32.286381 69.426651 32.46278 69.49054 32.901939 69.481087 
  32.81443 69.449417 32.778049 69.409698 32.89333 69.459137 
  33.069721 69.472473 33.07943 69.462196 32.82999 69.341087 
  32.851101 69.308296 32.958611 69.384697 33.326939 69.448868 
  33.52166 69.421921 33.492222 69.374969 33.45472 69.343307 
  33.289162 69.296082 33.30722 69.280258 33.477489 69.267761 
  33.294441 69.228027 33.522221 69.216087 33.51083 69.178864 
  33.01944 69.056091 33.008888 68.965263 33.031658 68.957474 
  33.047779 69.041641 33.075272 69.059418 33.255829 69.079422 
  33.567501 69.183029 33.581669 69.31192 33.641392 69.325531 
  34.37138 69.315811 34.664989 69.244141 35.129711 69.217758 
  35.178329 69.178864 35.266109 69.218582 35.16888 69.255249 
  35.178329 69.27359 35.67944 69.21637 36.411659 69.035248 
  37.824711 68.65831 37.867771 68.623306 38.332218 68.436371 
  38.40361 68.334702 38.768608 68.283859 38.608601 68.327477 
  38.5061 68.368591 38.637501 68.380814 39.10944 68.211357 
  39.61005 68.059914) #(13.48944 68.043587 13.55528 68.083313 
  13.59472 68.121368 13.68556 68.06192 13.84472 68.108307 
  13.8475 68.126923 13.77528 68.15303 13.91917 68.164978 
  14.11944 68.224426 14.09417 68.258034 13.65972 68.286362 
  13.51444 68.234703 13.63333 68.211357 13.48306 68.181091 
  13.58722 68.154419 13.44972 68.067467 13.48944 68.043587) 
#(-95.445473 68.006104 -95.461403 68.063873 -95.101959 68.086906 
  -95.009171 68.044418 -94.767227 68.046082 -94.192497 68.276367 
  -94.208069 68.35025 -93.375839 68.633324 -93.752228 68.613586 
  -93.696136 68.692467 -93.566116 68.849426 -93.64418 68.895538 
  -93.63501 68.931374 -93.666946 68.972198 -93.845291 68.959427 
  -93.837227 69.006363 -93.90918 68.998032 -94.069168 68.891083 
  -94.068069 68.864151 -94.03418 68.833313 -94.108063 68.755249 
  -94.250313 68.755814 -94.410843 68.71553 -94.632507 68.75415 
  -94.545288 68.884697 -94.586121 68.943588 -94.587509 68.968872 
  -94.424728 68.945534 -94.352226 69.020538 -94.220573 69.029419 
  -94.011948 69.158043 -94.248611 69.120529 -94.329453 69.161362 
  -94.260277 69.274406 -94.309448 69.294144 -94.284447 69.318863 
  -94.152237 69.343033 -93.866959 69.343872 -93.75528 69.39386 
  -93.554733 69.440536 -93.547791 69.420532 -93.801964 69.310806 
  -93.876106 69.218033 -93.81279 69.214981 -93.837509 69.164429 
  -93.36557 69.376083 -93.588623 69.368317 -93.441391 69.48053 
  -93.541122 69.523323 -93.684174 69.522202 -93.789459 69.476357 
  -93.833069 69.491089 -93.872787 69.446907 -93.928619 69.431923 
  -94.313339 69.44664 -94.451683 69.518593 -94.569458 69.645248 
  -94.600014 69.633873 -94.63945 69.683296 -94.766953 69.651093 
  -94.730827 69.602753 -94.83139 69.565811 -95.724731 69.789978 
  -95.787231 69.741364 -95.829178 69.765259 -95.806122 69.78804 
  -95.884453 69.774696 -96.200562 69.864967 -96.08223 69.873581 
  -96.116119 69.953873 -96.22084 69.957474 -96.509171 70.108582 
  -96.571671 70.234421 -96.54834 70.328873 -96.434723 70.409973 
  -96.340286 70.415253 -96.286957 70.528313 -96.243057 70.569702 
  -96.171951 70.529694 -96.069733 70.587753 -95.813629 70.531372 
  -95.799454 70.549149 -96.043617 70.598312 -96.055557 70.643044 
  -96.202789 70.621643 -96.611954 70.794418 -96.613892 70.821091 
  -96.498062 71.002762 -96.37001 71.089981 -96.409447 71.119423) 
#(-91.512413 70.153839 -91.542801 70.140808 -92.036133 70.126923 
  -92.294724 70.250809 -92.309723 70.221359 -92.268623 70.190811 
  -92.422791 70.168297 -92.396118 70.139687 -92.548889 70.085823 
  -92.565292 70.070824 -92.268623 70.09053 -91.993057 70.058594 
  -91.940002 70.020248 -92.254997 69.877762 -92.555008 69.808296 
  -92.545288 69.774696 -92.579178 69.759407 -92.656952 69.788857 
  -92.65863 69.761093 -92.868057 69.702187 -92.535294 69.705261 
  -92.3414 69.697197 -92.371674 69.66304 -92.277237 69.663589 
  -92.090843 69.616089 -92.279449 69.628593 -91.799454 69.484703 
  -91.475304 69.664429 -91.125 69.637192 -91.101959 69.620796 
  -91.360863 69.545532 -91.514717 69.534149 -91.553886 69.505539 
  -91.192497 69.562759 -91.103058 69.508873 -90.883347 69.531372 
  -90.884743 69.483307 -90.758904 69.482758 -90.698624 69.539429 
  -90.370827 69.457199 -90.358063 69.429703 -90.691116 69.45137 
  -90.585007 69.414139 -90.799179 69.359703 -90.805573 69.282761 
  -90.822243 69.251648 -90.944458 69.258873 -90.920563 69.299698 
  -91.070557 69.265808 -90.956413 69.356369 -91.193077 69.287483 
  -90.654457 69.070534 -90.705307 69.036087 -90.691406 68.991928 
  -90.621948 68.991089 -90.578339 68.946907 -90.625839 68.913307 
  -90.517502 68.905258 -90.436684 68.866089 -90.520859 68.837196 
  -90.438919 68.823303 -90.464737 68.770813 -90.507233 68.779694 
  -90.527786 68.736649 -90.479736 68.70192 -90.526962 68.652206 
  -90.489731 68.586906 -90.53891 68.565262 -90.474747 68.530807 
  -90.603897 68.455811 -90.601669 68.436371 -90.315842 68.369141 
  -90.319168 68.346359 -90.272781 68.237762 -90.178619 68.235809 
  -90.118057 68.262192 -90.167793 68.312469 -90.029716 68.357758 
  -90.001129 68.414429 -89.898361 68.454422 -89.838623 68.531372 
  -89.920288 68.553589 -89.950012 68.607758 -89.809738 68.710251 
  -89.780853 68.705811 -89.746689 68.664703 -89.766678 68.621918 
  -89.717506 68.645538 -89.724731 68.671654 -89.691963 68.759407 
  -89.756958 68.939972 -89.71669 69.006088 -89.306961 69.251373 
  -89.101959 69.27359 -88.94252 69.22998 -88.870293 69.14859 
  -88.279167 68.939697 -87.962517 68.755539 -87.787781 68.327477 
  -87.936111 68.195824 -88.039459 68.235809 -88.155006 68.231369 
  -88.181122 68.338867 -88.215843 68.371918 -88.395844 68.285248 
  -88.342529 68.223587 -88.277786 68.10553 -88.381119 68.025253 
  -88.365433 68.002983) #(-72.940247 67.942177 
  -72.903061 67.968872 -72.990593 68.193863 -73.013924 68.24054 
  -73.06723 68.201637 -73.166672 68.239433 -73.49614 68.275528 
  -73.3078 68.320251 -73.293083 68.348312 -73.269203 68.374969 
  -73.467239 68.313026 -73.640289 68.254433 -73.628067 68.294144 
  -73.74086 68.311653 -73.948639 68.411926 -73.867523 68.493027 
  -73.738907 68.514977 -73.728912 68.53804 -73.815582 68.570534 
  -73.748917 68.581093 -73.725861 68.618874 -73.823914 68.620529 
  -73.704727 68.656647 -73.775017 68.689697 -74.176697 68.723587 
  -74.051132 68.670532 -73.881973 68.549698 -73.921417 68.511917 
  -73.990593 68.492752 -74.144203 68.523033 -74.50502 68.594421 
  -74.5289 68.630814 -74.727249 68.732193 -74.719467 68.770538 
  -74.577217 68.79303 -74.551407 68.830544 -74.689743 68.839142 
  -74.671951 68.818863 -74.635033 68.793297 -74.778351 68.765808 
  -74.984741 68.809418 -74.682533 68.874687 -74.695572 68.91275 
  -74.704742 68.934143 -75.035583 68.901642 -74.846413 68.940536 
  -75.017242 68.946373 -74.842506 69.006927 -74.797523 68.997482 
  -74.638077 69.016083 -74.660843 69.044418 -74.834183 69.08165 
  -74.952507 69.048576 -75.059738 68.955544 -75.14003 68.884697 
  -75.202217 68.894417 -75.454742 69.021088 -75.507248 69.012482 
  -75.581131 68.97554 -75.501968 68.926086 -76.420578 68.679138 
  -76.575577 68.674149 -76.660858 68.699417 -76.689468 68.74054 
  -76.666962 68.76915 -76.561401 68.818039 -76.523903 68.876373 
  -76.655838 68.924698 -76.640556 69.00914 -76.578339 69.032204 
  -76.332787 69.054428 -75.996689 69.00386 -75.934189 69.033043 
  -75.598892 69.089417 -75.569473 69.15831 -75.603363 69.238861 
  -75.694183 69.280258 -76.16864 69.411362 -76.402237 69.399979 
  -76.641968 69.55748 -76.620033 69.586357 -76.459183 69.654419 
  -76.205582 69.615807 -76.18808 69.665253 -76.570297 69.690536 
  -76.631973 69.669693 -76.543083 69.674698 -76.535294 69.638603 
  -76.70752 69.559418 -76.872803 69.58136 -76.883911 69.59581 
  -76.821411 69.626083 -76.967529 69.591919 -77.186127 69.637482 
  -77.155853 69.680527 -76.99086 69.701637 -76.939468 69.679703 
  -76.868073 69.684692 -76.793907 69.718582 -76.788361 69.752197 
  -76.891968 69.754433 -76.905579 69.794693 -76.766418 69.810532 
  -76.787231 69.83609 -77.309189 69.830811 -77.285019 69.860527 
  -77.152527 69.894417 -77.488907 69.861649 -77.508636 69.826637 
  -77.444473 69.789429 -77.519203 69.766922 -77.594193 69.74025 
  -77.651688 69.776642 -77.67836 70.187759 -77.777252 70.23526 
  -77.949188 70.243317 -78.164177 70.254433 -78.146683 70.231087 
  -78.166412 70.19165 -78.364754 70.201103 -78.540298 70.309143 
  -78.38945 70.332199 -78.504471 70.358032 -78.579742 70.343033 
  -78.704742 70.374687 -78.743912 70.449142 -78.820023 70.438873 
  -78.889183 70.479141 -78.873062 70.407471 -79.070862 70.469704 
  -79.048897 70.523857 -79.051971 70.539978 -78.963074 70.533859 
  -78.969193 70.550262 -78.860313 70.596649 -78.718903 70.54776 
  -78.851967 70.638031 -78.886414 70.621094 -79.025299 70.680252 
  -79.101677 70.647751 -79.150017 70.613037 -79.001968 70.613312 
  -79.142242 70.501923 -79.160019 70.438026 -79.210022 70.41803 
  -79.293327 70.444702 -79.301407 70.484421 -79.227798 70.51886 
  -79.23114 70.553589 -79.309464 70.540817 -79.279457 70.521637 
  -79.320557 70.472473 -79.575577 70.429428 -79.589172 70.399406 
  -79.513901 70.375809 -79.357803 70.369713 -79.254471 70.332199 
  -79.027252 70.339417 -78.939194 70.311081 -78.763062 70.183594 
  -78.747528 70.126648 -78.680573 70.040253 -78.665024 69.961357 
  -78.799744 69.876083) #(-159.7697 70.1922 -159.93359 70.359703 
  -159.9817 70.368317 -160.06889 70.328583 -160.1281 70.330261 
  -159.9267 70.488861 -160.0961 70.463593 -160.19859 70.471649 
  -159.93359 70.51886 -159.93719 70.550262 -159.9375 70.593307 
  -160.1347 70.578583 -160.1503 70.604713 -160.2197 70.568314 
  -160.63091 70.437187 -160.6122 70.42775 -160.9817 70.319702 
  -160.9492 70.289978 -161.65109 70.246918 -161.7003 70.193039 
  -162.1208 70.155533 -162.02251 70.190262 -161.8938 70.18866 
  -161.8436 70.216003 -161.8956 70.256363 -161.7917 70.250259 
  -161.7014 70.266373 -161.8567 70.289978 -162.355 70.108307 
  -162.33859 70.088867 -162.4864 70.047203 -162.4847 69.99942 
  -162.5753 69.938026 -162.8286 69.840813 -163.02609 69.728592 
  -162.9442 69.719421 -162.9359 69.697479 -163.0325 69.654419 
  -163.14391 69.596359 -163.06531 69.568039 -163.07001 69.498306 
  -163.1097 69.489151 -163.1203 69.384697 -163.245 69.297203 
  -163.2711 69.298576 -163.175 69.398857 -163.1842 69.418869 
  -163.24609 69.333862 -163.7028 69.085533 -164.272 68.935532 
  -165.0892 68.8797 -166.1992 68.883873 -166.2364 68.870247 
  -166.22591 68.572479 -166.3067 68.522202 -166.3067 68.482483 
  -166.3667 68.439148 -166.3186 68.395248 -166.5892 68.35025 
  -166.757 68.363312 -166.8195 68.346649 -166.21809 68.269699 
  -165.9192 68.130814 -165.39281 68.04776 -164.7565 67.840027) 
#(-115.1136 67.798576 -115.257 67.85498 -115.2531 67.883034 
  -115.4236 67.878311 -115.537 67.905258 -115.5275 67.930252 
  -115.2047 67.978027 -115.1139 68.017471 -115.2206 68.023857 
  -115.2428 68.04747 -115.1739 68.13414 -115.2119 68.160248 
  -115.225 68.184143 -114.8964 68.146927 -114.7553 68.189697 
  -114.96 68.285812 -114.1286 68.238586 -114.0111 68.250259 
  -114.05 68.287483 -114.0417 68.317467 -113.9103 68.400253 
  -113.9747 68.435532 -114.0483 68.390533 -114.1245 68.418587 
  -114.1175 68.435532 -114.0575 68.433868 -114.0606 68.45665 
  -114.1217 68.517471 -114.41 68.619423 -114.4483 68.689697 
  -114.7492 68.751373 -114.8217 68.809692 -115.4464 68.937759 
  -115.7781 68.936371 -116.2614 68.97998 -116.3242 68.951637 
  -115.9414 68.81192 -116.0103 68.808296 -116.3814 68.882477 
  -116.4361 68.858582 -116.7567 68.883324 -116.9203 68.930252 
  -116.97 68.916924 -116.9789 68.899979 -117.5208 68.961639 
  -118.4683 69.120796 -118.6447 69.212479 -118.8556 69.252472 
  -119.9822 69.344704 -120.2753 69.404137 -120.9342 69.64859 
  -121.9306 69.814423 -122.1831 69.794693 -122.7486 69.825157) 
#(14.78555 67.782471 14.75555 67.799973 14.80222 67.823868 
  15.0325 67.839706 15.09916 67.854424 14.84944 67.844421 
  14.99222 67.893044 15.22528 67.872757 15.21611 67.862198 
  15.19889 67.828583 15.335 67.898323 15.54889 67.916092 
  15.52111 67.877472 15.56694 67.904137 15.78167 67.947479 
  15.86167 67.898857 15.96528 67.9897 15.84778 68.052467 
  15.59944 68.032761 15.52639 68.075256 15.41083 68.008034 
  15.41389 67.989151 15.32166 67.998581 15.28305 68.035538 
  15.35889 68.080544 15.50194 68.131638 15.53028 68.089706 
  15.59889 68.123032 15.72666 68.140808 15.73444 68.089142 
  15.6175 68.088028 15.65444 68.044693 15.9225 68.130814 
  15.87389 68.182747 15.95417 68.188583 15.95333 68.238586 
  16.005831 68.244423 16.05055 68.226089 16.032221 68.165817 
  16.103609 68.166092 16.092501 68.068039 16.040831 68.028587 
  16.20472 67.969704 16.21722 67.888031 16.41444 67.814697 
  16.50972 67.8022 16.251659 67.896637 16.27722 67.949142 
  16.2075 68.001648 16.27389 68.006363 16.4175 67.90303 
  16.46666 67.90387 16.32777 67.995796 16.34889 68.006638 
  16.460279 67.958588 16.45805 67.981087 16.499161 68.010803 
  16.372499 68.025253 16.36861 68.041641 16.4622 68.068771 
  16.684999 68.049973 16.675831 68.073303 16.294439 68.083313 
  16.25083 68.129433 16.41361 68.13414 16.419439 68.184143 
  16.162781 68.197197 16.17194 68.220261 16.340269 68.224136 
  16.331671 68.252197 16.251659 68.247757 16.103331 68.276917 
  16.190001 68.31636 16.54389 68.2397 16.566111 68.193039 
  16.797779 68.127197 16.750549 68.152763 16.578051 68.265533 
  16.245279 68.330261 16.479441 68.390533 16.838051 68.375259 
  16.83444 68.318039 17.15139 68.363861 17.329439 68.250526 
  17.315001 68.164429 17.36694 68.184692 17.354719 68.226639 
  17.400829 68.23053 17.39917 68.258873 17.26778 68.307747 
  17.20083 68.366928 17.25861 68.401917 17.448891 68.372757 
  17.578051 68.362473 17.370001 68.406082 17.37583 68.415527 
  17.59437 68.42334 17.696369 68.404449 17.763889 68.39386 
  17.465 68.450813 17.55278 68.523857 17.519171 68.525253 
  17.225559 68.444977 17.010559 68.437187 17.08 68.456917 
  17.095831 68.476639 16.991659 68.50415 16.843611 68.448593 
  16.49889 68.437469 16.48444 68.48497 16.48139 68.522202 
  16.63722 68.54303 16.564159 68.571907 16.566111 68.604713 
  16.640551 68.643044 16.999161 68.700256 17.15444 68.62915 
  17.184999 68.644417 17.094999 68.679703 17.112221 68.695251 
  17.2575 68.720543 17.62833 68.660812 17.670561 68.663857 
  17.468439 68.690292 17.423889 68.735809 17.290279 68.732758 
  17.24305 68.759697 17.47583 68.808868 17.76778 68.7547 
  17.469999 68.830261 17.715269 68.889977 17.828329 68.863037 
  17.84833 68.875259 17.685829 68.929138 17.46583 68.900253 
  17.43166 68.910812 17.538891 68.962479 17.48778 68.989967 
  17.680269 69.089981 17.648609 69.108032 18.15222 69.152206 
  18.06805 69.171371 18.097771 69.230263 17.989441 69.231644 
  18.01639 69.303864 18.17222 69.386368 18.151661 69.455811 
  18.285 69.488861 18.35639 69.458862 18.386391 69.415527 
  18.358061 69.38887 18.43111 69.393311 18.49972 69.368317 
  18.506109 69.256927 18.54166 69.322197 18.57111 69.355797 
  18.68972 69.257751 18.70722 69.279419 18.667219 69.304977 
  18.687771 69.3172 18.88583 69.317467 18.45389 69.449142 
  18.471661 69.51442 18.84194 69.55275 18.867769 69.529984 
  18.847219 69.501373 19.11722 69.355263 19.34889 69.334702 
  19.381109 69.307747 19.34528 69.283577 19.187771 69.273033 
  19.26667 69.26387 19.25111 69.236923 19.311661 69.221359 
  19.506941 69.223862 19.444719 69.255814 19.44972 69.321907 
  19.352501 69.374687 19.124439 69.381363 18.995831 69.467194 
  19.02944 69.513603 19.261391 69.526642 19.21361 69.56636 
  19.000271 69.534416 18.94611 69.573868 18.956671 69.62442 
  19.103331 69.699692 19.10639 69.7397 19.57972 69.801086 
  19.780279 69.803307 19.772779 69.780533 19.67639 69.668297 
  19.72361 69.655533 19.714161 69.603317 19.531389 69.393593 
  19.686939 69.434418 19.74194 69.607758 19.79694 69.613312 
  20.115549 69.581093 19.85111 69.630814 19.82111 69.697479 
  19.997499 69.839706 19.972771 69.784698 20.025 69.775528 
  20.16666 69.935806 20.165831 69.885529 20.217501 69.852478 
  20.20055 69.921371 20.28194 69.973862 20.318331 69.959702 
  20.424999 69.869423 20.32139 69.663589 20.387501 69.621094 
  20.37278 69.584702 20.271111 69.559143 20.303049 69.537483 
  20.19055 69.402206 19.981939 69.335533 19.918329 69.260246 
  19.96805 69.262482 20.04055 69.315262 20.28861 69.388313 
  20.48444 69.57692 20.639441 69.523857 20.853609 69.494713 
  20.70944 69.527763 20.48139 69.63887 20.538891 69.68248 
  20.541389 69.721077 20.479719 69.75914 20.80389 69.803589 
  20.826111 69.835533 20.791389 69.873032 20.922501 69.911362 
  21.09166 69.940262 20.89361 69.849426 21.0 69.784149 
  21.05167 69.791924 20.99444 69.819427 21.106939 69.867477 
  21.18889 69.856369 21.12639 69.809418 21.1625 69.810532 
  21.22611 69.849136 21.21167 69.900528 21.328051 69.905807 
  21.20611 69.938026 21.25333 70.003036 21.319441 70.022202 
  21.44278 70.017471 22.068609 69.731369 22.10083 69.751648 
  21.91444 69.833313 21.997219 69.833313 22.01722 69.853317 
  21.926941 69.880814 21.915279 69.949692 22.014999 69.982193 
  22.067499 69.940262 22.050831 70.010803 22.115549 70.02887 
  21.83639 70.01886 21.811661 70.042763 22.03167 70.064148 
  22.096661 70.113312 21.93222 70.079422 21.48139 70.095543 
  21.433331 70.141647 21.48778 70.17276 21.309719 70.161362 
  21.20895 70.207352) #(-73.41864 67.766373 -73.348618 67.828033 
  -73.432251 67.919144 -73.412514 67.963867 -73.46225 67.9897 
  -73.656403 68.007477 -74.275009 68.070824 -74.21669 68.13414 
  -74.325027 68.17247 -74.46669 68.064148 -74.748917 68.065536 
  -74.778061 68.006088 -74.759193 67.950256 -74.535294 67.804703 
  -74.320297 67.76886 -73.41864 67.766373) 
#(-86.676682 67.731644 -86.563629 67.734154 -86.396118 67.859703 
  -86.368622 67.954697 -86.435013 68.162483 -86.418327 68.213318 
  -86.646683 68.301651 -86.712227 68.299149 -86.912804 68.169983 
  -86.898064 68.136093 -86.978897 68.096916 -86.986969 68.061653 
  -86.847778 68.020248 -86.843628 67.958588 -86.946136 67.909416 
  -86.858337 67.796921 -86.676682 67.731644) 
#(-100.5878 67.793297 -100.5817 67.834137 -100.612 67.842194 
  -100.8511 67.79303 -100.8767 67.820534 -100.9186 67.80275 
  -100.9042 67.756927 -101.4561 67.720543 -101.41 67.687759 
  -101.5725 67.684143 -101.9789 67.78775 -102.0395 67.742203 
  -102.142 67.76915 -102.2211 67.718582 -102.2275 67.68692 
  -102.3539 67.747757 -103.3695 68.010803 -103.3417 68.116089 
  -103.39 68.161362 -103.4572 68.160538 -103.5581 68.104424 
  -103.5447 68.059982 -103.8433 68.020813 -104.5 68.031921 
  -104.6672 68.149979 -104.5972 68.222198 -104.6097 68.241364 
  -104.6878 68.250259 -104.9145 68.227203 -104.9528 68.252472 
  -104.8531 68.276642 -104.8359 68.310806 -104.8939 68.348862 
  -105.0825 68.308029 -105.0039 68.262756 -105.0881 68.263031 
  -105.295 68.339142 -105.3383 68.412201 -105.4164 68.406921 
  -105.5481 68.422203 -105.5381 68.445534 -105.4231 68.491928 
  -105.3253 68.468033 -105.3261 68.510803 -105.4075 68.51915 
  -105.5447 68.661926 -105.4783 68.698593 -105.487 68.729424 
  -105.7981 68.879433 -106.2292 68.940811 -106.4681 68.861649 
  -106.8208 68.811371 -107.3186 68.695824 -108.2792 68.618317 
  -108.3689 68.587196 -108.8153 68.262192 -108.7156 68.231369 
  -108.4436 68.308029 -108.3972 68.278587 -108.4533 68.185532 
  -108.392 68.180252 -108.3925 68.218872 -108.3539 68.231087 
  -108.3244 68.192749 -108.3386 68.145813 -108.367 68.161087 
  -108.4281 68.154137 -108.4328 68.131088 -108.4031 68.114967 
  -108.3322 68.117203 -108.1614 68.17276 -107.8956 68.146637 
  -107.8258 68.180527 -107.7203 68.174973 -107.6025 68.175262 
  -107.8853 68.26886 -107.8133 68.342484 -107.3272 68.312469 
  -107.2589 68.259979 -107.132 68.272476 -107.0136 68.369423 
  -106.7961 68.370529 -106.8025 68.389977 -106.7789 68.408043 
  -106.5728 68.291092 -106.5272 68.300812 -106.5645 68.342758 
  -106.4875 68.383324 -106.4878 68.404984 -106.6158 68.437759 
  -106.6142 68.470543 -106.5286 68.443039 -106.5042 68.466087 
  -106.535 68.482193 -106.5378 68.501373 -106.1306 68.587196 
  -105.645 68.633873 -105.772 68.53804 -105.6972 68.486649 
  -105.7303 68.419144 -105.7822 68.413857 -105.822 68.449982 
  -105.9933 68.391647 -106.2442 68.389977 -106.465 68.335823 
  -106.49 68.221359 -106.3447 68.183296 -106.4447 68.151642 
  -106.5995 68.247482 -106.64 68.236649 -106.6256 68.184418 
  -106.6636 68.169418 -106.7 68.223587 -106.8094 68.207199 
  -106.7531 68.157761 -106.7551 68.10611) 
#(-28.35965 68.495163 -28.26556 68.45636 -28.293329 68.421654 
  -28.49334 68.446907 -28.63028 68.391922 -28.81167 68.375259 
  -28.84778 68.318588 -28.97278 68.36026 -28.98889 68.341637 
  -29.147779 68.395813 -29.209169 68.378593 -29.102779 68.324692 
  -29.120279 68.280533 -29.192499 68.259407 -29.27528 68.317467 
  -29.47028 68.244713 -29.378059 68.198868 -29.50806 68.21637 
  -29.63611 68.261642 -29.61611 68.29303 -29.697781 68.288307 
  -29.788891 68.320534 -29.781389 68.372192 -29.870001 68.41275 
  -30.06695 68.321373 -30.067221 68.29776 -30.004999 68.265533 
  -30.00139 68.244141 -30.28195 68.257202 -30.11972 68.222748 
  -30.01222 68.128311 -30.03056 68.111649 -30.352221 68.092484 
  -30.40889 68.142197 -30.39333 68.194702 -30.414721 68.222473 
  -30.807501 68.251373 -30.46833 68.167763 -30.442499 68.075813 
  -30.45389 68.057747 -30.91584 68.07164 -30.919451 68.040817 
  -31.40361 68.112762 -31.450001 68.135818 -31.346109 68.149979 
  -31.472231 68.151642 -31.495001 68.115807 -31.422501 68.097198 
  -31.422501 68.082489 -31.498341 68.072746 -31.70472 68.098312 
  -31.67889 68.182747 -31.72526 68.20578 -31.695841 68.236923 
  -32.007229 68.261917 -32.16806 68.399139 -32.135281 68.453033 
  -32.164452 68.483032 -32.259171 68.41861 -32.32917 68.448029 
  -32.304451 68.492752 -32.42889 68.621918 -32.50528 68.610809 
  -32.45723 68.54776 -32.403339 68.541367 -32.432499 68.499153 
  -32.565559 68.498032 -32.43111 68.37944 -32.200562 68.341919 
  -32.091671 68.213867 -32.097229 68.183868 -32.430561 68.234154 
  -32.443611 68.194138 -32.035 68.143044 -31.99778 68.089417 
  -32.00639 68.046082 -32.097229 68.063309 -32.14473 68.036636 
  -32.071949 67.995796 -32.10778 67.958038 -32.041111 67.923309 
  -32.182499 67.919983 -32.188061 67.890808 -32.12278 67.857758 
  -32.17001 67.842758 -32.354172 67.88414 -32.546669 67.861076 
  -32.532501 67.821091 -32.930561 67.682213 -32.99931 67.686333) 
#(79.048309 67.5672 78.804428 67.623581 78.820251 67.63414 
  78.587196 67.60054 78.464417 67.630539 78.574692 67.625809 
  78.611359 67.659149 78.424423 67.698303 78.397476 67.634697 
  78.31665 67.675262 78.23526 67.656082 77.989151 67.694702 
  77.87442 67.678864 77.868591 67.697746 77.949417 67.721916 
  77.765259 67.776917 77.749977 67.738586 77.651917 67.722748 
  77.481087 67.749977 77.453308 67.781082 77.481087 67.908859 
  77.585823 67.943039 77.473312 67.976357 77.503036 68.09137 
  77.589981 68.163307 77.742203 68.221649 78.148857 68.251923 
  78.169983 68.277481 77.961906 68.38887 77.904694 68.463867 
  77.947746 68.475807 77.921654 68.519417 77.77359 68.519417 
  77.712753 68.614433 77.743874 68.72081 77.683594 68.883324 
  77.616638 68.912483 76.911087 69.010529 76.717484 69.132202 
  75.570534 69.259979 75.449692 69.245247 75.093033 69.132477 
  75.14859 69.107758 75.026367 69.101639 74.301361 69.140808 
  73.978317 69.075531 73.909973 69.079422 73.74942 69.16803 
  73.75415 69.199982 73.839142 69.29776 73.894417 69.425812 
  73.84581 69.493317 73.516922 69.730263 73.516373 69.755539 
  73.650528 69.838593 73.768311 70.086639 73.684418 70.131363 
  73.718582 70.163857 73.878593 70.244713 74.32692 70.530258 
  74.333038 70.599426 74.285248 70.697746 73.918869 70.854141 
  73.891922 70.969971 73.726089 71.045532 73.671371 71.118317 
  73.526642 71.263031 73.339981 71.331093 73.043587 71.397751 
  73.020813 71.42804 73.503311 71.66275 73.525253 71.713318 
  73.466919 71.767197 73.480263 71.786087 73.568314 71.829971 
  73.901642 71.904419 74.351639 71.958038 74.958038 72.109421 
  75.093582 72.242752 75.059692 72.589417 75.007751 72.662483 
  74.749687 72.79776 74.750809 72.821091 75.069427 72.876648 
  75.52359 72.75386 75.528587 72.735527 75.336639 72.681923 
  75.690536 72.574692 75.698593 72.544144 75.574692 72.539429 
  75.554138 72.477203 75.668587 72.319977 75.741089 72.305527 
  75.733307 72.256088 75.574692 72.196907 75.512756 72.071091 
  75.418869 72.031647 75.440262 71.995247 75.419144 71.969971 
  75.284149 71.951637 75.222748 71.831917 75.272751 71.734154 
  75.48526 71.668587 75.49942 71.64415 75.386093 71.61026 
  75.533577 71.539429 75.517197 71.526642 75.233582 71.444977 
  75.260803 71.364151 75.449692 71.308296 76.032761 71.231918 
  76.118874 71.191933 76.141922 71.227203 76.910538 71.181374 
  76.915817 71.069702) #(-76.825577 67.23497 -76.126404 67.252762 
  -75.388077 67.354713 -75.128067 67.486923 -75.037247 67.600807 
  -75.066406 67.695534 -75.044739 67.812469 -75.113907 67.861923 
  -75.156967 67.965263 -75.049469 68.041367 -75.010567 68.142197 
  -75.04808 68.174149 -75.695572 68.32692 -75.930862 68.336906 
  -76.060562 68.296921 -76.169456 68.30304 -76.531693 68.289978 
  -76.746689 68.225807 -77.225594 67.856644 -77.3228 67.698029 
  -77.225861 67.530807 -77.256683 67.516373 -77.055573 67.266373 
  -76.825577 67.23497) #(23.573891 67.16774 23.611389 67.207199 
  23.58444 67.223862 23.614441 67.263313 23.741659 67.284698 
  23.78194 67.32637 23.76194 67.420242 23.54916 67.453308 
  23.500549 67.436363 23.43111 67.46553 23.438881 67.498581 
  23.55361 67.587479 23.477221 67.774979 23.492491 67.875793 
  23.66555 67.929962 23.65694 67.950813 23.542219 67.978027 
  23.294439 68.142197 23.14777 68.127457 23.159439 68.178848 
  23.11972 68.241913 22.673889 68.420807 22.05055 68.479141 
  21.897221 68.569977 21.7575 68.57692 21.66861 68.630798 
  21.207769 68.819702 20.895281 68.893593 20.89138 68.926849) 
#(-52.498901 68.19371 -52.248341 68.208588 -51.240009 68.290527 
  -51.607792 68.401917 -51.587791 68.4272 -51.393341 68.405807 
  -51.18029 68.402763 -51.176682 68.382202 -51.126949 68.370529 
  -51.14806 68.289139 -51.091961 68.210823 -51.424179 68.204147 
  -51.424179 68.194138 -51.206951 68.147476 -51.043339 68.085251 
  -50.54557 67.995247 -50.550011 67.964417 -50.150291 67.943588 
  -50.153339 67.933296 -50.250561 67.91275 -50.61232 67.915359 
  -51.202789 68.064972 -51.971951 68.051361 -52.579731 68.189148 
  -52.779732 68.189697 -52.796959 68.165527 -53.170292 68.198029 
  -53.454449 68.152206 -53.28223 68.152763 -53.26862 68.131088 
  -53.128071 68.173309 -53.08334 68.159416 -53.14056 68.111076 
  -52.67696 67.972748 -52.190571 67.950256 -52.06501 67.977753 
  -52.093899 67.944977 -52.188351 67.923027 -52.250561 67.939697 
  -52.57613 67.934982 -53.08168 68.062759 -53.19585 68.039978 
  -53.26001 67.983032 -52.926399 67.986923 -52.92057 67.972748 
  -53.196678 67.965263 -53.240009 67.928589 -53.29668 67.905807 
  -53.126122 67.909149 -53.055851 67.879967 -53.273899 67.855797 
  -53.305851 67.880249 -53.435291 67.895248 -53.480572 67.871918 
  -53.248901 67.809418 -53.447788 67.794418 -53.45668 67.818314 
  -53.484459 67.855263 -53.603901 67.823868 -53.701679 67.791924 
  -53.555279 67.758591 -53.563061 67.651642 -53.753071 67.606369 
  -53.720852 67.522202 -53.567509 67.515259 -52.970291 67.76387 
  -52.67696 67.789703 -51.64806 67.964142 -51.92001 67.881363 
  -52.15527 67.862808 -52.341961 67.824417 -52.301682 67.806641 
  -51.928902 67.746643 -51.80946 67.777206 -51.668339 67.781921 
  -51.800011 67.756363 -51.840012 67.727478 -51.694462 67.698029 
  -51.588619 67.750526 -51.382511 67.74498 -51.39613 67.775528 
  -51.3214 67.811081 -51.329731 67.829971 -51.571678 67.92276 
  -51.561401 67.934418 -51.374729 67.918297 -51.18446 67.972473 
  -51.05751 67.969147 -50.97224 67.914429 -50.999729 67.875259 
  -51.111118 67.904984 -51.368351 67.875526 -51.250851 67.837753 
  -51.2314 67.778313 -51.140011 67.761093 -50.650291 67.848587 
  -50.758621 67.875809 -50.851398 67.846077 -50.798618 67.903587 
  -50.468899 67.88942 -50.43251 67.846649 -50.649448 67.819702 
  -51.02306 67.716919 -51.29723 67.733582 -51.317791 67.710251 
  -50.904461 67.659149 -51.00806 67.624153 -50.82362 67.632202 
  -50.26363 67.74498 -49.95612 67.700531 -49.97723 67.683296 
  -50.274731 67.731087 -50.876122 67.59581 -50.71307 67.532204 
  -50.196678 67.493317 -50.599461 67.481918 -51.162231 67.632751 
  -51.82473 67.628311 -51.915569 67.674698 -52.308071 67.733032 
  -52.745289 67.74942 -52.817509 67.73526 -52.895569 67.720543 
  -53.071678 67.678307 -53.091671 67.649979 -52.95779 67.678307 
  -52.922508 67.673309 -53.326679 67.553589 -53.8214 67.405533 
  -53.880291 67.256927 -53.777241 67.205544 -53.215569 67.309418 
  -52.141399 67.399406 -51.967232 67.352753 -51.138069 67.42276 
  -51.154171 67.40303 -51.482792 67.366089 -51.522511 67.346359 
  -51.222511 67.155807 -50.53307 67.222198 -50.348759 67.187469) 
#(-85.586441 69.827072 -85.349457 69.817467 -85.333344 69.774139 
  -85.406418 69.750526 -85.423363 69.788857 -85.515579 69.763313 
  -85.439728 69.734421 -85.446411 69.691093 -85.539459 69.662483 
  -85.539467 69.633034 -85.381683 69.56192 -85.527527 69.526093 
  -85.539177 69.466919 -85.491409 69.436653 -85.408913 69.461906 
  -85.339462 69.438873 -85.494453 69.410812 -85.503357 69.390808 
  -85.345573 69.306923 -85.503082 69.314423 -85.46669 69.267197 
  -85.204727 69.175537 -85.296127 69.162483 -85.308327 69.143593 
  -85.197533 69.132751 -85.15918 69.171654 -84.987518 69.168587 
  -85.110023 69.149406 -85.123062 69.11554 -84.532242 69.012482 
  -84.591667 68.994423 -84.818619 69.032204 -84.98558 69.002472 
  -84.809464 68.957199 -84.819183 68.92775 -85.10141 68.958313 
  -85.12973 68.937469 -84.997528 68.925812 -85.015839 68.891647 
  -85.018631 68.874969 -85.17807 68.873581 -85.19278 68.862198 
  -85.144203 68.830261 -85.003632 68.808296 -84.846687 68.823868 
  -84.761139 68.776917 -84.787247 68.733582 -85.250847 68.756088 
  -85.226967 68.733582 -85.228897 68.710251 -85.384193 68.737198 
  -85.371689 68.762192 -85.553627 68.781082 -85.478912 68.760246 
  -85.481949 68.739433 -85.66391 68.726929 -85.693893 68.666092 
  -85.733917 68.461639 -85.668083 68.448303 -85.748917 68.429703 
  -85.706123 68.407204 -85.78891 68.335533 -85.842506 68.230263 
  -85.785019 68.21637 -85.890579 68.174698 -85.859734 68.132477 
  -85.914467 68.104141 -85.892502 68.051361 -85.992508 68.00914 
  -86.108612 67.992203 -86.133057 68.008591 -86.129753 67.949982 
  -86.287231 67.86998 -86.525848 67.676361 -86.451424 67.597473 
  -86.488632 67.546371 -86.474167 67.468582 -86.532791 67.434982 
  -86.503082 67.377762 -86.543907 67.344971 -86.610863 67.402481 
  -86.647232 67.358307 -86.792252 67.42247 -86.885559 67.399406 
  -86.974731 67.31665 -87.041672 67.350807 -87.08667 67.336357 
  -86.968918 67.245247 -87.075844 67.253593 -87.073349 67.214417 
  -87.116386 67.178307 -87.154167 67.239967 -87.237793 67.221077 
  -87.255577 67.165817 -87.297523 67.095543 -87.3414 67.176361 
  -87.427803 67.170807 -87.455292 67.134697 -87.517242 67.11554 
  -87.505577 67.185257 -87.429169 67.208588 -87.357788 67.262192 
  -87.446404 67.291092 -87.714447 67.48053 -88.125 67.655533 
  -88.269203 67.793587 -88.370827 67.959137 -88.365433 68.002983) 
#(-63.822021 66.8172 -63.59362 66.83165 -63.227791 66.972748 
  -63.22057 67.016922 -63.273621 67.085251 -63.035839 67.171082 
  -62.97168 67.229424 -63.022789 67.298027 -63.122791 67.330811 
  -63.20779 67.315811 -63.170292 67.283859 -63.21418 67.257751 
  -63.293621 67.246368 -63.202789 67.29303 -63.248901 67.308868 
  -63.299179 67.29776 -63.418072 67.206093 -63.411671 67.176086 
  -63.439449 67.122482 -63.767231 67.006088 -63.772789 66.958862 
  -63.80751 66.988037 -63.788349 67.011368 -63.58556 67.083313 
  -63.453899 67.169418 -63.450569 67.222473 -63.483349 67.229424 
  -64.506683 67.129433 -64.604187 67.088318 -64.628357 67.012192 
  -64.69696 67.003311 -64.694473 67.034973 -64.647522 67.117477 
  -64.467529 67.16748 -64.013351 67.212196 -63.962791 67.270248 
  -63.976959 67.277763 -64.801407 67.195251 -64.809738 67.210251 
  -64.644203 67.242203 -64.380577 67.247482 -64.267242 67.274696 
  -64.246399 67.298576 -64.734741 67.333588 -64.797523 67.356644 
  -64.694183 67.35025 -63.904171 67.301651 -63.952511 67.335823 
  -63.942509 67.374687 -63.993351 67.449142 -64.38475 67.458313 
  -64.435577 67.478592 -64.261139 67.465263 -64.134743 67.49025 
  -64.039749 67.533577 -64.10585 67.549423 -64.06752 67.60025 
  -64.287247 67.621918 -64.204742 67.645538 -64.211411 67.674149 
  -64.318077 67.734154 -64.639473 67.660538 -64.578346 67.696907 
  -64.363632 67.759407 -64.475594 67.797203 -64.611969 67.82637 
  -64.755859 67.817749 -64.751968 67.777481 -64.799744 67.690811 
  -64.816132 67.710533 -64.816406 67.781372 -64.920029 67.790817 
  -65.13002 67.715813 -65.172501 67.633591 -65.204468 67.648323 
  -65.196693 67.697197 -65.145859 67.738861 -65.041412 67.761917 
  -65.017792 67.820824 -65.121964 67.820534 -65.048897 67.844147 
  -64.946693 67.917213 -64.874741 67.931091 -64.718353 67.976639 
  -64.723633 67.99054 -65.001129 68.055527 -65.059464 68.046921 
  -65.15863 68.002197 -65.190857 67.958313 -65.413361 67.918869 
  -65.550858 67.778313 -65.369461 67.702759 -65.328629 67.619141 
  -65.363907 67.597473 -65.61586 67.786087 -65.520576 67.843033 
  -65.443626 67.992203 -65.472794 67.996094 -65.823639 67.962753 
  -65.762527 67.914703 -65.795303 67.868027 -65.956131 67.818314 
  -65.969193 67.679138 -66.021973 67.650253 -65.944473 67.89386 
  -66.02919 67.949142 -65.853912 68.073303 -65.857803 68.11026 
  -65.920853 68.161926 -65.960571 68.144417 -65.94252 68.103027 
  -65.960297 68.034416 -66.297813 67.935532 -66.366127 67.777206 
  -66.39502 67.776093 -66.406967 67.829147 -66.49614 67.824417 
  -66.739754 67.877762 -66.398911 67.868591 -66.396683 67.907761 
  -66.184464 68.01886 -66.273071 68.087753 -66.39003 68.069427 
  -66.371964 68.08165 -66.310577 68.118591 -66.329178 68.132202 
  -66.579742 68.145538 -66.6203 68.125809 -66.647247 68.015533 
  -66.735023 67.982193 -66.67836 68.043297 -66.6828 68.141373 
  -66.748077 68.131638 -66.953629 68.017197 -66.965584 68.063873 
  -66.823639 68.126373 -66.769737 68.241089 -66.910019 68.259979 
  -67.1203 68.283043 -67.289467 68.236359 -67.273911 68.190811 
  -67.374191 68.127472 -67.480583 68.134697 -67.589752 68.16748 
  -67.398643 68.14386 -67.327797 68.181091 -67.327797 68.243591 
  -67.232483 68.281662) #(69.899406 66.869713 69.863312 66.822197 
  69.721916 66.808029 69.586639 66.834137 69.603027 66.810806 
  69.618874 66.788589 69.162483 66.830544 68.967758 66.804138 
  68.980904 66.790771) #(46.04068 66.825607 46.569439 66.868027 
  46.59943 66.832748 46.38554 66.7397 47.131649 66.877762 
  47.45388 66.920807 47.572208 66.894699 47.598881 66.883034 
  47.58971 66.931374 47.699711 66.986359 47.747501 67.038857 
  47.750542 67.125259 47.679989 67.189423 47.790829 67.253036 
  47.771938 67.341919 47.946381 67.433296 47.936649 67.474136 
  47.812771 67.563583 47.821098 67.585251 48.008049 67.654419 
  48.086102 67.621094 48.09277 67.588318 48.173599 67.63942 
  48.350269 67.689148 48.468319 67.659149 48.676929 67.710251 
  48.98415 67.666924 49.00304 67.635246 49.102779 67.635529 
  49.032211 67.675812 48.762772 67.728317 48.806389 67.771927 
  48.793598 67.833038 48.603321 67.91748 48.63026 67.933868 
  48.9436 67.846916 49.226101 67.873871 49.71944 67.998871 
  50.62611 68.289139 50.775829 68.372482 51.076099 68.35054 
  51.579151 68.434982 51.547211 68.448868 51.581928 68.48497 
  52.21526 68.577759 52.178051 68.533577 52.048038 68.507202 
  52.056931 68.481087 52.1786 68.5047 52.357498 68.474136 
  52.288052 68.463028 52.297771 68.423309 52.264439 68.404137 
  52.14777 68.392471 52.141659 68.372192 52.2686 68.305817 
  52.664711 68.41304 52.727779 68.451637 52.7286 68.486076 
  52.555538 68.541092 52.500271 68.613586 52.618038 68.624969 
  52.650269 68.652206 52.48333 68.63414 52.416931 68.585251 
  52.281101 68.595261 52.30138 68.619141 53.31583 68.88942 
  53.852211 68.974136 54.538052 69.002762 54.52499 68.973862 
  53.591381 68.901367 53.726101 68.856369 53.697769 68.88942 
  53.989712 68.8647 54.025829 68.842758 53.820541 68.758034 
  53.847221 68.728027 53.812771 68.682213 53.719711 68.651917 
  53.72694 68.625809 53.785549 68.586906 53.922218 68.471077 
  53.939709 68.392197 53.795818 68.341919 53.611099 68.408043 
  53.57526 68.396927 53.67194 68.35025 53.66888 68.326637 
  53.531391 68.36026 53.402489 68.359703 53.20332 68.274139 
  53.219711 68.256088 53.345829 68.236076 53.500271 68.257751 
  53.961651 68.213593 54.09444 68.243027 54.1786 68.314148 
  54.22028 68.31636 54.177769 68.279419 54.190269 68.212479 
  54.23888 68.204971 54.479431 68.304428 54.55444 68.296654 
  54.66721 68.177467 54.823318 68.167763 54.88055 68.196373 
  54.92387 68.279984 54.854988 68.317467 54.939709 68.399979 
  55.25526 68.528313 55.70443 68.574982 55.967491 68.659416 
  56.526939 68.616638 56.49263 68.581497) 
#(-82.153961 66.711807 -82.180283 66.76886 -82.014183 66.899406 
  -82.038887 66.923027 -81.833618 66.997757 -81.52446 66.99054 
  -81.432533 67.06665 -81.347794 67.292763 -81.2453 67.426361 
  -81.243073 67.474983 -81.43306 67.611359 -81.948349 67.827759 
  -82.175842 67.997482 -82.142517 68.04747 -82.027252 68.122757 
  -81.98558 68.201637 -82.011688 68.214706 -82.057251 68.204697 
  -82.100861 68.149979 -82.206413 68.115807 -82.34584 68.170258 
  -82.258911 68.255539 -82.273361 68.288857 -82.386963 68.266373 
  -82.483627 68.299423 -82.501106 68.317467 -82.356667 68.32164 
  -82.356667 68.34581 -82.436974 68.375809 -82.63446 68.407761 
  -82.648071 68.445251 -82.515846 68.445251 -82.493347 68.463593 
  -82.600594 68.492477 -82.382797 68.466919 -82.190582 68.466087 
  -82.176132 68.491364 -82.26947 68.532471 -82.20195 68.525528 
  -82.047813 68.47525 -81.97084 68.421082 -81.816704 68.469704 
  -81.797813 68.525528 -81.646683 68.505539 -81.357803 68.599136 
  -81.252518 68.65303 -81.268341 68.715813 -81.234734 68.769974 
  -81.296127 68.8172 -81.438629 68.874969 -81.581413 68.830811 
  -81.588074 68.869713 -81.686417 68.905258 -81.964752 68.883873 
  -81.570297 68.992477 -81.462799 69.072746 -81.273071 69.091637 
  -81.360001 69.19664 -81.708076 69.264687 -82.258911 69.233871 
  -82.289749 69.251648 -82.144203 69.300262 -82.335571 69.371094 
  -82.299454 69.381638 -82.225281 69.396362 -82.324188 69.418869 
  -82.954727 69.503593 -83.291412 69.544418 -83.241119 69.556641 
  -82.500839 69.492203 -82.499184 69.511642 -82.743362 69.577477 
  -82.551697 69.593033 -82.652802 69.618317 -82.640579 69.626373 
  -82.472778 69.636093 -82.407806 69.608582 -82.25502 69.636368 
  -82.67836 69.701103 -82.670288 69.67804 -83.253357 69.705261 
  -83.346413 69.676086 -83.748901 69.708862 -84.229752 69.834702 
  -84.546417 69.859421 -84.750313 69.832748 -84.882523 69.85553 
  -85.079468 69.771088 -85.377518 69.851089 -85.571953 69.856087 
  -85.586441 69.827072) #(-95.445473 68.006104 -95.580292 67.89859 
  -95.522507 67.852753 -95.550293 67.803864 -95.708344 67.733032 
  -95.693069 67.704422 -95.466667 67.637192 -95.323334 67.531921 
  -95.33168 67.505814 -95.419167 67.455261 -95.315002 67.330544 
  -95.172234 67.291367 -95.166397 67.276917 -95.248901 67.265259 
  -95.266113 67.212753 -95.352226 67.148323 -95.322777 67.106087 
  -95.347778 67.073868 -95.232513 66.987198 -95.224731 66.962753 
  -95.311401 66.889977 -95.542511 66.902206 -96.026123 66.950256 
  -96.085564 66.926933 -96.087784 66.907471 -95.785004 66.737198 
  -95.766678 66.683594 -95.691391 66.679428 -95.652237 66.728592 
  -95.629997 66.675537 -95.819733 66.583862 -95.777512 66.654984 
  -95.862228 66.761093 -96.108902 66.832748 -96.146393 66.894699 
  -96.397507 66.993874 -96.452507 67.068314 -96.288071 67.068314 
  -96.261124 67.041092 -96.285278 67.003593 -96.214737 66.976639 
  -96.134171 66.9897 -96.123611 66.950256 -96.025284 66.973312 
  -96.051682 67.010803 -95.986679 67.056091 -95.93251 67.069702 
  -95.993896 67.009697 -95.936401 66.95665 -95.876106 66.945824 
  -95.607788 66.98526 -95.597778 66.948868 -95.350281 66.963867 
  -95.329727 67.031921 -95.421951 67.063873 -95.379753 67.154694 
  -95.436951 67.154984 -95.488892 67.138031 -95.487793 67.203873 
  -95.569168 67.210533 -95.809174 67.161636 -95.80751 67.186081 
  -95.561684 67.307213 -95.5289 67.35553 -95.603348 67.383324 
  -95.675842 67.328308 -95.74028 67.376648 -96.114464 67.213318 
  -96.252502 67.247482 -96.226959 67.31665 -96.166672 67.341637 
  -96.101959 67.418587 -96.107788 67.469147 -96.222778 67.421921 
  -96.396118 67.494423 -96.461121 67.473312 -96.461403 67.508873 
  -96.38028 67.565536 -96.329727 67.61026 -96.343903 67.664978 
  -96.310837 67.692467 -96.246948 67.623306 -96.185287 67.626373 
  -96.168327 67.694977 -96.220291 67.693039 -96.215286 67.823593 
  -96.01918 68.111076 -96.075287 68.155533 -95.892227 68.294144 
  -96.171677 68.221649 -96.51001 68.119423 -96.547234 68.079422 
  -96.480293 68.090263 -96.453056 68.039429 -96.634453 68.060532 
  -96.696121 68.009979 -96.789459 68.017197 -96.812233 68.043869 
  -96.779167 68.071373 -96.690567 68.079971 -96.404167 68.311371 
  -96.47084 68.305527 -96.632507 68.22554 -96.630836 68.178864 
  -96.694458 68.227203 -96.62529 68.251648 -96.694168 68.280258 
  -96.925003 68.239151 -97.089737 68.263313 -97.070007 68.300262 
  -97.01889 68.295258 -97.001953 68.345261 -97.283073 68.474136 
  -97.531403 68.501923 -97.597778 68.483582 -97.61528 68.453583 
  -97.498901 68.430252 -97.537781 68.418297 -97.646118 68.450813 
  -97.65834 68.500526 -97.723892 68.523033 -97.994453 68.541092 
  -98.009743 68.498032 -97.943336 68.460251 -97.781952 68.406647 
  -97.743057 68.370529 -97.761124 68.363312 -98.114731 68.360527 
  -98.073059 68.32164 -98.126678 68.319977 -98.539459 68.421082 
  -98.543617 68.405258 -98.47139 68.373581 -98.482788 68.34581 
  -98.637222 68.37915 -98.714737 68.372192 -98.704453 68.352753 
  -98.317497 68.162201 -98.350853 68.092194 -98.39418 68.079147 
  -98.439453 68.104141 -98.428337 68.162201 -98.473892 68.18692 
  -98.58139 68.139977 -98.095573 67.833313 -98.049179 67.836357 
  -98.05751 67.912483 -98.030006 67.941933 -97.878067 67.963593 
  -97.79306 67.97081 -97.695282 68.017197 -97.64389 68.008324 
  -97.403633 67.879967 -97.324448 67.876648 -97.24057 67.926086 
  -97.117233 67.777481 -97.219452 67.708038 -97.060562 67.679703 
  -97.069168 67.670532 -97.532791 67.597198 -97.738892 67.642197 
  -97.998901 67.753036 -98.088623 67.756638 -98.179459 67.852478 
  -98.585564 68.091919 -98.732788 68.070251 -98.734451 67.998581 
  -98.656113 67.916367 -98.449448 67.865807 -98.354446 67.796082 
  -98.411957 67.784416 -98.693619 67.807747 -98.761124 67.743874 
  -98.896118 67.748306 -98.930557 67.696091 -99.017227 67.721359 
  -99.171112 67.711357 -99.308617 67.760529 -99.909447 67.819427 
  -100.4453 67.842484 -100.5878 67.793297) 
#(-72.940247 67.942177 -72.908363 67.90303 -72.843918 67.850807 
  -72.738342 67.866638 -72.585571 67.75386 -72.676392 67.693863 
  -72.637238 67.669144 -72.497528 67.633034 -72.422523 67.529984 
  -72.506126 67.496918 -72.436417 67.472198 -72.367523 67.321907 
  -72.202797 67.278587 -72.277527 67.225807 -72.275299 67.176651 
  -72.431137 67.096077 -72.650864 67.08136 -72.824188 67.029419 
  -72.963638 66.861923 -73.007797 66.783577 -72.965851 66.751083 
  -72.693359 66.709137 -71.435852 66.60997 -71.336411 66.712753 
  -71.298897 66.79303 -71.188919 66.836639 -71.151962 66.967484 
  -71.269737 66.993874 -71.215027 67.039139 -70.684189 66.976639 
  -70.827797 66.959137 -70.823639 66.937187 -70.628082 66.897202 
  -70.656952 66.85498 -70.596687 66.85498 -70.621964 66.824417 
  -70.588638 66.789703 -70.375023 66.733307 -69.742798 66.649979 
  -69.742798 66.621368 -69.610023 66.606369 -69.423897 66.563309 
  -69.507523 66.513603 -69.27475 66.584702 -69.226967 66.563026) 
#(71.556557 72.907944 71.809692 72.860527 72.142761 72.82637 
  72.833313 72.708588 72.722473 72.694702 72.811081 72.649696 
  72.732483 72.618591 72.736649 72.587753 72.856369 72.51442 
  72.791924 72.469971 72.881927 72.281372 72.731087 72.189423 
  72.719971 72.114433 72.57164 72.040817 72.56192 71.984703 
  72.509697 71.904419 72.343872 71.859421 72.313873 71.814697 
  72.361923 71.710251 72.238037 71.683029 72.192467 71.60025 
  71.85054 71.531372 71.802467 71.491089 71.809982 71.454147 
  71.856369 71.418587 72.250526 71.23526 72.591087 71.155258 
  72.677467 71.089981 72.621643 71.012756 72.838318 70.871368 
  72.834427 70.839981 72.681641 70.602203 72.773033 70.536926 
  72.77803 70.41803 72.524406 70.343582 72.427467 70.283043 
  72.438873 70.252197 72.608582 70.183868 72.620796 70.149139 
  72.485527 70.042763 72.503036 70.024696 72.63942 69.910812 
  72.686371 69.849701 72.65303 69.747757 72.501648 69.646088 
  72.559692 69.604424 72.635529 69.438583 72.603317 69.41803 
  72.483582 69.410538 72.574142 69.377762 72.652206 69.286362 
  72.513603 69.222198 72.479424 69.182213 72.481369 69.125259 
  72.582748 68.933594 72.720261 68.843872 73.513313 68.586906 
  73.652763 68.4897 73.624687 68.431641 73.591919 68.437759 
  73.606369 68.482758 73.560806 68.484703 73.449417 68.435257 
  73.408577 68.363861 73.093307 68.210533 73.139137 68.161636 
  73.072746 68.088867 73.124687 68.05304 73.205544 67.954697 
  73.197479 67.846359 73.083313 67.828033 73.067749 67.801933 
  73.148323 67.73526 73.138031 67.703033 73.099136 67.687187 
  73.074417 67.724426 72.978317 67.708862 72.844147 67.632751 
  72.597198 67.61998 72.540527 67.588028 72.542763 67.518044 
  72.39386 67.463867 72.451103 67.389977 72.384697 67.317749 
  72.040527 67.296921 72.038857 67.262192 72.20192 67.229713 
  72.233582 67.173576 72.220261 67.153587 72.17247 67.153313 
  72.154984 67.19136 72.11554 67.201103 72.131088 67.154419 
  71.908859 67.12915 72.014137 67.11026 71.741089 66.909149 
  71.598862 66.942467 71.534149 66.912201 71.374969 66.973862 
  71.304428 66.950813 71.515259 66.872757 71.481918 66.819427 
  71.545258 66.77803 71.515808 66.759697 71.598038 66.719421 
  71.543297 66.643311 71.354141 66.646927 71.370247 66.683868 
  71.230797 66.620796 71.06665 66.626923 71.043869 66.599983 
  71.124687 66.578308 70.940811 66.576637 70.976929 66.531082 
  70.678307 66.509697 70.300537 66.592194 70.316933 66.649979 
  70.726357 66.73497 70.697197 66.760246 70.46637 66.716919 
  70.535812 66.698593 70.322479 66.6772 70.149979 66.710533 
  69.899406 66.869713) #(180.0 68.978706 180.0 68.868042 
  180.0 68.678047 180.0 68.488052 180.0 68.29805 180.0 68.108047 
  180.0 67.918053 180.0 67.728043 180.0 67.53804 180.0 67.348053 
  180.0 67.158051 180.0 66.968048 180.0 66.778053 
  180.0 66.398041) #(-106.7551 68.10611 -107.0508 68.099136 
  -107.3622 68.046921 -107.6103 68.058594 -107.7919 67.988037 
  -107.8333 68.013031 -107.755 68.054977 -107.6994 68.075813 
  -107.8517 68.106087 -107.8906 68.08165 -107.9103 67.988586 
  -107.6511 67.940536 -107.7047 67.895813 -107.9483 67.841087 
  -108.0153 67.74498 -107.9836 67.684692 -107.7406 67.585251 
  -107.5739 67.481644 -107.6444 67.398323 -107.6792 67.41304 
  -107.7219 67.410812 -107.5031 67.192749 -107.3881 67.144417 
  -107.2164 67.125809 -107.2069 67.1147 -107.3847 67.056374 
  -107.4003 67.036926 -107.2975 67.001923 -107.1086 66.837196 
  -107.1378 66.823593 -107.2103 66.890808 -107.4061 66.971359 
  -107.4447 66.962479 -107.3939 66.885246 -107.4864 66.877197 
  -107.4103 66.816093 -107.4383 66.808029 -107.6725 66.928864 
  -107.6667 66.957748 -107.5797 66.916367 -107.4839 66.924149 
  -107.5239 67.020248 -107.6361 67.073868 -107.6681 67.068314 
  -107.6069 66.970543 -107.6375 66.961906 -107.7483 67.010246 
  -107.7658 66.99025 -107.6986 66.813026 -107.7025 66.751923 
  -107.7972 66.756088 -107.3422 66.461639 -107.1967 66.360809 
  -107.235 66.348587 -107.2911 66.368317 -107.5103 66.542213 
  -107.6009 66.546082 -107.8533 66.756363 -107.8514 66.730263 
  -107.8828 66.663307 -107.9494 66.720543 -107.9414 66.788307 
  -108.0033 66.835823 -108.1875 66.833038 -108.2275 66.849983 
  -108.1181 66.862198 -108.1147 66.928864 -108.1764 66.96553 
  -108.3306 66.986923 -108.4561 67.070534 -108.49 67.062187 
  -108.5242 67.038307 -108.5942 67.133873 -108.5906 67.153587 
  -108.4606 67.086906 -108.2039 67.01886 -108.177 67.056374 
  -107.8753 67.05275 -107.9145 67.132477 -107.875 67.140808 
  -108.0153 67.29303 -108.367 67.444977 -108.44 67.427467 
  -108.422 67.370247 -108.4581 67.347198 -108.4981 67.363037 
  -108.5228 67.440811 -108.5114 67.487473 -108.61 67.621094 
  -108.6961 67.626373 -108.7392 67.596916 -108.7364 67.481087 
  -108.7906 67.363586 -108.825 67.349426 -108.8589 67.408859 
  -109.0022 67.443588 -109.0214 67.488312 -108.9192 67.535812 
  -109.0658 67.714142 -109.3703 67.729141 -109.4089 67.766647 
  -109.5108 67.726639 -109.4881 67.703873 -109.5347 67.685806 
  -109.6978 67.711906 -109.7456 67.739433 -109.6231 67.74054 
  -109.7439 67.781372 -109.6958 67.804138 -109.8231 67.866089 
  -109.9531 67.881927 -109.9172 67.839142 -109.9631 67.830261 
  -110.0036 67.860527 -109.9675 67.94136 -109.9858 67.971649 
  -110.117 68.008873 -110.18 67.994423 -110.1997 67.955261 
  -110.1494 67.93248 -110.1539 67.915253 -110.34 67.96553 
  -110.6578 67.883324 -110.8517 67.798027 -111.2081 67.764137 
  -111.1439 67.828873 -111.1758 67.837479 -111.3225 67.806923 
  -111.4097 67.74025 -111.4742 67.735527 -111.4586 67.763031 
  -111.5208 67.768044 -111.5497 67.748871 -111.6422 67.731644 
  -111.9333 67.748306 -111.907 67.681923 -112.0111 67.742477 
  -112.367 67.734421 -112.3336 67.696373 -112.3958 67.679138 
  -113.3608 67.694427 -114.1808 67.738037 -114.2978 67.718582 
  -114.5303 67.791641 -115.1136 67.798576) 
#(68.980904 66.790771 68.985527 66.786087 69.078583 66.775818 
  69.117477 66.746094 69.097473 66.634979 69.117477 66.604141 
  69.386093 66.507477 69.742752 66.474426 69.92775 66.407761 
  70.424698 66.329422 70.99025 66.366928 71.461906 66.347198 
  71.999977 66.219421 72.354713 66.308296 72.398033 66.508034 
  72.290253 66.502762 72.354713 66.532761 72.953873 66.66304 
  73.003593 66.735527 73.515533 66.828583 73.549973 66.868591 
  73.847198 66.981087 73.918587 67.069427 73.948029 67.237198 
  73.900528 67.291367 74.098587 67.431641 74.704697 67.671371 
  74.755249 67.71109 74.80304 67.820824 74.81192 67.973862 
  74.745529 68.086639 74.618874 68.240807 74.339417 68.367752 
  74.336357 68.393044 74.434143 68.473038 74.467484 68.53804 
  74.413307 68.612198 74.443588 68.682747 74.526917 68.736076 
  74.690536 68.778313 75.842484 68.941933 76.396088 68.982483 
  76.614967 68.956093 76.699982 68.851089 76.616089 68.792213 
  76.675812 68.749687 76.876648 68.6922 77.111649 68.566093 
  77.133591 68.58165 77.113586 68.598862 77.198593 68.584427 
  77.325531 68.510529 77.243591 68.458313 77.305252 68.391373 
  77.29776 68.372482 77.173027 68.314423 77.166924 68.275528 
  77.358582 68.22525 77.214417 68.09581 77.252197 68.046082 
  77.19165 67.97525 77.246643 67.946091 77.301086 67.896362 
  77.217484 67.824982 77.085823 67.829971 77.072197 67.797203 
  77.113861 67.766373 77.323593 67.703873 77.698593 67.593307 
  77.688309 67.542213 79.048309 67.5672) 
#(-32.99931 67.686333 -33.141399 67.695824 -33.208069 67.678307 
  -33.18446 67.647476 -33.060291 67.637756 -33.061119 67.627197 
  -33.237511 67.536636 -33.355839 67.554428 -33.353901 67.518044 
  -33.27306 67.484703 -33.273621 67.46553 -33.34306 67.432747 
  -33.276119 67.39859 -33.378071 67.351639 -33.444729 67.38887 
  -33.60001 67.367203 -33.422508 67.332199 -33.475849 67.313873 
  -33.36945 67.244713 -33.470009 67.229141 -33.5989 67.255249 
  -33.6689 67.213318 -33.517231 67.194138 -33.557789 67.156372 
  -33.52113 67.133873 -33.77306 67.039978 -33.760288 67.023033 
  -33.730839 66.996368 -33.948898 66.992477 -33.89584 66.96637 
  -34.00251 66.948868 -33.951679 66.914978 -34.02113 66.836639 
  -33.93251 66.764687 -33.97279 66.736923 -33.98946 66.767197 
  -34.087791 66.799973 -34.047791 66.738586 -34.100849 66.756088 
  -34.092789 66.699692 -34.155849 66.698593 -34.255291 66.588028 
  -34.261959 66.677467 -34.287231 66.684692 -34.29945 66.646088 
  -34.36945 66.594704 -34.39613 66.618591 -34.412231 66.741638 
  -34.440571 66.731369 -34.434731 66.67247 -34.511398 66.645248 
  -34.465012 66.612473 -34.525291 66.591087 -34.405849 66.544983 
  -34.415852 66.532761 -34.704731 66.411636 -34.619179 66.407471 
  -34.68195 66.367752 -34.777241 66.319427 -34.863899 66.348587 
  -34.909451 66.314697 -34.984459 66.284149 -35.12973 66.337753 
  -35.113338 66.361649 -35.115292 66.418587 -35.162231 66.396927 
  -35.235008 66.313873 -35.040569 66.255249 -35.06723 66.238037 
  -35.232792 66.241928 -35.45668 66.324692 -35.498901 66.286362 
  -35.796398 66.413857 -35.74807 66.437187 -35.876122 66.41803 
  -35.680851 66.331093 -35.678341 66.3022 -35.74501 66.272751 
  -35.550838 66.239967 -35.670292 66.219421 -35.618061 66.20192 
  -35.572788 66.130814 -35.619179 66.107483 -35.702229 66.191093 
  -35.763069 66.186371 -35.69585 66.166641 -35.698341 66.120529 
  -35.819672 66.127403) #(39.61005 68.059914 39.853882 68.038307 
  39.857491 68.054428 39.707489 68.162201 39.72916 68.170532 
  39.80999 68.152763 40.150829 67.948303 40.36805 67.897751 
  40.410271 67.855263 40.319721 67.840263 40.387501 67.796654 
  40.511669 67.745796 40.56221 67.762756 40.56694 67.806374 
  40.67305 67.809692 40.810001 67.722748 40.939159 67.733307 
  41.010818 67.698029 41.05666 67.626373 40.99889 67.461906 
  41.090271 67.458588 41.153332 67.413857 41.115551 67.276642 
  41.138882 67.229713 41.34444 67.215813 41.391102 67.11554 
  41.3386 67.08136 41.361382 67.005814 41.26527 66.993874 
  41.30444 66.950813 41.219719 66.837753 40.723598 66.577759 
  40.71611 66.53331 40.443329 66.400818 39.276379 66.119141 
  38.492771 66.052467 37.876389 66.093582 37.366661 66.204697 
  35.486111 66.392761 34.875549 66.598038 34.76194 66.606369 
  34.661942 66.564148 34.47028 66.533577 34.354721 66.610809 
  34.369999 66.631927 34.429989 66.640808 34.088329 66.667763 
  34.153332 66.717194 34.160831 66.750259 34.13694 66.770248 
  34.099998 66.706917 33.915829 66.687187 33.660831 66.806923 
  33.584999 66.789429 33.521111 66.824692 33.52166 66.775818 
  33.555828 66.724701 33.483891 66.721359 33.058048 66.871643 
  32.808331 67.004967 32.804989 67.056641 32.965832 67.088318 
  32.773331 67.087479 32.346939 67.164139 32.263321 67.14386 
  31.92388 67.161636 31.85368 67.149551) 
#(41.643608 66.166641 42.168331 66.522751 42.236111 66.527481 
  42.585541 66.463867 42.673599 66.425812 42.548038 66.378593 
  43.021389 66.422203 43.310551 66.41748 43.378319 66.337196 
  43.54417 66.324982 43.68166 66.261642 43.671101 66.216087 
  43.290279 66.089706 43.367489 66.033577 43.459148 66.03331 
  43.514439 65.971916 43.52528 66.021927 43.506649 66.047203 
  43.385551 66.062469 43.391659 66.083038 43.51305 66.137482 
  43.852779 66.183296 44.057781 66.069138 44.021099 66.016373 
  44.127769 65.915253 44.186939 65.876373 44.11639 66.000526 
  44.156391 66.086639 44.095829 66.131363 44.076382 66.200531 
  44.134991 66.332199 44.2575 66.460823 44.355 66.49498 
  44.375271 66.549698 44.42915 66.639977 44.560822 66.664139 
  44.483059 66.674149 44.35833 66.785248 44.488331 66.843872 
  44.479988 66.949142 44.31694 67.044144 44.30666 67.063873 
  44.380821 67.102753 44.076099 67.17775 43.877781 67.163589 
  43.763889 67.21109 43.748878 67.296082 43.787498 67.393044 
  44.03249 67.666641 44.084999 67.682747 44.114441 67.65831 
  44.151932 67.70192 44.06749 67.70665 44.12804 67.800537 
  44.083321 67.841919 44.1036 67.891647 44.214161 67.895538 
  44.258331 67.929977 44.125549 67.930252 44.150829 68.004433 
  44.409161 68.06192 44.188881 68.030258 44.164989 68.045532 
  44.245281 68.255539 44.050549 68.374153 43.33194 68.608582 
  43.261108 68.666641 43.311661 68.684982 43.494999 68.676361 
  43.844158 68.584702 44.140541 68.534149 44.597771 68.559418 
  45.28582 68.573029 45.97332 68.474701 46.02499 68.450813 
  45.951649 68.447479 45.941101 68.42804 46.02972 68.323868 
  46.42667 68.18248 46.545551 68.10025 46.535831 68.048027 
  46.57999 67.98526 46.721661 67.920532 46.715271 67.820534 
  46.68055 67.804703 45.60527 67.767197 45.316109 67.71553 
  45.296101 67.695534 45.353611 67.6772 45.34 67.616364 
  45.294708 67.584976 45.153049 67.577759 45.023609 67.523857 
  44.93166 67.457199 44.91193 67.372757 44.935551 67.341637 
  45.618038 67.161087 45.81889 66.898323 46.04068 66.825607) 
#(24.16707 65.812843 24.004999 66.05275 23.71916 66.204971 
  23.65777 66.406921 23.65889 66.460533 23.887501 66.569977 
  23.9 66.7547 24.007771 66.800522 23.935829 66.88414 
  23.72583 67.012756 23.573891 67.16774) 
#(-164.7565 67.840027 -164.12421 67.60997 -163.98779 67.521637 
  -163.7933 67.300812 -163.76311 67.130814 -163.722 67.110809 
  -162.8445 67.001648 -162.93359 67.045258 -162.61861 67.010529 
  -162.3506 67.161362 -162.3317 67.144699 -162.4669 67.004433 
  -162.45219 66.988861 -162.2964 67.003311 -162.3172 67.032471 
  -162.2731 67.065811 -162.2345 67.007202 -161.84061 67.050262 
  -161.5011 66.979141 -161.507 66.952477 -161.6514 66.963867 
  -161.80029 66.899696 -161.7989 66.846077 -161.88831 66.799973 
  -161.8759 66.70665 -161.5067 66.533859 -161.30611 66.535248 
  -161.22861 66.560806 -161.2345 66.591087 -161.1403 66.647476 
  -160.83859 66.66275 -160.54221 66.586906 -160.3342 66.64859 
  -160.2403 66.64415 -160.3172 66.623306 -160.2097 66.524406 
  -160.2159 66.424149 -160.2525 66.39415 -160.662 66.368591 
  -161.2281 66.534973 -161.3425 66.482758 -161.6006 66.447746 
  -161.88499 66.53804 -162.0753 66.658043 -162.07719 66.696373 
  -162.01469 66.776917 -162.3369 66.958313 -162.63361 66.903313 
  -162.63609 66.868874 -162.5011 66.738037 -162.22391 66.710533 
  -161.94949 66.561371 -161.87109 66.495796 -161.8725 66.437469 
  -161.9619 66.332748 -161.8847 66.272202 -161.8589 66.287201 
  -161.92329 66.334702 -161.8864 66.371643 -161.50751 66.400818 
  -161.1194 66.335251 -160.9986 66.238586 -161.01559 66.183868 
  -161.09109 66.122482 -161.1078 66.134697 -161.1022 66.203033 
  -161.0872 66.241638 -161.332 66.232483 -161.36861 66.269974 
  -161.57829 66.251083 -161.8383 66.013031 -161.815 65.994713 
  -161.81641 65.974983 -161.91859 65.982758 -161.91611 66.038589 
  -162.0625 66.068863 -162.3856 66.032471 -162.47701 66.063873 
  -162.6814 66.004433 -162.75751 66.107193 -162.88029 66.091919 
  -163.7139 66.078873 -163.84419 66.121643 -163.9044 66.201103 
  -164.13451 66.188873 -164.1797 66.199692 -163.95309 66.227753 
  -163.8539 66.282471 -163.8942 66.392471 -163.7561 66.501083 
  -163.76781 66.536362 -163.8297 66.567749 -163.625 66.5672 
  -163.7047 66.589417 -163.9953 66.606087 -164.7175 66.549423 
  -164.97591 66.431091 -165.065 66.406647 -165.07449 66.435257 
  -165.1611 66.443314 -165.6525 66.357758 -165.8681 66.257751 
  -165.8672 66.219147 -165.63139 66.189972 -165.5009 66.144974 
  -165.7803 66.102203 -166.1523 66.141922 -166.0919 66.150818 
  -166.21111 66.181091 -166.2917 66.173576 -166.9697 65.969971 
  -166.8728 65.934418 -167.0583 65.873581 -167.20329 65.860527 
  -167.3017 65.90303 -167.55811 65.804428 -167.57111 65.785248 
  -167.4986 65.76915 -167.5081 65.733582 -167.63969 65.714417 
  -167.8172 65.718033 -167.8325 65.689148 -168.0417 65.634697 
  -168.04919 65.676361 -167.84641 65.761368) 
#(-83.379471 65.61554 -83.289169 65.632751 -83.214752 65.710533 
  -83.360023 65.727478 -83.529739 65.708313 -83.80307 65.816093 
  -83.689194 65.866638 -83.68335 65.910538 -83.73085 65.947746 
  -83.921417 66.009697 -84.24057 66.098312 -84.470573 66.133324 
  -84.468338 66.064972 -84.382782 66.000526 -84.189468 65.968307 
  -84.101387 65.819702 -84.14389 65.764137 -83.960281 65.737762 
  -83.906128 65.767471 -83.779457 65.784416 -83.82753 65.748306 
  -83.735863 65.761917 -83.684464 65.744423 -83.794189 65.719421 
  -83.808327 65.681923 -83.624741 65.646637 -83.662514 65.676361 
  -83.586937 65.703873 -83.379471 65.61554) 
#(-63.49918 65.935257 -63.200569 65.633324 -63.010571 65.62915 
  -62.996681 65.585533 -62.95335 65.586906 -62.892231 65.641922 
  -62.949459 65.755249 -62.88612 65.734421 -62.85112 65.630539 
  -62.730839 65.588867 -62.720291 65.626083 -62.652512 65.63414 
  -62.67223 65.597198 -62.645569 65.587196 -62.61779 65.614967 
  -62.59972 65.675812 -62.79945 65.711906 -62.848068 65.76387 
  -62.58363 65.723312 -62.575291 65.761642 -62.874729 65.883034 
  -62.864182 65.911087 -62.829731 65.899979 -62.79224 65.861076 
  -62.591949 65.800812 -62.288071 65.813309 -62.452789 65.924698 
  -62.38612 65.931374 -62.418339 65.970543 -62.841961 66.027481 
  -62.940571 66.123871 -63.060291 66.116364 -63.050289 66.126373 
  -62.946949 66.14859 -62.87862 66.125809 -62.842232 66.064148 
  -62.779171 66.03331 -62.69556 66.042213 -62.307789 65.973862 
  -62.013069 66.023033 -62.108898 66.049973 -62.017231 66.07692 
  -62.153069 66.100807 -62.168072 66.119423 -62.108341 66.143044 
  -62.30751 66.156082 -62.370838 66.184982 -62.715012 66.201637 
  -62.873901 66.318314 -62.868061 66.33609 -62.779461 66.307213 
  -62.780849 66.277763 -62.66695 66.214417 -62.39835 66.273033 
  -62.32029 66.308296 -62.454182 66.353867 -62.49501 66.405533 
  -62.673901 66.393593 -62.710011 66.410538 -62.604179 66.403587 
  -62.60751 66.442749 -62.21862 66.396637 -62.232231 66.366089 
  -62.198898 66.314148 -61.887508 66.280258 -61.462791 66.369141 
  -61.558071 66.413857 -61.853901 66.416367 -61.591961 66.467758 
  -61.576679 66.487198 -61.79723 66.611923 -61.980289 66.648033 
  -62.141121 66.608582 -62.18668 66.627197 -62.016949 66.658043 
  -62.005009 66.69664 -61.73473 66.645813 -61.598629 66.550262 
  -61.447788 66.538307 -61.272511 66.60025 -61.262791 66.629433 
  -61.314171 66.687187 -61.547508 66.806641 -61.690571 66.814423 
  -61.636681 66.837753 -61.612789 66.870796 -61.71307 66.885803 
  -61.97279 66.872482 -62.007511 66.883034 -61.748341 66.906647 
  -61.749729 66.948029 -61.865841 66.939972 -61.83807 66.968582 
  -61.95668 66.963867 -62.01918 66.901642 -62.106121 66.917213 
  -62.005569 67.035248 -62.03196 67.045258 -62.175289 67.050262 
  -62.29446 67.021362 -62.26112 66.948029 -62.4189 66.926651 
  -62.442509 66.888603 -62.303341 66.772476 -62.31945 66.726357 
  -62.500851 66.842484 -62.509739 66.901917 -62.578621 66.947746 
  -62.652241 66.949417 -62.764729 66.925262 -62.75029 66.868874 
  -62.83556 66.666367 -62.89529 66.641922 -62.82362 66.803864 
  -62.845852 66.930817 -62.940289 66.966637 -63.33556 66.895538 
  -63.356121 66.874687 -63.32029 66.814148 -63.420292 66.698868 
  -63.45306 66.711639 -63.407509 66.814423 -63.488899 66.828308 
  -63.598339 66.80304 -63.822021 66.8172) 
#(-37.865841 65.573029 -37.67445 65.574982 -37.631962 65.608307 
  -37.696678 65.626373 -37.695011 65.653587 -37.613899 65.62442 
  -37.568069 65.594971 -37.5364 65.640259 -37.38279 65.630539 
  -37.31168 65.688026 -37.34362 65.705261 -37.498619 65.709427 
  -37.474731 65.750259 -37.49501 65.808296 -37.394451 65.750259 
  -37.27084 65.760529 -37.578899 65.890259 -37.686958 65.904137 
  -37.837791 65.860809 -37.847511 65.821091 -37.95863 65.794418 
  -37.98724 65.705544 -37.935291 65.594971 -37.865841 65.573029) 
#(-84.722778 65.546082 -84.585281 65.619141 -84.58168 65.64859 
  -84.910278 65.999977 -85.144203 66.021088 -85.174728 65.98497 
  -85.145569 65.841919 -85.073914 65.727753 -84.878616 65.669144 
  -84.803619 65.565536 -84.722778 65.546082) 
#(-40.215111 65.505333 -40.039459 65.492203 -40.112511 65.545532 
  -40.096401 65.5672 -40.030849 65.578873 -39.863621 65.499977 
  -39.81057 65.502762 -39.80695 65.551933 -39.743061 65.533577 
  -39.716961 65.554977 -39.83168 65.582748 -39.78751 65.616928 
  -39.726959 65.639977 -39.645569 65.613312 -39.692509 65.646927 
  -39.67445 65.679428 -39.509449 65.659416 -39.543339 65.611076 
  -39.410568 65.53331 -39.373341 65.550537 -39.38335 65.588028 
  -39.338348 65.623032 -39.355839 65.559692 -39.33363 65.538307 
  -39.305561 65.609421 -39.22224 65.574142 -39.195011 65.592194 
  -39.24696 65.637482 -39.347511 65.699417 -39.34362 65.746094 
  -39.211948 65.682747 -39.068901 65.579971 -38.598068 65.576637 
  -38.631119 65.62915 -38.75362 65.640533 -38.787231 65.675537 
  -38.747509 65.6922 -38.701962 65.663589 -38.638069 65.668587 
  -38.583069 65.633873 -38.54612 65.637482 -38.547508 65.674149 
  -38.513069 65.680817 -38.503071 65.649406 -38.500011 65.590813 
  -38.450008 65.603027 -38.42057 65.659416 -38.242229 65.629433 
  -38.179459 65.684418 -38.188622 65.770813 -38.126122 65.766373 
  -38.460011 65.919983 -38.478069 66.016373 -38.404461 66.01387 
  -38.302792 65.907761 -38.180012 65.899979 -38.142231 65.918297 
  -38.170292 65.967484 -38.052231 65.912483 -37.974731 65.961906 
  -38.0014 66.027763 -37.954731 66.058868 -37.96751 66.084427 
  -38.077511 66.079147 -38.105839 66.114433 -37.988899 66.106918 
  -37.863071 66.179703 -37.974171 66.227203 -37.969181 66.249687 
  -37.80196 66.243027 -37.810009 66.213593 -37.753071 66.22081 
  -37.692509 66.263603 -37.777241 66.294144 -38.136398 66.333862 
  -38.14806 66.352753 -38.096951 66.387192 -37.938061 66.373032 
  -37.848068 66.443588 -37.790852 66.367203 -37.57613 66.318039 
  -37.184731 66.341637 -37.177792 66.309692 -37.308899 66.291924 
  -37.560841 66.160812 -37.553619 66.11026 -37.797508 66.049973 
  -37.80724 66.021088 -37.73418 65.974701 -37.829731 65.899696 
  -37.813061 65.876083 -37.675571 65.938583 -37.213902 65.771927 
  -37.164181 65.776917 -37.244179 65.812187 -37.259178 65.829971 
  -37.166119 65.799149 -37.110008 65.811081 -37.089741 65.857758 
  -37.22224 65.88887 -37.154171 65.888603 -37.162231 66.012756 
  -37.087791 65.988312 -37.08556 66.058594 -37.03973 66.058029 
  -37.035011 66.036362 -37.098068 65.943588 -37.064739 65.921921 
  -37.041679 65.843872 -36.971119 65.838593 -36.841671 65.89386 
  -36.876122 65.920258 -36.515011 65.988586 -36.475849 66.046371 
  -36.575569 66.064423 -36.537231 66.080811 -36.342232 66.074982 
  -36.395569 66.019417 -36.37862 65.916367 -36.327789 65.909973 
  -36.331951 65.958862 -36.254181 66.005249 -36.263069 65.948593 
  -36.202511 65.974136 -36.224171 65.934418 -36.180561 65.929977 
  -35.89613 66.011368 -35.920292 66.040253 -35.727791 66.082748 
  -35.940571 66.107758 -35.862789 66.144417 -35.819672 66.127403) 
#(-50.348759 67.187469 -51.189739 67.123581 -51.305561 67.160248 
  -51.466961 67.301086 -51.587509 67.33136 -52.613899 67.317467 
  -52.90556 67.267197 -53.47723 67.239151 -53.58918 67.214981 
  -53.47945 67.209976 -53.39613 67.198593 -53.647789 67.189148 
  -53.85112 67.16275 -53.95668 67.073868 -53.386681 67.108582 
  -53.543072 67.068863 -53.790852 67.07164 -53.83556 67.059143 
  -53.79557 67.013603 -53.608349 66.992752 -53.819462 66.988586 
  -53.816959 66.964417 -53.74807 66.94664 -52.73946 66.890808 
  -52.464451 66.978317 -52.502239 66.945534 -52.478619 66.905533 
  -52.341671 66.918869 -52.29557 66.892761 -52.462791 66.873032 
  -52.381119 66.851929 -52.58585 66.863586 -53.053341 66.835823 
  -53.077511 66.810806 -53.073898 66.792763 -53.093899 66.760803 
  -52.670292 66.825531 -52.650291 66.800812 -52.69862 66.773033 
  -52.65556 66.731369 -52.583069 66.703873 -52.851398 66.679977 
  -53.095852 66.681641 -53.368061 66.664429 -53.474731 66.600807 
  -53.333069 66.616089 -53.38612 66.593872 -53.42696 66.570251 
  -53.172791 66.545532 -52.950008 66.576103 -52.418339 66.542213 
  -52.48307 66.518593 -52.934731 66.548576 -53.054729 66.511642 
  -53.51334 66.528587 -53.5989 66.483032 -53.658352 66.434982 
  -53.630009 66.425537 -53.668072 66.398033 -53.696678 66.32692 
  -53.63612 66.306641 -53.658352 66.276642 -53.61195 66.24025 
  -53.51112 66.23526 -53.661671 66.133591 -53.64835 66.118317 
  -53.30751 66.118874 -52.913349 66.231644 -52.71056 66.352478 
  -52.12196 66.518311 -51.977791 66.658043 -51.680012 66.732193 
  -51.04446 66.945534 -50.95668 66.934692 -51.006962 66.899696 
  -50.90974 66.871918 -50.801399 66.823593 -51.113071 66.87886 
  -51.2714 66.843872 -51.523899 66.73497 -51.465569 66.721649 
  -51.450569 66.700813 -51.58168 66.705261 -51.918339 66.619713 
  -52.031399 66.519417 -51.964741 66.487762 -52.587791 66.366089 
  -52.767509 66.247757 -53.005009 66.170807 -53.462509 66.034149 
  -53.439739 66.020538 -53.325562 66.033859 -53.303341 66.01886 
  -53.465839 65.979424 -53.46085 65.957199 -53.361679 65.931374 
  -53.041401 65.993591 -53.264462 65.910248 -53.14418 65.88942 
  -53.214741 65.887756 -53.224171 65.86525 -53.139179 65.856918 
  -52.788349 65.944977 -52.683899 65.960823 -52.57362 66.012192 
  -52.518341 65.991928 -52.597511 65.948868 -52.505569 65.901917 
  -52.298901 65.903587 -52.175011 65.998871 -51.792789 66.065811 
  -51.860008 66.015533 -51.928341 66.005249 -52.005009 65.998581 
  -52.267231 65.910538 -52.26585 65.891083 -52.5089 65.884697 
  -52.66362 65.933594 -53.055012 65.848038 -53.086681 65.810257 
  -53.032509 65.805817 -53.26862 65.746918 -53.218899 65.728317 
  -52.902512 65.806374 -52.85918 65.794983 -53.160839 65.72081 
  -53.236118 65.682213 -53.15057 65.666924 -52.783619 65.682747 
  -52.711681 65.801086 -52.677231 65.793869 -52.680851 65.736923 
  -52.752499 65.664703 -52.767231 65.633324 -52.71751 65.641922 
  -52.664459 65.612473 -52.78862 65.569427 -52.78418 65.52803 
  -52.68446 65.502472 -52.604179 65.526642 -52.57473 65.508873 
  -52.443901 65.518593 -52.540009 65.424698 -52.491119 65.388031 
  -52.055561 65.50386 -51.916401 65.560806 -51.978901 65.673027 
  -51.23251 65.797203 -50.684731 65.750259 -50.79224 65.709702 
  -50.737789 65.689697 -50.551399 65.711357) 
#(-69.226967 66.563026 -69.316132 66.538857 -69.489471 66.458038 
  -69.54335 66.455261 -69.544189 66.48526 -69.701424 66.457199 
  -69.56752 66.421082 -69.42836 66.435806 -69.429749 66.459137 
  -69.24086 66.459427 -69.148071 66.416641 -69.156128 66.393044 
  -69.515846 66.285248 -69.51474 66.209702 -69.595863 66.191093 
  -69.660858 66.210823 -69.636139 66.253311 -69.675858 66.250526 
  -69.74086 66.188583 -69.795578 66.214417 -70.103912 66.259407 
  -70.331703 66.164429 -70.462799 66.211639 -70.46669 66.269974 
  -70.584473 66.263031 -70.568359 66.308296 -70.642517 66.328873 
  -70.624191 66.283577 -70.747238 66.16304 -70.857803 66.176933 
  -71.095581 65.997192 -71.315857 65.957199 -71.32753 65.976089 
  -71.097794 66.0522 -71.091141 66.09053 -71.27475 66.072746 
  -71.28363 66.088593 -71.125023 66.217758 -71.171127 66.271362 
  -71.103912 66.334976 -71.200577 66.367477 -71.249474 66.45137 
  -71.35585 66.555252 -71.796127 66.623306 -73.108627 66.723312 
  -73.330292 66.659698 -73.530853 66.517197 -74.324188 66.232193 
  -74.459473 66.156372 -74.058067 65.875526 -73.882782 65.821091 
  -73.701691 65.753036 -73.70224 65.685806 -73.606407 65.637482 
  -73.631683 65.607483 -73.504753 65.498871 -73.490021 65.450256 
  -73.703056 65.466919 -73.747238 65.517471 -74.111107 65.534416 
  -74.306961 65.467758 -74.346123 65.407471 -74.576401 65.33165 
  -74.676407 65.353592 -74.712601 65.431717) 
#(-88.412231 65.630249 -88.539459 65.578583 -88.212784 65.402763 
  -87.966667 65.333038 -87.361954 65.324417 -87.059448 65.414139 
  -87.118622 65.443314 -87.077789 65.48497 -86.908623 65.544983 
  -86.454453 65.742203 -86.464737 65.771088 -86.421402 65.902206 
  -86.099472 65.9897 -85.973907 66.038857 -86.011124 66.105263 
  -85.897247 66.168297 -85.940567 66.189423 -86.645279 66.319702 
  -86.80751 66.446091 -86.633904 66.436371 -86.777237 66.511093 
  -86.775284 66.526093 -86.587799 66.515259 -86.581413 66.555817 
  -86.381973 66.513031 -86.333618 66.549973 -86.256973 66.513313 
  -85.920288 66.503311 -85.781113 66.526367 -85.466667 66.578308 
  -85.343613 66.486923 -85.338058 66.39415 -85.298889 66.362198 
  -85.306686 66.314148 -85.252502 66.273033 -85.178337 66.262192 
  -85.118073 66.324692 -85.066132 66.275528 -84.869461 66.266647 
  -84.735291 66.20665 -84.628632 66.214706 -84.460571 66.159149 
  -84.372528 66.168297 -84.407806 66.21553 -84.636139 66.328873 
  -84.626968 66.343582 -84.517242 66.404694 -84.426971 66.363037 
  -84.392227 66.291367 -84.32196 66.274139 -84.305862 66.30304 
  -84.178337 66.315536 -83.940308 66.193314 -83.801392 66.216637 
  -83.786957 66.197746 -83.839188 66.176086 -83.847794 66.153313 
  -83.767242 66.169418 -83.681137 66.210823 -83.791687 66.303589 
  -83.864182 66.312469 -83.871407 66.394974 -83.916412 66.44664 
  -84.218918 66.594147 -84.142517 66.647202 -84.153061 66.685806 
  -84.254997 66.696907 -84.324463 66.676933 -84.445297 66.720261 
  -84.323639 66.769699 -84.328056 66.778313 -84.599457 66.815811 
  -84.684464 66.844147 -84.529167 66.821091 -84.545853 66.845543 
  -84.746689 66.897476 -84.562233 66.901367 -84.755287 66.951637 
  -84.885559 66.935806 -84.900848 66.898033 -84.948624 66.858582 
  -85.146133 66.839417 -85.228622 66.878311 -85.048607 66.963318 
  -84.64003 66.978027 -84.843918 67.008591 -84.9039 67.024406 
  -84.367798 66.968582 -84.578079 66.971916 -84.38974 66.923859 
  -84.420303 66.901917 -84.382523 66.8647 -84.239754 66.833862 
  -84.327507 66.835823 -84.436417 66.818314 -84.267242 66.780807 
  -84.313347 66.746094 -84.260567 66.71637 -84.105301 66.708313 
  -83.945557 66.813583 -83.916397 66.881088 -83.890297 66.857758 
  -83.886139 66.813873 -83.955307 66.747757 -83.856117 66.680817 
  -83.900864 66.644699 -83.9328 66.701103 -84.01474 66.692749 
  -84.008911 66.624687 -83.672501 66.520538 -83.529167 66.394699 
  -83.545303 66.381363 -83.618362 66.440811 -83.636963 66.427467 
  -83.573624 66.343582 -83.357803 66.353027 -83.015289 66.506088 
  -83.017242 66.546921 -82.585571 66.564697 -82.357803 66.728867 
  -82.153961 66.711807) #(12.06306 65.209976 12.18806 65.245529 
  12.22944 65.29248 12.2125 65.325531 12.44666 65.36554 
  12.50278 65.391922 12.2825 65.573868 12.24472 65.566933 
  12.21389 65.483307 12.32166 65.48526 12.16889 65.397751 
  12.18611 65.379967 12.18667 65.347198 12.12167 65.357483 
  12.06306 65.209976) #(-14.55753 66.383331 -14.94389 66.37886 
  -15.07167 66.298859 -15.34222 66.252762 -15.34083 66.175537 
  -15.38194 66.142761 -15.45861 66.188309 -15.62528 66.223862 
  -15.77306 66.28775 -15.68611 66.334137 -15.69333 66.365807 
  -15.93778 66.420532 -15.93528 66.498032 -16.178341 66.534416 
  -16.20306 66.504433 -16.555559 66.500809 -16.577499 66.474983 
  -16.41695 66.270813 -16.486389 66.178864 -16.428341 66.143044 
  -16.520559 66.183029 -16.68861 66.159416 -16.63834 66.10025 
  -16.724171 66.146362 -16.918329 66.118874 -16.968889 66.185532 
  -17.103609 66.212753 -17.271391 66.160538 -17.259171 66.127472 
  -17.35833 66.094704 -17.41222 65.957748 -17.438339 65.996368 
  -17.551941 65.973038 -17.559719 65.950813 -17.820841 66.112198 
  -18.21056 66.173027 -18.333059 66.151917 -18.315559 66.056641 
  -18.205561 65.921921 -18.145281 65.92276 -18.07028 65.838318 
  -18.103889 65.758873 -18.06278 65.686081 -18.06945 65.643311 
  -18.13361 65.704697 -18.180559 65.784416 -18.28945 65.910812 
  -18.540279 65.972748 -18.521111 66.02803 -18.56778 66.091919 
  -18.66222 66.086639 -18.62611 66.132477 -18.69861 66.16748 
  -18.805559 66.13942 -18.784451 66.191093 -18.865841 66.199982 
  -18.91695 66.145248 -18.91028 66.18248 -18.958611 66.189148 
  -19.069731 66.159973 -19.10833 66.106644 -19.055559 66.06665 
  -19.344721 66.083862 -19.45639 66.048859 -19.418329 65.999153 
  -19.51306 65.95192 -19.391109 65.836357 -19.39806 65.785248 
  -19.45195 65.725807 -19.548889 65.762482 -19.55945 65.733307 
  -19.647779 65.756088 -19.705 65.864433 -19.86945 65.891922 
  -20.094999 66.124687 -20.42083 66.085823 -20.446951 66.024139 
  -20.30917 65.856087 -20.316111 65.808868 -20.26306 65.723587 
  -20.32361 65.648857 -20.395281 65.524139 -20.410839 65.592484 
  -20.527229 65.570251 -20.430559 65.542763 -20.446671 65.49498 
  -20.493059 65.487473 -20.547501 65.510803 -20.56945 65.576103 
  -20.61306 65.584976 -20.645559 65.546921 -20.62611 65.676361 
  -20.682501 65.69165 -20.945841 65.574142 -20.98889 65.468307 
  -20.916389 65.341637 -21.081671 65.456093 -21.097231 65.436653 
  -21.06889 65.338867 -21.105829 65.285248 -21.069731 65.194702 
  -21.09889 65.162483 -21.144171 65.238037 -21.212219 65.437187 
  -21.478889 65.444138 -21.303061 65.530807 -21.29945 65.582199 
  -21.33334 65.599983 -21.475 65.556923 -21.43639 65.592758 
  -21.406389 65.632202 -21.648331 65.651093 -21.664721 65.676933 
  -21.77084 65.767471 -21.67028 65.760529 -21.589451 65.688026 
  -21.438061 65.688026 -21.339729 65.7397 -21.475 65.764977 
  -21.350281 65.789978 -21.28861 65.839706 -21.279169 65.894974 
  -21.38027 65.956009) #(180.0 66.398041 180.0 66.208054 
  180.0 66.018051 180.0 65.828056 180.0 65.638046 
  180.0 65.448036 180.0 65.258041 180.0 65.068047) 
#(-180.0 65.053116 -179.79196 65.150711 -179.49419 65.325439 
  -179.46219 65.43618 -179.30716 65.514931 -179.3293 65.63797 
  -179.54832 65.701958 -179.87071 65.85453 -179.88055 66.004646 
  -179.93715 66.105545 -179.78212 66.108009 -179.67137 66.139999 
  -179.56064 66.078476 -179.35146 66.127693 -179.3736 66.191681 
  -179.38345 66.309799 -179.23579 66.258125 -179.18411 66.32457 
  -179.14227 66.240898 -179.0 66.174667) 
#(-180.0 68.851898 -180.0 65.053116) 
#(179.7849 65.016922 179.8248 65.024696 179.8775 65.035263 
  179.94611 65.051086 180.0 65.068047) 
#(35.749161 64.964981 35.859989 64.998581 35.868889 65.031921 
  35.796661 65.055252 35.80167 65.103592 35.862782 65.065262 
  35.852219 65.117752 35.81181 65.180542 35.602211 65.149979 
  35.56583 65.178589 35.521648 65.149979 35.538052 65.106918 
  35.611111 65.058029 35.716381 65.041924 35.749161 64.964981) 
#(-65.479752 66.387192 -65.472237 66.31192 -65.964188 66.043869 
  -65.941406 65.99025 -65.888077 65.948593 -65.498917 65.970261 
  -65.329193 66.003593 -65.226967 66.01915 -64.854187 66.109703 
  -64.840027 66.193314 -64.59169 66.308594 -64.396683 66.329697 
  -64.721687 66.217484 -64.75502 66.163857 -64.85141 66.028313 
  -64.755287 65.984703 -64.754997 65.966087 -64.940582 66.001923 
  -65.117798 65.964981 -65.408363 65.871643 -65.505577 65.743317 
  -65.472794 65.736359 -65.401138 65.781372 -65.374191 65.770248 
  -65.442787 65.699692 -65.431412 65.669144 -65.16835 65.656082 
  -65.047241 65.712479 -64.828079 65.72998 -64.80336 65.714142 
  -64.981407 65.704697 -65.126129 65.633324 -65.295853 65.631638 
  -65.303909 65.60553 -65.180283 65.593582 -65.220863 65.554977 
  -65.110313 65.541092 -64.950302 65.568314 -64.818909 65.661926 
  -64.709473 65.650528 -64.821693 65.641647 -64.839752 65.613861 
  -64.789177 65.584137 -65.168907 65.482758 -65.136139 65.42247 
  -64.989754 65.368317 -64.96669 65.405807 -64.456703 65.444977 
  -64.439468 65.47998 -64.442253 65.420258 -64.710861 65.389977 
  -64.909187 65.334702 -64.732803 65.337753 -64.696411 65.329697 
  -64.892242 65.308296 -64.896683 65.273323 -64.810852 65.234154 
  -64.706703 65.267471 -64.697533 65.23497 -64.714752 65.189972 
  -64.71669 65.156082 -64.62085 65.192467 -64.641129 65.149979 
  -64.575851 65.127472 -64.555573 65.092194 -64.50975 65.120529 
  -64.461693 65.294983 -64.273064 65.428589 -64.236687 65.421921 
  -64.39003 65.304428 -64.384193 65.274406 -64.337799 65.289139 
  -64.396133 65.207199 -64.319748 65.148323 -64.223083 65.198593 
  -64.08197 65.196091 -64.275864 65.098862 -64.12114 65.043869 
  -64.081413 65.063583 -64.074722 65.120796 -63.94862 65.10054 
  -63.916401 65.134979 -63.80751 65.184418 -63.791401 65.167763 
  -63.885841 65.079971 -63.824459 65.027481 -63.73251 65.048859 
  -63.655289 65.03804 -63.827511 65.007751 -63.781399 64.976639 
  -63.62196 65.001083 -63.60112 64.981918 -63.656399 64.937187 
  -63.579731 64.897202 -63.52306 64.903313 -63.520012 64.976639 
  -63.398621 65.029137 -63.398621 65.078033 -63.342232 65.140533 
  -63.510571 65.193314 -63.353901 65.201103 -63.45834 65.239433 
  -63.35445 65.247192 -63.343899 65.264977 -63.429459 65.270248 
  -63.33556 65.300537 -63.496399 65.366638 -63.391941 65.394974 
  -63.61446 65.452477 -63.583618 65.472748 -63.39418 65.425262 
  -63.295292 65.436371 -63.446949 65.488312 -63.511681 65.476089 
  -63.569462 65.549149 -63.59668 65.583313 -63.474731 65.52359 
  -63.355289 65.53775 -63.320011 65.593307 -63.37529 65.632202 
  -63.567509 65.653313 -63.347511 65.676651 -63.529171 65.876923 
  -63.49918 65.935257) #(-21.38027 65.956009 -21.541389 65.952187 
  -21.321671 65.985527 -21.325001 65.998032 -21.39167 66.026093 
  -21.527781 66.01915 -21.55917 66.044693 -21.51083 66.061371 
  -21.549999 66.092758 -21.64028 66.080544 -21.62195 66.033859 
  -21.66861 66.020248 -21.644171 66.06665 -21.72167 66.072479 
  -21.745001 66.16748 -21.868059 66.192467 -21.928341 66.241638 
  -22.231951 66.274406 -22.204439 66.334976 -22.358061 66.392761 
  -22.40778 66.45665 -22.432501 66.448029 -22.45167 66.419144 
  -22.94639 66.464981 -22.879999 66.44165 -22.87417 66.415817 
  -23.093889 66.438873 -23.132231 66.4272 -23.049721 66.391083 
  -23.03945 66.363586 -23.190281 66.353317 -23.146111 66.329697 
  -22.93861 66.298576 -22.82445 66.345261 -22.809719 66.309418 
  -22.610001 66.367203 -22.709169 66.304703 -22.70056 66.29248 
  -22.50639 66.300537 -22.560841 66.271927 -22.36834 66.268311 
  -22.53056 66.245796 -22.821951 66.261093 -22.98889 66.226639 
  -22.91222 66.173576 -22.495001 66.07637 -22.383341 66.090813 
  -22.47278 66.053307 -22.35861 65.908043 -22.435841 65.838867 
  -22.46806 65.834137 -22.43 65.887192 -22.458611 65.94165 
  -22.53639 65.969971 -22.621389 65.864433 -22.56945 65.973312 
  -22.680281 66.055252 -22.76528 66.047203 -22.78334 65.971649 
  -22.82972 65.912201 -22.81361 65.997757 -22.878059 65.974701 
  -22.84556 66.01915 -22.930559 66.047203 -22.965281 66.01442 
  -22.980829 66.022751 -22.98139 66.078583 -23.038891 66.106644 
  -23.10778 66.076103 -23.14222 66.138313 -23.371389 66.191933 
  -23.583891 66.158859 -23.59584 66.138313 -23.39361 66.094704 
  -23.66222 66.117477 -23.65834 66.104141 -23.52389 66.048309 
  -23.68667 66.060806 -23.801109 66.056641 -23.816111 66.009407 
  -23.74028 65.964706 -23.315559 65.859154 -23.821671 65.918869 
  -23.865841 65.892471 -23.870001 65.863037 -23.74361 65.776093 
  -23.52195 65.750809 -23.233891 65.772476 -23.516109 65.724983 
  -23.52528 65.697197 -23.296949 65.669418 -23.466949 65.640533 
  -23.561951 65.605797 -23.553341 65.641647 -23.575001 65.676361 
  -24.105829 65.806641 -24.12611 65.775818 -23.803341 65.607758 
  -24.083611 65.647202 -24.01306 65.594704 -23.806669 65.532471 
  -23.89222 65.518044 -24.157499 65.608032 -24.333059 65.629967 
  -24.37611 65.559418 -24.514999 65.513603 -24.509171 65.489433 
  -24.333611 65.493027 -24.054449 65.471359 -24.0 65.444427 
  -23.907499 65.40303 -23.72278 65.417213 -23.652229 65.467758 
  -23.22917 65.482758 -23.19445 65.50415 -23.196671 65.562187 
  -23.160839 65.579422 -23.15028 65.54776 -23.01417 65.542213 
  -22.951111 65.607483 -22.9125 65.564697 -22.860001 65.584702 
  -22.85083 65.613037 -22.79528 65.589142 -22.88722 65.541367 
  -22.719999 65.501083 -22.76334 65.625809 -22.683611 65.622482 
  -22.716949 65.581917 -22.678341 65.526642 -22.573891 65.531082 
  -22.53611 65.57164 -22.555 65.616638 -22.495001 65.50415 
  -22.32556 65.537201 -22.108891 65.594971 -22.1775 65.535248 
  -22.366949 65.503311 -22.384171 65.476929 -22.27972 65.440262 
  -22.178061 65.442467 -22.10778 65.525253 -21.815001 65.433594 
  -22.19417 65.321091 -22.441669 65.246643 -22.531389 65.185806 
  -22.070841 65.104713 -21.964729 65.126373 -21.808611 65.203308 
  -21.734171 65.196091 -21.72945 65.157471 -21.844999 65.067467 
  -21.791109 65.04747 -22.529449 65.050812 -22.625561 65.007751 
  -22.577499 64.975807 -22.67417 64.998871 -22.69861 65.059982 
  -23.11195 64.958862 -23.110001 64.91803 -23.16028 64.95192 
  -23.083611 65.005249 -23.190281 65.015808 -23.23917 64.99054 
  -23.22278 64.943314 -23.26334 64.922203 -23.31361 64.947746 
  -23.68778 64.892212 -23.833891 64.9272 -24.057831 64.889221) 
#(-66.6996 64.760681 -66.735023 64.824692 -66.727524 64.905258 
  -66.744751 64.926361 -66.830307 64.940811 -66.747238 64.958313 
  -66.735023 64.996643 -66.773361 65.028587 -66.851967 65.033859 
  -66.799469 65.064697 -66.82753 65.094704 -66.753357 65.113312 
  -66.730583 65.181374 -66.826424 65.149139 -66.898071 65.064972 
  -67.108612 65.060257 -67.055573 65.105263 -66.959183 65.106644 
  -66.934738 65.233871 -66.99086 65.198303 -67.120567 65.214142 
  -67.077797 65.250259 -67.16835 65.268044 -67.120033 65.309982 
  -67.326973 65.316933 -67.408913 65.334137 -67.107803 65.367752 
  -67.065582 65.458588 -67.339752 65.444427 -67.456703 65.501923 
  -67.335571 65.494141 -67.404739 65.519699 -67.362244 65.546921 
  -67.261139 65.529694 -67.336143 65.580811 -67.256973 65.599136 
  -67.265297 65.623306 -67.399193 65.676933 -67.730583 65.636368 
  -68.030853 65.484421 -67.951973 65.568314 -67.998917 65.566933 
  -67.903084 65.612473 -67.874191 65.643311 -67.972794 65.709137 
  -67.821411 65.768044 -67.813629 65.811653 -67.901962 65.784698 
  -68.205582 65.794983 -68.081123 65.834427 -68.182533 65.851639 
  -68.149193 65.889687 -68.150299 65.930527 -68.306137 65.908859 
  -68.333633 65.931923 -68.315567 65.959702 -68.2603 65.957748 
  -68.323914 66.00386 -68.333633 66.043587 -68.134193 65.963318 
  -68.119751 65.973862 -68.205582 66.002762 -68.185577 66.027481 
  -68.104752 66.015259 -68.091423 65.980797 -68.053627 65.991089 
  -68.052254 66.021927 -68.027252 66.074982 -68.134193 66.10997 
  -68.223358 66.126083 -68.225594 66.069977 -68.278084 66.083588 
  -68.448639 66.182213 -68.470581 66.224426 -68.523071 66.299423 
  -68.456413 66.271362 -68.417236 66.205261 -68.336143 66.174973 
  -68.338623 66.217194 -68.26503 66.218582 -68.230583 66.146362 
  -67.99086 66.092484 -68.030853 65.998032 -67.989471 65.986076 
  -67.938629 65.908043 -67.839752 65.883873 -67.703079 65.893044 
  -67.745567 65.936081 -67.743073 65.960533 -67.681961 65.925262 
  -67.454193 65.897476 -67.411133 65.943863 -67.201973 65.909149 
  -67.171967 65.926361 -67.311974 65.996918 -67.165024 66.036926 
  -67.749474 66.252197 -67.701424 66.284698 -67.760834 66.358032 
  -67.993073 66.506927 -67.923897 66.516083 -67.79863 66.460251 
  -67.638641 66.445534 -67.399193 66.29248 -67.152527 66.299973 
  -67.143356 66.319977 -67.378357 66.39859 -67.406418 66.429703 
  -67.350304 66.428864 -67.185303 66.363586 -67.14003 66.376648 
  -67.148643 66.443863 -67.317787 66.531082 -67.722794 66.558029 
  -67.726967 66.576637 -67.591423 66.581917 -67.51503 66.573593 
  -67.542801 66.602478 -67.523071 66.622192 -67.218079 66.538307 
  -67.198639 66.494141 -67.10585 66.485809 -67.079742 66.511917 
  -67.124191 66.51387 -67.14975 66.531921 -66.997238 66.529419 
  -66.887802 66.569427 -67.04335 66.625809 -67.023071 66.643311 
  -66.851967 66.583313 -66.749741 66.594971 -66.723083 66.576637 
  -66.821693 66.535538 -66.790298 66.471077 -66.75502 66.431923 
  -66.677521 66.449692 -66.728912 66.383324 -66.466423 66.414978 
  -66.438629 66.404137 -66.550308 66.373871 -66.565582 66.343872 
  -66.47113 66.347748 -66.515297 66.318588 -66.474747 66.275253 
  -66.51503 66.28331 -66.541138 66.241638 -66.489754 66.202759 
  -66.38002 66.204971 -66.371689 66.22525 -66.422523 66.256088 
  -66.420029 66.275818 -66.258911 66.238861 -66.240837 66.234703 
  -66.200851 66.169418 -65.95224 66.108871 -65.479752 66.387192) 
#(-40.18029 64.431091 -40.149448 64.489433 -40.248901 64.53331 
  -40.45113 64.565262 -40.47279 64.583588 -40.37862 64.619713 
  -40.474461 64.680817 -40.54501 64.718033 -40.444462 64.72554 
  -40.438622 64.745247 -40.528629 64.796371 -40.505009 64.83165 
  -40.760288 64.934143 -40.85807 64.913307 -40.865292 64.898323 
  -40.78529 64.805252 -40.704182 64.771927 -40.58432 64.69191 
  -40.503071 64.598862 -40.541119 64.565536 -40.476959 64.540817 
  -40.500011 64.499977 -40.44751 64.475807 -40.18029 64.431091) 
#(-14.74611 64.383034 -14.53945 64.406082 -14.34528 64.60553 
  -14.49695 64.546654 -14.5575 64.5672 -14.43306 64.593872 
  -14.405 64.627197 -14.44945 64.642761 -14.28083 64.645813 
  -14.27111 64.67247 -14.34111 64.683594 -14.48 64.791641 
  -14.38806 64.758591 -14.24306 64.688873 -14.01417 64.726357 
  -14.01917 64.757477 -14.03 64.789978 -13.83361 64.799698 
  -13.90056 64.818588 -13.955 64.839706 -13.82695 64.823593 
  -13.76528 64.861359 -13.80278 64.882202 -13.94222 64.90387 
  -14.05111 64.933868 -13.74195 64.912483 -13.70806 64.932747 
  -13.9225 65.012756 -14.21722 65.021927 -14.09778 65.030533 
  -14.00945 65.05748 -14.01028 65.073029 -13.77917 64.987762 
  -13.61611 64.992477 -13.49778 65.073029 -13.51222 65.159698 
  -13.53528 65.16275 -13.625 65.096649 -13.68472 65.11525 
  -13.66528 65.151367 -13.62222 65.192467 -14.035 65.193039 
  -13.63945 65.219421 -13.56861 65.266647 -13.69861 65.30304 
  -13.96806 65.276642 -13.745 65.312187 -13.72695 65.334427 
  -13.83361 65.363586 -13.67556 65.373032 -13.61167 65.509979 
  -13.65833 65.531647 -13.81083 65.525253 -13.87028 65.612198 
  -14.00028 65.598862 -14.24195 65.65831 -14.32432 65.632782 
  -14.46306 65.554138 -14.53111 65.540817 -14.27472 65.671371 
  -14.39806 65.716919 -14.33694 65.783043 -14.38194 65.790817 
  -14.81778 65.721359 -14.89222 65.75914 -14.64695 65.88942 
  -14.60583 65.958038 -14.66333 66.043587 -14.73083 66.066093 
  -14.89972 66.02887 -15.0525 66.069977 -15.06556 66.096077 
  -15.15417 66.099136 -15.14917 66.136093 -14.97695 66.169693 
  -14.93639 66.211639 -15.00111 66.277206 -14.55753 66.383331) 
#(-173.4101 64.619034 -173.3817 64.551086 -173.3653 64.461639 
  -173.4734 64.392197 -173.6817 64.347198 -174.06779 64.436081 
  -174.1234 64.553589 -174.1758 64.57692 -175.0056 64.813309 
  -175.00751 64.872757 -175.0289 64.86026 -175.0231 64.820251 
  -175.0531 64.77887 -175.4892 64.782471 -175.487 64.827759 
  -175.42281 64.852203 -175.92281 65.014137 -175.8125 65.059418 
  -175.78059 65.160812 -175.92281 65.287483 -175.8947 65.32164 
  -176.0928 65.49025 -176.85699 65.589706 -177.2178 65.591637 
  -177.50031 65.485809 -178.41811 65.479713 -178.5631 65.516373 
  -178.57201 65.548027 -178.45171 65.718582 -178.47 65.741928 
  -178.65469 65.761368 -178.90109 65.91275 -178.8636 65.940811 
  -178.94501 66.018593 -178.9606 66.048576 -178.785 65.989967 
  -178.66251 66.121918 -178.5728 66.133034 -178.5186 66.227753 
  -178.507 66.397202 -178.5495 66.399139 -178.7775 66.208038 
  -178.9192 66.169144 -179.0 66.174667) 
#(10.51222 64.428307 10.63111 64.393044 10.62 64.445534 
  10.76222 64.379967 10.85305 64.372482 10.79139 64.438026 
  10.68278 64.434692 10.66833 64.452187 10.83944 64.46553 
  10.81444 64.507751 10.89722 64.469971 10.96639 64.503036 
  10.91555 64.578583 10.97222 64.601357 11.18639 64.473038 
  11.16306 64.443039 11.2575 64.452477 11.33778 64.429703 
  11.32805 64.398323 11.23555 64.330544 11.40861 64.446091 
  11.65555 64.473312 11.43861 64.464981 11.47055 64.511093 
  11.56778 64.53331 11.76833 64.594147 11.635 64.582474 
  11.61472 64.621094 11.55444 64.598862 11.595 64.583862 
  11.54639 64.563026 11.50167 64.575531 11.3925 64.673309 
  11.40305 64.707474 11.61806 64.734154 11.55167 64.761642 
  11.63194 64.773033 11.83861 64.796921 11.67111 64.834702 
  11.65805 64.844971 12.09528 64.958313 12.19055 64.933868 
  12.20583 64.949692 12.07389 64.972748 11.89361 64.939697 
  11.37583 64.745796 11.23555 64.734154 11.35389 64.76442 
  11.42222 64.811371 11.25778 64.812759 11.25722 64.832199 
  11.64917 64.888603 11.69167 64.908577 11.24639 64.855797 
  11.30639 64.886642 11.56278 64.899979 11.83361 64.982193 
  11.81028 65.011368 11.975 65.065811 12.15583 65.035248 
  12.17417 64.992477 12.2075 65.003036 12.19278 65.047203 
  12.62611 65.123032 12.87556 65.279137 12.68806 65.198593 
  12.46583 65.133324 12.36666 65.153313 12.49694 65.193314 
  12.40861 65.22998 12.70444 65.252472 12.42361 65.272202 
  12.27167 65.227203 12.26222 65.243874 12.46111 65.3172 
  12.41555 65.329971 12.50861 65.365807 12.65889 65.320251 
  12.68667 65.332474 12.64528 65.355797 12.5625 65.358307 
  12.48111 65.443314 12.565 65.443863 12.56778 65.414429 
  12.65889 65.407204 12.64889 65.444138 12.77472 65.458313 
  12.58917 65.482483 12.56583 65.515533 12.61806 65.525253 
  12.56805 65.586357 12.53111 65.516922 12.42555 65.526917 
  12.38917 65.551933 12.41639 65.590813 12.35555 65.590263 
  12.37417 65.656647 12.525 65.728027 12.58555 65.704147 
  12.61528 65.646637 12.71611 65.636093 12.78944 65.642761 
  12.66139 65.661926 12.55361 65.755539 12.62361 65.798576 
  12.71583 65.786636 12.69111 65.838318 12.62028 65.82164 
  12.60917 65.842758 12.69917 65.933029 12.84139 65.966087 
  13.13389 65.865807 13.17778 65.855797 13.12194 65.940262 
  12.93194 65.974983 12.92694 65.989151 13.04028 66.078033 
  12.72833 66.038589 12.67389 66.066933 12.77861 66.107758 
  12.99028 66.135529 13.31194 66.22081 13.57389 66.23053 
  13.58055 66.179977 13.53778 66.13887 13.54972 66.10054 
  13.64277 66.154694 13.78111 66.155807 13.635 66.181923 
  13.67972 66.231918 13.99444 66.243027 14.14583 66.327477 
  14.1075 66.335533 13.90083 66.266922 13.74806 66.291367 
  13.71944 66.252197 13.60028 66.24054 13.59444 66.264137 
  13.57778 66.281921 13.04944 66.176361 13.02944 66.196373 
  13.21611 66.274979 13.50528 66.295807 13.53305 66.308594 
  13.30028 66.371918 13.32694 66.318039 13.19222 66.293297 
  13.02333 66.322197 13.00028 66.351357 13.17139 66.406082 
  13.14639 66.439697 12.97 66.518311 13.08722 66.536636 
  13.21361 66.507202 13.22722 66.449982 13.26667 66.461357 
  13.26139 66.517471 13.34639 66.536926 13.66833 66.511642 
  13.48111 66.553864 13.58055 66.598862 13.2775 66.539978 
  13.20305 66.559418 13.24778 66.609421 13.40472 66.619423 
  13.19722 66.640533 13.19583 66.66304 13.47611 66.647751 
  13.26555 66.700256 13.27917 66.721077 13.46111 66.709137 
  13.75805 66.710533 13.88778 66.733307 13.56214 66.715042 
  13.53972 66.736923 13.56528 66.755539 13.75444 66.756088 
  13.56833 66.771362 13.99083 66.786926 13.79333 66.809418 
  13.69305 66.856369 13.54222 66.89415 13.55583 66.930252 
  13.94806 66.992752 13.97 66.982193 13.89027 66.950813 
  13.95694 66.920258 14.04722 66.983307 14.01778 67.021637 
  14.06611 67.053864 14.1225 66.980263 14.13139 66.948303 
  14.22694 66.978027 14.2575 67.05748 14.53916 67.042763 
  14.55305 67.011093 14.59667 67.035812 14.57444 67.053589 
  14.45667 67.06192 14.30333 67.09137 14.32111 67.141922 
  14.44833 67.164429 14.42889 67.137756 14.42833 67.105797 
  14.48167 67.150818 14.75305 67.138603 14.7125 67.16304 
  14.55556 67.174423 14.57417 67.194702 14.98 67.209427 
  14.89139 67.146088 14.96 67.105263 15.00861 67.101929 
  14.94472 67.155533 15.07611 67.210251 15.39305 67.150818 
  15.38167 67.092758 15.49555 67.065262 15.44 67.093872 
  15.47194 67.160812 15.38444 67.19136 15.39 67.205544 
  15.47278 67.204971 15.06389 67.248032 15.13472 67.266647 
  15.15194 67.308868 14.78278 67.264977 14.815 67.245247 
  14.61833 67.211906 14.69389 67.237762 14.69389 67.275528 
  14.62278 67.255539 14.32861 67.24054 14.61639 67.383034 
  14.57306 67.395248 14.67028 67.423859 14.81528 67.399696 
  14.82861 67.374969 15.04833 67.440811 14.83472 67.440262 
  14.7275 67.493317 14.9225 67.556091 15.05055 67.570824 
  15.13305 67.5522 15.14055 67.527206 14.98694 67.549423 
  15.03083 67.519699 15.00694 67.486649 14.83222 67.472473 
  14.99083 67.464706 15.18583 67.51886 15.195 67.479141 
  15.31028 67.483032 15.46028 67.46553 15.64 67.266373 
  15.70167 67.304977 15.51667 67.425537 15.55805 67.460251 
  15.59028 67.501373 15.89444 67.563309 15.72278 67.558296 
  15.53194 67.504967 15.23361 67.529984 15.22861 67.564148 
  15.45944 67.581093 15.39167 67.628311 15.21139 67.605797 
  15.18056 67.621368 15.26833 67.66748 15.65528 67.678307 
  15.45361 67.705544 15.41444 67.739967 15.61555 67.746643 
  15.82972 67.673576 15.76972 67.73053 15.58917 67.766647 
  15.41028 67.796082 15.45333 67.832748 15.43556 67.852478 
  15.35778 67.849136 15.37917 67.797203 15.28222 67.756088 
  14.90528 67.647751 14.73667 67.648323 14.73972 67.662201 
  15.10917 67.742752 14.83944 67.771637 14.78555 67.782471) 
#(-179.0 68.767822 -178.8725 68.750259 -178.7664 68.666641 
  -178.7383 68.539429 -178.04089 68.426086 -177.9483 68.331917 
  -178.07829 68.257751 -177.9745 68.251648 -177.95061 68.289978 
  -177.72031 68.328308 -177.72169 68.349983 -177.46561 68.282761 
  -177.6259 68.303307 -177.75529 68.250259 -177.6622 68.222473 
  -177.35471 68.248032 -177.265 68.206093 -177.2458 68.15387 
  -177.15469 68.127472 -177.0811 68.156082 -176.6245 68.031647 
  -175.2925 67.669983 -175.3667 67.641922 -175.1328 67.507202 
  -175.1422 67.495796 -175.2628 67.523857 -175.2178 67.448593 
  -175.38029 67.344971 -175.33141 67.340813 -175.09419 67.371643 
  -175.04311 67.443588 -175.07581 67.478027 -174.9272 67.424973 
  -174.957 67.404984 -174.9247 67.389687 -174.83749 67.38942 
  -174.7778 67.30304 -174.79201 67.291367 -174.84109 67.314972 
  -174.8925 67.289978 -174.9556 67.10025 -174.9117 66.988312 
  -174.73109 66.929138 -174.8045 66.90303 -174.7628 66.860809 
  -174.76221 66.745529 -174.8653 66.743874 -174.9975 66.664139 
  -174.73669 66.599701 -174.4883 66.540527 -174.42059 66.449142 
  -174.4917 66.474983 -174.515 66.458038 -174.50031 66.387192 
  -174.4231 66.356087 -174.4942 66.339142 -174.4183 66.298859 
  -174.2075 66.438583 -174.24719 66.479141 -173.9917 66.47081 
  -173.9906 66.454422 -174.0486 66.400253 -173.98421 66.371094 
  -173.98309 66.348587 -174.0753 66.314148 -174.0825 66.238312 
  -174.0233 66.210533 -173.8553 66.319138 -173.8958 66.325256 
  -173.93469 66.346649 -173.78419 66.369423 -173.75861 66.448029 
  -173.78889 66.463867 -174.1339 66.544693 -174.3017 66.58609 
  -173.9572 66.678864 -174.0009 66.777206 -174.12531 66.989151 
  -174.315 66.993874 -174.25591 67.016373 -174.28529 67.058296 
  -174.57719 67.037201 -174.595 67.053307 -174.6525 67.063583 
  -174.5811 67.09053 -174.25 67.101929 -173.6331 67.128036 
  -173.4922 67.083588 -173.5367 67.050537 -173.4642 67.041641 
  -173.4556 67.085533 -173.4192 67.087479 -173.1295 67.053864 
  -173.2742 67.049423 -173.3156 67.041092 -173.19501 67.006363 
  -173.3528 66.972198 -173.36501 66.911636 -173.3278 66.882751 
  -173.362 66.840263 -173.19141 66.839981 -173.1584 66.864967 
  -173.28 66.913307 -173.2195 66.981644 -173.1156 66.996643 
  -173.0522 66.936371 -172.78 66.908043 -172.4306 66.934418 
  -172.47031 66.951637 -173.0372 67.026917 -173.07201 67.048576 
  -173.02859 67.058029 -172.52921 67.008591 -172.5192 66.999153 
  -171.7261 66.955261 -171.6881 66.933296 -171.72141 66.878593 
  -171.7086 66.856644 -171.5925 66.800812 -171.4231 66.774406 
  -171.3933 66.748306 -171.43559 66.707748 -171.3017 66.630814 
  -170.88 66.51442 -170.5842 66.358032 -170.4178 66.318588 
  -170.45889 66.291092 -170.3136 66.305252 -170.1395 66.202477 
  -170.33389 66.180527 -170.21609 66.141922 -169.9153 66.145813 
  -169.9128 66.166641 -169.7011 66.124687 -169.69971 66.058594 
  -169.8134 65.990807 -170.005 66.036926 -170.1311 66.021927 
  -170.62 65.849701 -170.54311 65.851639 -170.51579 65.8172 
  -170.565 65.75914 -170.52921 65.726929 -170.5414 65.661087 
  -170.655 65.608871 -170.8867 65.623581 -171.4203 65.8172 
  -171.5442 65.833588 -171.3575 65.723587 -171.3436 65.694138 
  -171.10609 65.622192 -171.0233 65.569138 -171.0672 65.484703 
  -171.1353 65.476639 -171.3931 65.53775 -171.93359 65.492203 
  -171.815 65.524696 -172.11079 65.564148 -172.22141 65.535248 
  -172.2697 65.551086 -172.2886 65.587479 -172.3586 65.633324 
  -172.6628 65.702187 -172.8436 65.678589 -172.6745 65.651642 
  -172.67059 65.622757 -172.3978 65.592484 -172.43111 65.531647 
  -172.33031 65.477203 -172.47031 65.468582 -172.4164 65.424973 
  -172.3214 65.429428 -172.14751 65.489433 -172.2547 65.353317 
  -172.24719 65.22998 -172.6736 65.269974 -172.70219 65.248581 
  -172.68311 65.227753 -172.45219 65.218307 -172.2469 65.197197 
  -172.18559 65.130814 -172.2536 65.133873 -172.2086 65.079697 
  -172.13831 65.10025 -172.1331 65.072197 -172.43671 64.92804 
  -172.80141 64.85025 -172.9425 64.877762 -173.07359 64.856087 
  -173.19701 64.77359 -172.94141 64.844971 -172.7872 64.793587 
  -172.79311 64.761368 -173.0914 64.670532 -173.0795 64.65831 
  -172.9039 64.686081 -172.8672 64.662483 -172.9756 64.602753 
  -173.0081 64.582748 -172.80611 64.627197 -172.46249 64.555252 
  -172.29829 64.425537 -172.63091 64.388603 -172.7995 64.424698 
  -172.76109 64.468872 -172.8364 64.525253 -173.0406 64.489433 
  -173.0522 64.464142 -172.9097 64.469971 -172.8792 64.445251 
  -172.9019 64.332474 -173.2067 64.256363 -173.4361 64.324692 
  -173.4122 64.371918 -173.26421 64.442467 -173.29919 64.460823 
  -173.29919 64.538589 -173.4101 64.619034) 
#(-50.551399 65.711357 -50.542789 65.702187 -50.743622 65.680817 
  -50.98251 65.760246 -51.392231 65.748871 -51.87862 65.639977 
  -51.882229 65.601929 -51.837791 65.573868 -51.855572 65.542763 
  -52.407791 65.389977 -52.563351 65.315262 -52.51223 65.280533 
  -52.451962 65.291924 -52.503071 65.228317 -52.509739 65.18692 
  -52.330292 65.338028 -52.31918 65.28775 -52.20863 65.330811 
  -52.186401 65.311371 -52.30751 65.199142 -52.196678 65.210251 
  -52.04195 65.304428 -52.014462 65.30304 -52.212791 65.164703 
  -52.15057 65.120247 -52.217232 65.110809 -52.28529 65.084137 
  -52.26001 65.064697 -52.071678 65.010246 -52.09557 64.980797 
  -52.011398 64.979141 -52.01585 64.962196 -52.22057 64.908859 
  -52.22224 64.883873 -52.160011 64.857758 -52.224731 64.829697 
  -52.18029 64.799698 -52.045292 64.862198 -52.05724 64.918869 
  -51.942509 64.876373 -51.9589 64.856918 -52.08585 64.814423 
  -52.077789 64.788589 -51.755569 64.86554 -51.794182 64.895813 
  -51.736401 64.978592 -51.678619 65.021362 -51.553341 64.991638 
  -51.6464 64.966919 -51.694462 64.888031 -51.49501 64.950531 
  -51.321678 65.001923 -51.275009 65.03331 -51.2589 65.00386 
  -51.413898 64.95137 -51.539459 64.856087 -51.615841 64.885529 
  -51.88723 64.813873 -51.97084 64.736076 -52.053902 64.743027 
  -52.153069 64.6772 -52.047791 64.614433 -52.102509 64.551933 
  -52.081402 64.488312 -52.103901 64.383034 -52.039459 64.399139 
  -52.07362 64.322197 -52.013062 64.295807 -52.033352 64.23497 
  -51.985008 64.199982 -51.665291 64.306091 -51.712791 64.370529 
  -51.49057 64.478027 -51.41362 64.616364 -51.335011 64.650253 
  -51.295292 64.73053 -51.185009 64.775818 -51.064739 64.785812 
  -51.024181 64.7547 -51.15556 64.715813 -51.21056 64.619141 
  -51.12862 64.614967 -50.713348 64.76886 -50.698898 64.74025 
  -50.63335 64.761642 -50.710011 64.794418 -50.64529 64.83136 
  -50.717232 64.881927 -50.714729 64.950813 -50.743061 65.002762 
  -50.884449 64.978592 -50.87973 65.062187 -50.94223 65.079697 
  -50.885841 65.10025 -50.96056 65.149406 -50.978901 65.219704 
  -50.878071 65.149979 -50.73307 65.199982 -50.839741 65.118591 
  -50.779171 65.021927 -50.688622 65.008873 -50.712791 64.967484 
  -50.543339 64.763031 -50.373901 64.758034 -50.148621 64.836906 
  -49.999729 64.861649 -50.1889 64.760246 -50.213902 64.726089 
  -50.16473 64.694977 -50.045292 64.707748 -49.98946 64.687187 
  -50.123619 64.631638 -50.060841 64.524696 -49.788071 64.428307 
  -49.694729 64.42804 -49.584591 64.339607) 
#(-74.712601 65.431717 -74.823639 65.377472 -75.111389 65.38887 
  -75.07753 65.340263 -75.101959 65.271362 -75.21225 65.250526 
  -75.597794 65.291092 -75.615013 65.342194 -75.680557 65.310532 
  -75.931137 65.322197 -75.944168 65.312469 -75.720863 65.220543 
  -75.714737 65.186371 -75.597794 65.184143 -75.348633 65.00386 
  -75.237518 65.108032 -75.185837 65.09137 -75.25502 65.000259 
  -75.38475 64.981918 -75.479172 64.91803 -75.470016 64.869423 
  -75.393623 64.91748 -75.341667 64.916641 -75.373917 64.833038 
  -75.297523 64.72525 -75.396133 64.739967 -75.531128 64.775528 
  -75.525009 64.795807 -75.461411 64.811653 -75.463074 64.843582 
  -75.594177 64.86026 -75.663094 64.945251 -75.519203 64.93692 
  -75.420303 64.972198 -75.410583 65.024696 -75.472519 65.085251 
  -75.733353 65.152206 -75.805557 65.229713 -76.680023 65.411636 
  -77.086693 65.407204 -77.210571 65.454422 -77.434448 65.456917 
  -77.420303 65.439972 -77.304466 65.387192 -77.323334 65.357758 
  -77.461143 65.37915 -77.513077 65.318863 -77.313339 65.195824 
  -77.344742 65.173309 -77.638351 65.139977 -78.145569 64.957474 
  -78.146118 64.938309 -78.064453 64.849426 -78.122513 64.780258 
  -78.297501 64.703033 -78.156403 64.694427 -78.195007 64.64859 
  -78.164467 64.634979 -78.18364 64.572479 -77.973083 64.463593 
  -78.01445 64.427467 -77.94696 64.406372 -77.850021 64.42775 
  -77.831703 64.412483 -77.905853 64.400528 -77.87056 64.370247 
  -77.652527 64.322197 -77.652252 64.388031 -77.386139 64.314972 
  -77.448914 64.290253 -77.369743 64.277763 -77.339462 64.244713 
  -77.122787 64.295532 -76.825577 64.227478 -76.84169 64.202187 
  -76.658363 64.189972 -76.660294 64.218307 -76.72168 64.238312 
  -76.736954 64.285812 -76.706123 64.300812 -76.658363 64.276642 
  -76.591957 64.310532 -76.485001 64.266647 -76.378067 64.279419 
  -76.310287 64.27803 -76.238907 64.290817 -76.196671 64.310806 
  -76.323914 64.315811 -76.375023 64.356918 -76.276123 64.351357 
  -75.960571 64.404419 -75.736954 64.366364 -75.720863 64.383324 
  -75.888077 64.474983 -75.895576 64.488037 -75.65419 64.448593 
  -75.823624 64.535812 -75.815582 64.565536 -75.451424 64.531921 
  -75.295303 64.466637 -75.183617 64.449142 -74.686111 64.371094 
  -74.65834 64.406647 -74.543083 64.42247 -74.503342 64.462753 
  -74.579742 64.479424 -74.537247 64.510529 -74.613907 64.530533 
  -74.628357 64.545258 -74.513634 64.53331 -74.475304 64.561371 
  -74.98558 64.790253 -74.955002 64.804428 -74.724747 64.771362 
  -74.706703 64.800537 -74.743057 64.842194 -74.717529 64.860527 
  -74.63974 64.861359 -74.649437 64.902786) 
#(14.04893 64.08017 14.15472 64.185791 14.11639 64.47052 
  13.68222 64.571091 13.69694 64.62941 14.31944 65.129959 
  14.36889 65.246628 14.49305 65.313583 14.50389 65.593307 
  14.63472 65.82692 14.505 66.132462 15.02528 66.149979 
  15.46805 66.283859 15.36278 66.479973 15.62583 66.605797 
  16.01 66.890808 16.353889 67.017754 16.39916 67.17775 
  16.085831 67.411636 16.192221 67.499977 16.3825 67.515533 
  16.570271 67.656921 16.72694 67.899139 17.18833 68.030258 
  17.273609 68.09053 17.884159 67.945511 18.15527 68.166077 
  18.04583 68.409409 18.09083 68.507751 18.358049 68.539139 
  18.61194 68.47525 18.952221 68.487747 19.937771 68.337479 
  20.175831 68.448013 20.211109 68.482193 19.956381 68.543854 
  20.202499 68.662193 20.350269 68.786636 20.31472 68.928299 
  20.096939 69.042191 20.58609 69.063141) 
#(14.0405 64.071747 14.04893 64.08017) 
#(12.675 63.965542 12.83666 64.023033 13.23 64.093033 
  13.98166 64.013031 14.0405 64.071747) 
#(-90.124184 64.128593 -89.816391 64.148033 -89.816391 64.17276 
  -89.884171 64.200531 -89.784447 64.244713 -89.755569 64.227478 
  -89.738342 64.140259 -89.82251 64.103317 -89.785583 64.07692 
  -89.70639 64.056091 -89.673889 64.063873 -89.497223 63.94305 
  -89.565567 64.01915 -89.538071 64.073868 -89.444733 64.021637 
  -89.374733 64.041367 -89.246948 63.959709 -89.28418 64.014687 
  -89.181122 63.969151 -89.023621 63.95026 -89.286667 64.136642 
  -89.251106 64.159416 -89.198334 64.094704 -89.065292 64.022202 
  -88.726959 63.971371 -88.68251 64.00415 -88.464737 64.043297 
  -88.227509 64.140259 -88.113617 64.136093 -87.985573 64.200813 
  -88.034729 64.221649 -88.035278 64.258034 -87.878891 64.349136 
  -87.80751 64.51442 -87.586121 64.562759 -87.511414 64.636642 
  -87.525299 64.714142 -87.479462 64.74498 -87.451401 64.707474 
  -87.385834 64.733582 -87.236679 64.884697 -86.967506 65.059418 
  -86.997223 65.096649 -86.936401 65.133034 -86.945007 65.156921 
  -87.051964 65.199982 -87.051392 65.236359 -87.955002 65.285248 
  -89.065567 65.333038 -89.188904 65.436653 -89.372513 65.489151 
  -89.438057 65.538589 -89.455566 65.596359 -89.74501 65.724701 
  -90.078056 65.812469 -91.099731 65.919983 -91.123337 65.904694 
  -91.023354 65.824692 -91.046951 65.809418 -91.444458 65.930817 
  -91.316391 65.969971 -90.574173 65.896637 -90.235001 65.92247 
  -90.225571 65.900528 -90.393066 65.896088 -90.427513 65.878036 
  -90.315292 65.862198 -90.048889 65.888313 -89.793327 65.822479 
  -89.729172 65.834702 -89.731667 65.869141 -89.991119 65.947479 
  -89.818893 65.9422 -89.416946 65.863037 -89.099731 65.72525 
  -88.412231 65.630249) #(37.654709 63.923599 37.992771 63.940819 
  38.086391 64.049698 38.04361 64.154419 37.917759 64.21637 
  37.908878 64.241928 38.026379 64.291924 38.012772 64.311371 
  37.813889 64.38414 37.7925 64.448303 37.700829 64.437469 
  37.625542 64.3647 37.326111 64.353867 37.12722 64.419418 
  36.698051 64.730797 36.554722 64.744713 36.442211 64.913307 
  36.48167 64.951103 36.646111 64.921082 36.830551 64.988037 
  36.867489 65.07637 36.833328 65.160812 36.870548 65.184143 
  37.118889 65.195251 37.724159 65.04248 37.753319 65.011917 
  37.739441 64.971359 37.765549 64.955811 38.077492 64.854141 
  38.409721 64.851357 38.365261 64.806923 38.40028 64.771927 
  38.309441 64.80275 38.04361 64.765533 38.034161 64.742477 
  38.129162 64.684692 38.05917 64.660538 38.066101 64.640808 
  38.162498 64.671371 38.166939 64.708588 38.352779 64.756363 
  38.46611 64.738312 38.490829 64.761368 38.42083 64.795258 
  38.460548 64.822479 38.93222 64.743591 39.553879 64.561653 
  39.746109 64.553589 39.921661 64.602478 39.785549 64.601929 
  39.828609 64.671371 40.45055 64.536362 40.527489 64.544418 
  40.529991 64.575531 40.467499 64.633034 40.410549 64.747482 
  40.454159 64.765808 40.521389 64.752197 40.442211 64.794693 
  40.409439 64.869713 40.32972 64.960823 40.138599 65.053307 
  39.718048 65.378311 39.701389 65.42775 39.72332 65.510529 
  39.774441 65.570824 39.85667 65.611923 40.412769 65.776367 
  40.729439 65.974983 41.007771 65.99942 41.643608 66.166641) 
#(31.85368 67.149551 32.254169 67.125259 32.32 67.088593 
  32.492222 67.033859 32.563049 66.982483 32.493328 66.931923 
  32.421391 66.880539 32.91666 66.766083 32.92667 66.733307 
  32.79388 66.733032 33.303051 66.651367 33.315552 66.620796 
  33.13166 66.649979 33.033611 66.587196 33.283611 66.612198 
  33.514439 66.539139 33.50972 66.521362 33.181938 66.571091 
  32.96611 66.536362 33.076389 66.504967 33.239719 66.531647 
  33.33778 66.481644 33.638611 66.478592 33.590549 66.451637 
  33.665279 66.443039 33.721939 66.418869 33.513329 66.400818 
  33.615269 66.376373 33.66222 66.349136 33.35944 66.33136 
  33.328049 66.314423 33.619999 66.327187 33.883331 66.260246 
  33.898048 66.224136 34.103611 66.251083 34.496941 66.106918 
  34.724159 65.978317 34.66832 65.941093 34.852779 65.896362 
  34.832218 65.822746 34.9025 65.827477 34.870548 65.767197 
  34.963612 65.717758 34.912769 65.69664 34.69083 65.803864 
  34.67638 65.769974 34.755001 65.70137 34.697781 65.673309 
  34.782219 65.595261 34.715 65.518593 34.633888 65.489151 
  34.672779 65.472473 34.65749 65.443314 34.488049 65.448303 
  34.50666 65.407204 34.36388 65.41275 34.411381 65.372757 
  34.47916 65.275528 34.6311 65.244141 34.690552 65.180817 
  34.627781 65.166924 34.815552 65.025528 34.70166 64.976929 
  34.793331 64.958313 34.9361 64.838318 34.753052 64.771637 
  34.80444 64.749687 34.855549 64.784416 34.96999 64.779984 
  35.008888 64.766922 34.822781 64.724983 34.81638 64.703308 
  34.918049 64.664139 34.959709 64.632477 34.787769 64.54776 
  35.149719 64.381363 35.314159 64.373032 35.313889 64.330811 
  35.399429 64.320251 35.596378 64.348038 35.570831 64.407204 
  35.6325 64.395248 35.894718 64.296082 35.897221 64.251923 
  36.019428 64.193863 36.060822 64.255539 36.101662 64.244713 
  36.28194 64.134979 36.211391 64.101089 36.289162 64.008034 
  37.19944 63.881939 37.289719 63.814709 37.430271 63.805538 
  37.574169 63.838329 37.654709 63.923599) 
#(-24.057831 64.889221 -23.932501 64.74942 -23.663891 64.737762 
  -23.565559 64.814148 -23.291389 64.82637 -23.13195 64.798027 
  -22.777229 64.796654 -22.6675 64.794983 -22.65028 64.771637 
  -22.45056 64.809418 -22.43972 64.779694 -22.327499 64.75914 
  -22.322781 64.743874 -22.39222 64.694427 -22.403891 64.668587 
  -22.190001 64.733582 -22.32361 64.672203 -22.44083 64.660248 
  -22.36167 64.599983 -22.341669 64.55275 -22.243059 64.568314 
  -22.250561 64.483871 -22.08778 64.468582 -22.07361 64.50914 
  -22.028891 64.521088 -21.988609 64.526642 -21.67028 64.658859 
  -21.51417 64.647476 -21.702499 64.608032 -21.978889 64.500809 
  -22.041109 64.396362 -21.984449 64.378036 -22.03334 64.344704 
  -22.092501 64.309418 -21.93195 64.306091 -21.73278 64.386917 
  -21.45417 64.39415 -21.754721 64.342758 -21.926109 64.228867 
  -21.775 64.212753 -21.71611 64.176361 -21.930281 64.156921 
  -22.039169 64.152206 -21.91972 64.123871 -21.9475 64.098312 
  -21.973061 64.111359 -22.047501 64.097473 -21.976669 64.06665 
  -22.547501 63.977772 -22.589729 64.044418 -22.68861 64.084137 
  -22.72583 64.063873 -22.72834 63.968319 -22.63139 63.94804 
  -22.70306 63.91082 -22.69861 63.85471 -22.683611 63.8036 
  -22.282499 63.850269 -21.762779 63.869709 -21.639721 63.822769 
  -21.365561 63.849152) #(8.3194427 63.660259 8.7747211 63.69276 
  8.8266659 63.71693 8.786665 63.8111 8.2699986 63.678879 
  8.3194427 63.660259) #(24.16707 65.812843 24.012501 65.78804 
  23.69639 65.825813 23.649441 65.801086 23.459721 65.82692 
  23.434719 65.760529 23.18889 65.819702 23.23444 65.763603 
  23.08111 65.698868 23.072781 65.7397 23.000271 65.752762 
  22.78278 65.86026 22.63722 65.902763 22.70472 65.80748 
  22.648609 65.750526 22.60861 65.796921 22.508051 65.773857 
  22.527769 65.810806 22.49194 65.830811 22.36389 65.859154 
  22.32111 65.798309 22.35639 65.752197 22.315001 65.732193 
  22.240829 65.7547 22.23889 65.731087 22.373329 65.711906 
  22.38583 65.670532 22.34166 65.66304 22.30722 65.698593 
  22.257771 65.691093 22.27611 65.624687 22.186661 65.621643 
  22.309441 65.613312 22.316669 65.634697 22.42639 65.548576 
  22.40583 65.535248 21.955 65.645813 22.16222 65.549149 
  22.164169 65.533043 21.852501 65.529984 22.03167 65.457199 
  21.998051 65.423309 21.94305 65.449692 21.92944 65.398033 
  21.81444 65.396637 21.586941 65.416367 21.471939 65.376083 
  21.64805 65.306923 21.685829 65.261093 21.55361 65.234703 
  21.489441 65.308594 21.32444 65.371918 21.266109 65.333313 
  21.400829 65.32164 21.62055 65.15303 21.613331 65.138031 
  21.54722 65.136368 21.549721 65.09137 21.46833 65.050537 
  21.502781 65.019699 21.42416 65.009407 21.38694 64.958862 
  21.243891 64.947746 21.18305 64.829971 21.0975 64.823303 
  21.073059 64.856369 21.03694 64.835823 21.05444 64.81192 
  21.258329 64.777481 21.310829 64.750809 21.229719 64.743027 
  21.30389 64.687187 21.21055 64.695251 21.105 64.722748 
  21.118891 64.681374 21.36194 64.56636 21.373329 64.605263 
  21.54277 64.525528 21.37639 64.526367 21.481939 64.510246 
  21.48167 64.449142 21.57555 64.464417 21.33 64.314148 
  21.27611 64.295807 21.242769 64.310257 20.95417 64.13414 
  20.91083 64.018593 20.675831 63.821659 20.67944 63.788879 
  20.61417 63.81638 20.543329 63.7686 20.49972 63.822769 
  20.458611 63.775539 20.41361 63.691101 20.36278 63.67944 
  20.34305 63.746101 20.31472 63.73666 20.32555 63.69471 
  20.28944 63.649712 20.25444 63.704708 20.240829 63.646381 
  20.05722 63.659431 20.01194 63.635818 20.033051 63.60165) 
#(-83.020607 64.914658 -83.208344 64.945534 -83.341133 65.035538 
  -83.338058 65.074692 -83.420563 65.138031 -84.088348 65.203873 
  -84.228897 65.279419 -84.151138 65.338593 -84.402237 65.401917 
  -84.440567 65.45665 -84.59584 65.47554 -84.761124 65.331093 
  -84.748062 65.292763 -84.810287 65.21637 -84.924728 65.209702 
  -85.012787 65.322746 -85.003067 65.401367 -85.04364 65.436371 
  -85.295837 65.523857 -85.291946 65.557213 -85.120293 65.574982 
  -85.051682 65.606918 -85.056953 65.631088 -85.187233 65.721359 
  -85.147507 65.738037 -85.213898 65.808029 -85.381958 65.835251 
  -85.468338 65.790817 -85.516953 65.808594 -85.520844 65.842758 
  -85.468918 65.913857 -85.506973 65.934418 -85.621407 65.91748 
  -85.832497 65.832474 -86.013901 65.709137 -86.152237 65.3797 
  -86.095001 65.356644 -86.171951 65.27887 -86.138062 65.148323 
  -86.190292 65.064423 -86.226669 64.97998 -86.152512 64.91803 
  -86.210854 64.87915 -86.180557 64.856644 -86.416122 64.592194 
  -86.358902 64.302467 -86.186111 64.145813 -86.223343 64.081917 
  -86.934448 63.906101 -87.161118 63.743599 -87.218903 63.675819 
  -87.217216 63.622211 -87.131393 63.559711 -87.040009 63.550541 
  -86.778343 63.5811 -86.666397 63.648319 -86.563606 63.670551 
  -86.267227 63.63805 -85.80307 63.706379 -85.707642 63.76598) 
#(8.3074989 63.43832 8.7869434 63.47694 9.1438885 63.550819 
  9.1677761 63.56776 8.9749985 63.590549 8.9711094 63.653599 
  8.8013878 63.639149 8.5472221 63.597759 8.7169437 63.560822 
  8.4319439 63.55666 8.2874985 63.489429 8.2827759 63.446659 
  8.3074989 63.43832) #(22.400829 63.41637 22.264441 63.50082 
  22.28389 63.524151 22.33778 63.518318 22.408051 63.452209 
  22.49305 63.57082 22.502781 63.623878 22.592501 63.663319 
  22.586941 63.705818 22.68055 63.697769 22.740829 63.617771 
  22.82444 63.64138 22.931391 63.755821 22.909161 63.772491 
  22.92333 63.801102 23.004169 63.756939 22.99111 63.808601 
  23.043051 63.838871 23.243891 63.886379 23.41666 63.92165 
  23.3675 63.996929 23.39583 64.049973 23.610001 64.024139 
  23.624161 64.04747 23.567499 64.099136 23.63722 64.116638 
  23.83139 64.224136 23.85639 64.260529 23.945551 64.246094 
  23.999439 64.385803 24.20916 64.450813 24.560551 64.768311 
  24.674999 64.784698 24.68083 64.829147 25.11278 64.909416 
  25.26083 64.813583 25.364161 64.831917 25.36083 64.906647 
  25.303049 64.90387 25.18833 64.966087 25.218611 64.989151 
  25.42083 64.944138 25.448601 64.960533 25.408331 65.038589 
  25.213051 65.124687 25.299721 65.237473 25.31889 65.314423 
  25.26639 65.377197 25.35527 65.410812 25.34222 65.484421 
  25.00444 65.622482 24.670561 65.633324 24.55472 65.732483 
  24.556391 65.786926 24.64805 65.881638 24.51722 65.791092 
  24.23666 65.81636 24.247219 65.776093 24.214439 65.774979 
  24.16707 65.812843) #(-21.365561 63.849152 -21.206949 63.886101 
  -21.30056 63.918049 -21.195 63.954708 -21.046391 63.939709 
  -21.19445 63.922771 -21.174721 63.875271 -20.978889 63.826649 
  -20.746389 63.79887 -20.714729 63.82943 -20.672779 63.842491 
  -20.68639 63.79887 -20.769171 63.767769 -20.56472 63.70805 
  -20.56139 63.751099 -20.402229 63.82304 -20.443609 63.783329 
  -20.31111 63.72971 -20.49358 63.77702 -20.539021 63.731579 
  -20.43639 63.64082 -20.501949 63.702209 -20.44611 63.667759 
  -20.33889 63.61388 -20.170561 63.536381 -19.89333 63.538052 
  -19.521669 63.484989 -18.868059 63.40276 -18.26222 63.457211 
  -18.307501 63.546101 -18.17889 63.505821 -18.219999 63.46999 
  -18.16445 63.470829 -17.928341 63.530819 -17.85722 63.605259 
  -17.96278 63.62471 -17.821671 63.638882 -17.798059 63.669708 
  -17.930559 63.661652 -17.870001 63.73193 -17.723061 63.746929 
  -17.716669 63.77388 -17.62611 63.745541 -17.56583 63.760818 
  -16.986111 63.794708 -17.01722 63.827209 -16.966669 63.91721 
  -16.940559 63.891102 -16.966949 63.78471 -16.91139 63.79665 
  -16.885281 63.86499 -16.783609 63.802761 -16.78195 63.841648 
  -16.443609 63.912769 -16.14917 64.056374 -15.99084 64.126083 
  -15.99111 64.141083 -15.70972 64.183029 -15.38389 64.277481 
  -15.37195 64.363037 -15.33083 64.303589 -15.27833 64.295532 
  -15.27306 64.32637 -15.22083 64.261368 -15.16639 64.282761 
  -15.00167 64.257202 -14.91333 64.272476 -14.89167 64.301651 
  -14.95278 64.301933 -14.94389 64.323029 -14.90639 64.315262 
  -14.70195 64.429428 -14.56833 64.411926 -14.74611 64.383034) 
#(-41.749828 63.524529 -41.55724 63.436939 -41.546398 63.471931 
  -41.516121 63.47971 -41.334728 63.43277 -41.240009 63.409431 
  -41.291119 63.49165 -41.176399 63.38776 -40.998901 63.40749 
  -41.28529 63.529991 -41.28001 63.565269 -41.20834 63.53944 
  -41.093761 63.457619 -41.016682 63.44693 -41.002789 63.461929 
  -41.142231 63.51693 -41.029171 63.509708 -41.00806 63.5336 
  -41.008621 63.556931 -40.913898 63.511929 -40.84779 63.529991 
  -40.80695 63.498878 -40.734459 63.58276 -40.888069 63.583321 
  -40.84306 63.59388 -40.878071 63.651371 -41.02668 63.676659 
  -41.337791 63.731098 -41.593899 63.7561 -41.63028 63.78693 
  -41.486401 63.82999 -41.490841 63.85693 -41.44223 63.858051 
  -41.350849 63.77721 -40.713348 63.672211 -40.660839 63.710541 
  -40.634449 63.68082 -40.518341 63.697208 -40.516682 63.724991 
  -40.623901 63.798038 -40.563061 63.830818 -40.631962 63.926929 
  -40.838902 63.945541 -40.71085 63.990551 -40.664459 63.961929 
  -40.605011 63.973881 -40.645569 64.012482 -40.54501 64.057213 
  -40.543339 64.077187 -40.587231 64.116364 -40.89613 64.160812 
  -40.960011 64.139977 -40.926399 64.104141 -40.957512 64.078308 
  -41.01223 64.085251 -41.041119 64.116364 -41.400291 64.179977 
  -41.452789 64.247482 -41.545849 64.24942 -41.567509 64.270248 
  -41.506962 64.325813 -41.059181 64.306091 -40.809731 64.382202 
  -40.617229 64.386368 -40.541119 64.323593 -40.49501 64.346359 
  -40.430561 64.341919 -40.356121 64.357758 -40.380009 64.40387 
  -40.637791 64.469147 -40.563622 64.508324 -40.60112 64.681091 
  -40.690571 64.69165 -40.692791 64.728592 -40.956402 64.820534 
  -40.88335 64.854424 -41.067509 64.876923 -41.155849 64.964417 
  -41.13501 64.978317 -40.998341 64.955261 -40.98251 64.981087 
  -41.1264 65.087196 -41.08807 65.126373 -40.900291 65.071373 
  -40.863899 65.094971 -40.70863 65.024139 -40.667789 65.107193 
  -40.603352 65.142471 -40.397228 65.02803 -40.366402 65.041367 
  -40.392231 65.064423 -40.387508 65.083588 -40.282509 64.994713 
  -40.147228 65.02887 -40.169731 65.062469 -40.13723 65.085533 
  -39.974171 65.088867 -39.950569 65.102753 -40.111401 65.127197 
  -40.111401 65.167213 -39.95668 65.142471 -39.918621 65.16275 
  -40.010841 65.175812 -40.028629 65.193588 -39.95335 65.187187 
  -39.919731 65.250809 -39.75584 65.242752 -39.826962 65.29248 
  -39.839451 65.25914 -39.884178 65.285248 -39.950569 65.359154 
  -39.864182 65.412483 -40.201962 65.478317 -40.215111 65.505333) 
#(-76.682533 63.370819 -76.571121 63.45277 -76.68251 63.481659 
  -76.610001 63.51749 -76.716667 63.56749 -77.189453 63.683041 
  -77.410278 63.686649 -77.454178 63.65221 -77.440002 63.60471 
  -77.363342 63.588329 -77.235023 63.519711 -76.847778 63.385269 
  -76.682533 63.370819) #(8.0930538 63.327209 8.1836109 63.386101 
  8.0916653 63.466648 7.9880552 63.46693 7.7783332 63.405819 
  7.9702768 63.337769 8.0930538 63.327209) 
#(-167.84641 65.761368 -168.1217 65.674423 -168.1295 65.643044 
  -168.0647 65.580261 -167.8633 65.549973 -167.5858 65.45192 
  -166.7014 65.339417 -166.1956 65.302467 -166.05141 65.251923 
  -166.0542 65.236923 -166.2608 65.259697 -166.4845 65.234703 
  -166.47861 65.17276 -166.61169 65.121094 -166.81 65.122192 
  -166.9308 65.157471 -166.92 65.226639 -166.847 65.26915 
  -166.8558 65.283859 -166.9086 65.265259 -166.9586 65.210533 
  -166.9431 65.152763 -166.855 65.091637 -166.715 65.051361 
  -166.6978 64.993027 -166.5228 64.95137 -166.4222 64.919144 
  -166.3856 64.821091 -166.4772 64.796921 -166.4847 64.729141 
  -166.3484 64.62915 -166.0856 64.571907 -164.97279 64.446091 
  -164.9097 64.455811 -164.9622 64.496094 -164.9283 64.533859 
  -164.89 64.485809 -164.31281 64.584427 -163.7317 64.577759 
  -163.4003 64.52359 -163.19701 64.411087 -163.1347 64.41304 
  -163.04359 64.491364 -163.0439 64.520538 -163.15421 64.51387 
  -163.38811 64.593033 -163.1544 64.656647 -163.13699 64.61554 
  -162.94389 64.542213 -162.86279 64.478027 -162.7903 64.33609 
  -162.6317 64.387482 -162.64169 64.417213 -162.5764 64.520813 
  -162.1689 64.688583 -161.8795 64.714706 -161.8786 64.735527 
  -161.7153 64.788307 -161.8011 64.821907 -161.7159 64.81665 
  -161.54781 64.745529 -161.4122 64.775528 -161.1825 64.937469 
  -160.9903 64.938583 -161.0706 64.910812 -161.1236 64.920807 
  -161.1389 64.909973 -160.8822 64.812469 -160.78391 64.705261 
  -160.8306 64.607758 -161.0025 64.551361 -161.0273 64.532204 
  -161.0183 64.509407 -161.1584 64.501083 -161.38831 64.536926 
  -161.46671 64.507477 -161.53841 64.386368 -161.3961 64.428307 
  -161.2506 64.392761 -160.94591 64.222473 -160.9567 64.142761 
  -160.7775 63.868599 -160.76421 63.79916 -160.79449 63.732491 
  -161.11749 63.537209 -162.1422 63.42527 -162.16341 63.435551 
  -162.0145 63.481659 -162.0919 63.514709 -162.3181 63.53693 
  -162.2731 63.489429 -162.6803 63.230549 -162.7993 63.214809) 
#(-41.125011 63.209709 -41.095852 63.2211 -41.16029 63.286098 
  -41.412788 63.373322 -41.468262 63.386971 -41.59306 63.426929 
  -41.637661 63.435589 -41.730839 63.496658 -41.855011 63.477211 
  -41.845852 63.424992 -41.461121 63.25082 -41.34446 63.233051 
  -41.36195 63.285259 -41.125011 63.209709) 
#(-85.707642 63.76598 -85.705292 63.697491 -85.613617 63.669708 
  -85.593613 63.631939 -85.654167 63.408871 -85.638062 63.244991 
  -85.577789 63.165539 -85.482513 63.118599 -85.224457 63.120819 
  -84.578613 63.31221 -84.466667 63.41832 -84.283073 63.628601 
  -84.089737 63.607769 -83.803619 63.754162 -83.637512 63.76638 
  -83.59584 63.825821 -83.646957 63.86721 -83.60585 63.93277 
  -83.68251 64.007202 -83.64389 64.032204 -83.329178 64.136917 
  -83.191116 64.118317 -83.115837 64.179138 -83.008621 64.187469 
  -82.960564 64.140533 -82.996948 64.10025 -83.140007 64.006088 
  -83.064178 63.951931 -82.525848 63.966099 -82.358337 63.900539 
  -82.357788 63.84721 -82.514717 63.790272 -82.551117 63.749989 
  -82.535294 63.726379 -82.329178 63.650269 -82.285568 63.678051 
  -81.757233 63.634708 -81.654167 63.57193 -81.535278 63.580269 
  -81.44278 63.544159 -81.011124 63.449162 -80.93779 63.467491 
  -80.912231 63.526371 -80.837509 63.533039 -80.454453 63.727772 
  -80.178886 63.756649 -80.194733 63.80471 -80.40834 63.85165 
  -80.640007 63.875542 -80.700287 63.911652 -80.567497 63.889431 
  -80.491119 63.915272 -80.751106 64.062469 -80.946953 64.129967 
  -80.972778 64.05275 -80.90918 64.023323 -80.910278 63.999149 
  -80.964752 63.99194 -81.38002 64.095543 -81.446671 64.081917 
  -81.43251 64.043587 -81.462227 64.034973 -81.930557 63.988041 
  -81.999184 64.003311 -81.956123 64.06192 -81.602509 64.129967 
  -81.605827 64.207474 -81.727226 64.258324 -81.779167 64.321091 
  -81.753891 64.486923 -81.785278 64.514977 -82.202507 64.713593 
  -82.382507 64.767761 -82.554169 64.741089 -83.020607 64.914658) 
#(-77.898903 63.09277 -77.560287 63.18277 -77.501106 63.25721 
  -77.621117 63.34721 -77.628616 63.38332 -78.211121 63.496658 
  -78.573059 63.440269 -78.56279 63.395821 -78.025284 63.11721 
  -77.898903 63.09277) #(-74.649437 64.902786 -74.545837 64.892197 
  -74.478912 64.835823 -74.554176 64.843872 -74.704468 64.735527 
  -74.431137 64.596359 -74.381958 64.569977 -74.347519 64.591919 
  -74.417793 64.659973 -74.33168 64.62886 -74.305862 64.679138 
  -74.263351 64.648033 -74.298897 64.625526 -74.243362 64.580544 
  -74.212799 64.602753 -74.221413 64.671082 -74.101967 64.694427 
  -74.128632 64.728592 -74.09613 64.751373 -74.050858 64.724983 
  -74.083618 64.631088 -74.045303 64.607758 -74.011139 64.577187 
  -74.125313 64.587479 -74.158081 64.562469 -74.013351 64.54776 
  -73.960571 64.511093 -74.128082 64.533043 -74.0439 64.45137 
  -74.057533 64.432213 -74.110023 64.464706 -74.173073 64.458588 
  -74.09169 64.429703 -74.102226 64.367477 -74.174187 64.363861 
  -74.166138 64.35498 -73.993362 64.331093 -73.970863 64.43692 
  -73.863907 64.494141 -73.815582 64.459137 -73.785568 64.482758 
  -73.844727 64.501923 -73.896118 64.578033 -73.753891 64.535248 
  -73.644203 64.566093 -73.66391 64.640533 -73.623917 64.65303 
  -73.562241 64.583313 -73.460861 64.612198 -73.394203 64.566093 
  -73.40834 64.546921 -73.470573 64.570824 -73.463364 64.502472 
  -73.30336 64.538307 -73.302231 64.583862 -73.346687 64.641083 
  -73.297234 64.656921 -73.269447 64.593307 -73.164749 64.60553 
  -73.278084 64.519974 -73.371689 64.498871 -73.421951 64.463318 
  -73.305862 64.463593 -73.458076 64.435532 -73.472794 64.399139 
  -73.396408 64.367477 -73.343918 64.401093 -73.266953 64.368027 
  -73.391678 64.338593 -73.380577 64.268593 -73.328918 64.258873 
  -73.267242 64.273857 -73.310577 64.310806 -73.228912 64.329422 
  -73.055862 64.228867 -73.074463 64.180252 -72.964172 64.186653 
  -72.897522 64.156921 -72.888077 64.08609 -72.940582 64.058594 
  -72.720291 63.961102 -72.666412 63.980549 -72.676407 64.020248 
  -72.592796 64.018044 -72.641418 63.90443 -72.660583 63.850269 
  -72.521118 63.84026 -72.505577 63.80444 -72.521973 63.78693 
  -72.368057 63.78249 -72.373917 63.843319 -72.251404 63.879711 
  -72.276138 63.915539 -72.238907 63.952492 -72.210022 63.89304 
  -72.092529 63.904709 -72.23558 63.84499 -72.253082 63.760269 
  -72.317787 63.77776 -72.363907 63.749439 -72.31752 63.67416 
  -72.214188 63.677761 -72.194183 63.773602 -72.033913 63.665272 
  -71.955856 63.725819 -71.927803 63.694988 -71.970306 63.653049 
  -71.921417 63.645821 -71.853912 63.761379 -72.004471 63.752769 
  -71.970863 63.795818 -71.915863 63.810261 -71.823914 63.78054 
  -71.765839 63.694149 -71.737244 63.7211 -71.68306 63.733879 
  -71.721413 63.691929 -71.640297 63.646099 -71.608353 63.65443 
  -71.641693 63.68388 -71.638077 63.7211 -71.534187 63.71027 
  -71.573067 63.61665 -71.57724 63.581661 -71.456131 63.57888 
  -71.460571 63.600269 -71.377808 63.632771 -71.363907 63.607208 
  -71.414467 63.570541 -71.331703 63.56554 -71.315842 63.608601 
  -71.244751 63.610821 -71.285278 63.557209 -71.63475 63.419708 
  -71.984741 63.444149 -72.060852 63.428879 -71.916687 63.389149 
  -71.770287 63.408871 -71.730026 63.34499 -71.795853 63.346931 
  -71.753082 63.312771 -71.767242 63.27776 -71.667526 63.2686 
  -71.654739 63.243038 -71.753082 63.238041 -71.658913 63.19249 
  -71.710571 63.176659 -71.545288 63.125542 -71.39447 63.12027 
  -71.408363 63.055271 -71.251106 63.024712 -71.150299 63.100269 
  -71.127502 63.071659 -71.021133 63.078041 -70.990593 63.148041 
  -70.908913 63.170818 -70.94696 63.140541 -70.832413 63.138351) 
#(-169.66611 62.943321 -169.5569 62.999989 -169.56841 63.053322 
  -169.40421 63.150269 -169.19701 63.20388 -168.85001 63.15527 
  -168.7803 63.185261 -168.69031 63.303051 -169.2184 63.344711 
  -169.0703 63.315269 -169.11079 63.29916 -169.2003 63.302761 
  -169.2711 63.356098 -169.5011 63.36916 -169.7608 63.447208 
  -170.0378 63.483879 -170.037 63.540821 -170.23891 63.66666 
  -170.48579 63.70332 -170.795 63.611099 -171.0909 63.577209 
  -171.0672 63.598881 -171.3658 63.632488 -171.37469 63.60471 
  -171.5206 63.619991 -171.4028 63.64304 -171.64 63.698879 
  -171.6234 63.757771 -171.6664 63.792488 -171.7364 63.789711 
  -171.7442 63.662209 -171.8083 63.635818 -171.85091 63.508598 
  -171.7997 63.41415 -171.53889 63.326649 -171.0919 63.432209 
  -171.08031 63.438042 -170.8447 63.459991 -170.2372 63.28249 
  -170.2117 63.247761 -170.2511 63.193878 -170.0825 63.198879 
  -169.9314 63.13332 -169.88831 63.150539 -169.7106 63.055271 
  -169.7103 63.02055 -169.7581 63.008881 -169.7469 62.96027 
  -169.66611 62.943321) #(-65.269203 63.002209 -65.1203 62.923038 
  -65.153351 62.97887 -65.126968 62.99332 -65.080582 62.938599 
  -64.953079 62.895821 -64.648911 62.892769 -64.696411 62.952209 
  -64.846687 62.967209 -64.771408 62.983318 -64.790848 63.045269 
  -64.767242 63.06221 -64.864471 63.088871 -64.753357 63.096661 
  -64.821136 63.14082 -65.055023 63.182209 -65.030296 63.207489 
  -64.968918 63.217209 -65.113907 63.252209 -65.136139 63.290821 
  -64.901138 63.237492 -64.94725 63.357769 -65.035858 63.402489 
  -65.123627 63.400269 -65.043083 63.459709 -65.102249 63.536652 
  -65.085861 63.563881 -64.984467 63.586929 -65.019699 63.60606 
  -65.18808 63.728321 -65.281128 63.810261 -65.150864 63.772209 
  -65.193626 63.763321 -64.834473 63.4986 -64.775864 63.352211 
  -64.636139 63.235271 -64.482803 63.28582 -64.587799 63.299709 
  -64.622238 63.322208 -64.508072 63.309429 -64.5103 63.374981 
  -64.598907 63.38055 -64.627518 63.41666 -64.545578 63.39555 
  -64.498917 63.42915 -64.522781 63.514709 -64.55835 63.55888 
  -64.52919 63.608601 -64.506973 63.636929 -64.527527 63.676929 
  -64.660019 63.73193 -64.941704 63.773319 -64.987518 63.82304 
  -64.969467 63.854988 -64.630577 63.978321 -64.686417 64.039139 
  -64.94252 63.984711 -64.949188 64.014977 -65.190308 64.020248 
  -65.221413 64.036362 -65.103912 64.049149 -65.054466 64.074142 
  -65.170578 64.071373 -65.11586 64.106369 -65.273071 64.179138 
  -65.358627 64.146637 -65.392242 64.155807 -65.269203 64.197197 
  -65.283081 64.221077 -65.563347 64.248306 -65.442787 64.276093 
  -65.435577 64.289429 -65.65419 64.301651 -65.554176 64.323303 
  -65.343628 64.294983 -65.20253 64.306374 -65.180573 64.336906 
  -65.196136 64.36525 -65.262802 64.37886 -65.238358 64.407761 
  -65.176392 64.391373 -65.071953 64.430817 -65.085297 64.479713 
  -65.157242 64.47081 -65.120033 64.513313 -65.238358 64.483307 
  -65.210571 64.536087 -65.263077 64.517761 -65.276688 64.460823 
  -65.334183 64.480263 -65.397522 64.443314 -65.415298 64.453308 
  -65.345863 64.497482 -65.374741 64.525818 -65.505577 64.468872 
  -65.518082 64.499687 -65.708633 64.486649 -65.725304 64.525818 
  -65.576973 64.652481 -65.561417 64.733032 -65.627518 64.771088 
  -65.665298 64.771362 -65.708633 64.736076 -65.704742 64.687469 
  -65.742798 64.741089 -65.664467 64.808296 -65.733627 64.844421 
  -65.787247 64.801651 -65.780029 64.85997 -65.924744 64.891373 
  -65.958633 64.877762 -65.886688 64.822197 -65.938629 64.799973 
  -65.85585 64.750526 -65.900299 64.741638 -65.873901 64.708588 
  -65.823067 64.631927 -65.942787 64.711906 -65.950577 64.758324 
  -66.002243 64.758591 -66.011139 64.734154 -66.011414 64.848312 
  -66.064743 64.828583 -66.138924 64.749977 -66.152252 64.689148 
  -66.19725 64.683029 -66.206413 64.721077 -66.338074 64.768311 
  -66.192253 64.77887 -66.148361 64.868874 -66.251694 64.900253 
  -66.316971 64.869423 -66.309189 64.904694 -66.353912 64.941093 
  -66.379204 64.912201 -66.495567 64.938873 -66.480583 64.983871 
  -66.541412 64.954147 -66.535294 65.010803 -66.690018 65.038857 
  -66.684738 64.809143 -66.632523 64.781372 -66.6996 64.760681) 
#(-49.584591 64.339607 -49.666401 64.332748 -50.172791 64.501648 
  -50.291401 64.665527 -50.402241 64.689697 -50.628071 64.69165 
  -50.601959 64.65831 -50.480839 64.674698 -50.45668 64.658043 
  -50.595291 64.629967 -50.792511 64.652206 -50.891121 64.610809 
  -50.879181 64.583038 -50.624729 64.585533 -50.665852 64.555252 
  -50.65057 64.517471 -50.445278 64.542763 -50.652241 64.481087 
  -50.64085 64.469704 -50.46307 64.430527 -50.193901 64.474426 
  -50.17807 64.443039 -50.363338 64.383034 -50.698071 64.44664 
  -50.64307 64.396088 -50.79501 64.425812 -50.902241 64.400528 
  -50.98695 64.305252 -51.010288 64.260803 -50.906399 64.259697 
  -50.849731 64.249977 -51.26112 64.173027 -51.359459 64.187469 
  -51.746681 64.203033 -51.753071 64.179977 -51.494579 64.183327 
  -51.357792 64.139687 -51.547508 64.169418 -51.647789 64.123581 
  -51.63084 64.111076 -51.404732 64.082474 -50.592789 64.233307 
  -50.418072 64.346077 -50.335289 64.347198 -50.532791 64.213867 
  -50.540569 64.178307 -50.139462 64.236923 -50.047791 64.197197 
  -50.079731 64.164139 -50.071678 64.133034 -50.072788 64.091637 
  -50.11195 64.188583 -50.216129 64.199982 -50.337791 64.161362 
  -50.688622 64.170258 -50.873341 64.093582 -51.388069 64.054428 
  -51.335289 64.029419 -51.332512 64.007202 -51.561401 64.04303 
  -51.65807 64.010529 -51.499458 63.96888 -51.423351 63.984989 
  -51.363621 63.961651 -51.444729 63.94138 -51.376949 63.887211 
  -51.476681 63.84304 -51.453899 63.808319 -51.411671 63.80666 
  -51.531399 63.759708 -51.551121 63.703041 -51.34779 63.718601 
  -51.531399 63.678322 -51.302792 63.62471 -51.391399 63.567211 
  -51.369179 63.551102 -51.156399 63.50304 -51.118061 63.5186 
  -51.186958 63.621658 -51.12196 63.64193 -50.505009 63.66721 
  -50.553619 63.608318 -50.587231 63.6436 -50.899731 63.606098 
  -51.142509 63.608051 -51.141949 63.574162 -51.083069 63.523319 
  -50.76112 63.55444 -50.77306 63.527489 -51.029171 63.501659 
  -51.172791 63.466381 -51.172508 63.439991 -51.131962 63.423038 
  -51.158352 63.37804 -51.10751 63.382771 -51.047508 63.473598 
  -51.003899 63.4636 -51.062229 63.389709 -51.044182 63.368881 
  -51.107792 63.339432 -51.089741 63.292759 -51.02306 63.291931 
  -51.048351 63.262489 -50.974461 63.257488 -50.95612 63.241379 
  -51.048351 63.21804 -51.05946 63.184158 -50.984459 63.157768 
  -50.835838 63.23999 -50.783352 63.240822 -50.919731 63.176929 
  -50.905289 63.137489 -50.694462 63.212769 -50.534451 63.207211 
  -50.442509 63.185822 -50.360008 63.235538 -50.04723 63.222488 
  -50.36779 63.194439 -50.452511 63.162491 -50.435841 63.136379 
  -50.6064 63.09444 -50.59473 63.05471 -50.553902 63.024151 
  -50.514179 63.05415 -50.49612 63.008041 -50.610008 62.974152 
  -50.466129 62.949429 -50.28196 62.97443 -50.243061 63.045269 
  -50.14806 63.008598 -50.22974 62.99165 -50.400291 62.851379 
  -50.350849 62.78471 -50.256962 62.882488 -49.796959 63.059429 
  -49.700569 63.05666) #(-42.056122 62.6786 -42.040569 62.704708 
  -42.033352 62.727772 -42.20306 62.731659 -42.02779 62.75082 
  -41.929729 62.718319 -41.863899 62.739429 -41.98946 62.75499 
  -42.357792 62.80777 -42.448071 62.751381 -42.404461 62.69471 
  -42.341129 62.702209 -42.056122 62.6786) 
#(-74.169167 62.602211 -73.979172 62.602772 -73.958344 62.61665 
  -74.009193 62.662491 -74.146118 62.687771 -74.38002 62.682491 
  -74.480827 62.740261 -74.651123 62.71777 -74.169167 62.602211) 
#(-68.996918 63.75412 -68.489754 63.736099 -68.36586 63.64526 
  -68.271118 63.63805 -68.312813 63.690269 -68.263077 63.688042 
  -68.216949 63.627209 -68.247528 63.597488 -68.176407 63.601101 
  -67.724472 63.364159 -67.674187 63.378319 -67.672241 63.412491 
  -67.801971 63.552212 -67.799744 63.632488 -67.861969 63.68082 
  -67.883057 63.744709 -67.778351 63.636929 -67.670303 63.65332 
  -67.477783 63.428879 -67.420029 63.431381 -67.397522 63.459148 
  -67.34697 63.374149 -67.180023 63.275539 -67.051971 63.273319 
  -67.01445 63.286381 -67.041138 63.335541 -67.000847 63.401661 
  -66.97113 63.389709 -67.006126 63.316662 -66.9478 63.284161 
  -67.023911 63.243038 -66.898071 63.171379 -66.818359 63.154148 
  -66.799744 63.17749 -66.84613 63.22971 -66.841957 63.263321 
  -66.806961 63.272491 -66.768356 63.087769 -66.67308 63.023041 
  -66.537804 62.998051 -66.60614 63.064709 -66.560303 63.07888 
  -66.588074 63.105549 -66.607803 63.21027 -66.685577 63.248051 
  -66.738907 63.294159 -66.670578 63.344711 -66.690002 63.281101 
  -66.545303 63.195541 -66.518631 63.065269 -66.159187 62.936649 
  -66.103363 62.946659 -66.094193 62.986931 -66.270287 63.10471 
  -66.275864 63.133881 -66.075012 63.021381 -66.031418 62.984711 
  -65.950577 62.975819 -65.926407 63.00832 -65.835007 63.026371 
  -65.96196 62.92749 -65.79364 62.87027 -65.781418 62.888599 
  -65.824188 62.92194 -65.814468 62.945541 -65.743912 62.96582 
  -65.743912 63.0411 -65.718353 63.049992 -65.685577 62.998878 
  -65.750847 62.922489 -65.638641 62.8461 -65.579468 62.811939 
  -65.396973 62.825821 -65.361397 62.909431 -65.326141 62.922771 
  -65.339752 62.83749 -65.25502 62.82777 -65.363892 62.816929 
  -65.361969 62.774712 -65.244186 62.779148 -65.328629 62.73193 
  -65.350594 62.67971 -65.295303 62.66943 -65.205017 62.566101 
  -65.14502 62.565819 -64.92836 62.63221 -64.985023 62.714161 
  -65.281693 62.972488 -65.269203 63.002209) 
#(-70.383911 62.53138 -70.21225 62.57777 -70.22197 62.599152 
  -70.299179 62.6436 -70.416412 62.653599 -70.376419 62.691101 
  -70.587799 62.774151 -71.217796 62.886929 -71.21196 62.857769 
  -71.033081 62.822769 -71.155296 62.8186 -71.148643 62.794991 
  -70.821693 62.774151 -70.770576 62.75193 -70.920303 62.740551 
  -70.854462 62.7136 -70.819748 62.60471 -70.734741 62.5886 
  -70.771133 62.564709 -70.711143 62.548599 -70.383911 62.53138) 
#(-64.590584 62.36721 -64.394203 62.46138 -64.481689 62.481659 
  -64.361389 62.49749 -64.382797 62.525829 -64.486397 62.548038 
  -64.560028 62.534988 -64.767242 62.562771 -64.858353 62.546101 
  -64.857239 62.512211 -64.79335 62.491379 -64.966141 62.46582 
  -64.926697 62.41832 -64.590584 62.36721) 
#(179.7849 65.016922 179.4669 64.814148 179.14439 64.785248 
  178.57719 64.594971 178.4827 64.607193 178.745 64.662201 
  178.7513 64.689148 178.7113 64.698029 178.55051 64.674438 
  177.60941 64.718033 177.3894 64.834702 177.4772 64.863312 
  177.2216 64.949692 177.1666 65.024979 176.88049 65.082199 
  176.5808 65.02359 176.3811 65.082748 176.3958 65.057213 
  176.33521 65.048027 176.3233 65.039139 176.6049 64.997208 
  176.87131 65.045532 176.96381 65.036362 177.3033 64.827759 
  177.2755 64.81221 177.0358 64.770538 176.8447 64.847748 
  176.4286 64.804977 176.1844 64.921654 176.0069 64.931091 
  175.90021 64.846359 175.7305 64.783577 175.3302 64.75386 
  175.2274 64.767471 174.6947 64.67804 174.46719 64.685806 
  174.46831 64.675537 174.6714 64.66748 175.0519 64.735283 
  175.2975 64.730797 175.8289 64.785538 176.015 64.902763 
  176.1541 64.890533 176.35519 64.749153 176.4194 64.695534 
  176.15131 64.631927 176.1136 64.589417 176.10831 64.534973 
  176.2227 64.623581 176.33659 64.62442 176.44521 64.686371 
  176.5258 64.687759 176.7561 64.570251 177.0022 64.709427 
  177.33501 64.777763 177.48911 64.756088 177.3611 64.55748 
  177.36501 64.526917 177.4377 64.4272 177.6741 64.299423 
  177.998 64.209442 178.18469 64.20665 178.0974 64.230797 
  178.0766 64.258591 178.2383 64.313873 178.2811 64.362762 
  178.5891 64.030258 178.45329 64.058296 178.3797 63.996941 
  178.6391 63.941929 178.64999 63.97971 178.7433 63.72665 
  178.7569 63.622211 178.7113 63.6511 178.5858 63.668049 
  178.6458 63.624981 178.71021 63.622768 178.7305 63.597771 
  178.6299 63.585819 178.533 63.641659 178.52969 63.614159 
  178.483 63.59193 178.44521 63.62138 178.32159 63.612492 
  178.2711 63.556938 178.38831 63.51749 178.4969 63.578602 
  178.71111 63.572208 178.7377 63.497219 178.6572 63.457489 
  178.6002 63.40527 178.7211 63.387489 178.8372 63.431381 
  178.74409 63.55415 178.7816 63.589432 178.8286 63.469719 
  178.985 63.336929 178.97659 63.321098 178.8511 63.401932 
  178.8033 63.386379 178.80299 63.35638 178.8463 63.326382 
  179.30769 63.204151 179.4147 63.134991 179.40739 63.053879 
  179.2841 63.04887 179.23441 63.002209 179.2691 62.944149 
  179.3419 62.887489 179.5011 62.869991 179.5938 62.7486 
  179.588 62.680538 179.4236 62.607491 179.4025 62.537769 
  179.3441 62.501099 179.15939 62.493038 179.0988 62.449711 
  179.1497 62.332211 179.06129 62.28471 178.9608 62.357208 
  178.37019 62.467209 177.3325 62.589432 177.2664 62.61166 
  177.323 62.75 177.4563 62.811649 177.4386 62.82082 
  177.3188 62.795818 177.2314 62.70277 177.1377 62.718601 
  177.1541 62.781109 177.1127 62.812771 176.97591 62.865971) 
#(-92.472229 62.14703 -92.634171 62.25388 -92.585281 62.302212 
  -92.724731 62.358601 -92.715843 62.38554 -92.710281 62.46582 
  -92.537231 62.440269 -92.532227 62.467491 -92.563904 62.4986 
  -92.546951 62.546379 -92.597229 62.591381 -92.601959 62.62471 
  -92.467216 62.591381 -92.476959 62.548599 -92.384743 62.529991 
  -92.24556 62.564709 -92.266113 62.595268 -92.153061 62.598049 
  -92.170013 62.572208 -92.162514 62.54221 -91.948334 62.53138 
  -91.890289 62.5886 -91.882782 62.624149 -91.948898 62.651932 
  -92.090286 62.653049 -92.333618 62.709991 -92.459457 62.810261 
  -92.420837 62.831379 -92.340012 62.843601 -92.176392 62.805271 
  -92.084457 62.809158 -92.131958 62.852772 -91.600571 62.799709 
  -91.350571 62.794159 -91.410843 62.81971 -91.249184 62.843319 
  -91.173073 62.9086 -90.982513 62.941101 -90.770279 62.947491 
  -90.756958 62.99332 -90.647781 63.04166 -90.690567 63.11832 
  -90.672501 63.157768 -90.73056 63.178051 -90.684448 63.21888 
  -90.741669 63.324162 -90.696953 63.322769 -90.696953 63.35915 
  -90.950844 63.397209 -90.968613 63.423038 -90.877502 63.39555 
  -90.786392 63.39555 -90.906403 63.428322 -91.406403 63.49332 
  -91.387222 63.521099 -91.607788 63.584991 -91.617783 63.64888 
  -91.70668 63.694439 -91.820007 63.714161 -92.202789 63.61137 
  -92.23056 63.53471 -92.320557 63.572769 -92.472229 63.523319 
  -92.539459 63.55582 -92.458618 63.571659 -92.337784 63.644711 
  -92.252792 63.623878 -92.206947 63.651661 -92.190567 63.682491 
  -92.126106 63.68832 -92.161667 63.720268 -92.416122 63.744709 
  -92.622513 63.771648 -93.402237 63.97221 -93.452507 63.95443 
  -93.333893 63.85915 -93.2164 63.843601 -93.301964 63.82777 
  -93.650009 63.877209 -93.764717 63.988319 -93.58168 63.984989 
  -93.547501 64.00386 -93.773064 64.193588 -93.612228 64.15303 
  -93.636124 64.120247 -93.612228 64.093033 -93.413071 64.009979 
  -92.965286 63.936649 -92.376404 63.77721 -92.045563 63.74527 
  -91.985001 63.819149 -91.889183 63.79665 -91.982788 63.781651 
  -91.974731 63.76276 -91.910568 63.740551 -91.809448 63.74194 
  -91.693893 63.774712 -91.652237 63.746101 -90.918327 63.563881 
  -90.561111 63.597488 -90.545837 63.626659 -90.602783 63.67944 
  -90.623901 63.657768 -90.701401 63.662209 -90.623901 63.704151 
  -90.488342 63.672489 -90.486679 63.63221 -90.429459 63.615822 
  -90.289459 63.64777 -90.262222 63.628601 -90.258904 63.607208 
  -90.148903 63.629162 -90.057793 63.749149 -90.115837 63.777489 
  -89.968613 63.782211 -89.975014 63.825821 -90.10556 63.888321 
  -90.090561 63.92416 -90.279167 64.003593 -90.18251 64.008591 
  -90.093903 63.95055 -90.018066 63.987492 -89.946671 63.96526 
  -89.977783 63.920818 -89.815567 63.931931 -89.820282 63.9711 
  -89.950562 64.086906 -89.914726 64.106918 -90.124184 64.128593) 
#(-83.672791 62.141102 -83.360001 62.24971 -83.275848 62.2486 
  -83.174179 62.211651 -83.14418 62.176659 -82.431671 62.466648 
  -82.03334 62.663879 -81.924187 62.733051 -81.956123 62.79166 
  -81.883911 62.901932 -81.911957 62.952209 -82.186111 62.979988 
  -82.361954 62.96138 -82.694458 62.93943 -83.041397 62.837212 
  -83.311111 62.924431 -83.458069 62.861931 -83.575012 62.67194 
  -83.928886 62.46693 -83.72139 62.281651 -83.72084 62.173321 
  -83.672791 62.141102) #(-6.6577778 62.05582 -6.7038889 62.07943 
  -6.6986108 62.129429 -6.7580562 62.1786 -6.728889 62.136379 
  -6.728889 62.10387 -6.753056 62.09277 -6.9519639 62.213902 
  -7.081944 62.315819 -6.980834 62.330269 -6.8875008 62.316662 
  -6.9066672 62.279148 -6.8075008 62.290272 -6.5983329 62.190269 
  -6.7227778 62.181099 -6.5675001 62.135269 -6.664722 62.144428 
  -6.5922232 62.10693 -6.6541672 62.099709 -6.6577778 62.05582) 
#(5.0863891 62.186649 5.1938891 62.201649 5.2811108 62.124981 
  5.4002771 62.083881 5.4733319 62.008041 5.5288892 62.073879 
  5.5655551 62.072491 5.4225001 62.10471 5.3844442 62.12804 
  5.415 62.175819 5.4836111 62.184158 5.6727772 62.137211 
  5.6727772 62.170269 5.8586111 62.198318 5.9211111 62.172211 
  5.9199991 62.113602 5.8497219 62.04137 5.8786111 62.035259 
  5.9649992 62.138321 6.0463891 62.09499 6.3649998 62.058601 
  6.0986109 62.101379 5.9252782 62.198879 5.9230552 62.220539 
  5.9908328 62.217491 5.9516659 62.256378 6.0516658 62.30666 
  6.3238888 62.365822 6.5883331 62.129429 6.5722222 62.16721 
  6.418056 62.304989 6.3861098 62.363602 6.4111109 62.387211 
  6.5088878 62.394989 6.5677781 62.35416 6.5536108 62.40971 
  6.6965752 62.44146 6.8830552 62.411381 7.000555 62.254162 
  6.9894338 62.176991 6.9424992 62.140541 6.978333 62.088329 
  7.1766658 62.102489 7.0108328 62.09832 6.9677768 62.119709 
  7.0372219 62.272209 7.3263879 62.272491 6.9752769 62.30999 
  6.9235659 62.361698 6.9541659 62.385818 6.7997222 62.457211 
  6.3805552 62.41888 6.2933331 62.452209 6.6755552 62.491379 
  6.621666 62.514992 6.2636108 62.521099 6.246944 62.574711 
  6.3255548 62.607208 6.5655551 62.608318 6.6122222 62.560822 
  6.6222219 62.61721 6.769166 62.6511 6.9244442 62.57777 
  6.9127769 62.647209 7.0955548 62.643318 7.0369439 62.610538 
  7.0997219 62.608601 7.1288881 62.52776 7.1608319 62.627491 
  7.5152769 62.539989 7.539166 62.499149 7.7655549 62.57777 
  7.4744439 62.566101 7.4188881 62.595539 7.414721 62.627491 
  7.4888892 62.632771 7.5030551 62.60582 7.5066662 62.660259 
  7.6302781 62.699162 7.9052768 62.73193 8.1149998 62.697491 
  8.1391659 62.706928 8.0466652 62.74749 8.0633316 62.774712 
  7.4455552 62.683601 7.4080548 62.713871 7.3677769 62.726101 
  7.6405549 62.783039 7.625833 62.795269 7.3849988 62.751381 
  6.9502769 62.725552 6.9752769 62.799431 7.0997219 62.824162 
  7.0033331 62.8386 6.8819442 62.915821 7.0983319 62.986931 
  7.2980552 63.00193 7.4486098 62.912769 7.520833 62.917488 
  7.6488891 62.969151 7.7608328 62.975819 7.7841659 62.960541 
  7.7397208 62.93943 7.6769438 62.908329 7.977777 62.97332 
  8.0819445 62.94249 8.1755543 62.802212 8.5699997 62.672489 
  8.5524998 62.716648 8.1786098 62.84499 8.1716652 62.89082 
  8.2080545 62.90749 7.9702768 63.026661 7.9008331 62.994709 
  7.8791671 63.01054 8.0636101 63.108318 8.1172218 63.09193 
  8.1380539 63.03582 8.3391666 62.96138 8.3324986 62.87471 
  8.5308323 62.841381 8.5413876 62.856659 8.500555 62.872761 
  8.6994438 62.819988 8.6630554 62.850552 8.4822216 62.897209 
  8.4233322 62.9561 8.6566658 62.966381 8.6538887 62.98444 
  8.3744431 62.9711 8.3211098 62.99527 8.371666 63.005821 
  8.4649982 63.023602 8.226387 63.02776 8.1591663 63.12027 
  8.228054 63.12999 8.2836094 63.074162 8.3244438 63.088329 
  8.2399998 63.14555 8.3655548 63.137489 8.5708332 63.139149 
  8.6313877 63.182491 8.9419441 63.209148 8.6149998 63.20026 
  8.4777765 63.293598 8.7636108 63.345268 8.6366653 63.39027 
  8.6527767 63.409161 8.83111 63.42749 8.8802776 63.394989 
  8.9611111 63.434711 9.015276 63.464989 9.1461105 63.374149 
  9.0999985 63.345829 9.0916653 63.29221 9.2969437 63.364159 
  9.478611 63.403049 9.2141666 63.367771 9.1622219 63.39138 
  9.1894436 63.431931 9.3049984 63.444149 9.332222 63.461651 
  9.2574997 63.496101 9.291111 63.45776 9.2155552 63.45277 
  9.1499996 63.47916 9.1636105 63.499439 9.3852768 63.560261 
  9.3749981 63.521381 9.4094429 63.508598 9.4236107 63.537769 
  9.5349998 63.569439 9.5716648 63.538879 9.538887 63.606098 
  9.7205544 63.636379 9.9616661 63.430271 9.9433327 63.39304 
  9.8847218 63.348049 9.8455544 63.320271 10.255 63.321381 
  10.27472 63.277489 10.2575 63.337212 10.10194 63.352772 
  10.04111 63.387489 10.06444 63.419708 10.15778 63.445541 
  10.47139 63.452492 10.80444 63.41666 10.91472 63.461102 
  10.78167 63.480259 10.77694 63.53194 10.91444 63.5611 
  10.66611 63.553879 10.98417 63.70388 11.08444 63.698879 
  11.25361 63.767769 11.45583 63.787209 11.4625 63.80444 
  11.41528 63.8461 11.115 63.843601 11.09667 63.889149 
  11.26472 63.960819 11.43583 63.978321 11.49278 64.019417 
  11.25444 64.02887 11.24583 64.060242 11.35694 64.106369 
  11.30583 64.116364 11.18028 64.008034 10.62194 63.82526 
  10.58917 63.802761 10.90417 63.894161 11.02667 63.875542 
  11.07722 63.83749 10.95583 63.75388 10.04778 63.496101 
  9.9197216 63.506378 9.7922211 63.668598 10.04667 63.737209 
  10.08611 63.763882 9.539444 63.662769 9.558054 63.723598 
  9.7788887 63.77026 9.5438881 63.763599 9.5824986 63.787491 
  10.15111 63.93943 9.9944439 63.925541 9.9522209 63.926929 
  10.08444 63.956661 10.12 63.985271 9.9344444 63.9561 
  9.9944439 64.013603 9.9958324 64.101639 10.03 64.111649 
  10.10305 64.08609 10.22028 64.116364 10.10861 64.121094 
  10.17528 64.164139 10.18056 64.197197 10.37667 64.19165 
  10.25111 64.241638 10.49166 64.293297 10.44722 64.324142 
  10.50528 64.367477 10.60361 64.340263 10.65194 64.358032 
  10.46055 64.40303 10.51222 64.428307) 
#(-6.7180562 61.933319 -6.7066669 61.951382 -6.7783341 62.062481 
  -6.8397231 62.128601 -7.0877781 62.290821 -7.1736121 62.30138 
  -7.2325001 62.172489 -7.1355491 62.133831 -7.0111108 62.108318 
  -6.961112 62.04665 -6.7180562 61.933319) 
#(-70.832413 63.138351 -71.146683 63.00832 -71.09613 62.979988 
  -70.940567 63.026932 -70.949173 62.96471 -71.00502 62.96777 
  -71.031418 62.951931 -70.769203 62.927212 -70.508362 62.865822 
  -70.253342 62.7561 -70.00058 62.757488 -69.940308 62.794159 
  -69.76474 62.734711 -69.823639 62.787491 -69.831703 62.82193 
  -69.681412 62.764149 -69.662247 62.74332 -69.62114 62.787769 
  -69.381126 62.754162 -69.557533 62.726379 -69.556412 62.7061 
  -69.495567 62.708321 -69.597519 62.662491 -69.42836 62.548321 
  -69.456131 62.623322 -69.402802 62.600269 -69.408363 62.569988 
  -69.360863 62.536381 -69.311417 62.596661 -69.277252 62.617489 
  -69.312241 62.523602 -69.281967 62.486099 -69.121689 62.41082 
  -68.882248 62.360538 -68.853912 62.381378 -68.722519 62.302212 
  -68.514191 62.24416 -67.82724 62.2061 -67.828346 62.172489 
  -67.722794 62.158039 -67.575577 62.174709 -67.499741 62.138599 
  -67.412521 62.151661 -67.343918 62.110821 -67.300858 62.068878 
  -67.232803 62.0961 -66.960571 62.014431 -66.923897 62.042488 
  -66.648643 61.952209 -66.632797 61.91888 -66.312241 61.863041 
  -65.955017 61.89027 -65.956703 61.91888 -66.138351 62.007488 
  -66.104462 62.04443 -66.200577 62.113041 -66.15419 62.125542 
  -66.132523 62.089432 -66.031403 62.068321 -66.051132 62.14777 
  -65.930573 62.201099 -66.010849 62.250542 -66.180573 62.23777 
  -66.256973 62.266102 -66.148911 62.249439 -66.164467 62.290539 
  -66.3125 62.34499 -66.363907 62.32304 -66.329468 62.26749 
  -66.475861 62.348598 -66.32753 62.38443 -66.394203 62.419159 
  -66.359734 62.447491 -66.497803 62.418049 -66.491966 62.46999 
  -66.568626 62.57304 -66.775299 62.636929 -66.726967 62.668598 
  -66.805023 62.678879 -66.981689 62.65276 -66.920029 62.696381 
  -67.049469 62.69138 -67.012527 62.73444 -67.086693 62.793598 
  -67.114754 62.820541 -67.180023 62.815269 -67.176132 62.846931 
  -67.209473 62.874981 -67.285858 62.854988 -67.246689 62.883598 
  -67.395287 62.958321 -67.410294 62.96999 -67.5728 62.963871 
  -67.500313 63.015541 -67.565582 63.049431 -67.698349 63.020821 
  -67.718918 62.95805 -67.769737 62.958321 -67.768631 62.989159 
  -67.783363 63.024151 -67.624191 63.0611 -67.610313 63.094151 
  -67.886139 63.120541 -67.914467 63.077209 -67.963348 63.064991 
  -67.917526 63.137211 -68.034737 63.154709 -68.244461 63.2061 
  -68.206703 63.227211 -68.301407 63.30666 -68.717796 63.528599 
  -68.996918 63.75412) #(-64.926971 61.71888 -64.858078 61.739159 
  -64.828918 61.766651 -64.973907 61.889992 -65.016693 61.85165 
  -65.068077 61.92387 -65.196693 61.941662 -65.255859 61.88554 
  -65.210564 61.816929 -64.926971 61.71888) 
#(-79.827789 61.566662 -79.754181 61.580269 -79.628891 61.669159 
  -79.60556 61.76527 -79.402786 61.945541 -79.261398 62.163601 
  -79.266403 62.258041 -79.540863 62.411098 -79.859734 62.401371 
  -80.017502 62.358601 -80.216667 62.172489 -80.294449 61.978039 
  -80.257507 61.883881 -80.288887 61.868038 -80.18335 61.752769 
  -80.065567 61.743881 -79.827789 61.566662) 
#(-43.079922 61.592831 -42.726398 61.555271 -42.428341 61.564159 
  -42.46862 61.613602 -42.326679 61.622211 -42.319462 61.644428 
  -42.397789 61.65638 -42.384449 61.682209 -42.30946 61.69276 
  -42.263069 61.71582 -42.43446 61.69276 -42.85474 61.786381 
  -42.753071 61.81554 -42.590839 61.73444 -42.478901 61.737492 
  -42.289459 61.77776 -42.191681 61.864429 -42.41695 61.910549 
  -42.197788 61.920818 -42.115841 62.006649 -42.147789 62.019989 
  -42.340839 62.01582 -42.466671 61.953041 -42.54668 61.94804 
  -42.418621 62.01804 -42.513069 62.03054 -42.303341 62.11166 
  -42.33585 62.143318 -42.258621 62.196659 -42.26112 62.242489 
  -42.330841 62.264431 -42.26001 62.308319 -42.632511 62.339161 
  -42.647789 62.37888 -42.79501 62.44138 -42.974731 62.46888 
  -42.964741 62.522209 -42.30946 62.362492 -42.27557 62.38055 
  -42.255009 62.432209 -42.546959 62.46693 -42.37196 62.463871 
  -42.325291 62.50526 -42.46806 62.586929 -42.64418 62.618599 
  -42.674179 62.588039 -42.789459 62.651371 -43.130009 62.696659 
  -43.128071 62.735821 -43.130009 62.76305 -43.034451 62.721931 
  -42.696949 62.69276 -42.714741 62.778881 -42.686119 62.766651 
  -42.636398 62.6786 -42.565289 62.706379 -42.613899 62.756378 
  -42.588619 62.761662 -42.506962 62.698879 -42.563622 62.798321 
  -42.548069 62.821098 -42.49501 62.775539 -42.409451 62.81638 
  -42.42168 62.833321 -42.565571 62.839432 -42.600288 62.87471 
  -42.443619 62.862492 -42.33556 62.9361 -42.28529 62.932209 
  -42.363071 62.894428 -42.345291 62.857769 -42.323898 62.809158 
  -42.040569 62.785549 -42.012508 62.87249 -41.863621 62.823879 
  -41.743061 62.852211 -41.82085 62.874149 -41.64806 62.914711 
  -41.61224 62.951382 -41.627789 62.992489 -41.98251 63.021381 
  -42.031399 63.059158 -42.157509 63.09499 -42.125561 63.13443 
  -42.17223 63.20443 -42.129181 63.203041 -41.98196 63.074989 
  -41.95335 63.079708 -41.948341 63.100269 -41.823898 63.042488 
  -41.538071 63.029709 -41.559731 63.05415 -41.865009 63.19249 
  -41.527512 63.09193 -41.429459 63.126381 -41.482792 63.15221 
  -41.47279 63.21999 -41.642231 63.309158 -41.76223 63.299709 
  -41.800011 63.342209 -41.696949 63.327492 -41.85973 63.399429 
  -41.907791 63.46471 -41.749828 63.524529) 
#(-64.95224 61.343319 -64.715027 61.433319 -64.688629 61.4711 
  -64.72641 61.54221 -64.660019 61.588039 -64.735023 61.61166 
  -64.733078 61.659988 -65.204742 61.684158 -65.472519 61.64027 
  -65.487808 61.59943 -65.467239 61.583881 -65.086693 61.451649 
  -65.100861 61.42165 -64.99585 61.412491 -64.926132 61.39249 
  -64.985023 61.367489 -64.95224 61.343319) 
#(20.033051 63.60165 19.937771 63.61665 19.77528 63.533329 
  19.77305 63.457489 19.66083 63.435261 19.639721 63.474709 
  19.46361 63.5611 19.422779 63.545818 19.48222 63.467491 
  19.47361 63.453041 19.51416 63.408329 19.33639 63.482491 
  19.365829 63.43499 19.296671 63.4636 19.274441 63.441929 
  19.26194 63.321098 19.139999 63.310261 19.11611 63.232769 
  19.045561 63.244431 19.049721 63.218319 19.110279 63.208321 
  19.03694 63.17638 18.946659 63.2486 18.803049 63.256939 
  18.739719 63.24221 18.91527 63.206661 18.78944 63.167759 
  18.75194 63.201649 18.816389 63.21582 18.70389 63.220539 
  18.753889 63.154709 18.628611 63.146648 18.64472 63.104431 
  18.558889 63.114159 18.48167 63.018318 18.375271 63.047211 
  18.423611 63.00943 18.344999 63.034431 18.25861 62.98999 
  18.539721 62.98444 18.57666 62.96582 18.565001 62.95026 
  18.41416 62.965549 18.400829 62.938042 18.525551 62.923321 
  18.47361 62.879429 18.46694 62.858318 18.362221 62.833881 
  18.309719 62.858051 18.2075 62.86166 18.280279 62.84082 
  18.264721 62.811378 18.19944 62.7761 18.18611 62.81221 
  18.14805 62.769711 18.008051 62.797771 18.145 62.816662 
  18.047779 62.849991 17.97389 62.800819 17.92363 62.820061 
  17.92305 62.864429 17.828329 62.96944 17.696659 62.99194 
  17.801109 62.94693 17.88583 62.864159 17.99472 62.730549 
  17.99139 62.653049 17.91777 62.665272 17.885281 62.656101 
  18.045561 62.6236 18.05583 62.589989 17.95083 62.562481 
  17.954439 62.608051 17.93111 62.610821 17.91083 62.544159 
  17.83555 62.483879 17.693331 62.493599 17.65416 62.467209 
  17.69861 62.434158 17.564159 62.440269 17.409161 62.538052 
  17.32555 62.480259 17.379169 62.415272 17.34111 62.393879 
  17.466391 62.310822 17.465269 62.265541 17.65472 62.231098 
  17.6 62.209431 17.53861 62.211102 17.483061 62.129429 
  17.46361 62.006378 17.34972 61.945271 17.34194 61.813881 
  17.407221 61.816101 17.39361 61.716381 17.49472 61.728039 
  17.523609 61.696098 17.477221 61.62471 17.257771 61.719151 
  17.14027 61.719711 17.22027 61.70332 17.26305 61.671101 
  17.12639 61.614429 17.14472 61.593601 17.07333 61.54887 
  17.179159 61.487492 17.15778 61.45805 17.139721 61.43166 
  17.110279 61.387489 17.274879 61.311749) 
#(-49.700569 63.05666 -50.315571 62.73888 -50.265011 62.70055 
  -50.146118 62.775269 -49.88612 62.894989 -49.879459 62.883598 
  -50.053341 62.78915 -50.071671 62.734989 -50.2239 62.669708 
  -50.313351 62.490822 -50.132511 62.39304 -50.028629 62.322491 
  -49.96806 62.308319 -49.906399 62.364429 -49.879452 62.284988 
  -49.79557 62.306099 -49.795849 62.27388 -49.5364 62.29887 
  -49.568901 62.250542 -49.293339 62.261379 -49.34306 62.227211 
  -49.47057 62.244991 -49.68446 62.149429 -49.452229 62.149712 
  -49.40057 62.202492 -49.34724 62.204708 -49.363071 62.158871 
  -49.294182 62.172211 -49.293621 62.134159 -49.426121 62.113602 
  -49.33585 62.076649 -49.452511 62.0961 -49.693619 62.115822 
  -49.68446 62.0886 -49.501949 62.087212 -49.474171 62.070271 
  -49.6964 62.019428 -49.669731 61.995541 -49.537231 61.99638 
  -49.427792 62.058601 -49.38612 62.06332 -49.383621 61.998322 
  -49.150009 62.027489 -49.148621 62.107491 -49.03529 62.212212 
  -49.006119 62.204151 -49.099171 62.083599 -49.075291 62.07526 
  -48.9739 62.13332 -49.01112 62.081661 -48.870571 62.077209 
  -48.89333 62.048599 -49.404732 61.936939 -49.327511 61.9286 
  -49.440842 61.846931 -49.42057 61.822491 -49.218899 61.906101 
  -49.17445 61.89304 -49.354179 61.765541 -49.234459 61.711929 
  -49.182789 61.745541 -49.193069 61.82999 -49.1614 61.859989 
  -48.919731 61.980259 -48.763062 61.984711 -48.74696 61.95554 
  -49.11668 61.816929 -49.142231 61.718601 -48.87001 61.782768 
  -48.929729 61.733318 -49.06918 61.68721 -49.051682 61.618038 
  -48.938622 61.642208 -48.863621 61.61499 -48.59029 61.633881 
  -48.7314 61.602489 -49.25473 61.601101 -49.241959 61.574711 
  -49.28112 61.552212 -49.045292 61.5336 -49.11195 61.513321 
  -49.10474 61.490551 -49.028339 61.489159 -48.996681 61.454151 
  -48.344181 61.604988 -48.321678 61.576099 -48.337791 61.560551 
  -48.47612 61.528049 -48.848629 61.45805 -49.060009 61.394989 
  -48.861401 61.400269 -48.8564 61.372761 -48.642231 61.438881 
  -48.67168 61.392208 -48.55751 61.381939 -48.349731 61.36832 
  -48.482792 61.34721 -48.504459 61.297489 -48.381401 61.306931 
  -48.391949 61.297211 -48.577789 61.284988 -48.634449 61.243038 
  -48.638069 61.20805 -48.55529 61.24165 -48.541119 61.19138 
  -48.471401 61.172489 -48.305851 61.21888 -48.297791 61.209431 
  -48.30946 61.185551 -48.440842 61.15554 -48.388069 61.129162 
  -48.216671 61.136379 -48.286961 61.175819 -48.18224 61.248051 
  -48.16029 61.311939 -48.042789 61.326931 -47.916389 61.323879 
  -48.08168 61.294991 -48.099731 61.257771 -48.207512 61.20499 
  -48.216671 61.180271 -48.11668 61.11388 -48.066681 61.087769 
  -47.769451 61.187771) #(21.29673 61.057281 21.48278 61.059711 
  21.434719 61.139149 21.559441 61.20388 21.477501 61.247761 
  21.544439 61.276371 21.52722 61.374439 21.445271 61.401661 
  21.53167 61.40527 21.559999 61.427212 21.423889 61.483879 
  21.58666 61.477211 21.585831 61.492489 21.48694 61.53944 
  21.49333 61.573879 21.716391 61.52055 21.61055 61.58749 
  21.543051 61.67527 21.493891 61.734711 21.378611 61.934711 
  21.30917 61.933319 21.248329 61.999989 21.389999 62.203602 
  21.32777 62.352211 21.2775 62.336102 21.269171 62.406101 
  21.192221 62.333321 21.1875 62.39193 21.125 62.406101 
  21.125271 62.547489 21.20694 62.59026 21.064159 62.596371 
  21.080549 62.67194 21.12583 62.684429 21.128611 62.730549 
  21.112499 62.774429 21.184999 62.784988 21.24 62.868599 
  21.370831 62.85915 21.4625 62.949429 21.439159 63.042488 
  21.51972 63.066101 21.620001 63.0186 21.682779 63.029709 
  21.62805 63.054989 21.495831 63.18721 21.49778 63.209991 
  21.54277 63.23193 21.647221 63.191929 21.703051 63.22332 
  21.890829 63.253319 21.88166 63.17527 21.9825 63.140541 
  21.95916 63.17915 22.045561 63.240551 22.16555 63.221931 
  22.280001 63.295269 22.31805 63.269161 22.3475 63.286098 
  22.354441 63.34499 22.198059 63.421379 22.197781 63.465549 
  22.400829 63.41637) #(-72.797791 61.834431 -72.604446 61.9711 
  -72.601669 62.02388 -72.662231 62.05666 -72.617783 62.09193 
  -72.626678 62.115551 -72.815292 62.13776 -72.800003 62.108879 
  -73.387787 62.36916 -73.5625 62.377769 -73.613892 62.433601 
  -73.696404 62.4786 -74.345573 62.277489 -74.725853 62.244991 
  -74.751129 62.191101 -74.556412 62.10471 -74.676964 62.121929 
  -74.928337 62.249149 -75.088348 62.265541 -75.132782 62.230259 
  -75.136948 62.271931 -75.184448 62.29221 -75.430847 62.299709 
  -75.59584 62.273041 -75.800293 62.30777 -76.650558 62.471661 
  -77.482513 62.59193 -77.861954 62.42915 -78.023903 62.393318 
  -78.160004 62.273041 -78.14389 62.03138 -77.982513 61.706661 
  -77.898903 61.686378 -77.78334 61.698601 -77.710564 61.60582 
  -77.49501 61.55582 -77.478897 61.536381 -77.621117 61.5611 
  -77.670288 61.519161 -77.567497 61.490261 -77.563606 61.466648 
  -77.79306 61.45388 -77.740013 61.298599 -77.752502 61.229431 
  -77.696671 61.213871 -77.699173 61.193321 -77.776123 61.165821 
  -77.793617 61.11277 -78.171951 60.85471 -78.180008 60.78693 
  -77.886467 60.824551) #(-46.753899 60.750271 -46.20668 60.885269 
  -46.164459 60.922489 -46.226398 60.94693 -46.662231 60.82999 
  -46.845291 60.76054 -46.753899 60.750271) 
#(-48.032509 60.68832 -47.7089 60.727772 -47.660839 60.75832 
  -47.757511 60.731098 -47.831402 60.75388 -47.758621 60.80027 
  -47.954182 60.83749 -48.238899 60.795551 -48.123901 60.724152 
  -48.032509 60.68832) #(27.794769 60.547562 27.81583 60.523319 
  27.86134 60.5616) #(-47.769451 61.187771 -47.928341 61.085819 
  -47.92001 61.055271 -47.855839 61.075821 -47.83363 61.041931 
  -47.87001 61.032768 -48.230289 61.02026 -48.40723 60.995819 
  -48.373901 60.977211 -47.71973 61.011379 -47.702511 60.9986 
  -48.177231 60.863041 -48.24279 60.822208 -48.18668 60.811378 
  -47.92445 60.876099 -47.654171 60.808601 -47.325569 60.85915 
  -47.327511 60.870819 -47.476681 60.889149 -47.752789 60.84444 
  -47.726959 60.877769 -47.298351 60.950821 -47.248341 60.893879 
  -47.175838 60.9286 -46.94862 60.952492 -46.91473 60.92944 
  -47.040852 60.87693 -47.029732 60.82832 -46.847511 60.878601 
  -46.980572 60.816662 -46.928341 60.797489 -46.716671 60.853321 
  -46.71056 60.88776 -46.880009 60.924431 -46.656681 60.90694 
  -46.603069 60.922771 -46.637508 60.970829 -46.541679 60.95026 
  -46.562229 61.017769 -46.513069 61.014709 -46.376678 61.04665 
  -46.406399 61.084148 -46.26334 61.045551 -46.253071 60.983601 
  -46.211399 60.97971 -46.121399 61.01582 -46.176399 61.045269 
  -46.28973 61.06776 -46.055851 61.044708 -45.914459 61.092491 
  -45.952229 61.129711 -45.83807 61.132488 -45.856682 61.176659 
  -46.11446 61.247211 -45.932789 61.233318 -45.790291 61.334991 
  -45.714741 61.318878 -45.83168 61.264431 -45.869179 61.216648 
  -45.777241 61.178879 -45.698898 61.16888 -45.620289 61.141651 
  -45.77779 61.090549 -45.681679 61.074162 -45.907791 61.038052 
  -46.105839 60.96804 -46.065571 60.921101 -46.006962 60.912209 
  -45.64613 61.000271 -45.480839 61.110538 -45.52113 61.175819 
  -45.5014 61.24749 -45.390011 61.098598 -45.355011 61.093319 
  -45.216961 61.204708 -45.200569 61.186939 -45.28223 61.095539 
  -46.021961 60.88443 -46.192509 60.806381 -46.135288 60.806381 
  -45.98695 60.883041 -45.872791 60.874149 -46.215839 60.772209 
  -46.22168 60.753601 -46.15612 60.724991 -46.011398 60.735821 
  -45.998619 60.798599 -45.873901 60.849152 -45.75473 60.826649 
  -45.823341 60.801929 -45.880569 60.752209 -45.79974 60.7486 
  -45.387791 60.957489 -45.416401 60.996101 -45.392231 61.007488 
  -45.33168 60.98138 -45.314739 60.92638 -45.253071 60.901932 
  -45.62862 60.77776 -45.577511 60.763599 -45.85445 60.693878 
  -45.734459 60.66637 -45.605289 60.70776 -45.579182 60.698601 
  -45.637791 60.677212 -45.971951 60.572769 -45.797508 60.553051 
  -45.805561 60.602489 -45.76363 60.631378 -45.68362 60.635269 
  -45.71056 60.60638 -45.689178 60.560822 -45.5914 60.576931 
  -45.675838 60.5336 -45.616959 60.508881 -45.566959 60.473881 
  -45.505009 60.5811 -45.466671 60.561378 -45.466961 60.608318 
  -45.35807 60.65694 -45.37751 60.699989 -45.315289 60.718601 
  -45.297508 60.665821 -45.20779 60.681099 -45.373901 60.605259 
  -45.39806 60.544991 -45.46056 60.513321 -45.478069 60.49165 
  -45.20612 60.588329 -45.23418 60.629711 -45.061401 60.65749 
  -45.14806 60.602489 -45.2789 60.457489 -45.212791 60.434158 
  -45.012791 60.476379 -44.880009 60.568878 -44.813622 60.671101 
  -44.631008 60.737492) #(5.5499992 60.431381 5.6816659 60.472759 
  5.6891661 60.674431 5.331666 60.537491 5.4905548 60.438599 
  5.5499992 60.431381) #(-172.28 60.302761 -172.2092 60.317211 
  -172.3972 60.396099 -172.58611 60.398319 -172.8642 60.495819 
  -172.9281 60.558601 -172.9142 60.585541 -173.0325 60.560261 
  -173.04829 60.494431 -172.5992 60.324989 -172.3439 60.339432 
  -172.28 60.302761) #(-64.411003 60.295391 -64.465729 60.34734 
  -64.411293 60.39595 -64.425453 60.415119 -64.519333 60.387058 
  -64.51767 60.430401 -64.627121 60.49762 -64.83461 60.491779 
  -64.854889 60.463169 -64.77739 60.404011 -64.411003 60.295391) 
#(-162.7993 63.214809 -162.9333 63.119431 -163.34171 63.021931 
  -163.4014 63.0686 -163.55 63.1036 -163.5614 63.11166 
  -163.5522 63.13554 -163.662 63.111931 -163.63609 63.149151 
  -163.74561 63.218319 -164.1597 63.258881 -164.4106 63.211929 
  -164.5831 63.124149 -164.36079 63.066101 -164.3139 63.01693 
  -164.32581 63.003319 -164.5378 63.03249 -164.7011 63.0186 
  -164.7675 62.969151 -164.8719 62.823601 -164.76421 62.78944 
  -164.8875 62.78138 -164.80811 62.61832 -164.7681 62.61499 
  -164.6584 62.674431 -164.4792 62.745819 -164.57091 62.68277 
  -164.84 62.578041 -164.8522 62.55999 -164.7897 62.534988 
  -164.8333 62.481659 -164.73779 62.491379 -164.67329 62.459148 
  -164.5903 62.456379 -164.57359 62.42527 -164.60831 62.43166 
  -164.8586 62.474709 -164.8739 62.536098 -165.0808 62.529709 
  -165.3092 62.403599 -165.3356 62.360271 -165.6797 62.135269 
  -165.7561 62.01527 -165.745 61.973598 -165.6122 61.872211 
  -165.59641 61.847488 -165.8492 61.830818 -166.09669 61.80999 
  -165.99969 61.727211 -165.78889 61.67915 -166.14391 61.638882 
  -166.14751 61.68832 -166.16251 61.713871 -166.19611 61.58276 
  -166.1145 61.489159 -166.0573 61.498878 -166.0786 61.534161 
  -165.8736 61.549709 -165.7608 61.479988 -165.7867 61.443321 
  -165.8914 61.426102 -165.91859 61.389992 -165.8425 61.310551 
  -165.6089 61.280819 -165.63831 61.173038 -165.59309 61.108879 
  -165.49361 61.07526 -165.35719 61.076931 -165.3414 61.157211 
  -165.405 61.197491 -165.39861 61.217209 -165.222 61.274712 
  -165.28951 61.32888 -165.19501 61.4086 -164.86031 61.53194 
  -164.71609 61.625542 -164.69591 61.595539 -165.1756 61.396099 
  -165.15469 61.35915 -165.257 61.32832 -165.1972 61.31749 
  -165.2186 61.25555 -165.28439 61.224831 -165.3647 61.19582 
  -165.2119 61.149151 -165.1442 61.15971 -165.12531 61.20499 
  -165.0625 61.21138 -165.185 61.1236 -165.1058 61.077209 
  -165.01221 61.058041 -164.9933 61.11277 -164.7784 61.119431 
  -164.7834 61.09943 -164.9395 61.084991 -164.94749 61.013599 
  -165.1317 61.004429 -165.1947 60.966381 -165.1353 60.921379 
  -165.0495 60.908039 -164.94859 60.951931 -164.8511 60.944439 
  -164.8017 60.897491 -164.7281 60.932209 -164.6095 60.922771 
  -164.5795 60.89526 -164.5575 60.850819 -163.95779 60.855549 
  -163.8011 60.9711 -163.6689 60.989429 -163.6983 60.964161 
  -163.75591 60.93388 -163.5753 60.912491 -163.66859 60.865551 
  -163.8708 60.874149 -163.91451 60.845268 -163.72391 60.840549 
  -163.4097 60.756649 -163.46919 60.751381 -163.4231 60.709991 
  -163.4514 60.6786 -163.66949 60.587212 -163.7995 60.581379 
  -163.8353 60.631378 -163.8094 60.74971 -163.87061 60.774712 
  -164.04201 60.756378 -164.1297 60.663319 -164.2686 60.647209 
  -164.4061 60.553051 -164.4406 60.566101 -164.2184 60.688881 
  -164.28529 60.789989 -164.6808 60.82777 -164.69749 60.847488 
  -164.6356 60.907211 -164.70329 60.90971 -164.8392 60.86694 
  -164.94591 60.924431 -164.957 60.899429 -164.8698 60.848881 
  -164.88091 60.82943 -165.0334 60.78027 -164.9825 60.721661 
  -165.0045 60.701099 -165.20219 60.62138 -165.3759 60.57999 
  -165.4203 60.544708 -165.35001 60.508881 -164.9836 60.544159 
  -164.97141 60.511929 -165.14281 60.43943 -164.9742 60.335541 
  -164.7408 60.2911 -164.6512 60.32732) 
#(-146.58501 60.243038 -146.097 60.392769 -146.1358 60.41666 
  -146.15469 60.435551 -146.34 60.407211 -146.3575 60.42527 
  -146.3864 60.477211 -146.6153 60.473598 -146.70889 60.40221 
  -146.7159 60.358879 -146.63921 60.335819 -146.59219 60.3736 
  -146.485 60.36388 -146.67751 60.287769 -146.66701 60.267769 
  -146.58501 60.243038) #(-68.361954 60.225819 -68.251419 60.23082 
  -67.934464 60.321659 -67.806122 60.417488 -67.80336 60.463039 
  -67.948624 60.561378 -68.035278 60.5811 -68.12973 60.570541 
  -68.378082 60.310261 -68.393341 60.249149 -68.361954 60.225819) 
#(-45.392231 60.17971 -45.190571 60.260269 -45.135288 60.343601 
  -45.152241 60.376381 -45.353901 60.382488 -45.396679 60.202492 
  -45.392231 60.17971) #(19.761391 60.072208 19.957781 60.089432 
  20.050831 60.08971 20.04417 60.17194 19.945829 60.18082 
  19.921671 60.220539 20.01639 60.181381 19.972219 60.2686 
  20.021111 60.263321 20.03722 60.298321 20.055 60.188881 
  20.089161 60.227772 20.105829 60.221371 20.08555 60.17416 
  20.171671 60.163879 20.2775 60.274151 20.14139 60.33054 
  19.9275 60.349991 19.90583 60.39999 19.780001 60.349152 
  19.85083 60.312481 19.898609 60.33971 19.93528 60.282768 
  19.82111 60.193878 19.7925 60.19138 19.786381 60.299709 
  19.68528 60.263882 19.648331 60.256649 19.761391 60.072208) 
#(22.472771 59.996929 22.576941 60.004429 22.736111 60.00304 
  22.839161 60.096371 22.83555 60.13805 22.953609 60.287769 
  22.81555 60.224991 22.45166 60.184711 22.443609 60.213329 
  22.421671 60.143879 22.597771 60.131649 22.42416 60.108318 
  22.472771 59.996929) #(-44.631008 60.737492 -44.775291 60.650829 
  -44.76918 60.60165 -44.928902 60.488319 -44.845852 60.468319 
  -44.940289 60.360821 -44.927792 60.324429 -45.08363 60.28027 
  -45.180012 60.21249 -45.200291 60.16637 -44.925838 60.20388 
  -44.466671 60.561378 -44.47612 60.509708 -44.716671 60.32832 
  -44.730572 60.274429 -44.81279 60.243038 -44.8339 60.20388 
  -44.768341 60.218319 -44.76112 60.197769 -44.82473 60.189991 
  -45.138069 60.108601 -45.161961 60.078602 -45.105289 60.06638 
  -45.103901 60.103321 -44.944462 60.07555 -44.96973 60.03194 
  -44.83556 60.025829 -44.927509 60.107769 -44.88612 60.15332 
  -44.846951 60.142769 -44.884739 60.113602 -44.76112 59.992489 
  -44.712791 59.996929 -44.696678 60.094151 -44.666119 60.101101 
  -44.664459 60.004429 -44.610851 59.98138 -44.55196 60.006378 
  -44.443901 60.15276 -44.309181 60.150269 -44.26223 60.191662 
  -44.317791 60.22971 -44.235008 60.220829 -44.218899 60.259159 
  -44.2714 60.32777 -44.245289 60.333321 -44.15807 60.249989 
  -44.080841 60.286381 -44.10112 60.384159 -44.05862 60.355259 
  -44.052231 60.28249 -44.17057 60.192211 -44.09668 60.184158 
  -43.660011 60.146931 -43.6264 60.189709 -43.587791 60.135269 
  -43.124458 60.082489 -43.093899 60.1161 -43.209728 60.13443 
  -43.199181 60.168598 -43.116959 60.1436 -43.110008 60.176659 
  -43.30307 60.22443 -43.123901 60.238041 -43.17696 60.274429 
  -43.105011 60.306931 -43.132229 60.326649 -43.292789 60.352489 
  -43.165852 60.351101 -43.170559 60.377209 -43.3064 60.39526 
  -43.402241 60.369991 -43.35862 60.32777 -43.434181 60.35582 
  -43.559181 60.31554 -43.592789 60.31805 -43.313061 60.436939 
  -43.341671 60.456379 -43.753342 60.52055 -43.78529 60.443878 
  -43.830009 60.44582 -43.803619 60.4911 -43.851681 60.53915 
  -44.193619 60.58527 -44.196121 60.59943 -43.630009 60.548599 
  -43.620289 60.562771 -43.71056 60.69249 -43.67445 60.705818 
  -43.64418 60.6236 -43.53529 60.531651 -43.201962 60.46471 
  -43.14529 60.482769 -43.317509 60.54443 -43.07835 60.498051 
  -43.026951 60.519428 -43.14418 60.537769 -42.98196 60.539989 
  -42.875851 60.5811 -43.142509 60.60387 -42.83363 60.60416 
  -42.76556 60.66888 -42.787231 60.687481 -42.89806 60.642208 
  -43.009178 60.626099 -43.274448 60.670551 -42.910568 60.652489 
  -42.82056 60.694149 -42.787231 60.744991 -43.110291 60.795551 
  -43.26363 60.775269 -43.27306 60.803051 -42.80946 60.79916 
  -42.790009 60.820271 -43.11195 60.86916 -43.480572 60.907768 
  -43.48251 60.938599 -43.03751 60.883041 -42.728901 60.92749 
  -42.801399 60.949162 -42.793339 60.986099 -42.78529 61.017769 
  -42.696678 60.975269 -42.661671 60.997761 -42.764729 61.038601 
  -42.74057 61.063042 -43.009178 61.049992 -43.004459 61.08305 
  -43.586399 61.119709 -43.597511 61.134991 -43.411961 61.12999 
  -42.630009 61.09832 -42.69223 61.136662 -43.128342 61.203041 
  -42.765011 61.18166 -42.58918 61.216099 -42.9039 61.24971 
  -42.775291 61.27388 -42.893341 61.305271 -43.143902 61.32193 
  -43.24474 61.34026 -43.158352 61.345268 -42.64806 61.285549 
  -42.691399 61.308319 -42.579731 61.32193 -42.50473 61.373878 
  -42.43639 61.406101 -42.413898 61.427761 -42.527241 61.440819 
  -42.531681 61.529709 -42.936119 61.52388 -43.079922 61.592831) 
#(23.22497 59.924999 23.150551 59.933319 23.10778 59.968319 
  23.22472 60.003319 23.25 60.038601 23.04944 60.036098 
  22.972219 60.09193 22.87944 60.150829 23.06222 60.331928 
  23.05583 60.353321 22.64222 60.220268 22.590269 60.229988 
  22.44722 60.244431 22.63139 60.3811 22.56694 60.365551 
  22.476669 60.400269 22.285271 60.37138 22.175831 60.431381 
  22.03167 60.442211 21.9375 60.521381 21.8375 60.518318 
  21.874161 60.472759 21.783609 60.481659 21.799999 60.566929 
  21.844999 60.587212 21.83194 60.622761 21.67028 60.54332 
  21.628611 60.488602 21.559441 60.484711 21.58333 60.516102 
  21.41083 60.582211 21.46583 60.60582 21.395281 60.636929 
  21.355 60.683601 21.441669 60.69693 21.389441 60.746101 
  21.319719 60.863041 21.42333 60.86388 21.42416 60.906101 
  21.29673 61.057281) #(-43.553619 59.91888 -43.49501 60.00721 
  -43.487789 60.05666 -43.198341 59.988041 -43.142509 60.01638 
  -43.15057 60.040272 -44.088902 60.17416 -44.131119 60.146099 
  -44.116959 60.102772 -43.93446 60.044991 -43.704731 60.063881 
  -43.899731 60.013882 -43.912231 59.993881 -43.817791 59.965549 
  -43.686401 59.948601 -43.678341 59.967491 -43.654171 59.989429 
  -43.623901 59.9286 -43.553619 59.91888) 
#(-1.268889 59.851101 -1.378056 59.90638 -1.263056 60.10693 
  -1.2736109 60.187481 -1.3316669 60.201099 -1.350278 60.24332 
  -1.393611 60.24332 -1.358333 60.19249 -1.453889 60.152489 
  -1.526945 60.194439 -1.469722 60.21582 -1.631389 60.214432 
  -1.691667 60.288319 -1.628334 60.307209 -1.557778 60.28693 
  -1.413056 60.32082 -1.361667 60.283329 -1.345834 60.339989 
  -1.259167 60.350819 -1.434167 60.423321 -1.443889 60.484711 
  -1.61 60.474152 -1.601944 60.492489 -1.511111 60.55415 
  -1.438611 60.502769 -1.386945 60.509991 -1.4763891 60.54137 
  -1.329722 60.61694 -1.294445 60.6311 -1.317222 60.527489 
  -1.355454 60.40707 -1.236945 60.439159 -1.294445 60.464989 
  -1.2111109 60.493599 -1.190556 60.466099 -1.154722 60.421101 
  -1.231945 60.40527 -1.095834 60.41637 -1.121667 60.38443 
  -1.061111 60.385818 -1.09 60.3461 -1.1705559 60.347488 
  -1.0908329 60.310822 -1.1277781 60.271381 -1.200556 60.263321 
  -1.1805561 60.228039 -1.1950001 60.175541 -1.141667 60.185822 
  -1.1725 60.134159 -1.2025 59.979431 -1.248333 59.993038 
  -1.268889 59.851101) #(23.22497 59.924999 23.319441 60.02499 
  23.338329 60.019989 23.257219 59.91943 23.159161 59.91721 
  23.16555 59.886101 22.934719 59.840549 22.909719 59.804989 
  23.25305 59.843601 23.21389 59.884159 23.346939 59.927761 
  23.457781 60.027489 23.54611 60.067211 23.479441 60.00721 
  23.434441 59.95055 23.701941 59.95443 24.014999 60.037491 
  24.014999 60.004162 24.16111 60.043049 24.366659 60.06805 
  24.344999 60.025829 24.32333 59.992489 24.46055 60.045269 
  24.41333 59.9911 24.48222 59.991379 24.602501 60.117489 
  24.5875 60.12888 24.55389 60.15443 24.671391 60.100552 
  24.842779 60.192211 24.85778 60.15443 24.85083 60.136662 
  24.965 60.14138 24.9825 60.20026 25.024441 60.201382 
  25.01639 60.17194 25.031111 60.144989 25.195271 60.186378 
  25.204439 60.24221 25.37833 60.23999 25.51889 60.25555 
  25.526939 60.323879 25.672501 60.36277 25.705 60.338871 
  25.65361 60.29166 25.78389 60.238041 25.780279 60.272209 
  25.763611 60.311649 25.887501 60.24165 25.92861 60.2486 
  25.90222 60.285549 25.915279 60.35582 25.838051 60.4011 
  25.996111 60.344711 26.08305 60.294991 26.11166 60.330269 
  26.00333 60.39193 26.046671 60.415821 25.94083 60.466648 
  25.936939 60.483051 26.06111 60.42387 26.18833 60.409988 
  26.34638 60.372761 26.48222 60.436939 26.461941 60.507488 
  26.615549 60.64027 26.695271 60.64082 26.753889 60.571659 
  26.594999 60.598049 26.48004 60.474522 26.514441 60.440269 
  26.576111 60.45026 26.699711 60.413601 26.79472 60.48415 
  26.967489 60.445271 27.040279 60.54166 27.14583 60.521648 
  27.214439 60.55471 27.44639 60.46138 27.473049 60.476379 
  27.487221 60.506939 27.62611 60.466648 27.60667 60.5061 
  27.683331 60.51749 27.648609 60.488041 27.751659 60.500542 
  27.735001 60.551659 27.774719 60.573879 27.794769 60.547562) 
#(-43.912231 59.7911 -43.8414 59.808041 -43.781399 59.89082 
  -43.763069 59.876659 -43.800571 59.844711 -43.775291 59.813599 
  -43.74918 59.84193 -43.64806 59.847488 -43.638069 59.868038 
  -43.748901 59.921379 -43.976398 59.975269 -44.107792 59.869991 
  -44.115841 59.829151 -44.061958 59.800541 -43.902241 59.886929 
  -43.93251 59.823879 -43.912231 59.7911) 
#(176.97591 62.865971 177.04021 62.757488 176.9294 62.704708 
  176.9263 62.66832 176.9733 62.62804 177.2477 62.583881 
  177.23441 62.56805 176.68111 62.501659 176.69299 62.540272 
  176.6297 62.512211 176.6311 62.46582 176.4547 62.415539 
  175.3916 62.1161 175.24879 62.161098 175.2413 62.045551 
  175.1644 62.013599 174.7877 61.951931 174.59689 61.975819 
  174.7247 61.883598 174.65581 61.84943 174.1938 61.811939 
  174.0883 61.842209 174.0069 61.812481 174.0583 61.76944 
  174.1075 61.77776 173.8055 61.649429 173.77721 61.69693 
  173.5594 61.75082 173.5238 61.72332 173.48911 61.556099 
  173.3058 61.529148 173.2805 61.45499 173.1366 61.39526 
  173.063 61.391392 172.858 61.47028 172.7169 61.424431 
  172.9352 61.343891 172.9294 61.31776 172.8647 61.275269 
  172.6627 61.327492 172.7744 61.26638 172.65331 61.193321 
  172.5838 61.186649 172.3494 61.228321 172.33881 61.209148 
  172.4236 61.136101 172.263 61.127491 172.4597 61.071381 
  172.478 61.056931 172.3533 61.006939 172.0099 61.097488 
  172.1255 61.03471 172.2005 60.966648 172.1927 60.94693 
  172.11771 60.939991 172.0905 60.897491 172.0099 60.848881 
  171.9769 60.947208 171.94971 60.943321 171.9472 60.84499 
  171.53661 60.800819 171.6324 60.743599 171.6116 60.73415 
  171.4686 60.722759 171.4577 60.751099 171.3925 60.774712 
  171.3577 60.624981 171.1622 60.551102 170.7336 60.516651 
  170.75439 60.48888 170.80721 60.492771 170.78239 60.44138 
  170.64191 60.417488 170.5938 60.446659 170.5125 60.436649 
  170.65331 60.357769 170.6577 60.320541 170.49609 60.259991 
  170.4575 60.154709 170.39 59.955818 170.24879 59.909431 
  170.21471 59.918598 170.0764 60.03249 169.9352 60.06554 
  169.84441 60.174992 169.8497 60.216381 169.9716 60.224991 
  169.90131 60.251659 169.82471 60.233051 169.7397 60.288601 
  169.7072 60.403599 169.6797 60.420818 169.5258 60.464161 
  169.24879 60.560261 169.3705 60.566101 169.3325 60.598049 
  169.21021 60.622761 169.14661 60.55999 168.63831 60.555271 
  168.3138 60.594151 167.8239 60.509708 167.7538 60.54221 
  167.75909 60.48637 167.5439 60.438599 167.4716 60.46138 
  167.4669 60.42749 167.4155 60.423599 167.3347 60.470268 
  167.37109 60.400269 167.3069 60.390541 167.2702 60.363041 
  167.17799 60.353321 167.06689 60.4086 167.0733 60.419991 
  167.02 60.420551 167.0424 60.381378 166.5441 60.002491 
  166.24609 59.83054 166.1033 59.824711 166.0966 59.852489 
  166.1825 60.135269 166.2894 60.205269 166.27161 60.323879 
  166.2336 60.392769 166.31551 60.389709 166.35361 60.42416 
  166.3605 60.4911 166.0011 60.43388 165.9447 60.381939 
  165.6438 60.246658 165.4855 60.2136 165.435 60.250542 
  165.4391 60.186939 165.22659 60.09444 165.17751 60.09943 
  165.1727 60.145821 165.1613 60.16444 165.08521 60.10915 
  164.99609 60.123878 165.0311 60.065269 165.12331 60.085819 
  165.2086 59.98999 165.0038 59.841099 164.8205 59.78054 
  164.793 59.79916 164.7816 59.85638 164.6752 59.996929 
  164.4686 60.11137 164.3214 60.090549 164.3141 60.06443 
  164.3425 60.026371 164.33971 59.9911 164.1433 59.955372 
  164.0963 59.909988 164.1125 59.893318 164.1913 59.853321 
  164.0569 59.868599 164.0408 59.90443 164.2027 59.99165 
  164.0377 60.03138 163.6355 60.045551 163.61971 60.02026 
  163.67661 59.970829 163.7538 59.979431 163.6902 59.89027 
  163.5047 59.898602 163.3602 59.823879) 
#(-147.86079 59.775829 -147.4839 59.861931 -147.44501 59.904991 
  -147.48779 59.936378 -147.4417 59.968319 -147.35201 59.975269 
  -147.3656 60.026661 -147.29781 60.08276 -146.9847 60.24165 
  -146.93781 60.286381 -147.105 60.274429 -147.0153 60.3461 
  -147.1208 60.344151 -147.1122 60.380821 -147.19949 60.34943 
  -147.2061 60.238319 -147.3042 60.225269 -147.40421 60.11137 
  -147.7 59.994709 -147.6675 59.970268 -147.7581 59.94804 
  -147.8017 59.909161 -147.7411 59.893879 -147.895 59.84193 
  -147.89169 59.806381 -147.86079 59.775829) 
#(-166.1931 59.754429 -166.10249 59.758041 -166.0833 59.775829 
  -166.1167 59.811378 -166.2661 59.837769 -165.57091 59.914989 
  -165.5531 59.945271 -165.6692 60.042488 -165.68719 60.298321 
  -165.88029 60.343601 -165.9261 60.31749 -166.0717 60.331661 
  -166.10921 60.410259 -166.1436 60.38055 -166.19141 60.394161 
  -166.39639 60.34082 -166.4053 60.37249 -166.4648 60.38443 
  -166.58279 60.310822 -166.6797 60.324429 -166.80811 60.28027 
  -166.79221 60.238041 -166.8392 60.204708 -166.955 60.224152 
  -167.45081 60.207489 -167.3289 60.127491 -167.3159 60.071659 
  -167.1147 59.995819 -167.0692 60.01527 -166.7469 59.892208 
  -166.2845 59.822491 -166.1931 59.754429) 
#(-147.7256 61.277489 -147.7345 61.212212 -147.69949 61.204151 
  -147.7917 61.16666 -148.04829 60.944988 -147.8653 60.832489 
  -147.7872 60.821659 -147.7464 60.84277 -147.7859 60.92387 
  -147.7036 60.947769 -147.7292 60.887489 -147.6664 60.897491 
  -147.66811 60.853039 -147.5984 60.86499 -147.6031 60.914711 
  -147.6347 60.964989 -147.595 61.023602 -147.5553 61.151932 
  -147.5314 61.129429 -147.4792 61.074162 -147.5258 61.05582 
  -147.5397 60.929989 -147.50861 60.91444 -147.4725 60.99749 
  -147.422 61.009708 -147.4545 60.95554 -147.3786 60.98415 
  -147.43559 60.928879 -147.42081 60.9011 -147.2486 60.936649 
  -147.27251 61.00193 -147.1864 60.951099 -147.1425 60.952209 
  -147.1553 60.984711 -147.01221 61.003319 -146.9747 60.994991 
  -147.0256 60.95055 -146.9353 60.947208 -146.58501 61.131378 
  -146.4239 61.137489 -146.2728 61.11694 -146.24361 61.085541 
  -146.5278 61.083321 -146.6422 61.062481 -146.5939 61.051102 
  -146.57359 61.025829 -146.6678 61.033039 -146.70219 60.975269 
  -146.5833 60.937481 -146.7567 60.955269 -146.72279 60.911652 
  -146.51579 60.81638 -146.30969 60.834991 -146.23109 60.892769 
  -146.08859 60.834148 -146.20779 60.851101 -146.2422 60.833599 
  -146.1992 60.816101 -146.6909 60.74221 -146.63341 60.689159 
  -146.58 60.701931 -146.48579 60.6786 -146.28281 60.774712 
  -146.30389 60.725552 -146.255 60.723598 -146.03281 60.795818 
  -146.01669 60.74332 -146.26109 60.658039 -146.2536 60.638321 
  -146.17419 60.635269 -145.9231 60.706379 -145.92059 60.693321 
  -145.9814 60.65443 -145.95219 60.630821 -145.83611 60.694988 
  -145.8439 60.635818 -145.8356 60.622761 -145.63699 60.67387 
  -145.6194 60.658039 -145.7636 60.5411 -145.8867 60.48637 
  -145.6442 60.464989 -145.3495 60.352211 -145.237 60.361931 
  -144.75391 60.678051 -144.6114 60.715549 -144.63361 60.665821 
  -144.7617 60.663319 -144.8167 60.549431 -144.8764 60.49749 
  -144.87061 60.46471 -144.8242 60.474991 -144.79111 60.48138 
  -144.9364 60.301659 -144.91251 60.286381 -144.8311 60.300541 
  -144.5742 60.185822 -144.18311 60.198601 -144.2506 60.14555 
  -144.0045 60.047771 -144.00861 60.03249 -143.88699 59.990551 
  -143.7867 60.01749 -142.7433 60.110538 -142.2122 60.05666 
  -141.7056 59.95388 -141.3786 60.028049 -141.3828 60.04332 
  -141.4617 60.086102 -141.46919 60.12582 -141.37891 60.137211 
  -141.27969 60.071659 -141.2572 59.989712 -141.2825 59.936378 
  -141.46609 59.89888 -141.4308 59.876099 -140.6508 59.714989 
  -140.2395 59.708599 -139.8345 59.823318 -139.6819 59.93166 
  -139.5822 59.95332 -139.5858 60.003319 -139.5045 60.049431 
  -139.2225 59.86665 -139.1064 59.861931 -139.0553 59.845829 
  -139.2742 59.831379 -139.29449 59.73082 -139.2245 59.6161 
  -139.2653 59.570541 -139.3228 59.58749 -139.33749 59.610821 
  -139.26221 59.622761 -139.3383 59.718601 -139.3364 59.81443 
  -139.2928 59.854988 -139.4431 59.97694 -139.4939 59.982208 
  -139.6156 59.896648 -139.60609 59.847759 -139.4731 59.701931 
  -139.53751 59.672489 -139.5853 59.60387 -139.85229 59.54446) 
#(28.006678 59.481701 28.069441 59.552212 28.06027 59.610271 
  27.99361 59.685551 28.00861 59.758881 28.09638 59.795269 
  28.18722 59.758041 28.222771 59.685822 28.374161 59.661098 
  28.416389 59.695271 28.415001 59.779991 28.445829 59.82999 
  28.526661 59.860538 28.736111 59.78138 28.962219 59.82082 
  29.030279 59.869709 29.03861 59.901932 28.98222 59.926929 
  29.18722 60.006939 29.389441 59.988319 29.898331 59.90527 
  30.18 59.869431 30.2225 59.904148 30.225559 59.959148 
  30.219999 59.989712 29.97139 60.01804 29.93499 60.036652 
  29.884159 60.142769 29.811661 60.171379 29.58 60.198601 
  29.34194 60.163052 29.00333 60.197491 28.79528 60.36694 
  28.78167 60.334148 28.60194 60.38443 28.455 60.538319 
  28.499161 60.558601 28.68889 60.452492 28.708891 60.470268 
  28.658051 60.535549 28.66861 60.575821 28.632771 60.594711 
  28.59528 60.570541 28.553049 60.604431 28.57444 60.64082 
  28.682779 60.61388 28.646391 60.67527 28.73222 60.673599 
  28.728331 60.71944 28.671671 60.738041 28.58139 60.68277 
  28.403891 60.663879 28.38055 60.621101 28.28167 60.596931 
  28.21611 60.536652 27.881941 60.525829 27.86134 60.5616) 
#(25.404591 59.490292 25.545561 59.533871 25.46944 59.648319 
  25.492769 59.66415 25.64278 59.565269 25.70083 59.568321 
  25.715269 59.5886 25.68417 59.627769 25.694441 59.66832 
  25.774719 59.63554 25.793329 59.578602 25.847771 59.574989 
  25.885559 59.625542 25.951111 59.586929 25.992769 59.62999 
  26.096109 59.582211 26.650551 59.553322 26.96472 59.444988 
  27.88055 59.407768 27.96139 59.43082 28.006678 59.481701) 
#(11.78718 59.311871 11.66611 59.595821 11.90278 59.70776 
  11.89111 59.794708 11.81528 59.845821 11.95694 59.896931 
  12.16305 59.896931 12.47694 60.076382 12.49111 60.30138 
  12.58972 60.399151 12.60805 60.46859 12.5875 60.526649 
  12.22916 60.98526 12.29416 61.02943 12.655 61.062481 
  12.85611 61.362492 12.53 61.56609 12.40667 61.573318 
  12.12444 61.728588 12.29583 62.261662 12.21 62.38998 
  12.01194 62.601379 12.08944 62.749432 12.02889 62.89249 
  12.16861 63.01582 11.93639 63.272209 12.195 63.48526 
  12.13944 63.584148 12.32472 63.709431 12.675 63.965542) 
#(11.78748 59.22366 11.79833 59.245258 11.79083 59.30331 
  11.78718 59.311871) #(-151.7408 60.91534 -151.1544 61.056931 
  -151.13451 61.09304 -151.0011 61.185551 -150.5822 61.288601 
  -150.5764 61.360821 -150.5392 61.36499 -150.5464 61.28471 
  -150.47749 61.249439 -149.9958 61.240261 -149.93311 61.264709 
  -149.9059 61.35387 -149.76221 61.442211 -149.60699 61.490822 
  -149.2578 61.499149 -149.2467 61.488041 -149.3936 61.463039 
  -149.8261 61.31638 -149.90469 61.223881 -150.0314 61.198601 
  -150.0569 61.150829 -149.6158 60.990261 -149.14529 60.939159 
  -149.0425 60.879711 -149.04359 60.84444 -149.8364 60.973598 
  -150.0536 60.90554 -150.2711 60.955818 -150.3398 61.03194 
  -150.40919 61.036381 -150.66949 60.963871 -151.052 60.787769 
  -151.40891 60.727489 -151.4164 60.70554 -151.27499 60.53249 
  -151.30389 60.38554 -151.39169 60.360271 -151.3864 60.29887 
  -151.45329 60.189991 -151.67059 60.065269 -151.88091 59.779709 
  -151.8692 59.743881 -151.7809 59.69249 -151.45419 59.618038 
  -151.4422 59.653599 -151.1111 59.774712 -151.0081 59.790539 
  -150.9967 59.772209 -151.2 59.635818 -151.177 59.594151 
  -151.4436 59.528881 -151.4464 59.49971 -151.3856 59.468319 
  -151.38969 59.438042 -151.6736 59.47916 -151.87 59.420551 
  -151.90109 59.396931 -151.8125 59.353321 -151.9306 59.347488 
  -151.98331 59.30582 -151.972 59.271099 -151.8842 59.239712 
  -151.86639 59.209991 -151.75861 59.221661 -151.75861 59.169991 
  -151.7234 59.16082 -151.47639 59.202209 -151.5136 59.22694 
  -151.4025 59.25943 -151.3017 59.21693 -151.10471 59.217491 
  -151.09641 59.242489 -151.2672 59.298321 -151.2422 59.314159 
  -150.99249 59.269428 -151.002 59.22694 -150.9572 59.202209 
  -150.8797 59.263321 -150.9147 59.321098 -150.6064 59.430538 
  -150.57111 59.488602 -150.65469 59.546101 -150.51891 59.600552 
  -150.4917 59.591099 -150.5517 59.533039 -150.54581 59.511101 
  -150.4736 59.464432 -150.2325 59.71804 -150.2175 59.70499 
  -150.3597 59.533039 -150.34309 59.504429 -150.1758 59.53054 
  -150.1911 59.5886 -150.0869 59.588039 -150.11279 59.675819 
  -150.1089 59.695541 -150.0136 59.627491 -149.9567 59.666931 
  -149.92 59.71944 -150.02859 59.767769 -150.0247 59.798599 
  -149.91589 59.77277 -149.7925 59.669708 -149.74361 59.6586 
  -149.75 59.727489 -149.8597 59.850819 -149.7547 59.840549 
  -149.73199 59.960541 -149.6895 59.954151 -149.6436 59.884708 
  -149.6636 59.80415 -149.5972 59.771931 -149.62469 59.739429 
  -149.5258 59.716648 -149.5228 59.736931 -149.6281 59.824711 
  -149.5311 59.926659 -149.4614 59.926929 -149.4431 59.958881 
  -149.4397 60.06776 -149.41701 60.11832 -149.3689 60.115822 
  -149.3503 60.07777 -149.2928 60.009991 -149.2914 59.873051 
  -149.2614 59.874149 -149.1942 60.00526 -149.0775 60.056381 
  -149.03951 60.042488 -149.1011 59.997761 -149.0706 59.961651 
  -148.9292 59.97332 -148.8606 59.931931 -148.74609 59.961651 
  -148.6436 59.921101 -148.54781 59.95554 -148.5239 60.02832 
  -148.4359 59.948879 -148.4086 60.000271 -148.3203 60.174431 
  -148.2939 60.12693 -148.25999 60.116379 -148.16341 60.14304 
  -148.1122 60.194149 -148.12531 60.23444 -148.18359 60.201931 
  -148.2406 60.220268 -148.23421 60.238041 -148.4236 60.17638 
  -148.4353 60.188042 -148.3586 60.23193 -148.3797 60.254162 
  -148.3725 60.28944 -148.3136 60.25193 -148.23219 60.299431 
  -148.2133 60.3386 -148.2392 60.34721 -148.15469 60.34943 
  -148.1245 60.367489 -148.17999 60.41444 -147.9528 60.42971 
  -147.937 60.462212 -147.9975 60.469711 -147.95641 60.504711 
  -148.0417 60.5686 -148.09419 60.601379 -148.1828 60.492771 
  -148.1964 60.544991 -148.2247 60.46138 -148.2661 60.4436 
  -148.3378 60.506378 -148.4631 60.539989 -148.6842 60.448318 
  -148.6761 60.477489 -148.5661 60.539711 -148.4359 60.584709 
  -148.32249 60.536381 -148.19749 60.626099 -148.235 60.681099 
  -148.25281 60.740551 -148.2758 60.75499 -148.4211 60.625271 
  -148.44341 60.658871 -148.3578 60.749439 -148.3942 60.77776 
  -148.5242 60.758598 -148.60001 60.695541 -148.7 60.676659 
  -148.6311 60.750271 -148.4722 60.788052 -148.4628 60.810551 
  -148.31219 60.841381 -148.3008 60.870541 -148.3253 60.968319 
  -148.2442 60.951099 -148.1653 61.04665 -148.24249 61.06221 
  -148.4178 60.983051 -148.44971 60.994991 -148.3567 61.045818 
  -148.3911 61.061939 -148.1386 61.11665 -148.0764 61.018879 
  -148.0347 61.028599 -147.7256 61.277489) 
#(165.6488 62.4505 164.7014 62.583881 164.5666 62.690819 
  163.3244 62.556099 163.2244 62.52388 163.2236 62.469711 
  163.1644 62.44471 163.3502 62.372211 163.3477 62.352211 
  163.1313 62.289989 163.0775 62.205818 163.138 62.118599 
  163.0883 62.10194 163.1669 62.0611 163.0374 61.968319 
  163.0508 61.913052 162.96049 61.82526 162.9789 61.78138 
  163.30721 61.716099 163.3105 61.68832 163.27859 61.659161 
  163.0661 61.601379 163.08859 61.551659 163.00549 61.518318 
  162.8772 61.59304 162.9297 61.673321 162.8316 61.720539 
  162.6597 61.695541 162.6349 61.672211 162.6716 61.646099 
  162.7477 61.631649 162.7599 61.60387 162.7238 61.601379 
  162.5361 61.661652 162.40331 61.672489 162.2874 61.589432 
  161.9286 61.377769 161.883 61.42944 161.8869 61.374439 
  161.8513 61.349991 161.80051 61.380821 161.7422 61.308041 
  161.56329 61.26693 161.6116 61.23666 161.3044 61.076931 
  161.21609 61.06554 161.1658 61.000542 160.89439 60.903599 
  160.7836 60.73444 160.6705 60.776371 160.4319 60.716648 
  160.4052 60.746101 160.2524 60.619991 160.133 60.58971 
  160.12801 60.684711 160.1852 60.688881 160.2247 60.784431 
  160.15829 60.831379 160.2413 60.892769 160.3519 60.922211 
  160.40021 61.03138 160.3569 61.061939 160.16409 61.050819 
  159.8577 60.930271 159.78439 60.952492 159.9769 61.121101 
  159.90691 61.230259 159.87109 61.264709 159.7455 61.25082 
  159.84 61.311939 159.8875 61.297489 159.9122 61.308319 
  159.8905 61.328602 159.97079 61.398602 160.0305 61.380821 
  160.0722 61.4561 160.0083 61.461929 160.19659 61.54137 
  160.21381 61.598049 160.2838 61.662491 160.2372 61.702492 
  160.37379 61.778049 160.3652 61.9086 160.3166 61.949989 
  160.0963 61.879162 159.83749 61.712212 159.75301 61.725269 
  159.5311 61.662769 159.49049 61.685551 159.5305 61.822491 
  159.4458 61.774429 159.3344 61.831928 159.3889 61.871658 
  159.3586 61.89304 159.1622 61.922211 158.8799 61.885818 
  158.8472 61.81776 158.618 61.83305 158.5188 61.79166 
  158.4377 61.824429 158.2977 61.821659 158.1011 61.73999 
  157.9688 61.750542 157.5166 61.80666 157.37131 61.75943 
  157.3694 61.706379 157.2619 61.716099 157.0211 61.647209 
  156.9747 61.599152 156.8344 61.529991 156.69299 61.53138 
  156.6324 61.41832 156.6627 61.211651 156.4166 61.181931 
  156.1599 61.050819 155.9138 60.887211 155.9005 60.721931 
  155.48441 60.586929 155.4783 60.53582 155.34109 60.52388 
  154.935 60.357769 154.5291 60.046379 154.4686 59.871658 
  154.39549 59.84721 154.4066 59.89526 154.23019 59.875542 
  154.2289 59.71693 154.3633 59.571098 154.2247 59.652489 
  154.0652 59.509708 154.1252 59.454708 154.2916 59.444149 
  154.3819 59.528881 154.403 59.50304 154.3755 59.466099 
  154.4258 59.421101 154.5069 59.435551 154.4297 59.48444 
  154.4222 59.518318 154.44411 59.547771 154.79221 59.477489 
  154.9613 59.495541 155.0377 59.426659 155.14799 59.384159 
  155.19051 59.351101 155.1297 59.286098 155.17799 59.244991 
  155.133 59.21138 155.18381 59.171379 154.7675 59.198318 
  154.74001 59.168049 154.7644 59.11916 154.4447 59.21999 
  154.31441 59.184158 154.34441 59.121658 154.2614 59.079708 
  154.15221 59.09721 154.04111 59.045551 153.99361 59.055538 
  153.81689 59.163052 153.6591 59.19693 153.7439 59.268009) 
#(-2.9111111 58.889431 -2.708333 58.91721 -2.708611 58.96888 
  -2.793334 58.951382 -2.7788889 58.92416 -2.823889 58.928051 
  -2.8097219 58.963039 -2.782778 58.989429 -3.134167 59.00082 
  -3.0191669 59.042759 -3.011111 59.076931 -3.218889 59.148602 
  -3.321389 59.126381 -3.3613889 58.99221 -3.290833 58.94693 
  -3.271111 58.987209 -3.220834 59.024712 -3.238889 58.967491 
  -3.188612 58.909988 -3.041945 58.936378 -2.9111111 58.889431) 
#(11.42029 58.995998 11.42778 58.89304 11.46305 58.883598 
  11.62666 58.909149 11.75111 59.09026 11.73972 59.12859 
  11.78748 59.22366) #(-62.991009 58.8773 -63.071949 58.90276 
  -63.16029 58.82304 -63.3139 58.853321 -63.214741 58.8936 
  -63.17057 58.954708 -63.181122 58.980259 -63.2589 58.959431 
  -63.228901 59.00499 -63.336121 59.02499 -63.133621 59.038052 
  -63.125011 59.055271 -63.256962 59.075821 -63.758621 59.012211 
  -63.796959 59.038601 -63.877781 59.025269 -63.868351 58.95332 
  -63.898621 58.97694 -63.910839 59.03194 -63.94529 59.058319 
  -64.01918 59.014992 -64.043327 59.025829 -63.93446 59.0811 
  -63.688622 59.059429 -63.425838 59.126381 -63.35807 59.19804 
  -63.369999 59.212769 -63.430561 59.201382 -63.458889 59.203041 
  -63.40834 59.250271 -63.38612 59.286098 -63.45557 59.27832 
  -63.533619 59.22332 -63.618061 59.21249 -63.529461 59.27721 
  -63.53529 59.34444 -63.64085 59.361099 -63.741119 59.256378 
  -63.76223 59.265541 -63.715839 59.367489 -64.017242 59.384708 
  -63.78529 59.426102 -63.731682 59.5261 -63.871681 59.56638 
  -63.983898 59.508041 -63.954731 59.546379 -63.868622 59.586651 
  -63.880009 59.61721 -64.011139 59.624981 -64.047523 59.549709 
  -64.118073 59.529709 -64.023361 59.644161 -63.95612 59.636379 
  -63.926399 59.65694 -64.139473 59.678322 -64.1978 59.705269 
  -64.26474 59.787491 -64.180862 59.781651 -64.150574 59.8661 
  -64.137802 59.912769 -64.249741 59.872211 -64.184464 59.911381 
  -64.201973 59.934158 -64.251419 59.939159 -64.291412 59.951649 
  -64.150299 59.985271 -64.173897 60.02832 -64.307243 60.045269 
  -64.224747 59.99527 -64.352249 59.9711 -64.368073 59.920269 
  -64.51474 59.897491 -64.392807 59.949429 -64.416412 59.983601 
  -64.590302 60.001659 -64.382523 60.02026 -64.415024 60.070271 
  -64.372238 60.086102 -64.392242 60.124149 -64.803093 59.97971 
  -64.805008 60.00721 -64.492798 60.110821 -64.376968 60.160549 
  -64.40419 60.194149 -64.560852 60.17416 -64.468353 60.233318 
  -64.634193 60.268879 -64.752808 60.2286 -64.72113 60.261101 
  -64.613083 60.28944 -64.381973 60.242489 -64.60141 60.33276 
  -64.857529 60.35944 -64.834183 60.32304 -64.956413 60.252209 
  -64.876129 60.202492 -65.063629 60.09277 -65.027237 60.06749 
  -65.071693 60.035259 -65.110023 60.043049 -65.063629 59.974152 
  -65.128082 59.951382 -65.143631 59.898602 -65.134193 59.868599 
  -65.226967 59.877209 -65.115593 59.793049 -65.325302 59.845829 
  -65.355583 59.830269 -65.489967 59.790569) 
#(5.4562778 58.750648 5.5752769 58.892769 5.5502782 58.913879 
  5.5480552 58.952492 5.6108332 58.90443 5.626111 58.930271 
  5.5252771 58.985271 5.563333 59.031101 5.7147222 58.970829 
  5.7127771 58.865822 5.8197222 58.933601 5.874999 58.956928 
  6.1302781 58.833881 6.2302771 58.838329 6.0880551 58.865822 
  6.059444 58.902489 6.12361 58.959991 6.3813891 59.01582 
  6.1463881 58.9911 6.0274992 58.901932 5.9741659 58.962212 
  6.0236111 58.99194 6.0152769 59.015541 5.9283328 59.015541 
  5.8663878 59.072208 5.8872209 59.096371 6.1277771 59.14555 
  6.0094442 59.14304 6.0072222 59.16444 6.1113882 59.2286 
  6.455277 59.324989 6.1158328 59.260818 6.0902781 59.30415 
  6.184999 59.308601 6.1794438 59.320541 5.9955549 59.329708 
  6.0449991 59.381649 6.185833 59.428322 6.2355552 59.50499 
  6.4688878 59.555271 6.246666 59.52055 6.2472219 59.540539 
  6.1474991 59.450821 6.0113888 59.398319 5.9852772 59.425819 
  5.9888892 59.37471 5.9261098 59.352772 5.8769441 59.408871 
  5.896667 59.447208 6.0799999 59.466099 6.1399989 59.484711 
  5.8844442 59.478321 5.8052769 59.53249 5.6505551 59.399429 
  5.789444 59.428879 5.8619442 59.37693 5.856667 59.345539 
  5.622499 59.287209 5.6100001 59.299992 5.6486111 59.327209 
  5.5825 59.394711 5.5724988 59.319988 5.5111098 59.27499 
  5.438611 59.293598 5.4394441 59.39888 5.415 59.393879 
  5.4069438 59.321098 5.3794441 59.296101 5.3380551 59.417488 
  5.3266659 59.368038 5.3002772 59.33971 5.1947222 59.436378 
  5.1797218 59.514431 5.2733331 59.59193 5.3833332 59.646381 
  5.4077768 59.59082 5.4347219 59.623322 5.392777 59.663319 
  5.4919438 59.73082 5.495832 59.5686 5.414721 59.538319 
  5.4108319 59.503319 5.5025001 59.53054 5.541666 59.58054 
  5.5241661 59.617489 5.5555549 59.67194 5.5938878 59.67527 
  5.7611098 59.60638 5.7713881 59.646648 5.8780551 59.6511 
  5.7552781 59.66415 5.745832 59.682491 5.8402781 59.73138 
  6.0666671 59.743881 6.313055 59.852772 5.9733319 59.75304 
  5.9324999 59.78693 5.9638882 59.813042 5.9524989 59.855259 
  5.919167 59.788601 5.8188891 59.77026 5.6697221 59.849991 
  5.7436099 59.911652 5.9599991 59.951649 5.9841661 59.97443 
  5.9536099 60.002769 6.0341659 60.066929 6.2430549 60.11137 
  6.2588878 60.1586 6.1136098 60.102211 6.0780549 60.163052 
  6.079721 60.195271 6.1555548 60.219711 6.20472 60.295551 
  6.5366659 60.42971 6.6405549 60.410259 6.579721 60.341648 
  6.5044441 60.113602 6.5244441 60.081928 6.5774989 60.271381 
  6.7022219 60.400269 6.8338881 60.473598 7.021667 60.474709 
  7.104444 60.499149 6.8994441 60.5061 7.0136108 60.58749 
  6.9524989 60.57082 6.849999 60.489712 6.6205549 60.42944 
  6.5911102 60.45443 6.6313891 60.476101 6.686666 60.517208 
  6.4755549 60.444439 6.2361112 60.371929 6.1186099 60.368038 
  6.187778 60.347759 6.143332 60.306099 6.1602769 60.280819 
  6.1211109 60.236931 6.0033331 60.26804 5.9575 60.206379 
  5.852777 60.153599 5.8786111 60.04166 5.7566662 59.985821 
  5.704721 60.006939 5.6905551 60.06638 5.768611 60.059711 
  5.7947221 60.088871 5.7075 60.0886 5.7244439 60.139992 
  5.789721 60.207489 5.5791659 60.14027 5.5444441 60.156101 
  5.7075 60.234711 5.6025 60.258041 5.5683331 60.24638 
  5.6697221 60.345539 5.665833 60.366379 5.581388 60.288319 
  5.4016671 60.131939 5.3163881 60.19693 5.3386111 60.21777 
  5.2227769 60.20388 5.309999 60.26305 5.168056 60.27721 
  5.166389 60.3111 5.2252769 60.318321 5.1486111 60.336102 
  5.145 60.366379 5.2038879 60.392208 5.2969441 60.389149 
  5.2525001 60.428051 5.2358332 60.490822 5.2927771 60.52499 
  5.3205552 60.519161 5.4944439 60.41943 5.6336112 60.415272 
  5.7136111 60.46999 5.7027769 60.5536 5.7422218 60.65276 
  5.6619439 60.70332 5.6819439 60.755821 5.5925002 60.69582 
  5.5302768 60.69138 5.5161099 60.619991 5.2613888 60.553051 
  5.1986098 60.577492 5.0933328 60.660549 5.2227769 60.622761 
  4.9675002 60.783039 4.9972219 60.80471 5.2980552 60.711651 
  5.3147221 60.668598 5.373888 60.63443 5.3655548 60.674431 
  5.4058328 60.701931 5.2436099 60.758041 5.248333 60.78194 
  5.520833 60.872211 5.4838891 60.907211 5.145555 60.80777 
  5.0355549 60.85165 4.9927769 60.96027 5.084167 60.944439 
  5.0772219 60.885269 5.0977769 60.87471 5.103889 60.92416 
  5.081388 60.966648 5.0025001 60.99749 5.0241661 61.049992 
  5.1155548 61.072769 5.4119439 61.022209 5.4830551 61.05666 
  5.893888 61.124149 6.3722219 61.061939 6.351944 61.032211 
  6.3722219 61.00832 6.4219441 61.07304 6.5469441 61.094711 
  6.6086111 61.170818 6.855 61.12804 6.8672218 61.087769 
  6.9536099 61.08305 6.9822221 61.049709 6.999166 60.99332 
  6.870832 60.93388 7.0250001 60.974152 7.1283331 60.92749 
  7.1138892 60.860271 7.1627769 60.899429 7.1675 60.944149 
  7.0719442 60.974709 6.996666 61.08527 7.02 61.100552 
  7.3827772 61.11166 7.3586111 61.15332 7.6141658 61.19693 
  7.6933331 61.227489 7.580832 61.205269 7.3627782 61.20277 
  7.3038878 61.29443 7.3641658 61.36499 7.519444 61.45026 
  7.3430548 61.388321 7.313333 61.351379 7.2402768 61.290821 
  7.3072209 61.215549 7.3605552 61.186378 7.292222 61.158039 
  7.2238879 61.181099 7.1486111 61.142769 6.9266658 61.11694 
  6.918611 61.144989 7.0044441 61.17749 6.6944442 61.183041 
  6.5597219 61.229431 6.6966658 61.345829 6.7036099 61.401371 
  6.664166 61.337769 6.4930549 61.260269 6.5380549 61.20388 
  6.4611111 61.207211 6.5105548 61.151371 6.476666 61.127491 
  6.24861 61.13332 6.1763892 61.17915 5.8855548 61.15749 
  5.3830552 61.068878 5.061388 61.15694 5.084722 61.188881 
  5.2236109 61.16888 5.1891661 61.20805 4.9880552 61.21944 
  4.9861112 61.255821 4.996388 61.279148 5.2355552 61.334709 
  5.2938881 61.307491 5.311388 61.25555 5.3388882 61.259991 
  5.3202772 61.31805 5.2547221 61.34193 5.331388 61.349709 
  5.3836112 61.374149 5.040555 61.31776 4.999722 61.352772 
  5.0058331 61.382488 5.043056 61.399151 4.9488888 61.412769 
  5.1891661 61.470539 5.5274992 61.4286 5.5505552 61.445541 
  5.8049989 61.45277 5.667222 61.49416 5.5444441 61.457211 
  5.1713891 61.504429 5.1374998 61.536098 5.3558331 61.55444 
  5.2236109 61.569149 5.1602769 61.594151 5.3427768 61.57555 
  5.4244442 61.583599 5.2191658 61.627209 4.9633331 61.63805 
  4.9655552 61.719151 5.060555 61.746101 5.1319442 61.706928 
  5.1541662 61.731659 5.0727782 61.75555 5.105 61.77776 
  5.293611 61.863602 5.4099998 61.911381 5.5958328 61.89526 
  5.7447209 61.842209 5.6830549 61.837212 5.626389 61.808601 
  5.8855548 61.84832 5.9472222 61.83527 5.9211111 61.761929 
  5.9730549 61.83054 6.0161099 61.822491 6.102221 61.76749 
  6.1813889 61.771381 6.061944 61.83054 6.376389 61.80666 
  6.518332 61.808601 6.5861602 61.849609 6.6583328 61.869709 
  6.7580552 61.8461 6.8155551 61.872761 6.6747222 61.894711 
  6.476388 61.82555 6.0161099 61.86665 5.8241658 61.864712 
  5.960278 61.909988 5.519444 61.927212 5.2777781 61.906651 
  5.125555 61.90638 5.1494441 61.974152 5.4011111 62.021648 
  5.228055 62.085819 5.124999 62.12888 5.0736098 62.153049 
  5.0863891 62.186649) #(22.565269 58.686649 22.666941 58.705269 
  22.775829 58.8186 22.82917 58.818321 22.784439 58.775829 
  22.884439 58.779709 22.89889 58.834431 23.02166 58.820541 
  23.04805 58.84444 22.92972 58.982491 22.733891 59.001381 
  22.698601 59.019989 22.71583 59.069149 22.640499 59.081791 
  22.53639 59.024712 22.042219 58.939991 22.077499 58.921379 
  22.381941 58.886929 22.445551 58.838039 22.476391 58.756939 
  22.469721 58.703602 22.565269 58.686649) 
#(-161.0853 58.55471 -160.9117 58.56971 -160.7097 58.79221 
  -160.9478 58.740261 -161.07471 58.686378 -161.08501 58.631649 
  -161.0853 58.55471) #(163.4369 58.47443 163.3885 58.56049 
  163.58549 58.647209 163.74049 58.818878 163.7438 58.88026 
  163.8158 58.956661 163.9052 59.002769 163.8839 59.01054 
  163.69769 59.007771 163.9539 59.035259 164.1427 59.085541 
  164.43941 59.20554 164.5761 59.231659 164.71021 59.037491 
  164.66051 58.977489 164.67999 58.904991 164.6375 58.878319 
  164.38969 58.85915 163.5789 58.579708 163.50079 58.512489 
  163.4369 58.47443) #(-77.886467 60.824551 -77.966141 60.79137 
  -77.858337 60.791931 -77.890289 60.749989 -77.781403 60.787769 
  -77.515839 60.83054 -77.738892 60.767769 -77.696953 60.76527 
  -77.610001 60.75555 -77.829727 60.633598 -77.670288 60.549709 
  -77.521667 60.570271 -77.41362 60.544159 -77.69223 60.466648 
  -77.748062 60.408039 -77.594452 60.315269 -77.623611 60.268318 
  -77.470573 60.213329 -77.551392 60.19471 -77.406113 60.126659 
  -77.58168 60.118881 -77.626106 60.063042 -77.347778 60.05888 
  -77.313904 60.012489 -77.236687 59.994709 -77.386139 59.94305 
  -77.363892 59.89082 -77.295288 59.79443 -77.541946 59.743881 
  -77.493057 59.709148 -77.541672 59.694988 -77.452507 59.663052 
  -77.440567 59.599709 -77.344177 59.576931 -77.353897 59.563599 
  -77.464737 59.587212 -77.473068 59.634991 -77.517227 59.66082 
  -77.670288 59.674431 -77.732224 59.70776 -77.801392 59.67527 
  -77.76973 59.644161 -77.72139 59.539711 -77.874451 59.490551 
  -77.848618 59.446098 -77.89502 59.437771 -77.897232 59.397209 
  -77.723892 59.403599 -77.801117 59.368599 -77.774437 59.328041 
  -78.103897 59.205818 -78.086937 59.156651 -78.153633 59.15221 
  -78.127792 59.108318 -78.22084 59.102211 -78.218903 59.051929 
  -78.31723 58.985538 -78.24501 58.992489 -78.305008 58.931099 
  -78.363892 58.912491 -78.344727 58.946659 -78.437233 58.952209 
  -78.450844 58.909988 -78.481407 58.9361 -78.570557 58.96138 
  -78.549454 58.91082 -78.488892 58.82555 -78.49501 58.77721 
  -78.545288 58.785549 -78.547501 58.764149 -78.485291 58.730549 
  -78.469727 58.695541 -78.513901 58.69249 -78.573898 58.63055 
  -78.549454 58.60387 -78.47139 58.61166 -78.438339 58.572208 
  -78.321671 58.540272 -78.420288 58.60165 -78.397507 58.620819 
  -78.186684 58.488602 -78.073273 58.45507) 
#(-164.6512 60.32732 -164.6781 60.295818 -164.41029 60.084431 
  -164.1153 59.998051 -164.2186 59.94582 -164.1575 59.859711 
  -164.09171 59.830269 -163.832 59.799709 -163.30389 59.828602 
  -162.7731 59.95055 -162.75169 60.002769 -162.605 59.98138 
  -162.5092 60.000271 -162.4711 60.069149 -162.4989 60.12249 
  -162.44701 60.18082 -162.47279 60.204708 -162.7 60.261101 
  -162.5564 60.25721 -162.54829 60.2836 -162.597 60.299992 
  -162.5381 60.347759 -162.4581 60.363602 -162.41701 60.381378 
  -162.4361 60.43082 -162.3811 60.434711 -162.2681 60.61277 
  -162.1245 60.64999 -162.1311 60.713039 -162.0836 60.6586 
  -161.8795 60.702209 -162.222 60.581661 -162.37469 60.34082 
  -162.4722 60.297771 -162.332 60.20332 -162.367 60.162769 
  -162.325 60.13332 -162.2697 60.161381 -162.2906 60.19054 
  -162.1514 60.245541 -162.162 60.21777 -162.2514 60.197769 
  -162.1972 60.139709 -162.2361 60.060551 -162.05811 59.85944 
  -161.88721 59.678322 -161.7964 59.574989 -161.7133 59.48777 
  -161.9622 59.375542 -161.9614 59.304989 -162.0097 59.234711 
  -162.05029 59.255821 -161.94389 59.1036 -161.61861 59.138882 
  -161.5695 59.099152 -161.8058 59.016102 -161.8336 59.044708 
  -161.8542 59.02277 -161.78841 58.969151 -161.79469 58.89526 
  -161.7531 58.81805 -161.7706 58.783039 -161.6989 58.824429 
  -161.65559 58.800541 -161.7045 58.75943 -161.7939 58.757488 
  -161.8539 58.668598 -161.9344 58.645821 -161.9948 58.680538 
  -162.1714 58.649712 -162.0761 58.619431 -161.84309 58.626099 
  -161.7581 58.588329 -161.7489 58.643879 -161.7106 58.613319 
  -161.76311 58.55249 -161.6931 58.562481 -161.38499 58.670818 
  -161.36861 58.71777 -161.2809 58.775539 -161.3139 58.798038 
  -161.2672 58.815269 -161.2509 58.790539 -161.0631 58.831928 
  -160.8661 58.882771 -160.827 58.852772 -160.8414 58.822491 
  -160.72951 58.922489 -160.3856 59.062481 -160.31889 59.056931 
  -160.2531 58.982208 -160.32001 58.95055 -160.1617 58.911381 
  -160.1631 58.87138 -160.10561 58.86277 -160.0795 58.887489 
  -159.9986 58.876659 -159.9095 58.769711 -159.8497 58.788879 
  -159.7458 58.9161 -159.7686 58.934429 -159.6225 58.949429 
  -159.6028 58.898602 -159.6506 58.83638 -159.5425 58.84193 
  -159.3456 58.71944 -159.0567 58.424992 -158.89751 58.39555 
  -158.79581 58.415821 -158.70419 58.49221 -158.80811 58.577209 
  -158.9122 58.768879 -158.8817 58.805271 -158.8167 58.8111 
  -158.80611 58.786652 -158.88699 58.763599 -158.88451 58.733601 
  -158.83749 58.727211 -158.78641 58.761662 -158.772 58.861099 
  -158.79089 58.938881 -158.7886 58.961651 -158.73061 58.9286 
  -158.7397 58.896931 -158.6925 58.88443 -158.4431 59.059711 
  -158.42329 59.076931 -158.1295 59.02832 -158.0614 58.97916 
  -158.04359 58.91082 -157.9928 58.904991 -158.02361 58.870819 
  -158.07719 58.92165 -158.0614 58.946098 -158.1456 59.000542 
  -158.36391 59.037491 -158.4389 59.020821 -158.4908 58.98777 
  -158.42 58.971931 -158.4948 58.949162 -158.51781 58.85471 
  -158.5656 58.832489 -158.35091 58.73444 -158.31841 58.645821 
  -158.1989 58.60693 -158.0925 58.62138 -157.18469 58.852489 
  -156.87891 59.013882 -156.86031 59.108051 -156.77859 59.151249) 
#(-93.157417 58.741219 -93.327789 58.75721 -93.400284 58.70026 
  -93.452507 58.711929 -93.501953 58.771099 -93.768623 58.769711 
  -94.177231 58.771381 -94.140556 58.733318 -94.246399 58.586651 
  -94.231117 58.390541 -94.363892 58.223881 -94.291122 58.606659 
  -94.200844 58.685261 -94.239182 58.72443 -94.213058 58.79137 
  -94.351669 58.713871 -94.437233 58.723049 -94.477783 58.80666 
  -94.586403 58.874981 -94.676117 58.87804 -94.745293 58.83305 
  -94.676392 58.934429 -94.687233 58.980259 -94.805008 59.014709 
  -94.810287 59.064709 -94.787514 59.096931 -94.781403 59.263599 
  -94.658623 59.350552 -94.710854 59.37138 -94.811111 59.603321 
  -94.768623 59.78249 -94.789169 59.813881 -94.800842 60.014431 
  -94.707497 60.083599 -94.684448 60.208599 -94.614731 60.389992 
  -94.682793 60.47443 -94.652512 60.492489 -94.652512 60.515541 
  -94.706947 60.527489 -94.70668 60.542488 -94.575844 60.52026 
  -94.504997 60.549992 -94.511948 60.59388 -94.395844 60.725552 
  -94.410568 60.76804 -94.201134 60.964432 -93.981117 61.100819 
  -94.064453 61.110271 -94.039459 61.15694 -94.098618 61.165272 
  -94.010834 61.199989 -94.105827 61.324711 -93.940567 61.294991 
  -93.835564 61.326931 -93.857788 61.38554 -93.968903 61.396648 
  -93.968903 61.430538 -93.869171 61.53249 -93.311401 61.729431 
  -93.433617 61.72971 -93.452507 61.769161 -93.255569 61.742489 
  -93.248901 61.78471 -93.368057 61.784161 -93.436111 61.80888 
  -93.3564 61.81805 -93.578056 61.85194 -93.612503 61.87138 
  -93.499184 61.89304 -93.597229 61.93277 -93.590561 61.953602 
  -93.309448 61.883598 -93.282227 61.898319 -93.383057 61.949162 
  -93.289459 61.944149 -93.222504 61.957489 -93.390556 62.03194 
  -93.162231 61.97887 -93.152512 62.05138 -93.109177 62.036652 
  -93.067497 62.076931 -93.008621 62.064709 -92.931396 62.10416 
  -92.952507 62.11721 -93.08168 62.104431 -93.126953 62.132488 
  -93.114464 62.154148 -93.05751 62.175541 -92.801392 62.172771 
  -92.782501 62.21027 -92.790283 62.240822 -92.741119 62.28693 
  -92.603897 62.15638 -92.472229 62.14703) 
#(-139.85229 59.54446 -139.7778 59.51276 -139.34531 59.39888 
  -139.3456 59.380821 -139.2986 59.34388 -139.2253 59.377769 
  -139.2272 59.341648 -138.97861 59.269428 -138.6259 59.139431 
  -138.51331 59.186649 -138.4359 59.182491 -138.4984 59.119709 
  -138.5786 59.126099 -138.595 59.114429 -138.2878 59.073601 
  -137.965 58.904709 -137.9106 58.784988 -137.74921 58.70805 
  -137.6581 58.622211 -137.6264 58.598881 -137.2762 58.45776 
  -136.9225 58.388321 -136.89281 58.34082 -136.86501 58.381649 
  -136.8317 58.35387 -136.84309 58.31749 -136.772 58.33276 
  -136.7814 58.294991 -136.73219 58.308319 -136.7133 58.264149 
  -136.705 58.238041 -136.65421 58.21526 -136.58749 58.225552 
  -136.5611 58.27277 -136.6328 58.31749 -136.5925 58.35915 
  -136.362 58.298599 -136.35471 58.34026 -136.377 58.36166 
  -136.47391 58.382488 -136.55389 58.376381 -136.46609 58.408871 
  -136.32829 58.373051 -136.32359 58.401661 -136.2603 58.34943 
  -136.2834 58.3186 -136.2545 58.30777 -136.0833 58.338329 
  -136.0275 58.387211 -136.05969 58.468319 -136.15421 58.52943 
  -136.1925 58.61665 -136.297 58.657211 -136.2897 58.625271 
  -136.3864 58.62249 -136.44341 58.607491 -136.33749 58.68388 
  -136.382 58.720829 -136.49809 58.743599 -136.6353 58.80888 
  -136.85201 58.88026 -137.1158 58.81971 -137.09891 58.85693 
  -136.90669 58.920551 -136.9128 58.953041 -137.0047 59.02026 
  -136.6492 58.89027 -136.60831 58.907768 -136.69949 59.02026 
  -136.57091 58.913601 -136.53999 58.963039 -136.48891 58.965549 
  -136.5081 58.904709 -136.46561 58.82777 -136.38341 58.80444 
  -136.222 58.749439 -136.15891 58.761379 -136.0934 58.868599 
  -136.1353 58.95055 -136.1523 59.034431 -136.097 59.006939 
  -136.03391 58.85165 -135.96671 58.876381 -135.96359 58.91637 
  -135.7695 58.900269 -135.7589 58.883041 -135.92529 58.855549 
  -135.9281 58.87471 -136.0695 58.811649 -135.92 58.648041 
  -135.8203 58.599709 -135.8895 58.57193 -135.83611 58.53249 
  -135.8672 58.48999 -135.8728 58.460541 -135.9106 58.379162 
  -135.6097 58.420269 -135.4948 58.372761 -135.4606 58.38055 
  -135.4686 58.418049 -135.32919 58.252769 -135.1519 58.206661 
  -135.0856 58.233051 -135.09 58.269161 -135.05389 58.293598 
  -135.0495 58.340549 -135.2236 58.608879 -135.1628 58.636662 
  -135.2014 58.68082 -135.2375 58.780819 -135.3911 58.964161 
  -135.3756 59.0811 -135.5417 59.21471 -135.54559 59.233879 
  -135.4263 59.186508 -135.3047 59.083599 -135.3078 59.12027 
  -135.5475 59.321381 -135.3992 59.305271 -135.3597 59.45388 
  -135.3228 59.449711 -135.3625 59.263321 -135.1581 58.982769 
  -135.14059 58.831928 -135.0228 58.736931 -135.0273 58.787769 
  -134.9472 58.814709 -134.9153 58.65276 -134.98891 58.675541 
  -134.93559 58.607491 -134.7758 58.4911 -134.765 58.386662 
  -134.7375 58.372761 -134.6523 58.38055 -134.6331 58.342491 
  -134.60699 58.364712 -134.2403 58.208599 -134.15421 58.197769 
  -134.0961 58.247761 -134.14529 58.294708 -133.9592 58.504711 
  -133.7695 58.51749) #(11.465 58.066101 11.80639 58.120541 
  11.81472 58.17749 11.73667 58.281651 11.67164 58.276211 
  11.65528 58.23138 11.57611 58.225269 11.40111 58.13026 
  11.465 58.066101) #(-152.7717 57.998322 -152.75169 58.052761 
  -152.6264 58.078602 -152.6011 58.15694 -152.5603 58.18166 
  -152.5428 58.08527 -152.2744 58.127769 -152.3297 58.15749 
  -152.3275 58.219711 -152.27029 58.26305 -152.1917 58.174431 
  -152.08031 58.15638 -151.97279 58.233051 -151.96671 58.328041 
  -151.995 58.347488 -152.0639 58.275269 -152.06889 58.314991 
  -152.0995 58.303322 -152.13029 58.232769 -152.1478 58.262489 
  -152.09109 58.360271 -152.22141 58.353321 -152.2433 58.38776 
  -152.302 58.42416 -152.3992 58.315819 -152.4295 58.375271 
  -152.4747 58.35194 -152.46809 58.40527 -152.5264 58.413601 
  -152.4969 58.462769 -152.6581 58.477211 -152.692 58.422489 
  -152.7272 58.455269 -152.877 58.397491 -152.7672 58.366379 
  -152.7592 58.329708 -152.765 58.256649 -153.04781 58.301929 
  -153.1028 58.258881 -152.90469 58.165272 -153.18111 58.216648 
  -153.2195 58.196098 -153.22951 58.163052 -153.14861 58.102211 
  -153.0545 58.110538 -153.0325 58.049709 -152.89529 58.00721 
  -152.7717 57.998322) #(11.42029 58.995998 11.35611 59.107208 
  11.17139 59.124981 11.17361 59.193321 11.15028 59.15332 
  11.09778 59.132488 11.06417 59.11665 10.94194 59.186378 
  10.93889 59.13443 10.90611 59.138599 10.90361 59.195541 
  10.825 59.149429 10.7825 59.208881 10.72917 59.235538 
  10.78083 59.30999 10.6675 59.319149 10.66361 59.35944 
  10.58583 59.427761 10.65361 59.495819 10.67639 59.436939 
  10.69167 59.483879 10.55778 59.7286 10.58444 59.789989 
  10.64028 59.856659 10.67194 59.83971 10.71611 59.735821 
  10.75944 59.84193 10.72583 59.896648 10.57139 59.886379 
  10.47167 59.843319 10.49694 59.721931 10.60444 59.629711 
  10.60694 59.582489 10.55805 59.543049 10.45833 59.51305 
  10.41944 59.528599 10.42833 59.596371 10.37472 59.70277 
  10.22861 59.73138 10.23139 59.718601 10.375 59.662491 
  10.38972 59.631378 10.39 59.566929 10.35833 59.523041 
  10.26389 59.552761 10.24694 59.537769 10.485 59.40971 
  10.44972 59.344711 10.51361 59.298599 10.44722 59.239712 
  10.36389 59.26527 10.32111 59.159161 10.26361 59.106659 
  10.26222 59.033871 10.22722 59.11277 10.22083 59.01693 
  10.13083 58.99749 10.13083 59.016102 10.16306 59.04665 
  10.01917 59.028599 10.02583 58.971661 9.9963865 58.959431 
  9.8133316 58.961929 9.8427773 59.000542 9.7552776 59.03138 
  9.6919441 59.09026 9.6869431 59.045551 9.6547222 59.052212 
  9.6338882 59.128601 9.5441666 59.104988 9.7122211 59.0186 
  9.3511105 58.857491 9.2997208 58.875271 9.2805538 58.83054 
  9.4094429 58.841381 9.4483318 58.821381 9.3399982 58.75082 
  9.0672207 58.73637 9.224165 58.714161 9.1677761 58.682491 
  9.1972218 58.662209 8.9513874 58.579151 8.9311104 58.547211 
  8.5449982 58.306099 8.2480555 58.201931 8.2111111 58.115551 
  8.1630554 58.142208 8.1180553 58.095268 8.0319443 58.129162 
  8.0774994 58.154991 8.0261097 58.2211 8.0283318 58.174709 
  7.9347219 58.07943 7.8291659 58.069988 7.6547222 58.040272 
  7.3627782 58.01276 7.2419438 58.054989 7.0491662 57.996101 
  6.998055 58.003319 7.101944 58.080269 6.9605551 58.060822 
  6.9869442 58.10693 6.9036102 58.051102 6.892777 58.09277 
  6.9902768 58.13554 6.7744441 58.17416 6.813611 58.11721 
  6.7525001 58.11694 6.6913881 58.119709 6.749444 58.08971 
  6.7772222 58.058601 6.5977769 58.070271 6.5308328 58.114159 
  6.8491659 58.270821 6.665277 58.225552 6.6456318 58.288509 
  6.7049999 58.31443 6.647778 58.318878 6.6077781 58.23777 
  6.3266659 58.274429 5.9833331 58.39888 5.956944 58.471661 
  5.7572222 58.48666 5.620832 58.559711 5.4562778 58.750648) 
#(-3.979445 57.960541 -3.9022231 57.983601 -3.4713891 58.195541 
  -3.331389 58.27776 -3.1219449 58.369431 -3.0555561 58.477772 
  -3.123333 58.482208 -3.126389 58.519989 -3.03 58.600269 
  -3.0255561 58.647491 -3.3088889 58.644428 -3.374167 58.672489 
  -3.4102781 58.649429 -3.365278 58.595268 -3.571111 58.62249 
  -3.8575001 58.560551 -4.0411119 58.588871 -4.3600011 58.533871 
  -4.4950008 58.445271 -4.4283342 58.521381 -4.440834 58.55138 
  -4.5888891 58.57082 -4.6113892 58.51804 -4.7647228 58.443321 
  -4.6600008 58.552212 -4.7675009 58.57832 -4.8175001 58.521931 
  -4.8297219 58.600819 -5.0050001 58.623322 -5.0286112 58.538319 
  -5.1097231 58.50832 -5.0733342 58.450821 -5.0897231 58.41943 
  -5.146111 58.40971 -5.168334 58.361099 -5.1216669 58.28582 
  -4.9294448 58.261662 -4.9463892 58.223049 -5.1155558 58.269989 
  -5.1766672 58.249149 -5.3866668 58.261101 -5.396389 58.242489 
  -5.3000002 58.161652 -5.2833338 58.10638 -5.311111 58.063881 
  -5.4430561 58.09388 -5.4444451 58.06443 -5.2630558 57.9711) 
#(22.051661 57.90971 22.202499 57.986099 22.27916 58.18388 
  22.394171 58.22332 22.73444 58.216381 22.756941 58.240261 
  22.71055 58.26054 22.82555 58.27026 22.92944 58.326382 
  22.949169 58.381649 23.02861 58.357769 23.15638 58.47916 
  23.2675 58.42944 23.278879 58.460541 23.009451 58.5895 
  22.87167 58.617771 22.72361 58.581661 22.55139 58.631939 
  22.278891 58.556931 22.28694 58.520821 22.24028 58.499149 
  22.19833 58.549431 22.09889 58.480549 22.095831 58.42165 
  22.078051 58.420551 22.000549 58.514992 21.83194 58.50499 
  21.91666 58.457489 22.0075 58.353321 21.96139 58.349152 
  21.957781 58.31443 21.89917 58.34277 21.87361 58.332489 
  21.910271 58.297489 21.85639 58.301659 21.884439 58.252209 
  22.19722 58.137489 22.08222 58.076649 21.99667 57.97971 
  21.96389 57.981659 22.000549 57.916931 22.051661 57.90971) 
#(24.310049 57.870831 24.460831 58.069439 24.472771 58.247211 
  24.5425 58.284431 24.559441 58.320541 24.51778 58.353039 
  24.41972 58.386662 24.326111 58.384708 24.23805 58.271381 
  24.14666 58.27026 24.11055 58.232208 23.937771 58.325821 
  23.731939 58.346661 23.671671 58.536652 23.5 58.559429 
  23.49555 58.694149 23.538891 58.746101 23.808331 58.729988 
  23.791389 58.800819 23.42944 58.762489 23.5275 58.82304 
  23.416109 58.910549 23.43111 58.93943 23.637779 58.970539 
  23.61194 59.010269 23.540831 58.967209 23.407221 59.0186 
  23.43305 59.059158 23.49972 59.084991 23.52639 59.10693 
  23.464161 59.206379 23.51083 59.228321 23.738609 59.232769 
  23.74222 59.278599 24.09 59.275829 24.100281 59.303879 
  24.02 59.36277 24.03722 59.390541 24.08111 59.392208 
  24.199169 59.34277 24.22361 59.358318 24.16777 59.412491 
  24.246941 59.398602 24.31889 59.425819 24.32917 59.464161 
  24.39472 59.474991 24.650829 59.4361 24.622219 59.46777 
  24.68972 59.489429 24.730829 59.447769 24.783609 59.44804 
  24.81694 59.48888 24.78722 59.514992 24.790001 59.566662 
  25.404591 59.490292) #(-65.489967 59.790569 -65.54335 59.730259 
  -65.426407 59.525829 -64.983353 59.376381 -65.048889 59.38055 
  -65.523071 59.48138 -65.430862 59.403599 -65.446136 59.365261 
  -65.428337 59.33971 -65.571671 59.377769 -65.565582 59.30138 
  -65.492783 59.25499 -65.573639 59.24194 -65.59169 59.188042 
  -65.658081 59.251381 -65.732803 59.269161 -65.655289 59.083321 
  -65.413094 59.064159 -65.31752 59.04137 -65.570297 59.048599 
  -65.543327 59.015541 -65.67308 59.046101 -65.777512 59.029991 
  -65.670303 58.956379 -65.67836 58.926929 -65.763077 58.971371 
  -65.885834 59.00193 -65.853897 58.943878 -65.964752 58.915272 
  -65.973892 58.88221 -65.790298 58.857769 -65.833359 58.829708 
  -66.022781 58.86166 -66.103897 58.773602 -66.039177 58.741379 
  -65.873611 58.61916 -65.884193 58.580818 -65.982788 58.474152 
  -65.920288 58.44582 -66.051407 58.352489 -65.986679 58.423321 
  -66.021973 58.486931 -65.94223 58.58276 -65.945572 58.61694 
  -66.06778 58.64888 -66.113892 58.699429 -66.388634 58.850552 
  -66.489754 58.754429 -66.45253 58.739429 -66.468903 58.711651 
  -66.551971 58.71138 -66.626129 58.592491 -66.623901 58.48637 
  -66.754204 58.501659 -66.824722 58.451382 -66.898064 58.445271 
  -66.887238 58.485538 -66.951424 58.4986 -67.056396 58.388882 
  -67.09584 58.348881 -67.16864 58.37804 -67.499191 58.262211 
  -67.659729 58.110271 -67.635849 58.042759 -67.735001 57.939991 
  -67.735863 57.966381 -67.690292 58.02388 -67.703056 58.16193 
  -67.646133 58.253319 -67.730827 58.2836 -67.677254 58.43499 
  -67.787521 58.464432 -67.830841 58.331379 -67.801392 58.29665 
  -68.05751 58.10944 -68.129997 58.07888 -68.09584 58.138599 
  -67.887238 58.263321 -67.857803 58.320271 -67.908363 58.360821 
  -67.894203 58.496658 -67.945282 58.536381 -68.013062 58.573601 
  -68.029739 58.511929 -68.126129 58.526371 -68.188606 58.35387 
  -68.295303 58.209991 -68.309189 58.108051 -68.416946 58.034431 
  -68.749977 57.979599 -68.750954 57.979179 -68.752609 57.978851 
  -68.754089 57.97868 -68.755867 57.978199 -68.758179 57.977871 
  -68.760468 57.977551 -68.763428 57.976879 -68.766068 57.976391 
  -68.768173 57.975632 -68.770813 57.975239 -68.77269 57.974808 
  -68.774109 57.97459 -68.775742 57.974091 -68.77803 57.973164 
  -68.779709 57.973099 -68.781662 57.97261 -68.784607 57.97179 
  -68.786911 57.971298 -68.789223 57.970638 -68.791519 57.96999 
  -69.369751 57.764992) #(-69.369751 57.764992 
  -69.127518 57.899429 -68.77803 57.975632 -68.768997 57.978096 
  -68.477226 58.039989 -68.344177 58.127491 -68.238907 58.351101 
  -68.196136 58.544708 -68.295013 58.529709 -68.274727 58.590549 
  -68.350594 58.604431 -68.368362 58.78582 -68.668327 58.9011 
  -68.889191 58.87693 -69.134193 58.901371 -69.608078 58.754711 
  -69.819183 58.5886 -69.876678 58.6436 -69.79808 58.68943 
  -69.809723 58.709709 -69.910568 58.688042 -69.933327 58.705269 
  -69.920013 58.77388 -70.252243 58.771381 -69.892792 58.831379 
  -69.898354 58.873322 -69.858337 58.85194 -69.796951 58.838039 
  -69.825851 58.948601 -69.895859 58.95776 -69.872803 59.050819 
  -69.848343 59.047211 -69.827507 59.011929 -69.709473 58.972759 
  -69.712227 58.91888 -69.671951 58.930538 -69.672501 58.89138 
  -69.7164 58.864712 -69.656403 58.787769 -69.543327 58.811939 
  -69.528351 58.865551 -69.474747 58.8736 -69.454193 58.895821 
  -69.483078 58.985538 -69.49501 59.07193 -69.440002 59.02277 
  -69.365837 59.073879 -69.360023 59.11277 -69.463058 59.129429 
  -69.501129 59.10582 -69.537247 59.123051 -69.519203 59.189159 
  -69.420837 59.223049 -69.419167 59.19249 -69.359192 59.19471 
  -69.36586 59.242771 -69.285843 59.208321 -69.235001 59.233879 
  -69.25946 59.326649 -69.368347 59.314159 -69.424469 59.355549 
  -69.738907 59.305271 -69.744171 59.343319 -69.636414 59.366379 
  -69.649727 59.428879 -69.75946 59.493881 -69.718903 59.537769 
  -69.545288 59.609711 -69.521957 59.669708 -69.654167 59.697769 
  -69.545853 59.763599 -69.612244 59.784431 -69.563057 59.868038 
  -69.759171 59.902489 -69.72139 59.918049 -69.718903 59.959709 
  -69.759193 59.96777 -70.325302 59.97443 -70.412231 60.00304 
  -69.793327 59.98888 -69.843918 60.026932 -69.832779 60.068321 
  -69.624733 60.06749 -69.6064 60.232769 -69.748901 60.300819 
  -69.721687 60.368881 -69.82225 60.52776 -69.704742 60.544708 
  -69.654167 60.584991 -69.708618 60.686939 -69.380577 60.794708 
  -69.374474 60.826382 -69.51973 61.073318 -69.600021 61.081928 
  -69.656677 61.0536 -69.689468 60.9561 -69.644203 60.90332 
  -69.65863 60.87693 -69.720291 60.87582 -69.756958 60.91888 
  -69.902527 60.854431 -70.061417 60.84444 -70.088058 60.89777 
  -70.092796 60.96888 -70.160019 61.014431 -70.116119 61.06749 
  -70.539726 61.05582 -70.547523 61.007488 -70.656403 61.050541 
  -70.773354 61.081661 -70.798897 61.052761 -70.928337 61.102489 
  -71.053337 61.125542 -71.196671 61.11832 -71.220581 61.167488 
  -71.374191 61.119709 -71.490837 61.223881 -71.533081 61.208881 
  -71.512512 61.161652 -71.578339 61.15527 -71.610291 61.23637 
  -71.725853 61.28582 -71.664459 61.32777 -71.809738 61.35416 
  -71.689194 61.36832 -71.587799 61.408039 -71.873062 61.419708 
  -71.746689 61.471371 -71.781677 61.508041 -71.83168 61.519989 
  -71.549454 61.55888 -71.54863 61.576382 -71.675308 61.658871 
  -71.958344 61.706928 -71.933899 61.663601 -71.98056 61.599991 
  -72.080566 61.60194 -71.99057 61.67638 -72.075562 61.74165 
  -72.216133 61.740261 -72.225281 61.765541 -72.144447 61.807491 
  -72.607224 61.940819 -72.596123 61.805538 -72.628342 61.81805 
  -72.668327 61.879162 -72.797791 61.834431) 
#(17.274879 61.311749 17.128611 61.301102 17.21139 61.223598 
  17.14889 61.209148 17.181391 61.080818 17.18833 61.032768 
  17.165831 60.993599 17.150551 60.944988 17.33416 60.756378 
  17.18861 60.68832 17.3325 60.65332 17.578329 60.639992 
  17.65694 60.60194 17.602501 60.574989 17.63472 60.518318 
  17.740549 60.493599 17.725559 60.53471 17.77305 60.571098 
  17.94972 60.59721 17.97583 60.57082 18.22805 60.36916 
  18.23444 60.326649 18.440281 60.34082 18.445271 60.310261 
  18.5825 60.246929 18.58 60.22443 18.448891 60.239712 
  18.34083 60.298038 18.317221 60.29694 18.449169 60.21138 
  18.421671 60.18721 18.542219 60.151932 18.587219 60.073318 
  18.57917 60.137211 18.62611 60.145821 18.736389 60.118599 
  18.74472 60.047211 18.75305 60.0811 18.76083 60.104988 
  18.8225 60.114159 18.816389 60.073879 18.909719 59.935822 
  19.070551 59.889709 19.05055 59.822769 18.92444 59.889149 
  18.93111 59.857208 18.85722 59.794708 18.765829 59.786652 
  18.739161 59.758598 18.851669 59.77776 19.080549 59.77055 
  19.07 59.735821 18.953609 59.71999 18.91222 59.749439 
  18.694441 59.64526 18.74472 59.64249 18.668051 59.62027 
  18.64555 59.58054 18.25 59.4436 18.312771 59.406101 
  18.32222 59.39082 18.165001 59.408039 18.20833 59.420551 
  18.195829 59.455269 18.115549 59.453041 18.081671 59.399151 
  18.01111 59.40554 18.136391 59.332489 17.816111 59.371101 
  17.757771 59.409988 17.77 59.44582 17.84528 59.533039 
  17.71833 59.699162 17.71055 59.618881 17.59222 59.656101 
  17.68639 59.736099 17.63611 59.754711 17.58778 59.80471 
  17.496111 59.729988 17.444719 59.676102 17.48778 59.63221 
  17.521391 59.61694 17.5275 59.713039 17.5375 59.732208 
  17.620279 59.726379 17.560829 59.666931 17.58667 59.640541 
  17.757219 59.583881 17.785 59.52943 17.719999 59.44276 
  17.520281 59.50721 17.54166 59.557491 17.49028 59.542488 
  17.37055 59.619709 17.407499 59.500542 17.39889 59.469151 
  17.110279 59.55138 17.059999 59.604431 17.011391 59.5886 
  17.048889 59.560551 17.031389 59.536381 16.800831 59.591099 
  16.783051 59.552761 16.72139 59.525829 16.647499 59.560822 
  16.541941 59.60944 16.497499 59.586929 16.547501 59.556931 
  16.53833 59.538879 16.465 59.51582 16.4725 59.49749 
  16.389441 59.510818 16.34889 59.479988 16.022221 59.489712 
  16.072781 59.45443 16.181391 59.43943 16.67 59.473049 
  16.746389 59.428879 16.693331 59.476101 16.82889 59.491379 
  16.92444 59.45332 17.040001 59.35944 17.310551 59.348881 
  17.311939 59.327492 17.24361 59.313599 17.280001 59.274151 
  17.213329 59.25721 17.39805 59.247761 17.355 59.297211 
  17.36194 59.324711 17.503889 59.284161 17.594999 59.223049 
  17.593889 59.28471 17.847219 59.264431 17.88805 59.22694 
  17.889721 59.28471 17.98444 59.333881 18.163891 59.320541 
  18.272221 59.364429 18.360001 59.37138 18.45472 59.3311 
  18.478331 59.345829 18.441111 59.412769 18.434441 59.433601 
  18.52972 59.417488 18.65028 59.319149 18.63055 59.307491 
  18.353609 59.305538 18.339439 59.32777 18.276939 59.307209 
  18.338329 59.22971 18.309999 59.219711 18.40333 59.163601 
  18.04472 59.053879 17.995279 59.000542 17.96666 58.920818 
  17.89583 58.90971 17.89472 58.858879 17.83778 58.923038 
  17.80028 58.90638 17.78194 58.875542 17.740549 58.931931 
  17.76194 58.997211 17.759159 59.126659 17.706671 59.050541 
  17.66666 59.083321 17.69055 59.132771 17.663891 59.16832 
  17.613609 58.974709 17.61389 58.917488 17.61305 58.894428 
  17.5375 58.896381 17.589439 58.857208 17.446939 58.89249 
  17.480551 58.789711 17.34 58.80415 17.371389 58.745541 
  17.254999 58.724709 17.08333 58.763599 17.08666 58.733879 
  17.059999 58.703041 17.14555 58.70026 17.094721 58.6511 
  17.03389 58.67387 17.012779 58.662209 17.024719 58.636101 
  16.67778 58.636929 16.231939 58.658871 16.401939 58.592491 
  16.436661 58.64138 16.788891 58.602772 16.78611 58.567211 
  16.93861 58.48415 16.742769 58.424431 16.54055 58.46138 
  16.709999 58.403599 16.73361 58.363041 16.764441 58.337769 
  16.630831 58.348049 16.73111 58.31554 16.803329 58.31221 
  16.70916 58.268879 16.80167 58.24332 16.802219 58.138599 
  16.752781 58.125542 16.682501 58.171379 16.61805 58.19276 
  16.660271 58.136662 16.72805 58.100819 16.734171 58.047489 
  16.750271 58.01276 16.713881 58.01749 16.690281 57.999149 
  16.651939 58.044991 16.63805 58.004429 16.74 57.961929 
  16.77055 57.88443 16.72472 57.87582 16.692499 57.91666 
  16.659161 57.88332 16.558331 57.97694 16.49444 57.979431 
  16.58416 57.926929 16.461941 57.89249 16.702351 57.74226) 
#(24.297131 57.73642 24.294439 57.850269 24.310049 57.870831) 
#(-6.9658341 57.725552 -6.8788891 57.78915 -6.815556 57.805538 
  -6.7608342 57.824162 -6.8033342 57.878319 -6.6605558 57.884708 
  -6.7613902 57.998322 -6.6594448 58.04665 -6.706944 57.998878 
  -6.688612 57.955269 -6.5774999 57.91082 -6.4741669 57.940269 
  -6.4644451 57.986099 -6.5533342 58.009159 -6.3927779 58.00388 
  -6.3672228 58.052761 -6.4025002 58.10582 -6.6202779 58.081928 
  -6.375 58.13554 -6.3941669 58.209431 -6.2427778 58.180271 
  -6.1583338 58.218319 -6.168056 58.26054 -6.2872229 58.204708 
  -6.3658342 58.23082 -6.168334 58.34277 -6.2127781 58.36499 
  -6.166389 58.42527 -6.2447219 58.508598 -6.330833 58.471661 
  -6.7977781 58.302212 -6.8080559 58.259708 -6.7572231 58.22332 
  -6.728889 58.16943 -6.813612 58.196098 -6.873889 58.178322 
  -6.8619452 58.11137 -6.9083338 58.212769 -7.040833 58.233318 
  -7.0580559 58.20055 -7.020556 58.186649 -7.1088901 58.180538 
  -7.126945 58.123322 -7.0736108 58.058601 -6.936111 58.046101 
  -7.063612 58.005821 -6.8408341 57.92527 -7.0091672 57.83971 
  -7.125556 57.837769 -7.1200008 57.814159 -6.9658341 57.725552) 
#(-155.7341 57.545151 -155.76421 57.647209 -155.5878 57.669159 
  -155.58389 57.68499 -155.63451 57.712769 -155.6208 57.763321 
  -155.5611 57.793598 -155.3636 57.72332 -155.2953 57.757771 
  -155.35831 57.79887 -155.21919 57.84388 -155.2475 57.878319 
  -155.1819 57.862492 -155.0631 57.897491 -155.12 57.95055 
  -155.0181 58.025269 -154.74921 58.012489 -154.71719 58.055271 
  -154.65669 58.0686 -154.63361 58.031101 -154.5681 58.025269 
  -154.5406 58.063881 -154.6006 58.124439 -154.47031 58.08276 
  -154.46001 58.1036 -154.49139 58.196098 -154.4261 58.132771 
  -154.32719 58.080818 -154.3367 58.155819 -154.2408 58.128319 
  -154.2261 58.145821 -154.3017 58.189159 -154.18919 58.194988 
  -154.15559 58.229431 -154.2433 58.255821 -154.13361 58.26582 
  -154.1153 58.28693 -154.1922 58.317211 -154.35471 58.248051 
  -154.35451 58.287769 -154.047 58.360821 -154.0025 58.39555 
  -154.0667 58.407211 -154.097 58.485538 -153.92999 58.50526 
  -153.89639 58.57999 -153.64861 58.627491 -153.50841 58.698318 
  -153.34891 58.849991 -153.29089 58.839989 -153.2572 58.863319 
  -153.2906 58.87888 -153.33141 58.92915 -153.5909 58.995819 
  -153.7122 59.07082 -154.0406 59.07943 -154.177 59.0261 
  -154.20061 59.05582 -154.1756 59.08971 -154.2608 59.142208 
  -154.1264 59.202492 -154.1489 59.24332 -154.112 59.303879 
  -153.95081 59.36277 -154.10001 59.34943 -154.1425 59.377491 
  -153.7395 59.438599 -153.735 59.49416 -153.82829 59.542488 
  -153.8486 59.553051 -153.5889 59.556099 -153.5631 59.608051 
  -153.70219 59.63776 -153.5914 59.693878 -153.5558 59.628601 
  -153.4633 59.664711 -153.4436 59.78944 -153.3231 59.716648 
  -153.4261 59.64777 -153.30389 59.63443 -153.3017 59.678322 
  -153.2261 59.643879 -153.04449 59.706928 -152.99719 59.80138 
  -153.0192 59.8311 -153.1403 59.81443 -153.282 59.82555 
  -153.21809 59.868038 -152.9278 59.87888 -152.7122 59.918049 
  -152.575 60.070271 -152.5961 60.09444 -152.9295 60.23888 
  -152.93781 60.284431 -152.9995 60.29388 -153.0811 60.279148 
  -153.0067 60.311378 -152.89529 60.303051 -152.8864 60.250542 
  -152.8186 60.264992 -152.7906 60.245819 -152.57091 60.22971 
  -152.2442 60.398602 -152.3161 60.41721 -152.3403 60.461102 
  -152.32201 60.498878 -151.92081 60.7286 -151.7253 60.71693 
  -151.7092 60.734989 -151.7845 60.801929 -151.8028 60.853039 
  -151.7408 60.91534) #(24.310049 57.870831 24.4203 57.874401 
  24.4531 57.9133 24.5536 57.9547 24.7178 57.9589 
  24.7542 58.000801 24.827499 57.98 24.8853 58.0075 
  24.9681 58.0144 25.0917 58.071701 25.17 58.074402 
  25.2061 58.0317 25.2325 57.992802 25.294399 58.0075 
  25.2969 58.038101 25.2631 58.069199 25.301701 58.083099 
  25.348301 58.036701 25.4217 58.035599 25.4611 57.9944 
  25.576401 57.9669 25.5772 57.9422 25.622801 57.916401 
  25.749201 57.931099 25.801399 57.865799 26.031401 57.849998 
  26.0467 57.840302 26.028601 57.8022 26.0375 57.784698 
  26.1803 57.721901 26.2992 57.611401 26.4603 57.570599 
  26.5172 57.524399 26.5611 57.536098 26.6089 57.526901 
  26.635 57.555801 26.7194 57.581699 26.760799 57.571098 
  26.829201 57.5825 26.864401 57.625801 26.8908 57.6339 
  26.91 57.619202 27.0186 57.611401 27.0872 57.562199 
  27.245001 57.549198 27.338301 57.5228 27.371099 57.5364) 
#(-7.315001 57.504162 -7.1541672 57.50943 -7.1380558 57.556099 
  -7.106945 57.58638 -7.1799998 57.608601 -7.2016668 57.63805 
  -7.0958338 57.608051 -7.0755558 57.642208 -7.186667 57.648319 
  -7.1847229 57.684429 -7.313612 57.65332 -7.396111 57.661098 
  -7.500278 57.636929 -7.5191669 57.5811 -7.418612 57.573318 
  -7.315001 57.504162) #(-135.6881 57.36277 -135.55251 57.534161 
  -135.58141 57.553051 -135.65669 57.55138 -135.5656 57.584709 
  -135.6467 57.619991 -135.80389 57.64526 -135.70309 57.67416 
  -135.8139 57.762211 -135.73061 57.747761 -135.54221 57.657211 
  -134.9883 57.45055 -134.8111 57.486099 -134.9153 57.753319 
  -134.9633 57.761101 -135.21671 57.698318 -135.35249 57.740551 
  -135.36 57.797211 -135.2234 57.778049 -135.0522 57.77776 
  -134.935 57.8111 -135.1447 57.893879 -135.19749 57.9436 
  -135.0867 57.90638 -134.97 57.885269 -134.9059 57.92915 
  -134.90891 57.99527 -134.9653 58.044991 -135.3992 58.139431 
  -135.457 58.118881 -135.4231 58.085541 -135.6106 57.980259 
  -135.7495 57.97694 -135.63699 57.99332 -135.63029 58.01276 
  -135.75169 58.022491 -135.7717 58.047771 -135.6039 58.04388 
  -135.4825 58.15554 -135.5072 58.175819 -135.73779 58.2486 
  -135.8047 58.276371 -135.92999 58.224991 -135.9659 58.159988 
  -136.132 58.221931 -136.1817 58.17165 -136.1539 58.085541 
  -136.2756 58.21888 -136.35451 58.207211 -136.2706 58.10471 
  -136.3831 58.135269 -136.4323 58.107769 -136.38969 58.064709 
  -136.27 57.96999 -136.3436 57.987209 -136.377 57.899712 
  -136.4122 57.815819 -136.08859 57.68277 -136.1414 57.63221 
  -136.10921 57.614712 -136.0753 57.647209 -135.9534 57.608879 
  -136.0347 57.611099 -136.0609 57.591648 -135.8058 57.466648 
  -135.78889 57.431381 -135.91969 57.50082 -136.0106 57.511929 
  -135.8878 57.428051 -135.6881 57.36277) 
#(10.54202 57.229519 10.53722 57.449989 10.44305 57.535259 
  10.4325 57.592209 10.49139 57.653881 10.645 57.737492 
  10.55667 57.74416 10.39055 57.6661 9.9400024 57.571129) 
#(9.9400024 57.571129 9.5408335 57.213871 9.3899994 57.1511 
  9.2313881 57.137211 9.0547075 57.123859 8.7541656 57.101101 
  8.6286106 57.125271 8.5855541 57.100819) 
#(-7.3497229 57.09943 -7.2447219 57.121658 -7.2591672 57.152489 
  -7.2591672 57.226101 -7.2005558 57.302761 -7.3536119 57.351379 
  -7.3841672 57.38332 -7.252501 57.326649 -7.2247229 57.341648 
  -7.3497229 57.406101 -7.4252791 57.38221 -7.3919449 57.303879 
  -7.4227781 57.27832 -7.3869448 57.114712 -7.3497229 57.09943) 
#(-6.0122218 57.022209 -5.9283342 57.038601 -5.6641669 57.20499 
  -5.6541672 57.261662 -5.8994451 57.24194 -6.039722 57.30582 
  -6.1011109 57.321381 -6.128056 57.4011 -6.190001 57.396381 
  -6.1319451 57.474152 -6.1633339 57.59721 -6.3230562 57.694988 
  -6.420279 57.634708 -6.357779 57.58305 -6.394444 57.522209 
  -6.439445 57.476379 -6.4636121 57.508881 -6.5866671 57.5886 
  -6.6413889 57.602489 -6.623889 57.544159 -6.561667 57.499439 
  -6.6297231 57.497211 -6.6119452 57.438042 -6.7158341 57.511929 
  -6.7861118 57.446098 -6.7002778 57.36388 -6.5675001 57.33749 
  -6.5702782 57.386101 -6.482779 57.39777 -6.4219451 57.334709 
  -6.4763889 57.297211 -6.353889 57.225269 -6.353889 57.18943 
  -6.2791672 57.198318 -6.314723 57.15749 -6.2213898 57.173321 
  -6.1111121 57.170818 -6.0736108 57.126381 -6.0333338 57.224709 
  -5.9447231 57.147209 -6.0350008 57.05471 -6.0122218 57.022209) 
#(-134.6067 57.008041 -134.14751 57.202492 -134.1292 57.26054 
  -134.0947 57.246929 -134.07671 57.275539 -134.1425 57.30027 
  -134.16701 57.384991 -133.9464 57.301102 -133.8672 57.34832 
  -133.8633 57.376381 -133.9106 57.433319 -133.9953 57.408039 
  -134.0898 57.4711 -133.8403 57.460541 -133.9492 57.628319 
  -134.07919 57.649429 -134.04359 57.683601 -134.237 57.858879 
  -134.28889 57.831661 -134.3125 57.992771 -134.2236 57.96944 
  -134.2617 58.02832 -134.3031 58.095268 -134.1481 57.963039 
  -134.095 57.850269 -134.00751 57.805271 -133.9886 57.743038 
  -133.8403 57.610271 -134.0036 57.9361 -134.1778 58.083599 
  -134.1609 58.122761 -134.1692 58.15971 -134.202 58.163879 
  -134.6859 58.162769 -134.69749 58.18721 -134.87219 58.36277 
  -134.9567 58.407768 -134.972 58.364159 -134.927 58.25388 
  -134.88 58.254429 -134.91251 58.205269 -134.77921 58.105549 
  -134.7439 58.185261 -134.72639 58.176102 -134.8036 58.044159 
  -134.6544 57.59832 -134.56281 57.5061 -134.3784 57.54916 
  -134.36079 57.535549 -134.57249 57.489712 -134.50951 57.431099 
  -134.3398 57.374981 -134.3367 57.349991 -134.3306 57.32832 
  -134.5558 57.391651 -134.5545 57.34082 -134.4525 57.312481 
  -134.57671 57.275829 -134.5789 57.25555 -134.5211 57.23637 
  -134.52609 57.213039 -134.6236 57.224991 -134.6356 57.209431 
  -134.6067 57.008041) #(9.9813633 57.077869 10.02083 57.086929 
  10.23152 57.017429 10.34389 56.9986 10.42389 57.157211 
  10.54202 57.229519) #(-153.3156 56.989712 -153.2448 57.000542 
  -153.1917 57.082489 -152.8947 57.135818 -152.99001 57.174431 
  -153.21001 57.132771 -153.17529 57.184158 -153.2728 57.198601 
  -153.4075 57.072769 -153.34779 57.040821 -153.3156 56.989712) 
#(-135.827 56.985821 -135.6225 57.007771 -135.5464 57.134991 
  -135.62469 57.231659 -135.55389 57.224152 -135.5898 57.263321 
  -135.7003 57.316929 -135.847 57.316662 -135.81171 57.169159 
  -135.70889 57.161381 -135.82671 57.076649 -135.827 56.985821) 
#(-61.346119 56.951099 -61.380291 57.11721 -61.478889 57.159431 
  -61.565571 57.149712 -61.70084 57.15971 -61.656681 57.207211 
  -61.781399 57.14888 -61.781399 57.195271 -61.852509 57.165272 
  -62.026669 57.255821 -61.937778 57.252209 -61.862789 57.288879 
  -61.92001 57.365551 -61.803341 57.358879 -61.83363 57.38221 
  -62.156399 57.463329 -62.353889 57.41832 -62.464729 57.45443 
  -62.541389 57.507488 -62.329731 57.458881 -62.265011 57.535259 
  -62.159729 57.525269 -62.03056 57.596371 -61.89806 57.616379 
  -61.88361 57.64555 -62.0014 57.775269 -62.117779 57.798038 
  -62.135571 57.83971 -62.061111 57.889992 -62.079731 57.94276 
  -62.1464 57.97443 -62.341389 57.90749 -62.335838 57.977489 
  -62.37611 57.953602 -62.40168 57.868599 -62.425831 57.8736 
  -62.428612 57.96027 -62.53223 57.971661 -62.620838 57.947491 
  -62.519169 58.006939 -62.386669 57.993881 -62.30724 58.031101 
  -62.32584 58.061378 -62.392231 58.067211 -62.365292 58.092209 
  -62.3689 58.11166 -62.468609 58.10194 -62.514729 58.057491 
  -62.529171 58.102772 -62.459728 58.151932 -62.51585 58.169159 
  -62.561401 58.12138 -62.57362 58.164711 -62.646118 58.11916 
  -62.886391 58.137489 -63.09473 58.057491 -63.097778 58.019711 
  -63.341671 57.981098 -63.14613 58.036098 -63.154171 58.073601 
  -63.012218 58.13554 -63.068069 58.153049 -62.653069 58.17527 
  -62.581402 58.226101 -62.610008 58.256649 -62.821678 58.25193 
  -62.61974 58.310261 -62.630009 58.35416 -62.561401 58.487492 
  -62.610008 58.50388 -62.699459 58.485538 -62.801399 58.493038 
  -63.015011 58.42527 -63.050838 58.45026 -63.153069 58.374149 
  -63.086109 58.45499 -63.13279 58.477211 -63.26112 58.463871 
  -63.56168 58.303322 -63.577511 58.31554 -63.404171 58.40443 
  -63.345558 58.477211 -63.318069 58.49221 -62.96085 58.583599 
  -62.842232 58.669991 -62.868061 58.71138 -63.027241 58.703041 
  -62.916679 58.747761 -62.918339 58.81749 -63.05307 58.86499 
  -62.991009 58.8773) #(18.147779 56.91193 18.230551 56.918049 
  18.35861 56.98777 18.33555 57.023319 18.413059 57.12582 
  18.417219 57.144161 18.714439 57.246929 18.66638 57.278881 
  18.67194 57.302212 18.788891 57.370541 18.907499 57.38055 
  18.929159 57.418049 18.89666 57.44138 18.808889 57.439159 
  18.768049 57.478039 18.80805 57.600552 18.76222 57.615261 
  18.81444 57.734711 18.899719 57.713329 18.94416 57.781651 
  19.082781 57.830269 19.003889 57.89888 18.899719 57.886929 
  18.914169 57.917488 18.84083 57.908871 18.849159 57.873051 
  18.788059 57.830818 18.77194 57.886929 18.71611 57.921101 
  18.46139 57.80777 18.111389 57.519428 18.11528 57.48082 
  18.176941 57.375542 18.101391 57.282211 18.09889 57.25304 
  18.15667 57.228039 18.217501 57.05777 18.28944 57.09082 
  18.262501 57.036381 18.20277 57.01527 18.147779 56.91193) 
#(-154.13609 56.739712 -153.9614 56.742771 -153.8997 56.784431 
  -153.7119 56.85582 -153.6945 56.8811 -153.7639 56.861931 
  -153.7744 56.89027 -153.66949 56.932491 -153.60339 56.937771 
  -153.5872 57.028599 -153.5981 57.048038 -153.49561 57.06805 
  -153.5222 57.13443 -153.4895 57.176929 -153.4556 57.112492 
  -153.37061 57.174992 -153.3889 57.207211 -153.05811 57.218601 
  -152.9595 57.263321 -153.1653 57.297771 -153.162 57.348598 
  -152.87469 57.343319 -152.88699 57.29166 -152.722 57.304989 
  -152.70419 57.27388 -152.6339 57.31776 -152.6125 57.387211 
  -152.84669 57.47221 -153.0433 57.431381 -153.0228 57.473598 
  -152.91029 57.483879 -152.9489 57.504162 -152.72951 57.50499 
  -152.7148 57.478039 -152.61 57.476101 -152.57719 57.445541 
  -152.4948 57.46693 -152.452 57.454708 -152.4828 57.42416 
  -152.3306 57.42971 -152.1506 57.610538 -152.18111 57.628319 
  -152.437 57.60944 -152.39861 57.685822 -152.49249 57.651932 
  -152.44611 57.722488 -152.53391 57.695541 -152.5439 57.711102 
  -152.33749 57.80666 -152.3297 57.824989 -152.42171 57.817211 
  -152.43719 57.873051 -152.6281 57.92638 -152.6203 57.85638 
  -152.6917 57.88055 -152.7308 57.822491 -152.8134 57.856098 
  -152.85809 57.818878 -152.8578 57.734989 -152.8856 57.72887 
  -152.9247 57.768879 -152.9006 57.849991 -152.827 57.89555 
  -152.817 57.916931 -152.95 57.947208 -153.0114 57.926102 
  -153.26109 58.002491 -153.1367 57.896381 -153.0569 57.82526 
  -153.2397 57.896381 -153.1618 57.755581 -153.2131 57.788319 
  -153.4653 57.84193 -153.4648 57.797489 -153.3172 57.731659 
  -153.32809 57.71249 -153.3784 57.713039 -153.42081 57.767208 
  -153.49809 57.767769 -153.50951 57.74221 -153.43919 57.70443 
  -153.44 57.68943 -153.5036 57.708321 -153.50951 57.66444 
  -153.64169 57.889992 -153.7522 57.897209 -153.9303 57.805538 
  -153.92641 57.724991 -153.82719 57.697491 -153.61749 57.64138 
  -153.58749 57.599152 -153.7825 57.650829 -153.88029 57.64304 
  -153.84061 57.608879 -153.6817 57.544708 -153.76109 57.546379 
  -153.8325 57.581661 -153.85139 57.56749 -153.80811 57.400539 
  -153.7683 57.373878 -153.74809 57.302761 -153.8947 57.41444 
  -153.9745 57.56971 -153.99609 57.635269 -154.03 57.651371 
  -154.2408 57.666931 -154.3564 57.62582 -154.60339 57.525269 
  -154.7278 57.422211 -154.7047 57.335541 -154.7831 57.35915 
  -154.80251 57.33527 -154.5986 57.251381 -154.52609 57.141102 
  -154.53 56.990551 -154.4883 56.988602 -154.3008 56.90694 
  -154.29781 56.848881 -154.2561 56.877769 -154.1611 56.956928 
  -154.1006 57.10944 -154.1158 57.121929 -154.28391 57.112209 
  -154.3756 57.04665 -154.4539 57.058319 -154.485 57.1036 
  -154.4664 57.12693 -154.2245 57.154709 -153.9628 57.10944 
  -154.08389 57.064159 -154.13361 56.991379 -154.0692 56.968319 
  -154.00751 57.035259 -153.78419 57.15332 -153.7822 57.121101 
  -153.9492 57.009159 -153.96359 56.956661 -153.882 56.968319 
  -153.85471 57.019711 -153.82719 57.010269 -153.8392 56.96888 
  -154.0714 56.84388 -154.1494 56.746101 -154.13609 56.739712) 
#(8.6552773 56.67416 8.7699986 56.6936 8.8641663 56.78693 
  8.8455544 56.824429 8.8583317 56.886929 8.8977776 56.86832 
  8.9283333 56.973598 8.6466656 56.883881 8.6611099 56.809711 
  8.5452766 56.790539 8.5638885 56.737209 8.6552773 56.67416) 
#(-61.39085 56.618881 -61.36861 56.685822 -61.39307 56.779148 
  -61.481121 56.790539 -61.575562 56.75304 -61.58168 56.772209 
  -61.475288 56.842491 -61.439449 56.816101 -61.35223 56.857769 
  -61.40472 56.879711 -61.355572 56.91082 -61.503059 56.951931 
  -61.631962 56.859711 -61.644451 56.73444 -61.480289 56.64082 
  -61.39085 56.618881) #(10.33982 56.616779 10.36361 56.644989 
  10.33861 56.695271 10.23472 56.688599 9.8644428 56.638321 
  10.15944 56.720539 10.20639 56.701382 10.3425 56.71804 
  10.30528 56.748051 10.26917 56.91721 10.30972 56.983879 
  9.9813633 57.077869) #(-5.2630558 57.9711 -5.186389 57.941101 
  -5.2199998 57.919159 -5.1355562 57.885269 -5.0774999 57.828602 
  -5.3388891 57.920818 -5.2222219 57.84388 -5.4252791 57.902489 
  -5.4727778 57.848598 -5.6113892 57.923599 -5.6505561 57.888321 
  -5.580833 57.82999 -5.585279 57.781101 -5.6619449 57.786098 
  -5.668889 57.82555 -5.7169452 57.869431 -5.8055558 57.84832 
  -5.8055558 57.74332 -5.708056 57.728039 -5.688056 57.687481 
  -5.7852778 57.695271 -5.8105559 57.63776 -5.7150002 57.57888 
  -5.521667 57.549431 -5.5119448 57.531651 -5.6358342 57.525829 
  -5.7066669 57.539989 -5.8397231 57.572769 -5.8519449 57.538879 
  -5.8252778 57.383041 -5.7836108 57.34193 -5.7408342 57.346661 
  -5.6202779 57.414989 -5.606668 57.38805 -5.6361108 57.369431 
  -5.5536122 57.357769 -5.458056 57.42165 -5.4527779 57.396099 
  -5.520834 57.35915 -5.690556 57.340549 -5.7024999 57.280819 
  -5.4575 57.31971 -5.5086122 57.27277 -5.4758339 57.258598 
  -5.4500008 57.221371 -5.5369449 57.269989 -5.6372218 57.244431 
  -5.6755562 57.171101 -5.6675 57.142769 -5.400001 57.10582 
  -5.6541672 57.123051 -5.7813892 57.074989 -5.7844448 57.049431 
  -5.6758342 57.035549 -5.6491671 56.972759 -5.732779 57.019428 
  -5.8297219 57.00082 -5.876112 56.911098 -5.7388902 56.888882 
  -5.793056 56.838039 -5.856668 56.813042 -5.7855558 56.790821 
  -6.1522231 56.755821 -6.2350011 56.71027 -6.209167 56.684158 
  -6.147223 56.68082 -5.5675001 56.694149 -5.9930558 56.647491 
  -6.0094452 56.621929 -5.9305558 56.56971 -5.768333 56.53194 
  -5.6505561 56.502769 -5.481945 56.610821 -5.1219449 56.812771) 
#(-132.7731 56.494709 -132.735 56.523041 -132.74249 56.555271 
  -132.68359 56.52026 -132.5309 56.57777 -132.5334 56.59943 
  -132.802 56.786381 -132.92059 56.819149 -132.9639 56.796379 
  -132.88341 56.630821 -132.95641 56.594151 -132.9267 56.502769 
  -132.7731 56.494709) #(8.5855541 57.100819 8.4505539 57.00499 
  8.2422218 56.79443 8.2402763 56.707211 8.2647209 56.703602 
  8.2514725 56.771881 8.2844429 56.766651 8.5549984 56.582489 
  8.6072216 56.63055 8.519722 56.684711 8.5255547 56.711651 
  8.4747219 56.714432 8.4891663 56.790272 8.5724983 56.819439 
  8.6733322 56.947208 8.7469444 56.95277 9.0633316 57.022491 
  9.1155548 57.052761 9.2438889 56.995541 9.3180542 57.01638 
  9.579443 57.042759 9.8008327 57.102489 9.9180546 57.055538 
  9.6861095 57.038601 9.6624985 57.000271 9.5788879 56.966648 
  9.5466652 57.008041 9.4097214 57.018318 9.2436104 56.96582 
  9.1655521 56.889431 9.2119427 56.85693 9.1733322 56.799431 
  9.2394428 56.730549 9.1905537 56.699162 9.1808319 56.66943 
  9.3019428 56.702209 9.3297215 56.653049 9.2941666 56.558601 
  9.373888 56.566929 9.3711109 56.540821 9.3124981 56.525539 
  9.2508316 56.580269 9.2880554 56.620541 9.248888 56.63332 
  9.1519432 56.612492 9.0641651 56.563042 9.0438881 56.595829 
  9.0552769 56.63055 9.1733322 56.71526 9.0699997 56.80777 
  8.9374981 56.795551 8.8383331 56.71249 8.8772221 56.70332 
  8.6808319 56.614159 8.7661095 56.558601 8.7283335 56.482208 
  8.6266651 56.4786 8.5672207 56.572769 8.3694439 56.580269 
  8.3019428 56.54916 8.2038879 56.63805 8.2377777 56.687771 
  8.2166653 56.710541 8.1947212 56.69138 8.1372204 56.58276) 
#(-133.63251 56.43721 -133.4189 56.454708 -133.4292 56.50193 
  -133.3347 56.470829 -133.14861 56.458599 -133.1194 56.488319 
  -133.1292 56.524151 -133.0811 56.528599 -133.11391 56.600552 
  -133.105 56.618881 -133.242 56.636379 -133.2117 56.708881 
  -133.2339 56.740822 -133.30859 56.735821 -133.3425 56.839432 
  -133.222 56.788601 -133.1875 56.716648 -133.0114 56.599709 
  -132.9364 56.624981 -132.9247 56.659988 -132.9895 56.812771 
  -132.9278 56.860271 -133.0517 56.977489 -133.0997 56.99638 
  -133.297 56.993599 -133.2534 56.946098 -133.2803 56.927212 
  -133.3253 56.996929 -133.88341 57.086102 -134.0078 57.057491 
  -134.0181 57.014709 -133.75639 56.873878 -133.86279 56.898319 
  -133.8797 56.87804 -133.7739 56.821381 -133.6714 56.84832 
  -133.707 56.677761 -133.65919 56.6311 -133.645 56.563599 
  -133.6609 56.51804 -133.63251 56.43721) 
#(-3.325278 56.359989 -3.081111 56.448601 -2.9102781 56.463871 
  -2.7341671 56.458599 -2.5247231 56.5811 -2.415556 56.758598 
  -2.3094449 56.80471 -2.0494449 57.113319 -2.075278 57.151371 
  -2.0455561 57.22916 -1.763056 57.466648 -1.799445 57.54332 
  -1.9299999 57.677761 -2.2463889 57.684158 -2.3411109 57.669708 
  -2.790833 57.702492 -3.041945 57.662209 -3.198056 57.686378 
  -3.414444 57.716648 -3.5272231 57.661098 -3.606945 57.653599 
  -4.081944 57.579708 -4.0386109 57.557209 -4.1180558 57.51749 
  -4.248889 57.49527 -4.02 57.657768 -4.0111108 57.682209 
  -4.249445 57.659431 -4.4150009 57.572769 -4.4305558 57.582211 
  -4.3294449 57.646381 -4.019444 57.728039 -4.0291672 57.694149 
  -3.968889 57.702492 -3.7994449 57.826931 -3.7886109 57.861099 
  -3.936389 57.80444 -4.2347231 57.852772 -4.0111108 57.861099 
  -4.0572219 57.94804 -3.979445 57.960541) 
#(-6.2649999 56.258881 -5.8602781 56.35194 -5.8405561 56.30888 
  -5.7022228 56.35915 -5.7033339 56.375542 -5.7872229 56.367771 
  -5.6633339 56.39555 -5.6513891 56.451099 -5.7230558 56.483318 
  -5.9627781 56.52277 -6.0061111 56.591099 -6.1169448 56.650269 
  -6.2691669 56.61166 -6.3177791 56.585819 -6.12639 56.473881 
  -6.0322232 56.492489 -6.0100002 56.470268 -6.2030559 56.37804 
  -6.1852779 56.356659 -6.0958338 56.36665 -6.018889 56.369709 
  -6.1747231 56.3311 -6.290833 56.339989 -6.3638902 56.32999 
  -6.3613892 56.302761 -6.2649999 56.258881) 
#(-132.8342 56.23082 -132.6622 56.27055 -132.6347 56.298321 
  -132.66341 56.350552 -132.6142 56.396381 -132.70309 56.4561 
  -132.94031 56.447769 -133.0578 56.347488 -133.04781 56.333881 
  -132.8342 56.23082) #(16.43722 56.21138 16.50666 56.25832 
  16.699169 56.648602 16.806391 56.818878 16.85833 56.891102 
  17.110279 57.338039 17.05666 57.35915 16.97333 57.305271 
  16.727779 56.89193 16.61194 56.86832 16.39333 56.529148 
  16.40333 56.274151 16.43722 56.21138) 
#(-80.060837 56.184429 -79.980011 56.201649 -79.663361 56.333881 
  -79.555557 56.4986 -79.598068 56.45443 -79.698898 56.368881 
  -80.044724 56.310822 -80.107788 56.194988 -80.060837 56.184429) 
#(-134.6472 56.181099 -134.6564 56.580269 -134.61 56.57555 
  -134.7567 57.070541 -134.79201 57.075821 -134.797 57.160549 
  -134.8192 57.19276 -134.97639 57.304989 -134.9059 57.329708 
  -134.98199 57.389709 -135.10471 57.431381 -135.15359 57.448601 
  -135.1861 57.483318 -135.4059 57.447491 -135.2809 57.50943 
  -135.3192 57.536381 -135.4075 57.553322 -135.51421 57.50721 
  -135.60361 57.381649 -135.5108 57.369991 -135.47591 57.347488 
  -135.655 57.36388 -135.6725 57.346371 -135.5322 57.22971 
  -135.3331 57.244431 -135.4061 57.149712 -135.3717 57.14555 
  -135.33749 57.177761 -135.265 57.159161 -135.3717 57.132771 
  -135.3781 57.098598 -135.33 57.052212 -135.24361 57.03054 
  -135.1992 57.044708 -135.15891 57.008041 -135.3764 56.940269 
  -135.3089 56.913319 -135.2903 56.880821 -135.36501 56.88026 
  -135.3672 56.828041 -135.33611 56.819149 -135.12 56.827492 
  -135.1947 56.69693 -135.16141 56.6786 -135.0425 56.75499 
  -135.12531 56.658039 -135.0995 56.59388 -135.04089 56.615261 
  -134.9953 56.6936 -134.93719 56.709991 -134.9825 56.635818 
  -134.95329 56.623051 -134.88721 56.683319 -134.8459 56.68166 
  -135.03889 56.561649 -134.7995 56.26054 -134.67529 56.2136 
  -134.6472 56.181099) #(12.55663 56.179409 12.48139 56.28138 
  12.47389 56.297211 12.70889 56.218601 12.81333 56.232769 
  12.83305 56.269161 12.62278 56.39999 12.63194 56.436939 
  12.67972 56.466381 12.86861 56.44138 12.91083 56.46693 
  12.93694 56.53249 12.86917 56.64888 12.72528 56.639709 
  12.63528 56.725819 12.59333 56.81749 12.35028 56.91444 
  12.33444 57.01638 12.23778 57.059711 12.19666 57.182209 
  12.09972 57.232491 12.11194 57.25943 12.14194 57.313599 
  12.04389 57.336929 12.095 57.426929 12.04389 57.459709 
  12.00778 57.428879 11.98611 57.341381 11.93194 57.35471 
  11.90639 57.623322 11.86472 57.602772 11.83167 57.675819 
  11.91722 57.696659 11.74139 57.688599 11.69972 57.71582 
  11.81167 57.78194 11.66222 57.841648 11.75722 57.897209 
  11.80139 58.03249 11.77667 58.059429 11.88611 58.211929 
  11.80694 58.275539 11.8575 58.34193 11.57222 58.246929 
  11.49083 58.240551 11.51389 58.299709 11.62139 58.385818 
  11.55556 58.410549 11.49222 58.301929 11.39861 58.259159 
  11.38833 58.301659 11.3925 58.330269 11.44778 58.33276 
  11.41972 58.385269 11.38639 58.3536 11.34528 58.348049 
  11.42611 58.438042 11.22833 58.336651 11.20611 58.404148 
  11.25694 58.419991 11.24861 58.480259 11.25667 58.522491 
  11.25222 58.653049 11.17805 58.713871 11.21083 58.75555 
  11.19417 58.917488 11.10694 58.949989 11.115 58.99194 
  11.11917 59.01582 11.17944 59.07193 11.315 59.101379 
  11.35 59.084431 11.42029 58.995998) 
#(-78.073273 58.45507 -78.059448 58.433041 -77.719177 58.292759 
  -77.182243 58.03915 -76.896118 57.761101 -76.740837 57.503319 
  -76.529739 57.10582 -76.555557 57.0261 -76.506958 56.808601 
  -76.538353 56.297771 -76.613922 56.159161) 
#(27.371099 57.5364 27.547199 57.5364 27.545799 57.4725 
  27.5256 57.445801 27.5383 57.430801 27.660601 57.397499 
  27.862801 57.298901 27.840799 57.163601 27.701401 57.119202 
  27.7775 57.0658 27.742201 57.006699 27.7439 56.979401 
  27.7017 56.9147 27.663099 56.894699 27.639999 56.848099 
  27.807199 56.878899 27.8606 56.8689 27.935301 56.827202 
  27.933599 56.801102 27.886101 56.766102 27.886101 56.7472 
  28.004999 56.691399 28.010799 56.624401 28.032801 56.593102 
  28.1525 56.554401 28.1131 56.5056 28.189699 56.440601 
  28.184401 56.374699 28.237801 56.271099 28.202801 56.229698 
  28.195 56.177502 28.166498 56.150318) 
#(-78.927513 56.11388 -78.676392 56.181099 -78.660843 56.414711 
  -78.72139 56.442211 -78.767227 56.419991 -78.81723 56.295269 
  -78.916946 56.172489 -78.927513 56.11388) 
#(-132.05611 56.11137 -131.9203 56.207489 -132.00951 56.340549 
  -132.33611 56.479988 -132.3759 56.472488 -132.3261 56.399151 
  -132.3484 56.364429 -132.3311 56.256378 -132.05611 56.11137) 
#(21.049622 56.076775 21.039169 56.127491 20.98694 56.197769 
  21.005831 56.482769 21.02861 56.508041 21.06028 56.384159 
  21.081671 56.39888 21.057779 56.51054 20.99139 56.538052 
  21.060551 56.841648 21.35972 56.988602 21.41555 57.069439 
  21.420561 57.28944 21.62472 57.47887 21.754999 57.583321 
  21.953051 57.59193 22.49194 57.74221 22.614719 57.749989 
  22.58416 57.676102 22.612499 57.6161 22.860279 57.488319 
  23.13722 57.363041 23.259159 57.098049 23.580549 56.978321 
  23.683611 56.96526 23.89444 56.995541 24.333611 57.197491 
  24.413059 57.27277 24.387779 57.421101 24.376381 57.620541 
  24.297131 57.73642) #(-134.1067 55.999149 -134.0872 56.0811 
  -134.10561 56.14249 -134.1561 56.1311 -134.1814 56.183041 
  -134.0945 56.17971 -134.05251 56.312481 -134.0267 56.287209 
  -134.0314 56.101379 -133.955 56.083321 -133.9364 56.11665 
  -133.9478 56.199711 -133.89079 56.233601 -133.9225 56.27943 
  -133.98421 56.268879 -133.9686 56.361099 -133.9189 56.321098 
  -133.8492 56.284161 -133.8445 56.348881 -133.9147 56.370541 
  -133.9025 56.394989 -133.8286 56.44054 -133.9192 56.506378 
  -133.845 56.577209 -133.92059 56.614159 -133.82201 56.608318 
  -133.75281 56.55471 -133.69141 56.599709 -133.7261 56.627769 
  -133.72839 56.774429 -133.87469 56.80415 -133.8622 56.723598 
  -133.94591 56.646381 -133.9675 56.654991 -133.91969 56.727211 
  -133.9875 56.870819 -134.0869 56.89888 -134.2636 56.936939 
  -134.1514 56.890541 -134.1153 56.841381 -134.3147 56.897209 
  -134.3336 56.871658 -134.272 56.801659 -134.2917 56.786098 
  -134.35201 56.85638 -134.3933 56.85638 -134.40891 56.82943 
  -134.37469 56.6936 -134.3073 56.65749 -134.2234 56.693321 
  -134.2081 56.670269 -134.2486 56.64193 -134.1275 56.649712 
  -134.0947 56.625542 -134.3064 56.560261 -134.22701 56.557491 
  -134.12421 56.486938 -134.06841 56.555271 -134.02859 56.472488 
  -134.0692 56.46471 -134.03281 56.420269 -134.0495 56.35944 
  -134.10809 56.40527 -134.1553 56.364429 -134.18359 56.40694 
  -134.2317 56.419159 -134.2811 56.29137 -134.19949 56.319149 
  -134.16 56.296101 -134.2661 56.249989 -134.2458 56.165821 
  -134.1922 56.155819 -134.2364 56.112492 -134.162 56.022209 
  -134.1067 55.999149) #(-132.26559 55.91832 -132.17999 55.966099 
  -132.1667 55.931381 -132.12781 55.928322 -132.1156 55.95554 
  -132.1786 56.0411 -132.0903 56.099152 -132.1234 56.127491 
  -132.3595 56.216648 -132.3967 56.184719 -132.47839 56.189991 
  -132.38699 56.241379 -132.3903 56.336102 -132.52921 56.331928 
  -132.60339 56.23138 -132.6945 56.22221 -132.69591 56.17915 
  -132.69591 56.107769 -132.6256 56.047771 -132.59419 56.081379 
  -132.3756 56.022209 -132.4256 55.9561 -132.26559 55.91832) 
#(-130.0162 55.912411 -130.0051 55.923069) 
#(-133.6953 55.896381 -133.6433 55.93721 -133.617 55.959431 
  -133.5856 55.945271 -133.4772 56.02277 -133.3045 56.000271 
  -133.2878 56.033871 -133.3139 56.081379 -133.2856 56.12888 
  -133.3145 56.149151 -133.5006 56.115822 -133.61031 56.13332 
  -133.6203 56.114159 -133.5811 56.100269 -133.4897 56.0811 
  -133.68559 56.06221 -133.79311 55.948318 -133.7856 55.916931 
  -133.6953 55.896381) #(-79.763062 55.79166 -79.631119 55.899151 
  -79.56778 55.864712 -79.485291 55.86137 -79.435562 55.898041 
  -79.237808 56.147671 -79.144447 56.232208 -79.126404 56.173038 
  -79.219177 55.971661 -79.061401 56.199162 -79.091133 56.209431 
  -79.043327 56.360538 -78.97084 56.383598 -78.970573 56.314159 
  -79.200287 55.90221 -79.003891 56.20443 -78.879997 56.313881 
  -78.90834 56.34304 -78.936111 56.428879 -79.039169 56.428879 
  -79.100014 56.463039 -79.126678 56.524712 -79.253067 56.550819 
  -79.249184 56.60582 -79.284729 56.6036 -79.301392 56.447208 
  -79.427231 56.203041 -79.535278 56.178322 -79.575012 56.14526 
  -79.519997 56.220829 -79.419724 56.4436 -79.436401 56.525829 
  -79.47139 56.54443 -79.466667 56.424709 -79.550293 56.256378 
  -79.733902 56.163601 -80.025009 55.901371 -79.90918 55.840549 
  -79.567497 56.11277 -79.497223 56.133598 -79.470573 56.104431 
  -79.763062 55.814159 -79.763062 55.79166) 
#(-5.9722219 55.788319 -5.9505558 55.818878 -5.686389 56.113041 
  -5.6963892 56.142208 -5.9683342 56.023602 -5.9950008 55.972759 
  -5.8899999 55.966648 -6.022779 55.938042 -6.0883341 55.877491 
  -6.063334 55.803879 -5.9722219 55.788319) 
#(26.614086 55.676048 26.661699 55.705799 26.7453 55.686699 
  26.85 55.7108 26.9081 55.778599 26.99 55.834702 
  27.156099 55.846401 27.2822 55.787201 27.3508 55.826401 
  27.4 55.803902 27.6014 55.791901 27.632799 55.840599 
  27.6472 55.924198 27.7911 55.988899 27.795601 56.025299 
  27.893299 56.065601 27.929399 56.1133 28.0583 56.136398 
  28.118299 56.167198 28.166498 56.150318) 
#(26.614086 55.676048 26.510799 55.683899 26.3386 55.726398 
  26.2689 55.769402 26.198099 55.862499 26.0028 55.958302 
  25.715 56.09 25.684999 56.151699 25.593901 56.148102 
  25.546101 56.172501 25.4958 56.1567 25.327499 56.169201 
  25.096901 56.201099 25.047199 56.270802 25.0 56.295601 
  24.922199 56.439999 24.8997 56.4506 24.8722 56.4436 
  24.864401 56.4128 24.7267 56.3978 24.653299 56.365799 
  24.5583 56.2883 24.473301 56.269199 24.339701 56.310799 
  24.1478 56.261398 23.9489 56.332199 23.746401 56.3358 
  23.7411 56.360001 23.651899 56.360298 23.596901 56.362202 
  23.525299 56.334202 23.296101 56.380798 23.171101 56.3619 
  23.1803 56.3456 23.0961 56.305801 23.0375 56.328602 
  22.9928 56.393101 22.941401 56.423901 22.8272 56.3792 
  22.691401 56.356701 22.623301 56.386902 22.519199 56.4044 
  22.248899 56.397499 22.1544 56.424198 22.0672 56.419399 
  21.7094 56.3153 21.591101 56.3186 21.5625 56.293301 
  21.427799 56.241901 21.354401 56.240002 21.2444 56.168301 
  21.2181 56.09 21.049622 56.076775) 
#(-6.2672219 55.57304 -6.1399999 55.626659 -6.0261121 55.68499 
  -6.0977778 55.79665 -6.1194448 55.91721 -6.2663889 55.879711 
  -6.3175001 55.826099 -6.3225002 55.888599 -6.4500008 55.848598 
  -6.4544449 55.766651 -6.4952779 55.733601 -6.50139 55.673321 
  -6.4627781 55.67387 -6.3255558 55.78138 -6.251112 55.767208 
  -6.3261118 55.718601 -6.2450008 55.653599 -6.3227792 55.610821 
  -6.2672219 55.57304) #(-5.1544452 55.43277 -5.0750008 55.463329 
  -5.1297231 55.613319 -5.168334 55.684158 -5.2655559 55.717209 
  -5.3813901 55.668598 -5.4002781 55.600552 -5.3516669 55.551929 
  -5.3575001 55.504162 -5.273056 55.443878 -5.1544452 55.43277) 
#(16.702351 57.74226 16.618891 57.771381 16.7125 57.699989 
  16.574169 57.70332 16.625549 57.619709 16.55722 57.589161 
  16.55361 57.622211 16.51833 57.584431 16.6325 57.552212 
  16.693331 57.469151 16.627781 57.436378 16.664721 57.40749 
  16.555 57.383598 16.537781 57.364159 16.56889 57.334709 
  16.472219 57.290272 16.460279 57.167488 16.56444 57.081661 
  16.44194 57.044991 16.41444 56.786098 16.451941 56.790272 
  16.465269 56.764992 16.35639 56.757771 16.377501 56.697491 
  16.36083 56.65332 16.272499 56.656651 16.21611 56.607208 
  16.215 56.544159 16.171671 56.527489 16.088051 56.389709 
  15.85305 56.07555 15.78555 56.106098 15.82028 56.161098 
  15.7375 56.160549 15.5875 56.160259 15.58139 56.203602 
  15.30194 56.136379 14.69055 56.157768 14.68194 56.115551 
  14.75083 56.059711 14.76056 56.026661 14.66805 56.002769 
  14.62083 56.02943 14.54417 56.05249 14.33028 55.936939 
  14.20778 55.812481 14.19611 55.71582 14.35194 55.564991 
  14.36555 55.526661 14.19694 55.386929 14.11055 55.380821 
  13.93583 55.431381 13.7825 55.421379) 
#(9.6211109 55.35638 9.5969429 55.373322 9.6658335 55.459709 
  9.6497211 55.477211 9.5788879 55.486931 9.5030537 55.49194 
  9.7513885 55.559711 9.8452759 55.622761 9.6166649 55.694988 
  9.8116655 55.66943 10.01833 55.70776 10.01167 55.75721 
  10.04861 55.81443 9.873888 55.837769 9.8805542 55.85165 
  10.11305 55.87471 10.15055 55.834991 10.19305 55.83305 
  10.27972 56.018879 10.2625 56.051102 10.21917 56.151661 
  10.40055 56.290821 10.50833 56.264992 10.35305 56.195271 
  10.40667 56.157211 10.46639 56.177761 10.52278 56.153599 
  10.49416 56.134991 10.52417 56.098598 10.57555 56.11665 
  10.55528 56.176929 10.62556 56.228321 10.69055 56.21777 
  10.66944 56.165539 10.73306 56.148602 10.76056 56.2286 
  10.82861 56.258881 10.96083 56.444988 10.84417 56.52388 
  10.72333 56.528599 10.41472 56.528049 10.31917 56.598881 
  10.22694 56.54443 10.22611 56.489159 10.20944 56.55138 
  10.33982 56.616779) #(13.7825 55.421379 13.78139 55.42165 
  13.36472 55.33971 13.22778 55.35915 12.8275 55.387211 
  12.8675 55.438599 12.93556 55.415539 12.9625 55.43388 
  12.91639 55.544159 12.92528 55.577209 13.045 55.632488 
  13.05472 55.697769 12.91222 55.757771 12.76583 55.964989 
  12.55663 56.179409) #(20.932032 55.290062 21.004999 55.35582 
  21.092501 55.531101 21.086241 55.706299 21.11116 55.668911 
  21.10194 55.41415 20.96858 55.280033) 
#(20.96858 55.280033 20.932032 55.290062) 
#(11.74111 55.915821 11.67417 55.91444 11.66833 55.89526 
  11.73055 55.835541 11.72556 55.81443 11.66444 55.8111 
  11.62389 55.775539 11.73639 55.793049 11.77028 55.718319 
  11.79444 55.661652 11.83722 55.71804 11.95667 55.8461 
  11.91805 55.901661 11.92028 55.92971 11.99278 55.9011 
  12.02833 55.822491 12.05083 55.72443 11.92916 55.67416 
  11.99944 55.695271 12.05722 55.65332 12.09389 55.711102 
  12.06472 55.813881 12.0075 55.959431 11.87611 55.9361 
  11.85361 55.963039 12.11167 56.07526 12.30167 56.128601 
  12.51889 56.086102 12.61806 56.033871 12.53472 55.95388 
  12.60028 55.704151 12.51278 55.635269 12.38389 55.611099 
  12.2425 55.5411 12.19194 55.46027 12.22778 55.426102 
  12.37667 55.39526 12.45278 55.333599 12.44333 55.272491) 
#(21.271309 55.249691 21.251659 55.368038 21.182779 55.344711 
  21.24778 55.459148 21.058331 55.781651 21.067221 55.991379 
  21.049622 56.076775) #(-131.21111 55.187771 -131.14281 55.19693 
  -131.0428 55.27721 -131.0217 55.410549 -130.9644 55.397491 
  -130.98219 55.474709 -130.93671 55.579151 -130.9678 55.698318 
  -131.2317 55.95388 -131.57719 55.901371 -131.5464 55.855259 
  -131.4653 55.84499 -131.4583 55.824162 -131.6839 55.833321 
  -131.6797 55.79137 -131.522 55.8186 -131.4903 55.778599 
  -131.59419 55.77055 -131.71561 55.720268 -131.69611 55.698601 
  -131.6295 55.73082 -131.51311 55.726379 -131.7003 55.665272 
  -131.7 55.615551 -131.6167 55.591381 -131.82001 55.467491 
  -131.81841 55.446098 -131.67999 55.351379 -131.5153 55.296101 
  -131.4606 55.367771 -131.52 55.476379 -131.4906 55.50721 
  -131.4189 55.519711 -131.47 55.476101 -131.4192 55.37582 
  -131.4556 55.32555 -131.3945 55.352772 -131.31531 55.462212 
  -131.36749 55.60582 -131.3419 55.641651 -131.2814 55.489159 
  -131.29089 55.411098 -131.457 55.303051 -131.455 55.27721 
  -131.3889 55.25499 -131.29311 55.27388 -131.25391 55.321659 
  -131.2747 55.35944 -131.26109 55.39138 -131.19611 55.393318 
  -131.19611 55.349152 -131.3067 55.234989 -131.21111 55.187771) 
#(-160.8114 55.117489 -160.68111 55.208599 -160.6792 55.163879 
  -160.6136 55.150539 -160.4622 55.193321 -160.57249 55.228321 
  -160.58279 55.316929 -160.53391 55.350269 -160.5439 55.38554 
  -160.575 55.387489 -160.66859 55.297211 -160.6967 55.319439 
  -160.66 55.34026 -160.66141 55.387211 -160.6956 55.39999 
  -160.7314 55.40638 -160.8484 55.330269 -160.8114 55.117489) 
#(-156.77859 59.151249 -156.86 58.99416 -156.9839 58.939709 
  -157.07471 58.740551 -157.05499 58.722488 -157.1067 58.70332 
  -157.5006 58.46526 -157.565 58.3036 -157.457 58.209991 
  -157.2328 58.213329 -157.1386 58.162491 -157.39101 58.18961 
  -157.4364 58.169159 -157.54111 58.169159 -157.5986 58.10944 
  -157.6425 57.86916 -157.7067 57.643318 -157.6823 57.613319 
  -157.6214 57.61832 -157.5842 57.486931 -157.4362 57.503521 
  -157.4447 57.549431 -157.3889 57.559158 -157.4053 57.52026 
  -157.412 57.484989 -157.6572 57.474709 -157.68671 57.538879 
  -157.6786 57.56749 -157.8161 57.538319 -158.0433 57.413601 
  -158.28529 57.324162 -158.54089 57.1436 -158.7 56.977211 
  -158.64059 56.761101 -158.9583 56.833881 -158.98109 56.779148 
  -159.02969 56.806381 -159.2395 56.723598 -159.7717 56.562771 
  -160.36749 56.269989 -160.5753 55.992771 -160.53391 55.96888 
  -160.5695 55.92971 -160.517 55.935822 -160.2336 55.836929 
  -160.3147 55.822208 -160.24969 55.77055 -160.4711 55.79665 
  -160.4814 55.849709 -160.7975 55.872211 -160.66029 55.726101 
  -160.69749 55.697208 -161.017 55.87888 -161.0217 55.90694 
  -160.96249 55.936649 -160.86279 55.93832 -160.8895 55.99527 
  -161.06841 55.93499 -161.31841 55.950821 -161.645 55.913319 
  -162.0892 55.759708 -162.3842 55.574429 -162.5959 55.436649 
  -162.4986 55.438881 -162.4942 55.371101 -162.66389 55.34832 
  -162.8903 55.266102 -162.8847 55.239429 -162.8456 55.242489 
  -162.8394 55.21804 -162.96609 55.16415 -163.0786 55.18277 
  -163.0397 55.214432 -163.3259 55.11404) 
#(10.75805 55.10194 10.78806 55.140541 10.78167 55.301929 
  10.83472 55.29388 10.76333 55.388321 10.66667 55.451649 
  10.74444 55.496658 10.61028 55.611099) 
#(-7.253056 55.070541 -7.1594448 55.145821 -6.9644451 55.208881 
  -6.938612 55.2411 -7.2676539 55.355061) 
#(10.61028 55.611099 10.60028 55.482769 10.42555 55.438599 
  10.42222 55.464432 10.49083 55.493599 10.47694 55.529991 
  10.53583 55.526932 10.29889 55.61665 9.8833332 55.505821 
  9.8058319 55.544991 9.6783333 55.494431 9.8427773 55.39526 
  9.7819443 55.374981 9.873333 55.324429 9.9083328 55.22665 
  9.9980555 55.191101 10.10833 55.186378 10.15444 55.12693 
  10.07028 55.08527 10.50972 55.02832 10.74028 55.067211 
  10.75805 55.10194) #(-76.613922 56.159161 -76.682243 56.033871 
  -77.131393 55.719151 -77.184448 55.67416 -77.225853 55.588329 
  -77.665009 55.366379 -77.783073 55.269161 -77.944458 55.216648 
  -78.501404 55.001659) #(15.07667 55.001099 15.15 55.089161 
  15.13416 55.144161 14.93667 55.21582 14.77639 55.30027 
  14.69889 55.214989 14.68583 55.0961 14.89528 55.025539 
  15.07667 55.001099) #(-84.098343 55.272209 -84.206947 55.295551 
  -84.599457 55.24165 -85.0439 55.292759 -85.180008 55.253601 
  -85.241119 55.20277 -85.393341 55.002491 -85.425003 55.000271 
  -85.271118 55.21999 -85.129463 55.297771 -85.116669 55.32304 
  -85.146118 55.354988 -85.272232 55.37471 -85.499451 55.47221 
  -85.532227 55.528049 -85.731949 55.636929 -86.277237 55.72887 
  -86.468613 55.80582 -87.280838 55.956379 -87.343903 55.983879 
  -87.368896 56.00082 -87.572243 56.047211 -87.583618 56.076099 
  -87.982788 56.441662 -88.239464 56.511929 -88.831123 56.801659 
  -88.839737 56.841099 -88.944458 56.844151 -89.843613 56.98111 
  -90.451134 57.193878 -90.944458 57.25721 -91.38945 57.18832 
  -92.204727 57.024151 -92.303337 56.967491 -92.469452 56.93499 
  -92.237793 57.044991 -92.235573 57.066101 -92.475281 57.037491 
  -92.7314 56.922489 -92.715843 56.947491 -92.563904 57.068878 
  -92.428337 57.258041 -92.426392 57.351379 -92.710281 57.7836 
  -92.781403 57.834709 -92.801392 58.03249 -93.095573 58.467209 
  -93.157417 58.741219) #(-131.5733 54.995541 -131.52811 55.089161 
  -131.4753 55.000832 -131.37219 55.013599 -131.3428 55.067211 
  -131.3828 55.210541 -131.46719 55.235821 -131.4864 55.254429 
  -131.5836 55.25193 -131.577 55.19804 -131.5195 55.138882 
  -131.5231 55.11665 -131.5795 55.123051 -131.6217 55.015541 
  -131.5733 54.995541) #(-59.776169 55.32793 -59.811958 55.321659 
  -60.275291 55.034431 -60.288349 55.053322 -60.04084 55.252491 
  -60.040569 55.272209 -60.19445 55.192211 -60.16029 55.285549 
  -60.683331 54.994991 -60.67057 55.044708 -60.365841 55.236931 
  -60.373901 55.26054 -60.613899 55.164711 -60.51862 55.234989 
  -60.399731 55.289989 -60.35474 55.394989 -60.19334 55.427212 
  -60.218891 55.4911 -60.28112 55.49332 -60.28529 55.438042 
  -60.318069 55.44054 -60.32029 55.480549 -60.423901 55.421379 
  -60.420841 55.38221 -60.478611 55.347488 -60.452229 55.41943 
  -60.354729 55.490822 -60.316391 55.573879 -60.353901 55.574429 
  -60.432232 55.504711 -60.455009 55.506939 -60.390011 55.58638 
  -60.400848 55.608601 -60.4814 55.627769 -60.532791 55.587212 
  -60.487789 55.661098 -60.371948 55.678322 -60.329731 55.761379 
  -60.340012 55.786381 -60.433899 55.770821 -60.45834 55.798599 
  -60.519451 55.788052 -60.526119 55.740551 -60.62862 55.633598 
  -60.657509 55.66082 -60.592781 55.704151 -60.611401 55.794708 
  -60.640011 55.82555 -60.765011 55.728039 -60.865841 55.752491 
  -60.73307 55.80249 -60.73695 55.838329 -60.782791 55.85416 
  -61.001949 55.85387 -61.19862 55.876381 -61.18195 55.899151 
  -61.079441 55.89304 -61.07806 55.93277 -61.14389 55.970539 
  -61.415001 55.96027 -61.46085 55.988319 -61.39584 55.972488 
  -61.39085 55.998322 -61.474731 56.003319 -61.490009 56.02026 
  -61.265839 56.02277 -61.315571 56.06554 -61.411671 56.037491 
  -61.452511 56.062771 -61.341671 56.110538 -61.38361 56.132771 
  -61.406399 56.146099 -61.335011 56.186378 -61.388069 56.220829 
  -61.956951 56.220829 -62.067219 56.281101 -62.029732 56.305271 
  -61.753071 56.27776 -61.778629 56.254429 -61.661671 56.27026 
  -61.811668 56.305271 -61.652229 56.293049 -61.774731 56.339432 
  -61.798061 56.39526 -61.985001 56.415272 -62.11779 56.435551 
  -62.125 56.457211 -61.984459 56.452209 -61.946949 56.4711 
  -61.995571 56.483879 -61.755009 56.484989 -61.662231 56.5061 
  -61.65556 56.533871 -61.71973 56.573318 -62.09446 56.594711 
  -62.241112 56.623322 -62.02195 56.618038 -62.58556 56.792759 
  -62.50861 56.849991 -62.06723 56.834431 -62.05946 56.8186 
  -62.468899 56.798599 -62.49474 56.778049 -62.009178 56.66415 
  -61.895279 56.68082 -61.928341 56.647209 -61.79723 56.63026 
  -61.650291 56.635269 -61.65889 56.64777 -61.802231 56.686378 
  -61.73473 56.697208 -61.696949 56.724709 -61.759178 56.75193 
  -61.855839 56.75388 -61.86974 56.7136 -61.90028 56.707211 
  -61.906399 56.795269 -61.80946 56.787769 -61.646118 56.821098 
  -61.640011 56.883881 -61.495571 56.979431 -61.378059 56.982208 
  -61.346119 56.951099) #(8.1372204 56.58276 8.1308327 56.308319 
  8.1055546 56.118038 8.1138878 56.00082 8.141943 55.99638 
  8.1461105 56.111099 8.3111095 56.053051 8.394165 55.89193 
  8.186388 55.80999 8.1630554 55.936939 8.1261101 55.983051 
  8.1822205 55.723049 8.0913887 55.544708 8.2694445 55.48415 
  8.3286095 55.47332 8.2347221 55.55666 8.265276 55.573601 
  8.3324986 55.57555 8.4399986 55.452209 8.5994415 55.441101 
  8.6380539 55.40276 8.6913872 55.142208 8.6654568 55.133591 
  8.5544434 55.149712 8.5680542 55.193321 8.4830551 55.191101 
  8.4569445 55.123878 8.4874992 55.062771 8.5222206 55.072208 
  8.560276 55.14082 8.6822205 55.12999 8.6562958 54.9174) 
#(20.96858 55.280033 20.8675 55.17915 20.54472 54.974709 
  20.566389 54.937771 20.918051 54.900829 21.2225 54.931931 
  21.246941 54.95499 21.19639 55.11499 21.189989 55.206379 
  21.260281 55.20055 21.274441 55.2286 21.271309 55.249691) 
#(136.7408 54.881939 136.6705 54.9034 136.668 54.90723 
  136.7041 54.96777 137.1364 55.121658 137.18739 55.108601 
  137.1716 55.082211 137.06551 55.00526 137.0847 54.943321 
  137.0461 54.917488 136.8055 54.940269 136.7408 54.881939) 
#(-160.2045 54.872211 -160.1683 54.93499 -159.9472 55.073601 
  -159.97639 55.10165 -159.88361 55.09721 -159.8394 55.136929 
  -159.8322 55.183041 -159.91141 55.148041 -159.9086 55.187771 
  -159.8564 55.242771 -159.8717 55.278049 -159.94949 55.247211 
  -159.9608 55.161652 -160.0386 55.199162 -160.0625 55.188881 
  -160.02609 55.151932 -160.01331 55.104431 -160.1058 55.156101 
  -160.1942 55.112209 -160.11861 55.068321 -160.1714 55.05471 
  -160.0914 55.043598 -160.0997 55.029148 -160.2469 54.919159 
  -160.2256 54.875271 -160.2045 54.872211) 
#(9.9563885 54.858051 10.07306 54.880821 10.03 54.95055 
  9.7541656 55.084431 9.6394444 55.058601 9.6347218 55.044991 
  9.8361111 54.976379 9.8422222 54.939991 9.7605553 54.956379 
  9.8977776 54.899151 9.8758316 54.880821 9.9563885 54.858051) 
#(9.5031242 54.848251 9.601944 54.9286 9.6480541 54.913879 
  9.6141663 54.890541 9.7372208 54.82777 9.7519436 54.848049 
  9.7036095 54.892208 9.768055 54.891102 9.727499 54.989429 
  9.5916653 55.045551 9.5247211 55.02943 9.4344444 55.03471 
  9.5563889 55.083599 9.4661102 55.13055 9.6886101 55.19693 
  9.7111111 55.261101 9.6211109 55.35638) 
#(-163.3259 55.11404 -163.2886 54.999989 -163.2395 54.963871 
  -163.25841 54.941929 -163.3311 54.962769 -163.3522 54.919159 
  -163.2747 54.912769 -163.3817 54.851379 -163.32561 54.809158 
  -163.0428 54.94249 -163.0614 54.968319 -163.2039 55.011101 
  -163.22031 55.044159 -163.1844 55.139709 -163.065 55.101101 
  -162.9167 55.013321 -162.9747 54.994991 -162.87 54.929989 
  -162.74921 54.941662 -162.7119 54.985538 -162.6436 55.049431 
  -162.6114 55.011379 -162.65669 55.00555 -162.5578 54.959431 
  -162.5972 55.044991 -162.64639 55.072208 -162.59641 55.133598 
  -162.72169 55.21944 -162.7067 55.254429 -162.63699 55.297489 
  -162.56219 55.29332 -162.3694 55.094151 -162.5136 55.115261 
  -162.52499 55.090549 -162.45419 55.038319 -162.355 55.03582 
  -162.32091 55.06805 -162.2789 55.01749 -162.2242 55.024712 
  -162.1936 55.053879 -162.2267 55.106659 -162.1711 55.149429 
  -162.09641 55.162209 -162.11861 55.095829 -162.0461 55.074429 
  -161.95531 55.120819 -162.0442 55.227489 -162.0106 55.23666 
  -161.91859 55.219151 -161.6992 55.40554 -161.7114 55.514149 
  -161.5625 55.622761 -161.4128 55.631939 -161.1478 55.542488 
  -161.14169 55.522209 -161.187 55.51804 -161.3739 55.572769 
  -161.4856 55.481098 -161.5031 55.35944 -161.24361 55.348881 
  -160.92059 55.515541 -160.8331 55.513321 -160.8419 55.468319 
  -160.7856 55.446381 -160.6667 55.46582 -160.6595 55.50943 
  -160.7081 55.520821 -160.7664 55.5411 -160.59219 55.608318 
  -160.5894 55.551102 -160.52969 55.474152 -160.4731 55.493881 
  -160.4633 55.537491 -160.3653 55.607208 -160.4128 55.62804 
  -160.41811 55.651661 -160.2897 55.634708 -160.1342 55.671101 
  -160.15421 55.731098 -160.07581 55.696381 -160.0231 55.727211 
  -160.05811 55.765541 -160.03281 55.79137 -159.9745 55.775539 
  -159.9659 55.81638 -159.90469 55.78138 -159.8506 55.790272 
  -159.84109 55.851101 -159.70419 55.841099 -159.62061 55.8036 
  -159.6797 55.738041 -159.6317 55.694988 -159.7075 55.661652 
  -159.61501 55.634991 -159.6964 55.600552 -159.7386 55.565269 
  -159.6236 55.573318 -159.50391 55.765541 -159.55389 55.873322 
  -159.4731 55.89999 -159.47591 55.872211 -159.442 55.787769 
  -159.41141 55.793049 -159.4164 55.826382 -159.3597 55.875271 
  -159.02139 55.920269 -158.9567 55.93277 -158.92751 55.91444 
  -158.85471 56.010818 -158.7403 56.002209 -158.73531 55.949989 
  -158.6461 55.989712 -158.6478 56.0186 -158.7361 56.03693 
  -158.65919 56.066101 -158.6978 56.104431 -158.6897 56.148602 
  -158.6472 56.111099 -158.5634 56.164711 -158.6286 56.199989 
  -158.47141 56.178879 -158.5497 56.1436 -158.60471 56.045269 
  -158.56641 56.02388 -158.4969 55.990261 -158.4967 56.031651 
  -158.44 55.993599 -158.42 56.00943 -158.4283 56.039989 
  -158.4895 56.043049 -158.492 56.10165 -158.41611 56.062771 
  -158.40469 56.088329 -158.4395 56.126659 -158.39529 56.177212 
  -158.3575 56.124981 -158.2036 56.18388 -158.1342 56.239429 
  -158.3295 56.170818 -158.3206 56.202492 -158.3875 56.20805 
  -158.23531 56.258881 -158.21111 56.288601 -158.2608 56.30027 
  -158.4086 56.294159 -158.4478 56.34026 -158.5011 56.32888 
  -158.56531 56.284431 -158.5378 56.247211 -158.6095 56.255821 
  -158.6503 56.281651 -158.41499 56.446659 -158.1342 56.46249 
  -158.1284 56.492489 -157.877 56.467491 -157.8353 56.510818 
  -157.84891 56.557209 -157.92529 56.574162 -158.1122 56.5261 
  -158.11031 56.56805 -157.90311 56.650829 -157.7478 56.674431 
  -157.685 56.60915 -157.48109 56.615822 -157.4608 56.651371 
  -157.6003 56.71888 -157.5117 56.75832 -157.39639 56.76527 
  -157.4653 56.818878 -157.4503 56.84943 -157.36639 56.85165 
  -157.2775 56.79166 -157.16811 56.77832 -157.1456 56.811939 
  -157.1881 56.848049 -157.08749 56.823601 -157.022 56.894161 
  -156.94 56.912491 -156.9472 56.97665 -156.8317 56.893318 
  -156.79829 56.909431 -156.7592 56.99749 -156.795 57.033329 
  -156.7603 57.042759 -156.68469 56.996929 -156.54559 56.982491 
  -156.6403 57.056931 -156.56171 57.04332 -156.5014 57.052761 
  -156.4734 57.12138 -156.3683 57.14193 -156.34309 57.17971 
  -156.4464 57.224991 -156.34669 57.270821 -156.3689 57.310551 
  -156.55811 57.271381 -156.54581 57.315819 -156.2608 57.433319 
  -156.045 57.43388 -156.0256 57.455269 -156.07581 57.533039 
  -155.9211 57.526932 -155.82001 57.580269 -155.8033 57.54137 
  -155.7341 57.545151) #(-133.7695 58.51749 -133.92081 58.497761 
  -134.0114 58.39138 -133.98 58.31221 -134.06641 58.276932 
  -134.0695 58.101101 -134.05029 58.06776 -133.8983 57.976379 
  -133.79781 58.009708 -133.742 58.135818 -133.67081 58.14193 
  -133.7664 58.050541 -133.7256 58.00721 -133.6692 58.013882 
  -133.7 57.971371 -133.69971 57.935551 -133.7836 57.99165 
  -133.8558 57.95388 -133.70061 57.790272 -133.647 57.78582 
  -133.62219 57.810551 -133.6389 57.878319 -133.5894 57.859711 
  -133.5881 57.913052 -133.5481 57.924431 -133.1664 57.882771 
  -133.1328 57.850552 -133.5569 57.902489 -133.5497 57.809429 
  -133.51781 57.745819 -133.4003 57.71471 -133.56281 57.709709 
  -133.6436 57.700821 -133.6483 57.60944 -133.54919 57.565819 
  -133.3575 57.59193 -133.32111 57.579708 -133.44611 57.569439 
  -133.4967 57.53194 -133.4953 57.462769 -133.4344 57.419159 
  -133.35609 57.42971 -133.3409 57.40638 -133.452 57.374439 
  -133.4323 57.346931 -133.3419 57.32777 -133.0334 57.348049 
  -133.0589 57.32777 -133.472 57.27943 -133.547 57.175541 
  -133.2964 57.096661 -133.2608 57.11137 -133.2345 57.174709 
  -133.20309 57.136379 -133.1572 57.16444 -133.1145 57.144428 
  -133.16451 57.083881 -132.9722 57.03194 -132.7914 57.088039 
  -132.7664 56.989712 -132.7742 56.958321 -132.92329 56.97694 
  -132.7464 56.834148 -132.495 56.75082 -132.52609 56.708599 
  -132.455 56.67194 -132.5392 56.658329 -132.54781 56.627769 
  -132.44749 56.6036 -132.30499 56.633881 -132.35139 56.542488 
  -132.33141 56.515541 -132.2361 56.484989 -131.97031 56.357208 
  -131.90559 56.2286 -131.4903 56.220829 -131.5975 56.169159 
  -131.7697 56.19693 -131.9631 56.160259 -131.9436 55.995541 
  -132.0611 55.93721 -132.0322 55.89082 -132.08279 55.844711 
  -132.04781 55.80582 -132.1833 55.78944 -132.1683 55.721931 
  -132.205 55.73666 -132.2664 55.750542 -132.1911 55.613319 
  -132.1431 55.56749 -131.955 55.501099 -131.92281 55.55138 
  -131.9986 55.664989 -131.8795 55.598598 -131.81531 55.66943 
  -131.8631 55.725269 -131.787 55.743599 -131.7536 55.813042 
  -131.9156 55.858318 -131.8528 55.86499 -131.4097 56.00555 
  -131.3734 55.96249 -131.32249 55.964989 -131.0103 56.10638 
  -131.1172 56.022209 -131.1983 55.969151 -130.957 55.776932 
  -130.8858 55.705269 -130.8667 55.31332 -130.84309 55.300819 
  -130.6503 55.333599 -130.63699 55.302212 -130.6331 55.287769 
  -130.93719 55.283039 -131.05 55.20499 -131.07001 55.173599 
  -131.01221 55.086651 -130.9122 55.090549 -130.81641 55.142769 
  -130.75391 55.09277 -130.7278 55.076099 -130.8394 55.103039 
  -130.9847 55.045818 -130.9325 54.871929 -130.89391 54.78054 
  -130.8192 54.767769 -130.787 54.794159 -130.7478 54.963329 
  -130.7242 54.944149 -130.6828 54.79694 -130.72839 54.790539 
  -130.7128 54.767769 -130.6722 54.767208 -130.57581 54.857769 
  -130.60451 54.800541 -130.5795 54.796101 -130.3495 54.917759 
  -130.2097 55.081928 -129.99139 55.28693 -130.1436 55.558041 
  -130.17419 55.759991 -130.0162 55.912411) 
#(-58.031399 54.75388 -57.86195 54.800541 -57.864719 54.832211 
  -57.983891 54.802212 -57.94083 54.91193 -58.08334 54.87693 
  -58.218899 54.875271 -58.22279 54.830269 -58.159451 54.761379 
  -58.031399 54.75388) #(10.70361 54.725552 10.73833 54.73888 
  10.81167 54.886101 10.95889 55.14777 10.89639 55.12027 
  10.68111 54.904991 10.72666 54.88055 10.60333 54.833881 
  10.70361 54.725552) #(-132.00391 54.69054 -132.00639 54.779709 
  -131.94949 54.788319 -131.95531 54.82193 -132.0508 54.884991 
  -132.03889 54.90443 -131.972 54.894989 -131.97501 54.990822 
  -131.97861 55.03194 -132.0889 54.974709 -132.2186 54.992489 
  -132.0728 55.03915 -132.12061 55.065819 -132.0508 55.076649 
  -131.9922 55.10582 -131.9686 55.226379 -132.0106 55.27277 
  -132.1097 55.196098 -132.2056 55.221931 -132.22279 55.18832 
  -132.2475 55.201382 -132.2395 55.254711 -132.13091 55.23999 
  -132.08501 55.26804 -132.1534 55.363319 -132.4261 55.4086 
  -132.4583 55.382488 -132.48309 55.4011 -132.4447 55.421379 
  -132.28391 55.42915 -132.2814 55.45776 -132.5045 55.511379 
  -132.65311 55.418598 -132.67 55.462212 -132.58031 55.488041 
  -132.50951 55.556099 -132.5601 55.57304 -132.5197 55.61832 
  -132.15919 55.444439 -132.1375 55.46582 -132.1823 55.512489 
  -132.295 55.540821 -132.35001 55.64555 -132.3992 55.670818 
  -132.4359 55.623322 -132.4528 55.729431 -132.5659 55.879711 
  -132.8369 56.03249 -133.07809 56.05249 -133.13811 56.11694 
  -133.06281 56.118038 -133.0239 56.176659 -133.1781 56.328041 
  -133.267 56.325821 -133.2995 56.288879 -133.3239 56.326382 
  -133.5856 56.349709 -133.56531 56.29694 -133.6328 56.271099 
  -133.5692 56.17971 -133.3647 56.17194 -133.25529 56.14777 
  -133.27969 56.087212 -133.2433 56.031651 -133.257 55.944149 
  -133.18719 55.860538 -133.1539 55.872761 -133.1442 55.811939 
  -133.2506 55.74194 -133.31 55.756939 -133.33611 55.68082 
  -133.38499 55.65554 -133.3678 55.616379 -133.2536 55.573601 
  -132.9572 55.638882 -132.91251 55.622211 -133.0117 55.605259 
  -133.1286 55.494709 -133.0645 55.422771 -132.8475 55.35165 
  -133.2175 55.379162 -133.26221 55.332489 -133.19949 55.27388 
  -132.9006 55.279709 -132.9064 55.264149 -133.0056 55.22665 
  -133.0242 55.204708 -132.8656 55.224152 -132.83749 55.271648 
  -132.8075 55.248051 -132.76669 55.17527 -132.64861 55.139431 
  -132.60921 55.168049 -132.6472 55.205818 -132.6414 55.250271 
  -132.55969 55.165539 -132.6198 55.08749 -132.6097 55.058319 
  -132.5567 55.121929 -132.51199 55.10638 -132.54201 55.060822 
  -132.4586 55.043598 -132.5728 55.037209 -132.5322 55.016102 
  -132.5975 54.968601 -132.5403 54.93277 -132.50639 54.947491 
  -132.4883 54.999149 -132.4453 54.977772 -132.45081 54.94249 
  -132.50281 54.918598 -132.4753 54.900829 -132.41859 54.92165 
  -132.395 55.018879 -132.3875 54.964432 -132.26559 54.839432 
  -132.35339 54.799431 -132.23109 54.81638 -132.21359 54.788601 
  -132.2975 54.756649 -132.28419 54.711929 -132.00391 54.69054) 
#(8.6562958 54.9174 8.6422215 54.826382 8.6761093 54.779148 
  8.8056221 54.685219) #(-1.184956 54.674931 -1.256945 54.732491 
  -1.303889 54.80415 -1.445556 55.045551 -1.581389 55.346371 
  -1.573889 55.423599 -1.63 55.55888 -1.751111 55.627209 
  -1.8197221 55.634159 -2.030556 55.816662 -2.1641669 55.912209 
  -2.571389 56.019161 -2.6502781 56.058601 -2.794445 56.060261 
  -2.8611109 56.005821 -3.053334 55.9436 -3.666389 56.00721 
  -3.8105559 56.09721 -3.8205559 56.11137 -3.523056 56.0336 
  -3.158334 56.05999 -3.135834 56.113602 -2.9449999 56.204151 
  -2.7883329 56.187481 -2.583056 56.26804 -2.585834 56.283871 
  -2.8380561 56.363602 -2.7994449 56.418598 -2.8288889 56.43943 
  -3.2650001 56.3461 -3.325278 56.359989) 
#(166.66299 54.67416 166.5652 54.72694 166.4855 54.828609 
  166.3575 54.829151 166.0705 55.062481 166.0816 55.108879 
  166.0155 55.174709 165.74271 55.290539 165.9447 55.36277 
  166.04021 55.34082 166.2406 55.327351 166.2495 55.325562 
  166.2227 55.232769 166.26469 55.127491 166.6458 54.84304 
  166.66299 54.67416) #(-132.75751 54.670269 -132.6678 54.67915 
  -132.7572 54.739712 -132.7231 54.78471 -132.89861 54.910549 
  -132.9447 55.016651 -133.045 55.042488 -133.03391 55.07526 
  -133.0731 55.100269 -132.9814 55.087212 -133.06531 55.144428 
  -133.1022 55.245541 -133.12531 55.248878 -133.19749 55.212769 
  -133.15559 55.193321 -133.2142 55.169991 -133.11861 55.098049 
  -133.21359 55.089432 -133.0986 54.92165 -133.0258 54.871101 
  -132.9053 54.836651 -132.86391 54.726101 -132.797 54.696098 
  -132.75751 54.670269) #(9.9309311 54.667561 10.01583 54.695541 
  9.916666 54.7911 9.5783329 54.82555 9.5769444 54.861931 
  9.4516659 54.806931 9.5031242 54.848251) 
#(-5.1219449 56.812771 -5.2261109 56.732491 -5.210556 56.701382 
  -4.9944448 56.71027 -5.3030558 56.66444 -5.4113889 56.54388 
  -5.2824998 56.544159 -5.4283342 56.528599 -5.458056 56.468319 
  -5.4144449 56.500542 -5.396667 56.455269 -5.2030559 56.454151 
  -5.0690289 56.557079 -5.2208338 56.435822 -5.4466672 56.446381 
  -5.5694451 56.331928 -5.5938892 56.249439 -5.5388889 56.259991 
  -5.4927778 56.25388 -5.5572219 56.23082 -5.5544448 56.17194 
  -5.5119448 56.18166 -5.584445 56.08749 -5.710556 55.960819 
  -5.6944451 55.933319 -5.669445 55.98138 -5.5708342 56.037209 
  -5.690834 55.92416 -5.6766672 55.883041 -5.5738902 55.928322 
  -5.6700001 55.838871 -5.6327782 55.779709 -5.5366669 55.786098 
  -5.6805558 55.673038 -5.7211108 55.436649 -5.795279 55.386101 
  -5.7861118 55.30138 -5.7527781 55.291931 -5.5672231 55.316662 
  -5.518889 55.368038 -5.5872231 55.417488 -5.5097232 55.484711 
  -5.4866672 55.64304 -5.3838892 55.747761 -5.3186111 55.786652 
  -5.4213901 55.91415 -5.4455562 56.02277 -5.377224 56.005821 
  -5.2861118 56.084991 -4.9758339 56.24527 -5.2027779 56.11721 
  -5.335279 55.989712 -5.3033342 55.850552 -5.2027779 55.833599 
  -5.2388902 55.89304 -5.1844449 55.965549 -5.0916672 55.899429 
  -5.0774999 55.913601 -5.124752 55.97823 -5.040833 55.874981 
  -4.978889 55.8661 -4.895834 55.986099 -4.918334 56.16444 
  -4.8911109 56.169159 -4.8861108 56.11694 -4.8588901 56.107491 
  -4.8194451 56.147209 -4.7461119 56.199711 -4.873889 56.049431 
  -4.8488889 55.982491 -4.7758341 55.97971 -4.8252778 56.02776 
  -4.833334 56.080818 -4.7649999 56.00721 -4.5252781 55.929989 
  -4.7866669 55.959709 -4.8813901 55.932209 -4.8594451 55.74638 
  -4.917223 55.704708 -4.9083338 55.691929 -4.6950011 55.604431 
  -4.646111 55.534431 -4.6138902 55.48637 -4.8197231 55.33054 
  -4.8416672 55.275269 -5.0136118 55.131649 -5.0513902 55.023041 
  -4.9913888 54.925541 -5.0136118 54.90554 -5.0575008 54.921379 
  -5.105278 55.02388 -5.1786122 54.984711 -5.1644459 54.884991 
  -5.0052791 54.76693 -4.9636121 54.680271 -4.9225011 54.640541 
  -4.856945 54.63443 -4.9002781 54.701099 -4.9552779 54.808601 
  -4.852222 54.868599 -4.6955562 54.809711 -4.5494452 54.732491 
  -4.376112 54.676659 -4.3480558 54.699162 -4.3402791 54.800819 
  -4.4113889 54.825821 -4.4294448 54.872211 -4.393333 54.908039 
  -4.376112 54.879162 -4.2619448 54.83638 -4.2047219 54.863041 
  -4.1966672 54.80471 -4.0891681 54.768318 -4.0663891 54.8311 
  -4.043191 54.768539) #(11.46139 54.618881 11.79861 54.645821 
  11.85833 54.68943 11.80528 54.707489 11.86167 54.746101 
  11.78222 54.827492 11.64389 54.906101 11.56667 54.84026 
  11.58889 54.808041 11.23139 54.956928 11.05778 54.93499 
  11.015 54.884708 11.1075 54.822491 11.07889 54.806099 
  11.02111 54.813042 10.995 54.782768 11.08972 54.74416 
  11.46139 54.618881) #(137.7072 54.61832 137.64909 54.64193 
  137.4866 54.87249 137.4416 54.87027 137.3613 54.826382 
  137.2216 54.776112 137.56689 55.188881 137.64661 55.192211 
  137.7005 55.14526 137.9633 55.136929 137.985 55.08638 
  137.87939 54.998051 137.9722 55.03915 138.1649 55.052212 
  138.203 55.024429 138.0569 54.958881 137.99471 54.801102 
  137.7072 54.61832) #(11.74111 55.915821 11.75778 55.939991 
  11.76389 55.96471 11.60639 55.936378 11.32055 55.978321 
  11.27806 55.975269 11.50778 55.91888 11.51583 55.89193 
  11.48694 55.841648 11.37472 55.80471 11.34333 55.74749 
  11.16861 55.70277 11.12278 55.731659 11.15333 55.747211 
  10.87361 55.732491 11.08583 55.658871 10.9275 55.660259 
  11.11972 55.603321 11.15028 55.549709 11.08 55.509159 
  11.13 55.522491 11.17805 55.488041 11.21472 55.388599 
  11.10472 55.363602 11.11055 55.33054 11.17056 55.349709 
  11.24194 55.26804 11.23611 55.23138 11.24667 55.199711 
  11.74111 55.198879 11.72 55.15221 11.77361 55.154148 
  11.76694 55.131378 11.72389 55.108318 11.77917 55.081379 
  11.82333 55.046379 11.61861 55.08305 11.84722 55.02026 
  11.88361 54.973881 11.85611 54.95499 11.75083 54.960819 
  11.70861 54.936649 11.74222 54.89138 11.88361 54.74971 
  11.87194 54.651371 11.92944 54.572769 11.98 54.570271 
  11.95861 54.663319 11.97639 54.7061 12.16944 54.839161 
  12.11055 54.887489 12.00028 54.902489 11.96361 54.942211 
  11.90417 54.91943 11.87778 54.944988 11.91389 55.004711 
  12.07194 54.968601 12.17361 55.00499 12.12306 55.0811 
  12.16889 55.08971 12.17333 55.122761 12.06139 55.131649 
  12.015 55.161381 12.06861 55.17387 12.44333 55.272491) 
#(8.9749584 54.514332 8.850832 54.620819 8.8056221 54.685219) 
#(168.0838 54.498878 168.01469 54.538052 167.7363 54.660549 
  167.4352 54.827209 167.4333 54.862549 167.44 54.865219 
  167.66521 54.78138 168.09219 54.520821 168.0838 54.498878) 
#(19.636511 54.471069 19.864719 54.629711 19.961109 54.776932 
  19.91972 54.871101 19.936661 54.921101 19.985279 54.961929 
  20.4275 54.949429 20.69861 55.079708 20.932032 55.290062) 
#(19.636511 54.471069 19.66563 54.466911) 
#(19.62447 54.461491 19.636511 54.471069) 
#(19.81192 54.446049 19.939159 54.49638 19.99667 54.573318 
  20.06389 54.550819 20.405001 54.68277 20.238331 54.69138 
  20.07444 54.65276 20.011391 54.720268 19.95472 54.699429 
  19.94416 54.659161 19.961109 54.63443 19.66563 54.466911) 
#(19.66563 54.466911 19.81192 54.446049) 
#(-164.75861 54.394989 -164.43719 54.421379 -164.3364 54.475819 
  -164.32111 54.534431 -164.2139 54.592491 -164.00841 54.62999 
  -163.60001 54.610821 -163.4364 54.658329 -163.4325 54.709148 
  -163.34779 54.75555 -163.1153 54.686939 -163.1597 54.658871 
  -163.0486 54.66832 -163.1203 54.743599 -163.1895 54.779709 
  -163.32091 54.758041 -163.37781 54.796101 -163.4225 54.922211 
  -163.4933 54.99194 -163.54581 55.049992 -163.78641 55.05471 
  -163.9995 54.985271 -164.14169 54.962212 -164.2195 54.887489 
  -164.4328 54.930538 -164.545 54.8811 -164.63139 54.74638 
  -164.75391 54.640541 -164.9283 54.601379 -164.94859 54.569988 
  -164.84109 54.418598 -164.75861 54.394989) 
#(21.271309 55.249691 21.3811 55.287201 21.4314 55.2519 
  21.452499 55.214401 21.503901 55.193298 21.640301 55.1847 
  21.727501 55.134701 21.812799 55.118301 21.8631 55.0919 
  21.944201 55.077801 22.009701 55.087799 22.0233 55.077202 
  22.020599 55.0494 22.061899 55.0275 22.197201 55.061699 
  22.448601 55.0508 22.5536 55.075802 22.6022 55.071899 
  22.6408 54.9664 22.732201 54.962502 22.74 54.944698 
  22.770599 54.9389 22.7556 54.920601 22.834999 54.901699 
  22.8675 54.8311 22.8461 54.779999 22.740601 54.727798 
  22.7425 54.705299 22.7192 54.691399 22.7225 54.6217 
  22.698299 54.589401 22.694401 54.473301 22.782803 54.366657) 
#(19.004021 54.342628 19.439211 54.395809 19.62447 54.461491) 
#(19.81192 54.446049 19.990829 54.42054 20.641661 54.36665 
  21.353331 54.32832 22.07472 54.33498 22.77 54.359989 
  22.782803 54.366657) #(19.66563 54.466911 19.60833 54.434429 
  19.227489 54.331928 19.247499 54.286381 19.371111 54.2686 
  19.495279 54.32082 19.81192 54.446049) 
#(13.34083 54.234989 13.42944 54.238041 13.42 54.261379 
  13.365 54.261379 13.44972 54.31638 13.68444 54.349152 
  13.69055 54.327209 13.69639 54.292759 13.76778 54.34082 
  13.6175 54.404148 13.57778 54.45388 13.58528 54.482769 
  13.67528 54.526371 13.67667 54.565269 13.63389 54.585819 
  13.455 54.572769 13.40028 54.594151 13.38305 54.638882 
  13.41444 54.681931 13.23055 54.64777 13.22666 54.628601 
  13.28889 54.644711 13.24611 54.55777 13.28639 54.56332 
  13.36528 54.615261 13.40167 54.57304 13.51833 54.562481 
  13.49861 54.479431 13.37528 54.55777 13.34972 54.519428 
  13.36611 54.57526 13.30694 54.513321 13.24166 54.552761 
  13.14722 54.540821 13.27222 54.475819 13.15472 54.424431 
  13.26528 54.38026 13.13083 54.370819 13.11833 54.333881 
  13.20361 54.272491 13.33555 54.27943 13.34083 54.234989) 
#(-4.7841668 54.056931 -4.6541672 54.061649 -4.394444 54.186378 
  -4.3086119 54.300541 -4.3622231 54.31638 -4.37639 54.35165 
  -4.353056 54.409161 -4.5313892 54.364712 -4.625278 54.248878 
  -4.7141681 54.214432 -4.7841668 54.056931) 
#(-165.89 54.029709 -165.84171 54.08054 -165.76331 54.06443 
  -165.65891 54.11665 -165.7222 54.11832 -165.7664 54.138321 
  -165.7603 54.161381 -165.8683 54.167759 -165.8728 54.209148 
  -165.98891 54.211929 -166.12309 54.116379 -166.03889 54.036098 
  -165.9736 54.06554 -165.89 54.029709) 
#(-6.2701449 54.09687 -6.1966672 54.095268 -6.0677791 54.02776 
  -5.894444 54.103039 -5.8638902 54.223881 -5.7966671 54.242489 
  -5.648056 54.227211 -5.5341668 54.31332 -5.5577779 54.369709 
  -5.710556 54.346931 -5.6399999 54.403599 -5.645278 54.492489 
  -5.7127781 54.533871 -5.6805558 54.57304 -5.5597229 54.51582 
  -5.5675001 54.387489 -5.499167 54.331928 -5.4355559 54.460541 
  -5.4747229 54.53027 -5.5772228 54.678051 -5.670279 54.671101 
  -5.9047232 54.602211 -5.9241672 54.633881 -5.8713889 54.687481 
  -5.6966672 54.748878 -5.687222 54.777489 -5.7183342 54.838039 
  -5.7872229 54.853321 -5.7852778 54.83305 -5.8480558 54.898602 
  -5.9933338 54.983051 -5.9661112 55.024151 -5.9786119 55.052212 
  -6.0566669 55.055538 -6.0336108 55.154991 -6.0769448 55.19804 
  -6.4969449 55.24527 -6.7544451 55.16721 -6.9680562 55.189709 
  -6.9747229 55.136662 -7.0736108 55.037769 -7.251112 55.046101 
  -7.253056 55.070541) #(9.9309311 54.667561 10.03778 54.66832 
  10.02778 54.551102 9.8658333 54.477489 10.12694 54.489712 
  10.20278 54.45805 10.19806 54.395821 10.15167 54.363602 
  10.23805 54.41721 10.3725 54.434158 10.665 54.324429 
  10.78 54.30777 10.84889 54.34193 11.12222 54.39249 
  11.12917 54.375542 11.06472 54.349991 11.09305 54.197491 
  10.87389 54.087769 10.80222 54.095539 10.75639 54.034431 
  10.79 53.997211 10.87055 53.99194 10.90263 53.95998) 
#(22.782803 54.366657 22.863331 54.408588 23.0 54.383041 
  23.066111 54.308041 23.34194 54.24332 23.48444 54.138321 
  23.51778 54.03027 23.474991 53.995258 23.503748 53.947163) 
#(14.22598 53.928249 14.40861 53.917488 14.55944 53.97665 
  14.95389 54.06332 15.34111 54.15443 15.76417 54.217209 
  16.11305 54.268879 16.09222 54.25193 16.17333 54.271648 
  16.235001 54.31805 16.332781 54.34943 16.32972 54.398319 
  16.50639 54.529148 16.92305 54.599991 17.075279 54.676102 
  17.43417 54.752769 17.85972 54.81638 18.334999 54.836651 
  18.45805 54.788052 18.811939 54.639992 18.70307 54.677292 
  18.43305 54.786381 18.406111 54.73444 18.48361 54.62888 
  18.52083 54.64193 18.585279 54.433319 18.721939 54.376381 
  19.004021 54.342628) #(10.90263 53.95998 11.04583 54.006649 
  11.19222 54.01054 11.24222 53.94471 11.27694 53.93166 
  11.33805 53.957211 11.45417 53.9011 11.47139 53.96777 
  11.58639 54.042488 11.62444 54.110271 12.02 54.17971 
  12.1 54.18166 12.34361 54.297771 12.48722 54.45499 
  12.91166 54.439709 12.9175 54.419991 12.77583 54.41666 
  12.60583 54.406101 12.46 54.392208 12.36972 54.264992 
  12.41805 54.260818 12.42056 54.285259 12.46194 54.30249 
  12.7125 54.409431 12.74722 54.379162 12.81611 54.346371 
  12.99806 54.434429 13.09222 54.369431 13.07889 54.331661 
  13.16083 54.262489 13.38833 54.147209 13.49972 54.086102 
  13.71167 54.171379) #(23.503748 53.947163 23.579201 53.9361 
  23.6444 53.904701 23.719999 53.926701 23.779699 53.917801 
  23.7875 53.938099 23.833599 53.9258 23.934999 53.955799 
  23.986099 53.9389 24.0886 53.9375 24.1756 53.967499 
  24.2314 53.953098 24.2778 53.8997 24.3325 53.906101 
  24.3869 53.888599 24.6122 53.992199 24.6917 54.001701 
  24.7278 53.968601 24.820801 53.9772 24.840599 54.034401 
  24.795601 54.101398 24.8356 54.113602 24.8403 54.1422 
  24.968901 54.1586 25.024401 54.1311 25.071899 54.134701 
  25.1619 54.172501 25.2094 54.23 25.2178 54.2644 
  25.391701 54.255798 25.4519 54.299702 25.4928 54.305302 
  25.5772 54.240299 25.518299 54.2258 25.5478 54.2033 
  25.5047 54.183102 25.534401 54.1469 25.669201 54.136101 
  25.7003 54.154701 25.785299 54.160599 25.787201 54.218102 
  25.8078 54.2481 25.7703 54.2878 25.7272 54.2906 
  25.714199 54.3311 25.611099 54.311401 25.547501 54.328602 
  25.557199 54.3661 25.6364 54.4272 25.633101 54.477798 
  25.648899 54.517502 25.7642 54.579201 25.7272 54.666698 
  25.749201 54.728298 25.7367 54.789398 25.8036 54.8139 
  25.7889 54.8703 25.862499 54.910801 25.881701 54.944199 
  26.160801 54.9772 26.2194 55.029999 26.248301 55.071098 
  26.2533 55.1236 26.284201 55.148102 26.4503 55.132801 
  26.481701 55.154999 26.615801 55.124699 26.641701 55.142502 
  26.641701 55.1908 26.6686 55.218102 26.713301 55.243099 
  26.775299 55.250599 26.8197 55.281101 26.766899 55.313599 
  26.631399 55.3311 26.554701 55.313099 26.455799 55.3414 
  26.502501 55.389999 26.5236 55.443901 26.569401 55.4683 
  26.545 55.511101 26.626699 55.593102 26.614086 55.676048) 
#(14.22598 53.928249 14.20333 53.90942 14.21742 53.86866) 
#(14.21742 53.86866 14.18722 53.874981 13.93944 53.84304 
  13.825 53.858318 13.94055 53.912769 13.90306 53.988319 
  14.04889 53.941929 14.0525 53.99749 13.97664 54.042591 
  13.92 54.062771 13.89055 54.007488 13.77555 54.021648 
  13.81722 54.100819 13.77555 54.133598 13.91139 54.084431 
  14.22598 53.928249) #(-130.4064 53.834148 -130.3445 53.83527 
  -130.26311 53.918049 -130.23331 53.979988 -130.33611 54.06749 
  -130.4111 54.100819 -130.66721 53.986931 -130.7231 53.91721 
  -130.69591 53.84444 -130.6306 53.839989 -130.6225 53.872211 
  -130.6981 53.91415 -130.66701 53.963871 -130.6028 53.956661 
  -130.5406 53.900539 -130.4753 53.896099 -130.4295 53.983051 
  -130.3436 53.984989 -130.495 53.868881 -130.4064 53.834148) 
#(13.71167 54.171379 13.80805 54.096931 13.75056 54.028599 
  13.91306 53.917488 13.8075 53.855259 13.90361 53.802761 
  14.14083 53.738602 14.23639 53.759159 14.25771 53.743179 
  14.2375 53.698601 14.27782 53.69392) 
#(-0.25974709 53.68362 -0.65333343 53.70277 -0.26666671 53.73444 
  -0.2077778 53.699429 0.15416659 53.600819 -0.1344444 53.873051 
  -0.2163889 54.022491 -0.2027778 54.05471 -0.078611121 54.11665 
  -0.38194451 54.25555 -0.48083341 54.40332 -0.77722228 54.556381 
  -1.168611 54.638599 -1.184956 54.674931) 
#(14.27782 53.69392 14.50083 53.668049 14.59555 53.592491 
  14.61167 53.650829 14.54444 53.710541 14.61944 53.764431 
  14.62917 53.848881 14.58778 53.803322 14.55833 53.857208 
  14.42472 53.867489 14.43111 53.899712 14.3625 53.876099 
  14.41639 53.85944 14.38889 53.83276 14.21742 53.86866) 
#(-6.103333 53.488319 -6.0777779 53.525829 -6.1805558 53.614429 
  -6.2561111 53.807209 -6.2447219 53.858601 -6.3372231 53.871929 
  -6.3811111 53.91721 -6.3444452 54.014431 -6.228333 53.98777 
  -6.105278 53.99221 -6.1138902 54.011662 -6.2701449 54.09687) 
#(-129.1581 53.387211 -129.07561 53.514709 -128.94141 53.592491 
  -128.8717 53.572208 -128.882 53.612492 -128.82359 53.70055 
  -129.0386 53.686378 -129.1631 53.62249 -129.1722 53.423038 
  -129.1581 53.387211) #(14.27782 53.69392 14.28639 53.669151 
  14.37555 53.423038 14.4453 53.272591) 
#(-167.5428 53.271648 -167.47141 53.30027 -166.9892 53.448601 
  -166.97501 53.419708 -166.9425 53.466381 -166.91341 53.436939 
  -166.8856 53.477489 -166.7603 53.444149 -166.7442 53.468601 
  -166.78889 53.51527 -166.7892 53.563599 -166.6586 53.482769 
  -166.6322 53.531101 -166.66389 53.593319 -166.5909 53.535259 
  -166.5786 53.575821 -166.53059 53.602211 -166.532 53.63055 
  -166.27361 53.68388 -166.317 53.767208 -166.3506 53.77776 
  -166.3878 53.736099 -166.4464 53.7486 -166.4839 53.689709 
  -166.5097 53.723049 -166.55 53.685551 -166.54469 53.746101 
  -166.38091 53.83527 -166.34309 53.884708 -166.3109 53.86388 
  -166.2397 53.886101 -166.2581 53.967491 -166.37531 53.948318 
  -166.38029 53.999439 -166.42 53.941929 -166.6075 53.829708 
  -166.5811 53.876659 -166.6364 53.874981 -166.6272 53.94276 
  -166.59 53.960541 -166.6153 53.99165 -166.67641 54.010818 
  -167.0242 53.95554 -167.1597 53.848049 -167.09 53.785549 
  -166.7189 53.724152 -166.71609 53.710819 -166.82561 53.70055 
  -166.80141 53.625542 -166.9081 53.710541 -167.02251 53.704151 
  -167.06641 53.674431 -166.99609 53.615551 -167.0981 53.631378 
  -167.1523 53.617489 -167.1503 53.574429 -167.07091 53.526661 
  -166.98219 53.544991 -166.9697 53.52388 -167.1823 53.519711 
  -167.1609 53.466099 -167.29221 53.450821 -167.71809 53.3736 
  -167.83031 53.297771 -167.5428 53.271648) 
#(-59.023899 53.713871 -59.086121 53.679989 -59.303612 53.6861 
  -59.389721 53.621658 -59.62112 53.52721 -59.871948 53.534988 
  -59.899181 53.51693 -59.785011 53.485271 -59.874168 53.484989 
  -59.954182 53.40694 -60.152241 53.32193 -60.091122 53.294991 
  -60.1189 53.269989 -60.164452 53.309429 -60.26112 53.2686 
  -60.418331 53.269428 -60.28334 53.28944 -60.17474 53.338039 
  -60.18861 53.350552 -60.38335 53.332211 -60.406109 53.364159 
  -60.138062 53.453602 -60.069462 53.45554 -60.369179 53.609989 
  -60.653061 53.699429 -60.907501 53.707211 -60.933071 53.7286 
  -60.857231 53.792759 -60.87056 53.832211 -60.803059 53.768879 
  -60.503071 53.705818 -60.134171 53.52832 -60.063622 53.565819 
  -60.121391 53.625271 -60.079731 53.70055 -60.01778 53.70805 
  -60.128071 53.769161 -59.829182 53.788601 -59.80307 53.806099 
  -59.874729 53.818878 -59.852791 53.839432 -59.671951 53.826931 
  -58.980831 53.966381 -58.922508 54.013882 -58.704731 54.02721 
  -58.600849 54.04694 -58.399441 54.21249 -58.4114 54.229431 
  -58.803341 54.10944 -59.517231 53.997211 -59.587231 54.043049 
  -59.43446 54.047211 -58.716671 54.146931 -58.56612 54.204151 
  -58.098629 54.327209 -57.66917 54.376099 -57.589741 54.39999 
  -57.472511 54.473598 -57.385571 54.503319 -57.34779 54.57943 
  -57.45668 54.650829 -57.668339 54.629162 -57.803341 54.70776 
  -57.946949 54.739429 -58.18446 54.751659 -58.196678 54.795269 
  -58.398899 54.78471 -58.38863 54.7411 -58.438339 54.748878 
  -58.438622 54.77055 -58.565559 54.766102 -58.552509 54.800819 
  -58.805012 54.857208 -58.83334 54.831379 -58.916401 54.852772 
  -58.87611 54.913319 -58.91946 54.91666 -58.89418 54.95277 
  -58.990841 55.021099 -59.030849 54.994991 -58.961681 55.08527 
  -58.956402 55.13026 -59.035568 55.15638 -59.35862 54.999989 
  -59.127781 55.170551 -59.13139 55.215549 -59.161671 55.236931 
  -59.21722 55.164989 -59.243061 55.21249 -59.402241 55.028049 
  -59.808071 54.836102 -59.791401 54.785549 -59.909729 54.740822 
  -59.944462 54.75555 -59.85474 54.79443 -59.827511 54.846931 
  -59.432232 55.129429 -59.430561 55.151932 -59.501671 55.14193 
  -59.488899 55.185261 -59.519741 55.209709 -59.541679 55.1661 
  -59.968342 55.11916 -59.96278 55.161098 -59.88863 55.151661 
  -59.793339 55.17971 -59.712231 55.269711 -59.776169 55.32793) 
#(153.7439 59.268009 153.5827 59.192211 153.5172 59.224991 
  153.33299 59.230549 153.2802 59.129162 152.9897 59.073601 
  152.9252 58.998878 152.8963 58.892208 152.533 58.959148 
  152.40331 59.03915 152.3358 59.051659 152.35519 59.01693 
  152.1989 59.008041 152.1163 58.982208 152.1227 58.922489 
  152.088 58.901661 151.6924 58.858601 151.45551 58.875271 
  151.3094 58.836929 151.07359 59.110538 151.1702 59.091099 
  151.3963 59.170551 151.72301 59.135818 152.2841 59.207489 
  152.2877 59.22694 152.18469 59.266102 151.8002 59.297211 
  151.6741 59.32193 151.71271 59.363319 151.3513 59.610538 
  150.99409 59.57888 150.8652 59.545269 150.9283 59.50388 
  150.93221 59.468601 150.7066 59.44276 150.67439 59.457211 
  150.7325 59.49749 150.6591 59.511929 150.4716 59.48888 
  150.7213 59.549431 150.72549 59.572769 150.49471 59.561939 
  150.41051 59.623051 149.6244 59.771099 149.38609 59.753601 
  149.033 59.639149 149.0374 59.61388 149.2141 59.50082 
  149.21001 59.461929 149.1022 59.496101 148.9697 59.44804 
  148.84911 59.482769 148.8416 59.549992 148.7366 59.485538 
  148.6888 59.423038 148.7066 59.376099 148.7652 59.363602 
  148.87109 59.399151 148.87 59.350819 148.9236 59.393318 
  148.965 59.37249 148.90939 59.310551 148.95081 59.256939 
  148.89799 59.239159 148.8055 59.28138 148.61 59.25388 
  148.39799 59.26749 148.40221 59.357208 148.36189 59.396099 
  148.1869 59.417759 147.823 59.376659 147.7811 59.3461 
  147.8327 59.28471 147.7672 59.263321 147.6158 59.299992 
  147.545 59.277489 147.5538 59.244431 147.48911 59.239712 
  147.29111 59.326649 146.73911 59.37471 146.65829 59.426659 
  146.48579 59.459431 146.32941 59.396931 146.3177 59.37138 
  146.3452 59.207489 146.3105 59.181381 146.19859 59.197769 
  146.10831 59.17165 145.9433 59.157211 145.93829 59.209431 
  145.8275 59.234711 145.7991 59.268318 145.9136 59.352489 
  145.9025 59.415539 144.76221 59.37804 143.993 59.41415 
  143.4225 59.33749 143.18829 59.3811 142.54221 59.225552 
  142.0838 59.031651 141.79269 58.774712 141.49249 58.585819 
  140.98911 58.41666 140.68111 58.227211 140.5155 57.941662 
  140.5061 57.829708 140.4597 57.811649 140.1991 57.7486 
  139.98441 57.67944 139.8275 57.502769 139.68269 57.481098 
  139.4772 57.319439 139.24471 57.280819 139.1261 57.2286 
  139.07471 57.138321 138.985 57.156651 138.9572 57.133041 
  138.96519 57.061378 138.90691 57.024151 138.65269 56.985538 
  138.61411 56.947208 138.58971 56.868599 138.4836 56.849991 
  138.4622 56.805271 138.138 56.593601 138.1147 56.553879 
  138.1613 56.489712 138.24471 56.478321 138.2377 56.436378 
  138.0741 56.451382 138.05881 56.399151 137.9189 56.37804 
  137.8564 56.26582 137.4577 56.04332 137.4097 55.930538 
  137.3394 55.96526 137.17191 55.882488 137.0616 55.79221 
  136.4169 55.5686 136.198 55.358601 136.05859 55.293598 
  135.7438 55.14555 135.55251 55.122211 135.40581 55.03915 
  135.15581 54.8661 135.1664 54.82082 135.2238 54.764431 
  135.24159 54.699989 135.66409 54.665539 135.71359 54.576099 
  135.7933 54.568878 136.05 54.59193 136.5522 54.59277 
  136.66721 54.686378 136.6674 54.646648 136.705 54.608601 
  136.8161 54.651371 136.8833 54.581661 136.83299 54.543598 
  136.8316 54.426659 136.7377 54.421101 136.7419 54.401661 
  136.8205 54.306381 136.7538 54.278049 136.8105 54.245819 
  136.75861 54.20388 136.79939 54.17387 136.8036 54.128319 
  136.6922 54.012489 136.6541 53.912769 136.7027 53.798038 
  136.8044 53.775269 136.84579 53.82888 136.96519 53.85194 
  137.11301 53.80415 137.1786 53.841381 137.2661 53.987492 
  137.27049 54.043598 137.17329 54.035549 137.0619 54.14082 
  137.43159 54.311378 137.5563 54.2911 137.6924 54.323318 
  137.74409 54.30415 137.51221 54.1511 137.4863 54.081379 
  137.44611 54.085541 137.45799 54.131378 137.4236 54.146381 
  137.308 54.114429 137.30659 54.04916 137.5983 53.952492 
  137.8591 53.96138 137.6944 53.877769 137.58659 53.80999 
  137.5652 53.725269 137.5294 53.703602 137.34219 53.662769 
  137.2072 53.588329 137.24271 53.556931 137.3891 53.52499 
  137.9016 53.57304 138.29691 53.746101 138.3483 53.897209 
  138.56441 53.994991 138.5894 53.984989 138.59109 53.861099 
  138.5714 53.814991 138.3466 53.64555 138.353 53.607769 
  138.2394 53.562481 138.2197 53.485271 138.46519 53.521099 
  138.5602 53.594711 138.77609 54.024429 138.76801 54.101101 
  138.67329 54.062481 138.6613 54.076649 138.735 54.169159 
  138.7352 54.260269 138.64191 54.295269 138.7258 54.31638 
  138.9052 54.24971 139.3425 54.183319 139.735 54.308601 
  139.8091 54.296101 139.795 54.22443 139.93629 54.161381 
  140.24471 54.048038 140.2252 54.002209 140.3363 53.958321 
  140.25191 53.867489 140.2877 53.834991 140.5374 53.712769 
  140.5244 53.680271 140.5883 53.629429 140.96629 53.496658 
  140.93111 53.47332 140.9308 53.427761 141.11079 53.394989 
  141.11909 53.36499 141.4191 53.290272 141.3963 53.253601) 
#(-78.501404 55.001659 -78.722778 54.939159 -78.976959 54.84304 
  -79.240837 54.81221 -79.662521 54.667759 -79.686401 54.627209 
  -79.576401 54.60944 -79.525284 54.591381 -79.528633 54.571098 
  -79.602783 54.555271 -79.488068 54.458599 -79.498611 54.401932 
  -79.420288 54.274429 -79.338623 54.238319 -79.276672 54.166931 
  -79.191681 54.172771 -79.046402 54.178322 -79.103897 54.124981 
  -79.227783 54.088871 -79.03334 54.04665 -78.964737 53.996658 
  -79.07251 53.999149 -78.993347 53.91193 -79.101387 53.901661 
  -78.969727 53.851379 -78.901672 53.815269 -79.039459 53.837769 
  -79.06778 53.80249 -79.051682 53.768318 -79.151672 53.70499 
  -79.007233 53.67915 -79.063339 53.596931 -78.985001 53.614712 
  -78.916122 53.560551 -78.946953 53.544159 -79.004997 53.56443 
  -79.031403 53.55471 -78.962784 53.508881 -79.01889 53.491379 
  -79.061684 53.529148 -79.107788 53.497211 -78.980827 53.434711 
  -78.918823 53.249081) #(7.209444 53.24276 7.2111111 53.24416 
  7.2527771 53.316929 7.0505552 53.33971 7.0158329 53.383598 
  7.0349998 53.487492 7.147222 53.537209 7.0888882 53.571098 
  7.0961099 53.59193 7.2525001 53.67387 7.3908329 53.686378 
  7.8486109 53.714161 8.0263882 53.703602 8.0505543 53.63221 
  8.1594429 53.562481 8.163332 53.52055 8.061388 53.500542 
  8.0802755 53.45805 8.2230549 53.400829 8.2841663 53.418598 
  8.3138885 53.459431 8.3119431 53.524151 8.2319431 53.522209 
  8.2430553 53.586102 8.2833328 53.61388 8.3413887 53.613602 
  8.5488873 53.52943 8.4883327 53.47916 8.4852772 53.406101 
  8.5027771 53.408871 8.5683327 53.533329 8.519722 53.603039 
  8.4877777 53.701931 8.604166 53.879429 8.6805553 53.894711 
  8.728054 53.857769 8.9074993 53.828041 9.1288872 53.8661 
  9.2952156 53.83569 9.3599987 53.786381 9.582777 53.586102 
  9.8022213 53.53471 9.8247204 53.55027 9.6741657 53.574429 
  9.5466652 53.633598 9.5297222 53.70776 9.4377766 53.739429 
  9.3763885 53.831379 8.9619408 53.898602 8.8569431 54.002769 
  8.8577766 54.04221 9.0030537 54.028049 9.0177755 54.091099 
  8.9702759 54.14555 8.8447208 54.133041 8.8233318 54.207211 
  8.916111 54.270821 8.9580545 54.316929 8.7938881 54.284161 
  8.6316662 54.279148 8.5994415 54.327492 8.6091652 54.345539 
  8.6938877 54.357491 8.6541653 54.37582 8.9016666 54.41943 
  9.0147209 54.480259 8.9749584 54.514332) 
#(5.9149971 53.384151 6.0925002 53.41082 6.3036108 53.395821 
  6.7419438 53.46582 6.871388 53.431931 6.9016671 53.350269 
  7.0738888 53.288052 7.0963888 53.254711 7.209444 53.24276) 
#(-129.49139 53.209431 -129.4731 53.234711 -129.51421 53.308319 
  -129.4536 53.29665 -129.42529 53.43082 -129.56531 53.477211 
  -129.52361 53.496658 -129.7495 53.665821 -130.1758 53.9086 
  -130.2664 53.881378 -130.28391 53.83276 -130.06779 53.635269 
  -129.96561 53.642208 -130.0564 53.60387 -130.0161 53.572769 
  -129.91701 53.615261 -129.8703 53.545551 -129.8889 53.468601 
  -129.6031 53.248878 -129.49139 53.209431) 
#(-132.4995 53.159161 -132.187 53.160549 -132.1245 53.194149 
  -132.2556 53.193878 -132.26579 53.212769 -131.98219 53.251659 
  -131.9086 53.357491 -131.94 53.519711 -131.85339 53.81638 
  -131.73891 53.923321 -131.6797 54.019711 -131.66341 54.123878 
  -131.8528 54.059158 -132.07249 54.02277 -132.1711 54.043598 
  -132.1284 54.001099 -132.0889 53.86388 -132.1861 53.788879 
  -132.1953 53.753319 -132.1525 53.706379 -132.2003 53.65221 
  -132.2995 53.669991 -132.3306 53.653599 -132.27921 53.623322 
  -132.377 53.612209 -132.4514 53.582211 -132.4781 53.588871 
  -132.35921 53.669708 -132.6064 53.628601 -132.595 53.672771 
  -132.64 53.673038 -132.6472 53.691929 -132.22501 53.78027 
  -132.1111 53.878319 -132.1503 53.992771 -132.2906 54.110538 
  -132.4167 54.0961 -132.6481 53.947491 -132.6761 53.96471 
  -132.5667 54.029148 -132.5578 54.088039 -132.6481 54.14138 
  -133.0672 54.17387 -133.082 54.102489 -133.04111 54.031651 
  -133.11501 53.940269 -133.1347 53.87027 -133.067 53.82082 
  -133.1064 53.78249 -133.0336 53.752769 -132.97279 53.763882 
  -132.9292 53.684711 -133.0078 53.67638 -132.882 53.605549 
  -132.89079 53.585541 -132.9536 53.60194 -132.9917 53.58305 
  -132.89 53.55777 -132.9236 53.519161 -132.82359 53.51693 
  -132.8492 53.461929 -132.74361 53.515541 -132.71919 53.490261 
  -132.75281 53.457489 -132.6884 53.448318 -132.6606 53.489429 
  -132.65311 53.431381 -132.5208 53.412209 -132.4003 53.330818 
  -132.43359 53.319149 -132.71001 53.37027 -132.7417 53.314159 
  -132.5686 53.33749 -132.54449 53.309429 -132.6675 53.28249 
  -132.70309 53.257771 -132.5497 53.23138 -132.5778 53.20055 
  -132.4995 53.159161) #(-129.9317 53.158039 -129.75591 53.162209 
  -129.7292 53.21526 -129.89079 53.400539 -130.3911 53.61694 
  -130.52029 53.62471 -130.5273 53.552212 -130.4483 53.513599 
  -130.3658 53.532211 -130.4095 53.488602 -130.3058 53.384159 
  -130.20329 53.37888 -129.9317 53.158039) 
#(-4.4022231 53.12582 -4.0900002 53.25499 -4.0533342 53.30471 
  -4.2041669 53.291931 -4.292778 53.40749 -4.416389 53.424992 
  -4.5672231 53.39138 -4.5727792 53.31971 -4.4908342 53.174992 
  -4.3852792 53.18277 -4.4022231 53.12582) 
#(-169.00529 52.86721 -168.7567 52.925541 -168.7617 52.96027 
  -168.4648 53.050819 -168.32471 53.211102 -167.84891 53.380821 
  -167.7953 53.495541 -167.9375 53.521931 -168.0056 53.563599 
  -168.2464 53.525539 -168.4106 53.40971 -168.39169 53.375271 
  -168.42751 53.327492 -168.34531 53.294708 -168.37061 53.25304 
  -168.6214 53.272209 -168.76421 53.17944 -168.7964 53.102772 
  -168.765 53.086929 -168.77921 53.052761 -169.00529 52.86721) 
#(-130.0051 55.923069 -129.96671 55.912209 -130.11279 55.781651 
  -130.12891 55.72221 -130.07471 55.672489 -130.1017 55.556381 
  -129.9481 55.276371 -130.0808 55.184711 -130.16029 55.06971 
  -130.1006 54.990551 -130.0634 55.001659 -129.7803 55.359711 
  -129.8398 55.39193 -129.78841 55.429989 -129.81641 55.602772 
  -129.79781 55.618038 -129.6992 55.408329 -129.8967 55.147491 
  -129.9989 55.012489 -129.97141 54.998878 -129.7809 55.004711 
  -129.7209 54.982491 -129.9222 54.939991 -129.9503 54.95499 
  -129.9984 54.96999 -130.0583 54.95277 -130.1692 54.843601 
  -130.062 54.893318 -130.0589 54.875542 -130.15559 54.815269 
  -130.20171 54.72694 -129.9684 54.621929 -130.0006 54.614712 
  -130.1817 54.70388 -130.3398 54.687481 -130.37421 54.654991 
  -130.35139 54.618038 -130.1234 54.42749 -130.08279 54.434711 
  -130.07809 54.485271 -130.0592 54.47916 -130.0898 54.40276 
  -130.0497 54.360538 -130.0631 54.339989 -130.31889 54.562771 
  -130.4256 54.629711 -130.4397 54.612209 -130.3759 54.571659 
  -130.4325 54.557209 -130.43359 54.496658 -130.38451 54.451382 
  -130.45641 54.447769 -130.4839 54.401661 -130.45171 54.336651 
  -130.2914 54.345829 -130.2603 54.33749 -130.1956 54.259991 
  -130.2859 54.239712 -130.2731 54.20499 -130.10451 54.15443 
  -129.8367 54.238319 -129.60809 54.19471 -129.5614 54.22694 
  -129.4709 54.235821 -129.6236 54.17944 -129.8409 54.21888 
  -129.9297 54.183041 -129.92889 54.161381 -129.812 54.039711 
  -129.9225 54.122761 -130.03999 54.15638 -130.077 54.114429 
  -130.0992 53.941929 -130.0153 53.870541 -129.9675 53.889709 
  -129.9895 53.845829 -129.8045 53.748878 -129.7347 53.67527 
  -129.49561 53.494709 -129.2728 53.379162 -129.235 53.46693 
  -129.26199 53.517769 -129.2175 53.64027 -129.0336 53.743881 
  -129.04201 53.76638 -129.0569 53.811939 -128.9908 53.759991 
  -128.9642 53.782211 -128.9359 53.811378 -128.7506 53.912491 
  -128.6853 54.00082 -128.5984 54.026932 -128.6739 53.925541 
  -128.68359 53.886101 -128.6584 53.85944 -128.79111 53.776661 
  -128.8131 53.61916 -128.58 53.462212 -128.3714 53.49971 
  -128.11031 53.463329 -127.925 53.329151 -127.93 53.28471 
  -127.8814 53.24971 -127.9511 53.256378 -127.9583 53.329708 
  -128.0614 53.364712 -128.07111 53.396381 -128.1053 53.44054 
  -128.35249 53.475819 -128.5042 53.407768 -128.48199 53.33971 
  -128.52361 53.396648 -128.80499 53.569988 -128.9734 53.547489 
  -128.9153 53.450821 -128.8656 53.48637 -128.8295 53.477772 
  -128.88921 53.430271 -128.8784 53.31638 -128.84891 53.275829 
  -128.66721 53.187481 -128.6636 53.239429 -128.552 53.124981 
  -128.5378 53.07304 -128.5114 52.988602 -128.4361 52.818878 
  -128.23531 52.80582 -128.1656 52.862492 -128.13921 52.924431 
  -128.0611 52.914711 -128.0314 52.901932 -128.1281 52.88055 
  -128.1378 52.83778) #(141.83189 53.15276 141.778 53.376381 
  142.24249 53.525829 142.2377 53.459431 142.2533 53.38055 
  142.35159 53.356098 142.4955 53.398319 142.5789 53.501099 
  142.63049 53.52388 142.68021 53.509991 142.6722 53.549709 
  142.50549 53.549992 142.495 53.661098 142.5486 53.673038 
  142.7269 53.633598 142.8008 53.70388 142.77049 53.841381 
  142.7375 53.84193 142.7072 53.8111 142.6891 53.739159 
  142.64999 53.70332 142.60361 53.697491 142.718 53.898319 
  142.7052 53.950821 142.2805 54.303051 142.4019 54.266102 
  142.5152 54.28054 142.5352 54.23082 142.58 54.233879 
  142.59109 54.278049 142.6302 54.257771 142.6519 54.288601 
  142.61771 54.319149 142.69659 54.424709 142.7411 54.417488 
  143.015 54.117489 142.99831 54.059158 142.85049 53.870541 
  142.9252 53.86388 142.9258 53.832489 142.8813 53.808041 
  143.0663 53.592209 142.9839 53.569149 143.0369 53.535549 
  143.1039 53.554989 143.12939 53.469711 143.06689 53.451382 
  143.0955 53.376659 143.18111 53.39888 143.203 53.365822 
  143.3549 52.84193 143.3239 52.803051) 
#(-4.043191 54.768539 -3.9538889 54.76749 -3.8125 54.848881 
  -3.5694449 54.891102 -3.575556 54.978321 -3.041389 54.97887 
  -3.0877781 54.951382 -3.208611 54.949429 -3.3166671 54.913601 
  -3.259167 54.89888 -3.292222 54.8736 -3.3397231 54.901661 
  -3.3919449 54.876381 -3.438612 54.759159 -3.509167 54.712769 
  -3.627223 54.502769 -3.4122219 54.341648 -3.409445 54.276661 
  -3.3166671 54.19138 -3.2441671 54.19249 -3.208611 54.261101 
  -3.208611 54.199711 -3.248889 54.164989 -3.230834 54.100819 
  -3.1386111 54.067211 -3.0374999 54.22443 -2.9849999 54.148602 
  -2.926667 54.15527 -2.803611 54.243599 -2.8577781 54.1861 
  -2.7994449 54.114712 -2.9202781 54.025269 -2.8713889 53.998878 
  -3.0525 53.909431 -3.0580561 53.780819 -3.021667 53.739712 
  -2.897778 53.72665 -2.946111 53.7061 -3.1077781 53.551659 
  -2.9541669 53.360271 -2.833611 53.320541 -2.7652781 53.341099 
  -2.7025001 53.346371 -2.7863891 53.289989 -2.9425001 53.310551 
  -3.0272231 53.423321 -3.072778 53.42527 -3.190556 53.3811 
  -3.1199999 53.31554 -3.0875001 53.230259 -3.3152781 53.346661 
  -3.376112 53.34499 -3.6133339 53.279148 -3.8775001 53.3311 
  -3.833889 53.28249 -4.1966672 53.2061 -4.3730559 53.022209 
  -4.6150012 52.91637 -4.7618799 52.788712) 
#(-81.988892 52.762211 -82.004997 52.80917 -82.261398 52.93721 
  -82.301682 53.04166 -82.246948 53.216648 -82.160278 53.24527 
  -82.113892 53.286652 -82.216667 53.60387 -82.136673 53.749149 
  -82.131958 53.81776 -82.217506 54.004162 -82.434448 54.209431 
  -82.424728 54.307209 -82.196121 54.850819 -82.287231 55.036652 
  -82.246948 55.084148 -82.254463 55.11137 -82.350014 55.16637 
  -82.30751 55.115822 -82.341667 55.072769 -82.45668 55.142208 
  -82.884171 55.15332 -82.896957 55.177212 -82.948624 55.22887 
  -83.037514 55.238319 -83.180008 55.197208 -83.680847 55.279709 
  -83.696404 55.261662 -83.593903 55.236931 -83.601669 55.224152 
  -83.716667 55.247211 -83.751106 55.268879 -83.95195 55.31749 
  -84.098343 55.272209) #(172.9386 52.745541 173.0847 52.828602 
  173.1483 52.77943 173.1783 52.819988 173.36411 52.82526 
  173.4369 52.85194 173.26331 52.869431 173.32269 52.908039 
  173.2847 52.925819 173.1649 52.9161 173.18111 52.966381 
  173.1236 52.992771 172.66051 53.003052 172.5114 52.94276 
  172.49409 52.91444 172.6602 52.91943 172.6283 52.86166 
  172.69189 52.876099 172.8136 52.87833 172.7608 52.79388 
  172.9386 52.745541) #(-80.699722 52.696098 -80.669167 52.776932 
  -80.775284 52.944439 -81.087784 53.17944 -81.116386 53.200821 
  -81.664459 53.204708 -81.921112 53.151661 -82.061684 53.021099 
  -81.933327 52.96582 -81.369453 52.856098 -81.138077 52.788052 
  -80.699722 52.696098) #(163.3602 59.823879 163.35609 59.737492 
  163.3936 59.635269 163.3277 59.584709 163.18359 59.57082 
  163.16409 59.500271 163.2289 59.473598 163.328 59.394989 
  163.31081 59.295269 163.2561 59.236099 163.22549 59.242771 
  163.27299 59.29887 163.0858 59.27055 163.0602 59.198318 
  163.183 59.144428 163.20081 59.093601 163.1727 59.036098 
  163.15359 59.051659 163.1655 59.090549 163.0116 59.16832 
  162.8797 59.120819 163.03799 59.002209 162.9799 58.957211 
  162.9124 58.951099 162.90269 58.977211 162.86 58.947491 
  162.7188 58.88805 162.6813 58.853321 162.72411 58.8461 
  162.4133 58.685261 162.1402 58.45026 161.9388 58.074429 
  161.9644 58.008881 162.1064 57.85387 162.43269 57.78194 
  162.33611 57.689159 162.38519 57.69054 162.4825 57.762489 
  162.46941 57.8811 162.5563 57.948318 162.705 57.9636 
  163.0188 57.845829 163.2052 57.84304 163.2838 57.742489 
  163.1944 57.595268 162.73689 57.357769 162.7516 57.216099 
  162.8277 57.044991 162.78191 56.888599 162.7914 56.7911 
  162.8466 56.737209 162.91969 56.70499 163.2077 56.743038 
  163.2522 56.696381 163.2339 56.53693 163.3172 56.391102 
  163.3486 56.19276 163.0275 56.017769 162.8688 56.039989 
  162.5894 56.222488 162.52409 56.222488 162.6274 56.243599 
  162.6964 56.310822 163.07581 56.47887 163.0891 56.534161 
  162.9547 56.533871 162.8927 56.429989 162.7408 56.489712 
  162.6655 56.488319 162.41521 56.394711 162.4008 56.378052 
  162.49159 56.340549 162.5722 56.267208 162.515 56.23666 
  162.21831 56.158871 162.0313 56.05582 162.04939 56.0186 
  161.7491 55.627491 161.71021 55.483601 161.80859 55.131649 
  162.15469 54.85693 162.1122 54.761929 161.7327 54.505821 
  161.353 54.4911 161.2355 54.513321 161.19051 54.579708 
  161.10159 54.58971 160.72411 54.528049 160.0058 54.139149 
  159.94659 54.040539 159.8522 53.832771 159.8616 53.689159 
  159.8174 53.6586 159.91969 53.59943 159.87331 53.665539 
  159.9044 53.66832 159.965 53.570271 159.94769 53.471371 
  159.91859 53.472488 159.8566 53.509708 159.7916 53.514709 
  159.9724 53.314991 159.9113 53.257488 159.96471 53.20805 
  159.97189 53.26638 160.0166 53.269428 160.0369 53.202492 
  160.0455 53.096661 159.75301 53.219151 159.82269 53.278599 
  159.7144 53.230549 159.6147 53.25943 159.4588 53.22221 
  159.3844 53.153599 159.2791 53.16943 159.00549 53.076099 
  158.7339 52.89193 158.70219 52.89555 158.6033 53.05415 
  158.5316 53.069439 158.4133 52.997761 158.4558 52.96693 
  158.4241 52.93943 158.44611 52.902489 158.5255 52.90276 
  158.4894 52.943321 158.6272 52.931099 158.6447 52.894711 
  158.5611 52.78944 158.493 52.77055 158.49879 52.742771 
  158.5699 52.734711 158.60271 52.695271 158.5302 52.61916 
  158.4198 52.652729) #(-128.7489 52.59721 -128.59219 52.61388 
  -128.5603 52.73777 -128.5206 52.959431 -128.5847 53.113602 
  -128.70531 53.170551 -128.88139 53.279991 -129.04311 53.30471 
  -129.0898 53.287209 -129.0589 53.23138 -129.0881 53.086102 
  -129.1617 53.071098 -129.192 53.007771 -129.16589 52.923038 
  -129.1058 52.904709 -129.05 52.913052 -128.9572 53.00832 
  -128.8645 53.038879 -128.9939 53.09721 -129.0117 53.139709 
  -128.9639 53.121658 -128.8409 53.029709 -129.0222 52.90554 
  -129.0845 52.87804 -129.12 52.86916 -129.1145 52.82193 
  -129.03281 52.719711 -128.88451 52.648041 -128.8011 52.693321 
  -128.7747 52.661098 -128.7561 52.671101 -128.7814 52.73415 
  -128.75391 52.81971 -128.7428 52.91444 -128.6942 52.89249 
  -128.6664 52.912769 -128.677 52.962769 -128.6433 52.958881 
  -128.6447 52.904148 -128.71249 52.836929 -128.7489 52.59721) 
#(-7.2676539 55.355061 -7.3991671 55.377209 -7.2627778 55.274712 
  -7.521111 55.2836 -7.5475011 55.197208 -7.4547219 55.13221 
  -7.4524999 55.047489 -7.6650009 54.952492 -7.5972219 55.012489 
  -7.5669451 55.048038 -7.6399999 55.04443 -7.5322232 55.099152 
  -7.5736108 55.161381 -7.6169448 55.242771 -7.6577778 55.274429 
  -7.7611108 55.254429 -7.790556 55.20332 -7.7350011 55.187771 
  -7.7205558 55.216648 -7.6986108 55.214161 -7.668056 55.14193 
  -7.7041669 55.094151 -7.727778 55.16721 -7.811111 55.177212 
  -7.7988892 55.249439 -7.874167 55.206379 -7.8638902 55.16444 
  -7.9647231 55.183041 -8.0877781 55.159431 -8.2925014 55.152489 
  -8.3236122 55.024151 -8.3538895 55.056931 -8.4547234 54.99165 
  -8.3672237 54.94138 -8.460001 54.93832 -8.4230556 54.891102 
  -8.3394451 54.903599 -8.315834 54.869709 -8.3700008 54.874439 
  -8.3841667 54.8536 -8.3319454 54.829151 -8.5069447 54.841648 
  -8.5252781 54.811378 -8.4125004 54.753601 -8.6238899 54.769428 
  -8.8011112 54.691662 -8.7744446 54.656651 -8.3819447 54.616379 
  -8.1461124 54.633598 -8.2672234 54.51582 -8.210556 54.498051 
  -8.395834 54.461929 -8.4788895 54.42527 -8.583889 54.391102 
  -8.6663895 54.337769 -8.5091667 54.318321 -8.5391674 54.279991 
  -8.6200008 54.25721 -8.565834 54.233601 -8.936945 54.2836 
  -9.063612 54.2761 -9.1422234 54.139149 -9.2183342 54.211651 
  -9.1997223 54.239712 -9.3050022 54.307209 -9.8436127 54.32555 
  -9.8422241 54.304989 -9.7613907 54.28138 -9.9202785 54.206928 
  -9.9241676 54.221371 -9.8861122 54.260818 -10.00917 54.300819 
  -10.08167 54.25721 -10.09278 54.19582 -10.12444 54.096371 
  -10.06722 54.0886 -10.09056 54.119431 -9.9986115 54.214432 
  -9.9325008 54.14555 -9.9844456 54.09193 -9.9361115 54.060822 
  -9.8916683 54.08527 -9.9041672 54.01638 -9.8122234 53.939709 
  -9.9127789 53.949429 -9.9427795 53.869991 -9.9027786 53.857769 
  -9.7647228 53.894428 -9.566946 53.886379 -9.6072245 53.820541 
  -9.9063892 53.758598 -9.9133339 53.647491 -9.6994457 53.595829 
  -10.00972 53.60194 -10.05028 53.56332 -10.20195 53.540821 
  -10.13611 53.519711 -10.01139 53.475819 -10.05445 53.450821 
  -10.14778 53.443878 -10.17611 53.407768 -9.9480572 53.378601 
  -9.8005562 53.410259 -9.8972235 53.350269 -9.7752781 53.29694 
  -9.7000008 53.36137 -9.6383343 53.382771 -9.6497231 53.326649 
  -9.6111126 53.331661 -9.5994453 53.364429 -9.5577793 53.335541 
  -9.6200008 53.319439 -9.6116676 53.2686 -9.6002789 53.232208 
  -9.5527782 53.289711 -9.542778 53.227772 -9.4900017 53.223598 
  -9.0330563 53.271648 -8.9833336 53.248322 -8.9844456 53.215549 
  -8.9488907 53.185551 -8.9383345 53.140541 -9.085556 53.16082 
  -9.0755558 53.116379 -9.2530556 53.149151 -9.3508339 53.071098 
  -9.4680557 52.92749 -9.3519459 52.92749 -9.4902782 52.773319 
  -9.6033344 52.737209 -9.6644459 52.677761 -9.9113903 52.572491 
  -9.8861122 52.55027 -9.627779 52.61166) 
#(-128.9828 52.453041 -128.9436 52.469711 -128.91859 52.527489 
  -128.9319 52.614712 -129.23109 52.816101 -129.29201 52.761662 
  -129.10339 52.549431 -129.0089 52.525539 -128.9828 52.453041) 
#(-128.4417 52.368038 -128.3658 52.38221 -128.285 52.46804 
  -128.3734 52.7911 -128.44141 52.665821 -128.4283 52.516102 
  -128.3942 52.464989 -128.4678 52.39304 -128.4417 52.368038) 
#(-6.4030252 52.353649 -6.2005558 52.555271 -6.2216668 52.648041 
  -5.9947219 52.961102 -6.0772228 53.1936 -6.2247229 53.35387 
  -6.1436119 53.386662 -6.066668 53.36166 -6.0533342 53.38443 
  -6.1925001 53.46027 -6.103333 53.488319) 
#(23.503748 53.947163 23.521111 53.87859 23.658051 53.529709 
  23.85416 53.210819 23.93499 52.890541 23.93388 52.7122 
  23.883881 52.67804 23.56361 52.58498 23.384159 52.504162 
  23.16888 52.2822) #(-131.1806 52.121658 -131.11391 52.167759 
  -131.03641 52.170818 -131.00529 52.206661 -131.02139 52.22887 
  -131.1817 52.232208 -131.0894 52.249149 -131.09 52.282211 
  -131.147 52.31332 -131.21111 52.302761 -131.22701 52.25193 
  -131.32829 52.284988 -131.3475 52.350819 -131.26311 52.34277 
  -131.2534 52.36832 -131.3042 52.356659 -131.2972 52.386101 
  -131.2395 52.422489 -131.2556 52.440269 -131.35831 52.41415 
  -131.35091 52.363602 -131.3972 52.353039 -131.3914 52.39082 
  -131.44701 52.390541 -131.4156 52.45805 -131.49809 52.513321 
  -131.60809 52.51693 -131.6814 52.637489 -131.7336 52.698601 
  -131.8378 52.710819 -131.8175 52.734711 -131.6492 52.800541 
  -131.83611 52.806381 -131.8672 52.848049 -131.895 52.89193 
  -131.9825 52.879711 -131.8911 52.915539 -131.8022 52.864712 
  -131.6628 52.88221 -131.5981 52.975269 -131.6447 53.00388 
  -131.8764 53.034161 -131.91701 52.984711 -131.9861 53.061378 
  -131.6703 53.047489 -131.5956 53.046101 -131.69501 53.12027 
  -131.7825 53.2286 -131.8111 53.253601 -132.0881 53.152489 
  -132.56219 53.14526 -132.5528 53.08971 -132.47971 53.02721 
  -132.42 53.040272 -132.11031 52.993038 -132.1411 52.93277 
  -132.2556 52.954708 -132.347 52.936378 -132.2834 52.87471 
  -132.22591 52.864429 -132.23669 52.824711 -132.1275 52.75082 
  -132.0986 52.75526 -132.07719 52.854431 -131.95171 52.781101 
  -131.9175 52.722488 -132.0603 52.75526 -132.082 52.727489 
  -131.64281 52.451382 -131.5531 52.432209 -131.5036 52.39138 
  -131.5778 52.3936 -131.57809 52.37582 -131.2578 52.121929 
  -131.23219 52.16193 -131.2773 52.240822 -131.1806 52.121658) 
#(14.4453 53.272591 14.40861 53.21582 14.39083 53.141651 
  14.34222 53.044991 14.16472 52.968868 14.13333 52.833321 
  14.2575 52.790539 14.55111 52.62859 14.64111 52.566662 
  14.53444 52.394711 14.56694 52.328041 14.71333 52.239151 
  14.69305 52.10471 14.76353 52.070808) 
#(-173.5639 52.026932 -173.47031 52.03693 -173.1572 52.055271 
  -172.9644 52.087212 -173.4409 52.102489 -174.0114 52.122761 
  -174.04221 52.127491 -173.8275 52.035259 -173.6844 52.06332 
  -173.5639 52.026932) #(-175.2739 52.006649 -174.6095 52.02499 
  -174.5475 52.058601 -174.48531 52.034988 -174.5211 52.090549 
  -174.4442 52.041931 -174.40891 52.04137 -174.39059 52.084431 
  -174.42419 52.107769 -174.25751 52.093319 -174.2153 52.120819 
  -174.0986 52.10387 -174.0898 52.13055 -174.1945 52.194988 
  -174.185 52.231098 -174.0631 52.223598 -173.9953 52.2911 
  -173.99249 52.326099 -174.15891 52.418598 -174.3728 52.314709 
  -174.4339 52.319149 -174.4359 52.294991 -174.3542 52.27721 
  -174.3295 52.311939 -174.2253 52.252491 -174.27921 52.209991 
  -174.4178 52.212769 -174.5453 52.158871 -174.5961 52.12999 
  -174.58501 52.098881 -174.8683 52.099709 -174.93111 52.072769 
  -175.3322 52.018879 -175.2739 52.006649) 
#(5.9149971 53.384151 5.7036099 53.327492 5.4424992 53.211929 
  5.3786111 53.091648 5.0858331 52.955269 4.872499 52.897209 
  4.8086109 52.92416 4.8205552 52.960819 4.7341661 52.95554 
  4.7194438 52.89082 4.5886111 52.489429 4.435833 52.246658 
  4.1111112 51.985538 4.021111 51.988041) 
#(-127.8708 51.94471 -127.7081 51.988319 -127.6503 52.13554 
  -127.2475 52.301929 -127.2078 52.344711 -127.24 52.420551 
  -127.3628 52.403881 -127.5167 52.30444 -127.7533 52.245819 
  -127.8797 52.084991 -127.8947 51.9561 -127.8708 51.94471) 
#(-79.611954 51.91444 -79.376678 51.9361 -79.319733 51.96999 
  -79.322243 52.031651 -79.253067 52.071381 -79.297501 52.09193 
  -79.53862 52.023319 -79.62973 52.022209 -79.652786 51.981098 
  -79.611954 51.91444) #(177.3322 51.82666 177.3511 51.894428 
  177.46381 51.937222 177.5652 51.911652 177.59331 51.946659 
  177.5511 51.97443 177.6841 52.091648 177.6386 52.11861 
  177.5891 52.121929 177.49879 51.983059 177.36659 51.96999 
  177.22659 51.87804 177.3322 51.82666) 
#(-9.627779 52.61166 -9.6233349 52.611099 -9.5711117 52.663052 
  -9.4072227 52.604988 -9.2752781 52.632488 -9.3319454 52.595829 
  -9.2816677 52.588329 -9.1158352 52.649712 -8.9455566 52.77388 
  -8.9516678 52.67971 -8.7422237 52.670818 -8.8105564 52.661098 
  -9.2950001 52.56554 -9.6169453 52.57082 -9.6758347 52.545269 
  -9.6352787 52.46944 -9.9283352 52.422489 -9.9455566 52.402489 
  -9.8377781 52.376381 -9.835001 52.310551 -9.7408352 52.244709 
  -9.8775005 52.230549 -9.9705563 52.238041 -10.03333 52.287209 
  -10.05583 52.25499 -10.16778 52.231659 -10.16972 52.287491 
  -10.46695 52.176659 -10.47278 52.102489 -10.23778 52.115551 
  -9.9547234 52.14249 -9.8725014 52.151371 -9.7663898 52.144161 
  -9.9111118 52.10416 -10.26611 51.984711 -10.24889 51.901932 
  -10.39806 51.876659 -10.34167 51.842209 -10.33792 51.783649) 
#(-128.1097 51.743599 -128.0072 51.78249 -128.03169 51.826649 
  -128.0042 51.876381 -127.9528 52.048321 -127.9958 52.062771 
  -128.1508 52.035259 -128.2222 51.95332 -128.1945 51.922771 
  -128.23421 51.901932 -128.24249 51.858318 -128.132 51.85165 
  -128.13921 51.751659 -128.1097 51.743599) 
#(-177.6422 51.649429 -177.6208 51.696098 -177.37421 51.726379 
  -177.3159 51.682209 -177.13029 51.71888 -177.1339 51.764431 
  -177.04581 51.888599 -177.14639 51.93832 -177.1956 51.920551 
  -177.19971 51.844711 -177.2433 51.79332 -177.7045 51.700821 
  -177.6422 51.649429) #(-177.89391 51.596931 -177.9111 51.659431 
  -177.8031 51.698601 -177.7972 51.788879 -177.64861 51.81332 
  -177.6194 51.852211 -177.8342 51.832211 -177.9247 51.909161 
  -177.9572 51.91888 -178.1897 51.89526 -178.2142 51.86166 
  -177.96001 51.768879 -177.9483 51.733879 -177.9642 51.716381 
  -178.09061 51.698879 -178.10091 51.664711 -178.0294 51.662769 
  -177.9456 51.602211 -177.89391 51.596931) 
#(-176.92889 51.58527 -176.82091 51.712212 -176.7981 51.60416 
  -176.76109 51.622211 -176.7075 51.67915 -176.4881 51.752769 
  -176.4669 51.719151 -176.4167 51.74971 -176.42641 51.83638 
  -176.6422 51.857208 -176.5461 51.909988 -176.54919 51.971931 
  -176.7245 51.957211 -176.7803 51.936939 -176.7764 51.901661 
  -176.7036 51.847759 -176.772 51.844711 -176.77921 51.824711 
  -176.7025 51.783329 -176.8389 51.787769 -176.86169 51.820541 
  -176.91589 51.787209 -176.8175 51.764431 -176.9722 51.657768 
  -176.97501 51.595829 -176.92889 51.58527) 
#(-56.76334 51.547562 -56.68224 51.642208 -56.5839 51.650269 
  -56.433071 51.74638 -56.40028 51.733601 -56.3489 51.773602 
  -55.915569 51.932209 -55.894451 51.962212 -55.959179 52.019161 
  -55.891109 51.999989 -55.762791 52.050819 -55.793072 52.083881 
  -55.70195 52.082211 -55.686401 52.10944 -55.713619 52.139992 
  -55.6889 52.181099 -55.745289 52.188599 -55.760571 52.219711 
  -55.652241 52.208881 -55.640289 52.228039 -55.787788 52.248322 
  -55.766399 52.275829 -55.98473 52.3736 -55.78278 52.334148 
  -55.64362 52.358318 -55.648621 52.439709 -55.766682 52.447769 
  -55.734459 52.474709 -55.761398 52.498878 -56.262508 52.531651 
  -56.204731 52.543598 -56.04557 52.580818 -55.97279 52.610821 
  -55.982792 52.62249 -56.12001 52.643318 -56.03307 52.654709 
  -55.794731 52.59304 -55.738899 52.642769 -55.779171 52.682491 
  -55.96056 52.67915 -56.160278 52.79388 -56.160568 52.819439 
  -55.99667 52.773319 -55.964729 52.790821 -55.988071 52.806099 
  -55.84417 52.821381 -55.805012 52.877209 -55.889721 52.969151 
  -56.090839 52.970539 -56.13195 52.985538 -55.912231 53.02832 
  -55.881119 53.064709 -55.936401 53.11694 -55.830009 53.09721 
  -55.747509 53.1436 -55.791119 53.198879 -55.74612 53.249439 
  -55.767231 53.26276 -55.797779 53.230549 -55.860008 53.248051 
  -55.82584 53.320541 -55.808071 53.340549 -55.877239 53.35387 
  -55.918339 53.39555 -56.038609 53.367489 -55.965839 53.409161 
  -56.0564 53.475269 -56.26334 53.540272 -56.258621 53.559158 
  -56.14613 53.553051 -56.0089 53.499989 -55.9814 53.53915 
  -56.078899 53.583881 -56.543339 53.63026 -56.72084 53.68388 
  -56.414169 53.727772 -56.464451 53.78194 -56.557789 53.76749 
  -56.6339 53.714989 -56.694729 53.742771 -57.005009 53.71249 
  -57.15279 53.566101 -57.145569 53.541931 -57.285278 53.477489 
  -57.289459 53.43388 -57.375011 53.432209 -57.313351 53.483879 
  -57.32835 53.584148 -57.493622 53.60944 -57.119999 53.7411 
  -57.160011 53.758598 -57.101398 53.80471 -57.21529 53.877491 
  -57.221119 53.91832 -57.190281 53.95055 -57.430561 54.183041 
  -57.511959 54.177212 -58.03112 54.235538 -58.37973 54.193878 
  -58.415279 54.135269 -58.29974 54.086102 -58.15918 54.135818 
  -57.805561 54.086651 -57.815571 54.066101 -58.130009 54.096931 
  -58.200569 54.073318 -58.849171 53.939991 -59.066399 53.794991 
  -59.04306 53.774712 -59.023899 53.713871) 
#(23.16888 52.2822 23.21138 52.223869 23.29388 52.225811 
  23.48583 52.146931 23.59833 52.109428 23.65638 52.04166 
  23.61166 51.91415 23.626381 51.79694 23.55389 51.745819 
  23.539169 51.592758 23.592085 51.528278) 
#(-10.33792 51.783649 -10.20056 51.845829 -10.17611 51.80444 
  -10.22389 51.77499 -10.12806 51.75555 -9.7591667 51.841381 
  -9.5794449 51.869991 -9.8036118 51.785549 -9.9058342 51.757771 
  -9.9861126 51.709709 -9.9827785 51.67915 -10.10361 51.662769 
  -10.06556 51.624439 -10.14944 51.61499 -10.10222 51.59721 
  -9.6019459 51.68832 -9.5494461 51.75526 -9.4850006 51.71138 
  -9.8113899 51.558041 -9.8297234 51.539989 -9.6191673 51.599152 
  -9.8163891 51.48666 -9.8033352 51.44582 -9.5877781 51.504711 
  -9.4030571 51.545818 -9.3800011 51.487209 -9.2300014 51.482208 
  -9.1202793 51.552212 -8.6977787 51.58054 -8.7541676 51.642208 
  -8.5663891 51.637211 -8.5341682 51.607491 -8.5150013 51.67749 
  -8.3861122 51.7061 -8.2958336 51.764431 -8.3386116 51.869709 
  -8.3930569 51.875542 -8.4094448 51.885818 -8.1811123 51.886101 
  -8.2288895 51.828041 -8.2191677 51.795818 -8.0102787 51.82526 
  -8.0050011 51.85915 -7.8841672 51.877769 -7.8475008 51.978039 
  -7.812222 51.941662 -7.5883341 51.99165 -7.5483341 52.056381 
  -7.6341672 52.068321 -7.5911112 52.101379 -7.5519452 52.082489 
  -7.0750008 52.160549 -7.083611 52.131378 -6.9538889 52.178322 
  -6.9950008 52.282768 -6.9133339 52.203041 -6.9161119 52.151371 
  -6.936389 52.120541 -6.8291669 52.17194 -6.8316669 52.23444 
  -6.795279 52.20499 -6.7188892 52.214161 -6.585834 52.171101 
  -6.4741669 52.206661 -6.3613892 52.17749 -6.3216672 52.240261 
  -6.4119449 52.28582 -6.4924998 52.36137 -6.4030252 52.353649) 
#(-127.9044 51.414711 -127.8736 51.464432 -127.9981 51.711651 
  -128.01311 51.721371 -128.1528 51.63805 -128.06531 51.464161 
  -127.9044 51.414711) #(4.021111 51.988041 4.0522208 51.915272 
  4.0261111 51.884159 4.0641661 51.857491 3.8702359 51.7859 
  3.6936109 51.720829 3.687778 51.68943 3.7205551 51.672489 
  3.8286109 51.69138 3.8991671 51.635269 3.9955549 51.618038 
  4.1538892 51.614429 4.208611 51.589989 4.0274992 51.601101 
  3.9955549 51.57943 4.2669439 51.50832 4.293611 51.468319 
  4.2772222 51.445271 4.1111112 51.4436 3.9036109 51.568878 
  3.8625 51.602211 3.5688889 51.59721 3.446389 51.541931 
  3.4525001 51.521099 3.580277 51.4436 3.6913891 51.458599 
  3.7441659 51.414711 3.906666 51.39999 3.9302771 51.448601 
  3.9836111 51.456379 4.0663881 51.41415 4.2002769 51.408039 
  4.236443 51.368771) #(179.2522 51.347488 179.403 51.374161 
  179.1113 51.482498 178.9814 51.581379 178.69411 51.648891 
  178.6608 51.651379 178.6666 51.615002 178.8983 51.560261 
  179.2522 51.347488) #(1.4422131 51.347111 1.424166 51.392208 
  1.174722 51.376099 0.76777768 51.357208 0.71916658 51.4161 
  0.61166662 51.378601 0.55805552 51.411098 0.7144444 51.436939 
  0.72527772 51.455269 0.68388879 51.472759 0.38277781 51.45055 
  0.465 51.50304 0.8038888 51.52832 0.95388877 51.609989 
  0.9530555 51.676929 0.91888881 51.740551 0.75861108 51.69138 
  0.70416671 51.72221 0.8499999 51.737492 0.93666661 51.80777 
  1.004444 51.805538 1.111666 51.773319 1.223611 51.80888 
  1.293611 51.877491 1.201111 51.874439 1.290833 51.939159 
  1.156389 51.939709 1.076667 51.951099 1.248333 51.955818 
  1.259863 51.964802 1.1586111 52.019711 1.175 52.02388 
  1.333889 51.92915 1.588611 52.085541 1.639722 52.276371 
  1.733055 52.39304 1.7424999 52.63055 1.645278 52.771099 
  1.274722 52.928051 0.92777783 52.951931 0.53722209 52.96249 
  0.38361111 52.793049 0.01083333 52.891651 0.34166661 53.095829 
  0.35111111 53.193878 0.2355555 53.399429 -0.1175 53.581928 
  -0.25974709 53.68362) #(4.2300119 51.35722 4.2108331 51.37249 
  3.9819441 51.407211 3.9613891 51.369709 3.832778 51.341648 
  3.6011109 51.39193 3.4433329 51.392769 3.370646 51.375549) 
#(4.236443 51.368771 4.2938881 51.306381 4.2300119 51.35722) 
#(3.370646 51.375549 2.9716661 51.257488 2.541667 51.091099) 
#(-4.7618799 52.788712 -4.5919452 52.815269 -4.5252781 52.778881 
  -4.4930558 52.796379 -4.500556 52.82943 -4.395 52.890541 
  -4.065556 52.915539 -4.148334 52.798321 -4.0983329 52.7561 
  -3.989167 52.731659 -4.0594449 52.699711 -4.12639 52.60165 
  -4.0555558 52.540821 -3.9747219 52.551102 -3.9666669 52.536381 
  -4.0575008 52.52388 -4.061389 52.47665 -4.1502781 52.315269 
  -4.4413891 52.164711 -4.7227778 52.113041 -4.8377781 52.014149 
  -5.0763888 52.021648 -5.0769448 51.996101 -5.228889 51.923599 
  -5.3094449 51.86166 -5.252501 51.869709 -5.1200008 51.845539 
  -5.104445 51.770821 -5.2127781 51.731098 -4.9672232 51.701649 
  -4.8861108 51.751099 -4.8438892 51.706928 -5.1158342 51.673321 
  -4.9938898 51.606659 -4.856668 51.64193 -4.7833338 51.631939 
  -4.690834 51.687481 -4.6341672 51.727772 -4.3633342 51.783039 
  -4.356112 51.735271 -4.0780559 51.646099 -4.2427778 51.63776 
  -4.295279 51.556931 -4.2116671 51.531651 -4.1119452 51.564991 
  -4.0172219 51.552212 -3.9961121 51.596931 -3.935833 51.612492 
  -3.825556 51.595829 -3.542778 51.39777 -3.334167 51.379711 
  -3.1641669 51.40971 -3.164444 51.454708 -3.041389 51.52026 
  -2.886945 51.53915 -2.7066669 51.584991 -2.478889 51.740261 
  -2.4749999 51.721931 -2.6813891 51.523041 -2.793056 51.48082 
  -2.989722 51.346371 -3.0063889 51.247211 -3.0252781 51.190819 
  -3.238889 51.18832 -3.7772231 51.243038 -4.23 51.186378 
  -4.2119451 51.070541 -4.3513889 50.989429 -4.4747229 51.014149) 
#(158.4198 52.652729 158.4722 52.584709 158.52409 52.514709 
  158.46249 52.463871 158.42751 52.401932 158.5349 52.426659 
  158.56799 52.390541 158.5002 52.344711 158.5341 52.331379 
  158.5311 52.27776 158.3766 52.2136 158.41969 52.170551 
  158.3152 52.125271 158.2688 51.93082 158.0244 51.77277 
  157.9474 51.676659 157.5369 51.486931 157.48331 51.421379 
  157.5108 51.39304 157.4675 51.375542 156.6805 50.886379 
  156.65021 50.901661 156.7455 50.98777 156.7444 51.081379 
  156.7016 51.09832 156.7063 51.19138 156.6572 51.242489 
  156.5602 51.2686 156.52361 51.308601 156.5127 51.430538 
  156.4808 51.46582 156.49969 51.7836 156.4402 52.1661 
  156.2775 52.523602 156.3158 52.508881 156.3766 52.44276 
  156.44189 52.493881 156.43469 52.526932 156.34489 52.522209 
  156.2547 52.574711 156.1013 52.856098 156.0802 53.118599 
  155.9352 53.795551 155.7863 54.240551 155.6008 54.91666 
  155.545 55.330269 155.5697 55.413879 155.6461 55.91193 
  155.7177 56.089989 155.7599 56.106098 155.7361 56.136929 
  155.96989 56.690819 156.15221 56.842491 156.1689 56.83527 
  156.1086 56.78915 156.06329 56.71471 156.4763 56.974709 
  156.5569 57.107491 156.6794 57.042488 156.8822 57.31221 
  156.9875 57.45332 156.93111 57.64777 156.87379 57.699162 
  156.77251 57.73082 156.7869 57.763599 156.985 57.8536 
  157.17439 57.771931 157.4341 57.790539 157.5294