# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Guillaume Emont <guillaume@fluendo.com>

import os
from twisted.internet import threads

def have_file_sync(file_path):
    """
    Check whether a file exists and is non empty.

    You should prefer have_file(), its non-blocking version.

    @param file_path: the path of the file to check for existence
    @type  file_path: C{unicode}

    @return: True if the file exists and is not empty, False otherwise
    @rtype:  C{bool}
    """
    if os.path.exists(file_path):
        stat = os.stat(file_path)
        if stat.st_size != 0:
            return True
    return False


def have_file(file_path):
    """
    Check whether a file exists and is non empty.

    Note: the returned deferred is not cancellable

    @param file_path: the path of the file to check for existence
    @type  file_path: C{unicode}

    @return: Whether the file exists and is non empty (in a deferred)
    @rtype:  C{twisted.internet.defer.Deferred}
    """

    return threads.deferToThread(have_file_sync, file_path)
