/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

struct cw_nx_s
{
#ifdef CW_DBG
    uint32_t magic;
#define CW_NX_MAGIC 0xae9678fd
#endif

    bool is_malloced;

    /* Linkage for nxa's list of nx's. */
    ql_elm(cw_nx_t) link;

    /* Initial maximum estack depth for new threads. */
    cw_nxoi_t maxestack;

    /* Initial setting for tail call optimization. */
    bool tailopt;

    /* Dictionaries. */
    cw_nxo_t threadsdict;
    cw_nxo_t systemdict;
    cw_nxo_t globaldict;

    /* Files. */
    cw_nxo_t stdin_nxo;
    cw_nxo_t stdout_nxo;
    cw_nxo_t stderr_nxo;

    /* Thread initialization hook. */
    cw_op_t *thread_init;

    /* Thread start hook. */
    cw_thread_start_t *thread_start;
};

/* nx. */
cw_nx_t *
nx_new(cw_nx_t *a_nx, cw_op_t *a_thread_init,
       cw_thread_start_t *a_thread_start);

void
nx_delete(cw_nx_t *a_nx);

void
nx_maxestack_set(cw_nx_t *a_nx, cw_nxoi_t a_maxestack);

void
nx_tailopt_set(cw_nx_t *a_nx, bool a_tailopt);

void
nx_stdin_set(cw_nx_t *a_nx, cw_nxo_t *a_stdin);

void
nx_stdout_set(cw_nx_t *a_nx, cw_nxo_t *a_stdout);

void
nx_stderr_set(cw_nx_t *a_nx, cw_nxo_t *a_stderr);

#ifndef CW_USE_INLINES
cw_nxoi_t
nx_maxestack_get(cw_nx_t *a_nx);

bool
nx_tailopt_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_threadsdict_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_systemdict_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_globaldict_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_stdin_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_stdout_get(cw_nx_t *a_nx);

cw_nxo_t *
nx_stderr_get(cw_nx_t *a_nx);
#endif

#if (defined(CW_USE_INLINES) || defined(CW_NX_C_))
CW_INLINE cw_nxoi_t
nx_maxestack_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return a_nx->maxestack;
}

CW_INLINE bool
nx_tailopt_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return a_nx->tailopt;
}

CW_INLINE cw_nxo_t *
nx_threadsdict_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->threadsdict;
}

CW_INLINE cw_nxo_t *
nx_systemdict_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->systemdict;
}

CW_INLINE cw_nxo_t *
nx_globaldict_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->globaldict;
}

CW_INLINE cw_nxo_t *
nx_stdin_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->stdin_nxo;
}

CW_INLINE cw_nxo_t *
nx_stdout_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->stdout_nxo;
}

CW_INLINE cw_nxo_t *
nx_stderr_get(cw_nx_t *a_nx)
{
    cw_check_ptr(a_nx);
    cw_dassert(a_nx->magic == CW_NX_MAGIC);

    return &a_nx->stderr_nxo;
}
#endif /* (defined(CW_USE_INLINES) || defined(CW_NX_C_)) */
