#!/usr/bin/perl -w

eval 'exec /usr/bin/perl -w -S $0 ${1+"$@"}'
    if 0; # not running under some shell
use strict;

use Getopt::Long;

my %args;
GetOptions(\%args, 'service=s');

# Determine our service, default is Metamark for no real reason
my $config;
# eval in case we don't have Config::Auto installed
eval 'use Config::Auto 0.04';

unless ($@) {
  # eval in case we don't have a config file
  $config = eval 'Config::Auto::parse()';
}

my $service = $args{service} || $ENV{SHORTEN_SERVICE} ||
              $config->{service} || 'Metamark';
$service = "WWW::Shorten::$service";

# Import it
eval "require $service";
if ($@) {
    die "Invalid service in your configuration.\n";
}
$service->import('makeashorterlink');

# Get argument
die "No URL specified!\n" unless @ARGV;
my $url = $ARGV[0];
$url = "http://$url" unless $url =~ m[^\w+://];

# Convert
my $out = eval 'makeashorterlink( $url )';
$out = "Error" if $@ or not defined $out;

# Output
print "$out\n";

__END__

=head1 NAME

shorten - CLI program to demonstrate use of WWW::Shorten

=head1 SYNOPSIS

    % shorten books.perl.org/book/171
    http://tinyclick.com/?2x6nss

    # Or, if you specify a different service in your config file

    % shorten books.perl.org/book/171
    http://snurl.com/xc3

=head1 CONFIGURATION

The service used can be controlled in various ways. The program will
use the first of the following values that it finds:

=over 4

=item *

The value of the C<--service> command line option.

=item *

The value of the C<SHORTEN_SERVICE> environment variable.

=item *

The value of the C<service> option from the configuration file (see
below).

=item *

If none of the above options is found, the program defaults to using
Metamark.

=back

=head1 CONFIGURATION FILE

As we use the C<Config::Auto> module for configuration, shorten's
fairly flexible when it comes to format.

Configuration will be found in whichever of the following files
comes first.

    shortenconfig
    ~/shortenconfig
    /etc/shortenconfig
    shorten.config
    ~/shorten.config
    /etc/shorten.config
    shortenrc
    ~/shortenrc
    /etc/shortenrc
    .shortenrc
    ~/.shortenrc
    /etc/.shortenrc

Generally, I use the format:

    service = MakeAShorterLink

which is simple and works. C<service> is the only configuration keyword
at present. Its value should be a correctly capitalized service name as
per L<WWW::Shorten>'s documentation.

=head1 BUGS, REQUESTS, COMMENTS

Please report any requests, suggestions or bugs via the system at
L<http://rt.cpan.org/>, or email E<lt>bug-WWW-Shorten@rt.cpan.orgE<gt>.
This makes it much easier for me to track things and thus means
your problem is less likely to be neglected.

=head1 LICENSE AND COPYRIGHT

Copyright E<copy> Magnum Solutions Ltd, 2002 - 2010. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHOR

Dave Cross <dave@mag-sol.com>, taking over from
Iain Truskett <spoon@cpan.org>

=head1 SEE ALSO

L<perl>

=cut
