;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                        ;;
;;             Center for Spoken Language Understanding                   ;;
;;        Oregon Graduate Institute of Science & Technology               ;;
;;                         Portland, OR USA                               ;;
;;                        Copyright (c) 2000                              ;;
;;                                                                        ;;
;;      This module is not part of the CSTR/University of Edinburgh       ;;
;;               release of the Festival TTS system.                      ;;
;;                                                                        ;;
;;  In addition to any conditions disclaimers below, please see the file  ;;
;;  "license_ogi_tts.txt" distributed with this software for information  ;;
;;  on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.  ;;
;;                                                                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(set! OGI_english_token_pos_cart_trees
  '(
    ;;  Format is (Regex Tree)
    ("[0-9]+" 
     ((lisp_num_digits < 3.8)
      ((p.lisp_token_pos_guess is month)
       ((lisp_month_range is 0) ((year)) ((ordinal)))
       ((n.lisp_token_pos_guess is month)
	((lisp_month_range is 0) ((cardinal)) ((ordinal)))
	((n.lisp_token_pos_guess is numeric)
	 ((lisp_num_digits < 2)
	  ((p.lisp_token_pos_guess is numeric)
	   ((pp.lisp_token_pos_guess is sym) ((digits)) ((cardinal)))
	   ((cardinal)))
	  ((nn.lisp_token_pos_guess is sym) ((cardinal)) ((digits))))
	 ((lisp_num_digits < 2)
	  ((nn.lisp_token_pos_guess is numeric)
	   ((n.lisp_token_pos_guess is sym)
	    ((lisp_month_range is 0) ((digits)) ((cardinal)))
	    ((cardinal)))
	   ((cardinal)))
	  ((name < 302.3)
	   ((p.lisp_token_pos_guess is flight)
	    ((digits))
	    ((n.lisp_token_pos_guess is sym)
	     ((p.lisp_token_pos_guess is sym) ((digits)) ((cardinal)))
	     ((cardinal))))
	   ((p.lisp_token_pos_guess is a)
	    ((digits))
	    ((n.lisp_token_pos_guess is sym)
	     ((nn.lisp_token_pos_guess is sym)
	      ((name < 669.2) ((digits)) ((cardinal)))
	      ((cardinal)))
	     ((name < 373.2)
	      ((cardinal))
	      ((name < 436.2)
	       ((name < 392.6) ((digits)) ((cardinal)))
	       ((name < 716.5)
		((cardinal))
		((name < 773.6)
		 ((p.lisp_token_pos_guess is _other_) ((digits)) ((cardinal)))
		 ((cardinal)))))))))))))
      ((p.lisp_token_pos_guess is numeric)
       ((pp.lisp_token_pos_guess is month)
	((year))
	((nn.lisp_token_pos_guess is numeric) ((cardinal)) ((digits))))
       ((nn.lisp_token_pos_guess is numeric)
	((n.lisp_token_pos_guess is month)
	 ((cardinal))
	 ((n.lisp_token_pos_guess is numeric)
	  ((digits))
	  ((p.lisp_token_pos_guess is _other_) ((cardinal)) ((year)))))
	((p.lisp_token_pos_guess is _other_)
	 ((lisp_num_digits < 4.4)
	  ((name < 2959.6)
	   ((name < 1773.4) ((cardinal)) ((year)))
	   ((cardinal)))
	  ((pp.lisp_token_pos_guess is _other_) ((digits)) ((cardinal))))
	 ((n.lisp_token_pos_guess is to)
	  ((year))
	  ((p.lisp_token_pos_guess is sym)
	   ((pp.lisp_token_pos_guess is sym)
	    ((cardinal))
	    ((lisp_num_digits < 4.6) ((year)) ((digits))))
	   ((lisp_num_digits < 4.8)
	    ((name < 2880)
	     ((name < 1633.2)
	      ((name < 1306.4) ((cardinal)) ((year)))
	      ((year)))
	     ((cardinal)))
	    ((cardinal)))))))))
     )
    ("\\(II?I?\\|IV\\|VI?I?I?\\|IX\\|X[VIX]*\\)";; Roman numerals
     ((p.lisp_tok_rex_names is 0)
      ((lisp_num_digits is 5)
       ((number))
       ((lisp_num_digits is 4)
	((number))
	((nn.lisp_num_digits is 13)
	 ((number))
	 ((p.lisp_num_digits is 7)
	  ((number))
	  ((p.lisp_tok_section_name is 0)
	   ((lisp_tok_rex is 0)
	    ((lisp_num_digits is 3)
	     ((p.lisp_num_digits is 4)
	      ((number))
	      ((nn.lisp_num_digits is 4)
	       ((number))
	       ((n.lisp_num_digits is 4)
		((number))
		((pp.lisp_num_digits is 3)
		 ((number))
		 ((p.lisp_num_digits is 2)
		  ((letter))
		  ((nn.lisp_num_digits is 2)
		   ((letter))
		   ((n.cap is 0) ((letter)) ((number)))))))))
	     ((nn.lisp_num_digits is 11)
	      ((letter))
	      ((lisp_num_digits is 1)
	       ((pp.lisp_num_digits is 9)
		((letter))
		((p.lisp_num_digits is 9)
		 ((letter))
		 ((n.lisp_num_digits is 6)
		  ((letter))
		  ((pp.lisp_num_digits is 6)
		   ((letter))
		   ((pp.cap is 0)
		    ((n.cap is 0)
		     ((p.lisp_num_digits is 1)
		      ((letter))
		      ((n.lisp_num_digits is 4) ((letter)) ((letter))))
		     ((letter)))
		    ((letter)))))))
	       ((p.lisp_num_digits is 10)
		((number))
		((n.lisp_num_digits is 8)
		 ((number))
		 ((pp.lisp_num_digits is 9)
		  ((number))
		  ((nn.lisp_num_digits is 5)
		   ((number))
		   ((n.lisp_num_digits is 4) ((number)) ((letter))))))))))
	    ((letter)))
	   ((number)))))))
      ((century))))
    ("\\([dD][Rr]\\|[Ss][tT]\\)"
     ((n.name is 0)
      ((p.cap is 1)
       ((street))
       ((p.name matches "[0-9]*\\(1[sS][tT]\\|2[nN][dD]\\|3[rR][dD]\\|[0-9][tT][hH]\\)")
	((street))
	((title))))
      ((punc matches ".*,.*")
       ((street))
       ((p.punc matches ".*,.*")
	((title))
	((n.cap is 0)
	 ((street))
	 ((p.cap is 0)
	  ((p.name matches "[0-9]*\\(1[sS][tT]\\|2[nN][dD]\\|3[rR][dD]\\|[0-9][tT][hH]\\)")
	   ((street))
	   ((title)))
	  ((pp.name matches "[1-9][0-9]+")
	   ((street))
	   ((title)))))))))
    ("read"
     ((p.name matches "was\\|were\\|had\\|been\\|having\\|has\\|have\\|is\\|are\\|wasn't\\|weren't\\|isn't\\|aren't\\|hasn't\\|haven't")
      ((red))
      ((riid))))
    ))

(provide 'ogi_token.scm)


