/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import msfgui.Base64;
import msfgui.MainFrame;
import msfgui.MsfException;
import msfgui.MsfFrame;
import msfgui.MsfguiApp;
import msfgui.RpcConnection;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class PayloadPopup
extends MsfFrame {
    private RpcConnection rpcConn;
    private ArrayList elementVector;
    private String fullName;
    private MainFrame mainFrame;
    private JTextField archField;
    private JLabel archLabel;
    private JLabel authorsLabel;
    private ButtonGroup buttonGroup1;
    private JButton choosePathButton;
    private JLabel descriptionLabel;
    private JRadioButton displayButton;
    private JComboBox encoderCombo;
    private JLabel encoderLabel;
    private JButton generateButton;
    private JButton handleButton;
    private JScrollPane jScrollPane1;
    private JLabel licenseLabel;
    private JPanel mainPanel;
    private JComboBox outputCombo;
    private JLabel outputLabel;
    private JTextArea outputPane;
    private JTextField outputPathField;
    private JLabel outputPathLabel;
    private JScrollPane outputScrollPane;
    private JRadioButton saveButton;
    private JButton templateButton;
    private JTextField templateField;
    private JLabel templateLabel;
    private JCheckBox templateWorkingCheck;
    private JTextField timesField;
    private JLabel timesLabel;
    private JLabel titleLabel;
    private JLabel versionLabel;

    public PayloadPopup(String fullName, RpcConnection rpcConn, MainFrame frame) {
        this.mainFrame = frame;
        this.initComponents();
        this.outputPathField.setText(MsfguiApp.getTempFolder() + File.separator + "msf.exe");
        this.rpcConn = rpcConn;
        this.elementVector = new ArrayList();
        this.fullName = fullName;
        this.showOptions(fullName);
        try {
            Object[] encoders = ((List)((Map)rpcConn.execute("module.encoders", new Object[0])).get("modules")).toArray();
            int defaultEncoder = 0;
            for (int i = 0; i < encoders.length; ++i) {
                if (!encoders[i].toString().equals("generic/none")) continue;
                defaultEncoder = i;
            }
            this.encoderCombo.setModel(new DefaultComboBoxModel<Object>(encoders));
            this.encoderCombo.setSelectedIndex(defaultEncoder);
        }
        catch (MsfException xre) {
            // empty catch block
        }
        this.setSize(800, 700);
    }

    private void resetLayout() {
        boolean saving = this.saveButton.isSelected();
        this.outputScrollPane.setVisible(!saving);
        this.archField.setVisible(saving);
        this.archLabel.setVisible(saving);
        this.choosePathButton.setVisible(saving);
        this.encoderCombo.setVisible(saving);
        this.encoderLabel.setVisible(saving);
        this.outputCombo.setVisible(saving);
        this.outputLabel.setVisible(saving);
        this.outputPathField.setVisible(saving);
        this.outputPathLabel.setVisible(saving);
        this.templateButton.setVisible(saving);
        this.templateField.setVisible(saving);
        this.templateLabel.setVisible(saving);
        this.templateWorkingCheck.setVisible(saving);
        this.timesField.setVisible(saving);
        this.timesLabel.setVisible(saving);
        GroupLayout mainPanelLayout = (GroupLayout)this.mainPanel.getLayout();
        GroupLayout.ParallelGroup labelGroup = mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < this.elementVector.size(); ++i) {
            labelGroup = labelGroup.addComponent(((Component[])this.elementVector.get(i))[0]);
        }
        GroupLayout.ParallelGroup textBoxGroup = mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (int i = 0; i < this.elementVector.size(); ++i) {
            textBoxGroup = textBoxGroup.addComponent(((Component[])this.elementVector.get(i))[1]);
        }
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel).addComponent(this.descriptionLabel).addComponent(this.authorsLabel).addComponent(this.licenseLabel).addComponent(this.versionLabel).addGroup(mainPanelLayout.createSequentialGroup().addGroup(labelGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(textBoxGroup).addContainerGap()).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.generateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.handleButton)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.outputScrollPane, -1, 40, Short.MAX_VALUE).addContainerGap()).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.encoderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.outputLabel, -1, -1, Short.MAX_VALUE).addComponent(this.archLabel, -1, -1, Short.MAX_VALUE).addComponent(this.timesLabel, -1, -1, Short.MAX_VALUE).addComponent(this.outputPathLabel, -1, -1, Short.MAX_VALUE).addComponent(this.templateLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encoderCombo, 0, 188, Short.MAX_VALUE).addComponent(this.outputCombo, 0, 188, Short.MAX_VALUE).addComponent(this.archField, -1, 188, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateField, -1, 110, Short.MAX_VALUE).addComponent(this.outputPathField, -1, 110, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.templateButton).addComponent(this.choosePathButton))).addComponent(this.timesField, -1, 188, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateWorkingCheck))).addContainerGap()));
        GroupLayout.SequentialGroup groupie = mainPanelLayout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel);
        for (int i = 0; i < this.elementVector.size(); ++i) {
            groupie = groupie.addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(((Component[])this.elementVector.get(i))[0]).addComponent(((Component[])this.elementVector.get(i))[1], -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        groupie = groupie.addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateButton).addComponent(this.displayButton).addComponent(this.saveButton).addComponent(this.handleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputScrollPane, -1, 30, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputPathLabel).addComponent(this.outputPathField, -2, -1, -2).addComponent(this.choosePathButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encoderLabel).addComponent(this.encoderCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLabel).addComponent(this.outputCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timesLabel).addComponent(this.timesField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.archLabel).addComponent(this.archField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateLabel).addComponent(this.templateField, -2, -1, -2).addComponent(this.templateButton).addComponent(this.templateWorkingCheck)).addContainerGap();
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupie));
    }

    private void showOptions(String fullName) {
        try {
            Map info = (Map)this.rpcConn.execute("module.info", "payload", fullName);
            this.setTitle(info.get("name") + " " + fullName);
            this.titleLabel.setText("<html><h2>" + info.get("name") + "</h2></html>");
            this.descriptionLabel.setText(info.get("description").toString().replace("\n", " "));
            if (info.get("license") instanceof String) {
                this.licenseLabel.setText("<html><b>License:</b> " + info.get("license") + "</html>");
            } else {
                List license = (List)info.get("license");
                StringBuilder licenseString = new StringBuilder();
                for (Object lic : license) {
                    licenseString.append(lic).append(" ");
                }
                this.licenseLabel.setText("<html><b>License:</b> " + licenseString + "</html>");
            }
            this.versionLabel.setText("<html><b>Version:</b> " + info.get("version") + "</html>");
            List authors = (List)info.get("authors");
            StringBuilder authorLine = new StringBuilder();
            if (authors.size() > 0) {
                authorLine.append(authors.get(0).toString());
            }
            for (int i = 1; i < authors.size(); ++i) {
                authorLine.append(", ").append(authors.get(i));
            }
            this.authorsLabel.setText("<html><b>Authors:</b> " + authorLine.toString() + "</html>");
            Map options = (Map)this.rpcConn.execute("module.options", "payload", fullName);
            for (Object optionName : options.keySet()) {
                this.addOption(optionName, (Map)options.get(optionName));
            }
            this.resetLayout();
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex);
        }
    }

    private void addOption(Object optionName, Map option) {
        JLabel lab = new JLabel();
        this.mainPanel.add(lab);
        lab.setText(optionName + " " + option.get("desc"));
        lab.setName(optionName.toString());
        JTextField optionField = new JTextField();
        if (option.get("default") != null) {
            optionField.setText(option.get("default").toString());
        } else if (optionName.equals("LHOST")) {
            optionField.setText(MsfguiApp.getLocalIp());
        }
        optionField.setName("field" + optionName);
        this.mainPanel.add(optionField);
        this.elementVector.add(new Component[]{lab, optionField});
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.timesField = new JTextField();
        this.encoderCombo = new JComboBox();
        this.outputCombo = new JComboBox();
        this.templateButton = new JButton();
        this.templateWorkingCheck = new JCheckBox();
        this.archLabel = new JLabel();
        this.outputLabel = new JLabel();
        this.timesLabel = new JLabel();
        this.archField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.encoderLabel = new JLabel();
        this.generateButton = new JButton();
        this.versionLabel = new JLabel();
        this.licenseLabel = new JLabel();
        this.authorsLabel = new JLabel();
        this.outputScrollPane = new JScrollPane();
        this.outputPane = new JTextArea();
        this.displayButton = new JRadioButton();
        this.saveButton = new JRadioButton();
        this.outputPathLabel = new JLabel();
        this.outputPathField = new JTextField();
        this.choosePathButton = new JButton();
        this.templateLabel = new JLabel();
        this.templateField = new JTextField();
        this.handleButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setName("jScrollPane1");
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(MsfguiApp.class).getContext().getResourceMap(PayloadPopup.class);
        this.timesField.setText(resourceMap.getString("timesField.text", new Object[0]));
        this.timesField.setName("timesField");
        this.encoderCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.encoderCombo.setName("encoderCombo");
        this.outputCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"c", "elf", "exe", "java", "js_le", "js_be", "perl", "raw", "ruby", "vba", "vbs", "loop-vbs", "asp", "war", "macho"}));
        this.outputCombo.setSelectedIndex(2);
        this.outputCombo.setName("outputCombo");
        this.templateButton.setText(resourceMap.getString("templateButton.text", new Object[0]));
        this.templateButton.setName("templateButton");
        this.templateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.templateButtonActionPerformed(evt);
            }
        });
        this.templateWorkingCheck.setText(resourceMap.getString("templateWorkingCheck.text", new Object[0]));
        this.templateWorkingCheck.setName("templateWorkingCheck");
        this.archLabel.setText(resourceMap.getString("archLabel.text", new Object[0]));
        this.archLabel.setName("archLabel");
        this.outputLabel.setText(resourceMap.getString("outputLabel.text", new Object[0]));
        this.outputLabel.setName("outputLabel");
        this.timesLabel.setText(resourceMap.getString("timesLabel.text", new Object[0]));
        this.timesLabel.setName("timesLabel");
        this.archField.setText(resourceMap.getString("archField.text", new Object[0]));
        this.archField.setName("archField");
        this.descriptionLabel.setText(resourceMap.getString("descriptionLabel.text", new Object[0]));
        this.descriptionLabel.setName("descriptionLabel");
        this.titleLabel.setText(resourceMap.getString("titleLabel.text", new Object[0]));
        this.titleLabel.setName("titleLabel");
        this.encoderLabel.setText(resourceMap.getString("encoderLabel.text", new Object[0]));
        this.encoderLabel.setName("encoderLabel");
        this.generateButton.setText(resourceMap.getString("generateButton.text", new Object[0]));
        this.generateButton.setName("generateButton");
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.generateButtonActionPerformed(evt);
            }
        });
        this.versionLabel.setText(resourceMap.getString("versionLabel.text", new Object[0]));
        this.versionLabel.setName("versionLabel");
        this.licenseLabel.setText(resourceMap.getString("licenseLabel.text", new Object[0]));
        this.licenseLabel.setName("licenseLabel");
        this.authorsLabel.setText(resourceMap.getString("authorsLabel.text", new Object[0]));
        this.authorsLabel.setName("authorsLabel");
        this.outputScrollPane.setHorizontalScrollBarPolicy(31);
        this.outputScrollPane.setName("outputScrollPane");
        this.outputPane.setColumns(20);
        this.outputPane.setEditable(false);
        this.outputPane.setLineWrap(true);
        this.outputPane.setName("outputPane");
        this.outputScrollPane.setViewportView(this.outputPane);
        this.buttonGroup1.add(this.displayButton);
        this.displayButton.setSelected(true);
        this.displayButton.setText(resourceMap.getString("displayButton.text", new Object[0]));
        this.displayButton.setName("displayButton");
        this.displayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.displayButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.saveButton);
        this.saveButton.setText(resourceMap.getString("saveButton.text", new Object[0]));
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.saveButtonActionPerformed(evt);
            }
        });
        this.outputPathLabel.setText(resourceMap.getString("outputPathLabel.text", new Object[0]));
        this.outputPathLabel.setName("outputPathLabel");
        this.outputPathField.setText(resourceMap.getString("outputPathField.text", new Object[0]));
        this.outputPathField.setName("outputPathField");
        this.choosePathButton.setText(resourceMap.getString("choosePathButton.text", new Object[0]));
        this.choosePathButton.setName("choosePathButton");
        this.choosePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.choosePathButtonActionPerformed(evt);
            }
        });
        this.templateLabel.setText(resourceMap.getString("templateLabel.text", new Object[0]));
        this.templateLabel.setName("templateLabel");
        this.templateField.setName("templateField");
        this.handleButton.setText(resourceMap.getString("handleButton.text", new Object[0]));
        this.handleButton.setName("handleButton");
        this.handleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PayloadPopup.this.handleButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.outputScrollPane, -1, 1026, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.titleLabel, GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING).addComponent(this.authorsLabel, GroupLayout.Alignment.LEADING).addComponent(this.licenseLabel, GroupLayout.Alignment.LEADING).addComponent(this.versionLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent(this.generateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.handleButton)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.encoderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.outputLabel, -1, -1, Short.MAX_VALUE).addComponent(this.timesLabel, -1, -1, Short.MAX_VALUE).addComponent(this.outputPathLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.templateLabel).addComponent(this.archLabel, -2, 177, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.templateField, -1, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateButton, -2, 87, -2)).addComponent(this.archField, GroupLayout.Alignment.LEADING, -1, 311, Short.MAX_VALUE).addComponent(this.timesField, GroupLayout.Alignment.LEADING, -1, 311, Short.MAX_VALUE).addComponent(this.outputCombo, GroupLayout.Alignment.LEADING, 0, 311, Short.MAX_VALUE).addComponent(this.encoderCombo, GroupLayout.Alignment.LEADING, 0, 311, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent(this.outputPathField, -2, 213, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.choosePathButton, -2, 91, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.templateWorkingCheck).addGap(154, 154, 154))).addGap(195, 195, 195)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateButton).addComponent(this.displayButton).addComponent(this.saveButton).addComponent(this.handleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputScrollPane, -1, 374, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputPathLabel).addComponent(this.outputPathField, -2, -1, -2).addComponent(this.choosePathButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encoderLabel).addComponent(this.encoderCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputLabel).addComponent(this.outputCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timesLabel).addComponent(this.timesField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.archLabel).addComponent(this.archField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateLabel).addComponent(this.templateField, -2, -1, -2).addComponent(this.templateButton).addComponent(this.templateWorkingCheck)).addContainerGap()));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 922, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 752, Short.MAX_VALUE));
        this.pack();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            for (Object obj : this.elementVector) {
                String name = ((JLabel)((Component[])obj)[0]).getName();
                String val = ((JTextField)((Component[])obj)[1]).getText();
                if (val.length() <= 0) continue;
                options.put(name, val);
            }
            Map data = (Map)this.rpcConn.execute("module.execute", "payload", this.fullName, options);
            if (!data.get("result").equals("success")) {
                return;
            }
            String rawHex = data.get("payload").toString();
            if (this.saveButton.isSelected()) {
                byte[] buffer = new byte[rawHex.length() / 2];
                for (int i = 0; i < rawHex.length(); i += 2) {
                    buffer[i / 2] = (byte)Integer.parseInt(rawHex.substring(i, i + 2), 16);
                }
                options.put("format", this.outputCombo.getSelectedItem().toString());
                if (this.timesField.getText().length() > 0) {
                    options.put("ecount", this.timesField.getText());
                }
                if (this.archField.getText().length() > 0) {
                    options.put("arch", this.archField.getText());
                }
                if (this.templateField.getText().length() > 0) {
                    options.put("altexe", this.templateField.getText());
                    if (this.templateWorkingCheck.isSelected()) {
                        options.put("inject", true);
                    }
                }
                Map encoded = (Map)this.rpcConn.execute("module.encode", Base64.encode(buffer), this.encoderCombo.getSelectedItem().toString(), options);
                FileOutputStream fout = new FileOutputStream(this.outputPathField.getText());
                fout.write(Base64.decode(encoded.get("encoded").toString()));
                fout.close();
                return;
            }
            this.outputPane.setText("Payload " + this.fullName + " " + options + " " + rawHex.length() / 2 + " bytes.");
            boolean isPlain = true;
            StringBuilder plain = new StringBuilder("");
            for (int i = 0; i < rawHex.length(); i += 2) {
                int chint = Integer.parseInt(rawHex.substring(i, i + 2), 16);
                if (!Character.isISOControl(chint)) {
                    plain.append((char)chint);
                    continue;
                }
                isPlain = false;
            }
            if (isPlain) {
                this.outputPane.append("\n\nplain text\n" + plain);
            }
            StringBuilder rubyHex = new StringBuilder("\"");
            for (int i = 0; i < rawHex.length(); i += 20) {
                for (int j = 0; j < 20 && i + j + 2 <= rawHex.length(); j += 2) {
                    rubyHex.append("\\x");
                    rubyHex.append(rawHex.substring(i + j, i + j + 2));
                }
                rubyHex.append("\"");
                if (i + 20 >= rawHex.length()) continue;
                rubyHex.append("+\n\"");
            }
            this.outputPane.append("\n\nruby\n" + rubyHex);
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.resetLayout();
    }

    private void displayButtonActionPerformed(ActionEvent evt) {
        this.resetLayout();
    }

    private void choosePathButtonActionPerformed(ActionEvent evt) {
        if (MsfguiApp.fileChooser.showSaveDialog(this) == 0) {
            this.outputPathField.setText(MsfguiApp.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void templateButtonActionPerformed(ActionEvent evt) {
        if (MsfguiApp.fileChooser.showOpenDialog(this) == 0) {
            this.templateField.setText(MsfguiApp.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void handleButtonActionPerformed(ActionEvent evt) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Object obj : this.elementVector) {
            String name = ((JLabel)((Component[])obj)[0]).getName();
            String val = ((JTextField)((Component[])obj)[1]).getText();
            if (val.length() <= 0) continue;
            options.put(name, val);
        }
        options.put("PAYLOAD", this.fullName);
        options.put("TARGET", "0");
        options.put("WORKSPACE", MsfguiApp.workspace);
        try {
            Map data = (Map)this.rpcConn.execute("module.execute", "exploit", "multi/handler", options);
            MsfguiApp.addRecentModule(Arrays.asList("exploit", "multi/handler", options), this.rpcConn, this.mainFrame);
        }
        catch (MsfException ex) {
            JOptionPane.showMessageDialog(this, ex);
        }
    }
}

