/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.VariableTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VMMethod {
    public static final int SIZE = 8;
    private Class _class;
    private long _methodId;

    public long getId() {
        return this._methodId;
    }

    public Class getDeclaringClass() {
        return this._class;
    }

    public native String getName();

    public native String getSignature();

    public native int getModifiers();

    public native LineTable getLineTable() throws JdwpException;

    public native VariableTable getVariableTable() throws JdwpException;

    public String toString() {
        return this.getDeclaringClass().getName() + '.' + this.getName();
    }

    public void writeId(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(this.getId());
    }

    public static VMMethod readId(Class clazz, ByteBuffer byteBuffer) throws JdwpException, IOException {
        return VMVirtualMachine.getClassMethod(clazz, byteBuffer.getLong());
    }

    protected VMMethod(Class clazz, long l) {
        this._class = clazz;
        this._methodId = l;
    }
}

