/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.java.security.der.DEREncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;

public class OID
implements Cloneable,
Comparable,
Serializable {
    private int[] components;
    private transient String strRep;
    private transient byte[] der;
    private boolean relative;

    public int[] getIDs() {
        return (int[])this.components.clone();
    }

    public byte[] getDER() {
        if (this.der == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            if (!this.relative) {
                int n2 = this.components[n++] * 40;
                int n3 = 0;
                if (this.components.length > 1) {
                    n3 = this.components[n++];
                }
                int n4 = n2 + n3;
                OID.encodeSubID(byteArrayOutputStream, n4);
            }
            while (n < this.components.length) {
                OID.encodeSubID(byteArrayOutputStream, this.components[n]);
                ++n;
            }
            this.der = byteArrayOutputStream.toByteArray();
        }
        return (byte[])this.der.clone();
    }

    public OID getParent() {
        if (this.components.length == 1) {
            return null;
        }
        int[] nArray = new int[this.components.length - 1];
        System.arraycopy(this.components, 0, nArray, 0, nArray.length);
        return new OID(nArray);
    }

    public OID getChild(int n) {
        int[] nArray = new int[this.components.length + 1];
        System.arraycopy(this.components, 0, nArray, 0, this.components.length);
        nArray[nArray.length - 1] = n;
        return new OID(nArray);
    }

    public OID getRoot() {
        if (this.components.length <= 2) {
            return this;
        }
        int[] nArray = new int[]{this.components[0], this.components[1]};
        return new OID(nArray);
    }

    public boolean isRelative() {
        return this.relative;
    }

    public Object clone() {
        OID oID = new OID();
        oID.components = this.components;
        oID.strRep = this.strRep;
        return oID;
    }

    public String toString() {
        if (this.strRep != null) {
            return this.strRep;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.components.length) {
            stringBuffer.append((long)this.components[n] & 0xFFFFFFFFL);
            if (n < this.components.length - 1) {
                stringBuffer.append('.');
            }
            ++n;
        }
        this.strRep = stringBuffer.toString();
        return this.strRep;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.components.length) {
            n += this.components[n2] << (n2 & 0x1F);
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OID)) {
            return false;
        }
        return Arrays.equals(this.components, ((OID)object).components);
    }

    public int compareTo(Object object) {
        if (this.equals(object)) {
            return 0;
        }
        int[] nArray = ((OID)object).components;
        int n = Math.min(this.components.length, nArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (this.components[n2] != nArray[n2]) {
                return this.components[n2] < nArray[n2] ? -1 : 1;
            }
            ++n2;
        }
        if (this.components.length == nArray.length) {
            return 0;
        }
        return this.components.length < nArray.length ? -1 : 1;
    }

    private static final int[] fromDER(byte[] byArray, boolean bl) throws DEREncodingException {
        int n;
        int[] nArray = new int[byArray.length + 1];
        int n2 = 0;
        int n3 = 0;
        if (!bl && n3 < byArray.length) {
            n = byArray[n3] & 0xFF;
            nArray[n2++] = n / 40;
            nArray[n2++] = n % 40;
            ++n3;
        }
        while (n3 < byArray.length) {
            n = 0;
            do {
                n = byArray[n3++] & 0xFF;
                int n4 = n2;
                nArray[n4] = nArray[n4] << 7;
                int n5 = n2;
                nArray[n5] = nArray[n5] | n & 0x7F;
                if (n3 < byArray.length || (n & 0x80) == 0) continue;
                throw new DEREncodingException("malformed OID");
            } while ((n & 0x80) != 0);
            ++n2;
        }
        if (n2 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private static final int[] fromString(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer;
        if (string.startsWith("OID.") || string.startsWith("oid.")) {
            string = string.substring(4);
        }
        if ((stringTokenizer = new StringTokenizer(string, ".")).countTokens() == 0) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        return nArray;
    }

    private static final void encodeSubID(ByteArrayOutputStream byteArrayOutputStream, int n) {
        if (n < 128) {
            byteArrayOutputStream.write(n);
        } else if (n < 16384) {
            byteArrayOutputStream.write(n >>> 7 | 0x80);
            byteArrayOutputStream.write(n & 0x7F);
        } else if (n < 0x200000) {
            byteArrayOutputStream.write(n >>> 14 | 0x80);
            byteArrayOutputStream.write((n >>> 7 | 0x80) & 0xFF);
            byteArrayOutputStream.write(n & 0x7F);
        } else if (n < 0x10000000) {
            byteArrayOutputStream.write(n >>> 21 | 0x80);
            byteArrayOutputStream.write((n >>> 14 | 0x80) & 0xFF);
            byteArrayOutputStream.write((n >>> 7 | 0x80) & 0xFF);
            byteArrayOutputStream.write(n & 0x7F);
        }
    }

    public OID(int[] nArray) {
        this(nArray, false);
    }

    public OID(int[] nArray, boolean bl) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.components = (int[])nArray.clone();
        this.relative = bl;
    }

    public OID(String string) {
        this(string, false);
    }

    public OID(String string, boolean bl) {
        this.relative = bl;
        this.strRep = string;
        this.components = OID.fromString(string);
    }

    public OID(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, false);
    }

    public OID(InputStream inputStream, int n, boolean bl) throws IOException {
        this.der = new byte[n];
        inputStream.read(this.der);
        this.relative = bl;
        try {
            this.components = OID.fromDER(this.der, bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw arrayIndexOutOfBoundsException;
        }
    }

    public OID(byte[] byArray) throws IOException {
        this(byArray, false);
    }

    public OID(byte[] byArray, boolean bl) throws IOException {
        this.der = (byte[])byArray.clone();
        this.relative = bl;
        try {
            this.components = OID.fromDER(this.der, bl);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw arrayIndexOutOfBoundsException;
        }
    }

    private OID() {
    }
}

