/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

class Random
implements Constructed {
    private final int gmtUnixTime;
    private final byte[] randomBytes;

    static Random read(InputStream inputStream) throws IOException {
        int n = (inputStream.read() & 0xFF) << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
        byte[] byArray = new byte[28];
        inputStream.read(byArray);
        return new Random(n, byArray);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.gmtUnixTime >>> 24 & 0xFF);
        outputStream.write(this.gmtUnixTime >>> 16 & 0xFF);
        outputStream.write(this.gmtUnixTime >>> 8 & 0xFF);
        outputStream.write(this.gmtUnixTime & 0xFF);
        outputStream.write(this.randomBytes);
    }

    byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
        try {
            this.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    int getTime() {
        return this.gmtUnixTime;
    }

    byte[] getRandomBytes() {
        return this.randomBytes;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  gmt_unix_time = " + this.gmtUnixTime + ';');
        printWriter.println("  random_bytes = " + Util.toHexString(this.randomBytes, ':') + ';');
        printWriter.println("} Random;");
        return stringWriter.toString();
    }

    Random(int n, byte[] byArray) {
        this.gmtUnixTime = n;
        this.randomBytes = (byte[])byArray.clone();
    }
}

