/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.SignatureFactory;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.rsa.EME_PKCS1_V1_5;
import gnu.java.security.sig.rsa.RSA;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.KeyAgreementFactory;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.key.dh.GnuDHKey;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.prng.ARCFour;
import gnu.javax.crypto.sasl.srp.SRPAuthInfoProvider;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.DiffieHellman;
import gnu.javax.net.ssl.provider.DigestInputStream;
import gnu.javax.net.ssl.provider.DigestOutputStream;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Extensions;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.GNUSecurityParameters;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyPool;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.RecordInput;
import gnu.javax.net.ssl.provider.RecordInputStream;
import gnu.javax.net.ssl.provider.RecordOutputStream;
import gnu.javax.net.ssl.provider.SSLRSASignature;
import gnu.javax.net.ssl.provider.SSLRandom;
import gnu.javax.net.ssl.provider.SSLSocketInputStream;
import gnu.javax.net.ssl.provider.SSLSocketOutputStream;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.TLSRandom;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.security.auth.callback.DefaultCallbackHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SSLSocket
extends javax.net.ssl.SSLSocket {
    private static final boolean DEBUG_HANDSHAKE_LAYER = true;
    private static final boolean DEBUG_KEY_EXCHANGE = false;
    private static final Logger logger = SystemLogger.SYSTEM;
    static SortedSet supportedProtocols = new TreeSet();
    static List supportedSuites = new ArrayList(30);
    private static final byte[] SENDER_CLIENT;
    private static final byte[] SENDER_SERVER;
    private Socket underlyingSocket;
    private int underlyingPort;
    private boolean autoClose;
    SessionContext sessionContext;
    Session session;
    LinkedList handshakeListeners;
    private boolean clientMode;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean createSessions;
    private boolean handshakeDone;
    private String remoteHost;
    private InputStream socketIn;
    private OutputStream socketOut;
    private InputStream applicationIn;
    private OutputStream applicationOut;
    private InputStream handshakeIn;
    private OutputStream handshakeOut;
    RecordInput recordInput;
    private long handshakeTime;
    private SocketChannel channel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$gnu$javax$net$ssl$provider$SSLSocket;
    static /* synthetic */ Class class$java$security$Principal;

    private final void initialize() {
        this.session = new Session();
        this.session.enabledSuites = new ArrayList(supportedSuites);
        this.session.enabledProtocols = new TreeSet(supportedProtocols);
        this.session.protocol = ProtocolVersion.TLS_1;
        this.session.params.setVersion(ProtocolVersion.TLS_1);
        this.handshakeListeners = new LinkedList();
        this.handshakeDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            if (handshakeCompletedListener == null) {
                throw new NullPointerException();
            }
            if (!this.handshakeListeners.contains(handshakeCompletedListener)) {
                this.handshakeListeners.add(handshakeCompletedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            this.handshakeListeners.remove(handshakeCompletedListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] getEnabledProtocols() {
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            try {
                Object[] objectArray = this.session.enabledProtocols.toArray();
                Class clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = SSLSocket.class("[Ljava.lang.String;", false);
                }
                return (String[])Util.transform(objectArray, clazz, "toString", null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.getMessage());
                runtimeException.initCause(exception);
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!(stringArray[n].equalsIgnoreCase("SSLv3") || stringArray[n].equalsIgnoreCase("TLSv1") || stringArray[n].equalsIgnoreCase("TLSv1.1"))) {
                throw new IllegalArgumentException("unsupported protocol: " + stringArray[n]);
            }
            ++n;
        }
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            this.session.enabledProtocols.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase("SSLv3")) {
                    this.session.enabledProtocols.add(ProtocolVersion.SSL_3);
                } else if (stringArray[n2].equalsIgnoreCase("TLSv1")) {
                    this.session.enabledProtocols.add(ProtocolVersion.TLS_1);
                } else {
                    this.session.enabledProtocols.add(ProtocolVersion.TLS_1_1);
                }
                ++n2;
            }
            return;
        }
    }

    public final String[] getSupportedProtocols() {
        return new String[]{"TLSv1", "SSLv3"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] getEnabledCipherSuites() {
        List list2 = this.session.enabledSuites;
        synchronized (list2) {
            try {
                Object[] objectArray = this.session.enabledSuites.toArray();
                Class clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = SSLSocket.class("[Ljava.lang.String;", false);
                }
                return (String[])Util.transform(objectArray, clazz, "toString", null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.getMessage());
                runtimeException.initCause(exception);
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (CipherSuite.forName(stringArray[n]) == null) {
                throw new IllegalArgumentException("unsupported suite: " + stringArray[n]);
            }
            ++n;
        }
        List list2 = this.session.enabledSuites;
        synchronized (list2) {
            this.session.enabledSuites.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                CipherSuite cipherSuite = CipherSuite.forName(stringArray[n2]);
                if (!this.session.enabledSuites.contains(cipherSuite)) {
                    this.session.enabledSuites.add(cipherSuite);
                }
                ++n2;
            }
            return;
        }
    }

    public final String[] getSupportedCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[52]);
    }

    public final SSLSession getSession() {
        return this.session;
    }

    public final boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public final void setEnableSessionCreation(boolean bl) {
        this.createSessions = bl;
    }

    public final boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public final void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public final boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public final void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    public final void setUseClientMode(boolean bl) {
        this.clientMode = bl;
    }

    public final synchronized void startHandshake() throws IOException {
        logger.log((Level)Component.SSL_HANDSHAKE, "startHandshake called in {0}", Thread.currentThread());
        this.handshakeTime = System.currentTimeMillis();
        if (this.handshakeDone) {
            if (this.clientMode) {
                this.handshakeDone = false;
                this.doClientHandshake();
            } else {
                Handshake handshake = new Handshake(Handshake.Type.HELLO_REQUEST, null);
                handshake.write(this.handshakeOut, this.session.protocol);
                this.handshakeOut.flush();
            }
            return;
        }
        if (this.recordInput == null) {
            this.setupIO();
        }
        if (this.clientMode) {
            this.doClientHandshake();
        } else {
            this.doServerHandshake();
        }
    }

    public final InetAddress getInetAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getInetAddress();
        }
        return super.getInetAddress();
    }

    public final InetAddress getLocalAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalAddress();
        }
        return super.getLocalAddress();
    }

    public final int getPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getPort();
        }
        return super.getPort();
    }

    public final int getLocalPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalPort();
        }
        return super.getLocalPort();
    }

    public final InputStream getInputStream() throws IOException {
        if (this.applicationIn == null) {
            this.setupIO();
        }
        return this.applicationIn;
    }

    public final OutputStream getOutputStream() throws IOException {
        if (this.applicationOut == null) {
            this.setupIO();
        }
        return this.applicationOut;
    }

    public final void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setTcpNoDelay(bl);
        } else {
            super.setTcpNoDelay(bl);
        }
    }

    public final boolean getTcpNoDelay() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getTcpNoDelay();
        }
        return super.getTcpNoDelay();
    }

    public final void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoLinger(bl, n);
        } else {
            super.setSoLinger(bl, n);
        }
    }

    public final int getSoLinger() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoLinger();
        }
        return super.getSoLinger();
    }

    public final void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void setSoTimeout(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoTimeout(n);
        } else {
            super.setSoTimeout(n);
        }
    }

    public final int getSoTimeout() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    public final void setSendBufferSize(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSendBufferSize(n);
        } else {
            super.setSendBufferSize(n);
        }
    }

    public final int getSendBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSendBufferSize();
        }
        return super.getSendBufferSize();
    }

    public final void setReceiveBufferSize(int n) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setReceiveBufferSize(n);
        } else {
            super.setReceiveBufferSize(n);
        }
    }

    public final int getReceiveBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getReceiveBufferSize();
        }
        return super.getReceiveBufferSize();
    }

    public final synchronized void close() throws IOException {
        if (this.recordInput == null) {
            if (this.underlyingSocket != null) {
                if (this.autoClose) {
                    this.underlyingSocket.close();
                }
            } else {
                super.close();
            }
            return;
        }
        Alert alert = new Alert(Alert.Level.WARNING, Alert.Description.CLOSE_NOTIFY);
        this.sendAlert(alert);
        long l = System.currentTimeMillis() + 60000L;
        while (this.session.currentAlert == null && !this.recordInput.pollClose()) {
            Thread.yield();
            if (l <= System.currentTimeMillis()) break;
        }
        boolean bl = false;
        if (this.session.currentAlert != null && this.session.currentAlert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
            bl = true;
        }
        boolean bl2 = bl;
        this.recordInput = null;
        if (this.underlyingSocket != null) {
            if (this.autoClose) {
                this.underlyingSocket.close();
            }
        } else {
            super.close();
        }
        if (!bl2) {
            this.session.invalidate();
            throw new SSLException("did not receive close notify");
        }
    }

    public final String toString() {
        if (this.underlyingSocket != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Class clazz = class$gnu$javax$net$ssl$provider$SSLSocket;
            if (clazz == null) {
                clazz = class$gnu$javax$net$ssl$provider$SSLSocket = SSLSocket.class("[Lgnu.javax.net.ssl.provider.SSLSocket;", false);
            }
            return stringBuffer.append(clazz.getName()).append(" [ ").append(this.underlyingSocket).append(" ]").toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$javax$net$ssl$provider$SSLSocket;
        if (clazz == null) {
            clazz = class$gnu$javax$net$ssl$provider$SSLSocket = SSLSocket.class("[Lgnu.javax.net.ssl.provider.SSLSocket;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ ").append(super.toString()).append(" ]").toString();
    }

    public final void connect(SocketAddress socketAddress) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.connect(socketAddress);
        } else {
            super.connect(socketAddress);
        }
    }

    public final void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.connect(socketAddress, n);
        } else {
            super.connect(socketAddress, n);
        }
    }

    public final void bind(SocketAddress socketAddress) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.bind(socketAddress);
        } else {
            super.bind(socketAddress);
        }
    }

    public final SocketAddress getLocalSocketAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalSocketAddress();
        }
        return super.getLocalSocketAddress();
    }

    public final SocketChannel getChannel() {
        return this.channel;
    }

    public final boolean isBound() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isBound();
        }
        return super.isBound();
    }

    public final boolean isClosed() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isClosed();
        }
        return super.isClosed();
    }

    public final void setOOBInline(boolean bl) throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final boolean getOOBInline() throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final void setKeepAlive(boolean bl) throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final boolean getKeepAlive() throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final void setTrafficClass(int n) throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final int getTrafficClass() throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final void setReuseAddress(boolean bl) throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final boolean getReuseAddress() throws SocketException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final boolean isConnected() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isConnected();
        }
        return super.isConnected();
    }

    public final boolean isInputShutdown() {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    public final boolean isOutputShutdown() {
        throw new UnsupportedOperationException("1.4 methods not enabled");
    }

    protected final void finalize() {
        if (this.session.currentAlert == null) {
            try {
                this.close();
            }
            catch (Exception exception) {}
        }
    }

    final void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    final void setEnabledCipherSuites(List list2) {
        this.session.enabledSuites = list2;
    }

    final void setEnabledProtocols(SortedSet sortedSet) {
        this.session.enabledProtocols = sortedSet;
    }

    final void setSRPTrustManager(SRPTrustManager sRPTrustManager) {
        this.session.srpTrustManager = sRPTrustManager;
    }

    final void setTrustManager(X509TrustManager x509TrustManager) {
        this.session.trustManager = x509TrustManager;
    }

    final void setKeyManager(X509KeyManager x509KeyManager) {
        this.session.keyManager = x509KeyManager;
    }

    final void setRandom(SecureRandom secureRandom) {
        this.session.random = secureRandom;
    }

    final void sendAlert(Alert alert) throws IOException {
        RecordOutputStream recordOutputStream = new RecordOutputStream(this.socketOut, ContentType.ALERT, this.session.params);
        recordOutputStream.write(alert.getEncoded());
    }

    final Alert checkAlert() {
        return this.session.currentAlert;
    }

    final synchronized void checkHandshakeDone() throws IOException {
        Alert alert;
        if (!this.handshakeDone) {
            this.startHandshake();
        }
        if ((alert = this.session.currentAlert) != null && alert.getLevel() == Alert.Level.FATAL) {
            throw new AlertException(alert, false);
        }
        if (this.handshakeIn.available() > 0 && !this.clientMode) {
            this.handshakeDone = false;
            this.startHandshake();
        }
    }

    private final void changeCipherSpec() throws IOException {
        RecordOutputStream recordOutputStream = new RecordOutputStream(this.socketOut, ContentType.CHANGE_CIPHER_SPEC, this.session.params);
        recordOutputStream.write(1);
    }

    private final void readChangeCipherSpec() throws IOException {
        RecordInputStream recordInputStream = new RecordInputStream(this.recordInput, ContentType.CHANGE_CIPHER_SPEC);
        if (recordInputStream.read() != 1) {
            throw new SSLProtocolException("bad change cipher spec message");
        }
    }

    private final synchronized void setupIO() throws IOException {
        if (this.recordInput != null) {
            return;
        }
        if (this.underlyingSocket != null) {
            this.socketIn = this.underlyingSocket.getInputStream();
            this.socketOut = this.underlyingSocket.getOutputStream();
        } else {
            this.socketIn = super.getInputStream();
            this.socketOut = super.getOutputStream();
        }
        this.recordInput = new RecordInput(this.socketIn, this.session);
        this.applicationIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.APPLICATION_DATA), this);
        this.applicationOut = new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.APPLICATION_DATA, this.session.params), this);
        this.handshakeIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.HANDSHAKE), this, false);
        this.handshakeOut = new BufferedOutputStream(new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.HANDSHAKE, this.session.params), this, false), 8096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handshakeCompleted() {
        this.handshakeDone = true;
        HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.session);
        Object object = this.handshakeListeners.iterator();
        while (object.hasNext()) {
            try {
                ((HandshakeCompletedListener)object.next()).handshakeCompleted(handshakeCompletedEvent);
            }
            catch (Throwable throwable) {}
        }
        if (this.createSessions) {
            object = this.session;
            synchronized (object) {
                this.sessionContext.addSession(this.session.sessionId, this.session);
                this.session.access();
            }
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "Handshake finished in {0}", Thread.currentThread());
        this.handshakeTime = System.currentTimeMillis() - this.handshakeTime;
        logger.log((Level)Component.SSL_HANDSHAKE, "Elapsed time {0}s", new Long(this.handshakeTime / 1000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doClientHandshake() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl;
        Object object7;
        ServerHello serverHello;
        Handshake handshake;
        Object object8;
        DigestOutputStream digestOutputStream;
        DigestInputStream digestInputStream;
        IMessageDigest iMessageDigest;
        IMessageDigest iMessageDigest2;
        block119: {
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            logger.log((Level)Component.SSL_HANDSHAKE, "starting client handshake in {0}", Thread.currentThread());
            iMessageDigest2 = HashFactory.getInstance("md5");
            iMessageDigest = HashFactory.getInstance("sha-160");
            digestInputStream = new DigestInputStream(this.handshakeIn, iMessageDigest2, iMessageDigest);
            digestOutputStream = new DigestOutputStream(this.handshakeOut, iMessageDigest2, iMessageDigest);
            Session session = null;
            byte[] byArray = new byte[]{};
            LinkedList linkedList = null;
            String string = null;
            CertificateType certificateType = CertificateType.X509;
            Object object13 = this.sessionContext.getIds();
            while (object13.hasMoreElements()) {
                object12 = (byte[])object13.nextElement();
                session = (Session)this.sessionContext.getSession((byte[])object12);
                if (session == null || !this.session.enabledProtocols.contains(session.protocol) || !session.getPeerHost().equals(this.remoteHost)) continue;
                byArray = object12;
                break;
            }
            object13 = this.session.enabledSuites.iterator();
            while (object13.hasNext()) {
                object12 = (CipherSuite)object13.next();
                if (object12.getKeyExchange() != "SRP") continue;
                linkedList = new LinkedList();
                string = this.askUserName(this.remoteHost);
                object11 = string.getBytes("UTF-8");
                if (((byte[])object11).length > 255) {
                    this.handshakeFailure();
                    throw new SSLException("SRP username too long");
                }
                linkedList.add(new Extension(Extension.Type.SRP, Util.concat(new byte[]{(byte)((Object)object11).length}, object11)));
                break;
            }
            try {
                int n = Integer.parseInt(Util.getSecurityProperty("jessie.fragment.length"));
                object12 = new byte[1];
                if (n == 512) {
                    object12[0] = 1;
                } else if (n == 1024) {
                    object12[0] = 2;
                } else if (n == 2048) {
                    object12[0] = 3;
                } else {
                    if (n != 4096) {
                        throw new NumberFormatException();
                    }
                    object12[0] = 4;
                }
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add(new Extension(Extension.Type.MAX_FRAGMENT_LENGTH, (byte[])object12));
            }
            catch (NumberFormatException numberFormatException) {}
            object8 = this.session.protocol;
            object12 = new Random(Util.unixTime(), this.session.random.generateSeed(28));
            this.session.protocol = (ProtocolVersion)this.session.enabledProtocols.last();
            object11 = new ArrayList(2);
            object11.add(CompressionMethod.ZLIB);
            object11.add(CompressionMethod.NULL);
            ClientHello clientHello = new ClientHello(this.session.protocol, (Random)object12, byArray, this.session.enabledSuites, (List)object11, linkedList);
            handshake = new Handshake(Handshake.Type.CLIENT_HELLO, clientHello);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, (ProtocolVersion)object8);
            digestOutputStream.flush();
            handshake = Handshake.read(digestInputStream);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            if (handshake.getType() != Handshake.Type.SERVER_HELLO) {
                this.throwUnexpectedMessage();
            }
            serverHello = (ServerHello)handshake.getBody();
            Random random = serverHello.getRandom();
            object8 = serverHello.getVersion();
            if (!this.session.enabledProtocols.contains(object8)) {
                object7 = null;
                object10 = null;
                object9 = this.session.enabledProtocols.iterator();
                while (object9.hasNext()) {
                    object7 = (ProtocolVersion)object9.next();
                    if (((ProtocolVersion)object7).compareTo(object8) > 0) break;
                    object10 = object7;
                }
                object8 = object7;
            }
            if (object8 == null) {
                object7 = null;
                object7 = serverHello.getVersion() == ProtocolVersion.SSL_3 ? Alert.Description.HANDSHAKE_FAILURE : Alert.Description.PROTOCOL_VERSION;
                object10 = new Alert(Alert.Level.FATAL, (Alert.Description)object7);
                this.sendAlert((Alert)object10);
                this.session.currentAlert = object10;
                this.fatal();
                throw new AlertException((Alert)object10, true);
            }
            if (serverHello.getExtensions() != null) {
                object7 = serverHello.getExtensions().iterator();
                while (object7.hasNext()) {
                    object10 = (Extension)object7.next();
                    if (((Extension)object10).getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                        int n = Extensions.getMaxFragmentLength((Extension)object10);
                        this.session.params.setFragmentLength(n);
                        continue;
                    }
                    if (((Extension)object10).getType() != Extension.Type.CERT_TYPE) continue;
                    certificateType = Extensions.getServerCertType((Extension)object10);
                }
            }
            object7 = serverHello.getCipherSuite().resolve((ProtocolVersion)object8);
            bl = true;
            if (byArray.length > 0 && Arrays.equals(byArray, serverHello.getSessionId())) {
                object9 = this.session.params;
                object6 = this.session.random;
                this.session = (Session)session.clone();
                this.session.params = object9;
                this.session.random = object6;
                this.recordInput.setSession(this.session);
                object7 = this.session.cipherSuite;
                bl = false;
            } else {
                this.sessionContext.removeSession(new Session.ID(byArray));
            }
            if (bl) {
                this.session.peerHost = this.remoteHost;
                this.session.sessionId = new Session.ID(serverHello.getSessionId());
                this.session.cipherSuite = object7;
            }
            this.session.params.reset();
            this.session.currentAlert = null;
            this.session.valid = true;
            this.session.protocol = object8;
            if (bl) {
                Serializable serializable;
                Object object14;
                Object object15;
                Object object16;
                Object object17;
                Object object18;
                object9 = null;
                object6 = null;
                object5 = null;
                object4 = null;
                boolean bl2 = false;
                object3 = null;
                IKeyAgreementParty iKeyAgreementParty = null;
                OutgoingMessage outgoingMessage = null;
                if (((CipherSuite)object7).getKeyExchange() == "SRP") {
                    object18 = this.askPassword(string);
                    object17 = ((String)object18).getBytes("UTF-8");
                    iKeyAgreementParty = KeyAgreementFactory.getPartyAInstance("srp-tls");
                    object16 = new HashMap();
                    object16.put("gnu.crypto.srp6.ka.H", "sha-160");
                    object16.put("gnu.crypto.srp6.ka.I", string);
                    object16.put("gnu.crypto.srp6.ka.p", object17);
                    try {
                        iKeyAgreementParty.init((Map)object16);
                        outgoingMessage = iKeyAgreementParty.processMessage(null);
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.throwHandshakeFailure();
                    }
                }
                if (((CipherSuite)object7).getSignature() != "anon") {
                    handshake = Handshake.read(digestInputStream, certificateType);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    if (handshake.getType() != Handshake.Type.CERTIFICATE) {
                        this.throwUnexpectedMessage();
                    }
                    object18 = (Certificate)handshake.getBody();
                    object17 = ((Certificate)object18).getCertificates();
                    try {
                        this.session.trustManager.checkServerTrusted((X509Certificate[])object17, ((CipherSuite)object7).getAuthType());
                        if (((CipherSuite)object7).getSignature() == "RSA" && !(object17[0].getPublicKey() instanceof RSAPublicKey)) {
                            throw new InvalidKeyException("improper public key");
                        }
                        if (((CipherSuite)object7).getKeyExchange() == "DH" && !(object17[0].getPublicKey() instanceof DHPublicKey)) {
                            throw new InvalidKeyException("improper public key");
                        }
                        if (((CipherSuite)object7).getKeyExchange() == "DHE") {
                            if (((CipherSuite)object7).getSignature() == "RSA" && !(object17[0].getPublicKey() instanceof RSAPublicKey)) {
                                throw new InvalidKeyException("improper public key");
                            }
                            if (((CipherSuite)object7).getSignature() == "DSS" && !(object17[0].getPublicKey() instanceof DSAPublicKey)) {
                                throw new InvalidKeyException("improper public key");
                            }
                        }
                        this.session.peerCerts = (java.security.cert.Certificate[])object17;
                        this.session.peerVerified = true;
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        this.throwHandshakeFailure();
                    }
                    catch (Exception exception) {
                        if (!this.checkCertificates((X509Certificate[])object17)) {
                            this.peerUnverified((X509Certificate[])object17);
                            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException("could not verify peer certificate: " + object17[0].getSubjectDN());
                            sSLPeerUnverifiedException.initCause(exception);
                            throw sSLPeerUnverifiedException;
                        }
                        this.session.peerCerts = (java.security.cert.Certificate[])object17;
                        this.session.peerVerified = true;
                    }
                    object6 = object9 = object17[0].getPublicKey();
                }
                if ((handshake = Handshake.read(digestInputStream, (CipherSuite)object7, (PublicKey)object9)).getType() == Handshake.Type.SERVER_KEY_EXCHANGE) {
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    object18 = (ServerKeyExchange)handshake.getBody();
                    object6 = ((ServerKeyExchange)object18).getPublicKey();
                    if (((CipherSuite)object7).getSignature() != "anon") {
                        object17 = null;
                        if (((CipherSuite)object7).getSignature() == "RSA") {
                            object17 = new SSLRSASignature();
                        } else if (((CipherSuite)object7).getSignature() == "DSS") {
                            object17 = SignatureFactory.getInstance("dss");
                        }
                        object17.setupVerify(Collections.singletonMap("gnu.crypto.sig.public.key", object9));
                        object16 = object12.getEncoded();
                        object17.update((byte[])object16, 0, ((Object)object16).length);
                        object16 = random.getEncoded();
                        object17.update((byte[])object16, 0, ((Object)object16).length);
                        if (((CipherSuite)object7).getKeyExchange() == "RSA") {
                            this.updateSig((ISignature)object17, ((RSAPublicKey)object6).getModulus());
                            this.updateSig((ISignature)object17, ((RSAPublicKey)object6).getPublicExponent());
                        } else if (((CipherSuite)object7).getKeyExchange() == "DHE") {
                            this.updateSig((ISignature)object17, ((DHPublicKey)object6).getParams().getP());
                            this.updateSig((ISignature)object17, ((DHPublicKey)object6).getParams().getG());
                            this.updateSig((ISignature)object17, ((DHPublicKey)object6).getY());
                        } else if (((CipherSuite)object7).getKeyExchange() == "SRP") {
                            this.updateSig((ISignature)object17, ((SRPPublicKey)object6).getN());
                            this.updateSig((ISignature)object17, ((SRPPublicKey)object6).getG());
                            object15 = ((ServerKeyExchange)object18).getSRPSalt();
                            object17.update((byte)((byte[])object15).length);
                            object17.update((byte[])object15, 0, ((Object)object15).length);
                            this.updateSig((ISignature)object17, ((SRPPublicKey)object6).getY());
                        }
                        if (!object17.verify(((ServerKeyExchange)object18).getSignature().getSigValue())) {
                            this.throwHandshakeFailure();
                        }
                    }
                    if (((CipherSuite)object7).getKeyExchange() == "SRP") {
                        try {
                            outgoingMessage = new OutgoingMessage();
                            outgoingMessage.writeMPI(((SRPPublicKey)object6).getN());
                            outgoingMessage.writeMPI(((SRPPublicKey)object6).getG());
                            outgoingMessage.writeMPI(new BigInteger(1, ((ServerKeyExchange)object18).getSRPSalt()));
                            outgoingMessage.writeMPI(((SRPPublicKey)object6).getY());
                            object2 = new IncomingMessage(outgoingMessage.toByteArray());
                            outgoingMessage = iKeyAgreementParty.processMessage((IncomingMessage)object2);
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.throwHandshakeFailure();
                        }
                    }
                    handshake = Handshake.read(digestInputStream, (CipherSuite)object7, (PublicKey)object9);
                }
                object = null;
                if (handshake.getType() == Handshake.Type.CERTIFICATE_REQUEST) {
                    if (((CipherSuite)object7).getSignature() == "anon") {
                        this.throwHandshakeFailure();
                    }
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    object = (CertificateRequest)handshake.getBody();
                    handshake = Handshake.read(digestInputStream);
                }
                if (handshake.getType() != Handshake.Type.SERVER_HELLO_DONE) {
                    this.throwUnexpectedMessage();
                }
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                if (object != null) {
                    object18 = this.session.keyManager.chooseClientAlias(((CertificateRequest)object).getTypeStrings(), ((CertificateRequest)object).getAuthorities(), null);
                    if (object18 == null && object8 == ProtocolVersion.SSL_3) {
                        object17 = new Alert(Alert.Level.WARNING, Alert.Description.NO_CERTIFICATE);
                        this.sendAlert((Alert)object17);
                    } else {
                        object17 = this.session.keyManager.getCertificateChain((String)object18);
                        object16 = this.session.keyManager.getPrivateKey((String)object18);
                        if (object17 == null) {
                            object17 = new X509Certificate[0];
                        }
                        object15 = new Certificate((X509Certificate[])object17);
                        handshake = new Handshake(Handshake.Type.CERTIFICATE, (Handshake.Body)object15);
                        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                        handshake.write(digestOutputStream, (ProtocolVersion)object8);
                        digestOutputStream.flush();
                        if (((Object)object17).length > 0) {
                            this.session.localCerts = object17;
                            object5 = new KeyPair(((java.security.cert.Certificate)object17[0]).getPublicKey(), (PrivateKey)object16);
                        }
                    }
                }
                object18 = null;
                object17 = null;
                if (((CipherSuite)object7).getKeyExchange() == "RSA") {
                    object16 = (ProtocolVersion)this.session.enabledProtocols.last();
                    object15 = new byte[46];
                    this.session.random.nextBytes((byte[])object15);
                    object18 = Util.concat(((ProtocolVersion)object16).getEncoded(), (byte[])object15);
                    object14 = EME_PKCS1_V1_5.getInstance((RSAPublicKey)object6);
                    serializable = new BigInteger(1, ((EME_PKCS1_V1_5)object14).encode((byte[])object18, this.session.random));
                    serializable = RSA.encrypt((RSAPublicKey)object6, serializable);
                    object17 = new ClientKeyExchange(Util.trim(serializable));
                } else if (((CipherSuite)object7).getKeyExchange().startsWith("DH")) {
                    if (object5 == null || !(((KeyPair)object5).getPublic() instanceof DHPublicKey)) {
                        object16 = new GnuDHPrivateKey(null, ((DHPublicKey)object6).getParams().getP(), ((DHPublicKey)object6).getParams().getG(), null);
                        iKeyAgreementParty = KeyAgreementFactory.getPartyBInstance("dh");
                        object15 = new HashMap();
                        object15.put("gnu.crypto.dh.ka.owner.private.key", object16);
                        object15.put("gnu.crypto.dh.ka.prng", this.session.random);
                        try {
                            iKeyAgreementParty.init((Map)object15);
                            outgoingMessage = new OutgoingMessage();
                            outgoingMessage.writeMPI(((DHPublicKey)object6).getY());
                            object2 = new IncomingMessage(outgoingMessage.toByteArray());
                            outgoingMessage = iKeyAgreementParty.processMessage((IncomingMessage)object2);
                            object2 = new IncomingMessage(outgoingMessage.toByteArray());
                            object17 = new ClientKeyExchange(((IncomingMessage)object2).readMPI());
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.internalError();
                            RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                            runtimeException.initCause(keyAgreementException);
                            throw runtimeException;
                        }
                    }
                    iKeyAgreementParty = KeyAgreementFactory.getPartyBInstance("elgamal");
                    object16 = new HashMap();
                    object16.put("gnu.crypto.elgamal.ka.recipient.private.key", ((KeyPair)object5).getPrivate());
                    try {
                        iKeyAgreementParty.init((Map)object16);
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                        runtimeException.initCause(keyAgreementException);
                        throw runtimeException;
                    }
                    object17 = new ClientKeyExchange(new byte[0]);
                } else if (((CipherSuite)object7).getKeyExchange() == "SRP") {
                    object16 = null;
                    try {
                        object2 = new IncomingMessage(outgoingMessage.toByteArray());
                        object16 = ((IncomingMessage)object2).readMPI();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.throwHandshakeFailure();
                    }
                    object17 = new ClientKeyExchange((BigInteger)object16);
                }
                handshake = new Handshake(Handshake.Type.CLIENT_KEY_EXCHANGE, (Handshake.Body)object17);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, (ProtocolVersion)object8);
                if (((CipherSuite)object7).getKeyExchange().startsWith("DH")) {
                    try {
                        object18 = iKeyAgreementParty.getSharedSecret();
                    }
                    catch (KeyAgreementException keyAgreementException) {
                        this.internalError();
                        object15 = new RuntimeException(keyAgreementException.getMessage());
                        ((Throwable)object15).initCause(keyAgreementException);
                        throw object15;
                    }
                }
                if (((CipherSuite)object7).getKeyExchange() == "SRP") {
                    try {
                        try {
                            object18 = iKeyAgreementParty.getSharedSecret();
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.throwHandshakeFailure();
                        }
                        object15 = null;
                        iKeyAgreementParty = null;
                    }
                    catch (Throwable throwable) {
                        object15 = null;
                        iKeyAgreementParty = null;
                        throw throwable;
                    }
                }
                object16 = null;
                if (object8 == ProtocolVersion.SSL_3) {
                    object16 = new SSLRandom();
                    object15 = new HashMap();
                    ((HashMap)object15).put("jessie.sslprng.secret", object18);
                    ((HashMap)object15).put("jessie.sslprng.seed", Util.concat(object12.getEncoded(), random.getEncoded()));
                    object16.init((Map)object15);
                } else {
                    object16 = new TLSRandom();
                    object15 = new HashMap();
                    ((HashMap)object15).put("jessie.tls.prng.secret", object18);
                    ((HashMap)object15).put("jessie.tls.prng.seed", Util.concat("master secret".getBytes("UTF-8"), Util.concat(object12.getEncoded(), random.getEncoded())));
                    object16.init((Map)object15);
                }
                this.session.masterSecret = new byte[48];
                try {
                    object16.nextBytes(this.session.masterSecret, 0, 48);
                    int n = 0;
                    while (n < ((Object)object18).length) {
                        object18[n] = false;
                        ++n;
                    }
                }
                catch (LimitReachedException limitReachedException) {
                    this.internalError();
                    object14 = new RuntimeException(limitReachedException.getMessage());
                    ((Throwable)object14).initCause(limitReachedException);
                    throw object14;
                }
                if (object != null && object5 != null) {
                    Object object19;
                    IMessageDigest iMessageDigest3 = (IMessageDigest)iMessageDigest2.clone();
                    object14 = (IMessageDigest)iMessageDigest.clone();
                    serializable = ((KeyPair)object5).getPrivate();
                    Object object20 = null;
                    String string2 = null;
                    try {
                        if (serializable instanceof DSAPrivateKey) {
                            object20 = DSSSignature.sign((DSAPrivateKey)serializable, object14.digest(), this.session.random);
                            string2 = "DSS";
                        } else {
                            if (!(serializable instanceof RSAPrivateKey)) {
                                throw new InvalidKeyException("no appropriate key");
                            }
                            object19 = new SSLRSASignature(iMessageDigest3, (IMessageDigest)object14);
                            ((SSLRSASignature)object19).setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", serializable));
                            object20 = ((SSLRSASignature)object19).sign();
                            string2 = "RSA";
                        }
                    }
                    catch (Exception exception) {
                        this.throwHandshakeFailure();
                    }
                    object19 = new CertificateVerify(object20, string2);
                    handshake = new Handshake(Handshake.Type.CERTIFICATE_VERIFY, (Handshake.Body)object19);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    handshake.write(digestOutputStream, (ProtocolVersion)object8);
                }
                digestOutputStream.flush();
            }
            object9 = null;
            try {
                object9 = this.generateKeys(random.getEncoded(), object12.getEncoded(), (ProtocolVersion)object8);
            }
            catch (Exception exception) {
                this.internalError();
                object5 = new RuntimeException(exception.getMessage());
                ((Throwable)object5).initCause(exception);
                throw object5;
            }
            this.session.params.setVersion((ProtocolVersion)object8);
            object6 = null;
            object5 = null;
            object4 = null;
            object = null;
            try {
                if (this.session.params instanceof GNUSecurityParameters) {
                    HashMap hashMap = new HashMap();
                    object5 = CipherSuite.getMac(((CipherSuite)object7).getMac());
                    object6 = CipherSuite.getMac(((CipherSuite)object7).getMac());
                    hashMap.put("gnu.crypto.mac.key.material", object9[0]);
                    ((IMac)object5).init(hashMap);
                    hashMap.put("gnu.crypto.mac.key.material", object9[1]);
                    ((IMac)object6).init(hashMap);
                    if (((CipherSuite)object7).getCipher() == "RC4") {
                        object = new ARCFour();
                        object4 = new ARCFour();
                        hashMap.clear();
                        hashMap.put("gnu.crypto.prng.arcfour.key-material", object9[2]);
                        ((ARCFour)object).init(hashMap);
                        hashMap.put("gnu.crypto.prng.arcfour.key-material", object9[3]);
                        ((ARCFour)object4).init(hashMap);
                        break block119;
                    }
                    if (!((CipherSuite)object7).isStreamCipher()) {
                        object = CipherSuite.getCipher(((CipherSuite)object7).getCipher());
                        object4 = CipherSuite.getCipher(((CipherSuite)object7).getCipher());
                        hashMap.clear();
                        hashMap.put("gnu.crypto.cipher.key.material", object9[2]);
                        hashMap.put("gnu.crypto.mode.iv", object9[4]);
                        hashMap.put("gnu.crypto.mode.state", new Integer(1));
                        ((IMode)object).init(hashMap);
                        hashMap.put("gnu.crypto.cipher.key.material", object9[3]);
                        hashMap.put("gnu.crypto.mode.iv", object9[5]);
                        hashMap.put("gnu.crypto.mode.state", new Integer(2));
                        ((IMode)object4).init(hashMap);
                    }
                    break block119;
                }
                object5 = CipherSuite.getJCEMac(((CipherSuite)object7).getMac());
                object6 = CipherSuite.getJCEMac(((CipherSuite)object7).getMac());
                object = CipherSuite.getJCECipher(((CipherSuite)object7).getCipher());
                object4 = CipherSuite.getJCECipher(((CipherSuite)object7).getCipher());
                ((Mac)object5).init(new SecretKeySpec((byte[])object9[0], ((CipherSuite)object7).getMac()));
                ((Mac)object6).init(new SecretKeySpec((byte[])object9[1], ((CipherSuite)object7).getMac()));
                if (!((CipherSuite)object7).isStreamCipher()) {
                    ((Cipher)object).init(1, (Key)new SecretKeySpec((byte[])object9[2], ((CipherSuite)object7).getCipher()), new IvParameterSpec((byte[])object9[4]));
                    ((Cipher)object4).init(2, (Key)new SecretKeySpec((byte[])object9[3], ((CipherSuite)object7).getCipher()), new IvParameterSpec((byte[])object9[5]));
                } else {
                    ((Cipher)object).init(1, new SecretKeySpec((byte[])object9[2], ((CipherSuite)object7).getCipher()));
                    ((Cipher)object4).init(2, new SecretKeySpec((byte[])object9[3], ((CipherSuite)object7).getCipher()));
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                this.internalError();
                object3 = new RuntimeException(invalidKeyException.getMessage());
                ((Throwable)object3).initCause(invalidKeyException);
                throw object3;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.internalError();
                object3 = new RuntimeException(invalidAlgorithmParameterException.getMessage());
                ((Throwable)object3).initCause(invalidAlgorithmParameterException);
                throw object3;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.session.enabledSuites.remove(object7);
                this.internalError();
                object3 = new SSLException("suite " + object7 + " not available in this configuration");
                ((Throwable)object3).initCause(noSuchAlgorithmException);
                throw object3;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                this.session.enabledSuites.remove(object7);
                this.internalError();
                object3 = new SSLException("suite " + object7 + " not available in this configuration");
                ((Throwable)object3).initCause(noSuchPaddingException);
                throw object3;
            }
        }
        Finished finished = null;
        if (bl) {
            this.changeCipherSpec();
            SecurityParameters securityParameters = this.session.params;
            boolean bl3 = false;
            if (serverHello.getCompressionMethod() == CompressionMethod.ZLIB) {
                bl3 = true;
            }
            securityParameters.setDeflating(bl3);
            this.session.params.setOutMac(object5);
            this.session.params.setOutCipher(object);
            finished = this.generateFinished((ProtocolVersion)object8, (IMessageDigest)iMessageDigest2.clone(), (IMessageDigest)iMessageDigest.clone(), true);
            handshake = new Handshake(Handshake.Type.FINISHED, finished);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, (ProtocolVersion)object8);
            digestOutputStream.flush();
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        object3 = this.session.params;
        synchronized (object3) {
            this.readChangeCipherSpec();
            SecurityParameters securityParameters = this.session.params;
            boolean bl4 = false;
            if (serverHello.getCompressionMethod() == CompressionMethod.ZLIB) {
                bl4 = true;
            }
            securityParameters.setInflating(bl4);
            this.session.params.setInMac(object6);
            this.session.params.setInCipher(object4);
            this.session.params.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[16, 15] lbl550 : MonitorExitStatement: MONITOREXIT : var25_35
            object2 = this.generateFinished((ProtocolVersion)object8, (IMessageDigest)iMessageDigest2.clone(), (IMessageDigest)iMessageDigest.clone(), false);
        }
        handshake = Handshake.read(digestInputStream, (CipherSuite)object7, null);
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        if (handshake.getType() != Handshake.Type.FINISHED) {
            this.throwUnexpectedMessage();
        }
        finished = (Finished)handshake.getBody();
        if (object8 == ProtocolVersion.SSL_3) {
            if (!Arrays.equals(finished.getMD5Hash(), ((Finished)object2).getMD5Hash()) || !Arrays.equals(finished.getSHAHash(), ((Finished)object2).getSHAHash())) {
                this.throwHandshakeFailure();
            }
        } else if (!Arrays.equals(finished.getVerifyData(), ((Finished)object2).getVerifyData())) {
            this.throwHandshakeFailure();
        }
        if (!bl) {
            this.changeCipherSpec();
            SecurityParameters securityParameters = this.session.params;
            boolean bl5 = false;
            if (serverHello.getCompressionMethod() == CompressionMethod.ZLIB) {
                bl5 = true;
            }
            securityParameters.setDeflating(bl5);
            this.session.params.setOutMac(object5);
            this.session.params.setOutCipher(object);
            finished = this.generateFinished((ProtocolVersion)object8, iMessageDigest2, iMessageDigest, true);
            handshake = new Handshake(Handshake.Type.FINISHED, finished);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, (ProtocolVersion)object8);
            digestOutputStream.flush();
        }
        this.handshakeCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doServerHandshake() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        Object object6;
        CompressionMethod compressionMethod;
        ProtocolVersion protocolVersion;
        Handshake handshake;
        DigestOutputStream digestOutputStream;
        DigestInputStream digestInputStream;
        IMessageDigest iMessageDigest;
        IMessageDigest iMessageDigest2;
        block111: {
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            logger.log((Level)Component.SSL_HANDSHAKE, "doing server handshake in {0}", Thread.currentThread());
            if (this.remoteHost == null) {
                this.remoteHost = this.getInetAddress().getHostName();
            }
            if (this.remoteHost == null) {
                this.remoteHost = this.getInetAddress().getHostAddress();
            }
            iMessageDigest2 = HashFactory.getInstance("md5");
            iMessageDigest = HashFactory.getInstance("sha-160");
            digestInputStream = new DigestInputStream(this.handshakeIn, iMessageDigest2, iMessageDigest);
            digestOutputStream = new DigestOutputStream(this.handshakeOut, iMessageDigest2, iMessageDigest);
            handshake = Handshake.read(digestInputStream);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            if (handshake.getType() != Handshake.Type.CLIENT_HELLO) {
                this.throwUnexpectedMessage();
            }
            ClientHello clientHello = (ClientHello)handshake.getBody();
            Random random = clientHello.getRandom();
            protocolVersion = clientHello.getVersion();
            ProtocolVersion protocolVersion2 = (ProtocolVersion)this.session.enabledProtocols.last();
            compressionMethod = clientHello.getCompressionMethods().contains(CompressionMethod.ZLIB) ? CompressionMethod.ZLIB : CompressionMethod.NULL;
            if (!this.session.enabledProtocols.contains(protocolVersion) && protocolVersion.compareTo(protocolVersion2) < 0) {
                Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.PROTOCOL_VERSION);
                this.sendAlert(alert);
                this.session.currentAlert = alert;
                throw new AlertException(alert, true);
            }
            List list2 = null;
            String string = null;
            if (clientHello.getExtensions() != null) {
                object6 = clientHello.getExtensions().iterator();
                while (object6.hasNext()) {
                    object10 = (Extension)object6.next();
                    if (((Extension)object10).getType() == Extension.Type.SERVER_NAME) {
                        if (list2 == null) {
                            list2 = new LinkedList();
                        }
                        list2.add(object10);
                        continue;
                    }
                    if (((Extension)object10).getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                        int n = Extensions.getMaxFragmentLength((Extension)object10);
                        this.session.params.setFragmentLength(n);
                        if (list2 == null) {
                            list2 = new LinkedList();
                        }
                        list2.add(object10);
                        continue;
                    }
                    if (((Extension)object10).getType() != Extension.Type.SRP) continue;
                    if (list2 == null) {
                        list2 = new LinkedList();
                    }
                    byte[] byArray = ((Extension)object10).getValue();
                    string = new String(((Extension)object10).getValue(), 1, byArray[0] & 0xFF, "UTF-8");
                    this.session.putValue("srp-username", string);
                }
            }
            if ((object6 = this.selectSuite(clientHello.getCipherSuites(), protocolVersion)) == null) {
                return;
            }
            object10 = null;
            OutgoingMessage outgoingMessage = null;
            if (((CipherSuite)object6).getKeyExchange() == "SRP") {
                if (string == null) {
                    Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.MISSING_SRP_USERNAME);
                    this.sendAlert(alert);
                    throw new AlertException(alert, true);
                }
                SRPAuthInfoProvider sRPAuthInfoProvider = new SRPAuthInfoProvider();
                object9 = new HashMap();
                object9.put("gnu.crypto.sasl.srp.password.db", this.session.srpTrustManager.getPasswordFile());
                sRPAuthInfoProvider.activate((Map)object9);
                if (!sRPAuthInfoProvider.contains(string)) {
                    Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.UNKNOWN_SRP_USERNAME);
                    this.sendAlert(alert);
                    throw new AlertException(alert, true);
                }
                object10 = KeyAgreementFactory.getPartyBInstance("srp-tls");
                object8 = new HashMap();
                object8.put("gnu.crypto.srp6.ka.H", "sha-160");
                object8.put("gnu.crypto.srp6.ka.password.db", sRPAuthInfoProvider);
                try {
                    object10.init((Map)object8);
                    outgoingMessage = new OutgoingMessage();
                    outgoingMessage.writeString(string);
                    IncomingMessage incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                    outgoingMessage = object10.processMessage(incomingMessage);
                }
                catch (KeyAgreementException keyAgreementException) {
                    this.throwHandshakeFailure();
                }
            }
            bl = true;
            logger.log((Level)Component.SSL_HANDSHAKE, "saved sessions: {0}", this.sessionContext);
            if (this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId()))) {
                object9 = this.session;
                this.session = (Session)this.sessionContext.getSession(clientHello.getSessionId());
                if (!clientHello.getCipherSuites().contains(this.session.cipherSuite)) {
                    this.throwHandshakeFailure();
                }
                if (this.session.getPeerHost().equals(this.remoteHost) && ((Session)object9).enabledProtocols.contains(this.session.protocol)) {
                    this.session = (Session)this.session.clone();
                    object6 = this.session.cipherSuite;
                    bl = false;
                    this.recordInput.setSession(this.session);
                    this.session.currentAlert = null;
                    this.session.params = ((Session)object9).params;
                    this.session.random = ((Session)object9).random;
                } else {
                    logger.log((Level)Component.SSL_HANDSHAKE, "rejected section; hosts equal? {0}, same suites? {1}", new Object[]{this.session.getPeerHost().equals(this.remoteHost), ((Session)object9).enabledProtocols.contains(this.session.protocol)});
                    this.session = object9;
                    this.session.peerHost = this.remoteHost;
                    bl = true;
                }
            } else {
                logger.log((Level)Component.SSL_HANDSHAKE, "rejected session; have session id? {0}, saved sessions: {1}", new Object[]{this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId())), this.sessionContext});
            }
            if (bl) {
                object9 = new byte[32];
                object8 = null;
                do {
                    this.session.random.nextBytes((byte[])object9);
                } while (this.sessionContext.containsSessionID((Session.ID)(object8 = new Session.ID((byte[])object9))));
                this.session.sessionId = object8;
            }
            this.session.valid = true;
            this.session.peerHost = this.remoteHost;
            this.session.cipherSuite = object6;
            this.session.protocol = protocolVersion;
            this.session.params.setVersion(protocolVersion);
            object9 = new Random(Util.unixTime(), this.session.random.generateSeed(28));
            object8 = new ServerHello(protocolVersion, (Random)object9, this.session.getId(), (CipherSuite)object6, compressionMethod, list2);
            handshake = new Handshake(Handshake.Type.SERVER_HELLO, (Handshake.Body)object8);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
            if (bl) {
                Object object11;
                Object object12;
                Object object13;
                Object object14;
                Object object15;
                Constructed constructed;
                X509Certificate[] x509CertificateArray;
                Object object16;
                Serializable serializable;
                object7 = null;
                object5 = null;
                if (((CipherSuite)object6).getSignature() != "anon") {
                    object4 = this.session.keyManager.chooseServerAlias(((CipherSuite)object6).getAuthType(), null, null);
                    object7 = this.session.keyManager.getCertificateChain((String)object4);
                    object5 = this.session.keyManager.getPrivateKey((String)object4);
                    if (object7 == null || object5 == null) {
                        this.throwHandshakeFailure();
                    }
                    this.session.localCerts = (java.security.cert.Certificate[])object7;
                    object3 = new Certificate((X509Certificate[])object7);
                    handshake = new Handshake(Handshake.Type.CERTIFICATE, (Handshake.Body)object3);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    handshake.write(digestOutputStream, protocolVersion);
                    digestOutputStream.flush();
                }
                object4 = null;
                if (object7 != null) {
                    object4 = new KeyPair(object7[0].getPublicKey(), (PrivateKey)object5);
                }
                object3 = object4;
                object2 = null;
                if (((CipherSuite)object6).getKeyExchange() == "RSA" && ((CipherSuite)object6).isExportable() && ((RSAPrivateKey)object5).getModulus().bitLength() > 512) {
                    object3 = KeyPool.generateRSAKeyPair();
                    serializable = (RSAPublicKey)((KeyPair)object3).getPublic();
                    object16 = null;
                    if (((CipherSuite)object6).getSignature() != "anon") {
                        x509CertificateArray = new SSLRSASignature();
                        x509CertificateArray.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object4).getPrivate()));
                        object = random.getEncoded();
                        x509CertificateArray.update((byte[])object, 0, ((byte[])object).length);
                        object = ((Random)object9).getEncoded();
                        x509CertificateArray.update((byte[])object, 0, ((byte[])object).length);
                        this.updateSig((ISignature)x509CertificateArray, serializable.getModulus());
                        this.updateSig((ISignature)x509CertificateArray, serializable.getPublicExponent());
                        object16 = new Signature(x509CertificateArray.sign(), "RSA");
                    }
                    object2 = new ServerKeyExchange((PublicKey)serializable, (Signature)object16);
                } else {
                    if (((CipherSuite)object6).getKeyExchange() == "DH") {
                        object10 = KeyAgreementFactory.getPartyBInstance("elgamal");
                        serializable = new HashMap();
                        serializable.put("gnu.crypto.elgamal.ka.recipient.private.key", object5);
                        try {
                            object10.init((Map)((Object)serializable));
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.internalError();
                            RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                            runtimeException.initCause(keyAgreementException);
                            throw runtimeException;
                        }
                    }
                    if (((CipherSuite)object6).getKeyExchange() == "DHE") {
                        object10 = KeyAgreementFactory.getPartyAInstance("dh");
                        serializable = new HashMap();
                        object16 = DiffieHellman.getParams();
                        serializable.put("gnu.crypto.dh.ka.owner.private.key", object16);
                        serializable.put("gnu.crypto.dh.ka.prng", this.session.random);
                        x509CertificateArray = null;
                        try {
                            object10.init((Map)((Object)serializable));
                            outgoingMessage = object10.processMessage(null);
                            IncomingMessage incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                            x509CertificateArray = incomingMessage.readMPI();
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.internalError();
                            RuntimeException runtimeException = new RuntimeException(keyAgreementException.getMessage());
                            runtimeException.initCause(keyAgreementException);
                            throw runtimeException;
                        }
                        object = new GnuDHPublicKey(null, object16.getParams().getP(), object16.getParams().getG(), (BigInteger)x509CertificateArray);
                        constructed = null;
                        if (((CipherSuite)object6).getSignature() != "anon") {
                            object15 = null;
                            object15 = ((CipherSuite)object6).getSignature() == "RSA" ? (Object)new SSLRSASignature() : (Object)SignatureFactory.getInstance("dss");
                            object15.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object4).getPrivate()));
                            object14 = random.getEncoded();
                            object15.update((byte[])object14, 0, ((Object)object14).length);
                            object14 = ((Random)object9).getEncoded();
                            object15.update((byte[])object14, 0, ((Object)object14).length);
                            this.updateSig((ISignature)object15, ((GnuDHKey)object).getParams().getP());
                            this.updateSig((ISignature)object15, ((GnuDHKey)object).getParams().getG());
                            this.updateSig((ISignature)object15, ((GnuDHPublicKey)object).getY());
                            constructed = new Signature(object15.sign(), ((CipherSuite)object6).getSignature());
                        }
                        object2 = new ServerKeyExchange((PublicKey)object, (Signature)constructed);
                    } else if (((CipherSuite)object6).getKeyExchange() == "SRP") {
                        serializable = null;
                        object16 = null;
                        x509CertificateArray = null;
                        object = null;
                        try {
                            IncomingMessage incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                            serializable = incomingMessage.readMPI();
                            object16 = incomingMessage.readMPI();
                            x509CertificateArray = incomingMessage.readMPI();
                            object = incomingMessage.readMPI();
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.throwHandshakeFailure();
                        }
                        constructed = null;
                        object15 = Util.trim((BigInteger)x509CertificateArray);
                        if (((CipherSuite)object6).getSignature() != "anon") {
                            object14 = null;
                            object14 = ((CipherSuite)object6).getSignature() == "RSA" ? new SSLRSASignature() : SignatureFactory.getInstance("dss");
                            object14.setupSign(Collections.singletonMap("gnu.crypto.sig.private.key", ((KeyPair)object4).getPrivate()));
                            object13 = random.getEncoded();
                            object14.update((byte[])object13, 0, ((byte[])object13).length);
                            object13 = ((Random)object9).getEncoded();
                            object14.update((byte[])object13, 0, ((byte[])object13).length);
                            this.updateSig((ISignature)object14, (BigInteger)serializable);
                            this.updateSig((ISignature)object14, (BigInteger)object16);
                            object14.update((byte)((byte[])object15).length);
                            object14.update((byte[])object15, 0, ((Object)object15).length);
                            this.updateSig((ISignature)object14, (BigInteger)object);
                            constructed = new Signature(object14.sign(), ((CipherSuite)object6).getSignature());
                        }
                        object14 = new SRPPublicKey((BigInteger)serializable, (BigInteger)object16, (BigInteger)object);
                        object2 = new ServerKeyExchange((PublicKey)object14, (Signature)constructed, (byte[])object15);
                    }
                }
                if (object2 != null) {
                    handshake = new Handshake(Handshake.Type.SERVER_KEY_EXCHANGE, (Handshake.Body)object2);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    handshake.write(digestOutputStream, protocolVersion);
                    digestOutputStream.flush();
                }
                if (this.wantClientAuth || this.needClientAuth) {
                    serializable = null;
                    object16 = new CertificateRequest.ClientType[]{CertificateRequest.ClientType.RSA_SIGN, CertificateRequest.ClientType.DSS_SIGN, CertificateRequest.ClientType.RSA_FIXED_DH, CertificateRequest.ClientType.DSS_FIXED_DH};
                    try {
                        Object[] objectArray = this.session.trustManager.getAcceptedIssuers();
                        Class clazz = class$java$security$Principal;
                        if (clazz == null) {
                            clazz = class$java$security$Principal = SSLSocket.class("[Ljava.security.Principal;", false);
                        }
                        serializable = (Principal[])Util.transform(objectArray, clazz, "getSubjectDN", null);
                    }
                    catch (Exception exception) {
                        this.internalError();
                        object = new RuntimeException(exception.getMessage());
                        ((Throwable)object).initCause(exception);
                        throw object;
                    }
                    x509CertificateArray = new CertificateRequest((CertificateRequest.ClientType[])object16, (Principal[])serializable);
                    handshake = new Handshake(Handshake.Type.CERTIFICATE_REQUEST, (Handshake.Body)x509CertificateArray);
                    handshake.write(digestOutputStream, protocolVersion);
                    digestOutputStream.flush();
                }
                handshake = new Handshake(Handshake.Type.SERVER_HELLO_DONE, null);
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                handshake.write(digestOutputStream, protocolVersion);
                digestOutputStream.flush();
                handshake = ((CipherSuite)object6).getKeyExchange() == "RSA" ? Handshake.read(digestInputStream, (CipherSuite)object6, ((KeyPair)object3).getPublic()) : Handshake.read(digestInputStream, (CipherSuite)object6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                x509CertificateArray = null;
                object = null;
                if (handshake.getType() == Handshake.Type.CERTIFICATE) {
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    constructed = (Certificate)handshake.getBody();
                    x509CertificateArray = constructed.getCertificates();
                    try {
                        this.session.trustManager.checkClientTrusted(x509CertificateArray, ((CipherSuite)object6).getAuthType());
                        this.session.peerCerts = x509CertificateArray;
                        this.session.peerVerified = true;
                        object = x509CertificateArray[0].getPublicKey();
                    }
                    catch (Exception exception) {}
                    boolean bl4 = false;
                    if (object instanceof DSAPublicKey || object instanceof RSAPublicKey) {
                        bl4 = true;
                    }
                    bl3 = bl4;
                    handshake = ((CipherSuite)object6).getKeyExchange().startsWith("DH") ? Handshake.read(digestInputStream, (CipherSuite)object6, (PublicKey)object) : Handshake.read(digestInputStream, (CipherSuite)object6, ((KeyPair)object3).getPublic());
                }
                if (!this.session.peerVerified && this.needClientAuth) {
                    this.throwHandshakeFailure();
                }
                if (handshake.getType() != Handshake.Type.CLIENT_KEY_EXCHANGE) {
                    this.throwUnexpectedMessage();
                }
                logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                constructed = (ClientKeyExchange)handshake.getBody();
                object15 = null;
                if (((CipherSuite)object6).getKeyExchange() == "RSA") {
                    object14 = (byte[])((ClientKeyExchange)constructed).getExchangeObject();
                    object13 = new BigInteger(1, (byte[])object14);
                    try {
                        object13 = RSA.decrypt(((KeyPair)object3).getPrivate(), (BigInteger)object13);
                        object12 = EME_PKCS1_V1_5.getInstance((RSAPrivateKey)((KeyPair)object3).getPrivate());
                        object15 = ((EME_PKCS1_V1_5)object12).decode(Util.concat(new byte[1], ((BigInteger)object13).toByteArray()));
                    }
                    catch (Exception exception) {
                        object11 = new byte[46];
                        this.session.random.nextBytes((byte[])object11);
                        object15 = Util.concat(protocolVersion.getEncoded(), (byte[])object11);
                    }
                } else {
                    if (((CipherSuite)object6).getKeyExchange().startsWith("DH")) {
                        try {
                            outgoingMessage = new OutgoingMessage();
                            if (object == null) {
                                outgoingMessage.writeMPI((BigInteger)((ClientKeyExchange)constructed).getExchangeObject());
                            } else {
                                outgoingMessage.writeMPI(((DHPublicKey)object).getY());
                            }
                            IncomingMessage incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                            object10.processMessage(incomingMessage);
                            object15 = object10.getSharedSecret();
                        }
                        catch (KeyAgreementException keyAgreementException) {
                            this.internalError();
                            object13 = new RuntimeException(keyAgreementException.getMessage());
                            ((Throwable)object13).initCause(keyAgreementException);
                            throw object13;
                        }
                    }
                    if (((CipherSuite)object6).getKeyExchange() == "SRP") {
                        object14 = (BigInteger)((ClientKeyExchange)constructed).getExchangeObject();
                        try {
                            try {
                                outgoingMessage = new OutgoingMessage();
                                outgoingMessage.writeMPI((BigInteger)object14);
                                IncomingMessage incomingMessage = new IncomingMessage(outgoingMessage.toByteArray());
                                outgoingMessage = object10.processMessage(incomingMessage);
                                object15 = object10.getSharedSecret();
                            }
                            catch (KeyAgreementException keyAgreementException) {
                                this.throwHandshakeFailure();
                            }
                            object12 = null;
                            object10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var33_71 = null;
                            object10 = null;
                            throw throwable;
                        }
                    }
                }
                object14 = null;
                if (protocolVersion == ProtocolVersion.SSL_3) {
                    object14 = new SSLRandom();
                    object13 = new HashMap();
                    ((HashMap)object13).put("jessie.sslprng.secret", object15);
                    ((HashMap)object13).put("jessie.sslprng.seed", Util.concat(random.getEncoded(), ((Random)object9).getEncoded()));
                    object14.init((Map)object13);
                } else {
                    object14 = new TLSRandom();
                    object13 = new HashMap();
                    ((HashMap)object13).put("jessie.tls.prng.secret", object15);
                    ((HashMap)object13).put("jessie.tls.prng.seed", Util.concat("master secret".getBytes("UTF-8"), Util.concat(random.getEncoded(), ((Random)object9).getEncoded())));
                    object14.init((Map)object13);
                }
                this.session.masterSecret = new byte[48];
                try {
                    object14.nextBytes(this.session.masterSecret, 0, 48);
                    int n = 0;
                    while (n < ((Object)object15).length) {
                        object15[n] = false;
                        ++n;
                    }
                }
                catch (LimitReachedException limitReachedException) {
                    this.internalError();
                    object12 = new RuntimeException();
                    ((Throwable)object12).initCause(limitReachedException);
                    throw object12;
                }
                if (bl3 && (this.wantClientAuth || this.needClientAuth)) {
                    handshake = Handshake.read(digestInputStream);
                    if (handshake.getType() != Handshake.Type.CERTIFICATE_VERIFY) {
                        this.throwUnexpectedMessage();
                    }
                    CertificateVerify certificateVerify = (CertificateVerify)handshake.getBody();
                    if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                        object12 = (IMessageDigest)iMessageDigest2.clone();
                        object11 = (IMessageDigest)iMessageDigest.clone();
                        object = x509CertificateArray[0].getPublicKey();
                        if (object instanceof RSAPublicKey) {
                            SSLRSASignature sSLRSASignature = new SSLRSASignature((IMessageDigest)object12, (IMessageDigest)object11);
                            sSLRSASignature.setupVerify(Collections.singletonMap("gnu.crypto.sig.public.key", object));
                            if (!sSLRSASignature.verify(certificateVerify.getSigValue())) {
                                this.handshakeFailure();
                                throw new SSLHandshakeException("client certificate verify failed");
                            }
                        } else if (object instanceof DSAPublicKey) {
                            try {
                                if (!DSSSignature.verify((DSAPublicKey)object, object11.digest(), (BigInteger[])certificateVerify.getSigValue())) {
                                    throw new Exception("client's certificate could not be verified");
                                }
                            }
                            catch (Exception exception) {
                                this.handshakeFailure();
                                SSLHandshakeException sSLHandshakeException = new SSLHandshakeException(exception.getMessage());
                                sSLHandshakeException.initCause(exception);
                                throw sSLHandshakeException;
                            }
                        }
                    }
                }
            }
            object7 = null;
            try {
                object7 = this.generateKeys(((Random)object9).getEncoded(), random.getEncoded(), protocolVersion);
            }
            catch (Exception exception) {
                this.internalError();
                object4 = new RuntimeException(exception.getMessage());
                ((Throwable)object4).initCause(exception);
                throw object4;
            }
            object5 = null;
            object4 = null;
            object3 = null;
            object2 = null;
            try {
                if (this.session.params instanceof GNUSecurityParameters) {
                    HashMap hashMap = new HashMap();
                    object4 = CipherSuite.getMac(((CipherSuite)object6).getMac());
                    object5 = CipherSuite.getMac(((CipherSuite)object6).getMac());
                    hashMap.put("gnu.crypto.mac.key.material", object7[1]);
                    ((IMac)object4).init(hashMap);
                    hashMap.put("gnu.crypto.mac.key.material", object7[0]);
                    ((IMac)object5).init(hashMap);
                    if (((CipherSuite)object6).getCipher() == "RC4") {
                        object2 = new ARCFour();
                        object3 = new ARCFour();
                        hashMap.clear();
                        hashMap.put("gnu.crypto.prng.arcfour.key-material", object7[3]);
                        ((ARCFour)object2).init(hashMap);
                        hashMap.put("gnu.crypto.prng.arcfour.key-material", object7[2]);
                        ((ARCFour)object3).init(hashMap);
                        break block111;
                    }
                    if (!((CipherSuite)object6).isStreamCipher()) {
                        object2 = CipherSuite.getCipher(((CipherSuite)object6).getCipher());
                        object3 = CipherSuite.getCipher(((CipherSuite)object6).getCipher());
                        hashMap.clear();
                        hashMap.put("gnu.crypto.cipher.key.material", object7[3]);
                        hashMap.put("gnu.crypto.mode.iv", object7[5]);
                        hashMap.put("gnu.crypto.mode.state", new Integer(1));
                        ((IMode)object2).init(hashMap);
                        hashMap.put("gnu.crypto.cipher.key.material", object7[2]);
                        hashMap.put("gnu.crypto.mode.iv", object7[4]);
                        hashMap.put("gnu.crypto.mode.state", new Integer(2));
                        ((IMode)object3).init(hashMap);
                    }
                    break block111;
                }
                object4 = CipherSuite.getJCEMac(((CipherSuite)object6).getMac());
                object5 = CipherSuite.getJCEMac(((CipherSuite)object6).getMac());
                object2 = CipherSuite.getJCECipher(((CipherSuite)object6).getCipher());
                object3 = CipherSuite.getJCECipher(((CipherSuite)object6).getCipher());
                ((Mac)object4).init(new SecretKeySpec(object7[1], ((CipherSuite)object6).getMac()));
                ((Mac)object5).init(new SecretKeySpec(object7[0], ((CipherSuite)object6).getMac()));
                if (!((CipherSuite)object6).isStreamCipher()) {
                    ((Cipher)object2).init(1, (Key)new SecretKeySpec(object7[3], ((CipherSuite)object6).getCipher()), new IvParameterSpec(object7[5]));
                    ((Cipher)object3).init(2, (Key)new SecretKeySpec(object7[2], ((CipherSuite)object6).getCipher()), new IvParameterSpec(object7[4]));
                } else {
                    ((Cipher)object2).init(1, new SecretKeySpec(object7[3], ((CipherSuite)object6).getCipher()));
                    ((Cipher)object3).init(2, new SecretKeySpec(object7[2], ((CipherSuite)object6).getCipher()));
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                this.internalError();
                RuntimeException runtimeException = new RuntimeException(invalidKeyException.getMessage());
                runtimeException.initCause(invalidKeyException);
                throw new RuntimeException(String.valueOf(invalidKeyException));
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                this.internalError();
                RuntimeException runtimeException = new RuntimeException(invalidAlgorithmParameterException.getMessage());
                runtimeException.initCause(invalidAlgorithmParameterException);
                throw runtimeException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.session.enabledSuites.remove(object6);
                this.internalError();
                SSLException sSLException = new SSLException("suite " + object6 + " not available in this configuration");
                sSLException.initCause(noSuchAlgorithmException);
                throw sSLException;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                this.session.enabledSuites.remove(object6);
                this.internalError();
                SSLException sSLException = new SSLException("suite " + object6 + " not available in this configuration");
                sSLException.initCause(noSuchPaddingException);
                throw sSLException;
            }
        }
        Finished finished = null;
        if (!bl) {
            this.changeCipherSpec();
            SecurityParameters securityParameters = this.session.params;
            boolean bl5 = false;
            if (compressionMethod == CompressionMethod.ZLIB) {
                bl5 = true;
            }
            securityParameters.setDeflating(bl5);
            this.session.params.setOutMac(object4);
            this.session.params.setOutCipher(object2);
            finished = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest2.clone(), (IMessageDigest)iMessageDigest.clone(), false);
            handshake = new Handshake(Handshake.Type.FINISHED, finished);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        SecurityParameters securityParameters = this.session.params;
        synchronized (securityParameters) {
            this.readChangeCipherSpec();
            SecurityParameters securityParameters2 = this.session.params;
            boolean bl6 = false;
            if (compressionMethod == CompressionMethod.ZLIB) {
                bl6 = true;
            }
            securityParameters2.setInflating(bl6);
            this.session.params.setInMac(object5);
            this.session.params.setInCipher(object3);
            this.session.params.notifyAll();
            // MONITOREXIT @DISABLED, blocks:[16, 15] lbl558 : MonitorExitStatement: MONITOREXIT : var26_52
            object = this.generateFinished(protocolVersion, (IMessageDigest)iMessageDigest2.clone(), (IMessageDigest)iMessageDigest.clone(), true);
        }
        handshake = Handshake.read(digestInputStream, (CipherSuite)object6, null);
        if (handshake.getType() != Handshake.Type.FINISHED) {
            this.throwUnexpectedMessage();
        }
        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
        finished = (Finished)handshake.getBody();
        if (protocolVersion == ProtocolVersion.SSL_3) {
            if (!Arrays.equals(finished.getMD5Hash(), ((Finished)object).getMD5Hash()) || !Arrays.equals(finished.getSHAHash(), ((Finished)object).getSHAHash())) {
                this.throwHandshakeFailure();
            }
        } else if (!Arrays.equals(finished.getVerifyData(), ((Finished)object).getVerifyData())) {
            this.throwHandshakeFailure();
        }
        if (bl) {
            this.changeCipherSpec();
            SecurityParameters securityParameters3 = this.session.params;
            boolean bl7 = false;
            if (compressionMethod == CompressionMethod.ZLIB) {
                bl7 = true;
            }
            securityParameters3.setDeflating(bl7);
            this.session.params.setOutMac(object4);
            this.session.params.setOutCipher(object2);
            finished = this.generateFinished(protocolVersion, iMessageDigest2, iMessageDigest, false);
            handshake = new Handshake(Handshake.Type.FINISHED, finished);
            logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
            handshake.write(digestOutputStream, protocolVersion);
            digestOutputStream.flush();
        }
        this.handshakeCompleted();
    }

    private final byte[][] generateKeys(byte[] byArray, byte[] byArray2, ProtocolVersion protocolVersion) throws LimitReachedException, IOException {
        HashMap hashMap;
        CipherSuite cipherSuite = this.session.cipherSuite;
        int n = cipherSuite.getMac().indexOf("MD5") >= 0 ? 16 : 20;
        int n2 = cipherSuite.getKeyLength();
        int n3 = 0;
        if (cipherSuite.getCipher().indexOf("DES") >= 0) {
            n3 = 8;
        } else if (cipherSuite.getCipher() == "AES") {
            n3 = 16;
        }
        byte[][] byArrayArray = new byte[][]{new byte[n], new byte[n], new byte[n2], new byte[n2], new byte[n3], new byte[n3]};
        IRandom iRandom = null;
        if (protocolVersion == ProtocolVersion.SSL_3) {
            iRandom = new SSLRandom();
            hashMap = new HashMap();
            hashMap.put("jessie.sslprng.secret", this.session.masterSecret);
            hashMap.put("jessie.sslprng.seed", Util.concat(byArray, byArray2));
            iRandom.init(hashMap);
        } else {
            iRandom = new TLSRandom();
            hashMap = new HashMap();
            hashMap.put("jessie.tls.prng.secret", this.session.masterSecret);
            hashMap.put("jessie.tls.prng.seed", Util.concat("key expansion".getBytes("UTF-8"), Util.concat(byArray, byArray2)));
            iRandom.init(hashMap);
        }
        int n4 = 0;
        while (n4 < byArrayArray.length) {
            iRandom.nextBytes(byArrayArray[n4], 0, byArrayArray[n4].length);
            ++n4;
        }
        if (cipherSuite.isExportable()) {
            int n5 = n4 = cipherSuite.getCipher() == "DES" ? 8 : 16;
            if (protocolVersion == ProtocolVersion.SSL_3) {
                IMessageDigest iMessageDigest = HashFactory.getInstance("md5");
                iMessageDigest.update(byArrayArray[2], 0, byArrayArray[2].length);
                iMessageDigest.update(byArray2, 0, byArray2.length);
                iMessageDigest.update(byArray, 0, byArray.length);
                byArrayArray[2] = Util.trim(iMessageDigest.digest(), n4);
                iMessageDigest.update(byArrayArray[3], 0, byArrayArray[3].length);
                iMessageDigest.update(byArray, 0, byArray.length);
                iMessageDigest.update(byArray2, 0, byArray2.length);
                byArrayArray[3] = Util.trim(iMessageDigest.digest(), n4);
                if (!cipherSuite.isStreamCipher()) {
                    iMessageDigest.update(byArray2, 0, byArray2.length);
                    iMessageDigest.update(byArray, 0, byArray.length);
                    byArrayArray[4] = Util.trim(iMessageDigest.digest(), n3);
                    iMessageDigest.update(byArray, 0, byArray.length);
                    iMessageDigest.update(byArray2, 0, byArray2.length);
                    byArrayArray[5] = Util.trim(iMessageDigest.digest(), n3);
                }
            } else {
                HashMap hashMap2 = new HashMap();
                hashMap2.put("jessie.tls.prng.secret", byArrayArray[2]);
                hashMap2.put("jessie.tls.prng.seed", Util.concat("client write key".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
                iRandom.init(hashMap2);
                byArrayArray[2] = new byte[n4];
                iRandom.nextBytes(byArrayArray[2], 0, n4);
                hashMap2.put("jessie.tls.prng.secret", byArrayArray[3]);
                hashMap2.put("jessie.tls.prng.seed", Util.concat("server write key".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
                iRandom.init(hashMap2);
                byArrayArray[3] = new byte[n4];
                iRandom.nextBytes(byArrayArray[3], 0, n4);
                if (!cipherSuite.isStreamCipher()) {
                    hashMap2.put("jessie.tls.prng.secret", new byte[0]);
                    hashMap2.put("jessie.tls.prng.seed", Util.concat("IV block".getBytes("UTF-8"), Util.concat(byArray2, byArray)));
                    iRandom.init(hashMap2);
                    iRandom.nextBytes(byArrayArray[4], 0, byArrayArray[4].length);
                    iRandom.nextBytes(byArrayArray[5], 0, byArrayArray[5].length);
                }
            }
        }
        return byArrayArray;
    }

    private final Finished generateFinished(ProtocolVersion protocolVersion, IMessageDigest iMessageDigest, IMessageDigest iMessageDigest2, boolean bl) {
        if (protocolVersion == ProtocolVersion.SSL_3) {
            if (bl) {
                iMessageDigest.update(SENDER_CLIENT, 0, 4);
            } else {
                iMessageDigest.update(SENDER_SERVER, 0, 4);
            }
            byte[] byArray = this.session.masterSecret;
            iMessageDigest.update(byArray, 0, byArray.length);
            int n = 0;
            while (n < 48) {
                iMessageDigest.update((byte)54);
                ++n;
            }
            byte[] byArray2 = iMessageDigest.digest();
            iMessageDigest.update(byArray, 0, byArray.length);
            int n2 = 0;
            while (n2 < 48) {
                iMessageDigest.update((byte)92);
                ++n2;
            }
            iMessageDigest.update(byArray2, 0, byArray2.length);
            if (bl) {
                iMessageDigest2.update(SENDER_CLIENT, 0, 4);
            } else {
                iMessageDigest2.update(SENDER_SERVER, 0, 4);
            }
            iMessageDigest2.update(byArray, 0, byArray.length);
            n2 = 0;
            while (n2 < 40) {
                iMessageDigest2.update((byte)54);
                ++n2;
            }
            byArray2 = iMessageDigest2.digest();
            iMessageDigest2.update(byArray, 0, byArray.length);
            n2 = 0;
            while (n2 < 40) {
                iMessageDigest2.update((byte)92);
                ++n2;
            }
            iMessageDigest2.update(byArray2, 0, byArray2.length);
            return new Finished(iMessageDigest.digest(), iMessageDigest2.digest());
        }
        byte[] byArray = iMessageDigest.digest();
        byte[] byArray3 = iMessageDigest2.digest();
        String string = bl ? "client finished" : "server finished";
        byte[] byArray4 = null;
        try {
            byArray4 = Util.concat(string.getBytes("UTF-8"), Util.concat(byArray, byArray3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            RuntimeException runtimeException = new RuntimeException(unsupportedEncodingException.getMessage());
            runtimeException.initCause(unsupportedEncodingException);
            throw runtimeException;
        }
        TLSRandom tLSRandom = new TLSRandom();
        HashMap hashMap = new HashMap();
        hashMap.put("jessie.tls.prng.secret", this.session.masterSecret);
        hashMap.put("jessie.tls.prng.seed", byArray4);
        tLSRandom.init(hashMap);
        byte[] byArray5 = new byte[12];
        try {
            tLSRandom.nextBytes(byArray5, 0, 12);
        }
        catch (LimitReachedException limitReachedException) {
            RuntimeException runtimeException = new RuntimeException(limitReachedException.getMessage());
            runtimeException.initCause(limitReachedException);
            throw runtimeException;
        }
        return new Finished(byArray5);
    }

    private final Alert unexpectedMessage() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private final void throwUnexpectedMessage() throws IOException {
        throw new AlertException(this.unexpectedMessage(), true);
    }

    private final Alert handshakeFailure() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private final void throwHandshakeFailure() throws IOException {
        throw new AlertException(this.handshakeFailure(), true);
    }

    private final Alert internalError() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private final void throwInternalError() throws IOException {
        throw new AlertException(this.internalError(), true);
    }

    private final Alert peerUnverified(X509Certificate[] x509CertificateArray) throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE);
        this.sendAlert(alert);
        this.fatal();
        return alert;
    }

    private final void throwPeerUnverified(X509Certificate[] x509CertificateArray) throws IOException {
        this.peerUnverified(x509CertificateArray);
        throw new SSLPeerUnverifiedException("could not verify: " + x509CertificateArray[0].getSubjectDN());
    }

    private final CipherSuite selectSuite(List list2, ProtocolVersion protocolVersion) throws IOException {
        logger.log((Level)Component.SSL_HANDSHAKE, "selectSuite req:{0} suites:{1}", new Object[]{list2, this.session.enabledSuites});
        boolean bl = false;
        Object object = list2.iterator();
        while (object.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)object.next();
            Iterator iterator = this.session.enabledSuites.iterator();
            while (iterator.hasNext()) {
                CipherSuite cipherSuite2 = (CipherSuite)iterator.next();
                if (!cipherSuite2.equals(cipherSuite)) continue;
                logger.log((Level)Component.SSL_HANDSHAKE, "{0} == {1}", new Object[]{cipherSuite2, cipherSuite});
                if (cipherSuite2.getSignature() != "anon" && this.session.keyManager != null && this.session.keyManager.chooseServerAlias(cipherSuite2.getAuthType(), null, null) == null) {
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}: no certificate/private key", cipherSuite2);
                    continue;
                }
                if (cipherSuite2.getKeyExchange() == "SRP") {
                    if (this.session.getValue("srp-username") == null) {
                        logger.log(Component.SSL_HANDSHAKE, "no SRP username");
                        bl = true;
                        continue;
                    }
                    if (this.session.srpTrustManager == null) {
                        logger.log(Component.SSL_HANDSHAKE, "no SRP password file");
                        continue;
                    }
                }
                return cipherSuite2.resolve(protocolVersion);
            }
        }
        object = null;
        if (bl) {
            object = new Alert(Alert.Level.WARNING, Alert.Description.MISSING_SRP_USERNAME);
            this.sendAlert((Alert)object);
            return null;
        }
        object = new Alert(Alert.Level.FATAL, Alert.Description.INSUFFICIENT_SECURITY);
        this.sendAlert((Alert)object);
        this.fatal();
        throw new AlertException((Alert)object, true);
    }

    private final String askUserName(String string) {
        Serializable serializable;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            serializable = Class.forName(Util.getSecurityProperty("jessie.srp.user.handler"));
            callbackHandler = (CallbackHandler)((Class)serializable).newInstance();
        }
        catch (Exception exception) {}
        serializable = new TextInputCallback("User name for " + string + ": ", Util.getProperty("user.name"));
        try {
            callbackHandler.handle(new Callback[]{serializable});
        }
        catch (Exception exception) {}
        return ((TextInputCallback)serializable).getText();
    }

    private final String askPassword(String string) {
        Serializable serializable;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            serializable = Class.forName(Util.getSecurityProperty("jessie.srp.password.handler"));
            callbackHandler = (CallbackHandler)((Class)serializable).newInstance();
        }
        catch (Exception exception) {}
        serializable = new PasswordCallback(string + "'s password: ", false);
        try {
            callbackHandler.handle(new Callback[]{serializable});
        }
        catch (Exception exception) {}
        return new String(((PasswordCallback)serializable).getPassword());
    }

    private final boolean checkCertificates(X509Certificate[] x509CertificateArray) {
        Object object;
        CallbackHandler callbackHandler = new DefaultCallbackHandler();
        try {
            object = Class.forName(Util.getSecurityProperty("jessie.certificate.handler"));
            callbackHandler = (CallbackHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {}
        object = Util.getProperty("line.separator");
        ConfirmationCallback confirmationCallback = new ConfirmationCallback("The server's certificate could not be verified. There is no proof" + (String)object + "that this server is who it claims to be, or that their certificate" + (String)object + "is valid. Do you wish to continue connecting?", 2, 0, 1);
        try {
            callbackHandler.handle(new Callback[]{confirmationCallback});
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl = false;
        if (confirmationCallback.getSelectedIndex() == 0) {
            bl = true;
        }
        return bl;
    }

    private final void updateSig(ISignature iSignature, BigInteger bigInteger) {
        byte[] byArray = Util.trim(bigInteger);
        iSignature.update((byte)(byArray.length >>> 8));
        iSignature.update((byte)byArray.length);
        iSignature.update(byArray, 0, byArray.length);
    }

    private final void fatal() throws IOException {
        if (this.session != null) {
            this.session.invalidate();
        }
        if (this.underlyingSocket != null) {
            this.underlyingSocket.close();
        } else {
            super.close();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    SSLSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        this.underlyingSocket = socket;
        this.remoteHost = string;
        this.underlyingPort = n;
        this.autoClose = bl;
        this.initialize();
    }

    SSLSocket(Socket socket, SocketChannel socketChannel) throws IOException {
        this.underlyingSocket = socket;
        this.channel = socketChannel;
        this.initialize();
    }

    SSLSocket() throws IOException {
        this.initialize();
    }

    SSLSocket(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.initialize();
        this.remoteHost = inetAddress.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = inetAddress.getHostAddress();
        }
    }

    SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.initialize();
        this.remoteHost = inetAddress.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = inetAddress.getHostAddress();
        }
    }

    SSLSocket(String string, int n) throws IOException {
        super(string, n);
        this.initialize();
        this.remoteHost = string;
    }

    SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        super(string, n, inetAddress, n2);
        this.initialize();
        this.remoteHost = string;
    }

    static {
        supportedProtocols.add(ProtocolVersion.TLS_1);
        supportedProtocols.add(ProtocolVersion.SSL_3);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_RC4_128_MD5);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_RC4_128_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_EXPORT_WITH_RC4_40_MD5);
        supportedSuites.add(CipherSuite.TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_MD5);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_SHA);
        SENDER_CLIENT = new byte[]{67, 76, 78, 84};
        SENDER_SERVER = new byte[]{83, 82, 86, 82};
    }
}

