/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.Test;
import java.io.PrintStream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

class Template
implements Comparable {
    static final double DEFAULT_PRIORITY = 0.5;
    final Stylesheet stylesheet;
    final QName name;
    final Pattern match;
    final TemplateNode node;
    final double priority;
    final int precedence;
    final QName mode;
    final boolean isAnyNode;

    Template clone(Stylesheet stylesheet) {
        return new Template(stylesheet, this.name, this.match == null ? null : (Pattern)this.match.clone(stylesheet), this.node == null ? null : this.node.clone(stylesheet), this.precedence, this.priority, this.mode, this.isAnyNode);
    }

    public int compareTo(Object object) {
        if (object instanceof Template) {
            Template template = (Template)object;
            int n = template.precedence - this.precedence;
            if (n != 0) {
                return n;
            }
            double d = template.priority - this.priority;
            if (d != 0.0) {
                return (int)Math.round(d * 1000.0);
            }
        }
        return 0;
    }

    Test getNodeTest(Expr expr) {
        return null;
    }

    boolean matches(QName qName, Node node2) {
        if (qName == null && this.mode != null || qName != null && !qName.equals(this.mode)) {
            return false;
        }
        if (this.match == null) {
            return false;
        }
        if (this.isAnyNode && node2.getNodeType() == 9) {
            return false;
        }
        return this.match.matches(node2);
    }

    boolean matches(QName qName) {
        return qName.equals(this.name);
    }

    boolean imports(Template template) {
        Stylesheet stylesheet = template.stylesheet.parent;
        while (stylesheet != null) {
            if (stylesheet == this.stylesheet) {
                return true;
            }
            stylesheet = stylesheet.parent;
        }
        return false;
    }

    void apply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        if (stylesheet.debug) {
            System.err.println("...applying " + this.toString() + " to " + node2);
        }
        if (this.node != null) {
            this.node.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        if (this.name != null) {
            stringBuffer.append("name=");
            stringBuffer.append(this.name);
        } else if (this.match != null) {
            stringBuffer.append("match=");
            stringBuffer.append(this.match);
        }
        if (this.mode != null) {
            stringBuffer.append(",mode=");
            stringBuffer.append(this.mode);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    void list(PrintStream printStream) {
        printStream.println(this.toString());
        if (this.node != null) {
            this.node.list(1, printStream, true);
        }
    }

    Template(Stylesheet stylesheet, QName qName, Pattern pattern2, TemplateNode templateNode, int n, String string, QName qName2) {
        Selector selector;
        Test[] testArray;
        this.stylesheet = stylesheet;
        this.name = qName;
        this.match = pattern2;
        this.node = templateNode;
        this.precedence = n;
        this.mode = qName2;
        double d = 0.5;
        boolean bl = false;
        if (string != null) {
            d = Double.parseDouble(string);
        } else if (pattern2 instanceof Selector && (testArray = (selector = (Selector)pattern2).getTests()).length > 0) {
            Test test = testArray[0];
            if (test instanceof NameTest) {
                NameTest nameTest = (NameTest)test;
                d = nameTest.matchesAny() ? -0.25 : (nameTest.matchesAnyLocalName() ? -0.2 : 0.0);
            } else {
                NodeTypeTest nodeTypeTest = (NodeTypeTest)test;
                d = nodeTypeTest.getNodeType() == 7 && nodeTypeTest.getData() != null ? 0.0 : -0.5;
                boolean bl2 = false;
                if (nodeTypeTest.getNodeType() == 0) {
                    bl2 = bl = true;
                }
            }
            if (testArray.length > 1) {
                d += ((double)testArray.length - 1.0) * 0.001;
            }
        }
        this.priority = d;
        this.isAnyNode = bl;
    }

    private Template(Stylesheet stylesheet, QName qName, Pattern pattern2, TemplateNode templateNode, int n, double d, QName qName2, boolean bl) {
        this.stylesheet = stylesheet;
        this.name = qName;
        this.match = pattern2;
        this.node = templateNode;
        this.precedence = n;
        this.priority = d;
        this.mode = qName2;
        this.isAnyNode = bl;
    }
}

