/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Runtime {
    private static final Runtime current = new Runtime();
    private final String[] libpath;
    private Thread exitSequence;
    private Set shutdownHooks;

    public static Runtime getRuntime() {
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        if (this.runShutdownHooks()) {
            this.halt(n);
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.shutdownHooks != null) {
                this.shutdownHooks.remove(Thread.currentThread());
                this.exitSequence.interrupt();
                n = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (n != 0) {
                this.halt(n);
            }
            while (true) {
                try {
                    this.exitSequence.join();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    boolean runShutdownHooks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 15->89)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        if (thread.isAlive() || thread.getThreadGroup() == null) {
            throw new IllegalArgumentException("The hook thread " + thread + " must not have been already run or started");
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException("The Virtual Machine is exiting. It is not possible anymore to add any hooks");
            }
            if (this.shutdownHooks == null) {
                VMRuntime.enableShutdownHooks();
                this.shutdownHooks = new HashSet();
            }
            if (!this.shutdownHooks.add(thread)) {
                throw new IllegalArgumentException(thread.toString() + " had already been inserted");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        String[] stringArray = this.libpath;
        synchronized (this.libpath) {
            if (this.exitSequence != null) {
                throw new IllegalStateException();
            }
            if (this.shutdownHooks != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.shutdownHooks.remove(thread);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public void halt(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        VMRuntime.exit(n);
    }

    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(0);
        }
        VMRuntime.runFinalizersOnExit(bl);
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExec(stringArray[0]);
        }
        return VMRuntime.exec(stringArray, stringArray2, file);
    }

    public int availableProcessors() {
        return VMRuntime.availableProcessors();
    }

    public long freeMemory() {
        return VMRuntime.freeMemory();
    }

    public long totalMemory() {
        return VMRuntime.totalMemory();
    }

    public long maxMemory() {
        return VMRuntime.maxMemory();
    }

    public void gc() {
        VMRuntime.gc();
    }

    public void runFinalization() {
        VMRuntime.runFinalization();
    }

    public void traceInstructions(boolean bl) {
        VMRuntime.traceInstructions(bl);
    }

    public void traceMethodCalls(boolean bl) {
        VMRuntime.traceMethodCalls(bl);
    }

    public void load(String string) {
        this.load(string, VMStackWalker.getCallingClassLoader());
    }

    void load(String string, ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (Runtime.loadLib(string, classLoader) == 0) {
            throw new UnsatisfiedLinkError("Could not load library " + string);
        }
    }

    private static final int loadLib(String string, ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return VMRuntime.nativeLoad(string, classLoader);
    }

    public void loadLibrary(String string) {
        this.loadLibrary(string, VMStackWalker.getCallingClassLoader());
    }

    void loadLibrary(String string, ClassLoader classLoader) {
        String string2;
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            if (Runtime.loadLib(string2, classLoader) != 0) {
                return;
            }
        } else {
            string2 = VMRuntime.mapLibraryName(string);
            int n = 0;
            while (n < this.libpath.length) {
                if (Runtime.loadLib(this.libpath[n] + string2, classLoader) != 0) {
                    return;
                }
                ++n;
            }
            String[] stringArray = new String[]{"lib", "cyg", ""};
            String[] stringArray2 = new String[]{".so", ".dll", ".la", ".a", ".dylib", ".jnilib", ".dll.a"};
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    int n4 = 0;
                    while (n4 < this.libpath.length) {
                        if (Runtime.loadLib(this.libpath[n4] + stringArray[n2] + string + stringArray2[n3], classLoader) != 0) {
                            return;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        throw new UnsatisfiedLinkError("Native library `" + string + "' not found (as file `" + string2 + "' in class loader " + classLoader + ") in gnu.classpath.boot.library.path and java.library.path `" + Arrays.asList(this.libpath) + '\'');
    }

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    private Runtime() {
        String string;
        if (current != null) {
            throw new InternalError("Attempt to recreate Runtime");
        }
        String string2 = SystemProperties.getProperty("gnu.classpath.boot.library.path", "");
        String string3 = SystemProperties.getProperty("java.library.path", ".");
        String string4 = SystemProperties.getProperty("path.separator", ":");
        String string5 = SystemProperties.getProperty("file.separator", "/");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string4);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, string4);
        this.libpath = new String[stringTokenizer.countTokens() + stringTokenizer2.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!string.endsWith(string5)) {
                string = string + string5;
            }
            this.libpath[n] = string;
            ++n;
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string = stringTokenizer2.nextToken();
            if (!string.endsWith(string5)) {
                string = string + string5;
            }
            this.libpath[n] = string;
            ++n;
        }
    }
}

