/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    static final long serialVersionUID = -2077529998244066750L;
    int indexOfNextAdd;
    int limit = 100;

    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void setLimit(int n) {
        if (!this.isInProgress()) {
            throw new IllegalStateException();
        }
        this.limit = n;
        this.trimForLimit();
    }

    public synchronized void discardAllEdits() {
        int n = this.edits.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            ((UndoableEdit)this.edits.get(n2)).die();
            --n2;
        }
        this.indexOfNextAdd = 0;
        this.edits.clear();
    }

    protected void trimForLimit() {
        int n = this.edits.size();
        if (this.limit <= 0 || n <= this.limit) {
            return;
        }
        int n2 = Math.min(this.indexOfNextAdd + this.limit / 2 - 1, n - 1);
        this.trimEdits(n2 + 1, n - 1);
        this.trimEdits(0, n2 - this.limit);
    }

    protected void trimEdits(int n, int n2) {
        if (n > n2) {
            return;
        }
        int n3 = n2;
        while (n3 >= n) {
            ((UndoableEdit)this.edits.get(n3)).die();
            --n3;
        }
        if (n2 == n) {
            this.edits.remove(n);
        } else {
            this.edits.subList(n, n2 + 1).clear();
        }
        if (this.indexOfNextAdd > n2) {
            this.indexOfNextAdd = this.indexOfNextAdd - n2 + n - 1;
        } else if (this.indexOfNextAdd >= n) {
            this.indexOfNextAdd = n;
        }
    }

    protected UndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd - 1;
        while (n >= 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.get(n);
            if (undoableEdit.isSignificant()) {
                return undoableEdit;
            }
            --n;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int n = this.indexOfNextAdd;
        while (n < this.edits.size()) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.get(n);
            if (undoableEdit.isSignificant()) {
                return undoableEdit;
            }
            ++n;
        }
        return null;
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        UndoableEdit undoableEdit2;
        if (!this.edits.contains(undoableEdit)) {
            throw new CannotUndoException();
        }
        do {
            --this.indexOfNextAdd;
            undoableEdit2 = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            undoableEdit2.undo();
        } while (undoableEdit2 != undoableEdit);
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        UndoableEdit undoableEdit2;
        if (!this.edits.contains(undoableEdit)) {
            throw new CannotRedoException();
        }
        do {
            undoableEdit2 = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            ++this.indexOfNextAdd;
            undoableEdit2.redo();
        } while (undoableEdit2 != undoableEdit);
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        return this.indexOfNextAdd == this.edits.size() ? this.canUndo() : this.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        if (!this.isInProgress()) {
            super.undo();
            return;
        }
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit == null) {
            throw new CannotUndoException();
        }
        this.undoTo(undoableEdit);
    }

    public synchronized boolean canUndo() {
        if (!this.isInProgress()) {
            return super.canUndo();
        }
        UndoableEdit undoableEdit = this.editToBeUndone();
        boolean bl = false;
        if (undoableEdit != null && undoableEdit.canUndo()) {
            bl = true;
        }
        return bl;
    }

    public synchronized void redo() throws CannotRedoException {
        if (!this.isInProgress()) {
            super.redo();
            return;
        }
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit == null) {
            throw new CannotRedoException();
        }
        this.redoTo(undoableEdit);
    }

    public synchronized boolean canRedo() {
        if (!this.isInProgress()) {
            return super.canRedo();
        }
        UndoableEdit undoableEdit = this.editToBeRedone();
        boolean bl = false;
        if (undoableEdit != null && undoableEdit.canRedo()) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean bl = super.addEdit(undoableEdit);
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return bl;
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (!this.isInProgress()) {
            return super.getUndoPresentationName();
        }
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit == null) {
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return undoableEdit.getUndoPresentationName();
    }

    public synchronized String getRedoPresentationName() {
        if (!this.isInProgress()) {
            return super.getRedoPresentationName();
        }
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit == null) {
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return undoableEdit.getRedoPresentationName();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }
}

