/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DatatypeFactory {
    public static final String DATATYPEFACTORY_PROPERTY = "javax.xml.datatype.DatatypeFactory";
    public static final String DATATYPEFACTORY_IMPLEMENTATION_CLASS = "gnu.xml.datatype.JAXPDatatypeFactory";

    public static DatatypeFactory newInstance() throws DatatypeConfigurationException {
        try {
            Class clazz = Class.forName(DATATYPEFACTORY_IMPLEMENTATION_CLASS);
            return (DatatypeFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new DatatypeConfigurationException(exception);
        }
    }

    public abstract Duration newDuration(String var1);

    public abstract Duration newDuration(long var1);

    public abstract Duration newDuration(boolean var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigDecimal var7);

    public Duration newDuration(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.newDuration(bl, BigInteger.valueOf(n), BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigInteger.valueOf(n4), BigInteger.valueOf(n5), BigDecimal.valueOf(n6));
    }

    public Duration newDurationDayTime(String string) {
        return this.newDuration(string);
    }

    public Duration newDurationDayTime(long l) {
        return this.newDuration(l);
    }

    public Duration newDurationDayTime(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigDecimal bigDecimal) {
        return this.newDuration(bl, null, null, bigInteger, bigInteger2, bigInteger3, bigDecimal);
    }

    public Duration newDurationDayTime(boolean bl, int n, int n2, int n3, int n4) {
        return this.newDuration(bl, null, null, BigInteger.valueOf(n), BigInteger.valueOf(n2), BigInteger.valueOf(n3), BigDecimal.valueOf(n4));
    }

    public Duration newDurationYearMonth(String string) {
        return this.newDuration(string);
    }

    public Duration newDurationYearMonth(long l) {
        return this.newDuration(l);
    }

    public Duration newDurationYearMonth(boolean bl, BigInteger bigInteger, BigInteger bigInteger2) {
        return this.newDuration(bl, bigInteger, bigInteger2, null, null, null, null);
    }

    public Duration newDurationYearMonth(boolean bl, int n, int n2) {
        return this.newDuration(bl, BigInteger.valueOf(n), BigInteger.valueOf(n2), null, null, null, null);
    }

    public abstract XMLGregorianCalendar newXMLGregorianCalendar();

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(String var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(BigInteger var1, int var2, int var3, int var4, int var5, int var6, BigDecimal var7, int var8);

    public XMLGregorianCalendar newXMLGregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.newXMLGregorianCalendar(BigInteger.valueOf(n), n2, n3, n4, n5, n6, new BigDecimal((double)n7 / 1000.0), n8);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarDate(int n, int n2, int n3, int n4) {
        return this.newXMLGregorianCalendar(BigInteger.valueOf(n), n2, n3, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, n4);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int n, int n2, int n3, int n4) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, n, n2, n3, null, n4);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int n, int n2, int n3, BigDecimal bigDecimal, int n4) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, n, n2, n3, bigDecimal, n4);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int n, int n2, int n3, int n4, int n5) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, n, n2, n3, new BigDecimal((double)n4 / 1000.0), n5);
    }

    protected DatatypeFactory() {
    }
}

