/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Lookup {
    private static Resolver defaultResolver;
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private static final Name[] noAliases;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;
    private Resolver resolver;
    private Name[] searchPath;
    private Cache cache;
    private boolean temporary_cache;
    private int credibility;
    private Name name;
    private int type;
    private int dclass;
    private boolean verbose;
    private int iterations;
    private boolean foundAlias;
    private boolean done;
    private boolean doneCurrent;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private String badresponse_error;
    private boolean networkerror;
    private boolean timedout;
    private boolean nametoolong;
    private boolean referral;
    static /* synthetic */ Class class$org$xbill$DNS$Lookup;

    public static final synchronized void refreshDefault() {
        try {
            defaultResolver = new ExtendedResolver();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Failed to initialize resolver");
        }
        defaultSearchPath = ResolverConfig.getCurrentConfig().searchPath();
        defaultCaches = new HashMap();
    }

    public static final synchronized Resolver getDefaultResolver() {
        return defaultResolver;
    }

    public static final synchronized void setDefaultResolver(Resolver resolver) {
        defaultResolver = resolver;
    }

    public static final synchronized Cache getDefaultCache(int n) {
        DClass.check(n);
        Cache cache = (Cache)defaultCaches.get(Mnemonic.toInteger(n));
        if (cache == null) {
            cache = new Cache(n);
            defaultCaches.put(Mnemonic.toInteger(n), cache);
        }
        return cache;
    }

    public static final synchronized void setDefaultCache(Cache cache, int n) {
        DClass.check(n);
        defaultCaches.put(Mnemonic.toInteger(n), cache);
    }

    public static final synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static final synchronized void setDefaultSearchPath(Name[] nameArray) {
        defaultSearchPath = nameArray;
    }

    public static final synchronized void setDefaultSearchPath(String[] stringArray) throws TextParseException {
        if (stringArray == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nameArray[n] = Name.fromString(stringArray[n], Name.root);
            ++n;
        }
        defaultSearchPath = nameArray;
    }

    private final void reset() {
        this.iterations = 0;
        this.foundAlias = false;
        this.done = false;
        this.doneCurrent = false;
        this.aliases = null;
        this.answers = null;
        this.result = -1;
        this.error = null;
        this.nxdomain = false;
        this.badresponse = false;
        this.badresponse_error = null;
        this.networkerror = false;
        this.timedout = false;
        this.nametoolong = false;
        this.referral = false;
        if (this.temporary_cache) {
            this.cache.clearCache();
        }
    }

    public final void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public final void setSearchPath(Name[] nameArray) {
        this.searchPath = nameArray;
    }

    public final void setSearchPath(String[] stringArray) throws TextParseException {
        if (stringArray == null) {
            this.searchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nameArray[n] = Name.fromString(stringArray[n], Name.root);
            ++n;
        }
        this.searchPath = nameArray;
    }

    public final void setCache(Cache cache) {
        if (cache == null) {
            this.cache = new Cache(this.dclass);
            this.temporary_cache = true;
        } else {
            this.cache = cache;
            this.temporary_cache = false;
        }
    }

    public final void setCredibility(int n) {
        this.credibility = n;
    }

    private final void follow(Name name, Name name2) {
        this.foundAlias = true;
        this.badresponse = false;
        this.networkerror = false;
        this.timedout = false;
        this.nxdomain = false;
        this.referral = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals(name2)) {
            this.result = 1;
            this.error = "CNAME loop";
            this.done = true;
            return;
        }
        if (this.aliases == null) {
            this.aliases = new ArrayList();
        }
        this.aliases.add(name);
        this.lookup(name);
    }

    private final void processResponse(Name name, SetResponse setResponse) {
        if (setResponse.isSuccessful()) {
            RRset[] rRsetArray = setResponse.answers();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < rRsetArray.length) {
                Iterator iterator = rRsetArray[n].rrs();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                ++n;
            }
            this.result = 0;
            this.answers = (Record[])arrayList.toArray(new Record[arrayList.size()]);
            this.done = true;
        } else if (setResponse.isNXDOMAIN()) {
            this.nxdomain = true;
            this.doneCurrent = true;
            if (this.iterations > 0) {
                this.result = 3;
                this.done = true;
            }
        } else if (setResponse.isNXRRSET()) {
            this.result = 4;
            this.answers = null;
            this.done = true;
        } else if (setResponse.isCNAME()) {
            CNAMERecord cNAMERecord = setResponse.getCNAME();
            this.follow(cNAMERecord.getTarget(), name);
        } else if (setResponse.isDNAME()) {
            DNAMERecord dNAMERecord = setResponse.getDNAME();
            Object var4_7 = null;
            try {
                this.follow(name.fromDNAME(dNAMERecord), name);
            }
            catch (NameTooLongException nameTooLongException) {
                this.result = 1;
                this.error = "Invalid DNAME target";
                this.done = true;
            }
        } else if (setResponse.isDelegation()) {
            this.referral = true;
        }
    }

    private final void lookup(Name name) {
        SetResponse setResponse = this.cache.lookupRecords(name, this.type, this.credibility);
        if (this.verbose) {
            System.err.println("lookup " + name + ' ' + Type.string(this.type));
            System.err.println(setResponse);
        }
        this.processResponse(name, setResponse);
        if (this.done || this.doneCurrent) {
            return;
        }
        Record record = Record.newRecord(name, this.type, this.dclass);
        Message message = Message.newQuery(record);
        Message message2 = null;
        try {
            message2 = this.resolver.send(message);
        }
        catch (IOException iOException) {
            if (iOException instanceof InterruptedIOException) {
                this.timedout = true;
            } else {
                this.networkerror = true;
            }
            return;
        }
        int n = message2.getHeader().getRcode();
        if (n != 0 && n != 3) {
            this.badresponse = true;
            this.badresponse_error = Rcode.string(n);
            return;
        }
        if (!message.getQuestion().equals(message2.getQuestion())) {
            this.badresponse = true;
            this.badresponse_error = "response does not match query";
            return;
        }
        setResponse = this.cache.addMessage(message2);
        if (setResponse == null) {
            setResponse = this.cache.lookupRecords(name, this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + name + ' ' + Type.string(this.type));
            System.err.println(setResponse);
        }
        this.processResponse(name, setResponse);
    }

    private final void resolve(Name name, Name name2) {
        this.doneCurrent = false;
        Name name3 = null;
        if (name2 == null) {
            name3 = name;
        } else {
            try {
                name3 = Name.concatenate(name, name2);
            }
            catch (NameTooLongException nameTooLongException) {
                this.nametoolong = true;
                return;
            }
        }
        this.lookup(name3);
    }

    public final Record[] run() {
        if (this.done) {
            this.reset();
        }
        if (this.name.isAbsolute()) {
            this.resolve(this.name, null);
        } else if (this.searchPath == null) {
            this.resolve(this.name, Name.root);
        } else {
            if (this.name.labels() > 1) {
                this.resolve(this.name, Name.root);
            }
            if (this.done) {
                return this.answers;
            }
            int n = 0;
            while (n < this.searchPath.length) {
                this.resolve(this.name, this.searchPath[n]);
                if (this.done) {
                    return this.answers;
                }
                if (this.foundAlias) break;
                ++n;
            }
        }
        if (!this.done) {
            if (this.badresponse) {
                this.result = 2;
                this.error = this.badresponse_error;
                this.done = true;
            } else if (this.timedout) {
                this.result = 2;
                this.error = "timed out";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.referral) {
                this.result = 1;
                this.error = "referral";
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        return this.answers;
    }

    private final void checkDone() {
        if (this.done && this.result != -1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Lookup of " + this.name + ' ');
        if (this.dclass != 1) {
            stringBuffer.append(DClass.string(this.dclass) + ' ');
        }
        stringBuffer.append(Type.string(this.type) + " isn't done");
        throw new IllegalStateException(stringBuffer.toString());
    }

    public final Record[] getAnswers() {
        this.checkDone();
        return this.answers;
    }

    public final Name[] getAliases() {
        this.checkDone();
        if (this.aliases == null) {
            return noAliases;
        }
        return (Name[])this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public final int getResult() {
        this.checkDone();
        return this.result;
    }

    public final String getErrorString() {
        this.checkDone();
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        throw new IllegalStateException("unknown result");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lookup(Name name, int n, int n2) {
        Type.check(n);
        DClass.check(n2);
        if (!Type.isRR(n) && n != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = n;
        this.dclass = n2;
        Class clazz = class$org$xbill$DNS$Lookup;
        if (clazz == null) {
            clazz = class$org$xbill$DNS$Lookup = Lookup.class("[Lorg.xbill.DNS.Lookup;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            this.resolver = Lookup.getDefaultResolver();
            this.searchPath = Lookup.getDefaultSearchPath();
            this.cache = Lookup.getDefaultCache(n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.credibility = 3;
            this.verbose = Options.check("verbose");
            this.result = -1;
            return;
        }
    }

    public Lookup(Name name, int n) {
        this(name, n, 1);
    }

    public Lookup(Name name) {
        this(name, 1, 1);
    }

    public Lookup(String string, int n, int n2) throws TextParseException {
        this(Name.fromString(string), n, n2);
    }

    public Lookup(String string, int n) throws TextParseException {
        this(Name.fromString(string), n, 1);
    }

    public Lookup(String string) throws TextParseException {
        this(Name.fromString(string), 1, 1);
    }

    static {
        noAliases = new Name[0];
        Lookup.refreshDefault();
    }
}

