/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openide.options.SystemOption;

public final class HistorySettings
extends SystemOption {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CVS_ROOTS = "cvsRoots";
    public static final String PROP_CHECKOUT_DIRECTORY = "checkoutDirectory";
    public static final String PROP_SHOW_CHECKOUT_COMPLETED = "showCheckoutCompleted";
    public static final int HISTORY_LEN = 8;
    public static final String PROP_HTTP_PROXY_HOST = "httpProxyHost";
    public static final String PROP_HTTP_PROXY_PORT = "httpProxyPort";
    public static final String PROP_SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String PROP_SOCKS_PROXY_PORT = "socksProxyPort";
    public static final String PROP_EXT_COMMAND = "extCommand";

    public static HistorySettings getDefault() {
        return (HistorySettings)HistorySettings.findObject((Class)HistorySettings.class, (boolean)true);
    }

    public static List getRecent(String name) {
        List values = (List)HistorySettings.getDefault().getProperty(name);
        if (values == null) {
            return Collections.EMPTY_LIST;
        }
        return values;
    }

    public static void setRecent(String name, List values) {
        HistorySettings.getDefault().putProperty(name, new ArrayList(values), true);
    }

    public static void addRecent(String name, Serializable recent) {
        ArrayList<Serializable> list;
        List values = (List)HistorySettings.getDefault().getProperty(name);
        if (values == null) {
            list = new ArrayList<Serializable>(1);
            list.add(recent);
        } else {
            list = new ArrayList(values);
            list.remove(recent);
            while (list.size() > 8) {
                list.remove(list.size() - 1);
            }
            list.add(0, recent);
        }
        HistorySettings.getDefault().putProperty(name, list, true);
    }

    public static void setFlag(String name, int value) {
        HistorySettings.getDefault().putProperty(name, new Integer(value));
    }

    public static int getFlag(String name, int defaultValue) {
        Integer i = (Integer)HistorySettings.getDefault().getProperty(name);
        if (i != null) {
            return i;
        }
        return defaultValue;
    }

    public String displayName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public List getCvsRoots() {
        return HistorySettings.getRecent(PROP_CVS_ROOTS);
    }

    public void setCvsRoots(List values) {
        HistorySettings.setRecent(PROP_CVS_ROOTS, values);
    }

    public List getCheckoutDirectory() {
        return HistorySettings.getRecent(PROP_CHECKOUT_DIRECTORY);
    }

    public void setCheckoutDirectory(List values) {
        HistorySettings.setRecent(PROP_CHECKOUT_DIRECTORY, values);
    }

    public boolean getShowCheckoutCompleted() {
        int flag = HistorySettings.getFlag(PROP_SHOW_CHECKOUT_COMPLETED, -1);
        return flag != 0;
    }

    public void setShowCheckoutCompleted(boolean show) {
        HistorySettings.setFlag(PROP_SHOW_CHECKOUT_COMPLETED, show ? -1 : 0);
    }

    public String getHttpProxyHost() {
        String host = (String)this.getProperty(PROP_HTTP_PROXY_HOST);
        if (host == null) {
            host = "";
        }
        return host;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.putProperty(PROP_HTTP_PROXY_HOST, httpProxyHost);
    }

    public String getHttpProxyPort() {
        String port = (String)this.getProperty(PROP_HTTP_PROXY_PORT);
        if (port == null) {
            port = "80";
        }
        return port;
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.putProperty(PROP_HTTP_PROXY_PORT, httpProxyPort);
    }

    public String getSocksProxyHost() {
        String host = (String)this.getProperty(PROP_SOCKS_PROXY_HOST);
        if (host == null) {
            host = "";
        }
        return host;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.putProperty(PROP_SOCKS_PROXY_HOST, socksProxyHost);
    }

    public String getSocksProxyPort() {
        String port = (String)this.getProperty(PROP_SOCKS_PROXY_PORT);
        if (port == null) {
            port = "1080";
        }
        return port;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.putProperty(PROP_SOCKS_PROXY_PORT, socksProxyPort);
    }

    public void setExtCommand(String command) {
        this.putProperty(PROP_EXT_COMMAND, command);
    }

    public String getExtCommand() {
        return (String)this.getProperty(PROP_EXT_COMMAND);
    }
}

