/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffStreamSource;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.NoContentPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class DiffResultsView
implements AncestorListener,
PropertyChangeListener {
    private final SearchHistoryPanel parent;
    private final List results;
    private DiffTreeTable treeView;
    private JSplitPane diffView;
    private ShowDiffTask currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    private DiffView currentDiff;
    private int currentDifferenceIndex;
    private int currentIndex;
    private boolean dividerSet;
    private boolean onSelectionshowLastDifference;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$ResultsContainer;
    static /* synthetic */ Class class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision;

    public DiffResultsView(SearchHistoryPanel parent, List results) {
        this.parent = parent;
        this.results = results;
        this.treeView = new DiffTreeTable();
        this.treeView.setResults(results);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent(new NoContentPanel(NbBundle.getMessage((Class)DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    public void ancestorAdded(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            final Node[] nodes = (Node[])evt.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodes.length == 0) {
                this.showDiffError(NbBundle.getMessage((Class)DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodes.length > 2) {
                this.showDiffError(NbBundle.getMessage((Class)DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    SearchHistoryPanel.ResultsContainer container1 = (SearchHistoryPanel.ResultsContainer)nodes[0].getLookup().lookup(class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$ResultsContainer == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$ResultsContainer = DiffResultsView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel$ResultsContainer")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$ResultsContainer);
                    SearchHistoryPanel.DispRevision r1 = (SearchHistoryPanel.DispRevision)nodes[0].getLookup().lookup(class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision = DiffResultsView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel$DispRevision")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision);
                    try {
                        DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                        if (nodes.length == 1) {
                            if (container1 != null) {
                                DiffResultsView.this.showContainerDiff(container1, DiffResultsView.this.onSelectionshowLastDifference);
                            } else if (r1 != null) {
                                DiffResultsView.this.showRevisionDiff(r1, DiffResultsView.this.onSelectionshowLastDifference);
                            }
                        } else if (nodes.length == 2) {
                            SearchHistoryPanel.DispRevision r2 = (SearchHistoryPanel.DispRevision)nodes[1].getLookup().lookup(class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision = DiffResultsView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel$DispRevision")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SearchHistoryPanel$DispRevision);
                            if (r2.getRevision().getLogInfoHeader() != r1.getRevision().getLogInfoHeader()) {
                                throw new Exception();
                            }
                            String revision2 = r1.getRevision().getNumber();
                            String revision1 = r2.getRevision().getNumber();
                            DiffResultsView.this.showDiff(r1.getRevision().getLogInfoHeader(), revision1, revision2, false);
                        }
                    }
                    catch (Exception e) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffResultsView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffResultsView = DiffResultsView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffResultsView), (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void showDiffError(String s) {
        this.setBottomComponent(new NoContentPanel(s));
    }

    private void setBottomComponent(Component component) {
        int dl = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiff(LogInformation header, String revision1, String revision2, boolean showLastDifference) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            this.currentTask = new ShowDiffTask(header, revision1, revision2, showLastDifference);
            this.currentShowDiffTask = RequestProcessor.getDefault().create((Runnable)this.currentTask);
            this.currentShowDiffTask.schedule(0);
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    private void setDiffIndex(int idx, boolean showLastDifference) {
        this.currentIndex = idx;
        this.onSelectionshowLastDifference = showLastDifference;
        this.treeView.setSelection(idx);
    }

    private void showRevisionDiff(SearchHistoryPanel.DispRevision rev, boolean showLastDifference) {
        String revision2 = rev.getRevision().getNumber();
        String revision1 = Utils.previousRevision(revision2);
        this.showDiff(rev.getRevision().getLogInfoHeader(), revision1, revision2, showLastDifference);
    }

    private void showContainerDiff(SearchHistoryPanel.ResultsContainer container, boolean showLastDifference) {
        List revs = container.getRevisions();
        SearchHistoryPanel.DispRevision newest = (SearchHistoryPanel.DispRevision)revs.get(0);
        this.showDiff(newest.getRevision().getLogInfoHeader(), container.getEldestRevision(), newest.getRevision().getNumber(), showLastDifference);
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(SearchHistoryPanel.DispRevision revision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(revision);
    }

    void select(SearchHistoryPanel.ResultsContainer container) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(container);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    implements Runnable,
    Cancellable {
        private final LogInformation header;
        private final String revision1;
        private final String revision2;
        private boolean showLastDifference;
        private volatile boolean cancelled;
        private Thread thread;

        public ShowDiffTask(LogInformation header, String revision1, String revision2, boolean showLastDifference) {
            this.header = header;
            this.revision1 = revision1;
            this.revision2 = revision2;
            this.showLastDifference = showLastDifference;
        }

        public void run() {
            this.thread = Thread.currentThread();
            final Diff diff = Diff.getDefault();
            final DiffStreamSource s1 = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1);
            final DiffStreamSource s2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2);
            s1.getMIMEType();
            if (this.cancelled) {
                return;
            }
            s2.getMIMEType();
            if (this.cancelled) {
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.cancelled) {
                            return;
                        }
                        DiffView view = diff.createDiff((StreamSource)s1, (StreamSource)s2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = view;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getComponent());
                            if (DiffResultsView.this.currentDiff.getDifferenceCount() > 0) {
                                DiffResultsView.this.currentDifferenceIndex = ShowDiffTask.this.showLastDifference ? DiffResultsView.this.currentDiff.getDifferenceCount() - 1 : 0;
                                DiffResultsView.this.currentDiff.setCurrentDifference(DiffResultsView.this.currentDifferenceIndex);
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            });
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            return true;
        }
    }
}

