/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.debugger.ui.Utils;
import org.openide.util.NbBundle;

public class DebuggerAction
extends AbstractAction {
    private Object action;

    private DebuggerAction(Object action) {
        this.action = action;
        new Listener(this);
        this.setEnabled(DebuggerAction.getCurrentActionsManager().isEnabled(this.getAction()));
    }

    public Object getAction() {
        return this.action;
    }

    public Object getValue(String key) {
        if (key == "Name") {
            return NbBundle.getMessage((Class)DebuggerAction.class, (String)((String)super.getValue(key)));
        }
        Object value = super.getValue(key);
        if (key == "SmallIcon" && value instanceof String) {
            value = Utils.getIcon((String)value);
        }
        return value;
    }

    public void actionPerformed(ActionEvent evt) {
        DebuggerAction.getCurrentActionsManager().postAction(this.getAction());
    }

    private static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    public static DebuggerAction createContinueAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_CONTINUE);
        action.putValue("Name", "CTL_Continue_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Continue");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Continue.gif");
        return action;
    }

    public static DebuggerAction createFixAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_FIX);
        action.putValue("Name", "CTL_Fix_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Fix");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Fix.gif");
        return action;
    }

    public static DebuggerAction createKillAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_KILL);
        action.putValue("Name", "CTL_KillAction_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Kill");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Kill.gif");
        action.setEnabled(false);
        return action;
    }

    public static DebuggerAction createMakeCalleeCurrentAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLEE_CURRENT);
        action.putValue("Name", "CTL_MakeCalleeCurrentAction_name");
        return action;
    }

    public static DebuggerAction createMakeCallerCurrentAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
        action.putValue("Name", "CTL_MakeCallerCurrentAction_name");
        return action;
    }

    public static DebuggerAction createPauseAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_PAUSE);
        action.putValue("Name", "CTL_Pause_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/Pause");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/Pause.gif");
        return action;
    }

    public static DebuggerAction createPopTopmostCallAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_POP_TOPMOST_CALL);
        action.putValue("Name", "CTL_PopTopmostCallAction_name");
        return action;
    }

    public static DebuggerAction createRunIntoMethodAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_RUN_INTO_METHOD);
        action.putValue("Name", "CTL_Run_into_method_action_name");
        return action;
    }

    public static DebuggerAction createRunToCursorAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_RUN_TO_CURSOR);
        action.putValue("Name", "CTL_Run_to_cursor_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/RunToCursor");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/RunToCursor.gif");
        return action;
    }

    public static DebuggerAction createStepIntoAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_INTO);
        action.putValue("Name", "CTL_Step_into_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepInto");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepInto.gif");
        return action;
    }

    public static DebuggerAction createStepOutAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_OUT);
        action.putValue("Name", "CTL_Step_out_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOut");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOut.gif");
        return action;
    }

    public static DebuggerAction createStepOverAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_STEP_OVER);
        action.putValue("Name", "CTL_Step_over_action_name");
        action.putValue("SmallIcon", "org/netbeans/modules/debugger/resources/actions/StepOver");
        action.putValue("iconBase", "org/netbeans/modules/debugger/resources/actions/StepOver.gif");
        return action;
    }

    public static DebuggerAction createToggleBreakpointAction() {
        DebuggerAction action = new DebuggerAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        action.putValue("Name", "CTL_Toggle_breakpoint");
        return action;
    }

    static class Listener
    extends DebuggerManagerAdapter
    implements ActionsManagerListener {
        private ActionsManager currentActionsManager;
        private WeakReference ref;

        Listener(DebuggerAction da) {
            this.ref = new WeakReference<DebuggerAction>(da);
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.updateCurrentActionsManager();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            final DebuggerAction da = this.getDebuggerAction();
            if (da == null) {
                return;
            }
            this.updateCurrentActionsManager();
            final boolean en = this.currentActionsManager.isEnabled(da.getAction());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    da.setEnabled(en);
                }
            });
        }

        public void actionPerformed(Object action) {
        }

        public void actionStateChanged(Object action, final boolean enabled) {
            final DebuggerAction da = this.getDebuggerAction();
            if (da == null) {
                return;
            }
            if (action != da.getAction()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    da.setEnabled(enabled);
                }
            });
        }

        private void updateCurrentActionsManager() {
            ActionsManager newActionsManager = DebuggerAction.getCurrentActionsManager();
            if (this.currentActionsManager == newActionsManager) {
                return;
            }
            if (this.currentActionsManager != null) {
                this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            if (newActionsManager != null) {
                newActionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            this.currentActionsManager = newActionsManager;
        }

        private DebuggerAction getDebuggerAction() {
            DebuggerAction da = (DebuggerAction)this.ref.get();
            if (da == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
                if (this.currentActionsManager != null) {
                    this.currentActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
                }
                this.currentActionsManager = null;
                return null;
            }
            return da;
        }
    }
}

