/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.editor.mimelookup.OldProxyLookup;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public final class MimeLookup
extends Lookup {
    private static DelegatingResult rootInitializers;
    private static final Map mime2lookup;
    private MimeLookup parent;
    private DelegatorLookup delegator;
    private final List initializersListeners = new ArrayList();
    private final List initializersList = new ArrayList();
    private final Map mime2childLookup = new HashMap();

    private MimeLookup(MimeLookup parent, String mimeType) {
        this.parent = parent;
        this.delegator = new DelegatorLookup();
        this.initMimeLookup(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeLookup getMimeLookup(String mimeType) {
        MimeLookup lookup;
        if (mimeType == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        Map map = mime2lookup;
        synchronized (map) {
            Reference ref = (Reference)mime2lookup.get(mimeType);
            MimeLookup mimeLookup = lookup = ref == null ? null : (MimeLookup)((Object)ref.get());
            if (lookup == null) {
                lookup = new MimeLookup(null, mimeType);
                mime2lookup.put(mimeType, new WeakReference<MimeLookup>(lookup));
            }
        }
        return lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeLookup childLookup(String mimeType) {
        MimeLookup lookup;
        if (mimeType == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        Map map = this.mime2childLookup;
        synchronized (map) {
            Reference ref = (Reference)this.mime2childLookup.get(mimeType);
            MimeLookup mimeLookup = lookup = ref == null ? null : (MimeLookup)((Object)ref.get());
            if (lookup == null) {
                lookup = new MimeLookup(this, mimeType);
                this.mime2childLookup.put(mimeType, new WeakReference<MimeLookup>(lookup));
            }
        }
        return lookup;
    }

    public Object lookup(Class clazz) {
        return this.delegator.lookup(clazz);
    }

    public Lookup.Result lookup(Lookup.Template template) {
        return this.delegator.lookup(template);
    }

    private void initMimeLookup(String mimeType) {
        Iterator initializersIterator;
        Iterator iterator = initializersIterator = this.parent == null ? MimeLookup.getRootInitializers().allInstances().iterator() : this.parent.initializersList.iterator();
        while (initializersIterator.hasNext()) {
            MimeLookupInitializer initializer = (MimeLookupInitializer)initializersIterator.next();
            Lookup.Result children = initializer.child(mimeType);
            Iterator childrenIt = children.allInstances().iterator();
            while (childrenIt.hasNext()) {
                this.initializersList.add(childrenIt.next());
            }
            this.initializersListeners.add(new InitializersListener(children));
        }
        if (this.parent == null) {
            this.initializersListeners.add(new InitializersListener(rootInitializers));
        }
        this.rebuildLookups();
    }

    private static DelegatingResult getRootInitializers() {
        if (rootInitializers == null) {
            rootInitializers = new DelegatingResult(Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class)));
        }
        return rootInitializers;
    }

    private void rebuildLookups() {
        ArrayList allLookups = new ArrayList();
        Iterator it = this.initializersListeners.iterator();
        while (it.hasNext()) {
            InitializersListener l = (InitializersListener)it.next();
            allLookups.addAll(l.getLookups());
        }
        Lookup[] all = new Lookup[allLookups.size()];
        allLookups.toArray(all);
        this.delegator.setDelegatorLookups(all);
    }

    static {
        mime2lookup = new HashMap();
    }

    private final class InitializersListener
    implements LookupListener {
        private Lookup.Result initializersResult;
        private List lookupList = Collections.EMPTY_LIST;
        private Map initializer2lookup = new HashMap();

        public InitializersListener(Lookup.Result initializersResult) {
            this.initializersResult = initializersResult;
            initializersResult.addLookupListener((LookupListener)this);
            this.rebuild(initializersResult.allInstances());
        }

        public synchronized List getLookups() {
            return this.lookupList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebuild(Collection newInitializers) {
            ArrayList<Lookup> lookups = new ArrayList<Lookup>();
            this.initializer2lookup.keySet().retainAll(newInitializers);
            Iterator it = newInitializers.iterator();
            while (it.hasNext()) {
                Object initializer = it.next();
                this.initializer2lookup.remove(initializer);
                Lookup lookup = ((MimeLookupInitializer)initializer).lookup();
                if (lookup == null) continue;
                this.initializer2lookup.put(initializer, lookup);
                lookups.add(lookup);
            }
            InitializersListener initializersListener = this;
            synchronized (initializersListener) {
                this.lookupList = lookups;
            }
        }

        public void resultChanged(LookupEvent ev) {
            Lookup.Result initializersResult = (Lookup.Result)ev.getSource();
            this.rebuild(initializersResult.allInstances());
            MimeLookup.this.rebuildLookups();
        }
    }

    private class DelegatorLookup
    extends OldProxyLookup {
        public void setDelegatorLookups(Lookup[] lookups) {
            this.setLookups(lookups);
        }
    }

    private static class DelegatingResult
    extends Lookup.Result {
        private final Lookup.Result delegator;
        private final Set listeners = new WeakSet(10);

        public DelegatingResult(Lookup.Result delegator) {
            this.delegator = delegator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(l);
            }
        }

        public Collection allInstances() {
            return this.delegator.allInstances();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged() {
            LookupListener[] _listeners;
            Set set = this.listeners;
            synchronized (set) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                _listeners = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            LookupEvent ev = new LookupEvent((Lookup.Result)this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].resultChanged(ev);
            }
        }
    }
}

