/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.HttpProxySettings;
import org.netbeans.modules.welcome.content.NoHorizontalScrollPanel;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.content.WebLink;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RSSFeed
extends JScrollPane
implements Constants,
PropertyChangeListener {
    protected static final int NEWS_COUNT = 10;
    private String url;
    private RequestProcessor.Task reloadTimer;
    private long lastReload = 0L;
    public static final String FEED_CONTENT_PROPERTY = "feedContent";
    private static DateFormat parsingDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private static DateFormat parsingDateFormatShort = new SimpleDateFormat("EEE, dd MMM yyyy", Locale.ENGLISH);
    private static DateFormat printingDateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static DateFormat printingDateFormatShort = DateFormat.getDateInstance(3);
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$org$netbeans$modules$welcome$content$RSSFeed;

    public RSSFeed(String url) {
        this.url = url;
        this.setBorder(null);
        this.setOpaque(false);
        this.setBackground(Utils.getColor("DefaultBackgroundColor"));
        this.getViewport().setBackground(Utils.getColor("DefaultBackgroundColor"));
        this.setViewportView(this.buildContentLoadingLabel());
        this.setHorizontalScrollBarPolicy(31);
        HttpProxySettings.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)HttpProxySettings.getDefault()));
    }

    RSSFeed() {
        this((String)null);
    }

    public void setContent(Component content) {
        this.setViewportView(content);
        this.setCursor(Cursor.getDefaultCursor());
        this.firePropertyChange(FEED_CONTENT_PROPERTY, null, content);
    }

    public Component getContent() {
        return this.getViewport().getView();
    }

    public void reload() {
        new Reload().start();
    }

    protected ArrayList buildItemList() throws SAXException, ParserConfigurationException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
        FeedHandler handler = new FeedHandler();
        reader.setContentHandler(handler);
        reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
        reader.setErrorHandler(new ErrorCatcher());
        reader.parse(new InputSource(this.url));
        return handler.getItemList();
    }

    protected static String getTextContent(Node node) {
        Node child = node.getFirstChild();
        if (null == child) {
            return null;
        }
        return child.getNodeValue();
    }

    protected String formatDateTime(String strDateTime) {
        try {
            Date date = parsingDateFormat.parse(strDateTime);
            return printingDateFormat.format(date);
        }
        catch (ParseException pE) {
            try {
                Date date = parsingDateFormatShort.parse(strDateTime);
                return printingDateFormatShort.format(date);
            }
            catch (ParseException parseException) {
                return strDateTime;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension retValue = super.getPreferredSize();
        retValue.width = 1;
        retValue.height = 1;
        return retValue;
    }

    public void removeNotify() {
        if (null != this.reloadTimer) {
            this.reloadTimer.cancel();
            this.reloadTimer = null;
        }
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        if (null == this.reloadTimer && !Boolean.getBoolean("netbeans.full.hack")) {
            if (System.currentTimeMillis() - this.lastReload >= 3600000L) {
                this.reload();
            } else {
                this.reloadTimer = RequestProcessor.getDefault().post((Runnable)new Reload(), (int)(3600000L - (System.currentTimeMillis() - this.lastReload)));
            }
        }
    }

    private String trimHtml(String htmlSnippet) {
        String res = htmlSnippet.replaceAll("<[^>]*>", "");
        res = res.replaceAll("&nbsp;", " ");
        res = res.trim();
        int maxLen = this.getMaxDecsriptionLength();
        if (res.length() > maxLen) {
            res = res.substring(0, maxLen) + "...";
        }
        return res;
    }

    protected int getMaxDecsriptionLength() {
        int verticalSize = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (verticalSize >= 1200) {
            return 350;
        }
        if (verticalSize >= 1024) {
            return 220;
        }
        return 140;
    }

    protected Component getContentHeader() {
        return null;
    }

    private JComponent buildProxyPanel() {
        Component header = this.getContentHeader();
        JPanel panel = null == header ? new JPanel(new GridBagLayout()) : new NoHorizontalScrollPanel();
        panel.setOpaque(false);
        int row = 0;
        if (null != header) {
            panel.add(header, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)new JLabel(BundleSupport.getLabel("ErrCannotConnect")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)BundleSupport.getLabel("ProxyConfig"));
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HttpProxySettings.getDefault().showConfigurationDialog();
            }
        });
        panel.add((Component)button, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        return panel;
    }

    private JComponent buildContentLoadingLabel() {
        JLabel label = new JLabel(BundleSupport.getLabel("ContentLoading"));
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setForeground(Utils.getColor("DefaultTextColor"));
        label.setBackground(Utils.getColor("DefaultBackgroundColor"));
        label.setOpaque(false);
        Component header = this.getContentHeader();
        if (null != header) {
            NoHorizontalScrollPanel panel = new NoHorizontalScrollPanel();
            panel.setOpaque(false);
            panel.add(header, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }
        return label;
    }

    private JComponent buildErrorLabel() {
        Component header = this.getContentHeader();
        JPanel panel = null == header ? new JPanel(new GridBagLayout()) : new NoHorizontalScrollPanel();
        panel.setOpaque(false);
        int row = 0;
        if (null != header) {
            panel.add(header, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)new JLabel(BundleSupport.getLabel("ErrLoadingFeed")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        JButton button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)BundleSupport.getLabel("Reload"));
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RSSFeed.this.reload();
            }
        });
        panel.add((Component)button, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
        return panel;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("ProxySettings".equals(evt.getPropertyName())) {
            this.setViewportView(this.buildContentLoadingLabel());
            this.reload();
        }
    }

    static class FeedItem {
        String title;
        String link;
        String description;
        String dateTime;

        FeedItem() {
        }

        boolean isValid() {
            return null != this.title && null != this.link;
        }
    }

    static class FeedHandler
    implements ContentHandler {
        private FeedItem currentItem;
        private StringBuffer textBuffer;
        private ArrayList itemList = new ArrayList(10);

        FeedHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.itemList.size() < 10) {
                if ("item".equals(localName)) {
                    this.currentItem = new FeedItem();
                } else if ("link".equals(localName) || "pubDate".equals(localName) || "date".equals(localName) || "description".equals(localName) || "title".equals(localName)) {
                    this.textBuffer = new StringBuffer(110);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.itemList.size() < 10) {
                if ("item".equals(localName)) {
                    if (null != this.currentItem && this.currentItem.isValid()) {
                        this.itemList.add(this.currentItem);
                    }
                    this.currentItem = null;
                } else if (null != this.currentItem && null != this.textBuffer) {
                    String text = this.textBuffer.toString().trim();
                    this.textBuffer = null;
                    if (0 == text.length()) {
                        text = null;
                    }
                    if ("link".equals(localName)) {
                        this.currentItem.link = text;
                    } else if ("pubDate".equals(localName) || "date".equals(localName)) {
                        this.currentItem.dateTime = text;
                    } else if ("title".equals(localName)) {
                        this.currentItem.title = text;
                    } else if ("description".equals(localName)) {
                        this.currentItem.description = text;
                    }
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (null != this.textBuffer) {
                this.textBuffer.append(ch, start, length);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public ArrayList getItemList() {
            return this.itemList;
        }
    }

    private class Reload
    extends Thread {
        private Reload() {
        }

        public void run() {
            try {
                RSSFeed.this.lastReload = System.currentTimeMillis();
                RSSFeed.this.setCursor(Cursor.getPredefinedCursor(3));
                ArrayList itemList = RSSFeed.this.buildItemList();
                final NoHorizontalScrollPanel contentPanel = new NoHorizontalScrollPanel();
                contentPanel.setOpaque(false);
                int contentRow = 0;
                Component header = RSSFeed.this.getContentHeader();
                if (null != header) {
                    contentPanel.add(header, new GridBagConstraints(0, contentRow++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                for (int i = 0; i < Math.min(itemList.size(), 10); ++i) {
                    FeedItem item = (FeedItem)itemList.get(i);
                    if (null == item.title || null == item.link) continue;
                    JPanel panel = new JPanel(new GridBagLayout());
                    panel.setOpaque(false);
                    int row = 0;
                    if (item.dateTime != null) {
                        JLabel label = new JLabel();
                        label.setFont(Constants.RSS_DESCRIPTION_FONT);
                        label.setForeground(Utils.getColor("RssDateTimeColor"));
                        label.setText(RSSFeed.this.formatDateTime(item.dateTime));
                        panel.add((Component)label, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 2, 10), 0, 0));
                    }
                    WebLink linkButton = new WebLink(item.title, item.link, true);
                    linkButton.setFont(Constants.HEADER_FONT);
                    panel.add((Component)linkButton, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 2, 10), 0, 0));
                    if (item.description != null) {
                        JLabel label = new JLabel();
                        label.setFont(Constants.RSS_DESCRIPTION_FONT);
                        label.setText("<html>" + RSSFeed.this.trimHtml(item.description));
                        panel.add((Component)label, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 15, 0, 10), 0, 0));
                    }
                    contentPanel.add((Component)panel, new GridBagConstraints(0, contentRow++, 1, 1, 1.0, 1.0, 18, 1, new Insets(contentRow == 1 ? 5 : 0, 0, 16, 0), 0, 0));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(contentPanel);
                    }
                });
                RSSFeed.this.reloadTimer = RequestProcessor.getDefault().post((Runnable)this, 3600000);
            }
            catch (UnknownHostException uhE) {
                RSSFeed.this.setCursor(Cursor.getDefaultCursor());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (SocketException sE) {
                RSSFeed.this.setCursor(Cursor.getDefaultCursor());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildProxyPanel());
                    }
                });
            }
            catch (Exception e) {
                RSSFeed.this.setCursor(Cursor.getDefaultCursor());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RSSFeed.this.setContent(RSSFeed.this.buildErrorLabel());
                    }
                });
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(Level level, SAXParseException e) {
            Logger l = Logger.getLogger((class$org$netbeans$modules$welcome$content$RSSFeed == null ? (class$org$netbeans$modules$welcome$content$RSSFeed = RSSFeed.class$("org.netbeans.modules.welcome.content.RSSFeed")) : class$org$netbeans$modules$welcome$content$RSSFeed).getName());
            l.log(level, "Line number:" + e.getLineNumber());
            l.log(level, "Column number:" + e.getColumnNumber());
            l.log(level, "Public ID:" + e.getPublicId());
            l.log(level, "System ID:" + e.getSystemId());
            l.log(level, "Error message:" + e.getMessage());
        }

        public void error(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }

        public void warning(SAXParseException e) {
            this.message(Level.WARNING, e);
        }

        public void fatalError(SAXParseException e) {
            this.message(Level.SEVERE, e);
        }
    }
}

