/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.macros.MacrosModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MacrosPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JTable tMacros = new JTable();
    private JScrollPane spTable = new JScrollPane(this.tMacros);
    private JEditorPane epMacro = new JEditorPane();
    private JButton bNew = new JButton();
    private JButton bRemove = new JButton();
    private JButton bShortcut = new JButton();
    private MacrosModel model;
    private boolean listen = true;
    private String currentMacro;
    private Lookup lookup;

    public MacrosPanel() {
        this.tMacros.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macros_Table"));
        this.tMacros.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macros_Table"));
        this.epMacro.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_Macro"));
        this.epMacro.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_Macro"));
        this.bRemove.setEnabled(false);
        this.bShortcut.setEnabled(false);
        MacrosPanel.loc(this.bNew, "New_Macro");
        MacrosPanel.loc(this.bRemove, "Remove_Macro");
        MacrosPanel.loc(this.bShortcut, "Shortcut");
        this.bNew.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.bShortcut.addActionListener(this);
        this.tMacros.getSelectionModel().setSelectionMode(0);
        this.tMacros.getSelectionModel().addListSelectionListener(this);
        this.tMacros.getTableHeader().setReorderingAllowed(false);
        this.spTable.setPreferredSize(new Dimension(10, 10));
        this.epMacro.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        this.epMacro.setPreferredSize(new Dimension(10, 10));
        JScrollPane spMacro = new JScrollPane(this.epMacro);
        spMacro.setPreferredSize(new Dimension(10, 10));
        JLabel lbMacros = new JLabel();
        MacrosPanel.loc(lbMacros, "Macro_List");
        lbMacros.setLabelFor(this.tMacros);
        JLabel lbMacroCode = new JLabel();
        MacrosPanel.loc(lbMacroCode, "Macro_Code");
        lbMacroCode.setLabelFor(this.epMacro);
        FormLayout layout = new FormLayout("200dlu:g, 5dlu, p", "p, 1dlu, p, 3dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g");
        layout.setRowGroups((int[][])new int[][]{{3, 7}});
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.add((Component)lbMacros, lc.xy(1, 1));
        builder.add((Component)this.spTable, cc.xywh(1, 3, 1, 6));
        builder.add((Component)this.bNew, cc.xy(3, 3));
        builder.add((Component)this.bShortcut, cc.xy(3, 5));
        builder.add((Component)this.bRemove, cc.xy(3, 7));
        builder.add((Component)lbMacroCode, lc.xy(1, 10));
        builder.add((Component)spMacro, cc.xy(1, 12));
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)MacrosPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(MacrosPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(MacrosPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)MacrosPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)MacrosPanel.loc("CTL_" + key));
        }
    }

    public void update() {
        this.model = new MacrosModel(this.lookup);
        this.listen = false;
        DefaultTableModel tableModel = this.model.getShortcutsTableModel();
        this.currentMacro = null;
        tableModel.setColumnIdentifiers(new String[]{MacrosPanel.loc("Macro_Name_Title"), MacrosPanel.loc("Macro_Code_Title")});
        this.tMacros.setModel(tableModel);
        this.listen = true;
        if (this.model.getMacroNames().size() > 0) {
            this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void applyChanges() {
        this.saveCurrentMacro();
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.cancel();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }

    void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.bNew) {
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(MacrosPanel.loc("CTL_Enter_macro_name"), MacrosPanel.loc("CTL_New_macro_dialog_title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.InputLine.OK_OPTION) {
                String macroName = descriptor.getInputText().trim();
                if (macroName.length() == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Empty_Macro_Name"), 0));
                } else {
                    Iterator it = this.model.getMacroNames().iterator();
                    boolean duplicate = false;
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        if (!macroName.equals(name)) continue;
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MacrosPanel.loc("CTL_Duplicate_Macro_Name"), 0));
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        this.listen = false;
                        this.model.addMacro(macroName, "");
                        this.listen = true;
                        this.tMacros.getSelectionModel().setSelectionInterval(0, 0);
                        this.spTable.getVerticalScrollBar().setValue(0);
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacro.requestFocus();
                }
            });
        } else if (e.getSource() == this.bRemove) {
            int index = this.tMacros.getSelectedRow();
            this.listen = false;
            this.model.removeMacro(index);
            this.listen = true;
            this.currentMacro = null;
            if (index < this.tMacros.getModel().getRowCount()) {
                this.tMacros.getSelectionModel().setSelectionInterval(index, index);
            } else if (this.tMacros.getModel().getRowCount() > 0) {
                this.tMacros.getSelectionModel().setSelectionInterval(this.tMacros.getModel().getRowCount() - 1, this.tMacros.getModel().getRowCount() - 1);
            } else {
                this.bRemove.setEnabled(false);
                this.bShortcut.setEnabled(false);
            }
        } else if (e.getSource() == this.bShortcut) {
            int index = this.tMacros.getSelectedRow();
            String shortcut = ShortcutsDialog.getShortcut((KeymapViewModel)this.lookup.lookup(KeymapViewModel.class));
            this.saveCurrentMacro();
            if (shortcut != null) {
                this.model.setShortcut(index, shortcut);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MacrosPanel.this.epMacro.requestFocus();
                }
            });
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.tMacros.getSelectedRow();
        if (index < 0) {
            this.epMacro.setText("");
            this.bRemove.setEnabled(false);
            this.bShortcut.setEnabled(false);
            return;
        }
        this.saveCurrentMacro();
        this.bRemove.setEnabled(true);
        this.bShortcut.setEnabled(true);
        String name = this.getCurrentMacro();
        String text = this.model.getMacroText(name);
        this.epMacro.setText(text);
        this.currentMacro = name;
    }

    private String getCurrentMacro() {
        int index = this.tMacros.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return (String)this.tMacros.getModel().getValueAt(index, 0);
    }

    private void saveCurrentMacro() {
        if (this.currentMacro == null) {
            return;
        }
        if (this.epMacro.getText().equals(this.model.getMacroText(this.currentMacro))) {
            return;
        }
        this.model.setMacroText(this.currentMacro, this.epMacro.getText());
        this.firePropertyChange("changed", null, null);
    }
}

