/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class J2SELibrarySourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final Map cache = new HashMap();
    private final Map normalizedURLCache = new HashMap();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery;

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = (SourceForBinaryQuery.Result)this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        boolean isNormalizedURL = J2SELibrarySourceForBinaryQuery.isNormalizedURL(binaryRoot);
        LibraryManager lm = LibraryManager.getDefault();
        Library[] libs = lm.getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            String type = libs[i].getType();
            if (!"j2se".equalsIgnoreCase(type)) continue;
            List classes = libs[i].getContent("classpath");
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                URL entry = (URL)it.next();
                URL normalizedEntry = isNormalizedURL ? this.getNormalizedURL(entry) : entry;
                if (normalizedEntry == null || !normalizedEntry.equals(binaryRoot)) continue;
                res = new Result(entry, libs[i]);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (J2SELibrarySourceForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = (URL)this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private ArrayList listeners;
        private FileObject[] cache;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Result(URL queryFor, Library lib) {
            this.entry = queryFor;
            this.lib = lib;
            this.lib.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = J2SELibrarySourceForBinaryQuery.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    List src = this.lib.getContent("src");
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    Iterator sit = src.iterator();
                    while (sit.hasNext()) {
                        FileObject sourceRootURL = URLMapper.findFileObject((URL)((URL)sit.next()));
                        if (sourceRootURL == null) continue;
                        result.add(sourceRootURL);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (!$assertionsDisabled && l == null) {
                throw new AssertionError((Object)"Listener cannot be null");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (!$assertionsDisabled && l == null) {
                throw new AssertionError((Object)"Listener cannot be null");
            }
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator it = null;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery == null ? (class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery = J2SELibrarySourceForBinaryQuery.class$("org.netbeans.modules.java.j2seplatform.libraries.J2SELibrarySourceForBinaryQuery")) : class$org$netbeans$modules$java$j2seplatform$libraries$J2SELibrarySourceForBinaryQuery).desiredAssertionStatus();
        }
    }
}

