/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.fileupload;

import java.io.Serializable;
import java.util.Date;

public class FileUploadStatus
implements Serializable {
    public static final String UPLOAD_ERROR = "Error";
    public static final String NOT_RUNNING = "Not Running";
    public static final String WRITING_DATA = "Writing upload data";
    public static final String READING_DATA = "Reading upload data";
    public static final String UPLOAD_COMPLETED = "Upload Completed";
    private String name = "";
    private String currentItem = "";
    private String status = "Reading upload data";
    private String message = "Currently Uploading File(s)";
    private long totalUploadSize = 0L;
    private long currentSizeRead = 0L;
    private long currentSizeWritten = 0L;
    private Date startUploadDate = new Date();
    private Date endUploadDate = null;
    boolean customReturnEnabled = false;

    public FileUploadStatus() {
    }

    public FileUploadStatus(String compName) {
        this.name = compName;
    }

    public FileUploadStatus(String compName, long totSize, long currLoadedSize, Date startDate) {
        this.name = compName;
        this.totalUploadSize = totSize;
        this.currentSizeRead = currLoadedSize;
        this.startUploadDate = startDate;
        this.status = READING_DATA;
    }

    public void reset() {
        this.name = "";
        this.currentItem = "";
        this.status = READING_DATA;
        this.message = "Currently Uploading File(s)";
        this.totalUploadSize = 0L;
        this.currentSizeRead = 0L;
        this.currentSizeWritten = 0L;
        this.startUploadDate = new Date();
        this.endUploadDate = null;
        this.customReturnEnabled = false;
    }

    public void enableCustomReturn() {
        this.customReturnEnabled = true;
    }

    public void setCustomReturnEnabled(boolean customReturnx) {
        this.customReturnEnabled = customReturnx;
    }

    public boolean getCustomReturnEnabled() {
        return this.customReturnEnabled;
    }

    public boolean isCustomReturnEnabled() {
        return this.customReturnEnabled;
    }

    public void setName(String namex) {
        this.name = namex;
    }

    public String getName() {
        return this.name;
    }

    public void setMessage(String mess) {
        this.message = mess;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(String stat) {
        this.status = stat;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStartUploadDate(Date start) {
        this.startUploadDate = start;
    }

    public Date getStartUploadDate() {
        return this.startUploadDate;
    }

    public void setEndUploadDate(Date end) {
        this.endUploadDate = end;
    }

    public Date getEndUploadDate() {
        return this.endUploadDate;
    }

    public void setCurrentItem(String item) {
        this.currentItem = item;
    }

    public String getCurrentItem() {
        return this.currentItem;
    }

    public void setTotalUploadSize(long size) {
        this.totalUploadSize = size;
    }

    public long getTotalUploadSize() {
        return this.totalUploadSize;
    }

    public void incrementCurrentSizeRead(int size) {
        this.currentSizeRead += (long)size;
    }

    public void incrementCurrentSizeRead(long size) {
        this.currentSizeRead += size;
    }

    public long getCurrentSizeRead() {
        return this.currentSizeRead;
    }

    public int getPercentageRead() {
        float perc = new Long(this.currentSizeRead).floatValue() / new Long(this.totalUploadSize).floatValue() * 100.0f;
        return new Float(perc).intValue();
    }

    public void setReadingComplete() {
        this.status = WRITING_DATA;
        this.currentSizeRead = this.totalUploadSize;
    }

    public void incrementCurrentSizeWritten(int size) {
        this.currentSizeWritten += (long)size;
    }

    public void incrementCurrentSizeWritten(long size) {
        this.currentSizeWritten += size;
    }

    public long getCurrentSizeWritten() {
        return this.currentSizeWritten;
    }

    public int getPercentageWritten() {
        float perc = new Long(this.currentSizeWritten).floatValue() / new Long(this.totalUploadSize).floatValue() * 100.0f;
        return new Float(perc).intValue();
    }

    public long getUploadTime() {
        long endTime = this.endUploadDate == null ? new Date().getTime() : this.endUploadDate.getTime();
        return endTime - this.startUploadDate.getTime();
    }

    public String getUploadTimeString() {
        long duration = this.getUploadTime();
        return this.formatTimeAsString(duration);
    }

    public int getPercentageComplete() {
        return (this.getPercentageRead() + this.getPercentageWritten()) / 2;
    }

    public long getEstimatedFinishTime() {
        float perc = new Integer((this.getPercentageRead() + this.getPercentageWritten()) / 2).floatValue();
        float timeLeft = 0.0f;
        if (perc > 0.0f) {
            timeLeft = new Long(this.getUploadTime()).floatValue() / perc * (100.0f - perc);
        }
        return new Float(timeLeft).longValue();
    }

    public String getEstimatedFinishTimeString() {
        long duration = this.getEstimatedFinishTime();
        return this.formatTimeAsString(duration);
    }

    public String formatTimeAsString(long duration) {
        StringBuffer sb = new StringBuffer();
        long hours = duration / 3600000L;
        long remainder = duration % 3600000L;
        long minutes = remainder / 60000L;
        float seconds = new Long(remainder).floatValue() % 60000.0f / 1000.0f;
        if (hours == 1L) {
            sb.append(String.valueOf(hours));
            sb.append(" hour ");
        } else if (hours > 1L) {
            sb.append(String.valueOf(hours));
            sb.append(" hours ");
        }
        if (minutes == 1L) {
            sb.append(String.valueOf(minutes));
            sb.append(" minute ");
        } else if (minutes > 1L) {
            sb.append(String.valueOf(minutes));
            sb.append(" minutes ");
        }
        if (seconds > 0.0f) {
            sb.append(String.valueOf(seconds));
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    public void setUploadComplete() {
        this.currentSizeRead = this.totalUploadSize;
        this.currentSizeWritten = this.totalUploadSize;
        this.currentItem = "";
        this.status = UPLOAD_COMPLETED;
        this.message = "File Upload has Completed Successfully!";
        this.endUploadDate = new Date();
    }

    public void setUploadError(String error) {
        this.currentItem = "";
        this.status = UPLOAD_ERROR;
        this.message = error;
        this.endUploadDate = new Date();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nComponent Name:");
        sb.append(this.name);
        sb.append(" - Status:");
        sb.append(this.status);
        sb.append(" - Message:");
        sb.append(this.message);
        sb.append(" - CurrentUploadItem:");
        sb.append(this.currentItem);
        sb.append(" - TotalUploadSize:");
        sb.append(this.totalUploadSize);
        sb.append(" - CurrentSizeUploaded:");
        sb.append(this.currentSizeRead);
        sb.append(" - CurrentSizeWritten:");
        sb.append(this.currentSizeWritten);
        sb.append(" - StartDate:");
        sb.append(this.startUploadDate);
        sb.append(" - EndDate:");
        sb.append(this.endUploadDate);
        sb.append(" - PercentageRead:");
        sb.append(this.getPercentageRead());
        sb.append(" - PercentageWritten:");
        sb.append(this.getPercentageWritten());
        sb.append(" - PercentageCompleted:");
        sb.append(this.getPercentageComplete());
        sb.append(" - UploadTime:");
        sb.append(this.getUploadTimeString());
        sb.append(" - EstimatedFinishTime:");
        sb.append(this.getEstimatedFinishTimeString());
        return sb.toString();
    }
}

