/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleDeleterImpl
implements ModuleDeleter {
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String UPDATE_TRACKING = "update_tracking";
    private static final String INST_ORIGIN = "updater";
    private static final boolean ONLY_FROM_AUTOUPDATE = false;
    private static final int TIME_TO_CHECK = 2000;
    private static final int MAX_CHECKS_OF_STATE = 50;
    private static final int HOLD_ON_PROPAGATE_DISABLE = 1000;
    private ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate.ModuleDeleterImpl");
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean canDelete(Module module) {
        if (module.isFixed()) {
            this.err.log("Cannot delete module because module " + module.getCodeName() + " isFixed.");
        }
        return !module.isFixed() && this.findUpdateTracking(module, false);
    }

    public void delete(final Module module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException("Module argument cannot be null.");
        }
        this.err.log("Find and delete " + module.getCodeNameBase() + " module config file.");
        this.removeControlModuleFile(module);
        RequestProcessor.Task cleaner = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                try {
                    ModuleDeleterImpl.this.removeModuleFiles(module);
                }
                catch (IOException ioe) {
                    ModuleDeleterImpl.this.err.annotate((Throwable)ioe, "ERROR: During processing removeModuleFiles (" + module.getDisplayName() + ")");
                    ModuleDeleterImpl.this.err.notify((Throwable)ioe);
                }
            }
        });
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new HackModuleListRefresher());
        }
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new ModuleStateChecker(module, cleaner), 2000);
        } else {
            cleaner.run();
        }
    }

    private File locateControlFile(Module m) {
        String configFile = "config/Modules/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(configFile, m.getCodeNameBase(), false);
    }

    private void removeControlModuleFile(Module m) throws IOException {
        File configFile = null;
        while ((configFile = this.locateControlFile(m)) != null) {
            if (configFile != null && configFile.exists()) {
                this.err.log("Try detele the config File " + configFile);
                FileUtil.toFileObject((File)configFile).delete();
                continue;
            }
            this.err.log("Warning: Config File " + configFile + " doesn't exist!");
        }
    }

    private File locateUpdateTracking(Module m) {
        String fileNameToFind = "update_tracking/" + m.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(fileNameToFind, m.getCodeNameBase(), false);
    }

    private boolean findUpdateTracking(Module module, boolean checkIfFromAutoupdate) {
        File updateTracking = this.locateUpdateTracking(module);
        if (updateTracking != null && updateTracking.exists()) {
            if (!updateTracking.getParentFile().canWrite()) {
                this.err.log("Cannot delete module " + module.getCodeName() + " because no write permission to directory " + updateTracking.getParent());
                return false;
            }
            if (checkIfFromAutoupdate) {
                boolean isFromAutoupdate = this.fromAutoupdate(this.getModuleConfiguration(updateTracking));
                this.err.log("Is Module " + module.getCodeName() + " installed by AutoUpdate? " + isFromAutoupdate);
                return isFromAutoupdate;
            }
            return true;
        }
        this.err.log("Cannot delete module " + module.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private boolean fromAutoupdate(Node moduleNode) {
        Node attrOrigin = moduleNode.getAttributes().getNamedItem(ATTR_ORIGIN);
        if (!$assertionsDisabled && attrOrigin == null) {
            throw new AssertionError((Object)"ELEMENT_VERSION must contain ATTR_ORIGIN attribute.");
        }
        String origin = attrOrigin.getNodeValue();
        return INST_ORIGIN.equals(origin);
    }

    private void removeModuleFiles(Module m) throws IOException {
        File updateTracking = null;
        while ((updateTracking = this.locateUpdateTracking(m)) != null) {
            this.removeModuleFilesInCluster(m, updateTracking);
        }
    }

    private void removeModuleFilesInCluster(Module module, File updateTracking) throws IOException {
        this.err.log("Read update_tracking " + updateTracking + " file.");
        Set moduleFiles = this.readModuleFiles(this.getModuleConfiguration(updateTracking));
        String configFile = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        if (moduleFiles.contains(configFile)) {
            File file = InstalledFileLocator.getDefault().locate(configFile, module.getCodeNameBase(), false);
            if (!$assertionsDisabled && file != null && file.exists()) {
                throw new AssertionError((Object)("Config file " + configFile + " must be already removed."));
            }
        }
        Iterator it = moduleFiles.iterator();
        while (it.hasNext()) {
            File file;
            String fileName = (String)it.next();
            if (fileName.equals(configFile) || (file = InstalledFileLocator.getDefault().locate(fileName, module.getCodeNameBase(), false)).equals(updateTracking)) continue;
            if (!$assertionsDisabled && !file.exists()) {
                throw new AssertionError((Object)("File " + file + " exists."));
            }
            if (!file.exists()) continue;
            this.err.log("File " + file + " is deleted.");
            try {
                FileUtil.toFileObject((File)file).delete();
            }
            catch (IOException ioe) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file."));
                }
                this.err.log("Waring: IOException " + ioe.getMessage() + " was caught. Propably file lock on the file.");
                this.err.log("Try call File.deleteOnExit() on " + file);
                file.deleteOnExit();
            }
        }
        FileUtil.toFileObject((File)updateTracking).delete();
        this.err.log("File " + updateTracking + " is deleted.");
    }

    private Node getModuleConfiguration(File moduleUpdateTracking) {
        Document document = null;
        try {
            FileInputStream is = new FileInputStream(moduleUpdateTracking);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException saxe) {
            ErrorManager.getDefault().notify(1, (Throwable)saxe);
            return null;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        if (!$assertionsDisabled && document.getDocumentElement() == null) {
            throw new AssertionError((Object)("File " + moduleUpdateTracking + " must contain <module> element."));
        }
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node lastElement = null;
        if (!$assertionsDisabled && !ELEMENT_MODULE.equals(element.getTagName())) {
            throw new AssertionError((Object)("The root element is: module but was: " + element.getTagName()));
        }
        NodeList listModuleVersions = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < listModuleVersions.getLength() && (lastElement = this.getModuleLastVersion(listModuleVersions.item(i))) == null; ++i) {
        }
        return lastElement;
    }

    private Node getModuleLastVersion(Node version) {
        Node attrLast = version.getAttributes().getNamedItem(ATTR_LAST);
        if (!$assertionsDisabled && attrLast == null) {
            throw new AssertionError((Object)"ELEMENT_VERSION must contain ATTR_LAST attribute.");
        }
        if (Boolean.valueOf(attrLast.getNodeValue()).booleanValue()) {
            return version;
        }
        return null;
    }

    private Set readModuleFiles(Node version) {
        HashSet<String> files = new HashSet<String>();
        NodeList fileNodes = version.getChildNodes();
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            if (!fileNodes.item(i).hasAttributes()) continue;
            NamedNodeMap map = fileNodes.item(i).getAttributes();
            files.add(map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            this.err.log("File to delete: " + map.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return files;
    }

    static {
        $assertionsDisabled = !ModuleDeleterImpl.class.desiredAssertionStatus();
    }

    private class HackModuleListRefresher
    implements Runnable {
        private HackModuleListRefresher() {
        }

        public void run() {
            FileObject modulesRoot = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
            ModuleDeleterImpl.this.err.log("It's a hack: Call refresh on " + modulesRoot + " file object.");
            if (modulesRoot != null) {
                modulesRoot.refresh();
            }
        }
    }

    private class ModuleStateChecker
    implements Runnable {
        RequestProcessor.Task cleaner;
        Module m;
        int checks;

        public ModuleStateChecker(Module module, RequestProcessor.Task filesCleaner) {
            this.cleaner = filesCleaner;
            this.m = module;
            this.checks = 0;
        }

        public void run() {
            ++this.checks;
            if (this.m.isEnabled() && this.m.isValid()) {
                if (this.checks < 50) {
                    ModuleDeleterImpl.this.err.log("Module " + this.m.getCodeNameBase() + " is still valid, repost later.");
                    RequestProcessor.getDefault().post((Runnable)this, 2000);
                } else {
                    ModuleDeleterImpl.this.err.log("Warning: Module " + this.m.getCodeNameBase() + " is still valid but time-out. Task is terminated.");
                }
                return;
            }
            this.cleaner.schedule(1000);
        }
    }
}

