/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel;
import org.netbeans.modules.autoupdate.catalog.ModuleUninstallPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ModuleNodeUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ModuleNodeUtils() {
    }

    private static Set getCategoryModules(Node category) {
        if (!$assertionsDisabled && category.isLeaf()) {
            throw new AssertionError((Object)("Parent " + category + " cannot be leaf."));
        }
        HashSet<Node> modules = new HashSet<Node>();
        Node[] chNodes = category.getChildren().getNodes(true);
        for (int i = 0; i < chNodes.length; ++i) {
            if (!(chNodes[i] instanceof ModuleNode.Item)) continue;
            modules.add(chNodes[i]);
        }
        return modules;
    }

    static Set getAllSelectedModuleItems(Node[] nodes) {
        HashSet<Node> modules = new HashSet<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof ModuleNode.Item) {
                modules.add(nodes[i]);
                continue;
            }
            if (nodes[i].isLeaf()) continue;
            modules.addAll(ModuleNodeUtils.getCategoryModules(nodes[i]));
        }
        return modules;
    }

    static Set getAllSelectedModuleBeans(Node[] nodes) {
        HashSet<ModuleBean> beans = new HashSet<ModuleBean>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof ModuleNode.Item) {
                beans.add(((ModuleNode.Item)nodes[i]).getItem());
                continue;
            }
            if (nodes[i].isLeaf()) continue;
            beans.addAll(ModuleNodeUtils.getAllSelectedModuleBeans(nodes[i].getChildren().getNodes(true)));
        }
        return beans;
    }

    static Boolean isEnableCandidate(Node[] nodes) {
        Iterator beans = ModuleNodeUtils.getAllSelectedModuleBeans(nodes).iterator();
        Boolean res = null;
        while (beans.hasNext()) {
            ModuleBean b = (ModuleBean)beans.next();
            if (res == null) {
                res = b.isEnabled() ? Boolean.FALSE : Boolean.TRUE;
                continue;
            }
            if (res.booleanValue() != b.isEnabled()) continue;
            return null;
        }
        return res;
    }

    static boolean isEnableAllowed(Module m) {
        if (!m.isValid()) {
            return false;
        }
        return m.getProblems().isEmpty() && !m.isAutoload() && !m.isEager() && m.getJarFile() != null;
    }

    static String getUninstallActionName(Node[] activatedNodes, String oldName) {
        String name;
        if (activatedNodes == null || activatedNodes.length == 0) {
            return oldName;
        }
        if (activatedNodes.length == 1 && !(activatedNodes[0] instanceof ModuleNode.Item)) {
            name = NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)activatedNodes[0].getDisplayName());
        } else {
            Set items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
            name = NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)(items.size() > 1 ? NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction_many") : ((ModuleNode.Item)items.iterator().next()).getDisplayName()));
        }
        return name;
    }

    static boolean canUninstall(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        Set items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
        boolean res = !items.isEmpty();
        Iterator it = items.iterator();
        String moduleName = null;
        while (res && it.hasNext()) {
            Object n = it.next();
            if (!$assertionsDisabled && !(n instanceof ModuleNode.Item)) {
                throw new AssertionError((Object)("Object " + n + " is instanceof ModuleNode.Item"));
            }
            Module m = ((ModuleNode.Item)n).getItem().getModule();
            res = res && ((Node)n).canDestroy();
            moduleName = m.getDisplayName();
        }
        return res;
    }

    static void doUninstall(final Node[] activatedNodes) {
        if (ModuleNodeUtils.confirmUninstall(activatedNodes)) {
            ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ModuleNodeUtils.uninstallNodes(activatedNodes);
                }
            });
        }
    }

    static boolean confirmUninstall(Node[] activatedNodes) {
        if (!$assertionsDisabled && activatedNodes == null) {
            throw new AssertionError((Object)"Any ModuleNode must be selected");
        }
        Set items = ModuleNodeUtils.getAllSelectedModuleItems(activatedNodes);
        if (!$assertionsDisabled && items.isEmpty()) {
            throw new AssertionError((Object)"Any module must be selected");
        }
        String category = null;
        if (activatedNodes.length == 1 && !(activatedNodes[0] instanceof ModuleNode.Item)) {
            category = activatedNodes[0].getDisplayName();
        }
        Iterator it = items.iterator();
        HashSet<Module> modules = new HashSet<Module>(items.size());
        while (it.hasNext()) {
            modules.add(((ModuleNode.Item)it.next()).getItem().getModule());
        }
        ModuleUninstallPanel c = new ModuleUninstallPanel(modules, category);
        ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"ACD_ModuleUninstallPanel_form"));
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"CTL_ModuleUninstallPanel_UninstallConfirmation"), 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
    }

    private static void uninstallNodes(Node[] nodes) {
        if (!$assertionsDisabled && nodes == null) {
            throw new AssertionError((Object)"uninstallNodes cannot be called on null nodes.");
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].isLeaf()) {
                if (!$assertionsDisabled && !(nodes[i] instanceof ModuleNode.Item)) {
                    throw new AssertionError((Object)("Node " + nodes[i] + " instanceof ModuleNode.Item"));
                }
                ((ModuleNode.Item)nodes[i]).uninstall();
                continue;
            }
            ModuleNodeUtils.uninstallNodes(nodes[i].getChildren().getNodes(true));
        }
    }

    static {
        $assertionsDisabled = !ModuleNodeUtils.class.desiredAssertionStatus();
    }
}

