/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.UIManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class Utils {
    private static final String[] javaKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String JSP_PACKAGE_NAME = "org.apache.jsp";
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String SPECIFICATION_J2SE = "j2se";

    public static File getRoot(File f) {
        File rootF = f;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        return rootF;
    }

    public static FileObject getValidDir(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            Utils.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    public static FileObject getValidEmptyDir(File dir) throws IOException {
        FileObject fo = Utils.getValidDir(dir);
        if (fo.getChildren().length != 0) {
            throw new IOException("Dir has to be empty: " + dir);
        }
        return fo;
    }

    public static String createDefaultContext(String projectName) {
        return "/" + PropertyUtils.getUsablePropertyName((String)projectName);
    }

    public static void updateProperties(AntProjectHelper h, String path, EditableProperties ep) {
        EditableProperties properties = h.getProperties(path);
        properties.putAll((Map)ep);
        h.putProperties(path, properties);
    }

    public static boolean isParentOrEqual(File folder, File file) {
        if (folder != null || file != null) {
            folder = FileUtil.normalizeFile((File)folder);
            for (file = FileUtil.normalizeFile((File)file); file != null; file = file.getParentFile()) {
                if (!file.equals(folder)) continue;
                return true;
            }
        }
        return false;
    }

    public static JavaPlatform findJ2seJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, SPECIFICATION_J2SE);
    }

    public static JavaPlatform findJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, null);
    }

    private static JavaPlatform findJavaPlatform(String platformName, String specFilter) {
        if (platformName != null) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                JavaPlatform platform = platforms[i];
                String antName = (String)platform.getProperties().get(PLATFORM_ANT_NAME);
                if (antName == null || !antName.equals(platformName) || specFilter != null && !specFilter.equalsIgnoreCase(platform.getSpecification().getName())) continue;
                return platform;
            }
        }
        return null;
    }

    static String getGeneratedJavaResource(String jspUri) {
        int iSep = jspUri.lastIndexOf(47);
        String packageName = iSep > 0 ? Utils.makeJavaPackage(jspUri.substring(0, iSep)) : "";
        packageName = packageName.length() == 0 ? JSP_PACKAGE_NAME : "org.apache.jsp." + packageName;
        String className = Utils.makeJavaIdentifier(jspUri.substring(iSep + 1));
        return packageName.replace('.', '/') + "/" + className + ".java";
    }

    private static final String makeJavaPackage(String path) {
        String[] classNameComponents = Utils.split(path, "/");
        StringBuffer legalClassNames = new StringBuffer();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(Utils.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static final String[] split(String path, String pat) {
        Vector<String> comps = new Vector<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.elementAt(i);
        }
        return result;
    }

    private static final String makeJavaIdentifier(String identifier) {
        StringBuffer modifiedIdentifier = new StringBuffer(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(Utils.mangleChar(ch));
        }
        if (Utils.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    public static Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        return c == null ? new Color(89, 79, 191) : c;
    }

    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(":");
        }
        return classpath.toString();
    }
}

