/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.ui.customizer.PlatformUiSupport;
import org.netbeans.modules.web.project.ui.wizards.FileSearchUtility;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebProjectUtilities {
    public static final String SRC_STRUCT_BLUEPRINTS = "BluePrints";
    public static final String SRC_STRUCT_JAKARTA = "Jakarta";
    private static final String DEFAULT_DOC_BASE_FOLDER = "web";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_CONF_FOLDER = "conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String WEB_INF = "WEB-INF";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    public static final String MINIMUM_ANT_VERSION = "1.6";

    private WebProjectUtilities() {
    }

    @Deprecated
    public static AntProjectHelper createProject(File dir, String name, String serverInstanceID, String sourceStructure, String j2eeLevel, String contextPath) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setServerInstanceID(serverInstanceID);
        createData.setSourceStructure(sourceStructure);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setContextPath(contextPath);
        return WebProjectUtilities.createProject(createData);
    }

    public static AntProjectHelper createProject(WebProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        String name = createData.getName();
        String serverInstanceID = createData.getServerInstanceID();
        String sourceStructure = createData.getSourceStructure();
        String j2eeLevel = createData.getJavaEEVersion();
        String contextPath = createData.getContextPath();
        String javaPlatformName = createData.getJavaPlatformName();
        String sourceLevel = createData.getSourceLevel();
        assert (dir != null) : "Project folder can't be null";
        assert (name != null) : "Project name can't be null";
        assert (serverInstanceID != null) : "Server instance ID can't be null";
        assert (sourceStructure != null) : "Source structure can't be null";
        assert (j2eeLevel != null) : "Java EE version can't be null";
        boolean createBluePrintsStruct = SRC_STRUCT_BLUEPRINTS.equals(sourceStructure);
        boolean createJakartaStructure = SRC_STRUCT_JAKARTA.equals(sourceStructure);
        FileObject fo = Utils.getValidEmptyDir(dir);
        AntProjectHelper h = WebProjectUtilities.setupProject(fo, name, serverInstanceID, j2eeLevel);
        FileObject srcFO = fo.createFolder(DEFAULT_SRC_FOLDER);
        FileObject confFolderFO = null;
        if (createBluePrintsStruct) {
            srcFO.createFolder(DEFAULT_JAVA_FOLDER);
            confFolderFO = srcFO.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (createJakartaStructure) {
            confFolderFO = fo.createFolder(DEFAULT_CONF_FOLDER);
        }
        if (confFolderFO != null) {
            FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/MANIFEST.MF"), (FileObject)confFolderFO, (String)"MANIFEST");
        }
        FileUtil.createFolder((FileObject)fo, (String)DEFAULT_TEST_FOLDER);
        FileObject webFO = fo.createFolder(DEFAULT_DOC_BASE_FOLDER);
        final FileObject webInfFO = webFO.createFolder(WEB_INF);
        String webXMLContent = null;
        if ("1.5".equals(j2eeLevel)) {
            webXMLContent = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.5.xml").getInputStream());
        } else if ("1.4".equals(j2eeLevel)) {
            webXMLContent = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.4.xml").getInputStream());
        } else if ("1.3".equals(j2eeLevel)) {
            webXMLContent = WebProjectUtilities.readResource(Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-web-project/web-2.3.xml").getInputStream());
        }
        assert (webXMLContent != null) : "Cannot find web.xml template for J2EE specification level:" + j2eeLevel;
        final String webXmlText = webXMLContent;
        FileSystem fs = webInfFO.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject webXML = FileUtil.createData((FileObject)webInfFO, (String)"web.xml");
                FileLock lock = webXML.lock();
                try {
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(webXML.getOutputStream(lock)));
                    bw.write(webXmlText);
                    bw.close();
                }
                finally {
                    lock.releaseLock();
                }
            }
        });
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
        Element rootSrc = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        rootSrc.setAttribute("id", "src.dir");
        rootSrc.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
        sourceRoots.appendChild(rootSrc);
        if (createBluePrintsStruct) {
            ep.setProperty("src.dir", "src/java");
        } else {
            ep.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
        Element rootTest = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
        rootTest.setAttribute("id", "test.src.dir");
        rootTest.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
        testRoots.appendChild(rootTest);
        ep.setProperty("test.src.dir", DEFAULT_TEST_FOLDER);
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.put((Object)"source.root", (Object)(createBluePrintsStruct ? DEFAULT_SRC_FOLDER : "."));
        ep.setProperty("web.docbase.dir", DEFAULT_DOC_BASE_FOLDER);
        if (createBluePrintsStruct) {
            ep.setProperty("src.dir", "${source.root}/java");
            ep.setProperty("conf.dir", "${source.root}/conf");
        } else {
            ep.setProperty("src.dir", DEFAULT_SRC_FOLDER);
        }
        if (createJakartaStructure) {
            ep.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        }
        ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        ep.setProperty("lib.dir", "${web.docbase.dir}/WEB-INF/lib");
        Project p = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        UpdateHelper updateHelper = ((WebProject)p).getUpdateHelper();
        PlatformUiSupport.storePlatform(ep, updateHelper, javaPlatformName, sourceLevel != null ? new SpecificationVersion(sourceLevel) : null);
        h.putProperties("nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject(p);
        WebProjectUtilities.createIndexJSP(webFO);
        ProjectWebModule pwm = (ProjectWebModule)p.getLookup().lookup(ProjectWebModule.class);
        if (pwm != null) {
            pwm.setContextPath(contextPath);
        }
        return h;
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, FileObject wmFO, FileObject javaRoot, FileObject docBase, FileObject libFolder, String j2eeLevel, String serverInstanceID, String buildfile) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setWebModuleFO(wmFO);
        createData.setSourceFolders(new File[]{FileUtil.toFile((FileObject)javaRoot)});
        createData.setTestFolders(null);
        createData.setDocBase(docBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setServerInstanceID(serverInstanceID);
        createData.setBuildfile(buildfile);
        return WebProjectUtilities.importProject(createData);
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, FileObject wmFO, File[] sourceFolders, File[] tstFolders, FileObject docBase, FileObject libFolder, String j2eeLevel, String serverInstanceID, String buildfile) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setWebModuleFO(wmFO);
        createData.setSourceFolders(sourceFolders);
        createData.setTestFolders(tstFolders);
        createData.setDocBase(docBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEVersion(j2eeLevel);
        createData.setServerInstanceID(serverInstanceID);
        createData.setBuildfile(buildfile);
        return WebProjectUtilities.importProject(createData);
    }

    public static AntProjectHelper importProject(WebProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        String name = createData.getName();
        FileObject wmFO = createData.getWebModuleFO();
        final File[] sourceFolders = createData.getSourceFolders();
        File[] tstFolders = createData.getTestFolders();
        FileObject docBase = createData.getDocBase();
        FileObject libFolder = createData.getLibFolder();
        String j2eeLevel = createData.getJavaEEVersion();
        String serverInstanceID = createData.getServerInstanceID();
        String buildfile = createData.getBuildfile();
        String javaPlatformName = createData.getJavaPlatformName();
        String sourceLevel = createData.getSourceLevel();
        boolean javaSourceBased = createData.getJavaSourceBased();
        assert (dir != null) : "Project folder can't be null";
        assert (name != null) : "Project name can't be null";
        assert (wmFO != null) : "File object representation of the imported web project location can't be null";
        assert (sourceFolders != null) : "Source package root can't be null";
        assert (docBase != null) : "Web Pages folder can't be null";
        assert (serverInstanceID != null) : "Server instance ID can't be null";
        assert (j2eeLevel != null) : "Java EE version can't be null";
        FileObject fo = Utils.getValidDir(dir);
        final AntProjectHelper antProjectHelper = WebProjectUtilities.setupProject(fo, name, serverInstanceID, j2eeLevel);
        final WebProject p = (WebProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        final ReferenceHelper referenceHelper = p.getReferenceHelper();
        EditableProperties ep = new EditableProperties(true);
        if (FileUtil.isParentOf((FileObject)fo, (FileObject)wmFO) || fo.equals(wmFO)) {
            ep.setProperty("source.root", ".");
        } else {
            ep.setProperty("source.root", referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)wmFO), null));
        }
        ep.setProperty("web.docbase.dir", WebProjectUtilities.createFileReference(referenceHelper, fo, wmFO, docBase));
        final File[] testFolders = tstFolders;
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    String propName;
                    int i;
                    Element data = antProjectHelper.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    data.appendChild(sourceRoots);
                    Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    data.appendChild(testRoots);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                    assert (nl.getLength() == 1);
                    sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "test-roots");
                    assert (nl.getLength() == 1);
                    testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        EditableProperties props = antProjectHelper.getProperties("nbproject/project.properties");
                        propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = referenceHelper.createForeignFileReference(sourceFolders[i], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                        Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                        root.setAttribute("id", propName);
                        root.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_src.dir"));
                        sourceRoots.appendChild(root);
                        props = antProjectHelper.getProperties("nbproject/project.properties");
                        props.put((Object)propName, (Object)srcReference);
                        antProjectHelper.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders == null || testFolders.length == 0) {
                        EditableProperties props = antProjectHelper.getProperties("nbproject/project.properties");
                        props.put((Object)"test.src.dir", (Object)"");
                        antProjectHelper.putProperties("nbproject/project.properties", props);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                testFolders[i].mkdirs();
                            }
                            String name = testFolders[i].getName();
                            propName = "test." + name + ".dir";
                            int rootIndex = 1;
                            EditableProperties props = antProjectHelper.getProperties("nbproject/project.properties");
                            while (props.containsKey((Object)propName)) {
                                propName = "test." + name + ++rootIndex + ".dir";
                            }
                            String testReference = referenceHelper.createForeignFileReference(testFolders[i], WebProjectUtilities.DEFAULT_JAVA_FOLDER);
                            Element root = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "root");
                            root.setAttribute("id", propName);
                            root.setAttribute("name", NbBundle.getMessage(WebProjectUtilities.class, (String)"NAME_test.src.dir"));
                            testRoots.appendChild(root);
                            props = antProjectHelper.getProperties("nbproject/project.properties");
                            props.put((Object)propName, (Object)testReference);
                            antProjectHelper.putProperties("nbproject/project.properties", props);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(data, true);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me);
        }
        if (libFolder != null) {
            ep.setProperty("lib.dir", WebProjectUtilities.createFileReference(referenceHelper, fo, wmFO, libFolder));
        }
        if (!"build.xml".equals(buildfile)) {
            ep.setProperty("buildfile", buildfile);
        }
        Enumeration ch = FileSearchUtility.getChildrenToDepth(fo, 4, true);
        String confDir = "";
        while (ch.hasMoreElements()) {
            FileObject f = (FileObject)ch.nextElement();
            if (!f.isFolder() || !f.getName().equalsIgnoreCase(DEFAULT_CONF_FOLDER)) continue;
            confDir = FileUtil.getRelativePath((FileObject)fo, (FileObject)f);
            break;
        }
        if (confDir.equals("")) {
            fo.createFolder(DEFAULT_CONF_FOLDER);
            ep.setProperty("conf.dir", DEFAULT_CONF_FOLDER);
        } else {
            ep.setProperty("conf.dir", confDir);
        }
        ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        ep.setProperty("java.source.based", javaSourceBased + "");
        UpdateHelper updateHelper = p.getUpdateHelper();
        PlatformUiSupport.storePlatform(ep, updateHelper, javaPlatformName, sourceLevel != null ? new SpecificationVersion(sourceLevel) : null);
        Utils.updateProperties(antProjectHelper, "nbproject/project.properties", ep);
        ProjectManager.getDefault().saveProject((Project)p);
        return antProjectHelper;
    }

    private static String createFileReference(ReferenceHelper refHelper, FileObject projectFO, FileObject sourceprojectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)projectFO, (FileObject)referencedFO)) {
            return WebProjectUtilities.relativePath(projectFO, referencedFO);
        }
        if (FileUtil.isParentOf((FileObject)sourceprojectFO, (FileObject)referencedFO)) {
            String s = WebProjectUtilities.relativePath(sourceprojectFO, referencedFO);
            return s.length() > 0 ? "${source.root}/" + s : SOURCE_ROOT_REF;
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject dirFO, String name, String serverInstanceID, String j2eeLevel) throws IOException {
        File[] wsClasspath;
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.web.project");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        Element wmLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-libraries");
        data.appendChild(wmLibs);
        Element addLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-module-additional-libraries");
        data.appendChild(addLibs);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.war", "${dist.dir}/${war.name}");
        ep.setProperty("dist.ear.war", "${dist.dir}/${war.ear.name}");
        ep.setProperty("javac.classpath", "");
        ep.setProperty("jspcompilation.classpath", "${jspc.classpath}:${javac.classpath}");
        ep.setProperty("j2ee.platform", j2eeLevel);
        ep.setProperty("war.name", PropertyUtils.getUsablePropertyName((String)name) + ".war");
        ep.setProperty("war.ear.name", PropertyUtils.getUsablePropertyName((String)name) + ".war");
        ep.setProperty("jar.compress", "false");
        ep.setProperty("war.package", "true");
        ep.setProperty("war.content.additional", "");
        ep.setProperty("client.urlPart", "");
        ep.setProperty("display.browser", "true");
        Deployment deployment = Deployment.getDefault();
        ep.setProperty("j2ee.server.type", deployment.getServerID(serverInstanceID));
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.web.dir", "${build.dir}/web");
        ep.setProperty("build.ear.web.dir", "${build.dir}/ear-module");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.dir", "${build.web.dir}/WEB-INF/classes");
        ep.setProperty("build.ear.classes.dir", "${build.ear.web.dir}/WEB-INF/classes");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("build.web.excludes", "${build.classes.excludes}");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("no.dependencies", "false");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}:${build.ear.classes.dir}");
        ep.setProperty("runmain.jvmargs", "");
        ep.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(WebProjectUtilities.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "");
        ep.setProperty("javadoc.preview", "true");
        ep.setProperty("javadoc.additionalparam", "");
        ep.setProperty("compile.jsps", "false");
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("j2ee.server.instance", serverInstanceID);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        if (!j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR).contains(j2eeLevel)) {
            ErrorManager.getDefault().log(16, "J2EE level:" + j2eeLevel + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID) + " for module type WAR");
        }
        String classpath = Utils.toClasspathString(j2eePlatform.getClasspathEntries());
        ep.setProperty("j2ee.platform.classpath", classpath);
        if (j2eePlatform.isToolSupported("wscompile")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wscompile");
            ep.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(wsClasspath));
        }
        if (j2eePlatform.isToolSupported("wsimport")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsimport");
            ep.setProperty("j2ee.platform.wsimport.classpath", Utils.toClasspathString(wsClasspath));
        }
        if (j2eePlatform.isToolSupported("wsgen")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsgen");
            ep.setProperty("j2ee.platform.wsgen.classpath", Utils.toClasspathString(wsClasspath));
        }
        if (j2eePlatform.isToolSupported("jsr109")) {
            ep.setProperty("j2ee.platform.is.jsr109", "true");
        }
        File projectFolder = FileUtil.toFile((FileObject)dirFO);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, "nbproject/ant-deploy.xml"), (Object)J2eeModule.WAR, (String)serverInstanceID);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
        if (deployAntPropsFile != null) {
            ep.setProperty("deploy.ant.properties.file", deployAntPropsFile.getAbsolutePath());
        }
        h.putProperties("nbproject/private/private.properties", ep);
        return h;
    }

    private static Element createLibraryElement(Document doc, String libraryName) {
        Element servletLib = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "library");
        Element servletLibName = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "file");
        servletLibName.appendChild(doc.createTextNode("${libs." + libraryName + ".classpath}"));
        servletLib.appendChild(servletLibName);
        return servletLib;
    }

    private static void createIndexJSP(FileObject webFolder) throws IOException {
        FileObject jspTemplate = Repository.getDefault().getDefaultFileSystem().findResource("Templates/JSP_Servlet/JSP.jsp");
        if (jspTemplate == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)jspTemplate);
        DataFolder webDf = DataFolder.findFolder((FileObject)webFolder);
        mt.createFromTemplate(webDf, "index");
    }

    private static String readResource(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }
}

