/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class WebProjectClassPathExtender
implements ProjectClassPathExtender,
PropertyChangeListener {
    private static final String CP_CLASS_PATH = "javac.classpath";
    private static final String DEFAULT_WEB_MODULE_ELEMENT_NAME = "web-module-libraries";
    private Project project;
    private UpdateHelper helper;
    private ReferenceHelper refHelper;
    private PropertyEvaluator eval;
    private ClassPathSupport cs;
    private volatile boolean projectDeleted;

    public WebProjectClassPathExtender(Project project, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper) {
        this.project = project;
        this.helper = helper;
        this.eval = eval;
        this.refHelper = refHelper;
        this.cs = new ClassPathSupport(eval, refHelper, helper.getAntProjectHelper(), WebProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.registerLibraryListeners();
    }

    public boolean addLibrary(Library library) throws IOException {
        return this.addLibraries(CP_CLASS_PATH, new Library[]{library}, DEFAULT_WEB_MODULE_ELEMENT_NAME);
    }

    public boolean addLibraries(final String classPathId, final Library[] libraries, final String webModuleElementName) throws IOException {
        assert (libraries != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = WebProjectClassPathExtender.this.cs.itemsList(raw, webModuleElementName);
                    boolean added = false;
                    for (int i = 0; i < libraries.length; ++i) {
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(libraries[i], null, "WEB-INF/lib");
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = WebProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), webModuleElementName);
                        props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        WebProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        EditableProperties privateProps = WebProjectClassPathExtender.this.helper.getProperties("nbproject/private/private.properties");
                        ArrayList l = new ArrayList();
                        l.addAll(resources);
                        l.addAll(WebProjectClassPathExtender.this.cs.itemsList(props.getProperty("war.content.additional"), "web-module-additional-libraries"));
                        WebProjectProperties.storeLibrariesLocations(l.iterator(), privateProps);
                        WebProjectClassPathExtender.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                        ProjectManager.getDefault().saveProject(WebProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public boolean addArchiveFile(FileObject archiveFile) throws IOException {
        return this.addArchiveFiles(CP_CLASS_PATH, new FileObject[]{archiveFile}, DEFAULT_WEB_MODULE_ELEMENT_NAME);
    }

    public boolean addArchiveFiles(final String classPathId, final FileObject[] archiveFiles, final String webModuleElementName) throws IOException {
        assert (archiveFiles != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = WebProjectClassPathExtender.this.cs.itemsList(raw, webModuleElementName);
                    boolean added = false;
                    for (int i = 0; i < archiveFiles.length; ++i) {
                        File f = FileUtil.toFile((FileObject)archiveFiles[i]);
                        if (f == null) {
                            throw new IllegalArgumentException("The file must exist on disk");
                        }
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(f, null, archiveFiles[i].isFolder() ? "WEB-INF/classes" : "WEB-INF/lib");
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = WebProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), webModuleElementName);
                        props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        WebProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(WebProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
        return this.addAntArtifacts(CP_CLASS_PATH, new AntArtifactChooser.ArtifactItem[]{new AntArtifactChooser.ArtifactItem(artifact, artifactElement)}, DEFAULT_WEB_MODULE_ELEMENT_NAME);
    }

    public boolean addAntArtifacts(final String classPathId, final AntArtifactChooser.ArtifactItem[] artifactItems, final String webModuleElementName) throws IOException {
        assert (artifactItems != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List resources = WebProjectClassPathExtender.this.cs.itemsList(raw, webModuleElementName);
                    boolean added = false;
                    for (int i = 0; i < artifactItems.length; ++i) {
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null, "WEB-INF/lib");
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = WebProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), webModuleElementName);
                        props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        WebProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(WebProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public ClassPathSupport getClassPathSupport() {
        return this.cs;
    }

    private void registerLibraryListeners() {
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        Library[] libs = LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            libs[i].removePropertyChangeListener((PropertyChangeListener)this);
        }
        HashSet set = new HashSet();
        set.addAll(this.cs.itemsList(props.getProperty(CP_CLASS_PATH), DEFAULT_WEB_MODULE_ELEMENT_NAME));
        set.addAll(this.cs.itemsList(props.getProperty("war.content.additional"), "web-module-additional-libraries"));
        for (ClassPathSupport.Item item : set) {
            if (item.getType() != 1 || item.isBroken()) continue;
            item.getLibrary().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.projectDeleted) {
            return;
        }
        if (e.getSource().equals(this.eval) && (e.getPropertyName().equals(CP_CLASS_PATH) || e.getPropertyName().equals("war.content.additional"))) {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            String javacCp = props.getProperty(CP_CLASS_PATH);
            if (javacCp != null) {
                this.registerLibraryListeners();
                if (ProjectManager.getDefault().isValid(this.project)) {
                    this.storeLibLocations();
                }
            }
        } else if (e.getPropertyName().equals("content")) {
            this.storeLibLocations();
        }
    }

    private void storeLibLocations() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties props = WebProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                EditableProperties privateProps = WebProjectClassPathExtender.this.helper.getProperties("nbproject/private/private.properties");
                List wmLibs = WebProjectClassPathExtender.this.cs.itemsList(props.getProperty(WebProjectClassPathExtender.CP_CLASS_PATH), WebProjectClassPathExtender.DEFAULT_WEB_MODULE_ELEMENT_NAME);
                List additionalLibs = WebProjectClassPathExtender.this.cs.itemsList(props.getProperty("war.content.additional"), "web-module-additional-libraries");
                WebProjectClassPathExtender.this.cs.encodeToStrings(wmLibs.iterator(), WebProjectClassPathExtender.DEFAULT_WEB_MODULE_ELEMENT_NAME);
                WebProjectClassPathExtender.this.cs.encodeToStrings(additionalLibs.iterator(), "web-module-additional-libraries");
                HashSet set = new HashSet();
                set.addAll(wmLibs);
                set.addAll(additionalLibs);
                WebProjectProperties.storeLibrariesLocations(set.iterator(), privateProps);
                WebProjectClassPathExtender.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            ProjectManager.getDefault().saveProject(WebProjectClassPathExtender.this.project);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public void notifyDeleting() {
        this.projectDeleted = true;
        this.eval.removePropertyChangeListener((PropertyChangeListener)this);
    }
}

