/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.project.classpath.ClassPathSupport;
import org.netbeans.modules.web.project.ui.customizer.AntArtifactChooser;

public class WarIncludesUiSupport {
    private static Object[][] data;

    public static ClasspathTableModel createTableModel(List items) {
        ClasspathTableModel model = new ClasspathTableModel();
        data = new Object[items.size()][2];
        for (int i = 0; i < items.size(); ++i) {
            model.setValueAt((ClassPathSupport.Item)items.get(i), i, 0);
            String pathInWAR = ((ClassPathSupport.Item)items.get(i)).getPathInWAR();
            model.setValueAt(pathInWAR, i, 1);
        }
        model.fireTableDataChanged();
        return model;
    }

    public static List getList(ClasspathTableModel model) {
        LinkedList<Object> items = new LinkedList<Object>();
        for (int i = 0; i < data.length; ++i) {
            items.add(data[i][0]);
        }
        return items;
    }

    public static Iterator getIterator(ClasspathTableModel model) {
        return WarIncludesUiSupport.getList(model).iterator();
    }

    public static void remove(JTable list) {
        ListSelectionModel sm = list.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (sm.isSelectionEmpty()) assert (false) : "Remove button should be disabled";
        ArrayList<Object[]> elements = new ArrayList<Object[]>();
        int n0 = data.length;
        for (int i = 0; i < n0; ++i) {
            if (sm.isSelectedIndex(i)) continue;
            elements.add(data[i]);
        }
        int n = elements.size();
        data = (Object[][])elements.toArray((T[])new Object[n][2]);
        ((ClasspathTableModel)list.getModel()).fireTableRowsDeleted(elements.size(), n0 - 1);
        if (index >= n) {
            index = n - 1;
        }
        sm.setSelectionInterval(index, index);
    }

    public static void addLibraries(Library[] libraries, Set alreadyIncludedLibs, JTable table) {
        if (libraries.length > 0) {
            ArrayList<Library> newLibList = new ArrayList<Library>(Arrays.asList(libraries));
            table.clearSelection();
            int n0 = data.length;
            for (int i = 0; i < n0; ++i) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)data[i][0];
                if (item.getType() != 1 || !newLibList.remove(item.getObject())) continue;
                table.addRowSelectionInterval(i, i);
            }
            int n = newLibList.size();
            if (n > 0) {
                int i;
                Object[][] newData = new Object[n0 + n][2];
                for (i = 0; i < n0; ++i) {
                    newData[i] = data[i];
                }
                for (i = 0; i < n; ++i) {
                    newData[n0 + i][0] = ClassPathSupport.Item.create((Library)newLibList.get(i), null, "");
                    newData[n0 + i][1] = "";
                }
                data = newData;
                ((ClasspathTableModel)table.getModel()).fireTableRowsInserted(n0, n0 + n - 1);
                table.addRowSelectionInterval(n0, n0 + n - 1);
            }
        }
    }

    public static void addJarFiles(File[] files, ClasspathTableModel tableModel) {
        int i;
        Object[][] newData = new Object[data.length + files.length][2];
        for (i = 0; i < data.length; ++i) {
            newData[i] = data[i];
        }
        for (i = 0; i < files.length; ++i) {
            newData[WarIncludesUiSupport.data.length + i][0] = ClassPathSupport.Item.create(files[i], null, "");
            newData[WarIncludesUiSupport.data.length + i][1] = "";
        }
        data = newData;
        tableModel.fireTableRowsInserted(data.length, data.length + files.length - 1);
    }

    public static void addArtifacts(AntArtifactChooser.ArtifactItem[] artifactItems, ClasspathTableModel tableModel) {
        int i;
        Object[][] newData = new Object[data.length + artifactItems.length][2];
        for (i = 0; i < data.length; ++i) {
            newData[i] = data[i];
        }
        for (i = 0; i < artifactItems.length; ++i) {
            newData[WarIncludesUiSupport.data.length + i][0] = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null, "");
            newData[WarIncludesUiSupport.data.length + i][1] = "";
        }
        data = newData;
        tableModel.fireTableRowsInserted(data.length, data.length + artifactItems.length - 1);
    }

    static class ClasspathTableModel
    extends AbstractTableModel {
        ClasspathTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (data == null) {
                return 0;
            }
            return data.length;
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

