/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.web.api.webmodule.WebFrameworkSupport;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.wizards.PanelConfigureProjectVisual;
import org.netbeans.modules.web.project.ui.wizards.PanelSupportedFrameworks;
import org.netbeans.modules.web.spi.webmodule.FrameworkConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSupportedFrameworksVisual
extends JPanel
implements HelpCtx.Provider,
TableModelListener,
ListSelectionListener,
ChangeListener {
    public static int ALL_FRAMEWORKS = 0;
    public static int USED_FRAMEWORKS = 1;
    public static int UNUSED_FRAMEWORKS = 2;
    private List ignoredFrameworks;
    private HashMap configPanels = new HashMap();
    private FrameworksTableModel model;
    private PanelSupportedFrameworks panel;
    private WizardDescriptor wizardDescriptor;
    private JLabel jLabel1;
    private JLabel jLabelConfig;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableFrameworks;

    public PanelSupportedFrameworksVisual(PanelSupportedFrameworks panel, WebProject project, int filter, List ignoredFrameworks) {
        this.panel = panel;
        this.ignoredFrameworks = ignoredFrameworks;
        this.initComponents();
        this.model = new FrameworksTableModel();
        this.jTableFrameworks.setModel(this.model);
        this.createFrameworksList(project, filter);
        FrameworksTableCellRenderer renderer = new FrameworksTableCellRenderer();
        renderer.setBooleanRenderer(this.jTableFrameworks.getDefaultRenderer(Boolean.class));
        this.jTableFrameworks.setDefaultRenderer(WebFrameworkProvider.class, renderer);
        this.jTableFrameworks.setDefaultRenderer(Boolean.class, renderer);
        this.initTableVisualProperties(this.jTableFrameworks);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_NWP2_Frameworks_A11YDesc"));
        this.setName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"LBL_NWP2_Frameworks"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NewWebApp"));
    }

    private void initTableVisualProperties(JTable table) {
        table.getModel().addTableModelListener(this);
        table.setRowSelectionAllowed(true);
        table.getSelectionModel().addListSelectionListener(this);
        table.getSelectionModel().setSelectionMode(0);
        table.setTableHeader(null);
        table.setRowHeight(this.jTableFrameworks.getRowHeight() + 4);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void createFrameworksList(WebProject project, int filter) {
        WebFrameworkProvider framework;
        int i;
        List frameworks = WebFrameworkSupport.getFrameworkProviders();
        this.configPanels.clear();
        if (project == null || filter == ALL_FRAMEWORKS) {
            for (i = 0; i < frameworks.size(); ++i) {
                this.addFrameworkToModel((WebFrameworkProvider)frameworks.get(i));
                this.configPanels.put((WebFrameworkProvider)frameworks.get(i), ((WebFrameworkProvider)frameworks.get(i)).getConfigurationPanel(null));
            }
        } else if (project != null && filter == USED_FRAMEWORKS) {
            for (i = 0; i < frameworks.size(); ++i) {
                framework = (WebFrameworkProvider)frameworks.get(i);
                if (!framework.isInWebModule(project.getAPIWebModule())) continue;
                this.addFrameworkToModel(framework);
                this.configPanels.put(framework, framework.getConfigurationPanel(null));
            }
        } else if (project != null && filter == UNUSED_FRAMEWORKS) {
            for (i = 0; i < frameworks.size(); ++i) {
                framework = (WebFrameworkProvider)frameworks.get(i);
                if (framework.isInWebModule(project.getAPIWebModule())) continue;
                this.addFrameworkToModel(framework);
                this.configPanels.put(framework, framework.getConfigurationPanel(null));
            }
        }
        for (i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item = this.model.getItem(i);
            FrameworkConfigurationPanel configPanel = (FrameworkConfigurationPanel)this.configPanels.get(item.getFramework());
            if (configPanel == null) continue;
            configPanel.addChangeListener((ChangeListener)this);
        }
    }

    private void addFrameworkToModel(WebFrameworkProvider framework) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        if (this.ignoredFrameworks == null || !this.ignoredFrameworks.contains(framework)) {
            model.addItem(new FrameworkModelItem(framework));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFrameworks = new JTable();
        this.jSeparator1 = new JSeparator();
        this.jLabelConfig = new JLabel();
        this.jPanelConfig = new JPanel();
        this.setPreferredSize(new Dimension(500, 340));
        this.setRequestFocusEnabled(false);
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"MNE_Frameworks").charAt(0));
        this.jLabel1.setLabelFor(this.jTableFrameworks);
        this.jLabel1.setText(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_Select_Frameworks"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"ACS_LBL_NWP2_FrameworksTable_A11YDesc"));
        this.jScrollPane1.setMaximumSize(new Dimension(Short.MAX_VALUE, 70));
        this.jScrollPane1.setMinimumSize(new Dimension(22, 70));
        this.jScrollPane1.setPreferredSize(new Dimension(453, 70));
        this.jTableFrameworks.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTableFrameworks);
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        this.jPanelConfig.setLayout(new GridBagLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 500, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 500, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 500, Short.MAX_VALUE).add(2, (Component)this.jLabelConfig, -1, 500, Short.MAX_VALUE).add((Component)this.jPanelConfig, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 71, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelConfig, -2, 21, -2).addPreferredGap(0).add((Component)this.jPanelConfig, -1, 207, Short.MAX_VALUE)));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        int i;
        boolean retVal = true;
        for (i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.model.getItem(i).isSelected().booleanValue()) continue;
            retVal = false;
            break;
        }
        if (retVal) {
            return true;
        }
        for (i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item = this.model.getItem(i);
            FrameworkConfigurationPanel configPanel = (FrameworkConfigurationPanel)this.configPanels.get(item.getFramework());
            if (configPanel == null || configPanel.isValid()) continue;
            return false;
        }
        return true;
    }

    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("frameworks", (Object)this.getSelectedFrameworks());
    }

    public List getSelectedFrameworks() {
        LinkedList<WebFrameworkProvider> selectedFrameworks = new LinkedList<WebFrameworkProvider>();
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            FrameworkModelItem item = model.getItem(i);
            if (item.isSelected() != Boolean.TRUE) continue;
            selectedFrameworks.add(item.getFramework());
        }
        return selectedFrameworks;
    }

    public Component[] getConfigComponents() {
        return new Component[]{this.jSeparator1, this.jLabelConfig, this.jPanelConfig};
    }

    public HelpCtx getHelpCtx() {
        if (this.jPanelConfig.getComponentCount() > 0) {
            for (int i = 0; i < this.jPanelConfig.getComponentCount(); ++i) {
                if (!(this.jPanelConfig.getComponent(i) instanceof HelpCtx.Provider)) continue;
                return ((HelpCtx.Provider)this.jPanelConfig.getComponent(i)).getHelpCtx();
            }
        }
        return null;
    }

    public void tableChanged(TableModelEvent e) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        FrameworkModelItem item = model.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider framework = item.getFramework();
        this.setConfigPanel(framework, item);
    }

    public void valueChanged(ListSelectionEvent e) {
        FrameworksTableModel model = (FrameworksTableModel)this.jTableFrameworks.getModel();
        FrameworkModelItem item = model.getItem(this.jTableFrameworks.getSelectedRow());
        WebFrameworkProvider framework = item.getFramework();
        this.setConfigPanel(framework, item);
    }

    private void setConfigPanel(WebFrameworkProvider framework, FrameworkModelItem item) {
        if (this.configPanels.get(framework) != null) {
            String message = MessageFormat.format(NbBundle.getMessage(PanelSupportedFrameworksVisual.class, (String)"LBL_NWP2_ConfigureFramework"), framework.getName());
            this.jLabelConfig.setText(message);
            this.jPanelConfig.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanelConfig.add(((FrameworkConfigurationPanel)this.configPanels.get(framework)).getComponent(), gridBagConstraints);
            this.jLabelConfig.setEnabled(item.isSelected());
            ((FrameworkConfigurationPanel)this.configPanels.get(framework)).enableComponents(item.isSelected().booleanValue());
            ((FrameworkConfigurationPanel)this.configPanels.get(framework)).readSettings((Object)this.wizardDescriptor);
            this.jPanelConfig.revalidate();
            this.jPanelConfig.repaint();
        } else {
            this.jLabelConfig.setText("");
            this.jPanelConfig.removeAll();
            this.jPanelConfig.repaint();
            this.jPanelConfig.revalidate();
        }
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    private final class FrameworkModelItem {
        private WebFrameworkProvider framework;
        private Boolean selected;

        public FrameworkModelItem(WebFrameworkProvider framework) {
            this.setFramework(framework);
            this.setSelected(Boolean.FALSE);
        }

        public WebFrameworkProvider getFramework() {
            return this.framework;
        }

        public void setFramework(WebFrameworkProvider framework) {
            this.framework = framework;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }
    }

    public static final class FrameworksTableModel
    extends AbstractTableModel {
        private DefaultListModel model = new DefaultListModel();

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.model.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return WebFrameworkProvider.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Object getValueAt(int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item.getFramework();
                }
            }
            return "";
        }

        public void setValueAt(Object value, int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    item.setSelected((Boolean)value);
                    break;
                }
                case 1: {
                    item.setFramework((WebFrameworkProvider)value);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        private FrameworkModelItem getItem(int index) {
            return (FrameworkModelItem)this.model.get(index);
        }

        public void addItem(FrameworkModelItem item) {
            this.model.addElement(item);
        }
    }

    public static class FrameworksTableCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer booleanRenderer;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof WebFrameworkProvider) {
                WebFrameworkProvider item = (WebFrameworkProvider)value;
                return super.getTableCellRendererComponent(table, item.getName(), isSelected, false, row, column);
            }
            if (value instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public void setBooleanRenderer(TableCellRenderer booleanRenderer) {
            this.booleanRenderer = booleanRenderer;
        }
    }
}

