/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.web.wizards.Editable;
import org.openide.util.NbBundle;

class DDTable
extends JTable
implements KeyListener {
    private static final boolean debug = false;
    private String titleKey;
    private Editable editable;
    private String[] headers;
    private static final int margin = 6;
    private boolean fontChanged = true;
    private boolean addedRow = true;
    private int rowHeight = 23;
    private static final long serialVersionUID = -155464225493968935L;

    DDTable(String[] headers, String titleKey) {
        this(headers, titleKey, Editable.BOTH);
    }

    DDTable(String[] headers, String titleKey, Editable editable) {
        super(new Object[0][headers.length], headers);
        this.headers = headers;
        this.titleKey = titleKey;
        this.editable = editable;
        this.setModel(new DDTableModel(headers, editable));
        this.setColors(editable);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension(6, 6));
        DefaultCellEditor dce = new DefaultCellEditor(new CellText(this));
        dce.setClickCountToStart(1);
        this.getColumnModel().getColumn(0).setCellEditor(dce);
        this.getColumnModel().getColumn(1).setCellEditor(dce);
    }

    void setEditable(Editable editable) {
        this.editable = editable;
        this.setColors(editable);
    }

    Editable getEditable() {
        return this.editable;
    }

    int addRow(String[] values) {
        int i = ((DDTableModel)this.getModel()).addRow(values);
        if (i == 0) {
            this.fontChanged = true;
        }
        this.addedRow = true;
        this.invalidate();
        return i;
    }

    void removeRow(int row) {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        ((DDTableModel)this.getModel()).removeRow(row);
        this.invalidate();
        int maxSelectedRow = this.getRowCount() - 1;
        if (this.getSelectedRow() > maxSelectedRow) {
            if (maxSelectedRow >= 0) {
                this.setRowSelectionInterval(maxSelectedRow, maxSelectedRow);
            } else {
                this.clearSelection();
            }
        }
    }

    String getColumnKey(int col) {
        return this.headers[col];
    }

    private void setColors(Editable editable) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color bg = editable == Editable.NEITHER ? this.getBackground().darker() : Color.white;
        this.setBackground(bg);
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return super.getCellRenderer(row, col);
    }

    void setData(String name, String value, int row) {
        if (this.getEditingRow() == row) {
            int col = this.getEditingColumn();
            this.getCellEditor(row, col).cancelCellEditing();
        }
        ((DDTableModel)this.getModel()).setData(name, value, row);
    }

    public boolean isCellEditable(int row, int col) {
        if (this.editable == Editable.NEITHER) {
            return false;
        }
        return this.editable != Editable.VALUE || col != 0;
    }

    public void paint(Graphics g) {
        if (this.fontChanged) {
            this.fontChanged = false;
            int height = 0;
            FontMetrics fm = g.getFontMetrics(this.getFont());
            height = fm.getHeight() + 6;
            if (height > this.rowHeight) {
                this.rowHeight = height;
            }
            this.setRowHeight(this.rowHeight);
            return;
        }
        if (this.addedRow) {
            this.addedRow = false;
            int row = this.getModel().getRowCount() - 1;
            this.editCellAt(row, 0);
            Component c = this.getCellEditor(row, 0).getTableCellEditorComponent(this, this.getValueAt(row, 0), true, row, 0);
            if (c instanceof JTextField) {
                ((JTextField)c).requestFocus();
            }
        }
        super.paint(g);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object o = keyEvent.getSource();
        String s = null;
        if (o instanceof JTextField) {
            s = ((JTextField)o).getText().trim();
        }
        int row = this.getEditingRow();
        int col = this.getEditingColumn();
        this.setValueAt(s, row, col);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void log(String s) {
        System.out.println("DDTable" + s);
    }

    class CellText
    extends JTextField {
        private static final long serialVersionUID = 2674682216176560005L;

        public CellText(DDTable table) {
            this.addKeyListener(table);
            this.getAccessibleContext().setAccessibleName(this.getText());
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DDTable.class, (String)"ACSD_ipcell"));
        }
    }

    class DDTableModel
    extends AbstractTableModel {
        private String[] colheaders = null;
        private Object[][] data = null;
        private Editable editable;
        private int numCols;
        private int numRows = 0;
        private static final long serialVersionUID = -5044296029944667379L;

        DDTableModel(String[] headers, Editable editable) {
            this.colheaders = headers;
            this.editable = editable;
            this.numCols = this.colheaders.length;
            this.data = new Object[this.numRows][this.numCols];
        }

        public String getColumnName(int col) {
            String key = "LBL_".concat(this.colheaders[col]);
            return NbBundle.getMessage(DDTable.class, (String)key);
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.numCols;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public int addRow(String[] values) {
            Object[][] data2 = new Object[this.numRows + 1][this.numCols];
            int i = 0;
            int j = 0;
            if (this.numRows > 0) {
                for (j = 0; j < this.numRows; ++j) {
                    data2[j] = this.data[j];
                }
            }
            for (i = 0; i < values.length; ++i) {
                data2[j][i] = values[i];
            }
            this.data = data2;
            ++this.numRows;
            return j;
        }

        public void removeRow(int row) {
            Object[][] data2 = new Object[this.numRows - 1][this.numCols];
            int newRowIndex = 0;
            for (int i = 0; i < this.numRows; ++i) {
                if (i == row) continue;
                data2[newRowIndex] = this.data[i];
                ++newRowIndex;
            }
            this.data = data2;
            this.numRows = --this.numRows;
        }

        void setData(String name, String value, int row) {
            this.data[row][0] = name;
            this.data[row][1] = value;
            this.fireTableChanged(new TableModelEvent(this, row));
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        private void log(String s) {
            System.out.println("DDTableModel" + s);
        }
    }
}

