/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.dd.ORMMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.WeakMetadataUnit;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceClassPathProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtils {
    private static final Map<FileObject, EntityMappingsCache> persistence2EMCache = new WeakHashMap<FileObject, EntityMappingsCache>();
    private static final WeakHashMap<Project, MetadataUnit> project2MUCache = new WeakHashMap();

    private PersistenceUtils() {
    }

    public static EntityMappings getEntityMappings(PersistenceScope persistenceScope, String persistenceUnitName) throws IOException {
        if (persistenceScope == null) {
            throw new NullPointerException("The persistenceScope parameter cannot be null");
        }
        if (persistenceUnitName == null) {
            throw new NullPointerException("The persistenceUnitName parameter cannot be null");
        }
        EntityMappingsCache emCache = PersistenceUtils.getEntityMappingsCache(persistenceScope);
        if (emCache != null) {
            return emCache.getEntityMappings(persistenceUnitName);
        }
        return null;
    }

    public static List<EntityMappings> getEntityMappings(Project project) throws IOException {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        ArrayList<EntityMappings> result = new ArrayList<EntityMappings>();
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project)) {
            EntityMappingsCache emCache = PersistenceUtils.getEntityMappingsCache(persistenceScope);
            if (emCache == null) continue;
            result.addAll(emCache.getEntityMappings());
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EntityMappingsCache getEntityMappingsCache(PersistenceScope persistenceScope) throws IOException {
        FileObject persistenceXml = persistenceScope.getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        EntityMappingsCache emCache = null;
        Map<FileObject, EntityMappingsCache> map = persistence2EMCache;
        synchronized (map) {
            emCache = persistence2EMCache.get(persistenceXml);
            if (emCache == null && persistenceXml.isValid()) {
                emCache = EntityMappingsCache.create(persistenceScope);
                persistence2EMCache.put(persistenceXml, emCache);
            }
        }
        return emCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromCache(FileObject persistenceXml) {
        Map<FileObject, EntityMappingsCache> map = persistence2EMCache;
        synchronized (map) {
            persistence2EMCache.remove(persistenceXml);
        }
    }

    public static Set<Entity> getEntityClasses(PersistenceScope persistenceScope) throws IOException {
        if (persistenceScope == null) {
            throw new NullPointerException("The persistenceScope parameter cannot be null");
        }
        FileObject persistenceXml = persistenceScope.getPersistenceXml();
        if (persistenceXml == null) {
            return Collections.emptySet();
        }
        HashSet<Entity> result = new HashSet<Entity>();
        Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceXml);
        for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
            EntityMappings entityMappings = PersistenceUtils.getEntityMappings(persistenceScope, persistenceUnit.getName());
            if (entityMappings == null) continue;
            for (Entity entity : entityMappings.getEntity()) {
                result.add(entity);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<Entity> getEntityClasses(Project project) throws IOException {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        HashSet<Entity> result = new HashSet<Entity>();
        HashSet<String> entityNames = new HashSet<String>();
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project)) {
            for (Entity entity : PersistenceUtils.getEntityClasses(persistenceScope)) {
                String entityName = entity.getName();
                if (entityNames.contains(entityName)) continue;
                result.add(entity);
                entityNames.add(entityName);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<Entity> getEntityClasses(List<EntityMappings> entityMappingsList) {
        if (entityMappingsList == null) {
            throw new NullPointerException("The entityMappingsList parameter cannot be null");
        }
        HashSet<Entity> result = new HashSet<Entity>();
        HashSet<String> entityNames = new HashSet<String>();
        for (EntityMappings em : entityMappingsList) {
            for (Entity entity : em.getEntity()) {
                String entityName = entity.getName();
                if (entityNames.contains(entityName)) continue;
                result.add(entity);
                entityNames.add(entityName);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static EntityMappings getAnnotationEntityMappings(Project project) {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        try {
            return ORMMetadata.getDefault().getRoot(PersistenceUtils.getPersistenceMetadataUnit(project));
        }
        catch (IOException e) {
            return new EntityMappings();
        }
    }

    public static Set<Entity> getAnnotationEntityClasses(Project project) {
        HashSet<Entity> result = new HashSet<Entity>();
        for (Entity entity : PersistenceUtils.getAnnotationEntityMappings(project).getEntity()) {
            result.add(entity);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetadataUnit getPersistenceMetadataUnit(Project project) {
        MetadataUnit mu;
        WeakHashMap<Project, MetadataUnit> weakHashMap = project2MUCache;
        synchronized (weakHashMap) {
            mu = project2MUCache.get(project);
            if (mu == null) {
                ClassPath classpath = null;
                PersistenceClassPathProvider provider = (PersistenceClassPathProvider)project.getLookup().lookup(PersistenceClassPathProvider.class);
                if (provider != null) {
                    classpath = provider.getClassPath();
                }
                mu = new WeakMetadataUnit(null, classpath);
                project2MUCache.put(project, mu);
            }
        }
        return mu;
    }

    public static PersistenceUnit[] getPersistenceUnits(FileObject sourceFile) throws IOException {
        if (sourceFile == null) {
            throw new NullPointerException("The sourceFile parameter cannot be null");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)sourceFile);
        if (project == null) {
            return new PersistenceUnit[0];
        }
        ArrayList<PersistenceUnit> result = new ArrayList<PersistenceUnit>();
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project)) {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                result.add(persistenceUnit);
            }
        }
        return result.toArray(new PersistenceUnit[result.size()]);
    }

    public static EntityMappings getEntityMappings(FileObject sourceFile) {
        if (sourceFile == null) {
            throw new NullPointerException("The sourceFile parameter cannot be null");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)sourceFile);
        if (project == null) {
            return null;
        }
        return PersistenceUtils.getAnnotationEntityMappings(project);
    }

    public static List<Entity> sortEntityClasses(Set<Entity> entityClasses) {
        if (entityClasses == null) {
            throw new NullPointerException("The entityClasses parameter cannot be null");
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>(entityClasses);
        Collections.sort(entityList, new EntityComparator());
        return entityList;
    }

    public static Entity getEntity(JavaClass javaClass, EntityMappings entityMappings) {
        if (javaClass == null) {
            throw new NullPointerException("The javaClass parameter cannot be null");
        }
        if (entityMappings == null) {
            throw new NullPointerException("The entityMappings parameter cannot be null");
        }
        return PersistenceUtils.getEntity(javaClass.getName(), entityMappings);
    }

    public static Entity getEntity(String className, EntityMappings entityMappings) {
        if (className == null) {
            throw new NullPointerException("The javaClass parameter cannot be null");
        }
        if (entityMappings == null) {
            throw new NullPointerException("The entityMappings parameter cannot be null");
        }
        for (Entity entity : entityMappings.getEntity()) {
            if (!className.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static PersistenceScope[] getPersistenceScopes(Project project) {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        PersistenceScopes persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project);
        if (persistenceScopes != null) {
            return persistenceScopes.getPersistenceScopes();
        }
        return new PersistenceScope[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityComparator
    implements Comparator<Entity> {
        private EntityComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            String name1 = o1.getClass2();
            String name2 = o2.getClass2();
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            return name2 == null ? 1 : name1.compareTo(name2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntityMappingsCache
    implements PropertyChangeListener {
        private final WeakReference<PersistenceScope> persistenceScopeRef;
        private final Map<String, WeakMetadataUnit> metadataUnitCache = new HashMap<String, WeakMetadataUnit>();

        public static EntityMappingsCache create(PersistenceScope persistenceScope) {
            EntityMappingsCache result = new EntityMappingsCache(persistenceScope);
            result.startListening();
            return result;
        }

        private EntityMappingsCache(PersistenceScope persistenceScope) {
            this.persistenceScopeRef = new WeakReference<PersistenceScope>(persistenceScope);
        }

        private void startListening() {
            PUDataObject pudo = this.getPUDataObject();
            if (pudo != null) {
                pudo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)pudo)));
            }
        }

        public EntityMappings getEntityMappings(String persistenceUnitName) throws IOException {
            MetadataUnit mu = this.getMetadataUnit(persistenceUnitName);
            if (mu != null) {
                return ORMMetadata.getDefault().getRoot(mu);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<EntityMappings> getEntityMappings() throws IOException {
            PUDataObject pudo = this.getPUDataObject();
            if (pudo == null) {
                return Collections.emptyList();
            }
            ArrayList<EntityMappings> entityMappingsList = new ArrayList<EntityMappings>();
            Persistence persistence = pudo.getPersistence();
            EntityMappingsCache entityMappingsCache = this;
            synchronized (entityMappingsCache) {
                for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                    EntityMappings em = this.getEntityMappings(persistenceUnit.getName());
                    if (em == null) continue;
                    entityMappingsList.add(em);
                }
            }
            return Collections.unmodifiableList(entityMappingsList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MetadataUnit getMetadataUnit(String persistenceUnitName) {
            PersistenceScope persistenceScope = (PersistenceScope)this.persistenceScopeRef.get();
            if (persistenceScope == null) {
                return null;
            }
            WeakMetadataUnit metadataUnit = null;
            EntityMappingsCache entityMappingsCache = this;
            synchronized (entityMappingsCache) {
                PUDataObject pudo;
                metadataUnit = this.metadataUnitCache.get(persistenceUnitName);
                if (metadataUnit == null && (pudo = this.getPUDataObject()) != null && (metadataUnit = this.createMetadataUnit(pudo, persistenceScope.getClassPath(), persistenceUnitName)) != null) {
                    this.metadataUnitCache.put(persistenceUnitName, metadataUnit);
                }
            }
            return metadataUnit;
        }

        private WeakMetadataUnit createMetadataUnit(PUDataObject pudo, ClassPath classPath, String persistenceUnitName) {
            assert (Thread.holdsLock(this));
            Persistence persistence = pudo.getPersistence();
            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                if (!persistenceUnitName.equals(unit.getName())) continue;
                return new WeakMetadataUnit(EntityMappingsCache.getMappingFile(pudo), classPath);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshCache() {
            PUDataObject pudo = this.getPUDataObject();
            if (pudo == null) {
                return;
            }
            Persistence persistence = pudo.getPersistence();
            EntityMappingsCache entityMappingsCache = this;
            synchronized (entityMappingsCache) {
                HashSet<String> persistenceUnitNames = new HashSet<String>();
                for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                    persistenceUnitNames.add(persistenceUnit.getName());
                }
                Iterator<Map.Entry<String, WeakMetadataUnit>> i = this.metadataUnitCache.entrySet().iterator();
                while (i.hasNext()) {
                    if (persistenceUnitNames.contains(i.next().getKey())) continue;
                    i.remove();
                }
                for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                    WeakMetadataUnit metadataUnit = this.metadataUnitCache.get(persistenceUnit.getName());
                    if (metadataUnit == null) continue;
                    EntityMappingsCache.refreshMetadataUnit(metadataUnit, pudo);
                }
            }
        }

        private static void refreshMetadataUnit(WeakMetadataUnit metadataUnit, PUDataObject pudo) {
            metadataUnit.setDeploymentDescriptor(EntityMappingsCache.getMappingFile(pudo));
        }

        private static FileObject getMappingFile(PUDataObject pudo) {
            FileObject metaInf;
            FileObject persistenceXml = pudo.getPrimaryFile();
            FileObject ormXml = null;
            if (persistenceXml != null && (metaInf = persistenceXml.getParent()) != null) {
                ormXml = metaInf.getFileObject("orm.xml");
            }
            return ormXml;
        }

        PUDataObject getPUDataObject() {
            PersistenceScope persistenceScope = (PersistenceScope)this.persistenceScopeRef.get();
            FileObject persistenceXml = null;
            if (persistenceScope != null) {
                persistenceXml = persistenceScope.getPersistenceXml();
            }
            if (persistenceXml == null) {
                return null;
            }
            try {
                return (PUDataObject)DataObject.find((FileObject)persistenceXml);
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName())) {
                PersistenceUtils.removeFromCache(((DataObject)evt.getSource()).getPrimaryFile());
            } else {
                this.refreshCache();
            }
        }
    }
}

