/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCFinderFactory;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.NNParser;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBCompletionContextResolver;
import org.netbeans.modules.javacore.JMManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class NNCompletionQuery
extends JavaCompletionQuery {
    private List resolvers;

    public NNCompletionQuery(boolean isJava15) {
        this.setJava15(isJava15);
        this.initResolvers();
    }

    private void initResolvers() {
        this.resolvers = new ArrayList();
        this.resolvers.add(new DBCompletionContextResolver());
    }

    protected JCFinder getFinder() {
        FileObject fo = this.getFileObject();
        return JCFinderFactory.getDefault().getFinder(fo);
    }

    protected CompletionQuery.Result getResult(JTextComponent component, JavaSyntaxSupport sup, boolean openingSource, int offset, JCExpression exp) {
        Completion completion = ((ExtEditorUI)Utilities.getEditorUI((JTextComponent)component)).getCompletion();
        boolean autoPopup = completion != null ? completion.provokedByAutoPopup : false;
        ArrayList results = new ArrayList();
        for (CompletionContextResolver resolver : this.resolvers) {
            Context ctx = new Context(component, (NbJavaJMISyntaxSupport)sup.get(NbJavaJMISyntaxSupport.class), openingSource, offset, autoPopup);
            if (ctx.getEntityMappings() == null) {
                ErrorManager.getDefault().log(1, "No EnitityMappings defined.");
                break;
            }
            results.addAll(resolver.resolve(exp, ctx));
        }
        return new CompletionQuery.DefaultResult(component, "*", results, exp.getTokenCount() == 0 ? offset : exp.getTokenOffset(0), 0);
    }

    private FileObject getFileObject() {
        BaseDocument bDoc = this.getBaseDocument();
        DataObject dobj = NbEditorUtilities.getDataObject((Document)bDoc);
        return dobj.getPrimaryFile();
    }

    public final class Context {
        private JTextComponent component;
        private NbJavaJMISyntaxSupport sup;
        private boolean openingSource;
        private int endOffset;
        private JavaClass curCls;
        private PersistenceUnit[] pus;
        private EntityMappings emaps;
        private boolean autoPopup;
        private String completedMemberName;
        private String completedMemberJavaClassName;
        private NNParser nnparser;
        private NNParser.NN parsednn = null;

        public Context(JTextComponent component, NbJavaJMISyntaxSupport sup, boolean openingSource, int endOffset, boolean autoPopup) {
            this.component = component;
            this.sup = sup;
            this.openingSource = openingSource;
            this.endOffset = endOffset;
            this.autoPopup = autoPopup;
            FileObject documentFO = this.getFileObject();
            if (documentFO != null) {
                try {
                    this.pus = PersistenceUtils.getPersistenceUnits(documentFO);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                this.emaps = PersistenceUtils.getEntityMappings(documentFO);
            }
            this.nnparser = new NNParser(this.getBaseDocument());
        }

        public JavaClass getJavaClass() {
            assert (Thread.currentThread() == JMManager.getTransactionMutex().getThread());
            this.curCls = this.sup.getJavaClass(this.endOffset);
            if (this.curCls == null) {
                this.curCls = this.sup.getTopJavaClass();
            }
            return this.curCls;
        }

        public BaseDocument getBaseDocument() {
            return this.sup.getDocument();
        }

        public FileObject getFileObject() {
            return NbEditorUtilities.getFileObject((Document)this.getBaseDocument());
        }

        public PersistenceUnit[] getPersistenceUnits() {
            return this.pus;
        }

        public EntityMappings getEntityMappings() {
            return this.emaps;
        }

        public int getCompletionOffset() {
            return this.endOffset;
        }

        public NbJavaJMISyntaxSupport getSyntaxSupport() {
            return this.sup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NNParser.NN getParsedAnnotation() {
            NNParser nNParser = this.nnparser;
            synchronized (nNParser) {
                if (this.parsednn == null) {
                    this.parsednn = this.nnparser.parseAnnotation(this.getCompletionOffset());
                }
                return this.parsednn;
            }
        }

        public String getCompletedMemberClassName() {
            if (this.completedMemberJavaClassName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberJavaClassName;
        }

        public String getCompletedMemberName() {
            if (this.completedMemberName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberName;
        }

        private void initCompletedMemberContext() {
            String type = null;
            String genericType = null;
            String propertyName = null;
            NNParser nnp = new NNParser(this.getBaseDocument());
            try {
                TokenItem ti = this.sup.getTokenChain(this.getCompletionOffset(), this.getCompletionOffset() + 1);
                while (ti != null && propertyName == null) {
                    NNParser.NN parsed;
                    if (ti.getTokenID() == JavaTokenContext.ANNOTATION && (parsed = nnp.parseAnnotation(ti.getOffset() + 1)) != null) {
                        ti = this.sup.getTokenChain(parsed.getEndOffset(), parsed.getEndOffset() + 1);
                        continue;
                    }
                    if (genericType != null && ti.getTokenID() == JavaTokenContext.LT) {
                        TokenItem ti2 = ti.getNext();
                        if (ti2.getTokenID() == JavaTokenContext.IDENTIFIER) {
                            genericType = ti2.getImage();
                            ti = ti.getNext();
                        } else {
                            genericType = null;
                        }
                    } else if (ti.getTokenID() == JavaTokenContext.IDENTIFIER) {
                        if (type == null) {
                            genericType = type = ti.getImage();
                        } else {
                            propertyName = ti.getImage();
                        }
                    }
                    ti = ti.getNext();
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            this.completedMemberName = propertyName;
            this.completedMemberJavaClassName = genericType == null ? type : genericType;
        }
    }
}

