/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.ws.checks;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

public class WSMustHaveAtLeastOneOperation
extends ProblemFinder {
    public void parseDocument() {
        JavaClass javaClass = this.getMainJavaClass();
        Annotation annWS = ProblemFindingUtils.findAnnotation((AnnotableElement)javaClass, "javax.jws.WebService");
        if (annWS != null) {
            for (Element e : javaClass.getContents()) {
                if (!(e instanceof Method) || !this.isOperation((Method)e)) continue;
                return;
            }
            if (this.hasPublicMethod(javaClass)) {
                return;
            }
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_must_have_at_least_one_operation", NbBundle.getMessage(this.getClass(), (String)"MSG_WSMustHaveAtLeastOneOperation"), problemContext);
            this.attachProblemMarkToElement(problemMark, (Element)javaClass);
            this.addProblemMark(problemMark);
        }
    }

    private boolean isOperation(Method method) {
        Annotation annWebMethod = ProblemFindingUtils.findAnnotation((AnnotableElement)method, "javax.jws.WebMethod");
        return annWebMethod != null;
    }

    private boolean hasPublicMethod(JavaClass javaClass) {
        if ("java.lang.Object".equals(javaClass.getName())) {
            return false;
        }
        for (Element e : javaClass.getContents()) {
            if (!(e instanceof Method) || !Modifier.isPublic(((Method)e).getModifiers())) continue;
            return true;
        }
        return this.hasPublicMethod(javaClass.getSuperClass());
    }
}

