/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.lib.java.parser.CompilerException;
import org.netbeans.lib.java.parser.ECRequestDesc;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class ECRequestDescImpl
implements ECRequestDesc {
    private final String sourcePath;
    private final String classPath;
    private final String bootPath;
    private final String fileName;
    private final ASTProvider provider;
    private final ErrConsumer consumer;
    private Map modifiedMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ECRequestDescImpl(String name, ASTProvider provider, ErrConsumer consumer) throws CompilerException {
        this.provider = provider;
        this.consumer = consumer;
        this.fileName = name;
        StringBuffer compileRoots = new StringBuffer(241);
        StringBuffer sourceRoots = new StringBuffer(246);
        FileObject fo = provider.getFileObject();
        ClassPath ccp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        ClassPath ecp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
        ClassPath scp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (!fo.isValid()) {
            throw new CompilerException(new RuntimeException("FileObject " + fo.getPath() + " is no more valid. EC request cancelled."));
        }
        ClassPath extCcp = ECRequestDescImpl.getCompileClassPathWithCompiledSrc(ccp, ecp, scp);
        HashSet cprootsSet = new HashSet();
        this.getCompileAndSourcePath(extCcp, sourceRoots, compileRoots, cprootsSet);
        this.getSourcePath(scp, sourceRoots, cprootsSet);
        this.sourcePath = sourceRoots.toString();
        this.classPath = compileRoots.toString();
        this.bootPath = this.getClassPathString(ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot"));
    }

    private Map getModifiedMap() {
        if (this.modifiedMap == null) {
            this.modifiedMap = new HashMap();
            DataObject[] dobjs = DataObject.getRegistry().getModified();
            for (int i = 0; i < dobjs.length; ++i) {
                FileObject fobj = dobjs[i].getPrimaryFile();
                if (fobj == null || !fobj.isValid()) continue;
                String filename = fobj.getPath();
                this.modifiedMap.put(filename, dobjs[i]);
            }
        }
        return this.modifiedMap;
    }

    public String getBootClassPath() {
        return this.bootPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public ErrConsumer getErrConsumer() {
        return this.consumer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Reader getReader() {
        try {
            return this.provider.getFileReader(false);
        }
        catch (FileNotFoundException fnfe) {
            ErrorManager.getDefault().notify(1, (Throwable)fnfe);
            return null;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    public String getSourceClassPath() {
        return this.sourcePath;
    }

    public String getSourceLevel() {
        return this.provider.getSourceLevel();
    }

    private void getCompileAndSourcePath(ClassPath classPath, StringBuffer sourceRoots, StringBuffer compileRoots, Set cprootsSet) {
        if (classPath != null) {
            Iterator it = classPath.entries().iterator();
            while (it.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it.next();
                FileObject root = entry.getRoot();
                if (root != null) {
                    cprootsSet.add(root);
                    this.getFileName(root, compileRoots);
                }
                FileObject[] sRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                for (int x = 0; x < sRoots.length; ++x) {
                    FileObject sRoot = sRoots[x];
                    if (cprootsSet.contains(sRoot)) continue;
                    cprootsSet.add(sRoot);
                    this.getFileName(sRoot, sourceRoots);
                }
            }
        }
    }

    private void getSourcePath(ClassPath classPath, StringBuffer sourceRoots, Set cprootsSet) {
        if (classPath != null) {
            Iterator it = classPath.entries().iterator();
            while (it.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it.next();
                FileObject root = entry.getRoot();
                if (root == null || !cprootsSet.add(root)) continue;
                this.getFileName(root, sourceRoots);
            }
        }
    }

    void getFileName(FileObject fo, StringBuffer buf) {
        try {
            URL url = fo.getURL();
            if (url.getProtocol().equals("jar")) {
                fo = FileUtil.getArchiveFile((FileObject)fo);
            }
            File f = FileUtil.toFile((FileObject)fo);
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(f.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String getClassPathString(ClassPath cp) {
        FileObject[] roots = cp.getRoots();
        if (roots.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(237);
        for (int i = 0; i < roots.length; ++i) {
            this.getFileName(roots[i], buf);
        }
        return buf.toString();
    }

    public Reader getReader(String filename) {
        FileObject fo;
        if ((filename = filename.replace('\\', '/')).startsWith("/")) {
            filename = filename.substring(1);
        }
        Reader reader = null;
        DataObject dobj = (DataObject)this.getModifiedMap().get(filename);
        if (dobj == null) {
            fo = this.provider.getFileObject();
            ClassPath scp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            FileObject[] roots = scp.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                String root = roots[i].getPath();
                if (!filename.startsWith(root)) continue;
                filename = filename.substring(root.length() + 1);
                break;
            }
            fo = scp.findResource(filename);
        } else {
            fo = dobj.getPrimaryFile();
        }
        if (fo != null) {
            try {
                ASTProvider provider = new ASTProvider(null, fo);
                reader = provider.getFileReader(false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return reader;
    }

    public boolean isModified(String filename) {
        if ((filename = filename.replace('\\', '/')).startsWith("/")) {
            filename = filename.substring(1);
        }
        return this.getModifiedMap().containsKey(filename);
    }

    private static ClassPath getCompileClassPathWithCompiledSrc(ClassPath ccp, ClassPath ecp, ClassPath scp) {
        ArrayList<PathResourceImplementation> buildRoots;
        if (!$assertionsDisabled && scp == null) {
            throw new AssertionError((Object)"Source path can not be null");
        }
        if (ecp == null) {
            buildRoots = Collections.EMPTY_LIST;
        } else {
            buildRoots = new ArrayList<PathResourceImplementation>(5);
            Iterator it = ecp.entries().iterator();
            block0: while (it.hasNext()) {
                URL url = ((ClassPath.Entry)it.next()).getURL();
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
                for (int i = 0; i < sourceRoots.length; ++i) {
                    if (!scp.contains(sourceRoots[i])) continue;
                    buildRoots.add(ClassPathSupport.createResource((URL)url));
                    continue block0;
                }
            }
        }
        if (buildRoots.size() == 0) {
            return ccp;
        }
        if (ccp == null) {
            return ClassPathSupport.createClassPath(buildRoots);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ccp, ClassPathSupport.createClassPath(buildRoots)});
    }

    static {
        $assertionsDisabled = !ECRequestDescImpl.class.desiredAssertionStatus();
    }
}

