/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.customizer.CustomizerSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBProperties {
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_JAVA_OPTS = "java_opts";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final String PROP_SERVER_DIR = "server-dir";
    private static final String PROP_ROOT_DIR = "root-dir";
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private final InstanceProperties ip;
    private final JBDeploymentManager manager;

    public JBProperties(JBDeploymentManager manager) {
        this.manager = manager;
        this.ip = manager.getInstanceProperties();
    }

    public boolean isJavaEE5() {
        return new File(this.getServerDir(), "deploy/ejb3.deployer").exists();
    }

    public File getServerDir() {
        return new File(this.ip.getProperty(PROP_SERVER_DIR));
    }

    public File getRootDir() {
        return new File(this.ip.getProperty(PROP_ROOT_DIR));
    }

    public boolean getProxyEnabled() {
        String val = this.ip.getProperty(PROP_PROXY_ENABLED);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setProxyEnabled(boolean enabled) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(enabled));
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String val = this.ip.getProperty(PROP_JAVA_OPTS);
        return val != null ? val : DEF_VALUE_JAVA_OPTS;
    }

    public void setJavaOpts(String javaOpts) {
        this.ip.setProperty(PROP_JAVA_OPTS, javaOpts);
    }

    public List<URL> getClasses() {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            File jsfIMPL;
            File jsfAPI;
            File wsClientLib;
            File rootDir = this.getRootDir();
            File serverDir = this.getServerDir();
            list.add(JBProperties.fileToUrl(new File(rootDir, "client/jboss-j2ee.jar")));
            if (this.isJavaEE5() && (wsClientLib = new File(rootDir, "client/jbossws-client.jar")).exists()) {
                list.add(JBProperties.fileToUrl(wsClientLib));
            }
            this.addFiles(new File(rootDir, "lib"), list);
            this.addFiles(new File(serverDir, "/lib"), list);
            if (this.isJavaEE5()) {
                this.addFiles(new File(serverDir, "/deploy/ejb3.deployer/"), list);
            }
            if ((jsfAPI = new File(serverDir, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-api.jar")).exists()) {
                try {
                    list.add(JBProperties.fileToUrl(jsfAPI));
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            if ((jsfIMPL = new File(serverDir, "/deploy/jbossweb-tomcat55.sar/jsf-libs/myfaces-impl.jar")).exists()) {
                try {
                    list.add(JBProperties.fileToUrl(jsfIMPL));
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return list;
    }

    private void addFiles(File folder, List l) {
        File[] files = folder.listFiles(new FF());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addFiles(files[i], l);
                continue;
            }
            try {
                l.add(JBProperties.fileToUrl(files[i]));
                continue;
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public List<URL> getSources() {
        String path = this.ip.getProperty(PROP_SOURCES);
        if (path == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setSources(List<URL> path) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(path));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    public List<URL> getJavadocs() {
        String path = this.ip.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            try {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
                if (j2eeDoc != null) {
                    list.add(JBProperties.fileToUrl(j2eeDoc));
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return list;
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setJavadocs(List<URL> path) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(path));
        this.manager.getJBPlatform().notifyLibrariesChanged();
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    private static class FF
    implements FilenameFilter {
        private FF() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || new File(dir, name).isDirectory();
        }
    }
}

