/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.openide.ErrorManager;

public final class TaskTags
implements Externalizable {
    static final long serialVersionUID = 1L;
    private TaskTag[] tags = null;
    private Pattern regexp = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setTags(TaskTag[] tags) {
        this.tags = tags;
    }

    public TaskTag[] getTags() {
        return this.tags;
    }

    public TaskTag getTag(CharSequence token, int start, int len) {
        if (this.tags == null) {
            return null;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (!TaskTags.same(this.tags[i].getToken(), token, start, len)) continue;
            return this.tags[i];
        }
        return null;
    }

    private static boolean same(String s1, CharSequence s2, int start, int len) {
        if (s1.length() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    public Pattern getScanRegexp() {
        if (this.regexp == null) {
            StringBuffer sb = new StringBuffer(200);
            TaskTag[] tgs = this.getTags();
            for (int i = 0; i < tgs.length; ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                String s = tgs[i].getToken();
                int n = s.length();
                if (Character.isJavaIdentifierPart(s.charAt(0))) {
                    sb.append("\\W");
                }
                for (int j = 0; j < n; ++j) {
                    char c = s.charAt(j);
                    if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?' || c == '*' || c == '+' || c == '!' || c == '|' || c == '\\' || c == '^' || c == '$') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                if (!Character.isJavaIdentifierPart(s.charAt(n - 1))) continue;
                sb.append("\\b");
            }
            try {
                this.regexp = Pattern.compile(sb.toString());
            }
            catch (PatternSyntaxException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        return this.regexp;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int ver = objectInput.read();
        if (!$assertionsDisabled && ver != 1) {
            throw new AssertionError((Object)"serialization version incorrect; should be 1");
        }
        int num = (Integer)objectInput.readObject();
        this.tags = new TaskTag[num];
        for (int i = 0; i < num; ++i) {
            this.tags[i] = (TaskTag)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(1);
        objectOutput.writeObject(new Integer(this.tags.length));
        for (int i = 0; i < this.tags.length; ++i) {
            objectOutput.writeObject(this.tags[i]);
        }
    }

    static {
        $assertionsDisabled = !TaskTags.class.desiredAssertionStatus();
    }
}

