/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class PauseActionProvider
extends JPDADebuggerActionProvider
implements Runnable {
    private boolean j2meDebugger = false;
    private volatile boolean doingAction;

    public PauseActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        if (properties != null) {
            this.j2meDebugger = properties.containsKey("J2ME_DEBUGGER");
        }
        this.setProviderToDisableOnLazyAction(this);
        RequestProcessor.getDefault().post((Runnable)this, 200);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_PAUSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        this.doingAction = true;
        try {
            this.getDebuggerImpl().suspend();
        }
        finally {
            this.doingAction = false;
        }
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        this.doingAction = true;
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PauseActionProvider.this.getDebuggerImpl().suspend();
                }
                finally {
                    try {
                        actionPerformedNotifier.run();
                    }
                    finally {
                        PauseActionProvider.this.doingAction = false;
                    }
                }
            }
        });
    }

    protected void checkEnabled(int debuggerState) {
        if (this.j2meDebugger) {
            this.setEnabled(ActionsManager.ACTION_PAUSE, debuggerState == 2);
            return;
        }
        VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
        if (vm == null) {
            this.setEnabled(ActionsManager.ACTION_PAUSE, false);
            return;
        }
        try {
            List<ThreadReference> l = vm.allThreads();
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                ThreadReference tr = l.get(i);
                boolean susp = true;
                try {
                    susp = tr.isSuspended();
                }
                catch (ObjectCollectedException e) {
                    // empty catch block
                }
                if (susp) continue;
                this.setEnabled(ActionsManager.ACTION_PAUSE, true);
                return;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.setEnabled(ActionsManager.ACTION_PAUSE, false);
    }

    public void run() {
        if (this.getDebuggerImpl().getState() == 4) {
            return;
        }
        if (!this.doingAction) {
            this.checkEnabled(this.getDebuggerImpl().getState());
        }
        RequestProcessor.getDefault().post((Runnable)this, 200);
    }
}

