/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadGroupImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;

public final class ObjectTranslation {
    private static final int THREAD_ID = 0;
    private static final int LOCALS_ID = 2;
    private JPDADebuggerImpl debugger;
    private int translationID;
    private WeakHashMap cache = new WeakHashMap();

    private ObjectTranslation(JPDADebuggerImpl debugger, int translationID) {
        this.debugger = debugger;
        this.translationID = translationID;
    }

    private Object createTranslation(Object o) {
        switch (this.translationID) {
            case 0: {
                if (o instanceof ThreadReference) {
                    return new JPDAThreadImpl((ThreadReference)o, this.debugger);
                }
                if (o instanceof ThreadGroupReference) {
                    return new JPDAThreadGroupImpl((ThreadGroupReference)o, this.debugger);
                }
                return null;
            }
        }
        throw new IllegalStateException("" + o);
    }

    private Object createTranslation(Object o, Object v) {
        switch (this.translationID) {
            case 2: {
                if (!(o instanceof LocalVariable) || v != null && !(v instanceof Value)) break;
                LocalVariable lv = (LocalVariable)o;
                Local local = v instanceof ObjectReference ? new ObjectLocalVariable(this.debugger, (Value)v, null, lv, JPDADebuggerImpl.getGenericSignature(lv), null) : new Local(this.debugger, (Value)v, null, lv, null);
                return local;
            }
        }
        throw new IllegalStateException("" + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror o) {
        Object r = null;
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            WeakReference wr = (WeakReference)this.cache.get(o);
            if (wr != null) {
                r = wr.get();
            }
            if (r == null) {
                r = this.createTranslation(o);
                this.cache.put(o, new WeakReference<Object>(r));
            }
        }
        return r;
    }

    public Object translate(Mirror o, Object v) {
        Object r = null;
        WeakReference wr = (WeakReference)this.cache.get(o);
        if (wr != null) {
            r = wr.get();
        }
        if (r == null) {
            r = this.createTranslation(o, v);
            this.cache.put(o, new WeakReference<Object>(r));
        }
        return r;
    }

    public static ObjectTranslation createThreadTranslation(JPDADebuggerImpl debugger) {
        return new ObjectTranslation(debugger, 0);
    }

    public static ObjectTranslation createLocalsTranslation(JPDADebuggerImpl debugger) {
        return new ObjectTranslation(debugger, 2);
    }
}

