/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.jaxws;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.SourceRoots;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2SEProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    private J2SEProject project;
    private UpdateHelper updateHelper;
    private static final String WSDL_FOLDER = "wsdl";
    private static final String KEY_PROXY_HOST = "http.proxyHost";
    private static final String KEY_PROXY_PORT = "http.proxyPort";
    private static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    private static final String HTTP_PROXY_HOST_OPTION = "-Dhttp.proxyHost";
    private static final String HTTP_PROXY_PORT_OPTION = "-Dhttp.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS_OPTION = "-Dhttp.nonProxyHosts";
    private static final String HTTPS_PROXY_HOST_OPTION = "-Dhttps.proxyHost";
    private static final String HTTPS_PROXY_PORT_OPTION = "-Dhttps.proxyPort";
    private static final String HTTPS_NON_PROXY_HOSTS_OPTION = "-Dhttps.nonProxyHosts";

    public J2SEProjectJAXWSClientSupport(J2SEProject project, UpdateHelper updateHelper) {
        super((Project)project);
        this.project = project;
        this.updateHelper = updateHelper;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
        String metaInfStr = ep.getProperty("meta.inf.dir");
        String wsdlFolderStr = metaInfStr + "/" + WSDL_FOLDER;
        FileObject wsdlFolder = this.project.getProjectDirectory().getFileObject(wsdlFolderStr);
        if (wsdlFolder == null && create) {
            wsdlFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)wsdlFolderStr);
        }
        return wsdlFolder;
    }

    public String addServiceClient(String clientName, String wsdlUrl, String packageName, boolean isJsr109) {
        String serviceIdeName;
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        if ((serviceIdeName = super.addServiceClient(clientName, wsdlUrl, packageName, false)) != null) {
            this.addJVMProxyOptions(clientName);
        }
        return serviceIdeName;
    }

    protected void addJaxWs20Library() {
        ClassPath classPath = null;
        SourceRoots srcRoots = this.project.getSourceRoots();
        if (srcRoots != null && srcRoots.getRoots().length > 0) {
            FileObject srcRoot = srcRoots.getRoots()[0];
            ClassPath compileClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile");
            ClassPath bootClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compileClassPath, bootClassPath});
        }
        FileObject webServiceClass = null;
        if (classPath != null) {
            webServiceClass = classPath.findResource("javax/jws/WebService.class");
        }
        if (webServiceClass == null) {
            ProjectClassPathExtender pce = (ProjectClassPathExtender)this.project.getLookup().lookup(ProjectClassPathExtender.class);
            Library jaxwslib = LibraryManager.getDefault().getLibrary("jaxws20");
            if (pce != null && jaxwslib != null) {
                try {
                    pce.addLibrary(jaxwslib);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getMessage());
                }
                FileObject wscompileFO = null;
                if (classPath != null) {
                    wscompileFO = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
                }
                if (wscompileFO != null) {
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEProjectJAXWSClientSupport.class, (String)"MSG_RemoveJAX-RPC"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        }
    }

    private void addJVMProxyOptions(final String clientName) {
        final String proxyHost = System.getProperty(KEY_PROXY_HOST);
        if (proxyHost != null && proxyHost.length() > 0) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    boolean modif = false;
                    String proxyPort = System.getProperty(J2SEProjectJAXWSClientSupport.KEY_PROXY_PORT);
                    if (proxyPort == null || proxyPort.length() == 0) {
                        proxyPort = "8080";
                    }
                    String localHosts = "";
                    localHosts = J2SEProjectJAXWSClientSupport.this.getDefaultNonProxyHosts();
                    EditableProperties ep = J2SEProjectJAXWSClientSupport.this.updateHelper.getProperties("nbproject/project.properties");
                    String jvmOptions = ep.getProperty("run.jvmargs");
                    if (jvmOptions == null || jvmOptions.length() == 0) {
                        jvmOptions = "-Dhttp.proxyHost=" + proxyHost + " " + J2SEProjectJAXWSClientSupport.HTTP_PROXY_PORT_OPTION + "=" + proxyPort + " " + J2SEProjectJAXWSClientSupport.HTTP_NON_PROXY_HOSTS_OPTION + "=" + localHosts + " " + J2SEProjectJAXWSClientSupport.HTTPS_PROXY_HOST_OPTION + "=" + proxyHost + " " + J2SEProjectJAXWSClientSupport.HTTPS_PROXY_PORT_OPTION + "=" + proxyPort + " " + J2SEProjectJAXWSClientSupport.HTTPS_NON_PROXY_HOSTS_OPTION + "=" + localHosts;
                        modif = true;
                    } else {
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTP_PROXY_HOST_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttp.proxyHost=" + proxyHost;
                            modif = true;
                        }
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTP_PROXY_PORT_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttp.proxyPort=" + proxyPort;
                            modif = true;
                        }
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTP_NON_PROXY_HOSTS_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttp.nonProxyHosts=" + localHosts;
                            modif = true;
                        }
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTPS_PROXY_HOST_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttps.proxyHost=" + proxyHost;
                            modif = true;
                        }
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTPS_PROXY_PORT_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttps.proxyPort=" + proxyPort;
                            modif = true;
                        }
                        if (jvmOptions.indexOf(J2SEProjectJAXWSClientSupport.HTTPS_NON_PROXY_HOSTS_OPTION) < 0) {
                            jvmOptions = jvmOptions + " -Dhttps.nonProxyHosts=" + localHosts;
                            modif = true;
                        }
                    }
                    if (modif) {
                        ep.setProperty("run.jvmargs", jvmOptions);
                        J2SEProjectJAXWSClientSupport.this.updateHelper.putProperties("nbproject/project.properties", ep);
                        try {
                            ProjectManager.getDefault().saveProject((Project)J2SEProjectJAXWSClientSupport.this.project);
                        }
                        catch (IOException ex) {
                            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$jaxws$J2SEProjectJAXWSClientSupport == null ? (class$org$netbeans$modules$java$j2seproject$jaxws$J2SEProjectJAXWSClientSupport = J2SEProjectJAXWSClientSupport.class$("org.netbeans.modules.java.j2seproject.jaxws.J2SEProjectJAXWSClientSupport")) : class$org$netbeans$modules$java$j2seproject$jaxws$J2SEProjectJAXWSClientSupport), (String)"MSG_ErrorSavingOnWSClientAdd", (Object)clientName, (Object)ex.getLocalizedMessage()), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        }
                    }
                }
            });
        }
    }

    private String getDefaultNonProxyHosts() {
        String nonProxy = "localhost|127.0.0.1";
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
            if (!localhost.equals("localhost")) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            String localhost2 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!localhost2.equals("localhost") && !localhost2.equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return nonProxy;
    }
}

