/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewJ2SEProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final int TYPE_APP = 0;
    static final int TYPE_LIB = 1;
    static final int TYPE_EXT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NewJ2SEProjectWizardIterator() {
        this(0);
    }

    public NewJ2SEProjectWizardIterator(int type) {
        this.type = type;
    }

    public static NewJ2SEProjectWizardIterator library() {
        return new NewJ2SEProjectWizardIterator(1);
    }

    public static NewJ2SEProjectWizardIterator existing() {
        return new NewJ2SEProjectWizardIterator(2);
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray;
        if (this.type == 2) {
            WizardDescriptor.Panel[] panelArray2 = new WizardDescriptor.Panel[2];
            panelArray2[0] = new PanelConfigureProject(this.type);
            panelArray = panelArray2;
            panelArray2[1] = new PanelSourceFolders.Panel();
        } else {
            WizardDescriptor.Panel[] panelArray3 = new WizardDescriptor.Panel[1];
            panelArray = panelArray3;
            panelArray3[0] = new PanelConfigureProject(this.type);
        }
        return panelArray;
    }

    private String[] createSteps() {
        String[] stringArray;
        if (this.type == 2) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject");
            stringArray = stringArray2;
            stringArray2[1] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots");
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_ConfigureProject");
        }
        return stringArray;
    }

    public Set instantiate() throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        String mainClass = (String)this.wiz.getProperty("mainClass");
        if (this.type == 2) {
            File[] sourceFolders = (File[])this.wiz.getProperty("sourceRoot");
            File[] testFolders = (File[])this.wiz.getProperty("testRoot");
            J2SEProjectGenerator.createProject(dirF, name, sourceFolders, testFolders, MANIFEST_FILE);
            for (int i = 0; i < sourceFolders.length; ++i) {
                FileObject srcFo = FileUtil.toFileObject((File)sourceFolders[i]);
                if (srcFo == null) continue;
                resultSet.add(srcFo);
            }
        } else {
            AntProjectHelper h = J2SEProjectGenerator.createProject(dirF, name, mainClass, this.type == 0 ? MANIFEST_FILE : null);
            if (mainClass != null && mainClass.length() > 0) {
                try {
                    FileObject sourcesRoot = h.getProjectDirectory().getFileObject("src");
                    FileObject mainClassFo = this.getMainClassFO(sourcesRoot, mainClass);
                    if (!$assertionsDisabled && mainClassFo == null) {
                        throw new AssertionError((Object)("sourcesRoot: " + sourcesRoot + ", mainClass: " + mainClass));
                    }
                    resultSet.add(mainClassFo);
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }
            if (this.type == 1) {
                // empty if block
            }
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        if (this.type == 0 || this.type == 2) {
            NewJ2SEProjectWizardIterator.createManifest(dir, MANIFEST_FILE);
        }
        Project p = ProjectManager.getDefault().findProject(dir);
        Integer index = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case 0: {
                FoldersListSettings.getDefault().setNewApplicationCount(index);
                break;
            }
            case 1: {
                FoldersListSettings.getDefault().setNewLibraryCount(index);
                break;
            }
            case 2: {
                FoldersListSettings.getDefault().setNewProjectCount(index);
            }
        }
        resultSet.add(dir);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        if (this.type == 2) {
            this.wiz.putProperty("sourceRoot", null);
            this.wiz.putProperty("testRoot", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getMainClassFO(FileObject sourcesRoot, String mainClass) {
        mainClass = mainClass.replace('.', '/');
        return sourcesRoot.getFileObject(mainClass + ".java");
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage((Class)NewJ2SEProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String path) throws IOException {
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static {
        $assertionsDisabled = !NewJ2SEProjectWizardIterator.class.desiredAssertionStatus();
    }
}

