/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualHostPortPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class AddDomainHostPortPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualHostPortPanel component;
    private WizardDescriptor wiz;
    private final Set listeners = new HashSet(1);

    AddDomainHostPortPanel() {
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddInstanceVisualHostPortPanel();
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("AS_RegServ_EnterRemoteInfo");
    }

    public boolean isValid() {
        String h = this.component.getHost();
        if (h.length() < 1) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainHostPortPanel.class, (String)"MSG_EnterHost", (Object)h));
            return false;
        }
        if (h.indexOf("://") > -1) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainHostPortPanel.class, (String)"MSG_exclude_protocol", (Object)h));
            return false;
        }
        int p = this.component.getPort();
        try {
            InetAddress ia = InetAddress.getByName(h);
            new InetSocketAddress(ia, p);
        }
        catch (UnknownHostException uhe) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainHostPortPanel.class, (String)"MSG_UnknownHost2", (Object)h));
            return false;
        }
        catch (IllegalArgumentException iae) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainHostPortPanel.class, (String)"Msg_ValidPortNumber"));
            return false;
        }
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        this.wiz.putProperty("host", (Object)h);
        this.wiz.putProperty("port", (Object)(p + ""));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wiz = (WizardDescriptor)settings;
    }

    public void storeSettings(Object settings) {
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return true;
    }
}

