/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.ddloaders.multiview.NonEditableDocument;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.MdbImplementationForm;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.filesystems.FileObject;

public class MdbImplementationPanel
extends MdbImplementationForm {
    private XmlMultiViewDataObject dataObject;
    private static final String LINK_BEAN = "linkBean";
    private MessageDriven messageDriven;
    private NonEditableDocument beanClassDocument;

    public MdbImplementationPanel(SectionNodeView sectionNodeView, final MessageDriven messageDriven) {
        super(sectionNodeView);
        this.messageDriven = messageDriven;
        this.dataObject = sectionNodeView.getDataObject();
        this.beanClassDocument = new NonEditableDocument(){

            protected String retrieveText() {
                return messageDriven.getEjbClass();
            }
        };
        this.getBeanClassTextField().setDocument(this.beanClassDocument);
        JButton moveClassButton = this.getMoveClassButton();
        moveClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.activateMoveClassUI(messageDriven.getEjbClass());
            }
        });
        JButton renameClassButton = this.getRenameClassButton();
        renameClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Utils.activateRenameClassUI(messageDriven.getEjbClass());
            }
        });
        LinkButton.initLinkButton((AbstractButton)this.getBeanClassLinkButton(), (LinkCookie)this, null, (String)LINK_BEAN);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        this.scheduleRefreshView();
    }

    public void refreshView() {
        this.beanClassDocument.init();
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
        if (ddProperty == LINK_BEAN) {
            FileObject ejbJarFile = this.dataObject.getPrimaryFile();
            ClassPath sourceClassPath = Utils.getSourceClassPath(ejbJarFile);
            JavaClass beanClass = (JavaClass)JMIUtils.resolveType((String)this.messageDriven.getEjbClass());
            Utils.openEditorFor(ejbJarFile, beanClass);
        }
    }
}

