/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Font;
import java.util.Map;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLTokenContext;

public class HTMLSettingsInitializer
extends Settings.AbstractInitializer {
    private final Class htmlKitClass;
    public static final String NAME = "html-settings-initializer";
    public static final Acceptor HTML_IDENTIFIER_ACCEPTOR = new Acceptor(){

        public final boolean accept(char ch) {
            return ch == ':' || AcceptorFactory.JAVA_IDENTIFIER.accept(ch);
        }
    };

    public HTMLSettingsInitializer(Class htmlKitClass) {
        super(NAME);
        this.htmlKitClass = htmlKitClass;
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == BaseKit.class) {
            new HTMLTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        }
        if (kitClass == this.htmlKitClass) {
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{HTMLTokenContext.context});
            settingsMap.put("identifier-acceptor", HTML_IDENTIFIER_ACCEPTOR);
            settingsMap.put("completion-lower-case", HTMLSettingsDefaults.defaultCompletionLowerCase);
        }
    }

    static class HTMLTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        Font boldFont = SettingsDefaults.defaultFont.deriveFont(1);
        Font italicFont = SettingsDefaults.defaultFont.deriveFont(2);
        Settings.Evaluator boldSubst = new SettingsUtil.FontStylePrintColoringEvaluator(1);
        Settings.Evaluator italicSubst = new SettingsUtil.FontStylePrintColoringEvaluator(2);
        Settings.Evaluator lightGraySubst = new SettingsUtil.ForeColorPrintColoringEvaluator(Color.lightGray);

        public HTMLTokenColoringInitializer() {
            super((TokenContext)HTMLTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            if (!printingSet) {
                switch (tokenIDOrCategory.getNumericID()) {
                    case 1: 
                    case 2: {
                        return SettingsDefaults.emptyColoring;
                    }
                    case 3: {
                        return new Coloring(null, Color.white, Color.red);
                    }
                    case 16: {
                        return new Coloring(null, Color.blue, null);
                    }
                    case 6: {
                        return new Coloring(null, Color.green.darker().darker(), null);
                    }
                    case 7: {
                        return new Coloring(null, Color.green.darker().darker(), null);
                    }
                    case 8: {
                        return new Coloring(null, new Color(153, 0, 107), null);
                    }
                    case 9: {
                        return new Coloring(null, Color.gray, null);
                    }
                    case 10: {
                        return new Coloring(null, Color.gray, null);
                    }
                    case 11: {
                        return new Coloring(null, new Color(191, 146, 33), null);
                    }
                    case 12: {
                        return new Coloring(null, Color.red.darker(), null);
                    }
                }
            } else {
                switch (tokenIDOrCategory.getNumericID()) {
                    case 9: 
                    case 10: {
                        return this.lightGraySubst;
                    }
                }
                return SettingsUtil.defaultPrintColoringEvaluator;
            }
            return null;
        }
    }
}

