/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class PropertiesTableModel
extends AbstractTableModel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Bundle");
    private Vector data = null;

    public PropertiesTableModel(ResourceConfigData data) {
        this.data = data.getProperties();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        NameValuePair pair = (NameValuePair)this.data.elementAt(rowIndex);
        if (columnIndex == 0) {
            return pair.getParamName();
        }
        return pair.getParamValue();
    }

    public String getColumnName(int col) {
        if (0 == col) {
            return bundle.getString("COL_HEADER_NAME");
        }
        if (1 == col) {
            return bundle.getString("COL_HEADER_VALUE");
        }
        throw new RuntimeException(bundle.getString("COL_HEADER_ERR_ERR_ERR"));
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        if (row >= 0 && row < this.data.size()) {
            NameValuePair property = (NameValuePair)this.data.elementAt(row);
            if (col == 0) {
                if (!this.isNotUnique((String)value)) {
                    property.setParamName((String)value);
                }
            } else if (col == 1) {
                property.setParamValue((String)value);
            }
        }
        this.fireTableDataChanged();
    }

    private boolean isNotUnique(String newVal) {
        for (int i = 0; i < this.data.size() - 1; ++i) {
            NameValuePair pair = (NameValuePair)this.data.elementAt(i);
            if (!pair.getParamName().equals(newVal)) continue;
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)bundle.getString("Err_DuplicateValue"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return true;
        }
        return false;
    }

    public void setData(ResourceConfigData data) {
        this.data = data.getProperties();
        this.fireTableDataChanged();
    }
}

